--[[
Name: LibBabble-Zone-3.0
Revision: $Rev: 268 $
Maintainers: ckknight, nevcairiel, Ackis
Website: http://www.wowace.com/projects/libbabble-zone-3-0/
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-Zone-3.0"
local MINOR_VERSION = 90000 + tonumber(("$Rev: 268 $"):match("%d+"))

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations {
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: The Old Kingdom",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Alliance Base"] = "Alliance Base",
	["Alterac Mountains"] = "Alterac Mountains",
	["Alterac Valley"] = "Alterac Valley",
	["Amani Pass"] = "Amani Pass",
	["Arathi Basin"] = "Arathi Basin",
	["Arathi Highlands"] = "Arathi Highlands",
	Armory = "Armory",
	Ashenvale = "Ashenvale",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Auchenai Crypts",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Azuremyst Isle",
	Badlands = "Badlands",
	["Bash'ir Landing"] = "Bash'ir Landing",
	["Blackfathom Deeps"] = "Blackfathom Deeps",
	["Blackrock Depths"] = "Blackrock Depths",
	["Blackrock Mountain"] = "Blackrock Mountain",
	["Blackrock Spire"] = "Blackrock Spire",
	["Black Temple"] = "Black Temple",
	["Blackwind Lake"] = "Blackwind Lake",
	["Blackwing Lair"] = "Blackwing Lair",
	["Blade's Edge Arena"] = "Blade's Edge Arena",
	["Blade's Edge Mountains"] = "Blade's Edge Mountains",
	["Blasted Lands"] = "Blasted Lands",
	["Bloodmyst Isle"] = "Bloodmyst Isle",
	["Booty Bay"] = "Booty Bay",
	["Borean Tundra"] = "Borean Tundra",
	["Burning Steppes"] = "Burning Steppes",
	Cathedral = "Cathedral",
	["Caverns of Time"] = "Caverns of Time",
	["Champions' Hall"] = "Champions' Hall",
	["Coilfang Reservoir"] = "Coilfang Reservoir",
	Coldarra = "Coldarra",
	["Cosmic map"] = "Cosmic map",
	["Crystalsong Forest"] = "Crystalsong Forest",
	["Crystal Spine"] = "Crystal Spine",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Dalaran Arena",
	["Dalaran Sewers"] = "Dalaran Sewers",
	["Darkmoon Faire"] = "Darkmoon Faire",
	Darkshore = "Darkshore",
	Darnassus = "Darnassus",
	["Deadwind Pass"] = "Deadwind Pass",
	["Deeprun Tram"] = "Deeprun Tram",
	Desolace = "Desolace",
	["Dire Maul"] = "Dire Maul",
	["Dire Maul (East)"] = "Dire Maul (East)",
	["Dire Maul (North)"] = "Dire Maul (North)",
	["Dire Maul (West)"] = "Dire Maul (West)",
	Dragonblight = "Dragonblight",
	["Drak'Tharon Keep"] = "Drak'Tharon Keep",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Duskwood",
	["Dustwallow Marsh"] = "Dustwallow Marsh",
	["Eastern Kingdoms"] = "Eastern Kingdoms",
	["Eastern Plaguelands"] = "Eastern Plaguelands",
	["Elwynn Forest"] = "Elwynn Forest",
	Everlook = "Everlook",
	["Eversong Woods"] = "Eversong Woods",
	["Eye of the Storm"] = "Eye of the Storm",
	Felwood = "Felwood",
	Feralas = "Feralas",
	["Forge Camp: Terror"] = "Forge Camp: Terror",
	["Forge Camp: Wrath"] = "Forge Camp: Wrath",
	["Frostwyrm Lair"] = "Frostwyrm Lair",
	["Furywing's Perch"] = "Furywing's Perch",
	Gadgetzan = "Gadgetzan",
	["Gates of Ahn'Qiraj"] = "Gates of Ahn'Qiraj",
	Ghostlands = "Ghostlands",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Graveyard",
	["Grizzly Hills"] = "Grizzly Hills",
	["Grom'gol Base Camp"] = "Grom'gol Base Camp",
	["Gruul's Lair"] = "Gruul's Lair",
	Gundrak = "Gundrak",
	["Hall of Champions"] = "Hall of Champions",
	["Hall of Legends"] = "Hall of Legends",
	["Halls of Lightning"] = "Halls of Lightning",
	["Halls of Reflection"] = "Halls of Reflection",
	["Halls of Stone"] = "Halls of Stone",
	["Hellfire Citadel"] = "Hellfire Citadel",
	["Hellfire Peninsula"] = "Hellfire Peninsula",
	["Hellfire Ramparts"] = "Hellfire Ramparts",
	["Hillsbrad Foothills"] = "Hillsbrad Foothills",
	["Horde Encampment"] = "Horde Encampment",
	["Howling Fjord"] = "Howling Fjord",
	["Hrothgar's Landing"] = "Hrothgar's Landing",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Hyjal Summit",
	Icecrown = "Icecrown",
	["Icecrown Citadel"] = "Icecrown Citadel",
	["Insidion's Perch"] = "Insidion's Perch",
	Ironforge = "Ironforge",
	["Isle of Conquest"] = "Isle of Conquest",
	["Isle of Quel'Danas"] = "Isle of Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Krasus' Landing"] = "Krasus' Landing",
	Library = "Library",
	["Loch Modan"] = "Loch Modan",
	["Lower Blackrock Spire"] = "Lower Blackrock Spire",
	["Magisters' Terrace"] = "Magisters' Terrace",
	["Magtheridon's Lair"] = "Magtheridon's Lair",
	["Mana-Tombs"] = "Mana-Tombs",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Marshlight Lake",
	["Menethil Harbor"] = "Menethil Harbor",
	["Molten Core"] = "Molten Core",
	Moonglade = "Moonglade",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Nagrand Arena",
	Naxxramas = "Naxxramas",
	Netherstorm = "Netherstorm",
	["Night Elf Village"] = "Night Elf Village",
	Northrend = "Northrend",
	["Obsidia's Perch"] = "Obsidia's Perch",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Old Hillsbrad Foothills",
	["Old Stratholme"] = "Old Stratholme",
	["Onyxia's Lair"] = "Onyxia's Lair",
	Orgrimmar = "Orgrimmar",
	Outland = "Outland",
	["Pit of Saron"] = "Pit of Saron",
	["Plaguelands: The Scarlet Enclave"] = "Plaguelands: The Scarlet Enclave",
	Plaguewood = "Plaguewood",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Ragefire Chasm",
	Ratchet = "Ratchet",
	["Razorfen Downs"] = "Razorfen Downs",
	["Razorfen Kraul"] = "Razorfen Kraul",
	["Redridge Mountains"] = "Redridge Mountains",
	["Ring of Observance"] = "Ring of Observance",
	["Rivendark's Perch"] = "Rivendark's Perch",
	["Ruins of Ahn'Qiraj"] = "Ruins of Ahn'Qiraj",
	["Ruins of Lordaeron"] = "Ruins of Lordaeron",
	["Scalebeard's Cave"] = "Scalebeard's Cave",
	["Scarlet Monastery"] = "Scarlet Monastery",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "Searing Gorge",
	["Serpent Lake"] = "Serpent Lake",
	["Serpentshrine Cavern"] = "Serpentshrine Cavern",
	["Sethekk Halls"] = "Sethekk Halls",
	["Shadowfang Keep"] = "Shadowfang Keep",
	["Shadow Labyrinth"] = "Shadow Labyrinth",
	["Shadowmoon Valley"] = "Shadowmoon Valley",
	["Shartuul's Transporter"] = "Shartuul's Transporter",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Shattrath City",
	["Sholazar Basin"] = "Sholazar Basin",
	Silithus = "Silithus",
	["Silvermoon City"] = "Silvermoon City",
	["Silverpine Forest"] = "Silverpine Forest",
	["Skyguard Outpost"] = "Skyguard Outpost",
	["Skysong Lake"] = "Skysong Lake",
	["Sporewind Lake"] = "Sporewind Lake",
	Stonard = "Stonard",
	["Stonetalon Mountains"] = "Stonetalon Mountains",
	Stormwind = "Stormwind",
	["Stormwind City"] = "Stormwind City",
	["Strand of the Ancients"] = "Strand of the Ancients",
	["Stranglethorn Vale"] = "Stranglethorn Vale",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "Sunken Temple",
	["Sunwell Plateau"] = "Sunwell Plateau",
	["Swamp of Sorrows"] = "Swamp of Sorrows",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "Tempest Keep",
	["Temple of Ahn'Qiraj"] = "Temple of Ahn'Qiraj",
	["Terokkar Forest"] = "Terokkar Forest",
	["Terokk's Rest"] = "Terokk's Rest",
	["The Arachnid Quarter"] = "The Arachnid Quarter",
	["The Arcatraz"] = "The Arcatraz",
	["The Argent Coliseum"] = "The Argent Coliseum",
	["The Barrens"] = "The Barrens",
	["The Black Morass"] = "The Black Morass",
	["The Blood Furnace"] = "The Blood Furnace",
	["The Bone Wastes"] = "The Bone Wastes",
	["The Botanica"] = "The Botanica",
	["The Construct Quarter"] = "The Construct Quarter",
	["The Culling of Stratholme"] = "The Culling of Stratholme",
	["The Dark Portal"] = "The Dark Portal",
	["The Deadmines"] = "The Deadmines",
	["The Descent into Madness"] = "The Descent into Madness",
	["The Exodar"] = "The Exodar",
	["The Eye"] = "The Eye",
	["The Eye of Eternity"] = "The Eye of Eternity",
	["The Forbidding Sea"] = "The Forbidding Sea",
	["The Forge of Souls"] = "The Forge of Souls",
	["The Frozen Halls"] = "The Frozen Halls",
	["The Frozen Sea"] = "The Frozen Sea",
	["The Great Sea"] = "The Great Sea",
	["The Halls of Winter"] = "The Halls of Winter",
	["The Hinterlands"] = "The Hinterlands",
	["The Mechanar"] = "The Mechanar",
	["The Military Quarter"] = "The Military Quarter",
	["The Nexus"] = "The Nexus",
	["The North Sea"] = "The North Sea",
	["The Obsidian Sanctum"] = "The Obsidian Sanctum",
	["The Oculus"] = "The Oculus",
	["The Plague Quarter"] = "The Plague Quarter",
	["The Prison of Yogg-Saron"] = "The Prison of Yogg-Saron",
	["Theramore Isle"] = "Theramore Isle",
	["The Ring of Valor"] = "The Ring of Valor",
	["The Ruby Sanctum"] = "The Ruby Sanctum",
	["The Scarlet Enclave"] = "The Scarlet Enclave",
	["The Shattered Halls"] = "The Shattered Halls",
	["The Slave Pens"] = "The Slave Pens",
	["The Spark of Imagination"] = "The Spark of Imagination",
	["The Steamvault"] = "The Steamvault",
	["The Stockade"] = "The Stockade",
	["The Storm Peaks"] = "The Storm Peaks",
	["The Temple of Atal'Hakkar"] = "The Temple of Atal'Hakkar",
	["The Underbog"] = "The Underbog",
	["The Veiled Sea"] = "The Veiled Sea",
	["The Violet Hold"] = "The Violet Hold",
	["Thousand Needles"] = "Thousand Needles",
	["Thunder Bluff"] = "Thunder Bluff",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Tirisfal Glades",
	["Trial of the Champion"] = "Trial of the Champion",
	["Trial of the Crusader"] = "Trial of the Crusader",
	["Twisting Nether"] = "Twisting Nether",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Undercity = "Undercity",
	["Un'Goro Crater"] = "Un'Goro Crater",
	["Upper Blackrock Spire"] = "Upper Blackrock Spire",
	["Utgarde Keep"] = "Utgarde Keep",
	["Utgarde Pinnacle"] = "Utgarde Pinnacle",
	["Vault of Archavon"] = "Vault of Archavon",
	["Vortex Pinnacle"] = "Vortex Pinnacle",
	["Wailing Caverns"] = "Wailing Caverns",
	["Warsong Gulch"] = "Warsong Gulch",
	["Western Plaguelands"] = "Western Plaguelands",
	Westfall = "Westfall",
	Wetlands = "Wetlands",
	Wintergrasp = "Wintergrasp",
	Winterspring = "Winterspring",
	["Wyrmrest Temple"] = "Wyrmrest Temple",
	Zangarmarsh = "Zangarmarsh",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}


if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)
elseif GAME_LOCALE == "deDE" then
	lib:SetCurrentTranslations {
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: Das Alte Königreich",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Alliance Base"] = "Basis der Allianz",
	["Alterac Mountains"] = "Alteracgebirge",
	["Alterac Valley"] = "Alteractal",
	["Amani Pass"] = "Amanipass",
	["Arathi Basin"] = "Arathibecken",
	["Arathi Highlands"] = "Arathihochland",
	Armory = "Waffenkammer",
	Ashenvale = "Eschental",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Auchenaikrypta",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Azurmythosinsel",
	Badlands = "Ödland",
	["Bash'ir Landing"] = "Landeplatz von Bash'ir",
	["Blackfathom Deeps"] = "Tiefschwarze Grotte",
	["Blackrock Depths"] = "Schwarzfelstiefen",
	["Blackrock Mountain"] = "Der Schwarzfels",
	["Blackrock Spire"] = "Schwarzfelsspitze",
	["Black Temple"] = "Der Schwarze Tempel",
	["Blackwind Lake"] = "Schattenwindsee",
	["Blackwing Lair"] = "Pechschwingenhort",
	["Blade's Edge Arena"] = "Arena des Schergrats",
	["Blade's Edge Mountains"] = "Schergrat",
	["Blasted Lands"] = "Verwüstete Lande",
	["Bloodmyst Isle"] = "Blutmythosinsel",
	["Booty Bay"] = "Beutebucht",
	["Borean Tundra"] = "Boreanische Tundra",
	["Burning Steppes"] = "Brennende Steppe",
	Cathedral = "Kathedrale",
	["Caverns of Time"] = "Höhlen der Zeit",
	["Champions' Hall"] = "Halle der Champions",
	["Coilfang Reservoir"] = "Der Echsenkessel",
	Coldarra = "Kaltarra",
	["Cosmic map"] = "Kosmische Karte",
	["Crystalsong Forest"] = "Kristallsangwald",
	["Crystal Spine"] = "Kristallrücken",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arena von Dalaran",
	["Dalaran Sewers"] = "Arena von Dalaran",
	["Darkmoon Faire"] = "Dunkelmond-Jahrmarkt",
	Darkshore = "Dunkelküste",
	Darnassus = "Darnassus",
	["Deadwind Pass"] = "Gebirgspass der Totenwinde",
	["Deeprun Tram"] = "Die Tiefenbahn",
	Desolace = "Desolace",
	["Dire Maul"] = "Düsterbruch",
	["Dire Maul (East)"] = "Düsterbruch (Ost)",
	["Dire Maul (North)"] = "Düsterbruch (Nord)",
	["Dire Maul (West)"] = "Düsterbruch (West)",
	Dragonblight = "Drachenöde",
	["Drak'Tharon Keep"] = "Feste Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Dämmerwald",
	["Dustwallow Marsh"] = "Düstermarschen",
	["Eastern Kingdoms"] = "Östliche Königreiche",
	["Eastern Plaguelands"] = "Östliche Pestländer",
	["Elwynn Forest"] = "Wald von Elwynn",
	Everlook = "Ewige Warte",
	["Eversong Woods"] = "Immersangwald",
	["Eye of the Storm"] = "Auge des Sturms",
	Felwood = "Teufelswald",
	Feralas = "Feralas",
	["Forge Camp: Terror"] = "Konstruktionslager: Terror",
	["Forge Camp: Wrath"] = "Konstruktionslager: Wut",
	["Frostwyrm Lair"] = "Frostwyrmbau",
	["Furywing's Perch"] = "Isidions Hort",
	Gadgetzan = "Gadgetzan",
	["Gates of Ahn'Qiraj"] = "Tore von Ahn'Qiraj",
	Ghostlands = "Geisterlande",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Friedhof",
	["Grizzly Hills"] = "Grizzlyhügel",
	["Grom'gol Base Camp"] = "Basislager von Grom'gol",
	["Gruul's Lair"] = "Gruuls Unterschlupf",
	Gundrak = "Gundrak",
	["Hall of Champions"] = "Halle der Champions",
	["Hall of Legends"] = "Halle der Legenden",
	["Halls of Lightning"] = "Die Hallen der Blitze",
	["Halls of Reflection"] = "Hallen der Reflexion",
	["Halls of Stone"] = "Die Hallen des Steins",
	["Hellfire Citadel"] = "Höllenfeuerzitadelle",
	["Hellfire Peninsula"] = "Höllenfeuerhalbinsel",
	["Hellfire Ramparts"] = "Höllenfeuerbollwerk",
	["Hillsbrad Foothills"] = "Vorgebirge des Hügellands",
	["Horde Encampment"] = "Lager der Horde",
	["Howling Fjord"] = "Der heulende Fjord",
	["Hrothgar's Landing"] = "Hrothgars Landestelle",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Hyjalgipfel",
	Icecrown = "Eiskrone",
	["Icecrown Citadel"] = "Eiskronenzitadelle",
	["Insidion's Perch"] = "Isidions Hort",
	Ironforge = "Eisenschmiede",
	["Isle of Conquest"] = "Insel der Eroberung",
	["Isle of Quel'Danas"] = "Insel von Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Krasus' Landing"] = "Krasus' Landeplatz",
	Library = "Bibliothek",
	["Loch Modan"] = "Loch Modan",
	["Lower Blackrock Spire"] = "Untere Schwarzfelsspitze",
	["Magisters' Terrace"] = "Terrasse der Magister",
	["Magtheridon's Lair"] = "Magtheridons Kammer",
	["Mana-Tombs"] = "Managruft",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Sumpflichtsee",
	["Menethil Harbor"] = "Hafen von Menethil",
	["Molten Core"] = "Geschmolzener Kern",
	Moonglade = "Mondlichtung",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arena von Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Nethersturm",
	["Night Elf Village"] = "Nachtelfen Dorf",
	Northrend = "Nordend",
	["Obsidia's Perch"] = "Obsidias Hort",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Vorgebirge des Alten Hügellands",
	["Old Stratholme"] = "Alt-Stratholme",
	["Onyxia's Lair"] = "Onyxias Hort",
	Orgrimmar = "Orgrimmar",
	Outland = "Scherbenwelt",
	["Pit of Saron"] = "Grube von Saron",
	["Plaguelands: The Scarlet Enclave"] = "Pestländer: Die Scharlachrote Enklave",
	Plaguewood = "Seuchenwald",
	["Quel'thalas"] = "Quel'Thalas",
	["Ragefire Chasm"] = "Der Flammenschlund",
	Ratchet = "Ratschet",
	["Razorfen Downs"] = "Hügel der Klingenhauer",
	["Razorfen Kraul"] = "Kral der Klingenhauer",
	["Redridge Mountains"] = "Rotkammgebirge",
	["Ring of Observance"] = "Ring der Beobachtung",
	["Rivendark's Perch"] = "Nachtreißers Hort",
	["Ruins of Ahn'Qiraj"] = "Ruinen von Ahn'Qiraj",
	["Ruins of Lordaeron"] = "Ruinen von Lordaeron",
	["Scalebeard's Cave"] = "Schuppenbarts Höhle",
	["Scarlet Monastery"] = "Das Scharlachrote Kloster",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "Sengende Schlucht",
	["Serpent Lake"] = "Schlangensee",
	["Serpentshrine Cavern"] = "Höhle des Schlangenschreins",
	["Sethekk Halls"] = "Sethekkhallen",
	["Shadowfang Keep"] = "Burg Schattenfang",
	["Shadow Labyrinth"] = "Schattenlabyrinth",
	["Shadowmoon Valley"] = "Schattenmondtal",
	["Shartuul's Transporter"] = "Shartuuls Transporter",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Shattrath",
	["Sholazar Basin"] = "Sholazarbecken",
	Silithus = "Silithus",
	["Silvermoon City"] = "Silbermond",
	["Silverpine Forest"] = "Silberwald",
	["Skyguard Outpost"] = "Außenposten der Himmelswache",
	["Skysong Lake"] = "Himmelsweisensee",
	["Sporewind Lake"] = "Sporenwindsee",
	Stonard = "Steinard",
	["Stonetalon Mountains"] = "Steinkrallengebirge",
	Stormwind = "Sturmwind",
	["Stormwind City"] = "Sturmwind",
	["Strand of the Ancients"] = "Strand der Uralten",
	["Stranglethorn Vale"] = "Schlingendorntal",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "Versunkener Tempel",
	["Sunwell Plateau"] = "Sonnenbrunnenplateau",
	["Swamp of Sorrows"] = "Sümpfe des Elends",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "Festung der Stürme",
	["Temple of Ahn'Qiraj"] = "Tempel von Ahn'Qiraj",
	["Terokkar Forest"] = "Wälder von Terokkar",
	["Terokk's Rest"] = "Terokks Ruh",
	["The Arachnid Quarter"] = "Das Arachnidenviertel",
	["The Arcatraz"] = "Die Arkatraz",
	["The Argent Coliseum"] = "Das Kolosseum der Kreuzfahrer",
	["The Barrens"] = "Brachland",
	["The Black Morass"] = "Der schwarze Morast",
	["The Blood Furnace"] = "Der Blutkessel",
	["The Bone Wastes"] = "Die Knochenwüste",
	["The Botanica"] = "Die Botanika",
	["The Construct Quarter"] = "Das Konstruktviertel",
	["The Culling of Stratholme"] = "Das Ausmerzen von Stratholme",
	["The Dark Portal"] = "Das Dunkle Portal",
	["The Deadmines"] = "Die Todesminen",
	["The Descent into Madness"] = "Der Abstieg in den Wahnsinn",
	["The Exodar"] = "Die Exodar",
	["The Eye"] = "Das Auge",
	["The Eye of Eternity"] = "Das Auge der Ewigkeit",
	["The Forbidding Sea"] = "Das verbotene Meer",
	["The Forge of Souls"] = "Die Schmiede der Seelen",
	["The Frozen Halls"] = "Die gefrorenen Hallen",
	["The Frozen Sea"] = "Die gefrorene See",
	["The Great Sea"] = "Das große Meer",
	["The Halls of Winter"] = "Die Hallen des Winters",
	["The Hinterlands"] = "Hinterland",
	["The Mechanar"] = "Die Mechanar",
	["The Military Quarter"] = "Das Militärviertel",
	["The Nexus"] = "Der Nexus",
	["The North Sea"] = "Das nördliche Meer",
	["The Obsidian Sanctum"] = "Das Obsidiansanktum",
	["The Oculus"] = "Das Oculus",
	["The Plague Quarter"] = "Das Seuchenviertel",
	["The Prison of Yogg-Saron"] = "Das Gefängnis von Yogg-Saron",
	["Theramore Isle"] = "Insel Theramore",
	["The Ring of Valor"] = "Der Ring der Ehre",
	["The Ruby Sanctum"] = "Das Rubinsanktum",
	["The Scarlet Enclave"] = "Die Scharlachrote Enklave",
	["The Shattered Halls"] = "Die zerschmetterten Hallen",
	["The Slave Pens"] = "Die Sklavenunterkünfte",
	["The Spark of Imagination"] = "Der Funke der Imagination",
	["The Steamvault"] = "Die Dampfkammer",
	["The Stockade"] = "Das Verlies",
	["The Storm Peaks"] = "Die Sturmgipfel",
	["The Temple of Atal'Hakkar"] = "Der Tempel von Atal'Hakkar",
	["The Underbog"] = "Der Tiefensumpf",
	["The Veiled Sea"] = "Das verhüllte Meer",
	["The Violet Hold"] = "Die Violette Festung",
	["Thousand Needles"] = "Tausend Nadeln",
	["Thunder Bluff"] = "Donnerfels",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Tirisfal",
	["Trial of the Champion"] = "Prüfung des Champions",
	["Trial of the Crusader"] = "Prüfung des Kreuzfahrers",
	["Twisting Nether"] = "Wirbelnder Nether",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Undercity = "Unterstadt",
	["Un'Goro Crater"] = "Krater von Un'Goro",
	["Upper Blackrock Spire"] = "Obere Schwarzfelsspitze",
	["Utgarde Keep"] = "Burg Utgarde",
	["Utgarde Pinnacle"] = "Turm Utgarde",
	["Vault of Archavon"] = "Archavons Kammer",
	["Vortex Pinnacle"] = "Vortexgipfel",
	["Wailing Caverns"] = "Die Höhlen des Wehklagens",
	["Warsong Gulch"] = "Kriegshymnenschlucht",
	["Western Plaguelands"] = "Westliche Pestländer",
	Westfall = "Westfall",
	Wetlands = "Sumpfland",
	Wintergrasp = "Tausendwintersee",
	Winterspring = "Winterquell",
	["Wyrmrest Temple"] = "Wyrmruhtempel",
	Zangarmarsh = "Zangarmarschen",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "frFR" then
	lib:SetCurrentTranslations {
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet : l'Ancien royaume",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Alliance Base"] = "Base de l'Alliance",
	["Alterac Mountains"] = "Montagnes d'Alterac",
	["Alterac Valley"] = "Vallée d'Alterac",
	["Amani Pass"] = "Passage des Amani",
	["Arathi Basin"] = "Bassin d'Arathi",
	["Arathi Highlands"] = "Hautes-terres d'Arathi",
	Armory = "Armurerie",
	Ashenvale = "Orneval",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Cryptes Auchenaï",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nérub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Île de Brume-azur",
	Badlands = "Terres ingrates",
	["Bash'ir Landing"] = "Point d'ancrage de Bash'ir",
	["Blackfathom Deeps"] = "Profondeurs de Brassenoire",
	["Blackrock Depths"] = "Profondeurs de Rochenoire",
	["Blackrock Mountain"] = "Mont Rochenoire",
	["Blackrock Spire"] = "Pic Rochenoire",
	["Black Temple"] = "Temple noir",
	["Blackwind Lake"] = "Lac Noirvent",
	["Blackwing Lair"] = "Repaire de l'Aile noire",
	["Blade's Edge Arena"] = "Arène des Tranchantes",
	["Blade's Edge Mountains"] = "Les Tranchantes",
	["Blasted Lands"] = "Terres foudroyées",
	["Bloodmyst Isle"] = "Île de Brume-sang",
	["Booty Bay"] = "Baie-du-Butin",
	["Borean Tundra"] = "Toundra Boréenne",
	["Burning Steppes"] = "Steppes ardentes",
	Cathedral = "Cathédrale",
	["Caverns of Time"] = "Grottes du temps",
	["Champions' Hall"] = "Hall des Champions",
	["Coilfang Reservoir"] = "Réservoir de Glissecroc",
	Coldarra = "Frimarra",
	["Cosmic map"] = "Carte cosmique",
	["Crystalsong Forest"] = "Forêt du Chant de cristal",
	["Crystal Spine"] = "Éperon de cristal",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arène de Dalaran",
	["Dalaran Sewers"] = "Égouts de Dalaran",
	["Darkmoon Faire"] = "Foire de Sombrelune",
	Darkshore = "Sombrivage",
	Darnassus = "Darnassus",
	["Deadwind Pass"] = "Défilé de Deuillevent",
	["Deeprun Tram"] = "Tram des profondeurs",
	Desolace = "Désolace",
	["Dire Maul"] = "Hache-tripes",
	["Dire Maul (East)"] = "Hache-tripes (Est)",
	["Dire Maul (North)"] = "Hache-tripes (Nord)",
	["Dire Maul (West)"] = "Hache-tripes (Ouest)",
	Dragonblight = "Désolation des dragons",
	["Drak'Tharon Keep"] = "Donjon de Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Bois de la Pénombre",
	["Dustwallow Marsh"] = "Marécage d'Âprefange",
	["Eastern Kingdoms"] = "Royaumes de l'est",
	["Eastern Plaguelands"] = "Maleterres de l'est",
	["Elwynn Forest"] = "Forêt d'Elwynn",
	Everlook = "Long-guet",
	["Eversong Woods"] = "Bois des Chants éternels",
	["Eye of the Storm"] = "L'Œil du cyclone",
	Felwood = "Gangrebois",
	Feralas = "Féralas",
	["Forge Camp: Terror"] = "Camp de forge : Terreur",
	["Forge Camp: Wrath"] = "Camp de forge : Courroux",
	["Frostwyrm Lair"] = "Repaire du wyrm de givre",
	["Furywing's Perch"] = "Perchoir d'Aile-furie",
	Gadgetzan = "Gadgetzan",
	["Gates of Ahn'Qiraj"] = "Portes d'Ahn'Qiraj",
	Ghostlands = "Les Terres fantômes",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Cimetière",
	["Grizzly Hills"] = "Les Grisonnes",
	["Grom'gol Base Camp"] = "Campement Grom'gol",
	["Gruul's Lair"] = "Repaire de Gruul",
	Gundrak = "Gundrak",
	["Hall of Champions"] = "Hall des Champions",
	["Hall of Legends"] = "Hall des Légendes",
	["Halls of Lightning"] = "Les salles de Foudre",
	["Halls of Reflection"] = "Les salles des Reflets",
	["Halls of Stone"] = "Les salles de Pierre",
	["Hellfire Citadel"] = "Citadelle des Flammes infernales",
	["Hellfire Peninsula"] = "Péninsule des Flammes infernales",
	["Hellfire Ramparts"] = "Remparts des Flammes infernales",
	["Hillsbrad Foothills"] = "Contreforts de Hautebrande",
	["Horde Encampment"] = "Campement de la Horde",
	["Howling Fjord"] = "Fjord Hurlant",
	["Hrothgar's Landing"] = "Accostage de Hrothgar",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Sommet d'Hyjal",
	Icecrown = "La Couronne de glace",
	["Icecrown Citadel"] = "Citadelle de la Couronne de glace",
	["Insidion's Perch"] = "Perchoir d'Insidion",
	Ironforge = "Forgefer",
	["Isle of Conquest"] = "Île des Conquérants",
	["Isle of Quel'Danas"] = "Île de Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Krasus' Landing"] = "Aire de Krasus",
	Library = "Bibliothèque",
	["Loch Modan"] = "Loch Modan",
	["Lower Blackrock Spire"] = "Pic de Rochenoire inférieur",
	["Magisters' Terrace"] = "Terrasse des Magistères",
	["Magtheridon's Lair"] = "Le repaire de Magtheridon",
	["Mana-Tombs"] = "Tombes-mana",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Lac des furoles",
	["Menethil Harbor"] = "Port de Menethil",
	["Molten Core"] = "Cœur du Magma",
	Moonglade = "Reflet-de-Lune",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arène de Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Raz-de-Néant",
	["Night Elf Village"] = "Village elfe de la nuit",
	Northrend = "Norfendre",
	["Obsidia's Perch"] = "Perchoir d'Obsidia",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Contreforts de Hautebrande d'antan",
	["Old Stratholme"] = "L'Épuration de Stratholme",
	["Onyxia's Lair"] = "Repaire d'Onyxia",
	Orgrimmar = "Orgrimmar",
	Outland = "Outreterre",
	["Pit of Saron"] = "Fosse de Saron",
	["Plaguelands: The Scarlet Enclave"] = "Maleterres : l'enclave Écarlate",
	Plaguewood = "Pestebois",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Gouffre de Ragefeu",
	Ratchet = "Cabestan",
	["Razorfen Downs"] = "Souilles de Tranchebauge",
	["Razorfen Kraul"] = "Kraal de Tranchebauge",
	["Redridge Mountains"] = "Les Carmines",
	["Ring of Observance"] = "Cercle d'observance",
	["Rivendark's Perch"] = "Perchoir de Clivenuit",
	["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj",
	["Ruins of Lordaeron"] = "Ruines de Lordaeron",
	["Scalebeard's Cave"] = "Caverne de Barbe-d'écailles",
	["Scarlet Monastery"] = "Monastère écarlate",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "Gorge des Vents brûlants",
	["Serpent Lake"] = "Lac des Serpents",
	["Serpentshrine Cavern"] = "Caverne du sanctuaire du Serpent",
	["Sethekk Halls"] = "Les salles des Sethekk",
	["Shadowfang Keep"] = "Donjon d'Ombrecroc",
	["Shadow Labyrinth"] = "Labyrinthe des ombres",
	["Shadowmoon Valley"] = "Vallée d'Ombrelune",
	["Shartuul's Transporter"] = "Transporteur de Shartuul",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Shattrath",
	["Sholazar Basin"] = "Bassin de Sholazar",
	Silithus = "Silithus",
	["Silvermoon City"] = "Lune-d'argent",
	["Silverpine Forest"] = "Forêt des Pins argentés",
	["Skyguard Outpost"] = "Avant-poste de la Garde-ciel",
	["Skysong Lake"] = "Lac Chanteciel",
	["Sporewind Lake"] = "Lac Ventespore",
	Stonard = "Pierrêche",
	["Stonetalon Mountains"] = "Les Serres-Rocheuses",
	Stormwind = "Hurlevent",
	["Stormwind City"] = "Hurlevent",
	["Strand of the Ancients"] = "Rivage des anciens",
	["Stranglethorn Vale"] = "Vallée de Strangleronce",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "Temple englouti",
	["Sunwell Plateau"] = "Plateau du Puits de soleil",
	["Swamp of Sorrows"] = "Marais des Chagrins",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "Donjon de la Tempête",
	["Temple of Ahn'Qiraj"] = "Le temple d'Ahn'Qiraj",
	["Terokkar Forest"] = "Forêt de Terokkar",
	["Terokk's Rest"] = "Repos de Terokk",
	["The Arachnid Quarter"] = "Le quartier des Arachnides",
	["The Arcatraz"] = "L'Arcatraz",
	["The Argent Coliseum"] = "Le colisée d'Argent",
	["The Barrens"] = "Les Tarides",
	["The Black Morass"] = "Le Noir Marécage",
	["The Blood Furnace"] = "La Fournaise du sang",
	["The Bone Wastes"] = "Le désert des Ossements",
	["The Botanica"] = "La Botanica",
	["The Construct Quarter"] = "Le quartier des Assemblages",
	["The Culling of Stratholme"] = "L'Épuration de Stratholme",
	["The Dark Portal"] = "La Porte des ténèbres",
	["The Deadmines"] = "Les Mortemines",
	["The Descent into Madness"] = "La Descente dans la folie",
	["The Exodar"] = "L'Exodar",
	["The Eye"] = "L'Œil",
	["The Eye of Eternity"] = "L'Œil de l'éternité",
	["The Forbidding Sea"] = "La Mer interdite",
	["The Forge of Souls"] = "La Forge des âmes",
	["The Frozen Halls"] = "Les salles Gelées",
	["The Frozen Sea"] = "La mer Gelée",
	["The Great Sea"] = "La Grande mer",
	["The Halls of Winter"] = "Les salles de l'Hiver",
	["The Hinterlands"] = "Les Hinterlands",
	["The Mechanar"] = "Le Méchanar",
	["The Military Quarter"] = "Le quartier Militaire",
	["The Nexus"] = "Le Nexus",
	["The North Sea"] = "La mer Boréale",
	["The Obsidian Sanctum"] = "Le sanctum Obsidien",
	["The Oculus"] = "L'Oculus",
	["The Plague Quarter"] = "Le quartier de la Peste",
	["The Prison of Yogg-Saron"] = "La prison de Yogg-Saron",
	["Theramore Isle"] = "Île de Theramore",
	["The Ring of Valor"] = "L'Arène des valeureux",
	["The Ruby Sanctum"] = "Le sanctum Rubis",
	["The Scarlet Enclave"] = "L'enclave Écarlate",
	["The Shattered Halls"] = "Les Salles brisées",
	["The Slave Pens"] = "Les enclos aux esclaves",
	["The Spark of Imagination"] = "L'Étincelle d'imagination",
	["The Steamvault"] = "Le Caveau de la vapeur",
	["The Stockade"] = "La Prison",
	["The Storm Peaks"] = "Les pics Foudroyés",
	["The Temple of Atal'Hakkar"] = "Le temple d'Atal'Hakkar",
	["The Underbog"] = "La Basse-tourbière",
	["The Veiled Sea"] = "La Mer voilée",
	["The Violet Hold"] = "Le fort Pourpre",
	["Thousand Needles"] = "Mille pointes",
	["Thunder Bluff"] = "Les Pitons du Tonnerre",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Clairières de Tirisfal",
	["Trial of the Champion"] = "L'épreuve du champion",
	["Trial of the Crusader"] = "L'épreuve du croisé",
	["Twisting Nether"] = "Le Néant distordu",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Undercity = "Fossoyeuse",
	["Un'Goro Crater"] = "Cratère d'Un'Goro",
	["Upper Blackrock Spire"] = "Pic de Rochenoire supérieur",
	["Utgarde Keep"] = "Donjon d'Utgarde",
	["Utgarde Pinnacle"] = "Cime d'Utgarde",
	["Vault of Archavon"] = "Caveau d'Archavon",
	["Vortex Pinnacle"] = "Cime du vortex",
	["Wailing Caverns"] = "Cavernes des lamentations",
	["Warsong Gulch"] = "Goulet des Chanteguerres",
	["Western Plaguelands"] = "Maleterres de l'ouest",
	Westfall = "Marche de l'Ouest",
	Wetlands = "Les Paluns",
	Wintergrasp = "Joug-d'hiver",
	Winterspring = "Berceau-de-l'Hiver",
	["Wyrmrest Temple"] = "Temple du Repos du ver",
	Zangarmarsh = "Marécage de Zangar",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "koKR" then
	lib:SetCurrentTranslations {
	["Ahn'kahet: The Old Kingdom"] = "안카헤트: 고대 왕국",
	["Ahn'Qiraj"] = "안퀴라즈",
	["Alliance Base"] = "얼라이언스 주둔지",
	["Alterac Mountains"] = "알터랙 산맥",
	["Alterac Valley"] = "알터랙 계곡",
	["Amani Pass"] = "아마니 고개",
	["Arathi Basin"] = "아라시 분지",
	["Arathi Highlands"] = "아라시 고원",
	Armory = "무기고",
	Ashenvale = "잿빛 골짜기",
	Auberdine = "아우버다인",
	["Auchenai Crypts"] = "아키나이 납골당",
	Auchindoun = "아킨둔",
	Azeroth = "아제로스",
	["Azjol-Nerub"] = "아졸네룹",
	Azshara = "아즈샤라",
	["Azuremyst Isle"] = "하늘안개 섬",
	Badlands = "황야의 땅",
	["Bash'ir Landing"] = "바쉬르 영지",
	["Blackfathom Deeps"] = "검은심연의 나락",
	["Blackrock Depths"] = "검은바위 나락",
	["Blackrock Mountain"] = "검은바위 산",
	["Blackrock Spire"] = "검은바위 첨탑",
	["Black Temple"] = "검은 사원",
	["Blackwind Lake"] = "검은바람 호수",
	["Blackwing Lair"] = "검은날개 둥지",
	["Blade's Edge Arena"] = "칼날 투기장",
	["Blade's Edge Mountains"] = "칼날 산맥",
	["Blasted Lands"] = "저주받은 땅",
	["Bloodmyst Isle"] = "핏빛안개 섬",
	["Booty Bay"] = "무법항",
	["Borean Tundra"] = "북풍의 땅",
	["Burning Steppes"] = "불타는 평원",
	Cathedral = "대성당",
	["Caverns of Time"] = "시간의 동굴",
	["Champions' Hall"] = "용사의 전당",
	["Coilfang Reservoir"] = "갈퀴송곳니 저수지",
	Coldarra = "콜다라",
	["Cosmic map"] = "세계 지도",
	["Crystalsong Forest"] = "수정노래 숲",
	["Crystal Spine"] = "수정 돌기",
	Dalaran = "달라란",
	["Dalaran Arena"] = "달라란 투기장",
	["Dalaran Sewers"] = "달라란 하수도",
	["Darkmoon Faire"] = "다크문 축제",
	Darkshore = "어둠의 해안",
	Darnassus = "다르나서스",
	["Deadwind Pass"] = "죽음의 고개",
	["Deeprun Tram"] = "깊은굴 지하철",
	Desolace = "잊혀진 땅",
	["Dire Maul"] = "혈투의 전장",
	["Dire Maul (East)"] = "혈투의 전장 동부",
	["Dire Maul (North)"] = "혈투의 전장 북부",
	["Dire Maul (West)"] = "혈투의 전장 서부",
	Dragonblight = "용의 안식처",
	["Drak'Tharon Keep"] = "드락타론 성채",
	["Dun Morogh"] = "던 모로",
	Durotar = "듀로타",
	Duskwood = "그늘숲",
	["Dustwallow Marsh"] = "먼지진흙 습지대",
	["Eastern Kingdoms"] = "동부 왕국",
	["Eastern Plaguelands"] = "동부 역병지대",
	["Elwynn Forest"] = "엘윈 숲",
	Everlook = "눈망루 마을",
	["Eversong Woods"] = "영원노래 숲",
	["Eye of the Storm"] = "폭풍의 눈",
	Felwood = "악령의 숲",
	Feralas = "페랄라스",
	["Forge Camp: Terror"] = "공포의 괴철로 기지",
	["Forge Camp: Wrath"] = "격노의 괴철로 기지",
	["Frostwyrm Lair"] = "서리고룡의 방",
	["Furywing's Perch"] = "퓨리윙의 둥지",
	Gadgetzan = "가젯잔",
	["Gates of Ahn'Qiraj"] = "안퀴라즈 성문",
	Ghostlands = "유령의 땅",
	Gnomeregan = "놈리건",
	Graveyard = "묘지",
	["Grizzly Hills"] = "회색 구릉지",
	["Grom'gol Base Camp"] = "그롬골 주둔지",
	["Gruul's Lair"] = "그룰의 둥지",
	Gundrak = "군드락",
	["Hall of Champions"] = "용사의 전당",
	["Hall of Legends"] = "전설의 전당",
	["Halls of Lightning"] = "번개의 전당",
	["Halls of Reflection"] = "투영의 전당",
	["Halls of Stone"] = "돌의 전당",
	["Hellfire Citadel"] = "지옥불 성채",
	["Hellfire Peninsula"] = "지옥불 반도",
	["Hellfire Ramparts"] = "지옥불 성루",
	["Hillsbrad Foothills"] = "힐스브래드 구릉지",
	["Horde Encampment"] = "호드 야영지",
	["Howling Fjord"] = "울부짖는 협만",
	["Hrothgar's Landing"] = "흐로스가르 상륙지",
	Hyjal = "하이잘",
	["Hyjal Summit"] = "하이잘 정상",
	Icecrown = "얼음왕관",
	["Icecrown Citadel"] = "얼음왕관 성채",
	["Insidion's Perch"] = "인시디온의 둥지",
	Ironforge = "아이언포지",
	["Isle of Conquest"] = "정복의 섬",
	["Isle of Quel'Danas"] = "쿠엘다나스 섬",
	Kalimdor = "칼림도어",
	Karazhan = "카라잔",
	["Krasus' Landing"] = "크라서스 착륙장",
	Library = "도서관",
	["Loch Modan"] = "모단 호수",
	["Lower Blackrock Spire"] = "검은바위 첨탑 하층",
	["Magisters' Terrace"] = "마법학자의 정원",
	["Magtheridon's Lair"] = "마그테리돈의 둥지",
	["Mana-Tombs"] = "마나 무덤",
	Maraudon = "마라우돈",
	["Marshlight Lake"] = "수렁등불 호수",
	["Menethil Harbor"] = "메네실 항구",
	["Molten Core"] = "화산 심장부",
	Moonglade = "달의 숲",
	Mulgore = "멀고어",
	Nagrand = "나그란드",
	["Nagrand Arena"] = "나그란드 투기장",
	Naxxramas = "낙스라마스",
	Netherstorm = "황천의 폭풍",
	["Night Elf Village"] = "나이트 엘프 마을",
	Northrend = "노스렌드",
	["Obsidia's Perch"] = "옵시디아의 둥지",
	["Ogri'la"] = "오그릴라",
	["Old Hillsbrad Foothills"] = "옛 힐스브래드 구릉지",
	["Old Stratholme"] = "옛 스트라솔름",
	["Onyxia's Lair"] = "오닉시아의 둥지",
	Orgrimmar = "오그리마",
	Outland = "아웃랜드",
	["Pit of Saron"] = "사론의 구덩이",
	["Plaguelands: The Scarlet Enclave"] = "동부 역병지대: 붉은십자군 초소",
	Plaguewood = "역병의 숲",
	["Quel'thalas"] = "쿠엘탈라스",
	["Ragefire Chasm"] = "성난불길 협곡",
	Ratchet = "톱니항",
	["Razorfen Downs"] = "가시덩굴 구릉",
	["Razorfen Kraul"] = "가시덩굴 우리",
	["Redridge Mountains"] = "붉은마루 산맥",
	["Ring of Observance"] = "규율의 광장",
	["Rivendark's Perch"] = "리븐다크의 둥지",
	["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허",
	["Ruins of Lordaeron"] = "로데론의 폐허",
	["Scalebeard's Cave"] = "비늘수염 동굴",
	["Scarlet Monastery"] = "붉은십자군 수도원",
	Scholomance = "스칼로맨스",
	["Searing Gorge"] = "이글거리는 협곡",
	["Serpent Lake"] = "물갈퀴 호수",
	["Serpentshrine Cavern"] = "불뱀 제단",
	["Sethekk Halls"] = "세데크 전당",
	["Shadowfang Keep"] = "그림자송곳니 성채",
	["Shadow Labyrinth"] = "어둠의 미궁",
	["Shadowmoon Valley"] = "어둠달 골짜기",
	["Shartuul's Transporter"] = "샤툴의 순간이동기",
	Shattrath = "샤트라스",
	["Shattrath City"] = "샤트라스",
	["Sholazar Basin"] = "숄라자르 분지",
	Silithus = "실리더스",
	["Silvermoon City"] = "실버문",
	["Silverpine Forest"] = "은빛소나무 숲",
	["Skyguard Outpost"] = "하늘경비대 전초기지",
	["Skysong Lake"] = "하늘노래 호수",
	["Sporewind Lake"] = "포자바람 호수",
	Stonard = "스토나드",
	["Stonetalon Mountains"] = "돌발톱 산맥",
	Stormwind = "스톰윈드",
	["Stormwind City"] = "스톰윈드",
	["Strand of the Ancients"] = "고대의 해안",
	["Stranglethorn Vale"] = "가시덤불 골짜기",
	Stratholme = "스트라솔름",
	["Sunken Temple"] = "가라앉은 사원",
	["Sunwell Plateau"] = "태양샘 고원",
	["Swamp of Sorrows"] = "슬픔의 늪",
	Tanaris = "타나리스",
	Teldrassil = "텔드랏실",
	["Tempest Keep"] = "폭풍우 요새",
	["Temple of Ahn'Qiraj"] = "안퀴라즈 사원",
	["Terokkar Forest"] = "테로카르 숲",
	["Terokk's Rest"] = "테로크의 안식처",
	["The Arachnid Quarter"] = "거미 지구",
	["The Arcatraz"] = "알카트라즈",
	["The Argent Coliseum"] = "십자군 원형경기장",
	["The Barrens"] = "불모의 땅",
	["The Black Morass"] = "검은늪",
	["The Blood Furnace"] = "피의 용광로",
	["The Bone Wastes"] = "해골 무덤",
	["The Botanica"] = "신록의 정원",
	["The Construct Quarter"] = "피조물 지구",
	["The Culling of Stratholme"] = "옛 스트라솔름",
	["The Dark Portal"] = "어둠의 문",
	["The Deadmines"] = "죽음의 폐광",
	["The Descent into Madness"] = "광기의 내리막길",
	["The Exodar"] = "엑소다르",
	["The Eye"] = "눈",
	["The Eye of Eternity"] = "영원의 눈",
	["The Forbidding Sea"] = "성난폭풍 해안",
	["The Forge of Souls"] = "영혼의 제련소",
	["The Frozen Halls"] = "얼어붙은 전당",
	["The Frozen Sea"] = "얼어붙은 바다",
	["The Great Sea"] = "대해",
	["The Halls of Winter"] = "겨울의 전당",
	["The Hinterlands"] = "동부 내륙지",
	["The Mechanar"] = "메카나르",
	["The Military Quarter"] = "군사 지구",
	["The Nexus"] = "마력의 탑",
	["The North Sea"] = "북해",
	["The Obsidian Sanctum"] = "흑요석 성소",
	["The Oculus"] = "마력의 눈",
	["The Plague Quarter"] = "역병 지구",
	["The Prison of Yogg-Saron"] = "요그사론의 감옥",
	["Theramore Isle"] = "테라모어 섬",
	["The Ring of Valor"] = "용맹의 투기장",
	["The Ruby Sanctum"] = "루비 성소", -- Needs review
	["The Scarlet Enclave"] = "진홍빛 전당",
	["The Shattered Halls"] = "으스러진 손의 전당",
	["The Slave Pens"] = "강제 노역소",
	["The Spark of Imagination"] = "상상의 흔적",
	["The Steamvault"] = "증기 저장고",
	["The Stockade"] = "스톰윈드 지하감옥",
	["The Storm Peaks"] = "폭풍우 봉우리",
	["The Temple of Atal'Hakkar"] = "아탈학카르 신전",
	["The Underbog"] = "지하수렁",
	["The Veiled Sea"] = "장막의 바다",
	["The Violet Hold"] = "보랏빛 요새",
	["Thousand Needles"] = "버섯구름 봉우리",
	["Thunder Bluff"] = "썬더 블러프",
	Tirisfal = "티리스팔",
	["Tirisfal Glades"] = "티리스팔 숲",
	["Trial of the Champion"] = "용사의 시험장",
	["Trial of the Crusader"] = "십자군의 시험장",
	["Twisting Nether"] = "뒤틀린 황천",
	Uldaman = "울다만",
	Ulduar = "울두아르",
	Undercity = "언더시티",
	["Un'Goro Crater"] = "운고로 분화구",
	["Upper Blackrock Spire"] = "검은바위 첨탑 상층",
	["Utgarde Keep"] = "우트가드 성채",
	["Utgarde Pinnacle"] = "우트가드 첨탑",
	["Vault of Archavon"] = "아카본 석실",
	["Vortex Pinnacle"] = "소용돌이 고원",
	["Wailing Caverns"] = "통곡의 동굴",
	["Warsong Gulch"] = "전쟁노래 협곡",
	["Western Plaguelands"] = "서부 역병지대",
	Westfall = "서부 몰락지대",
	Wetlands = "저습지",
	Wintergrasp = "겨울손아귀 호수",
	Winterspring = "여명의 설원",
	["Wyrmrest Temple"] = "고룡쉼터 사원",
	Zangarmarsh = "장가르 습지대",
	["Zul'Aman"] = "줄아만",
	["Zul'Drak"] = "줄드락",
	["Zul'Farrak"] = "줄파락",
	["Zul'Gurub"] = "줄구룹",
}
elseif GAME_LOCALE == "esES" then
	lib:SetCurrentTranslations {
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: El Antiguo Reino",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Alliance Base"] = "Base de la Alianza",
	["Alterac Mountains"] = "Montañas de Alterac",
	["Alterac Valley"] = "Valle de Alterac",
	["Amani Pass"] = "Paso de Amani",
	["Arathi Basin"] = "Cuenca de Arathi",
	["Arathi Highlands"] = "Tierras Altas de Arathi",
	Armory = "Armería",
	Ashenvale = "Vallefresno",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Criptas Auchenai",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Isla Bruma Azur",
	Badlands = "Tierras Inhóspitas",
	["Bash'ir Landing"] = "Zona de aterrizaje Bash'ir",
	["Blackfathom Deeps"] = "Cavernas de Brazanegra",
	["Blackrock Depths"] = "Profundidades de Roca Negra",
	["Blackrock Mountain"] = "Montaña Roca Negra",
	["Blackrock Spire"] = "Cumbre de Roca Negra",
	["Black Temple"] = "El Templo Oscuro",
	["Blackwind Lake"] = "Lago Vientonegro",
	["Blackwing Lair"] = "Guarida Alanegra",
	["Blade's Edge Arena"] = "Arena Filospada",
	["Blade's Edge Mountains"] = "Montañas Filospada",
	["Blasted Lands"] = "Las Tierras Devastadas",
	["Bloodmyst Isle"] = "Isla Bruma de Sangre",
	["Booty Bay"] = "Bahía del Botín",
	["Borean Tundra"] = "Tundra Boreal",
	["Burning Steppes"] = "Las Estepas Ardientes",
	Cathedral = "Catedral",
	["Caverns of Time"] = "Cavernas del Tiempo",
	["Champions' Hall"] = "Sala de los Campeones",
	["Coilfang Reservoir"] = "Reserva Colmillo Torcido",
	Coldarra = "Gelidar",
	["Cosmic map"] = "Mapa cósmico",
	["Crystalsong Forest"] = "Bosque Canto de Cristal",
	["Crystal Spine"] = "Espina de Cristal",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arena de Dalaran",
	["Dalaran Sewers"] = "Cloacas de Dalaran",
	["Darkmoon Faire"] = "Feria de la Luna Negra",
	Darkshore = "Costa Oscura",
	Darnassus = "Darnassus",
	["Deadwind Pass"] = "Paso de la Muerte",
	["Deeprun Tram"] = "Tranvía Subterráneo",
	Desolace = "Desolace",
	["Dire Maul"] = "La Masacre",
	["Dire Maul (East)"] = "La Masacre (Este)",
	["Dire Maul (North)"] = "La Masacre (Norte)",
	["Dire Maul (West)"] = "La Masacre (Oeste)",
	Dragonblight = "Cementerio de Dragones",
	["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Bosque del Ocaso",
	["Dustwallow Marsh"] = "Marjal Revolcafango",
	["Eastern Kingdoms"] = "Reinos del Este",
	["Eastern Plaguelands"] = "Tierras de la Peste del Este",
	["Elwynn Forest"] = "Bosque de Elwynn",
	Everlook = "Vista Eterna",
	["Eversong Woods"] = "Bosque Canción Eterna",
	["Eye of the Storm"] = "Ojo de la Tormenta",
	Felwood = "Frondavil",
	Feralas = "Feralas",
	["Forge Camp: Terror"] = "Campamento forja: Terror",
	["Forge Camp: Wrath"] = "Campamento forja: Cólera",
	["Frostwyrm Lair"] = "Guarida de Vermis de Escarcha",
	["Furywing's Perch"] = "Nido de Alafuria",
	Gadgetzan = "Gadgetzan",
	["Gates of Ahn'Qiraj"] = "Puertas de Ahn'Qiraj",
	Ghostlands = "Tierras Fantasma",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Cementerio",
	["Grizzly Hills"] = "Colinas Pardas",
	["Grom'gol Base Camp"] = "Campamento Grom'gol",
	["Gruul's Lair"] = "Guarida de Gruul",
	Gundrak = "Gundrak",
	["Hall of Champions"] = "Sala de los Campeones",
	["Hall of Legends"] = "Sala de las Leyendas",
	["Halls of Lightning"] = "Cámaras de Relámpagos",
	["Halls of Reflection"] = "Cámaras de Reflexión",
	["Halls of Stone"] = "Cámaras de Piedra",
	["Hellfire Citadel"] = "Ciudadela del Fuego Infernal",
	["Hellfire Peninsula"] = "Península del Fuego Infernal",
	["Hellfire Ramparts"] = "Murallas del Fuego Infernal",
	["Hillsbrad Foothills"] = "Laderas de Trabalomas",
	["Horde Encampment"] = "Campamento Horda",
	["Howling Fjord"] = "Fiordo Aquilonal",
	["Hrothgar's Landing"] = "Desembarco de Hrothgar",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Cima Hyjal",
	Icecrown = "Corona de Hielo",
	["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo",
	["Insidion's Perch"] = "Nido de Insidion",
	Ironforge = "Forjaz",
	["Isle of Conquest"] = "Isla de la Conquista",
	["Isle of Quel'Danas"] = "Isla de Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Krasus' Landing"] = "Krasus' Landing",
	Library = "Biblioteca",
	["Loch Modan"] = "Loch Modan",
	["Lower Blackrock Spire"] = "Cumbre inferior de Roca Negra",
	["Magisters' Terrace"] = "Bancal Del Magister",
	["Magtheridon's Lair"] = "Guarida de Magtheridon",
	["Mana-Tombs"] = "Tumbas de Maná",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Lago Luz Pantanosa",
	["Menethil Harbor"] = "Puerto de Menethil",
	["Molten Core"] = "Núcleo de Magma",
	Moonglade = "Claro de la Luna",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arena de Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Tormenta Abisal",
	["Night Elf Village"] = "Poblado Elfo de la Noche",
	Northrend = "Rasganorte",
	["Obsidia's Perch"] = "Nido de Obsidia",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas",
	["Old Stratholme"] = "Stratholme en el pasado",
	["Onyxia's Lair"] = "Guarida de Onyxia",
	Orgrimmar = "Orgrimmar",
	Outland = "Terrallende",
	["Pit of Saron"] = "Foso de Saron",
	["Plaguelands: The Scarlet Enclave"] = "Tierras de la Peste del Este: El Enclave Escarlata",
	Plaguewood = "Bosque de la Plaga",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Sima ígnea",
	Ratchet = "Trinquete",
	["Razorfen Downs"] = "Zahúrda Rajacieno",
	["Razorfen Kraul"] = "Horado Rajacieno",
	["Redridge Mountains"] = "Montañas Crestagrana",
	["Ring of Observance"] = "Círculo de la Observancia",
	["Rivendark's Perch"] = "Nido de Desgarro Oscuro",
	["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj",
	["Ruins of Lordaeron"] = "Ruinas de Lordaeron",
	["Scalebeard's Cave"] = "Cueva de Barbascamas",
	["Scarlet Monastery"] = "Monasterio Escarlata",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "La Garganta de Fuego",
	["Serpent Lake"] = "Lago Serpiente",
	["Serpentshrine Cavern"] = "Caverna Santuario Serpiente",
	["Sethekk Halls"] = "Salas Sethekk",
	["Shadowfang Keep"] = "Castillo de Colmillo Oscuro",
	["Shadow Labyrinth"] = "Laberinto de las Sombras",
	["Shadowmoon Valley"] = "Valle Sombraluna",
	["Shartuul's Transporter"] = "Transportador de Shartuul",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Ciudad de Shattrath",
	["Sholazar Basin"] = "Cuenca de Sholazar",
	Silithus = "Silithus",
	["Silvermoon City"] = "Ciudad de Lunargenta",
	["Silverpine Forest"] = "Bosque de Argénteos",
	["Skyguard Outpost"] = "Puesto de la guardia de cielo",
	["Skysong Lake"] = "Lago Sol Celeste",
	["Sporewind Lake"] = "Lago Espora Volante",
	Stonard = "Rocal",
	["Stonetalon Mountains"] = "Sierra Espolón",
	Stormwind = "Ventormenta",
	["Stormwind City"] = "Ciudad de Ventormenta",
	["Strand of the Ancients"] = "Playa de los Ancestros",
	["Stranglethorn Vale"] = "Vega de Tuercespina",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "El Templo Sumergido",
	["Sunwell Plateau"] = "Meseta de la Fuente del Sol",
	["Swamp of Sorrows"] = "Pantano de las Penas",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "El Castillo de la Tempestad",
	["Temple of Ahn'Qiraj"] = "El Templo de Ahn'Qiraj",
	["Terokkar Forest"] = "Bosque de Terokkar",
	["Terokk's Rest"] = "Sosiego de Terokk",
	["The Arachnid Quarter"] = "Ala Arácnida",
	["The Arcatraz"] = "El Alcatraz",
	["The Argent Coliseum"] = "El Coliseo Argenta",
	["The Barrens"] = "Los Baldíos",
	["The Black Morass"] = "La Ciénaga Negra",
	["The Blood Furnace"] = "El Horno de Sangre",
	["The Bone Wastes"] = "El Vertedero de Huesos",
	["The Botanica"] = "El Invernáculo",
	["The Construct Quarter"] = "Ala de Abominación",
	["The Culling of Stratholme"] = "La Matanza de Stratholme",
	["The Dark Portal"] = "El Portal Oscuro",
	["The Deadmines"] = "Las Minas de la Muerte",
	["The Descent into Madness"] = "Descenso a la Locura",
	["The Exodar"] = "El Exodar",
	["The Eye"] = "El Ojo",
	["The Eye of Eternity"] = "El Ojo de la Eternidad",
	["The Forbidding Sea"] = "Mar Adusto",
	["The Forge of Souls"] = "La Forja de Almas",
	["The Frozen Halls"] = "Las Cámaras Heladas",
	["The Frozen Sea"] = "El Mar Gélido",
	["The Great Sea"] = "Mare Magnum",
	["The Halls of Winter"] = "Las Cámaras del Invierno",
	["The Hinterlands"] = "Tierras del Interior",
	["The Mechanar"] = "El Mechanar",
	["The Military Quarter"] = "Ala Militar",
	["The Nexus"] = "El Nexo",
	["The North Sea"] = "El Mar Norte",
	["The Obsidian Sanctum"] = "El Sagrario Obsidiana",
	["The Oculus"] = "El Oculus",
	["The Plague Quarter"] = "Ala de la Plaga",
	["The Prison of Yogg-Saron"] = "La Prisión de Yogg-Saron",
	["Theramore Isle"] = "Isla Theramore",
	["The Ring of Valor"] = "El Anillo del Valor",
	-- ["The Ruby Sanctum"] = "",
	["The Scarlet Enclave"] = "Tierras de la Peste: El Enclave Escarlata",
	["The Shattered Halls"] = "Las Salas Arrasadas",
	["The Slave Pens"] = "Recinto de los Esclavos",
	["The Spark of Imagination"] = "Cámaras de la Invención",
	["The Steamvault"] = "La Cámara de Vapor",
	["The Stockade"] = "Las Mazmorras",
	["The Storm Peaks"] = "Las Cumbres Tormentosas",
	["The Temple of Atal'Hakkar"] = "El Templo de Atal'Hakkar",
	["The Underbog"] = "La Sotiénaga",
	["The Veiled Sea"] = "Mar de la Bruma",
	["The Violet Hold"] = "El Bastión Violeta",
	["Thousand Needles"] = "Las Mil Agujas",
	["Thunder Bluff"] = "Cima del Trueno",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Claros de Tirisfal",
	["Trial of the Champion"] = "Prueba del Cruzado",
	["Trial of the Crusader"] = "Prueba del Cruzado",
	["Twisting Nether"] = "El Vacío Abisal",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Undercity = "Entrañas",
	["Un'Goro Crater"] = "Cráter de Un'Goro",
	["Upper Blackrock Spire"] = "Cumbre de Roca Negra",
	["Utgarde Keep"] = "Fortaleza de Utgarde",
	["Utgarde Pinnacle"] = "Pináculo de Utgarde",
	["Vault of Archavon"] = "La Cámara de Archavon",
	["Vortex Pinnacle"] = "Cumbre del Vórtice",
	["Wailing Caverns"] = "Cuevas de los Lamentos",
	["Warsong Gulch"] = "Garganta Grito de Guerra",
	["Western Plaguelands"] = "Tierras de la Peste del Oeste",
	Westfall = "Páramos de Poniente",
	Wetlands = "Los Humedales",
	Wintergrasp = "Conquista del Invierno",
	Winterspring = "Cuna del Invierno",
	["Wyrmrest Temple"] = "Templo del Reposo del Dragón",
	Zangarmarsh = "Marisma de Zangar",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "esMX" then
	lib:SetCurrentTranslations {
	["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: El Antiguo Reino",
	["Ahn'Qiraj"] = "Ahn'Qiraj",
	["Alliance Base"] = "Base de la Alianza",
	["Alterac Mountains"] = "Montañas de Alterac",
	["Alterac Valley"] = "Valle de Alterac",
	["Amani Pass"] = "Paso de Amani",
	["Arathi Basin"] = "Cuenca de Arathi",
	["Arathi Highlands"] = "Tierras Altas de Arathi",
	Armory = "Armería",
	Ashenvale = "Vallefresno",
	Auberdine = "Auberdine",
	["Auchenai Crypts"] = "Criptas Auchenai",
	Auchindoun = "Auchindoun",
	Azeroth = "Azeroth",
	["Azjol-Nerub"] = "Azjol-Nerub",
	Azshara = "Azshara",
	["Azuremyst Isle"] = "Isla Bruma Azur",
	Badlands = "Tierras Inhóspitas",
	["Bash'ir Landing"] = "Zona de aterrizaje Bash'ir",
	["Blackfathom Deeps"] = "Cavernas de Brazanegra",
	["Blackrock Depths"] = "Profundidades de Roca Negra",
	["Blackrock Mountain"] = "Montaña Roca Negra",
	["Blackrock Spire"] = "Cumbre de Roca Negra",
	["Black Temple"] = "El Templo Oscuro",
	["Blackwind Lake"] = "Lago Vientonegro",
	["Blackwing Lair"] = "Guarida Alanegra",
	["Blade's Edge Arena"] = "Arena Filospada",
	["Blade's Edge Mountains"] = "Montañas Filospada",
	["Blasted Lands"] = "Las Tierras Devastadas",
	["Bloodmyst Isle"] = "Isla Bruma de Sangre",
	["Booty Bay"] = "Bahía del Botín",
	["Borean Tundra"] = "Tundra Boreal",
	["Burning Steppes"] = "Las Estepas Ardientes",
	Cathedral = "Catedral",
	["Caverns of Time"] = "Cavernas del Tiempo",
	["Champions' Hall"] = "Sala de los Campeones",
	["Coilfang Reservoir"] = "Reserva Colmillo Torcido",
	Coldarra = "Gelidar",
	["Cosmic map"] = "Mapa cósmico",
	["Crystalsong Forest"] = "Bosque Canto de Cristal",
	["Crystal Spine"] = "Espina de Cristal",
	Dalaran = "Dalaran",
	["Dalaran Arena"] = "Arena de Dalaran",
	["Dalaran Sewers"] = "Cloacas de Dalaran",
	["Darkmoon Faire"] = "Feria de la Luna Negra",
	Darkshore = "Costa Oscura",
	Darnassus = "Darnassus",
	["Deadwind Pass"] = "Paso de la Muerte",
	["Deeprun Tram"] = "Tranvía Subterráneo",
	Desolace = "Desolace",
	["Dire Maul"] = "La Masacre",
	["Dire Maul (East)"] = "La Masacre (Este)",
	["Dire Maul (North)"] = "La Masacre (Norte)",
	["Dire Maul (West)"] = "La Masacre (Oeste)",
	Dragonblight = "Cementerio de Dragones",
	["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon",
	["Dun Morogh"] = "Dun Morogh",
	Durotar = "Durotar",
	Duskwood = "Bosque del Ocaso",
	["Dustwallow Marsh"] = "Marjal Revolcafango",
	["Eastern Kingdoms"] = "Reinos del Este",
	["Eastern Plaguelands"] = "Tierras de la Peste del Este",
	["Elwynn Forest"] = "Bosque de Elwynn",
	Everlook = "Vista Eterna",
	["Eversong Woods"] = "Bosque Canción Eterna",
	["Eye of the Storm"] = "Ojo de la Tormenta",
	Felwood = "Frondavil",
	Feralas = "Feralas",
	["Forge Camp: Terror"] = "Campamento forja: Terror",
	["Forge Camp: Wrath"] = "Campamento forja: Cólera",
	["Frostwyrm Lair"] = "Guarida de Vermis de Escarcha",
	["Furywing's Perch"] = "Nido de Alafuria",
	Gadgetzan = "Gadgetzan",
	["Gates of Ahn'Qiraj"] = "Puertas de Ahn'Qiraj",
	Ghostlands = "Tierras Fantasma",
	Gnomeregan = "Gnomeregan",
	Graveyard = "Cementerio",
	["Grizzly Hills"] = "Colinas Pardas",
	["Grom'gol Base Camp"] = "Campamento Grom'gol",
	["Gruul's Lair"] = "Guarida de Gruul",
	Gundrak = "Gundrak",
	["Hall of Champions"] = "Sala de los Campeones",
	["Hall of Legends"] = "Sala de las Leyendas",
	["Halls of Lightning"] = "Cámaras de Relámpagos",
	["Halls of Reflection"] = "Camáras de Reflexión",
	["Halls of Stone"] = "Cámaras de Piedra",
	["Hellfire Citadel"] = "Ciudadela del Fuego Infernal",
	["Hellfire Peninsula"] = "Península del Fuego Infernal",
	["Hellfire Ramparts"] = "Murallas del Fuego Infernal",
	["Hillsbrad Foothills"] = "Laderas de Trabalomas",
	["Horde Encampment"] = "Campamento Horda",
	["Howling Fjord"] = "Fiordo Aquilonal",
	["Hrothgar's Landing"] = "Desembarco de Hrothgar",
	Hyjal = "Hyjal",
	["Hyjal Summit"] = "Cima Hyjal",
	Icecrown = "Corona de Hielo",
	["Icecrown Citadel"] = "Ciudadela de la Corona de Hielo",
	["Insidion's Perch"] = "Nido de Insidion",
	Ironforge = "Forjaz",
	["Isle of Conquest"] = "Isla de la Conquista",
	["Isle of Quel'Danas"] = "Isla de Quel'Danas",
	Kalimdor = "Kalimdor",
	Karazhan = "Karazhan",
	["Krasus' Landing"] = "Krasus' Landing",
	Library = "Biblioteca",
	["Loch Modan"] = "Loch Modan",
	["Lower Blackrock Spire"] = "Cumbre inferior de Roca Negra",
	["Magisters' Terrace"] = "Bancal Del Magister",
	["Magtheridon's Lair"] = "Guarida de Magtheridon",
	["Mana-Tombs"] = "Tumbas de Maná",
	Maraudon = "Maraudon",
	["Marshlight Lake"] = "Lago Luz Pantanosa",
	["Menethil Harbor"] = "Puerto de Menethil",
	["Molten Core"] = "Núcleo de Magma",
	Moonglade = "Claro de la Luna",
	Mulgore = "Mulgore",
	Nagrand = "Nagrand",
	["Nagrand Arena"] = "Arena de Nagrand",
	Naxxramas = "Naxxramas",
	Netherstorm = "Tormenta Abisal",
	["Night Elf Village"] = "Poblado Elfo de la Noche",
	Northrend = "Rasganorte",
	["Obsidia's Perch"] = "Nido de Obsidia",
	["Ogri'la"] = "Ogri'la",
	["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas",
	["Old Stratholme"] = "Stratholme en el pasado",
	["Onyxia's Lair"] = "Guarida de Onyxia",
	Orgrimmar = "Orgrimmar",
	Outland = "Terrallende",
	["Pit of Saron"] = "Foso de Saron",
	["Plaguelands: The Scarlet Enclave"] = "Tierras de la Peste del Este: El Enclave Escarlata",
	Plaguewood = "Bosque de la Plaga",
	["Quel'thalas"] = "Quel'thalas",
	["Ragefire Chasm"] = "Sima ígnea",
	Ratchet = "Trinquete",
	["Razorfen Downs"] = "Zahúrda Rajacieno",
	["Razorfen Kraul"] = "Horado Rajacieno",
	["Redridge Mountains"] = "Montañas Crestagrana",
	["Ring of Observance"] = "Círculo de la Observancia",
	["Rivendark's Perch"] = "Nido de Desgarro Oscuro",
	["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj",
	["Ruins of Lordaeron"] = "Ruinas de Lordaeron",
	["Scalebeard's Cave"] = "Cueva de Barbaescamas",
	["Scarlet Monastery"] = "Monasterio Escarlata",
	Scholomance = "Scholomance",
	["Searing Gorge"] = "La Garganta de Fuego",
	["Serpent Lake"] = "Lago Serpiente",
	["Serpentshrine Cavern"] = "Caverna Santuario Serpiente",
	["Sethekk Halls"] = "Salas Sethekk",
	["Shadowfang Keep"] = "Castillo de Colmillo Oscuro",
	["Shadow Labyrinth"] = "Laberinto de las Sombras",
	["Shadowmoon Valley"] = "Valle Sombraluna",
	["Shartuul's Transporter"] = "Transportador de Shartuul",
	Shattrath = "Shattrath",
	["Shattrath City"] = "Ciudad de Shattrath",
	["Sholazar Basin"] = "Cuenca de Sholazar",
	Silithus = "Silithus",
	["Silvermoon City"] = "Ciudad de Lunargenta",
	["Silverpine Forest"] = "Bosque de Argénteos",
	["Skyguard Outpost"] = "Puesto de la guardia de cielo",
	["Skysong Lake"] = "Lago Son Celeste",
	["Sporewind Lake"] = "Lago Espora Volante",
	Stonard = "Rocal",
	["Stonetalon Mountains"] = "Sierra Espolón",
	Stormwind = "Ventormenta",
	["Stormwind City"] = "Ciudad de Ventormenta",
	["Strand of the Ancients"] = "Playa de los Ancestros",
	["Stranglethorn Vale"] = "Vega de Tuercespina",
	Stratholme = "Stratholme",
	["Sunken Temple"] = "El Templo Sumergido",
	["Sunwell Plateau"] = "Meseta de la Fuente del Sol",
	["Swamp of Sorrows"] = "Pantano de las Penas",
	Tanaris = "Tanaris",
	Teldrassil = "Teldrassil",
	["Tempest Keep"] = "El Castillo de la Tempestad",
	["Temple of Ahn'Qiraj"] = "El Templo de Ahn'Qiraj",
	["Terokkar Forest"] = "Bosque de Terokkar",
	["Terokk's Rest"] = "Sosiego de Terokk",
	["The Arachnid Quarter"] = "Ala Arácnida",
	["The Arcatraz"] = "El Alcatraz",
	["The Argent Coliseum"] = "El Coliseo Argenta",
	["The Barrens"] = "Los Baldíos",
	["The Black Morass"] = "La Ciénaga Negra",
	["The Blood Furnace"] = "El Horno de Sangre",
	["The Bone Wastes"] = "El Vertedero de Huesos",
	["The Botanica"] = "El Invernáculo",
	["The Construct Quarter"] = "Ala de Abominación",
	["The Culling of Stratholme"] = "La Matanza de Stratholme",
	["The Dark Portal"] = "El Portal Oscuro",
	["The Deadmines"] = "Las Minas de la Muerte",
	["The Descent into Madness"] = "Descenso a la Locura",
	["The Exodar"] = "El Exodar",
	["The Eye"] = "El Ojo",
	["The Eye of Eternity"] = "El Ojo de la Eternidad",
	["The Forbidding Sea"] = "Mar Adusto",
	["The Forge of Souls"] = "La Forja de Almas",
	["The Frozen Halls"] = "Las Salas Gélidas",
	["The Frozen Sea"] = "El Mar Gélido",
	["The Great Sea"] = "Mare Magnum",
	["The Halls of Winter"] = "Las Cámaras del Invierno",
	["The Hinterlands"] = "Tierras del Interior",
	["The Mechanar"] = "El Mechanar",
	["The Military Quarter"] = "Ala Militar",
	["The Nexus"] = "El Nexo",
	["The North Sea"] = "El Mar Norte",
	["The Obsidian Sanctum"] = "El Sagrario Obsidiana",
	["The Oculus"] = "El Oculus",
	["The Plague Quarter"] = "Ala de la Plaga",
	["The Prison of Yogg-Saron"] = "La Prisión de Yogg-Saron",
	["Theramore Isle"] = "Isla Theramore",
	["The Ring of Valor"] = "El Anillo del Valor",
	-- ["The Ruby Sanctum"] = "",
	["The Scarlet Enclave"] = "El Enclave Escarlata",
	["The Shattered Halls"] = "Las Salas Arrasadas",
	["The Slave Pens"] = "Recinto de los Esclavos",
	["The Spark of Imagination"] = "Cámaras de la Invención",
	["The Steamvault"] = "La Cámara de Vapor",
	["The Stockade"] = "Las Mazmorras",
	["The Storm Peaks"] = "Las Cumbres Tormentosas",
	["The Temple of Atal'Hakkar"] = "El Templo de Atal'Hakkar",
	["The Underbog"] = "La Sotiénaga",
	["The Veiled Sea"] = "Mar de la Bruma",
	["The Violet Hold"] = "El Bastión Violeta",
	["Thousand Needles"] = "Las Mil Agujas",
	["Thunder Bluff"] = "Cima del Trueno",
	Tirisfal = "Tirisfal",
	["Tirisfal Glades"] = "Claros de Tirisfal",
	["Trial of the Champion"] = "Pueba del Campeon",
	["Trial of the Crusader"] = "Prueba del Cruzado",
	["Twisting Nether"] = "El Vacío Abisal",
	Uldaman = "Uldaman",
	Ulduar = "Ulduar",
	Undercity = "Entrañas",
	["Un'Goro Crater"] = "Cráter de Un'Goro",
	["Upper Blackrock Spire"] = "Cumbre de Roca Negra",
	["Utgarde Keep"] = "Fortaleza de Utgarde",
	["Utgarde Pinnacle"] = "Pináculo de Utgarde",
	["Vault of Archavon"] = "La Cámara de Archavon",
	["Vortex Pinnacle"] = "Cumbre del Vórtice",
	["Wailing Caverns"] = "Cuevas de los Lamentos",
	["Warsong Gulch"] = "Garganta Grito de Guerra",
	["Western Plaguelands"] = "Tierras de la Peste del Oeste",
	Westfall = "Páramos de Poniente",
	Wetlands = "Los Humedales",
	Wintergrasp = "Conquista del Invierno",
	Winterspring = "Cuna del Invierno",
	["Wyrmrest Temple"] = "Templo del Reposo del Dragón",
	Zangarmarsh = "Marisma de Zangar",
	["Zul'Aman"] = "Zul'Aman",
	["Zul'Drak"] = "Zul'Drak",
	["Zul'Farrak"] = "Zul'Farrak",
	["Zul'Gurub"] = "Zul'Gurub",
}
elseif GAME_LOCALE == "ruRU" then
	lib:SetCurrentTranslations {
	["Ahn'kahet: The Old Kingdom"] = "Ан'кахет: Старое Королевство",
	["Ahn'Qiraj"] = "Ан'Кираж",
	["Alliance Base"] = "База Альянса",
	["Alterac Mountains"] = "Альтеракские горы",
	["Alterac Valley"] = "Альтеракская долина",
	["Amani Pass"] = "Перевал Амани",
	["Arathi Basin"] = "Низина Арати",
	["Arathi Highlands"] = "Нагорье Арати",
	Armory = "Оружейная",
	Ashenvale = "Ясеневый лес",
	Auberdine = "Аубердин",
	["Auchenai Crypts"] = "Аукенайские гробницы",
	Auchindoun = "Аукиндон",
	Azeroth = "Азерот",
	["Azjol-Nerub"] = "Азжол-Неруб",
	Azshara = "Азшара",
	["Azuremyst Isle"] = "Остров Лазурной Дымки",
	Badlands = "Бесплодные земли",
	["Bash'ir Landing"] = "Лагерь Баш'ира",
	["Blackfathom Deeps"] = "Непроглядная Пучина",
	["Blackrock Depths"] = "Глубины Черной горы",
	["Blackrock Mountain"] = "Черная гора",
	["Blackrock Spire"] = "Пик Черной горы",
	["Black Temple"] = "Черный храм",
	["Blackwind Lake"] = "Озеро Черного Ветра",
	["Blackwing Lair"] = "Логово Крыла Тьмы",
	["Blade's Edge Arena"] = "Арена Острогорья",
	["Blade's Edge Mountains"] = "Острогорье",
	["Blasted Lands"] = "Выжженные земли",
	["Bloodmyst Isle"] = "Остров Кровавой Дымки",
	["Booty Bay"] = "Пиратская Бухта",
	["Borean Tundra"] = "Борейская тундра",
	["Burning Steppes"] = "Пылающие степи",
	Cathedral = "Собор",
	["Caverns of Time"] = "Пещеры Времени",
	["Champions' Hall"] = "Зал Защитника",
	["Coilfang Reservoir"] = "Резервуар Кривого Клыка",
	Coldarra = "Хладарра",
	["Cosmic map"] = "Карта Вселенной",
	["Crystalsong Forest"] = "Лес Хрустальной Песни",
	["Crystal Spine"] = "Хрустальное поле",
	Dalaran = "Даларан",
	["Dalaran Arena"] = "Арена Даларана",
	["Dalaran Sewers"] = "Арена Даларана",
	["Darkmoon Faire"] = "Ярмарка Новолуния",
	Darkshore = "Темные берега",
	Darnassus = "Дарнас",
	["Deadwind Pass"] = "Перевал Мертвого Ветра",
	["Deeprun Tram"] = "Подземный поезд",
	Desolace = "Пустоши",
	["Dire Maul"] = "Забытый Город",
	["Dire Maul (East)"] = "Забытый Город: Восток",
	["Dire Maul (North)"] = "Забытый Город: Север",
	["Dire Maul (West)"] = "Забытый Город: Запад",
	Dragonblight = "Драконий Погост",
	["Drak'Tharon Keep"] = "Крепость Драк'Тарон",
	["Dun Morogh"] = "Дун Морог",
	Durotar = "Дуротар",
	Duskwood = "Сумеречный лес",
	["Dustwallow Marsh"] = "Пылевые топи",
	["Eastern Kingdoms"] = "Восточные королевства",
	["Eastern Plaguelands"] = "Восточные Чумные земли",
	["Elwynn Forest"] = "Элвиннский лес",
	Everlook = "Круговзор",
	["Eversong Woods"] = "Леса Вечной Песни",
	["Eye of the Storm"] = "Око Бури",
	Felwood = "Оскверненный лес",
	Feralas = "Фералас",
	["Forge Camp: Terror"] = "Лагерь Легиона: Ужас",
	["Forge Camp: Wrath"] = "Лагерь Легиона: Гнев",
	["Frostwyrm Lair"] = "Логово Ледяного змея",
	["Furywing's Perch"] = "Гнездовье Ярокрыла",
	Gadgetzan = "Прибамбасск",
	["Gates of Ahn'Qiraj"] = "Врата Ан'Киража",
	Ghostlands = "Призрачные земли",
	Gnomeregan = "Гномреган",
	Graveyard = "Кладбище",
	["Grizzly Hills"] = "Седые холмы",
	["Grom'gol Base Camp"] = "Лагерь Гром'гол",
	["Gruul's Lair"] = "Логово Груула",
	Gundrak = "Гундрак",
	["Hall of Champions"] = "Чертог Защитников",
	["Hall of Legends"] = "Зал Легенд",
	["Halls of Lightning"] = "Чертоги Молний",
	["Halls of Reflection"] = "Залы Отражений",
	["Halls of Stone"] = "Чертоги Камня",
	["Hellfire Citadel"] = "Цитадель Адского Пламени",
	["Hellfire Peninsula"] = "Полуостров Адского Пламени",
	["Hellfire Ramparts"] = "Бастионы Адского Пламени",
	["Hillsbrad Foothills"] = "Предгорья Хилсбрада",
	["Horde Encampment"] = "Стоянка Орды",
	["Howling Fjord"] = "Ревущий фьорд",
	["Hrothgar's Landing"] = "Лагерь Хротгара",
	Hyjal = "Хиджал",
	["Hyjal Summit"] = "Вершина Хиджала",
	Icecrown = "Ледяная Корона",
	["Icecrown Citadel"] = "Цитадель Ледяной Короны",
	["Insidion's Perch"] = "Гнездо Инсидиона",
	Ironforge = "Стальгорн",
	["Isle of Conquest"] = "Остров Завоеваний",
	["Isle of Quel'Danas"] = "Остров Кель'Данас",
	Kalimdor = "Калимдор",
	Karazhan = "Каражан",
	["Krasus' Landing"] = "Площадка Краса",
	Library = "Библиотека",
	["Loch Modan"] = "Лок Модан",
	["Lower Blackrock Spire"] = "Нижний ярус Черной горы",
	["Magisters' Terrace"] = "Терраса Магистров",
	["Magtheridon's Lair"] = "Логово Магтеридона",
	["Mana-Tombs"] = "Гробницы Маны",
	Maraudon = "Мародон",
	["Marshlight Lake"] = "Озеро Болотных Огоньков",
	["Menethil Harbor"] = "Гавань Менетилов",
	["Molten Core"] = "Огненные Недра",
	Moonglade = "Лунная поляна",
	Mulgore = "Мулгор",
	Nagrand = "Награнд",
	["Nagrand Arena"] = "Арена Награнда",
	Naxxramas = "Наксрамас",
	Netherstorm = "Пустоверть",
	["Night Elf Village"] = "Деревня ночных эльфов",
	Northrend = "Нордскол",
	["Obsidia's Perch"] = "Гнездо Обсидии",
	["Ogri'la"] = "Огри'ла",
	["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада",
	["Old Stratholme"] = "Старый Стратхольм",
	["Onyxia's Lair"] = "Логово Ониксии",
	Orgrimmar = "Оргриммар",
	Outland = "Запределье",
	["Pit of Saron"] = "Яма Сарона",
	["Plaguelands: The Scarlet Enclave"] = "Чумные земли: Анклав Алого ордена",
	Plaguewood = "Проклятый лес",
	["Quel'thalas"] = "Кель'Талас",
	["Ragefire Chasm"] = "Огненная пропасть",
	Ratchet = "Кабестан",
	["Razorfen Downs"] = "Курганы Иглошкурых",
	["Razorfen Kraul"] = "Лабиринты Иглошкурых",
	["Redridge Mountains"] = "Красногорье",
	["Ring of Observance"] = "Ритуальный Круг",
	["Rivendark's Perch"] = "Гнездо Чернокрыла",
	["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража",
	["Ruins of Lordaeron"] = "Руины Лордерона",
	["Scalebeard's Cave"] = "Пещера Чешуеборода",
	["Scarlet Monastery"] = "Монастырь Алого ордена",
	Scholomance = "Некроситет",
	["Searing Gorge"] = "Тлеющее ущелье",
	["Serpent Lake"] = "Змеиное озеро",
	["Serpentshrine Cavern"] = "Змеиное святилище",
	["Sethekk Halls"] = "Сетеккские залы",
	["Shadowfang Keep"] = "Крепость Темного Клыка",
	["Shadow Labyrinth"] = "Темный лабиринт",
	["Shadowmoon Valley"] = "Долина Призрачной Луны",
	["Shartuul's Transporter"] = "Транспортер Шартуула",
	Shattrath = "Шаттрат",
	["Shattrath City"] = "Шаттрат",
	["Sholazar Basin"] = "Низина Шолазар",
	Silithus = "Силитус",
	["Silvermoon City"] = "Луносвет",
	["Silverpine Forest"] = "Серебряный бор",
	["Skyguard Outpost"] = "Застава Стражи Небес",
	["Skysong Lake"] = "Озеро Небесной Песни",
	["Sporewind Lake"] = "Озеро Спороветра",
	Stonard = "Каменор",
	["Stonetalon Mountains"] = "Когтистые горы",
	Stormwind = "Штормград",
	["Stormwind City"] = "Штормград",
	["Strand of the Ancients"] = "Берег Древних",
	["Stranglethorn Vale"] = "Тернистая долина",
	Stratholme = "Стратхольм",
	["Sunken Temple"] = "Затонувший храм",
	["Sunwell Plateau"] = "Плато Солнечного Колодца",
	["Swamp of Sorrows"] = "Болото Печали",
	Tanaris = "Танарис",
	Teldrassil = "Тельдрассил",
	["Tempest Keep"] = "Крепость Бурь",
	["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж",
	["Terokkar Forest"] = "Лес Тероккар",
	["Terokk's Rest"] = "Покой Терокка",
	["The Arachnid Quarter"] = "Паучий квартал",
	["The Arcatraz"] = "Аркатрац",
	["The Argent Coliseum"] = "Испытание крестоносца",
	["The Barrens"] = "Степи",
	["The Black Morass"] = "Черные топи",
	["The Blood Furnace"] = "Кузня Крови",
	["The Bone Wastes"] = "Костяные пустоши",
	["The Botanica"] = "Ботаника",
	["The Construct Quarter"] = "Квартал Мерзости",
	["The Culling of Stratholme"] = "Очищение Стратхольма",
	["The Dark Portal"] = "Темный портал",
	["The Deadmines"] = "Мертвые копи",
	["The Descent into Madness"] = "Провал Безумия",
	["The Exodar"] = "Экзодар",
	["The Eye"] = "Око",
	["The Eye of Eternity"] = "Око Вечности",
	["The Forbidding Sea"] = "Зловещее море",
	["The Forge of Souls"] = "Кузня Душ",
	["The Frozen Halls"] = "Ледяные залы", -- Needs review
	["The Frozen Sea"] = "Ледяное море",
	["The Great Sea"] = "Великое море",
	["The Halls of Winter"] = "Залы Зимы", -- Needs review
	["The Hinterlands"] = "Внутренние земли",
	["The Mechanar"] = "Механар",
	["The Military Quarter"] = "Военный квартал",
	["The Nexus"] = "Нексус",
	["The North Sea"] = "Северное море",
	["The Obsidian Sanctum"] = "Обсидиановое святилище",
	["The Oculus"] = "Окулус",
	["The Plague Quarter"] = "Чумной квартал",
	["The Prison of Yogg-Saron"] = "Темница Йогг-Сарона", -- Needs review
	["Theramore Isle"] = "Остров Терамор",
	["The Ring of Valor"] = "Круг Доблести",
	["The Ruby Sanctum"] = "Рубиновое святилище",
	["The Scarlet Enclave"] = "Анклав Алого ордена", -- Needs review
	["The Shattered Halls"] = "Разрушенные залы",
	["The Slave Pens"] = "Узилище",
	["The Spark of Imagination"] = "Искра Воображения",
	["The Steamvault"] = "Паровое подземелье",
	["The Stockade"] = "Тюрьма",
	["The Storm Peaks"] = "Грозовая Гряда",
	["The Temple of Atal'Hakkar"] = "Храм Атал'Хаккара",
	["The Underbog"] = "Нижетопь",
	["The Veiled Sea"] = "Сокрытое Море",
	["The Violet Hold"] = "Аметистовая крепость",
	["Thousand Needles"] = "Тысяча Игл",
	["Thunder Bluff"] = "Громовой Утес",
	Tirisfal = "Тирисфальские леса",
	["Tirisfal Glades"] = "Тирисфальские леса",
	["Trial of the Champion"] = "Испытание чемпиона",
	["Trial of the Crusader"] = "Испытание крестоносца",
	["Twisting Nether"] = "Круговерть Пустоты",
	Uldaman = "Ульдаман",
	Ulduar = "Ульдуар",
	Undercity = "Подгород",
	["Un'Goro Crater"] = "Кратер Ун'Горо",
	["Upper Blackrock Spire"] = "Верхний ярус Черной горы",
	["Utgarde Keep"] = "Крепость Утгард",
	["Utgarde Pinnacle"] = "Вершина Утгард",
	["Vault of Archavon"] = "Склеп Аркавона",
	["Vortex Pinnacle"] = "Нагорье Смерчей",
	["Wailing Caverns"] = "Пещеры Стенаний",
	["Warsong Gulch"] = "Ущелье Песни Войны",
	["Western Plaguelands"] = "Западные Чумные земли",
	Westfall = "Западный Край",
	Wetlands = "Болотина",
	Wintergrasp = "Озеро Ледяных Оков",
	Winterspring = "Зимние Ключи",
	["Wyrmrest Temple"] = "Храм Драконьего Покоя",
	Zangarmarsh = "Зангартопь",
	["Zul'Aman"] = "Зул'Аман",
	["Zul'Drak"] = "Зул'Драк",
	["Zul'Farrak"] = "Зул'Фаррак",
	["Zul'Gurub"] = "Зул'Гуруб",
}
elseif GAME_LOCALE == "zhCN" then
	lib:SetCurrentTranslations {
	["Ahn'kahet: The Old Kingdom"] = "安卡雷：古代王国",
	["Ahn'Qiraj"] = "安其拉",
	["Alliance Base"] = "联盟基地",
	["Alterac Mountains"] = "奥特兰克山脉",
	["Alterac Valley"] = "奥特兰克山谷",
	["Amani Pass"] = "阿曼尼小径",
	["Arathi Basin"] = "阿拉希盆地",
	["Arathi Highlands"] = "阿拉希高地",
	Armory = "军械库",
	Ashenvale = "灰谷",
	Auberdine = "奥伯丁",
	["Auchenai Crypts"] = "奥金尼地穴",
	Auchindoun = "奥金顿",
	Azeroth = "艾泽拉斯",
	["Azjol-Nerub"] = "艾卓-尼鲁布",
	Azshara = "艾萨拉",
	["Azuremyst Isle"] = "秘蓝岛",
	Badlands = "荒芜之地",
	["Bash'ir Landing"] = "巴什伊尔码头",
	["Blackfathom Deeps"] = "黑暗深渊",
	["Blackrock Depths"] = "黑石深渊",
	["Blackrock Mountain"] = "黑石山",
	["Blackrock Spire"] = "黑石塔",
	["Black Temple"] = "黑暗神殿",
	["Blackwind Lake"] = "黑风湖",
	["Blackwing Lair"] = "黑翼之巢",
	["Blade's Edge Arena"] = "刀锋山竞技场",
	["Blade's Edge Mountains"] = "刀锋山",
	["Blasted Lands"] = "诅咒之地",
	["Bloodmyst Isle"] = "秘血岛",
	["Booty Bay"] = "藏宝海湾",
	["Borean Tundra"] = "北风苔原",
	["Burning Steppes"] = "燃烧平原",
	Cathedral = "教堂",
	["Caverns of Time"] = "时光之穴",
	["Champions' Hall"] = "勇士大厅",
	["Coilfang Reservoir"] = "盘牙水库",
	Coldarra = "考达拉",
	["Cosmic map"] = "全部地图",
	["Crystalsong Forest"] = "晶歌森林",
	["Crystal Spine"] = "水晶之脊",
	Dalaran = "达拉然",
	["Dalaran Arena"] = "达拉然竞技场",
	["Dalaran Sewers"] = "达拉然下水道",
	["Darkmoon Faire"] = "暗月马戏团",
	Darkshore = "黑海岸",
	Darnassus = "达纳苏斯",
	["Deadwind Pass"] = "逆风小径",
	["Deeprun Tram"] = "矿道地铁",
	Desolace = "凄凉之地",
	["Dire Maul"] = "厄运之槌",
	["Dire Maul (East)"] = "厄运之槌（东）",
	["Dire Maul (North)"] = "厄运之槌（北）",
	["Dire Maul (West)"] = "厄运之槌（西）",
	Dragonblight = "龙骨荒野",
	["Drak'Tharon Keep"] = "达克萨隆要塞",
	["Dun Morogh"] = "丹莫罗",
	Durotar = "杜隆塔尔",
	Duskwood = "暮色森林",
	["Dustwallow Marsh"] = "尘泥沼泽",
	["Eastern Kingdoms"] = "东部王国",
	["Eastern Plaguelands"] = "东瘟疫之地",
	["Elwynn Forest"] = "艾尔文森林",
	Everlook = "永望镇",
	["Eversong Woods"] = "永歌森林",
	["Eye of the Storm"] = "风暴之眼",
	Felwood = "费伍德森林",
	Feralas = "菲拉斯",
	["Forge Camp: Terror"] = "铸魔营地：恐怖",
	["Forge Camp: Wrath"] = "铸魔营地：天罚",
	["Frostwyrm Lair"] = "冰霜巨龙的巢穴",
	["Furywing's Perch"] = "弗雷文栖木",
	Gadgetzan = "加基森",
	["Gates of Ahn'Qiraj"] = "安其拉之门",
	Ghostlands = "幽魂之地",
	Gnomeregan = "诺莫瑞根",
	Graveyard = "墓地",
	["Grizzly Hills"] = "灰熊丘陵",
	["Grom'gol Base Camp"] = "格罗姆高营地",
	["Gruul's Lair"] = "格鲁尔的巢穴",
	Gundrak = "古达克",
	["Hall of Champions"] = "勇士大厅",
	["Hall of Legends"] = "传说大厅",
	["Halls of Lightning"] = "闪电大厅",
	["Halls of Reflection"] = "映像大厅",
	["Halls of Stone"] = "岩石大厅",
	["Hellfire Citadel"] = "地狱火堡垒",
	["Hellfire Peninsula"] = "地狱火半岛",
	["Hellfire Ramparts"] = "地狱火城墙",
	["Hillsbrad Foothills"] = "希尔斯布莱德丘陵",
	["Horde Encampment"] = "部落营地",
	["Howling Fjord"] = "嚎风峡湾",
	["Hrothgar's Landing"] = "洛斯加尔登陆点",
	Hyjal = "海加尔山",
	["Hyjal Summit"] = "海加尔峰",
	Icecrown = "冰冠冰川",
	["Icecrown Citadel"] = "冰冠堡垒",
	["Insidion's Perch"] = "因斯迪安栖木",
	Ironforge = "铁炉堡",
	["Isle of Conquest"] = "征服之岛",
	["Isle of Quel'Danas"] = "奎尔丹纳斯岛",
	Kalimdor = "卡利姆多",
	Karazhan = "卡拉赞",
	["Krasus' Landing"] = "克拉苏斯平台",
	Library = "图书馆",
	["Loch Modan"] = "洛克莫丹",
	["Lower Blackrock Spire"] = "下层黑石塔",
	["Magisters' Terrace"] = "魔导师平台",
	["Magtheridon's Lair"] = "玛瑟里顿的巢穴",
	["Mana-Tombs"] = "法力陵墓",
	Maraudon = "玛拉顿",
	["Marshlight Lake"] = "沼光湖",
	["Menethil Harbor"] = "米奈希尔港",
	["Molten Core"] = "熔火之心",
	Moonglade = "月光林地",
	Mulgore = "莫高雷",
	Nagrand = "纳格兰",
	["Nagrand Arena"] = "纳格兰竞技场",
	Naxxramas = "纳克萨玛斯",
	Netherstorm = "虚空风暴",
	["Night Elf Village"] = "暗夜精灵村庄",
	Northrend = "诺森德",
	["Obsidia's Perch"] = "欧比斯迪栖木",
	["Ogri'la"] = "奥格瑞拉",
	["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵",
	["Old Stratholme"] = "旧斯坦索姆",
	["Onyxia's Lair"] = "奥妮克希亚的巢穴",
	Orgrimmar = "奥格瑞玛",
	Outland = "外域",
	["Pit of Saron"] = "萨隆矿坑",
	["Plaguelands: The Scarlet Enclave"] = "东瘟疫之地：血色领地",
	Plaguewood = "病木林",
	["Quel'thalas"] = "奎尔萨拉斯",
	["Ragefire Chasm"] = "怒焰裂谷",
	Ratchet = "棘齿城",
	["Razorfen Downs"] = "剃刀高地",
	["Razorfen Kraul"] = "剃刀沼泽",
	["Redridge Mountains"] = "赤脊山",
	["Ring of Observance"] = "仪式广场",
	["Rivendark's Perch"] = "雷文达克栖木",
	["Ruins of Ahn'Qiraj"] = "安其拉废墟",
	["Ruins of Lordaeron"] = "洛丹伦废墟",
	["Scalebeard's Cave"] = "鳞须海龟洞穴",
	["Scarlet Monastery"] = "血色修道院",
	Scholomance = "通灵学院",
	["Searing Gorge"] = "灼热峡谷",
	["Serpent Lake"] = "毒蛇湖",
	["Serpentshrine Cavern"] = "毒蛇神殿",
	["Sethekk Halls"] = "塞泰克大厅",
	["Shadowfang Keep"] = "影牙城堡",
	["Shadow Labyrinth"] = "暗影迷宫",
	["Shadowmoon Valley"] = "影月谷",
	["Shartuul's Transporter"] = "沙图尔的传送器",
	Shattrath = "沙塔斯",
	["Shattrath City"] = "沙塔斯城",
	["Sholazar Basin"] = "索拉查盆地",
	Silithus = "希利苏斯",
	["Silvermoon City"] = "银月城",
	["Silverpine Forest"] = "银松森林",
	["Skyguard Outpost"] = "天空卫队哨站",
	["Skysong Lake"] = "天歌湖",
	["Sporewind Lake"] = "孢子湖",
	Stonard = "斯通纳德",
	["Stonetalon Mountains"] = "石爪山脉",
	Stormwind = "暴风城",
	["Stormwind City"] = "暴风城",
	["Strand of the Ancients"] = "远古海滩",
	["Stranglethorn Vale"] = "荆棘谷",
	Stratholme = "斯坦索姆",
	["Sunken Temple"] = "沉没的神庙",
	["Sunwell Plateau"] = "太阳之井高地",
	["Swamp of Sorrows"] = "悲伤沼泽",
	Tanaris = "塔纳利斯",
	Teldrassil = "泰达希尔",
	["Tempest Keep"] = "风暴要塞",
	["Temple of Ahn'Qiraj"] = "安其拉神殿",
	["Terokkar Forest"] = "泰罗卡森林",
	["Terokk's Rest"] = "泰罗克之墓",
	["The Arachnid Quarter"] = "蜘蛛区",
	["The Arcatraz"] = "禁魔监狱",
	["The Argent Coliseum"] = "银色试炼场", -- Needs review
	["The Barrens"] = "贫瘠之地",
	["The Black Morass"] = "黑色沼泽",
	["The Blood Furnace"] = "鲜血熔炉",
	["The Bone Wastes"] = "白骨荒野",
	["The Botanica"] = "生态船",
	["The Construct Quarter"] = "构造区",
	["The Culling of Stratholme"] = "净化斯坦索姆",
	["The Dark Portal"] = "黑暗之门",
	["The Deadmines"] = "死亡矿井",
	["The Descent into Madness"] = "疯狂阶梯",
	["The Exodar"] = "埃索达",
	["The Eye"] = "风暴要塞",
	["The Eye of Eternity"] = "永恒之眼",
	["The Forbidding Sea"] = "禁忌之海",
	["The Forge of Souls"] = "灵魂洪炉",
	["The Frozen Halls"] = "The Frozen Halls", -- Needs review
	["The Frozen Sea"] = "冰冻之海",
	["The Great Sea"] = "无尽之海",
	["The Halls of Winter"] = "寒冬之厅",
	["The Hinterlands"] = "辛特兰",
	["The Mechanar"] = "能源舰",
	["The Military Quarter"] = "军事区",
	["The Nexus"] = "魔枢",
	["The North Sea"] = "北海",
	["The Obsidian Sanctum"] = "黑曜石圣殿",
	["The Oculus"] = "魔环",
	["The Plague Quarter"] = "瘟疫区",
	["The Prison of Yogg-Saron"] = "尤格-萨隆的监狱",
	["Theramore Isle"] = "塞拉摩岛",
	["The Ring of Valor"] = "勇气竞技场",
	["The Ruby Sanctum"] = "The Ruby Sanctum", -- Needs review
	["The Scarlet Enclave"] = "血色领地",
	["The Shattered Halls"] = "破碎大厅",
	["The Slave Pens"] = "奴隶围栏",
	["The Spark of Imagination"] = "思想火花",
	["The Steamvault"] = "蒸汽地窟",
	["The Stockade"] = "监狱",
	["The Storm Peaks"] = "风暴峭壁",
	["The Temple of Atal'Hakkar"] = "阿塔哈卡神庙",
	["The Underbog"] = "幽暗沼泽",
	["The Veiled Sea"] = "迷雾之海",
	["The Violet Hold"] = "紫罗兰监狱",
	["Thousand Needles"] = "千针石林",
	["Thunder Bluff"] = "雷霆崖",
	Tirisfal = "提里斯法林地",
	["Tirisfal Glades"] = "提瑞斯法林地",
	["Trial of the Champion"] = "冠军的试炼",
	["Trial of the Crusader"] = "十字军的试炼",
	["Twisting Nether"] = "扭曲虚空",
	Uldaman = "奥达曼",
	Ulduar = "奥杜尔",
	Undercity = "幽暗城",
	["Un'Goro Crater"] = "安戈洛环形山",
	["Upper Blackrock Spire"] = "上层黑石塔",
	["Utgarde Keep"] = "乌特加德城堡",
	["Utgarde Pinnacle"] = "乌特加德之巅",
	["Vault of Archavon"] = "阿尔卡冯的宝库",
	["Vortex Pinnacle"] = "漩涡峰",
	["Wailing Caverns"] = "哀嚎洞穴",
	["Warsong Gulch"] = "战歌峡谷",
	["Western Plaguelands"] = "西瘟疫之地",
	Westfall = "西部荒野",
	Wetlands = "湿地",
	Wintergrasp = "冬拥湖",
	Winterspring = "冬泉谷",
	["Wyrmrest Temple"] = "龙眠神殿",
	Zangarmarsh = "赞加沼泽",
	["Zul'Aman"] = "祖阿曼",
	["Zul'Drak"] = "祖达克",
	["Zul'Farrak"] = "祖尔法拉克",
	["Zul'Gurub"] = "祖尔格拉布",
}
elseif GAME_LOCALE == "zhTW" then
	lib:SetCurrentTranslations {
	["Ahn'kahet: The Old Kingdom"] = "安卡罕特:古王國",
	["Ahn'Qiraj"] = "安其拉",
	["Alliance Base"] = "聯盟營地",
	["Alterac Mountains"] = "奧特蘭克山脈",
	["Alterac Valley"] = "奧特蘭克山谷",
	["Amani Pass"] = "阿曼尼小俓",
	["Arathi Basin"] = "阿拉希盆地",
	["Arathi Highlands"] = "阿拉希高地",
	Armory = "軍械庫",
	Ashenvale = "梣谷",
	Auberdine = "奧伯丁",
	["Auchenai Crypts"] = "奧奇奈地穴",
	Auchindoun = "奧齊頓",
	Azeroth = "艾澤拉斯",
	["Azjol-Nerub"] = "阿茲歐-奈幽",
	Azshara = "艾薩拉",
	["Azuremyst Isle"] = "藍謎島",
	Badlands = "荒蕪之地",
	["Bash'ir Landing"] = "貝許爾平臺",
	["Blackfathom Deeps"] = "黑暗深淵",
	["Blackrock Depths"] = "黑石深淵",
	["Blackrock Mountain"] = "黑石山",
	["Blackrock Spire"] = "黑石塔",
	["Black Temple"] = "黑暗神廟",
	["Blackwind Lake"] = "黑風湖",
	["Blackwing Lair"] = "黑翼之巢",
	["Blade's Edge Arena"] = "劍刃競技場",
	["Blade's Edge Mountains"] = "劍刃山脈",
	["Blasted Lands"] = "詛咒之地",
	["Bloodmyst Isle"] = "血謎島",
	["Booty Bay"] = "藏寶海灣",
	["Borean Tundra"] = "北風凍原",
	["Burning Steppes"] = "燃燒平原",
	Cathedral = "教堂",
	["Caverns of Time"] = "時光之穴",
	["Champions' Hall"] = "勇士大廳",
	["Coilfang Reservoir"] = "盤牙洞穴",
	Coldarra = "凜懼島",
	["Cosmic map"] = "宇宙地圖",
	["Crystalsong Forest"] = "水晶之歌森林",
	["Crystal Spine"] = "水晶背脊",
	Dalaran = "達拉然",
	["Dalaran Arena"] = "達拉然競技場",
	["Dalaran Sewers"] = "達拉然下水道",
	["Darkmoon Faire"] = "暗月馬戲團",
	Darkshore = "黑海岸",
	Darnassus = "達納蘇斯",
	["Deadwind Pass"] = "逆風小徑",
	["Deeprun Tram"] = "礦道地鐵",
	Desolace = "淒涼之地",
	["Dire Maul"] = "厄運之槌",
	["Dire Maul (East)"] = "厄運之槌 - 東",
	["Dire Maul (North)"] = "厄運之槌 - 北",
	["Dire Maul (West)"] = "厄運之槌 - 西",
	Dragonblight = "龍骨荒野",
	["Drak'Tharon Keep"] = "德拉克薩隆要塞",
	["Dun Morogh"] = "丹莫洛",
	Durotar = "杜洛塔",
	Duskwood = "暮色森林",
	["Dustwallow Marsh"] = "塵泥沼澤",
	["Eastern Kingdoms"] = "東部王國",
	["Eastern Plaguelands"] = "東瘟疫之地",
	["Elwynn Forest"] = "艾爾文森林",
	Everlook = "永望鎮",
	["Eversong Woods"] = "永歌森林",
	["Eye of the Storm"] = "暴風之眼",
	Felwood = "費伍德森林",
	Feralas = "菲拉斯",
	["Forge Camp: Terror"] = "煉冶場:驚駭",
	["Forge Camp: Wrath"] = "煉冶場:憤怒",
	["Frostwyrm Lair"] = "冰霜巨龍的巢穴",
	["Furywing's Perch"] = "狂怒之翼棲所",
	Gadgetzan = "加基森",
	["Gates of Ahn'Qiraj"] = "安其拉之門",
	Ghostlands = "鬼魂之地",
	Gnomeregan = "諾姆瑞根",
	Graveyard = "墓地",
	["Grizzly Hills"] = "灰白之丘",
	["Grom'gol Base Camp"] = "格羅姆高營地",
	["Gruul's Lair"] = "戈魯爾之巢",
	Gundrak = "剛德拉克",
	["Hall of Champions"] = "勇士大廳",
	["Hall of Legends"] = "傳說大廳",
	["Halls of Lightning"] = "雷光大廳",
	["Halls of Reflection"] = "倒影大廳",
	["Halls of Stone"] = "石之大廳",
	["Hellfire Citadel"] = "地獄火堡壘",
	["Hellfire Peninsula"] = "地獄火半島",
	["Hellfire Ramparts"] = "地獄火壁壘",
	["Hillsbrad Foothills"] = "希爾斯布萊德丘陵",
	["Horde Encampment"] = "部落營地",
	["Howling Fjord"] = "凜風峽灣",
	["Hrothgar's Landing"] = "赫魯斯加臺地",
	Hyjal = "海加爾山",
	["Hyjal Summit"] = "海加爾山",
	Icecrown = "寒冰皇冠",
	["Icecrown Citadel"] = "冰冠城塞",
	["Insidion's Perch"] = "印希迪恩棲所",
	Ironforge = "鐵爐堡",
	["Isle of Conquest"] = "征服之島",
	["Isle of Quel'Danas"] = "奎爾達納斯之島",
	Kalimdor = "卡林多",
	Karazhan = "卡拉贊",
	["Krasus' Landing"] = "卡薩斯平臺",
	Library = "圖書館",
	["Loch Modan"] = "洛克莫丹",
	["Lower Blackrock Spire"] = "黑石塔",
	["Magisters' Terrace"] = "博學者殿堂",
	["Magtheridon's Lair"] = "瑪瑟里頓的巢穴",
	["Mana-Tombs"] = "法力墓地",
	Maraudon = "瑪拉頓",
	["Marshlight Lake"] = "沼澤光之湖",
	["Menethil Harbor"] = "米奈希爾港",
	["Molten Core"] = "熔火之心",
	Moonglade = "月光林地",
	Mulgore = "莫高雷",
	Nagrand = "納葛蘭",
	["Nagrand Arena"] = "納葛蘭競技場",
	Naxxramas = "納克薩瑪斯",
	Netherstorm = "虛空風暴",
	["Night Elf Village"] = "夜精靈村",
	Northrend = "北裂境",
	["Obsidia's Perch"] = "歐比希迪亞棲所",
	["Ogri'la"] = "歐格利拉",
	["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址",
	["Old Stratholme"] = "舊斯坦索姆",
	["Onyxia's Lair"] = "奧妮克希亞的巢穴",
	Orgrimmar = "奧格瑪",
	Outland = "外域",
	["Pit of Saron"] = "薩倫之淵",
	["Plaguelands: The Scarlet Enclave"] = "東瘟疫之地: 血色領區",
	Plaguewood = "病木林",
	["Quel'thalas"] = "奎爾薩拉斯",
	["Ragefire Chasm"] = "怒焰裂谷",
	Ratchet = "棘齒城",
	["Razorfen Downs"] = "剃刀高地",
	["Razorfen Kraul"] = "剃刀沼澤",
	["Redridge Mountains"] = "赤脊山",
	["Ring of Observance"] = "儀式競技場",
	["Rivendark's Perch"] = "瑞文達科棲所",
	["Ruins of Ahn'Qiraj"] = "安其拉廢墟",
	["Ruins of Lordaeron"] = "羅德隆廢墟",
	["Scalebeard's Cave"] = "鱗鬚洞穴",
	["Scarlet Monastery"] = "血色修道院",
	Scholomance = "通靈學院",
	["Searing Gorge"] = "灼熱峽谷",
	["Serpent Lake"] = "毒蛇之湖",
	["Serpentshrine Cavern"] = "毒蛇神殿洞穴",
	["Sethekk Halls"] = "塞司克大廳",
	["Shadowfang Keep"] = "影牙城堡",
	["Shadow Labyrinth"] = "暗影迷宮",
	["Shadowmoon Valley"] = "影月谷",
	["Shartuul's Transporter"] = "夏圖歐的傳送門",
	Shattrath = "撒塔斯城",
	["Shattrath City"] = "撒塔斯城",
	["Sholazar Basin"] = "休拉薩盆地",
	Silithus = "希利蘇斯",
	["Silvermoon City"] = "銀月城",
	["Silverpine Forest"] = "銀松森林",
	["Skyguard Outpost"] = "禦天者崗哨",
	["Skysong Lake"] = "天歌湖",
	["Sporewind Lake"] = "孢子風之湖",
	Stonard = "斯通納德",
	["Stonetalon Mountains"] = "石爪山脈",
	Stormwind = "暴風城",
	["Stormwind City"] = "暴風城",
	["Strand of the Ancients"] = "遠祖灘頭",
	["Stranglethorn Vale"] = "荊棘谷",
	Stratholme = "斯坦索姆",
	["Sunken Temple"] = "沉沒的神廟",
	["Sunwell Plateau"] = "太陽之井高地",
	["Swamp of Sorrows"] = "悲傷沼澤",
	Tanaris = "塔納利斯",
	Teldrassil = "泰達希爾",
	["Tempest Keep"] = "風暴要塞",
	["Temple of Ahn'Qiraj"] = "安其拉神廟",
	["Terokkar Forest"] = "泰洛卡森林",
	["Terokk's Rest"] = "泰洛克之墓",
	["The Arachnid Quarter"] = "蜘蛛區",
	["The Arcatraz"] = "亞克崔茲",
	["The Argent Coliseum"] = "銀白大競技場",
	["The Barrens"] = "貧瘠之地",
	["The Black Morass"] = "黑色沼澤",
	["The Blood Furnace"] = "血熔爐",
	["The Bone Wastes"] = "白骨荒野",
	["The Botanica"] = "波塔尼卡",
	["The Construct Quarter"] = "傀儡區",
	["The Culling of Stratholme"] = "斯坦索姆的抉擇",
	["The Dark Portal"] = "黑暗之門",
	["The Deadmines"] = "死亡礦坑",
	["The Descent into Madness"] = "驟狂斜廊",
	["The Exodar"] = "艾克索達",
	["The Eye"] = "風暴要塞",
	["The Eye of Eternity"] = "永恆之眼",
	["The Forbidding Sea"] = "禁忌之海",
	["The Forge of Souls"] = "眾魂熔爐",
	["The Frozen Halls"] = "冰封大廳",
	["The Frozen Sea"] = "冰凍之海",
	["The Great Sea"] = "無盡之海",
	["The Halls of Winter"] = "凜冬之廳",
	["The Hinterlands"] = "辛特蘭",
	["The Mechanar"] = "麥克納爾",
	["The Military Quarter"] = "軍事區",
	["The Nexus"] = "奧核之心",
	["The North Sea"] = "北海",
	["The Obsidian Sanctum"] = "黑曜聖所",
	["The Oculus"] = "奧核之眼",
	["The Plague Quarter"] = "瘟疫區",
	["The Prison of Yogg-Saron"] = "尤格薩倫之獄",
	["Theramore Isle"] = "塞拉摩島",
	["The Ring of Valor"] = "勇武之環",
	["The Ruby Sanctum"] = "晶紅聖所",
	["The Scarlet Enclave"] = "血色領區",
	["The Shattered Halls"] = "破碎大廳",
	["The Slave Pens"] = "奴隸監獄",
	["The Spark of Imagination"] = "創思之廳",
	["The Steamvault"] = "蒸汽洞窟",
	["The Stockade"] = "監獄",
	["The Storm Peaks"] = "風暴群山",
	["The Temple of Atal'Hakkar"] = "阿塔哈卡神廟",
	["The Underbog"] = "深幽泥沼",
	["The Veiled Sea"] = "迷霧之海",
	["The Violet Hold"] = "紫羅蘭堡",
	["Thousand Needles"] = "千針石林",
	["Thunder Bluff"] = "雷霆崖",
	Tirisfal = "提里斯法林地",
	["Tirisfal Glades"] = "提里斯法林地",
	["Trial of the Champion"] = "勇士試煉",
	["Trial of the Crusader"] = "十字軍試煉",
	["Twisting Nether"] = "扭曲虛空",
	Uldaman = "奧達曼",
	Ulduar = "奧杜亞",
	Undercity = "幽暗城",
	["Un'Goro Crater"] = "安戈洛環形山",
	["Upper Blackrock Spire"] = "黑石塔上層",
	["Utgarde Keep"] = "俄特加德要塞",
	["Utgarde Pinnacle"] = "俄特加德之巔",
	["Vault of Archavon"] = "亞夏梵穹殿",
	["Vortex Pinnacle"] = "漩渦尖塔",
	["Wailing Caverns"] = "哀嚎洞穴",
	["Warsong Gulch"] = "戰歌峽谷",
	["Western Plaguelands"] = "西瘟疫之地",
	Westfall = "西部荒野",
	Wetlands = "濕地",
	Wintergrasp = "冬握湖",
	Winterspring = "冬泉谷",
	["Wyrmrest Temple"] = "龍眠神殿",
	Zangarmarsh = "贊格沼澤",
	["Zul'Aman"] = "祖阿曼",
	["Zul'Drak"] = "祖爾德拉克",
	["Zul'Farrak"] = "祖爾法拉克",
	["Zul'Gurub"] = "祖爾格拉布",
}

else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
