--[[
	This file keeps track of aura duration and debuff type.

	lib.spellDuration:		[spellID] = duration

	lib.spellDebuffType:	[spellID] = debuffType
	debuffTypes: Magic = 1,	Disease = 2, Poison = 3, Curse = 4, Enrage = 5, Invisibility = 6
]]

local lib = LibStub("LibAuraInfo-1.0-ElvUI")
if not lib then error("spellIdData.lua for LibAuraInfo needs library loaded.") return end
if lib.spellDuration then return end

lib.spellDuration = {
	[10]	= 8,	-- Blizzard
	[17]	= 30,	-- Power Word: Shield
	[66]	= 3,	-- Invisibility
	[67]	= 10,	-- Vindication (Rank 1)
	[71]	= 0,	-- Defensive Stance
	[99]	= 30,	-- Demoralizing Roar (Rank 1)
	[113]	= 15,	-- Chains of Ice (Rank 1)
	[116]	= 8,	-- Frostbolt (Rank 1)
	[118]	= 50,	-- Polymorph (Rank 1)
	[120]	= 8,	-- Cone of Cold (Rank 1)
	[122]	= 8,	-- Frost Nova (Rank 1)
	[126]	= 45,	-- Eye of Kilrogg (Summon)
	[130]	= 30,	-- Slow Fall
	[131]	= 600,	-- Water Breathing
	[132]	= 600,	-- Detect Invisibility
	[133]	= 4,	-- Fireball (Rank 1)
	[136]	= 10,	-- Mend Pet
	[139]	= 15,	-- Renew (Rank 1)
	[168]	= 1800,	-- Frost Armor (Rank 1)
	[172]	= 12,	-- Corruption (Rank 1)
	[324]	= 600,	-- Lightning Shield (Rank 1)
	[325]	= 600,	-- Lightning Shield (Rank 2)
	[339]	= 27,	-- Entangling Roots (Rank 1)
	[348]	= 15,	-- Immolate (Rank 1)
	[355]	= 3,	-- Taunt
	[408]	= 1,	-- Kidney Shot (Rank 1)
	[430]	= 18,	-- Drink
	[431]	= 21,	-- Drink
	[432]	= 24,	-- Drink
	[434]	= 21,	-- Food
	[435]	= 24,	-- Food
	[453]	= 15,	-- Mind Soothe
	[465]	= 0,	-- Devotion Aura (Rank 1)
	[467]	= 600,	-- Thorns (Rank 1)
	[469]	= 120,	-- Commanding Shout (Rank 1)
	[498]	= 12,	-- Divine Protection
	[543]	= 30,	-- Fire Ward (Rank 1)
	[546]	= 600,	-- Water Walking
	[552]	= 12,	-- Abolish Disease
	[580]	= 0,	-- Timber Wolf
	[586]	= 10,	-- Fade
	[588]	= 1800,	-- Inner Fire (Rank 1)
	[589]	= 18,	-- Shadow Word: Pain (Rank 1)
	[592]	= 30,	-- Power Word: Shield (Rank 2)
	[594]	= 18,	-- Shadow Word: Pain (Rank 2)
	[600]	= 30,	-- Power Word: Shield (Rank 3)
	[602]	= 1800,	-- Inner Fire (Rank 3)
	[603]	= 60,	-- Bane of Doom
	[604]	= 600,	-- Dampen Magic (Rank 1)
	[605]	= 60,	-- Mind Control
	[642]	= 12,	-- Divine Shield
	[643]	= 0,	-- Devotion Aura (Rank 3)
	[673]	= 3600,	-- Lesser Armor
	[676]	= 10,	-- Disarm
	[687]	= 1800,	-- Demon Skin (Rank 1)
	[689]	= 5,	-- Drain Life (Rank 1)
	[694]	= 6,	-- Mocking Blow
	[696]	= 1800,	-- Demon Skin (Rank 2)
	[699]	= 5,	-- Drain Life (Rank 2)
	[700]	= 20,	-- Sleep (Rank 1)
	[702]	= 120,	-- Curse of Weakness (Rank 1)
	[703]	= 18,	-- Garrote (Rank 1)
	[706]	= 1800,	-- Demon Armor (Rank 1)
	[707]	= 15,	-- Immolate (Rank 2)
	[709]	= 5,	-- Drain Life (Rank 3)
	[710]	= 20,	-- Banish (Rank 1)
	[740]	= 8,	-- Tranquility (Rank 1)
	[744]	= 30,	-- Poison
	[745]	= 5,	-- Web
	[746]	= 6,	-- First Aid
	[755]	= 10,	-- Health Funnel (Rank 1)
	[768]	= 0,	-- Cat Form (Shapeshift)
	[770]	= 300,	-- Faerie Fire
	[774]	= 15,	-- Rejuvenation (Rank 1)
	[782]	= 600,	-- Thorns (Rank 2)
	[783]	= 0,	-- Travel Form (Shapeshift)
	[837]	= 6,	-- Frostbolt (Rank 3)
	[853]	= 3,	-- Hammer of Justice (Rank 1)
	[865]	= 8,	-- Frost Nova (Rank 2)
	[871]	= 12,	-- Shield Wall
	[879]	= 6,	-- Exorcism
	[905]	= 600,	-- Lightning Shield (Rank 3)
	[945]	= 600,	-- Lightning Shield (Rank 4)
	[970]	= 18,	-- Shadow Word: Pain (Rank 3)
	[974]	= 600,	-- Earth Shield
	[976]	= 600,	-- Shadow Protection (Rank 1)
	[980]	= 24,	-- Curse of Agony (Rank 1)
	[982]	= 3,	-- Revive Pet
	[992]	= 18,	-- Shadow Word: Pain (Rank 4)
	[1002]	= 60,	-- Eyes of the Beast
	[1006]	= 1800,	-- Inner Fire (Rank 4)
	[1008]	= 600,	-- Amplify Magic (Rank 1)
	[1014]	= 24,	-- Curse of Agony (Rank 2)
	[1022]	= 10,	-- Hand of Protection
	[1032]	= 0,	-- Devotion Aura (Rank 5)
	[1038]	= 10,	-- Hand of Salvation
	[1044]	= 6,	-- Hand of Freedom
	[1062]	= 15,	-- Entangling Roots (Rank 2)
	[1066]	= 0,	-- Aquatic Form (Shapeshift)
	[1075]	= 600,	-- Thorns (Rank 3)
	[1079]	= 12,	-- Rip (Rank 1)
	[1086]	= 1800,	-- Demon Armor (Rank 2)
	[1094]	= 15,	-- Immolate (Rank 3)
	[1108]	= 120,	-- Curse of Weakness (Rank 2)
	[1120]	= 15,	-- Drain Soul (Rank 1)
	[1126]	= 1800,	-- Mark of the Wild (Rank 1)
	[1127]	= 27,	-- Food
	[1129]	= 30,	-- Food
	[1130]	= 300,	-- Hunter's Mark (Rank 1)
	[1133]	= 27,	-- Drink
	[1134]	= 15,	-- Inner Rage
	[1135]	= 30,	-- Drink
	[1137]	= 30,	-- Drink
	[1159]	= 6,	-- First Aid (Rank 2)
	[1160]	= 30,	-- Demoralizing Shout (Rank 1)
	[1161]	= 6,	-- Challenging Shout
	[1243]	= 1800,	-- Power Word: Fortitude (Rank 1)
	[1244]	= 1800,	-- Power Word: Fortitude (Rank 2)
	[1245]	= 1800,	-- Power Word: Fortitude (Rank 3)
	[1330]	= 3,	-- Garrote - Silence
	[1430]	= 15,	-- Rejuvenation (Rank 3)
	[1459]	= 1800,	-- Arcane Intellect (Rank 1)
	[1460]	= 1800,	-- Arcane Intellect (Rank 2)
	[1461]	= 1800,	-- Arcane Intellect (Rank 3)
	[1463]	= 60,	-- Mana Shield (Rank 1)
	[1490]	= 300,	-- Curse of the Elements (Rank 1)
	[1513]	= 20,	-- Scare Beast (Rank 1)
	[1539]	= 10,	-- Feed Pet
	[1543]	= 0,	-- Flare
	[1604]	= 4,	-- Dazed
	[1706]	= 120,	-- Levitate
	[1714]	= 30,	-- Curse of Tongues
	[1715]	= 15,	-- Hamstring
	[1719]	= 12,	-- Recklessness
	[1735]	= 30,	-- Demoralizing Roar (Rank 2)
	[1742]	= 6,	-- Cower
	[1776]	= 4,	-- Gouge
	[1784]	= 0,	-- Stealth
	[1822]	= 9,	-- Rake (Rank 1)
	[1823]	= 9,	-- Rake (Rank 2)
	[1833]	= 4,	-- Cheap Shot
	[1850]	= 15,	-- Dash (Rank 1)
	[1943]	= 16,	-- Rupture (Rank 1)
	[1949]	= 15,	-- Hellfire
	[1953]	= 1,	-- Blink
	[1978]	= 15,	-- Serpent Sting
	[2048]	= 240,	-- Battle Shout (Rank 8)
	[2070]	= 35,	-- Sap (Rank 2)
	[2090]	= 15,	-- Rejuvenation (Rank 4)
	[2091]	= 15,	-- Rejuvenation (Rank 5)
	[2094]	= 10,	-- Blind
	[2367]	= 3600,	-- Lesser Strength
	[2374]	= 3600,	-- Lesser Agility
	[2378]	= 3600,	-- Health
	[2457]	= 0,	-- Battle Stance
	[2458]	= 0,	-- Berserker Stance
	[2479]	= 30,	-- Honorless Target
	[2565]	= 10,	-- Shield Block
	[2584]	= 0,	-- Waiting to Resurrect
	[2601]	= 30,	-- Fire Shield III
	[2602]	= 15,	-- Fire Shield IV
	[2645]	= 0,	-- Ghost Wolf
	[2767]	= 18,	-- Shadow Word: Pain (Rank 5)
	[2791]	= 1800,	-- Power Word: Fortitude (Rank 4)
	[2812]	= 3,	-- Holy Wrath
	[2818]	= 12,	-- Deadly Poison (Rank 1)
	[2819]	= 12,	-- Deadly Poison II (Rank 2)
	[2825]	= 40,	-- Bloodlust
	[2893]	= 12,	-- Abolish Poison
	[2895]	= 0,	-- Wrath of Air Totem
	[2941]	= 15,	-- Immolate (Rank 4)
	[2944]	= 24,	-- Devouring Plague (Rank 1)
	[2947]	= 180,	-- Fire Shield (Rank 1)
	[2974]	= 10,	-- Wing Clip
	[2983]	= 15,	-- Sprint (Rank 1)
	[3034]	= 8,	-- Viper Sting
	[3043]	= 20,	-- Scorpid Sting
	[3045]	= 15,	-- Rapid Fire
	[3140]	= 8,	-- Fireball (Rank 4)
	[3166]	= 3600,	-- Lesser Intellect
	[3219]	= 3600,	-- Weak Troll's Blood Elixir
	[3220]	= 3600,	-- Armor
	[3222]	= 7200,	-- Strong Troll's Blood Elixir
	[3248]	= 6,	-- Improved Blocking
	[3256]	= 240,	-- Plague Cloud
	[3267]	= 7,	-- First Aid (Rank 3)
	[3355]	= 20,	-- Freezing Trap Effect (Rank 1)
	[3356]	= 45,	-- Flame Lash
	[3409]	= 12,	-- Crippling Poison
	[3419]	= 6,	-- Improved Blocking
	[3427]	= 30,	-- Infected Wound
	[3436]	= 300,	-- Wandering Plague
	[3439]	= 300,	-- Wandering Plague
	[3583]	= 60,	-- Deadly Poison
	[3593]	= 3600,	-- Elixir of Fortitude
	[3600]	= 5,	-- Earthbind
	[3603]	= 15,	-- Distracting Pain
	[3604]	= 8,	-- Tendon Rip
	[3627]	= 15,	-- Rejuvenation (Rank 6)
	[3639]	= 6,	-- Improved Blocking
	[3661]	= 15,	-- Mend Pet (Rank 3)
	[3662]	= 15,	-- Mend Pet (Rank 4)
	[3674]	= 15,	-- Black Arrow
	[3698]	= 10,	-- Health Funnel (Rank 2)
	[3699]	= 7,	-- Health Funnel (Rank 3)
	[3700]	= 10,	-- Health Funnel (Rank 4)
	[3714]	= 600,	-- Path of Frost
	[3742]	= 15,	-- Static Electricity
	[3747]	= 30,	-- Power Word: Shield (Rank 4)
	[3815]	= 45,	-- Poison Cloud
	[4167]	= 4,	-- Web (Rank 1)
	[4318]	= 1800,	-- Guile of the Raptor
	[4511]	= 0,	-- Phase Shift
	[5005]	= 21,	-- Food
	[5115]	= 6,	-- Battle Command
	[5116]	= 4,	-- Concussive Shot
	[5118]	= 0,	-- Aspect of the Cheetah
	[5137]	= 60,	-- Call of the Grave
	[5138]	= 5,	-- Drain Mana
	[5159]	= 20,	-- Melt Ore
	[5171]	= 12,	-- Slice and Dice (Rank 1)
	[5195]	= 18,	-- Entangling Roots (Rank 3)
	[5196]	= 21,	-- Entangling Roots (Rank 4)
	[5209]	= 6,	-- Challenging Roar
	[5211]	= 2,	-- Bash (Rank 1)
	[5213]	= 15,	-- Molten Metal
	[5215]	= 0,	-- Prowl
	[5217]	= 6,	-- Tiger's Fury (Rank 1)
	[5225]	= 0,	-- Track Humanoids
	[5229]	= 10,	-- Enrage
	[5232]	= 1800,	-- Mark of the Wild (Rank 2)
	[5234]	= 1800,	-- Mark of the Wild (Rank 4)
	[5242]	= 120,	-- Battle Shout (Rank 2)
	[5246]	= 8,	-- Intimidating Shout
	[5262]	= 10,	-- Fanatic Blade
	[5277]	= 15,	-- Evasion (Rank 1)
	[5280]	= 45,	-- Razor Mane (Rank 1)
	[5384]	= 360,	-- Feign Death
	[5403]	= 6,	-- Crash of Waves
	[5413]	= 120,	-- Noxious Catalyst
	[5484]	= 6,	-- Howl of Terror (Rank 1)
	[5487]	= 0,	-- Bear Form (Shapeshift)
	[5570]	= 12,	-- Insect Swarm
	[5588]	= 4,	-- Hammer of Justice (Rank 2)
	[5589]	= 5,	-- Hammer of Justice (Rank 3)
	[5599]	= 8,	-- Hand of Protection (Rank 2)
	[5677]	= 0,	-- Mana Spring (Rank 1)
	[5697]	= 600,	-- Unending Breath
	[5740]	= 8,	-- Rain of Fire
	[5760]	= 10,	-- Mind-numbing Poison
	[5782]	= 10,	-- Fear (Rank 1)
	[5784]	= 0,	-- Felsteed (Summon)
	[5916]	= 0,	-- Shadowstalker Stealth
	[6016]	= 20,	-- Pierce Armor
	[6065]	= 30,	-- Power Word: Shield (Rank 5)
	[6066]	= 30,	-- Power Word: Shield (Rank 6)
	[6074]	= 15,	-- Renew (Rank 2)
	[6075]	= 15,	-- Renew (Rank 3)
	[6076]	= 15,	-- Renew (Rank 4)
	[6077]	= 12,	-- Renew (Rank 5)
	[6078]	= 15,	-- Renew (Rank 6)
	[6114]	= 300,	-- Raptor Punch
	[6117]	= 1800,	-- Mage Armor (Rank 1)
	[6131]	= 8,	-- Frost Nova (Rank 3)
	[6136]	= 5,	-- Chilled (Rank 1)
	[6143]	= 30,	-- Frost Ward (Rank 1)
	[6146]	= 15,	-- Slow (Rank 2)
	[6150]	= 12,	-- Quick Shots
	[6190]	= 30,	-- Demoralizing Shout (Rank 2)
	[6192]	= 120,	-- Battle Shout (Rank 3)
	[6196]	= 0,	-- Far Sight
	[6205]	= 120,	-- Curse of Weakness (Rank 3)
	[6213]	= 15,	-- Fear (Rank 2)
	[6215]	= 20,	-- Fear (Rank 3)
	[6217]	= 24,	-- Curse of Agony (Rank 3)
	[6222]	= 15,	-- Corruption (Rank 2)
	[6223]	= 18,	-- Corruption (Rank 3)
	[6229]	= 30,	-- Shadow Ward
	[6253]	= 2,	-- Backhand
	[6268]	= 3,	-- Rushing Charge (Rank 1)
	[6278]	= 60,	-- Creeping Mold
	[6306]	= 30,	-- Acid Splash
	[6307]	= 0,	-- Blood Pact (Rank 1)
	[6343]	= 10,	-- Thunder Clap (Rank 1)
	[6346]	= 180,	-- Fear Ward
	[6358]	= 15,	-- Seduction
	[6432]	= 10,	-- Smite Stomp
	[6466]	= 3,	-- Axe Toss
	[6524]	= 2,	-- Ground Tremor
	[6533]	= 2,	-- Net
	[6546]	= 15,	-- Rend (Rank 2)
	[6547]	= 15,	-- Rend (Rank 3)
	[6548]	= 15,	-- Rend (Rank 4)
	[6562]	= 0,	-- Heroic Presence (Racial Passive)
	[6653]	= 0,	-- Dire Wolf
	[6673]	= 120,	-- Battle Shout (Rank 1)
	[6713]	= 5,	-- Disarm
	[6726]	= 5,	-- Silence
	[6728]	= 10,	-- Enveloping Winds (Rank 1)
	[6742]	= 30,	-- Bloodlust
	[6756]	= 1800,	-- Mark of the Wild (Rank 3)
	[6770]	= 60,	-- Sap (Rank 1)
	[6774]	= 6,	-- Slice and Dice (Rank 2)
	[6788]	= 15,	-- Weakened Soul
	[6789]	= 3,	-- Death Coil (Rank 1)
	[6793]	= 6,	-- Tiger's Fury (Rank 2)
	[6795]	= 3,	-- Growl
	[6940]	= 12,	-- Hand of Sacrifice
	[6950]	= 60,	-- Faerie Fire
	[7038]	= 60,	-- Forsaken Skill: Swords
	[7039]	= 60,	-- Forsaken Skill: Axes
	[7040]	= 60,	-- Forsaken Skill: Daggers
	[7041]	= 60,	-- Forsaken Skill: Maces
	[7042]	= 60,	-- Forsaken Skill: Staves
	[7044]	= 60,	-- Forsaken Skill: Guns
	[7045]	= 60,	-- Forsaken Skill: 2H Axes
	[7046]	= 60,	-- Forsaken Skill: 2H Maces
	[7047]	= 60,	-- Forsaken Skill: 2H Swords
	[7049]	= 60,	-- Forsaken Skill: Fire
	[7051]	= 60,	-- Forsaken Skill: Holy
	[7053]	= 60,	-- Forsaken Skill: Shadow
	[7054]	= 300,	-- Forsaken Skills
	[7057]	= 300,	-- Haunting Spirits
	[7068]	= 15,	-- Veil of Shadow
	[7072]	= 60,	-- Wild Rage
	[7074]	= 5,	-- Screams of the Past
	[7121]	= 10,	-- Anti-Magic Shield
	[7124]	= 300,	-- Arugal's Gift
	[7125]	= 120,	-- Toxic Saliva
	[7127]	= 60,	-- Wavering Will
	[7128]	= 1800,	-- Inner Fire (Rank 2)
	[7140]	= 5,	-- Expose Weakness
	[7178]	= 1800,	-- Water Breathing (Rank 1)
	[7294]	= 0,	-- Retribution Aura (Rank 1)
	[7295]	= 10,	-- Soul Drain
	[7300]	= 1800,	-- Frost Armor (Rank 2)
	[7301]	= 1800,	-- Frost Armor (Rank 3)
	[7302]	= 1800,	-- Ice Armor (Rank 1)
	[7320]	= 1800,	-- Ice Armor (Rank 2)
	[7321]	= 5,	-- Chilled (Rank 1)
	[7322]	= 7,	-- Frostbolt (Rank 4)
	[7353]	= 60,	-- Cozy Fire
	[7389]	= 15,	-- Attack
	[7399]	= 4,	-- Terrify
	[7481]	= 300,	-- Howling Rage
	[7483]	= 300,	-- Howling Rage
	[7484]	= 300,	-- Howling Rage
	[7621]	= 10,	-- Arugal's Curse
	[7648]	= 18,	-- Corruption (Rank 4)
	[7651]	= 5,	-- Drain Life (Rank 4)
	[7739]	= 10,	-- Inferno Shell
	[7744]	= 0,	-- Will of the Forsaken (Racial)
	[7804]	= 0,	-- Blood Pact (Rank 2)
	[7805]	= 0,	-- Blood Pact (Rank 3)
	[7812]	= 30,	-- Sacrifice (Rank 1)
	[7844]	= 3600,	-- Fire Power
	[7870]	= 300,	-- Lesser Invisibility
	[7922]	= 2,	-- Charge Stun (1.5 seconds)
	[7947]	= 60,	-- Localized Toxin
	[7948]	= 20,	-- Wild Regeneration
	[7964]	= 4,	-- Smoke Bomb
	[7966]	= 60,	-- Thorns Aura
	[7992]	= 24,	-- Slowing Poison
	[8034]	= 8,	-- Frostbrand Attack
	[8040]	= 15,	-- Druid's Slumber
	[8041]	= 10,	-- Serpent Form (Shapeshift)
	[8042]	= 8,	-- Earth Shock (Rank 1)
	[8045]	= 8,	-- Earth Shock (Rank 3)
	[8046]	= 8,	-- Earth Shock (Rank 4)
	[8050]	= 18,	-- Flame Shock (Rank 1)
	[8052]	= 18,	-- Flame Shock (Rank 2)
	[8053]	= 18,	-- Flame Shock (Rank 3)
	[8056]	= 8,	-- Frost Shock (Rank 1)
	[8058]	= 8,	-- Frost Shock (Rank 2)
	[8066]	= 120,	-- Shrink
	[8068]	= 1800,	-- Healthy Spirit
	[8076]	= 0,	-- Strength of Earth (Rank 1)
	[8078]	= 10,	-- Thunderclap
	[8096]	= 1800,	-- Intellect (Rank 1)
	[8101]	= 1800,	-- Stamina (Level 3)
	[8112]	= 1800,	-- Spirit (Rank 1)
	[8117]	= 1800,	-- Agility (Rank 3)
	[8119]	= 1800,	-- Strength (Rank 2)
	[8122]	= 8,	-- Psychic Scream
	[8134]	= 600,	-- Lightning Shield (Rank 5)
	[8140]	= 15,	-- Befuddlement (Rank 1)
	[8148]	= 0,	-- Thorns Aura
	[8153]	= 0,	-- Owl Form (Shapeshift)
	[8156]	= 0,	-- Stoneskin (Rank 2)
	[8157]	= 0,	-- Stoneskin (Rank 3)
	[8162]	= 0,	-- Strength of Earth (Rank 2)
	[8163]	= 0,	-- Strength of Earth (Rank 3)
	[8178]	= 0,	-- Grounding Totem Effect (Rank 1)
	[8185]	= 0,	-- Elemental Resistance
	[8198]	= 14,	-- Thunder Clap (Rank 2)
	[8202]	= 1200,	-- Sapta Sight
	[8204]	= 18,	-- Thunder Clap (Rank 3)
	[8205]	= 22,	-- Thunder Clap (Rank 4)
	[8212]	= 1200,	-- Enlarge
	[8219]	= 3600,	-- Flip Out
	[8220]	= 3600,	-- Flip Out
	[8221]	= 3600,	-- Yaaarrrr
	[8222]	= 3600,	-- Yaaarrrr
	[8242]	= 2,	-- Shield Slam
	[8258]	= 240,	-- Devotion Aura
	[8263]	= 0,	-- Elemental Protection Totem Aura (Rank 1)
	[8267]	= 600,	-- Cursed Blood
	[8269]	= 120,	-- Frenzy
	[8272]	= 600,	-- Mind Tremor
	[8275]	= 75,	-- Poisoned Shot
	[8281]	= 6,	-- Sonic Burst
	[8282]	= 120,	-- Curse of Blood
	[8285]	= 3,	-- Rampage
	[8288]	= 15,	-- Drain Soul (Rank 2)
	[8289]	= 15,	-- Drain Soul (Rank 3)
	[8314]	= 3600,	-- Rock Skin
	[8316]	= 180,	-- Fire Shield (Rank 2)
	[8317]	= 180,	-- Fire Shield (Rank 3)
	[8326]	= 0,	-- Ghost
	[8362]	= 20,	-- Renew
	[8365]	= 10,	-- Enlarge
	[8377]	= 4,	-- Earthgrab
	[8379]	= 10,	-- Disarm
	[8382]	= 45,	-- Leech Poison
	[8385]	= 3600,	-- Swift Wind
	[8391]	= 3,	-- Ravage
	[8395]	= 0,	-- Emerald Raptor
	[8398]	= 8,	-- Frostbolt Volley
	[8399]	= 10,	-- Sleep
	[8402]	= 8,	-- Fireball (Rank 7)
	[8406]	= 7,	-- Frostbolt (Rank 5)
	[8407]	= 8,	-- Frostbolt (Rank 6)
	[8408]	= 8,	-- Frostbolt (Rank 7)
	[8450]	= 600,	-- Dampen Magic (Rank 2)
	[8451]	= 600,	-- Dampen Magic (Rank 3)
	[8455]	= 600,	-- Amplify Magic (Rank 2)
	[8492]	= 8,	-- Cone of Cold (Rank 2)
	[8495]	= 60,	-- Mana Shield (Rank 3)
	[8515]	= 0,	-- Windfury Totem (Rank 1)
	[8599]	= 120,	-- Enrage
	[8600]	= 180,	-- Fevered Plague
	[8632]	= 18,	-- Garrote (Rank 3)
	[8633]	= 18,	-- Garrote (Rank 4)
	[8639]	= 16,	-- Rupture (Rank 2)
	[8640]	= 6,	-- Rupture (Rank 3)
	[8643]	= 6,	-- Kidney Shot (Rank 2)
	[8647]	= 6,	-- Expose Armor
	[8696]	= 15,	-- Sprint (Rank 2)
	[8733]	= 3600,	-- Blessing of Blackfathom
	[8788]	= 600,	-- Lightning Shield (Rank 4)
	[8898]	= 1200,	-- Sapta Sight
	[8907]	= 1800,	-- Mark of the Wild (Rank 5)
	[8910]	= 15,	-- Rejuvenation (Rank 7)
	[8914]	= 600,	-- Thorns (Rank 4)
	[8921]	= 12,	-- Moonfire
	[8925]	= 12,	-- Moonfire (Rank 3)
	[8926]	= 12,	-- Moonfire (Rank 4)
	[8927]	= 12,	-- Moonfire (Rank 5)
	[8928]	= 12,	-- Moonfire (Rank 6)
	[8929]	= 12,	-- Moonfire (Rank 7)
	[8936]	= 21,	-- Regrowth (Rank 1)
	[8938]	= 21,	-- Regrowth (Rank 2)
	[8939]	= 21,	-- Regrowth (Rank 3)
	[8940]	= 21,	-- Regrowth (Rank 4)
	[8941]	= 21,	-- Regrowth (Rank 5)
	[8983]	= 4,	-- Bash (Rank 3)
	[8988]	= 10,	-- Silence (Rank 1)
	[8990]	= 0,	-- Retribution Aura (Rank 1)
	[9005]	= 3,	-- Pounce
	[9007]	= 18,	-- Pounce Bleed (Rank 1)
	[9034]	= 21,	-- Immolate
	[9080]	= 10,	-- Hamstring
	[9128]	= 120,	-- Battle Shout
	[9256]	= 10,	-- Deep Sleep
	[9275]	= 21,	-- Immolate
	[9438]	= 8,	-- Arcane Bubble
	[9459]	= 60,	-- Corrosive Ooze
	[9482]	= 30,	-- Amplify Flames
	[9484]	= 30,	-- Shackle Undead (Rank 1)
	[9485]	= 40,	-- Shackle Undead (Rank 2)
	[9490]	= 30,	-- Demoralizing Roar (Rank 3)
	[9492]	= 12,	-- Rip (Rank 2)
	[9493]	= 12,	-- Rip (Rank 3)
	[9634]	= 0,	-- Dire Bear Form (Shapeshift)
	[9672]	= 4,	-- Frostbolt
	[9747]	= 30,	-- Demoralizing Roar (Rank 4)
	[9750]	= 21,	-- Regrowth (Rank 6)
	[9756]	= 600,	-- Thorns (Rank 5)
	[9775]	= 60,	-- Irradiated
	[9798]	= 0,	-- Radiation
	[9821]	= 15,	-- Dash (Rank 2)
	[9833]	= 12,	-- Moonfire (Rank 8)
	[9839]	= 15,	-- Rejuvenation (Rank 8)
	[9840]	= 15,	-- Rejuvenation (Rank 9)
	[9856]	= 21,	-- Regrowth (Rank 7)
	[9884]	= 1800,	-- Mark of the Wild (Rank 6)
	[9885]	= 1800,	-- Mark of the Wild (Rank 7)
	[9896]	= 16,	-- Rip (Rank 6)
	[9904]	= 9,	-- Rake (Rank 4)
	[9906]	= 5,	-- Reflection
	[9910]	= 600,	-- Thorns (Rank 6)
	[10060]	= 15,	-- Power Infusion
	[10093]	= 1,	-- Harsh Winds
	[10156]	= 1800,	-- Arcane Intellect (Rank 4)
	[10157]	= 1800,	-- Arcane Intellect (Rank 5)
	[10159]	= 11,	-- Cone of Cold (Rank 3)
	[10160]	= 8,	-- Cone of Cold (Rank 4)
	[10170]	= 600,	-- Amplify Magic (Rank 4)
	[10173]	= 600,	-- Dampen Magic (Rank 4)
	[10174]	= 600,	-- Dampen Magic (Rank 5)
	[10179]	= 9,	-- Frostbolt (Rank 8)
	[10180]	= 9,	-- Frostbolt (Rank 9)
	[10219]	= 1800,	-- Ice Armor (Rank 3)
	[10220]	= 1800,	-- Ice Armor (Rank 4)
	[10278]	= 10,	-- Hand of Protection (Rank 3)
	[10290]	= 0,	-- Devotion Aura (Rank 2)
	[10291]	= 0,	-- Devotion Aura (Rank 4)
	[10292]	= 0,	-- Devotion Aura (Rank 6)
	[10293]	= 0,	-- Devotion Aura (Rank 7)
	[10298]	= 0,	-- Retribution Aura (Rank 2)
	[10299]	= 0,	-- Retribution Aura (Rank 3)
	[10300]	= 0,	-- Retribution Aura (Rank 4)
	[10301]	= 0,	-- Retribution Aura (Rank 5)
	[10308]	= 6,	-- Hammer of Justice (Rank 4)
	[10326]	= 20,	-- Turn Evil
	[10348]	= 20,	-- Tune Up
	[10403]	= 0,	-- Stoneskin (Rank 4)
	[10404]	= 0,	-- Stoneskin (Rank 5)
	[10405]	= 0,	-- Stoneskin (Rank 6)
	[10412]	= 8,	-- Earth Shock (Rank 5)
	[10413]	= 8,	-- Earth Shock (Rank 6)
	[10431]	= 600,	-- Lightning Shield (Rank 6)
	[10432]	= 600,	-- Lightning Shield (Rank 7)
	[10452]	= 20,	-- Flame Buffet
	[10458]	= 8,	-- Frostbrand Attack (Rank 3)
	[10491]	= 0,	-- Mana Spring (Rank 2)
	[10493]	= 0,	-- Mana Spring (Rank 3)
	[10494]	= 0,	-- Mana Spring (Rank 4)
	[10596]	= 0,	-- Nature Resistance (Rank 1)
	[10598]	= 0,	-- Nature Resistance (Rank 2)
	[10668]	= 3600,	-- Spirit of Boar
	[10730]	= 10,	-- Pacify
	[10732]	= 10,	-- Supercharge
	[10734]	= 3,	-- Hail Storm
	[10796]	= 0,	-- Turquoise Raptor
	[10799]	= 0,	-- Violet Raptor
	[10831]	= 5,	-- Reflection Field
	[10838]	= 8,	-- First Aid (Rank 7)
	[10890]	= 8,	-- Psychic Scream (Rank 4)
	[10892]	= 18,	-- Shadow Word: Pain (Rank 6)
	[10894]	= 18,	-- Shadow Word: Pain (Rank 8)
	[10898]	= 30,	-- Power Word: Shield (Rank 7)
	[10899]	= 30,	-- Power Word: Shield (Rank 8)
	[10901]	= 30,	-- Power Word: Shield (Rank 10)
	[10909]	= 60,	-- Mind Vision (Rank 2)
	[10927]	= 15,	-- Renew (Rank 7)
	[10937]	= 1800,	-- Power Word: Fortitude (Rank 5)
	[10938]	= 1800,	-- Power Word: Fortitude (Rank 6)
	[10951]	= 1800,	-- Inner Fire (Rank 5)
	[10952]	= 1800,	-- Inner Fire (Rank 6)
	[10955]	= 50,	-- Shackle Undead (Rank 3)
	[10957]	= 1200,	-- Shadow Protection (Rank 2)
	[10958]	= 600,	-- Shadow Protection (Rank 3)
	[11020]	= 8,	-- Petrify
	[11113]	= 6,	-- Blast Wave (Rank 1)
	[11131]	= 10,	-- Icicle
	[11196]	= 60,	-- Recently Bandaged
	[11264]	= 10,	-- Ice Blast
	[11273]	= 10,	-- Rupture (Rank 4)
	[11305]	= 15,	-- Sprint (Rank 3)
	[11327]	= 10,	-- Vanish (Rank 1)
	[11328]	= 3600,	-- Agility
	[11329]	= 10,	-- Vanish (Rank 2)
	[11334]	= 3600,	-- Greater Agility
	[11348]	= 3600,	-- Greater Armor
	[11349]	= 3600,	-- Armor
	[11366]	= 12,	-- Pyroblast (Rank 1)
	[11390]	= 3600,	-- Arcane Elixir
	[11396]	= 3600,	-- Greater Intellect
	[11397]	= 300,	-- Diseased Shot
	[11426]	= 60,	-- Ice Barrier (Rank 1)
	[11436]	= 10,	-- Slow
	[11442]	= 180,	-- Withered Touch
	[11443]	= 15,	-- Cripple
	[11445]	= 60,	-- Bone Armor
	[11538]	= 4,	-- Frostbolt
	[11549]	= 120,	-- Battle Shout (Rank 4)
	[11550]	= 120,	-- Battle Shout (Rank 5)
	[11551]	= 240,	-- Battle Shout (Rank 6)
	[11554]	= 30,	-- Demoralizing Shout (Rank 3)
	[11555]	= 30,	-- Demoralizing Shout (Rank 4)
	[11572]	= 15,	-- Rend (Rank 5)
	[11573]	= 15,	-- Rend (Rank 6)
	[11580]	= 26,	-- Thunder Clap (Rank 5)
	[11639]	= 18,	-- Shadow Word: Pain
	[11640]	= 15,	-- Renew
	[11641]	= 10,	-- Hex
	[11647]	= 30,	-- Power Word: Shield
	[11665]	= 15,	-- Immolate (Rank 5)
	[11671]	= 18,	-- Corruption (Rank 5)
	[11699]	= 5,	-- Drain Life (Rank 5)
	[11707]	= 120,	-- Curse of Weakness (Rank 5)
	[11711]	= 24,	-- Curse of Agony (Rank 4)
	[11712]	= 24,	-- Curse of Agony (Rank 5)
	[11719]	= 12,	-- Curse of Tongues (Rank 2)
	[11733]	= 1800,	-- Demon Armor (Rank 3)
	[11734]	= 1800,	-- Demon Armor (Rank 4)
	[11735]	= 1800,	-- Demon Armor (Rank 5)
	[11766]	= 0,	-- Blood Pact (Rank 4)
	[11767]	= 0,	-- Blood Pact (Rank 5)
	[11770]	= 180,	-- Fire Shield (Rank 4)
	[11820]	= 6,	-- Electrified Net
	[11841]	= 600,	-- Static Barrier
	[11876]	= 3,	-- War Stomp
	[11922]	= 15,	-- Entangling Roots
	[11962]	= 15,	-- Immolate
	[11971]	= 30,	-- Sunder Armor
	[11974]	= 30,	-- Power Word: Shield
	[11977]	= 15,	-- Rend
	[11980]	= 120,	-- Curse of Weakness
	[12024]	= 5,	-- Net
	[12040]	= 30,	-- Shadow Shield
	[12042]	= 15,	-- Arcane Power
	[12043]	= 0,	-- Presence of Mind
	[12051]	= 8,	-- Evocation
	[12096]	= 8,	-- Fear
	[12097]	= 20,	-- Pierce Armor
	[12098]	= 20,	-- Sleep
	[12169]	= 5,	-- Shield Block
	[12178]	= 1800,	-- Stamina (Level 4)
	[12245]	= 300,	-- Infected Spine
	[12248]	= 10,	-- Amplify Damage
	[12251]	= 30,	-- Virulent Poison
	[12255]	= 900,	-- Curse of Tuten'kash
	[12292]	= 30,	-- Death Wish
	[12294]	= 10,	-- Mortal Strike (Rank 1)
	[12323]	= 6,	-- Piercing Howl
	[12328]	= 30,	-- Sweeping Strikes
	[12355]	= 2,	-- Impact
	[12421]	= 2,	-- Mithril Frag Bomb
	[12461]	= 2,	-- Backhand
	[12472]	= 20,	-- Icy Veins
	[12479]	= 10,	-- Hex of Jammal'an
	[12484]	= 2,	-- Chilled (Rank 1)
	[12486]	= 2,	-- Chilled (Rank 3)
	[12493]	= 120,	-- Curse of Weakness
	[12494]	= 5,	-- Frostbite
	[12523]	= 12,	-- Pyroblast (Rank 4)
	[12528]	= 10,	-- Silence
	[12530]	= 60,	-- Frailty
	[12531]	= 8,	-- Chilling Touch
	[12536]	= 15,	-- Clearcasting
	[12540]	= 4,	-- Gouge
	[12541]	= 600,	-- Ghoul Rot
	[12544]	= 1800,	-- Frost Armor
	[12548]	= 8,	-- Frost Shock
	[12579]	= 15,	-- Winter's Chill
	[12611]	= 8,	-- Cone of Cold
	[12627]	= 0,	-- Disease Cloud
	[12654]	= 4,	-- Ignite
	[12721]	= 6,	-- Deep Wounds
	[12741]	= 120,	-- Curse of Weakness
	[12795]	= 120,	-- Frenzy
	[12809]	= 5,	-- Concussion Blow
	[12824]	= 30,	-- Polymorph (Rank 2)
	[12826]	= 10,	-- Polymorph (Rank 4)
	[12884]	= 45,	-- Acid Breath
	[12890]	= 15,	-- Deep Slumber
	[12891]	= 45,	-- Acid Breath
	[12946]	= 10,	-- Putrid Stench
	[12968]	= 15,	-- Flurry
	[12970]	= 15,	-- Flurry (Rank 5)
	[12976]	= 20,	-- Last Stand
	[13159]	= 0,	-- Aspect of the Pack
	[13161]	= 0,	-- Aspect of the Beast
	[13163]	= 0,	-- Aspect of the Monkey
	[13165]	= 0,	-- Aspect of the Hawk (Rank 1)
	[13218]	= 15,	-- Wound Poison (Rank 1)
	[13222]	= 15,	-- Wound Poison II (Rank 2)
	[13298]	= 30,	-- Poison
	[13326]	= 1800,	-- Arcane Intellect
	[13439]	= 5,	-- Frostbolt
	[13443]	= 15,	-- Rend
	[13445]	= 15,	-- Rend
	[13526]	= 30,	-- Corrosive Poison
	[13532]	= 10,	-- Thunder Clap (Rank 1)
	[13542]	= 15,	-- Mend Pet (Rank 5)
	[13549]	= 15,	-- Serpent Sting (Rank 2)
	[13550]	= 15,	-- Serpent Sting (Rank 3)
	[13551]	= 21,	-- Serpent Sting (Rank 4)
	[13552]	= 15,	-- Serpent Sting (Rank 5)
	[13553]	= 15,	-- Serpent Sting (Rank 6)
	[13555]	= 15,	-- Serpent Sting (Rank 8)
	[13704]	= 6,	-- Psychic Scream
	[13730]	= 30,	-- Demoralizing Shout
	[13750]	= 15,	-- Adrenaline Rush
	[13797]	= 15,	-- Immolation Trap (Rank 1)
	[13810]	= 0,	-- Frost Trap Aura
	[13812]	= 0,	-- Explosive Trap Effect (Rank 1)
	[13864]	= 1800,	-- Power Word: Fortitude
	[13877]	= 15,	-- Blade Flurry
	[14030]	= 6,	-- Hooked Net
	[14032]	= 18,	-- Shadow Word: Pain
	[14143]	= 20,	-- Remorseless (Rank 1)
	[14149]	= 20,	-- Remorseless (Rank 2)
	[14177]	= 0,	-- Cold Blood
	[14183]	= 20,	-- Premeditation
	[14201]	= 12,	-- Enrage (Rank 2)
	[14202]	= 9,	-- Enrage
	[14203]	= 12,	-- Enrage (Rank 4)
	[14251]	= 30,	-- Riposte
	[14267]	= 0,	-- Horde Flag
	[14268]	= 0,	-- Alliance Flag
	[14278]	= 7,	-- Ghostly Strike
	[14298]	= 15,	-- Immolation Trap (Rank 2)
	[14308]	= 20,	-- Freezing Trap Effect (Rank 2)
	[14309]	= 20,	-- Freezing Trap Effect (Rank 3)
	[14314]	= 0,	-- Explosive Trap Effect (Rank 2)
	[14318]	= 0,	-- Aspect of the Hawk (Rank 2)
	[14319]	= 0,	-- Aspect of the Hawk (Rank 3)
	[14320]	= 0,	-- Aspect of the Hawk (Rank 4)
	[14321]	= 0,	-- Aspect of the Hawk (Rank 5)
	[14322]	= 0,	-- Aspect of the Hawk (Rank 6)
	[14323]	= 300,	-- Hunter's Mark (Rank 2)
	[14324]	= 300,	-- Hunter's Mark (Rank 3)
	[14325]	= 120,	-- Hunter's Mark (Rank 4)
	[14515]	= 15,	-- Dominate Mind
	[14517]	= 30,	-- Crusader Strike
	[14518]	= 30,	-- Crusader Strike
	[14751]	= 0,	-- Inner Focus
	[14752]	= 1800,	-- Divine Spirit (Rank 1)
	[14818]	= 1800,	-- Divine Spirit (Rank 2)
	[14819]	= 1800,	-- Divine Spirit (Rank 3)
	[14893]	= 15,	-- Inspiration (Rank 1)
	[14914]	= 7,	-- Holy Fire (Rank 1)
	[15007]	= 600,	-- Resurrection Sickness (assuming level 20+)
	[15039]	= 12,	-- Flame Shock
	[15087]	= 15,	-- Evasion
	[15258]	= 15,	-- Shadow Weaving (Rank 1)
	[15262]	= 7,	-- Holy Fire (Rank 2)
	[15263]	= 7,	-- Holy Fire (Rank 3)
	[15265]	= 7,	-- Holy Fire (Rank 5)
	[15266]	= 7,	-- Holy Fire (Rank 6)
	[15271]	= 15,	-- Spirit Tap (Rank 1)
	[15286]	= 1800,	-- Vampiric Embrace
	[15357]	= 15,	-- Inspiration (Rank 2)
	[15359]	= 15,	-- Inspiration (Rank 3)
	[15407]	= 3,	-- Mind Flay (Rank 1)
	[15473]	= 0,	-- Shadowform
	[15487]	= 5,	-- Silence
	[15531]	= 8,	-- Frost Nova
	[15532]	= 8,	-- Frost Nova
	[15548]	= 10,	-- Thunderclap
	[15571]	= 4,	-- Dazed
	[15572]	= 30,	-- Sunder Armor
	[15588]	= 0,	-- Thunderclap
	[15708]	= 0,	-- Mortal Strike
	[15971]	= 30,	-- Demoralizing Roar
	[15976]	= 10,	-- Puncture
	[16166]	= 30,	-- Elemental Mastery
	[16177]	= 15,	-- Ancestral Fortitude (Rank 1)
	[16188]	= 0,	-- Nature's Swiftness
	[16191]	= 0,	-- Mana Tide
	[16236]	= 15,	-- Ancestral Fortitude (Rank 2)
	[16237]	= 15,	-- Ancestral Fortitude (Rank 3)
	[16244]	= 30,	-- Demoralizing Shout
	[16246]	= 15,	-- Clearcasting
	[16277]	= 15,	-- Flurry (Rank 2)
	[16278]	= 15,	-- Flurry
	[16280]	= 15,	-- Flurry (Rank 5)
	[16468]	= 0,	-- Mother's Milk
	[16488]	= 6,	-- Blood Craze
	[16490]	= 6,	-- Blood Craze
	[16491]	= 6,	-- Blood Craze
	[16509]	= 15,	-- Rend
	[16511]	= 15,	-- Hemorrhage (Rank 1)
	[16567]	= 600,	-- Tainted Mind
	[16591]	= 600,	-- Noggenfogger Elixir
	[16593]	= 15,	-- Noggenfogger Elixir
	[16595]	= 600,	-- Noggenfogger Elixir
	[16609]	= 3600,	-- Warchief's Blessing
	[16689]	= 45,	-- Nature's Grasp (Rank 1)
	[16711]	= 300,	-- Grow
	[16739]	= 300,	-- Orb of Deception
	[16810]	= 45,	-- Nature's Grasp (Rank 2)
	[16811]	= 45,	-- Nature's Grasp (Rank 3)
	[16812]	= 45,	-- Nature's Grasp (Rank 4)
	[16857]	= 300,	-- Faerie Fire (Feral)
	[16870]	= 15,	-- Clearcasting
	[16886]	= 3,	-- Nature's Grace
	[16914]	= 0,	-- Hurricane (Rank 1)
	[17038]	= 1200,	-- Winterfall Firewater
	[17057]	= 6,	-- Furor
	[17116]	= 0,	-- Nature's Swiftness
	[17154]	= 30,	-- The Green Tower (Rank 1)
	[17229]	= 0,	-- Winterspring Frostsaber
	[17311]	= 3,	-- Mind Flay (Rank 2)
	[17312]	= 3,	-- Mind Flay (Rank 3)
	[17347]	= 15,	-- Hemorrhage (Rank 2)
	[17364]	= 12,	-- Stormstrike
	[17462]	= 0,	-- Red Skeletal Horse
	[17463]	= 0,	-- Blue Skeletal Horse
	[17464]	= 0,	-- Brown Skeletal Horse
	[17465]	= 0,	-- Green Skeletal Warhorse
	[17481]	= 0,	-- Rivendare's Deathcharger
	[17535]	= 7200,	-- Elixir of the Sages
	[17537]	= 3600,	-- Elixir of Brute Force
	[17539]	= 7200,	-- Greater Arcane Elixir
	[17619]	= 0,	-- Alchemist's Stone
	[17627]	= 3600,	-- Distilled Wisdom
	[17628]	= 7200,	-- Supreme Power
	[17670]	= 0,	-- Argent Dawn Commission
	[17735]	= 5,	-- Suffering
	[17767]	= 6,	-- Consume Shadows
	[17800]	= 30,	-- Shadow Mastery
	[17928]	= 8,	-- Howl of Terror (Rank 2)
	[17941]	= 10,	-- Shadow Trance
	[17962]	= 6,	-- Conflagrate
	[18070]	= 30,	-- Earthborer Acid
	[18093]	= 10,	-- Pyroclasm
	[18118]	= 5,	-- Aftermath
	[18223]	= 12,	-- Curse of Exhaustion
	[18266]	= 15,	-- Curse of Agony
	[18267]	= 30,	-- Curse of Weakness
	[18381]	= 30,	-- Cripple (Rank 1)
	[18400]	= 0,	-- Piccolo of the Flaming Fire
	[18425]	= 2,	-- Silenced - Improved Kick
	[18469]	= 2,	-- Silenced - Improved Counterspell (Rank 1)
	[18498]	= 3,	-- Silenced - Gag Order
	[18499]	= 10,	-- Berserker Rage
	[18610]	= 8,	-- First Aid (Rank 10)
	[18647]	= 30,	-- Banish (Rank 2)
	[18657]	= 40,	-- Hibernate (Rank 2)
	[18658]	= 10,	-- Hibernate (Rank 3)
	[18708]	= 15,	-- Fel Domination
	[18972]	= 20,	-- Slow
	[18989]	= 0,	-- Gray Kodo
	[18990]	= 0,	-- Brown Kodo
	[19136]	= 0,	-- Stormbolt
	[19263]	= 5,	-- Deterrence
	[19276]	= 24,	-- Devouring Plague (Rank 2)
	[19277]	= 24,	-- Devouring Plague (Rank 3)
	[19278]	= 24,	-- Devouring Plague (Rank 4)
	[19306]	= 5,	-- Counterattack
	[19386]	= 6,	-- Wyvern Sting (Rank 1)
	[19434]	= 10,	-- Aimed Shot (Rank 1)
	[19440]	= 30,	-- Sacrifice (Rank 3)
	[19503]	= 4,	-- Scatter Shot
	[19506]	= 0,	-- Trueshot Aura
	[19574]	= 10,	-- Bestial Wrath
	[19577]	= 15,	-- Intimidation
	[19579]	= 0,	-- Spirit Bond (Rank 1)
	[19615]	= 8,	-- Frenzy Effect (Rank 1)
	[19683]	= 900,	-- Tame Armored Scorpid
	[19705]	= 900,	-- Well Fed
	[19706]	= 900,	-- Well Fed
	[19709]	= 900,	-- Well Fed
	[19710]	= 900,	-- Well Fed
	[19740]	= 600,	-- Blessing of Might (Rank 1)
	[19742]	= 600,	-- Blessing of Wisdom (Rank 1)
	[19746]	= 0,	-- Concentration Aura
	[19821]	= 5,	-- Arcane Bomb
	[19834]	= 600,	-- Blessing of Might (Rank 2)
	[19835]	= 600,	-- Blessing of Might (Rank 3)
	[19836]	= 600,	-- Blessing of Might (Rank 4)
	[19837]	= 600,	-- Blessing of Might (Rank 5)
	[19838]	= 1800,	-- Blessing of Might (Rank 6)
	[19850]	= 600,	-- Blessing of Wisdom (Rank 2)
	[19852]	= 600,	-- Blessing of Wisdom (Rank 3)
	[19853]	= 600,	-- Blessing of Wisdom (Rank 4)
	[19854]	= 600,	-- Blessing of Wisdom (Rank 5)
	[19876]	= 0,	-- Shadow Resistance Aura (Rank 1)
	[19883]	= 0,	-- Track Humanoids
	[19891]	= 0,	-- Fire Resistance Aura (Rank 1)
	[19895]	= 0,	-- Shadow Resistance Aura (Rank 2)
	[19897]	= 0,	-- Frost Resistance Aura (Rank 2)
	[19899]	= 0,	-- Fire Resistance Aura (Rank 2)
	[19972]	= 21,	-- Entangling Roots (Rank 4)
	[19973]	= 18,	-- Entangling Roots (Rank 3)
	[19974]	= 15,	-- Entangling Roots (Rank 2)
	[19975]	= 27,	-- Entangling Roots
	[20005]	= 5,	-- Chilled
	[20006]	= 12,	-- Unholy Curse
	[20007]	= 15,	-- Holy Strength
	[20043]	= 0,	-- Aspect of the Wild (Rank 1)
	[20050]	= 15,	-- Conviction
	[20052]	= 15,	-- Conviction
	[20053]	= 30,	-- Vengeance
	[20066]	= 60,	-- Repentance
	[20132]	= 10,	-- Redoubt
	[20154]	= 1800,	-- Seal of Righteousness
	[20164]	= 1800,	-- Seal of Justice
	[20165]	= 1800,	-- Seal of Light
	[20166]	= 1800,	-- Seal of Wisdom
	[20170]	= 2,	-- Stun
	[20178]	= 8,	-- Reckoning
	[20184]	= 20,	-- Judgement of Justice
	[20185]	= 20,	-- Judgement of Light (Rank 1)
	[20186]	= 20,	-- Judgement of Wisdom (Rank 1)
	[20216]	= 0,	-- Divine Favor
	[20217]	= 600,	-- Blessing of Kings
	[20230]	= 12,	-- Retaliation
	[20236]	= 15,	-- Lay on Hands (Rank 2)
	[20253]	= 3,	-- Intercept (Rank 1)
	[20375]	= 1800,	-- Seal of Command
	[20511]	= 8,	-- Intimidating Shout
	[20549]	= 2,	-- War Stomp (Racial)
	[20572]	= 15,	-- Blood Fury (Racial)
	[20578]	= 10,	-- Cannibalize
	[20615]	= 3,	-- Intercept (Rank 3)
	[20707]	= 900,	-- Soulstone Resurrection
	[20736]	= 6,	-- Distracting Shot
	[20762]	= 900,	-- Soulstone Resurrection
	[20763]	= 900,	-- Soulstone Resurrection
	[20765]	= 900,	-- Soulstone Resurrection
	[20798]	= 1800,	-- Demon Skin
	[20800]	= 21,	-- Immolate
	[20875]	= 900,	-- Rumsey Rum
	[20901]	= 10,	-- Aimed Shot (Rank 3)
	[20902]	= 10,	-- Aimed Shot (Rank 4)
	[20903]	= 10,	-- Aimed Shot (Rank 5)
	[20911]	= 600,	-- Blessing of Sanctuary
	[20925]	= 10,	-- Holy Shield (Rank 1)
	[20927]	= 10,	-- Holy Shield (Rank 2)
	[21007]	= 120,	-- Curse of Weakness
	[21049]	= 30,	-- Bloodlust
	[21062]	= 30,	-- Putrid Breath
	[21067]	= 10,	-- Poison Bolt
	[21068]	= 24,	-- Corruption
	[21069]	= 6,	-- Larva Goo
	[21084]	= 1800,	-- Seal of Righteousness
	[21163]	= 1800,	-- Polished Armor (Rank 1)
	[21183]	= 20,	-- Heart of the Crusader (Rank 1)
	[21331]	= 15,	-- Entangling Roots
	[21337]	= 600,	-- Thorns
	[21547]	= 5,	-- Spore Cloud
	[21553]	= 10,	-- Mortal Strike (Rank 4)
	[21562]	= 3600,	-- Prayer of Fortitude (Rank 1)
	[21564]	= 3600,	-- Prayer of Fortitude (Rank 2)
	[21655]	= 1,	-- Blink
	[21687]	= 15,	-- Toxic Volley
	[21749]	= 2,	-- Thorn Volley
	[21787]	= 120,	-- Deadly Poison
	[21849]	= 3600,	-- Gift of the Wild (Rank 1)
	[21850]	= 3600,	-- Gift of the Wild (Rank 2)
	[21909]	= 8,	-- Dust Field
	[22570]	= 0,	-- Maim
	[22717]	= 0,	-- Black War Steed
	[22718]	= 0,	-- Black War Kodo
	[22719]	= 0,	-- Black Battlestrider
	[22720]	= 0,	-- Black War Ram
	[22721]	= 0,	-- Black War Raptor
	[22722]	= 0,	-- Red Skeletal Warhorse
	[22723]	= 0,	-- Black War Tiger
	[22724]	= 0,	-- Black War Wolf
	[22766]	= 0,	-- Sneak (Rank 1)
	[22782]	= 1800,	-- Mage Armor (Rank 2)
	[22783]	= 1800,	-- Mage Armor (Rank 3)
	[22812]	= 12,	-- Barkskin
	[22842]	= 10,	-- Frenzied Regeneration
	[22888]	= 7200,	-- Rallying Cry of the Dragonslayer
	[22911]	= 0,	-- Charge
	[22959]	= 30,	-- Improved Scorch
	[23028]	= 3600,	-- Arcane Brilliance (Rank 1)
	[23033]	= 0,	-- Battle Standard
	[23036]	= 0,	-- Battle Standard
	[23145]	= 16,	-- Dive
	[23161]	= 0,	-- Dreadsteed (Summon)
	[23214]	= 0,	-- Charger (Summon)
	[23219]	= 0,	-- Swift Mistsaber
	[23221]	= 0,	-- Swift Frostsaber
	[23223]	= 0,	-- Swift White Mechanostrider
	[23225]	= 0,	-- Swift Green Mechanostrider
	[23227]	= 0,	-- Swift Palomino
	[23228]	= 0,	-- Swift White Steed
	[23229]	= 0,	-- Swift Brown Steed
	[23238]	= 0,	-- Swift Brown Ram
	[23239]	= 0,	-- Swift Gray Ram
	[23240]	= 0,	-- Swift White Ram
	[23241]	= 0,	-- Swift Blue Raptor
	[23242]	= 0,	-- Swift Olive Raptor
	[23243]	= 0,	-- Swift Orange Raptor
	[23246]	= 0,	-- Purple Skeletal Warhorse
	[23247]	= 0,	-- Great White Kodo
	[23248]	= 0,	-- Great Gray Kodo
	[23249]	= 0,	-- Great Brown Kodo
	[23250]	= 0,	-- Swift Brown Wolf
	[23251]	= 0,	-- Swift Timber Wolf
	[23252]	= 0,	-- Swift Gray Wolf
	[23333]	= 0,	-- Warsong Flag
	[23335]	= 0,	-- Silverwing Flag
	[23338]	= 0,	-- Swift Stormsaber
	[23451]	= 10,	-- Speed
	[23493]	= 10,	-- Restoration
	[23509]	= 0,	-- Frostwolf Howler
	[23510]	= 0,	-- Stormpike Battle Charger
	[23511]	= 0,	-- Demoralizing Shout
	[23600]	= 6,	-- Piercing Howl
	[23693]	= 120,	-- Stormpike's Salvation
	[23694]	= 5,	-- Improved Hamstring
	[23759]	= 0,	-- Master Demonologist
	[23760]	= 0,	-- Master Demonologist
	[23767]	= 7200,	-- Sayge's Dark Fortune of Armor
	[23768]	= 7200,	-- Sayge's Dark Fortune of Damage
	[23829]	= 0,	-- Master Demonologist
	[23844]	= 0,	-- Master Demonologist
	[23885]	= 8,	-- Bloodthirst
	[23920]	= 5,	-- Spell Reflection
	[23978]	= 10,	-- Speed
	[24131]	= 6,	-- Wyvern Sting
	[24242]	= 0,	-- Swift Razzashi Raptor
	[24252]	= 0,	-- Swift Zulian Tiger
	[24259]	= 3,	-- Spell Lock
	[24378]	= 60,	-- Berserking
	[24379]	= 10,	-- Restoration
	[24394]	= 2,	-- Intimidation
	[24398]	= 600,	-- Water Shield (Rank 7)
	[24425]	= 7200,	-- Spirit of Zandalar
	[24450]	= 0,	-- Prowl (Rank 1)
	[24452]	= 0,	-- Prowl (Rank 2)
	[24453]	= 0,	-- Prowl (Rank 3)
	[24529]	= 0,	-- Spirit Bond (Rank 2)
	[24586]	= 10,	-- Scorpid Poison (Rank 3)
	[24709]	= 3600,	-- Pirate Costume
	[24711]	= 3600,	-- Ninja Costume
	[24712]	= 3600,	-- Leper Gnome Costume
	[24735]	= 3600,	-- Ghost Costume
	[24844]	= 45,	-- Lightning Breath
	[24858]	= 0,	-- Moonkin Form (Shapeshift)
	[24870]	= 900,	-- Well Fed
	[24907]	= 0,	-- Moonkin Aura
	[24932]	= 0,	-- Leader of the Pack
	[24974]	= 14,	-- Insect Swarm (Rank 2)
	[25040]	= 900,	-- Mark of Nature
	[25046]	= 2,	-- Arcane Torrent (Racial)
	[25058]	= 15,	-- Renew
	[25163]	= 0,	-- Oozeling's Disgusting Aura
	[25207]	= 1800,	-- Amulet of the Moon
	[25217]	= 30,	-- Power Word: Shield (Rank 11)
	[25218]	= 30,	-- Power Word: Shield (Rank 12)
	[25221]	= 15,	-- Renew (Rank 11)
	[25222]	= 15,	-- Renew (Rank 12)
	[25228]	= 0,	-- Soul Link
	[25289]	= 120,	-- Battle Shout (Rank 7)
	[25290]	= 600,	-- Blessing of Wisdom (Rank 6)
	[25291]	= 600,	-- Blessing of Might (Rank 7)
	[25295]	= 15,	-- Serpent Sting (Rank 9)
	[25296]	= 0,	-- Aspect of the Hawk (Rank 7)
	[25312]	= 1800,	-- Divine Spirit (Rank 5)
	[25368]	= 18,	-- Shadow Word: Pain (Rank 10)
	[25387]	= 3,	-- Mind Flay (Rank 7)
	[25389]	= 1800,	-- Power Word: Fortitude (Rank 7)
	[25392]	= 3600,	-- Prayer of Fortitude (Rank 3)
	[25431]	= 1800,	-- Inner Fire (Rank 7)
	[25433]	= 600,	-- Shadow Protection (Rank 4)
	[25454]	= 8,	-- Earth Shock (Rank 8)
	[25467]	= 23,	-- Devouring Plague (Rank 7)
	[25469]	= 600,	-- Lightning Shield (Rank 8)
	[25472]	= 600,	-- Lightning Shield (Rank 9)
	[25527]	= 0,	-- Strength of Earth (Rank 6)
	[25569]	= 0,	-- Mana Spring (Rank 5)
	[25606]	= 1800,	-- Pendant of the Agate Shield
	[25694]	= 900,	-- Well Fed
	[25702]	= 21,	-- Food
	[25746]	= 15,	-- Damage Absorb
	[25747]	= 15,	-- Damage Absorb
	[25771]	= 120,	-- Forbearance
	[25780]	= 120,	-- Righteous Fury
	[25804]	= 900,	-- Rumsey Rum Black Label
	[25809]	= 12,	-- Crippling Poison (Rank 1)
	[25810]	= 12,	-- Mind-numbing Poison
	[25859]	= 0,	-- Reindeer
	[25894]	= 1800,	-- Greater Blessing of Wisdom (Rank 1)
	[25898]	= 1800,	-- Greater Blessing of Kings
	[25899]	= 1800,	-- Greater Blessing of Sanctuary
	[25916]	= 1800,	-- Greater Blessing of Might (Rank 2)
	[25918]	= 1800,	-- Greater Blessing of Wisdom (Rank 2)
	[25941]	= 900,	-- Well Fed
	[26004]	= 1800,	-- Mistletoe
	[26008]	= 1800,	-- Toast
	[26013]	= 900,	-- Deserter
	[26017]	= 10,	-- Vindication (Rank 2)
	[26276]	= 7200,	-- Greater Firepower
	[26297]	= 10,	-- Berserking (Racial)
	[26522]	= 1800,	-- Lunar Fortune
	[26573]	= 10,	-- Consecration
	[26669]	= 15,	-- Evasion (Rank 2)
	[26679]	= 6,	-- Deadly Throw
	[26864]	= 15,	-- Hemorrhage (Rank 4)
	[26867]	= 14,	-- Rupture (Rank 7)
	[26884]	= 18,	-- Garrote (Rank 8)
	[26888]	= 10,	-- Vanish (Rank 3)
	[26968]	= 12,	-- Deadly Poison VI (Rank 6)
	[26990]	= 1800,	-- Mark of the Wild (Rank 8)
	[26991]	= 3600,	-- Gift of the Wild (Rank 3)
	[26992]	= 600,	-- Thorns (Rank 7)
	[27009]	= 45,	-- Nature's Grasp (Rank 7)
	[27044]	= 0,	-- Aspect of the Hawk (Rank 8)
	[27046]	= 15,	-- Mend Pet (Rank 8)
	[27065]	= 10,	-- Aimed Shot (Rank 7)
	[27089]	= 30,	-- Drink
	[27124]	= 1800,	-- Ice Armor (Rank 5)
	[27125]	= 1800,	-- Mage Armor (Rank 4)
	[27126]	= 1800,	-- Arcane Intellect (Rank 6)
	[27127]	= 3600,	-- Arcane Brilliance (Rank 2)
	[27140]	= 1800,	-- Blessing of Might (Rank 8)
	[27142]	= 600,	-- Blessing of Wisdom (Rank 7)
	[27143]	= 1800,	-- Greater Blessing of Wisdom (Rank 3)
	[27149]	= 0,	-- Devotion Aura (Rank 8)
	[27150]	= 0,	-- Retribution Aura (Rank 6)
	[27151]	= 0,	-- Shadow Resistance Aura (Rank 4)
	[27152]	= 0,	-- Frost Resistance Aura (Rank 4)
	[27153]	= 0,	-- Fire Resistance Aura (Rank 4)
	[27187]	= 12,	-- Deadly Poison VII (Rank 7)
	[27243]	= 18,	-- Seed of Corruption
	[27260]	= 1800,	-- Demon Armor (Rank 6)
	[27268]	= 0,	-- Blood Pact (Rank 6)
	[27681]	= 3600,	-- Prayer of Spirit (Rank 1)
	[27683]	= 1200,	-- Prayer of Shadow Protection (Rank 1)
	[27813]	= 6,	-- Blessed Recovery (Rank 1)
	[27817]	= 6,	-- Blessed Recovery (Rank 2)
	[27818]	= 6,	-- Blessed Recovery (Rank 3)
	[27827]	= 15,	-- Spirit of Redemption
	[27828]	= 6,	-- Focused Casting (Rank 2)
	[27841]	= 1800,	-- Divine Spirit (Rank 4)
	[27863]	= 600,	-- The Baron's Ultimatum
	[28093]	= 15,	-- Lightning Speed
	[28176]	= 1800,	-- Fel Armor (Rank 1)
	[28189]	= 1800,	-- Fel Armor (Rank 2)
	[28271]	= 50,	-- Polymorph (turtle)
	[28272]	= 50,	-- Polymorph (pig)
	[28273]	= 600,	-- Bloodthistle
	[28274]	= 1200,	-- Bloodthistle Withdrawal
	[28489]	= 3600,	-- Camouflage
	[28491]	= 3600,	-- Healing Power
	[28497]	= 3600,	-- Mighty Agility
	[28509]	= 3600,	-- Greater Mana Regeneration
	[28518]	= 3600,	-- Flask of Fortification
	[28520]	= 7200,	-- Flask of Relentless Assault
	[28521]	= 3600,	-- Flask of Blinding Light
	[28682]	= 0,	-- Combustion
	[28694]	= 900,	-- Dreaming Glory
	[28703]	= 900,	-- Netherbloom Pollen
	[28730]	= 2,	-- Arcane Torrent (Racial)
	[28747]	= 600,	-- Frenzy
	[28878]	= 0,	-- Heroic Presence (Racial Passive)
	[29073]	= 30,	-- Food
	[29131]	= 10,	-- Bloodrage
	[29166]	= 10,	-- Innervate
	[29175]	= 3600,	-- Ribbon Dance [This duration changed based on how long you've used the ribbon poll]
	[29177]	= 10,	-- Elemental Devastation (Rank 2)
	[29178]	= 10,	-- Elemental Devastation (Rank 3)
	[29228]	= 18,	-- Flame Shock (Rank 6)
	[29235]	= 3600,	-- Fire Festival Fortitude
	[29332]	= 3600,	-- Fire-toasted Bun
	[29333]	= 3600,	-- Midsummer Sausage
	[29334]	= 3600,	-- Toasted Smorc
	[29335]	= 3600,	-- Elderberry Pie
	[29341]	= 5,	-- Shadowburn
	[29348]	= 3600,	-- Goldenmist Special Brew
	[29544]	= 6,	-- Frightening Shout
	[29674]	= 0,	-- Lesser Shielding
	[29703]	= 6,	-- Dazed
	[29801]	= 0,	-- Rampage (Passive)
	[29842]	= 10,	-- Second Wind (Rank 2)
	[29882]	= 0,	-- Loose Mana
	[30070]	= 0,	-- Blood Frenzy (Rank 2)
	[30108]	= 15,	-- Unstable Affliction
	[30151]	= 6,	-- Pursuit
	[30213]	= 6,	-- Legion Strike
	[30283]	= 3,	-- Shadowfury
	[30482]	= 1800,	-- Molten Armor (Rank 1)
	[30708]	= 0,	-- Totem of Wrath
	[30802]	= 0,	-- Unleashed Rage (Rank 1)
	[30808]	= 0,	-- Unleashed Rage (Rank 2)
	[30809]	= 0,	-- Unleashed Rage (Rank 3)
	[30823]	= 15,	-- Shamanistic Rage
	[30910]	= 60,	-- Curse of Doom (Rank 2)
	[30931]	= 20,	-- Battle Shout
	[30991]	= 0,	-- Stealth
	[31117]	= 5,	-- Unstable Affliction
	[31125]	= 4,	-- Blade Twisting
	[31224]	= 5,	-- Cloak of Shadows
	[31403]	= 120,	-- Battle Shout
	[31462]	= 3600,	-- Moonwell Restoration
	[31579]	= 0,	-- Arcane Empowerment (Rank 1)
	[31583]	= 0,	-- Arcane Empowerment (Rank 3)
	[31589]	= 15,	-- Slow
	[31616]	= 10,	-- Nature's Guardian
	[31643]	= 8,	-- Blazing Speed
	[31661]	= 5,	-- Dragon's Breath (Rank 1)
	[31665]	= 6,	-- Master of Subtlety
	[31790]	= 3,	-- Righteous Defense
	[31801]	= 1800,	-- Seal of Vengeance
	[31803]	= 15,	-- Holy Vengeance (Rank 1)
	[31821]	= 6,	-- Aura Mastery
	[31834]	= 15,	-- Light's Grace
	[31842]	= 15,	-- Divine Illumination
	[31850]	= 10,	-- Ardent Defender
	[31884]	= 20,	-- Avenging Wrath
	[31930]	= 10,	-- Judgements of the Wise
	[31935]	= 3,	-- Avenger's Shield
	[32182]	= 40,	-- Heroism
	[32216]	= 20,	-- Victorious
	[32223]	= 0,	-- Crusader Aura
	[32240]	= 0,	-- Snowy Gryphon
	[32243]	= 0,	-- Tawny Wind Rider
	[32244]	= 0,	-- Blue Wind Rider
	[32245]	= 0,	-- Green Wind Rider
	[32246]	= 0,	-- Swift Red Wind Rider
	[32289]	= 0,	-- Swift Red Gryphon
	[32292]	= 0,	-- Swift Purple Gryphon
	[32295]	= 0,	-- Swift Green Wind Rider
	[32296]	= 0,	-- Swift Yellow Wind Rider
	[32297]	= 0,	-- Swift Purple Wind Rider
	[32386]	= 12,	-- Shadow Embrace
	[32388]	= 12,	-- Shadow Embrace
	[32389]	= 12,	-- Shadow Embrace
	[32390]	= 12,	-- Shadow Embrace
	[32391]	= 12,	-- Shadow Embrace
	[32409]	= 1,	-- Shadow Word: Death
	[32593]	= 600,	-- Earth Shield (Rank 2)
	[32594]	= 600,	-- Earth Shield (Rank 3)
	[32600]	= 10,	-- Avoidance
	[32612]	= 0,	-- Invisibility
	[32645]	= 1,	-- Envenom
	[32727]	= 0,	-- Arena Preparation
	[32736]	= 5,	-- Mortal Strike
	[32752]	= 5,	-- Summoning Disorientation
	[32851]	= 10,	-- Demonic Frenzy
	[32999]	= 3600,	-- Prayer of Spirit (Rank 2)
	[33041]	= 5,	-- Dragon's Breath (Rank 2)
	[33042]	= 5,	-- Dragon's Breath (Rank 3)
	[33043]	= 5,	-- Dragon's Breath (Rank 4)
	[33053]	= 7200,	-- Mr Pinchy's Blessing
	[33082]	= 1800,	-- Strength (Rank 5)
	[33151]	= 10,	-- Surge of Light (Rank 1)
	[33197]	= 24,	-- Misery (Rank 2)
	[33198]	= 24,	-- Misery (Rank 3)
	[33206]	= 8,	-- Pain Suppression
	[33254]	= 1800,	-- Well Fed
	[33256]	= 1800,	-- Well Fed
	[33257]	= 1800,	-- Well Fed
	[33259]	= 1800,	-- Well Fed
	[33263]	= 1800,	-- Well Fed
	[33268]	= 1800,	-- Well Fed
	[33280]	= 0,	-- Corporal
	[33357]	= 15,	-- Dash (Rank 3)
	[33395]	= 2,	-- Freeze
	[33660]	= 0,	-- Swift Pink Hawkstrider
	[33697]	= 15,	-- Blood Fury (Racial)
	[33702]	= 15,	-- Blood Fury (Racial)
	[33720]	= 7200,	-- Onslaught Elixir
	[33721]	= 3600,	-- Spellpower Elixir
	[33726]	= 3600,	-- Elixir of Mastery
	[33736]	= 600,	-- Water Shield (Rank 8)
	[33745]	= 15,	-- Lacerate
	[33763]	= 7,	-- Lifebloom (Rank 1)
	[33786]	= 6,	-- Cyclone
	[33876]	= 60,	-- Mangle
	[33878]	= 60,	-- Mangle
	[33891]	= 0,	-- Tree of Life (Shapeshift)
	[33943]	= 0,	-- Flight Form (Shapeshift)
	[33944]	= 600,	-- Dampen Magic (Rank 6)
	[33946]	= 600,	-- Amplify Magic (Rank 6)
	[34027]	= 30,	-- Kill Command (Rank 1)
	[34074]	= 0,	-- Aspect of the Viper
	[34123]	= 0,	-- Tree of Life (Passive)
	[34321]	= 10,	-- Call of the Nexus
	[34410]	= 3600,	-- Hellscream's Warsong
	[34471]	= 10,	-- The Beast Within
	[34477]	= 30,	-- Misdirection
	[34490]	= 3,	-- Silencing Shot
	[34501]	= 7,	-- Expose Weakness
	[34655]	= 8,	-- Deadly Poison
	[34709]	= 15,	-- Shadow Sight
	[34767]	= 0,	-- Summon Charger (Summon)
	[34769]	= 0,	-- Summon Warhorse (Summon)
	[34790]	= 0,	-- Dark War Talbuk
	[34795]	= 0,	-- Red Hawkstrider
	[34837]	= 8,	-- Master Tactician (Rank 5)
	[34896]	= 0,	-- Cobalt War Talbuk
	[34897]	= 0,	-- White War Talbuk
	[34898]	= 0,	-- Silver War Talbuk
	[34899]	= 0,	-- Tan War Talbuk
	[34914]	= 15,	-- Vampiric Touch
	[34917]	= 15,	-- Vampiric Touch (Rank 3)
	[34936]	= 8,	-- Backlash
	[34976]	= 0,	-- Netherstorm Flag
	[35018]	= 0,	-- Purple Hawkstrider
	[35020]	= 0,	-- Blue Hawkstrider
	[35022]	= 0,	-- Black Hawkstrider
	[35025]	= 0,	-- Swift Green Hawkstrider
	[35027]	= 0,	-- Swift Purple Hawkstrider
	[35028]	= 0,	-- Swift Warstrider
	[35079]	= 4,	-- Misdirection
	[35098]	= 20,	-- Rapid Killing (Rank 1)
	[35099]	= 20,	-- Rapid Killing (Rank 2)
	[35101]	= 4,	-- Concussive Barrage
	[35696]	= 0,	-- Demonic Knowledge
	[35706]	= 0,	-- Master Demonologist
	[35712]	= 0,	-- Great Green Elekk
	[35713]	= 0,	-- Great Blue Elekk
	[35714]	= 0,	-- Great Purple Elekk
	[35944]	= 30,	-- Power Word: Shield
	[36032]	= 6,	-- Arcane Blast
	[36444]	= 0,	-- Wintergrasp Water
	[36554]	= 3,	-- Shadowstep
	[36563]	= 10,	-- Shadowstep
	[36702]	= 0,	-- Fiery Warhorse
	[36893]	= 3600,	-- Transporter Malfunction
	[36895]	= 3600,	-- Transporter Malfunction
	[36897]	= 3600,	-- Transporter Malfunction
	[36899]	= 3600,	-- Transporter Malfunction
	[37548]	= 3,	-- Taunt
	[37578]	= 5,	-- Debilitating Strike
	[37795]	= 0,	-- Recruit
	[38232]	= 20,	-- Battle Shout
	[38254]	= 1800,	-- Festering Wound
	[38384]	= 8,	-- Cone of Cold
	[39171]	= 5,	-- Mortal Strike
	[39315]	= 0,	-- Cobalt Riding Talbuk
	[39316]	= 0,	-- Dark Riding Talbuk
	[39317]	= 0,	-- Silver Riding Talbuk
	[39318]	= 0,	-- Tan Riding Talbuk
	[39319]	= 0,	-- White Riding Talbuk
	[39374]	= 1200,	-- Prayer of Shadow Protection (Rank 2)
	[39439]	= 10,	-- Aura of the Crusader
	[39627]	= 3600,	-- Elixir of Draenic Wisdom
	[39628]	= 3600,	-- Elixir of Ironskin
	[39796]	= 3,	-- Stoneclaw Stun
	[39800]	= 0,	-- Red Riding Nether Ray
	[39802]	= 0,	-- Silver Riding Nether Ray
	[40120]	= 0,	-- Swift Flight Form (Shapeshift)
	[40192]	= 0,	-- Ashes of Al'ar
	[40623]	= 3600,	-- Apexis Vibrations
	[40625]	= 5400,	-- Apexis Emanations
	[41252]	= 0,	-- Raven Lord
	[41425]	= 30,	-- Hypothermia
	[41513]	= 0,	-- Onyx Netherwing Drake
	[41514]	= 0,	-- Azure Netherwing Drake
	[41516]	= 0,	-- Purple Netherwing Drake
	[41635]	= 30,	-- Prayer of Mending (Rank 1)
	[42138]	= 7200,	-- Brewfest Enthusiast
	[42292]	= 0,	-- PvP Trinket
	[42650]	= 4,	-- Army of the Dead
	[42702]	= 10,	-- Decrepify
	[42705]	= 60,	-- Enrage
	[42723]	= 2,	-- Dark Smash
	[42728]	= 60,	-- Dreadful Roar
	[42740]	= 8,	-- Njord's Rune of Protection
	[42777]	= 0,	-- Swift Spectral Tiger
	[42792]	= 3,	-- Recently Dropped Flag
	[42833]	= 8,	-- Fireball (Rank 16)
	[42842]	= 9,	-- Frostbolt (Rank 16)
	[42891]	= 0,	-- Pyroblast (Rank 12)
	[42917]	= 8,	-- Frost Nova (Rank 6)
	[42931]	= 11,	-- Cone of Cold (Rank 8)
	[42949]	= 5,	-- Dragon's Breath (Rank 5)
	[42950]	= 5,	-- Dragon's Breath (Rank 6)
	[42995]	= 1800,	-- Arcane Intellect (Rank 7)
	[43002]	= 3600,	-- Arcane Brilliance (Rank 3)
	[43008]	= 1800,	-- Ice Armor (Rank 6)
	[43010]	= 30,	-- Fire Ward (Rank 7)
	[43012]	= 30,	-- Frost Ward (Rank 7)
	[43015]	= 600,	-- Dampen Magic (Rank 7)
	[43017]	= 600,	-- Amplify Magic (Rank 7)
	[43019]	= 60,	-- Mana Shield (Rank 8)
	[43020]	= 60,	-- Mana Shield (Rank 9)
	[43023]	= 1800,	-- Mage Armor (Rank 5)
	[43024]	= 1800,	-- Mage Armor (Rank 6)
	[43038]	= 60,	-- Ice Barrier (Rank 7)
	[43039]	= 60,	-- Ice Barrier (Rank 8)
	[43045]	= 1800,	-- Molten Armor (Rank 2)
	[43046]	= 1800,	-- Molten Armor (Rank 3)
	[43180]	= 30,	-- Food
	[43182]	= 30,	-- Drink
	[43183]	= 30,	-- Drink
	[43195]	= 1800,	-- Intellect (Rank 6)
	[43196]	= 1800,	-- Armor (Rank 6)
	[43197]	= 1800,	-- Spirit (Rank 6)
	[43265]	= 0,	-- Death and Decay (Rank 1)
	[43664]	= 15,	-- Unholy Rage
	[43680]	= 60,	-- Idle
	[43681]	= 60,	-- Inactive
	[43688]	= 0,	-- Amani War Bear
	[43751]	= 10,	-- Energized
	[43771]	= 3600,	-- Well Fed
	[43900]	= 0,	-- Swift Brewfest Ram
	[43927]	= 0,	-- Cenarion War Hippogryph
	[43931]	= 15,	-- Rend
	[44151]	= 0,	-- Turbo-Charged Flying Machine
	[44153]	= 0,	-- Flying Machine
	[44212]	= 3600,	-- Jack-o'-Lanterned!
	[44401]	= 15,	-- Missile Barrage
	[44413]	= 10,	-- Incanter's Absorption
	[44415]	= 3,	-- Blackout (Rank 1)
	[44457]	= 12,	-- Living Bomb
	[44521]	= 0,	-- Preparation
	[44535]	= 6,	-- Spirit Heal
	[44544]	= 15,	-- Fingers of Frost
	[44572]	= 5,	-- Deep Freeze
	[44614]	= 9,	-- Frostfire Bolt (Rank 1)
	[44795]	= 0,	-- Parachute
	[44825]	= 0,	-- Flying Reindeer
	[45062]	= 0,	-- Holy Energy
	[45123]	= 0,	-- Romantic Picnic
	[45182]	= 3,	-- Cheating Death
	[45241]	= 8,	-- Focused Will (Rank 2)
	[45242]	= 8,	-- Focused Will (Rank 3)
	[45245]	= 1800,	-- Well Fed
	[45282]	= 8,	-- Natural Perfection (Rank 2)
	[45283]	= 8,	-- Natural Perfection (Rank 3)
	[45334]	= 4,	-- Feral Charge Effect
	[45373]	= 7200,	-- Bloodberry
	[45438]	= 10,	-- Ice Block
	[45444]	= 0,	-- Bonfire's Blessing
	[45472]	= 60,	-- Parachute
	[45524]	= 10,	-- Chains of Ice
	[45529]	= 20,	-- Blood Tap
	[45544]	= 8,	-- First Aid (Rank 15)
	[45548]	= 30,	-- Food
	[45693]	= 0,	-- Torches Caught
	[45694]	= 180,	-- Captain Rumsey's Lager
	[45699]	= 5,	-- Flames of Failure
	[45716]	= 40,	-- Torch Tossing Training
	[45724]	= 0,	-- Braziers Hit!
	[46168]	= 0,	-- Pet Biscuit
	[46199]	= 0,	-- X-51 Nether-Rocket X-TREME
	[46202]	= 10,	-- Pierce Armor
	[46221]	= 180,	-- Animal Blood
	[46352]	= 3600,	-- Fire Festival Fury
	[46355]	= 300,	-- Blood Elf Illusion
	[46356]	= 300,	-- Blood Elf Illusion
	[46604]	= 4,	-- Ice Block
	[46628]	= 0,	-- Swift White Hawkstrider
	[46630]	= 90,	-- Torch Tossing Practice
	[46833]	= 15,	-- Wrath of Elune
	[46857]	= 60,	-- Trauma (Rank 2)
	[46899]	= 900,	-- Well Fed
	[46916]	= 5,	-- Slam!
	[46924]	= 6,	-- Bladestorm
	[46968]	= 4,	-- Shockwave
	[46987]	= 4,	-- Frostbolt
	[46989]	= 4,	-- Improved Blink
	[47057]	= 180,	-- Fiery Seduction
	[47241]	= 30,	-- Metamorphosis
	[47283]	= 8,	-- Empowered Imp
	[47436]	= 120,	-- Battle Shout (Rank 9)
	[47437]	= 30,	-- Demoralizing Shout (Rank 8)
	[47439]	= 360,	-- Commanding Shout (Rank 2)
	[47440]	= 120,	-- Commanding Shout (Rank 3)
	[47465]	= 15,	-- Rend (Rank 10)
	[47476]	= 5,	-- Strangulate
	[47481]	= 3,	-- Gnaw
	[47486]	= 10,	-- Mortal Strike (Rank 8)
	[47501]	= 30,	-- Thunder Clap (Rank 8)
	[47502]	= 30,	-- Thunder Clap (Rank 9)
	[47543]	= 0,	-- Frozen Prison
	[47585]	= 6,	-- Dispersion
	[47610]	= 12,	-- Frostfire Bolt (Rank 2)
	[47699]	= 300,	-- Crystal Bark
	[47747]	= 45,	-- Charge Rifts
	[47748]	= 45,	-- Rift Shield
	[47753]	= 12,	-- Divine Aegis (Rank 1)
	[47774]	= 120,	-- Frenzy
	[47779]	= 4,	-- Arcane Torrent
	[47781]	= 6,	-- Spellbreaker
	[47791]	= 5,	-- Arcane Haste
	[47811]	= 15,	-- Immolate (Rank 11)
	[47813]	= 18,	-- Corruption (Rank 10)
	[47823]	= 15,	-- Hellfire (Rank 5)
	[47836]	= 18,	-- Seed of Corruption (Rank 3)
	[47843]	= 15,	-- Unstable Affliction (Rank 5)
	[47847]	= 3,	-- Shadowfury (Rank 5)
	[47854]	= 0,	-- Frozen Prison
	[47855]	= 15,	-- Drain Soul (Rank 6)
	[47856]	= 9,	-- Health Funnel (Rank 9)
	[47857]	= 5,	-- Drain Life (Rank 9)
	[47860]	= 3,	-- Death Coil (Rank 6)
	[47864]	= 24,	-- Curse of Agony (Rank 9)
	[47865]	= 300,	-- Curse of the Elements (Rank 5)
	[47867]	= 60,	-- Curse of Doom (Rank 3)
	[47883]	= 900,	-- Soulstone Resurrection
	[47889]	= 1800,	-- Demon Armor (Rank 8)
	[47891]	= 30,	-- Shadow Ward (Rank 6)
	[47892]	= 1800,	-- Fel Armor (Rank 3)
	[47893]	= 1800,	-- Fel Armor (Rank 4)
	[47930]	= 15,	-- Grace
	[47960]	= 6,	-- Shadowflame
	[47981]	= 15,	-- Spell Reflection
	[47982]	= 0,	-- Blood Pact (Rank 7)
	[47983]	= 180,	-- Fire Shield (Rank 7)
	[47986]	= 30,	-- Sacrifice (Rank 9)
	[47988]	= 6,	-- Consume Shadows (Rank 9)
	[47990]	= 15,	-- Suffering (Rank 8)
	[47995]	= 3,	-- Intercept (Rank 4)
	[48018]	= 360,	-- Demonic Circle: Summon
	[48020]	= 1,	-- Demonic Circle: Teleport
	[48024]	= 0,	-- Headless Horseman's Mount
	[48025]	= 0,	-- Headless Horseman's Mount
	[48027]	= 0,	-- Black War Elekk
	[48040]	= 1800,	-- Inner Fire (Rank 8)
	[48058]	= 30,	-- Crystal Bloom
	[48065]	= 30,	-- Power Word: Shield (Rank 13)
	[48066]	= 30,	-- Power Word: Shield (Rank 14)
	[48068]	= 15,	-- Renew (Rank 14)
	[48073]	= 1800,	-- Divine Spirit (Rank 6)
	[48074]	= 3600,	-- Prayer of Spirit (Rank 3)
	[48090]	= 45,	-- Demonic Pact
	[48095]	= 0,	-- Intense Cold
	[48100]	= 1800,	-- Intellect (Rank 7)
	[48101]	= 1800,	-- Stamina (Level 6)
	[48102]	= 1800,	-- Stamina (Level 6)
	[48103]	= 1800,	-- Spirit (Rank 7)
	[48108]	= 10,	-- Hot Streak
	[48111]	= 30,	-- Prayer of Mending (Rank 3)
	[48125]	= 18,	-- Shadow Word: Pain (Rank 12)
	[48135]	= 7,	-- Holy Fire (Rank 11)
	[48155]	= 3,	-- Mind Flay (Rank 8)
	[48156]	= 3,	-- Mind Flay (Rank 9)
	[48160]	= 15,	-- Vampiric Touch (Rank 5)
	[48161]	= 1800,	-- Power Word: Fortitude (Rank 8)
	[48162]	= 3600,	-- Prayer of Fortitude (Rank 4)
	[48168]	= 1800,	-- Inner Fire (Rank 9)
	[48169]	= 600,	-- Shadow Protection (Rank 5)
	[48170]	= 1200,	-- Prayer of Shadow Protection (Rank 3)
	[48181]	= 12,	-- Haunt
	[48263]	= 0,	-- Frost Presence
	[48265]	= 0,	-- Unholy Presence
	[48266]	= 0,	-- Blood Presence
	[48299]	= 24,	-- Devouring Plague (Rank 8)
	[48300]	= 24,	-- Devouring Plague (Rank 9)
	[48301]	= 10,	-- Mind Trauma
	[48333]	= 300,	-- Going Ape
	[48391]	= 10,	-- Owlkin Frenzy
	[48400]	= 20,	-- Frost Tomb
	[48418]	= 0,	-- Master Shapeshifter
	[48420]	= 0,	-- Master Shapeshifter
	[48421]	= 0,	-- Master Shapeshifter
	[48422]	= 0,	-- Master Shapeshifter
	[48438]	= 7,	-- Wild Growth
	[48440]	= 15,	-- Rejuvenation (Rank 14)
	[48441]	= 15,	-- Rejuvenation (Rank 15)
	[48442]	= 21,	-- Regrowth (Rank 11)
	[48443]	= 21,	-- Regrowth (Rank 12)
	[48446]	= 0,	-- Tranquility (Rank 6)
	[48447]	= 7,	-- Tranquility (Rank 7)
	[48450]	= 7,	-- Lifebloom (Rank 2)
	[48451]	= 7,	-- Lifebloom (Rank 3)
	[48463]	= 12,	-- Moonfire (Rank 14)
	[48467]	= 0,	-- Hurricane (Rank 5)
	[48468]	= 14,	-- Insect Swarm (Rank 7)
	[48469]	= 1800,	-- Mark of the Wild (Rank 9)
	[48470]	= 3600,	-- Gift of the Wild (Rank 4)
	[48504]	= 15,	-- Living Seed
	[48505]	= 10,	-- Starfall
	[48517]	= 15,	-- Eclipse (Solar)
	[48518]	= 15,	-- Eclipse (Lunar)
	[48560]	= 30,	-- Demoralizing Roar (Rank 8)
	[48564]	= 60,	-- Mangle (Bear) (Rank 5)
	[48565]	= 60,	-- Mangle (Cat) (Rank 4)
	[48566]	= 60,	-- Mangle (Cat) (Rank 5)
	[48568]	= 15,	-- Lacerate (Rank 3)
	[48574]	= 9,	-- Rake (Rank 7)
	[48660]	= 15,	-- Hemorrhage (Rank 5)
	[48671]	= 14,	-- Rupture (Rank 8)
	[48672]	= 16,	-- Rupture (Rank 9)
	[48674]	= 6,	-- Deadly Throw (Rank 3)
	[48675]	= 18,	-- Garrote (Rank 9)
	[48676]	= 18,	-- Garrote (Rank 10)
	[48707]	= 5,	-- Anti-Magic Shell
	[48719]	= 600,	-- Water Breathing
	[48778]	= 0,	-- Acherus Deathcharger (Summon)
	[48792]	= 12,	-- Icebound Fortitude
	[48817]	= 3,	-- Holy Wrath (Rank 5)
	[48827]	= 10,	-- Avenger's Shield (Rank 5)
	[48836]	= 5,	-- Vengeful Justice
	[48838]	= 10,	-- Elemental Tenacity
	[48846]	= 20,	-- Runic Infusion
	[48931]	= 1800,	-- Blessing of Might (Rank 9)
	[48932]	= 600,	-- Blessing of Might (Rank 10)
	[48933]	= 1800,	-- Greater Blessing of Might (Rank 4)
	[48934]	= 1800,	-- Greater Blessing of Might (Rank 5)
	[48935]	= 600,	-- Blessing of Wisdom (Rank 8)
	[48936]	= 600,	-- Blessing of Wisdom (Rank 9)
	[48937]	= 1800,	-- Greater Blessing of Wisdom (Rank 4)
	[48938]	= 1800,	-- Greater Blessing of Wisdom (Rank 5)
	[48941]	= 0,	-- Devotion Aura (Rank 9)
	[48942]	= 0,	-- Devotion Aura (Rank 10)
	[48943]	= 0,	-- Shadow Resistance Aura (Rank 5)
	[48945]	= 0,	-- Frost Resistance Aura (Rank 5)
	[48947]	= 0,	-- Fire Resistance Aura (Rank 5)
	[48952]	= 10,	-- Holy Shield (Rank 6)
	[48989]	= 15,	-- Mend Pet (Rank 9)
	[48990]	= 15,	-- Mend Pet (Rank 10)
	[49000]	= 21,	-- Serpent Sting (Rank 11)
	[49001]	= 15,	-- Serpent Sting (Rank 12)
	[49005]	= 20,	-- Mark of Blood
	[49010]	= 30,	-- Wyvern Sting (Rank 6)
	[49012]	= 30,	-- Wyvern Sting (Rank 6)
	[49016]	= 30,	-- Hysteria
	[49028]	= 12,	-- Dancing Rune Weapon
	[49039]	= 10,	-- Lichborne
	[49050]	= 10,	-- Aimed Shot (Rank 9)
	[49054]	= 15,	-- Immolation Trap (Rank 8)
	[49065]	= 0,	-- Explosive Trap Effect (Rank 6)
	[49071]	= 0,	-- Aspect of the Wild (Rank 4)
	[49203]	= 10,	-- Hungering Cold (Rank 1)
	[49206]	= 0,	-- Summon Gargoyle
	[49222]	= 300,	-- Bone Shield
	[49231]	= 8,	-- Earth Shock (Rank 10)
	[49232]	= 18,	-- Flame Shock (Rank 8)
	[49233]	= 18,	-- Flame Shock (Rank 9)
	[49236]	= 8,	-- Frost Shock (Rank 7)
	[49280]	= 600,	-- Lightning Shield (Rank 10)
	[49281]	= 600,	-- Lightning Shield (Rank 11)
	[49284]	= 600,	-- Earth Shield (Rank 5)
	[49322]	= 0,	-- Swift Zhevra
	[49379]	= 0,	-- Great Brewfest Kodo
	[49560]	= 3,	-- Death Grip
	[49623]	= 15,	-- Effervescence
	[49759]	= 0,	-- Teleport
	[49800]	= 12,	-- Rip (Rank 9)
	[49802]	= 6,	-- Maim (Rank 2)
	[49803]	= 4,	-- Pounce (Rank 5)
	[49804]	= 18,	-- Pounce Bleed (Rank 5)
	[49868]	= 0,	-- Mind Quickening
	[49938]	= 0,	-- Death and Decay (Rank 4)
	[49962]	= 17,	-- Jungle Madness!
	[50131]	= 10,	-- Draw Magic
	[50213]	= 6,	-- Tiger's Fury (Rank 6)
	[50227]	= 5,	-- Sword and Board
	[50259]	= 3,	-- Dazed
	[50263]	= 20,	-- Quickness of the Sailor
	[50334]	= 15,	-- Berserk
	[50411]	= 3,	-- Dazed
	[50421]	= 20,	-- Scent of Blood
	[50434]	= 10,	-- Icy Clutch
	[50435]	= 10,	-- Chilblains
	[50436]	= 10,	-- Icy Clutch
	[50448]	= 30,	-- Bloody Vengeance
	[50449]	= 30,	-- Bloody Vengeance
	[50461]	= 0,	-- Anti-Magic Zone
	[50486]	= 18,	-- Acclimation
	[50510]	= 0,	-- Crypt Fever
	[50511]	= 120,	-- Curse of Weakness (Rank 9)
	[50518]	= 2,	-- Ravage (Rank 1)
	[50519]	= 2,	-- Sonic Blast (Rank 1)
	[50536]	= 10,	-- Unholy Blight
	[50589]	= 13,	-- Immolation Aura (Demon)
	[50613]	= 2,	-- Arcane Torrent (Racial)
	[50720]	= 1800,	-- Vigilance
	[50872]	= 30,	-- Savagery
	[50882]	= 20,	-- Icy Talons
	[50989]	= 3,	-- Flame Breath
	[51124]	= 30,	-- Killing Machine
	[51185]	= 0,	-- King of the Jungle
	[51209]	= 10,	-- Hungering Cold (Rank 1)
	[51271]	= 20,	-- Unbreakable Armor
	[51399]	= 2,	-- Death Grip
	[51460]	= 3,	-- Runic Corruption
	[51466]	= 0,	-- Elemental Oath (Rank 1)
	[51470]	= 0,	-- Elemental Oath (Rank 2)
	[51514]	= 30,	-- Hex
	[51585]	= 8,	-- Blade Twisting
	[51690]	= 2,	-- Killing Spree
	[51693]	= 8,	-- Waylay
	[51698]	= 0,	-- Honor Among Thieves
	[51700]	= 0,	-- Honor Among Thieves
	[51701]	= 0,	-- Honor Among Thieves
	[51713]	= 6,	-- Shadow Dance
	[51714]	= 20,	-- Frost Vulnerability
	[51722]	= 10,	-- Dismantle
	[51724]	= 60,	-- Sap (Rank 4)
	[51726]	= 0,	-- Ebon Plague
	[51735]	= 15,	-- Ebon Plague
	[51755]	= 60,	-- Camouflage
	[51789]	= 10,	-- Blade Barrier
	[51911]	= 2,	-- Spell Deflection
	[51945]	= 12,	-- Earthliving (Rank 1)
	[51987]	= 20,	-- Arcane Infusion
	[51990]	= 12,	-- Earthliving (Rank 2)
	[51999]	= 12,	-- Earthliving (Rank 5)
	[52000]	= 12,	-- Earthliving (Rank 6)
	[52109]	= 0,	-- Flametongue Totem (Rank 1)
	[52110]	= 0,	-- Flametongue Totem (Rank 2)
	[52111]	= 0,	-- Flametongue Totem (Rank 3)
	[52113]	= 0,	-- Flametongue Totem (Rank 5)
	[52127]	= 600,	-- Water Shield (Rank 1)
	[52129]	= 600,	-- Water Shield (Rank 2)
	[52131]	= 600,	-- Water Shield (Rank 3)
	[52134]	= 600,	-- Water Shield (Rank 4)
	[52136]	= 600,	-- Water Shield (Rank 5)
	[52138]	= 600,	-- Water Shield (Rank 6)
	[52179]	= 0,	-- Astral Shift
	[52418]	= 0,	-- Carrying Seaforium
	[52419]	= 10,	-- Deflection
	[52437]	= 10,	-- Sudden Death
	[52446]	= 10,	-- Acid Splash
	[52459]	= 10,	-- End of Round
	[52470]	= 8,	-- Enrage
	[52493]	= 10,	-- Poison Spray
	[52537]	= 10,	-- Fixate
	[52610]	= 34,	-- Savage Roar (Rank 1) (note this duration changes by combo points, 14, 19, 24, 29, 34)
	[52909]	= 1800,	-- Water Breathing
	[52910]	= 8,	-- Turn the Tables
	[53023]	= 5,	-- Mind Sear (Rank 2)
	[53030]	= 10,	-- Leech Poison
	[53137]	= 0,	-- Abomination's Might (Rank 1)
	[53138]	= 0,	-- Abomination's Might (Rank 2)
	[53148]	= 1,	-- Charge
	[53200]	= 0,	-- Starfall (Rank 3)
	[53201]	= 10,	-- Starfall (Rank 4)
	[53220]	= 12,	-- Improved Steady Shot
	[53227]	= 6,	-- Typhoon (Rank 5)
	[53251]	= 7,	-- Wild Growth (Rank 4)
	[53257]	= 10,	-- Cobra Strikes
	[53283]	= 30,	-- Food
	[53284]	= 1800,	-- Well Fed
	[53290]	= 0,	-- Hunting Party
	[53301]	= 2,	-- Explosive Shot (Rank 1)
	[53307]	= 600,	-- Thorns (Rank 8)
	[53308]	= 27,	-- Entangling Roots (Rank 8)
	[53312]	= 45,	-- Nature's Grasp (Rank 8)
	[53313]	= 27,	-- Entangling Roots (Rank 8)
	[53317]	= 15,	-- Rend
	[53322]	= 6,	-- Crushing Webs
	[53330]	= 20,	-- Infected Wound
	[53334]	= 9,	-- Animate Bones
	[53338]	= 300,	-- Hunter's Mark (Rank 5)
	[53365]	= 15,	-- Unholy Strength
	[53386]	= 30,	-- Cinderglacier
	[53390]	= 15,	-- Tidal Waves
	[53401]	= 20,	-- Rabid
	[53403]	= 0,	-- Rabid Power
	[53426]	= 5,	-- Lick Your Wounds
	[53434]	= 20,	-- Call of the Wild
	[53467]	= 15,	-- Leeching Swarm
	[53468]	= 0,	-- Leeching Swarm
	[53477]	= 3,	-- Taunt
	[53480]	= 12,	-- Roar of Sacrifice
	[53515]	= 8,	-- Owl's Focus
	[53517]	= 9,	-- Roar of Recovery
	[53520]	= 4,	-- Carrion Beetles
	[53547]	= 4,	-- Pin (Rank 5)
	[53548]	= 4,	-- Pin (Rank 6)
	[53563]	= 60,	-- Beacon of Light
	[53572]	= 6,	-- Tendon Rip (Rank 3)
	[53578]	= 15,	-- Savage Rend (Rank 2)
	[53579]	= 15,	-- Savage Rend (Rank 3)
	[53601]	= 30,	-- Sacred Shield (Rank 1)
	[53602]	= 12,	-- Dart
	[53646]	= 0,	-- Demonic Pact
	[53657]	= 60,	-- Judgements of the Pure (Rank 3)
	[53659]	= 10,	-- Sacred Cleansing
	[53736]	= 1800,	-- Seal of Corruption
	[53742]	= 15,	-- Blood Corruption (Rank 1)
	[53746]	= 3600,	-- Wrath Elixir
	[53747]	= 3600,	-- Elixir of Spirit
	[53748]	= 3600,	-- Mighty Strength
	[53749]	= 3600,	-- Guru's Elixir
	[53751]	= 3600,	-- Elixir of Mighty Fortitude
	[53752]	= 3600,	-- Lesser Flask of Toughness
	[53755]	= 3600,	-- Flask of the Frost Wyrm
	[53758]	= 3600,	-- Flask of Stoneblood
	[53760]	= 3600,	-- Flask of Endless Rage
	[53764]	= 3600,	-- Mighty Mana Regeneration
	[53768]	= 0,	-- Haunted
	[53801]	= 600,	-- Frenzy
	[53805]	= 600,	-- Pygmy Oil
	[53806]	= 600,	-- Pygmy Oil
	[53817]	= 30,	-- Maelstrom Weapon
	[53908]	= 15,	-- Speed
	[53909]	= 15,	-- Wild Magic
	[54043]	= 0,	-- Retribution Aura (Rank 7)
	[54131]	= 5,	-- Bloodthirsty
	[54149]	= 15,	-- Infusion of Light (Rank 2)
	[54152]	= 60,	-- Judgements of the Pure (Rank 4)
	[54153]	= 60,	-- Judgements of the Pure (Rank 5)
	[54203]	= 12,	-- Sheath of Light
	[54212]	= 3600,	-- Flask of Pure Mojo
	[54216]	= 4,	-- Master's Call
	[54277]	= 15,	-- Backdraft
	[54309]	= 10,	-- Mark of Darkness
	[54314]	= 30,	-- Drain Power
	[54315]	= 30,	-- Drain Power
	[54370]	= 8,	-- Nether Protection
	[54371]	= 8,	-- Nether Protection
	[54372]	= 8,	-- Nether Protection
	[54373]	= 8,	-- Nether Protection
	[54374]	= 8,	-- Nether Protection
	[54375]	= 8,	-- Nether Protection
	[54424]	= 0,	-- Fel Intelligence (Rank 1)
	[54428]	= 15,	-- Divine Plea
	[54443]	= 20,	-- Demonic Empowerment
	[54452]	= 3600,	-- Adept's Elixir
	[54494]	= 3600,	-- Major Agility
	[54497]	= 3600,	-- Lesser Armor
	[54499]	= 20,	-- Heart of the Crusader (Rank 3)
	[54501]	= 6,	-- Consume Shadows
	[54508]	= 15,	-- Demonic Empowerment
	[54643]	= 20,	-- Teleport
	[54646]	= 1800,	-- Focus Magic
	[54648]	= 10,	-- Focus Magic
	[54681]	= 12,	-- Monstrous Strength
	[54706]	= 5,	-- Venom Web Spray
	[54726]	= 0,	-- Winged Steed of the Ebon Blade
	[54727]	= 0,	-- Winged Steed of the Ebon Blade
	[54729]	= 0,	-- Winged Steed of the Ebon Blade
	[54753]	= 0,	-- White Polar Bear
	[54758]	= 12,	-- Hyperspeed Acceleration
	[54786]	= 2,	-- Demon Leap
	[54833]	= 10,	-- Glyph of Innervate
	[54839]	= 10,	-- Purified Spirit
	[54842]	= 0,	-- Thunder Charge
	[54861]	= 5,	-- Nitro Boosts
	[54955]	= 0,	-- Ticking Bomb
	[54965]	= 8,	-- Bolthorn's Rune of Flame
	[55001]	= 30,	-- Parachute
	[55012]	= 0,	-- Lok'lira's Bargain
	[55018]	= 10,	-- Sonic Awareness
	[55021]	= 4,	-- Silenced - Improved Counterspell (Rank 2)
	[55077]	= 5,	-- Pounce
	[55078]	= 15,	-- Blood Plague
	[55080]	= 8,	-- Shattered Barrier
	[55095]	= 15,	-- Frost Fever
	[55166]	= 20,	-- Tidal Force
	[55233]	= 10,	-- Vampiric Blood
	[55277]	= 15,	-- Stoneclaw Totem
	[55328]	= 15,	-- Stoneclaw Totem
	[55342]	= 30,	-- Mirror Image
	[55360]	= 12,	-- Living Bomb (Rank 3)
	[55428]	= 5,	-- Lifeblood (Rank 1)
	[55480]	= 5,	-- Lifeblood (Rank 2)
	[55502]	= 5,	-- Lifeblood (Rank 5)
	[55503]	= 5,	-- Lifeblood (Rank 6)
	[55531]	= 0,	-- Mechano-hog
	[55610]	= 0,	-- Improved Icy Talons
	[55629]	= 0,	-- First Lieutenant
	[55637]	= 15,	-- Lightweave
	[55694]	= 10,	-- Enraged Regeneration
	[55711]	= 600,	-- Weakened Heart
	[55741]	= 0,	-- Desecration
	[55753]	= 30,	-- Acid Spit (Rank 5)
	[55775]	= 15,	-- Swordguard Embroidery
	[55817]	= 3600,	-- Eck Residue
	[56112]	= 10,	-- Furious Attacks
	[56161]	= 6,	-- Glyph of Prayer of Healing
	[56222]	= 3,	-- Dark Command
	[56352]	= 12,	-- Storm Punch
	[56453]	= 12,	-- Lock and Load
	[56520]	= 600,	-- Blessing of Might (Rank 10)
	[56521]	= 1800,	-- Blessing of Wisdom
	[56525]	= 1800,	-- Blessing of Kings
	[56654]	= 0,	-- Rapid Recuperation
	[56778]	= 60,	-- Mana Shield
	[56827]	= 60,	-- Aura of Arcane Haste
	[56969]	= 8,	-- Arcane Blast
	[57054]	= 10,	-- Tranquility
	[57056]	= 0,	-- Aura of Regeneration
	[57063]	= 10,	-- Arcane Attraction
	[57073]	= 30,	-- Drink
	[57079]	= 3600,	-- Well Fed
	[57086]	= 0,	-- Frenzy
	[57097]	= 3600,	-- Well Fed
	[57100]	= 3600,	-- Well Fed
	[57102]	= 3600,	-- Well Fed
	[57107]	= 3600,	-- Well Fed
	[57111]	= 3600,	-- Well Fed
	[57139]	= 3600,	-- Well Fed
	[57286]	= 3600,	-- Well Fed
	[57288]	= 3600,	-- Well Fed
	[57291]	= 3600,	-- Well Fed
	[57294]	= 3600,	-- Well Fed
	[57325]	= 3600,	-- Well Fed
	[57327]	= 3600,	-- Well Fed
	[57329]	= 3600,	-- Well Fed
	[57330]	= 120,	-- Horn of Winter (Rank 1)
	[57332]	= 3600,	-- Well Fed
	[57334]	= 3600,	-- Well Fed
	[57348]	= 0,	-- Carrying an RP-GG
	[57350]	= 6,	-- Illusionary Barrier
	[57356]	= 3600,	-- Well Fed
	[57358]	= 3600,	-- Well Fed
	[57360]	= 3600,	-- Well Fed
	[57363]	= 3600,	-- Well Fed
	[57365]	= 3600,	-- Well Fed
	[57367]	= 3600,	-- Well Fed
	[57371]	= 3600,	-- Well Fed
	[57399]	= 3600,	-- Well Fed
	[57447]	= 0,	-- Kindred Spirits
	[57452]	= 0,	-- Kindred Spirits
	[57453]	= 0,	-- Kindred Spirits
	[57457]	= 0,	-- Kindred Spirits
	[57458]	= 0,	-- Kindred Spirits
	[57475]	= 0,	-- Kindred Spirits
	[57482]	= 0,	-- Kindred Spirits
	[57483]	= 0,	-- Kindred Spirits
	[57484]	= 0,	-- Kindred Spirits
	[57485]	= 0,	-- Kindred Spirits
	[57514]	= 12,	-- Enrage (Rank 1)
	[57516]	= 12,	-- Enrage (Rank 2)
	[57519]	= 12,	-- Enrage
	[57522]	= 12,	-- Enrage (Rank 5)
	[57524]	= 120,	-- Metanoia
	[57529]	= 0,	-- Arcane Potency
	[57531]	= 0,	-- Arcane Potency
	[57564]	= 0,	-- Fel Intelligence (Rank 2)
	[57565]	= 0,	-- Fel Intelligence (Rank 3)
	[57566]	= 0,	-- Fel Intelligence (Rank 4)
	[57567]	= 0,	-- Fel Intelligence (Rank 5)
	[57580]	= 5,	-- Lightning Infusion
	[57621]	= 0,	-- Strength of Earth (Rank 7)
	[57623]	= 120,	-- Horn of Winter (Rank 2)
	[57660]	= 0,	-- Totem of Wrath
	[57662]	= 0,	-- Totem of Wrath
	[57663]	= 0,	-- Totem of Wrath
	[57669]	= 15,	-- Replenishment
	[57723]	= 600,	-- Exhaustion
	[57724]	= 600,	-- Sated
	[57761]	= 15,	-- Fireball!
	[57819]	= 0,	-- Argent Champion
	[57820]	= 0,	-- Ebon Champion
	[57821]	= 0,	-- Champion of the Kirin Tor
	[57822]	= 0,	-- Wyrmrest Champion
	[57833]	= 4,	-- Frost Spit
	[57933]	= 6,	-- Tricks of the Trade
	[57934]	= 30,	-- Tricks of the Trade
	[57940]	= 0,	-- Essence of Wintergrasp
	[57960]	= 600,	-- Water Shield (Rank 9)
	[57969]	= 12,	-- Deadly Poison VIII (Rank 8)
	[57970]	= 12,	-- Deadly Poison IX (Rank 9)
	[57974]	= 10,	-- Wound Poison VI (Rank 6)
	[57975]	= 15,	-- Wound Poison VII (Rank 7)
	[57993]	= 6,	-- Envenom (Rank 4)
	[58045]	= 0,	-- Essence of Wintergrasp
	[58179]	= 12,	-- Infected Wounds
	[58180]	= 12,	-- Infected Wounds
	[58181]	= 12,	-- Infected Wounds
	[58269]	= 0,	-- Iceskin Stoneform
	[58363]	= 10,	-- Glyph of Revenge
	[58371]	= 180,	-- Recently Slain
	[58374]	= 10,	-- Glyph of Blocking
	[58427]	= 20,	-- Overkill
	[58448]	= 1800,	-- Strength (Rank 7)
	[58449]	= 1800,	-- Strength (Rank 8)
	[58450]	= 1800,	-- Agility (Rank 7)
	[58451]	= 1800,	-- Agility (Rank 8)
	[58452]	= 1800,	-- Armor (Rank 7)
	[58468]	= 3600,	-- Hugely Well Fed
	[58479]	= 3600,	-- Nearly Well Fed
	[58493]	= 3600,	-- Mohawked!
	[58496]	= 7200,	-- Sad
	[58499]	= 7200,	-- Happy
	[58500]	= 7200,	-- Angry
	[58501]	= 600,	-- Iron Boot Flask
	[58502]	= 7200,	-- Scared
	[58511]	= 45,	-- Rotten Apple Aroma
	[58514]	= 45,	-- Rotten Banana Aroma
	[58519]	= 45,	-- Spit
	[58549]	= 0,	-- Tenacity
	[58555]	= 0,	-- Great Honor
	[58556]	= 0,	-- Greater Honor
	[58557]	= 0,	-- Greatest Honor
	[58567]	= 30,	-- Sunder Armor (Rank 1)
	[58578]	= 20,	-- Icy Talons
	[58591]	= 15,	-- Stoneclaw Totem
	[58597]	= 6,	-- Sacred Shield (Rank 1)
	[58600]	= 10,	-- Restricted Flight Area
	[58610]	= 10,	-- Lava Breath (Rank 5)
	[58611]	= 10,	-- Lava Breath (Rank 6)
	[58617]	= 10,	-- Glyph of Heart Strike
	[58646]	= 0,	-- Strength of Earth (Rank 8)
	[58651]	= 0,	-- Flametongue Totem (Rank 6)
	[58655]	= 0,	-- Flametongue Totem (Rank 8)
	[58683]	= 0,	-- Savage Combat (Rank 2)
	[58729]	= 0,	-- Spiritual Immunity
	[58730]	= 9,	-- Restricted Flight Area
	[58740]	= 0,	-- Fire Resistance (Rank 6)
	[58744]	= 0,	-- Frost Resistance (Rank 6)
	[58750]	= 0,	-- Nature Resistance (Rank 6)
	[58752]	= 0,	-- Stoneskin (Rank 9)
	[58754]	= 0,	-- Stoneskin (Rank 10)
	[58775]	= 0,	-- Mana Spring (Rank 6)
	[58776]	= 0,	-- Mana Spring (Rank 7)
	[58777]	= 0,	-- Mana Spring (Rank 8)
	[58799]	= 8,	-- Frostbrand Attack (Rank 9)
	[58861]	= 2,	-- Bash (Rank 1)
	[58875]	= 15,	-- Spirit Walk
	[58882]	= 6,	-- Rapid Recuperation
	[58891]	= 45,	-- Wild Magic
	[58914]	= 30,	-- Kill Command (Rank 1)
	[58984]	= 0,	-- Shadowmeld (Racial)
	[58999]	= 0,	-- Big Blizzard Bear
	[59000]	= 8,	-- Improved Spirit Tap (Rank 2)
	[59052]	= 0,	-- Freezing Fog
	[59125]	= 120,	-- Lucky
	[59164]	= 12,	-- Haunt (Rank 4)
	[59230]	= 3600,	-- Well Fed
	[59542]	= 15,	-- Gift of the Naaru (Racial)
	[59547]	= 15,	-- Gift of the Naaru (Racial)
	[59548]	= 15,	-- Gift of the Naaru (Racial)
	[59568]	= 0,	-- Blue Drake
	[59569]	= 0,	-- Bronze Drake
	[59570]	= 0,	-- Red Drake
	[59578]	= 15,	-- The Art of War (Rank 2)
	[59620]	= 15,	-- Berserk
	[59626]	= 10,	-- Black Magic
	[59628]	= 6,	-- Tricks of the Trade
	[59638]	= 4,	-- Frostbolt
	[59650]	= 0,	-- Black Drake
	[59658]	= 15,	-- Argent Heroism
	[59671]	= 6,	-- Challenging Howl (Demon)
	[59674]	= 1800,	-- Moonshroud Residue
	[59675]	= 1800,	-- Nexus Residue
	[59676]	= 1800,	-- Residue of Darkness
	[59725]	= 5,	-- Spell Reflection
	[59752]	= 0,	-- Every Man for Himself (Racial)
	[59785]	= 0,	-- Black War Mammoth
	[59788]	= 0,	-- Black War Mammoth
	[59793]	= 0,	-- Wooly Mammoth
	[59797]	= 0,	-- Ice Mammoth
	[59843]	= 600,	-- Underbelly Elixir
	[59882]	= 9,	-- Rake (Rank 2)
	[59883]	= 9,	-- Rake (Rank 3)
	[59884]	= 9,	-- Rake (Rank 4)
	[59885]	= 9,	-- Rake (Rank 5)
	[59886]	= 9,	-- Rake (Rank 6)
	[59888]	= 6,	-- Borrowed Time
	[59889]	= 6,	-- Borrowed Time
	[59891]	= 6,	-- Borrowed Time
	[59911]	= 0,	-- Tenacity
	[59961]	= 0,	-- Red Proto-Drake
	[59996]	= 0,	-- Blue Proto-Drake
	[60002]	= 0,	-- Time-Lost Proto-Drake
	[60024]	= 0,	-- Violet Proto-Drake
	[60025]	= 0,	-- Albino Drake
	[60053]	= 2,	-- Explosive Shot (Rank 4)
	[60062]	= 10,	-- Essence of Life
	[60064]	= 10,	-- Now is the time!
	[60065]	= 10,	-- Reflection of Torment
	[60097]	= 10,	-- Feeding Frenzy (Rank 2)
	[60106]	= 300,	-- Old Spices
	[60114]	= 0,	-- Armored Brown Bear
	[60116]	= 0,	-- Armored Brown Bear
	[60118]	= 0,	-- Black War Bear
	[60119]	= 0,	-- Black War Bear
	[60122]	= 30,	-- Baby Spice
	[60196]	= 12,	-- Berserker!
	[60210]	= 10,	-- Freezing Arrow Effect (Rank 1) (PvP duration)
	[60214]	= 0,	-- Seal of the Pantheon
	[60215]	= 0,	-- Lavanthor's Talisman
	[60218]	= 0,	-- Essence of Gossamer
	[60229]	= 15,	-- Greatness
	[60233]	= 15,	-- Greatness
	[60234]	= 15,	-- Greatness
	[60299]	= 20,	-- Incisor Fragment
	[60302]	= 10,	-- Meteorite Whetstone
	[60305]	= 20,	-- Heart of a Dragon
	[60314]	= 10,	-- Fury of the Five Flights
	[60318]	= 13,	-- Edward's Insight
	[60340]	= 3600,	-- Accuracy
	[60341]	= 3600,	-- Deadly Strikes
	[60343]	= 3600,	-- Mighty Defense
	[60344]	= 3600,	-- Expertise
	[60345]	= 3600,	-- Armor Piercing
	[60346]	= 3600,	-- Lightning Speed
	[60347]	= 3600,	-- Mighty Thoughts
	[60424]	= 0,	-- Mekgineer's Chopper
	[60433]	= 12,	-- Earth and Moon
	[60437]	= 10,	-- Grim Toll
	[60479]	= 10,	-- Forge Ember
	[60486]	= 10,	-- Illustration of the Dragon Soul
	[60494]	= 10,	-- Dying Curse
	[60503]	= 9,	-- Taste for Blood
	[60512]	= 15,	-- Healing Trance
	[60517]	= 20,	-- Talisman of Troll Divinity
	[60518]	= 10,	-- Touched by a Troll
	[60520]	= 15,	-- Spark of Life
	[60525]	= 10,	-- Majestic Dragon Figurine
	[60530]	= 12,	-- Forethought Talisman
	[60549]	= 10,	-- Deadly Aggression
	[60551]	= 10,	-- Furious Gladiator's Libram of Fortitude
	[60553]	= 10,	-- Relentless Aggression
	[60568]	= 10,	-- Furious Gladiator's Idol of Steadfastness
	[60569]	= 10,	-- Relentless Survival
	[60819]	= 10,	-- Libram of Reciprocation
	[60946]	= 4,	-- Nightmare
	[60947]	= 5,	-- Nightmare
	[60956]	= 0,	-- Improved Health Funnel
	[60970]	= 0.1,	-- Heroic Fury
	[61024]	= 1800,	-- Dalaran Intellect (Rank 7)
	[61044]	= 15,	-- Demoralizing Shout
	[61198]	= 6,	-- Spirit Strike (Rank 6)
	[61258]	= 5,	-- Runic Return (Rank 2)
	[61291]	= 8,	-- Shadowflame
	[61294]	= 0,	-- Green Proto-Drake
	[61295]	= 15,	-- Riptide
	[61299]	= 15,	-- Riptide (Rank 2)
	[61301]	= 15,	-- Riptide (Rank 4)
	[61305]	= 50,	-- Polymorph (cat)
	[61309]	= 0,	-- Magnificent Flying Carpet
	[61316]	= 3600,	-- Dalaran Brilliance (Rank 3)
	[61336]	= 20,	-- Survival Instincts
	[61391]	= 6,	-- Typhoon
	[61394]	= 4,	-- Glyph of Freezing Trap
	[61425]	= 0,	-- Traveler's Tundra Mammoth
	[61427]	= 20,	-- Infinite Speed
	[61447]	= 0,	-- Traveler's Tundra Mammoth
	[61451]	= 0,	-- Flying Carpet
	[61465]	= 0,	-- Grand Black War Mammoth
	[61467]	= 0,	-- Grand Black War Mammoth
	[61469]	= 0,	-- Grand Ice Mammoth
	[61470]	= 0,	-- Grand Ice Mammoth
	[61485]	= 60,	-- Dreadful Roar
	[61573]	= 0,	-- Banner of the Alliance
	[61619]	= 10,	-- Tentacles
	[61669]	= 0,	-- Aspect of the Beast
	[61671]	= 10,	-- Crusader's Glory
	[61684]	= 16,	-- Dash
	[61685]	= 4,	-- Charge
	[61721]	= 50,	-- Polymorph (Rabbit)
	[61792]	= 10,	-- Shadowy Insight
	[61840]	= 8,	-- Righteous Vengeance
	[61846]	= 0,	-- Aspect of the Dragonhawk (Rank 1)
	[61847]	= 0,	-- Aspect of the Dragonhawk (Rank 2)
	[61858]	= 0,	-- Plague Slime
	[61882]	= 8,	-- Earthquake
	[62061]	= 3600,	-- Festive Holiday Mount
	[62064]	= 0,	-- Tower Control
	[62124]	= 3,	-- Hand of Reckoning
	[62146]	= 30,	-- Unflinching Valor
	[62305]	= 4,	-- Master's Call
	[62380]	= 7200,	-- Lesser Flask of Resistance
	[62408]	= 300,	-- Ethereal Oil
	[62552]	= 0,	-- Defend
	[62574]	= 0,	-- Warts-B-Gone Lip Balm
	[62606]	= 10,	-- Savage Defense
	[63058]	= 20,	-- Glyph of Amberskin Protection
	[63087]	= 5,	-- Raptor Strike
	[63167]	= 10,	-- Decimation
	[63232]	= 0,	-- Stormwind Steed
	[63243]	= 10,	-- Pyroclasm
	[63244]	= 10,	-- Pyroclasm
	[63250]	= 10,	-- Jouster's Fury
	[63283]	= 300,	-- Totem of Wrath
	[63311]	= 8,	-- Glyph of Shadowflame
	[63321]	= 40,	-- Life Tap
	[63433]	= 0,	-- Orgrimmar Champion's Pennant
	[63438]	= 0,	-- Silvermoon Champion's Pennant
	[63468]	= 8,	-- Piercing Shots
	[63500]	= 0,	-- Argent Crusade Valiant's Pennant
	[63529]	= 3,	-- Silenced - Shield of the Templar
	[63560]	= 30,	-- Dark Transformation
	[63619]	= 5,	-- Shadowcrawl
	[63635]	= 0,	-- Darkspear Raptor
	[63637]	= 0,	-- Darnassian Nightsaber
	[63640]	= 0,	-- Orgrimmar Wolf
	[63641]	= 0,	-- Thunder Bluff Kodo
	[63643]	= 0,	-- Forsaken Warhorse
	[63665]	= 0,	-- Charge
	[63668]	= 15,	-- Black Arrow (Rank 2)
	[63672]	= 15,	-- Black Arrow (Rank 6)
	[63685]	= 5,	-- Freeze
	[63725]	= 8,	-- Holy Concentration
	[63729]	= 3600,	-- Elixir of Minor Accuracy
	[63734]	= 20,	-- Serendipity
	[63735]	= 20,	-- Serendipity
	[63844]	= 0,	-- Argent Hippogryph
	[63848]	= 60,	-- Hunger For Blood
	[63896]	= 12,	-- Bullheaded
	[63944]	= 60,	-- Renewed Hope
	[63956]	= 0,	-- Ironbound Proto-Drake
	[63963]	= 0,	-- Rusted Proto-Drake
	[64044]	= 3,	-- Psychic Horror
	[64057]	= 3600,	-- Well Fed
	[64058]	= 10,	-- Psychic Horror
	[64128]	= 4,	-- Body and Soul
	[64205]	= 10,	-- Divine Sacrifice
	[64343]	= 10,	-- Impact (Rank 1)
	[64368]	= 10,	-- Eradication
	[64370]	= 10,	-- Eradication
	[64371]	= 10,	-- Eradication
	[64373]	= 0,	-- Armistice
	[64382]	= 10,	-- Shattering Throw
	[64419]	= 15,	-- Sniper Training (Rank 3)
	[64420]	= 15,	-- Sniper Training (Rank 3)
	[64440]	= 10,	-- Blade Warding
	[64491]	= 20,	-- Furious Howl (Rank 2)
	[64492]	= 20,	-- Furious Howl (Rank 3)
	[64493]	= 20,	-- Furious Howl (Rank 4)
	[64494]	= 0,	-- Furious Howl (Rank 5)
	[64495]	= 20,	-- Furious Howl (Rank 6)
	[64524]	= 20,	-- Platinum Disks of Battle
	[64568]	= 20,	-- Blood Reserve
	[64657]	= 0,	-- White Kodo
	[64658]	= 0,	-- Black Wolf
	[64659]	= 0,	-- Venomhide Ravasaur
	[64695]	= 5,	-- Earthgrab
	[64701]	= 15,	-- Elemental Mastery
	[64731]	= 0,	-- Sea Turtle
	[64803]	= 4,	-- Entrapment
	[64804]	= 4,	-- Entrapment
	[64810]	= 0,	-- Bested Ironforge
	[64843]	= 5,	-- Divine Hymn (Rank 1)
	[64844]	= 8,	-- Divine Hymn
	[64850]	= 6,	-- Unrelenting Assault
	[64855]	= 10,	-- Blade Barrier (Rank 2)
	[64856]	= 10,	-- Blade Barrier (Rank 3)
	[64859]	= 10,	-- Blade Barrier (Rank 5)
	[64861]	= 15,	-- Precision Shots
	[64901]	= 8,	-- Hymn of Hope
	[64904]	= 8,	-- Hymn of Hope
	[64937]	= 5,	-- Heightened Reflexes
	[64951]	= 12,	-- Primal Wrath (Rank 5)
	[64977]	= 0,	-- Black Skeletal Horse
	[65006]	= 10,	-- Eye of the Broodmother
	[65014]	= 10,	-- Pyrite Infusion
	[65019]	= 10,	-- Mjolnir Runestone
	[65081]	= 4,	-- Body and Soul
	[65142]	= 21,	-- Ebon Plague
	[65156]	= 10,	-- Juggernaut
	[65247]	= 3514,	-- Well Fed
	[65264]	= 6,	-- Lava Flows
	[65637]	= 0,	-- Great Red Elekk
	[65638]	= 0,	-- Swift Moonsaber
	[65639]	= 0,	-- Swift Red Hawkstrider
	[65640]	= 0,	-- Swift Gray Steed
	[65641]	= 0,	-- Great Golden Kodo
	[65642]	= 0,	-- Turbostrider
	[65644]	= 0,	-- Swift Purple Raptor
	[65645]	= 0,	-- White Skeletal Warhorse
	[65646]	= 0,	-- Swift Burgundy Wolf
	[65745]	= 300,	-- Path of Cenarius
	[65780]	= 300,	-- Pink Gumball
	[66088]	= 0,	-- Sunreaver Dragonhawk
	[66090]	= 0,	-- Quel'dorei Steed
	[66091]	= 0,	-- Sunreaver Hawkstrider
	[66122]	= 0,	-- Magic Rooster
	[66157]	= 0,	-- Honorable Defender
	[66233]	= 120,	-- Ardent Defender
	[66251]	= 8,	-- Launch
	[66550]	= 20,	-- Teleport
	[66684]	= 0,	-- Flaming Cinder
	[66721]	= 0,	-- Burning Fury
	[66725]	= 15,	-- Meteor Fists
	[66776]	= 0,	-- Rage
	[66803]	= 20,	-- Desolation
	[66808]	= 15,	-- Meteor Fists
	[66846]	= 0,	-- Ochre Skeletal Warhorse
	[66906]	= 0,	-- Argent Charger (Summon)
	[66922]	= 12,	-- Flash of Light
	[67016]	= 3600,	-- Flask of the North
	[67017]	= 3600,	-- Flask of the North
	[67018]	= 3600,	-- Flask of the North
	[67117]	= 15,	-- Unholy Might
	[67332]	= 0,	-- Flaming Cinder
	[67354]	= 9,	-- Evasion (Rank 5)
	[67355]	= 16,	-- Agile
	[67358]	= 9,	-- Rejuvenating
	[67360]	= 12,	-- Blessing of the Moon Goddess
	[67364]	= 15,	-- Holy Judgement
	[67371]	= 16,	-- Holy Strength
	[67378]	= 18,	-- Evasion (Rank 1)
	[67380]	= 20,	-- Evasion (Rank 1)
	[67383]	= 20,	-- Unholy Force (Rank 1)
	[67385]	= 12,	-- Energized
	[67388]	= 15,	-- Spiritual Trance
	[67391]	= 18,	-- Volcanic Fury
	[67466]	= 0,	-- Argent Warhorse
	[67596]	= 15,	-- Tremendous Fortitude
	[67631]	= 10,	-- Aegis
	[67669]	= 10,	-- Elusive Power
	[67671]	= 10,	-- Fury
	[67683]	= 20,	-- Celerity
	[67684]	= 20,	-- Hospitality
	[67694]	= 20,	-- Defensive Tactics
	[67695]	= 20,	-- Rage
	[67696]	= 10,	-- Energized
	[67703]	= 15,	-- Paragon
	[67708]	= 15,	-- Paragon
	[67713]	= 0,	-- Mote of Flame
	[67735]	= 0,	-- Volatility
	[67736]	= 20,	-- Volatile Power
	[67737]	= 0,	-- Risen Fury
	[67738]	= 20,	-- Rising Fury
	[67811]	= 12,	-- Dagger Throw
	[67890]	= 3,	-- Cobalt Frag Bomb
	[68054]	= 600,	-- Pressing Engagement
	[68055]	= 20,	-- Judgements of the Just (Rank 1)
	[68056]	= 0,	-- Swift Horde Wolf
	[68057]	= 0,	-- Swift Alliance Steed
	[68160]	= 15,	-- Meteor Fists
	[68161]	= 15,	-- Meteor Fists
	[68188]	= 0,	-- Crusader's Black Warhorse
	[68269]	= 0,	-- The Brewmaiden's Blessing (Rank 6)
	[68298]	= 5,	-- Parachute
	[68377]	= 0,	-- Carrying Huge Seaforium
	[68652]	= 0,	-- Honorable Defender
	[68719]	= 0,	-- Oil Refinery
	[68720]	= 0,	-- Quarry
	[68722]	= 0,	-- Oil Refinery
	[68766]	= 0,	-- Desecration
	[69180]	= 30,	-- Gutgore Ripper
	[69369]	= 8,	-- Predator's Swiftness
	[70013]	= 0,	-- Quel'Delar's Compulsion
	[70029]	= 0,	-- The Beast Within
	[70244]	= 3600,	-- \"Wizardry\" Cologne
	[70338] = 15,   -- Necrotic Plague
	[73786] = 15,   -- Necrotic Plague
	[73914] = 15,   -- Necrotic Plague
	[73787] = 15,   -- Necrotic Plague
	[73913] = 15,   -- Necrotic Plague
	[70337] = 15,   -- Necrotic Plague
	[73785] = 15,   -- Necrotic Plague
	[73912] = 15,   -- Necrotic Plague
	[70639]	= 8,	-- Call of Sylvanas
	[70657]	= 15,	-- Advantage (Rank 5)
	[70691]	= 15,	-- Rejuvenation
	[70721]	= 6,	-- Omen of Doom
	[70725]	= 10,	-- Enraged Defense
	[70728]	= 10,	-- Exploit Weakness
	[70747]	= 30,	-- Quad Core
	[70753]	= 5,	-- Pushing the Limit
	[70757]	= 10,	-- Holiness (Rank 5)
	[70760]	= 10,	-- Deliverance
	[70772]	= 9,	-- Blessed Healing
	[70806]	= 10,	-- Rapid Currents
	[70840]	= 10,	-- Devious Minds
	[70845]	= 10,	-- Stoicism
	[70855]	= 10,	-- Blood Drinker
	[70893]	= 10,	-- Culling the Herd
	[70940]	= 6,	-- Divine Guardian
	[71007]	= 10,	-- Stinger
	[71041]	= 1800,	-- Dungeon Deserter
	[71165]	= 15,	-- Molten Core
	[71175]	= 15,	-- Agile
	[71177]	= 15,	-- Vicious
	[71184]	= 15,	-- Soothing
	[71187]	= 15,	-- Formidable
	[71192]	= 15,	-- Blessed
	[71197]	= 15,	-- Evasive
	[71199]	= 30,	-- Furious
	[71216]	= 15,	-- Enraged
	[71220]	= 15,	-- Energized
	[71227]	= 15,	-- Indomitable
	[71345]	= 0,	-- Big Love Rocket
	[71396]	= 10,	-- Rage of the Fallen
	[71401]	= 15,	-- Icy Rage
	[71403]	= 10,	-- Fatal Flaws
	[71432]	= 0,	-- Mote of Anger
	[71484]	= 30,	-- Strength of the Taunka
	[71485]	= 30,	-- Agility of the Vrykul
	[71486]	= 30,	-- Power of the Taunka
	[71491]	= 30,	-- Aim of the Iron Dwarves
	[71492]	= 30,	-- Speed of the Vrykul
	[71560]	= 30,	-- Speed of the Vrykul
	[71564]	= 20,	-- Deadly Precision
	[71568]	= 20,	-- Urgency
	[71570]	= 10,	-- Cultivated Power
	[71572]	= 10,	-- Cultivated Power
	[71579]	= 20,	-- Elusive Power
	[71584]	= 15,	-- Revitalized
	[71586]	= 10,	-- Hardened Skin
	[71600]	= 0,	-- Surging Power
	[71601]	= 20,	-- Surge of Power
	[71633]	= 10,	-- Thick Skin
	[71824]	= 6,	-- Lava Burst
	[71864]	= 0,	-- Fountain of Light
	[71866]	= 6,	-- Fountain of Light
	[71870]	= 10,	-- Blessing of Light
	[71875]	= 10,	-- Necrotic Touch
	[71877]	= 10,	-- Necrotic Touch
	[71882]	= 10,	-- Invigoration
	[71993]	= 0,	-- Frozen Mallet
	[72004]	= 20,	-- Frostbite
	[72034]	= 0,	-- Whiteout
	[72081]	= 0,	-- Frozen Orb
	[72096]	= 0,	-- Whiteout
	[72098]	= 20,	-- Frostbite
	[72104]	= 5,	-- Freezing Ground
	[72121]	= 10,	-- Frostbite
	[72122]	= 0,	-- Frozen Mallet
	[72221]	= 0,	-- Luck of the Draw
	[72282]	= 0,	-- Invincible
	[72412]	= 10,	-- Frostforged Champion
	[72414]	= 10,	-- Frostforged Defender
	[72416]	= 10,	-- Frostforged Sage
	[72418]	= 10,	-- Chilling Knowledge
	[72586]	= 1800,	-- Blessing of Forgotten Kings
	[72588]	= 3600,	-- Gift of the Wild
	[72590]	= 3600,	-- Fortitude
	[72808]	= 0,	-- Bloodbathed Frostbrood Vanquisher
	[72968]	= 0,	-- Precious's Ribbon
	[73313]	= 0,	-- Crimson Deathcharger (Summon)
	[73320]	= 600,	-- Frostborn Illusion
	[73413]	= 1800,	-- Inner Will
	[73651]	= 0,	-- Recuperate
	[73681]	= 12,	-- Unleash Wind
	[73682]	= 5,	-- Unleash Frost
	[73683]	= 8,	-- Unleash Flame
	[73685]	= 8,	-- Unleash Life
	[73975]	= 15,	-- Necrotic Strike
	[74001]	= 30,	-- Combat Readiness
	[74002]	= 6,	-- Combat Insight
	[74347]	= 3,	-- Silenced - Gag Order
	[74396]	= 15,	-- Fingers of Frost
	[74434]	= 15,	-- Soulburn
	[74855]	= 0,	-- Blazing Hippogryph
	[74960]	= 10,	-- Infrigidate
	[75446]	= 0,	-- Ferocious Inspiration
	[75447]	= 0,	-- Ferocious Inspiration
	[75458]	= 15,	-- Piercing Twilight
	[75593]	= 0,	-- Ferocious Inspiration
	[75596]	= 0,	-- Frosty Flying Carpet
	[75617]	= 0,	-- Celestial Steed
	[75618]	= 0,	-- Celestial Steed
	[75619]	= 0,	-- Celestial Steed
	[75620]	= 0,	-- Celestial Steed
	[75731]	= 0,	-- Instant Statue
	[75957]	= 0,	-- X-53 Touring Rocket
	[75972]	= 0,	-- X-53 Touring Rocket
}

lib.spellDebuffType = {
	[17]	= 1,	-- Power Word: Shield
	[66]	= 6,	-- Invisibility
	[67]	= 1,	-- Vindication (Rank 1)
	[113]	= 1,	-- Chains of Ice (Rank 1)
	[116]	= 1,	-- Frostbolt (Rank 1)
	[118]	= 1,	-- Polymorph (Rank 1)
	[120]	= 1,	-- Cone of Cold (Rank 1)
	[122]	= 1,	-- Frost Nova (Rank 1)
	[130]	= 1,	-- Slow Fall
	[132]	= 1,	-- Detect Invisibility
	[136]	= 1,	-- Mend Pet
	[139]	= 1,	-- Renew (Rank 1)
	[172]	= 1,	-- Corruption (Rank 1)
	[324]	= 1,	-- Lightning Shield (Rank 1)
	[325]	= 1,	-- Lightning Shield (Rank 2)
	[339]	= 1,	-- Entangling Roots (Rank 1)
	[348]	= 1,	-- Immolate (Rank 1)
	[467]	= 1,	-- Thorns (Rank 1)
	[498]	= 1,	-- Divine Protection
	[543]	= 1,	-- Fire Ward (Rank 1)
	[552]	= 1,	-- Abolish Disease
	[589]	= 1,	-- Shadow Word: Pain (Rank 1)
	[592]	= 1,	-- Power Word: Shield (Rank 2)
	[594]	= 1,	-- Shadow Word: Pain (Rank 2)
	[600]	= 1,	-- Power Word: Shield (Rank 3)
	[603]	= 4,	-- Bane of Doom
	[604]	= 1,	-- Dampen Magic (Rank 1)
	[605]	= 1,	-- Mind Control
	[642]	= 1,	-- Divine Shield
	[689]	= 1,	-- Drain Life (Rank 1)
	[699]	= 1,	-- Drain Life (Rank 2)
	[700]	= 1,	-- Sleep (Rank 1)
	[702]	= 4,	-- Curse of Weakness (Rank 1)
	[707]	= 1,	-- Immolate (Rank 2)
	[709]	= 1,	-- Drain Life (Rank 3)
	[710]	= 1,	-- Banish (Rank 1)
	[744]	= 3,	-- Poison
	[770]	= 1,	-- Faerie Fire
	[774]	= 1,	-- Rejuvenation (Rank 1)
	[782]	= 1,	-- Thorns (Rank 2)
	[837]	= 1,	-- Frostbolt (Rank 3)
	[853]	= 1,	-- Hammer of Justice (Rank 1)
	[865]	= 1,	-- Frost Nova (Rank 2)
	[905]	= 1,	-- Lightning Shield (Rank 3)
	[945]	= 1,	-- Lightning Shield (Rank 4)
	[970]	= 1,	-- Shadow Word: Pain (Rank 3)
	[974]	= 1,	-- Earth Shield
	[976]	= 1,	-- Shadow Protection (Rank 1)
	[980]	= 4,	-- Curse of Agony (Rank 1)
	[992]	= 1,	-- Shadow Word: Pain (Rank 4)
	[1008]	= 1,	-- Amplify Magic (Rank 1)
	[1014]	= 4,	-- Curse of Agony (Rank 2)
	[1022]	= 1,	-- Hand of Protection
	[1038]	= 1,	-- Hand of Salvation
	[1044]	= 1,	-- Hand of Freedom
	[1062]	= 1,	-- Entangling Roots (Rank 2)
	[1075]	= 1,	-- Thorns (Rank 3)
	[1094]	= 1,	-- Immolate (Rank 3)
	[1108]	= 4,	-- Curse of Weakness (Rank 2)
	[1126]	= 1,	-- Mark of the Wild (Rank 1)
	[1130]	= 1,	-- Hunter's Mark (Rank 1)
	[1243]	= 1,	-- Power Word: Fortitude (Rank 1)
	[1244]	= 1,	-- Power Word: Fortitude (Rank 2)
	[1245]	= 1,	-- Power Word: Fortitude (Rank 3)
	[1430]	= 1,	-- Rejuvenation (Rank 3)
	[1459]	= 1,	-- Arcane Intellect (Rank 1)
	[1460]	= 1,	-- Arcane Intellect (Rank 2)
	[1461]	= 1,	-- Arcane Intellect (Rank 3)
	[1463]	= 1,	-- Mana Shield (Rank 1)
	[1490]	= 4,	-- Curse of the Elements (Rank 1)
	[1513]	= 1,	-- Scare Beast (Rank 1)
	[1706]	= 1,	-- Levitate
	[1714]	= 4,	-- Curse of Tongues
	[1978]	= 3,	-- Serpent Sting
	[2090]	= 1,	-- Rejuvenation (Rank 4)
	[2091]	= 1,	-- Rejuvenation (Rank 5)
	[2601]	= 1,	-- Fire Shield III
	[2602]	= 1,	-- Fire Shield IV
	[2645]	= 1,	-- Ghost Wolf
	[2767]	= 1,	-- Shadow Word: Pain (Rank 5)
	[2791]	= 1,	-- Power Word: Fortitude (Rank 4)
	[2812]	= 1,	-- Holy Wrath
	[2818]	= 3,	-- Deadly Poison (Rank 1)
	[2819]	= 3,	-- Deadly Poison II (Rank 2)
	[2825]	= 1,	-- Bloodlust
	[2893]	= 1,	-- Abolish Poison
	[2941]	= 1,	-- Immolate (Rank 4)
	[2944]	= 2,	-- Devouring Plague (Rank 1)
	[2947]	= 1,	-- Fire Shield (Rank 1)
	[3034]	= 3,	-- Viper Sting
	[3043]	= 3,	-- Scorpid Sting
	[3256]	= 2,	-- Plague Cloud
	[3355]	= 1,	-- Freezing Trap Effect (Rank 1)
	[3356]	= 1,	-- Flame Lash
	[3409]	= 3,	-- Crippling Poison
	[3427]	= 2,	-- Infected Wound
	[3436]	= 2,	-- Wandering Plague
	[3439]	= 2,	-- Wandering Plague
	[3583]	= 3,	-- Deadly Poison
	[3600]	= 1,	-- Earthbind
	[3627]	= 1,	-- Rejuvenation (Rank 6)
	[3661]	= 1,	-- Mend Pet (Rank 3)
	[3662]	= 1,	-- Mend Pet (Rank 4)
	[3674]	= 1,	-- Black Arrow
	[3747]	= 1,	-- Power Word: Shield (Rank 4)
	[3815]	= 3,	-- Poison Cloud
	[4167]	= 1,	-- Web (Rank 1)
	[4318]	= 1,	-- Guile of the Raptor
	[5115]	= 1,	-- Battle Command
	[5137]	= 4,	-- Call of the Grave
	[5138]	= 1,	-- Drain Mana
	[5195]	= 1,	-- Entangling Roots (Rank 3)
	[5196]	= 1,	-- Entangling Roots (Rank 4)
	[5232]	= 1,	-- Mark of the Wild (Rank 2)
	[5234]	= 1,	-- Mark of the Wild (Rank 4)
	[5262]	= 1,	-- Fanatic Blade
	[5403]	= 1,	-- Crash of Waves
	[5413]	= 2,	-- Noxious Catalyst
	[5484]	= 1,	-- Howl of Terror (Rank 1)
	[5570]	= 1,	-- Insect Swarm
	[5588]	= 1,	-- Hammer of Justice (Rank 2)
	[5589]	= 1,	-- Hammer of Justice (Rank 3)
	[5599]	= 1,	-- Hand of Protection (Rank 2)
	[5760]	= 3,	-- Mind-numbing Poison
	[5782]	= 1,	-- Fear (Rank 1)
	[6065]	= 1,	-- Power Word: Shield (Rank 5)
	[6066]	= 1,	-- Power Word: Shield (Rank 6)
	[6074]	= 1,	-- Renew (Rank 2)
	[6075]	= 1,	-- Renew (Rank 3)
	[6076]	= 1,	-- Renew (Rank 4)
	[6077]	= 1,	-- Renew (Rank 5)
	[6078]	= 1,	-- Renew (Rank 6)
	[6131]	= 1,	-- Frost Nova (Rank 3)
	[6136]	= 1,	-- Chilled (Rank 1)
	[6143]	= 1,	-- Frost Ward (Rank 1)
	[6146]	= 1,	-- Slow (Rank 2)
	[6205]	= 4,	-- Curse of Weakness (Rank 3)
	[6213]	= 1,	-- Fear (Rank 2)
	[6215]	= 1,	-- Fear (Rank 3)
	[6217]	= 4,	-- Curse of Agony (Rank 3)
	[6222]	= 1,	-- Corruption (Rank 2)
	[6223]	= 1,	-- Corruption (Rank 3)
	[6229]	= 1,	-- Shadow Ward
	[6278]	= 2,	-- Creeping Mold
	[6306]	= 3,	-- Acid Splash
	[6346]	= 1,	-- Fear Ward
	[6358]	= 1,	-- Seduction
	[6726]	= 1,	-- Silence
	[6728]	= 1,	-- Enveloping Winds (Rank 1)
	[6742]	= 1,	-- Bloodlust
	[6756]	= 1,	-- Mark of the Wild (Rank 3)
	[6789]	= 1,	-- Death Coil (Rank 1)
	[6940]	= 1,	-- Hand of Sacrifice
	[6950]	= 1,	-- Faerie Fire
	[7038]	= 4,	-- Forsaken Skill: Swords
	[7039]	= 4,	-- Forsaken Skill: Axes
	[7040]	= 4,	-- Forsaken Skill: Daggers
	[7041]	= 4,	-- Forsaken Skill: Maces
	[7042]	= 4,	-- Forsaken Skill: Staves
	[7044]	= 4,	-- Forsaken Skill: Guns
	[7045]	= 4,	-- Forsaken Skill: 2H Axes
	[7046]	= 4,	-- Forsaken Skill: 2H Maces
	[7047]	= 4,	-- Forsaken Skill: 2H Swords
	[7049]	= 4,	-- Forsaken Skill: Fire
	[7051]	= 4,	-- Forsaken Skill: Holy
	[7053]	= 4,	-- Forsaken Skill: Shadow
	[7054]	= 4,	-- Forsaken Skills
	[7057]	= 4,	-- Haunting Spirits
	[7068]	= 4,	-- Veil of Shadow
	[7074]	= 1,	-- Screams of the Past
	[7124]	= 4,	-- Arugal's Gift
	[7125]	= 3,	-- Toxic Saliva
	[7127]	= 1,	-- Wavering Will
	[7140]	= 1,	-- Expose Weakness
	[7295]	= 1,	-- Soul Drain
	[7321]	= 1,	-- Chilled (Rank 1)
	[7322]	= 1,	-- Frostbolt (Rank 4)
	[7399]	= 1,	-- Terrify
	[7621]	= 4,	-- Arugal's Curse
	[7648]	= 1,	-- Corruption (Rank 4)
	[7651]	= 1,	-- Drain Life (Rank 4)
	[7739]	= 1,	-- Inferno Shell
	[7812]	= 1,	-- Sacrifice (Rank 1)
	[7947]	= 3,	-- Localized Toxin
	[7948]	= 1,	-- Wild Regeneration
	[7964]	= 1,	-- Smoke Bomb
	[7992]	= 3,	-- Slowing Poison
	[8040]	= 1,	-- Druid's Slumber
	[8050]	= 1,	-- Flame Shock (Rank 1)
	[8052]	= 1,	-- Flame Shock (Rank 2)
	[8053]	= 1,	-- Flame Shock (Rank 3)
	[8056]	= 1,	-- Frost Shock (Rank 1)
	[8058]	= 1,	-- Frost Shock (Rank 2)
	[8066]	= 4,	-- Shrink
	[8068]	= 1,	-- Healthy Spirit
	[8078]	= 1,	-- Thunderclap
	[8096]	= 1,	-- Intellect (Rank 1)
	[8101]	= 1,	-- Stamina (Level 3)
	[8112]	= 1,	-- Spirit (Rank 1)
	[8117]	= 1,	-- Agility (Rank 3)
	[8119]	= 1,	-- Strength (Rank 2)
	[8122]	= 1,	-- Psychic Scream
	[8134]	= 1,	-- Lightning Shield (Rank 5)
	[8140]	= 1,	-- Befuddlement (Rank 1)
	[8202]	= 1,	-- Sapta Sight
	[8267]	= 4,	-- Cursed Blood
	[8272]	= 1,	-- Mind Tremor
	[8275]	= 3,	-- Poisoned Shot
	[8281]	= 1,	-- Sonic Burst
	[8282]	= 4,	-- Curse of Blood
	[8314]	= 1,	-- Rock Skin
	[8316]	= 1,	-- Fire Shield (Rank 2)
	[8317]	= 1,	-- Fire Shield (Rank 3)
	[8362]	= 1,	-- Renew
	[8365]	= 1,	-- Enlarge
	[8382]	= 3,	-- Leech Poison
	[8385]	= 1,	-- Swift Wind
	[8398]	= 1,	-- Frostbolt Volley
	[8399]	= 1,	-- Sleep
	[8406]	= 1,	-- Frostbolt (Rank 5)
	[8407]	= 1,	-- Frostbolt (Rank 6)
	[8408]	= 1,	-- Frostbolt (Rank 7)
	[8450]	= 1,	-- Dampen Magic (Rank 2)
	[8451]	= 1,	-- Dampen Magic (Rank 3)
	[8455]	= 1,	-- Amplify Magic (Rank 2)
	[8492]	= 1,	-- Cone of Cold (Rank 2)
	[8495]	= 1,	-- Mana Shield (Rank 3)
	[8600]	= 2,	-- Fevered Plague
	[8788]	= 1,	-- Lightning Shield (Rank 4)
	[8898]	= 1,	-- Sapta Sight
	[8907]	= 1,	-- Mark of the Wild (Rank 5)
	[8910]	= 1,	-- Rejuvenation (Rank 7)
	[8914]	= 1,	-- Thorns (Rank 4)
	[8921]	= 1,	-- Moonfire
	[8925]	= 1,	-- Moonfire (Rank 3)
	[8926]	= 1,	-- Moonfire (Rank 4)
	[8927]	= 1,	-- Moonfire (Rank 5)
	[8928]	= 1,	-- Moonfire (Rank 6)
	[8929]	= 1,	-- Moonfire (Rank 7)
	[8936]	= 1,	-- Regrowth (Rank 1)
	[8938]	= 1,	-- Regrowth (Rank 2)
	[8939]	= 1,	-- Regrowth (Rank 3)
	[8940]	= 1,	-- Regrowth (Rank 4)
	[8941]	= 1,	-- Regrowth (Rank 5)
	[8988]	= 1,	-- Silence (Rank 1)
	[9034]	= 1,	-- Immolate
	[9275]	= 1,	-- Immolate
	[9459]	= 1,	-- Corrosive Ooze
	[9482]	= 1,	-- Amplify Flames
	[9484]	= 1,	-- Shackle Undead (Rank 1)
	[9485]	= 1,	-- Shackle Undead (Rank 2)
	[9672]	= 1,	-- Frostbolt
	[9750]	= 1,	-- Regrowth (Rank 6)
	[9756]	= 1,	-- Thorns (Rank 5)
	[9775]	= 2,	-- Irradiated
	[9833]	= 1,	-- Moonfire (Rank 8)
	[9839]	= 1,	-- Rejuvenation (Rank 8)
	[9840]	= 1,	-- Rejuvenation (Rank 9)
	[9856]	= 1,	-- Regrowth (Rank 7)
	[9884]	= 1,	-- Mark of the Wild (Rank 6)
	[9885]	= 1,	-- Mark of the Wild (Rank 7)
	[9906]	= 1,	-- Reflection
	[9910]	= 1,	-- Thorns (Rank 6)
	[10060]	= 1,	-- Power Infusion
	[10156]	= 1,	-- Arcane Intellect (Rank 4)
	[10157]	= 1,	-- Arcane Intellect (Rank 5)
	[10159]	= 1,	-- Cone of Cold (Rank 3)
	[10160]	= 1,	-- Cone of Cold (Rank 4)
	[10170]	= 1,	-- Amplify Magic (Rank 4)
	[10173]	= 1,	-- Dampen Magic (Rank 4)
	[10174]	= 1,	-- Dampen Magic (Rank 5)
	[10179]	= 1,	-- Frostbolt (Rank 8)
	[10180]	= 1,	-- Frostbolt (Rank 9)
	[10278]	= 1,	-- Hand of Protection (Rank 3)
	[10308]	= 1,	-- Hammer of Justice (Rank 4)
	[10326]	= 1,	-- Turn Evil
	[10431]	= 1,	-- Lightning Shield (Rank 6)
	[10432]	= 1,	-- Lightning Shield (Rank 7)
	[10452]	= 1,	-- Flame Buffet
	[10730]	= 1,	-- Pacify
	[10831]	= 1,	-- Reflection Field
	[10890]	= 1,	-- Psychic Scream (Rank 4)
	[10892]	= 1,	-- Shadow Word: Pain (Rank 6)
	[10894]	= 1,	-- Shadow Word: Pain (Rank 8)
	[10898]	= 1,	-- Power Word: Shield (Rank 7)
	[10899]	= 1,	-- Power Word: Shield (Rank 8)
	[10901]	= 1,	-- Power Word: Shield (Rank 10)
	[10927]	= 1,	-- Renew (Rank 7)
	[10937]	= 1,	-- Power Word: Fortitude (Rank 5)
	[10938]	= 1,	-- Power Word: Fortitude (Rank 6)
	[10955]	= 1,	-- Shackle Undead (Rank 3)
	[10957]	= 1,	-- Shadow Protection (Rank 2)
	[10958]	= 1,	-- Shadow Protection (Rank 3)
	[11020]	= 1,	-- Petrify
	[11264]	= 1,	-- Ice Blast
	[11397]	= 2,	-- Diseased Shot
	[11426]	= 1,	-- Ice Barrier (Rank 1)
	[11436]	= 1,	-- Slow
	[11442]	= 2,	-- Withered Touch
	[11443]	= 1,	-- Cripple
	[11445]	= 1,	-- Bone Armor
	[11538]	= 1,	-- Frostbolt
	[11639]	= 1,	-- Shadow Word: Pain
	[11640]	= 1,	-- Renew
	[11641]	= 1,	-- Hex
	[11665]	= 1,	-- Immolate (Rank 5)
	[11671]	= 1,	-- Corruption (Rank 5)
	[11699]	= 1,	-- Drain Life (Rank 5)
	[11707]	= 4,	-- Curse of Weakness (Rank 5)
	[11711]	= 4,	-- Curse of Agony (Rank 4)
	[11712]	= 4,	-- Curse of Agony (Rank 5)
	[11719]	= 4,	-- Curse of Tongues (Rank 2)
	[11770]	= 1,	-- Fire Shield (Rank 4)
	[11841]	= 1,	-- Static Barrier
	[11922]	= 1,	-- Entangling Roots
	[11962]	= 1,	-- Immolate
	[11974]	= 1,	-- Power Word: Shield
	[11980]	= 4,	-- Curse of Weakness
	[12040]	= 1,	-- Shadow Shield
	[12042]	= 1,	-- Arcane Power
	[12043]	= 1,	-- Presence of Mind
	[12096]	= 1,	-- Fear
	[12098]	= 1,	-- Sleep
	[12178]	= 1,	-- Stamina (Level 4)
	[12245]	= 2,	-- Infected Spine
	[12248]	= 1,	-- Amplify Damage
	[12251]	= 3,	-- Virulent Poison
	[12255]	= 4,	-- Curse of Tuten'kash
	[12472]	= 1,	-- Icy Veins
	[12493]	= 4,	-- Curse of Weakness
	[12494]	= 1,	-- Frostbite
	[12528]	= 1,	-- Silence
	[12530]	= 1,	-- Frailty
	[12531]	= 1,	-- Chilling Touch
	[12536]	= 1,	-- Clearcasting
	[12541]	= 2,	-- Ghoul Rot
	[12544]	= 1,	-- Frost Armor
	[12548]	= 1,	-- Frost Shock
	[12579]	= 1,	-- Winter's Chill
	[12611]	= 1,	-- Cone of Cold
	[12654]	= 1,	-- Ignite
	[12741]	= 4,	-- Curse of Weakness
	[12824]	= 1,	-- Polymorph (Rank 2)
	[12826]	= 1,	-- Polymorph (Rank 4)
	[12890]	= 1,	-- Deep Slumber
	[12946]	= 2,	-- Putrid Stench
	[13218]	= 3,	-- Wound Poison (Rank 1)
	[13222]	= 3,	-- Wound Poison II (Rank 2)
	[13298]	= 3,	-- Poison
	[13326]	= 1,	-- Arcane Intellect
	[13439]	= 1,	-- Frostbolt
	[13526]	= 3,	-- Corrosive Poison
	[13542]	= 1,	-- Mend Pet (Rank 5)
	[13549]	= 3,	-- Serpent Sting (Rank 2)
	[13550]	= 3,	-- Serpent Sting (Rank 3)
	[13551]	= 3,	-- Serpent Sting (Rank 4)
	[13552]	= 3,	-- Serpent Sting (Rank 5)
	[13553]	= 3,	-- Serpent Sting (Rank 6)
	[13555]	= 3,	-- Serpent Sting (Rank 8)
	[13704]	= 1,	-- Psychic Scream
	[13797]	= 1,	-- Immolation Trap (Rank 1)
	[13864]	= 1,	-- Power Word: Fortitude
	[14032]	= 1,	-- Shadow Word: Pain
	[14202]	= 5,	-- Enrage
	[14298]	= 1,	-- Immolation Trap (Rank 2)
	[14308]	= 1,	-- Freezing Trap Effect (Rank 2)
	[14309]	= 1,	-- Freezing Trap Effect (Rank 3)
	[14323]	= 1,	-- Hunter's Mark (Rank 2)
	[14324]	= 1,	-- Hunter's Mark (Rank 3)
	[14325]	= 1,	-- Hunter's Mark (Rank 4)
	[14515]	= 1,	-- Dominate Mind
	[14517]	= 1,	-- Crusader Strike
	[14518]	= 1,	-- Crusader Strike
	[14751]	= 1,	-- Inner Focus
	[14752]	= 1,	-- Divine Spirit (Rank 1)
	[14818]	= 1,	-- Divine Spirit (Rank 2)
	[14819]	= 1,	-- Divine Spirit (Rank 3)
	[14893]	= 1,	-- Inspiration (Rank 1)
	[14914]	= 1,	-- Holy Fire (Rank 1)
	[15039]	= 1,	-- Flame Shock
	[15258]	= 1,	-- Shadow Weaving (Rank 1)
	[15262]	= 1,	-- Holy Fire (Rank 2)
	[15263]	= 1,	-- Holy Fire (Rank 3)
	[15265]	= 1,	-- Holy Fire (Rank 5)
	[15266]	= 1,	-- Holy Fire (Rank 6)
	[15271]	= 1,	-- Spirit Tap (Rank 1)
	[15357]	= 1,	-- Inspiration (Rank 2)
	[15359]	= 1,	-- Inspiration (Rank 3)
	[15487]	= 1,	-- Silence
	[15531]	= 1,	-- Frost Nova
	[15532]	= 1,	-- Frost Nova
	[15548]	= 1,	-- Thunderclap
	[15588]	= 1,	-- Thunderclap
	[16166]	= 1,	-- Elemental Mastery
	[16177]	= 1,	-- Ancestral Fortitude (Rank 1)
	[16188]	= 1,	-- Nature's Swiftness
	[16236]	= 1,	-- Ancestral Fortitude (Rank 2)
	[16237]	= 1,	-- Ancestral Fortitude (Rank 3)
	[16246]	= 1,	-- Clearcasting
	[16468]	= 3,	-- Mother's Milk
	[16567]	= 4,	-- Tainted Mind
	[16591]	= 1,	-- Noggenfogger Elixir
	[16593]	= 1,	-- Noggenfogger Elixir
	[16595]	= 1,	-- Noggenfogger Elixir
	[16689]	= 1,	-- Nature's Grasp (Rank 1)
	[16711]	= 1,	-- Grow
	[16810]	= 1,	-- Nature's Grasp (Rank 2)
	[16811]	= 1,	-- Nature's Grasp (Rank 3)
	[16812]	= 1,	-- Nature's Grasp (Rank 4)
	[16857]	= 1,	-- Faerie Fire (Feral)
	[16870]	= 1,	-- Clearcasting
	[16886]	= 1,	-- Nature's Grace
	[17116]	= 1,	-- Nature's Swiftness
	[17154]	= 1,	-- The Green Tower (Rank 1)
	[17800]	= 1,	-- Shadow Mastery
	[17928]	= 1,	-- Howl of Terror (Rank 2)
	[17941]	= 1,	-- Shadow Trance
	[18093]	= 1,	-- Pyroclasm
	[18118]	= 1,	-- Aftermath
	[18223]	= 4,	-- Curse of Exhaustion
	[18266]	= 4,	-- Curse of Agony
	[18267]	= 4,	-- Curse of Weakness
	[18425]	= 1,	-- Silenced - Improved Kick
	[18469]	= 1,	-- Silenced - Improved Counterspell (Rank 1)
	[18498]	= 1,	-- Silenced - Gag Order
	[18647]	= 1,	-- Banish (Rank 2)
	[18657]	= 1,	-- Hibernate (Rank 2)
	[18658]	= 1,	-- Hibernate (Rank 3)
	[18972]	= 1,	-- Slow
	[19276]	= 2,	-- Devouring Plague (Rank 2)
	[19277]	= 2,	-- Devouring Plague (Rank 3)
	[19278]	= 2,	-- Devouring Plague (Rank 4)
	[19386]	= 3,	-- Wyvern Sting (Rank 1)
	[19440]	= 1,	-- Sacrifice (Rank 3)
	[19740]	= 1,	-- Blessing of Might (Rank 1)
	[19742]	= 1,	-- Blessing of Wisdom (Rank 1)
	[19821]	= 1,	-- Arcane Bomb
	[19834]	= 1,	-- Blessing of Might (Rank 2)
	[19835]	= 1,	-- Blessing of Might (Rank 3)
	[19836]	= 1,	-- Blessing of Might (Rank 4)
	[19837]	= 1,	-- Blessing of Might (Rank 5)
	[19838]	= 1,	-- Blessing of Might (Rank 6)
	[19850]	= 1,	-- Blessing of Wisdom (Rank 2)
	[19852]	= 1,	-- Blessing of Wisdom (Rank 3)
	[19853]	= 1,	-- Blessing of Wisdom (Rank 4)
	[19854]	= 1,	-- Blessing of Wisdom (Rank 5)
	[19972]	= 1,	-- Entangling Roots (Rank 4)
	[19973]	= 1,	-- Entangling Roots (Rank 3)
	[19974]	= 1,	-- Entangling Roots (Rank 2)
	[19975]	= 1,	-- Entangling Roots
	[20006]	= 1,	-- Unholy Curse
	[20050]	= 1,	-- Conviction
	[20052]	= 1,	-- Conviction
	[20053]	= 1,	-- Vengeance
	[20066]	= 1,	-- Repentance
	[20184]	= 1,	-- Judgement of Justice
	[20185]	= 1,	-- Judgement of Light (Rank 1)
	[20186]	= 1,	-- Judgement of Wisdom (Rank 1)
	[20216]	= 1,	-- Divine Favor
	[20217]	= 1,	-- Blessing of Kings
	[20236]	= 1,	-- Lay on Hands (Rank 2)
	[20798]	= 1,	-- Demon Skin
	[20800]	= 1,	-- Immolate
	[20911]	= 1,	-- Blessing of Sanctuary
	[20925]	= 1,	-- Holy Shield (Rank 1)
	[20927]	= 1,	-- Holy Shield (Rank 2)
	[21007]	= 4,	-- Curse of Weakness
	[21049]	= 1,	-- Bloodlust
	[21062]	= 2,	-- Putrid Breath
	[21067]	= 3,	-- Poison Bolt
	[21068]	= 1,	-- Corruption
	[21069]	= 3,	-- Larva Goo
	[21331]	= 1,	-- Entangling Roots
	[21337]	= 1,	-- Thorns
	[21562]	= 1,	-- Prayer of Fortitude (Rank 1)
	[21564]	= 1,	-- Prayer of Fortitude (Rank 2)
	[21687]	= 3,	-- Toxic Volley
	[21787]	= 3,	-- Deadly Poison
	[21849]	= 1,	-- Gift of the Wild (Rank 1)
	[21850]	= 1,	-- Gift of the Wild (Rank 2)
	[22812]	= 1,	-- Barkskin
	[22959]	= 1,	-- Improved Scorch
	[23028]	= 1,	-- Arcane Brilliance (Rank 1)
	[24131]	= 3,	-- Wyvern Sting
	[24259]	= 1,	-- Spell Lock
	[24398]	= 1,	-- Water Shield (Rank 7)
	[24586]	= 3,	-- Scorpid Poison (Rank 3)
	[24844]	= 1,	-- Lightning Breath
	[24974]	= 1,	-- Insect Swarm (Rank 2)
	[25046]	= 1,	-- Arcane Torrent (Racial)
	[25058]	= 1,	-- Renew
	[25207]	= 1,	-- Amulet of the Moon
	[25217]	= 1,	-- Power Word: Shield (Rank 11)
	[25218]	= 1,	-- Power Word: Shield (Rank 12)
	[25221]	= 1,	-- Renew (Rank 11)
	[25222]	= 1,	-- Renew (Rank 12)
	[25290]	= 1,	-- Blessing of Wisdom (Rank 6)
	[25291]	= 1,	-- Blessing of Might (Rank 7)
	[25295]	= 3,	-- Serpent Sting (Rank 9)
	[25312]	= 1,	-- Divine Spirit (Rank 5)
	[25368]	= 1,	-- Shadow Word: Pain (Rank 10)
	[25389]	= 1,	-- Power Word: Fortitude (Rank 7)
	[25392]	= 1,	-- Prayer of Fortitude (Rank 3)
	[25433]	= 1,	-- Shadow Protection (Rank 4)
	[25467]	= 2,	-- Devouring Plague (Rank 7)
	[25469]	= 1,	-- Lightning Shield (Rank 8)
	[25472]	= 1,	-- Lightning Shield (Rank 9)
	[25606]	= 1,	-- Pendant of the Agate Shield
	[25746]	= 1,	-- Damage Absorb
	[25747]	= 1,	-- Damage Absorb
	[25780]	= 1,	-- Righteous Fury
	[25809]	= 3,	-- Crippling Poison (Rank 1)
	[25810]	= 3,	-- Mind-numbing Poison
	[25894]	= 1,	-- Greater Blessing of Wisdom (Rank 1)
	[25898]	= 1,	-- Greater Blessing of Kings
	[25899]	= 1,	-- Greater Blessing of Sanctuary
	[25916]	= 1,	-- Greater Blessing of Might (Rank 2)
	[25918]	= 1,	-- Greater Blessing of Wisdom (Rank 2)
	[26017]	= 1,	-- Vindication (Rank 2)
	[26968]	= 3,	-- Deadly Poison VI (Rank 6)
	[26990]	= 1,	-- Mark of the Wild (Rank 8)
	[26991]	= 1,	-- Gift of the Wild (Rank 3)
	[26992]	= 1,	-- Thorns (Rank 7)
	[27009]	= 1,	-- Nature's Grasp (Rank 7)
	[27046]	= 1,	-- Mend Pet (Rank 8)
	[27126]	= 1,	-- Arcane Intellect (Rank 6)
	[27127]	= 1,	-- Arcane Brilliance (Rank 2)
	[27140]	= 1,	-- Blessing of Might (Rank 8)
	[27142]	= 1,	-- Blessing of Wisdom (Rank 7)
	[27143]	= 1,	-- Greater Blessing of Wisdom (Rank 3)
	[27187]	= 3,	-- Deadly Poison VII (Rank 7)
	[27243]	= 1,	-- Seed of Corruption
	[27681]	= 1,	-- Prayer of Spirit (Rank 1)
	[27683]	= 1,	-- Prayer of Shadow Protection (Rank 1)
	[27813]	= 1,	-- Blessed Recovery (Rank 1)
	[27817]	= 1,	-- Blessed Recovery (Rank 2)
	[27818]	= 1,	-- Blessed Recovery (Rank 3)
	[27828]	= 1,	-- Focused Casting (Rank 2)
	[27841]	= 1,	-- Divine Spirit (Rank 4)
	[28271]	= 1,	-- Polymorph (turtle)
	[28272]	= 1,	-- Polymorph (pig)
	[28682]	= 1,	-- Combustion
	[28730]	= 1,	-- Arcane Torrent (Racial)
	[29166]	= 1,	-- Innervate
	[29228]	= 1,	-- Flame Shock (Rank 6)
	[29674]	= 1,	-- Lesser Shielding
	[30108]	= 1,	-- Unstable Affliction
	[30283]	= 1,	-- Shadowfury
	[30910]	= 4,	-- Curse of Doom (Rank 2)
	[31117]	= 1,	-- Unstable Affliction
	[31589]	= 1,	-- Slow
	[31643]	= 1,	-- Blazing Speed
	[31661]	= 1,	-- Dragon's Breath (Rank 1)
	[31803]	= 1,	-- Holy Vengeance (Rank 1)
	[31834]	= 1,	-- Light's Grace
	[31842]	= 1,	-- Divine Illumination
	[31884]	= 1,	-- Avenging Wrath
	[31935]	= 1,	-- Avenger's Shield
	[32182]	= 1,	-- Heroism
	[32386]	= 1,	-- Shadow Embrace
	[32388]	= 1,	-- Shadow Embrace
	[32389]	= 1,	-- Shadow Embrace
	[32390]	= 1,	-- Shadow Embrace
	[32391]	= 1,	-- Shadow Embrace
	[32593]	= 1,	-- Earth Shield (Rank 2)
	[32594]	= 1,	-- Earth Shield (Rank 3)
	[32645]	= 3,	-- Envenom
	[32999]	= 1,	-- Prayer of Spirit (Rank 2)
	[33041]	= 1,	-- Dragon's Breath (Rank 2)
	[33042]	= 1,	-- Dragon's Breath (Rank 3)
	[33043]	= 1,	-- Dragon's Breath (Rank 4)
	[33082]	= 1,	-- Strength (Rank 5)
	[33151]	= 1,	-- Surge of Light (Rank 1)
	[33206]	= 1,	-- Pain Suppression
	[33395]	= 1,	-- Freeze
	[33736]	= 1,	-- Water Shield (Rank 8)
	[33763]	= 1,	-- Lifebloom (Rank 1)
	[33944]	= 1,	-- Dampen Magic (Rank 6)
	[33946]	= 1,	-- Amplify Magic (Rank 6)
	[34490]	= 1,	-- Silencing Shot
	[34501]	= 1,	-- Expose Weakness
	[34655]	= 3,	-- Deadly Poison
	[34914]	= 1,	-- Vampiric Touch
	[34917]	= 1,	-- Vampiric Touch (Rank 3)
	[34936]	= 1,	-- Backlash
	[35944]	= 1,	-- Power Word: Shield
	[38254]	= 2,	-- Festering Wound
	[38384]	= 1,	-- Cone of Cold
	[39374]	= 1,	-- Prayer of Shadow Protection (Rank 2)
	[39796]	= 1,	-- Stoneclaw Stun
	[41635]	= 1,	-- Prayer of Mending (Rank 1)
	[42702]	= 2,	-- Decrepify
	[42740]	= 1,	-- Njord's Rune of Protection
	[42842]	= 1,	-- Frostbolt (Rank 16)
	[42917]	= 1,	-- Frost Nova (Rank 6)
	[42931]	= 1,	-- Cone of Cold (Rank 8)
	[42949]	= 1,	-- Dragon's Breath (Rank 5)
	[42950]	= 1,	-- Dragon's Breath (Rank 6)
	[42995]	= 1,	-- Arcane Intellect (Rank 7)
	[43002]	= 1,	-- Arcane Brilliance (Rank 3)
	[43010]	= 1,	-- Fire Ward (Rank 7)
	[43012]	= 1,	-- Frost Ward (Rank 7)
	[43015]	= 1,	-- Dampen Magic (Rank 7)
	[43017]	= 1,	-- Amplify Magic (Rank 7)
	[43019]	= 1,	-- Mana Shield (Rank 8)
	[43020]	= 1,	-- Mana Shield (Rank 9)
	[43038]	= 1,	-- Ice Barrier (Rank 7)
	[43039]	= 1,	-- Ice Barrier (Rank 8)
	[43195]	= 1,	-- Intellect (Rank 6)
	[43196]	= 1,	-- Armor (Rank 6)
	[43197]	= 1,	-- Spirit (Rank 6)
	[44401]	= 1,	-- Missile Barrage
	[44413]	= 1,	-- Incanter's Absorption
	[44415]	= 1,	-- Blackout (Rank 1)
	[44457]	= 1,	-- Living Bomb
	[44544]	= 1,	-- Fingers of Frost
	[44572]	= 1,	-- Deep Freeze
	[44614]	= 1,	-- Frostfire Bolt (Rank 1)
	[45241]	= 1,	-- Focused Will (Rank 2)
	[45242]	= 1,	-- Focused Will (Rank 3)
	[45282]	= 1,	-- Natural Perfection (Rank 2)
	[45283]	= 1,	-- Natural Perfection (Rank 3)
	[45438]	= 1,	-- Ice Block
	[45524]	= 1,	-- Chains of Ice
	[46604]	= 1,	-- Ice Block
	[46987]	= 1,	-- Frostbolt
	[46989]	= 1,	-- Improved Blink
	[47283]	= 1,	-- Empowered Imp
	[47476]	= 1,	-- Strangulate
	[47610]	= 1,	-- Frostfire Bolt (Rank 2)
	[47699]	= 1,	-- Crystal Bark
	[47753]	= 1,	-- Divine Aegis (Rank 1)
	[47779]	= 1,	-- Arcane Torrent
	[47811]	= 1,	-- Immolate (Rank 11)
	[47813]	= 1,	-- Corruption (Rank 10)
	[47836]	= 1,	-- Seed of Corruption (Rank 3)
	[47843]	= 1,	-- Unstable Affliction (Rank 5)
	[47847]	= 1,	-- Shadowfury (Rank 5)
	[47857]	= 1,	-- Drain Life (Rank 9)
	[47860]	= 1,	-- Death Coil (Rank 6)
	[47864]	= 4,	-- Curse of Agony (Rank 9)
	[47865]	= 4,	-- Curse of the Elements (Rank 5)
	[47867]	= 4,	-- Curse of Doom (Rank 3)
	[47891]	= 1,	-- Shadow Ward (Rank 6)
	[47930]	= 1,	-- Grace
	[47960]	= 1,	-- Shadowflame
	[47983]	= 1,	-- Fire Shield (Rank 7)
	[47986]	= 1,	-- Sacrifice (Rank 9)
	[47990]	= 1,	-- Suffering (Rank 8)
	[48058]	= 1,	-- Crystal Bloom
	[48065]	= 1,	-- Power Word: Shield (Rank 13)
	[48066]	= 1,	-- Power Word: Shield (Rank 14)
	[48068]	= 1,	-- Renew (Rank 14)
	[48073]	= 1,	-- Divine Spirit (Rank 6)
	[48074]	= 1,	-- Prayer of Spirit (Rank 3)
	[48100]	= 1,	-- Intellect (Rank 7)
	[48101]	= 1,	-- Stamina (Level 6)
	[48102]	= 1,	-- Stamina (Level 6)
	[48103]	= 1,	-- Spirit (Rank 7)
	[48111]	= 1,	-- Prayer of Mending (Rank 3)
	[48125]	= 1,	-- Shadow Word: Pain (Rank 12)
	[48135]	= 1,	-- Holy Fire (Rank 11)
	[48160]	= 1,	-- Vampiric Touch (Rank 5)
	[48161]	= 1,	-- Power Word: Fortitude (Rank 8)
	[48162]	= 1,	-- Prayer of Fortitude (Rank 4)
	[48169]	= 1,	-- Shadow Protection (Rank 5)
	[48170]	= 1,	-- Prayer of Shadow Protection (Rank 3)
	[48181]	= 1,	-- Haunt
	[48299]	= 2,	-- Devouring Plague (Rank 8)
	[48300]	= 2,	-- Devouring Plague (Rank 9)
	[48301]	= 1,	-- Mind Trauma
	[48438]	= 1,	-- Wild Growth
	[48440]	= 1,	-- Rejuvenation (Rank 14)
	[48441]	= 1,	-- Rejuvenation (Rank 15)
	[48442]	= 1,	-- Regrowth (Rank 11)
	[48443]	= 1,	-- Regrowth (Rank 12)
	[48450]	= 1,	-- Lifebloom (Rank 2)
	[48451]	= 1,	-- Lifebloom (Rank 3)
	[48463]	= 1,	-- Moonfire (Rank 14)
	[48468]	= 1,	-- Insect Swarm (Rank 7)
	[48469]	= 1,	-- Mark of the Wild (Rank 9)
	[48470]	= 1,	-- Gift of the Wild (Rank 4)
	[48817]	= 1,	-- Holy Wrath (Rank 5)
	[48827]	= 1,	-- Avenger's Shield (Rank 5)
	[48931]	= 1,	-- Blessing of Might (Rank 9)
	[48932]	= 1,	-- Blessing of Might (Rank 10)
	[48933]	= 1,	-- Greater Blessing of Might (Rank 4)
	[48934]	= 1,	-- Greater Blessing of Might (Rank 5)
	[48935]	= 1,	-- Blessing of Wisdom (Rank 8)
	[48936]	= 1,	-- Blessing of Wisdom (Rank 9)
	[48937]	= 1,	-- Greater Blessing of Wisdom (Rank 4)
	[48938]	= 1,	-- Greater Blessing of Wisdom (Rank 5)
	[48952]	= 1,	-- Holy Shield (Rank 6)
	[48989]	= 1,	-- Mend Pet (Rank 9)
	[48990]	= 1,	-- Mend Pet (Rank 10)
	[49000]	= 3,	-- Serpent Sting (Rank 11)
	[49001]	= 3,	-- Serpent Sting (Rank 12)
	[49005]	= 1,	-- Mark of Blood
	[49010]	= 3,	-- Wyvern Sting (Rank 6)
	[49012]	= 3,	-- Wyvern Sting (Rank 6)
	[49054]	= 1,	-- Immolation Trap (Rank 8)
	[49203]	= 1,	-- Hungering Cold (Rank 1)
	[49232]	= 1,	-- Flame Shock (Rank 8)
	[49233]	= 1,	-- Flame Shock (Rank 9)
	[49236]	= 1,	-- Frost Shock (Rank 7)
	[49280]	= 1,	-- Lightning Shield (Rank 10)
	[49281]	= 1,	-- Lightning Shield (Rank 11)
	[49284]	= 1,	-- Earth Shield (Rank 5)
	[50263]	= 1,	-- Quickness of the Sailor
	[50448]	= 1,	-- Bloody Vengeance
	[50449]	= 1,	-- Bloody Vengeance
	[50486]	= 1,	-- Acclimation
	[50510]	= 2,	-- Crypt Fever
	[50511]	= 4,	-- Curse of Weakness (Rank 9)
	[50613]	= 1,	-- Arcane Torrent (Racial)
	[51209]	= 1,	-- Hungering Cold (Rank 1)
	[51514]	= 4,	-- Hex
	[51726]	= 2,	-- Ebon Plague
	[51735]	= 2,	-- Ebon Plague
	[51945]	= 1,	-- Earthliving (Rank 1)
	[51990]	= 1,	-- Earthliving (Rank 2)
	[51999]	= 1,	-- Earthliving (Rank 5)
	[52000]	= 1,	-- Earthliving (Rank 6)
	[52127]	= 1,	-- Water Shield (Rank 1)
	[52129]	= 1,	-- Water Shield (Rank 2)
	[52131]	= 1,	-- Water Shield (Rank 3)
	[52134]	= 1,	-- Water Shield (Rank 4)
	[52136]	= 1,	-- Water Shield (Rank 5)
	[52138]	= 1,	-- Water Shield (Rank 6)
	[52493]	= 3,	-- Poison Spray
	[53030]	= 3,	-- Leech Poison
	[53251]	= 1,	-- Wild Growth (Rank 4)
	[53307]	= 1,	-- Thorns (Rank 8)
	[53308]	= 1,	-- Entangling Roots (Rank 8)
	[53312]	= 1,	-- Nature's Grasp (Rank 8)
	[53313]	= 1,	-- Entangling Roots (Rank 8)
	[53330]	= 2,	-- Infected Wound
	[53338]	= 1,	-- Hunter's Mark (Rank 5)
	[53390]	= 1,	-- Tidal Waves
	[53515]	= 1,	-- Owl's Focus
	[53517]	= 1,	-- Roar of Recovery
	[53547]	= 1,	-- Pin (Rank 5)
	[53548]	= 1,	-- Pin (Rank 6)
	[53563]	= 1,	-- Beacon of Light
	[53601]	= 1,	-- Sacred Shield (Rank 1)
	[53742]	= 1,	-- Blood Corruption (Rank 1)
	[53817]	= 1,	-- Maelstrom Weapon
	[54203]	= 1,	-- Sheath of Light
	[54277]	= 1,	-- Backdraft
	[54309]	= 1,	-- Mark of Darkness
	[54370]	= 1,	-- Nether Protection
	[54371]	= 1,	-- Nether Protection
	[54372]	= 1,	-- Nether Protection
	[54373]	= 1,	-- Nether Protection
	[54374]	= 1,	-- Nether Protection
	[54375]	= 1,	-- Nether Protection
	[54428]	= 1,	-- Divine Plea
	[54646]	= 1,	-- Focus Magic
	[54648]	= 1,	-- Focus Magic
	[54706]	= 1,	-- Venom Web Spray
	[54833]	= 1,	-- Glyph of Innervate
	[54965]	= 1,	-- Bolthorn's Rune of Flame
	[55021]	= 1,	-- Silenced - Improved Counterspell (Rank 2)
	[55078]	= 2,	-- Blood Plague
	[55080]	= 1,	-- Shattered Barrier
	[55095]	= 2,	-- Frost Fever
	[55166]	= 1,	-- Tidal Force
	[55360]	= 1,	-- Living Bomb (Rank 3)
	[56161]	= 1,	-- Glyph of Prayer of Healing
	[56352]	= 1,	-- Storm Punch
	[56520]	= 1,	-- Blessing of Might (Rank 10)
	[56521]	= 1,	-- Blessing of Wisdom
	[56525]	= 1,	-- Blessing of Kings
	[56778]	= 1,	-- Mana Shield
	[56827]	= 1,	-- Aura of Arcane Haste
	[57063]	= 1,	-- Arcane Attraction
	[57350]	= 1,	-- Illusionary Barrier
	[57519]	= 5,	-- Enrage
	[57524]	= 1,	-- Metanoia
	[57529]	= 1,	-- Arcane Potency
	[57531]	= 1,	-- Arcane Potency
	[57580]	= 1,	-- Lightning Infusion
	[57761]	= 1,	-- Fireball!
	[57960]	= 1,	-- Water Shield (Rank 9)
	[57969]	= 3,	-- Deadly Poison VIII (Rank 8)
	[57970]	= 3,	-- Deadly Poison IX (Rank 9)
	[57974]	= 3,	-- Wound Poison VI (Rank 6)
	[57975]	= 3,	-- Wound Poison VII (Rank 7)
	[57993]	= 3,	-- Envenom (Rank 4)
	[58179]	= 2,	-- Infected Wounds
	[58180]	= 2,	-- Infected Wounds
	[58181]	= 2,	-- Infected Wounds
	[58448]	= 1,	-- Strength (Rank 7)
	[58449]	= 1,	-- Strength (Rank 8)
	[58450]	= 1,	-- Agility (Rank 7)
	[58451]	= 1,	-- Agility (Rank 8)
	[58452]	= 1,	-- Armor (Rank 7)
	[58501]	= 1,	-- Iron Boot Flask
	[58597]	= 1,	-- Sacred Shield (Rank 1)
	[58610]	= 1,	-- Lava Breath (Rank 5)
	[58611]	= 1,	-- Lava Breath (Rank 6)
	[59000]	= 1,	-- Improved Spirit Tap (Rank 2)
	[59052]	= 1,	-- Freezing Fog
	[59164]	= 1,	-- Haunt (Rank 4)
	[59578]	= 1,	-- The Art of War (Rank 2)
	[59638]	= 1,	-- Frostbolt
	[59888]	= 1,	-- Borrowed Time
	[59889]	= 1,	-- Borrowed Time
	[59891]	= 1,	-- Borrowed Time
	[60210]	= 1,	-- Freezing Arrow Effect (Rank 1) (PvP duration)
	[60433]	= 1,	-- Earth and Moon
	[60518]	= 1,	-- Touched by a Troll
	[60946]	= 1,	-- Nightmare
	[60947]	= 1,	-- Nightmare
	[61024]	= 1,	-- Dalaran Intellect (Rank 7)
	[61291]	= 1,	-- Shadowflame
	[61295]	= 1,	-- Riptide
	[61299]	= 1,	-- Riptide (Rank 2)
	[61301]	= 1,	-- Riptide (Rank 4)
	[61305]	= 1,	-- Polymorph (cat)
	[61316]	= 1,	-- Dalaran Brilliance (Rank 3)
	[61394]	= 1,	-- Glyph of Freezing Trap
	[61721]	= 1,	-- Polymorph (Rabbit)
	[61840]	= 1,	-- Righteous Vengeance
	[63167]	= 1,	-- Decimation
	[63243]	= 1,	-- Pyroclasm
	[63244]	= 1,	-- Pyroclasm
	[63321]	= 1,	-- Life Tap
	[63529]	= 1,	-- Silenced - Shield of the Templar
	[63668]	= 1,	-- Black Arrow (Rank 2)
	[63672]	= 1,	-- Black Arrow (Rank 6)
	[63685]	= 1,	-- Freeze
	[63725]	= 1,	-- Holy Concentration
	[63734]	= 1,	-- Serendipity
	[63735]	= 1,	-- Serendipity
	[64044]	= 1,	-- Psychic Horror
	[64128]	= 1,	-- Body and Soul
	[64205]	= 1,	-- Divine Sacrifice
	[64368]	= 1,	-- Eradication
	[64370]	= 1,	-- Eradication
	[64371]	= 1,	-- Eradication
	[64695]	= 1,	-- Earthgrab
	[64701]	= 1,	-- Elemental Mastery
	[64803]	= 1,	-- Entrapment
	[64804]	= 1,	-- Entrapment
	[64844]	= 1,	-- Divine Hymn
	[64904]	= 1,	-- Hymn of Hope
	[65081]	= 1,	-- Body and Soul
	[65142]	= 2,	-- Ebon Plague
	[65264]	= 1,	-- Lava Flows
	[66922]	= 1,	-- Flash of Light
	[67631]	= 1,	-- Aegis
	[68055]	= 1,	-- Judgements of the Just (Rank 1)
	[69180]	= 4,	-- Gutgore Ripper
	[69369]	= 1,	-- Predator's Swiftness
	[70691]	= 1,	-- Rejuvenation
	[70338] = 2,    -- Necrotic Plague
	[73786] = 2,    -- Necrotic Plague
	[73914] = 2,    -- Necrotic Plague
	[73787] = 2,    -- Necrotic Plague
	[73913] = 2,    -- Necrotic Plague
	[70337] = 2,    -- Necrotic Plague
	[73785] = 2,    -- Necrotic Plague
	[73912] = 2,    -- Necrotic Plague
	[71824]	= 1,	-- Lava Burst
	[71870]	= 1,	-- Blessing of Light
	[71875]	= 1,	-- Necrotic Touch
	[71877]	= 1,	-- Necrotic Touch
	[71882]	= 1,	-- Invigoration
	[72104]	= 1,	-- Freezing Ground
	[72586]	= 1,	-- Blessing of Forgotten Kings
	[72588]	= 1,	-- Gift of the Wild
	[72590]	= 1,	-- Fortitude
	[73320]	= 1,	-- Frostborn Illusion
	[74347]	= 1,	-- Silenced - Gag Order
}

--Durations that don't match PvE durations.
--http://www.wowwiki.com/Diminishing_returns
lib.auraInfoPvP = {
	[118]	= 10,	-- Polymorph (Rank 1)
	[339]	= 10,	-- Entangling Roots (Rank 1)
	[605]	= 10,	-- Mind Control
	[770]	= 40,	-- Faerie Fire
--	[1513]	= 10,	-- Scare Beast (Rank 1)
	[1715]	= 10,	-- Hamstring
	[3355]	= 10,	-- Freezing Trap Effect (Rank 1)
	[6215]	= 10,	-- Fear (Rank 3)
	[6358]	= 10,	-- Seduction
	[6770]	= 10,	-- Sap (Rank 1)
	[8643]	= 6,	-- Kidney Shot (Rank 2) (time based on comob points, i'll assume they're using 5 points)
	[10326]	= 10,	-- Turn Evil
--	[10955]	= 10,	-- Shackle Undead
	[14308]	= 10,	-- Freezing Trap Effect (Rank 2)
	[14309]	= 10,	-- Freezing Trap Effect (Rank 3)
	[16857]	= 40,	-- Faerie Fire (Feral)
	[18647]	= 6,	-- Banish (Rank 2)
	[18657]	= 10,	-- Hibernate (Rank 2)
	[20066]	= 6,	-- Repentance
	[47865]	= 120,	-- Curse of the Elements (Rank 5)
	[49012]	= 6,	-- Wyvern Sting (Rank 6)
	[51514]	= 10,	-- Hex
	[51724]	= 10,	-- Sap (Rank 4)
	[53308]	= 10,	-- Entangling Roots (Rank 8)
	[53313]	= 10,	-- Entangling Roots (Rank 8)
	[53338]	= 120,	-- Hunter's Mark (Rank 5)* Confirm Duration",
	[61721]	= 10,	-- Polymorph (Rabbit)
}