--[[
	This file keeps track of aura duration and debuff type.

	lib.spellDuration:		[spellID] = duration

	lib.spellDebuffType:	[spellID] = debuffType
	debuffTypes: Magic = 1,	Disease = 2, Poison = 3, Curse = 4, Enrage = 5, Invisibility = 6
]]

local lib = LibStub("LibAuraInfo-1.0-ElvUI")
if not lib then error("spellIdData.lua for LibAuraInfo needs library loaded.") return end
if lib.spellDuration then return end

lib.spellDuration = {
	[10]	= 8,	-- Blizzard
	[17]	= 30,	-- Power Word: Shield
	[66]	= 3,	-- Invisibility
	[71]	= 0,	-- Defensive Stance
	[99]	= 30,	-- Demoralizing Roar
	[113]	= 15,	-- Chains of Ice
	[116]	= 9,	-- Frostbolt
	[118]	= 50,	-- Polymorph
	[120]	= 8,	-- Cone of Cold
	[122]	= 8,	-- Frost Nova
	[126]	= 45,	-- Eye of Kilrogg
	[130]	= 30,	-- Slow Fall
	[131]	= 600,	-- Water Breathing
	[133]	= 0,	-- Fireball
	[136]	= 10,	-- Mend Pet
	[139]	= 12,	-- Renew
	[172]	= 18,	-- Corruption
	[324]	= 600,	-- Lightning Shield
	[339]	= 30,	-- Entangling Roots
	[348]	= 15,	-- Immolate
	[355]	= 3,	-- Taunt
	[408]	= 1,	-- Kidney Shot
	[430]	= 18,	-- Drink
	[431]	= 21,	-- Drink
	[432]	= 24,	-- Drink
	[434]	= 21,	-- Food
	[435]	= 24,	-- Food
	[453]	= 15,	-- Mind Soothe
	[465]	= 0,	-- Devotion Aura
	[467]	= 20,	-- Thorns
	[469]	= 120,	-- Commanding Shout
	[498]	= 10,	-- Divine Protection
	[543]	= 30,	-- Mage Ward
	[546]	= 600,	-- Water Walking
	[580]	= 0,	-- Timber Wolf
	[586]	= 10,	-- Fade
	[588]	= 1800,	-- Inner Fire
	[589]	= 18,	-- Shadow Word: Pain
	[603]	= 60,	-- Bane of Doom
	[605]	= 60,	-- Mind Control
	[642]	= 8,	-- Divine Shield
	[673]	= 3600,	-- Lesser Armor
	[676]	= 10,	-- Disarm
	[687]	= 1800,	-- Demon Armor
	[689]	= 3,	-- Drain Life
	[700]	= 20,	-- Sleep
	[702]	= 120,	-- Curse of Weakness
	[703]	= 18,	-- Garrote
	[710]	= 30,	-- Banish
	[740]	= 8,	-- Tranquility
	[744]	= 30,	-- Poison
	[745]	= 5,	-- Web
	[746]	= 6,	-- First Aid
	[755]	= 3,	-- Health Funnel
	[768]	= 0,	-- Cat Form
	[768]	= 0,	-- Cat Form
	[770]	= 300,	-- Faerie Fire
	[774]	= 12,	-- Rejuvenation
	[783]	= 0,	-- Travel Form
	[783]	= 0,	-- Travel Form
	[853]	= 6,	-- Hammer of Justice
	[853]	= 6,	-- Hammer of Justice
	[871]	= 12,	-- Shield Wall
	[879]	= 6,	-- Exorcism
	[974]	= 600,	-- Earth Shield
	[980]	= 24,	-- Bane of Agony
	[982]	= 3,	-- Revive Pet
	[1022]	= 10,	-- Hand of Protection
	[1038]	= 10,	-- Hand of Salvation
	[1044]	= 6,	-- Hand of Freedom
	[1066]	= 0,	-- Aquatic Form
	[1079]	= 16,	-- Rip
	[1120]	= 15,	-- Drain Soul
	[1120]	= 15,	-- Drain Soul
	[1126]	= 3600,	-- Mark of the Wild
	[1127]	= 27,	-- Food
	[1129]	= 30,	-- Food
	[1130]	= 300,	-- Hunter's Mark
	[1133]	= 27,	-- Drink
	[1134]	= 15,	-- Inner Rage
	[1135]	= 30,	-- Drink
	[1137]	= 30,	-- Drink
	[1159]	= 6,	-- First Aid
	[1160]	= 30,	-- Demoralizing Shout
	[1161]	= 6,	-- Challenging Shout
	[1330]	= 3,	-- Garrote - Silence
	[1459]	= 3600,	-- Arcane Brilliance
	[1463]	= 60,	-- Mana Shield
	[1490]	= 300,	-- Curse of the Elements
	[1513]	= 20,	-- Scare Beast
	[1539]	= 10,	-- Feed Pet
	[1543]	= 0,	-- Flare
	[1604]	= 4,	-- Dazed
	[1706]	= 120,	-- Levitate
	[1714]	= 30,	-- Curse of Tongues
	[1715]	= 15,	-- Hamstring
	[1719]	= 12,	-- Recklessness
	[1742]	= 6,	-- Cower
	[1776]	= 4,	-- Gouge
	[1784]	= 0,	-- Stealth
	[1822]	= 9,	-- Rake
	[1833]	= 4,	-- Cheap Shot
	[1850]	= 15,	-- Dash
	[1943]	= 6,	-- Rupture
	[1949]	= 15,	-- Hellfire
	[1953]	= 1,	-- Blink
	[1978]	= 15,	-- Serpent Sting
	[2094]	= 10,	-- Blind
	[2367]	= 3600,	-- Lesser Strength
	[2374]	= 3600,	-- Lesser Agility
	[2378]	= 3600,	-- Health
	[2457]	= 0,	-- Battle Stance
	[2458]	= 0,	-- Berserker Stance
	[2479]	= 30,	-- Honorless Target
	[2565]	= 10,	-- Shield Block
	[2584]	= 0,	-- Waiting to Resurrect
	[2601]	= 30,	-- Fire Shield III
	[2602]	= 15,	-- Fire Shield IV
	[2645]	= 0,	-- Ghost Wolf
	[2812]	= 3,	-- Holy Wrath
	[2818]	= 12,	-- Deadly Poison
	[2825]	= 40,	-- Bloodlust
	[2895]	= 0,	-- Wrath of Air Totem
	[2895]	= 0,	-- Wrath of Air Totem
	[2944]	= 24,	-- Devouring Plague
	[2974]	= 10,	-- Wing Clip
	[2983]	= 8,	-- Sprint
	[3045]	= 15,	-- Rapid Fire
	[3045]	= 15,	-- Rapid Fire
	[3166]	= 3600,	-- Lesser Intellect
	[3166]	= 3600,	-- Lesser Intellect
	[3219]	= 3600,	-- Weak Troll's Blood Elixir
	[3220]	= 3600,	-- Armor
	[3222]	= 3600,	-- Strong Troll's Blood Elixir
	[3248]	= 6,	-- Improved Blocking
	[3256]	= 240,	-- Plague Cloud
	[3267]	= 7,	-- First Aid
	[3355]	= 20,	-- Freezing Trap
	[3356]	= 45,	-- Flame Lash
	[3409]	= 12,	-- Crippling Poison
	[3409]	= 12,	-- Crippling Poison
	[3419]	= 6,	-- Improved Blocking
	[3427]	= 30,	-- Infected Wound
	[3436]	= 300,	-- Wandering Plague
	[3436]	= 300,	-- Wandering Plague
	[3439]	= 300,	-- Wandering Plague
	[3583]	= 60,	-- Deadly Poison
	[3593]	= 3600,	-- Elixir of Fortitude
	[3600]	= 5,	-- Earthbind
	[3600]	= 5,	-- Earthbind
	[3603]	= 15,	-- Distracting Pain
	[3604]	= 8,	-- Tendon Rip
	[3639]	= 6,	-- Improved Blocking
	[3674]	= 15,	-- Black Arrow
	[3714]	= 600,	-- Path of Frost
	[3714]	= 600,	-- Path of Frost
	[3742]	= 15,	-- Static Electricity
	[3815]	= 45,	-- Poison Cloud
	[4167]	= 5,	-- Web
	[4167]	= 5,	-- Web
	[4318]	= 1800,	-- Guile of the Raptor
	[5005]	= 21,	-- Food
	[5115]	= 6,	-- Battle Command
	[5116]	= 4,	-- Concussive Shot
	[5118]	= 0,	-- Aspect of the Cheetah
	[5137]	= 60,	-- Call of the Grave
	[5138]	= 3,	-- Drain Mana
	[5159]	= 20,	-- Melt Ore
	[5171]	= 6,	-- Slice and Dice
	[5209]	= 6,	-- Challenging Roar
	[5211]	= 4,	-- Bash
	[5213]	= 15,	-- Molten Metal
	[5215]	= 0,	-- Prowl
	[5217]	= 6,	-- Tiger's Fury
	[5225]	= 0,	-- Track Humanoids
	[5229]	= 10,	-- Enrage
	[5246]	= 8,	-- Intimidating Shout
	[5262]	= 10,	-- Fanatic Blade
	[5277]	= 15,	-- Evasion
	[5280]	= 45,	-- Razor Mane
	[5384]	= 360,	-- Feign Death
	[5403]	= 6,	-- Crash of Waves
	[5413]	= 120,	-- Noxious Catalyst
	[5484]	= 8,	-- Howl of Terror
	[5487]	= 0,	-- Bear Form
	[5570]	= 12,	-- Insect Swarm
	[5677]	= 0,	-- Mana Spring
	[5697]	= 600,	-- Unending Breath
	[5740]	= 8,	-- Rain of Fire
	[5760]	= 10,	-- Mind-numbing Poison
	[5782]	= 20,	-- Fear
	[5784]	= 0,	-- Felsteed
	[5916]	= 0,	-- Shadowstalker Stealth
	[6016]	= 20,	-- Pierce Armor
	[6114]	= 300,	-- Raptor Punch
	[6117]	= 1800,	-- Mage Armor
	[6136]	= 5,	-- Chilled
	[6146]	= 15,	-- Slow
	[6150]	= 12,	-- Quick Shots
	[6196]	= 60,	-- Far Sight
	[6229]	= 30,	-- Shadow Ward
	[6253]	= 2,	-- Backhand
	[6268]	= 3,	-- Rushing Charge
	[6278]	= 60,	-- Creeping Mold
	[6306]	= 30,	-- Acid Splash
	[6307]	= 0,	-- Blood Pact
	[6343]	= 30,	-- Thunder Clap
	[6346]	= 180,	-- Fear Ward
	[6358]	= 30,	-- Seduction
	[6432]	= 10,	-- Smite Stomp
	[6466]	= 3,	-- Axe Toss
	[6524]	= 2,	-- Ground Tremor
	[6533]	= 2,	-- Net
	[6562]	= 0,	-- Heroic Presence
	[6653]	= 0,	-- Dire Wolf
	[6673]	= 120,	-- Battle Shout
	[6713]	= 5,	-- Disarm
	[6726]	= 5,	-- Silence
	[6728]	= 10,	-- Enveloping Winds
	[6742]	= 30,	-- Bloodlust
	[6770]	= 60,	-- Sap
	[6788]	= 15,	-- Weakened Soul
	[6789]	= 3,	-- Death Coil
	[6795]	= 3,	-- Growl
	[6940]	= 12,	-- Hand of Sacrifice
	[6950]	= 60,	-- Faerie Fire
	[7038]	= 60,	-- Forsaken Skill: Swords
	[7039]	= 60,	-- Forsaken Skill: Axes
	[7040]	= 60,	-- Forsaken Skill: Daggers
	[7041]	= 60,	-- Forsaken Skill: Maces
	[7042]	= 60,	-- Forsaken Skill: Staves
	[7044]	= 60,	-- Forsaken Skill: Guns
	[7045]	= 60,	-- Forsaken Skill: 2H Axes
	[7046]	= 60,	-- Forsaken Skill: 2H Maces
	[7047]	= 60,	-- Forsaken Skill: 2H Swords
	[7049]	= 60,	-- Forsaken Skill: Fire
	[7051]	= 60,	-- Forsaken Skill: Holy
	[7053]	= 60,	-- Forsaken Skill: Shadow
	[7054]	= 300,	-- Forsaken Skills
	[7057]	= 300,	-- Haunting Spirits
	[7068]	= 15,	-- Veil of Shadow
	[7072]	= 60,	-- Wild Rage
	[7074]	= 5,	-- Screams of the Past
	[7121]	= 10,	-- Anti-Magic Shield
	[7124]	= 300,	-- Arugal's Gift
	[7125]	= 120,	-- Toxic Saliva
	[7127]	= 60,	-- Wavering Will
	[7140]	= 5,	-- Expose Weakness
	[7178]	= 1800,	-- Water Breathing
	[7294]	= 0,	-- Retribution Aura
	[7295]	= 10,	-- Soul Drain
	[7302]	= 1800,	-- Frost Armor
	[7321]	= 5,	-- Chilled
	[7353]	= 60,	-- Cozy Fire
	[7389]	= 15,	-- Attack
	[7399]	= 4,	-- Terrify
	[7481]	= 300,	-- Howling Rage
	[7483]	= 300,	-- Howling Rage
	[7484]	= 300,	-- Howling Rage
	[7621]	= 10,	-- Arugal's Curse
	[7739]	= 10,	-- Inferno Shell
	[7744]	= 0,	-- Will of the Forsaken
	[7812]	= 30,	-- Sacrifice
	[7844]	= 3600,	-- Fire Power
	[7870]	= 300,	-- Lesser Invisibility
	[7922]	= 1.5,	-- Charge Stun
	[7947]	= 60,	-- Localized Toxin
	[7948]	= 20,	-- Wild Regeneration
	[7964]	= 4,	-- Smoke Bomb
	[7966]	= 60,	-- Thorns Aura
	[7992]	= 25,	-- Slowing Poison
	[8034]	= 8,	-- Frostbrand Attack
	[8040]	= 15,	-- Druid's Slumber
	[8041]	= 10,	-- Serpent Form
	[8042]	= 8,	-- Earth Shock
	[8050]	= 18,	-- Flame Shock
	[8056]	= 8,	-- Frost Shock
	[8066]	= 120,	-- Shrink
	[8068]	= 1800,	-- Healthy Spirit
	[8076]	= 0,	-- Strength of Earth
	[8078]	= 10,	-- Thunderclap
	[8096]	= 1800,	-- Intellect
	[8101]	= 1800,	-- Stamina
	[8112]	= 1800,	-- Spirit
	[8117]	= 1800,	-- Agility
	[8119]	= 1800,	-- Strength
	[8122]	= 8,	-- Psychic Scream
	[8140]	= 15,	-- Befuddlement
	[8148]	= 60,	-- Thorns Aura
	[8153]	= 0,	-- Owl Form
	[8178]	= 0,	-- Grounding Totem Effect
	[8185]	= 0,	-- Elemental Resistance
	[8202]	= 1200,	-- Sapta Sight
	[8212]	= 1200,	-- Enlarge
	[8219]	= 3600,	-- Flip Out
	[8220]	= 3600,	-- Flip Out
	[8221]	= 3600,	-- Yaaarrrr
	[8222]	= 3600,	-- Yaaarrrr
	[8242]	= 2,	-- Shield Slam
	[8258]	= 240,	-- Devotion Aura
	[8263]	= 0,	-- Elemental Protection Totem Aura
	[8267]	= 600,	-- Cursed Blood
	[8269]	= 120,	-- Frenzy
	[8272]	= 600,	-- Mind Tremor
	[8275]	= 75,	-- Poisoned Shot
	[8281]	= 6,	-- Sonic Burst
	[8282]	= 120,	-- Curse of Blood
	[8285]	= 2.5,	-- Rampage
	[8314]	= 3600,	-- Rock Skin
	[8326]	= 0,	-- Ghost
	[8362]	= 20,	-- Renew
	[8365]	= 10,	-- Enlarge
	[8377]	= 4,	-- Earthgrab
	[8379]	= 10,	-- Disarm
	[8382]	= 45,	-- Leech Poison
	[8385]	= 3600,	-- Swift Wind
	[8391]	= 3,	-- Ravage
	[8395]	= 0,	-- Emerald Raptor
	[8398]	= 8,	-- Frostbolt Volley
	[8399]	= 10,	-- Sleep
	[8515]	= 0,	-- Windfury Totem
	[8599]	= 120,	-- Enrage
	[8600]	= 180,	-- Fevered Plague
	[8647]	= 10,	-- Expose Armor (1 combo point = 10 seconds)
	[8733]	= 3600,	-- Blessing of Blackfathom
	[8788]	= 600,	-- Lightning Shield
	[8898]	= 1200,	-- Sapta Sight
	[8921]	= 12,	-- Moonfire
	[8936]	= 6,	-- Regrowth
	[8988]	= 10,	-- Silence
	[8990]	= 0,	-- Retribution Aura
	[9005]	= 3,	-- Pounce
	[9007]	= 18,	-- Pounce Bleed
	[9034]	= 21,	-- Immolate
	[9080]	= 10,	-- Hamstring
	[9128]	= 120,	-- Battle Shout
	[9256]	= 10,	-- Deep Sleep
	[9275]	= 21,	-- Immolate
	[9438]	= 8,	-- Arcane Bubble
	[9459]	= 60,	-- Corrosive Ooze
	[9482]	= 30,	-- Amplify Flames
	[9484]	= 50,	-- Shackle Undead
	[9672]	= 4,	-- Frostbolt
	[9775]	= 60,	-- Irradiated
	[9798]	= 0,	-- Radiation
	[9906]	= 5,	-- Reflection
	[10060]	= 15,	-- Power Infusion
	[10093]	= 1,	-- Harsh Winds
	[10326]	= 20,	-- Turn Evil
	[10348]	= 20,	-- Tune Up
	[10452]	= 20,	-- Flame Buffet
	[10668]	= 3600,	-- Spirit of Boar
	[10730]	= 10,	-- Pacify
	[10732]	= 10,	-- Supercharge
	[10734]	= 3,	-- Hail Storm
	[10796]	= 0,	-- Turquoise Raptor
	[10799]	= 0,	-- Violet Raptor
	[10831]	= 5,	-- Reflection Field
	[10838]	= 8,	-- First Aid
	[11020]	= 8,	-- Petrify
	[11113]	= 3,	-- Blast Wave
	[11131]	= 10,	-- Icicle
	[11196]	= 60,	-- Recently Bandaged
	[11264]	= 10,	-- Ice Blast
	[11327]	= 3,	-- Vanish
	[11328]	= 3600,	-- Agility
	[11334]	= 3600,	-- Greater Agility
	[11348]	= 3600,	-- Greater Armor
	[11349]	= 3600,	-- Armor
	[11366]	= 12,	-- Pyroblast
	[11390]	= 3600,	-- Arcane Elixir
	[11396]	= 3600,	-- Greater Intellect
	[11397]	= 300,	-- Diseased Shot
	[11426]	= 60,	-- Ice Barrier
	[11436]	= 10,	-- Slow
	[11442]	= 180,	-- Withered Touch
	[11443]	= 15,	-- Cripple
	[11445]	= 60,	-- Bone Armor
	[11538]	= 4,	-- Frostbolt
	[11639]	= 18,	-- Shadow Word: Pain
	[11640]	= 15,	-- Renew
	[11641]	= 10,	-- Hex
	[11647]	= 30,	-- Power Word: Shield
	[11820]	= 6,	-- Electrified Net
	[11841]	= 600,	-- Static Barrier
	[11876]	= 5,	-- War Stomp
	[11922]	= 15,	-- Entangling Roots
	[11962]	= 15,	-- Immolate
	[11971]	= 30,	-- Sunder Armor
	[11974]	= 30,	-- Power Word: Shield
	[11977]	= 15,	-- Rend
	[11980]	= 120,	-- Curse of Weakness
	[12024]	= 5,	-- Net
	[12040]	= 30,	-- Shadow Shield
	[12042]	= 15,	-- Arcane Power
	[12043]	= 0,	-- Presence of Mind
	[12051]	= 6,	-- Evocation
	[12096]	= 8,	-- Fear
	[12097]	= 20,	-- Pierce Armor
	[12098]	= 20,	-- Sleep
	[12169]	= 5,	-- Shield Block
	[12178]	= 1800,	-- Stamina
	[12245]	= 300,	-- Infected Spine
	[12248]	= 10,	-- Amplify Damage
	[12251]	= 30,	-- Virulent Poison
	[12255]	= 900,	-- Curse of Tuten'kash
	[12292]	= 30,	-- Death Wish
	[12294]	= 10,	-- Mortal Strike
	[12323]	= 6,	-- Piercing Howl
	[12328]	= 10,	-- Sweeping Strikes
	[12355]	= 2,	-- Impact
	[12421]	= 2,	-- Mithril Frag Bomb
	[12461]	= 2,	-- Backhand
	[12472]	= 20,	-- Icy Veins
	[12479]	= 10,	-- Hex of Jammal'an
	[12484]	= 2,	-- Chilled
	[12486]	= 1.5,	-- Chilled
	[12493]	= 120,	-- Curse of Weakness
	[12528]	= 10,	-- Silence
	[12530]	= 60,	-- Frailty
	[12531]	= 8,	-- Chilling Touch
	[12536]	= 15,	-- Clearcasting
	[12540]	= 4,	-- Gouge
	[12541]	= 600,	-- Ghoul Rot
	[12544]	= 1800,	-- Frost Armor
	[12548]	= 8,	-- Frost Shock
	[12579]	= 15,	-- Winter's Chill
	[12611]	= 8,	-- Cone of Cold
	[12627]	= 0,	-- Disease Cloud
	[12654]	= 4,	-- Ignite
	[12721]	= 6,	-- Deep Wounds
	[12741]	= 120,	-- Curse of Weakness
	[12795]	= 120,	-- Frenzy
	[12809]	= 5,	-- Concussion Blow
	[12884]	= 45,	-- Acid Breath
	[12890]	= 15,	-- Deep Slumber
	[12891]	= 45,	-- Acid Breath
	[12946]	= 10,	-- Putrid Stench
	[12968]	= 15,	-- Flurry
	[12976]	= 20,	-- Last Stand
	[13159]	= 0,	-- Aspect of the Pack
	[13165]	= 0,	-- Aspect of the Hawk
	[13218]	= 15,	-- Wound Poison
	[13298]	= 30,	-- Poison
	[13326]	= 1800,	-- Arcane Intellect
	[13439]	= 5,	-- Frostbolt
	[13443]	= 15,	-- Rend
	[13445]	= 15,	-- Rend
	[13526]	= 30,	-- Corrosive Poison
	[13532]	= 10,	-- Thunder Clap
	[13704]	= 6,	-- Psychic Scream
	[13730]	= 30,	-- Demoralizing Shout
	[13750]	= 15,	-- Adrenaline Rush
	[13797]	= 15,	-- Immolation Trap
	[13810]	= 30,	-- Ice Trap
	[13812]	= 20,	-- Explosive Trap
	[13864]	= 1800,	-- Power Word: Fortitude
	[13877]	= 15,	-- Blade Flurry
	[14030]	= 6,	-- Hooked Net
	[14032]	= 18,	-- Shadow Word: Pain
	[14143]	= 20,	-- Remorseless
	[14149]	= 20,	-- Remorseless
	[14177]	= 0,	-- Cold Blood
	[14183]	= 20,	-- Premeditation
	[14201]	= 9,	-- Enrage
	[14202]	= 9,	-- Enrage
	[14251]	= 30,	-- Riposte
	[14267]	= 0,	-- Horde Flag
	[14268]	= 0,	-- Alliance Flag
	[14515]	= 15,	-- Dominate Mind
	[14517]	= 30,	-- Crusader Strike
	[14518]	= 30,	-- Crusader Strike
	[14751]	= 30,	-- Chakra
	[14893]	= 15,	-- Inspiration
	[14914]	= 7,	-- Holy Fire
	[15007]	= 600,	-- Resurrection Sickness
	[15039]	= 12,	-- Flame Shock
	[15087]	= 15,	-- Evasion
	[15286]	= 1800,	-- Vampiric Embrace
	[15357]	= 15,	-- Inspiration
	[15407]	= 3,	-- Mind Flay
	[15473]	= 0,	-- Shadowform
	[15487]	= 5,	-- Silence
	[15531]	= 8,	-- Frost Nova
	[15532]	= 8,	-- Frost Nova
	[15548]	= 10,	-- Thunderclap
	[15571]	= 4,	-- Dazed
	[15572]	= 30,	-- Sunder Armor
	[15588]	= 10,	-- Thunderclap
	[15708]	= 5,	-- Mortal Strike
	[15971]	= 30,	-- Demoralizing Roar
	[15976]	= 10,	-- Puncture
	[16166]	= 30,	-- Elemental Mastery
	[16177]	= 15,	-- Ancestral Fortitude
	[16188]	= 0,	-- Nature's Swiftness
	[16191]	= 0,	-- Mana Tide
	[16236]	= 15,	-- Ancestral Fortitude
	[16244]	= 30,	-- Demoralizing Shout
	[16246]	= 15,	-- Clearcasting
	[16277]	= 15,	-- Flurry
	[16278]	= 15,	-- Flurry
	[16468]	= 0,	-- Mother's Milk
	[16488]	= 5,	-- Blood Craze
	[16490]	= 5,	-- Blood Craze
	[16491]	= 5,	-- Blood Craze
	[16509]	= 15,	-- Rend
	[16511]	= 60,	-- Hemorrhage
	[16567]	= 600,	-- Tainted Mind
	[16591]	= 600,	-- Noggenfogger Elixir
	[16593]	= 15,	-- Noggenfogger Elixir
	[16595]	= 600,	-- Noggenfogger Elixir
	[16609]	= 3600,	-- Warchief's Blessing
	[16689]	= 45,	-- Nature's Grasp
	[16711]	= 300,	-- Grow
	[16739]	= 300,	-- Orb of Deception
	[16857]	= 600,	-- Faerie Fire (Feral)
	[16870]	= 8,	-- Clearcasting
	[16886]	= 15,	-- Nature's Grace
	[16914]	= 10,	-- Hurricane
	[17038]	= 1200,	-- Winterfall Firewater
	[17057]	= 6,	-- Furor
	[17116]	= 0,	-- Nature's Swiftness
	[17154]	= 30,	-- The Green Tower
	[17229]	= 0,	-- Winterspring Frostsaber
	[17364]	= 15,	-- Stormstrike
	[17462]	= 0,	-- Red Skeletal Horse
	[17463]	= 0,	-- Blue Skeletal Horse
	[17464]	= 0,	-- Brown Skeletal Horse
	[17465]	= 0,	-- Green Skeletal Warhorse
	[17481]	= 0,	-- Rivendare's Deathcharger
	[17535]	= 3600,	-- Elixir of the Sages
	[17535]	= 3600,	-- Elixir of the Sages
	[17537]	= 3600,	-- Elixir of Brute Force
	[17539]	= 3600,	-- Greater Arcane Elixir
	[17619]	= 0,	-- Alchemist's Stone
	[17627]	= 3600,	-- Distilled Wisdom
	[17628]	= 3600,	-- Supreme Power
	[17670]	= 0,	-- Argent Dawn Commission
	[17735]	= 5,	-- Suffering
	[17767]	= 6,	-- Consume Shadows
	[17800]	= 30,	-- Shadow Mastery
	[17941]	= 10,	-- Shadow Trance
	[18070]	= 30,	-- Earthborer Acid
	[18118]	= 5,	-- Aftermath
	[18223]	= 30,	-- Curse of Exhaustion
	[18266]	= 15,	-- Curse of Agony
	[18267]	= 30,	-- Curse of Weakness
	[18381]	= 30,	-- Cripple
	[18400]	= 0,	-- Piccolo of the Flaming Fire
	[18400]	= 0,	-- Piccolo of the Flaming Fire
	[18425]	= 1.5,	-- Silenced - Improved Kick
	[18469]	= 2,	-- Silenced - Improved Counterspell
	[18498]	= 3,	-- Silenced - Gag Order
	[18499]	= 10,	-- Berserker Rage
	[18610]	= 8,	-- First Aid
	[18708]	= 15,	-- Fel Domination
	[18972]	= 20,	-- Slow
	[18989]	= 0,	-- Gray Kodo
	[18990]	= 0,	-- Brown Kodo
	[19136]	= 5,	-- Stormbolt
	[19263]	= 5,	-- Deterrence
	[19306]	= 5,	-- Counterattack
	[19386]	= 30,	-- Wyvern Sting
	[19434]	= 0,	-- Aimed Shot
	[19503]	= 4,	-- Scatter Shot
	[19506]	= 0,	-- Trueshot Aura
	[19574]	= 10,	-- Bestial Wrath
	[19577]	= 15,	-- Intimidation
	[19615]	= 10,	-- Frenzy Effect
	[19683]	= 900,	-- Tame Armored Scorpid
	[19705]	= 900,	-- Well Fed
	[19706]	= 900,	-- Well Fed
	[19709]	= 900,	-- Well Fed
	[19710]	= 900,	-- Well Fed
	[19740]	= 3600,	-- Blessing of Might
	[19746]	= 0,	-- Concentration Aura
	[19821]	= 5,	-- Arcane Bomb
	[19883]	= 0,	-- Track Humanoids
	[19891]	= 0,	-- Resistance Aura
	[19975]	= 27,	-- Entangling Roots
	[20005]	= 5,	-- Chilled
	[20006]	= 12,	-- Unholy Curse
	[20007]	= 15,	-- Holy Strength
	[20043]	= 0,	-- Aspect of the Wild
	[20050]	= 15,	-- Conviction
	[20052]	= 15,	-- Conviction
	[20053]	= 15,	-- Conviction
	[20066]	= 60,	-- Repentance
	[20132]	= 10,	-- Redoubt
	[20154]	= 1800,	-- Seal of Righteousness
	[20164]	= 1800,	-- Seal of Justice
	[20165]	= 1800,	-- Seal of Insight
	[20170]	= 5,	-- Seal of Justice
	[20178]	= 8,	-- Reckoning
	[20217]	= 3600,	-- Blessing of Kings
	[20230]	= 12,	-- Retaliation
	[20253]	= 3,	-- Intercept
	[20511]	= 8,	-- Intimidating Shout
	[20549]	= 2,	-- War Stomp
	[20572]	= 15,	-- Blood Fury
	[20578]	= 10,	-- Cannibalize
	[20615]	= 3,	-- Intercept
	[20707]	= 900,	-- Soulstone Resurrection
	[20736]	= 6,	-- Distracting Shot
	[20798]	= 1800,	-- Demon Skin
	[20800]	= 21,	-- Immolate
	[20875]	= 900,	-- Rumsey Rum
	[20911]	= 0,	-- Sanctuary
	[20925]	= 0,	-- Holy Shield
	[21007]	= 120,	-- Curse of Weakness
	[21049]	= 30,	-- Bloodlust
	[21062]	= 30,	-- Putrid Breath
	[21067]	= 10,	-- Poison Bolt
	[21068]	= 24,	-- Corruption
	[21069]	= 6,	-- Larva Goo
	[21163]	= 1800,	-- Polished Armor
	[21163]	= 1800,	-- Polished Armor
	[21331]	= 15,	-- Entangling Roots
	[21337]	= 600,	-- Thorns
	[21547]	= 5,	-- Spore Cloud
	[21562]	= 3600,	-- Power Word: Fortitude
	[21655]	= 1,	-- Blink
	[21687]	= 15,	-- Toxic Volley
	[21749]	= 2,	-- Thorn Volley
	[21787]	= 120,	-- Deadly Poison
	[21909]	= 8,	-- Dust Field
	[22570]	= 0,	-- Maim
	[22717]	= 0,	-- Black War Steed
	[22718]	= 0,	-- Black War Kodo
	[22719]	= 0,	-- Black Battlestrider
	[22720]	= 0,	-- Black War Ram
	[22721]	= 0,	-- Black War Raptor
	[22722]	= 0,	-- Red Skeletal Warhorse
	[22723]	= 0,	-- Black War Tiger
	[22724]	= 0,	-- Black War Wolf
	[22766]	= 0,	-- Sneak
	[22812]	= 12,	-- Barkskin
	[22842]	= 20,	-- Frenzied Regeneration
	[22888]	= 7200,	-- Rallying Cry of the Dragonslayer
	[22911]	= 2,	-- Charge
	[22959]	= 30,	-- Critical Mass
	[23033]	= 0,	-- Battle Standard
	[23036]	= 0,	-- Battle Standard
	[23145]	= 16,	-- Dive
	[23161]	= 0,	-- Dreadsteed
	[23214]	= 0,	-- Summon Charger
	[23219]	= 0,	-- Swift Mistsaber
	[23221]	= 0,	-- Swift Frostsaber
	[23223]	= 0,	-- Swift White Mechanostrider
	[23225]	= 0,	-- Swift Green Mechanostrider
	[23225]	= 0,	-- Swift Green Mechanostrider
	[23227]	= 0,	-- Swift Palomino
	[23228]	= 0,	-- Swift White Steed
	[23229]	= 0,	-- Swift Brown Steed
	[23238]	= 0,	-- Swift Brown Ram
	[23239]	= 0,	-- Swift Gray Ram
	[23240]	= 0,	-- Swift White Ram
	[23241]	= 0,	-- Swift Blue Raptor
	[23242]	= 0,	-- Swift Olive Raptor
	[23243]	= 0,	-- Swift Orange Raptor
	[23246]	= 0,	-- Purple Skeletal Warhorse
	[23247]	= 0,	-- Great White Kodo
	[23248]	= 0,	-- Great Gray Kodo
	[23249]	= 0,	-- Great Brown Kodo
	[23250]	= 0,	-- Swift Brown Wolf
	[23251]	= 0,	-- Swift Timber Wolf
	[23252]	= 0,	-- Swift Gray Wolf
	[23333]	= 0,	-- Warsong Flag
	[23335]	= 0,	-- Silverwing Flag
	[23338]	= 0,	-- Swift Stormsaber
	[23451]	= 10,	-- Speed
	[23493]	= 10,	-- Restoration
	[23509]	= 0,	-- Frostwolf Howler
	[23510]	= 0,	-- Stormpike Battle Charger
	[23511]	= 30,	-- Demoralizing Shout
	[23600]	= 6,	-- Piercing Howl
	[23693]	= 120,	-- Stormpike's Salvation
	[23694]	= 5,	-- Improved Hamstring
	[23759]	= 0,	-- Master Demonologist
	[23760]	= 0,	-- Master Demonologist
	[23767]	= 7200,	-- Sayge's Dark Fortune of Armor
	[23768]	= 7200,	-- Sayge's Dark Fortune of Damage
	[23829]	= 0,	-- Master Demonologist
	[23844]	= 0,	-- Master Demonologist
	[23885]	= 8,	-- Bloodthirst
	[23920]	= 5,	-- Spell Reflection
	[23978]	= 10,	-- Speed
	[24131]	= 6,	-- Wyvern Sting
	[24242]	= 0,	-- Swift Razzashi Raptor
	[24252]	= 0,	-- Swift Zulian Tiger
	[24259]	= 3,	-- Spell Lock
	[24378]	= 60,	-- Berserking
	[24379]	= 10,	-- Restoration
	[24394]	= 3,	-- Intimidation
	[24425]	= 7200,	-- Spirit of Zandalar
	[24450]	= 0,	-- Prowl
	[24529]	= 0,	-- Spirit Bond
	[24709]	= 3600,	-- Pirate Costume
	[24711]	= 3600,	-- Ninja Costume
	[24712]	= 3600,	-- Leper Gnome Costume
	[24735]	= 3600,	-- Ghost Costume
	[24844]	= 45,	-- Lightning Breath
	[24858]	= 0,	-- Moonkin Form
	[24870]	= 900,	-- Well Fed
	[24907]	= 0,	-- Moonkin Aura
	[24932]	= 0,	-- Leader of the Pack
	[25040]	= 900,	-- Mark of Nature
	[25046]	= 2,	-- Arcane Torrent
	[25058]	= 15,	-- Renew
	[25163]	= 0,	-- Oozeling's Disgusting Aura
	[25207]	= 1800,	-- Amulet of the Moon
	[25228]	= 0,	-- Soul Link
	[25606]	= 1800,	-- Pendant of the Agate Shield
	[25694]	= 900,	-- Well Fed
	[25702]	= 21,	-- Food
	[25746]	= 15,	-- Damage Absorb
	[25747]	= 15,	-- Damage Absorb
	[25771]	= 120,	-- Forbearance
	[25780]	= 0,	-- Righteous Fury
	[25804]	= 900,	-- Rumsey Rum Black Label
	[25809]	= 12,	-- Crippling Poison
	[25810]	= 12,	-- Mind-numbing Poison
	[25859]	= 0,	-- Reindeer
	[25941]	= 900,	-- Well Fed
	[26004]	= 1800,	-- Mistletoe
	[26008]	= 1800,	-- Toast
	[26013]	= 900,	-- Deserter
	[26017]	= 30,	-- Vindication
	[26276]	= 3600,	-- Greater Firepower
	[26276]	= 3600,	-- Greater Firepower
	[26297]	= 10,	-- Berserking
	[26522]	= 1800,	-- Lunar Fortune
	[26573]	= 10,	-- Consecration
	[26679]	= 6,	-- Deadly Throw
	[27089]	= 30,	-- Drink
	[27243]	= 18,	-- Seed of Corruption
	[27683]	= 3600,	-- Shadow Protection
	[27813]	= 6,	-- Blessed Recovery
	[27817]	= 6,	-- Blessed Recovery
	[27818]	= 6,	-- Blessed Recovery
	[27827]	= 15,	-- Spirit of Redemption
	[27863]	= 600,	-- The Baron's Ultimatum
	[28093]	= 15,	-- Lightning Speed
	[28176]	= 1800,	-- Fel Armor
	[28271]	= 50,	-- Polymorph (turtle)
	[28272]	= 50,	-- Polymorph (pig)
	[28273]	= 600,	-- Bloodthistle
	[28274]	= 1200,	-- Bloodthistle Withdrawal
	[28489]	= 3600,	-- Camouflage
	[28491]	= 3600,	-- Healing Power
	[28497]	= 3600,	-- Mighty Agility
	[28509]	= 3600,	-- Greater Mana Regeneration
	[28518]	= 3600,	-- Flask of Fortification
	[28520]	= 3600,	-- Flask of Relentless Assault
	[28521]	= 3600,	-- Flask of Blinding Light
	[28694]	= 900,	-- Dreaming Glory
	[28703]	= 900,	-- Netherbloom Pollen
	[28730]	= 2,	-- Arcane Torrent
	[28747]	= 600,	-- Frenzy
	[28878]	= 0,	-- Heroic Presence
	[29073]	= 30,	-- Food
	[29131]	= 10,	-- Bloodrage
	[29166]	= 10,	-- Innervate
	[29175]	= 180,	-- Ribbon Dance
	[29175]	= 180,	-- Ribbon Dance
	[29178]	= 10,	-- Elemental Devastation
	[29235]	= 3600,	-- Fire Festival Fortitude
	[29332]	= 3600,	-- Fire-toasted Bun
	[29333]	= 3600,	-- Midsummer Sausage
	[29334]	= 3600,	-- Toasted Smorc
	[29335]	= 3600,	-- Elderberry Pie
	[29341]	= 5,	-- Shadowburn
	[29348]	= 900,	-- Goldenmist Special Brew
	[29544]	= 6,	-- Frightening Shout
	[29674]	= 0,	-- Lesser Shielding
	[29703]	= 6,	-- Dazed
	[29801]	= 0,	-- Rampage
	[29842]	= 10,	-- Second Wind
	[29882]	= 20,	-- Loose Mana
	[30070]	= 0,	-- Blood Frenzy
	[30108]	= 15,	-- Unstable Affliction
	[30151]	= 6,	-- Pursuit
	[30213]	= 6,	-- Legion Strike
	[30283]	= 3,	-- Shadowfury
	[30482]	= 1800,	-- Molten Armor
	[30802]	= 0,	-- Unleashed Rage
	[30808]	= 0,	-- Unleashed Rage
	[30823]	= 15,	-- Shamanistic Rage
	[30931]	= 20,	-- Battle Shout
	[30991]	= 0,	-- Stealth
	[31117]	= 5,	-- Unstable Affliction
	[31125]	= 4,	-- Blade Twisting
	[31224]	= 5,	-- Cloak of Shadows
	[31403]	= 120,	-- Battle Shout
	[31579]	= 0,	-- Arcane Empowerment
	[31583]	= 0,	-- Arcane Empowerment
	[31589]	= 15,	-- Slow
	[31616]	= 10,	-- Nature's Guardian
	[31643]	= 8,	-- Blazing Speed
	[31661]	= 5,	-- Dragon's Breath
	[31665]	= 0,	-- Master of Subtlety
	[31790]	= 3,	-- Righteous Defense
	[31801]	= 1800,	-- Seal of Truth
	[31803]	= 15,	-- Censure
	[31821]	= 6,	-- Aura Mastery
	[31842]	= 20,	-- Divine Favor
	[31850]	= 10,	-- Ardent Defender
	[31884]	= 20,	-- Avenging Wrath
	[31930]	= 10,	-- Judgements of the Wise
	[31935]	= 3,	-- Avenger's Shield
	[32182]	= 40,	-- Heroism
	[32216]	= 20,	-- Victorious
	[32223]	= 0,	-- Crusader Aura
	[32240]	= 0,	-- Snowy Gryphon
	[32240]	= 0,	-- Snowy Gryphon
	[32243]	= 0,	-- Tawny Wind Rider
	[32244]	= 0,	-- Blue Wind Rider
	[32245]	= 0,	-- Green Wind Rider
	[32246]	= 0,	-- Swift Red Wind Rider
	[32289]	= 0,	-- Swift Red Gryphon
	[32289]	= 0,	-- Swift Red Gryphon
	[32292]	= 0,	-- Swift Purple Gryphon
	[32295]	= 0,	-- Swift Green Wind Rider
	[32296]	= 0,	-- Swift Yellow Wind Rider
	[32297]	= 0,	-- Swift Purple Wind Rider
	[32386]	= 12,	-- Shadow Embrace
	[32388]	= 12,	-- Shadow Embrace
	[32389]	= 12,	-- Shadow Embrace
	[32409]	= 1,	-- Shadow Word: Death
	[32600]	= 10,	-- Avoidance
	[32612]	= 20,	-- Invisibility
	[32645]	= 1,	-- Envenom
	[32727]	= 0,	-- Arena Preparation
	[32736]	= 5,	-- Mortal Strike
	[32752]	= 5,	-- Summoning Disorientation
	[33053]	= 7200,	-- Mr Pinchy's Blessing
	[33082]	= 1800,	-- Strength
	[33151]	= 10,	-- Surge of Light
	[33151]	= 10,	-- Surge of Light
	[33197]	= 24,	-- Misery
	[33198]	= 24,	-- Misery
	[33206]	= 8,	-- Pain Suppression
	[33254]	= 1800,	-- Well Fed
	[33256]	= 1800,	-- Well Fed
	[33257]	= 1800,	-- Well Fed
	[33259]	= 1800,	-- Well Fed
	[33263]	= 1800,	-- Well Fed
	[33268]	= 1800,	-- Well Fed
	[33280]	= 3600,	-- Corporal
	[33395]	= 8,	-- Freeze
	[33660]	= 0,	-- Swift Pink Hawkstrider
	[33697]	= 15,	-- Blood Fury
	[33702]	= 15,	-- Blood Fury
	[33720]	= 3600,	-- Onslaught Elixir
	[33721]	= 3600,	-- Spellpower Elixir
	[33726]	= 3600,	-- Elixir of Mastery
	[33745]	= 15,	-- Lacerate
	[33763]	= 10,	-- Lifebloom
	[33786]	= 6,	-- Cyclone
	[33876]	= 60,	-- Mangle
	[33878]	= 60,	-- Mangle
	[33891]	= 30,	-- Tree of Life
	[33943]	= 0,	-- Flight Form
	[34321]	= 10,	-- Call of the Nexus
	[34410]	= 3600,	-- Hellscream's Warsong
	[34471]	= 10,	-- The Beast Within
	[34477]	= 20,	-- Misdirection
	[34490]	= 3,	-- Silencing Shot
	[34655]	= 8,	-- Deadly Poison
	[34709]	= 15,	-- Shadow Sight
	[34767]	= 0,	-- Summon Charger
	[34769]	= 0,	-- Summon Warhorse
	[34790]	= 0,	-- Dark War Talbuk
	[34795]	= 0,	-- Red Hawkstrider
	[34837]	= 8,	-- Master Tactician
	[34896]	= 0,	-- Cobalt War Talbuk
	[34897]	= 0,	-- White War Talbuk
	[34898]	= 0,	-- Silver War Talbuk
	[34899]	= 0,	-- Tan War Talbuk
	[34914]	= 15,	-- Vampiric Touch
	[34936]	= 8,	-- Backlash
	[34976]	= 0,	-- Netherstorm Flag
	[35018]	= 0,	-- Purple Hawkstrider
	[35020]	= 0,	-- Blue Hawkstrider
	[35022]	= 0,	-- Black Hawkstrider
	[35025]	= 0,	-- Swift Green Hawkstrider
	[35027]	= 0,	-- Swift Purple Hawkstrider
	[35028]	= 0,	-- Swift Warstrider
	[35079]	= 4,	-- Misdirection
	[35098]	= 20,	-- Rapid Killing
	[35099]	= 20,	-- Rapid Killing
	[35101]	= 4,	-- Concussive Barrage
	[35696]	= 0,	-- Demonic Knowledge
	[35706]	= 0,	-- Master Demonologist
	[35712]	= 0,	-- Great Green Elekk
	[35713]	= 0,	-- Great Blue Elekk
	[35714]	= 0,	-- Great Purple Elekk
	[35944]	= 30,	-- Power Word: Shield
	[36032]	= 6,	-- Arcane Blast
	[36444]	= 0,	-- Wintergrasp Water
	[36554]	= 3,	-- Shadowstep
	[36563]	= 10,	-- Shadowstep
	[36702]	= 0,	-- Fiery Warhorse
	[36893]	= 3600,	-- Transporter Malfunction
	[36895]	= 3600,	-- Transporter Malfunction
	[36897]	= 3600,	-- Transporter Malfunction
	[36899]	= 3600,	-- Transporter Malfunction
	[37548]	= 3,	-- Taunt
	[37578]	= 5,	-- Debilitating Strike
	[37795]	= 3600,	-- Recruit
	[38232]	= 20,	-- Battle Shout
	[38254]	= 1800,	-- Festering Wound
	[38384]	= 8,	-- Cone of Cold
	[39171]	= 5,	-- Mortal Strike
	[39315]	= 0,	-- Cobalt Riding Talbuk
	[39316]	= 0,	-- Dark Riding Talbuk
	[39317]	= 0,	-- Silver Riding Talbuk
	[39318]	= 0,	-- Tan Riding Talbuk
	[39319]	= 0,	-- White Riding Talbuk
	[39439]	= 10,	-- Aura of the Crusader
	[39627]	= 3600,	-- Elixir of Draenic Wisdom
	[39628]	= 3600,	-- Elixir of Ironskin
	[39796]	= 3,	-- Stoneclaw Stun
	[39800]	= 0,	-- Red Riding Nether Ray
	[39802]	= 0,	-- Silver Riding Nether Ray
	[40120]	= 0,	-- Swift Flight Form
	[40192]	= 0,	-- Ashes of Al'ar
	[40623]	= 3600,	-- Apexis Vibrations
	[40625]	= 5400,	-- Apexis Emanations
	[41252]	= 0,	-- Raven Lord
	[41425]	= 30,	-- Hypothermia
	[41513]	= 0,	-- Onyx Netherwing Drake
	[41514]	= 0,	-- Azure Netherwing Drake
	[41516]	= 0,	-- Purple Netherwing Drake
	[41635]	= 30,	-- Prayer of Mending
	[42138]	= 7200,	-- Brewfest Enthusiast
	[42292]	= 0.1,	-- PvP Trinket
	[42650]	= 4,	-- Army of the Dead
	[42702]	= 10,	-- Decrepify
	[42705]	= 60,	-- Enrage
	[42723]	= 2,	-- Dark Smash
	[42728]	= 60,	-- Dreadful Roar
	[42740]	= 8,	-- Njord's Rune of Protection
	[42777]	= 0,	-- Swift Spectral Tiger
	[42792]	= 3,	-- Recently Dropped Flag
	[43180]	= 30,	-- Food
	[43182]	= 30,	-- Drink
	[43183]	= 30,	-- Drink
	[43195]	= 1800,	-- Intellect
	[43196]	= 1800,	-- Armor
	[43197]	= 1800,	-- Spirit
	[43265]	= 10,	-- Death and Decay
	[43664]	= 15,	-- Unholy Rage
	[43680]	= 60,	-- Idle
	[43681]	= 60,	-- Inactive
	[43688]	= 0,	-- Amani War Bear
	[43751]	= 10,	-- Energized
	[43771]	= 3600,	-- Well Fed
	[43900]	= 0,	-- Swift Brewfest Ram
	[43927]	= 0,	-- Cenarion War Hippogryph
	[43931]	= 15,	-- Rend
	[44151]	= 0,	-- Turbo-Charged Flying Machine
	[44153]	= 0,	-- Flying Machine
	[44212]	= 3600,	-- Jack-o'-Lanterned!
	[44413]	= 10,	-- Incanter's Absorption
	[44415]	= 3,	-- Blackout
	[44457]	= 12,	-- Living Bomb
	[44521]	= 0,	-- Preparation
	[44535]	= 6,	-- Spirit Heal
	[44544]	= 15,	-- Fingers of Frost
	[44572]	= 5,	-- Deep Freeze
	[44614]	= 9,	-- Frostfire Bolt
	[44795]	= 0,	-- Parachute
	[44825]	= 0,	-- Flying Reindeer
	[44825]	= 0,	-- Flying Reindeer
	[45062]	= 0,	-- Holy Energy
	[45123]	= 0,	-- Romantic Picnic
	[45182]	= 3,	-- Cheating Death
	[45241]	= 8,	-- Focused Will
	[45242]	= 8,	-- Focused Will
	[45245]	= 1800,	-- Well Fed
	[45282]	= 8,	-- Natural Perfection
	[45283]	= 8,	-- Natural Perfection
	[45334]	= 4,	-- Feral Charge Effect
	[45373]	= 7200,	-- Bloodberry
	[45438]	= 10,	-- Ice Block
	[45444]	= 0,	-- Bonfire's Blessing
	[45472]	= 60,	-- Parachute
	[45524]	= 8,	-- Chains of Ice
	[45529]	= 20,	-- Blood Tap
	[45544]	= 8,	-- First Aid
	[45548]	= 30,	-- Food
	[45693]	= 0,	-- Torches Caught
	[45694]	= 180,	-- Captain Rumsey's Lager
	[45699]	= 5,	-- Flames of Failure
	[45716]	= 40,	-- Torch Tossing Training
	[45724]	= 0,	-- Braziers Hit!
	[46168]	= 0,	-- Pet Biscuit
	[46199]	= 0,	-- X-51 Nether-Rocket X-TREME
	[46202]	= 10,	-- Pierce Armor
	[46221]	= 180,	-- Animal Blood
	[46352]	= 3600,	-- Fire Festival Fury
	[46355]	= 300,	-- Blood Elf Illusion
	[46356]	= 300,	-- Blood Elf Illusion
	[46604]	= 4,	-- Ice Block
	[46628]	= 0,	-- Swift White Hawkstrider
	[46630]	= 90,	-- Torch Tossing Practice
	[46833]	= 15,	-- Wrath of Elune
	[46857]	= 60,	-- Trauma
	[46899]	= 900,	-- Well Fed
	[46916]	= 10,	-- Bloodsurge
	[46924]	= 6,	-- Bladestorm
	[46968]	= 4,	-- Shockwave
	[46987]	= 4,	-- Frostbolt
	[46989]	= 3,	-- Improved Blink
	[47057]	= 180,	-- Fiery Seduction
	[47241]	= 30,	-- Metamorphosis
	[47283]	= 8,	-- Empowered Imp
	[47476]	= 5,	-- Strangulate
	[47481]	= 0,	-- Gnaw
	[47543]	= 0,	-- Frozen Prison
	[47585]	= 6,	-- Dispersion
	[47699]	= 300,	-- Crystal Bark
	[47747]	= 45,	-- Charge Rifts
	[47748]	= 45,	-- Rift Shield
	[47753]	= 12,	-- Divine Aegis
	[47774]	= 120,	-- Frenzy
	[47779]	= 4,	-- Arcane Torrent
	[47781]	= 6,	-- Spellbreaker
	[47791]	= 5,	-- Arcane Haste
	[47854]	= 0,	-- Frozen Prison
	[47930]	= 15,	-- Grace
	[47960]	= 6,	-- Shadowflame
	[47981]	= 15,	-- Spell Reflection
	[48018]	= 360,	-- Demonic Circle: Summon
	[48020]	= 1,	-- Demonic Circle: Teleport
	[48024]	= 0,	-- Headless Horseman's Mount
	[48025]	= 0,	-- Headless Horseman's Mount
	[48027]	= 0,	-- Black War Elekk
	[48058]	= 30,	-- Crystal Bloom
	[48095]	= 0,	-- Intense Cold
	[48100]	= 1800,	-- Intellect
	[48101]	= 1800,	-- Stamina
	[48102]	= 1800,	-- Stamina
	[48103]	= 1800,	-- Spirit
	[48108]	= 15,	-- Hot Streak
	[48111]	= 30,	-- Prayer of Mending
	[48181]	= 12,	-- Haunt
	[48263]	= 0,	-- Blood Presence
	[48265]	= 0,	-- Unholy Presence
	[48266]	= 0,	-- Frost Presence
	[48301]	= 10,	-- Mind Trauma
	[48333]	= 300,	-- Going Ape
	[48391]	= 10,	-- Owlkin Frenzy
	[48400]	= 20,	-- Frost Tomb
	[48418]	= 0,	-- Master Shapeshifter
	[48420]	= 0,	-- Master Shapeshifter
	[48421]	= 0,	-- Master Shapeshifter
	[48438]	= 7,	-- Wild Growth
	[48504]	= 15,	-- Living Seed
	[48505]	= 10,	-- Starfall
	[48517]	= 0,	-- Eclipse (Solar)
	[48518]	= 0,	-- Eclipse (Lunar)
	[48707]	= 5,	-- Anti-Magic Shell
	[48719]	= 600,	-- Water Breathing
	[48778]	= 0,	-- Acherus Deathcharger
	[48792]	= 12,	-- Icebound Fortitude
	[48836]	= 5,	-- Vengeful Justice
	[48838]	= 10,	-- Elemental Tenacity
	[48846]	= 20,	-- Runic Infusion
	[49016]	= 30,	-- Unholy Frenzy
	[49028]	= 12,	-- Dancing Rune Weapon
	[49039]	= 10,	-- Lichborne
	[49203]	= 0,	-- Hungering Cold
	[49206]	= 40,	-- Summon Gargoyle
	[49222]	= 300,	-- Bone Shield
	[49322]	= 0,	-- Swift Zhevra
	[49379]	= 0,	-- Great Brewfest Kodo
	[49560]	= 3,	-- Death Grip
	[49623]	= 15,	-- Effervescence
	[49759]	= 30,	-- Teleport
	[49868]	= 0,	-- Mind Quickening
	[49962]	= 17,	-- Jungle Madness!
	[50131]	= 10,	-- Draw Magic
	[50227]	= 5,	-- Sword and Board
	[50259]	= 3,	-- Dazed
	[50263]	= 20,	-- Quickness of the Sailor
	[50334]	= 15,	-- Berserk
	[50411]	= 3,	-- Dazed
	[50421]	= 20,	-- Scent of Blood
	[50434]	= 10,	-- Chilblains
	[50435]	= 10,	-- Chilblains
	[50461]	= 30,	-- Anti-Magic Zone
	[50518]	= 25,	-- Ravage
	[50519]	= 2,	-- Sonic Blast
	[50536]	= 10,	-- Unholy Blight
	[50589]	= 15,	-- Immolation Aura
	[50613]	= 2,	-- Arcane Torrent
	[50720]	= 1800,	-- Vigilance
	[50872]	= 30,	-- Savagery
	[50989]	= 3,	-- Flame Breath
	[51124]	= 10,	-- Killing Machine
	[51185]	= 0,	-- King of the Jungle
	[51209]	= 10,	-- Hungering Cold
	[51271]	= 20,	-- Pillar of Frost
	[51399]	= 3,	-- Death Grip
	[51460]	= 3,	-- Runic Corruption
	[51466]	= 0,	-- Elemental Oath
	[51470]	= 0,	-- Elemental Oath
	[51514]	= 60,	-- Hex
	[51585]	= 8,	-- Blade Twisting
	[51690]	= 2,	-- Killing Spree
	[51693]	= 8,	-- Waylay
	[51698]	= 0,	-- Honor Among Thieves
	[51700]	= 0,	-- Honor Among Thieves
	[51701]	= 0,	-- Honor Among Thieves
	[51713]	= 6,	-- Shadow Dance
	[51714]	= 20,	-- Frost Vulnerability
	[51722]	= 10,	-- Dismantle
	[51755]	= 60,	-- Camouflage
	[51789]	= 10,	-- Blade Barrier
	[51945]	= 12,	-- Earthliving
	[51987]	= 20,	-- Arcane Infusion
	[52109]	= 0,	-- Flametongue Totem
	[52127]	= 600,	-- Water Shield
	[52179]	= 0,	-- Astral Shift
	[52418]	= 0,	-- Carrying Seaforium
	[52419]	= 10,	-- Deflection
	[52437]	= 2,	-- Sudden Death
	[52446]	= 10,	-- Acid Splash
	[52459]	= 10,	-- End of Round
	[52470]	= 8,	-- Enrage
	[52493]	= 10,	-- Poison Spray
	[52537]	= 10,	-- Fixate
	[52610]	= 9,	-- Savage Roar
	[52909]	= 1800,	-- Water Breathing
	[52910]	= 8,	-- Turn the Tables
	[53030]	= 10,	-- Leech Poison
	[53137]	= 0,	-- Abomination's Might
	[53138]	= 0,	-- Abomination's Might
	[53148]	= 1,	-- Charge
	[53220]	= 8,	-- Improved Steady Shot
	[53257]	= 15,	-- Cobra Strikes
	[53283]	= 30,	-- Food
	[53284]	= 1800,	-- Well Fed
	[53290]	= 0,	-- Hunting Party
	[53301]	= 2,	-- Explosive Shot
	[53317]	= 15,	-- Rend
	[53322]	= 6,	-- Crushing Webs
	[53330]	= 20,	-- Infected Wound
	[53334]	= 9,	-- Animate Bones
	[53365]	= 15,	-- Unholy Strength
	[53386]	= 30,	-- Cinderglacier
	[53390]	= 15,	-- Tidal Waves
	[53401]	= 20,	-- Rabid
	[53403]	= 20,	-- Rabid Power
	[53426]	= 5,	-- Lick Your Wounds
	[53434]	= 20,	-- Call of the Wild
	[53467]	= 15,	-- Leeching Swarm
	[53468]	= 1,	-- Leeching Swarm
	[53477]	= 3,	-- Taunt
	[53480]	= 12,	-- Roar of Sacrifice
	[53515]	= 8,	-- Owl's Focus
	[53517]	= 9,	-- Roar of Recovery
	[53520]	= 4,	-- Carrion Beetles
	[53563]	= 60,	-- Beacon of Light
	[53602]	= 12,	-- Dart
	[53646]	= 0,	-- Demonic Pact
	[53657]	= 60,	-- Judgements of the Pure
	[53746]	= 3600,	-- Wrath Elixir
	[53747]	= 3600,	-- Elixir of Spirit
	[53748]	= 3600,	-- Mighty Strength
	[53749]	= 3600,	-- Guru's Elixir
	[53751]	= 3600,	-- Elixir of Mighty Fortitude
	[53752]	= 3600,	-- Lesser Flask of Toughness
	[53755]	= 3600,	-- Flask of the Frost Wyrm
	[53758]	= 3600,	-- Flask of Stoneblood
	[53760]	= 3600,	-- Flask of Endless Rage
	[53764]	= 3600,	-- Mighty Mana Regeneration
	[53768]	= 0,	-- Haunted
	[53801]	= 600,	-- Frenzy
	[53805]	= 600,	-- Pygmy Oil
	[53806]	= 600,	-- Pygmy Oil
	[53817]	= 30,	-- Maelstrom Weapon
	[53908]	= 15,	-- Speed
	[53909]	= 15,	-- Wild Magic
	[54131]	= 5,	-- Bloodthirsty
	[54149]	= 15,	-- Infusion of Light
	[54212]	= 3600,	-- Flask of Pure Mojo
	[54216]	= 4,	-- Master's Call
	[54277]	= 15,	-- Backdraft
	[54309]	= 10,	-- Mark of Darkness
	[54314]	= 30,	-- Drain Power
	[54315]	= 30,	-- Drain Power
	[54370]	= 12,	-- Nether Protection (Holy)
	[54371]	= 12,	-- Nether Protection (Fire)
	[54372]	= 12,	-- Nether Protection (Frost)
	[54373]	= 12,	-- Nether Protection (Arcane)
	[54374]	= 12,	-- Nether Protection (Shadow)
	[54375]	= 12,	-- Nether Protection (Nature)
	[54424]	= 0,	-- Fel Intelligence
	[54428]	= 15,	-- Divine Plea
	[54443]	= 20,	-- Demonic Empowerment
	[54452]	= 3600,	-- Adept's Elixir
	[54494]	= 3600,	-- Major Agility
	[54497]	= 3600,	-- Lesser Armor
	[54501]	= 6,	-- Consume Shadows
	[54508]	= 15,	-- Demonic Empowerment
	[54643]	= 20,	-- Teleport
	[54646]	= 1800,	-- Focus Magic
	[54648]	= 10,	-- Focus Magic
	[54706]	= 5,	-- Venom Web Spray
	[54726]	= 0,	-- Winged Steed of the Ebon Blade
	[54727]	= 0,	-- Winged Steed of the Ebon Blade
	[54729]	= 0,	-- Winged Steed of the Ebon Blade
	[54753]	= 0,	-- White Polar Bear
	[54758]	= 12,	-- Hyperspeed Acceleration
	[54786]	= 2,	-- Demon Leap
	[54833]	= 10,	-- Innervate
	[54839]	= 10,	-- Purified Spirit
	[54842]	= 0,	-- Thunder Charge
	[54861]	= 5,	-- Nitro Boosts
	[54955]	= 5,	-- Ticking Bomb
	[54965]	= 8,	-- Bolthorn's Rune of Flame
	[55001]	= 30,	-- Parachute
	[55012]	= 0,	-- Lok'lira's Bargain
	[55018]	= 10,	-- Sonic Awareness
	[55021]	= 4,	-- Silenced - Improved Counterspell
	[55077]	= 5,	-- Pounce
	[55078]	= 21,	-- Blood Plague
	[55080]	= 3,	-- Shattered Barrier
	[55095]	= 21,	-- Frost Fever
	[55166]	= 20,	-- Tidal Force
	[55233]	= 10,	-- Vampiric Blood
	[55277]	= 15,	-- Stoneclaw Totem
	[55328]	= 15,	-- Stoneclaw Totem
	[55342]	= 30,	-- Mirror Image
	[55428]	= 20,	-- Lifeblood
	[55480]	= 20,	-- Lifeblood
	[55502]	= 20,	-- Lifeblood
	[55503]	= 20,	-- Lifeblood
	[55531]	= 0,	-- Mechano-hog
	[55610]	= 0,	-- Improved Icy Talons
	[55629]	= 3600,	-- First Lieutenant
	[55637]	= 15,	-- Lightweave
	[55694]	= 10,	-- Enraged Regeneration
	[55711]	= 480,	-- Weakened Heart
	[55741]	= 20,	-- Desecration
	[55775]	= 15,	-- Swordguard Embroidery
	[55817]	= 3600,	-- Eck Residue
	[56112]	= 10,	-- Furious Attacks
	[56161]	= 6,	-- Glyph of Prayer of Healing
	[56161]	= 6,	-- Glyph of Prayer of Healing
	[56222]	= 3,	-- Dark Command
	[56352]	= 12,	-- Storm Punch
	[56453]	= 12,	-- Lock and Load
	[56520]	= 1800,	-- Blessing of Might
	[56521]	= 1800,	-- Blessing of Wisdom
	[56525]	= 1800,	-- Blessing of Kings
	[56654]	= 6,	-- Rapid Recuperation
	[56778]	= 60,	-- Mana Shield
	[56827]	= 60,	-- Aura of Arcane Haste
	[56969]	= 8,	-- Arcane Blast
	[57054]	= 10,	-- Tranquility
	[57054]	= 10,	-- Tranquility
	[57056]	= 90,	-- Aura of Regeneration
	[57063]	= 10,	-- Arcane Attraction
	[57073]	= 30,	-- Drink
	[57079]	= 3600,	-- Well Fed
	[57086]	= 0,	-- Frenzy
	[57097]	= 3600,	-- Well Fed
	[57100]	= 3600,	-- Well Fed
	[57102]	= 3600,	-- Well Fed
	[57107]	= 3600,	-- Well Fed
	[57111]	= 3600,	-- Well Fed
	[57139]	= 3600,	-- Well Fed
	[57286]	= 3600,	-- Well Fed
	[57288]	= 3600,	-- Well Fed
	[57291]	= 3600,	-- Well Fed
	[57294]	= 3600,	-- Well Fed
	[57325]	= 3600,	-- Well Fed
	[57327]	= 3600,	-- Well Fed
	[57329]	= 3600,	-- Well Fed
	[57330]	= 120,	-- Horn of Winter
	[57332]	= 3600,	-- Well Fed
	[57334]	= 3600,	-- Well Fed
	[57348]	= 0,	-- Carrying an RP-GG
	[57350]	= 6,	-- Illusionary Barrier
	[57356]	= 3600,	-- Well Fed
	[57358]	= 3600,	-- Well Fed
	[57360]	= 3600,	-- Well Fed
	[57363]	= 3600,	-- Well Fed
	[57363]	= 3600,	-- Well Fed
	[57365]	= 3600,	-- Well Fed
	[57367]	= 3600,	-- Well Fed
	[57371]	= 3600,	-- Well Fed
	[57399]	= 3600,	-- Well Fed
	[57514]	= 12,	-- Enrage
	[57516]	= 12,	-- Enrage
	[57519]	= 12,	-- Enrage
	[57524]	= 120,	-- Metanoia
	[57529]	= 0,	-- Arcane Potency
	[57531]	= 0,	-- Arcane Potency
	[57580]	= 5,	-- Lightning Infusion
	[57669]	= 15,	-- Replenishment
	[57723]	= 600,	-- Exhaustion
	[57724]	= 600,	-- Sated
	[57761]	= 15,	-- Brain Freeze
	[57819]	= 0,	-- Argent Champion
	[57820]	= 0,	-- Ebon Champion
	[57821]	= 0,	-- Champion of the Kirin Tor
	[57822]	= 0,	-- Wyrmrest Champion
	[57833]	= 4,	-- Frost Spit
	[57933]	= 6,	-- Tricks of the Trade
	[57934]	= 20,	-- Tricks of the Trade
	[57940]	= 0,	-- Essence of Wintergrasp
	[58045]	= 0,	-- Essence of Wintergrasp
	[58179]	= 12,	-- Infected Wounds
	[58180]	= 12,	-- Infected Wounds
	[58269]	= 0,	-- Iceskin Stoneform
	[58371]	= 180,	-- Recently Slain
	[58374]	= 10,	-- Glyph of Shield Block
	[58427]	= 0,	-- Overkill
	[58448]	= 1800,	-- Strength
	[58449]	= 1800,	-- Strength
	[58450]	= 1800,	-- Agility
	[58451]	= 1800,	-- Agility
	[58452]	= 1800,	-- Armor
	[58468]	= 3600,	-- Hugely Well Fed
	[58479]	= 3600,	-- Nearly Well Fed
	[58493]	= 3600,	-- Mohawked!
	[58496]	= 7200,	-- Sad
	[58499]	= 7200,	-- Happy
	[58500]	= 7200,	-- Angry
	[58501]	= 600,	-- Iron Boot Flask
	[58502]	= 7200,	-- Scared
	[58511]	= 45,	-- Rotten Apple Aroma
	[58514]	= 45,	-- Rotten Banana Aroma
	[58519]	= 45,	-- Spit
	[58549]	= 1800,	-- Tenacity
	[58555]	= 180,	-- Great Honor
	[58556]	= 180,	-- Greater Honor
	[58557]	= 180,	-- Greatest Honor
	[58567]	= 30,	-- Sunder Armor
	[58600]	= 10,	-- Restricted Flight Area
	[58617]	= 10,	-- Glyph of Heart Strike
	[58683]	= 0,	-- Savage Combat
	[58729]	= 0,	-- Spiritual Immunity
	[58861]	= 2,	-- Bash
	[58875]	= 15,	-- Spirit Walk
	[58882]	= 6,	-- Rapid Recuperation
	[58891]	= 45,	-- Wild Magic
	[58984]	= 0,	-- Shadowmeld
	[58999]	= 0,	-- Big Blizzard Bear
	[59052]	= 15,	-- Freezing Fog
	[59125]	= 120,	-- Lucky
	[59230]	= 3600,	-- Well Fed
	[59542]	= 15,	-- Gift of the Naaru
	[59547]	= 15,	-- Gift of the Naaru
	[59548]	= 15,	-- Gift of the Naaru
	[59568]	= 0,	-- Blue Drake
	[59569]	= 0,	-- Bronze Drake
	[59570]	= 0,	-- Red Drake
	[59578]	= 15,	-- The Art of War
	[59620]	= 15,	-- Berserk
	[59626]	= 10,	-- Black Magic
	[59628]	= 6,	-- Tricks of the Trade
	[59638]	= 4,	-- Frostbolt
	[59650]	= 0,	-- Black Drake
	[59658]	= 15,	-- Argent Heroism
	[59675]	= 1800,	-- Nexus Residue
	[59676]	= 1800,	-- Residue of Darkness
	[59725]	= 5,	-- Spell Reflection
	[59752]	= 0.1,	-- Every Man for Himself
	[59785]	= 0,	-- Black War Mammoth
	[59788]	= 0,	-- Black War Mammoth
	[59793]	= 0,	-- Wooly Mammoth
	[59797]	= 0,	-- Ice Mammoth
	[59843]	= 600,	-- Underbelly Elixir
	[59888]	= 6,	-- Borrowed Time
	[59889]	= 6,	-- Borrowed Time
	[59911]	= 1800,	-- Tenacity
	[59961]	= 0,	-- Red Proto-Drake
	[59996]	= 0,	-- Blue Proto-Drake
	[60002]	= 0,	-- Time-Lost Proto-Drake
	[60024]	= 0,	-- Violet Proto-Drake
	[60025]	= 0,	-- Albino Drake
	[60062]	= 10,	-- Essence of Life
	[60064]	= 10,	-- Now is the time!
	[60065]	= 10,	-- Reflection of Torment
	[60097]	= 10,	-- Feeding Frenzy
	[60106]	= 300,	-- Old Spices
	[60114]	= 0,	-- Armored Brown Bear
	[60116]	= 0,	-- Armored Brown Bear
	[60118]	= 0,	-- Black War Bear
	[60119]	= 0,	-- Black War Bear
	[60122]	= 30,	-- Baby Spice
	[60196]	= 12,	-- Berserker!
	[60214]	= 20,	-- Seal of the Pantheon
	[60215]	= 40,	-- Lavanthor's Talisman
	[60218]	= 10,	-- Essence of Gossamer
	[60229]	= 15,	-- Greatness
	[60233]	= 15,	-- Greatness
	[60234]	= 15,	-- Greatness
	[60299]	= 20,	-- Incisor Fragment
	[60302]	= 10,	-- Meteorite Whetstone
	[60305]	= 20,	-- Heart of a Dragon
	[60314]	= 10,	-- Fury of the Five Flights
	[60318]	= 13,	-- Edward's Insight
	[60340]	= 3600,	-- Accuracy
	[60341]	= 3600,	-- Deadly Strikes
	[60343]	= 3600,	-- Mighty Defense
	[60344]	= 3600,	-- Expertise
	[60345]	= 3600,	-- Armor Piercing
	[60346]	= 3600,	-- Lightning Speed
	[60347]	= 3600,	-- Mighty Thoughts
	[60424]	= 0,	-- Mekgineer's Chopper
	[60433]	= 12,	-- Earth and Moon
	[60437]	= 10,	-- Grim Toll
	[60479]	= 10,	-- Forge Ember
	[60486]	= 10,	-- Illustration of the Dragon Soul
	[60494]	= 10,	-- Dying Curse
	[60503]	= 9,	-- Taste for Blood
	[60512]	= 15,	-- Healing Trance
	[60517]	= 20,	-- Talisman of Troll Divinity
	[60518]	= 10,	-- Touched by a Troll
	[60520]	= 15,	-- Spark of Life
	[60525]	= 10,	-- Majestic Dragon Figurine
	[60530]	= 12,	-- Forethought Talisman
	[60549]	= 10,	-- Deadly Aggression
	[60551]	= 10,	-- Furious Gladiator's Libram of Fortitude
	[60553]	= 10,	-- Relentless Aggression
	[60568]	= 10,	-- Furious Gladiator's Idol of Steadfastness
	[60569]	= 10,	-- Relentless Survival
	[60819]	= 10,	-- Libram of Reciprocation
	[60946]	= 5,	-- Nightmare
	[60947]	= 5,	-- Nightmare
	[60956]	= 0,	-- Improved Health Funnel
	[60970]	= 0.1,	-- Heroic Fury
	[61044]	= 15,	-- Demoralizing Shout
	[61258]	= 5,	-- Runic Return
	[61294]	= 0,	-- Green Proto-Drake
	[61295]	= 15,	-- Riptide
	[61305]	= 50,	-- Polymorph (cat)
	[61309]	= 0,	-- Magnificent Flying Carpet
	[61316]	= 3600,	-- Dalaran Brilliance
	[61336]	= 12,	-- Survival Instincts
	[61391]	= 6,	-- Typhoon
	[61394]	= 4,	-- Frozen Wake
	[61425]	= 0,	-- Traveler's Tundra Mammoth
	[61427]	= 20,	-- Infinite Speed
	[61447]	= 0,	-- Traveler's Tundra Mammoth
	[61451]	= 0,	-- Flying Carpet
	[61465]	= 0,	-- Grand Black War Mammoth
	[61467]	= 0,	-- Grand Black War Mammoth
	[61469]	= 0,	-- Grand Ice Mammoth
	[61470]	= 0,	-- Grand Ice Mammoth
	[61485]	= 60,	-- Dreadful Roar
	[61573]	= 0,	-- Banner of the Alliance
	[61619]	= 10,	-- Tentacles
	[61671]	= 10,	-- Crusader's Glory
	[61684]	= 16,	-- Dash
	[61685]	= 4,	-- Charge
	[61721]	= 50,	-- Polymorph
	[61858]	= 9,	-- Plague Slime
	[61882]	= 8,	-- Earthquake
	[62061]	= 3600,	-- Festive Holiday Mount
	[62064]	= 1800,	-- Tower Control
	[62124]	= 3,	-- Hand of Reckoning
	[62146]	= 30,	-- Unflinching Valor
	[62305]	= 4,	-- Master's Call
	[62380]	= 3600,	-- Lesser Flask of Resistance
	[62408]	= 300,	-- Ethereal Oil
	[62552]	= 60,	-- Defend
	[62574]	= 0,	-- Warts-B-Gone Lip Balm
	[62606]	= 10,	-- Savage Defense
	[63058]	= 20,	-- Glyph of Amberskin Protection
	[63087]	= 5,	-- Raptor Strike
	[63167]	= 10,	-- Decimation
	[63232]	= 0,	-- Stormwind Steed
	[63250]	= 10,	-- Jouster's Fury
	[63283]	= 300,	-- Totem of Wrath
	[63311]	= 8,	-- Shadowsnare
	[63433]	= 0,	-- Orgrimmar Champion's Pennant
	[63438]	= 0,	-- Silvermoon Champion's Pennant
	[63468]	= 8,	-- Piercing Shots
	[63500]	= 0,	-- Argent Crusade Valiant's Pennant
	[63529]	= 10,	-- Dazed - Avenger's Shield
	[63560]	= 30,	-- Dark Transformation
	[63619]	= 5,	-- Shadowcrawl
	[63635]	= 0,	-- Darkspear Raptor
	[63637]	= 0,	-- Darnassian Nightsaber
	[63640]	= 0,	-- Orgrimmar Wolf
	[63641]	= 0,	-- Thunder Bluff Kodo
	[63643]	= 0,	-- Forsaken Warhorse
	[63665]	= 2.5,	-- Charge
	[63672]	= 15,	-- ObsoleteBlack Arrow
	[63685]	= 5,	-- Freeze
	[63729]	= 3600,	-- Elixir of Minor Accuracy
	[63735]	= 20,	-- Serendipity
	[63844]	= 0,	-- Argent Hippogryph
	[63896]	= 12,	-- Bullheaded
	[63956]	= 0,	-- Ironbound Proto-Drake
	[63956]	= 0,	-- Ironbound Proto-Drake
	[63963]	= 0,	-- Rusted Proto-Drake
	[64044]	= 3,	-- Psychic Horror
	[64057]	= 3600,	-- Well Fed
	[64058]	= 10,	-- Psychic Horror
	[64128]	= 4,	-- Body and Soul
	[64205]	= 10,	-- Divine Sacrifice
	[64343]	= 10,	-- Impact
	[64368]	= 10,	-- Eradication
	[64370]	= 10,	-- Eradication
	[64371]	= 10,	-- Eradication
	[64373]	= 0,	-- Armistice
	[64382]	= 10,	-- Shattering Throw
	[64419]	= 15,	-- Sniper Training
	[64420]	= 15,	-- Sniper Training
	[64440]	= 10,	-- Blade Warding
	[64524]	= 20,	-- Platinum Disks of Battle
	[64568]	= 20,	-- Blood Reserve
	[64657]	= 0,	-- White Kodo
	[64658]	= 0,	-- Black Wolf
	[64659]	= 0,	-- Venomhide Ravasaur
	[64695]	= 5,	-- Earthgrab
	[64701]	= 15,	-- Elemental Mastery
	[64731]	= 0,	-- Sea Turtle
	[64803]	= 4,	-- Entrapment
	[64810]	= 300,	-- Bested Ironforge
	[64843]	= 8,	-- Divine Hymn
	[64844]	= 8,	-- Divine Hymn
	[64855]	= 10,	-- Blade Barrier
	[64856]	= 10,	-- Blade Barrier
	[64861]	= 15,	-- Precision Shots
	[64901]	= 8,	-- Hymn of Hope
	[64904]	= 8,	-- Hymn of Hope
	[64937]	= 5,	-- Heightened Reflexes
	[64951]	= 12,	-- Primal Wrath
	[64977]	= 0,	-- Black Skeletal Horse
	[65006]	= 10,	-- Eye of the Broodmother
	[65014]	= 10,	-- Pyrite Infusion
	[65019]	= 10,	-- Mjolnir Runestone
	[65081]	= 4,	-- Body and Soul
	[65142]	= 21,	-- Ebon Plague
	[65156]	= 10,	-- Juggernaut
	[65247]	= 3600,	-- Well Fed
	[65264]	= 6,	-- Lava Flows
	[65637]	= 0,	-- Great Red Elekk
	[65638]	= 0,	-- Swift Moonsaber
	[65639]	= 0,	-- Swift Red Hawkstrider
	[65640]	= 0,	-- Swift Gray Steed
	[65641]	= 0,	-- Great Golden Kodo
	[65642]	= 0,	-- Turbostrider
	[65644]	= 0,	-- Swift Purple Raptor
	[65645]	= 0,	-- White Skeletal Warhorse
	[65646]	= 0,	-- Swift Burgundy Wolf
	[65745]	= 300,	-- Path of Cenarius
	[65780]	= 300,	-- Pink Gumball
	[66088]	= 0,	-- Sunreaver Dragonhawk
	[66090]	= 0,	-- Quel'dorei Steed
	[66091]	= 0,	-- Sunreaver Hawkstrider
	[66122]	= 0,	-- Magic Rooster
	[66157]	= 0,	-- Honorable Defender
	[66251]	= 8,	-- Launch
	[66550]	= 20,	-- Teleport
	[66684]	= 20,	-- Flaming Cinder
	[66721]	= 0,	-- Burning Fury
	[66725]	= 15,	-- Meteor Fists
	[66776]	= 0,	-- Rage
	[66803]	= 20,	-- Desolation
	[66808]	= 15,	-- Meteor Fists
	[66846]	= 0,	-- Ochre Skeletal Warhorse
	[66906]	= 0,	-- Argent Charger
	[67016]	= 3600,	-- Flask of the North
	[67017]	= 3600,	-- Flask of the North
	[67018]	= 3600,	-- Flask of the North
	[67117]	= 15,	-- Unholy Might
	[67332]	= 20,	-- Flaming Cinder
	[67354]	= 9,	-- Evasion
	[67355]	= 16,	-- Agile
	[67358]	= 9,	-- Rejuvenating
	[67360]	= 12,	-- Blessing of the Moon Goddess
	[67364]	= 15,	-- Holy Judgement
	[67371]	= 16,	-- Holy Strength
	[67378]	= 18,	-- Evasion
	[67380]	= 20,	-- Evasion
	[67383]	= 20,	-- Unholy Force
	[67388]	= 15,	-- Spiritual Trance
	[67391]	= 18,	-- Volcanic Fury
	[67466]	= 0,	-- Argent Warhorse
	[67596]	= 15,	-- Tremendous Fortitude
	[67631]	= 10,	-- Aegis
	[67669]	= 10,	-- Elusive Power
	[67671]	= 10,	-- Fury
	[67683]	= 20,	-- Celerity
	[67684]	= 20,	-- Hospitality
	[67694]	= 20,	-- Defensive Tactics
	[67695]	= 20,	-- Rage
	[67696]	= 10,	-- Energized
	[67703]	= 15,	-- Paragon
	[67708]	= 15,	-- Paragon
	[67713]	= 0,	-- Mote of Flame
	[67735]	= 0,	-- Volatility
	[67736]	= 20,	-- Volatile Power
	[67737]	= 0,	-- Risen Fury
	[67738]	= 20,	-- Rising Fury
	[67811]	= 12,	-- Dagger Throw
	[67890]	= 3,	-- Cobalt Frag Bomb
	[68054]	= 600,	-- Pressing Engagement
	[68055]	= 20,	-- Judgements of the Just
	[68056]	= 0,	-- Swift Horde Wolf
	[68057]	= 0,	-- Swift Alliance Steed
	[68160]	= 15,	-- Meteor Fists
	[68161]	= 15,	-- Meteor Fists
	[68188]	= 0,	-- Crusader's Black Warhorse
	[68269]	= 0,	-- The Brewmaiden's Blessing
	[68298]	= 5,	-- Parachute
	[68377]	= 0,	-- Carrying Huge Seaforium
	[68652]	= 0,	-- Honorable Defender
	[68719]	= 0,	-- Oil Refinery
	[68720]	= 0,	-- Quarry
	[68722]	= 2,	-- Oil Refinery
	[68766]	= 20,	-- Desecration
	[69180]	= 30,	-- Gutgore Ripper
	[69369]	= 8,	-- Predator's Swiftness
	[70013]	= 0,	-- Quel'Delar's Compulsion
	[70029]	= 0.1,	-- The Beast Within
	[70244]	= 3600,	-- "Wizardry" Cologne
	[70639]	= 8,	-- Call of Sylvanas
	[70657]	= 15,	-- Advantage
	[70691]	= 15,	-- Rejuvenation
	[70721]	= 6,	-- Omen of Doom
	[70725]	= 10,	-- Enraged Defense
	[70728]	= 10,	-- Exploit Weakness
	[70747]	= 30,	-- Quad Core
	[70753]	= 5,	-- Pushing the Limit
	[70757]	= 10,	-- Holiness
	[70760]	= 10,	-- Deliverance
	[70772]	= 9,	-- Blessed Healing
	[70806]	= 10,	-- Rapid Currents
	[70840]	= 10,	-- Devious Minds
	[70845]	= 10,	-- Stoicism
	[70855]	= 10,	-- Blood Drinker
	[70893]	= 10,	-- Culling the Herd
	[70940]	= 6,	-- Divine Guardian
	[71007]	= 10,	-- Stinger
	[71041]	= 1800,	-- Dungeon Deserter
	[71165]	= 15,	-- Molten Core
	[71175]	= 15,	-- Agile
	[71177]	= 15,	-- Vicious
	[71184]	= 15,	-- Soothing
	[71187]	= 15,	-- Formidable
	[71192]	= 15,	-- Blessed
	[71197]	= 15,	-- Evasive
	[71199]	= 30,	-- Furious
	[71216]	= 15,	-- Enraged
	[71220]	= 15,	-- Energized
	[71227]	= 15,	-- Indomitable
	[71345]	= 0,	-- Big Love Rocket
	[71396]	= 10,	-- Rage of the Fallen
	[71401]	= 15,	-- Icy Rage
	[71403]	= 10,	-- Fatal Flaws
	[71432]	= 0,	-- Mote of Anger
	[71484]	= 30,	-- Strength of the Taunka
	[71485]	= 30,	-- Agility of the Vrykul
	[71486]	= 30,	-- Power of the Taunka
	[71491]	= 30,	-- Aim of the Iron Dwarves
	[71492]	= 30,	-- Speed of the Vrykul
	[71560]	= 30,	-- Speed of the Vrykul
	[71564]	= 20,	-- Deadly Precision
	[71568]	= 20,	-- Urgency
	[71570]	= 10,	-- Cultivated Power
	[71572]	= 10,	-- Cultivated Power
	[71579]	= 20,	-- Elusive Power
	[71584]	= 15,	-- Revitalized
	[71586]	= 10,	-- Hardened Skin
	[71600]	= 20,	-- Surging Power
	[71601]	= 20,	-- Surge of Power
	[71633]	= 10,	-- Thick Skin
	[71824]	= 6,	-- Lava Burst
	[71864]	= 6,	-- Fountain of Light
	[71866]	= 6,	-- Fountain of Light
	[71870]	= 10,	-- Blessing of Light
	[71875]	= 10,	-- Necrotic Touch
	[71877]	= 10,	-- Necrotic Touch
	[71882]	= 10,	-- Invigoration
	[71993]	= 0,	-- Frozen Mallet
	[72004]	= 20,	-- Frostbite
	[72034]	= 60,	-- Whiteout
	[72081]	= 0,	-- Frozen Orb
	[72096]	= 60,	-- Whiteout
	[72096]	= 60,	-- Whiteout
	[72098]	= 20,	-- Frostbite
	[72098]	= 20,	-- Frostbite
	[72104]	= 5,	-- Freezing Ground
	[72104]	= 5,	-- Freezing Ground
	[72121]	= 10,	-- Frostbite
	[72121]	= 10,	-- Frostbite
	[72122]	= 0,	-- Frozen Mallet
	[72221]	= 0,	-- Luck of the Draw
	[72282]	= 0,	-- Invincible
	[72412]	= 10,	-- Frostforged Champion
	[72414]	= 10,	-- Frostforged Defender
	[72416]	= 10,	-- Frostforged Sage
	[72418]	= 10,	-- Chilling Knowledge
	[72586]	= 1800,	-- Blessing of Forgotten Kings
	[72590]	= 3600,	-- Fortitude
	[72808]	= 0,	-- Bloodbathed Frostbrood Vanquisher
	[72968]	= 0,	-- Precious's Ribbon
	[73313]	= 0,	-- Crimson Deathcharger
	[73320]	= 600,	-- Frostborn Illusion
	[73320]	= 600,	-- Frostborn Illusion
	[73413]	= 1800,	-- Inner Will
	[73651]	= 0,	-- Recuperate
	[73681]	= 12,	-- Unleash Wind
	[73682]	= 5,	-- Unleash Frost
	[73683]	= 8,	-- Unleash Flame
	[73685]	= 8,	-- Unleash Life
	[73975]	= 15,	-- Necrotic Strike
	[74001]	= 30,	-- Combat Readiness
	[74002]	= 6,	-- Combat Insight
	[74347]	= 3,	-- Silenced - Gag Order
	[74434]	= 15,	-- Soulburn
	[74855]	= 0,	-- Blazing Hippogryph
	[74960]	= 10,	-- Infrigidate
	[75447]	= 0,	-- Ferocious Inspiration
	[75458]	= 15,	-- Piercing Twilight
	[75596]	= 0,	-- Frosty Flying Carpet
	[75617]	= 0,	-- Celestial Steed
	[75618]	= 0,	-- Celestial Steed
	[75619]	= 0,	-- Celestial Steed
	[75620]	= 0,	-- Celestial Steed
	[75731]	= 0,	-- Instant Statue
	[75957]	= 0,	-- X-53 Touring Rocket
	[75972]	= 0,	-- X-53 Touring Rocket
	[76691]	= 0,	-- Vengeance
	[76780]	= 50,	-- Bind Elemental
	[77487]	= 60,	-- Shadow Orb
	[77489]	= 6,	-- Echo of Light
	[77535]	= 10,	-- Blood Shield
	[77606]	= 8,	-- Dark Simulacrum
	[77613]	= 15,	-- Grace
	[77616]	= 20,	-- Dark Simulacrum
	[77661]	= 15,	-- Searing Flames
	[77747]	= 0,	-- Totemic Wrath
	[77758]	= 6,	-- Thrash
	[77764]	= 6,	-- Stampeding Roar
	[77769]	= 15,	-- Trap Launcher
	[77800]	= 8,	-- Focused Insight
	[79057]	= 3600,	-- Arcane Brilliance
	[79058]	= 3600,	-- Arcane Brilliance
	[79060]	= 3600,	-- Mark of the Wild
	[79061]	= 3600,	-- Mark of the Wild
	[79062]	= 3600,	-- Blessing of Kings
	[79063]	= 3600,	-- Blessing of Kings
	[79101]	= 3600,	-- Blessing of Might
	[79102]	= 3600,	-- Blessing of Might
	[79104]	= 3600,	-- Power Word: Fortitude
	[79105]	= 3600,	-- Power Word: Fortitude
	[79106]	= 3600,	-- Shadow Protection
	[79107]	= 3600,	-- Shadow Protection
	[79140]	= 30,	-- Vendetta
	[79206]	= 10,	-- Spiritwalker's Grace
	[79268]	= 9,	-- Soul Harvest
	[79437]	= 8,	-- Soulburn: Healthstone
	[79438]	= 8,	-- Soulburn: Demonic Circle
	[79440]	= 6,	-- Soulburn: Searing Pain
	[79459]	= 30,	-- Demon Soul: Imp
	[79460]	= 20,	-- Demon Soul: Felhunter
	[79462]	= 20,	-- Demon Soul: Felguard
	[79464]	= 15,	-- Demon Soul: Voidwalker
	[79683]	= 20,	-- Arcane Missiles!
	[80325]	= 0,	-- Camouflage
	[80353]	= 40,	-- Time Warp
	[80354]	= 600,	-- Temporal Displacement
	[80886]	= 0,	-- Primal Madness
	[80951]	= 10,	-- Pulverize
	[81017]	= 8,	-- Stampede
	[81021]	= 10,	-- Stampede
	[81022]	= 10,	-- Stampede
	[81130]	= 30,	-- Scarlet Fever
	[81141]	= 10,	-- Blood Swarm
	[81162]	= 8,	-- Will of the Necropolis
	[81192]	= 3,	-- Lunar Shower
	[81206]	= 30,	-- Chakra: Prayer of Healing
	[81208]	= 30,	-- Chakra: Heal
	[81256]	= 12,	-- Dancing Rune Weapon
	[81261]	= 10,	-- Solar Beam
	[81262]	= 7,	-- Efflorescence
	[81277]	= 0,	-- Blood Gorged
	[81281]	= 2,	-- Fungal Growth
	[81301]	= 12,	-- Glyph of Spirit Tap
	[81325]	= 0,	-- Brittle Bones
	[81326]	= 0,	-- Brittle Bones
	[81340]	= 10,	-- Sudden Doom
	[81661]	= 15,	-- Evangelism
	[81700]	= 18,	-- Archangel
	[81781]	= 25,	-- Power Word: Barrier
	[82327]	= 10,	-- Holy Radiance
	[82365]	= 10,	-- Skull Bash
	[82368]	= 20,	-- Victorious
	[82654]	= 30,	-- Widow Venom
	[82661]	= 0,	-- Aspect of the Fox
	[82691]	= 10,	-- Ring of Frost
	[82692]	= 15,	-- Focus Fire
	[82897]	= 8,	-- Resistance is Futile!
	[82925]	= 30,	-- Ready, Set, Aim...
	[82930]	= 0,	-- Arcane Tactics
	[83046]	= 1.5,	-- Improved Polymorph
	[83073]	= 6,	-- Shattered Barrier
	[83098]	= 15,	-- Improved Mana Gem
	[83154]	= 9,	-- Piercing Chill
	[83302]	= 4,	-- Improved Cone of Cold
	[84585]	= 15,	-- Slaughter
	[84586]	= 15,	-- Slaughter
	[84617]	= 15,	-- Revealing Strike
	[84620]	= 10,	-- Hold the Line
	[84721]	= 2,	-- Frostfire Orb
	[84745]	= 15,	-- Shallow Insight
	[84746]	= 15,	-- Moderate Insight
	[84747]	= 15,	-- Deep Insight
	[84958]	= 20,	-- Tranquilized
	[84963]	= 4,	-- Inquisition
	[85383]	= 15,	-- Improved Soul Fire
	[85387]	= 2,	-- Aftermath
	[85388]	= 5,	-- Throwdown
	[85416]	= 2,	-- Grand Crusader
	[85421]	= 7,	-- Burning Embers
	[85433]	= 15,	-- Sacred Duty
	[85497]	= 4,	-- Speed of Light
	[85509]	= 20,	-- Denounce
	[85539]	= 0,	-- Jinx
	[85673]	= 6,	-- Word of Glory
	[85696]	= 20,	-- Zealotry
	[85730]	= 10,	-- Deadly Calm
	[85739]	= 10,	-- Meat Cleaver
	[85767]	= 1800,	-- Dark Intent
	[85768]	= 1800,	-- Dark Intent
	[86000]	= 15,	-- Curse of Gul'dan
	[86105]	= 3,	-- Jinx: Curse of the Elements
	[86211]	= 20,	-- Soul Swap
	[86273]	= 6,	-- Illuminated Healing
	[86346]	= 6,	-- Colossus Smash
	[86627]	= 10,	-- Incite
	[86659]	= 12,	-- Guardian of Ancient Kings Summon
	[86662]	= 15,	-- Rude Interruption
	[86663]	= 30,	-- Rude Interruption
	[86669]	= 30,	-- Guardian of Ancient Kings Summon
	[86759]	= 3,	-- Silenced - Improved Kick
	[87096]	= 20,	-- Thunderstruck
	[87098]	= 8,	-- Invocation
	[87118]	= 15,	-- Dark Evangelism
	[87153]	= 18,	-- Dark Archangel
	[87160]	= 6,	-- Mind Melt
	[87173]	= 4,	-- Long Arm of the Law
	[87178]	= 12,	-- Mind Spike
	[87194]	= 4,	-- Paralysis
	[87204]	= 3,	-- Sin and Punishment
	[87342]	= 20,	-- Holy Shield
	[87717]	= 0,	-- Tranquil Mind
	[88063]	= 6,	-- Guarded by the Light
	[88448]	= 10,	-- Demonic Rebirth
	[88466]	= 9,	-- Serpent Sting
	[88611]	= 1,	-- Smoke Bomb
	[88684]	= 6,	-- Holy Word: Serenity
	[88819]	= 12,	-- Daybreak
	[89388]	= 12,	-- Sic 'Em!
	[89420]	= 1.5,	-- Drain Life
	[89485]	= 0,	-- Inner Focus
	[89751]	= 6,	-- Felstorm
	[89766]	= 4,	-- Axe Toss
	[89775]	= 24,	-- Hemorrhage
	[89792]	= 0.2,	-- Flee
	[89906]	= 10,	-- Judgements of the Bold
	[90174]	= 8,	-- Hand of Light
	[90315]	= 30,	-- Tailspin
	[90361]	= 10,	-- Spirit Mend
	[90364]	= 0,	-- Qiraji Fortitude
	[90785]	= 0.4,	-- Glyph of Power Word: Barrier
	[90806]	= 9,	-- Executioner
	[91021]	= 10,	-- Find Weakness
	[91342]	= 30,	-- Shadow Infusion
	[91565]	= 300,	-- Faerie Fire
	[91711]	= 30,	-- Nether Ward
	[91724]	= 0,	-- Spell Warding
	[91797]	= 4,	-- Monstrous Blow
	[91800]	= 3,	-- Gnaw
	[91807]	= 2,	-- Shambling Rush
	[93068]	= 15,	-- Master Poisoner
	[93400]	= 8,	-- Shooting Stars
	[93402]	= 12,	-- Sunfire
	[93435]	= 60,	-- Roar of Courage
	[93622]	= 5,	-- Berserk
	[93986]	= 3,	-- Aura of Foreboding
	[93987]	= 3,	-- Aura of Foreboding
	[94009]	= 15,	-- Rend
	[94528]	= 20,	-- Flare
}

lib.spellDebuffType = {
	[17] = 1,		-- Power Word: Shield
	[66] = 6,		-- Invisibility
	[113] = 1,		-- Chains of Ice
	[116] = 1,		-- Frostbolt
	[118] = 1,		-- Polymorph
	[120] = 1,		-- Cone of Cold
	[122] = 1,		-- Frost Nova
	[130] = 1,		-- Slow Fall
	[136] = 1,		-- Mend Pet
	[139] = 1,		-- Renew
	[172] = 1,		-- Corruption
	[324] = 1,		-- Lightning Shield
	[339] = 1,		-- Entangling Roots
	[348] = 1,		-- Immolate
	[467] = 1,		-- Thorns
	[498] = 1,		-- Divine Protection
	[543] = 1,		-- Mage Ward
	[589] = 1,		-- Shadow Word: Pain
	[603] = 4,		-- Bane of Doom
	[605] = 1,		-- Mind Control
	[642] = 1,		-- Divine Shield
	[689] = 1,		-- Drain Life
	[700] = 1,		-- Sleep
	[702] = 4,		-- Curse of Weakness
	[710] = 1,		-- Banish
	[744] = 3,		-- Poison
	[774] = 1,		-- Rejuvenation
	[853] = 1,		-- Hammer of Justice
	[853] = 1,		-- Hammer of Justice
	[974] = 1,		-- Earth Shield
	[980] = 4,		-- Bane of Agony
	[1022] = 1,		-- Hand of Protection
	[1038] = 1,		-- Hand of Salvation
	[1044] = 1,		-- Hand of Freedom
	[1130] = 1,		-- Hunter's Mark
	[1463] = 1,		-- Mana Shield
	[1490] = 4,		-- Curse of the Elements
	[1513] = 1,		-- Scare Beast
	[1706] = 1,		-- Levitate
	[1714] = 4,		-- Curse of Tongues
	[1978] = 3,		-- Serpent Sting
	[2601] = 1,		-- Fire Shield III
	[2602] = 1,		-- Fire Shield IV
	[2645] = 1,		-- Ghost Wolf
	[2812] = 1,		-- Holy Wrath
	[2818] = 3,		-- Deadly Poison
	[2825] = 1,		-- Bloodlust
	[2944] = 2,		-- Devouring Plague
	[3256] = 2,		-- Plague Cloud
	[3355] = 1,		-- Freezing Trap
	[3356] = 1,		-- Flame Lash
	[3409] = 3,		-- Crippling Poison
	[3409] = 3,		-- Crippling Poison
	[3427] = 2,		-- Infected Wound
	[3436] = 2,		-- Wandering Plague
	[3436] = 2,		-- Wandering Plague
	[3439] = 2,		-- Wandering Plague
	[3583] = 3,		-- Deadly Poison
	[3600] = 1,		-- Earthbind
	[3600] = 1,		-- Earthbind
	[3674] = 1,		-- Black Arrow
	[3815] = 3,		-- Poison Cloud
	[4167] = 1,		-- Web
	[4167] = 1,		-- Web
	[4318] = 1,		-- Guile of the Raptor
	[5115] = 1,		-- Battle Command
	[5137] = 4,		-- Call of the Grave
	[5138] = 1,		-- Drain Mana
	[5262] = 1,		-- Fanatic Blade
	[5403] = 1,		-- Crash of Waves
	[5413] = 2,		-- Noxious Catalyst
	[5484] = 1,		-- Howl of Terror
	[5570] = 1,		-- Insect Swarm
	[5760] = 3,		-- Mind-numbing Poison
	[5782] = 1,		-- Fear
	[5916] = 7,		-- Shadowstalker Stealth
	[6136] = 1,		-- Chilled
	[6146] = 1,		-- Slow
	[6229] = 1,		-- Shadow Ward
	[6278] = 2,		-- Creeping Mold
	[6306] = 3,		-- Acid Splash
	[6346] = 1,		-- Fear Ward
	[6358] = 1,		-- Seduction
	[6726] = 1,		-- Silence
	[6728] = 1,		-- Enveloping Winds
	[6742] = 1,		-- Bloodlust
	[6789] = 1,		-- Death Coil
	[6940] = 1,		-- Hand of Sacrifice
	[6950] = 1,		-- Faerie Fire
	[7038] = 4,		-- Forsaken Skill: Swords
	[7039] = 4,		-- Forsaken Skill: Axes
	[7040] = 4,		-- Forsaken Skill: Daggers
	[7041] = 4,		-- Forsaken Skill: Maces
	[7042] = 4,		-- Forsaken Skill: Staves
	[7044] = 4,		-- Forsaken Skill: Guns
	[7045] = 4,		-- Forsaken Skill: 2H Axes
	[7046] = 4,		-- Forsaken Skill: 2H Maces
	[7047] = 4,		-- Forsaken Skill: 2H Swords
	[7049] = 4,		-- Forsaken Skill: Fire
	[7051] = 4,		-- Forsaken Skill: Holy
	[7053] = 4,		-- Forsaken Skill: Shadow
	[7054] = 4,		-- Forsaken Skills
	[7057] = 4,		-- Haunting Spirits
	[7068] = 4,		-- Veil of Shadow
	[7074] = 1,		-- Screams of the Past
	[7124] = 4,		-- Arugal's Gift
	[7125] = 3,		-- Toxic Saliva
	[7127] = 1,		-- Wavering Will
	[7140] = 1,		-- Expose Weakness
	[7295] = 1,		-- Soul Drain
	[7321] = 1,		-- Chilled
	[7399] = 1,		-- Terrify
	[7621] = 4,		-- Arugal's Curse
	[7739] = 1,		-- Inferno Shell
	[7812] = 1,		-- Sacrifice
	[7947] = 3,		-- Localized Toxin
	[7948] = 1,		-- Wild Regeneration
	[7964] = 1,		-- Smoke Bomb
	[7992] = 3,		-- Slowing Poison
	[8040] = 1,		-- Druid's Slumber
	[8050] = 1,		-- Flame Shock
	[8056] = 1,		-- Frost Shock
	[8066] = 4,		-- Shrink
	[8068] = 1,		-- Healthy Spirit
	[8078] = 1,		-- Thunderclap
	[8096] = 1,		-- Intellect
	[8101] = 1,		-- Stamina
	[8112] = 1,		-- Spirit
	[8117] = 1,		-- Agility
	[8119] = 1,		-- Strength
	[8122] = 1,		-- Psychic Scream
	[8140] = 1,		-- Befuddlement
	[8202] = 1,		-- Sapta Sight
	[8267] = 4,		-- Cursed Blood
	[8272] = 1,		-- Mind Tremor
	[8275] = 3,		-- Poisoned Shot
	[8281] = 1,		-- Sonic Burst
	[8282] = 4,		-- Curse of Blood
	[8314] = 1,		-- Rock Skin
	[8362] = 1,		-- Renew
	[8365] = 1,		-- Enlarge
	[8382] = 3,		-- Leech Poison
	[8385] = 1,		-- Swift Wind
	[8398] = 1,		-- Frostbolt Volley
	[8399] = 1,		-- Sleep
	[8599] = 5,		-- Enrage
	[8600] = 2,		-- Fevered Plague
	[8788] = 1,		-- Lightning Shield
	[8898] = 1,		-- Sapta Sight
	[8921] = 1,		-- Moonfire
	[8936] = 1,		-- Regrowth
	[8988] = 1,		-- Silence
	[9034] = 1,		-- Immolate
	[9275] = 1,		-- Immolate
	[9459] = 1,		-- Corrosive Ooze
	[9482] = 1,		-- Amplify Flames
	[9484] = 1,		-- Shackle Undead
	[9672] = 1,		-- Frostbolt
	[9775] = 2,		-- Irradiated
	[9906] = 1,		-- Reflection
	[10060] = 1,	-- Power Infusion
	[10326] = 1,	-- Turn Evil
	[10452] = 1,	-- Flame Buffet
	[10730] = 1,	-- Pacify
	[10831] = 1,	-- Reflection Field
	[11020] = 1,	-- Petrify
	[11113] = 1,	-- Blast Wave
	[11264] = 1,	-- Ice Blast
	[11327] = 7,	-- Vanish
	[11397] = 2,	-- Diseased Shot
	[11426] = 1,	-- Ice Barrier
	[11436] = 1,	-- Slow
	[11442] = 2,	-- Withered Touch
	[11443] = 1,	-- Cripple
	[11445] = 1,	-- Bone Armor
	[11538] = 1,	-- Frostbolt
	[11639] = 1,	-- Shadow Word: Pain
	[11640] = 1,	-- Renew
	[11641] = 1,	-- Hex
	[11841] = 1,	-- Static Barrier
	[11922] = 1,	-- Entangling Roots
	[11962] = 1,	-- Immolate
	[11974] = 1,	-- Power Word: Shield
	[11980] = 4,	-- Curse of Weakness
	[12040] = 1,	-- Shadow Shield
	[12042] = 1,	-- Arcane Power
	[12043] = 1,	-- Presence of Mind
	[12096] = 1,	-- Fear
	[12098] = 1,	-- Sleep
	[12178] = 1,	-- Stamina
	[12245] = 2,	-- Infected Spine
	[12248] = 1,	-- Amplify Damage
	[12251] = 3,	-- Virulent Poison
	[12255] = 4,	-- Curse of Tuten'kash
	[12292] = 5,	-- Death Wish
	[12472] = 1,	-- Icy Veins
	[12493] = 4,	-- Curse of Weakness
	[12528] = 1,	-- Silence
	[12530] = 1,	-- Frailty
	[12531] = 1,	-- Chilling Touch
	[12536] = 1,	-- Clearcasting
	[12541] = 2,	-- Ghoul Rot
	[12544] = 1,	-- Frost Armor
	[12548] = 1,	-- Frost Shock
	[12579] = 1,	-- Winter's Chill
	[12611] = 1,	-- Cone of Cold
	[12654] = 1,	-- Ignite
	[12741] = 4,	-- Curse of Weakness
	[12890] = 1,	-- Deep Slumber
	[12946] = 2,	-- Putrid Stench
	[13218] = 3,	-- Wound Poison
	[13298] = 3,	-- Poison
	[13326] = 1,	-- Arcane Intellect
	[13439] = 1,	-- Frostbolt
	[13526] = 3,	-- Corrosive Poison
	[13704] = 1,	-- Psychic Scream
	[13797] = 1,	-- Immolation Trap
	[13864] = 1,	-- Power Word: Fortitude
	[14032] = 1,	-- Shadow Word: Pain
	[14201] = 5,	-- Enrage
	[14202] = 5,	-- Enrage
	[14515] = 1,	-- Dominate Mind
	[14517] = 1,	-- Crusader Strike
	[14518] = 1,	-- Crusader Strike
	[14751] = 1,	-- Chakra
	[14893] = 1,	-- Inspiration
	[14914] = 1,	-- Holy Fire
	[15039] = 1,	-- Flame Shock
	[15357] = 1,	-- Inspiration
	[15487] = 1,	-- Silence
	[15531] = 1,	-- Frost Nova
	[15532] = 1,	-- Frost Nova
	[15548] = 1,	-- Thunderclap
	[15588] = 1,	-- Thunderclap
	[16166] = 1,	-- Elemental Mastery
	[16177] = 1,	-- Ancestral Fortitude
	[16188] = 1,	-- Nature's Swiftness
	[16236] = 1,	-- Ancestral Fortitude
	[16246] = 1,	-- Clearcasting
	[16468] = 3,	-- Mother's Milk
	[16567] = 4,	-- Tainted Mind
	[16591] = 1,	-- Noggenfogger Elixir
	[16593] = 1,	-- Noggenfogger Elixir
	[16595] = 1,	-- Noggenfogger Elixir
	[16689] = 1,	-- Nature's Grasp
	[16711] = 1,	-- Grow
	[16870] = 1,	-- Clearcasting
	[16886] = 1,	-- Nature's Grace
	[17116] = 1,	-- Nature's Swiftness
	[17154] = 1,	-- The Green Tower
	[17800] = 1,	-- Shadow Mastery
	[17941] = 1,	-- Shadow Trance
	[18118] = 1,	-- Aftermath
	[18223] = 4,	-- Curse of Exhaustion
	[18266] = 4,	-- Curse of Agony
	[18267] = 4,	-- Curse of Weakness
	[18425] = 1,	-- Silenced - Improved Kick
	[18469] = 1,	-- Silenced - Improved Counterspell
	[18498] = 1,	-- Silenced - Gag Order
	[18972] = 1,	-- Slow
	[19386] = 3,	-- Wyvern Sting
	[19821] = 1,	-- Arcane Bomb
	[19975] = 1,	-- Entangling Roots
	[20006] = 1,	-- Unholy Curse
	[20050] = 1,	-- Conviction
	[20052] = 1,	-- Conviction
	[20053] = 1,	-- Conviction
	[20066] = 1,	-- Repentance
	[20170] = 1,	-- Seal of Justice
	[20798] = 1,	-- Demon Skin
	[20800] = 1,	-- Immolate
	[20925] = 1,	-- Holy Shield
	[21007] = 4,	-- Curse of Weakness
	[21049] = 1,	-- Bloodlust
	[21062] = 2,	-- Putrid Breath
	[21067] = 3,	-- Poison Bolt
	[21068] = 1,	-- Corruption
	[21069] = 3,	-- Larva Goo
	[21331] = 1,	-- Entangling Roots
	[21337] = 1,	-- Thorns
	[21687] = 3,	-- Toxic Volley
	[21787] = 3,	-- Deadly Poison
	[22812] = 1,	-- Barkskin
	[22959] = 1,	-- Critical Mass
	[24131] = 3,	-- Wyvern Sting
	[24259] = 1,	-- Spell Lock
	[24844] = 1,	-- Lightning Breath
	[25046] = 1,	-- Arcane Torrent
	[25058] = 1,	-- Renew
	[25207] = 1,	-- Amulet of the Moon
	[25606] = 1,	-- Pendant of the Agate Shield
	[25746] = 1,	-- Damage Absorb
	[25747] = 1,	-- Damage Absorb
	[25780] = 1,	-- Righteous Fury
	[25809] = 3,	-- Crippling Poison
	[25810] = 3,	-- Mind-numbing Poison
	[26017] = 1,	-- Vindication
	[27243] = 1,	-- Seed of Corruption
	[27813] = 1,	-- Blessed Recovery
	[27817] = 1,	-- Blessed Recovery
	[27818] = 1,	-- Blessed Recovery
	[28271] = 1,	-- Polymorph (turtle)
	[28272] = 1,	-- Polymorph (pig)
	[28730] = 1,	-- Arcane Torrent
	[29166] = 1,	-- Innervate
	[29674] = 1,	-- Lesser Shielding
	[30108] = 1,	-- Unstable Affliction
	[30283] = 1,	-- Shadowfury
	[30991] = 7,	-- Stealth
	[31117] = 1,	-- Unstable Affliction
	[31589] = 1,	-- Slow
	[31643] = 1,	-- Blazing Speed
	[31661] = 1,	-- Dragon's Breath
	[31842] = 1,	-- Divine Favor
	[31884] = 1,	-- Avenging Wrath
	[31935] = 1,	-- Avenger's Shield
	[32182] = 1,	-- Heroism
	[32386] = 1,	-- Shadow Embrace
	[32388] = 1,	-- Shadow Embrace
	[32389] = 1,	-- Shadow Embrace
	[32645] = 3,	-- Envenom
	[33082] = 1,	-- Strength
	[33151] = 1,	-- Surge of Light
	[33151] = 1,	-- Surge of Light
	[33206] = 1,	-- Pain Suppression
	[33395] = 1,	-- Freeze
	[33763] = 1,	-- Lifebloom
	[34490] = 1,	-- Silencing Shot
	[34655] = 3,	-- Deadly Poison
	[34914] = 1,	-- Vampiric Touch
	[34936] = 1,	-- Backlash
	[35944] = 1,	-- Power Word: Shield
	[38254] = 2,	-- Festering Wound
	[38384] = 1,	-- Cone of Cold
	[39796] = 1,	-- Stoneclaw Stun
	[41635] = 1,	-- Prayer of Mending
	[42702] = 2,	-- Decrepify
	[42705] = 5,	-- Enrage
	[42740] = 1,	-- Njord's Rune of Protection
	[43195] = 1,	-- Intellect
	[43196] = 1,	-- Armor
	[43197] = 1,	-- Spirit
	[43664] = 5,	-- Unholy Rage
	[44413] = 1,	-- Incanter's Absorption
	[44415] = 1,	-- Blackout
	[44457] = 1,	-- Living Bomb
	[44544] = 1,	-- Fingers of Frost
	[44572] = 1,	-- Deep Freeze
	[44614] = 1,	-- Frostfire Bolt
	[45241] = 1,	-- Focused Will
	[45242] = 1,	-- Focused Will
	[45282] = 1,	-- Natural Perfection
	[45283] = 1,	-- Natural Perfection
	[45438] = 1,	-- Ice Block
	[46604] = 1,	-- Ice Block
	[46987] = 1,	-- Frostbolt
	[46989] = 1,	-- Improved Blink
	[47283] = 1,	-- Empowered Imp
	[47476] = 1,	-- Strangulate
	[47699] = 1,	-- Crystal Bark
	[47753] = 1,	-- Divine Aegis
	[47779] = 1,	-- Arcane Torrent
	[47930] = 1,	-- Grace
	[47960] = 1,	-- Shadowflame
	[48058] = 1,	-- Crystal Bloom
	[48100] = 1,	-- Intellect
	[48101] = 1,	-- Stamina
	[48102] = 1,	-- Stamina
	[48103] = 1,	-- Spirit
	[48111] = 1,	-- Prayer of Mending
	[48181] = 1,	-- Haunt
	[48391] = 5,	-- Owlkin Frenzy
	[48438] = 1,	-- Wild Growth
	[49016] = 5,	-- Unholy Frenzy
	[49203] = 1,	-- Hungering Cold
	[50263] = 1,	-- Quickness of the Sailor
	[50613] = 1,	-- Arcane Torrent
	[51209] = 1,	-- Hungering Cold
	[51514] = 4,	-- Hex
	[51945] = 1,	-- Earthliving
	[52127] = 1,	-- Water Shield
	[52470] = 5,	-- Enrage
	[52493] = 3,	-- Poison Spray
	[52537] = 5,	-- Fixate
	[52610] = 5,	-- Savage Roar
	[53030] = 3,	-- Leech Poison
	[53330] = 2,	-- Infected Wound
	[53390] = 1,	-- Tidal Waves
	[53515] = 1,	-- Owl's Focus
	[53517] = 1,	-- Roar of Recovery
	[53563] = 1,	-- Beacon of Light
	[54277] = 1,	-- Backdraft
	[54309] = 1,	-- Mark of Darkness
	[54370] = 1,	-- Nether Protection (Holy)
	[54371] = 1,	-- Nether Protection (Fire)
	[54372] = 1,	-- Nether Protection (Frost)
	[54373] = 1,	-- Nether Protection (Arcane)
	[54374] = 1,	-- Nether Protection (Shadow)
	[54375] = 1,	-- Nether Protection (Nature)
	[54428] = 1,	-- Divine Plea
	[54508] = 5,	-- Demonic Empowerment
	[54646] = 1,	-- Focus Magic
	[54648] = 1,	-- Focus Magic
	[54706] = 1,	-- Venom Web Spray
	[54833] = 1,	-- Innervate
	[54965] = 1,	-- Bolthorn's Rune of Flame
	[55021] = 1,	-- Silenced - Improved Counterspell
	[55078] = 2,	-- Blood Plague
	[55080] = 1,	-- Shattered Barrier
	[55095] = 2,	-- Frost Fever
	[55166] = 1,	-- Tidal Force
	[56161] = 1,	-- Glyph of Prayer of Healing
	[56161] = 1,	-- Glyph of Prayer of Healing
	[56352] = 1,	-- Storm Punch
	[56520] = 1,	-- Blessing of Might
	[56521] = 1,	-- Blessing of Wisdom
	[56525] = 1,	-- Blessing of Kings
	[56778] = 1,	-- Mana Shield
	[56827] = 1,	-- Aura of Arcane Haste
	[57063] = 1,	-- Arcane Attraction
	[57350] = 1,	-- Illusionary Barrier
	[57514] = 5,	-- Enrage
	[57516] = 5,	-- Enrage
	[57519] = 5,	-- Enrage
	[57524] = 1,	-- Metanoia
	[57529] = 1,	-- Arcane Potency
	[57531] = 1,	-- Arcane Potency
	[57580] = 1,	-- Lightning Infusion
	[57761] = 1,	-- Brain Freeze
	[58179] = 2,	-- Infected Wounds
	[58180] = 2,	-- Infected Wounds
	[58448] = 1,	-- Strength
	[58449] = 1,	-- Strength
	[58450] = 1,	-- Agility
	[58451] = 1,	-- Agility
	[58452] = 1,	-- Armor
	[58501] = 1,	-- Iron Boot Flask
	[59052] = 1,	-- Freezing Fog
	[59578] = 1,	-- The Art of War
	[59638] = 1,	-- Frostbolt
	[59888] = 1,	-- Borrowed Time
	[59889] = 1,	-- Borrowed Time
	[60433] = 1,	-- Earth and Moon
	[60518] = 1,	-- Touched by a Troll
	[60946] = 1,	-- Nightmare
	[60947] = 1,	-- Nightmare
	[61295] = 1,	-- Riptide
	[61305] = 1,	-- Polymorph (cat)
	[61316] = 1,	-- Dalaran Brilliance
	[61394] = 1,	-- Frozen Wake
	[61721] = 1,	-- Polymorph
	[63167] = 1,	-- Decimation
	[63529] = 1,	-- Dazed - Avenger's Shield
	[63672] = 1,	-- ObsoleteBlack Arrow
	[63685] = 1,	-- Freeze
	[63735] = 1,	-- Serendipity
	[64044] = 1,	-- Psychic Horror
	[64128] = 1,	-- Body and Soul
	[64205] = 1,	-- Divine Sacrifice
	[64368] = 1,	-- Eradication
	[64370] = 1,	-- Eradication
	[64371] = 1,	-- Eradication
	[64695] = 1,	-- Earthgrab
	[64701] = 1,	-- Elemental Mastery
	[64803] = 1,	-- Entrapment
	[64844] = 1,	-- Divine Hymn
	[64904] = 1,	-- Hymn of Hope
	[65081] = 1,	-- Body and Soul
	[65142] = 2,	-- Ebon Plague
	[65264] = 1,	-- Lava Flows
	[67631] = 1,	-- Aegis
	[68055] = 1,	-- Judgements of the Just
	[69180] = 4,	-- Gutgore Ripper
	[69369] = 1,	-- Predator's Swiftness
	[70691] = 1,	-- Rejuvenation
	[71824] = 1,	-- Lava Burst
	[71870] = 1,	-- Blessing of Light
	[71875] = 1,	-- Necrotic Touch
	[71877] = 1,	-- Necrotic Touch
	[71882] = 1,	-- Invigoration
	[72104] = 1,	-- Freezing Ground
	[72104] = 1,	-- Freezing Ground
	[72586] = 1,	-- Blessing of Forgotten Kings
	[72590] = 1,	-- Fortitude
	[73320] = 1,	-- Frostborn Illusion
	[73320] = 1,	-- Frostborn Illusion
	[74347] = 1,	-- Silenced - Gag Order
	[76691] = 5,	-- Vengeance
	[76780] = 1,	-- Bind Elemental
	[77487] = 1,	-- Shadow Orb
	[77613] = 1,	-- Grace
	[77661] = 1,	-- Searing Flames
	[77800] = 1,	-- Focused Insight
	[79057] = 1,	-- Arcane Brilliance
	[79058] = 1,	-- Arcane Brilliance
	[79060] = 1,	-- Mark of the Wild
	[79061] = 1,	-- Mark of the Wild
	[79062] = 1,	-- Blessing of Kings
	[79063] = 1,	-- Blessing of Kings
	[79101] = 1,	-- Blessing of Might
	[79102] = 1,	-- Blessing of Might
	[79104] = 1,	-- Power Word: Fortitude
	[79105] = 1,	-- Power Word: Fortitude
	[79106] = 1,	-- Shadow Protection
	[79107] = 1,	-- Shadow Protection
	[79206] = 1,	-- Spiritwalker's Grace
	[79438] = 1,	-- Soulburn: Demonic Circle
	[79440] = 1,	-- Soulburn: Searing Pain
	[79459] = 1,	-- Demon Soul: Imp
	[79460] = 1,	-- Demon Soul: Felhunter
	[79462] = 1,	-- Demon Soul: Felguard
	[79464] = 1,	-- Demon Soul: Voidwalker
	[80325] = 7,	-- Camouflage
	[80353] = 1,	-- Time Warp
	[81017] = 5,	-- Stampede
	[81021] = 5,	-- Stampede
	[81022] = 5,	-- Stampede
	[81281] = 1,	-- Fungal Growth
	[81301] = 1,	-- Glyph of Spirit Tap
	[81700] = 1,	-- Archangel
	[82327] = 1,	-- Holy Radiance
	[82654] = 3,	-- Widow Venom
	[83073] = 1,	-- Shattered Barrier
	[83154] = 1,	-- Piercing Chill
	[83302] = 1,	-- Improved Cone of Cold
	[84963] = 1,	-- Inquisition
	[85383] = 1,	-- Improved Soul Fire
	[85387] = 1,	-- Aftermath
	[85421] = 1,	-- Burning Embers
	[85497] = 1,	-- Speed of Light
	[85696] = 1,	-- Zealotry
	[85767] = 1,	-- Dark Intent
	[85768] = 1,	-- Dark Intent
	[86211] = 1,	-- Soul Swap
	[86273] = 1,	-- Illuminated Healing
	[86759] = 1,	-- Silenced - Improved Kick
	[87153] = 1,	-- Dark Archangel
	[87160] = 1,	-- Mind Melt
	[87204] = 1,	-- Sin and Punishment
	[87342] = 1,	-- Holy Shield
	[88063] = 1,	-- Guarded by the Light
	[88466] = 3,	-- Serpent Sting
	[89420] = 1,	-- Drain Life
	[89485] = 1,	-- Inner Focus
	[90315] = 1,	-- Tailspin
	[90361] = 1,	-- Spirit Mend
	[91565] = 1,	-- Faerie Fire
	[91711] = 1,	-- Nether Ward
	[93400] = 1,	-- Shooting Stars
	[93402] = 1,	-- Sunfire
	[93986] = 1,	-- Aura of Foreboding
}

--Durations that don't match PvE durations.
--http://www.wowwiki.com/Diminishing_returns
lib.auraInfoPvP = {
	[118]	= 10,	-- Polymorph
	[339]	= 10, 	-- Entangling Roots	
	[605]	= 10, 	-- Mind Control
	[710]	= 6,	-- Banish
	[770]	= 40, 	-- Faerie Fire
	[1130]	= 120,	-- Hunter's Mark
	[1490]	= 120,	-- Curse of the Elements
	[1715]	= 10, 	-- Hamstring
	[2637]	= 10, 	-- Hibernate (18657)
	[3355]	= 10, 	-- Freezing Trap Effect
	[5782]	= 10,	-- Fear
	[6358]	= 10, 	-- Seduction
	[6770]	= 10, 	-- Sap
	[9484]	= 10,	-- Shackle Undead
	[10326] = 10, 	-- Turn Evil
	[16857] = 40, 	-- Faerie Fire (Feral)
	[19386]	= 6,	-- Wyvern Sting
	[20066] = 6, 	-- Repentance
	[28271]	= 10,	-- Polymorph (Turtle)
	[28272]	= 10,	-- Polymorph (Pig)
	[51514] = 10, 	-- Hex 
	[61305]	= 10,	-- Polymorph (Cat)
	[61721] = 10, 	-- Polymorph (Rabbit)
}