﻿---@diagnostic disable: deprecated
-----------------------------------------------------------------
--   L O C A L I Z A T I O N   D A T A B A S E   M O D U L E   --
-----------------------------------------------------------------
local localize = function(t, data) for k,v in pairs(data) do t[k] = v; end end
local appName, _, a = ...;
local L = _.L;

-- Category Database Module
_.CategoryNames = {
	[3] = "Tarot Decks",
	[106] = "Card",
	[107] = "Scrolls",
	[167] = "Crowns",
	[168] = "Materials",
	[227] = "Weapons",
	[230] = "Materials",
	[233] = "Bags",
	[234] = "Hats & Hoods",
	[235] = "Shoulders",
	[236] = "Robes & Tunics",
	[237] = "Bracers",
	[238] = "Belts",
	[239] = "Gloves",
	[240] = "Pants",
	[241] = "Boots",
	[242] = "Cloaks",
	[243] = "Shirts",
	[251] = "Helms",
	[252] = "Shoulders",
	[253] = "Chest",
	[254] = "Bracers",
	[255] = "Gloves",
	[256] = "Belts",
	[257] = "Pants",
	[258] = "Boots",
	[866] = "Trinkets",
	[867] = "Prisms & Statues",
	[868] = "Reagents",
	[869] = "Crowns",
	[1000] = "Materials",
	[1001] = "Spellthreads",
	[1002] = "Bags",
	[1003] = "Hats & Hoods",
	[1004] = "Shoulders",
	[1005] = "Robes & Tunics",
	[1006] = "Bracers",
	[1007] = "Belts",
	[1008] = "Gloves",
	[1009] = "Pants",
	[1010] = "Boots",
	[1011] = "Cloaks",
	[1012] = "Nets",
}
_.CategoryIcons = {
	[3] = 134492,
	[106] = 134492,
	[107] = 134939,
	[167] = 132769,
	[168] = 133237,
	[227] = 135580,
	[230] = 132907,
	[233] = 133652,
	[234] = 133133,
	[235] = 135033,
	[236] = 132659,
	[237] = 132606,
	[238] = 132503,
	[239] = 132940,
	[240] = 134586,
	[241] = 132539,
	[242] = 133768,
	[243] = 135029,
	[251] = 133076,
	[252] = 135032,
	[253] = 132635,
	[254] = 132607,
	[255] = 132939,
	[256] = 132513,
	[257] = 134592,
	[258] = 132544,
	[866] = 135443,
	[867] = 134096,
	[868] = 135732,
	[869] = 132767,
	[1002] = 133646,
	[1003] = 133133,
	[1004] = 135033,
	[1005] = 132659,
	[1006] = 132616,
	[1007] = 132516,
	[1008] = 132940,
	[1009] = 134586,
	[1010] = 132535,
	[1011] = 133770,
}

-- Custom Header Database Module
_.HeaderConstants = {
	ACHIEVEMENTS = -1000004,
	ARTIFACTS = -1000098,
	AZERITE_ESSENCES = -1000075,
	BLACK_MARKET_AUCTION_HOUSE = -1000083,
	BONUS_OBJECTIVES = -1000005,
	BONUS_ROLL = -1000006,
	BREWFEST_HEADER = -1000282,
	BUILDINGS = -1000091,
	CALL_OF_THE_SCARAB_HEADER = -1000199,
	CHEST = -1000062,
	CHILDRENS_WEEK_HEADER = -1000200,
	COMMON_BOSS_DROPS = -1000010,
	COMMON_DUNGEON_DROPS = -1000012,
	COMMON_VENDOR_ITEMS = -1000013,
	COMMUNITY_CLUES_HEADER = -1000361,
	CRAFTED_ITEMS = -1000014,
	DARKMOON_FAIRE_HEADER = -1000201,
	DAY_OF_THE_DEAD_HEADER = -1000207,
	DELVE_COMPLETION = -1001041,
	DELVES = -1000907,
	DISCOVERY = -1000016,
	DRAGONRIDING_CUP_HEADER = -1000208,
	DROPS = -1000017,
	DUNGEONS = -1000877,
	EASTERN_KINGDOMS_CUP_HEADER = -1000210,
	EMISSARY_QUESTS = -1000018,
	EVENT_COMPLETION = -1000851,
	EXPANSION_PRELAUNCH = -1001075,
	EXPLORATION = -1000019,
	FACTIONS = -1000020,
	FEAST_OF_WINTER_VEIL_HEADER = -1000215,
	FLIGHT_PATHS = -1000021,
	FOLLOWERS = -1000022,
	FREE_T_SHIRT_DAY_HEADER = -1000216,
	GARRISON_MISSION_LOOT = -1001077,
	GARRISON_MISSIONS = -1001076,
	GARRISONS = -1000092,
	GUEST_RELATIONS = -1001045,
	HALLOWS_END_HEADER = -1000217,
	HANDS = -1000065,
	HARVEST_FESTIVAL_HEADER = -1000218,
	HEAD = -1000066,
	HEIRLOOMS = -1000103,
	HOLIDAYS = -1000025,
	HONOR_TITLES = -1000142,
	IN_GAME_SHOP = -1000097,
	KALIMDOR_CUP_HEADER = -1000211,
	LEGENDARIES = -1000105,
	LEGS = -1000067,
	LOVE_IS_IN_THE_AIR_HEADER = -1000220,
	LUNAR_FESTIVAL_HEADER = -1000221,
	MARCH_OF_THE_TADPOLES_HEADER = -1000222,
	MIDSUMMER_FIRE_FESTIVAL_HEADER = -1000223,
	MOUNT_MODS = -1001032,
	NOBLEGARDEN_HEADER = -1000224,
	NORTHREND_CUP_HEADER = -1000212,
	OUTLAND_CUP_HEADER = -1000213,
	PET_BATTLE = -1000029,
	PILGRIMS_BOUNTY_HEADER = -1000225,
	PIRATES_DAY_HEADER = -1000226,
	PRESTIGE = -1001092,
	PROFESSIONS = -1000030,
	PVP = -1000144,
	PVP_COMBATANT = -1000139,
	PVP_GLADIATOR = -1000141,
	PVP_WARMODE = -1000978,
	QUESTS = -1000031,
	RAIDS = -1000885,
	RARES = -1000032,
	REMIX_MOP = -1000873,
	REWARDS = -1000033,
	SCENARIO_COMPLETION = -1000850,
	SCENARIOS = -1000054,
	SECRETS = -1000035,
	SECRETS_OF_AZEROTH_HEADER = -1000360,
	SHARED_APPEARANCES = -1000162,
	SHOULDER = -1000070,
	SPECIAL = -1000037,
	THE_GREAT_GNOMEREGAN_RUN_HEADER = -1000228,
	THOUSAND_BOAT_BASH_HEADER = -1000229,
	TIER_14_RAIDS = -1000879,
	TREASURES = -1000038,
	TRIAL_OF_STYLE_HEADER = -1000230,
	UI_BOUNTY_WINDOW = -1000380,
	UNIQUE_APPEARANCE = -1000163,
	UPGRADE = -1001070,
	VENDORS = -1000039,
	WAR_CAMPAIGN_ALLIANCE = -1001088,
	WAR_CAMPAIGN_HORDE = -1001089,
	WAR_EFFORT = -1000076,
	WARFRONT_BATTLE_FOR_STROMGARDE = -1000078,
	WEAPONS = -1000073,
	WEEKLY_HOLIDAYS = -1000041,
	WHELP_DAYCARE = -1000310,
	WORK_ORDERS = -1001086,
	WORLD_BOSSES = -1000042,
	WORLD_QUESTS = -1000043,
	ZONE_DROPS = -1000044,
	ZONE_REWARDS = -1000045,
	ZULAMAN_CHEST_4 = -1000059,
};
_.HeaderData = {
	IGNOREINMINILIST = {[-1000885]=1,[-1000879]=1,[-1000877]=1,[-1000873]=1,[-1000850]=1,[-1000092]=1,[-1000054]=1},
	FILLNPCS = {[-1000070]=1,[-1000067]=1,[-1000066]=1,[-1000065]=1,[-1000062]=1,[-1000044]=1,[-1000033]=1,[-1000017]=1,[-1000013]=1,[-1000010]=1},
};
localize(L.HEADER_NAMES, {
	[-1000000] = "East",
	[-1000001] = "North",
	[-1000002] = "South",
	[-1000003] = "West",
	[-1000004] = ACHIEVEMENTS,
	[-1000005] = TRACKER_HEADER_BONUS_OBJECTIVES,
	[-1000006] = "Bonus Roll",
	[-1000007] = RAID_BOSSES,
	[-1000008] = "Class Trial",
	[-1000009] = CLASS,
	[-1000010] = BATTLE_PET_BREED_QUALITY2.." "..TRANSMOG_SOURCE_1,
	[-1000011] = "Common Box Drops",
	[-1000012] = "Common Dungeon Drops",
	[-1000013] = "Common Vendor Items",
	[-1000014] = LOOT_JOURNAL_LEGENDARIES_SOURCE_CRAFTED_ITEM,
	[-1000016] = BATTLE_PET_SOURCE_11,
	[-1000017] = "Drops",
	[-1000018] = BOUNTY_BOARD_LOCKED_TITLE,
	[-1000019] = "Exploration",
	[-1000020] = FACTION,
	[-1000021] = C_Spell.GetSpellName(218950),
	[-1000022] = GARRISON_FOLLOWERS,
	[-1000023] = "Group Finder",
	[-1000024] = MINIMAP_TRACKING_HIDDEN_QUESTS,
	[-1000025] = CALENDAR_FILTER_HOLIDAYS,
	[-1000026] = MINIMAP_TRACKING_MAILBOX,
	[-1000027] = BRAWL_TOOLTIP_MAPS,
	[-1000028] = SPLASH_BATTLEFORAZEROTH_8_2_5_FEATURE1_TITLE,
	[-1000029] = BATTLE_PET_SOURCE_5,
	[-1000030] = TRADE_SKILLS,
	[-1000031] = TRACKER_HEADER_QUESTS,
	[-1000032] = BATTLE_PET_BREED_QUALITY4,
	[-1000033] = QUEST_REWARDS,
	[-1000035] = "Secrets",
	[-1000036] = WARDROBE_SETS,
	[-1000037] = SPECIAL,
	[-1000038] = C_Spell.GetSpellName(225652).." "..C_Spell.GetSpellName(168498),
	[-1000039] = TUTORIAL_TITLE20,
	[-1000041] = CALENDAR_FILTER_WEEKLY_HOLIDAYS,
	[-1000042] = WORLD.." "..RAID_BOSSES,
	[-1000043] = TRACKER_HEADER_WORLD_QUESTS,
	[-1000044] = ZONE.." "..BATTLE_PET_SOURCE_1,
	[-1000045] = "Zone Rewards",
	[-1000046] = CHALLENGE_MODE,
	[-1000047] = PLAYER_DIFFICULTY_MYTHIC_PLUS,
	[-1000048] = "Dragons of Nightmare",
	[-1000049] = DUNGEON_FLOOR_NAXXRAMAS2,
	[-1000050] = DUNGEON_FLOOR_NAXXRAMAS1,
	[-1000051] = DUNGEON_FLOOR_NAXXRAMAS3,
	[-1000052] = DUNGEON_FLOOR_NAXXRAMAS4,
	[-1000053] = DUNGEON_FLOOR_NAXXRAMAS6,
	[-1000054] = SCENARIOS,
	[-1000055] = "Timed Event",
	[-1000056] = "First Chest",
	[-1000057] = "Second Chest",
	[-1000058] = "Third Chest",
	[-1000059] = "Final Chest",
	[-1000060] = ARMOR,
	[-1000061] = INVTYPE_CLOAK,
	[-1000062] = INVTYPE_CHEST,
	[-1000063] = INVTYPE_FEET,
	[-1000064] = INVTYPE_FINGER,
	[-1000065] = INVTYPE_HAND,
	[-1000066] = INVTYPE_HEAD,
	[-1000067] = INVTYPE_LEGS,
	[-1000068] = INVTYPE_NECK,
	[-1000069] = C_Item.GetItemSubClassInfo(3,11),
	[-1000070] = INVTYPE_SHOULDER,
	[-1000071] = INVTYPE_TRINKET,
	[-1000072] = INVTYPE_WAIST,
	[-1000073] = AUCTION_CATEGORY_WEAPONS,
	[-1000074] = INVTYPE_WRIST,
	[-1000075] = SPLASH_BATTLEFORAZEROTH_8_2_0_FEATURE2_TITLE,
	[-1000076] = select(1,GetCategoryInfo(15308)),
	[-1000077] = C_Spell.GetSpellName(290253),
	[-1000078] = C_Spell.GetSpellName(279443),
	[-1000079] = C_Spell.GetSpellName(370340),
	[-1000080] = "Dream Wardens",
	[-1000081] = C_Spell.GetSpellName(388922),
	[-1000082] = select(1,GetCategoryInfo(15304)),
	[-1000083] = BLACK_MARKET_AUCTION_HOUSE,
	[-1000084] = TRACKER_HEADER_PROVINGGROUNDS,
	[-1000085] = COVENANT_MISSIONS_TITLE,
	[-1000086] = ANIMA_DIVERSION_ORIGIN_TOOLTIP,
	[-1000087] = "Covenant Assaults",
	[-1000088] = select(1,GetCategoryInfo(15441)),
	[-1000089] = "Sanctum Upgrades",
	[-1000090] = "Soulshape Forms",
	[-1000091] = "Buildings",
	[-1000092] = "Garrisons",
	[-1000093] = FACTION_ALLIANCE,
	[-1000094] = GUILD,
	[-1000095] = FACTION_HORDE,
	[-1000096] = COMBATLOG_FILTER_STRING_NEUTRAL_UNITS,
	[-1000097] = BATTLE_PET_SOURCE_10,
	[-1000098] = ITEM_QUALITY6_DESC,
	[-1000099] = ITEM_QUALITY1_DESC,
	[-1000100] = ELITE,
	[-1000103] = HEIRLOOMS,
	[-1000104] = ITEM_QUALITY5_DESC,
	[-1000105] = LOOT_JOURNAL_LEGENDARIES,
	[-1000106] = ITEM_QUALITY0_DESC,
	[-1000108] = "Thunderforged",
	[-1000109] = string.format(GARRISON_CURRENT_LEVEL.." "..WARDROBE_SETS, 3),
	[-1000112] = "Warforged",
	[-1000114] = "Patch 1.x.x",
	[-1000115] = "Patch 2.x.x",
	[-1000116] = "Patch 3.x.x",
	[-1000117] = "Patch 4.x.x",
	[-1000118] = "Patch 5.x.x",
	[-1000119] = "Patch 6.x.x",
	[-1000120] = "Patch 7.x.x",
	[-1000121] = "Patch 8.x.x",
	[-1000122] = "Patch 9.x.x",
	[-1000123] = "Armor Enchantments",
	[-1000124] = "First Crafts",
	[-1000125] = "Weapon Enchantments",
	[-1000126] = "Weekly Profession Knowledge",
	[-1000127] = select(2,GetAchievementInfo(2091))..": Season 1",
	[-1000128] = select(2,GetAchievementInfo(418))..": Season 2",
	[-1000129] = select(2,GetAchievementInfo(419))..": Season 3",
	[-1000130] = select(2,GetAchievementInfo(420))..": Season 4",
	[-1000131] = select(2,GetAchievementInfo(3336))..": Season 5",
	[-1000132] = "Hateful Gladiator",
	[-1000133] = select(2,GetAchievementInfo(3436))..": Season 6",
	[-1000134] = select(2,GetAchievementInfo(3758))..": Season 7",
	[-1000135] = select(2,GetAchievementInfo(4599))..": Season 8",
	[-1000136] = ARENA,
	[-1000137] = BATTLEGROUNDS,
	[-1000138] = "Aspirant Gear",
	[-1000139] = "Combatant Gear",
	[-1000140] = "Elite Gear",
	[-1000141] = "Gladiator Gear",
	[-1000142] = HONOR .. " " .. PAPERDOLL_SIDEBAR_TITLES,
	[-1000143] = HONOR,
	[-1000144] = PVP,
	[-1000145] = "All Roles",
	[-1000146] = "DPS",
	[-1000147] = "Healers",
	[-1000148] = "Tanks",
	[-1000149] = MONTH_JANUARY,
	[-1000150] = MONTH_FEBRUARY,
	[-1000151] = MONTH_MARCH,
	[-1000152] = MONTH_APRIL,
	[-1000153] = MONTH_MAY,
	[-1000154] = MONTH_JUNE,
	[-1000155] = MONTH_JULY,
	[-1000156] = MONTH_AUGUST,
	[-1000157] = MONTH_SEPTEMBER,
	[-1000158] = MONTH_OCTOBER,
	[-1000159] = MONTH_NOVEMBER,
	[-1000160] = MONTH_DECEMBER,
	[-1000161] = "Year 2023",
	[-1000162] = "Shared Appearances",
	[-1000163] = "Unique Appearance",
	[-1000165] = "Tier 0.5 Sets",
	[-1000166] = "Captains",
	[-1000168] = "The Four Horsemen",
	[-1000169] = DUNGEON_FLOOR_BLACKROCKDEPTHS1,
	[-1000170] = DUNGEON_FLOOR_BLACKROCKDEPTHS2,
	[-1000172] = DUNGEON_FLOOR_UPPERBLACKROCKSPIRE1,
	[-1000173] = DUNGEON_FLOOR_DIREMAUL5.." (East)",
	[-1000174] = DUNGEON_FLOOR_DIREMAUL1.." (North)",
	[-1000175] = DUNGEON_FLOOR_DIREMAUL2.." (West)",
	[-1000176] = C_Spell.GetSpellName(21127),
	[-1000177] = DUNGEON_FLOOR_DESOLACE22.." ("..C_Spell.GetSpellName(251097)..")",
	[-1000178] = DUNGEON_FLOOR_DESOLACE21.." ("..C_Spell.GetSpellName(251095)..")",
	[-1000179] = "Graveyard",
	[-1000180] = "Library",
	[-1000181] = "Armory",
	[-1000182] = "Cathedral",
	[-1000183] = C_Map.GetAreaInfo(5916),
	[-1000184] = C_Map.GetAreaInfo(5917),
	[-1000185] = "Atal'ai Defenders",
	[-1000186] = "Storming the Citadel",
	[-1000187] = "The Plagueworks",
	[-1000188] = C_Map.GetAreaInfo(4892),
	[-1000189] = C_Map.GetAreaInfo(7932),
	[-1000190] = "Cache of Madness",
	[-1000194] = C_Map.GetAreaInfo(9310),
	[-1000197] = C_Map.GetAreaInfo(1769),
	[-1000199] = "Call of the Scarab",
	[-1000200] = select(1,GetCategoryInfo(163)),
	[-1000201] = "Darkmoon Faire",
	[-1000202] = "Minigames",
	[-1000203] = "Darkmoon Dance",
	[-1000204] = "Firebird's Challenge",
	[-1000205] = "Shooting Gallery",
	[-1000206] = "Whack-a-Gnoll",
	[-1000207] = "Day of the Dead",
	[-1000208] = "Dragonriding Cup",
	[-1000210] = "Eastern Kingdoms Cup",
	[-1000211] = "Kalimdor Cup",
	[-1000212] = "Northrend Cup",
	[-1000213] = "Outland Cup",
	[-1000215] = C_Spell.GetSpellName(21953),
	[-1000216] = "Free T-Shirt Day",
	[-1000217] = select(1,GetCategoryInfo(158)),
	[-1000218] = "Harvest Festival",
	[-1000219] = "Kalu'ak Fishing Derby",
	[-1000220] = select(1,GetCategoryInfo(187)),
	[-1000221] = select(1,GetCategoryInfo(160)),
	[-1000222] = "March of the Tadpoles",
	[-1000223] = "Midsummer Fire Festival",
	[-1000224] = select(1,GetCategoryInfo(159)),
	[-1000225] = select(1,GetCategoryInfo(14981)),
	[-1000226] = "Pirates' Day",
	[-1000227] = "Stranglethorn Fishing Extravaganza",
	[-1000228] = "The Great Gnomeregan Run",
	[-1000229] = "Thousand Boat Bash",
	[-1000230] = "Trial of Style",
	[-1000231] = select(1,GetCategoryInfo(14941)),
	[-1000232] = "Elemental Unrest",
	[-1000233] = select(2,GetAchievementInfo(4786)),
	[-1000234] = "The Ahn'Qiraj War Effort",
	[-1000235] = "The Opening of the Dark Portal",
	[-1000236] = "The Scepter of the Shifting Sands",
	[-1000237] = "The Scourge Invasion",
	[-1000239] = select(2,GetAchievementInfo(4790)),
	[-1000240] = "Shadowlands Seasonal Promotions",
	[-1000241] = "Dragonflight Seasonal Promotions",
	[-1000242] = "Amazon Prime Gaming",
	[-1000243] = "BlizzCon",
	[-1000244] = "Collector's Edition",
	[-1000245] = "Heroic Edition",
	[-1000246] = "Epic Edition",
	[-1000247] = "TBC Classic Deluxe Edition",
	[-1000248] = "WotLK Classic Northrend Upgrade",
	[-1000249] = "Cata Classic Blazing Upgrade",
	[-1000251] = "WoW 15th Anniversary Collector's Edition",
	[-1000252] = "Diablo III",
	[-1000253] = "Diablo III: Reaper of Souls",
	[-1000254] = "Diablo IV",
	[-1000255] = "Overwatch: Origins",
	[-1000256] = "Starcraft II: Wings of Liberty",
	[-1000257] = "Starcraft II: Heart of the Swarm",
	[-1000258] = "Starcraft II: Legacy of the Void",
	[-1000259] = "Warcraft III Spoils of War Edition",
	[-1000260] = "Hearthstone",
	[-1000261] = "Hearthstone Mercenaries",
	[-1000262] = "Heroes of the Storm",
	[-1000263] = "iCoke",
	[-1000264] =  AUCTION_CATEGORY_MISCELLANEOUS,
	[-1000265] = SCROLL_OF_RESURRECTION,
	[-1000266] = C_PetJournal.GetPetInfoBySpeciesID(179),
	[-1000267] = BATTLE_PET_SOURCE_9,
	[-1000268] = "Warcraft Movie",
	[-1000269] = "Warcraft Rumble",
	[-1000282] = select(1,GetCategoryInfo(162)),
	[-1000283] = REFER_A_FRIEND,
	[-1000284] = "WoW's Anniversary",
	[-1000285] = select(2,GetAchievementInfo(2398)),
	[-1000286] = select(2,GetAchievementInfo(4400)),
	[-1000287] = select(2,GetAchievementInfo(5512)),
	[-1000288] = select(2,GetAchievementInfo(5863)),
	[-1000289] = select(2,GetAchievementInfo(6131)),
	[-1000290] = select(2,GetAchievementInfo(7853)),
	[-1000291] = select(2,GetAchievementInfo(8820)),
	[-1000292] = select(2,GetAchievementInfo(10058)),
	[-1000293] = select(2,GetAchievementInfo(10741)),
	[-1000294] = select(2,GetAchievementInfo(11848)),
	[-1000295] = select(2,GetAchievementInfo(12827)),
	[-1000296] = select(2,GetAchievementInfo(13917)),
	[-1000297] = select(2,GetAchievementInfo(14271)),
	[-1000298] = select(2,GetAchievementInfo(14942)),
	[-1000299] = select(2,GetAchievementInfo(15218)),
	[-1000300] = select(2,GetAchievementInfo(18702)),
	[-1000301] = "Raid Finder (5.4)",
	[-1000302] = "Flexible (5.4)",
	[-1000303] = "Normal (5.4)",
	[-1000304] = "Heroic (5.4)",
	[-1000305] = "Junkyard",
	[-1000306] = C_Spell.GetSpellName(251998),
	[-1000307] = "Divergent",
	[-1000308] = C_Spell.GetSpellName(147343),
	[-1000309] = "Assault on the Dark Portal",
	[-1000310] = "Little Scales Daycare",
	[-1000311] = "Emerald Bounty",
	[-1000312] = "Eon's Fringe",
	[-1000313] = C_Spell.GetSpellName(408633),
	[-1000314] = "Fifth Rock Mouse",
	[-1000315] = GARRISON_LANDING_INVASION,
	[-1000316] = "Event Roll",
	[-1000317] = "Great Odyn and the Firelord",
	[-1000318] = "The Wanderer and the Serpent",
	[-1000319] = "Halls of Gold and Glory",
	[-1000320] = "The Keeper's Eye",
	[-1000321] = "First of the Val'kyr",
	[-1000322] = "The Sealing of the Halls of Valor",
	[-1000323] = "His Name Is Dragonblood",
	[-1000324] = "The Last Words of Asgrim the Dreadkiller",
	[-1000325] = "A Shieldmaiden's Creed",
	[-1000326] = "The Prophecy of Rythas the Oracle",
	[-1000327] = "The Lessons of the Blackfist",
	[-1000328] = "Volund's Folly",
	[-1000329] = "Event Roll",
	[-1000330] = DUNGEON_FLOOR_NIGHTMARERAID8.." "..C_Spell.GetSpellName(133137),
	[-1000331] = DUNGEON_FLOOR_NIGHTMARERAID9.." "..C_Spell.GetSpellName(133137),
	[-1000332] = DUNGEON_FLOOR_NIGHTMARERAID7.." "..C_Spell.GetSpellName(133137),
	[-1000333] = DUNGEON_FLOOR_NIGHTMARERAID8.." "..C_Spell.GetSpellName(78741),
	[-1000334] = DUNGEON_FLOOR_NIGHTMARERAID9.." "..C_Spell.GetSpellName(78741),
	[-1000335] = DUNGEON_FLOOR_NIGHTMARERAID7.." "..C_Spell.GetSpellName(78741),
	[-1000336] = string.format(AZERITE_ESSENCE_RANK, 1),
	[-1000337] = string.format(AZERITE_ESSENCE_RANK, 2),
	[-1000338] = string.format(AZERITE_ESSENCE_RANK, 3),
	[-1000339] = string.format(AZERITE_ESSENCE_RANK, 4),
	[-1000340] = "Broken Mirror",
	[-1000341] = "Broken Mirror",
	[-1000342] = "Broken Mirror",
	[-1000343] = "Broken Mirror",
	[-1000344] = "Broken Mirror",
	[-1000345] = "Broken Mirror",
	[-1000346] = "Broken Mirror",
	[-1000347] = "Broken Mirror",
	[-1000348] = "Broken Mirror",
	[-1000349] = "Broken Mirror",
	[-1000350] = "Broken Mirror",
	[-1000351] = "Broken Mirror",
	[-1000352] = "Clan Aylaag",
	[-1000353] = "Grand Hunts",
	[-1000354] = "Iskaara Fishing",
	[-1000355] = C_Spell.GetSpellName(400433),
	[-1000356] = C_Spell.GetSpellName(388945),
	[-1000357] = "Dream Infusion",
	[-1000358] = C_Spell.GetSpellName(419242),
	[-1000359] = "Dreamsurge",
	[-1000360] = "Secrets of Azeroth",
	[-1000361] = "Community Clues",
	[-1000362] = "Uuna's World Tour",
	[-1000363] = RPE_GEAR_UPDATE,
	[-1000364] = "Diablo Events",
	[-1000365] = "Diablo 20th Anniversary",
	[-1000366] = "A Greedy Emissary",
	[-1000368] = GetDifficultyInfo(24),
	[-1000369] = "Year 2024",
	[-1000370] = "Year 2025",
	[-1000373] = "New Character",
	[-1000374] = "Allied Races",
	[-1000375] = "Hearthstone's 10th Anniversary",
	[-1000379] = "Bounty",
	[-1000380] = "Bounty",
	[-1000381] = "Kukuru's Cache",
	[-1000850] = "Scenario Completion",
	[-1000851] = "Event Completion",
	[-1000853] = "Sargerei War Council",
	[-1000855] = "Forsaken Deathsquad",
	[-1000856] = "Worgen Stalkers",
	[-1000858] = "Amateur Hunters",
	[-1000859] = ENCOUNTER_JOURNAL,
	[-1000860] = select(2,GetAchievementInfo(6002))..": Season 9",
	[-1000861] = select(2,GetAchievementInfo(6124))..": Season 10",
	[-1000862] = "Cataclysmic Gladiator: Season 11",
	[-1000863] = PVP_RATED_BATTLEGROUND,
	[-1000865] = "Battlefield: Barrens",
	[-1000866] = "Legendary: The Black Prince",
	[-1000869] = "The Iron Invasion",
	[-1000870] = "The Troll Incursion",
	[-1000872] = WOWLABS_GAMEMODE_HEADER,
	[-1000873] = "Remix: Mists of Pandaria",
	[-1000875] = "Infinite Bazaar",
	[-1000877] = DUNGEONS,
	[-1000879] = "Tier 14 Raids",
	[-1000881] = "World PvP",
	[-1000883] = "Pet Battle Dungeons",
	[-1000885] = RAIDS,
	[-1000887] = "Archaeology: PH1",
	[-1000888] = "Archaeology: PH2",
	[-1000889] = "Archaeology: PH3",
	[-1000890] = "Archaeology: PH4",
	[-1000891] = "Archaeology: PH5",
	[-1000892] = "Archaeology: PH6",
	[-1000893] = "Archaeology: PH7",
	[-1000894] = "Archaeology: PH8",
	[-1000895] = "Archaeology: PH9",
	[-1000896] = "Archaeology: PH10",
	[-1000897] = "Archaeology: PH11",
	[-1000899] = SPLASH_BATTLEFORAZEROTH_8_3_0_FEATURE1_TITLE,
	[-1000900] = "Lost Area",
	[-1000901] = "Corrupted Area",
	[-1000904] = "Source IDs",
	[-1000905] = GUILD .. " " .. TUTORIAL_TITLE20,
	[-1000906] = GROUP_FINDER,
	[-1000907] = DELVES_LABEL,
	[-1000908] = select(2,GetAchievementInfo(12945)),
	[-1000909] = select(2,GetAchievementInfo(13200)),
	[-1000910] = select(2,GetAchievementInfo(14690)),
	[-1000911] = select(2,GetAchievementInfo(14973)),
	[-1000912] = select(2,GetAchievementInfo(15353)),
	[-1000913] = select(2,GetAchievementInfo(15606)),
	[-1000914] = select(2,GetAchievementInfo(15951)),
	[-1000915] = select(2,GetAchievementInfo(17764)),
	[-1000916] = select(2,GetAchievementInfo(19132)),
	[-1000917] = select(2,GetAchievementInfo(19454)),
	[-1000918] = select(2,GetAchievementInfo(40380)),
	[-1000919] = "Heritage",
	[-1000920] = C_Spell.GetSpellName(415581),
	[-1000921] = ISLANDS_HEADER,
	[-1000922] = WORLD_MAP_THREATS,
	[-1000923] = "Drakewatcher Manuscript",
	[-1000924] = "Primal Storms",
	[-1000925] = BROKENSHORE_BUILDING_MAGETOWER,
	[-1000926] = "Trading Post",
	[-1000927] = select(2,GetAchievementInfo(13630)),
	[-1000928] = select(2,GetAchievementInfo(13957)),
	[-1000929] = string.format(COVENANT_SANCTUM_TIER, 5),
	[-1000930] = string.format(COVENANT_SANCTUM_TIER, 4),
	[-1000931] = string.format(COVENANT_SANCTUM_TIER, 1),
	[-1000932] = string.format(COVENANT_SANCTUM_TIER, 3),
	[-1000933] = string.format(COVENANT_SANCTUM_TIER, 2),
	[-1000935] = BROKENSHORE_BUILDING_NETHERDISRUPTOR,
	[-1000936] = "DF Rare Rotation",
	[-1000937] = "Zskera Vaults",
	[-1000938] = "Sniffenseeking",
	[-1000939] = C_Spell.GetSpellName(417520),
	[-1000940] = C_Spell.GetSpellName(386485),
	[-1000941] = C_Spell.GetSpellName(381284),
	[-1000942] = C_Spell.GetSpellName(365311),
	[-1000943] = C_Spell.GetSpellName(382288),
	[-1000944] = "Bartering",
	[-1000945] = "Fyrakk Assaults",
	[-1000946] = ITEM_TOURNAMENT_GEAR,
	[-1000948] = C_Spell.GetSpellName(181765),
	[-1000949] = "Council of Dornogal",
	[-1000954] = ACCOUNT_QUEST_LABEL,
	[-1000955] = "Lore",
	[-1000956] = "The Assembly of the Deeps",
	[-1000957] = "Hallowfall Arathi",
	[-1000958] = "The Severed Threads",
	[-1000960] = "Awakening The Machine",
	[-1000963] = "Snuffling",
	[-1000966] = "Severed Threads Pact",
	[-1000967] = PROFESSIONS_CRAFTING_ORDERS_TAB_NAME,
	[-1000973] = C_Spell.GetSpellName(445256),
	[-1000975] = C_Spell.GetSpellName(430253),
	[-1000978] = "War Mode Gear",
	[-1000989] = select(2,GetAchievementInfo(11012)),
	[-1000990] = select(2,GetAchievementInfo(11014)),
	[-1000991] = select(2,GetAchievementInfo(11037)),
	[-1000992] = select(2,GetAchievementInfo(11062)),
	[-1000993] = select(2,GetAchievementInfo(12010)),
	[-1000994] = select(2,GetAchievementInfo(12134)),
	[-1000995] = select(2,GetAchievementInfo(12185)),
	[-1001001] = "The War Within Seasonal Promotions",
	[-1001006] = "Garrison Campaign",
	[-1001008] = "Gear Conversion",
	[-1001011] = "SteelSeries",
	[-1001014] = C_Spell.GetSpellName(456522),
	[-1001017] = "Faithful Dog Secret",
	[-1001021] = "Discord Promotion",
	[-1001024] = "Patron Rewards",
	[-1001027] = "Filled Travelers Log",
	[-1001031] = select(2,GetAchievementInfo(41220)),
	[-1001032] = "Mount Mods",
	[-1001033] = C_Spell.GetSpellName(363104),
	[-1001034] = "Elemental Bonds",
	[-1001035] = "Seasonal Fish: Summer Bass",
	[-1001036] = "Seasonal Fish: Winter Squid",
	[-1001037] = "Leeching Vaults",
	[-1001038] = "Reliquary of Opulence",
	[-1001039] = "Blood from Stone",
	[-1001040] = "Audience with Arrogance",
	[-1001041] = "Delve Completion",
	[-1001045] = "Guest Relations",
	[-1001050] = "Plunderstore",
	[-1001057] = "Razer",
	[-1001059] = "Firestorms",
	[-1001060] = "Sandstorms",
	[-1001061] = "Snowstorms",
	[-1001062] = "Thunderstorms",
	[-1001070] = UPGRADE,
	[-1001071] = "Alcaz Island",
	[-1001074] = string.format(SPELLBOOK_AVAILABLE_AT, 48),
	[-1001075] = "Expansion Pre-Launch",
	[-1001076] = GARRISON_MISSIONS,
	[-1001077] = "Garrison Mission Loot",
	[-1001086] = CAPACITANCE_WORK_ORDERS,
	[-1001087] = "Outposts",
	[-1001088] = C_Map.GetAreaInfo(9663),
	[-1001089] = C_Map.GetAreaInfo(9664),
	[-1001090] = BATTLEFIELD_LEVEL .. "80-84",
	[-1001091] = BATTLEFIELD_LEVEL .. "85-89",
	[-1001092] = PVP_PRESTIGE_RANK_UP_TITLE,
	[-1001093] = PVP_TAB_CONQUEST,
	[-1001094] = "Unrated",
	[-1001095] = "|cffFF0000Ogom the Mangler seems just to spawn when you are doing the Daily 'Assault on the Iron Siegeworks'. This Quest wasn't active since the start of Legion and the buyable Quest 'Missive: Assault on the Iron Siegeworks' does not work either.|r",
	[-1001096] = "|cFFFFFFFFStep 1:|r Conspicious Note",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000018] = "These items can be obtained by doing Emissary Quests or gaining a paragon box.",
	[-1000025] = "A specific holiday may need to be active for you to complete the referenced Things within this section.",
	[-1000030] = "This section will only show your current character's professions outside of Account and Debug Mode.",
	[-1000033] = "Contains Things which are rewarded or are available from other content within the containing section.\nThey are consolidated here in an effort to reduce duplication from many possible Sources.",
	[-1000035] = "Naughty secrets...",
	[-1000043] = "World Quests are time-limited Quests available in specific locations with variable rewards.\n\nMake sure to check the ATT World Quests window (/attwq) often to see what time-limited Things you should go collect!",
	[-1000045] = "These items can drop from many many sources and are usually not difficult to obtain either.\n\nWhile not every source is possible in every Zone, here is a list of possible Sources:\nEmissary Quest (Legion&later)\nRare NPCs (MoP&later)\nRepeatable Treasure Chests (SL)\nTable missions (Legion&later)\nWish Crickets (SL)\nWorld Quests (Legion&later)\nZone Drops (MoP&later)",
	[-1000097] = "This section will show you things that you can buy in the In-Game Shop.",
	[-1000162] = "The items in this list are shared appearances for the above item. In Unique Appearance Mode, this list can help you understand why or why not a specific item would be marked Collected.",
	[-1000163] = "This item has a Unique Appearance. You must collect this item specifically to earn the appearance.",
	[-1000172] = "One member of your group must have completed the Seal of Ascension quest chain in order for the fires to light and the door to open to this portion of the instance. Also known as 'Upper' Blackrock Spire.",
	[-1000173] = "This part of the instance can be accessed from the eastern-most portal. (right side)",
	[-1000174] = "This part of the instance can be accessed from the northern-most portal.",
	[-1000175] = "This part of the instance can be accessed from the western-most portal. (left side)",
	[-1000183] = "Stratholme is divided into two sides.\n\nThis side is commonly referred to as the \"Live\" or \"Scarlet\" side, which the Scarlet Crusade has taken over.",
	[-1000184] = "Stratholme is divided into two sides.\n\nThis side is commonly referred to as the \"Dead\" or \"Scourge\" side, which the Scourge has taken over.",
	[-1000185] = "You must kill all 6 mini bosses around the room in order to unlock the way to Jammal'an the Prophet.",
	[-1000190] = "Requires Archaeology to activate. Activate all 4 of the artifacts to spawn the boss. If the boss you want doesn't spawn, do NOT kill the one that did. Instead, zone out and wait for 30 minutes. Once you zone back, there will sometimes be a new boss waiting for you.",
	[-1000202] = "The following minigames cost one Darkmoon Game Token to play and have a daily quest that grants you prize tickets as well as a number of associated achievements.",
	[-1000203] = "To play the Darkmoon Faire Dance game, talk to Simon Sezdans in front of the South Pavillion. Each attempt at the Darkmoon Faire Dance game costs one Darkmoon Game Token. Talking to Simon will also set the difficulty for your dance game:\n  Just something fun and easygoing! (Easy)\n  I'd like a little challenge! (Medium)\n  Show me your moves, don't hold back! (Hard)\n\nDarkmoon Dance Master is not a rhythm game like most dance games are, but a memory game instead. You will have a dancer next to you in the dancing arena, who will start a sequence of moves highlighted by runes in front of him. Easy games will have a sequence of 3 runes at a time, Medium games 4 runes, and Hard games 5 runes.\n\nThere are three possible runes: Chicken Dance (Yellow), Power Spin (Purple) and Fist Pump (Blue). Once the opponent finishes their sequence, you have 5 seconds to match the exact sequence used by the dancer. There is no punishment for taking your time to complete the sequence, as long as you do it in time and don't miss any steps.\n\nThe game ends after 5 rounds (if you complete all steps successfully), but can end prematurely if you miss too many steps. Missing no steps will grant you a perfect score.",
	[-1000204] = "Roughly 60 floating rings appear all over the island, but most are not over the Faire area proper and are found in the woods. Players start with ten seconds of flight time and flying through a ring will refresh the buff. Work out a route in such a way that the next ring is always within 10 seconds of the one that is getting flown through, as there are many ways to get cut off.",
	[-1000205] = "In order to maximize your score, wait for the current mark to disappear then aim towards the middle target. As soon as any green mark appear, press 1 immediately and during the short cast time, move your gun to point at the left or right target if necessary.",
	[-1000206] = "Located near the entrance, guests receive a mallet to whack some stuffed gnolls that pop out of nine barrels in the area. Players will have 60 seconds to earn 30 points. The gnolls come in three types: normal, Hogger, and baby, awarding 1 point, 3 points, or a knockdown, respectively.",
	[-1000232] = "The Elemental Unrest was a world event that heralded the Cataclysm. The event culminated in elementals attacking Stormwind, Orgrimmar, Ironforge, and Thunder Bluff. Players defeating these elementals and freeing trapped citizens within their entire city were granted access to two special boss encounters.",
	[-1000233] = "Operation: Gnomeregan was the name of Gelbin Mekkatorque's plan for the retaking of the surface of Gnomeregan. Only Alliance players between level 75 and 80 were able to serve during the operation, but lower level players helped by motivating other gnomes or by turning in items.",
	[-1000234] = "The Ruins of Ahn'Qiraj and Temple of Ahn'Qiraj were not be immediately available with the release of Phase 5. Instead, server communities had to undertake a massive war effort to open the raids by gathering supplies to prepare for the war and completing an epic questline that ultimately culminates in the banging of a gong to open the gates and release the horrors within upon the world.\n\nOnce both factions have finished their contribution, there is a 5-day grace period where. Afterwards, there is a server-wide 10 hour event which spans several zones in Kalimdor the moment someone bangs the gong.\n\nHow quickly Ahn'Qiraj opens depends on the server and its faction balance.\n\nWe recommend delaying the War Effort as long as possible to allow for the most number of people to obtain the Scarab Lord mount as everyone that finishes The Scepter of the Shifting Sands quest line will be granted the same rewards!",
	[-1000235] = "The Opening of the Dark Portal was a one-time event that happened between Prepatch and the launch of TBC and subsequentially removed after. The tabard is the only tabard in the game with the Flex emote built into it and is highly covetted by collectors. Highlord Kruul would spawn randomly outside of the major cities and max level zones of the time.",
	[-1000236] = "In addition to all players on a realm working towards completing the War Effort, one player had to create the Scepter of the Shifting Sands - a very difficult task that could only be solved by a server's top guild back when the questline was added. After the war effort was finished and the army of the Alliance and the Horde arrived in Silithus, the Scepter of the Shifting Sands could be used on the Scarab Gong. Doing so resulted in the opening of Ahn'Qiraj. The first player to bang the Scarab Gong on each server would be rewarded with the Scarab Lord title (in Burning Crusade, the title will not be available in Classic!) and the Black Qiraji Resonating Crystal mount. Anyone else who followed them within 10 hours was rewarded with the title as well.\n\nAlthough it is still possible to complete the questline for the Scepter of the Shifting Sands after the gates have been opened on your server, doing so will not reward neither the Black Qiraji Resonating Crystal nor the Scarab Lord title.",
	[-1000237] = "The Scourge Invasion was a world event in Patch 1.11 and again during the Wrath of the Lich King Pre-Patch during 3.0.1 that heralded the opening of Naxxramas, the citadel of the dreaded Kel'Thuzad.\n\nSeveral regions of Azeroth came under attack by Scourge forces. Members of the Argent Dawn organized a worldwide counter to the Scourge invasion, keeping an eye out for any necropolis sightings and passing on their information to all adventurers willing to aid them in their struggle.\n\nWith each victory against the Scourge, the defense grows stronger. As more and more invasion attempts are beaten back by the defenders, the Argent Dawn will be able to bestow increasingly more powerful blessings upon those fighting the invaders. If the mortal races focus on clearing the Scourge camps all over the world that have sprung up beneath each necropolis, perhaps the invasion can effectively be halted or even repelled. Those who wish to take up arms against the undead invaders should speak with a representative of the Argent Dawn to learn what regions need help and how the defense is holding up.",
	[-1000239] = "Zalazane's Fall (also referred to as the Battle to reclaim the Echo Isles) was the final push by Vol'jin and the Darkspear tribe to retake the Echo Isles from the clutches of the evil Zalazane. It was a culminating event for the Horde to occur before the release of the next expansion, Cataclysm. Furthermore, all troll characters created after the liberation of the Echo Isles now have their new starting point there.",
	[-1000240] = "These promotions happened during the time Shadowlands was the most recent content between 13th October 2020 & 25th October 2022.\n\nThey are listed in the order of their first appearance.",
	[-1000241] = "These promotions happened during the time Dragonflight was the most recent expansion between 25th October 2022 & 24th July 2024.\n\nThey are listed in the order of their first appearance.",
	[-1000242] = "Amazon Prime Gaming offers in-game content for World of Warcraft Retail. Depending on your country, Amazon Prime (which includes Gaming) costs between 4-16 $/€ per month with the occasional monthly free trial available.\n\nCreate a Twitch account & connect it with your Prime Account. Next connect your B.Net Account with your Twitch Account. Lastly claim your monthly reward under 'gaming.amazon.com/loot/wow'.\n\nAmazon Prime also comes with a free Twitch subscription which you can use to support AllTheThings.\n\nTwitch.tv/Crieve\nTwitch.tv/Goldenshacal",
	[-1000251] = "These rewards were made available to anyone who purchased a World of Warcraft 15th Anniversary Collector's Edition.",
	[-1000252] = "These rewards were made available to anyone who purchased a Collector's Edition of Diablo III.",
	[-1000253] = "These rewards were made available to anyone who purchased the Collector's Edition of the Reaper of Souls expansion for Diablo III.",
	[-1000254] = "Granted to owners of Diablo IV Base Version.",
	[-1000255] = "These rewards are available to anyone who purchases the Collector's Edition for Overwatch: Origins.",
	[-1000256] = "These rewards are available to anyone who purchased the Collector's Edition for Starcraft II: Wings of Liberty.",
	[-1000257] = "These rewards are available to anyone who purchased the Collector's Edition for Starcraft II: Heart of the Swarm.",
	[-1000258] = "These rewards are available to anyone who purchased the Collector's Edition for Starcraft II: Legacy of the Void.",
	[-1000259] = "These rewards are available to anyone who purchased the Spoils of War Edition of Warcraft III: Reforged.",
	[-1000260] = "Win 3 games in Hearthstone to qualify for these rewards.\n\nThe game is free, go get it!\n\nNOTE: You can thank IceQ1337 for this!",
	[-1000261] = "Complete the Mercenaries Mode tutorial in Hearthstone and send your party on a mission in order to receive this reward.",
	[-1000263] = "These were only available through the 2006 iCoke Promotion (China Only)",
	[-1000264] = "This section is for miscellaneous promotions that took place in the real world or something to do with account management.",
	[-1000265] = "The following item sets were implemented as boosted character rewards for recipients of the Scroll of Resurrection.\n\nThey were later added to vendors in Mount Hyjal and Vash'jir once the Scroll of Resurrection Service was retired.",
	[-1000266] = "This is a Battlegrounds-based event that coincides with the beginning of the Summer Olympic games. The only time this was celebrated was in 2008 to correspond to the Beijing Olympics, and although there appeared to be the intention to repeat this event, it never returned.",
	[-1000268] = "These were rewarded for logging in at least once per faction while the Warcraft movie was still in theaters.",
	[-1000269] = "Promotion for mobile game Warcraft Rumble.",
	[-1000284] = "This is a yearly recurring event that occurs between the beginning of November and the end of the year.",
	[-1000301] = "This version of the instance was the original Raid Finder difficulty mode. The loot all had unique item IDs for each difficulty tier as well as their Warforged variants similar to how ToT was done. Blizzard changed their design philosophy for the better with Patch 6.0 and chose to reuse an item's ID and apply a bonus ID rather than creating a brand new item ID with the same base stats.",
	[-1000302] = "This version of the instance was the original Flexible difficulty mode. The loot all had unique item IDs for each difficulty tier as well as their Warforged variants similar to how ToT was done. Blizzard changed their design philosophy for the better with Patch 6.0 and chose to reuse an item's ID and apply a bonus ID rather than creating a brand new item ID with the same base stats.",
	[-1000303] = "This version of the instance was the original Normal difficulty mode. The loot all had unique item IDs for each difficulty tier as well as their Warforged variants similar to how ToT was done. Blizzard changed their design philosophy for the better with Patch 6.0 and chose to reuse an item's ID and apply a bonus ID rather than creating a brand new item ID with the same base stats.",
	[-1000304] = "This version of the instance was the original Heroic difficulty mode. The loot all had unique item IDs for each difficulty tier as well as their Warforged variants similar to how ToT was done. Blizzard changed their design philosophy for the better with Patch 6.0 and chose to reuse an item's ID and apply a bonus ID rather than creating a brand new item ID with the same base stats.",
	[-1000307] = "Low Drop Chance",
	[-1000309] = "The Assault on the Dark Portal is the instanced version of Tanaan Valley, which is the subzone of Tanaan Jungle and a location of Warlords of Draenor introductory experience. Once the intro is completed, players have no means of returning to the area, similiar to Plaguelands: The Scarlet Enclave for death knights.",
	[-1000315] = "To trigger an invasion, you need to do an assault quest or purchase a scouting missive from the garrison quartermaster. \n\nBotani Invasion -- Assault on Lost Veil Anzu, Assault on the Everbloom Wilds \n\nGoren Invasion -- Assault on Magnarok, Assault on the Broken Precipice \n\nIron Horde Invasion -- Assault on Mok'gol Watchpost, Assault on the Iron Siegeworks, Assault on the Pit, Battle in Ashran \n\nOgre Invasion -- Assault on Stonefury Cliffs, Assault on the Gorian Proving Grounds, Challenge at the Ring of Blood \n\nShadow Council Invasion -- Assault on Shattrath Harbor, Assault on the Heart of Shattrath \n\nShadowmoon Invasion -- Assault on Darktide Roost, Assault on Pillars of Fate, Assault on Skettis, Assault on Socrethar's Rise \n\nYou can earn Bronze, Silver, Gold, and Platinum rewards once per week per toon.",
	[-1000316] = "If this quest has a checkmark next to it, then check below to see if you are eligible for the scenario portal. If not, that means that you should come back tomorrow.",
	[-1000329] = "If this quest has a checkmark next to it, then check below which stone is active. If none of them are checked, that means that none of the owlcat stones can be interacted with today and that you should come back tomorrow.",
	[-1000330] = "If this quest has a checkmark next to it, then that means the stone is active.",
	[-1000331] = "If this quest has a checkmark next to it, then that means the stone is active.",
	[-1000332] = "If this quest has a checkmark next to it, then that means the stone is active.",
	[-1000333] = "This quest indicates if you have activated the Duskwood Owlcat Stone.",
	[-1000334] = "This quest indicates if you have activated the Feralas Owlcat Stone.",
	[-1000335] = "This quest indicates if you have activated the Hinterlands Owlcat Stone.",
	[-1000362] = "Congrats on making it this far!  Now it's time to take your favorite li'l ghost on a world tour.",
	[-1000368] = "Timewalking difficulties needlessly create new Source IDs for items despite having the exact same name, appearance, and display in the Collections Tab.\n\nA plea to the Blizzard Devs: Please clean up the Source ID database and have your Timewalking / Titanforged item variants use the same Source ID as their base assuming the appearances and names are exactly the same. Not only will this make your database much cleaner, but it will also make Completionists excited for rather than dreading the introduction of more Timewalking content.\n\n - Crieve, the Very Bitter Account Completionist that had 99% Ulduar completion and now only has 64% because your team duplicated the Source IDs rather than reuse the existing one.",
	[-1000380] = "This list contains Unobtainable items that the ATT Discord has reported as bugs that Blizzard has yet to fix.\n\nNOTE: All filters are ignored within this list for visibility. Only items removed from the game due to negligence rather than a gigantic fire breathing dragon are present on this list.\n\nTo Blizzard Devs: Please fix the items and encounters listed below.",
	[-1000381] = "Buy a Kukuru's Cache Key to open this. Has a very small chance of containing a Burden of Eternity and more frequently, the Bonkers pet.",
	[-1000850] = "Contains Things which are rewarded that upon completing that scenario.",
	[-1000851] = "Contains things that are rewarded upon completing that event.",
	[-1000853] = "Patrols the area in roughly a circle.",
	[-1000855] = "There is an ongoing 4x4 battle.  Assist the Alliance by defeating the Forsaken Deathsquad.",
	[-1000856] = "There is an ongoing 4x4 battle.  Assist the Horde by defeating the Worgen Stalkers.",
	[-1000858] = "Three hunters have surrounded Mara Swiftmane. Engage them in combat, and a Battered Chest will spawn near Mara Swiftmane. Once the battle is over, Mara will thank you and leave you with the Battered Chest.",
	[-1000863] = "These items require the Legionnaire/Knight-Captain rank from Classic/Rated Battlegrounds or higher to purchase.",
	[-1000869] = "If you are phased into the Invasion Blasted Lands and need to go to the pre-Invasion Blasted Lands, then you need to speak with Zidormi, who is standing on a small hill near the entrance of the zone from Swamp of Sorrows.",
	[-1000872] = "Get swept away in the Plunderstorm— a fun, new, limited-time, pirate-themed event of prodigious proportions lasting the next several weeks. Scour the map and try to be the last pirate standing while dashing across the Arathi Highlands to find abilities, upgrades, and loot to plunder just to survive!\n\nTo Play: Login to Retail WoW and select 'Plunderstorm' from the Game Mode on the top left of your Character Select screen.",
	[-1000875] = "The Infinite Bazaar has multiple locations.",
	[-1001001] = "These promotions happened during the time The War Within.\n\nThey are listed in the order of their first appearance.",
	[-1001011] = "Promotion for SteelSeries World of Warcraft Limited Edition Collection.",
	[-1001021] = "Promotion for streaming World of Warcraft in Discord.",
	[-1001027] = "This reward is given for filling the Travel Points Progress Bar during the month.",
	[-1001034] = "The Elemental Bonds questline is an epic series of quests to restore Thrall to his former self after Majordomo Staghelm splits him into 4 essences of elements.",
	[-1001037] = "The first LFR wing, featuring Huntsman Altimor, Hungering Destroyer, and Lady Inerva Darkvein.",
	[-1001038] = "The second LFR wing, featuring Artificer Xy'mox, Sun King's Salvation, and The Council of Blood.",
	[-1001039] = "The third LFR wing, featuring Shriekwing, Sludgefist, and Stone Legion Generals.",
	[-1001040] = "The fourth LFR wing, featuring Sire Denathrius.",
	[-1001041] = "Contains things that are rewarded upon completing that event.",
	[-1001050] = "This ingame shop menu allows you to purchase new and returning rewards in exchange for Plunder earned during the event.",
	[-1001057] = "Promotion for Razer Gaming Peripherals World of Warcraft Collection. Purchasing any item will award all three promotional codes.",
	[-1001071] = "Return to Alcaz Island to get to get to the bottom of Dr. Weavil's insidious plans, and perhaps you will take home a nice souvenir.",
});
localize(L.HEADER_LORE, {
	[-1000048] = "One of these dragons will spawn randomly at the associated coordinates across Azeroth.",
	[-1000165] = "The Dungeon Set 2 class sets, commonly referred to as Tier 0.5, are obtained by completing a long quest chain to upgrade the first set available as drops in end game dungeons into stronger versions of themselves. In current WoW, these sets are covetted by Collectors as the quest chain was completely removed from the game with Cataclysm. In WoW Classic, you should finish this quest chain on all of your characters before then!",
	[-1000166] = "These can be farmed infinitely by resetting the boss.",
	[-1000197] = "The Timbermaw Furbolgs inhabit two areas: Azshara and Felwood. They are presumed to be the only furbolg tribe to escape demonic corruption, though this may not be true due to the existence of Krolg, an uncorrupted furbolg of unknown tribe, and the Stillpine tribe on Azuremyst Isle in Burning Crusade. However, many other races kill furbolg blindly now, without bothering to see if they are friend or foe. For this reason, the Timbermaw furbolg trust very few.\n\nAdventurers who seek out Timbermaw Hold in northern Felwood and prove themselves as friends of the Timbermaw will learn that the furbolgs value their friends above all else. Though they possess no fine jewels or any worldly riches, the Timbermaw's shamanistic tradition is still strong. They know much about the art of crafting armors from animal hides, and they are more than happy to share their healing/resurrection knowledge with friends of their tribe. Besides, any reputation above Unfriendly will also grant you untroubled access to Moonglade and Winterspring through their tunnels.",
	[-1000308] = "The following items can be created by using a Burden of Eternity on a Timeless Armor Token for a double dose of pointless RNG.",
	[-1000869] = "The Iron Horde have activated their Dark Portal and have begun streaming through it in the Blasted Lands. They've made it all the way to Blackrock Spire and have designs on the rest of Azeroth. In the Blasted Lands, Nethergarde Keep has fallen, Okril'lon Hold (previously Dreadmaul Hold) has been taken over, and the Dreadmaul tribe have taken up with the Iron Horde as endless numbers of orcs stream from the Dark Portal.",
	[-1000870] = "Empowered by the Zandalari's offer the Gurubashi launched on all-out attack to claim Stranglethorn Vale for themselves. In Northern Stranglethorn Bambala, Fort Livingston, Nesingwary's Expedition, Grom'gol Base Camp, and the Rebel Camp came under attack by serpents sent by High Priest Venoxis. High Priestess Kilnara sent panthers to attack the Rebel Camp and Grom'gol while the panther Mauti attacked the hunters at Nesingwary's Expedition. Both Grom'gol and the Rebel Camp later came under attack by Gurubashi trolls led by Bloodlord Mandokir. After heroes of the Horde and Alliance beat back the Gurubashi attack, they were sent to the Cape of Stranglethorn which faced its own troubles.",
});
localize(L.HEADER_ICONS, {
	[-1000000] = 450908,
	[-1000001] = 450907,
	[-1000002] = 450905,
	[-1000003] = 450906,
	[-1000004] = _.asset("category_achievements"),
	[-1000005] = _.asset("interface_bonus_objectives"),
	[-1000006] = 237284,
	[-1000007] = _.asset("interface_world_boss"),
	[-1000008] = 1391675,
	[-1000009] = 136455,
	[-1000010] = _.asset("category_commonbossdrop"),
	[-1000011] = 1518641,
	[-1000012] = 3753263,
	[-1000013] = 133785,
	[-1000014] = _.asset("category_crafting"),
	[-1000016] = 975740,
	[-1000017] = _.asset("category_worlddrops"),
	[-1000018] = _.asset("interface_emissary_callings"),
	[-1000019] = _.asset("category_exploration"),
	[-1000020] = _.asset("category_factions"),
	[-1000021] = _.asset("category_flightpaths"),
	[-1000022] = _.asset("category_followers"),
	[-1000023] = 236685,
	[-1000024] = 134400,
	[-1000025] = _.asset("category_holidays"),
	[-1000026] = 133473,
	[-1000027] = 237381,
	[-1000028] = 236685,
	[-1000029] = _.asset("category_petbattles"),
	[-1000030] = _.asset("category_professions"),
	[-1000031] = _.asset("interface_quest_header"),
	[-1000032] = _.asset("interface_rare"),
	[-1000033] = _.asset("interface_rewards"),
	[-1000035] = _.asset("category_secrets"),
	[-1000036] = 1602705,
	[-1000037] = _.asset("interface_special"),
	[-1000038] = _.asset("interface_tchest"),
	[-1000039] = _.asset("interface_vendor"),
	[-1000041] = 3753381,
	[-1000042] = _.asset("interface_world_boss"),
	[-1000043] = _.asset("interface_worldquest"),
	[-1000044] = _.asset("interface_zone_drop"),
	[-1000045] = _.asset("interface_rewards"),
	[-1000046] = 618858,
	[-1000047] = 525134,
	[-1000048] = 134157,
	[-1000049] = 135442,
	[-1000050] = 236271,
	[-1000051] = 135771,
	[-1000052] = 133781,
	[-1000053] = 134155,
	[-1000054] = 647976,
	[-1000055] = 133633,
	[-1000056] = 133634,
	[-1000057] = 133639,
	[-1000058] = 133644,
	[-1000059] = 132594,
	[-1000060] = 1030912,
	[-1000061] = 133763,
	[-1000062] = 132624,
	[-1000063] = 132543,
	[-1000064] = 133346,
	[-1000065] = 132958,
	[-1000066] = 133071,
	[-1000067] = 134589,
	[-1000068] = 133289,
	[-1000069] = 1109960,
	[-1000070] = 135036,
	[-1000071] = 133440,
	[-1000072] = 132513,
	[-1000073] = _.asset("weapon_type_epic"),
	[-1000074] = 132606,
	[-1000075] = _.asset("category_azeriteessences"),
	[-1000076] = 132349,
	[-1000077] = 236739,
	[-1000078] = 236712,
	[-1000079] = 4687628,
	[-1000080] = 5244643,
	[-1000081] = 4687630,
	[-1000082] = 1408997,
	[-1000083] = _.asset("category_blackmarket"),
	[-1000084] = 618859,
	[-1000085] = 1103069,
	[-1000087] = 236373,
	[-1000088] = 3675495,
	[-1000090] = 572034,
	[-1000091] = 1005027,
	[-1000092] = 1041860,
	[-1000093] = 374217,
	[-1000094] = 442272,
	[-1000095] = 374221,
	[-1000096] = 374222,
	[-1000097] = _.asset("category_ingameshop"),
	[-1000098] = _.asset("weapon_type_artifact"),
	[-1000099] = 135030,
	[-1000100] = 237273,
	[-1000103] = _.asset("weapon_type_heirloom"),
	[-1000104] = _.asset("weapon_type_legendary"),
	[-1000105] = _.asset("weapon_type_legendary"),
	[-1000106] = 135025,
	[-1000108] = 839979,
	[-1000109] = 236489,
	[-1000112] = 450907,
	[-1000114] = _.asset("expansion_classic"),
	[-1000115] = _.asset("expansion_tbc"),
	[-1000116] = _.asset("expansion_wotlk"),
	[-1000117] = _.asset("expansion_cata"),
	[-1000118] = _.asset("expansion_mop"),
	[-1000119] = _.asset("expansion_wod"),
	[-1000120] = _.asset("expansion_legion"),
	[-1000121] = _.asset("expansion_bfa"),
	[-1000122] = _.asset("expansion_sl"),
	[-1000123] = 237019,
	[-1000124] = 4622272,
	[-1000125] = 237018,
	[-1000126] = 237446,
	[-1000127] = 236534,
	[-1000128] = 236535,
	[-1000129] = 236536,
	[-1000130] = 236537,
	[-1000131] = 303868,
	[-1000132] = 303868,
	[-1000133] = 303868,
	[-1000134] = 303868,
	[-1000135] = 303868,
	[-1000136] = 236329,
	[-1000137] = 132487,
	[-1000138] = 311229,
	[-1000139] = 311228,
	[-1000140] = 311232,
	[-1000141] = 311231,
	[-1000142] = 135358,
	[-1000143] = 1322720,
	[-1000144] = _.asset("category_pvp"),
	[-1000145] = 2065602,
	[-1000146] = 135810,
	[-1000147] = 136042,
	[-1000148] = 132362,
	[-1000149] = 132387,
	[-1000150] = _.asset("holiday_lunar"),
	[-1000151] = 3636844,
	[-1000152] = _.asset("holiday_noblegarden"),
	[-1000153] = 133938,
	[-1000154] = _.asset("holiday_midsummer"),
	[-1000155] = 3636845,
	[-1000156] = 874580,
	[-1000157] = 133208,
	[-1000158] = _.asset("holiday_brewfest"),
	[-1000159] = _.asset("holiday_day_of_the_dead"),
	[-1000160] = _.asset("holiday_winter_veil"),
	[-1000161] = 134284,
	[-1000162] = 1033585,
	[-1000163] = 413576,
	[-1000165] = 132738,
	[-1000166] = 236623,
	[-1000168] = 132264,
	[-1000169] = 236718,
	[-1000170] = 236718,
	[-1000172] = 134153,
	[-1000173] = 236292,
	[-1000174] = 236695,
	[-1000175] = 134162,
	[-1000176] = 135743,
	[-1000177] = 134116,
	[-1000178] = 134075,
	[-1000179] = 133730,
	[-1000180] = 133745,
	[-1000181] = 133127,
	[-1000182] = 133101,
	[-1000183] = 134503,
	[-1000184] = 134247,
	[-1000185] = 134177,
	[-1000186] = 343640,
	[-1000187] = 342919,
	[-1000188] = 341981,
	[-1000189] = 343638,
	[-1000190] = 441139,
	[-1000194] = 236829,
	[-1000197] = 236696,
	[-1000199] = _.asset("holiday_call_of_the_scarab"),
	[-1000200] = _.asset("holiday_children"),
	[-1000201] = _.asset("event_dmf"),
	[-1000202] = 134481,
	[-1000203] = 348567,
	[-1000204] = 514340,
	[-1000205] = 135610,
	[-1000206] = 537060,
	[-1000207] = _.asset("holiday_day_of_the_dead"),
	[-1000208] = _.asset("holiday_racecup"),
	[-1000210] = _.asset("holiday_eastcup"),
	[-1000211] = _.asset("holiday_kalcup"),
	[-1000212] = _.asset("holiday_northcup"),
	[-1000213] = _.asset("holiday_outcup"),
	[-1000215] = _.asset("holiday_winter_veil"),
	[-1000216] = _.asset("holiday_tshirt"),
	[-1000217] = _.asset("holiday_hallows_end"),
	[-1000218] = _.asset("holiday_harvestfest"),
	[-1000219] = 132933,
	[-1000220] = _.asset("holiday_love"),
	[-1000221] = _.asset("holiday_lunar"),
	[-1000222] = _.asset("holiday_marchofmurloc"),
	[-1000223] = _.asset("holiday_midsummer"),
	[-1000224] = _.asset("holiday_noblegarden"),
	[-1000225] = _.asset("holiday_pilgrim"),
	[-1000226] = _.asset("holiday_pirate"),
	[-1000227] = _.asset("holiday_stv_fishing"),
	[-1000228] = _.asset("holiday_gnomerun"),
	[-1000230] = _.asset("holiday_trialofstyle"),
	[-1000231] = 236689,
	[-1000232] = _.asset("expansion_cata"),
	[-1000233] = 255139,
	[-1000234] = 132594,
	[-1000235] = 255348,
	[-1000236] = 133062,
	[-1000237] = 135228,
	[-1000239] = 255135,
	[-1000240] = _.asset("expansion_sl"),
	[-1000241] = _.asset("expansion_df"),
	[-1000242] = 136101,
	[-1000243] = _.asset("promotion_blizzcon"),
	[-1000244] = _.asset("promotion_collector"),
	[-1000245] = _.asset("weapon_type_heirloom"),
	[-1000246] = _.asset("weapon_type_legendary"),
	[-1000247] = _.asset("expansion_tbc"),
	[-1000248] = _.asset("expansion_wotlk"),
	[-1000249] = _.asset("expansion_cata"),
	[-1000251] = _.asset("expansion_classic"),
	[-1000252] = 1529348,
	[-1000253] = 1529348,
	[-1000254] = 1529348,
	[-1000255] = 1303199,
	[-1000256] = 254885,
	[-1000257] = 656595,
	[-1000258] = 1125916,
	[-1000259] = 1041991,
	[-1000260] = 134414,
	[-1000261] = 134414,
	[-1000262] = 132314,
	[-1000263] = 461806,
	[-1000264] = 135999,
	[-1000265] = _.asset("promotion_scroll_of_rez"),
	[-1000266] = 133278,
	[-1000267] = 418250,
	[-1000268] = 133885,
	[-1000269] = 4226119,
	[-1000282] = _.asset("holiday_brewfest"),
	[-1000283] = 236688,
	[-1000284] = 133783,
	[-1000285] = 133783,
	[-1000286] = 133783,
	[-1000287] = 133783,
	[-1000288] = 133783,
	[-1000289] = 133783,
	[-1000290] = 133783,
	[-1000291] = 133783,
	[-1000292] = 133783,
	[-1000293] = 133783,
	[-1000294] = 133783,
	[-1000295] = 133783,
	[-1000296] = 133783,
	[-1000297] = 133783,
	[-1000298] = 133783,
	[-1000299] = 133783,
	[-1000300] = 133783,
	[-1000301] = _.asset("difficulty_lfr"),
	[-1000302] = _.asset("difficulty_normal"),
	[-1000303] = _.asset("difficulty_heroic"),
	[-1000304] = _.asset("difficulty_mythic"),
	[-1000305] = 321487,
	[-1000306] = 134240,
	[-1000307] = 4630469,
	[-1000308] = 775461,
	[-1000309] = 255348,
	[-1000310] = 3846202,
	[-1000311] = 464030,
	[-1000312] = 2026009,
	[-1000313] = 2026009,
	[-1000315] = 236351,
	[-1000316] = 1031536,
	[-1000317] = 237446,
	[-1000318] = 237446,
	[-1000319] = 237446,
	[-1000320] = 237446,
	[-1000321] = 237446,
	[-1000322] = 237446,
	[-1000323] = 237446,
	[-1000324] = 237446,
	[-1000325] = 237446,
	[-1000326] = 237446,
	[-1000327] = 237446,
	[-1000328] = 237446,
	[-1000329] = 1128042,
	[-1000330] = 236757,
	[-1000331] = 236764,
	[-1000332] = 236780,
	[-1000333] = 236757,
	[-1000334] = 236764,
	[-1000335] = 236780,
	[-1000336] = 2065623,
	[-1000337] = 2065629,
	[-1000338] = 2065624,
	[-1000339] = 2065622,
	[-1000340] = 3854020,
	[-1000341] = 3854020,
	[-1000342] = 3854020,
	[-1000343] = 3854020,
	[-1000344] = 3854020,
	[-1000345] = 3854020,
	[-1000346] = 3854020,
	[-1000347] = 3854020,
	[-1000348] = 3854020,
	[-1000349] = 3854020,
	[-1000350] = 3854020,
	[-1000351] = 3854020,
	[-1000352] = 3193420,
	[-1000353] = 4622465,
	[-1000354] = 1911518,
	[-1000355] = 1100022,
	[-1000356] = 1394891,
	[-1000357] = 1394953,
	[-1000358] = 441139,
	[-1000359] = 1396974,
	[-1000360] = _.asset("holiday_secretsaz"),
	[-1000361] = _.asset("holiday_secretsaz"),
	[-1000362] = 134507,
	[-1000363] = 1391675,
	[-1000364] = 1529348,
	[-1000365] = 1529344,
	[-1000366] = 5160585,
	[-1000368] = _.asset("difficulty_timewalking"),
	[-1000369] = 134283,
	[-1000370] = 134285,
	[-1000373] = 1530081,
	[-1000374] = 939373,
	[-1000375] = 134414,
	[-1000379] = 2125377,
	[-1000380] = 2125377,
	[-1000381] = 348554,
	[-1000850] = _.asset("interface_rewards"),
	[-1000851] = _.asset("interface_rewards"),
	[-1000853] = 136156,
	[-1000855] = 463451,
	[-1000856] = 463876,
	[-1000858] = 626000,
	[-1000859] = 4549140,
	[-1000860] = 236235,
	[-1000861] = 236235,
	[-1000862] = 236235,
	[-1000863] = 1455894,
	[-1000865] = 252178,
	[-1000866] = 656543,
	[-1000869] = 132396,
	[-1000870] = 135727,
	[-1000872] = 2055032,
	[-1000873] = _.asset("category_remix"),
	[-1000875] = 298656,
	[-1000877] = _.asset("category_d&r"),
	[-1000879] = _.asset("category_d&r"),
	[-1000881] = _.asset("category_zones"),
	[-1000883] = _.asset("pet_dungeon"),
	[-1000885] = _.asset("category_d&r"),
	[-1000899] = 609893,
	[-1000900] = 537021,
	[-1000901] = 136202,
	[-1000904] = 134400,
	[-1000905] = _.asset("interface_vendor"),
	[-1000906] = _.asset("category_d&r"),
	[-1000907] = _.asset("category_delves"),
	[-1000908] = 2406661,
	[-1000909] = 2406660,
	[-1000910] = 3593686,
	[-1000911] = 3593819,
	[-1000912] = 3593822,
	[-1000913] = 3593821,
	[-1000914] = 4571779,
	[-1000915] = 5114749,
	[-1000916] = 5208286,
	[-1000917] = 5145984,
	[-1000918] = 5499973,
	[-1000919] = 2437241,
	[-1000920] = 4640486,
	[-1000921] = 236739,
	[-1000922] = 575534,
	[-1000923] = 4728198,
	[-1000924] = 4638591,
	[-1000925] = 1033914,
	[-1000926] = _.asset("category_tradingpost"),
	[-1000927] = 2406664,
	[-1000928] = 2406659,
	[-1000935] = 1604164,
	[-1000936] = 237274,
	[-1000937] = 4638590,
	[-1000938] = 648644,
	[-1000939] = 535594,
	[-1000940] = 1377394,
	[-1000941] = 1109168,
	[-1000942] = 4562583,
	[-1000943] = 1723999,
	[-1000944] = 413570,
	[-1000945] = 4914672,
	[-1000946] = 1582146,
	[-1000948] = _.asset("category_selfiefilters"),
	[-1000949] = 5891369,
	[-1000954] = 4203076,
	[-1000955] = 2437241,
	[-1000956] = 5891367,
	[-1000957] = 5891368,
	[-1000958] = 5891370,
	[-1000960] = 5768149,
	[-1000963] = 648644,
	[-1000966] = 5409320,
	[-1000967] = 4557373,
	[-1000973] = 2967107,
	[-1000975] = 4622271,
	[-1000978] = 311230,
	[-1000989] = 1503309,
	[-1000990] = 1503310,
	[-1000991] = 1503311,
	[-1000992] = 1503312,
	[-1000993] = 1503313,
	[-1000994] = 1503314,
	[-1000995] = 1610629,
	[-1001001] = _.asset("expansion_tww"),
	[-1001006] = 1032149,
	[-1001008] = 1391675,
	[-1001011] = 133015,
	[-1001014] = 1604168,
	[-1001017] = 133210,
	[-1001021] = 133014,
	[-1001024] = 4557373,
	[-1001027] = 4696085,
	[-1001031] = 133783,
	[-1001032] = 975744,
	[-1001033] = 2915721,
	[-1001034] = 516313,
	[-1001035] = 133889,
	[-1001036] = 133899,
	[-1001037] = 3614361,
	[-1001038] = 3614361,
	[-1001039] = 3614361,
	[-1001040] = 3614361,
	[-1001041] = _.asset("interface_rewards"),
	[-1001045] = _.asset("holiday_secretsaz"),
	[-1001050] = 6255014,
	[-1001057] = 132529,
	[-1001059] = 460952,
	[-1001060] = 451165,
	[-1001061] = 135783,
	[-1001062] = 132845,
	[-1001070] = _.asset("interface_upgrade"),
	[-1001071] = 132996,
	[-1001074] = 1391675,
	[-1001075] = 134289,
	[-1001076] = 1035062,
	[-1001077] = 1103070,
	[-1001086] = 1103070,
	[-1001087] = 1103069,
	[-1001088] = 2565243,
	[-1001089] = 2565244,
	[-1001090] = 630784,
	[-1001091] = 630786,
	[-1001092] = 458725,
	[-1001093] = 2022761,
	[-1001094] = 236368,
});
localize(L.HEADER_EVENTS, {
	[-1000199] = 638,
	[-1000200] = 201,
	[-1000201] = 479,
	[-1000207] = 409,
	[-1000208] = 133701,
	[-1000210] = 1400,
	[-1000211] = 1395,
	[-1000212] = 1429,
	[-1000213] = 1407,
	[-1000215] = 141,
	[-1000216] = 1053,
	[-1000217] = 324,
	[-1000218] = 321,
	[-1000219] = 424,
	[-1000220] = 423,
	[-1000221] = 327,
	[-1000222] = 647,
	[-1000223] = 341,
	[-1000224] = 181,
	[-1000225] = 404,
	[-1000226] = 398,
	[-1000227] = 301,
	[-1000228] = 696,
	[-1000229] = 642,
	[-1000230] = 691,
	[-1000243] = 1181,
	[-1000282] = 372,
	[-1000284] = 590,
	[-1000291] = 514,
	[-1000292] = 566,
	[-1000293] = 589,
	[-1000294] = 693,
	[-1000295] = 807,
	[-1000296] = 808,
	[-1000297] = 1181,
	[-1000298] = 1225,
	[-1000299] = 1262,
	[-1000300] = 1397,
	[-1000366] = 1382,
	[-1000368] = 1271,
	[-1000872] = 446916,
	[-1000873] = 1525,
	[-1001031] = 1509,
	[-1001035] = 133889,
	[-1001036] = 133899,
});
localize(L.EVENT_TIMERUNNING_SEASONS, {
	[1] = 1525,
});

-- Programmatic Event Scheduling
_.Modules.Events.SetEventInformation(1397, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=16,["weekday"]=5,["year"]=2023},{["hour"]=0,["minute"]=0,["month"]=12,["monthDay"]=7,["weekday"]=5,["year"]=2023})
});
_.Modules.Events.SetEventInformation(1262, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=6,["weekday"]=1,["year"]=2022},{["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=27,["weekday"]=1,["year"]=2022})
});
_.Modules.Events.SetEventInformation(1225, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=15,["weekday"]=2,["year"]=2021},{["hour"]=0,["minute"]=0,["month"]=12,["monthDay"]=6,["weekday"]=2,["year"]=2021})
});
_.Modules.Events.SetEventInformation(1181, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=1,["weekday"]=1,["year"]=2020},{["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=22,["weekday"]=1,["year"]=2020})
});
_.Modules.Events.SetEventInformation(808, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=5,["weekday"]=3,["year"]=2019},{["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=7,["weekday"]=3,["year"]=2020})
});
_.Modules.Events.SetEventInformation(807, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=16,["weekday"]=6,["year"]=2018},{["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=30,["weekday"]=6,["year"]=2018})
});
_.Modules.Events.SetEventInformation(693, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=16,["weekday"]=5,["year"]=2017},{["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=30,["weekday"]=5,["year"]=2017})
});
_.Modules.Events.SetEventInformation(589, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=16,["weekday"]=4,["year"]=2016},{["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=30,["weekday"]=4,["year"]=2016})
});
_.Modules.Events.SetEventInformation(566, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=16,["weekday"]=2,["year"]=2015},{["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=30,["weekday"]=2,["year"]=2015})
});
_.Modules.Events.SetEventInformation(514, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=11,["monthDay"]=21,["weekday"]=6,["year"]=2014},{["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=5,["weekday"]=2,["year"]=2015})
});
_.Modules.Events.SetEventInformation(590, {
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=10,["monthDay"]=22,["weekday"]=3,["year"]=2024},{["hour"]=10,["minute"]=0,["month"]=1,["monthDay"]=7,["weekday"]=3,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=10,["monthDay"]=22,["weekday"]=4,["year"]=2025},{["hour"]=10,["minute"]=0,["month"]=1,["monthDay"]=7,["weekday"]=4,["year"]=2026}),
	_.Modules.Events.CreateSchedule({["hour"]=10,["minute"]=0,["month"]=10,["monthDay"]=22,["weekday"]=5,["year"]=2026},{["hour"]=10,["minute"]=0,["month"]=1,["monthDay"]=7,["weekday"]=5,["year"]=2027})
});
_.Modules.Events.SetEventInformation(133899, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=23,["weekday"]=2,["year"]=2024},{["hour"]=23,["minute"]=59,["month"]=3,["monthDay"]=19,["weekday"]=4,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=23,["weekday"]=3,["year"]=2025},{["hour"]=23,["minute"]=59,["month"]=3,["monthDay"]=19,["weekday"]=5,["year"]=2026}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=9,["monthDay"]=23,["weekday"]=4,["year"]=2026},{["hour"]=23,["minute"]=59,["month"]=3,["monthDay"]=19,["weekday"]=6,["year"]=2027})
});
_.Modules.Events.SetEventInformation(133889, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=20,["weekday"]=4,["year"]=2024},{["hour"]=23,["minute"]=59,["month"]=9,["monthDay"]=22,["weekday"]=1,["year"]=2024}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=20,["weekday"]=5,["year"]=2025},{["hour"]=23,["minute"]=59,["month"]=9,["monthDay"]=22,["weekday"]=2,["year"]=2025}),
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=3,["monthDay"]=20,["weekday"]=6,["year"]=2026},{["hour"]=23,["minute"]=59,["month"]=9,["monthDay"]=22,["weekday"]=3,["year"]=2026})
});
_.Modules.Events.SetEventInformation(1525, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=5,["monthDay"]=16,["weekday"]=5,["year"]=2024},{["hour"]=0,["minute"]=0,["month"]=8,["monthDay"]=20,["weekday"]=3,["year"]=2024})
});
_.Modules.Events.SetEventInformation(446916, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=14,["weekday"]=3,["year"]=2025},{["hour"]=0,["minute"]=0,["month"]=2,["monthDay"]=18,["weekday"]=3,["year"]=2025})
});
_.Modules.Events.SetEventInformation(1509, {
	_.Modules.Events.CreateSchedule({["hour"]=0,["minute"]=0,["month"]=10,["monthDay"]=22,["weekday"]=3,["year"]=2024},{["hour"]=0,["minute"]=0,["month"]=1,["monthDay"]=7,["weekday"]=3,["year"]=2025})
});

-- Filter Database Module
_.FilterConstants = {
	ACHIEVEMENTS = 105,
	AMMO = 37,
	ARTIFACTS = 11,
	BAGS = 113,
	BATTLE_PETS = 101,
	BOWS = 32,
	CLOAKS = 3,
	CLOTH = 4,
	CONSUMABLES = 55,
	COSMETIC = 2,
	CROSSBOWS = 33,
	DAGGERS = 20,
	FINGER = 52,
	FIST_WEAPONS = 34,
	GEMS = 61,
	GLYPHS = 111,
	GUNS = 31,
	HELD_IN_OFF_HAND = 1,
	HOLIDAY = 106,
	ILLUSIONS = 103,
	LEATHER = 5,
	MAIL = 6,
	MISCELLANEOUS = 50,
	MOUNT_EQUIPMENT = 114,
	MOUNTS = 100,
	NECK = 51,
	ONE_HANDED_AXES = 21,
	ONE_HANDED_MACES = 23,
	ONE_HANDED_SWORDS = 25,
	PLATE = 7,
	POLEARMS = 29,
	PROFESSION_EQUIPMENT = 57,
	QUEST_ITEMS = 104,
	REAGENTS = 56,
	RECIPES = 200,
	RELIC = 54,
	SHIELDS = 8,
	SHIRTS = 10,
	STAVES = 28,
	TABARDS = 9,
	THROWN = 36,
	TITLES = 110,
	TOYS = 102,
	TRINKET = 53,
	TWO_HANDED_AXES = 22,
	TWO_HANDED_MACES = 24,
	TWO_HANDED_SWORDS = 26,
	WANDS = 27,
	WARGLAIVES = 35,
};
L.FILTER_ID_TYPES = {
	[1] = INVTYPE_HOLDABLE,
	[2] = C_Item.GetItemSubClassInfo(4,5),
	[3] = C_Item.GetItemSubClassInfo(8,3),
	[4] = C_Item.GetItemSubClassInfo(4,1),
	[5] = C_Item.GetItemSubClassInfo(4,2),
	[6] = C_Item.GetItemSubClassInfo(4,3),
	[7] = C_Item.GetItemSubClassInfo(4,4),
	[8] = C_Item.GetItemSubClassInfo(4,6),
	[9] = INVTYPE_TABARD,
	[10] = INVTYPE_BODY,
	[11] = "Artifacts",
	[20] = C_Item.GetItemSubClassInfo(2,15),
	[21] = C_Item.GetItemSubClassInfo(2,0),
	[22] = C_Item.GetItemSubClassInfo(2,1),
	[23] = C_Item.GetItemSubClassInfo(2,4),
	[24] = C_Item.GetItemSubClassInfo(2,5),
	[25] = C_Item.GetItemSubClassInfo(2,7),
	[26] = C_Item.GetItemSubClassInfo(2,8),
	[27] = C_Item.GetItemSubClassInfo(2,19),
	[28] = C_Item.GetItemSubClassInfo(2,10),
	[29] = C_Item.GetItemSubClassInfo(2,6),
	[31] = C_Item.GetItemSubClassInfo(2,3),
	[32] = C_Item.GetItemSubClassInfo(2,2),
	[33] = C_Item.GetItemSubClassInfo(2,18),
	[34] = C_Item.GetItemSubClassInfo(2,13),
	[35] = C_Item.GetItemSubClassInfo(2,9),
	[36] = INVTYPE_THROWN,
	[37] = INVTYPE_AMMO,
	[50] = AUCTION_CATEGORY_MISCELLANEOUS,
	[51] = INVTYPE_NECK,
	[52] = INVTYPE_FINGER,
	[53] = INVTYPE_TRINKET,
	[54] = C_Item.GetItemSubClassInfo(3,11),
	[55] = AUCTION_CATEGORY_CONSUMABLES,
	[56] = C_Item.GetItemClassInfo(5),
	[57] = INVTYPE_PROFESSION_GEAR,
	[61] = C_Item.GetItemClassInfo(3),
	[100] = MOUNTS,
	[101] = AUCTION_CATEGORY_BATTLE_PETS,
	[102] = TOY,
	[103] = "Illusions",
	[104] = AUCTION_CATEGORY_QUEST_ITEMS,
	[105] = TRACKER_FILTER_ACHIEVEMENTS,
	[106] = CALENDAR_FILTER_WEEKLY_HOLIDAYS,
	[110] = PAPERDOLL_SIDEBAR_TITLES,
	[111] = C_Item.GetItemClassInfo(16),
	[113] = INVTYPE_BAG,
	[114] = C_Item.GetItemSubClassInfo(13,0),
	[200] = AUCTION_CATEGORY_RECIPES,
}
L.FILTER_ID_ICONS = {
	[1] = 134333,
	[2] = _.asset("interface_cosmetic"),
	[3] = 133763,
	[4] = 132662,
	[5] = 132724,
	[6] = 132627,
	[7] = 132736,
	[8] = 134952,
	[9] = 135026,
	[10] = 135025,
	[11] = 535594,
	[20] = 135637,
	[21] = 132408,
	[22] = 132400,
	[23] = 133477,
	[24] = 133053,
	[25] = 135274,
	[26] = 135277,
	[27] = 135464,
	[28] = 135164,
	[29] = 135127,
	[31] = 135610,
	[32] = 135493,
	[33] = 135530,
	[34] = 134295,
	[35] = 135561,
	[36] = 135426,
	[37] = 132383,
	[50] = 135999,
	[51] = 133289,
	[52] = 133346,
	[53] = 135443,
	[54] = 1109960,
	[55] = 132812,
	[56] = _.asset("interface_zone_drop"),
	[57] = 132932,
	[61] = 134129,
	[100] = _.asset("category_mounts"),
	[101] = _.asset("category_petjournal"),
	[102] = _.asset("category_toybox"),
	[103] = 237174,
	[104] = _.asset("interface_quest_header"),
	[105] = _.asset("category_achievements"),
	[106] = 133202,
	[110] = _.asset("category_titles"),
	[111] = 254306,
	[113] = 133633,
	[114] = 1534178,
	[200] = 134941,
}

-- Flight Path Database Module
_.FlightPathNames = {
	[1] = "Northshire Abbey",
	[2] = "Stormwind, Elwynn",
	[3] = "Programmer Isle",
	[4] = "Sentinel Hill, Westfall",
	[5] = "Lakeshire, Redridge",
	[6] = "Ironforge, Dun Morogh",
	[7] = "Menethil Harbor, Wetlands",
	[8] = "Thelsamar, Loch Modan",
	[9] = "Booty Bay, Stranglethorn",
	[10] = "The Sepulcher, Silverpine Forest",
	[11] = "Undercity, Tirisfal",
	[12] = "Darkshire, Duskwood",
	[13] = "Tarren Mill, Hillsbrad",
	[14] = "Southshore, Hillsbrad",
	[15] = "Eastern Plaguelands",
	[16] = "Refuge Pointe, Arathi",
	[17] = "Hammerfall, Arathi",
	[18] = "Booty Bay, Stranglethorn",
	[19] = "Booty Bay, Stranglethorn",
	[20] = "Grom'gol, Stranglethorn",
	[21] = "New Kargath, Badlands",
	[22] = "Thunder Bluff, Mulgore",
	[23] = "Orgrimmar, Durotar",
	[24] = "Generic, World Target 002",
	[25] = "The Crossroads, Northern Barrens",
	[26] = "Lor'danel, Darkshore",
	[27] = "Rut'theran Village, Teldrassil",
	[28] = "Astranaar, Ashenvale",
	[29] = "Sun Rock Retreat, Stonetalon Mountains",
	[30] = "Westreach Summit, Thousand Needles",
	[31] = "Shadebough, Feralas",
	[32] = "Theramore, Dustwallow Marsh",
	[33] = "Thal'darah Overlook, Stonetalon Mountains",
	[34] = "Transport, Booty Bay",
	[35] = "Transport, Orgrimmar",
	[36] = "Generic, World Target 001",
	[37] = "Nijel's Point, Desolace",
	[38] = "Shadowprey Village, Desolace",
	[39] = "Gadgetzan, Tanaris",
	[40] = "Gadgetzan, Tanaris",
	[41] = "Feathermoon, Feralas",
	[42] = "Camp Mojache, Feralas",
	[43] = "Aerie Peak, The Hinterlands",
	[44] = "Bilgewater Harbor, Azshara",
	[45] = "Nethergarde Keep, Blasted Lands",
	[46] = "Transport, Southshore",
	[47] = "Transport, Grom'gol",
	[48] = "Bloodvenom Post, Felwood",
	[49] = "Moonglade",
	[50] = "Transport, Menethil Harbor",
	[51] = "Transport, Auberdine",
	[52] = "Everlook, Winterspring",
	[53] = "Everlook, Winterspring",
	[54] = "Transport, Feathermoon",
	[55] = "Brackenwall Village, Dustwallow Marsh",
	[56] = "Stonard, Swamp of Sorrows",
	[57] = "Fishing Village, Teldrassil",
	[58] = "Zoram'gar Outpost, Ashenvale",
	[59] = "Dun Baldar, Alterac Valley",
	[60] = "Frostwolf Keep, Alterac Valley",
	[61] = "Splintertree Post, Ashenvale",
	[62] = "Nighthaven, Moonglade",
	[63] = "Nighthaven, Moonglade",
	[64] = "Talrendis Point, Azshara",
	[65] = "Talonbranch Glade, Felwood",
	[66] = "Chillwind Camp, Western Plaguelands",
	[67] = "Light's Hope Chapel, Eastern Plaguelands",
	[68] = "Light's Hope Chapel, Eastern Plaguelands",
	[69] = "Moonglade",
	[70] = "Flame Crest, Burning Steppes",
	[71] = "Morgan's Vigil, Burning Steppes",
	[72] = "Cenarion Hold, Silithus",
	[73] = "Cenarion Hold, Silithus",
	[74] = "Thorium Point, Searing Gorge",
	[75] = "Thorium Point, Searing Gorge",
	[76] = "Revantusk Village, The Hinterlands",
	[77] = "Vendetta Point, Southern Barrens",
	[78] = "Naxxramas",
	[79] = "Marshal's Stand, Un'Goro Crater",
	[80] = "Ratchet, Northern Barrens",
	[81] = "Filming",
	[82] = "Silvermoon City",
	[83] = "Tranquillien, Ghostlands",
	[84] = "Plaguewood Tower, Eastern Plaguelands",
	[85] = "Northpass Tower, Eastern Plaguelands",
	[86] = "Eastwall Tower, Eastern Plaguelands",
	[87] = "Crown Guard Tower, Eastern Plaguelands",
	[88] = "Transport, Exodar",
	[89] = "Transport, Theramore",
	[90] = "Transport, Undercity",
	[91] = "Quest - Azuremyst Shaman Target",
	[92] = "Quest - Azuremyst Shaman Start",
	[93] = "Blood Watch, Bloodmyst Isle",
	[94] = "The Exodar",
	[95] = "Zangarmarsh - Quest - As the Crow Flies",
	[96] = "Zangarmarsh - Quest - As the Crow Flies - End",
	[97] = "Quest - Elekk Path to Kessel",
	[98] = "Quest - Elekk to Kessel Target",
	[99] = "Thrallmar, Hellfire Peninsula",
	[100] = "Honor Hold, Hellfire Peninsula",
	[101] = "Temple of Telhamat, Hellfire Peninsula",
	[102] = "Falcon Watch, Hellfire Peninsula",
	[103] = "Nagrand - PvP - Attack Run Start 1",
	[104] = "Nagrand - PvP - Attack Run End 1",
	[105] = "Nagrand - PvP - Attack Run Start 2",
	[106] = "Nagrand - PvP - Attack Run End 2",
	[107] = "Nagrand - PvP - Attack Run Start 3",
	[108] = "Nagrand - PvP - Attack Run End 3",
	[109] = "Nagrand - PvP - Attack Run Start 4",
	[110] = "Nagrand - PvP - Attack Run End 4",
	[111] = "Eversong - Duskwither Teleport",
	[112] = "Eversong - Duskwither Teleport End",
	[113] = "Quest - Nethrandamus Start",
	[114] = "Quest - Nethrandamus End Target",
	[115] = "Quest - Caverns of Time OH - Begin",
	[116] = "Quest - Caverns of Time OH - End",
	[117] = "Telredor, Zangarmarsh",
	[118] = "Zabra'jin, Zangarmarsh",
	[119] = "Telaar, Nagrand",
	[120] = "Garadar, Nagrand",
	[121] = "Allerian Stronghold, Terokkar Forest",
	[122] = "Area 52, Netherstorm",
	[123] = "Shadowmoon Village, Shadowmoon Valley",
	[124] = "Wildhammer Stronghold, Shadowmoon Valley",
	[125] = "Sylvanaar, Blade's Edge Mountains",
	[126] = "Thunderlord Stronghold, Blade's Edge Mountains",
	[127] = "Stonebreaker Hold, Terokkar Forest",
	[128] = "Shattrath, Terokkar Forest",
	[129] = "Hellfire Peninsula, The Dark Portal",
	[130] = "Hellfire Peninsula, The Dark Portal",
	[131] = "Quest - Horde Hellfire Start",
	[132] = "Quest - Horde Hellfire End",
	[133] = "Quest - Hellfire Peninsula (Alliance Path) Start",
	[134] = "Quest - Hellfire Peninsula (Alliance) End",
	[135] = "Quest - Hellfire, Aerial Mission (Horde) Start",
	[136] = "Quest - Hellfire, Aerial Mission (Horde) End",
	[137] = "Quest - Hellfire, Aerial Mission (Alliance) Start",
	[138] = "Quest - Hellfire, Aerial Mission (Alliance) End",
	[139] = "The Stormspire, Netherstorm",
	[140] = "Altar of Sha'tar, Shadowmoon Valley",
	[141] = "Spinebreaker Ridge, Hellfire Peninsula",
	[142] = "Hellfire Peninsula - Reaver's Fall",
	[143] = "Quest - Caverns of Time (Intro Flight Path) (End)",
	[144] = "Quest - Caverns of Time (Intro Flight Path) (Start)",
	[145] = "Quest - Netherstorm - Stealth Flight - Begin",
	[146] = "Quest - Netherstorm - Stealth Flight - End",
	[147] = "Hellfire Peninsula - Force Camp Beach Head",
	[148] = "Shatter Point, Hellfire Peninsula (Beach Assault)",
	[149] = "Shatter Point, Hellfire Peninsula",
	[150] = "Cosmowrench, Netherstorm",
	[151] = "Swamprat Post, Zangarmarsh",
	[152] = "Quest - Netherstorm - Manaforge Ultris (Start)",
	[153] = "Quest - Netherstorm - Manaforge Ultris (End)",
	[154] = "Quest - Netherstorm - Manaforge Ultris (Second Pass) Start",
	[155] = "Quest - Netherstorm - Manaforge Ultris (Second Pass) End",
	[156] = "Toshley's Station, Blade's Edge Mountains",
	[157] = "Quest - Blade's Edge - Vision Guide - Start",
	[158] = "Quest - Blade's Edge - Vision Guide - End",
	[159] = "Sanctum of the Stars, Shadowmoon Valley",
	[160] = "Evergrove, Blade's Edge Mountains",
	[161] = "Quest - Nether Dragon Ally - Start",
	[162] = "Quest - Nether Dragon Ally - End",
	[163] = "Mok'Nathal Village, Blade's Edge Mountains",
	[164] = "Orebor Harborage, Zangarmarsh",
	[165] = "Transport, Northrend 2",
	[166] = "Emerald Sanctuary, Felwood",
	[167] = "Forest Song, Ashenvale",
	[168] = "Filming",
	[169] = "Quest - Netherwing Ledge - Mine Cart Ride - South - Start",
	[170] = "Quest - Netherwing Ledge - Mine Cart Ride - South - End",
	[171] = "Skettis",
	[172] = "Ogri'La",
	[173] = "Quest - Yarzill Flight Start",
	[174] = "Quest - Yarzill Flight Start End",
	[175] = "Transport, Howling Fjord",
	[176] = "Quest - Howling Fjord Tauren Canoe (Start)",
	[177] = "Quest - Howling Fjord Tauren Canoe (End)",
	[178] = "Transport, Borean Tundra",
	[179] = "Mudsprocket, Dustwallow Marsh",
	[180] = "Quest - Dustwallow - Alcaz Survey Start",
	[181] = "Quest - Dustwallow - Alcaz Survey End",
	[182] = "Quest - Howling Fjord - Break the Blockade Zeppelin",
	[183] = "Valgarde Port, Howling Fjord",
	[184] = "Fort Wildervar, Howling Fjord",
	[185] = "Westguard Keep, Howling Fjord",
	[186] = "Quest - Howling Fjord - Flight to the Windrunner - Start",
	[187] = "Quest - Howling Fjord - Flight to the Windrunner - End",
	[188] = "Quest - Howling Fjord - Test at Sea - Start",
	[189] = "Quest - Howling Fjord - Test at Sea - End",
	[190] = "New Agamand, Howling Fjord",
	[191] = "Vengeance Landing, Howling Fjord",
	[192] = "Camp Winterhoof, Howling Fjord",
	[193] = "Quest - Howling Fjord - Mission: Plague This! - End",
	[194] = "Quest - Howling Fjord - Mission: Plague This! - Start",
	[195] = "Rebel Camp, Stranglethorn Vale",
	[196] = "Test - SP",
	[197] = "Test SP2",
	[198] = "Test SP1",
	[199] = "Quest - Howling Fjord - McGoyver Start",
	[200] = "Quest - Howling Fjord - McGoyver End",
	[201] = "Development Land - Kyle Radue Start",
	[202] = "Development Land - Kyle Radue End",
	[203] = "Quest - Stars' Rest -> Wintergarde",
	[204] = "Quest - New Agamand -> Venomspite",
	[205] = "Zul'Aman, Ghostlands",
	[206] = "Transport, Feathermoon (NE Ship)",
	[207] = "Quest - Howling Fjord - Sister Mercy (Start)",
	[208] = "Quest - Howling Fjord - Sister Mercy (End)",
	[209] = "Quest - Sunwell Daily - Dead Scar Bombing - Start",
	[210] = "Quest - Sunwell Daily - Dead Scar Bombing - End",
	[211] = "Quest - Sunwell Daily - Ship Bombing - Start",
	[212] = "Quest - Sunwell Daily - Ship Bombing - End",
	[213] = "Shattered Sun Staging Area",
	[214] = "Quest - Howling Fjord - Naglfar (Start)",
	[215] = "Quest - Howling Fjord - Naglfar (Nodes)",
	[218] = "Transport, Howling Fjord (Gondola, Top)",
	[219] = "Transport, Howling Fjord (Gondola, Bottom)",
	[221] = "Amber Ledge, Borean (To Beryl)",
	[222] = "Beryl Point, Borean",
	[223] = "Quest - Naglevar",
	[224] = "Borean Tundra, Naglevar",
	[225] = "Amber Ledge, Borean (to Coldarra)",
	[226] = "Transitus Shield, Coldarra",
	[227] = "Transport, PattyMacDevTest",
	[228] = "Development Land - Pat Test Start",
	[229] = "Development Land - Pat Test End",
	[230] = "Transport, Tuskarr 01",
	[231] = "Transport, Tuskarr 02",
	[232] = "Borean Tundra - Warsong Hold Wolf Start",
	[233] = "Borean Tundra - Warsong Hold Wolf End",
	[234] = "Coldarra Ledge, Coldarra",
	[235] = "Transitus Shield, Coldarra (NOT USED)",
	[236] = "Coldarra, Keristrasza to Malygos",
	[237] = "Coldarra, Keristrasza Landing",
	[239] = "Borean Tundra - Quest - Dusk Start",
	[240] = "Borean Tundra - Quest - Dusk - End",
	[241] = "Transport, Valiance Keep",
	[242] = "Quest - Dragonblight - Spiritual Vision - Begin",
	[243] = "Quest - Dragonblight - Spiritual Vision - End",
	[244] = "Wintergarde Keep, Dragonblight",
	[245] = "Valiance Keep, Borean Tundra",
	[246] = "Fizzcrank Airstrip, Borean Tundra",
	[247] = "Stars' Rest, Dragonblight",
	[248] = "Apothecary Camp, Howling Fjord",
	[249] = "Camp Oneqwah, Grizzly Hills",
	[250] = "Conquest Hold, Grizzly Hills",
	[251] = "Fordragon Hold, Dragonblight",
	[252] = "Wyrmrest Temple, Dragonblight",
	[253] = "Amberpine Lodge, Grizzly Hills",
	[254] = "Venomspite, Dragonblight",
	[255] = "Westfall Brigade, Grizzly Hills",
	[256] = "Agmar's Hammer, Dragonblight",
	[257] = "Warsong Hold, Borean Tundra",
	[258] = "Taunka'le Village, Borean Tundra",
	[259] = "Bor'gorok Outpost, Borean Tundra",
	[260] = "Kor'kron Vanguard, Dragonblight",
	[261] = "Quest - Stars' Rest to Wintergarde End",
	[262] = "Grizzly Hills, Alliance Log Ride Start 01",
	[263] = "Grizzly Hills, Alliance Log Ride End 01",
	[264] = "Transport, Auberdine (NEW)",
	[265] = "Transport, Theramore (NEW)",
	[266] = "Transport, Menethil (NEW)",
	[267] = "Grizzly Hills, Alliance Log Ride Start",
	[268] = "Grizzly Hills, Alliance Log Ride End",
	[269] = "Quest - Westguard Keep to Wintergarde Keep Begin",
	[270] = "Quest - Westguard Keep to Wintergarde Keep End",
	[271] = "Grizzly Hills, Horde Log Ride Start",
	[272] = "Grizzly Hills, Horde Log Ride End",
	[273] = "Wyrmrest Temple - bottom to top, Dragonblight - Begin",
	[274] = "Wyrmrest Temple - bottom to top, Dragonblight - End",
	[275] = "Wyrmrest Temple - top to bottom, Dragonblight - Begin",
	[276] = "Wyrmrest Temple - top to bottom, Dragonblight - End",
	[277] = "Wyrmrest Temple - top to middle, Dragonblight - Begin",
	[278] = "Wyrmrest Temple - top to middle, Dragonblight - End",
	[279] = "Wyrmrest Temple - middle to top, Dragonblight - End",
	[280] = "Wyrmrest Temple - middle to top, Dragonblight - Begin",
	[281] = "Wyrmrest Temple - middle to bottom, Dragonblight - End",
	[282] = "Wyrmrest Temple - middle to bottom, Dragonblight - Begin",
	[283] = "Wyrmrest Temple - bottom to middle, Dragonblight - End",
	[284] = "Wyrmrest Temple - bottom to middle, Dragonblight - Begin",
	[285] = "Quest - Wintergarde -> Stars' Rest (Start)",
	[286] = "Quest - Wintergarde -> Stars' Rest (End)",
	[287] = "Quest - Valgarde -> Westguard Keep Start",
	[288] = "Quest - Valgarde -> Westguard Keep End",
	[289] = "Amber Ledge, Borean Tundra",
	[290] = "Argent Stand, Zul'Drak",
	[291] = "Ruined City Post 01, Zul'Drak",
	[292] = "Flavor - Stormwind Harbor  - Start",
	[293] = "Flavor - Stormwind Harbor - Stop",
	[294] = "Moa'ki, Dragonblight",
	[295] = "Kamagua, Howling Fjord",
	[296] = "Unu'pe, Borean Tundra",
	[297] = "Sholazar Basin - Quest - Reconnaisance - Start",
	[298] = "Sholazar Basin - Quest - Reconnaisance - End",
	[299] = "Transport: Menethil <-> Valgarde",
	[300] = "Transport, Stormwind",
	[301] = "Quest - Borean Tundra - Check In With Bixie - Begin",
	[302] = "Quest - Borean Tundra - Check In With Bixie - End",
	[303] = "Valiance Landing Camp, Wintergrasp",
	[304] = "The Argent Stand, Zul'Drak",
	[305] = "Ebon Watch, Zul'Drak",
	[306] = "Light's Breach, Zul'Drak",
	[307] = "Zim'Torga, Zul'Drak",
	[308] = "River's Heart, Sholazar Basin",
	[309] = "Nesingwary Base Camp, Sholazar Basin",
	[310] = "Dalaran",
	[311] = "Camp Onequah, Grizzly Hills (Quest)",
	[312] = "Light's Breach, Zul'Drak (Quest)",
	[313] = "Westfall Brigade, Grizzly Hills (Quest)",
	[314] = "Zim'Torga, Zul'Drak (Quest)",
	[315] = "Acherus: The Ebon Hold",
	[316] = "Ebon Hold - Acherus -> Death's Breach Start",
	[317] = "Ebon Hold - Acherus -> Death's Breach End",
	[318] = "Ebon Hold - Death's Breach -> Acherus Start",
	[319] = "Ebon Hold - Death's Breach -> Acherus End",
	[320] = "K3, The Storm Peaks",
	[321] = "Frosthold, The Storm Peaks",
	[322] = "Dun Niffelem, The Storm Peaks",
	[323] = "Grom'arsh Crash-Site, The Storm Peaks",
	[324] = "Camp Tunka'lo, The Storm Peaks",
	[325] = "Death's Rise, Icecrown",
	[326] = "Ulduar, The Storm Peaks",
	[327] = "Bouldercrag's Refuge, The Storm Peaks",
	[328] = "Transport, Icecrown Airship (A)",
	[329] = "Transport, Icecrown Airship (H)",
	[330] = "Transport, Icecrown (Target)",
	[331] = "Gundrak, Zul'Drak",
	[332] = "Warsong Camp, Wintergrasp",
	[333] = "The Shadow Vault, Icecrown",
	[334] = "The Argent Vanguard, Icecrown",
	[335] = "Crusaders' Pinnacle, Icecrown",
	[336] = "Windrunner's Overlook, Crystalsong Forest",
	[337] = "Sunreaver's Command, Crystalsong Forest",
	[338] = "Blackfathom Camp, Ashenvale",
	[339] = "Grove of the Ancients, Darkshore",
	[340] = "Argent Tournament Grounds, Icecrown",
	[341] = "Ulduar Raid - Interior - Insertion Point",
	[342] = "Ulduar Raid - Iron Concourse",
	[343] = "Splintertree, Ashenvale",
	[344] = "Quest - Splintertree  Post -> Zoramgar",
	[345] = "Quest - Zoramgar, Ashenvale",
	[346] = "Ashenvale 4.x, Azshara to Mor'shan Ramparts",
	[347] = "Ashenvale 4.x, Mor'shan Landing",
	[348] = "Transport: Thunder Bluff <-> Org (Zep)",
	[349] = "Andruk, Zoram'gar",
	[350] = "Hellscream's Watch, Ashenvale",
	[351] = "Stardust Spire, Ashenvale",
	[352] = "Isle of Conquest - Gunships",
	[354] = "The Mor'Shan Ramparts, Ashenvale",
	[356] = "Silverwind Refuge, Ashenvale",
	[358] = "Quest - Icecrown - North Sea Kraken Bombing - Start",
	[359] = "Quest - Icecrown - North Sea Kraken Bombing - End",
	[360] = "Cliffwalker Post, Stonetalon Mountains",
	[361] = "Windshear Hold, Stonetalon Mountains",
	[362] = "Krom'gar Fortress, Stonetalon Mountains",
	[363] = "Malaka'jin, Stonetalon Mountains",
	[364] = "Northwatch Expedition Base Camp, Stonetalon Mountains",
	[365] = "Farwatcher's Glen, Stonetalon Mountains",
	[366] = "Furien's Post, Desolace",
	[367] = "Thargad's Camp, Desolace",
	[368] = "Karnum's Glade, Desolace",
	[369] = "Thunk's Abode, Desolace",
	[370] = "Ethel Rethor, Desolace",
	[371] = "Vashj'ir - Alliance Start",
	[372] = "Vashj'ir - Alliance End",
	[373] = "Mulgore - Red Cloud Mesa: To Bloodhoof",
	[374] = "Mulgore - Red Cloud Mesa: To Bloodhoof (End)",
	[375] = "Transport, Gadgetzan",
	[376] = "Icecrown Raid - Airship Battle Taxi Paths",
	[377] = "Icecrown Dungeon - Gunships",
	[378] = "Quest - Dun Morogh - Coldridge Valley - Pack Your Bags End",
	[379] = "Icecrown Raid - Saurfang's Ship (End)",
	[380] = "Icecrown Raid - Saurfang's Ship (Start)",
	[381] = "Quest [Transport] Icecrown Raid - Saurfang Ship (START)",
	[382] = "Quest [Transport] Icecrown Raid - Saurfang Ship (END)",
	[383] = "Thondroril River, Eastern Plaguelands",
	[384] = "The Bulwark, Tirisfal",
	[386] = "Mossy Pile, Un'Goro Crater",
	[387] = "Honor's Stand, Southern Barrens",
	[388] = "Northwatch Hold, Southern Barrens",
	[389] = "Fort Triumph, Southern Barrens",
	[390] = "Hunter's Hill, Southern Barrens",
	[391] = "Desolation Hold, Southern Barrens",
	[392] = "CC Prologue - GT - Quest - Vent Horizon - Start",
	[393] = "CC Prologue - GT - Quest - Vent Horizon - End",
	[394] = "CC Prologue - GT - Battle Flight - Start",
	[395] = "CC Prologue - GT - Battle Flight - End",
	[402] = "Bloodhoof Village, Mulgore",
	[404] = "Durotar - ET - CC Prologue Spy Frog Start",
	[405] = "Durotar - ET - CC Prologue Spy Frog End",
	[413] = "Quest - 'To The Summit' - Westreach Summit - End",
	[414] = "Quest - 'To The Summit' - Camp Mojache -> Westreach Summit - Begin",
	[429] = "Quest - 'To The Summit' - Mudsprocket -> Westreach Summit - Begin",
	[433] = "Quest - 'To New Thalanaar' - Mudsprocket -> New Thalanaar - Begin",
	[434] = "Quest - 'To New Thalanaar' - New Thalanaar - End",
	[436] = "Quest - 'To New Thalanaar' - Shadebough -> New Thalanaar - Begin",
	[438] = "Durotar - ET - CC Prologue Troll Taxi Bat Start",
	[439] = "Durotar - ET - CC Prologue Troll Recruit End",
	[440] = "Durotar - ET - CC Prologue - Troll Battle End",
	[456] = "Dolanaar, Teldrassil",
	[457] = "Darnassus, Teldrassil",
	[458] = "Nozzlepot's Outpost, Northern Barrens",
	[460] = "Brill, Tirisfal Glades",
	[509] = "Quest Path 2063: Brian's 4.0 Test Path",
	[513] = "Fizzle & Pozzik's Speedbarge, Thousand Needles",
	[521] = "Smuggler's Scar, Vashj'ir",
	[522] = "Silver Tide Hollow, Vashj'ir",
	[523] = "Tranquil Wash, Vashj'ir",
	[524] = "Darkbreak Cove, Vashj'ir",
	[525] = "Legion's Rest, Vashj'ir",
	[526] = "Tenebrous Cavern, Vashj'ir",
	[531] = "Dawnrise Expedition, Tanaris",
	[532] = "Gunstan's Dig, Tanaris",
	[536] = "Sen'jin Village, Durotar",
	[537] = "Razor Hill, Durotar",
	[538] = "test - JZB - Orgrim's Hammer",
	[539] = "Bootlegger Outpost, Tanaris",
	[540] = "The Sludgewerks, Stonetalon Mountains",
	[541] = "Mirkfallon Post, Stonetalon Mountains",
	[551] = "Whelgar's Retreat, Wetlands",
	[552] = "Greenwarden's Grove, Wetlands",
	[553] = "Dun Modr, Wetlands",
	[554] = "Slabchisel's Survey, Wetlands",
	[555] = "Farstrider Lodge, Loch Modan",
	[557] = "Shrine of Aviana, Hyjal",
	[558] = "Grove of Aessina, Hyjal",
	[559] = "Nordrassil, Hyjal",
	[560] = "Quest Path 2171: [3.x] Transport, Org -> Undercity (Thundercaller)",
	[561] = "Quest Path 2172: [3.x] Transport, Thunder Bluff -> Org (Zephyr)",
	[562] = "Quest Path 2173: [3.x] Transport, Borean Tundra -> Org (Mighty Wind)",
	[563] = "Quest Path 2174: [3.x] Transport, Grom'gol -> Orgrimmar (The Iron Eagle)",
	[564] = "Quest Path 2175: Stonetalon 4.x - Taxi to Thal'darah Overlook Start",
	[565] = "Dreamer's Rest, Feralas",
	[567] = "Tower of Estulan, Feralas",
	[568] = "Camp Ataya, Feralas",
	[569] = "Stonemaul Hold, Feralas",
	[574] = "Quest Path 2201: Dun Morogh - Quest - Flight to Ironforge Airfield",
	[575] = "Quest Path 2203: Dun Morogh - Quest - Striking Back (Bombing Run)",
	[577] = "Quest Path 2206: Ironforge, Dun Morogh - Quest - Breadcrumb to Loch Modan",
	[578] = "Quest Path 2207: Dun Morogh - Quest - Flight to Gol'Bolar from Ironforge Airfield",
	[582] = "Goldshire, Elwynn",
	[583] = "Moonbrook, Westfall",
	[584] = "Furlbrow's Pumpkin Farm, Westfall",
	[585] = "Quest Path 293: Transport, Auberdine -> Rut'theran Village, Teldrassil (NO LONGER USED in 4.x)",
	[586] = "Justin Test Node 1",
	[587] = "Justin Test Node 2",
	[589] = "Eastvale Logging Camp, Elwynn",
	[590] = "Fort Livingston, Stranglethorn",
	[591] = "Explorers' League Digsite, Stranglethorn",
	[592] = "Hardwrench Hideaway, Stranglethorn",
	[593] = "Bambala, Stranglethorn",
	[594] = "Whisperwind Grove, Felwood",
	[595] = "Wildheart Point, Felwood",
	[596] = "Shalewind Canyon, Redridge",
	[597] = "Irontree Clearing, Felwood",
	[598] = "Marshtide Watch, Swamp of Sorrows",
	[599] = "Bogpaddle, Swamp of Sorrows",
	[600] = "The Harborage, Swamp of Sorrows",
	[601] = "Galen's Fall, Arathi",
	[602] = "Surwich, Blasted Lands",
	[603] = "Sunveil Excursion, Blasted Lands",
	[604] = "Dreadmaul Hold, Blasted Lands",
	[605] = "Voldrin's Hold, Vashj'ir",
	[606] = "Sandy Beach, Vashj'ir",
	[607] = "Sandy Beach, Vashj'ir",
	[608] = "Sandy Beach, Vashj'ir",
	[609] = "Sandy Beach, Vashj'ir",
	[610] = "Stygian Bounty, Vashj'ir",
	[611] = "Voldrin's Hold, Vashj'ir",
	[612] = "Stygian Bounty, Vashj'ir",
	[613] = "Southern Rocketway, Azshara",
	[614] = "Northern Rocketway, Azshara",
	[615] = "Camp Everstill, Redridge",
	[616] = "Gates of Sothann, Hyjal",
	[617] = "Hiri'watha Research Station, The Hinterlands",
	[618] = "Stormfeather Outpost, The Hinterlands",
	[619] = "Kharanos, Dun Morogh",
	[620] = "Gol'Bolar Quarry, Dun Morogh",
	[621] = "Quest Path 2367: QA's Test Path 1",
	[622] = "Raven Hill, Duskwood",
	[623] = "Quest Path 2374: Deeopholm Test Copy",
	[624] = "Azure Watch, Azuremyst Isle",
	[625] = "Fairbreeze Village, Eversong Woods",
	[626] = "Quest Path 508: zzzThe Exodar -> Blood Watch, Bloodmyst Isle",
	[627] = "Quest Path 2376: zzzThe Exodar -> Azure Watch, Azuremyst Isle",
	[628] = "Quest Path 507: zzzBlood Watch, Bloodmyst Isle -> The Exodar",
	[629] = "Quest Path 2375: zzzAzure Watch, Azuremyst Isle -> The Exodar",
	[630] = "Light's Shield Tower, Eastern Plaguelands",
	[631] = "Falconwing Square, Eversong Woods",
	[632] = "Bloodwatcher Point, Badlands",
	[633] = "Dustwind Dig, Badlands",
	[634] = "Dragon's Mouth, Badlands",
	[635] = "Fuselight, Badlands",
	[645] = "Forsaken High Command, Silverpine Forest",
	[646] = "Forsaken Forward Command, Gilneas",
	[649] = "Andorhal, Western Plaguelands",
	[650] = "Andorhal, Western Plaguelands",
	[651] = "The Menders' Stead, Western Plaguelands",
	[652] = "Ramkahen, Uldum",
	[653] = "Oasis of Vir'sar, Uldum",
	[654] = "The Forsaken Front, Silverpine Forest",
	[656] = "Crushblow, Twilight Highlands",
	[657] = "The Gullet, Twilight Highlands",
	[658] = "Vermillion Redoubt, Twilight Highlands",
	[659] = "Bloodgulch, Twilight Highlands",
	[660] = "The Krazzworks, Twilight Highlands",
	[661] = "Dragonmaw Port, Twilight Highlands",
	[662] = "Highbank, Twilight Highlands",
	[663] = "Victor's Point, Twilight Highlands",
	[664] = "Firebeard's Patrol, Twilight Highlands",
	[665] = "Thundermar, Twilight Highlands",
	[666] = "Kirthaven, Twilight Highlands",
	[667] = "Ruins of Southshore, Hillsbrad",
	[668] = "Southpoint Gate, Hillsbrad",
	[669] = "Eastpoint Tower, Hillsbrad",
	[670] = "Strahnbrad, Alterac Mountains",
	[672] = "Hearthglen, Western Plaguelands",
	[673] = "Iron Summit, Searing Gorge",
	[674] = "Schnottz's Landing, Uldum",
	[675] = "Flamestar Post, Burning Steppes",
	[676] = "Chiselgrip, Burning Steppes",
	[681] = "Forsaken Rear Guard, Silverpine Forest",
	[682] = "Quest Path 1843: Transport - Gadgetzan to ??? JZB RVM Test [DISABLED]",
	[683] = "Valormok, Azshara",
	[728] = "Quest Path 2653: 4.1 - ZG Event - Rebel Camp -> Explorers' League",
	[757] = "Quest Path 2695: PattyMac Taxi Path Speed Test",
	[781] = "Sanctuary of Malorne, Hyjal",
	[888] = "Quest Path 2837: Quest - Jade Forest: (DLA) - Dawnblossom to Jade Mines",
	[894] = "Grookin Hill, Jade Forest",
	[895] = "Dawn's Blossom, Jade Forest",
	[906] = "Dragon Soul Raid - Wyrmrest Temple Base",
	[907] = "Dragon Soul Raid - East Sarlac",
	[918] = "Quest Path 2954: Quest - Valley of the Four Winds (Flyback: Chen A) PRK",
	[919] = "Quest Path 2955: Quest - Valley of the Four Winds (Flyback: Chen B) PRK",
	[920] = "Quest Path 2956: Quest - Valley of the Four Winds (Flyback: Chen C) PRK",
	[921] = "Quest Path 2957: Quest - Valley of the Four Winds (Flyback: Chen D) PRK",
	[922] = "Quest Path 2958: Quest - Valley of the Four Winds (Flyback: Sad Panda A) PRK",
	[923] = "Quest Path 2959: Quest - Valley of the Four Winds (Flyback: Sad Panda B) PRK",
	[924] = "Quest Path 2960: Quest - Valley of the Four Winds (Flyback: Horde A) PRK",
	[925] = "Quest Path 2961: Quest - Valley of the Four Winds (Flyback: Alliance A) PRK",
	[926] = "Quest Path 2962: Quest - Valley of the Four Winds (Flyback: Horde B) PRK",
	[927] = "Quest Path 2963: Quest - Valley of the Four Winds (Flyback: Alliance B) PRK",
	[935] = "Quest Path 2986: Jade Forest: -hmc (Taxi: Glassfin Village to Dawnblossom)",
	[949] = "Quest Path 3002: Jade Forest: -hmc (Taxi: Serpent's Spine to Statue Top)",
	[950] = "Quest Path 3003: Jade Forest: -hmc (Taxi: Statue Top to Serpent's Spine)",
	[951] = "Quest Path 3004: Quest - Jade Forest - Fort Grookin -> Ka Pao Rise",
	[963] = "Quest Path 3018: Quest - Jade Forest - Glassfin Village -> Ka Pao Rise",
	[966] = "Paw'Don Village, Jade Forest",
	[967] = "The Arboretum, Jade Forest",
	[968] = "Jade Temple Grounds, Jade Forest",
	[969] = "Sri-La Village, Jade Forest",
	[970] = "Emperor's Omen, Jade Forest",
	[971] = "Tian Monastery, Jade Forest",
	[972] = "Pearlfin Village, Jade Forest",
	[973] = "Honeydew Village, Jade Forest",
	[984] = "Pang's Stead, Valley of the Four Winds",
	[985] = "Halfhill, Valley of the Four Winds",
	[986] = "Zhu's Watch, Krasarang Wilds",
	[987] = "Thunder Cleft, Krasarang Wilds",
	[988] = "The Incursion, Krasarang Wilds",
	[989] = "Stoneplow, Valley of the Four Winds",
	[990] = "Dawnchaser Retreat, Krasarang Wilds",
	[991] = "Sentinel Basecamp, Krasarang Wilds",
	[992] = "Cradle of Chi-Ji, Krasarang Wilds",
	[993] = "Marista, Krasarang Wilds",
	[998] = "Quest Path 3154: Quest - Kun-Lai Summit - Neverrest Peak -> Valley of Emperors",
	[1009] = "Quest Path 3173: Quest - Kun-Lai Summit - Valley -> Whispercloud Rise",
	[1016] = "Quest Path 3066: Quest - Jade Forest - Serpent's Spine -> VotFW - JLR",
	[1017] = "Binan Village, Kun-Lai Summit",
	[1018] = "Temple of the White Tiger, Kun-Lai Summit",
	[1019] = "Eastwind Rest, Kun-Lai Summit",
	[1020] = "Westwind Rest, Kun-Lai Summit",
	[1021] = "Zouchin Village, Kun-Lai Summit",
	[1022] = "One Keg, Kun-Lai Summit",
	[1023] = "Kota Basecamp, Kun-Lai Summit",
	[1024] = "Shado-Pan Fallback, Kun-Lai Summit",
	[1025] = "Winter's Blossom, Kun-Lai Summit",
	[1029] = "Tavern in the Mists, The Veiled Stair",
	[1030] = "Quest Path 3244: Jade Forest: -hmc (Taxi: Serpent's Spine to East Temple)",
	[1032] = "Quest Path 3246: Quest - Kun-Lai Summit - GoWB - To the Wall! (NLC)",
	[1038] = "Quest Path 3248: Quest - Kun-Lai Summit - GoWB - Back from the Wall (NLC)",
	[1046] = "Jade Forest - Cliff path 04 Start",
	[1047] = "Jade Forest - Cliff path 04 End",
	[1048] = "Quest Path 3263: Jade forest - Cliff path 04",
	[1049] = "Quest Path 3264: Jade Forest - Cliff Path 01",
	[1050] = "Quest Path 3265: Jade Forest - Cliff Path 02",
	[1051] = "Quest Path 3266: Jade Forest - Cliff Path 03",
	[1052] = "Grassy Cline, Valley of the Four Winds",
	[1053] = "Longying Outpost, Townlong Steppes",
	[1054] = "Gao-Ran Battlefront, Townlong Steppes",
	[1055] = "Rensai's Watchpost, Townlong Steppes",
	[1056] = "Shado-Pan Garrison, Townlong Steppes",
	[1057] = "Shrine of Seven Stars, Vale of Eternal Blossoms",
	[1058] = "Shrine of Two Moons, Vale of Eternal Blossoms",
	[1070] = "Klaxxi'vess, Dread Wastes",
	[1071] = "Soggy's Gamble, Dread Wastes",
	[1072] = "The Sunset Brewgarden, Dread Wastes",
	[1073] = "Serpent's Spine, Vale of Eternal Blossoms",
	[1076] = "Quest Path 3375: Jade Forest: JSB - East Temple -> Grookin' Hill",
	[1079] = "Quest Path 3377: Jade Forest: JSB - East Temple -> Glassfin Village",
	[1080] = "Serpent's Overlook, Jade Forest",
	[1090] = "The Briny Muck, Dread Wastes",
	[1091] = "Quest Path 3448: Dread Wastes: Klaxxi'vess -> Briny Muck Quest Path",
	[1092] = "Quest Path 3449: Dread Wastes: Klaxxi'vess -> Lake of Stars Quest Path",
	[1104] = "Test - Spy Quest H01a - PRK",
	[1105] = "Test - Spy Quest H01b - PRK",
	[1114] = "Quest Path 3481: Quest - Kun-Lai Summit: JLR - Zouchin Village -> Isle of Reckoning",
	[1115] = "The Lion's Redoubt, Dread Wastes",
	[1116] = "Quest Path 3482: Quest - Kun-Lai Summit: JLR - Isle of Reckoning - Zouchin",
	[1117] = "Serpent's Spine, Kun-Lai Summit",
	[1130] = "Quest Path 3506: Jade Forest: -hmc (Taxi: Serpent's Spine to Statue Top) NEW (Tab 870)",
	[1131] = "Quest Path 3507: Jade Forest: -hmc (Taxi: Statue Top to Serpent's Spine) NEW (Tab 870)",
	[1190] = "Lion's Landing, Krasarang Wilds",
	[1195] = "Domination Point, Krasarang Wilds",
	[1221] = "Beeble's Wreck, Isle Of Giants",
	[1222] = "Bozzle's Wreck, Isle Of Giants",
	[1284] = "Quest Path 3877: Garrosh Raid - Siege Engineer - Pipe Transfer",
	[1291] = "Quest Path 3885: Timeless Isle 5.4 - Vignette - Source of Water - Bubble Up (RKS) [REUSEME]",
	[1292] = "Quest Path 3886: Timeless Isle 5.4 - Vignette - Source of Water - Bubble Down (RKS) [REUSEME]",
	[1293] = "Tushui Landing, Timeless Isle",
	[1294] = "Huojin Landing, Timeless Isle",
	[1350] = "Shadowmoon Valley 6.0 - Observatory (JP3)",
	[1351] = "Shadowmoon Valley 6.0 - Ironhorde POI (JP3)",
	[1381] = "Embaari Village, Shadowmoon Valley",
	[1382] = "Twilight Glade, Shadowmoon Valley",
	[1383] = "Path of the Light, Shadowmoon Valley",
	[1384] = "Exile's Rise, Shadowmoon Valley",
	[1385] = "Arkaat Outpost, Shadowmoon Valley",
	[1386] = "Wor'gol, Frostfire Ridge",
	[1387] = "Bladespire Citadel, Frostfire Ridge",
	[1388] = "Throm'Var, Frostfire Ridge",
	[1389] = "Bloodmaul Slag Mines, Frostfire Ridge",
	[1390] = "Stonefang Outpost, Frostfire Ridge",
	[1394] = "Thunder Pass. Frostfire Ridge",
	[1395] = "Thunder Pass, Frostfire Ridge",
	[1396] = "Darkspear's Edge, Frostfire Ridge",
	[1408] = "Warspear, Ashran",
	[1420] = "Stormshield (Alliance), Ashran",
	[1421] = "Shadowmoon Valley 6.0:Jp3 - Darktide Roost - Bottom Of Hill",
	[1422] = "Shadowmoon Valley 6.0:JP3 - Darktide Roost - Top of Hill",
	[1430] = "Test Loc 1, Talador",
	[1431] = "Test Loc 2, Talador",
	[1432] = "Frostwall Garrison, Frostfire Ridge",
	[1440] = "Zangarra, Talador",
	[1441] = "Frostwolf Overlook, Talador",
	[1442] = "Beastwatch, Gorgrond",
	[1443] = "Vol'jin's Pride, Talador",
	[1445] = "Durotan's Grasp, Talador",
	[1447] = "Fort Wrynn (Alliance), Talador",
	[1448] = "Redemption Rise, Talador",
	[1450] = "Shattrath City, Talador",
	[1451] = "Anchorite's Sojourn, Talador",
	[1452] = "Retribution Point, Talador",
	[1453] = "Exarch's Refuge, Talador",
	[1454] = "Exarch's Refuge, Talador",
	[1462] = "Terokkar Refuge, Talador",
	[1463] = "Quest Path 4263: Draenor Zone Breadcrumb - Frostfire Garrison > Talador Start Loc (CSA)",
	[1464] = "Quest Path 4266: Draenor Zone Breadcrumb - Shadowmoon Garrison > Talador Start Loc (CSA)",
	[1465] = "Quest Path 4269: Draenor Zone Breadcrumb - Shadowmoon Garrison > Nagrand Start Loc (ELM)",
	[1466] = "Quest Path 4270: Draenor Zone Breadcrumb - Frostfire Ridge Garrison > Nagrand Start Loc (ELM)",
	[1467] = "The Draakorium, Shadowmoon Valley",
	[1468] = "Elodor (Alliance), Shadowmoon Valley",
	[1475] = "Socrethar's Rise, Shadowmoon Valley",
	[1476] = "Lunarfall (Alliance), Shadowmoon Valley",
	[1477] = "Quest Path 4316: Frostfire Ridge - Garrison - Max-Level Chapter - Sargerei - Taxi Path to Shadowmoon (HMC)",
	[1487] = "Axefall, Spires of Arak",
	[1488] = "Quest Path 4333: Shadowmoon Valley 6.0:JP3 - Darktide Roost - Taxi Path to Darktide Roost",
	[1489] = "Quest Path 4334: Frostfire Ridge:JP3 - Darktide Roost - Taxi to Darktide Roost",
	[1490] = "Quest Path 4337: Spires of Arak 6.0 - Horde Garrison Outpost > Shadow's Defiance",
	[1493] = "Southport, Spires of Arak",
	[1494] = "Quest Path 4341: Spires of Arak 6.0 - Alliance Garrison Outpost > Shadow's Defiance",
	[1495] = "Quest Path 4342: Shadowmoon Valley 6.0:JP3 - A - Broken Precipice - Taxi Path to Broken Precipice",
	[1496] = "Quest Path 4345: Spires of Arak 6.0 - Shattered Hand Poison Camp > Horde Garrison Outpost",
	[1497] = "Quest Path 4346: Spires of Arak 6.0 - Shattered Hand Poison Camp > Alliance Garrison Outpost",
	[1498] = "Quest Path 4353: Frostfire Ridge:JP3 - Broken Precipice - Taxi to Nagrand / Broken Precipice",
	[1502] = "The Ring of Trials, Nagrand",
	[1503] = "Throne of the Elements, Nagrand",
	[1504] = "Wor'var, Nagrand",
	[1505] = "Riverside Post, Nagrand",
	[1506] = "Telaari Station, Nagrand",
	[1507] = "Yrel's Watch, Nagrand",
	[1508] = "Veil Terokk, Spires of Arak",
	[1509] = "Talon Watch, Spires of Arak",
	[1510] = "Pinchwhistle Gearworks, Spires of Arak",
	[1511] = "Bastion Rise, Gorgrond",
	[1512] = "Bastion Rise, Gorgrond",
	[1513] = "Apexis Excavation, Spires of Arak",
	[1514] = "Evermorn Springs, Gorgrond",
	[1515] = "Crow's Crook, Spires of Arak",
	[1518] = "Wildwood Wash, Gorgrond",
	[1519] = "Highpass, Gorgrond",
	[1520] = "Breaker's Crown, Gorgrond",
	[1523] = "Deeproot, Gorgrond",
	[1524] = "Iron Docks, Gorgrond",
	[1527] = "Quest Path 4442: Spires of Arak: (DLA) - Veil Terokk -> Talon Watch Breadcrumb",
	[1528] = "Iron Siegeworks, Frostfire Ridge",
	[1529] = "Darktide Roost, Shadowmoon Valley",
	[1535] = "Quest Path 4535: Quest Path - Spires of Arak 6.0 - Horde Garrison Outpost > Pinchwhistle Gearworks (LWB)",
	[1536] = "Quest Path 4538: Quest Path - Spires of Arak 6.0 - Alliance Garrison Outpost > Pinchwhistle Gearworks (LWB)",
	[1537] = "Shattered Landing, Blasted Lands",
	[1538] = "Shattered Beachhead, Blasted Lands",
	[1539] = "Skysea Ridge, Gorgrond",
	[1540] = "Quest Path 4579: Talador 6.0 - Zangarra > Khadgar's Tower",
	[1541] = "Quest Path 4580: Talador 6.0 - Khadgar's Tower > Zangarra",
	[1547] = "Quest Path 4590: Shadowmoon Valley 6.0:JP3 - A - Ashran - Taxi Path to Ashran Staging Area",
	[1549] = "Quest Path 4600: Frostfire Ridge:JP3 - Ashran Staging Area - Taxi to Ashran",
	[1550] = "Quest Path 4599: Shadowmoon 6.x - 'The Search for Owynn Graddock': Garrison, Shadowmoon Valley -> Bloodmaul Slag Mines, Frostfire Ridge (HMC)",
	[1553] = "Quest Path 4634: Shadowmoon 6.x - 'Pinchwhistle Gearworks': Garrison, Shadowmoon Valley -> Pinchwhistle Gearworks, Spires of Arak (LWB)",
	[1554] = "Quest Path 4635: Frostfire 6.x - 'Pinchwhistle Gearworks': Garrison, Frostfire ->Pinchwhistle Gearworks, Spires of Arak (LWB)",
	[1555] = "Quest Path 4636: Shadowmoon Valley, Tier 3 Garrison -> Ashran, Stormshield (Shortcut Path) (CSA)",
	[1556] = "Tranquil Court, Shadowmoon Valley",
	[1559] = "Wolf's Stand, Frostfire Ridge",
	[1562] = "Quest Path 4665: Ashran - Lane - Warspear to Stormshield",
	[1563] = "Quest Path 4666: Ashran - Lane - Stormshield to Warspear",
	[1567] = "Temple of Karabor, Shadowmoon Valley",
	[1568] = "Everbloom Wilds, Gorgrond",
	[1569] = "Akeeta's Hovel, Shadowmoon Valley",
	[1572] = "Rilzit's Holdfast, Nagrand",
	[1573] = "Nivek's Overlook, Nagrand",
	[1574] = "Joz's Rylaks, Nagrand",
	[1580] = "Everbloom Overlook, Gorgrond",
	[1581] = "Quest Path 4881: Lunarfall, Shadowmoon Valley -> Terokkar Pass, Spires of Arak",
	[1582] = "Quest Path 4888: Frostwall Garrison, Frostfire Ridge -> Terokkar Pass, Spires of Arak",
	[1599] = "Quest Path 4958: Garrison - 6.1 Chapter - H - Taxi to Iron Docks - JMC",
	[1601] = "Quest Path 4960: Garrison - 6.1 Chapter - H - Taxi from Iron Docks to Garrison - JMC",
	[1605] = "Quest Path 4965: Garrison - 6.1 Chapter - A - Taxi from Garrison to Iron Docks - JMC",
	[1606] = "Quest Path 4966: Garrison - 6.1 Chapter - A - Taxi from Iron Docks to Garrison - JMC",
	[1613] = "Azurewing Repose, Azsuna",
	[1614] = "Quest Path 4974: 6.2 Tanaan - Quest - H - From Vol'mar to Iron Front - JMC",
	[1615] = "Challiane's Terrace, Azsuna",
	[1620] = "Lion's Watch, Tanaan Jungle",
	[1621] = "Vol'mar, Tanaan Jungle",
	[1622] = "Illidari Stand, Azsuna",
	[1625] = "Quest Path 4987: 6.2 Tanaan - Lion's Watch - Taxi Path to Aktar's Post (LWB)",
	[1626] = "Quest Path 4988: 6.2 Tanaan - Volmar - Taxi Path to Aktar's Post (LWB)",
	[1633] = "Shackle's Den, Azsuna",
	[1634] = "Quest Path 5017: 7.0 Azsuna - Rift 01 - East Chasm -> West Chasm",
	[1635] = "Quest Path 5018: 7.0 Azsuna - Rift 01 - West Chasm -> East Chasm",
	[1636] = "Quest Path 5019: 7.0 Azsuna - Rift 02 - Tower -> Rock (ZTO)",
	[1637] = "Quest Path 5020: 7.0 Azsuna - Rift 03, Tower - Base -> Top (ZTO/PRK)",
	[1642] = "Quest Path 5026: 6.2 Tanaan - Quest - A - From Lion's Watch to Iron Front - JMC",
	[1643] = "Aktar's Post, Tanaan Jungle",
	[1644] = "The Iron Front, Tanaan Jungle",
	[1645] = "The Iron Front, Tanaan Jungle",
	[1646] = "Vault of the Earth, Tanaan Jungle",
	[1647] = "Malo's Lookout, Tanaan Jungle",
	[1648] = "Sha'naari Refuge, Tanaan Jungle",
	[1660] = "Bret Test 3-3s",
	[1661] = "Bret Test 3-3e",
	[1662] = "Carl Test a",
	[1673] = "Lorlathil, Val'sharah",
	[1713] = "Bradensbrook, Val'sharah",
	[1716] = "Quest Path 5222: Garrison, Alliance Shipyard -> Tanaan (IGC)",
	[1719] = "Thunder Totem, Highmountain",
	[1722] = "Quest Path 5262: Stormheim: (DLA) - Valdisdall -> Dreadwake (Spell Taxi)",
	[1723] = "Quest Path 5263: Stormheim: (DLA) - Valdisdall -> Greywatch (Spell Taxi)",
	[1729] = "Quest Path 5283: Alliance Garrison (Tier 3) > Alliance Shipyard",
	[1730] = "Quest Path 5284: Alliance Shipyard > Alliance Garrison (Tier 3)",
	[1731] = "Alliance Shipyard Taxi",
	[1732] = "Quest Path 5286: 7.0 DH-Mardum - Illidari Foothold -> The Fel Hammer (ELM)",
	[1738] = "Cullen's Post, Stormheim",
	[1739] = "Dreadwake's Landing, Stormheim",
	[1741] = "Forsaken Foothold, Stormheim",
	[1742] = "Valdisdall, Stormheim",
	[1744] = "Greywatch, Stormheim",
	[1745] = "Lorna's Watch, Stormheim",
	[1747] = "Skyfire Triage Camp, Stormheim",
	[1748] = "Quest Path 5333: 7.0 Artifacts - Monk - Order Formation - Number Nine Flight - LWB",
	[1753] = "Skyhorn, Highmountain",
	[1754] = "The Witchwood, Highmountain",
	[1755] = "Felbane Camp, Highmountain",
	[1756] = "Shipwreck Cove, Highmountain",
	[1758] = "Obsidian Overlook, Highmountain",
	[1759] = "Ironhorn Enclave, Highmountain",
	[1760] = "Trueshot Lodge, Highmountain",
	[1761] = "Prepfoot, Highmountain",
	[1764] = "Starsong Refuge, Val'sharah",
	[1766] = "Garden of the Moon, Val'sharah",
	[1767] = "Nesingwary, Highmountain",
	[1774] = "Dalaran",
	[1777] = "Sylvan Falls, Highmountain",
	[1778] = "Stonehoof Watch, Highmountain",
	[1783] = "Quest Path 5500: 7.0 Azsuna - Rift 02 - Rock -> Tower (ZTO)",
	[1784] = "Quest Path 5509: 7.0 Highmountain - Stonehoof Watch -> Sylvan Falls (Quest, ZTO)",
	[1787] = "Quest Path 5512: Quest Path 5020: 7.0 Azsuna - Rift 03, Base - Tower (ZTO)",
	[1800] = "Quest Path 4621: [OLD]7.0 Quest - Azsuna (Down to Azsuna: Unlearned Taxi Dalaran --> Azsuna - Alliance) - ELM",
	[1801] = "Quest Path 5597: [OLD]7.0 Quest - Azsuna (Down to Azsuna: Unlearned Taxi Dalaran --> Azsuna - Horde) - ELM",
	[1803] = "Quest Path 5615: 7.0 Dalaran -> Trueshot Lodge, Highmountain",
	[1813] = "Quest Path 5643: 7.0 Quest - Azsuna (Down to Azsuna: Unlearned Taxi Dalaran --> Azsuna - Alliance) - ELM",
	[1814] = "Quest Path 5645: [OLD2]7.0 Quest - Azsuna (Down to Azsuna: Unlearned Taxi Dalaran --> Azsuna - Horde) - ELM",
	[1815] = "The Dreamgrove, Val'sharah",
	[1818] = "Quest Path 5654: 7.0 Artifacts - Druid - Feral - Q:42428 - Dreamgrove -> Ashamane's Fall - LWB",
	[1819] = "Quest Path 5655: 7.0 Quest - Azsuna (Down to Azsuna: Unlearned Taxi Dalaran --> Azsuna - Horde) - ELM",
	[1825] = "Quest Path 5667: 7.0 DH-OHC - 'Malace in Vrykul Land' Alliance - Dalaran -> Valdishall (ELM)",
	[1826] = "Quest Path 5668: 7.0 DH-OHC - 'Malace in Vrykul Land' Horde - Dalaran -> Valdishall (ELM)",
	[1827] = "Quest Path 5669: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Rings Portal 01 - SBV",
	[1828] = "Quest Path 5670: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Rings Portal Top -> Ring A - SBV",
	[1829] = "Quest Path 5671: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Rings Portal Middle 02 - SBV",
	[1830] = "Quest Path 5672: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Rings Portal Middle 03 - SBV",
	[1831] = "Quest Path 5673: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Side Platform Portal B -> Ring C - SBV",
	[1832] = "Quest Path 5674: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Portal - Ring A -> Center - SBV",
	[1833] = "Quest Path 5675: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Portal - Ring B -> Center - SBV",
	[1834] = "Quest Path 5676: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Side Platform Portal A -> Ring B - SBV",
	[1835] = "Quest Path 5677: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Side Platform Portal C -> Ring A - SBV",
	[1836] = "Quest Path 5678: 7.0 Order Hall - Mage - Ch 4 - The Oculus - Rings Portal - Ring C -> Ring A - SBV",
	[1837] = "Wardens' Redoubt, Azsuna",
	[1838] = "Thorim's Peak",
	[1839] = "Nastrondir",
	[1840] = "Eastern Suramar",
	[1841] = "Western Suramar",
	[1842] = "Carl Test b",
	[1843] = "Carl Test c",
	[1844] = "Carl Test d",
	[1845] = "Isle of the Watchers",
	[1846] = "Faronaar",
	[1847] = "The Dreamgrove",
	[1848] = "Trueshot Lodge",
	[1849] = "Dalaran",
	[1850] = "Eastern Highmountain",
	[1855] = "Shield's Rest, Stormheim",
	[1856] = "Vengeance Point, Broken Shore",
	[1857] = "Stormtorn Foothills, Stormheim",
	[1858] = "Meredil, Suramar",
	[1859] = "Felblaze Ingress, Azsuna",
	[1860] = "Watchers' Aerie, Azsuna",
	[1861] = "Illidari Perch, Azsuna",
	[1862] = "Acherus: The Ebon Hold",
	[1863] = "Hafr Fjall, Stormheim",
	[1864] = "Quest Path 5598: Nesingwary, Highmountain -> Shipwreck Cove, Highmountain [Unlearned]",
	[1865] = "Boost 2.0 - Alliance - Leave Point",
	[1867] = "Quest Path 5911: 7.0 Dalaran -> Acherus",
	[1868] = "Quest Path 5912: 7.0 Acherus -> Dalaran",
	[1869] = "Quest Path 5913: 7.0 Karazhan - Ballroom -> Opera Portal",
	[1870] = "Eye of Azshara, Azsuna",
	[1871] = "Quest Path 5925: Quest Path 5654: 7.0 Artifacts - Druid - Feral - Q:42428 - Ashamane's Fall -> Dreamgrove - LWB",
	[1874] = "Quest Path 5962: 7.0 Artifacts - Death Knight - Blood - From Dalaran to Broken Shore Portal - Taxi Version - LWB",
	[1875] = "Quest Path 5963: 7.0 Artifacts - Death Knight - Blood - From Broken Shore to Dalaran - Taxi - LWB",
	[1877] = "Quest Path 5626: 7.0 Artifacts - Priest - Holy - Dalaran to Broken Shore Portal - LWB",
	[1878] = "Quest Path 5627: 7.0 Artifacts - Priest - Holy - Quest NPC - Broken Shore - Fly Back - LWB",
	[1879] = "Crimson Thicket, Suramar",
	[1880] = "Irongrove Retreat, Suramar",
	[1885] = "Gloaming Reef, Val'sharah",
	[1892] = "Quest Path 6004: 7.2 Assault - Val'sharah - Black Rook - Base Camp to Ramparts - LWB",
	[1893] = "Quest Path 6005: 7.2 Legion Invasion - Val'sharah - 03 - Taxi to Top - LWB",
	[1894] = "Quest Path 6009: 7.1 Suramar -> Black Rook Hold ('We Need Weapons' ) - ZTO",
	[1899] = "Quest Path 6026: 7.2 OHC - Paladin - Light's Hope Chapel (Alliance) -> Broken Shore (1666) - JAP",
	[1900] = "Quest Path 6027: Quest Path 6026: 7.2 OHC - Paladin - Light's Hope Chapel (Horde) -> Broken Shore (1666) - JAP",
	[1902] = "Quest Path 6030: 7.2 Fel Hammer -> 7.2 Mardum",
	[1906] = "The Fel Hammer, Broken Shore",
	[1907] = "Quest Path 6038: 7.0 - Death Knight - No Man's Land - Taxi Route - LWB",
	[1908] = "Quest Path 6036: 7.2 Fel Hammer -> 7.2 Broken Shore",
	[1909] = "Quest Path 6041: 7.2 Wandering Isle -> Stormstout Brewery, Pandaria",
	[1910] = "Quest Path 6042: 7.2 OHC - Priest - Dalaran -> Broken Shore - Teleport (JAP)",
	[1913] = "Quest Path 6048: Quest Path 6005: 7.2 Legion Invasion - Val'sharah - 03 - Taxi to Bottom - LWB",
	[1916] = "Quest Path 6052: 7.2 OHC - Hunter - Trueshot Lodge -> Broken Shore - Teleport (JAP)",
	[1917] = "Quest Path 6053: 7.2 Order Hall - Shaman - Ch 5 - Thunderaan Transport (JLW)",
	[1922] = "Quest Path 6065: 7.2 Assault - Val'sharah - Black Rook - Top to Final Terrace",
	[1923] = "Quest Path 6067: 7.2 Assault - Val'sharah - Black Rook - Base Camp to Final Terrace",
	[1924] = "Quest Path 6068: 7.2 Acherus: The Ebon Hold -> Illidari Camp, Broken Shore",
	[1927] = "Quest Path 6072: 7.2 Order Hall - Rogue - Ch 5 - Temp To BS (JLW)",
	[1928] = "Krokul Hovel, Krokuun",
	[1933] = "Quest Path 6084: Acherus: The Ebon Hold -> Thorim's Peak, Stormheim",
	[1934] = "TEMPAREA1, Argus",
	[1935] = "TEMPAREA2, Argus",
	[1941] = "Deliverance Point, Broken Shore",
	[1942] = "Aalgen Point, Broken Shore",
	[1945] = "Quest Path 6154: 8.0 Zuldazar - Quest - 'King Rastakhan' - ZTO",
	[1947] = "Quest Path 6175: 7.3 Argus - Isle 2 - Alleria Arc - Alleria Shadow Ball Taxi (JAK)",
	[1953] = "Zul'jan, Nazmir",
	[1954] = "Zo'bal Ruins, Nazmir",
	[1955] = "Gloom Hollow, Nazmir",
	[1956] = "Forlorn Ruins, Nazmir",
	[1957] = "Port of Zandalar, Zuldazar",
	[1959] = "The Great Seal",
	[1961] = "Quest Path 6233: 8.0 Nazmir - Q: 47250 - Taxi to Jeb'watha ruins - LWB",
	[1962] = "Quest Path 6234: 8.0 Nazmir - Q: 42750 - Flight from Jeb'watha -> Zul'jan - LWB",
	[1964] = "Quest Path 6237: 8.0 Warfronts - Barrens - Intro Quest - Taxi from Theramore to Fort Triumph",
	[1965] = "Nesingwary's Gameland, Zuldazar",
	[1966] = "Warbeast Kraal, Zuldazar",
	[1967] = "Shattered Fields, Krokuun",
	[1974] = "Xibala, Zuldazar",
	[1975] = "Zeb'ahari, Zuldazar",
	[1976] = "Destiny Point, Krokuun",
	[1978] = "Conservatory of the Arcane, Eredath",
	[1981] = "Shadowguard Incursion, Eredath",
	[1982] = "Triumvirate's End, Eredath",
	[1983] = "Quest Path 6309: 8.0 Nazmir - Q: 47631 - Flight from Zul'jan -> Gloom Hollow - LWB",
	[1984] = "Quest Path 6310: 8.0 Nazmir - Q: 47602 - Flight out of Sundered Span - LWB",
	[1985] = "[Hidden] Argus Ground Points Hub (Ground TP out to here, TP to Vindicaar from here)",
	[1986] = "[Hidden] Argus Vindicaar Ground Hub (Vindicaar TP out to here, TP to ground from here)",
	[1987] = "[Hidden] Argus Vindicaar No Load Hub (Vindicaar No Load transition goes through here)",
	[1988] = "Hope's Landing, Antoran Wastes",
	[1991] = "Prophet's Reflection, Eredath",
	[1992] = "Light's Purchase, Antoran Wastes",
	[1993] = "The Veiled Den, Antoran Wastes",
	[2003] = "City Center, Eredath",
	[2009] = "Warport Rastari, Zuldazar",
	[2012] = "Xibala, Zuldazar",
	[2015] = "Quest Path 6437: 8.0 Nazmir - Q49082 - Flight out of Hir'eek's Lair - LWB",
	[2018] = "Quest Path 6440: 7.3 QA - TEST HOTFIX - Task 110012 - TaxiPathNode - RRB",
	[2020] = "Quest Path 6443: 7.3 QA - TEST HOTFIX - Task 110012 - TaxiPathNode - 2 - RRB",
	[2023] = "Freehold, Tiragarde Sound",
	[2027] = "Temple of the Prophet, Zuldazar",
	[2033] = "Fallhaven, Drustvar",
	[2034] = "Hangman's Point, Drustvar",
	[2035] = "Fletcher's Hollow, Drustvar",
	[2037] = "Barbthorn Ridge, Drustvar",
	[2041] = "Quest Path 6474: Freehold, Tiragarde Sound -> Southwind Ferry Dock, Tiragarde Sound",
	[2042] = "Vigil Hill, Tiragarde Sound",
	[2043] = "xxOLD - Zuldazar, Nazmir Outskirts",
	[2045] = "Garden of the Loa, Zuldazar",
	[2046] = "Atal'Dazar, Zuldazar",
	[2052] = "Anglepoint Wharf, Tiragarde Sound",
	[2053] = "Old Drust Road, Tiragarde Sound",
	[2054] = "Firebreaker Expedition, Tiragarde Sound",
	[2055] = "Southwind Station, Tiragarde Sound",
	[2056] = "Fallhaven, Drustvar",
	[2057] = "Fletcher's Hollow, Drustvar",
	[2058] = "Staghelm Point, Silithus",
	[2059] = "Southwind Village, Silithus",
	[2060] = "Hatherford, Tiragarde Sound",
	[2061] = "The Sliver, Zuldazar",
	[2062] = "Wolf's Den, Tiragarde Sound",
	[2065] = "Harbor, Zuldazar",
	[2066] = "Atal'Gral, Zuldazar",
	[2067] = "Timberfell Outpost, Tiragarde Sound",
	[2068] = "Scaletrader Post, Zuldazar",
	[2069] = "Crater Bay, Zuldazar",
	[2070] = "Zandalar Arena, Zuldazar",
	[2071] = "Dreadpearl, Zuldazar",
	[2073] = "Throne Room, Zuldazar",
	[2074] = "Bridgeport, Tiragarde Sound",
	[2075] = "Seeker's Outpost, Zuldazar",
	[2076] = "Atal'Gral, Zuldazar",
	[2077] = "Castaway Point, Tiragarde Sound",
	[2078] = "Fort Victory, Nazmir",
	[2079] = "Kennings Lodge, Tiragarde Sound",
	[2080] = "Grimwatt's Crash, Nazmir",
	[2081] = "Alliance Camp - East (TEMP NAME)",
	[2083] = "Tradewinds Market, Tiragarde Sound",
	[2084] = "Norwington Estate, Tiragarde Sound",
	[2085] = "Tidecross, Stormsong Valley",
	[2086] = "Brennadam, Stormsong Valley",
	[2087] = "Outrigger Post, Tiragarde Sound",
	[2088] = "Mildenhall Meadery, Stormsong Valley",
	[2089] = "Seekers Vista, Stormsong Valley",
	[2090] = "Hillcrest Pasture, Stormsong Valley",
	[2091] = "Stonetusk Watch, Stormsong Valley",
	[2092] = "Diretusk Hollow, Stormsong Valley",
	[2093] = "Ironmaul Overlook, Stormsong Valley",
	[2094] = "Warfang Hold, Stormsong Valley",
	[2095] = "Shrine of the Storm, Stormsong Valley",
	[2096] = "Tol Dagor, Tiragarde Sound",
	[2097] = "Deadwash, Stormsong Valley",
	[2101] = "The Amber Waves, Stormsong Valley",
	[2102] = "Roughneck Camp, Tiragarde Sound",
	[2103] = "Eastpoint Station, Tiragarde Sound",
	[2104] = "Eastpoint Station, Tiragarde Sound",
	[2105] = "Tradewinds Market, Tiragarde Sound",
	[2106] = "Arom's Stand, Drustvar",
	[2107] = "Watchman's Rise, Drustvar",
	[2108] = "Falconhurst, Drustvar",
	[2109] = "Whitegrove Chapel, Drustvar",
	[2110] = "Shatterstone Harbor, Vol'dun",
	[2111] = "Vorrik's Sanctum, Vol'dun",
	[2112] = "Vulture's Nest, Vol'dun",
	[2113] = "Tortaka Refuge, Vol'dun",
	[2114] = "Deadwood Cove, Vol'dun",
	[2116] = "Quest Path 6698: Horde Embassy, Zuldazar -> Throne Room, Zuldazar",
	[2117] = "Vulpera Hideaway, Vol'dun",
	[2118] = "Temple of Akunda, Vol'dun",
	[2119] = "Sanctuary of the Devoted, Vol'dun",
	[2120] = "Tortaka Refuge, Vol'dun",
	[2126] = "Scaletrader Post, Zuldazar",
	[2127] = "Anyport, Drustvar",
	[2128] = "Quest Path 6783: 8.0 Stormsong - Monastery -> Water Bridge - GJC",
	[2129] = "Quest Path 6799: 8.0 Nazmir - Player Flight Path to Altar of Rot - (STM)",
	[2130] = "Quest Path 6801: 8.0 Nazmir - Altar of Rot to Zul'jan Ruins - (STM)",
	[2133] = "Shrine of the Storm, Stormsong Valley",
	[2135] = "Krazzlefrazz Outpost, Drustvar",
	[2137] = "Millstone Hamlet, Stormsong Valley",
	[2138] = "Fort Daelin, Stormsong Valley",
	[2139] = "Windfall Cavern, Stormsong Valley",
	[2140] = "Plunder Harbor, Tiragarde Sound",
	[2143] = "Scorched Sands Outpost, Vol'dun",
	[2144] = "Goldtusk Inn, Vol'dun",
	[2145] = "Verdant Hollow, Zuldazar",
	[2147] = "Castaway Encampment, Zuldazar",
	[2148] = "Mugamba Overlook, Zuldazar",
	[2153] = "Mistvine Ledge, Zuldazar",
	[2156] = "Quest Path 6967: 8.0 War Campaign - Horde - Chapter 02 - Anyport to Barrowknoll (JLW)",
	[2157] = "Veiled Grotto, Zuldazar",
	[2158] = "Quest Path 6995: 8.0 Quest - Warchief's Command: Thousand Needles! - Orgrimmar --> Mudsprocket (ELM)",
	[2159] = "Quest Path 6996: 8.0 Quest - Warchief's Command: Un'Goro Crater! - Orgrimmar --> Marshal's Stand (ELM)",
	[2160] = "Quest Path 6997: 8.0 Quest - Warchief's Command: Silithus! - Orgrimmar --> Cenarion Hold (ELM)",
	[2161] = "Redfield's Watch, Nazmir",
	[2162] = "Devoted Sanctuary, Vol'dun",
	[2163] = "Quest Path 7004: 8.0 Quest - Warchief's Command: Southern Barrens! - Orgrimmar --> Malaka'jin (ELM)",
	[2164] = "Isle of Fangs, Zuldazar",
	[2165] = "Tusk Isle, Zuldazar",
	[2166] = "Quest Path 7063: 8.0 War Campaign - Horde - Chapter 05 - Plunder Harbor to Flagship (JLW)",
	[2167] = "Quest Path 7064: 8.0 War Campaign - Horde - Chapter 05 - Plunder Harbor to Ship (JLW)",
	[2168] = "Quest Path 7065: 8.0 War Campaign - Horde - Chapter 05 - Ship to Plunder Harbor (JLW)",
	[2169] = "Quest Path 7066: 8.0 War Campaign - Horde - Chapter 05 - Flagship to Plunder Harbor (JLW)",
	[2170] = "Quest Path 7067: 8.0 War Campaign - Horde - Chapter 05 - Ship to Flagship (JLW)",
	[2171] = "Quest Path 7068: 8.0 War Campaign - Horde - Chapter 05 - Flagship to Ship (JLW)",
	[2172] = "Disable Taxi Paths - Source - RRB",
	[2173] = "Disable Taxi Paths - Destination - RRB",
	[2272] = "Quest Path 6801: 8.0 Nazmir - Altar of Rot to Zul'jan Ruins - (STM)",
	[2273] = "Waning Glacier, Tiragarde Sound",
	[2274] = "Swiftwind Post, Drustvar",
	[2275] = "Mudfisher Cove, Drustvar",
	[2276] = "Tol Dagor, Tiragarde Sound",
	[2277] = "Proudmoore Keep, Tiragarde Sound",
	[2278] = "Mariner's Row, Tiragarde Sound",
	[2279] = "Stonefist Watch, Tiragarde Sound",
	[2282] = "Quest Path 6478: 8.0 Nazmir - Zuldazar to Talanji's Camp - (STM)",
	[2381] = "The Mugambala, Zuldazar",
	[2382] = "Quest Path 7405: 8.1 War Campaign - A - Ch1 - South Shore -> Ramparts - KRB",
	[2383] = "Quest Path 7496: 8.1 War Campaign - A - Ch1 - Ramparts -> South Shore  - KRB",
	[2384] = "Quest Path 7497: 8.1 War Campaign - A - Ch1 - North Shore -> Ramparts - KRB",
	[2392] = "Quest Path 7569: 8.2 Nazjatar - Kal'methir - Boss Path",
	[2393] = "TEMP, 9.0, Oribos, Bastion",
	[2394] = "TEMP, 9.0, Oribos, Maldraxxus",
	[2395] = "Oribos",
	[2396] = "TEMP, 9.0, Oribos, Ardenweald",
	[2397] = "9.0, Zone, Bastion",
	[2398] = "Bleak Redoubt, Maldraxxus",
	[2399] = "TEMP, 9.0, Zone, Revendreth",
	[2400] = "TEMP, 9.0, Zone, Ardenweald",
	[2401] = "Alliance Outpost, Exile's Reach Outpost",
	[2402] = "Ogre Citadel, Exile's Reach Island",
	[2403] = "Kelya's Grave",
	[2404] = "Newhome",
	[2405] = "Zin'Azshari",
	[2406] = "Elun'alor Temple",
	[2407] = "Utama's Stand",
	[2408] = "Mezzamere",
	[2409] = "Wreck of the Old Blanchy",
	[2410] = "Ashen Strand",
	[2411] = "Ashen Strand",
	[2412] = "Wreck of the Hungry Riverbeast",
	[2437] = "Ekka's Hideaway",
	[2441] = "Prospectus Bay, Mechagon",
	[2442] = "Overspark Expedition Camp, Mechagon",
	[2467] = "test node",
	[2471] = "test node",
	[2472] = "test node",
	[2473] = "test node",
	[2474] = "adams test node",
	[2475] = "adams second test node",
	[2482] = "The Tidal Conflux",
	[2483] = "The Tidal Conflux",
	[2488] = "Darkhaven, Revendreth",
	[2490] = "Quest Path 7759: Oribos go south 2 (msc)",
	[2506] = "Quest Path 7794: 9.0 Bastion - Temple of Humility - Quest - Transport To Humiity Top (JLW)",
	[2511] = "Sanctuary of the Mad, Revendreth",
	[2512] = "Halls of Atonement, Revendreth",
	[2513] = "Old Gate, Revendreth",
	[2514] = "Pridefall Hamlet, Revendreth",
	[2515] = "Dominance Keep, Revendreth",
	[2516] = "Chalice District, Revendreth",
	[2517] = "Menagerie of the Master, Revendreth",
	[2518] = "Wanecrypt Hill, Revendreth",
	[2519] = "Aspirant's Rest, Bastion",
	[2520] = "Sagehaven, Bastion",
	[2527] = "Quest Path 7856: 9.0 Ardenweald - COV - MC - Q57782 - Taxi to Boss - LWB",
	[2528] = "Elysian Hold, Bastion",
	[2529] = "Hero's Rest, Bastion",
	[2530] = "Dreamsong Fenn, Ardenweald",
	[2537] = "Charred Ramparts, Revendreth",
	[2541] = "Quest Path 7899: 9.0 Bastion - Campaign - Ch 05 - Revendreth - Redelav District - Transport Down from Wall (JLW)",
	[2544] = "Mistfall Village, Vale of Eternal Blossoms",
	[2548] = "Sinfall, Revendreth",
	[2549] = "Quest Path 7925: 9.0 Bastion - Temple of Wisdom - Teleport Pads - Grounds -> Temple Base - GJC",
	[2550] = "Quest Path 7926: 9.0 Bastion - Temple of Wisdom - Teleport Pads - Temple Base -> Grounds - GJC",
	[2552] = "Quest Path 7869: 9.0 Bastion - Hero's Rest - Zipline - North - Up - GJC",
	[2553] = "Quest Path 7949: 9.0 Ardenweald - Bastion Campaign - Queen's Chamber - Up - RRB",
	[2554] = "Quest Path 7950: 9.0 Ardenweald - Bastion Campaign - Queen's Chamber - Down - RRB/ELM",
	[2555] = "The Maw",
	[2556] = "Progenitor Console",
	[2557] = "[Hidden] The Maw - Outdoor - Cocyrus Oribos Teleport Dest",
	[2558] = "The Spearhead, Maldraxxus",
	[2559] = "Spider's Watch, Maldraxxus",
	[2560] = "Keres' Rest, Maldraxxus",
	[2561] = "Renounced Bastille, Maldraxxus",
	[2562] = "Quest Path 7870: 9.0 Bastion - Hero's Rest - Zipline - South - Up - GJC",
	[2563] = "Quest Path 7876: 9.0 Bastion - Hero's Rest - Zipline - South - Down - GJC",
	[2564] = "Theater of Pain, Maldraxxus",
	[2565] = "Starlit Overlook, Ardenweald",
	[2566] = "Quest Path 7875: 9.0 Bastion - Hero's Rest - Zipline - West - Down - GJC",
	[2567] = "Quest Path 7874: 9.0 Bastion - Hero's Rest - Zipline - West - Up - GJC",
	[2568] = "Quest Path 7877: 9.0 Bastion - Hero's Rest - Zipline - North - Down - GJC",
	[2569] = "Plague Watch, Maldraxxus",
	[2572] = "Quest Path 8039: 9.0 Bastion - Campaign - Ch 05 - Revendreth - Tower to Ember Ward (JLW)",
	[2573] = "Quest Path 8047: 9.0 Ardenweald - Covenant Hall - Queen's Audience Chamber Taxi Up - KRB",
	[2574] = "Quest Path 8048: 9.0 Ardenweald - Covenant Hall - Queen's Audience Chamber Taxi Down - KRB",
	[2575] = "Quest Path 8054: 9.0 Ardenweald - COV - Sisters - Q05 - Queen's Audience Chamber Taxi Up - KRB",
	[2576] = "Quest Path 8055: 9.0 Ardenweald - COV - Sisters - Q05 - Queen's Audience Chamber Taxi Down - KRB",
	[2580] = "Quest Path 8079: 9.0 Bastion Campaign - Ch 09 - Loyalty - Stage 6 - Ground -> Temple of Loyalty - GJC",
	[2584] = "Glitterfall Basin, Ardenweald",
	[2585] = "Tirna Vaal, Ardenweald",
	[2586] = "Hibernal Hollow, Ardenweald",
	[2587] = "Heart of the Forest, Ardenweald",
	[2588] = "Root-Home, Ardenweald",
	[2589] = "Claw's Edge, Ardenweald",
	[2590] = "Refugee Camp, Ardenweald",
	[2591] = "Crucible of Souls",
	[2594] = "9.0 Maw - Oribos - Teleport In",
	[2595] = "Quest Path 8159: 9.0 Bastion - Level Up - Memory Extraction - Zipline - Up (JAK)",
	[2596] = "Quest Path 8160: 9.0 Bastion - Level Up - Memory Extraction - Zipline - Down (JAK)",
	[2602] = "Quest Path 8194: 9.0 Bastion - Level Up - Temple of Purity - Zipline - Up (JAK)",
	[2603] = "Quest Path 8195: 9.0 Bastion - Level Up - Temple of Purity - Zipline - Down (JAK)",
	[2604] = "Quest Path 8242: [UNUSED]9.x Quest - The Battle for Lordaeron (H) - Orgrimmar, Valley of Strength --> Orgrimmar, Gates of Orgrimmar (ELM)",
	[2605] = "Quest Path 8278: Theater of Pain Taxi Path",
	[2625] = "Elysian Hold, Bastion",
	[2626] = "Hero's Rest, Bastion",
	[2627] = "[Hidden] 9.0 Bastion Ground Points Hub (Ground TP out to here, TP to Sanctum from here)",
	[2628] = "[Hidden] 9.0 Bastion Ground Hub (Sanctum TP out to here, TP to ground from here)",
	[2630] = "Aspirant's Rest, Bastion",
	[2631] = "Xandaria's Vigil, Bastion",
	[2632] = "Sagehaven, Bastion",
	[2633] = "Temple of Purity, Bastion",
	[2634] = "Seat of Eternal Hymns, Bastion",
	[2635] = "Temple of Humility, Bastion",
	[2636] = "Terrace of the Collectors, Bastion",
	[2637] = "Summoned Steward, Bastion",
	[2639] = "Quest Path 8321: 9.0 Bastion - Treasure Max Level - Wisdom - Taxi - A to D - EJC",
	[2640] = "Quest Path 8322: 9.0 Bastion - Treasure Max Level - Wisdom - Taxi - B to C - EJC",
	[2641] = "Quest Path 8323: 9.0 Bastion - Treasure Max Level - Wisdom - Taxi - C to D - EJC",
	[2642] = "Quest Path 8324: 9.0 Bastion - Treasure Max Level - Wisdom - Taxi - D to E - EJC",
	[2643] = "Theater of Pain North, Maldraxxus",
	[2644] = "Quest Path 8326: 9.0 Bastion - Treasure Max Level - Wisdom - Taxi - F to A - EJC",
	[2645] = "Quest Path 8327: 9.0 Bastion - Treasure Max Level - Wisdom - Taxi - C to F - EJC",
	[2646] = "Quest Path 8328: 9.0 Bastion - Max Level - Temple of Courage - Zipline -  Up (JAK)",
	[2647] = "Quest Path 8329: 9.0 Bastion - Max Level - Temple of Courage - Zipline -  Down (JAK)",
	[2648] = "Quest Path 8330: 9.0 Bastion - Max Level - Temple of Wisdom - Zipline -  Up (JAK)",
	[2649] = "Quest Path 8331: 9.0 Bastion - Max Level - Temple of Wisdom - Zipline - Down (JAK)",
	[2650] = "Quest Path 8332: 9.0 Bastion - Max Level - Temple of Humility - Zipline -  Up (JAK)",
	[2651] = "Quest Path 8333: 9.0 Bastion - Max Level - Temple of Humility - Zipline -  Down (JAK)",
	[2652] = "Quest Path 8334: 9.0 Bastion - Treasure Max Level - Wisdom - Taxi - E to B - EJC",
	[2653] = "Quest Path 8336: 9.0 Bastion - Max Level - Temple of Loyalty - Zipline - Lower - Up (JAK)",
	[2654] = "Quest Path 8337: 9.0 Bastion - Max Level - Temple of Loyalty - Zipline - Lower - Down (JAK)",
	[2655] = "Quest Path 8338: 9.0 Bastion - Max Level - Temple of Loyalty - Zipline - Upper - Up (JAK)",
	[2656] = "Quest Path 8339: 9.0 Bastion - Max Level - Temple of Loyalty - Zipline - Upper - Down (JAK)",
	[2657] = "Quest Path 8335: 9.0 Maw - Torghast - Floor 90 - Up",
	[2658] = "Quest Path 8340: 9.0 Maw - Torghast - Floor 90 - Down",
	[2659] = "Quest Path 8347: 9.0 Bastion - Treasure Max Level - Courage - Taxi - Return - EJC",
	[2660] = "Quest Path 8348: 9.0 Bastion - Treasure Max Level - Wisdom - Taxi - Return - EJC",
	[2661] = "Quest Path 8359: 9.0 Ardenweald - COV - Drust - Ch2 - Flight out of Darkreach - LWB",
	[2662] = "Quest Path 8363: 9.0 Maldraxxus - House of Plagues - Pipeline Up - EJC",
	[2663] = "Quest Path 8372: 9.0 Bastion - Path of Ascension - Capture - Devourer - Anima Gateway Taxi - GJC",
	[2664] = "Quest Path 8374: 9.0 Maw - Outdoor - Ve'nari -> Planes of Torment",
	[2665] = "Quest Path 8387: 9.0 Bastion - Teleport Pads -  Eternal Forge Suburbs -> Miri's Chapel - SBV",
	[2666] = "Quest Path 8388: 9.0 Bastion - Teleport Pads -  Miri's Chapel ->  Eternal Forge Suburbs - SBV",
	[2670] = "Quest Path 8421: 9.0 Maw - Outdoor - Mawsworn Rifts - Zovaal's -> Calcis",
	[2671] = "Quest Path 8422: 9.0 Maw - Outdoor - Mawsworn Rifts - Calcis -> Zovaal's",
	[2672] = "Quest Path 8423: 9.0 Maw - Outdoor - Mawsworn Rifts - Crucible -> Tremaculum",
	[2673] = "Quest Path 8424: 9.0 Maw - Outdoor - Mawsworn Rifts - Tremaculum -> Crucible",
	[2674] = "Quest Path 8375: 9.0 Maw - Outdoor - Ve'nari -> Beastwarrens",
	[2675] = "Quest Path 8425: 9.0 Bastion - Treasure - Out of Bounds Teleporter - 01 - SBV",
	[2676] = "Quest Path 8426: 9.0 Bastion - Treasure - Out of Bounds Teleporter - 02 - SBV",
	[2677] = "Quest Path 8427: 9.0 Bastion - Treasure - Out of Bounds Teleporter - 03 - SBV",
	[2678] = "Quest Path 8428: 9.0 Bastion - Treasure - Out of Bounds Teleporter - 04 - SBV",
	[2680] = "Terrace of the Collectors, Bastion",
	[2681] = "Quest Path 8460: 9.0 Bastion - Cloudwalker Coffer - Zipline - To Memorial Shrine (MAH)",
	[2683] = "Quest Path 8472: 9.0 Bastion - Covenant Hall - Flight to Sanctum - Amphitheater -> Covenant Hall - GJC",
	[2684] = "Quest Path 8473: 9.0 Bastion - Covenant Hall - Flight to Sanctum - Sanctum -> Amphitheater - GJC",
	[2685] = "Quest Path 8474: 9.0 Bastion - Covenant Hall - Flight to Sanctum - Fate's Precipice -> Sanctum - GJC",
	[2686] = "Quest Path 8475: 9.0 Bastion - Covenant Hall - Flight to Sanctum - Sanctum -> Fate's Precipice - GJC",
	[2687] = "Quest Path 8476: 9.0 Bastion - Covenant Hall - Flight to Sanctum - Humility Terrace -> Sanctum - GJC",
	[2688] = "Quest Path 8477: 9.0 Bastion - Covenant Hall - Flight to Sanctum - Sanctum -> Humility Terrace - GJC",
	[2690] = "Quest Path 8500: 9.0.5 Maw - Hidden Object - Shadehound Mount - Perdition Upper to Zovaals - LJS",
	[2691] = "Quest Path 8507: 9.1 Campaign- Ch 06 - House of Rituals - Surface -> Exoramas - KRB",
	[2692] = "Quest Path 8508: 9.1 Campaign- Ch 06 - House of Rituals - Exoramas -> Surface - KRB",
	[2693] = "Seamless Proto, Revendreth",
	[2694] = "Seamless Proto, Boralus",
	[2695] = "Quest Path 8530: 9.1 - Dungeon - Broker City - RP Throughline - Elevator Taxi Path",
	[2698] = "Keeper's Respite, Korthia",
	[2699] = "Tazavesh Outdoor",
	[2700] = "Ve'nari's Refuge, The Maw",
	[2703] = "Tazavesh, the Veiled Market",
	[2708] = "Quest Path 8614: 9.0 Maw - Outdoor - Ve'nari -> Perdition Hold",
	[2709] = "Quest Path 8615: 9.0 Maw - Outdoor - Ve'nari -> Desmotaeron",
	[2710] = "Quest Path 8616: 9.0 Maw - Outdoor - Mawsworn Rifts - Desmotaeron -> Perdition Hold",
	[2711] = "Quest Path 8617: 9.0 Maw - Outdoor - Mawsworn Rifts - Perdition Hold -> Desmotaeron",
	[2717] = "Quest Path 8628: 10.0 - Pre-Prod - Krav'rel to Azure Archives - (STM)",
	[2718] = "Quest Path 8629: 10.0 - Pre-Prod: Azure Archives to Kirin Tor Hub - (STM)",
	[2719] = "Quest Path 8630: 10.0 - Pre-Prod - Bombing Run - (STM)",
	[2720] = "Quest Path 8631: 10.0 - Pre-Prod - Kalthraz Fortress to Azure Archives - (STM)",
	[2722] = "Quest Path 8635: 10.0 Pre-Prod - Grasslands - Dragonsmeet to Emerald Gardens (JLW)",
	[2732] = "[HIDDEN] - 9.2 Resonant Peaks - Teleport Network - Hidden Hub (Connects all Nodes to each other without unique paths) (MAH/JDA)",
	[2739] = "Rebuff Lookout, The Waking Shores",
	[2740] = "10.0 Construction - Teleport Network - Hidden Hub (Connects all Nodes to each other without unique paths) (JDA)",
	[2741] = "Skytop Lookout (QD), The Waking Shores",
	[2752] = "Ruby Lifeshrine, The Waking Shores",
	[2770] = "Brackenhide Outskirts, The Azure Span",
	[2771] = "Emerald Gardens, Ohn'ahran Plains",
	[2773] = "Azure Archives, Azure Span",
	[2774] = "Camp Antonidas, Azure Span",
	[2775] = "Iskaara, Azure Span",
	[2776] = "Life Pools - top to bottom, Waking Shores - Begin",
	[2777] = "Life Pools - top to bottom, Waking Shores - End",
	[2778] = "Dragonscale Basecamp (QD), The Waking Shores",
	[2779] = "Wingrest Embassy (QD), The Waking Shores",
	[2780] = "10.0 Explorers - Travel Network - Hub",
	[2782] = "Quest Path 8851: 10.0 Plains - Emerald Hub - Taxi Down to Portal Grove (RMV)",
	[2783] = "Quest Path 8852: 10.0 Plains - Emerald Hub - Taxi Up to Shady Snctuary (RMV)",
	[2784] = "Camp Nowhere, Azure Span",
	[2786] = "Rhonin's Shield, Azure Span",
	[2787] = "Cobalt Assembly, Azure Span",
	[2788] = "Theron's Watch, Azure Span",
	[2789] = "Three-Falls Lookout, Azure Span",
	[2790] = "Timberstep Outpost, Ohn'ahran Plains",
	[2792] = "Maruukai, Ohn'ahran Plains",
	[2793] = "Forkriver Crossing, Ohn'ahran Plains",
	[2794] = "Teerakai, Ohn'ahran Plains",
	[2795] = "Broadhoof Outpost, Ohn'ahran Plains",
	[2796] = "Shady Sanctuary, Ohn'ahran Plains",
	[2797] = "Emberwatch, Ohn'ahran Plains",
	[2798] = "Pinewood Post, Ohn'ahran Plains",
	[2799] = "Rusza'thar Reach, Ohn'ahran Plains",
	[2800] = "Uktulut Outpost, The Waking Shores",
	[2801] = "Apex Observatory, The Waking Shores",
	[2802] = "Obsidian Throne, The Waking Shores",
	[2803] = "Uktulut Pier, The Waking Shores",
	[2804] = "Uktulut Backwater, The Waking Shores",
	[2808] = "Obsidian Bulwark, The Waking Shores",
	[2809] = "Dragonscale Basecamp, The Waking Shores",
	[2810] = "Valdrakken, Thaldraszus",
	[2811] = "Gelikyr Post, Thaldraszus",
	[2812] = "Temporal Conflux, Thaldraszus",
	[2813] = "Algeth'era, Thaldraszus",
	[2814] = "Veiled Ossuary, Thaldraszus",
	[2815] = "Garden Shrine, Thaldraszus",
	[2816] = "Shifting Sands, Thaldraszus",
	[2818] = "Vault of the Incarnates, Thaldraszus",
	[2820] = "Quest Path 9123: 10.0 Plains - Merithra's Watch - Taxi Down to Shady Sanctuary (RMV)",
	[2821] = "Quest Path 9124: 10.0 Plains - Emerald Hub - Taxi Up to Merithra's Watch (RMV)",
	[2822] = "Quest Path 9125: 10.0 Plains - Emerald Hub - Taxi to Lunedane (RMV)",
	[2823] = "Quest Path 9126: 10.0 Plains - Lunedane - Taxi to Shady Sanctuary (RMV)",
	[2824] = "Quest Path 9147: 10.0 Plains - Emerald Hub - Taxi to Lunedane - PERSONAL (RMV)",
	[2825] = "Ohn'iri Springs, Ohn'ahran Plains",
	[2832] = "Cobalt Assembly, The Azure Span",
	[2834] = "Eon's Fringe, Thaldraszus",
	[2835] = "[Hidden] 10.0 Travel Network - Destination Input",
	[2836] = "Algeth'era, Thaldraszus",
	[2837] = "Vakthros, Azure Span",
	[2838] = "Cobalt Assembly, Azure Span",
	[2839] = "Rusza'thar Reach, Ohn'ahran Plains",
	[2840] = "Shady Sanctuary, Ohn'ahran Plains",
	[2841] = "Skytop Observatory, The Waking Shores",
	[2842] = "Rubyscale Outpost, The Waking Shores",
	[2843] = "[Hidden] 10.0 Travel Network - Destination Output",
	[2855] = "Morqut Village, The Forbidden Reach",
	[2856] = "Quest Path 9315: 10.0.7 Forbidden Reach - War Creche - Taxi - Go Up - EJC",
	[2857] = "Quest Path 9316: 10.0.7 Forbidden Reach - War Creche - Taxi - Go Down - EJC",
	[2860] = "10.1 UG - Campaign - Ch6 - Aberrus Upper Platform (SMART)",
	[2862] = "Morqut Islet, Forbidden Reach",
	[2866] = "Cascades Canyon, Ohn'ahran Plains",
	[2867] = "The Throughway, Zaralek Cavern",
	[2874] = "Old Loamm Road, Ohn'ahran Plains",
	[2875] = "Old Loamm Road, Zaralek Cavern",
	[2876] = "Lookout Breach, Zaralek Cavern",
	[2877] = "Lookout Breach, Azure Span",
}

-- Object Database Module
local ObjectNames = {
	[31] = "Old Lion Statue",
	[33] = "Locked Chest",
	[34] = "Old Jug",
	[35] = "Captain's Footlocker",
	[36] = "Broken Barrel",
	[47] = "Wanted: Lieutenant Fangore",
	[55] = "A half-eaten body",
	[56] = "Rolf's corpse",
	[59] = "Mound of loose dirt",
	[60] = "Wanted: Gath'Ilzogg",
	[61] = "A Weathered Grave",
	[76] = "An Empty Jar",
	[256] = "Wanted!",
	[257] = "Suspicious Barrel",
	[259] = "Half-buried Barrel",
	[261] = "Damaged Crate",
	[269] = "Guarded Thunder Ale Barrel",
	[270] = "Unguarded Thunder Ale Barrel",
	[287] = "Bookie Herod's Records",
	[288] = "Bookie Herod's Strongbox",
	[711] = "Wanted!",
	[1557] = "Lillith's Dinner Table",
	[1561] = "Sealed Crate",
	[1585] = "Explosive Charge",
	[1586] = "Crate of Candles",
	[1593] = "Corpse Laden Boat",
	[1599] = "Shallow Grave",
	[1609] = "Dragonmaw Catapult",
	[1610] = "Incendicite Mineral Vein",
	[1627] = "Dalaran Crate",
	[1728] = "Dusty Rug",
	[1738] = "Syndicate Documents",
	[1739] = "Syndicate Documents",
	[1740] = "Syndicate Documents",
	[1763] = "WANTED",
	[1765] = "Worn Wooden Chest",
	[2008] = "Dangerous!",
	[2059] = "A Dwarven Corpse",
	[2076] = "Bubbling Cauldron",
	[2083] = "Bloodsail Correspondence",
	[2289] = "Ruined Lifeboat",
	[2553] = "A Soggy Scroll",
	[2554] = "Cortello's Riddle",
	[2555] = "Musty Scroll",
	[2560] = "Half-Buried Bottle",
	[2652] = "Ebenezer Rustlocke's Corpse",
	[2656] = "Waterlogged Letter",
	[2688] = "Keystone",
	[2701] = "Iridescent Shards",
	[2702] = "Stone of Inner Binding",
	[2703] = "Trollbane's Tomb",
	[2713] = "Wanted Board",
	[2734] = "Waterlogged Chest",
	[2744] = "Giant Clam",
	[2868] = "Crumpled Map",
	[2875] = "Battered Dwarven Skeleton",
	[2908] = "Sealed Supply Crate",
	[2933] = "Seal of the Earth",
	[3076] = "Dirt-stained Map",
	[3238] = "Chen's Empty Keg",
	[3239] = "Benedict's Chest",
	[3643] = "Old Footlocker",
	[3972] = "WANTED",
	[4141] = "Control Console",
	[5620] = "Flawed Power Stones",
	[6751] = "Strange Fruited Plant",
	[6752] = "Strange Fronded Plant",
	[7510] = "Sprouted Frond",
	[10076] = "Scrying Bowl",
	[12666] = "Twilight Tome",
	[15084] = "The Sparklematic 5200",
	[15085] = "The Sparklematic 5200",
	[17182] = "Buzzbox 827",
	[17183] = "Buzzbox 411",
	[17184] = "Buzzbox 323",
	[19023] = "|cFFFFFFFFStep 7:|r Page 2351",
	[19024] = "Hidden Shrine",
	[19595] = "Gatekeeper's Hold",
	[19599] = "Talon Den Hoard",
	[19861] = "Henrig Lonebrow's Journal",
	[20805] = "Rizzle's Unguarded Plans",
	[20985] = "Loose Dirt",
	[20992] = "Black Shield",
	[21015] = "Hoofprints",
	[21016] = "Hoofprints",
	[21042] = "Theramore Guard Badge",
	[21581] = "Aftermath of the Second War",
	[21582] = "Beyond the Dark Portal",
	[21583] = "The Kaldorei and the Well of Eternity",
	[28604] = "Scattered Crate",
	[32569] = "Galen's Strongbox",
	[35251] = "Karnitol's Chest",
	[50961] = "Malem Chest",
	[51708] = "Eliza's Grave Dirt",
	[61934] = "Brazier of the Dormant Flame",
	[103821] = "Doan's Strongbox",
	[112888] = "Dusty Shelf",
	[112948] = "Intrepid's Locked Strongbox",
	[113757] = "Shadowforge Cache",
	[113768] = C_Spell.GetSpellName(61820),
	[113791] = "Brazier of Everfount",
	[123329] = "Baelog's Chest",
	[125477] = "Conspicuous Urn",
	[131474] = "The Discs of Norgannon",
	[138492] = "Shards of Myzrael",
	[141931] = "Hippogryph Egg",
	[141979] = "Ancient Treasure",
	[141980] = "Spectral Lockbox",
	[142071] = "Egg-O-Matic",
	[142088] = "Tablet of Will",
	[142122] = "Wanted Poster",
	[142127] = "Rin'ji's Secret",
	[142151] = "Sealed Barrel",
	[142179] = "Solarsal Gazebo",
	[142184] = "Captain's Chest",
	[142189] = "Inconspicuous Landmark",
	[142195] = "Woodpaw Battle Map",
	[142343] = "Uldum Pedestal",
	[142345] = "Matrix Punchograph 3005-A",
	[142475] = "Matrix Punchograph 3005-B",
	[142476] = "Matrix Punchograph 3005-C",
	[142487] = "The Sparklematic 5200",
	[142696] = "Matrix Punchograph 3005-D",
	[142702] = "Venom Bottle",
	[142958] = "Feralas: A History",
	[143980] = "Gordunni Scroll",
	[144063] = "Equinex Monolith",
	[144064] = "Gordunni Dirt Mound",
	[148498] = "Altar of Suntara",
	[148502] = "|cFFFFFFFFStep 1:|r Page 9",
	[148504] = "A Conspicuous Gravestone",
	[148512] = "Essence Font",
	[148832] = "Atal'ai Statue",
	[148836] = "Altar of Hakkar",
	[148838] = "Idol of Hakkar",
	[149047] = "Torch of Retribution",
	[149502] = "Hoard of the Black Dragonflight",
	[150075] = "Wanted Poster",
	[151286] = "Kaldorei Tome of Summoning",
	[152097] = "Belnistrasz's Brazier",
	[157936] = "Un'Goro Dirt Pile",
	[160836] = "Relic Coffer",
	[160845] = "Dark Coffer",
	[161495] = "Secret Safe",
	[161504] = "A Small Pack",
	[161505] = "A Wrecked Raft",
	[161521] = "Research Equipment",
	[161526] = "Crate of Foodstuffs",
	[164659] = "Green Power Crystal",
	[164661] = "Yellow Power Crystal",
	[164689] = "Monument of Franclorn Forgewright",
	[164778] = "Blue Power Crystal",
	[164780] = "Red Power Crystal",
	[164798] = "Evoroot",
	[164820] = "Dark Keeper Nameplate",
	[164867] = "WANTED",
	[164868] = "KILL ON SIGHT",
	[164869] = "Spectral Chalice",
	[164885] = "Corrupted Night Dragon",
	[164886] = "Corrupted Songflower",
	[164887] = "Corrupted Windblossom",
	[164888] = "Corrupted Whipper Root",
	[164909] = "Wrecked Row Boat",
	[164911] = "Thunderbrew Lager Keg",
	[164953] = "Large Leather Backpacks",
	[164954] = "Zukk'ash Pod",
	[164955] = "Northern Crystal Pylon",
	[164956] = "Western Crystal Pylon",
	[164957] = "Eastern Crystal Pylon",
	[164958] = "Bloodpetal Sprout",
	[165554] = "Heart of the Mountain",
	[169243] = "Chest of The Seven",
	[171939] = "Corrupted Songflower",
	[171942] = "Corrupted Songflower",
	[173232] = "Blacksmithing Plans",
	[173265] = "Wooden Outhouse",
	[173284] = "Corrupted Whipper Root",
	[173324] = "Corrupted Night Dragon",
	[173327] = "Corrupted Windblossom",
	[174594] = "Corrupted Songflower",
	[174595] = "Corrupted Songflower",
	[174596] = "Corrupted Songflower",
	[174597] = "Corrupted Songflower",
	[174598] = "Corrupted Songflower",
	[174599] = "Corrupted Windblossom",
	[174600] = "Corrupted Windblossom",
	[174601] = "Corrupted Windblossom",
	[174602] = "Corrupted Windblossom",
	[174603] = "Corrupted Windblossom",
	[174604] = "Corrupted Windblossom",
	[174605] = "Corrupted Whipper Root",
	[174606] = "Corrupted Whipper Root",
	[174607] = "Corrupted Whipper Root",
	[174608] = "Corrupted Night Dragon",
	[174682] = "Beware of Pterrordax",
	[174684] = "Corrupted Night Dragon",
	[174686] = "Corrupted Whipper Root",
	[174708] = "Corrupted Windblossom",
	[174709] = "Corrupted Windblossom",
	[174712] = "Corrupted Songflower",
	[174713] = "Corrupted Songflower",
	[174848] = "Testing Equipment",
	[175124] = "Rookery Egg",
	[175226] = "Beached Sea Creature",
	[175227] = "Beached Sea Creature",
	[175230] = "Beached Sea Creature",
	[175233] = "Beached Sea Creature",
	[175245] = "Father Flame",
	[175320] = "WANTED: Murkdeep!",
	[175369] = "Elders' Square Service Entrance",
	[175382] = "Doomrigger's Coffer",
	[175385] = "Darkstone Tablet",
	[175524] = "Mysterious Red Crystal",
	[175564] = "Brazier of the Herald",
	[175586] = "Jaron's Wagon",
	[175587] = "Damaged Crate",
	[175621] = "Urok's Tribute Pile",
	[175704] = "Singed Letter",
	[175724] = "Sargeras and the Betrayal",
	[175725] = "The Old Gods and the Ordering of Azeroth",
	[175726] = "Charge of the Dragonflights",
	[175727] = "The War of the Ancients",
	[175729] = "Mount Hyjal and Illidan's Gift",
	[175730] = "The World Tree and the Emerald Dream",
	[175731] = "Exile of the High Elves",
	[175732] = "The Sentinels and the Long Vigil",
	[175733] = "The Founding of Quel'Thalas",
	[175734] = "Arathor and the Troll Wars",
	[175735] = "The Guardians of Tirisfal",
	[175736] = "Ironforge - the Awakening of the Dwarves",
	[175737] = "The Seven Kingdoms",
	[175738] = "Aegwynn and the Dragon Hunt",
	[175739] = "War of the Three Hammers",
	[175740] = "The Last Guardian",
	[175741] = "Kil'jaeden and the Shadow Pact",
	[175742] = "Rise of the Horde",
	[175745] = "The Dark Portal and the Fall of Stormwind",
	[175746] = "The Alliance of Lordaeron",
	[175747] = "The Invasion of Draenor",
	[175748] = "The Birth of the Lich King",
	[175749] = "Icecrown and the Frozen Throne",
	[175750] = "The Battle of Grim Batol",
	[175751] = "Lethargy of the Orcs",
	[175752] = "The New Horde",
	[175753] = "War of the Spider",
	[175754] = "Kel'Thuzad and the Forming of the Scourge",
	[175756] = "The Scourge of Lordaeron",
	[175757] = "Sunwell - The Fall of Quel'Thalas",
	[175758] = "Archimonde's Return and the Flight to Kalimdor",
	[175759] = "The Betrayer Ascendant",
	[175760] = "Rise of the Blood Elves",
	[175761] = "Civil War in the Plaguelands",
	[175762] = "The Lich King Triumphant",
	[175763] = "Old Hatreds - The Colonization of Kalimdor",
	[175854] = "The Twin Empires",
	[175855] = "Empires' Fall",
	[175856] = "Wrath of Soulflayer",
	[175886] = "Roughshod Pike",
	[175894] = "Janice's Parcel",
	[175924] = "Locked Cabinet",
	[175925] = "Outhouse",
	[175926] = "Mrs. Dalson's Diary",
	[175949] = "Fifth Mosh'aru Tablet",
	[175950] = "Sixth Mosh'aru Tablet",
	[175965] = "Frostwhisper's Embalming Fluid",
	[175966] = "Enchanted Scarlet Thread",
	[175970] = "Unforged Runic Breastplate",
	[176089] = "Unfired Plate Gauntlets",
	[176090] = "Human Remains",
	[176091] = "Deadwood Cauldron",
	[176112] = "Malor's Strongbox",
	[176115] = "Wanted Poster - Arnak Grimtotem",
	[176116] = "Pamela's Doll's Head",
	[176142] = "Pamela's Doll's Left Side",
	[176143] = "Pamela's Doll's Right Side",
	[176190] = "Beached Sea Turtle",
	[176191] = "Beached Sea Turtle",
	[176192] = "Catalogue of the Wayward",
	[176196] = "Beached Sea Turtle",
	[176197] = "Beached Sea Turtle",
	[176198] = "Beached Sea Turtle",
	[176249] = "Scourge Data",
	[176317] = "The Argent Hold",
	[176325] = "Blacksmithing Plans",
	[176361] = "Scourge Cauldron",
	[176392] = "Scourge Cauldron",
	[176393] = "Scourge Cauldron",
	[176582] = "Shellfish Trap",
	[176631] = "Menethil's Gift",
	[177289] = "Scourge Cauldron",
	[177490] = "Northridge Lumber Mill Crate",
	[177491] = "Termite Barrel",
	[177544] = "Joseph's Chest",
	[177667] = "Torn Scroll",
	[177675] = "Mound of Dirt",
	[177786] = "Rackmore's Chest",
	[177787] = "Rackmore's Log",
	[177904] = "Wanted Poster: Besseleth",
	[177964] = "Fathom Stone",
	[178609] = "Holiday Snow",
	[179485] = "Broken Trap",
	[179499] = "Ogre Tannin Basket",
	[179501] = "Knot Thimblejack's Cache",
	[179517] = "Treasure of the Shen'dralar",
	[179545] = "The Prince's Chest",
	[179547] = "A Dusty Tome",
	[179551] = "Hydraxis' Coffer",
	[179552] = "Schematic: Field Repair Bot 74A",
	[179559] = "Felvine Shard",
	[179562] = "Ancient Heated Blade",
	[179564] = "Gordok Tribute",
	[179697] = "Arena Treasure Chest",
	[179703] = "Cache of the Firelord",
	[179827] = "Wanted/Missing/Lost & Found",
	[179832] = "Pillaclencher's Ornate Pillow",
	[179879] = "Orb of Command",
	[179880] = "Drakkisath's Brand",
	[179913] = "Call to Arms!",
	[180215] = "Hakkari Thorium Vein",
	[180229] = "Jinxed Hoodoo Pile",
	[180327] = "Brazier of Madness",
	[180366] = "Battered Tackle Box",
	[180368] = "Tablet of Madness",
	[180369] = "Muddy Churning Waters",
	[180448] = "Wanted Poster: Deathclasp",
	[180456] = "Lesser Wind Stone",
	[180461] = "Wind Stone",
	[180466] = "Greater Wind Stone",
	[180503] = "Sandy Cookbook",
	[180526] = "Gong of Bethekk",
	[180570] = "Keg",
	[180633] = "Crystalline Tear",
	[180642] = "Inconspicuous Crate",
	[180652] = "Freshly Dug Dirt",
	[180658] = "School of Deviate Fish",
	[180662] = "Schooner Wreckage",
	[180665] = "Draconic for Dummies",
	[180666] = "Draconic for Dummies",
	[180667] = "Draconic for Dummies",
	[180682] = "Oily Blackmouth School",
	[180684] = "Greater Sagefish School",
	[180685] = "Waterlogged Wreckage",
	[180690] = "Large Scarab Coffer",
	[180691] = "Scarab Coffer",
	[180712] = "Stonescale Eel Swarm",
	[180717] = "The Scarab Gong",
	[180743] = "Carefully Wrapped Present",
	[180746] = "Gently Shaken Gift",
	[180747] = "Gaily Wrapped Present",
	[180748] = "Ticking Present",
	[180751] = "Floating Wreckage",
	[180793] = "Festive Gift",
	[180794] = "Journal of Jandice Barov",
	[180796] = "PX-238 Winter Wondervolt",
	[180901] = "Bloodsail Wreckage",
	[180918] = "Wanted: Thaelis the Hungerer",
	[181011] = "Magister Duskwither's Journal",
	[181073] = "Fragrant Cauldron",
	[181074] = "Arena Spoils",
	[181083] = "Sothos and Jarien's Heirlooms",
	[181085] = "Stratholme Supply Crate",
	[181147] = "Wanted Poster",
	[181150] = "Dusty Journal",
	[181153] = "Wanted Poster: Kel'gash the Wicked",
	[181366] = "Four Horsemen Chest",
	[181638] = "Wanted Poster",
	[181643] = "Featherbeard's Remains",
	[181649] = "Featherbeard's Journal",
	[181665] = "Burial Chest",
	[181698] = "Voidstone",
	[181748] = "Blood Crystal",
	[181756] = "Battered Ancient Book",
	[181889] = "Wanted Poster",
	[182030] = "Inert Peculiar Key",
	[182032] = "Galaen's Journal",
	[182053] = "Glowcap",
	[182115] = "Wanted Poster",
	[182165] = "Wanted Poster",
	[182196] = "Arcane Container",
	[182197] = "Arcane Container",
	[182198] = "Arcane Container",
	[182392] = "Garadar Bulletin Board",
	[182393] = "Telaar Bulletin Board",
	[182549] = "Fel Orc Plans",
	[182587] = "Wanted Poster",
	[182588] = "Wanted Poster",
	[182947] = "The Codex of Blood",
	[182952] = "Steam Pump Flotsam",
	[182953] = "Sporefish School",
	[182954] = "Brackish Mixed School",
	[182956] = "School of Darter",
	[182957] = "Highland Mixed School",
	[182958] = "Mudfish School",
	[182959] = "Bluefish School",
	[183284] = "Wanted Poster",
	[183385] = "Sanguine Hibiscus",
	[183770] = "B'naar Control Console",
	[183811] = "Wanted Poster",
	[183877] = "Ethereal Transporter Control Panel",
	[184300] = "Necromantic Focus",
	[184418] = "Ethereum Prison",
	[184465] = "Cache of the Legion",
	[184660] = "Wanted Poster",
	[184793] = "Primitive Chest",
	[184825] = "Lashh'an Tome",
	[184945] = "Wanted Poster",
	[184946] = "Wanted Poster",
	[185035] = "Wanted Poster",
	[185119] = "Dust Covered Chest",
	[185126] = "Crystal Prison",
	[185165] = "Legion Communicator",
	[185166] = "Wanted Poster",
	[185168] = "Reinforced Fel Iron Chest",
	[185302] = "Fei Fei's Cache",
	[185522] = "Shaffar's Stasis Chamber",
	[186183] = "Barleybrew Festive Keg",
	[186184] = "Thunderbrew Festive Keg",
	[186185] = "Gordok Festive Keg",
	[186186] = "Drohn's Distillery Festive Keg",
	[186187] = "T'chali's Voodoo Brew Festive Keg",
	[186267] = "Pumpkin Shrine",
	[186426] = "Wanted Poster",
	[186585] = "Dragonskin Scroll",
	[186881] = "Dark Iron Sabotage Plans",
	[186887] = "Large Jack-o'-Lantern",
	[187236] = "Winter Veil Gift",
	[187273] = "Suspicious Hoofprint",
	[187367] = "Winterfin Clam",
	[187565] = "Elder Atkanok",
	[187851] = "Cultist Shrine",
	[187905] = "Massive Glowing Egg",
	[188085] = "Plagued Grain",
	[188192] = "Ice Chest",
	[188261] = "Battered Journal",
	[188364] = "Wrecked Crab Trap",
	[188365] = "Heart of the Ancients",
	[188367] = "Portable Seismograph",
	[188418] = "Wanted!",
	[188419] = "Elder Mana'loa",
	[188501] = "War Golem Part",
	[188502] = "War Golem Part",
	[188503] = "War Golem Part",
	[188649] = "Wanted Poster",
	[188667] = "Amberseed",
	[189311] = "Flesh-bound Tome",
	[189989] = "Dark Iron Mole Machine Wreckage",
	[189990] = "Dark Iron Mole Machine Wreckage",
	[190020] = "Wanted!",
	[190447] = "Flying Machine Engine",
	[190453] = "Venture Co. Spare Parts",
	[190454] = "Venture Co. Spare Parts",
	[190455] = "Venture Co. Spare Parts",
	[190535] = "Zim'Abwa",
	[190602] = "Zim'Torga",
	[190622] = "Sturdy Vine",
	[190623] = "Papaya",
	[190624] = "Orange",
	[190625] = "Banana Bunch",
	[190643] = "Thunderbrew's Jungle Punch",
	[190657] = "Zim'Rhuk",
	[190768] = "Timeworn Coffer",
	[190917] = "Abandoned Mail",
	[190936] = "Plague Cauldron",
	[191543] = "Scarlet Onslaught Trunk",
	[191728] = "Wanted!",
	[191760] = "Inventor's Library Console",
	[191761] = "Prototype Console",
	[191766] = "Orders From Drakuru",
	[192046] = "Musselback Sculpin School",
	[192048] = "Dragonfin Angelfish School",
	[192049] = "Fangtooth Herring School",
	[192050] = "Glacial Salmon School",
	[192051] = "Borean Man O' War School",
	[192052] = "Imperial Manta Ray School",
	[192053] = "Deep Sea Monsterbelly School",
	[192054] = "Moonglow Cuttlefish School",
	[192057] = "Nettlefish School",
	[192059] = "Glassfin Minnow School",
	[192060] = "Fjorn's Anvil",
	[192071] = "Fjorn's Anvil",
	[192072] = "Harpoon Crate",
	[192078] = "Hodir's Horn",
	[192079] = "Hodir's Spear",
	[192080] = "Hodir's Helm",
	[192524] = "Arngrim the Insatiable",
	[192708] = "The Schools of Arcane Magic - Introduction",
	[192709] = "The Schools of Arcane Magic - Abjuration",
	[192710] = "The Schools of Arcane Magic - Conjuration",
	[192711] = "The Schools of Arcane Magic - Divination",
	[192713] = "The Schools of Arcane Magic - Enchantment",
	[192818] = "Infused Mushroom",
	[192827] = "Wild Mustard",
	[192828] = "Crystalsong Carrot",
	[192833] = "Bridenbrad's Possessions",
	[192865] = "The Schools of Arcane Magic - Illusion",
	[192866] = "The Schools of Arcane Magic - Necromancy",
	[192867] = "The Schools of Arcane Magic - Transmutation",
	[193195] = "Pulsing Crystal",
	[193400] = "Saronite Bomb Stack",
	[193402] = "Rusted Prisoner's Footlocker",
	[193426] = "Four Horsemen Chest",
	[194092] = "Blackened Urn",
	[194105] = "Buzzbox 413",
	[194122] = "Buzzbox 723",
	[194213] = "Winter Hyacinth",
	[194238] = "Blade of Drak'Mar",
	[194378] = "Stolen Explorers' League Document",
	[194387] = "Stolen Explorers' League Document",
	[194388] = "Stolen Explorers' League Document",
	[194389] = "Stolen Explorers' League Document",
	[194390] = "Stolen Explorers' League Document",
	[194391] = "Stolen Explorers' League Document",
	[194479] = "Pool of Blood",
	[194555] = "Archivum Console",
	[194618] = "Lance Rack",
	[194622] = "Lance Rack",
	[194714] = "Disgusting Workbench",
	[194908] = "Lance Rack",
	[194909] = "Lance Rack",
	[195134] = "The Bomb",
	[195431] = "Headquarters Radio",
	[195433] = "Ancient Tablets",
	[195435] = "Weapons Cabinet",
	[195438] = "Cup of Elune",
	[195445] = "Ancient Vortex Runestone",
	[195497] = "Elune's Brazier",
	[195517] = "Elune's Handmaiden",
	[195600] = "Smouldering Stone",
	[195642] = "Naga Power Stone",
	[195665] = "Argent Crusade Tribute Chest",
	[195676] = "Secret Lab Squakbox",
	[196393] = "Broken Relic",
	[196394] = "Crate of Mandrake Essence",
	[196832] = "Upper Scrying Stone",
	[196833] = "Lower Scrying Stone",
	[201578] = "Wrenchmen Recruitment Poster",
	[201873] = "Gunship Armory",
	[202080] = "Dart's Nest",
	[202081] = "Takk's Nest",
	[202082] = "Ravasaur Matriarch's Nest",
	[202083] = "Razormaw Matriarch's Nest",
	[202135] = "Dadanga's Grave",
	[202180] = "Gunship Armory",
	[202407] = "Sandscraper's Chest",
	[202474] = "Antediluvean Chest",
	[202598] = "Big Nasty Plunger",
	[202613] = "Platform Control Panel",
	[202655] = "Troll Archaeology Find",
	[202697] = "Eye of Twilight",
	[202701] = "Outhouse Hideout",
	[202706] = "Twilight Cauldron",
	[202712] = "The Twilight Apocrypha",
	[202776] = "Mountain Trout School",
	[202777] = "Highland Guppy School",
	[202778] = "Albino Cavefish School",
	[202779] = "Blackbelly Mudfish School",
	[202780] = "Fathom Eel Swarm",
	[202871] = "Sunken Crate",
	[202975] = "Submerged Outhouse",
	[203071] = "Night Elf Archaeology Find",
	[203078] = "Nerubian Archaeology Find",
	[203128] = "Broken Bottle",
	[203134] = "Empty Pedestal",
	[203140] = "Broken Prong",
	[203186] = "STAY OUT!",
	[203207] = "Codex of Shadows",
	[203301] = "Naga Tridents",
	[203305] = "Crucible of Nazsharin",
	[203733] = "Bounty Board",
	[203734] = "Westfall Deed",
	[203755] = "Wrenchmen Recruitment Poster",
	[204050] = "Foebreaker Blueprints",
	[204274] = "Captain's Log",
	[204282] = "Dwarf Archaeology Find",
	[204344] = "Wanted!",
	[204351] = "Ettin Control Orb",
	[204372] = "Zanzil's Portal",
	[204386] = "Zanzil's Portal",
	[204406] = "Half-Buried Bottle",
	[204437] = "Blackrock Key Pouch",
	[204450] = "Captain Stillwater's Charts",
	[204578] = "Barrel of Doublerum",
	[204817] = "Lightforged Rod",
	[204824] = "Lightforged Arch",
	[204825] = "Lightforged Crest",
	[204959] = "Gigantic Painite Cluster",
	[205134] = "Forgemaster's Log",
	[205143] = "Abandoned Outhouse",
	[205198] = "Pile of Explosives",
	[205207] = "Maziel's Journal",
	[205258] = "Broken Weapons Crate",
	[205266] = "Elaborate Disc",
	[205332] = "Wanted Poster",
	[205350] = "Horde Communication Panel",
	[205476] = "Book of Lost Souls",
	[205477] = "Moonsteel Ingots",
	[205479] = "Moontouched Wood",
	[205540] = "Decrepit Skeleton",
	[205874] = "Sand-Covered Hieroglyphs",
	[205875] = "Crusader's Flare",
	[206109] = "Warchief's Command Board",
	[206111] = "Hero's Call Board",
	[206116] = "Warchief's Command Board",
	[206293] = "A.I.D.A. Terminal",
	[206294] = "Hero's Call Board",
	[206335] = "Stone Slab",
	[206336] = "Marble Slab",
	[206374] = "Trove of the Watchers",
	[206504] = "Rhea's Final Note",
	[206569] = "Eye of Twilight",
	[206585] = "Totem of Ruumbo",
	[206836] = "Fossil Archaeology Find",
	[206944] = "Shovel",
	[207104] = "Master Control Pump",
	[207125] = "Crate of Left Over Supplies",
	[207179] = "Winterfall Cauldron",
	[207187] = "Orc Archaeology Find",
	[207188] = "Draenei Archaeology Find",
	[207189] = "Vrykul Archaeology Find",
	[207190] = "Tol'vir Archaeology Find",
	[207279] = "Warchief's Command Board",
	[207303] = "Adventure Board",
	[207304] = "Adventure Board",
	[207320] = "Hero's Call Board",
	[207321] = "Hero's Call Board",
	[207322] = "Hero's Call Board",
	[207323] = "Warchief's Command Board",
	[207324] = "Warchief's Command Board",
	[207325] = "Warchief's Command Board",
	[207359] = "Pure Twilight Egg",
	[207406] = "Strange Fountain",
	[207407] = "Broken Pillar",
	[207408] = "Magical Brazier",
	[207409] = "Tol'vir Grave",
	[207410] = "Large Stone Obelisk",
	[207411] = "Dwarven Bone Pile",
	[207412] = "Stone Tablet",
	[207496] = "Dark Iron Treasure Chest",
	[207497] = "Dark Iron Treasure Chest",
	[207498] = "Dark Iron Treasure Chest",
	[207500] = "Dark Iron Treasure Chest",
	[207724] = "Shipwreck Debris",
	[208311] = "Deepsea Sagefish School",
	[208316] = "Hero's Call Board",
	[208317] = "Warchief's Command Board",
	[208321] = "Shrine of the Soulflayer",
	[208365] = "Recently Disturbed Dirt Mound",
	[208535] = "Dried Acorn",
	[208549] = "Voodoo Pile",
	[208550] = "Voodoo Pile",
	[208825] = "Shrine of the Ancestors",
	[208900] = "Portal to the Firelands",
	[209072] = "Stolen Crate",
	[209076] = "Anson's Crate",
	[209094] = "Stolen Crate",
	[209095] = "Edgar's Crate",
	[209270] = "|cFFFFFFFFStep 2:|r Page 78",
	[209344] = "Orchard Tool",
	[209345] = "Orchard Tool",
	[209436] = "Ripe Orange",
	[209462] = "Rattan Switch",
	[209497] = "Stolen Treats",
	[209550] = "Blushleaf Cluster",
	[209620] = "Darkmoon Treasure Chest",
	[209673] = "Jade Tiger Pillar",
	[209699] = "Jade Cong",
	[209700] = "Chipped Ritual Bowl",
	[209701] = "Pungent Ritual Candle",
	[209825] = "Tidemist Cap",
	[209836] = "Freshly Fallen Petals",
	[209842] = "Pang's Extra-Spicy Tofu",
	[209843] = "Ang's Summer Watermelon",
	[209844] = "Ang's Giant Pink Turnip",
	[209845] = "Mouthwatering Brew",
	[209863] = "Chunk of Jade",
	[209891] = "Stolen Turnip",
	[209892] = "Stolen Watermelon",
	[209903] = "Green Branch",
	[209907] = "Meadow Marigold",
	[209921] = "Muddy Water",
	[209951] = "Silk Patch",
	[209952] = "Jademoon",
	[209953] = "Emperor Tern Egg",
	[209954] = "Whitefisher Crane Egg",
	[209955] = "Hornbill Strider Egg",
	[210001] = "Stolen Malt Sack",
	[210002] = "Stolen Barley Sack",
	[210005] = "Weapon Rack",
	[210015] = "Weapon Rack",
	[210016] = "Weapon Rack",
	[210017] = "Weapon Rack",
	[210018] = "Weapon Rack",
	[210019] = "Weapon Rack",
	[210020] = "Weapon Rack",
	[210184] = "Slick Mudfish",
	[210186] = "Slick Mudfish",
	[210188] = "Rain-Slick Honeycomb",
	[210209] = "Imperial Lotus",
	[210228] = "Jar of Pigment",
	[210229] = "Water of Youth",
	[210238] = "Serpent Egg",
	[210239] = "Serpent Egg",
	[210240] = "Serpent Egg",
	[210416] = "Mogu Artifact",
	[210417] = "Mogu Artifact",
	[210418] = "Mogu Artifact",
	[210565] = "Dark Soil",
	[210582] = "Dark Soil",
	[210759] = "Arrow for Commander Hsieh",
	[210887] = "Untainted Supplies",
	[211017] = "Root Vegetable",
	[211018] = "Root Vegetable",
	[211019] = "Root Vegetable",
	[211023] = "Cast Iron Pot",
	[211143] = "Mogu Relic",
	[211147] = "Mogu Relic",
	[211148] = "Mogu Relic",
	[211266] = "Stolen Supplies",
	[211268] = "Stolen Supplies",
	[211269] = "Stolen Supplies",
	[211270] = "Stolen Supplies",
	[211312] = "Explosives Barrel",
	[211379] = "Spare Plank",
	[211382] = "Tough Kelp",
	[211420] = "Lump of Sand",
	[211424] = "Alchemy Scroll",
	[211451] = "Cerulean Gift of the Crane",
	[211452] = "Bronze Gift of the Crane",
	[211454] = "Kafa'kota Bush",
	[211480] = "Kafa'kota Berries",
	[211506] = "Pitch Pot",
	[211507] = "Pitch Pot",
	[211510] = "Sage Liao's Belongings",
	[211517] = "Snarlvine",
	[211518] = "Snarlvine",
	[211536] = "Stolen Bag of Luckydos",
	[211537] = "Stolen Bag of Luckydos",
	[211538] = "Stolen Bag of Luckydos",
	[211566] = "Palewind Totem",
	[211684] = "Volatile Blooms",
	[211696] = "Stolen Sack of Hops",
	[211719] = "Violet Citron",
	[211721] = "Violet Citron",
	[211754] = "Curious Text",
	[211770] = "Shen Dynasty Tablet",
	[211780] = "Curious Text",
	[211793] = "Wai Dynasty Tablet",
	[211794] = "Qiang Dynasty Tablet",
	[211807] = "Mogu Chest",
	[211863] = "Krik'thik Limb",
	[211871] = "Dread Orb",
	[211872] = "Dread Orb",
	[211873] = "Dread Orb",
	[211967] = "King's Coffer",
	[211990] = "Hozen Speech",
	[211993] = "Hozen Maturity",
	[211994] = "The Hozen Ravage",
	[212003] = "Yaungol Oil Barrel",
	[212009] = "Amber Fragment",
	[212079] = "Mantid Relic",
	[212135] = "Shado-Pan Fire Arrows",
	[212136] = "Shado-Pan Fire Arrows",
	[212181] = "Ancient Statute",
	[212278] = "Protected Unga Keg",
	[212389] = "Scroll of Auspice",
	[212540] = "Lost Keg",
	[212541] = "Lost Mug",
	[212553] = "Lost Picnic Supplies",
	[212902] = "Solidified Amber",
	[212923] = "Amber Collector",
	[212987] = "Spiny Starfish",
	[212988] = "Spiny Starfish",
	[213267] = "Dreadshade",
	[213327] = "The Saurok",
	[213328] = "The Defiant",
	[213329] = "The Deserters",
	[213330] = "The Last Stand",
	[213331] = "Valley of the Emperors",
	[213332] = "The Lost Dynasty",
	[213333] = "Spirit Binders",
	[213334] = "The Thunder King",
	[213362] = "Ship's Locker",
	[213363] = "Wodin's Mantid Shanker",
	[213364] = "Ancient Pandaren Mining Pick",
	[213366] = "Ancient Pandaren Tea Pot",
	[213368] = "Lucky Pandren Coin",
	[213407] = "Quan Tou Kuo the Two Fisted",
	[213409] = "Cycle of the Mantid",
	[213410] = "Mantid Society",
	[213411] = "Amber",
	[213412] = "The Empress",
	[213413] = "Pandaren Fighting Tactics",
	[213414] = "Always Remember",
	[213415] = "The First Monks",
	[213416] = "Together, We Are Strong",
	[213417] = "Yaungol Tactics",
	[213418] = "Dominance",
	[213420] = "Trapped in a Strange Land",
	[213421] = "The Emperor's Burden - Part 3",
	[213422] = "The Emperor's Burden - Part 4",
	[213438] = "Ren Yun the Blind",
	[213443] = "The Emperor's Burden - Part 6",
	[213445] = "The Emperor's Burden - Part 5",
	[213454] = "Soggy's Footlocker",
	[213455] = "The Emperor's Burden - Part 7",
	[213456] = "The Emperor's Burden - Part 8",
	[213459] = "The Birthplace of Liu Lang",
	[213460] = "A Most Famous Bill of Sale",
	[213461] = "The Wandering Widow",
	[213511] = "Victory in Kun-Lai",
	[213512] = "Xin Wo Yin the Broken Hearted",
	[213649] = "Cache of Pilfered Goods",
	[213650] = "Virmen Treasure Cache",
	[213651] = "Equipment Locker",
	[213653] = "Pandaren Fishing Spear",
	[213741] = "Ancient Jinyu Staff",
	[213742] = "Hammer of Ten Thunders",
	[213748] = "Pandaren Ritual Stone",
	[213749] = "Staff of the Hidden Master",
	[213750] = "Saurok Stone Tablet",
	[213751] = "Sprite's Cloth Chest",
	[213765] = "Tablet of Ren Yun",
	[213767] = "Hidden Treasure",
	[213768] = "Hozen Warrior Spear",
	[213769] = "Hozen Treasure Cache",
	[213770] = "Stolen Sprite Treasure",
	[213771] = "Statue of Xuen",
	[213774] = "Lost Adventurer's Belongings",
	[213782] = "Terracotta Head",
	[213793] = "Rikktik's Tiny Chest",
	[213795] = "Stormstout Secrets",
	[213842] = "Stash of Yaungol Weapons",
	[213844] = "Amber Encased Moth",
	[213845] = "The Hammer of Folly",
	[213956] = "Fragment of Dread",
	[213959] = "Hardened Sap of Kri'vess",
	[213960] = "Yaungol Fire Carrier",
	[213961] = "Abandoned Create of Goods",
	[213962] = "Wind-Reaver's Dagger of Quick Strikes",
	[213964] = "Malik's Stalwart Spear",
	[213966] = "Amber Encased Necklace",
	[213967] = "Blade of the Prime",
	[213968] = "Swarming Cleaver of Ka'roz",
	[213969] = "Dissector's Staff of Mutation",
	[213970] = "Bloodsoaked Chitin Fragment",
	[213971] = "Swarmkeeper's Medallion",
	[213972] = "Blade of the Poisoned Mind",
	[213973] = "Klaxxi Sonic Relay",
	[214062] = "Glowing Amber",
	[214170] = "Vor'thik Egg",
	[214175] = "Bag of Wu Kao Supplies",
	[214325] = "Forgotten Lockbox",
	[214337] = "Stash of Gems",
	[214338] = "Offering of Remembrance",
	[214339] = "Chest of Supplies",
	[214340] = "Boat-Building Instructions",
	[214379] = "Shrine of Fellowship",
	[214403] = "Stack of Papers",
	[214407] = "Mo-Mo's Treasure Chest",
	[214438] = "Ancient Mogu Tablet",
	[214439] = "Barrel of Banana Infused Rum",
	[214562] = "Sha-Haunted Crystal",
	[214871] = "Shattered Destroyer",
	[214903] = "The Tan-Chao",
	[214945] = "Onyx Egg",
	[214962] = "Requisitioned Firework Launcher",
	[215705] = "Tillers Shrine",
	[215765] = "Waiting for the Turtle",
	[215779] = "Watersmithing",
	[215780] = "Waterspeakers",
	[215782] = "Origins",
	[215783] = "Role Call",
	[215785] = "Embracing the Passions",
	[215797] = "The Emperor's Burden - Part 2",
	[215798] = "Yaungoil",
	[215799] = "The Emperor's Burden - Part 1",
	[215844] = "Flagpole",
	[216322] = "Bounty Board",
	[216362] = "A Keg of Metal Brew",
	[216761] = "Mixed Ocean School",
	[216764] = "Sagefish School",
	[218055] = "Loa-Infused Blade",
	[218056] = "Loa-Infused Blade",
	[218059] = "Zandalari Potion",
	[218427] = "Coming of Age",
	[218428] = "For Council and King",
	[218429] = "Shadows of the Loa",
	[218430] = "The Dark Prophet Zul",
	[218431] = "Lei Shen",
	[218432] = "The Sacred Mount",
	[218433] = "Unity at a Price",
	[218434] = "The Pandaren Problem",
	[218435] = "Agents of Order",
	[218436] = "Shadow, Storm, and Stone",
	[218437] = "The Curse and the Silence",
	[218438] = "Age of a Hundred Kings",
	[218593] = "Trove of the Thunder King",
	[218750] = "Work Orders",
	[218853] = "Stormy Chest",
	[220641] = "Thunderlord Cache",
	[220807] = "Neverending Spritewood",
	[220815] = "Cave-in",
	[220820] = "|cFFFFFFFFStep 6:|r Page 1127",
	[220821] = "|cFFFFFFFFStep 5:|r Page 845",
	[220832] = "Sunken Treasure",
	[220901] = "Gleaming Treasure Chest",
	[220902] = "Rope-Bound Treasure Chest",
	[220903] = "Gleaming Crane Statue",
	[220904] = "Rock-breaking Hammer",
	[220908] = "Mist-Covered Treasure Chest",
	[220986] = "Blackguard's Jetsam",
	[220994] = "Timeless Chest",
	[220995] = "Timeless Chest",
	[220996] = "Timeless Chest",
	[220997] = "Timeless Chest",
	[220998] = "Timeless Chest",
	[220999] = "Timeless Chest",
	[221000] = "Timeless Chest",
	[221001] = "Timeless Chest",
	[221002] = "Timeless Chest",
	[221003] = "Timeless Chest",
	[221004] = "Timeless Chest",
	[221005] = "Timeless Chest",
	[221006] = "Timeless Chest",
	[221007] = "Timeless Chest",
	[221008] = "Timeless Chest",
	[221009] = "Timeless Chest",
	[221010] = "Timeless Chest",
	[221013] = "Timeless Chest",
	[221014] = "Timeless Chest",
	[221015] = "Timeless Chest",
	[221016] = "Timeless Chest",
	[221017] = "Timeless Chest",
	[221018] = "Timeless Chest",
	[221019] = "Timeless Chest",
	[221020] = "Timeless Chest",
	[221021] = "Timeless Chest",
	[221022] = "Timeless Chest",
	[221023] = "Timeless Chest",
	[221024] = "Timeless Chest",
	[221026] = "Timeless Chest",
	[221027] = "Conspicuously Empty Shell",
	[221036] = "Gleaming Treasure Satchel",
	[221376] = "Old Sign Fragment",
	[221413] = "Lin Family Scroll",
	[221617] = "Skull-Covered Chest",
	[221670] = "Moss-Covered Chest",
	[221671] = "Sturdy Chest",
	[221672] = "Smoldering Chest",
	[221673] = "Blazing Chest",
	[221689] = "Ripe Crispfruit",
	[221690] = "Sand-Covered Egg",
	[221725] = "Charged Crystal",
	[221747] = "Huge Yak Roast",
	[221763] = "Fire Poppy",
	[221764] = "Roasted Seed",
	[222684] = "Glinting Sand",
	[222685] = "Crane Nest",
	[222686] = "Eerie Crystal",
	[222687] = "Ordon Supplies",
	[222688] = "Firestorm Egg",
	[222689] = "Fiery Altar of Ordos",
	[222776] = "Time-Lost Shrine",
	[222796] = "Cloudstrike Family Helm",
	[223084] = "Moss-Covered Chest",
	[223085] = "Moss-Covered Chest",
	[223086] = "Moss-Covered Chest",
	[223087] = "Moss-Covered Chest",
	[223088] = "Moss-Covered Chest",
	[223089] = "Moss-Covered Chest",
	[223090] = "Moss-Covered Chest",
	[223091] = "Moss-Covered Chest",
	[223092] = "Moss-Covered Chest",
	[223093] = "Moss-Covered Chest",
	[223094] = "Moss-Covered Chest",
	[223095] = "Moss-Covered Chest",
	[223096] = "Moss-Covered Chest",
	[223097] = "Moss-Covered Chest",
	[223098] = "Moss-Covered Chest",
	[223099] = "Moss-Covered Chest",
	[223100] = "Moss-Covered Chest",
	[223101] = "Moss-Covered Chest",
	[223102] = "Moss-Covered Chest",
	[223103] = "Moss-Covered Chest",
	[223104] = "Moss-Covered Chest",
	[223105] = "Moss-Covered Chest",
	[223106] = "Moss-Covered Chest",
	[223107] = "Moss-Covered Chest",
	[223108] = "Moss-Covered Chest",
	[223109] = "Moss-Covered Chest",
	[223110] = "Moss-Covered Chest",
	[223111] = "Moss-Covered Chest",
	[223112] = "Moss-Covered Chest",
	[223113] = "Moss-Covered Chest",
	[223114] = "Moss-Covered Chest",
	[223115] = "Moss-Covered Chest",
	[223116] = "Sturdy Chest",
	[223117] = "Sturdy Chest",
	[223118] = "Sturdy Chest",
	[223119] = "Smoldering Chest",
	[223139] = "Cursed Gravestone",
	[223193] = "Giant Clam",
	[223204] = "Moss-Covered Chest",
	[223228] = "Southsea Firebrew",
	[223533] = "Peaceful Offering",
	[223537] = "Flameheart Shawl",
	[223538] = "Riverspeaker's Trident",
	[223539] = "Snowdrift Tiger Talons",
	[224228] = "Bubbling Cauldron",
	[224306] = "Broken Chains",
	[224392] = "Slave's Stash",
	[224613] = "Spectator's Chest",
	[224616] = "Obsidian Petroglyph",
	[224623] = "Wiggling Egg",
	[224633] = "Iron Horde Supplies",
	[224686] = "Devourer's Gutstone",
	[224713] = "Cragmaul Cache",
	[224750] = "Hanging Satchel",
	[224753] = "Scaly Rylak Egg",
	[224754] = "Waterlogged Chest",
	[224755] = "Iron Horde Tribute",
	[224756] = "Alchemist's Satchel",
	[224770] = "Shadowmoon Exile Treasure",
	[224780] = "Shadowmoon Sacrificial Dagger",
	[224781] = "Rotting Basket",
	[224783] = "False-Bottomed Jar",
	[224784] = "Vindicator's Cache",
	[224785] = "Demonic Cache",
	[225501] = "Peaceful Offering",
	[225502] = "Peaceful Offering",
	[225503] = "Peaceful Offering",
	[225596] = "Prickly Nopal",
	[225726] = "Iron Shredder Decommission Orders",
	[225778] = "Barum's Notes",
	[226468] = "Buffeting Galefury",
	[226469] = C_Spell.GetSpellName(154259),
	[226831] = "Astrologer's Box",
	[226854] = "Armored Elekk Tusk",
	[226861] = "Ronokk's Belongings",
	[226862] = "Giant Moonwillow Cone",
	[226865] = "Cargo of the Raven Queen",
	[226955] = "Arena Master's War Horn",
	[226956] = "Mysterious Fruit Pile",
	[226961] = "Bounty Board",
	[226967] = "Lagoon Pool",
	[226976] = "Deceptia's Smoldering Boots",
	[226983] = "Crag-Leaper's Cache",
	[226990] = "Supply Dump",
	[226993] = "Survivalist's Cache",
	[226994] = "Grimfrost Treasure",
	[226996] = "Goren Leftovers",
	[227069] = "Hastily Written Note",
	[227134] = "Iron Horde Cargo Shipment",
	[227504] = "Barbed Thunderlord Spear",
	[227527] = "Lightbearer",
	[227587] = "Yuuri's Gift",
	[227654] = "Bonechewer Spear",
	[227737] = "Shadow Council Communicator",
	[227743] = "Fantastic Fish",
	[227793] = "Aarko's Family Treasure",
	[227806] = "Battle-Worn Frostwolf Banner",
	[227859] = "Hope",
	[227868] = "Sparkling Pool",
	[227951] = "Rook's Tacklebox",
	[227953] = "Jug of Aged Ironwine",
	[227954] = "Luminous Shell",
	[227955] = "Amethyl Crystal",
	[227956] = "Foreman's Lunchbox",
	[227996] = "Curious Deathweb Egg",
	[227998] = "Ockbar's Pack",
	[228012] = "Charred Sword",
	[228013] = "Farmer's Bounty",
	[228014] = "Relic of Aruuna",
	[228015] = "Iron Box",
	[228016] = "Barrel of Fish",
	[228017] = "Draenei Weapons",
	[228018] = "Soulbinder's Reliquary",
	[228019] = "Webbed Sac",
	[228020] = "Relic of Telmor",
	[228021] = "Treasure of Ango'rosh",
	[228022] = "Light of the Sea",
	[228023] = "Bonechewer Remnants",
	[228024] = "Aruuna Mining Cart",
	[228025] = "Keluu's Belongings",
	[228026] = "Pure Crystal Dust",
	[228483] = "Rusted Lockbox",
	[228570] = "Ketya's Stash",
	[229314] = "Goblin Mind Control Device",
	[229328] = "Envoy's Satchel",
	[229330] = "Mysterious Ring",
	[229331] = "A Mystical Hat",
	[229333] = "Mysterious Boots",
	[229344] = "Buried Timewarped Staff",
	[229354] = "Bright Coin",
	[229367] = "Frozen Orc Skeleton",
	[229640] = "Frozen Frostwolf Axe",
	[230252] = "Burning Pearl",
	[230303] = "Bounty Board",
	[230401] = "Sealed Jug",
	[230402] = "Lucky Coin",
	[230424] = "Snow-Covered Strongbox",
	[230425] = "Gnawed Bone",
	[230428] = "Smoldering True Iron Deposit",
	[230498] = "Thunderlord Cage",
	[230506] = "Thunderlord Cage",
	[230544] = "Touched By Ice",
	[230611] = "Pale Loot Sack",
	[230643] = "Teroclaw Nest",
	[230664] = "The Crystal Blade of Torvath",
	[230865] = "List of Ingredients",
	[230909] = "Forgotten Supplies",
	[230933] = "Defense Pylon Central Control Console",
	[231063] = "Lady Sena's Materials Stash",
	[231064] = "Lady Sena's Other Materials Stash",
	[231069] = "Strange Looking Dagger",
	[231100] = "Icevine",
	[231103] = "Raided Loot",
	[231644] = "Horned Skull",
	[231769] = "Glowing Mushroom",
	[231775] = "Heart of the Magnaron",
	[231901] = "Ogre Scrolls",
	[231903] = "Razzlebeard's Report",
	[231918] = "Laanda's Scroll",
	[232024] = "Warsong Attack Plans",
	[232066] = "Sunken Treasure",
	[232067] = "Stolen Treasure",
	[232090] = "Spark's Stolen Supplies",
	[232214] = "Ogre Booty",
	[232215] = "Gorr'thogg's Personal Reserve",
	[232216] = "Ogre Booty",
	[232217] = "Ogre Booty",
	[232218] = "Doorog's Secret Stash",
	[232219] = "Ogre Booty",
	[232237] = "Ogre Booty",
	[232248] = "Pippers' Buried Supplies",
	[232250] = "Pippers' Buried Supplies",
	[232251] = "Pippers' Buried Supplies",
	[232252] = "Pippers' Buried Supplies",
	[232353] = "Overseer's Chair",
	[232397] = "Bulletin Board",
	[232398] = "Bulletin Board",
	[232400] = "Bulletin Board",
	[232405] = "Wanted Poster",
	[232406] = "Adventurer's Pack",
	[232416] = "Command Board",
	[232458] = "Nizzix's Chest",
	[232492] = "Doomshot",
	[232494] = "Mushroom-Covered Chest",
	[232507] = "Lunarfall Egg",
	[232541] = "Mine Cart",
	[232546] = "Ogre Booty",
	[232547] = "Ogre Booty",
	[232549] = "Ogre Booty",
	[232550] = "Ogre Booty",
	[232571] = "Goblin Pack",
	[232579] = "Kaliri Egg",
	[232582] = "Ashes of A'kumbo",
	[232583] = "Carved Drinking Horn",
	[232584] = "Steamwheedle Supplies",
	[232586] = "Rovo's Dagger",
	[232587] = "Uzko's Knickknacks",
	[232588] = "Greka's Urn",
	[232589] = "Veema's Herb Bag",
	[232590] = "Void-Infused Crystal",
	[232591] = "Beloved's Offering",
	[232592] = "Swamplighter Hive",
	[232595] = "Steamwheedle Supplies",
	[232596] = "Ancestral Greataxe",
	[232597] = "Goblin Pack",
	[232598] = "Steamwheedle Supplies",
	[232599] = "Warsong Spoils",
	[232621] = "Strange Spore",
	[232624] = "Mikkal's Chest",
	[232985] = "Steamwheedle Supplies",
	[232986] = "Hidden Stash",
	[232989] = "Basket of Arakkoa Goods",
	[233032] = "Mountain Climber's Pack",
	[233033] = "Steamwheedle Supplies",
	[233034] = "Steamwheedle Supplies",
	[233044] = "Fungus-Covered Chest",
	[233048] = "Brilliant Dreampetal",
	[233052] = "Steamwheedle Supplies",
	[233079] = "Appropriated Warsong Supplies",
	[233101] = "Sunken Fishing Boat",
	[233103] = "Warsong Lockbox",
	[233107] = "Small Treasure Chest",
	[233113] = "Warsong Spear",
	[233126] = "Shadowmoon Treasure",
	[233132] = "Freshwater Clam",
	[233134] = "Golden Kaliri Egg",
	[233135] = "Warsong Cache",
	[233137] = "Burning Blade Cache",
	[233139] = "Ancient Titan Chest",
	[233149] = "Laughing Skull Cache",
	[233180] = "Iron Horde Bonfire",
	[233206] = "Abandoned Cargo",
	[233218] = "Adventurer's Pack",
	[233229] = "Shadow Council Tome of Curses",
	[233241] = "Glowing Cave Mushroom",
	[233263] = "Blessing of the Wolf",
	[233291] = "Command Board",
	[233391] = "Weaponization Orders",
	[233452] = "A Pile of Dirt",
	[233455] = "Aged Stone Container",
	[233457] = "Adventurer's Staff",
	[233492] = "Elemental Offering",
	[233499] = "Adventurer's Sack",
	[233501] = "Mysterious Petrified Pod",
	[233504] = "Remains of Grimnir Ashpick",
	[233505] = "Unknown Petrified Egg",
	[233507] = "Forgotten Ogre Cache",
	[233511] = "Adventurer's Pack",
	[233513] = "Forgotten Skull Cache",
	[233520] = "Remains of Explorer Engineer Toldirk Ashlamp",
	[233521] = "Warsong Supplies",
	[233522] = "Obsidian Crystal Formation",
	[233523] = "Mysterious Petrified Pod",
	[233524] = "Unknown Petrified Egg",
	[233525] = "Botani Essence Seed",
	[233526] = "Ancient Titan Chest",
	[233532] = "Bone-Carved Dagger",
	[233539] = "Genedar Debris",
	[233549] = "Genedar Debris",
	[233550] = "Unknown Petrified Egg",
	[233551] = "Genedar Debris",
	[233552] = "Aged Stone Container",
	[233555] = "Genedar Debris",
	[233557] = "Genedar Debris",
	[233558] = "Mysterious Petrified Pod",
	[233559] = "Forgotten Skull Cache",
	[233560] = "Fragment of Oshu'gun",
	[233561] = "Pokkar's Thirteenth Axe",
	[233593] = "Polished Saberon Skull",
	[233594] = "Thukmar's Research",
	[233598] = "Elemental Shackles",
	[233611] = "Highmaul Sledge",
	[233613] = "Telaar Defender Shield",
	[233618] = "Ogre Beads",
	[233623] = "Adventurer's Pouch",
	[233626] = "Grizzlemaw's Bonepile",
	[233633] = "Unused Wood Pile",
	[233645] = "Warsong Helm",
	[233649] = "Gambler's Purse",
	[233650] = "Adventurer's Mace",
	[233651] = "Lost Pendant",
	[233658] = "Adventurer's Pouch",
	[233696] = "Important Exploration Supplies",
	[233697] = "Saberon Stash",
	[233715] = "Goldtoe's Plunder",
	[233768] = "Pale Elixir",
	[233773] = "Bag of Herbs",
	[233792] = "Pile of Rubble",
	[233917] = "Femur of Improbability",
	[233956] = "Bloody Blade",
	[233973] = "Bounty of the Elements",
	[233975] = "Rooby's Roo",
	[234054] = "Warm Goren Egg",
	[234147] = "Outcast's Belongings",
	[234154] = "Misplaced Scrolls",
	[234155] = "Relics of the Outcasts",
	[234157] = "Fractured Sunstone",
	[234159] = "Lost Herb Satchel",
	[234243] = "Overly Gaudy Note",
	[234432] = "Ogron Plunder",
	[234446] = "Relics of the Outcasts",
	[234449] = "Relics of the Outcasts",
	[234451] = "Relics of the Outcasts",
	[234454] = "Relics of the Outcasts",
	[234455] = "Relics of the Outcasts",
	[234456] = "Shattered Hand Lockbox",
	[234457] = "Fruit Basket",
	[234458] = "Shattered Hand Cache",
	[234461] = "Toxicfang Venom",
	[234471] = "Spray-O-Matic 5000 XT",
	[234472] = "Sailor Zazzuk's 180-Proof Rum",
	[234473] = "Campaign Contributions",
	[234474] = "Saberon Stash",
	[234618] = "Gift of Anzu",
	[234685] = "Secret Warplans",
	[234703] = "Elixir of Shadow Sight",
	[234704] = "Elixir of Shadow Sight",
	[234705] = "Elixir of Shadow Sight",
	[234734] = "Elixir of Shadow Sight",
	[234735] = "Elixir of Shadow Sight",
	[234736] = "Elixir of Shadow Sight",
	[234740] = "Orcish Signaling Horn",
	[234744] = "Offering to the Raven Mother",
	[234746] = "Offering to the Raven Mother",
	[234748] = "Offering to the Raven Mother",
	[235073] = "Offering to the Raven Mother",
	[235090] = "Offering to the Raven Mother",
	[235091] = "Lost Ring",
	[235095] = "Misplaced Scroll",
	[235097] = "Ephial's Dark Grimoire",
	[235103] = "Garrison Supplies",
	[235104] = "Sun-Touched Cache",
	[235105] = "Sun-Touched Cache",
	[235127] = "Mysterious Petrified Pod",
	[235129] = "Enriched Seeds",
	[235135] = "Smuggled Apexis Artifacts",
	[235141] = "Iron Horde Explosives",
	[235143] = "Assassin's Spear",
	[235168] = "Outcast's Pouch",
	[235172] = "Outcast's Belongings",
	[235282] = "Sethekk Ritual Brew",
	[235289] = "Garrison Workman's Hammer",
	[235299] = "Coinbender's Payment",
	[235300] = "Mysterious Mushrooms",
	[235307] = "Watertight Bag",
	[235310] = "Shredder Parts",
	[235313] = "Abandoned Mining Pick",
	[235365] = "Admiral Taylor's Coffer",
	[235673] = "A Restless Crate",
	[235826] = "Giant Rylak Egg",
	[235859] = "Brokor's Sack",
	[235860] = "Orc Skeleton",
	[235869] = "Weapons Cache",
	[235881] = "Petrified Rylak Egg",
	[236092] = "Stashed Emergency Rucksack",
	[236096] = "Remains of Balldir Deeprock",
	[236099] = "Suntouched Spear",
	[236138] = "Iron Supply Chest",
	[236139] = "Explorer Canister",
	[236140] = "Goren Tunnel",
	[236141] = "Discarded Pack",
	[236147] = "Vindicator's Hammer",
	[236149] = "Sasha's Secret Stash",
	[236158] = "Sniper's Crossbow",
	[236165] = "War Planning Map",
	[236169] = "Harvestable Precious Crystal",
	[236170] = "Remains of Balik Orecrusher",
	[236178] = "Evermorn Supply Cache",
	[236206] = "War Planning Map",
	[236257] = "Ancient Titan Chest",
	[236258] = "Unknown Petrified Egg",
	[236259] = "Mysterious Petrified Pod",
	[236260] = "Mysterious Petrified Pod",
	[236264] = "Forgotten Skull Cache",
	[236265] = "Aged Stone Container",
	[236266] = "Unknown Petrified Egg",
	[236267] = "Ancient Titan Chest",
	[236269] = "Obsidian Crystal Formation",
	[236270] = "Aged Stone Container",
	[236271] = "Aged Stone Container",
	[236274] = "Aged Stone Container",
	[236275] = "Ancient Titan Chest",
	[236276] = "Obsidian Crystal Formation",
	[236278] = "Obsidian Crystal Formation",
	[236279] = "Aged Stone Container",
	[236280] = "Ancient Titan Chest",
	[236282] = "Obsidian Crystal Formation",
	[236284] = "Ancient Ogre Cache",
	[236285] = "Aged Stone Container",
	[236288] = "Ancient Titan Chest",
	[236289] = "Aged Stone Container",
	[236348] = "Ancient Ogre Cache",
	[236349] = "Ancient Titan Chest",
	[236350] = "Aged Stone Container",
	[236351] = "Ancient Ogre Cache",
	[236399] = "Aged Stone Container",
	[236400] = "Ancient Ogre Cache",
	[236402] = "Ancient Titan Chest",
	[236404] = "Aged Stone Container",
	[236406] = "Ancient Ogre Cache",
	[236407] = "Ancient Ogre Cache",
	[236483] = "Gift of the Ancients",
	[236610] = "Spirit's Gift",
	[236633] = "Smuggler's Cache",
	[236693] = "Iron Horde Munitions",
	[236715] = "Odd Skull",
	[236755] = "Dusty Lockbox",
	[236935] = "Burning Blade Cache",
	[237016] = "Wanted: Kuu'rat",
	[237021] = "Wanted: Kliaa's Stinger",
	[237022] = "Command Board",
	[237343] = "Keg of Impaler Ale",
	[237452] = "Iron Horde Chest",
	[237461] = "Olaf's Shield",
	[237462] = "Horribly Acidic Solution",
	[237463] = "Strange Brass Compass",
	[237464] = "Soulsever Blade",
	[237465] = "Soulweave Vessel",
	[237466] = "Sun Crystal",
	[237467] = "Pristine Plumage",
	[237468] = "Pip's Improved Skinner",
	[237469] = "Shed Proto-Dragon Claw",
	[237470] = "Dark Parchment",
	[237471] = "Silver-Lined Arrow",
	[237472] = "Strangely-Glowing Frond",
	[237473] = "Overgrown Artifact",
	[237474] = "Huge Crate of Weapons",
	[237475] = "Iron Limbcleaver",
	[237476] = "Miniature Iron Star",
	[237477] = "Ogre Family Tree",
	[237478] = "Very Shiny Thing",
	[237479] = "Nightmare Bell",
	[237480] = "Bottled Windstorm",
	[237481] = "Bottled Flamefly",
	[237482] = "Void-Gate Key",
	[237483] = "Rustling Peachick Nest",
	[237484] = "Iron Autocannon",
	[237511] = "Strange Spore",
	[237751] = "Iron Horde Attack Orders",
	[237821] = "Bladefury's Orders",
	[237946] = "Spirit Coffer",
	[239120] = "Okuna Longtusk's Pack",
	[239143] = "Glass of Warm Milk",
	[239171] = "Glass of Warm Milk",
	[239194] = "Norana's Cache",
	[239198] = "Isaari's Cache",
	[239328] = "Captain's Foot Locker",
	[239791] = "Relic Hunting Notes",
	[239803] = "Treasure Chest",
	[239828] = "Edge of Reality",
	[239901] = "Voidtalon Egg",
	[239925] = "Ogrish Fortitude",
	[239926] = "Touched By Fire",
	[240003] = "Strange Sapphire",
	[240215] = "Ashes of a Fallen Crusader",
	[240289] = "Weathered Axe",
	[240317] = "Iskar's Tome of Shadows",
	[240353] = "Seemingly Unguarded Treasure",
	[240354] = "Genuinely Unguarded Treasure",
	[240519] = "Small Treasure Chest",
	[240543] = "Stolen Captain's Chest",
	[240547] = "Orc Skull",
	[240577] = "The Blade of Kra'nak",
	[240580] = "Jewel of Hellfire",
	[240605] = "Small Treasure Chest",
	[240608] = "Small Treasure Chest",
	[240609] = "Small Treasure Chest",
	[240612] = "Small Treasure Chest",
	[240614] = "Small Treasure Chest",
	[240616] = "Frozen Supplies",
	[240617] = "Lost Sentinel's Pouch",
	[240619] = "Small Treasure Chest",
	[240622] = "Warden's Scroll Case",
	[240623] = "Sylvanas' Strongbox",
	[240624] = "Faerie Dragon Nest",
	[240625] = "High Priestess' Reliquary",
	[240629] = "Treasure Chest",
	[240630] = "Small Treasure Chest",
	[240631] = "Treasure Chest",
	[240634] = "Treasure Chest",
	[240635] = "Treasure Chest",
	[240637] = "Glimmering Treasure Chest",
	[240638] = "Disputed Treasure",
	[240639] = "Glimmering Treasure Chest",
	[240641] = "Treasure Chest",
	[240642] = "Treasure Chest",
	[240643] = "Treasure Chest",
	[240644] = "Small Treasure Chest",
	[240645] = "Glimmering Treasure Chest",
	[240646] = "Treasure Chest",
	[240649] = "Small Treasure Chest",
	[240651] = "Small Treasure Chest",
	[240652] = "Treasure Chest",
	[240653] = "Small Treasure Chest",
	[240654] = "Small Treasure Chest",
	[240655] = "Glimmering Treasure Chest",
	[240657] = "Small Treasure Chest",
	[240690] = "Treasure Chest",
	[240855] = "Tome of Secrets",
	[241128] = "Unguarded Thistleleaf Treasure",
	[241146] = "Treasure Chest",
	[241147] = "Small Treasure Chest",
	[241148] = "Small Treasure Chest",
	[241149] = "Small Treasure Chest",
	[241150] = "Small Treasure Chest",
	[241151] = "Small Treasure Chest",
	[241152] = "Treasure Chest",
	[241153] = "Small Treasure Chest",
	[241154] = "Small Treasure Chest",
	[241155] = "Treasure Chest",
	[241180] = "Treasure Chest",
	[241206] = "Small Treasure Chest",
	[241207] = "Small Treasure Chest",
	[241208] = "Treasure Chest",
	[241212] = "Treasure Chest",
	[241213] = "Small Treasure Chest",
	[241216] = "Treasure Chest",
	[241267] = "Small Treasure Chest",
	[241272] = "Treasure Chest",
	[241280] = "Treasure Chest",
	[241433] = "Forgotten Sack",
	[241434] = "Lodged Hunting Spear",
	[241449] = "Blackfang Island Cache",
	[241450] = "Crystallized Fel Spike",
	[241504] = "Polished Crystal",
	[241518] = "Small Treasure Chest",
	[241521] = "Snake Charmer's Flute",
	[241522] = "The Perfect Blossom",
	[241524] = "Pale Removal Equipment",
	[241533] = "Forgotten Champion's Blade",
	[241557] = "Small Treasure Chest",
	[241558] = "Treasure Chest",
	[241560] = "Bleeding Hollow Warchest",
	[241561] = "Jewel of the Fallen Star",
	[241562] = "Small Treasure Chest",
	[241563] = "Censer of Torment",
	[241564] = "Small Treasure Chest",
	[241565] = "Looted Bleeding Hollow Treasure",
	[241566] = "Rune Etched Femur",
	[241599] = "Strange Fruit",
	[241600] = "Discarded Helm",
	[241601] = "Scout's Belongings",
	[241602] = "Forgotten Iron Horde Supplies",
	[241605] = "Crystalized Essence of the Elements",
	[241641] = "Foxflower",
	[241656] = "Overgrown Relic",
	[241657] = "Jeweled Arakkoa Effigy",
	[241664] = "Borrowed Enchanted Spyglass",
	[241665] = "Treasure Chest",
	[241666] = "Mysterious Corrupted Obelisk",
	[241671] = "Forgotten Shard of the Cipher",
	[241673] = "Looted Bleeding Hollow Treasure",
	[241674] = "Skull of the Mad Chief",
	[241680] = "Small Treasure Chest",
	[241692] = "Axe of the Weeping Wolf",
	[241699] = "Spoils of War",
	[241712] = "Ironbeard's Treasure",
	[241713] = "The Eye of Grannok",
	[241714] = "Stashed Iron Sea Booty",
	[241715] = "Stashed Iron Sea Booty",
	[241716] = "Stashed Iron Sea Booty",
	[241717] = "Glimmering Treasure Chest",
	[241726] = "Leystone Deposit",
	[241742] = "Book of Zyzzix",
	[241743] = "Felslate Deposit",
	[241745] = "Fel-Drenched Satchel",
	[241760] = "Sacrificial Blade",
	[241764] = "Stashed Bleeding Hollow Loot",
	[241767] = "Treasure Chest",
	[241772] = "Treasure Chest",
	[241773] = "Small Treasure Chest",
	[241775] = "Brazier of Awakening",
	[241835] = "Bleeding Hollow Mushroom Stash",
	[241841] = "Looted Mystical Staff",
	[241847] = "The Commander's Shield",
	[241848] = "Dazzling Rod",
	[242242] = "Small Treasure Chest",
	[242249] = "Partially Mined Apexis Crystal",
	[242250] = "Small Treasure Chest",
	[242328] = "Small Treasure Chest",
	[242350] = "Treasure Chest",
	[242446] = "Small Treasure Chest",
	[242642] = "Small Treasure Chest",
	[242643] = "Small Treasure Chest",
	[242644] = "Treasure Chest",
	[242645] = "Small Treasure Chest",
	[242646] = "Small Treasure Chest",
	[242647] = "Treasure Chest",
	[242649] = "Fel-Tainted Apexis Formation",
	[242660] = "Small Treasure Chest",
	[242662] = "Small Treasure Chest",
	[242663] = "Small Treasure Chest",
	[242664] = "Treasure Chest",
	[242665] = "Small Treasure Chest",
	[242666] = "Treasure Chest",
	[242667] = "Small Treasure Chest",
	[242668] = "Glimmering Treasure Chest",
	[242669] = "Small Treasure Chest",
	[242670] = "Treasure Chest",
	[242671] = "Glimmering Treasure Chest",
	[242675] = "Small Treasure Chest",
	[242678] = "Treasure Chest",
	[242683] = "Treasure Chest",
	[242959] = "Treasure Chest",
	[243280] = "Pirate Pepe",
	[243281] = "Ninja Pepe",
	[243282] = "Viking Pepe",
	[243283] = "Knight Pepe",
	[243321] = "Feral Stone",
	[243323] = "Balance Stone",
	[243392] = "Alchemy Book",
	[243688] = "Treasure Chest",
	[243690] = "Bejeweled Egg",
	[243693] = "Dead Man's Chest",
	[243698] = "Glimmering Treasure Chest",
	[243773] = "Treasure Chest",
	[243798] = "A Steamy Jewelry Box",
	[243899] = "Broken Ley Flame Burner",
	[243911] = "Snow Mound",
	[244447] = "White Murloc Egg",
	[244453] = "Cullen's Scouting Report",
	[244473] = "Thunder Totem Stolen Goods",
	[244494] = "Treasure Chest",
	[244519] = "Treasure Chest",
	[244628] = "Taurson's Prize",
	[244651] = "Steamy Romance Novel",
	[244678] = "|cFFFFFFFFStep 8:|r Page 5555",
	[244689] = "Small Treasure Chest",
	[244691] = "Small Treasure Chest",
	[244692] = "Small Treasure Chest",
	[244694] = "Small Treasure Chest",
	[244698] = "Small Treasure Chest",
	[244699] = "Small Treasure Chest",
	[244700] = "Small Treasure Chest",
	[244701] = "Small Treasure Chest",
	[244774] = "Aethril",
	[244775] = "Dreamleaf",
	[244776] = "Dreamleaf",
	[244777] = "Fjarnskaggl",
	[244778] = "Starlight Rose",
	[244786] = "Felwort",
	[244887] = "Small Treasure Chest",
	[244899] = "Small Treasure Chest",
	[244901] = "Treasure Chest",
	[244902] = "Treasure Chest",
	[244903] = "Treasure Chest",
	[244904] = "Small Treasure Chest",
	[244905] = "Small Treasure Chest",
	[244909] = "Small Treasure Chest",
	[244912] = "Small Treasure Chest",
	[244913] = "Treasure Chest",
	[244917] = "Treasure Chest",
	[244928] = "Glimmering Treasure Chest",
	[244965] = "Sheddle's Chest",
	[244986] = "Legion Portal",
	[245216] = "|cFFFFFFFFStep 3:|r Page 161",
	[245286] = "Crystalline Cat Figurine",
	[245316] = "Small Treasure Chest",
	[245324] = "Rich Leystone Deposit",
	[245325] = "Rich Felslate Deposit",
	[245328] = "Enchanted Scroll",
	[245345] = "Small Treasure Chest",
	[245479] = "Battered Chest",
	[245524] = "Treasure Chest",
	[245525] = "Small Treasure Chest",
	[245527] = "Treasure Chest",
	[245528] = "Treasure Chest",
	[245529] = "Small Treasure Chest",
	[245530] = "Glimmering Treasure Chest",
	[245531] = "Treasure Chest",
	[245532] = "Treasure Chest",
	[245533] = "Treasure Chest",
	[245534] = "Small Treasure Chest",
	[245535] = "Small Treasure Chest",
	[245536] = "Glimmering Treasure Chest",
	[245537] = "Glimmering Treasure Chest",
	[245538] = "Small Treasure Chest",
	[245541] = "Small Treasure Chest",
	[245542] = "Treasure Chest",
	[245543] = "Treasure Chest",
	[245545] = "Small Treasure Chest",
	[245547] = "Small Treasure Chest",
	[245548] = "Treasure Chest",
	[245550] = "Treasure Chest",
	[245551] = "Small Treasure Chest",
	[245553] = "Treasure Chest",
	[245554] = "Small Treasure Chest",
	[245555] = "Small Treasure Chest",
	[245579] = "Treasure Chest",
	[245580] = "Small Treasure Chest",
	[245581] = "Small Treasure Chest",
	[245601] = "Small Treasure Chest",
	[245602] = "Treasure Chest",
	[245603] = "Small Treasure Chest",
	[245688] = "Shattered Burial Urn",
	[245793] = "Battered Journal",
	[245941] = "Warp Cache",
	[245996] = "Small Treasure Chest",
	[246037] = "Treasure Chest",
	[246147] = "Small Treasure Chest",
	[246154] = "Broken Toy Box",
	[246205] = "Small Treasure Chest",
	[246206] = "Small Treasure Chest",
	[246249] = "Small Treasure Chest",
	[246250] = "Letter From Jabrul",
	[246254] = "Dusty Coffer",
	[246269] = "Small Treasure Chest",
	[246309] = "Small Treasure Chest",
	[246353] = "Small Treasure Chest",
	[246438] = "Blingtron Circuit Design",
	[246524] = "Small Treasure Chest",
	[246555] = "Small Treasure Chest",
	[246556] = "Small Treasure Chest",
	[246557] = "Small Treasure Chest",
	[246558] = "Small Treasure Chest",
	[246559] = "Small Treasure Chest",
	[246560] = "Small Treasure Chest",
	[246561] = "Small Treasure Chest",
	[246562] = "Small Treasure Chest",
	[247694] = "Kel'danath's Knapsack",
	[247797] = "Lost Mail",
	[247999] = "Felwort",
	[248000] = "Felwort",
	[248001] = "Felwort",
	[248002] = "Felwort",
	[248003] = "Felwort",
	[248004] = "Felwort",
	[248005] = "Felwort",
	[248006] = "Felwort",
	[248007] = "Felwort",
	[248008] = "Felwort",
	[248009] = "Felwort",
	[248010] = "Felwort",
	[248011] = "Felwort",
	[248012] = "Felwort",
	[248398] = "Ethereal Communication Device",
	[248534] = "Tears of Elune",
	[248854] = "Desmond's Lockbox",
	[249211] = "Torn Shaldorei Silk",
	[249997] = "Small Treasure Chest",
	[250080] = "Small Treasure Chest",
	[250081] = "Small Treasure Chest",
	[250083] = "Small Treasure Chest",
	[250084] = "Small Treasure Chest",
	[250085] = "Small Treasure Chest",
	[250087] = "Small Treasure Chest",
	[250088] = "Small Treasure Chest",
	[250090] = "Small Treasure Chest",
	[250091] = "Small Treasure Chest",
	[250092] = "Treasure Chest",
	[250097] = "Small Treasure Chest",
	[250098] = "Small Treasure Chest",
	[250102] = "Treasure Chest",
	[250103] = "Small Treasure Chest",
	[250104] = "Small Treasure Chest",
	[250106] = "Small Treasure Chest",
	[250107] = "Glimmering Treasure Chest",
	[250108] = "Small Treasure Chest",
	[250109] = "Treasure Chest",
	[250383] = "Moonshade Relic",
	[250541] = "Treasure Chest",
	[250984] = "Small Treasure Chest",
	[250985] = "Treasure Chest",
	[250987] = "Small Treasure Chest",
	[251032] = "Armoire",
	[251124] = "Glimmering Treasure Chest",
	[251168] = "Ephemeral Crystal",
	[251218] = "Rollo's Runestone",
	[251220] = "Ragnar's Runestone",
	[251221] = "Floki's Runestone",
	[251416] = "Ancient Mana Chunk",
	[251552] = "Small Treasure Chest",
	[251564] = "|cFFFFFFFFStep 4:|r Page 655",
	[251713] = "Small Treasure Chest",
	[251714] = "Small Treasure Chest",
	[251716] = "Glimmering Treasure Chest",
	[251719] = "Small Treasure Chest",
	[251720] = "Small Treasure Chest",
	[251723] = "Small Treasure Chest",
	[251737] = "Treasure Chest",
	[251738] = "Treasure Chest",
	[251761] = "Small Treasure Chest",
	[251762] = "Small Treasure Chest",
	[251764] = "Small Treasure Chest",
	[251772] = "Small Treasure Chest",
	[251776] = "Small Treasure Chest",
	[251780] = "Small Treasure Chest",
	[251782] = "Small Treasure Chest",
	[251792] = "Small Treasure Chest",
	[251820] = "Treasure Chest",
	[251851] = "Small Treasure Chest",
	[251853] = "Small Treasure Chest",
	[251854] = "Small Treasure Chest",
	[251856] = "Small Treasure Chest",
	[251857] = "Treasure Chest",
	[251991] = "The Aegis of Aggramar",
	[252069] = "Alaina's Belongings",
	[252107] = "Unpowered Telemancy Beacon",
	[252232] = "Aponi's Libram",
	[252258] = "Leyline Feed",
	[252259] = "Leyline Feed",
	[252260] = "Leyline Feed",
	[252261] = "Leyline Feed",
	[252262] = "Leyline Feed",
	[252263] = "Leyline Feed",
	[252264] = "Leyline Feed",
	[252267] = "Large Plundered Sack",
	[252269] = "Pack of Battle Potions",
	[252270] = "Mysterious Crate",
	[252272] = "Smoky Boots",
	[252273] = "Box of Throwing Daggers",
	[252277] = "Thistle Tea",
	[252279] = "Stolen Tome of Artifact Lore",
	[252282] = "Sparkling Set of Keys",
	[252284] = "Pile of Sticky Bombs",
	[252289] = "Vanishing Powder",
	[252331] = "Traveller Pepe",
	[252385] = "Torn Page",
	[252386] = "Worn-Edged Page",
	[252387] = "Dog-Eared Page",
	[252388] = "Singed Page",
	[252390] = "Ink-splattered Page",
	[252391] = "Hastily-Scrawled Page",
	[252395] = "Deathcharger Hitching Post",
	[252404] = "Felwort",
	[252412] = "|cFFFFFFFFStep 2:|r Mound of Dirt",
	[252432] = "Shimmering Ancient Mana Cluster",
	[252434] = "|cFFFFFFFFStep 12:|r Hungering Orb X",
	[252446] = "Shimmering Ancient Mana Cluster",
	[252447] = "Shimmering Ancient Mana Cluster",
	[252448] = "Shimmering Ancient Mana Cluster",
	[252449] = "Shimmering Ancient Mana Cluster",
	[252450] = "Shimmering Ancient Mana Cluster",
	[252557] = "|cFFFFFFFFStep 3:|r Hungering Orb I",
	[252558] = "|cFFFFFFFFStep 4:|r Hungering Orb II",
	[252559] = "|cFFFFFFFFStep 5:|r Hungering Orb III",
	[252560] = "|cFFFFFFFFStep 6:|r Hungering Orb IV",
	[252561] = "|cFFFFFFFFStep 7:|r Hungering Orb V",
	[252562] = "|cFFFFFFFFStep 8:|r Hungering Orb VI",
	[252563] = "|cFFFFFFFFStep 9:|r Hungering Orb VII",
	[252564] = "|cFFFFFFFFStep 10:|r Hungering Orb VIII",
	[252565] = "|cFFFFFFFFStep 11:|r Hungering Orb IX",
	[252570] = "Skyhold Chest of Riches",
	[252802] = "Small Treasure Chest",
	[252803] = "Small Treasure Chest",
	[252805] = "Treasure Chest",
	[252806] = "Small Treasure Chest",
	[252807] = "Small Treasure Chest",
	[252808] = "Small Treasure Chest",
	[252810] = "Small Treasure Chest",
	[252812] = "Treasure Chest",
	[252813] = "Small Treasure Chest",
	[252814] = "Unpowered Telemancy Beacon",
	[252815] = "Unpowered Telemancy Beacon",
	[252816] = "Unpowered Telemancy Beacon",
	[252817] = "Unpowered Telemancy Beacon",
	[252819] = "Small Treasure Chest",
	[252820] = "Small Treasure Chest",
	[252821] = "Treasure Chest",
	[252822] = "Glimmering Treasure Chest",
	[252824] = "Treasure Chest",
	[252828] = "Small Treasure Chest",
	[252829] = "Small Treasure Chest",
	[252830] = "Small Treasure Chest",
	[252831] = "Glimmering Treasure Chest",
	[252833] = "Treasure Chest",
	[252834] = "Small Treasure Chest",
	[252835] = "Small Treasure Chest",
	[252836] = "Small Treasure Chest",
	[252837] = "Treasure Chest",
	[252838] = "Treasure Chest",
	[252839] = "Small Treasure Chest",
	[252840] = "Small Treasure Chest",
	[252841] = "Small Treasure Chest",
	[252842] = "Treasure Chest",
	[252844] = "Treasure Chest",
	[252850] = "Small Treasure Chest",
	[252860] = "Small Treasure Chest",
	[252876] = "Small Treasure Chest",
	[252880] = "Treasure Chest",
	[252881] = "Treasure Chest",
	[252882] = "Treasure Chest",
	[252883] = "Treasure Chest",
	[252884] = "Glimmering Treasure Chest",
	[253161] = "Grove Vine",
	[253280] = "Leystone Seam",
	[253452] = "Beginner's Guide to Dimensional Rifting Ch. 1  - Navigating Through Time",
	[253453] = "Beginner's Guide to Dimensional Rifting Ch. 2  - Holy Places to Many",
	[253454] = "Beginner's Guide to Dimensional Rifting Ch. 3  - Water, Just Water",
	[253455] = "Beginner's Guide to Dimensional Rifting Ch. 4  - Risks and Rewards",
	[253456] = "Beginner's Guide to Dimensional Rifting Ch. 5  - Finding Others Along the Way",
	[253457] = "Beginner's Guide to Dimensional Rifting Ch. 6  - Pent up Energy",
	[253458] = "Beginner's Guide to Dimensional Rifting Ch. 7  - Our Legacy",
	[253994] = "Seemingly Unguarded Treasure",
	[254007] = "Executioner's Altar",
	[254010] = "Earthen Ring Supplies",
	[254025] = "Small Treasure Chest",
	[254027] = "Small Treasure Chest",
	[254028] = "Small Treasure Chest",
	[254126] = "Small Treasure Chest",
	[254127] = "Small Treasure Chest",
	[254128] = "Treasure Chest",
	[254141] = "Small Treasure Chest",
	[254262] = "Owl of the Watchers",
	[255344] = "Felslate Seam",
	[255828] = "Small Treasure Chest",
	[255829] = "Small Treasure Chest",
	[255963] = "Vrykul Ancestral Chest",
	[256790] = "Elven Treasure Chest",
	[257290] = "Highmountain Clan Chest",
	[257291] = "Nightborne Treasure Chest",
	[257393] = "Treasure Chest",
	[257545] = "Treasure Chest",
	[257546] = "Treasure Chest",
	[257978] = "Treasure Chest",
	[257999] = "Technique: Tome of the Tranquil Mind",
	[258690] = "Small Treasure Chest",
	[258978] = "Waterlogged Tome",
	[258979] = "Fel-Ravaged Tome",
	[258980] = "Cursed Tome",
	[259806] = "Love Potion Recipe",
	[265526] = "Treasure Chest",
	[265532] = "Telemancy Beacon",
	[265602] = "Sealed Tome",
	[266289] = "Time Lost Chest",
	[266851] = "Wand of Simulated Life",
	[268478] = "Battered Trinket",
	[268551] = "Curious Wyrmtongue Cache",
	[268753] = "Small Treasure Chest",
	[269037] = "Loose Pebble",
	[269064] = "Small Treasure Chest",
	[269830] = "|cFFFFFFFFStep 9:|r Gift of the Mind-Seekers",
	[270855] = "|cFFFFFFFFStep 1:|r Inconspicuous Note",
	[270917] = "Glenbrook Register",
	[271103] = "Prayer Effigy",
	[271706] = "Hunters' Board",
	[271849] = "Eredar War Supplies",
	[271850] = "Eredar War Supplies",
	[272039] = "|cFFFFFFFFStep 2:|r Inconspicuous Note",
	[272046] = "|cFFFFFFFFStep 3:|r Mind Larva",
	[272061] = "|cFFFFFFFFStep 4:|r Inconspicuous Note",
	[272163] = "|cFFFFFFFFStep 5:|r Strange Skull",
	[272165] = "|cFFFFFFFFStep 6:|r Inconspicuous Note",
	[272172] = "|cFFFFFFFFStep 7:|r Inconspicuous Note",
	[272179] = "Mayor's Bulletin",
	[272181] = "|cFFFFFFFFStep 8:|r Inconspicuous Note",
	[272220] = "|cFFFFFFFFStep 9:|r Inconspicuous Note",
	[272270] = "|cFFFFFFFFStep 10:|r Puzzler's Desire",
	[272422] = "Gentle's Spellbook",
	[272434] = "Water Stone",
	[272455] = "Eredar War Supplies",
	[272456] = "Eredar War Supplies",
	[272487] = "|cFFFFFFFFStep 14:|r Oddly-Colored Egg",
	[272768] = "Empyrium Deposit",
	[272770] = "Eredar War Supplies",
	[272771] = "Eredar War Supplies",
	[272778] = "Rich Empyrium Deposit",
	[272780] = "Empyrium Seam",
	[272782] = "Astral Glory",
	[273052] = "Fel-Encrusted Herb",
	[273053] = "Fel-Encrusted Herb Cluster",
	[273222] = "Eredar War Supplies",
	[273301] = "Ancient Eredar Cache",
	[273407] = "Ancient Eredar Cache",
	[273412] = "Ancient Eredar Cache",
	[273414] = "Ancient Eredar Cache",
	[273415] = "Ancient Eredar Cache",
	[273439] = "Ancient Eredar Cache",
	[273443] = "Void-Seeped Cache",
	[273519] = "Legion War Supplies",
	[273521] = "Legion War Supplies",
	[273523] = "Legion War Supplies",
	[273524] = "Legion War Supplies",
	[273527] = "Legion War Supplies",
	[273528] = "Legion War Supplies",
	[273533] = "Legion War Supplies",
	[273535] = "Legion War Supplies",
	[273538] = "Legion War Supplies",
	[273814] = "Bladed Charm",
	[273854] = "Backpack",
	[276187] = "Junji",
	[276223] = "Eredar Treasure Cache",
	[276224] = "Chest of Ill-Gotten Gains",
	[276225] = "Student's Surprising Surplus",
	[276226] = "Void-Tinged Chest",
	[276227] = "Augari Secret Stash",
	[276228] = "Desperate Eredar's Cache",
	[276229] = "Shattered House Chest",
	[276230] = "Doomseeker's Treasure",
	[276234] = "Riverbud",
	[276236] = "Star Moss",
	[276237] = "Akunda's Bite",
	[276238] = "Winter's Kiss",
	[276239] = "Siren's Sting",
	[276240] = "Sea Stalks",
	[276242] = "Anchor Weed",
	[276251] = "Excavation Inventory",
	[276424] = "Intact Imp Bones",
	[276425] = "Intact Fiend Bone",
	[276426] = "Intact Ur'zul Bone",
	[276488] = "Azurite Cannonball",
	[276489] = "Legion Tower Chest",
	[276490] = "Krokul Emergency Cache",
	[276491] = "Lost Krokul Chest",
	[276513] = "Intact Mudfish",
	[276515] = "Fishing Rod",
	[276616] = "Monelite Deposit",
	[276617] = "Storm Silver Deposit",
	[276618] = "Platinum Deposit",
	[276619] = "Monelite Seam",
	[276620] = "Storm Silver Seam",
	[276621] = "Rich Monelite Deposit",
	[276622] = "Rich Storm Silver Deposit",
	[276623] = "Treasure Chest",
	[276735] = "Offerings of the Chosen",
	[276837] = "Recipe Rock",
	[277199] = "Weathered Job List",
	[277204] = "Forgotten Legion Supplies",
	[277205] = "Ancient Legion War Cache",
	[277206] = "Fel-Bound Chest",
	[277207] = "Legion Treasure Hoard",
	[277208] = "Timeworn Fel Chest",
	[277327] = "Augari-Runed Chest",
	[277333] = "Ancient Sarcophagus",
	[277336] = "Treasure Chest",
	[277340] = "Secret Augari Chest",
	[277342] = "Augari Goods",
	[277343] = "Long-Lost Augari Treasure",
	[277344] = "Precious Augari Keepsakes",
	[277346] = "Missing Augari Chest",
	[277373] = "Glimmering Seaweed",
	[277384] = "Abandoned Treasure",
	[277444] = "Reclaimed Bijous",
	[277447] = "Venerated Remains",
	[277459] = "Pig Effigy",
	[277561] = "Warlord's Cache",
	[277637] = "Void-Seeped Cache",
	[277715] = "Cursed Nazmani Chest",
	[277885] = "Wunja's Trove",
	[277886] = "Grimoire of the Other Side",
	[277897] = "Seething Cache",
	[278197] = "Vial of Antidote",
	[278252] = "Job Flyer",
	[278313] = "Sternly Worded Letter",
	[278368] = "Tattered Note",
	[278432] = "Obviously Safe Chest",
	[278436] = "Shipwrecked Chest",
	[278437] = "Offering to Bwonsamdi",
	[278447] = "Faithless Trapper's Spear",
	[278453] = "Voodoo Totem",
	[278456] = "Treasure Chest",
	[278461] = "Treasure Chest",
	[278462] = "Treasure Chest",
	[278570] = "Ancient Journal",
	[278577] = "Torn Horde Missive",
	[278669] = "Fallhaven Ledger",
	[278675] = "Cursed Effigy",
	[278694] = "Treasure Chest",
	[278793] = "Treasure Chest",
	[279042] = "Smuggler's Stash",
	[279044] = "Zandalari Rushes",
	[279253] = "Lucky Horace's Lucky Chest",
	[279260] = "Cleverly Disguised Chest",
	[279299] = "Venomous Seal",
	[279609] = "Spoils of Pandaria",
	[279645] = "Tome of Oblivion",
	[279646] = "Bloodguard Chronicles",
	[279647] = "Tome of Sacrifice",
	[279689] = "Lost Nazmani Treasure",
	[279750] = "Hay Covered Chest",
	[280504] = "Swallowed Naga Chest",
	[280522] = "Partially-Digested Treasure",
	[280576] = "Encased Scroll",
	[280619] = "Old Ironbound Chest",
	[280727] = "Charred Note",
	[280747] = "Shadow Tear",
	[280755] = "Quintin's Satchel",
	[280815] = "|cFFFFFFFFStep 1:|r Letter from Ms. Graham I",
	[280836] = "|cFFFFFFFFStep 2:|r Letter from Ms. Graham II",
	[280837] = "|cFFFFFFFFStep 3:|r Letter from Ms. Graham III",
	[280838] = "|cFFFFFFFFStep 4:|r Letter from Ms. Graham IV",
	[280842] = "|cFFFFFFFFStep 5:|r Letter from Ms. Graham V",
	[280843] = "|cFFFFFFFFStep 6:|r Letter from Ms. Graham VI",
	[280844] = "|cFFFFFFFFStep 7:|r Letter from Ms. Graham VII",
	[280845] = "|cFFFFFFFFStep 8:|r Gift for Ms. Graham",
	[280883] = "Sun-Worn Chest",
	[280886] = "Star-Touched Chest",
	[280903] = "Lost Cat Toy",
	[280948] = "Twilight Outhouse",
	[280951] = "Ashvane Spoils",
	[280957] = "Zukashi's Satchel",
	[281079] = "Star Moss",
	[281092] = "Witch Doctor's Hoard",
	[281230] = "Formal Invitation",
	[281312] = "Stolen Supplies",
	[281326] = "Falcon Cage",
	[281348] = "Crumbling Letter",
	[281397] = "Cutwater Treasure Chest",
	[281494] = "Frosty Treasure Chest",
	[281551] = "Help Wanted Poster",
	[281583] = "Ancient Reliquary",
	[281639] = "Crumbling Statue",
	[281646] = "Honey Vat",
	[281647] = "Posted Notice",
	[281655] = "Gift of the Brokenhearted",
	[281673] = "Corlain Citizen's Journal",
	[281718] = "HELP WANTED",
	[281867] = "Star Moss",
	[281868] = "Star Moss",
	[281869] = "Siren's Sting",
	[281870] = "Riverbud",
	[281872] = "Sea Stalks",
	[281898] = "Dazar's Forgotten Chest",
	[282153] = "Sunken Strongbox",
	[282457] = "Brambleguard Totem",
	[282478] = "Empty Crate",
	[282498] = "Desert Flute",
	[282666] = "Urn of Agussu",
	[282721] = "Treasure Chest",
	[282723] = "Treasure Chest",
	[284411] = "Treasure Chest",
	[284417] = "Treasure Chest",
	[284421] = "Treasure Chest",
	[284426] = "Buried Mining Machine",
	[284448] = "Hidden Scholar's Chest",
	[284454] = "Da White Shark's Bounty",
	[284455] = "The Exile's Lament",
	[286016] = "Ship's Log",
	[286954] = "Bot Buster Bomb",
	[287081] = "Ancient Tablet",
	[287185] = "Wanted: Darkspeaker Jo'la",
	[287189] = "Wanted: Dangerous Beasts",
	[287228] = "Wanted: Dark Chronicler",
	[287229] = "Wanted: Dark Chronicler",
	[287232] = "Scouting Report",
	[287239] = "Grayal's Last Offering",
	[287304] = "Lost Explorer's Bounty",
	[287318] = "Sandfury Reserve",
	[287320] = "Stranded Cache",
	[287324] = "Excavator's Greed",
	[287326] = "Zem'lan's Buried Treasure",
	[287327] = "Scouting Report",
	[287398] = "Wanted: Za'roco",
	[287440] = "Wanted: Taz'raka",
	[287441] = "Wanted: Sandscout Vesarik",
	[287442] = "Wanted: Cobra Excursion Participants",
	[287958] = "Bulletin Board",
	[288157] = "WANTED: Yarsel'ghun",
	[288167] = "Marie's Package",
	[288214] = "Wanted Poster",
	[288596] = "Cache of Secrets",
	[288609] = "Tortollan Chest",
	[288622] = "Wanted Poster",
	[288641] = "WANTED: Gryphon 'Nappers",
	[289310] = "WANTED: Raging Earthguard",
	[289313] = "WANTED: The Hornet",
	[289317] = "Seaweed",
	[289361] = "WANTED: Quartermaster Ssylis",
	[289365] = "Wanted Poster",
	[289521] = "Titan Translocator",
	[289647] = "Weathered Treasure Chest",
	[289728] = "Captain Gulnaku's Treasure Map",
	[290127] = "Tortollan Chest",
	[290128] = "Tortollan Chest",
	[290138] = "Bot Buster Bomb",
	[290419] = "Wanted Poster",
	[290537] = "Help Wanted",
	[290725] = "Riches of Tor'nowa",
	[290750] = "Jambani Stockpile",
	[290765] = "Large Pile of Gold",
	[290993] = "Irontide Loot",
	[291143] = "Ranah's Wrench",
	[291233] = "Saurolisk Tail",
	[291238] = "Bwonsamdi's Tears",
	[291241] = "Gnarl Root",
	[291257] = "Small Treasure Chest",
	[291291] = "Wanted: Poacher",
	[292523] = "Wanted Poster",
	[292673] = "A Damp Scroll",
	[292674] = "A Damp Scroll",
	[292675] = "A Damp Scroll",
	[292676] = "A Damp Scroll",
	[292677] = "A Damp Scroll",
	[292686] = "Ominous Altar",
	[292812] = "Sapphire Amaraina",
	[292823] = "Krag'wa's Ire",
	[292825] = "Stonebloom",
	[292843] = "Gem of Acquiescence",
	[293110] = "Pepe'jin",
	[293131] = "Pepe",
	[293134] = "Large Azerite Grenade",
	[293349] = "Discarded Lunchbox",
	[293350] = "Carved Wooden Chest",
	[293351] = "Truffle",
	[293445] = "Truffle",
	[293446] = "Truffle",
	[293449] = "Truffle",
	[293567] = "Wanted Poster",
	[293568] = "Wanted Poster",
	[293837] = "|cFFFFFFFFStep 2:|r Ordinary Pebble I",
	[293838] = "|cFFFFFFFFStep 3:|r Ordinary Pebble II",
	[293839] = "|cFFFFFFFFStep 4:|r Ordinary Pebble III",
	[293840] = "|cFFFFFFFFStep 5:|r Ordinary Pebble IV",
	[293841] = "|cFFFFFFFFStep 6:|r Ordinary Pebble V",
	[293842] = "|cFFFFFFFFStep 7:|r Ordinary Pebble VI",
	[293843] = "|cFFFFFFFFStep 8:|r Ordinary Pebble VII",
	[293844] = "|cFFFFFFFFStep 9:|r Ordinary Pebble VIII",
	[293845] = "|cFFFFFFFFStep 10:|r Ordinary Pebble IX",
	[293846] = "|cFFFFFFFFStep 11:|r Ordinary Pebble X",
	[293849] = "Conspicious Note",
	[293852] = "Buried Treasure Chest",
	[293880] = "Buried Treasure Chest",
	[293881] = "Buried Treasure Chest",
	[293884] = "Buried Treasure Chest",
	[293962] = "Precarious Noble Cache",
	[293964] = "Forgotten Smuggler's Stash",
	[293965] = "Scrimshaw Cache",
	[293985] = "Wanted: War Gore",
	[294084] = "Adventurer's Society Loot Stash",
	[294096] = "Lit Orb",
	[294097] = "Strange Seed",
	[294098] = "Tiny Frog",
	[294099] = "Brittle Bone",
	[294100] = "Misplaced Candle",
	[294101] = "Odd Cup",
	[294102] = "Interesting Rock",
	[294103] = "Blooming Lily",
	[294104] = "Pretty Flower",
	[294105] = "Old Book",
	[294106] = "Dead Fish",
	[294107] = "Scratched Board",
	[294108] = "Lost Ring",
	[294109] = "Spoiled Apple",
	[294110] = "Broken Tooth",
	[294111] = "Worn Helm",
	[294112] = "Leafy Leaf",
	[294113] = "Musty Cloth",
	[294114] = "Broken Tablet",
	[294115] = "Ashed Torch",
	[294125] = "Anchor Weed",
	[294173] = "Venture Co. Supply Chest",
	[294174] = "Forgotten Chest",
	[294312] = "Grimmy's List of Friends",
	[294314] = "Grimmy's List of Enemies",
	[294315] = "Grimmy's Favorite Recipe",
	[294316] = "Lost Offerings of Kimbul",
	[294317] = "Deadwood Chest",
	[294319] = "Sandsunken Treasure",
	[294335] = "Rotten Potato",
	[294703] = "Grimmy's Rusty Lockbox",
	[296252] = "Box of Large Azerite Grenades",
	[296479] = "Lord Admiral's Footlocker",
	[296536] = "Bloodied Sentinel's Glaive",
	[296573] = "Jason's Rusty Blade",
	[296574] = "Ian's Empty Bottle",
	[296575] = "Julie's Cracked Dish",
	[296579] = "Brian's Broken Compass",
	[296580] = "Ofer's Bound Journal",
	[296581] = "Skye's Pet Rock",
	[296582] = "Julien's Left Boot",
	[296583] = "Navarro's Flask",
	[296584] = "Zach's Canteen",
	[296585] = "Damarcus' Backpack",
	[296586] = "Rachel's Flute",
	[296587] = "Josh's Fang Necklace",
	[296588] = "Portrait of Commander Martens",
	[296589] = "Kurt's Ornate Key",
	[296854] = "Ancient Tidesage Scroll",
	[296855] = "Truffle",
	[296902] = "Ancient Tidesage Scroll",
	[296903] = "Ancient Tidesage Scroll",
	[296904] = "Ancient Tidesage Scroll",
	[296905] = "Ancient Tidesage Scroll",
	[296906] = "Ancient Tidesage Scroll",
	[296907] = "Ancient Tidesage Scroll",
	[296908] = "Ancient Tidesage Scroll",
	[296915] = "Drust Stele: The Circle",
	[296916] = "Drust Stele: The Ritual",
	[296917] = "Drust Stele: The Tree",
	[296918] = "Drust Stele: Breath Into Stone",
	[297069] = "Dresser",
	[297071] = "Small Coin Bag",
	[297074] = "Tales of de Loa: Gral",
	[297485] = "Tales of de Loa: Sethraliss",
	[297489] = "Tales of de Loa: Krag'wa",
	[297490] = "Tales of de Loa: Rezan",
	[297491] = "Tales of de Loa: Bwonsamdi",
	[297492] = "Bulletin Board",
	[297493] = "Tales of de Loa: Shadra",
	[297494] = "Tales of de Loa: Kimbul",
	[297495] = "Tales of de Loa: Akunda",
	[297521] = "Tales of de Loa: Gonk",
	[297522] = "Tales of de Loa: Hir'eek",
	[297523] = "Tales of de Loa: Torga",
	[297524] = "Tales of de Loa: Pa'ku",
	[297528] = "Tales of de Loa: Jani",
	[297627] = "Drust Stele: Sacrifice",
	[297628] = "Drust Stele: Constructs",
	[297629] = "Drust Stele: The Cycle",
	[297630] = "Drust Stele: Conflict",
	[297631] = "Drust Stele: The Flayed Man",
	[297632] = "Drust Stele: Protectors of the Forest",
	[297700] = "Tales of de Loa: Zandalar",
	[297825] = "Web-Covered Chest",
	[297828] = "Merchant's Chest",
	[297878] = "Hexed Chest",
	[297879] = "Bespelled Chest",
	[297880] = "Ensorcelled Chest",
	[297881] = "Enchanted Chest",
	[297885] = "Tales of de Loa: Torcali",
	[297891] = "Runebound Cache",
	[297892] = "Runebound Chest",
	[297893] = "Runebound Coffer",
	[297905] = "Jay's Songbook",
	[297906] = "Russel's Songbook",
	[297933] = "Dusty Songbook",
	[297934] = "Scoundrel's Songbook",
	[297939] = "Order Of Embers Crossbow",
	[297940] = "Order Of Embers Knife",
	[297941] = "Order Of Embers Hat",
	[297942] = "Order Of Embers Flask",
	[298766] = "Old Crossbow",
	[298767] = "Old Knife",
	[298768] = "Old Flask",
	[298769] = "Old Hat",
	[298778] = "Wanted Poster",
	[298849] = "Wanted Poster",
	[298920] = "Stolen Thornspeaker Cache",
	[298921] = "Ancient Nazmani Tablet",
	[298963] = "Weathered Nazmani Tablet",
	[298965] = "Cracked Tablet",
	[299073] = "Fractured Tablet",
	[303016] = "|cFFFFFFFFStep 14:|r Ordinary Pebble XIII",
	[303017] = "|cFFFFFFFFStep 13:|r Ordinary Pebble XII",
	[303018] = "|cFFFFFFFFStep 12:|r Ordinary Pebble XI",
	[303039] = "Curious Grain Sack",
	[307091] = "Ominous Whispering Dagger",
	[307265] = "Wanted Poster",
	[307277] = "Old Jug",
	[307307] = "Broken Barrel",
	[307325] = "Wanted Poster",
	[307330] = "Captain's Footlocker",
	[307340] = "Locked Chest",
	[307748] = "Venture Co. Letter",
	[307836] = "Twilight Ore",
	[309498] = "Armor Stand",
	[310600] = "Ancient Kaldorei Tome",
	[310601] = "Discarded Nightsaber Bridle",
	[310603] = "Bow of the High Priestess",
	[310709] = "Waterlogged Chest",
	[310736] = "Ore Crate",
	[311155] = "Ancient Tablet",
	[311218] = "Xal'atath, Blade of the Black Empire",
	[311822] = "Bot Scrambler",
	[311902] = "Loose Parts",
	[311903] = "Loose Parts",
	[313446] = "Silver Dawning Salvage",
	[313447] = "Silver Dawning Salvage",
	[313448] = "Silver Dawning Salvage",
	[316443] = "Xal'atath, Blade of the Black Empire",
	[316792] = "Pilfered Iron Ore",
	[316863] = "Lost Zandalari Relic",
	[319222] = "Darkshore Cache",
	[320514] = "Darkshore Cache",
	[320515] = "Darkshore Cache",
	[320516] = "Darkshore Cache",
	[320517] = "Darkshore Cache",
	[320518] = "Darkshore Cache",
	[322020] = "Pile of Coins",
	[322066] = "Ley Line Accumulator",
	[322413] = "Glimmering Chest",
	[322533] = "Mardivas's Tome of the Elements",
	[322791] = "Kelpberry",
	[322803] = "Kelpberry",
	[324407] = "Void Roots",
	[325659] = "Mechanized Chest",
	[325660] = "Mechanized Chest",
	[325661] = "Mechanized Chest",
	[325662] = "Mechanized Chest",
	[325663] = "Mechanized Chest",
	[325664] = "Mechanized Chest",
	[325665] = "Mechanized Chest",
	[325666] = "Mechanized Chest",
	[325667] = "Mechanized Chest",
	[325668] = "Mechanized Chest",
	[325759] = "Mana-Infused Clam",
	[325795] = "Sunken Chest",
	[325853] = "Empty Bookcase",
	[325869] = "Empty Cask",
	[325873] = "Rich Osmenite Deposit",
	[325874] = "Osmenite Seam",
	[325875] = "Osmenite Deposit",
	[325894] = "Arcane Cache",
	[325954] = "Illegible Treasure Map",
	[326026] = "Void Cache",
	[326027] = "Recyclerizer DX-82",
	[326047] = "Reinforced Cache",
	[326140] = "Bounty Board",
	[326141] = "Bounty Board",
	[326142] = "Bounty Board",
	[326148] = "Naga Attack Plans",
	[326394] = "Arcane Chest",
	[326395] = "Glowing Arcane Trunk",
	[326396] = "Glowing Arcane Trunk",
	[326397] = "Glowing Arcane Trunk",
	[326398] = "Glowing Arcane Trunk",
	[326399] = "Glowing Arcane Trunk",
	[326400] = "Glowing Arcane Trunk",
	[326401] = "Arcane Chest",
	[326402] = "Arcane Chest",
	[326403] = "Arcane Chest",
	[326404] = "Arcane Chest",
	[326405] = "Arcane Chest",
	[326406] = "Arcane Chest",
	[326407] = "Arcane Chest",
	[326408] = "Arcane Chest",
	[326409] = "Arcane Chest",
	[326410] = "Arcane Chest",
	[326411] = "Arcane Chest",
	[326412] = "Arcane Chest",
	[326413] = "Arcane Chest",
	[326414] = "Arcane Chest",
	[326415] = "Arcane Chest",
	[326416] = "Arcane Chest",
	[326417] = "Arcane Chest",
	[326418] = "Arcane Chest",
	[326419] = "Arcane Chest",
	[326588] = "Azerite Weapons Cache",
	[326594] = "Arcane Tome",
	[326598] = "Zin'anthid",
	[327170] = "Weapon Rack",
	[327221] = "Kelpberry Cask",
	[327230] = "Jelly Deposit",
	[327407] = "Precious Ogre Stash",
	[327516] = "Jelly Deposit",
	[327548] = "Powerpack Blueprints",
	[327568] = "Pirate Chest",
	[327569] = "Pirate Chest",
	[327570] = "Pirate Chest",
	[327585] = "Bounty Board",
	[327591] = "Preserved Journal",
	[327592] = "Enchanted Lock",
	[327596] = "Broken Abyssal Focus",
	[327597] = "Old Rusty Chest",
	[327650] = "War Supply Chest",
	[327652] = "War Supply Chest",
	[327669] = "Contained Alemental",
	[328343] = "Direbrew Cog",
	[328413] = "Hozen Totem",
	[329641] = "Wanted: Junkbrat and Roadtrogg",
	[329715] = "Useful Bits and Pieces",
	[329783] = "Glowing Arcane Trunk",
	[329805] = "Strange Crystal",
	[329918] = "Quilboar Treasures",
	[329919] = "Stolen Supplies",
	[330168] = "Contained Alemental",
	[330169] = "Direbrew Cog",
	[330170] = "Hozen Totem",
	[330183] = "Irontide Lockbox",
	[330627] = "Danger Sign",
	[330634] = "P3-P3",
	[332220] = "Glowing Arcane Trunk",
	[332568] = "Crystalline Cat Figurine",
	[332569] = "Crystalline Cat Figurine",
	[332570] = "Crystalline Cat Figurine",
	[332571] = "Crystalline Cat Figurine",
	[332572] = "Crystalline Cat Figurine",
	[332573] = "Crystalline Cat Figurine",
	[332574] = "Crystalline Cat Figurine",
	[332575] = "Crystalline Cat Figurine",
	[332576] = "Crystalline Cat Figurine",
	[334216] = "Black Empire Cache",
	[334220] = "Black Empire Cache",
	[335655] = "Oonar's Arm",
	[336415] = "Discarded Scroll",
	[337237] = "Lost Vault",
	[337241] = "Stashed Equipment",
	[338520] = "Duskmire Mushroom",
	[339211] = "Empty Dish",
	[339243] = "Infested Strongbox",
	[339248] = "Infested Cache",
	[339249] = "Infested Cache",
	[339250] = "Infested Cache",
	[339283] = "Forgotten Noble's Chest",
	[339601] = "Scroll of Aeons",
	[339625] = "Sophia's Gift",
	[339641] = "Purifying Draught",
	[339770] = "Abandoned Treasure Chest",
	[339837] = "Powder Bag",
	[339869] = "Curator's Chest",
	[341416] = "Vault Portcullis Chain",
	[341424] = "Forgotten Mementos",
	[342098] = "Coifcurl's Close Shave Kit",
	[343611] = "Voidtouched Egg",
	[343698] = "Void-Touched Skull",
	[344588] = "Stewart's Stewpendous Stew",
	[344726] = "Dark Sermon",
	[345446] = "Great Horn of the Runestag",
	[345455] = "Construct Supply Chest",
	[345456] = "Chest of Eyes",
	[345458] = "Prize Bag",
	[347444] = "Ornate Bone Shield",
	[348521] = "Strange Growth",
	[348558] = "Notice",
	[348676] = "Ballista Bolt",
	[348747] = "Muddy Scroll",
	[349515] = "Battered Journal",
	[349565] = "Chest of Envious Dreams",
	[349612] = "Wanted: Appraiser Vix",
	[349792] = "Filcher's Prize",
	[349793] = "Wayfarer's Abandoned Spoils",
	[349794] = "Remlate's Hidden Cache",
	[349795] = "Fleeing Soul's Bundle",
	[349796] = "Gilded Plum Chest",
	[349797] = "Abandoned Curios",
	[349798] = "Smuggled Cache",
	[350802] = "Web Sealed Chest",
	[350804] = "Broken Harp",
	[350972] = "Cell Portcullis Chain",
	[350978] = "Queen's Conservatory Cache",
	[351467] = "Faded Epitaph",
	[351487] = "Secret Treasure",
	[351540] = "Secret Treasure",
	[351541] = "Secret Treasure",
	[351542] = "Secret Treasure",
	[351543] = "Secret Treasure",
	[351544] = "Secret Treasure",
	[351545] = "Secret Treasure",
	[351874] = "Wanted: Enforcer Kristof",
	[351885] = "Wanted: Aggregate of Doom",
	[351886] = "Wanted: Duke Anton",
	[351887] = "Wanted: Lord Darion",
	[351888] = "Wanted: Summoner Marcelis",
	[351889] = "Wanted: The Pale Doom",
	[351948] = "Forgotten Chest",
	[351980] = "Misplaced Supplies",
	[352027] = "Wanted Scroll",
	[352028] = "Wanted Scroll",
	[352086] = "Blackhound Cache",
	[352181] = "Spriggan-Sized Wand",
	[352182] = "Spriggan-Sized Polearm",
	[352428] = "Vesper of Virtues",
	[352433] = "Cache of Eyes",
	[352490] = "Join the Rebellion!",
	[352520] = "Medallion of Pride",
	[352596] = "Sprouting Growth",
	[352703] = "The Harvest",
	[352754] = "Silver Strongbox",
	[352909] = "Glimmerfin Scale",
	[353019] = "Silver Strongbox",
	[353205] = "Silver Strongbox",
	[353231] = "Bonebound Chest",
	[353232] = "Bleakwood Chest",
	[353233] = "Enchanted Chest",
	[353234] = "Gilded Chest",
	[353252] = "Silver Strongbox",
	[353305] = "Stonebreaker Mallet",
	[353306] = "Decayed Husk",
	[353314] = "Silver Strongbox",
	[353323] = "Decayed Husk",
	[353324] = "Decayed Husk",
	[353325] = "Silver Strongbox",
	[353326] = "Decayed Husk",
	[353327] = "Decayed Husk",
	[353329] = "Faerie Stash",
	[353330] = "Faerie Stash",
	[353331] = "Faerie Stash",
	[353332] = "Faerie Stash",
	[353333] = "Faerie Stash",
	[353340] = "Dusty Book",
	[353380] = "Halis's Lunch Pail",
	[353472] = "Radiant Sword",
	[353484] = "The Great Vault",
	[353500] = "Silver Strongbox",
	[353503] = "Silver Strongbox",
	[353516] = "Silver Strongbox",
	[353626] = "Locked Toolbox",
	[353627] = "Battlefront Rations",
	[353643] = "Silver Strongbox",
	[353645] = "Marileth's Journal",
	[353650] = "Steward's Golden Chest",
	[353681] = "Lunarlight Pod",
	[353683] = "Lunarlight Pod",
	[353684] = "Lunarlight Pod",
	[353685] = "Lunarlight Pod",
	[353686] = "Lunarlight Pod",
	[353687] = "Broken Bell",
	[353688] = "Broken Bell",
	[353689] = "Broken Bell",
	[353691] = "Skyward Bell",
	[353791] = "Castle Strongbox",
	[353792] = "Village Strongbox",
	[353793] = "Parish Chest",
	[353796] = "Reliquary of Remembrance",
	[353797] = "Stone Legion Supplies",
	[353799] = "Hopebreaker Pack",
	[353868] = "Hidden Hoard",
	[353869] = "Hidden Hoard",
	[353870] = "Hidden Hoard",
	[353871] = "Hidden Hoard",
	[353872] = "Hidden Hoard",
	[353873] = "Hidden Hoard",
	[353874] = "Animacone",
	[353876] = "Virtue of Penitence",
	[353940] = "Gift of Vesiphone",
	[353941] = "Gift of Chyrus",
	[353942] = "Gift of Agthia",
	[353943] = "Gift of Thenios",
	[353944] = "Gift of Devos",
	[353948] = "Medallion of Desire",
	[353949] = "Medallion of Avarice",
	[354075] = "Blank Parchment",
	[354108] = "Stoneborn Satchel",
	[354109] = "Stoneborn Satchel",
	[354110] = "Stoneborn Satchel",
	[354111] = "Stoneborn Satchel",
	[354112] = "Stoneborn Satchel",
	[354113] = "Stoneborn Satchel",
	[354114] = "Stoneborn Satchel",
	[354115] = "Pugilist's Prize",
	[354116] = "Pugilist's Prize",
	[354121] = "Pugilist's Prize",
	[354122] = "Pugilist's Prize",
	[354123] = "Pugilist's Prize",
	[354175] = "Cache of the Ascended",
	[354186] = "Stoneborn Satchel",
	[354187] = "Stoneborn Satchel",
	[354188] = "Stoneborn Satchel",
	[354189] = "Stoneborn Satchel",
	[354190] = "Stoneborn Satchel",
	[354191] = "Stoneborn Satchel",
	[354192] = "Stoneborn Satchel",
	[354193] = "Stoneborn Satchel",
	[354202] = "Abandoned Stockpile",
	[354208] = "Stolen Equipment",
	[354211] = "Greed's Reward",
	[354213] = "Lost Disciple's Notes",
	[354214] = "Larion Tamer's Harness",
	[354275] = "Experimental Construct Part",
	[354283] = "Mercia's Legacy: Chapter One",
	[354284] = "Mercia's Legacy: Chapter Two",
	[354285] = "Mercia's Legacy: Chapter Three",
	[354286] = "Mercia's Legacy: Chapter Four",
	[354287] = "Mercia's Legacy: Chapter Five",
	[354288] = "Mercia's Legacy: Chapter Six",
	[354289] = "Windsmith's Tools",
	[354467] = "Mercia's Legacy: Chapter Seven",
	[354645] = "Lost Satchel",
	[354646] = "Ancient Cloudfeather Egg",
	[354647] = "Hearty Dragon Plume",
	[354648] = "Darkreach Supplies",
	[354649] = "Relic Hoard",
	[354650] = "Dreamsong Heart",
	[354651] = "Enchanted Dreamcatcher",
	[354652] = "Faerie Trove",
	[354662] = "Elusive Faerie Cache",
	[354852] = "Sprouting Growth",
	[354853] = "Sprouting Growth",
	[354856] = "Slime-Coated Crate",
	[354911] = "Swollen Anima Seed",
	[355000] = "Cache of the Night",
	[355019] = "Raw Dream Silk",
	[355020] = "Enchanted Bough",
	[355021] = "Fae Ornament",
	[355035] = "Treasure: House of the Chosen",
	[355037] = "Runebound Coffer",
	[355038] = "Runebound Coffer",
	[355040] = "Rune of Rituals",
	[355041] = "Cache of the Moon",
	[355048] = "Rune of Rituals",
	[355049] = "Rune of Rituals",
	[355194] = "Rune of Constructs",
	[355195] = "Rune of Constructs",
	[355196] = "Rune of Constructs",
	[355286] = "Memorial Offerings",
	[355296] = "Bounty: Beast Control",
	[355355] = "Harmonic Chest",
	[355435] = "Vesper of the Silver Wind",
	[355449] = "Gift of the Silver Wind",
	[355798] = "Cage",
	[355865] = "Vat of Conspicuous Slime",
	[355872] = "Stolen Jar",
	[355880] = "The Necronom-i-nom",
	[355886] = "Plaguefallen Chest",
	[355947] = "Glutharn's Stash",
	[355971] = "Stoneborn Glaive",
	[355980] = "Ritualist's Cache",
	[356535] = "Runespeaker's Trove",
	[356555] = "Eurydea's Necklace",
	[356693] = "Baroness Vashj's Extravagant Tribute",
	[356697] = "Alexandros Mograine's Extravagant Tribute",
	[356700] = "Grandmaster Vole's Extravagant Tribute",
	[356705] = "Plague Deviser Marileth's Extravagant Tribute",
	[356709] = "Lady Moonberry's Extravagant Tribute",
	[356712] = "Hunt-Captain Korayn's Extravagant Tribute",
	[356716] = "Droman Aliothe's Extravagant Tribute",
	[356720] = "Choofa's Extravagant Tribute",
	[356725] = "Polemarch Adrestes' Extravagant Tribute",
	[356728] = "Mikanikos' Extravagant Tribute",
	[356733] = "Kleia and Pelagos' Extravagant Tribute",
	[356737] = "Sika's Extravagant Tribute",
	[356741] = "The Countess' Extravagant Tribute",
	[356744] = "Rendle and Cudgelface's Extravagant Tribute",
	[356748] = "Stonehead's Extravagant Tribute",
	[356752] = "Cryptkeeper Kassir's Extravagant Tribute",
	[356757] = "Greed's Desire",
	[356818] = "Penitence of Purity",
	[356820] = "Large Lunarlight Pod",
	[356823] = "Cloudwalker's Coffer",
	[357228] = "Forgotten Chest",
	[357229] = "Forgotten Chest",
	[357230] = "Forgotten Chest",
	[357231] = "Forgotten Chest",
	[357232] = "Forgotten Chest",
	[357233] = "Forgotten Chest",
	[357234] = "Forgotten Chest",
	[357235] = "Forgotten Chest",
	[357236] = "Forgotten Chest",
	[357237] = "Forgotten Chest",
	[357238] = "Forgotten Chest",
	[357246] = "Tattered Scroll",
	[357467] = "Forbidden Ink",
	[357487] = "Stylish Parasol",
	[357515] = "Sack of Oats",
	[357526] = "Empty Water Bucket",
	[357541] = "Discarded Horseshoe",
	[357565] = "Forgotten Angler's Rod",
	[357572] = "Rapier of the Fearless",
	[357584] = "Vyrtha's Dredglaive",
	[357683] = "Outcast's Makeshift Muckpool",
	[357697] = "Taskmaster's Trove",
	[357726] = "Broken Spear",
	[357758] = "Plague Barrel",
	[357771] = "Burried Cache",
	[357937] = "Burried Cache",
	[358298] = "Forbidden Chamber Lockbox",
	[358315] = "Skeletal Hand Fragments",
	[358318] = "R. Suavel Dredger Portrait",
	[358319] = "Sorceror's Note",
	[358382] = "Wanted: Chelicera",
	[358398] = "Lost Journal",
	[358399] = "Six-League Pack",
	[358531] = "Giant Cache of Epic Treasure",
	[358533] = "Forgotten Supplies",
	[358855] = "Damaged Safe Fall Pack",
	[360054] = "Sticky Cat",
	[362489] = "Elysian Decree",
	[364345] = "A Faintly Glowing Seed",
	[364483] = "Empty Nightcap Cask",
	[364899] = "Crystallized Stygia",
	[364926] = "Runeforged Shackles",
	[364932] = "Blazing Ingot",
	[364937] = "Phasic Siphoner",
	[364987] = "Broker Journal",
	[364994] = "Spectral Pick",
	[365084] = "Tormentor's Pike",
	[365093] = "Theotar's Caroling Books",
	[368205] = "Mawsworn Cache",
	[368206] = "Mawsworn Cache",
	[368207] = "Mawsworn Cache",
	[368208] = "Mawsworn Cache",
	[368213] = "Mawsworn Cache",
	[368214] = "Mawsworn Cache",
	[368347] = "Rift Hidden Cache",
	[368645] = "Rift Hidden Cache",
	[368646] = "Rift Hidden Cache",
	[368648] = "Rift Hidden Cache",
	[368649] = "Rift Hidden Cache",
	[368650] = "Rift Hidden Cache",
	[368653] = "Etherwyrm Cage",
	[368663] = "Lil'Abom's Right Hand",
	[368665] = "Lil'Abom's Spare Arm",
	[368666] = "Lil'Abom's Head",
	[368667] = "Lil'Abom's Torso",
	[368668] = "Lil'Abom's Trunk",
	[368772] = "Sigilscored Scroll",
	[368876] = "Mawsworn Cache",
	[368935] = "Sinfall Screecher Cage",
	[368946] = "Stolen Anima Vessel",
	[368948] = "Stolen Anima Vessel",
	[368949] = "Stolen Anima Vessel",
	[368950] = "Stolen Anima Vessel",
	[368951] = "Stolen Anima Vessel",
	[368952] = "Stolen Anima Vessel",
	[368953] = "Stolen Anima Vessel",
	[369129] = "Nilganihmaht's Gold Band",
	[369132] = "Domination Sealed Chest",
	[369133] = "Domination Seal #1",
	[369134] = "Domination Sealed Cage",
	[369135] = "Domination Seal #2",
	[369138] = "Domination Chest Seal",
	[369141] = "Mawsworn Cache",
	[369143] = "Quartered Ancient Ring",
	[369144] = "The Harrower's Key Ring",
	[369145] = "Helgarde Supply Cache",
	[369148] = "Glittering Nest Material",
	[369149] = "Forgotten Feather",
	[369172] = "Lost Memento",
	[369183] = "Dislodged Nest",
	[369185] = "Korthian Relic Box",
	[369194] = "Anima Laden Egg",
	[369204] = "Displaced Relic",
	[369216] = "Helsworn Chest",
	[369224] = "Jeweled Heart of Ezekiel",
	[369225] = "Infested Vestige",
	[369227] = "Stolen Anima Vessel",
	[369232] = "Offering Box",
	[369234] = "Offering Key",
	[369235] = "Stolen Anima Vessel",
	[369236] = "Stolen Anima Vessel",
	[369245] = "Korthian Relic Box",
	[369292] = "Relic Cache",
	[369294] = "Relic Cache",
	[369295] = "Pile of Bones",
	[369296] = "Shardhide Stash",
	[369297] = "Pile of Bones",
	[369304] = "Korthian Relic Box",
	[369327] = "Invasive Mawshroom",
	[369329] = "Invasive Mawshroom",
	[369330] = "Invasive Mawshroom",
	[369331] = "Invasive Mawshroom",
	[369332] = "Invasive Mawshroom",
	[369333] = "Nest of Unusual Materials",
	[369334] = "Nest of Unusual Materials",
	[369335] = "Nest of Unusual Materials",
	[369336] = "Nest of Unusual Materials",
	[369337] = "Nest of Unusual Materials",
	[369339] = "Mawsworn Cache",
	[369340] = "Korthian Relic Box",
	[369341] = "Mawsworn Cache",
	[369432] = "Misplaced Venthyr Tome",
	[369437] = "Riftbound Cache",
	[369438] = "Riftbound Cache",
	[369439] = "Riftbound Cache",
	[369440] = "Riftbound Cache",
	[369602] = "Hands of Defiance",
	[369757] = "Submerged Chest",
	[369893] = "Urgent Missive",
	[369894] = "Urgent Missive",
	[370140] = "Damaged Jiro Stash",
	[370469] = "Spectral Feed",
	[370494] = "Toccatian Cache",
	[373437] = "Pungent Blobfish Cluster",
	[373438] = "Coilclutch Vine",
	[373439] = "Flipper Fish School",
	[373460] = "Fae Net",
	[373471] = "Mezzonic Cache",
	[373472] = "Glissandian Cache",
	[373473] = "Fugueal Cache",
	[373474] = "Cantaric Cache",
	[373543] = "Library Vault",
	[373548] = "Template Archive",
	[373553] = "Tranquil Concordance",
	[373561] = "Forgotten Proto-Vault",
	[373562] = "Excitable Concordance",
	[373563] = "Mercurial Concordance",
	[373568] = "Provis Cache",
	[373579] = "Prying Eye Discovery",
	[373580] = "Tranquil Concordance",
	[373581] = "Excitable Concordance",
	[373582] = "Mercurial Concordance",
	[373583] = "Tranquil Concordance",
	[373584] = "Excitable Concordance",
	[373585] = "Mercurial Concordance",
	[373586] = "Tranquil Concordance",
	[373587] = "Excitable Concordance",
	[373588] = "Mercurial Concordance",
	[374976] = "Symphonic Vault",
	[375021] = "Perished Automa",
	[375058] = "Toccatian Cache",
	[375059] = "Mezzonic Cache",
	[375060] = "Glissandian Cache",
	[375061] = "Fugueal Cache",
	[375062] = "Cantaric Cache",
	[375064] = "Toccatian Cache",
	[375066] = "Mezzonic Cache",
	[375067] = "Glissandian Cache",
	[375068] = "Fugueal Cache",
	[375069] = "Cantaric Cache",
	[375188] = "Camber Alcove Arrangement",
	[375189] = "Repertory Alcove Arrangement",
	[375190] = "Rondure Alcove Arrangement",
	[375191] = "Dormant Alcove Arrangement",
	[375192] = "Fulgore Alcove Arrangement",
	[375234] = "Hardened Draconium Deposit",
	[375235] = "Molten Draconium Deposit",
	[375238] = "Titan-Touched Draconium Deposit",
	[375239] = "Primal Draconium Deposit",
	[375240] = "Infurious Draconium Deposit",
	[375241] = "Bubble Poppy",
	[375242] = "Titan-Touched Bubble Poppy",
	[375243] = "Infurious Bubble Poppy",
	[375244] = "Frigid Bubble Poppy",
	[375245] = "Windswept Bubble Poppy",
	[375246] = "Decayed Bubble Poppy",
	[375270] = "Protoform Schematic",
	[375272] = "Mawsworn Cache",
	[375281] = "Stolen Relic",
	[375283] = "Percolation Array",
	[375290] = "Cypher Bound Chest",
	[375354] = "Domination Cache",
	[375362] = "Avian Nest",
	[375363] = "Mawsworn Supply Chest",
	[375366] = "Tarachnid Eggs",
	[375368] = "Creation Catalyst Console",
	[375369] = "Gnawed Valise",
	[375370] = "Protoform Schematic",
	[375371] = "Protoform Schematic",
	[375373] = "Discarded Automa Scrap",
	[375376] = "Fallen Vault",
	[375382] = "Crushed Supply Crate",
	[375383] = "Protoform Schematic",
	[375387] = "Protoform Schematic",
	[375388] = "Protoform Schematic",
	[375389] = "Protoform Schematic",
	[375390] = "Protoform Schematic",
	[375391] = "Protoform Schematic",
	[375393] = "Protoform Schematic",
	[375396] = "Lumpy Sand Pile",
	[375397] = "Glinting Sand Pile",
	[375398] = "Shifting Sand Pile",
	[375399] = "Humming Sand Pile",
	[375400] = "Misshapen Sand Pile",
	[375401] = "Sparkling Sand Pile",
	[375402] = "Ticking Sand Pile",
	[375403] = "Pulp-Covered Relic",
	[375404] = "Sandworn Chest",
	[375405] = "Filched Artifact",
	[375408] = "Architect's Reserve",
	[375411] = "Mistaken Ovoid",
	[375413] = "Drowned Broker Supplies",
	[375422] = "Overgrown Protofruit",
	[375423] = "Offering to the First Ones",
	[375478] = "Protomineral Extractor",
	[375479] = "Protoform Schematic",
	[375481] = "Pilfered Curio",
	[375483] = "Stolen Scroll",
	[375484] = "Grateful Boon",
	[375485] = "Protoflora Harvester",
	[375486] = "Protoform Schematic",
	[375492] = "Syntactic Vault",
	[375493] = "Ripened Protopear",
	[375494] = "Rondure Cache",
	[375495] = "Undulating Foliage",
	[375496] = "Bushel of Progenitor Produce",
	[375498] = "Protoform Schematic",
	[375502] = "Protoform Schematic",
	[375516] = "Lost Comb",
	[375517] = "Suspicious Rubble Pile",
	[375530] = "Forgotten Treasure Vault",
	[375536] = "Xy'rath's Booby-Trapped Cache",
	[375538] = "Lost Ovoid",
	[375668] = "Misty Treasure Chest",
	[375693] = "Protoform Schematic",
	[375694] = "Protoform Schematic",
	[375746] = "Protoform Schematic",
	[375748] = "Protoform Schematic",
	[375889] = "Protoform Schematic",
	[375893] = "High Value Cache",
	[375900] = "Protoform Schematic",
	[375902] = "Torn Ethereal Drape",
	[375903] = "Protoform Schematic",
	[375905] = "Protoform Schematic",
	[375907] = "Protoform Schematic",
	[375915] = "Glimmer of Serenity",
	[375950] = "Bauble of Pure Innovation",
	[375972] = "Wanted: Custos",
	[375973] = "Firim in Exile, Part 1",
	[375974] = "Crystallized Echo of the First Song",
	[375981] = "Protoform Schematic",
	[375982] = "Firim in Exile, Part 2",
	[375983] = "Firim in Exile, Part 3",
	[375984] = "Firim in Exile, Part 4",
	[375985] = "Firim in Exile, Part 5",
	[375986] = "Firim in Exile, Part 6",
	[375987] = "Firim in Exile, Part 7",
	[375988] = "Firim in Exile, Epilogue",
	[376041] = "Shrouded Cypher Cache",
	[376123] = "Suspicious Bottle",
	[376124] = "Bag of Enchanted Wind",
	[376175] = "Fullsails Supply Chest",
	[376213] = "Mysterious Wand",
	[376325] = "So Close, So Far",
	[376386] = "Disturbed Dirt",
	[376416] = "Ellam's Favorite Toys",
	[376426] = "Magic-Bound Chest",
	[376451] = "Bronze Stopwatch",
	[376578] = "Titan Chest",
	[376580] = "Djaradin Cache",
	[376581] = "Clan Chest",
	[376582] = "Tuskarr Chest",
	[376583] = "Decay Covered Chest",
	[376587] = "Expedition Scout's Pack",
	[376657] = "Ancient Monument",
	[376757] = "WANTED: Frigellus",
	[377114] = "Coil of Heavy Rope",
	[377233] = "Hessethiash's Poorly Hidden Treasure",
	[377317] = "Treasure Hoard",
	[377458] = "Abandoned Weapon Rack",
	[377466] = "Lost Draconic Hourglass",
	[377485] = "Sour Apple",
	[377499] = "On the Origin of Draconic Species",
	[377534] = "Delivered Vault",
	[377899] = "Hidden Hornswog Hostage",
	[377900] = "Nokhud Warspear",
	[377938] = "Prismatic Leaper School",
	[378010] = "Forgotten Dragon Treasure",
	[378047] = "Emerald Chest",
	[378054] = "Riptide Brew",
	[378088] = "Crystalline Flower",
	[378820] = "Popfizz Punch",
	[378857] = "Lost Obsidian Cache",
	[379168] = "Lost Cache Key",
	[379248] = "Draconium Deposit",
	[379252] = "Draconium Deposit",
	[379263] = "Rich Draconium Deposit",
	[379267] = "Rich Draconium Deposit",
	[379272] = "Draconium Seam",
	[379290] = "Ornamented Statue",
	[379296] = "Broken Banding",
	[379297] = "Slam Bam Swill",
	[379314] = "Full Fishing Net",
	[379321] = "Mysterious Paw Print",
	[380429] = "Golden Claw",
	[380430] = "Tail Fragment",
	[380457] = "Experimental Decay Cauldron",
	[380516] = "Glimmer of Wisdom",
	[380518] = "Dislodged Dragoneye",
	[380533] = "Snow Covered Scroll",
	[380540] = "Ornamented Statue",
	[380545] = "Painter's Pretty Jewel",
	[380547] = "Decay-Infused Tanning Oil",
	[380548] = "Forgotten Jewelry Box",
	[380549] = "Intriguing Bolt of Blue Cloth",
	[380550] = "Forgetful Apprentice's Tome",
	[380554] = "Well-Danced Drum",
	[380556] = "Harmonic Chest",
	[380558] = "Enchanted Debris",
	[380559] = "Frostforged Potion",
	[380560] = "Disabled Tesla Coil",
	[380567] = "Eight of Storms",
	[380569] = "Crystalline Overgrowth",
	[380570] = "Curious Glyph",
	[380571] = "Boomthyr Rocket",
	[380577] = "Lofty Malygite",
	[380578] = "How to Train Your Whelpling",
	[380579] = "Spare Djaradin Tools",
	[380580] = "Lava-Infused Seed",
	[380583] = "Decaying Brackenhide Blanket",
	[380585] = "Erupted Alexstraszite Cluster",
	[380586] = "Mysterious Cauldrons",
	[380587] = "Crate of Treated Hides",
	[380588] = "Miniature Bronze Dragonflight Banner",
	[380589] = "Faintly Enchanted Remains",
	[380590] = "Well-Insulated Mug",
	[380591] = "Closely Guarded Shiny",
	[380592] = "Stormbound Horn",
	[380593] = "Bag of Decayed Scales",
	[380595] = "Frosted Parchment",
	[380597] = "Battle Hardened Centaur Carpet",
	[380598] = "Singed Chest",
	[380600] = "Enriched Earthen Shard",
	[380601] = "Dusty Darkmoon Card",
	[380602] = "Wind-Blessed Hide",
	[380604] = "Mysterious Banner",
	[380605] = "Contraband Concoction",
	[380607] = "Itinerant Singed Fabric",
	[380608] = "Silky Surprise",
	[380610] = "Pulsing Earth Rune",
	[380611] = "Canteen of Suspicious Water",
	[380612] = "Sign Language Reference Sheet",
	[380615] = "Poacher's Pack",
	[380616] = "Small Basket of Firewater Powder",
	[380617] = "Qalashi Weapon Diagram",
	[380618] = "Draconic Flux",
	[380619] = "Curious Ingots",
	[380620] = "Ancient Spear Shards",
	[380623] = "Spelltouched Tongs",
	[380643] = "Flashfrozen Scroll",
	[380647] = "Forgotten Arcane Tomne",
	[380648] = "Odd Book",
	[380652] = "Fractured Titanic Sphere",
	[380653] = "Yennu's Kite",
	[380654] = "Dead Man's Chestplate",
	[380709] = "Falconer Gauntlet Drawings",
	[380763] = "Ancient Dragonweave Loom",
	[380822] = "Igneous Gem",
	[380840] = "Torn Riding Pack",
	[380842] = "Gold Coin",
	[380843] = "Rubber Fish",
	[380847] = "Emerald Gem Cluster",
	[380859] = "Tuskarr Toy Boat",
	[380860] = "Centaur Horn",
	[380867] = "Amber Gem Cluster",
	[380902] = "Fields of Ferocity",
	[380918] = "Broken Ornamented Statue",
	[380963] = "Small Pile of Ash",
	[380991] = "Dirt Mound",
	[381035] = "The Great Vault",
	[381045] = "Golden Dragon Goblet",
	[381065] = "Broken Waygate",
	[381069] = "Full Fishing Net",
	[381071] = "Box of Rocks",
	[381094] = "Elegant Canvas Brush",
	[381104] = "Rich Serevite Deposit",
	[381105] = "Rich Serevite Deposit",
	[381106] = "Serevite Seam",
	[381107] = "Sand Pile",
	[381108] = "Yennu's Map",
	[381110] = "Forgotten Jewel Box",
	[381153] = "Ruby Gem Cluster",
	[381154] = "Writhebark",
	[381157] = "Sapphire Gem Cluster",
	[381158] = "Gnoll Fiend Flail",
	[381160] = "Lost Compass",
	[381196] = "Titan-Touched Writhebark",
	[381197] = "Infurious Writhebark",
	[381198] = "Decayed Writhebark",
	[381199] = "Windswept Writhebark",
	[381200] = "Frigid Writhebark",
	[381201] = "Frigid Saxifrage",
	[381202] = "Windswept Saxifrage",
	[381203] = "Decayed Saxifrage",
	[381204] = "Infurious Saxifrage",
	[381205] = "Titan-Touched Saxifrage",
	[381207] = "Saxifrage",
	[381210] = "Titan-Touched Hochenblume",
	[381211] = "Infurious Hochenblume",
	[381212] = "Decayed Hochenblume",
	[381213] = "Windswept Hochenblume",
	[381214] = "Frigid Hochenblume",
	[381216] = "Surveyor's Magnifying Glass",
	[381223] = "Cracked Hourglass",
	[381277] = "Barrel of Confiscated Treats",
	[381296] = "Horrible Mess",
	[381297] = "Misplaced Luggage",
	[381336] = "One Small Part",
	[381340] = "Neltharus Stands",
	[381341] = "Welcoming the First",
	[381343] = "Learn and Grow",
	[381353] = "Stone Dragontooth",
	[381354] = "Wrapped Gold Band",
	[381355] = "Finely Carved Wing",
	[381356] = "Coldwashed Dragonclaw",
	[381357] = "Stone Tablet",
	[381358] = "Stone Tablet",
	[381359] = "Stone Tablet",
	[381361] = "Precious Stone Fragment",
	[381362] = "Chunk of Sculpture",
	[381365] = "Dragonscale Expedition Flag",
	[381367] = "Dragonscale Expedition Flag",
	[381369] = "Dragonscale Expedition Flag",
	[381370] = "Dragonscale Expedition Flag",
	[381373] = "Dragonscale Expedition Flag",
	[381375] = "Dragonscale Expedition Flag",
	[381377] = "Dragonscale Expedition Flag",
	[381483] = "Marmoni's Prize",
	[381484] = "Well-Preserved Bone",
	[381485] = "Adventurer's Lost Soap Bar",
	[381510] = "Flying Fish Bones",
	[381511] = "Harpoon Head",
	[381512] = "Wooden Pole",
	[381513] = "Old Pickaxe",
	[381514] = "Sea-Polished Basalt",
	[381515] = "Hardened Serevite Deposit",
	[381516] = "Molten Serevite Deposit",
	[381517] = "Titan-Touched Serevite Deposit",
	[381518] = "Primal Serevite Deposit",
	[381519] = "Infurious Serevite Deposit",
	[381575] = "Duck Trap Kit",
	[381579] = "Archivists' Request",
	[381584] = "Archivists' Request",
	[381650] = "Archivists' Request",
	[381653] = "Fang Flap Fire Signups",
	[381661] = "Archivists' Request",
	[381662] = "Archivists' Request",
	[381663] = "Manastorming For Beginners",
	[381664] = "Archivists' Request",
	[381667] = "Archivists' Request",
	[381668] = "Archivists' Request",
	[381669] = "Archivists' Request",
	[381670] = "Archivists' Request",
	[381671] = "Archivists' Request",
	[381672] = "Archivists' Request",
	[381687] = "Discarded Note",
	[381691] = "A Steamy Romance Novel: The Lusty Draconian Mage",
	[381701] = "WANTED: Mara'nar the Thunderous",
	[381705] = "The Gnoll Wars",
	[381706] = "Your Dreamer",
	[381707] = "Dreams in Emerald",
	[381708] = "The First Kurnal",
	[381709] = "Wind, Wood, Water",
	[381711] = "Im'bunata's Blessing",
	[381712] = "Water-Bound Chest",
	[381713] = "A Solid Foundation",
	[381715] = "Attention: Immediate Evacuation",
	[381718] = "The Vow",
	[381722] = "Vakthros Maintenance",
	[381730] = "Mighty Ducks",
	[381731] = "A Timely Message",
	[381732] = "Keeper's Blessing",
	[381733] = "Guardian Wings",
	[381734] = "Together Bound",
	[381735] = "Caretaker's Notes",
	[381736] = "Valdrakken",
	[381957] = "Lush Bubble Poppy",
	[381958] = "Lush Writhebark",
	[381959] = "Lush Saxifrage",
	[381960] = "Lush Hochenblume",
	[381964] = "Deactivated Signal Transmitter",
	[381981] = "Chest of the Flood",
	[381983] = "Deactivated Signal Transmitter",
	[381985] = "Deactivated Signal Transmitter",
	[381987] = "Deactivated Signal Transmitter",
	[381989] = "Deactivated Signal Transmitter",
	[381991] = "Deactivated Signal Transmitter",
	[381993] = "Deactivated Signal Transmitter",
	[381995] = "Deactivated Signal Transmitter",
	[381997] = "Deactivated Signal Transmitter",
	[381999] = "Deactivated Signal Transmitter",
	[382001] = "Deactivated Signal Transmitter",
	[382003] = "Deactivated Signal Transmitter",
	[382029] = "Disturbed Dirt",
	[382071] = "Full Fishing Net",
	[382079] = "Dragonscale Expedition Flag",
	[382086] = "Dragonscale Expedition Flag",
	[382092] = "Dragonscale Expedition Flag",
	[382094] = "Dragonscale Expedition Flag",
	[382101] = "Dragonscale Expedition Flag",
	[382103] = "Dragonscale Expedition Flag",
	[382105] = "Dragonscale Expedition Flag",
	[382107] = "Dragonscale Expedition Flag",
	[382110] = "Dragonscale Expedition Flag",
	[382112] = "Dragonscale Expedition Flag",
	[382116] = "Dragonscale Expedition Flag",
	[382118] = "Dragonscale Expedition Flag",
	[382120] = "Dragonscale Expedition Flag",
	[382166] = "The Ruby Feast!",
	[382180] = "Overheated Magma Thresher Pool",
	[382193] = "Chest of the Elements",
	[382195] = "Elemental Bound Chest",
	[382325] = "Onyx Gem Cluster",
	[382621] = "Revival Catalyst Console",
	[383625] = "Case of Fresh Gleamfish",
	[383660] = "Salt Crystal",
	[383732] = "Tuskarr Tacklebox",
	[383733] = "Disturbed Dirt",
	[383734] = "Disturbed Dirt",
	[383735] = "Disturbed Dirt",
	[384311] = "Ancient Volume",
	[384312] = "Ancient Volume",
	[384313] = "Ancient Volume",
	[384317] = "Crumpled Schematic",
	[384318] = "Inconspicuous Bookmark",
	[384370] = "Deliberately Delinquent Notes",
	[384405] = "Half-Boiled Fish",
	[384653] = "Ancient Volume",
	[384654] = "Ancient Volume",
	[384744] = "Warcraft Rumble Machine",
	[384763] = "Forbidden Hoard",
	[384980] = "Mysterious Chest",
	[385001] = "Empty Fish Barrel",
	[385008] = "Spun Webs",
	[385010] = "Spun Webs",
	[385021] = "Petrified Dragon Egg",
	[385022] = "Eroded Fossil",
	[385028] = "Powerful Flask of Renewal",
	[385032] = "Gold Pile",
	[385064] = "Ice Spike",
	[385074] = "Magic-Bound Chest",
	[385075] = "Magic-Bound Chest",
	[385396] = "Primordial Fire Cache",
	[385398] = "Searing Chest",
	[385401] = "Searing Chest",
	[385415] = "Bone Pile",
	[385467] = "Bone Pile",
	[385468] = "Bone Pile",
	[385469] = "Bone Pile",
	[385520] = "Bone Pile",
	[385533] = "Sending Stone: Protest",
	[385565] = "Blazing Shadowflame Chest",
	[385581] = "Henry's Handbag",
	[385584] = "Demanding Perfection",
	[385585] = "Binding Oaths",
	[385586] = "Primal Power",
	[385799] = "Hardened Strongbox",
	[385800] = "Gold Pile",
	[385801] = "Gold Pile",
	[385802] = "Gold Pile",
	[385826] = "Titan Coffer",
	[385830] = "Sending Stone: Initial Report",
	[385831] = "Sending Stone: The Prisoner",
	[385832] = "Receiving Stone: Final Warning",
	[385834] = "Journal Entry: Experiments",
	[385835] = "Journal Entry: Relics",
	[385836] = "Journal Entry: The Creches",
	[385837] = "Journal Entry: Silence",
	[385917] = "Deactivated Signal Transmitter",
	[385919] = "Deactivated Signal Transmitter",
	[385921] = "Deactivated Signal Transmitter",
	[385937] = "Titan Coffer",
	[385940] = "Runic Wrench",
	[385952] = "Unusual Ring",
	[385958] = "Rumble Coin Bag",
	[385961] = "Rumble Coin Bag",
	[386079] = "Well-Chewed Chest",
	[386080] = "Scorching Key",
	[386083] = "Seething Orb",
	[386086] = "Seething Cache",
	[386088] = "Ritual Offerings",
	[386089] = "Ritual Offerings",
	[386090] = "Ritual Offerings",
	[386091] = "Ritual Offerings",
	[386104] = "Ancient Zaqali Chest",
	[386106] = "Dragonscale Expedition Flag",
	[386108] = "Dragonscale Expedition Flag",
	[386123] = "Charred Egg",
	[386138] = "Rumble Coin Bag",
	[386139] = "Rumble Coin Bag",
	[386140] = "Rumble Foil Bag",
	[386157] = "Rumble Foil Bag",
	[386158] = "Rumble Foil Bag",
	[386168] = "Farscale Cache",
	[386353] = "Hardened Chest",
	[386354] = "Hardened Chest",
	[386421] = "Primordial Fire Cache",
	[386422] = "Primordial Fire Cache",
	[386423] = "Primordial Fire Cache",
	[386424] = "Searing Chest",
	[386425] = "Searing Chest",
	[386426] = "Primordial Earth Cache",
	[386427] = "Cart of Crushed Stone",
	[386428] = "Primordial Earth Cache",
	[386429] = "Primordial Earth Cache",
	[386430] = "Hardened Chest",
	[386431] = "Primordial Earth Cache",
	[386432] = "Hardened Chest",
	[386433] = "Primordial Wind Cache",
	[386441] = "Primordial Wind Cache",
	[386442] = "Primordial Void Cache",
	[386443] = "Primordial Wind Cache",
	[386444] = "Primordial Water Cache",
	[386445] = "Primordial Water Cache",
	[386447] = "Primordial Water Cache",
	[386450] = "Primordial Water Cache",
	[386451] = "Wind-Bound Strongbox",
	[386452] = "Void-Bound Strongbox",
	[386453] = "Wind-Bound Strongbox",
	[386454] = "Chest of Ice",
	[386455] = "Hardshell Chest",
	[386456] = "Hardshell Chest",
	[386457] = "Frozen Coffer",
	[386458] = "Primordial Decay Cache",
	[386459] = "Primordial Decay Cache",
	[386460] = "Primordial Arcane Cache",
	[386461] = "Primordial Arcane Cache",
	[386462] = "Primordial Blood Cache",
	[386463] = "Primordial Gold Cache",
	[386470] = "Gold Pile",
	[386472] = "Gold Pile",
	[386484] = "Gold Pile",
	[386531] = "Gold Pile",
	[386532] = "Primordial Gold Cache",
	[386547] = "Suffusion Mold",
	[386555] = "Odd Circular Object",
	[386556] = "Dusty Vase",
	[386559] = "Secured Shipment",
	[386573] = "Ornate Key Box",
	[386578] = "Neltharion Gift Token",
	[386579] = "Neltharion Gift Token",
	[386580] = "Neltharion Gift Token",
	[386581] = "Neltharion Gift Token",
	[386582] = "Neltharion Gift Token",
	[386583] = "Neltharion Gift Token",
	[386585] = "Experimental Melder",
	[386586] = "Prismatic Fragment",
	[386587] = "Prismatic Fragment",
	[386588] = "Crystal Basket",
	[386589] = "Crystal Basket",
	[386591] = "Empty Vial",
	[386604] = "Primordial Gold Cache",
	[386605] = "Gold Pile",
	[386632] = "Experimental Dragon Pack",
	[386633] = "Chest of Storms",
	[386648] = "Mysterious Scroll",
	[386660] = "Gold Pile",
	[386668] = "Shattered Hakkari Bijou",
	[386669] = "Fragmented Hakkari Bijou",
	[386680] = "Mysterious Almanac",
	[386683] = "Seared Book",
	[386687] = "Aged Journal",
	[386688] = "Blank Tome",
	[386690] = "Ambiguous Compendium",
	[386762] = "Primordial Armor Cache",
	[387493] = "Unique Fish",
	[387496] = "Brazier of Madness",
	[387500] = "Chilly Snowman",
	[387501] = "Neltharion Gift Token",
	[387503] = "Sealed Letter to Neltharion",
	[387507] = "Azerite Powder Barrel",
	[387508] = "Igniter Torch",
	[387520] = "TICKET: Glimmerogg Games",
	[387695] = "Rumble Coin Bag",
	[387696] = "Rumble Coin Bag",
	[387697] = "Rumble Coin Bag",
	[387718] = "Rumble Foil Bag",
	[387719] = "Rumble Foil Bag",
	[387720] = "Rumble Foil Bag",
	[387721] = "Rumble Foil Bag",
	[387722] = "Rumble Foil Bag",
	[387725] = "Glowing Crystal",
	[387727] = "Sulfuric Crystal",
	[387728] = "Opera of the Aspects",
	[387729] = "Magma Crystal",
	[387736] = "The Old Gods and the Ordering of Azeroth",
	[387737] = "Living Book",
	[387746] = "Primordial Spirit Cache",
	[387749] = "Animate Crystalspine",
	[387853] = "Shattered Crystals",
	[388471] = "Pillaged Primordial Cache",
	[388712] = "Opera Chest",
	[388866] = "Reagent Pot",
	[388873] = "Irontide Coin Bag",
	[388876] = "Reagent Pot",
	[388895] = "Random Scribblings",
	[388896] = "Crystal-encased Chest",
	[388905] = "Neltharion Toolkit",
	[388908] = "Inert Goo",
	[388911] = "Old Trunk",
	[389102] = "Prismatic Fragment",
	[389103] = "Prismatic Fragment",
	[389104] = "Prismatic Fragment",
	[389105] = "Prismatic Fragment",
	[389106] = "Prismatic Fragment",
	[389107] = "Prismatic Fragment",
	[389108] = "Prismatic Fragment",
	[389111] = "Waterlogged Bundle",
	[389114] = "Long-Lost Cache",
	[389173] = "Primordial Blood Cache",
	[389231] = "Primordial Music Cache",
	[389471] = "Grand Obsidian Cache",
	[389540] = "Slimy Goo",
	[389545] = "Mysterious Chest",
	[389546] = "Reagent Pot",
	[389564] = "Mindless Slime",
	[389599] = "Ice Spike",
	[389789] = "Primordial Earth Cache",
	[389902] = "Primordial Earth Cache",
	[390008] = "Ice",
	[390009] = "Box of Rocks",
	[390074] = "Primordial Deep Ocean Cache",
	[390136] = "Spore-bound Essence",
	[390137] = "Metamorphic Serevite Deposit",
	[390138] = "Metamorphic Draconium Deposit",
	[390139] = "Lambent Hochenblume",
	[390140] = "Lambent Saxifrage",
	[390141] = "Lambent Writhebark",
	[390142] = "Lambent Bubble Poppy",
	[390257] = "Stuffed Bear",
	[390258] = "Inert Goo",
	[390559] = "Box of Rocks",
	[390560] = "Locked Research Chest",
	[392025] = "Molded Coins",
	[392026] = "Neltharion Coin Mold",
	[392030] = "Blacksteel Hammer",
	[392031] = "Rumble Foil Bag",
	[392032] = "Rumble Foil Bag",
	[392335] = "Primordial Armor Cache",
	[392569] = "Chain-Bound Primordial Cache",
	[392570] = "Chain-Bound Primordial Cache",
	[392571] = "Chain-Bound Strongbox",
	[392572] = "Chain-Bound Strongbox",
	[392573] = "Chain-Bound Strongbox",
	[392580] = "Misplaced Aberrus Outflow Blueprints",
	[392581] = "Haphazardly Discarded Bombs",
	[392582] = "Defective Survival Pack",
	[392583] = "Void-Bound Strongbox",
	[392587] = "Busted Wyrmhole Generator",
	[392591] = "Chest of the Flights",
	[392593] = "Inconspicuous Data Miner",
	[393218] = "Primordial Arcane Cache",
	[393220] = "Primordial Paint Cache",
	[393221] = "Reagent Pot",
	[393222] = "Supply Trunk",
	[393282] = "Balloon Box",
	[393283] = "Balloon Box",
	[393957] = "Gold Pile",
	[393958] = "Gold Pile",
	[396019] = "Stolen Stash",
	[396020] = "Stolen Stash",
	[396339] = "Moth-Pilfered Pouch",
	[398133] = "Bolts and Brass",
	[398135] = "Discarded Dracothyst Drill",
	[398138] = "Molten Scoutbot",
	[398200] = "Forgotten Lockbox",
	[398674] = "Vibrant Flyer",
	[398698] = "Squeaking Swiss",
	[398751] = "Lush Bubble Poppy",
	[398752] = "Lush Writhebark",
	[398753] = "Lush Hochenblume",
	[398754] = "Lush Saxifrage",
	[398755] = "Bubble Poppy",
	[398756] = "Writhebark",
	[398758] = "Saxifrage",
	[398759] = "Titan-Touched Bubble Poppy",
	[398760] = "Titan-Touched Writhebark",
	[398761] = "Titan-Touched Hochenblume",
	[398762] = "Titan-Touched Saxifrage",
	[398764] = "Infurious Bubble Poppy",
	[398765] = "Infurious Writhebark",
	[398766] = "Infurious Hochenblume",
	[398767] = "Infurious Saxifrage",
	[398770] = "Box of Rocks",
	[398778] = "Disgusting Vat",
	[398783] = "Flame-Infused Scale Oil",
	[398785] = "Lava-Forged Leatherworker's 'Knife'",
	[398786] = "Spun Webs",
	[398787] = "Spun Webs",
	[398788] = "Spun Webs",
	[398789] = "Spun Webs",
	[398790] = "Spun Webs",
	[398791] = "Sulfur-Soaked Skins",
	[398793] = "Lava-Drenched Shadow Crystal",
	[398794] = "Shimmering Aqueous Orb",
	[398796] = "Resonating Arcane Crystal",
	[398810] = "Fealty's Reward",
	[398814] = "Molten Hoard",
	[398815] = "Secured Shipment",
	[398828] = "Chest of Massive Gains",
	[401236] = "Malnourished Specimen",
	[401238] = "Marrow-Ripened Slime",
	[401240] = "Suspicious Mold",
	[401241] = "Snubbed Snail Shells",
	[401292] = "Gently Jostled Jewels",
	[401299] = "Broken Barter Boulder",
	[401828] = "Nal ks'kol Reliquary",
	[401839] = "Dreamer's Bounty",
	[401844] = "Smelly Trash Pile",
	[401845] = "Smelly Disturbed Dirt",
	[401846] = "Smelly Treasure Chest",
	[402578] = "Glowing Key",
	[402609] = "Demonic Gateway",
	[402627] = "Well-Worn Kiln",
	[402632] = "Brimstone Rescue Ring",
	[402634] = "Zaqali Elder Spear",
	[402841] = "Delicate Experimental Egg",
	[402868] = "Abandoned Reserve Chute",
	[402878] = "Used Medical Wrap Kit",
	[402887] = "Exquisitely Embroidered Banner",
	[402888] = "Intricate Zaqali Runes",
	[402890] = "Hissing Rune Draft",
	[402892] = "Ancient Research",
	[403458] = "Dauntless Draught",
	[403498] = "Eva's Journal",
	[403532] = "Bucket of Fountain Water",
	[403533] = "Undelivered Shipment of Smokes",
	[403534] = "Trampled Doll",
	[403535] = "The Deed to Andorhal",
	[403536] = "The Road Ahead",
	[403541] = "Wand of Mass Polymorph",
	[403552] = "Eva's Femur",
	[403567] = "Cracked Argent Dawn Commission",
	[403702] = "Lost Page",
	[403703] = "Lost Page",
	[403704] = "Lost Page",
	[403705] = "Lost Page",
	[403706] = "Lost Page",
	[403707] = "Lost Page",
	[403708] = "Lost Page",
	[403709] = "Lost Page",
	[403710] = "Lost Page",
	[403711] = "Lost Page",
	[403712] = "Lost Page",
	[403713] = "Lost Page",
	[403714] = "Lost Page",
	[403715] = "Lost Page",
	[403716] = "Lost Page",
	[403717] = "Lost Page",
	[403722] = "Conveniently Misplaced Hook",
	[403731] = "Frozen Rune",
	[403786] = "Antlered Skull",
	[403919] = "Mechanized Cog",
	[403962] = "Omarion's Second Handbook",
	[404232] = "Pale Duskblossom",
	[404242] = "Oil Soaked Book",
	[404260] = "Riddle Solved!",
	[404314] = "Chipped Stone Tabled",
	[404319] = "Time Lost Fragment",
	[404337] = "Bar Tab Barrel",
	[404432] = "Bload Soaked Book",
	[404480] = "Ragged Mantid Sword",
	[404492] = "Gilded Vase",
	[404849] = "Dreadsquall Nest",
	[404981] = "Bar Tab Barrel",
	[404982] = "Bar Tab Barrel",
	[404987] = "Bar Tab Barrel",
	[404992] = "Bar Tab Barrel",
	[405009] = "Bar Tab Barrel",
	[405010] = "Bar Tab Barrel",
	[405012] = "Bar Tab Barrel",
	[405068] = "Forgotten Grimoire",
	[405286] = "Torn Page",
	[405388] = "Familiar Journal",
	[405489] = "Preservationist's Locker",
	[405510] = "Ancient Lever",
	[405511] = "Ancient Lever",
	[405512] = "Ancient Lever",
	[405513] = "Torch of Pyrreth",
	[405515] = "Enchanted Box",
	[405523] = "Unveiled Tablet",
	[405525] = "Loose Dirt Mound",
	[405526] = "Loose Dirt Mound",
	[405529] = "Loose Dirt Mound",
	[405530] = "Loose Dirt Mound",
	[405531] = "Loose Dirt Mound",
	[405532] = "Loose Dirt Mound",
	[405533] = "Loose Dirt Mound",
	[405534] = "Loose Dirt Mound",
	[405535] = "Loose Dirt Mound",
	[405536] = "Loose Dirt Mound",
	[405537] = "Loose Dirt Mound",
	[405538] = "Loose Dirt Mound",
	[405539] = "Loose Dirt Mound",
	[405540] = "Loose Dirt Mound",
	[405541] = "Loose Dirt Mound",
	[405546] = "Idol of Ohn'ahra",
	[405584] = "Rumble Foil Bag",
	[405585] = "Rumble Foil Bag",
	[405586] = "Rumble Foil Bag",
	[405587] = "Rumble Foil Bag",
	[405593] = "Azerothian Archives!",
	[405943] = "Drakonid Scroll Case",
	[405958] = "Sealed Kaldorei Scroll",
	[405996] = "Ancient Zaqali Trade-bond Tablet",
	[406383] = "Firelands Portal",
	[407186] = "Bar Tab Barrel",
	[407192] = "Bar Tab Barrel",
	[407199] = "Bar Tab Barrel",
	[407201] = "Bar Tab Barrel",
	[407691] = "Dusty Red Pellets",
	[407692] = "Igneous Flux",
	[407739] = "Triflesnatch's Roving Trove",
	[407862] = "Hidden Moonkin Stash",
	[408060] = "The First Clue",
	[408076] = "The Second Clue",
	[408079] = "The Third Clue",
	[408080] = "A Partial Fourth Clue",
	[408081] = "A Partial Fourth Clue",
	[408082] = "A Partial Fourth Clue",
	[408083] = "A Partial Fourth Clue",
	[408107] = "Crystalline Glowblossom",
	[408224] = "Hastily Scrawled Stone",
	[408226] = "Ancient Key Mold",
	[408706] = "Magical Bloom",
	[408707] = "Odd Burl",
	[408719] = "Small Somnut",
	[408720] = "Laden Somnut",
	[408754] = "Reforged Titan Key",
	[408767] = "Dusty Bag",
	[408860] = "Mimiron's Booster Part",
	[408934] = "Artificing Tools",
	[408954] = "Artificer's Lockbox",
	[408964] = "Satyr Totem",
	[408976] = "Ancient Tome",
	[408980] = "Tyr's Legacy",
	[408997] = "Turtle Egg",
	[409012] = "Auction House Bill of Sale",
	[409016] = "Void Storage Receipt",
	[409017] = "Garden Supply Receipt",
	[409018] = "Researcher's Note",
	[409019] = "Hastily Scrawled Note",
	[409020] = "Note to Kritha",
	[409077] = "Singed Leaflet",
	[409120] = "Cache of Cosmic Mysteries",
	[409166] = "Titan Power Relay",
	[409200] = "Broken Urn",
	[409208] = "Broken Urn",
	[409209] = "Broken Urn",
	[409211] = "Broken Urn",
	[409212] = "Broken Urn",
	[409214] = "Broken Urn",
	[409222] = "Boon of Ursol",
	[409302] = "Dispersal Crystal",
	[409320] = "Buried Object",
	[409329] = "Buried Object",
	[409333] = "Buried Object",
	[409338] = "Washed-Up Pack",
	[409440] = "Pineshrew Pile",
	[409458] = "Lost Fishing Supplies",
	[409835] = "Loose Dirt Mound",
	[409849] = "Ashwood Research Binder",
	[409914] = "Mimiron's Booster Part",
	[410045] = "Ageless Blossom",
	[410046] = "Ageless Blossom",
	[410048] = "Ageless Blossom",
	[410179] = "Loose Dirt Mound",
	[410181] = "Loose Dirt Mound",
	[410395] = "Siegehold Records",
	[410426] = "Half-Filled Dreamless Sleep Potion",
	[410434] = "Splash Potion of Narcolepsy",
	[410442] = "Root of the Problem",
	[410456] = "Experimental Dreamcatcher",
	[410458] = "Insomniotron",
	[410459] = "Highlands Lodestone",
	[410469] = "Unhatched Battery",
	[410475] = "Petrified Hope",
	[410479] = "Unpolished Blemish",
	[410484] = "Coalesced Dreamstone",
	[410529] = "Tuft of Dreamsaber Fur",
	[410534] = "Molted Faerie Dragon Scales",
	[410550] = "Dreamtalon Claw",
	[410574] = "Pure Dream Water",
	[410575] = "Everburning Core",
	[410582] = "Essence of Dreams",
	[410786] = "Alydrus' Research Notes",
	[410833] = "The Reforging of the Tyr's Guard",
	[410994] = "Map of Shadowfang Keep Security",
	[410998] = "Formula: Intoxicating Toxic Perfume",
	[410999] = "Memo from Apothecary Hummel",
	[411065] = "Boon of Ashamane",
	[411066] = "Boon of Aviana",
	[411067] = "Boon of Goldrinn",
	[411102] = "Airship Rubble",
	[411104] = "Well-Bleached Bones",
	[411106] = "Weathered Cloth",
	[411168] = "Winnie's Notes on Flora and Fauna",
	[411169] = "Grove Keeper's Pillar",
	[411170] = "Primalist Shadowbinding Rune",
	[411171] = "Exceedingly Soft Wildercloth",
	[411176] = "Plush Pillow",
	[411177] = "Snuggle Buddy",
	[411179] = "Amirdrassil Defender's Shield",
	[411180] = "Deathstalker Chassis",
	[411181] = "Flamesworn Render",
	[411447] = "Unwaking Echo",
	[411463] = "Unwaking Echo",
	[411465] = "Unwaking Echo",
	[411466] = "Unwaking Echo",
	[411560] = "Lavenbloom",
	[411561] = "Sugar Orchid",
	[411562] = "Orange Illicium",
	[411571] = "Freydrin's Shillelagh",
	[411622] = "Machinist Plinth",
	[411623] = "Machinist Plinth",
	[411624] = "Machinist Plinth",
	[411691] = "Shiny New Weapon",
	[411778] = "Pollenfused Bristlebruin Fur Sample",
	[411878] = "Intriguing Scrap",
	[411930] = "Blackpowder Barrel",
	[411936] = "Orb Location",
	[412066] = "Throwing Stone",
	[412950] = "Moon-Blessed Claw",
	[412995] = "Small Box of Vials",
	[413126] = "Box of Artisanal Goods",
	[413246] = "Elemental Silt Mound",
	[413590] = "Bountiful Coffer",
	[413694] = "Suspicious Vent",
	[413774] = "The Legend of Elun'Ahir",
	[413780] = "On the Nature of the Dream",
	[413784] = "Self-Baking Herb Based Cookies",
	[413787] = "The Tragedy of Erinethria",
	[414113] = "Sivstone Deposit",
	[414169] = "Mysterious Seeds",
	[414199] = "Pile of Earthen Belongings",
	[414700] = "Ethereal Sugar",
	[415296] = "Repair Kit",
	[415303] = "Magically-Sealed Parcel",
	[415584] = "Sizzling Magma Core",
	[416310] = "Kobyss Chest",
	[416401] = "Kobyss Spear",
	[416448] = "Lush Lavenbloom",
	[416450] = "Lush Orange Illicium",
	[416950] = "Unsorted Ore Pile",
	[416954] = "Ore Fragment",
	[416968] = "Stillstone Catch",
	[416969] = "Harvest Wine",
	[416970] = "Hallowfall Farm Supplies",
	[416971] = "Fallow Corn",
	[416973] = "Arathi Toolbox",
	[416974] = "Rolled Arathi-Rug",
	[417057] = "Hallowfall Farm Supply",
	[417136] = "Intriguing Scrap",
	[417137] = "Intriguing Scrap",
	[417138] = "Intriguing Scrap",
	[417381] = "Small Bag of Seeds",
	[419657] = "Abandoned Tools",
	[419695] = "Spore-Covered Coffer",
	[419714] = "Expedition Pack",
	[419729] = "Strange Eggs",
	[420019] = "Artificing Tools",
	[420039] = "Artificing Tools",
	[420040] = "Artificing Tools",
	[420053] = "Webbed Knapsack",
	[420195] = "Golden Egg Heirloom",
	[420722] = "Lost Page",
	[420730] = "Vein of Ore",
	[420734] = "Ashenfold",
	[420954] = "Carved Eye",
	[421070] = "Remnant Sachel",
	[421154] = "Carved Eye",
	[421179] = "Kaldorei Bedroll",
	[421180] = "Kaldorei Backpack",
	[421181] = "Kaldorei Dagger",
	[421182] = "Kaldorei Horn",
	[421183] = "Kaldorei Bag",
	[421184] = "Kaldorei Shield",
	[421185] = "Kaldorei Spear",
	[421186] = "Kaldorei Spyglass",
	[421338] = "Kaldorei Bag",
	[421339] = "Kaldorei Horn",
	[421360] = "Memorial Bouquet",
	[421525] = "Shinies",
	[421555] = "Kaldorei Moon Bow",
	[421592] = "Life Savings",
	[421594] = "Gainful Employment",
	[421597] = "Village Center",
	[421599] = "Local Industry",
	[421718] = "Dragon Pepe",
	[421735] = "Prooftelling Flower",
	[421736] = "Explorer Pepe",
	[421740] = "Tuskarr Pepe",
	[421909] = "Fallen Defender",
	[422560] = "Maevest's Compass",
	[423581] = "Broodmother's Egg",
	[423596] = "Sand Pile",
	[423602] = "Sand Pile",
	[423603] = "Sand Pile",
	[423612] = "Titan Artifacts",
	[423688] = "Titan Device",
	[423714] = "Duskstem Stalk",
	[423854] = "Soulwell",
	[423958] = "Arathi Chest",
	[423959] = "Faded Supply Chest",
	[423971] = "Coral-Fused Clam",
	[423977] = "Kobyss Chest",
	[423978] = "Kobyss Chest",
	[423979] = "Kobyss Chest",
	[423987] = "Dropped Package",
	[424098] = "Golden Egg Heirloom",
	[424253] = "Korgran's Lantern",
	[424343] = "Medical Supplies",
	[424347] = "Empty Crab Cage",
	[424436] = "Order of Night Propaganda",
	[425875] = "Priority Transport Crate",
	[428135] = "Discarded Botanist Notes",
	[428167] = "Discarded Research Notes",
	[428199] = "Discarded Research Notes",
	[428472] = "Captain Lancekat's Discretionary Funds",
	[428699] = "Sizzling Barrel",
	[428814] = "Inconspicuous Box",
	[429301] = "Shipment Crate",
	[429303] = "Angrily-Scrawled Poster",
	[429765] = "Forgotten Chest",
	[430215] = "Molten Wax",
	[430284] = "Radiant Remnant",
	[430337] = "Radiant Remnant",
	[430340] = "Radiant Remnant",
	[430341] = "Radiant Remnant",
	[430342] = "Radiant Remnant",
	[430343] = "Radiant Remnant",
	[430344] = "Radiant Remnant",
	[430345] = "Radiant Remnant",
	[430358] = "Radiant Remnant",
	[430551] = "Coal Shipment",
	[430581] = "Egg Basket",
	[432893] = "Shipment Crate",
	[432894] = "Shipment Crate",
	[433090] = "Infused Underclay",
	[433101] = "Bag of Glowing Shards",
	[433102] = "Bundle of Receipts",
	[433109] = "Nerubian Silk Ropes",
	[433370] = "War Supply Chest",
	[433377] = "Harvest Box",
	[433733] = "Forgotten Treasure",
	[433757] = "Buried Treasure",
	[433773] = "Buried Treasure",
	[433774] = "Buried Treasure",
	[433776] = "Buried Treasure",
	[433778] = "Buried Treasure",
	[433907] = "Order of Night Propaganda",
	[434281] = "Radiant Remnant",
	[434283] = "Radiant Remnant",
	[434284] = "Radiant Remnant",
	[434285] = "Radiant Remnant",
	[434286] = "Radiant Remnant",
	[434288] = "Radiant Remnant",
	[434289] = "Radiant Remnant",
	[434502] = "Anglers Supply Box",
	[434527] = "Thimble's Cache",
	[434554] = "Radiant Remnant",
	[434560] = "Radiant Remnant",
	[434561] = "Radiant Remnant",
	[434563] = "Radiant Remnant",
	[434564] = "Radiant Remnant",
	[434565] = "Radiant Remnant",
	[434566] = "Radiant Remnant",
	[434567] = "Radiant Remnant",
	[434568] = "Radiant Remnant",
	[434861] = "Ever-Blossoming Fungi",
	[434924] = "Radiant Remnant",
	[434925] = "Radiant Remnant",
	[434926] = "Radiant Remnant",
	[434927] = "Radiant Remnant",
	[434928] = "Radiant Remnant",
	[434929] = "Radiant Remnant",
	[434930] = "Radiant Remnant",
	[434932] = "Radiant Remnant",
	[435008] = "Farmhand Stash",
	[435009] = "Radiant Remnant",
	[436933] = "Softsnout's Favorite Shovel",
	[437025] = "Sludge Pile",
	[437058] = "Forgotten Memorial",
	[437060] = "Aspirant's Tribute",
	[437112] = "Clammer's Kit",
	[437191] = "Forgotten Memorial",
	[437195] = "Titan Artifacts",
	[437205] = "Sureki War Chest",
	[437211] = "Illuminated Footlocker",
	[437216] = "Sureki Shadecaster",
	[437302] = "Fisherman's Pouch",
	[437389] = "Forgotten Memorial",
	[437726] = "Luminescent Umbrashroom",
	[437767] = "Crate of Hallowfall Herbs",
	[437769] = "Fragrant Fangpetal",
	[438037] = "Black Blood Vessel",
	[438038] = "Venomancy Flask",
	[438039] = "Alchemical Instruments",
	[439291] = "Repossessed Goods",
	[439314] = "Camp Supplies",
	[439324] = "Discarded Artifacts",
	[439334] = "Sureki Shadecaster",
	[439339] = "Sureki Shadecaster",
	[439348] = "Mutagen Cache",
	[439382] = "Suspicious Shipment",
	[439463] = "Spilled Fire honey",
	[439473] = "Tenir and the Order of Night",
	[439474] = "Queensguard Weaponry",
	[439531] = "Unattended Arbalest",
	[439532] = "Sureki Smithing Tool",
	[439562] = "Fallen Aeroknight",
	[439890] = "Grave Offering Location",
	[440914] = "Offering of Pure Water",
	[440926] = "Jar of Mucus",
	[441183] = "Galan's Edict",
	[441223] = "Stone of The Unbound",
	[441231] = "Titan Console",
	[441278] = "Watcher of The South",
	[441284] = "Watcher of The North",
	[441358] = "A Skull on a Sign",
	[441555] = "Wax-Drenched Sign",
	[441563] = "Submerged Sign",
	[441577] = "Warning: Collapsed Tunnel",
	[441578] = "Kobold Warning Sign",
	[441585] = "Burning Venom Flask",
	[441586] = "Military Correspondence",
	[441587] = "Crate of Emptied Vials",
	[441588] = "Confiscated Weapons",
	[441606] = "Jewel of the Cliffs",
	[441611] = "Windswept Satchel",
	[441628] = "Captain's Chest",
	[441633] = "A Worn Down Book",
	[441637] = "A Weathered Tome",
	[441638] = "Lost Memento",
	[441688] = "A Tattered Note",
	[441720] = "A Scout's Journal",
	[441723] = "Farm Satchel",
	[441795] = "Hallowfall Sparkfly",
	[441797] = "Void-Scarred Stormhammer",
	[441800] = "Sunken Cache",
	[442718] = "Elemental Pearl",
	[442814] = "Boskroot Cap",
	[443318] = "Tree's Treasure",
	[443532] = "Rusted Lever",
	[443638] = "Mosswool Flower",
	[443995] = "Familiar-Looking Appendage",
	[444022] = "Magical Treasure Chest",
	[444028] = "Light-Bathed Lotus",
	[444029] = "Light-Bathed Lotus",
	[444030] = "Light-Bathed Lotus",
	[444065] = "Elemental Geode",
	[444066] = "Keeper's Stash",
	[444071] = "Cursed Pickaxe",
	[444087] = "Munderut's Forgotten Stash",
	[444115] = "Discarded Toolbox",
	[444137] = "Thak's Treasure",
	[444215] = "Mysterious Orb",
	[444233] = "Mushroom Cap",
	[444256] = "Kaja'Cola Machine",
	[444261] = "Purchase Bluesberry Blast - 5 Silver",
	[444275] = "Purchase Mangoro Madness - 5 Silver",
	[444276] = "Purchase Orange O-pocalypse - 5 Silver",
	[444277] = "Purchase Oyster Outbreak - 5 Silver",
	[444354] = "Turtle's Thanks",
	[444773] = "Jade Pearl",
	[444797] = "Threadspun Cache",
	[444798] = "Arathi Treasure Hoard",
	[444799] = "Potent Concentrated Shadow",
	[444800] = "Sureki Strongbox",
	[444801] = "Brimming Arathi Treasure Hoard",
	[444802] = "Kobyss Ritual Cache",
	[444804] = "Concentrated Shadow",
	[444844] = "Stashed Loot",
	[444894] = "Shimmering Opal Lily",
	[444899] = "Kobold Axe",
	[445275] = "Royal Sureki Strongbox",
	[445277] = "Hunters Threadspun Cache",
	[445360] = "Pilfered Loot",
	[445403] = "Scary Dark Chest",
	[446097] = "Disturbed Soil",
	[446100] = "Blocked Intake",
	[446101] = "Nerubian Offerings",
	[446135] = "Niffen Stash",
	[446140] = "Missing Scouts Pack",
	[446151] = "Dislodged Blockage",
	[446299] = "Silk-spun Supplies",
	[446341] = "Dusty Prospector's Chest",
	[446343] = "Loose Crystal Shard",
	[446347] = "Loose Crystal Shard",
	[446349] = "Loose Crystal Shard",
	[446351] = "Loose Crystal Shard",
	[446352] = "Loose Crystal Shard",
	[446362] = "Crimson Charmer",
	[446363] = "Amber Bloom",
	[446366] = "The Great Vault",
	[446404] = "Memory Cache",
	[446419] = "Concealed Contraband",
	[446420] = "\"Weaving Supplies\"",
	[446421] = "Trapped Trove",
	[446423] = "Nest Egg",
	[446435] = "Violet Thread",
	[446437] = "Crimson Thread",
	[446438] = "Gold Thread",
	[446473] = "Infused Cinderbrew",
	[446476] = "Web-wrapped Axe",
	[446495] = "Pile of Refuse",
	[449528] = "Opal-Mining Tools",
	[451442] = "Secret Garlic",
	[451538] = "Sludge Pile",
	[451595] = "Forgotten Memorial",
	[451596] = "Forgotten Memorial",
	[451597] = "Forgotten Memorial",
	[451598] = "Forgotten Memorial",
	[451599] = "Forgotten Memorial",
	[451600] = "Forgotten Memorial",
	[451601] = "Forgotten Memorial",
	[451602] = "Forgotten Memorial",
	[451603] = "Forgotten Memorial",
	[451967] = "Hillhelm Lunchbox",
	[451990] = "Radiant Remnant",
	[451993] = "Nerubian Device",
	[452005] = "Lil Piggy",
	[452438] = "Half-Buried Dog Bowl",
	[452696] = "Machine Speaker's Reliquary",
	[452706] = "Deep-Lost Satchel",
	[452710] = "Brimming Deep-Lost Satchel",
	[453167] = "Disturbed Lynx Treasure",
	[453186] = "Nightfarm Growthling",
	[453283] = "Smuggler's Treasure",
	[453359] = "Dark Ritual",
	[453374] = "Shadowed Essence",
	[453716] = "Cache of Expensive Libations",
	[453741] = "Loremaster's Reward",
	[453749] = "Palawltar's Codex of Dimensional Structure",
	[453751] = "Care and Feeding of the Imperial Lynx",
	[453752] = "Shadow Curfew Guidelines",
	[453753] = "Beledar- The Emperor's Vision",
	[453754] = "The Song of Renilash",
	[453755] = "The Big Book of Arathi Idioms",
	[453937] = "500 Dishes Using Cave Fish and Mushrooms",
	[454021] = "Radiant Remnant",
	[454023] = "Radiant Remnant",
	[454024] = "Radiant Remnant",
	[454037] = "Stolen Supplies",
	[454038] = "Stolen Supplies",
	[454039] = "Stolen Supplies",
	[454049] = "|cff1EFF00Sturdy Chest",
	[454090] = "|cff1EFF00Sturdy Chest",
	[454091] = "|cff1EFF00Sturdy Chest",
	[454092] = "|cff1EFF00Sturdy Chest",
	[454093] = "|cff1EFF00Sturdy Chest",
	[454094] = "|cff1EFF00Sturdy Chest",
	[454176] = "Kaheti Armaments",
	[454189] = "Opal Ore",
	[454200] = "|cff1EFF00Sturdy Chest",
	[454201] = "|cff1EFF00Sturdy Chest",
	[454202] = "|cff1EFF00Sturdy Chest",
	[454205] = "Radiant Prism Crystals",
	[454207] = "|cff1EFF00Sturdy Chest",
	[454313] = "Queen Xekatha",
	[454316] = "Queen Zaltra",
	[454318] = "Thimble's Cache",
	[454320] = "Queen Anub'izek",
	[454321] = "Thimble's Cache",
	[454323] = "Thimble's Cache",
	[454327] = "Thimble's Cache",
	[454328] = "Strands of Memory",
	[454330] = "Treatise on Forms: Skitterlings",
	[454331] = "Thimble's Cache",
	[454332] = "Treatise on Forms: Sages",
	[454334] = "Thimble's Cache",
	[454335] = "Entomological Essay on Grubs, Volume 1",
	[454336] = "Entomological Essay on Grubs, Volume 2",
	[454337] = "Thimble's Cache",
	[454338] = "Entomological Essay on Grubs, Volume 3",
	[454339] = "Thimble's Cache",
	[454340] = "Thimble's Cache",
	[454342] = "Thimble's Cache",
	[454343] = "Ethos of War, Part 1",
	[454344] = "Ethos of War, Part 2",
	[454346] = "Thimble's Cache",
	[454348] = "Ethos of War, Part 3",
	[454350] = "Ethos of War, Part 4",
	[454404] = "Hathlaz's Plaque",
	[454405] = "Attwogaz's Plaque",
	[454406] = "Krattdaz's Plaque",
	[454407] = "Uisgaz's Plaque",
	[454408] = "Venedaz's Plaque",
	[454412] = "Merunth's Plaque",
	[454414] = "Varerko's Plaque",
	[454416] = "Alfritha's Plaque",
	[454417] = "Gundrig's Plaque",
	[454418] = "Sathilga's Plaque",
	[454463] = "Wanted: The Boroughbreaker",
	[454541] = "Radiant Remnant",
	[454542] = "Radiant Remnant",
	[454543] = "Radiant Remnant",
	[454707] = "Bag of Stolen Goods",
	[454797] = "From the Depths They Come",
	[455038] = "Light's Gambit Playbook",
	[455170] = "Crumbling Ironwood Parchment",
	[455183] = "Shadow Curfew Journal",
	[455204] = "Salvage Crate",
	[455269] = "Notes On The Machine Speakers: Fragment I",
	[455274] = "Notes On The Machine Speakers: Fragment II",
	[455275] = "Notes On The Machine Speakers: Fragment III",
	[455276] = "Notes On The Machine Speakers: Fragment IV",
	[455277] = "Notes On The Machine Speakers: Fragment V",
	[455278] = "Notes On The Machine Speakers: Fragment VI",
	[455279] = "Vizier's Appreciation",
	[455288] = "Fleshy Grimoire",
	[455310] = "Hear Historic Tales at the Storyteller Stage!",
	[455320] = "Vizier's Appreciation",
	[455321] = "Vizier's Appreciation",
	[455322] = "Vizier's Appreciation",
	[455323] = "Vizier's Appreciation",
	[455324] = "Vizier's Appreciation",
	[455325] = "Vizier's Appreciation",
	[455327] = "Vizier's Appreciation",
	[455328] = "Vizier's Appreciation",
	[455329] = "Vizier's Appreciation",
	[455330] = "Vizier's Appreciation",
	[455331] = "Vizier's Appreciation",
	[455435] = "Aspirant's Tribute",
	[455436] = "Aspirant's Tribute",
	[455437] = "Aspirant's Tribute",
	[455439] = "Aspirant's Tribute",
	[455440] = "Aspirant's Tribute",
	[455441] = "Aspirant's Tribute",
	[455442] = "Aspirant's Tribute",
	[455443] = "Aspirant's Tribute",
	[455444] = "Aspirant's Tribute",
	[455445] = "Aspirant's Tribute",
	[455446] = "Aspirant's Tribute",
	[455482] = "|cff1EFF00Sturdy Chest",
	[455484] = "|cff1EFF00Sturdy Chest",
	[455485] = "|cff1EFF00Sturdy Chest",
	[455486] = "|cff1EFF00Sturdy Chest",
	[455487] = "|cff1EFF00Sturdy Chest",
	[455488] = "|cff1EFF00Sturdy Chest",
	[455489] = "|cff1EFF00Sturdy Chest",
	[455490] = "|cff1EFF00Sturdy Chest",
	[455491] = "|cff1EFF00Sturdy Chest",
	[455492] = "|cff1EFF00Sturdy Chest",
	[455493] = "|cff1EFF00Sturdy Chest",
	[455494] = "|cff1EFF00Sturdy Chest",
	[455495] = "|cff1EFF00Sturdy Chest",
	[455496] = "|cff1EFF00Sturdy Chest",
	[455497] = "|cff1EFF00Sturdy Chest",
	[455503] = "|cff1EFF00Sturdy Chest",
	[455504] = "|cff1EFF00Sturdy Chest",
	[455505] = "|cff1EFF00Sturdy Chest",
	[455506] = "|cff1EFF00Sturdy Chest",
	[455507] = "|cff1EFF00Sturdy Chest",
	[455508] = "|cff1EFF00Sturdy Chest",
	[455509] = "|cff1EFF00Sturdy Chest",
	[455510] = "|cff1EFF00Sturdy Chest",
	[455511] = "|cff1EFF00Sturdy Chest",
	[455512] = "|cff1EFF00Sturdy Chest",
	[455513] = "|cff1EFF00Sturdy Chest",
	[455514] = "|cff1EFF00Sturdy Chest",
	[455515] = "|cff1EFF00Sturdy Chest",
	[455516] = "|cff1EFF00Sturdy Chest",
	[455517] = "|cff1EFF00Sturdy Chest",
	[455522] = "|cff1EFF00Sturdy Chest",
	[455523] = "|cff1EFF00Sturdy Chest",
	[455524] = "|cff1EFF00Sturdy Chest",
	[455525] = "|cff1EFF00Sturdy Chest",
	[455526] = "|cff1EFF00Sturdy Chest",
	[455527] = "|cff1EFF00Sturdy Chest",
	[455531] = "|cff1EFF00Sturdy Chest",
	[455532] = "|cff1EFF00Sturdy Chest",
	[455533] = "|cff1EFF00Sturdy Chest",
	[455534] = "|cff1EFF00Sturdy Chest",
	[455685] = "DELVER'S CALL: Dread Pit",
	[455690] = "DELVER'S CALL: Mycomancer Cavern",
	[455694] = "DELVER'S CALL: Skittering Breach",
	[455704] = "DELVER'S CALL: The Sinkhole",
	[455713] = "DELVER'S CALL: Kriegval's Rest",
	[455716] = "DELVER'S CALL: Fungal Folly",
	[455720] = "DELVER'S CALL: Tak-Rethan Abyss",
	[455759] = "Hulking Raptorial Claw",
	[455761] = "Gerald",
	[455768] = "Soggy Celebration Crate",
	[455795] = "Pet Box",
	[455890] = "Waterlogged Refuse",
	[455914] = "Mislaid Curiosity",
	[455938] = "Nerubian's Pincushion",
	[455939] = "Nerubian Quilt",
	[455940] = "Royal Outfitter's Protractor",
	[455941] = "Arathi Rotary Cutter",
	[455942] = "Earthen Stitcher's Snips",
	[455943] = "Runed Earthen Pins",
	[455944] = "Earthen Tape Measure",
	[455945] = "Dornogal Seam Ripper",
	[455946] = "Carapace Shiner",
	[455947] = "Nerubian's Slicking Iron",
	[455948] = "Arathi Craftsman's Spokeshave",
	[455949] = "Arathi Tanning Agent",
	[455950] = "Fungarian's Rich Tannin",
	[455951] = "Artisan's Drawing Knife",
	[455952] = "Earthen Worker's Beams",
	[455953] = "Dornogal Carving Knife",
	[455954] = "Nerubian Mining Cart",
	[455955] = "Heavy Spider Crusher",
	[455956] = "Devout Archaeologist's Excavator",
	[455957] = "Arathi Precision Drill",
	[455958] = "Regenerating Ore",
	[455959] = "Earthen Excavator's Shovel",
	[455960] = "Dornogal Chisel",
	[455961] = "Earthen Miner's Gavel",
	[455962] = "Curved Nerubian Skinning Knife",
	[455963] = "Nerubian Tanning Mallet",
	[455964] = "Arathi Leather Burnisher",
	[455965] = "Arathi Beveler Set",
	[455966] = "Earthen Awl",
	[455967] = "Underground Stropping Compound",
	[455968] = "Dornogal Craftsman's Flat Knife",
	[455969] = "Earthen Lacing Tools",
	[455970] = "Nerubian Bench Blocks",
	[455971] = "Ritual Caster's Crystal",
	[455972] = "Librarian's Magnifiers",
	[455973] = "Arathi Sizing Gauges",
	[455974] = "Jeweler's Delicate Drill",
	[455975] = "Carved Stone File",
	[455976] = "Earthen Gem Pliers",
	[455977] = "Gentle Jewel Hammer",
	[455978] = "Venomancer's Ink Well",
	[455979] = "Nerubian Texts",
	[455980] = "Calligrapher's Chiselled Marker",
	[455981] = "Informant's Fountain Pen",
	[455982] = "Blue Earthen Pigment",
	[455983] = "Runic Scroll",
	[455984] = "Historian's Dip Pen",
	[455985] = "Dornogal Scribe's Quill",
	[455986] = "Tunneler's Shovel",
	[455987] = "Web-Entangled Lotus",
	[455988] = "Arathi Herb Pruner",
	[455989] = "Arathi Garden Trowel",
	[455990] = "Fungarian Slicer's Knife",
	[455991] = "Earthen Digging Fork",
	[455992] = "Dornogal Gardening Scythe",
	[455993] = "Ancient Flower",
	[455994] = "Emptied Venom Canister",
	[455995] = "Puppeted Mechanical Spider",
	[455996] = "Arathi Safety Gloves",
	[455997] = "Holy Firework Dud",
	[455998] = "Earthen Construct Blueprints",
	[455999] = "Inert Mining Bomb",
	[456000] = "Dornogal Spectacles",
	[456001] = "Rock Engineer's Wrench",
	[456002] = "Void Shard",
	[456003] = "Book of Dark Magic",
	[456004] = "Enchanted Arathi Scroll",
	[456005] = "Essence of Holy Fire",
	[456006] = "Animated Enchanting Dust",
	[456007] = "Soot-Coated Orb",
	[456008] = "Silver Dornogal Rod",
	[456009] = "Grinded Earthen Gem",
	[456010] = "Spiderling's Wire Brush",
	[456011] = "Nerubian Smith's Kit",
	[456012] = "Radiant Tongs",
	[456013] = "Holy Flame Forge",
	[456014] = "Earthen Chisels",
	[456015] = "Ringing Hammer Vise",
	[456016] = "Dornogal Hammer",
	[456017] = "Ancient Earthen Anvil",
	[456018] = "Dark Apothecary's Vial",
	[456019] = "Nerubian Mixing Salts",
	[456020] = "Sanctified Mortar and Pestle",
	[456021] = "Chemist's Purified Water",
	[456022] = "Engraved Stirring Rod",
	[456023] = "Reinforced Beaker",
	[456024] = "Metal Dornogal Frame",
	[456025] = "Earthen Iron Powder",
	[456032] = "Ruffled Paper",
	[456036] = "Loose Paper",
	[456038] = "Wet Paper",
	[456039] = "Crumpled Letter",
	[456041] = "Folded Paper",
	[456061] = "Battered Celebration Crate",
	[456208] = "The Catalyst",
	[456581] = "Egg Clutch",
	[456583] = "Lost Shoe",
	[456665] = "Ore Sample",
	[456767] = "Red Hair",
	[456820] = "Strange Torch",
	[456869] = "Kaja'Cola Stash",
	[456927] = "Treatise on Forms: Lords",
	[456928] = "Treatise on Forms: Ascended",
	[457025] = "Pre-Calibrated Goblin Transport Vessel",
	[457062] = "Sky-Captain Lancekat's Curse",
	[457143] = "Kaja'Cola Can",
	[457156] = "Torn Note",
	[457160] = "Torn Note",
	[457161] = "Torn Note",
	[457168] = "Bar Tab Barrel",
	[457170] = "Bar Tab Barrel",
	[457171] = "Bar Tab Barrel",
	[457172] = "Bar Tab Barrel",
	[457173] = "Bar Tab Barrel",
	[457174] = "Bar Tab Barrel",
	[457176] = "Bar Tab Barrel",
	[457180] = "Bar Tab Barrel",
	[457181] = "Interesting Notes",
	[457182] = "Bar Tab Barrel",
	[457183] = "Bar Tab Barrel",
	[457197] = "Mounted Spyglass",
	[457246] = "Fieldhand Stash",
	[457251] = "Old Rotting Crate",
	[457260] = "Misplaced Supplies",
	[457270] = "Surveyor's Box",
	[457271] = "Crabber Supplies",
	[457303] = "Radiant Remnant",
	[459333] = "Jeweled Eye",
	[459368] = "Half-Buried Chest",
	[462417] = "Waterlogged Celebration Crate",
	[463104] = "Nola's Lash Wish",
	[463539] = "Pilfered Earthen Chest",
	[463653] = "Dirt-Caked Celebration Crate",
	[463979] = "Lightspark Sky Academy Gradebook",
	[464213] = "Jumping Spider",
	[464218] = "Summit Kid",
	[464233] = "Bilge Rat Supply Chest",
	[464938] = "Awakened Cache",
	[465161] = "Water-Resistant Receipt of Sale",
	[465183] = "Mysterious Bones",
	[465186] = "Unmarked Grave",
	[465208] = "Crystal Chunk",
	[465234] = "Missing Page from Yennu's Snackbook",
	[465241] = "Awakened Cache",
	[465242] = "Awakened Cache",
	[465243] = "Awakened Cache",
	[465272] = "Empty Kaja'Cola Can",
	[465277] = "Mound of Dirt",
	[465294] = "Antonidas' Introduction to Arcane Magic",
	[465295] = "Medivh's Karazhan Schematics",
	[465300] = "Thalen Songweaver's Notes",
	[466118] = "Unfinished Note",
	[466119] = "Hastily Scrawled Note",
	[466120] = "Water-Resistant Note",
	[466128] = "Peculiar Gem",
	[466393] = "Astral Chest",
	[466400] = "\"Property of Elder Ko'nani\"",
	[466413] = "Encrypted Puzzle Box",
	[466420] = "Rubenstein's Safe",
	[466438] = "Charred Celebration Crate",
	[466479] = "Encrypted Chest",
	[466484] = "Encrypted Chest",
	[466489] = "Encrypted Chest",
	[466495] = "Encrypted Chest",
	[466497] = "Encrypted Chest",
	[466512] = "Crystallized Celebration Crate",
	[466808] = "Chest of Acquisitions",
	[466943] = "Sentry Statue",
	[466960] = "Treasure of the Wardens",
	[466975] = "Enigma Machine",
	[467060] = "Ball of Yarn",
	[467064] = "Quest Journal",
	[467075] = "Darkmoon Fortune Card",
	[467083] = "Darkmoon Fortune Card",
	[467191] = "Encrypted Chest",
	[467293] = "Chew Toy",
	[467305] = "Toy Box",
	[467329] = "Maru's Toy",
	[467334] = "Darkmoon Fortune Card",
	[467336] = "Darkmoon Fortune Card",
	[467337] = "Darkmoon Fortune Card",
	[467338] = "Darkmoon Fortune Card",
	[467339] = "Darkmoon Fortune Card",
	[467342] = "Darkmoon Fortune Card",
	[467351] = "Darkmoon Fortune Card",
	[467403] = "Darkmoon Fortune Card",
	[467489] = "Ghostly Celebration Crate",
	[469327] = "Play Script",
	[469332] = "Prop Sword",
	[469334] = "Mask of the Trickster",
	[469335] = "Conductor's Baton",
	[469568] = "Burnt Feather",
	[469569] = "Plucked Feather",
	[469573] = "Frozen Feather",
	[469574] = "Normal Feather",
	[469985] = "Ice Block",
	[470229] = "Plush Toy",
	[472068] = "Bakar Sketch",
	[473934] = "Property of Cooktholomew",
	[473943] = "Salvageable Scrap",
	[474030] = "Salvageable Scrap",
	[474033] = "Salvageable Scrap",
	[474084] = "Salvageable Scrap",
	[474086] = "Salvageable Scrap",
	[474822] = "Runed Storm Cache",
	[475116] = "Ordinary Pebble",
	[475284] = "Earthen Prototype",
	[475286] = "Overcharged Battery",
	[476815] = "Ancient Treasure Note",
	[477098] = "Bilge Rat Trunk",
	[477139] = "Lost & Found",
	[477248] = "Songs of the Siren",
	[477366] = "Dat-Dat's Book Stash",
	[477605] = "Ancient Treasure Note",
	[477609] = "Ancient Treasure Note",
	[477612] = "Siren Isle Manifest",
	[478090] = "Mildewed Celebration Crate",
	[485669] = "DELVER'S CALL: Fungal Folly",
	[487805] = "DELVER'S CALL: Earthcrawl Mines",
	[487815] = "DELVER'S CALL: The Waterworks",
	[487825] = "Ruffled Pages",
	[487847] = "DELVER'S CALL: Nightfall Sanctum",
	[487851] = "DELVER'S CALL: The Spiral Weave",
	[487855] = "DELVER'S CALL: The Underkeep",
	[493375] = "Rune-Sealed Coffer",
	[494475] = "Rune-Seared Spear",
	[494499] = "Seafarer's Cache",
	[494923] = "Tattered Journal",
	[499127] = "Runemarked Coffer",
	[499466] = "Tattered Kul Tiran Journal",
	[499551] = "Blacksteel Cannonballs",
	[499620] = "Runed Storm Cache",
	[499862] = "Runed Storm Cache",
	[499863] = "Runed Storm Cache",
	[500407] = "Runed Storm Cache",
	[500682] = "Seafarer's Cache",
	[500683] = "Seafarer's Cache",
	[500684] = "Seafarer's Cache",
	[500685] = "Seafarer's Cache",
	[500686] = "Seafarer's Cache",
	[500688] = "Seafarer's Cache",
	[500689] = "Seafarer's Cache",
	[500690] = "Seafarer's Cache",
	[500697] = "Well Loved Squeaky Toy",
	[505260] = "Potion of Truth",
	[505476] = "Stone Carver's Scramseax",
	[505503] = "Ashvane Issued Workboots",
	[505504] = "Kul Tiran Lumberer's Hatchet",
	[505505] = "Iron Mining Pick",
	[505506] = "Minnow's Favorite Blade",
	[505510] = "Barnacle-Encrusted Chest",
	[507120] = "Ducky Friend",
	[9000000] = "Wind Sculpted Stone",
	[9000001] = "Ancient Incense Brazier",
	[9000002] = "Ancient Incense Brazier",
	[9000003] = "Ancient Incense Brazier",
	[9000004] = "Ancient Incense Brazier",
	[9000005] = "Aged Marker",
	[9000006] = "Aged Marker",
	[9000007] = "Aged Marker",
	[9000008] = "Aged Marker",
	[9000009] = "Aged Marker",
	[9000010] = "Banner Stand",
	[9999908] = "|cFFFFFFFFStep 1:|r Gather Consumables.",
	[9999909] = "|cFFFFFFFFStep 2:|r Caverns of Consumption",
	[9999910] = "|cFFFFFFFFStep 3:|r Fire Barrier",
	[9999911] = "|cFFFFFFFFStep 4:|r Prismatic Barrier",
	[9999912] = "|cFFFFFFFFStep 5:|r Diligent Watcher",
	[9999913] = "|cFFFFFFFFStep 6:|r Vine Barrier",
	[9999914] = "|cFFFFFFFFStep 7:|r Water Barrier",
	[9999915] = "|cFFFFFFFFStep 8:|r Stone Watcher",
	[9999916] = "|cFFFFFFFFStep 9:|r Ethereal Barrier",
	[9999917] = "|cFFFFFFFFStep 10:|r Strange Stone",
	[9999918] = "|cFFFFFFFFStep 11:|r Metal Gate",
	[9999919] = "|cFFFFFFFFStep 12:|r Wisdom Cube",
	[9999920] = "|cFFFFFFFFStep 13:|r Tarnished Plaque",
	[9999921] = "Placement",
	[9999946] = "Summon Baa'l",
	[13000000] = "|cFFFFFFFFStep 1:|r Purchase Talisman of True Treasure Tracking",
	[13000001] = "|cFFFFFFFFStep 2:|r Equip Talisman",
	[13000002] = "|cFFFFFFFFItem 1:|r Scintillating Murloc Skin Lotion",
	[13000003] = "Glittergill Glitter",
	[13000004] = "|cFFFFFFFFStep 1:|r Seashell",
	[13000005] = "|cFFFFFFFFStep 2:|r Cavity-Free Great Shark Tooth",
	[13000006] = "|cFFFFFFFFStep 3:|r Razoreel Larva",
	[13000007] = "|cFFFFFFFFStep 4:|r Well-Fed Doctor Fish",
	[13000008] = "|cFFFFFFFFStep 5:|r Freshly Molted Crab Skin",
	[13000009] = "|cFFFFFFFFStep 6:|r Glittergill Glitter",
	[13000010] = "Symbiotic Plankton",
	[13000011] = "|cFFFFFFFFStep 1:|r Seashell",
	[13000012] = "|cFFFFFFFFStep 2:|r Giant Giant Toenail Clipping",
	[13000013] = "|cFFFFFFFFStep 3:|r Makrura Eye",
	[13000014] = "|cFFFFFFFFStep 4:|r Accidentally-Severed Seahorse Fin",
	[13000015] = "|cFFFFFFFFStep 5:|r Shiny Sea Serpent Scale",
	[13000016] = "|cFFFFFFFFStep 6:|r Symbiotic Plankton",
	[13000017] = "Scintillating Murloc Skin Lotion",
	[13000018] = "|cFFFFFFFFItem 2:|r Potent Gastropod Gloop",
	[13000019] = "|cFFFFFFFFStep 1:|r Seashell",
	[13000020] = "|cFFFFFFFFStep 2:|r Vantus Black Squid Ink",
	[13000021] = "|cFFFFFFFFStep 3:|r Super Slick Eel Slime",
	[13000022] = "|cFFFFFFFFStep 4:|r Rock-Encrusted Whelk Shell",
	[13000023] = "|cFFFFFFFFStep 5:|r Potent Gastropod Gloop",
	[13000024] = "|cFFFFFFFFItem 3:|r Captured Cavitation Bubble",
	[13000025] = "|cFFFFFFFFStep 1:|r Seashell",
	[13000026] = "|cFFFFFFFFStep 2:|r Very Pretty Coral",
	[13000027] = "|cFFFFFFFFStep 3:|r Iridescent Shimmerray Skin",
	[13000028] = "|cFFFFFFFFStep 4:|r Luxurous Luxscale Scale",
	[13000029] = "|cFFFFFFFFStep 5:|r Captured Cavitation Bubble",
	[13000030] = "Purchase Red Crystal Monocle",
	[13000031] = "Red Crystal Monocle",
	[13000032] = "|cFFFFFFFFStep 3:|r Pick a Monocle (Or Don't!)",
	[13000033] = "|cFFFFFFFFStep 4:|r Suramar Beams",
	[13000034] = "|cFFFFFFFFStep 5:|r Cat Code",
	[13000035] = "|cFFFFFFFFStep 6:|r Jumping Puzzle",
	[13000036] = "|cFFFFFFFFStep 7:|r Arcane Lava",
	[13000037] = "|cFFFFFFFFStep 8:|r Hivemind",
	[13000040] = "|cFFFFFFFFStep 1:|r Phoenix Ash Talisman",
	[13000041] = "|cFFFFFFFFStep 1A:|r Glittering Phoenix Ember",
	[13000042] = "|cFFFFFFFFStep 1B:|r Inert Phoenix Ash",
	[13000043] = "|cFFFFFFFFStep 1C:|r Sacred Phoenix Ash",
	[13000044] = "|cFFFFFFFFStep 2:|r Ash Feather",
	[13000045] = "|cFFFFFFFFStep 3:|r Smoldering Phoenix Ash",
	[1278968766] = "Rune",
	[1278968767] = "Rune",
	[1278968768] = "Rune",
}; _.ObjectNames = ObjectNames;
local ObjectIcons = {
	[31] = 464140,
	[34] = 132798,
	[55] = 133730,
	[56] = 133730,
	[61] = 236399,
	[256] = 134939,
	[259] = 132798,
	[261] = 132762,
	[270] = 133201,
	[711] = 134939,
	[1593] = 1126431,
	[1627] = 132761,
	[1738] = 134939,
	[1739] = 134939,
	[1740] = 134939,
	[1763] = 134939,
	[1765] = 132763,
	[2008] = 134166,
	[2059] = 133728,
	[2076] = 133778,
	[2083] = 1500889,
	[2553] = 134939,
	[2555] = 134939,
	[2688] = 1003587,
	[2701] = 1003587,
	[2702] = 1003587,
	[2713] = 134939,
	[2908] = 132763,
	[3238] = 132623,
	[3972] = 134939,
	[4141] = 134063,
	[5620] = 134095,
	[6751] = 134220,
	[6752] = 960672,
	[7510] = 458173,
	[10076] = 134715,
	[15084] = 133867,
	[15085] = 133867,
	[17182] = 133867,
	[17183] = 133867,
	[17184] = 133867,
	[19023] = 1505961,
	[19024] = 132867,
	[20805] = 134943,
	[20985] = 463521,
	[20992] = 134950,
	[21042] = 134951,
	[21581] = 133740,
	[21582] = 133734,
	[21583] = 133741,
	[35251] = 1001977,
	[112948] = 1041430,
	[113768] = _.asset("holiday_noblegarden"),
	[113791] = 135805,
	[131474] = 574567,
	[138492] = 1003587,
	[141979] = 985959,
	[142071] = 132833,
	[142122] = 134939,
	[142151] = 132622,
	[142184] = 132595,
	[142195] = 237386,
	[142343] = 134375,
	[142345] = 134393,
	[142475] = 134394,
	[142476] = 134390,
	[142487] = 133867,
	[142696] = 134392,
	[142702] = 134799,
	[142958] = 133734,
	[143980] = 134943,
	[144064] = 135228,
	[148502] = 1505961,
	[148504] = 135349,
	[150075] = 134939,
	[157936] = 133849,
	[160836] = 132596,
	[160845] = 132597,
	[161495] = 132595,
	[161505] = 132594,
	[161521] = _.asset("icon_petfamily_mechanical"),
	[161526] = 132594,
	[164659] = 134105,
	[164661] = 134136,
	[164778] = 134133,
	[164780] = 134130,
	[164820] = 236444,
	[164867] = 134939,
	[164868] = 134939,
	[164869] = 133748,
	[164955] = 134087,
	[164956] = 134087,
	[164957] = 134087,
	[164958] = 134001,
	[165554] = 134085,
	[169243] = 985959,
	[173232] = 1500877,
	[174682] = 134939,
	[175226] = 133719,
	[175227] = 133719,
	[175230] = 133719,
	[175233] = 133719,
	[175245] = 134337,
	[175320] = 134939,
	[175382] = 133276,
	[175385] = 134419,
	[175524] = 134396,
	[175564] = 134804,
	[175724] = 133737,
	[175725] = 133740,
	[175726] = 133741,
	[175727] = 133734,
	[175729] = 133734,
	[175730] = 133734,
	[175731] = 133740,
	[175732] = 133741,
	[175733] = 133742,
	[175734] = 133734,
	[175735] = 133737,
	[175736] = 133740,
	[175737] = 133741,
	[175738] = 133742,
	[175739] = 133741,
	[175740] = 133734,
	[175741] = 133737,
	[175742] = 133741,
	[175745] = 133740,
	[175746] = 133740,
	[175747] = 133742,
	[175748] = 133737,
	[175749] = 133734,
	[175750] = 133741,
	[175751] = 133742,
	[175752] = 133734,
	[175753] = 133740,
	[175754] = 133737,
	[175756] = 133737,
	[175757] = 133734,
	[175758] = 133741,
	[175759] = 133737,
	[175760] = 133742,
	[175761] = 133734,
	[175762] = 133741,
	[175763] = 133741,
	[175854] = 133734,
	[175855] = 133740,
	[175856] = 133742,
	[175894] = 134144,
	[175926] = 133739,
	[176091] = 133778,
	[176115] = 134060,
	[176190] = 133724,
	[176191] = 133724,
	[176192] = 133740,
	[176196] = 133724,
	[176197] = 133724,
	[176198] = 133724,
	[176582] = 133900,
	[176631] = 133736,
	[177491] = 132620,
	[177544] = 132594,
	[177787] = 132594,
	[177904] = 132196,
	[177964] = 134462,
	[178609] = 132387,
	[179485] = 461122,
	[179501] = 132761,
	[179552] = 134939,
	[179559] = 132884,
	[179562] = 135279,
	[179564] = 985959,
	[179697] = 132595,
	[179827] = 134939,
	[179832] = 133601,
	[180327] = 134711,
	[180366] = 132932,
	[180368] = 134462,
	[180369] = 133891,
	[180448] = 134939,
	[180456] = 134455,
	[180461] = 134462,
	[180466] = 134459,
	[180503] = 133741,
	[180526] = 132594,
	[180633] = 132787,
	[180642] = 132763,
	[180652] = 133849,
	[180662] = 132594,
	[180665] = 134457,
	[180666] = 134457,
	[180667] = 134457,
	[180685] = 132594,
	[180690] = 132595,
	[180691] = 132594,
	[180717] = 133575,
	[180743] = 133202,
	[180746] = 133202,
	[180747] = 133202,
	[180748] = 133202,
	[180751] = 132594,
	[180793] = 133202,
	[180794] = 133738,
	[180796] = 135849,
	[180901] = 132594,
	[180918] = 134939,
	[181011] = 133743,
	[181074] = 132597,
	[181083] = 132597,
	[181147] = 134939,
	[181150] = 133743,
	[181153] = 134939,
	[181638] = 134939,
	[181643] = 133728,
	[181649] = 133743,
	[181698] = 134078,
	[181748] = 132787,
	[181889] = 134939,
	[182032] = 133741,
	[182115] = 134939,
	[182165] = 134939,
	[182549] = 134939,
	[182587] = 134939,
	[182588] = 134939,
	[182947] = 460694,
	[182952] = 132761,
	[182953] = 133920,
	[182954] = 133928,
	[182956] = 133922,
	[182957] = 133900,
	[182958] = 133927,
	[182959] = 133909,
	[183770] = 1033908,
	[183811] = 134939,
	[184418] = 134335,
	[184465] = 133018,
	[184660] = 134939,
	[184825] = 133737,
	[184945] = 134939,
	[184946] = 134939,
	[185035] = 134939,
	[185126] = 133867,
	[185165] = 1135365,
	[185522] = 134885,
	[186426] = 134939,
	[186585] = 1500882,
	[186881] = 134269,
	[186887] = 133661,
	[187236] = 133202,
	[187273] = 1508511,
	[187565] = 441145,
	[187851] = 133751,
	[187905] = 651736,
	[188085] = 134058,
	[188365] = 133250,
	[188418] = 134939,
	[188649] = 134939,
	[189311] = 133738,
	[189989] = 134518,
	[189990] = 134518,
	[190020] = 134939,
	[190535] = 1690118,
	[190657] = 1690118,
	[190768] = 1542856,
	[190917] = 133465,
	[190936] = 1385153,
	[191728] = 134939,
	[191760] = 1045113,
	[191761] = 1045113,
	[191766] = 2178528,
	[192046] = 237313,
	[192048] = 237305,
	[192049] = 237318,
	[192050] = 237302,
	[192051] = 237300,
	[192052] = 237310,
	[192053] = 237311,
	[192054] = 237321,
	[192057] = 237323,
	[192059] = 237320,
	[192060] = 136241,
	[192071] = 136241,
	[192072] = 132764,
	[192078] = 134229,
	[192079] = 135127,
	[192080] = 133091,
	[192524] = 342402,
	[192708] = 133735,
	[192709] = 133741,
	[192710] = 133740,
	[192711] = 133736,
	[192713] = 133736,
	[192818] = 134531,
	[192827] = 134182,
	[192828] = 134010,
	[192833] = 1542856,
	[192865] = 133741,
	[192866] = 133733,
	[192867] = 133736,
	[193195] = 1379177,
	[193400] = 237295,
	[193402] = 132764,
	[194092] = 134514,
	[194105] = 876476,
	[194122] = 876476,
	[194213] = 134195,
	[194238] = 135366,
	[194378] = 237446,
	[194387] = 237446,
	[194388] = 237446,
	[194389] = 237446,
	[194390] = 237446,
	[194391] = 237446,
	[194479] = 133913,
	[194618] = 135128,
	[194622] = 135128,
	[194714] = 1379178,
	[194908] = 135128,
	[194909] = 135128,
	[195134] = 133717,
	[195431] = 133015,
	[195433] = 134456,
	[195435] = 1001977,
	[195438] = 454051,
	[195445] = 134456,
	[195497] = 1379180,
	[195517] = 458241,
	[195600] = 514016,
	[195642] = 839977,
	[195676] = 133015,
	[196393] = 1029027,
	[196832] = 528334,
	[196833] = 528334,
	[201578] = 237162,
	[201873] = 374217,
	[202080] = 294479,
	[202081] = 294479,
	[202082] = 294479,
	[202083] = 294479,
	[202135] = 236399,
	[202180] = 374221,
	[202407] = 1542856,
	[202474] = 1542856,
	[202598] = 133713,
	[202613] = 237290,
	[202697] = 134336,
	[202701] = 975745,
	[202706] = 133782,
	[202712] = 133737,
	[202871] = 132766,
	[203128] = 135446,
	[203134] = 646673,
	[203140] = 135582,
	[203186] = 442743,
	[203207] = 133737,
	[203301] = 135127,
	[203305] = 305294,
	[203733] = 134939,
	[203734] = 134939,
	[203755] = 237162,
	[204050] = 1035002,
	[204344] = 134939,
	[204351] = 332402,
	[204406] = 463534,
	[204450] = 1064187,
	[204578] = 645193,
	[204817] = 133849,
	[204824] = 133849,
	[204825] = 133849,
	[205143] = 134246,
	[205207] = 133740,
	[205258] = 133823,
	[205332] = 134939,
	[205350] = 133014,
	[205476] = 354719,
	[205875] = 135815,
	[206109] = 1863940,
	[206111] = 1863940,
	[206116] = 1863940,
	[206294] = 1863940,
	[206335] = 134455,
	[206336] = 134455,
	[206374] = 1604165,
	[206569] = 133254,
	[206585] = 971076,
	[206944] = 134435,
	[207104] = 134519,
	[207179] = 133778,
	[207279] = 1863940,
	[207303] = 134939,
	[207304] = 134939,
	[207320] = 1863940,
	[207321] = 1863940,
	[207322] = 1863940,
	[207323] = 1863940,
	[207324] = 1863940,
	[207325] = 1863940,
	[207359] = 516862,
	[207496] = 985959,
	[208316] = 1863940,
	[208317] = 1863940,
	[208321] = 237272,
	[208365] = 133849,
	[208535] = 1526614,
	[209076] = 132761,
	[209095] = 132761,
	[209270] = 1505961,
	[209620] = 1001980,
	[211424] = 134939,
	[211754] = 133743,
	[213363] = 135681,
	[213364] = 134710,
	[213651] = 1542860,
	[213653] = 135128,
	[213741] = 135144,
	[213742] = 133526,
	[213749] = 579539,
	[213751] = 1542843,
	[213765] = 134459,
	[213768] = 135128,
	[213842] = 134344,
	[213960] = 135432,
	[213962] = 615300,
	[213964] = 615301,
	[213967] = 615302,
	[213968] = 615303,
	[213969] = 615361,
	[213972] = 615300,
	[214439] = 132788,
	[214871] = 646675,
	[214903] = 133748,
	[220807] = 132784,
	[220820] = 1505961,
	[220821] = 1505961,
	[221376] = 134459,
	[221413] = 441147,
	[222684] = 133848,
	[222685] = 236998,
	[222796] = 136111,
	[223537] = 135265,
	[223538] = 135861,
	[223539] = 135853,
	[224228] = 1385153,
	[224623] = 236997,
	[224686] = 132847,
	[224750] = 133646,
	[224754] = 1542860,
	[224755] = 1542853,
	[224780] = 135425,
	[224784] = 1518642,
	[224785] = 1542854,
	[226468] = 442737,
	[226469] = 442737,
	[226831] = 1001977,
	[226854] = 133719,
	[226862] = 959845,
	[226955] = 134227,
	[226956] = 237269,
	[226967] = 463514,
	[226976] = 464774,
	[227654] = 135128,
	[227793] = 1518643,
	[227859] = 917922,
	[227868] = 1500963,
	[227954] = 134434,
	[227956] = 1529273,
	[227996] = 237430,
	[228012] = 629515,
	[228015] = 1542860,
	[228018] = 1125255,
	[228026] = 1003595,
	[228570] = 985959,
	[229330] = 133352,
	[229333] = 132576,
	[229354] = 237281,
	[229367] = 970830,
	[229640] = 930452,
	[230252] = 134124,
	[230425] = 134298,
	[230544] = 442737,
	[230643] = 132834,
	[231069] = 924154,
	[232214] = 1542856,
	[232215] = 1542856,
	[232216] = 1542856,
	[232217] = 1542856,
	[232218] = 1542856,
	[232219] = 1542856,
	[232237] = 1542856,
	[232406] = 133633,
	[232546] = 1542856,
	[232547] = 1542856,
	[232549] = 1542856,
	[232550] = 1542856,
	[232586] = 135427,
	[232587] = 1518635,
	[232588] = 134514,
	[232590] = 132779,
	[232591] = 134927,
	[232596] = 132409,
	[232621] = 463280,
	[233137] = 1125255,
	[233206] = 132761,
	[233218] = 133633,
	[233263] = 442737,
	[233457] = 135144,
	[233511] = 133633,
	[233532] = 454058,
	[233560] = 132781,
	[233561] = 132409,
	[233593] = 236946,
	[233598] = 135033,
	[233611] = 133040,
	[233613] = 134994,
	[233645] = 669453,
	[233650] = 133481,
	[233651] = 648537,
	[233792] = 135236,
	[234054] = 134344,
	[234147] = 237271,
	[234154] = 454060,
	[234155] = 1002596,
	[234446] = 1002596,
	[234449] = 1002596,
	[234451] = 1002596,
	[234454] = 1002596,
	[234455] = 1002596,
	[234456] = 1125255,
	[234618] = 132372,
	[234703] = 134746,
	[234704] = 134746,
	[234705] = 134746,
	[234734] = 134746,
	[234735] = 134746,
	[234736] = 134746,
	[234740] = 134228,
	[235091] = 133345,
	[235097] = 460694,
	[235104] = 1002596,
	[235105] = 1002596,
	[235135] = 1002596,
	[235143] = 135128,
	[235172] = 237271,
	[235289] = 1059122,
	[235313] = 984831,
	[235859] = 133639,
	[235860] = 1542858,
	[236092] = 133633,
	[236141] = 133633,
	[236147] = 133041,
	[236149] = 348523,
	[236158] = 920736,
	[236178] = 1029580,
	[236715] = 1516566,
	[237511] = 463282,
	[239143] = 132815,
	[239171] = 132815,
	[239828] = 607513,
	[239901] = 237000,
	[239925] = 442737,
	[239926] = 442737,
	[240003] = 134131,
	[240289] = 132416,
	[240577] = 916552,
	[240580] = 1137541,
	[240616] = 133647,
	[240617] = 133642,
	[240623] = 1041430,
	[240624] = 841541,
	[240625] = 1769068,
	[240855] = 133736,
	[241128] = 1542847,
	[241434] = 135128,
	[241450] = 1135365,
	[241521] = 133942,
	[241522] = 876365,
	[241533] = 135326,
	[241563] = 237275,
	[241565] = 134051,
	[241566] = 133718,
	[241599] = 645344,
	[241600] = 1036487,
	[241601] = 133633,
	[241605] = 132783,
	[241656] = 1542847,
	[241664] = 463555,
	[241671] = 132873,
	[241674] = 1325308,
	[241692] = 531359,
	[241713] = 134127,
	[241726] = 1394960,
	[241742] = 460694,
	[241743] = 1394961,
	[241745] = 348526,
	[241760] = 801017,
	[241835] = 252179,
	[241841] = 134344,
	[241847] = 134955,
	[241848] = 134923,
	[243911] = 132387,
	[244473] = 134344,
	[244678] = 1505961,
	[244689] = 308482,
	[244691] = 308482,
	[244692] = 308482,
	[244694] = 308482,
	[244698] = 308482,
	[244699] = 308482,
	[244700] = 308482,
	[244701] = 308482,
	[244965] = 1001980,
	[245216] = 1505961,
	[245286] = 454045,
	[245316] = 308482,
	[245328] = 1500882,
	[245345] = 308482,
	[245479] = 132594,
	[245688] = 133748,
	[245793] = 953644,
	[245996] = 308482,
	[246147] = 308482,
	[246249] = 308482,
	[246269] = 308482,
	[246309] = 308482,
	[246353] = 308482,
	[246438] = 1405804,
	[246555] = 308482,
	[246556] = 308482,
	[246557] = 308482,
	[246558] = 308482,
	[246559] = 308482,
	[246560] = 308482,
	[246561] = 308482,
	[246562] = 1001980,
	[247694] = 454060,
	[247797] = 1506461,
	[248534] = 629525,
	[248854] = 644388,
	[250383] = 1416160,
	[251032] = 442732,
	[251168] = 458245,
	[251416] = 1466166,
	[251564] = 1505961,
	[251991] = 880012,
	[252107] = 1405806,
	[252267] = 915852,
	[252269] = 348519,
	[252270] = 132762,
	[252272] = 850065,
	[252273] = 135426,
	[252277] = 132819,
	[252279] = 1529351,
	[252282] = 134245,
	[252284] = 133710,
	[252289] = 134380,
	[252412] = 133852,
	[252434] = 134336,
	[252557] = 134336,
	[252558] = 134336,
	[252559] = 134336,
	[252560] = 134336,
	[252561] = 134336,
	[252562] = 134336,
	[252563] = 134336,
	[252564] = 134336,
	[252565] = 134336,
	[252815] = 1405806,
	[253280] = 961618,
	[254007] = 236304,
	[255344] = 961621,
	[257999] = 1392955,
	[258978] = 1499566,
	[258980] = 133738,
	[266851] = 133836,
	[269830] = 458238,
	[270855] = 1500878,
	[270917] = 354435,
	[271706] = 134939,
	[271849] = 1542858,
	[271850] = 1542858,
	[272039] = 1500878,
	[272046] = 651538,
	[272061] = 1500878,
	[272163] = 237272,
	[272165] = 1500878,
	[272172] = 1500878,
	[272179] = 134939,
	[272181] = 1500878,
	[272220] = 1500878,
	[272270] = 458238,
	[272422] = 133737,
	[272455] = 1542858,
	[272456] = 1542858,
	[272487] = 1029747,
	[272768] = 134567,
	[272770] = 1542858,
	[272771] = 1542858,
	[272780] = 961620,
	[273222] = 1542858,
	[273301] = 1542858,
	[273407] = 1542858,
	[273412] = 1542858,
	[273414] = 1542858,
	[273415] = 1542858,
	[273439] = 1542858,
	[273519] = 1542858,
	[273521] = 1542858,
	[273523] = 1542858,
	[273524] = 1542858,
	[273527] = 1542858,
	[273528] = 1542858,
	[273533] = 1542858,
	[273535] = 1542858,
	[273538] = 1542858,
	[273814] = 1060569,
	[276187] = 132594,
	[276223] = 1542858,
	[276224] = 1542858,
	[276225] = 1542858,
	[276226] = 1542858,
	[276227] = 1542858,
	[276228] = 1542858,
	[276229] = 1542858,
	[276230] = 1542858,
	[276251] = 1506456,
	[276488] = 1373903,
	[276489] = 1542858,
	[276490] = 1542858,
	[276491] = 1542858,
	[276513] = 350868,
	[276515] = 132932,
	[277204] = 1542858,
	[277205] = 1542858,
	[277206] = 1542858,
	[277207] = 1542858,
	[277208] = 1542858,
	[277327] = 1542858,
	[277333] = 1542845,
	[277340] = 1542858,
	[277342] = 1542858,
	[277343] = 1542858,
	[277344] = 1542858,
	[277346] = 1542858,
	[277373] = 134186,
	[277459] = 973904,
	[277561] = 1001977,
	[277897] = 986484,
	[278313] = 1505949,
	[278368] = 134331,
	[278447] = 644382,
	[278669] = 133740,
	[278675] = 458236,
	[279042] = 1001977,
	[279609] = 1001977,
	[279750] = 1001977,
	[280619] = 1001977,
	[280727] = 1500881,
	[280815] = 1500878,
	[280836] = 1500878,
	[280837] = 1500878,
	[280838] = 1500878,
	[280842] = 1500878,
	[280843] = 1500878,
	[280844] = 1500878,
	[280845] = 1500878,
	[281092] = 1001977,
	[281397] = 1001977,
	[281494] = 1001977,
	[281583] = 237193,
	[281639] = 1397648,
	[281646] = 134773,
	[281655] = 1001977,
	[281673] = 133741,
	[281898] = 1001977,
	[282153] = 1001977,
	[282457] = 310733,
	[282478] = 132763,
	[282498] = 133942,
	[282666] = 134514,
	[284426] = 134709,
	[284448] = 1001977,
	[284455] = 1001977,
	[287185] = 134939,
	[287189] = 134331,
	[287228] = 134939,
	[287229] = 134331,
	[287327] = 134939,
	[287440] = 134331,
	[287441] = 134331,
	[287442] = 134331,
	[288157] = 1500881,
	[288622] = 134939,
	[289365] = 134939,
	[289647] = 1001977,
	[290419] = 134939,
	[290537] = 1500881,
	[290725] = 1001977,
	[290765] = 961622,
	[290993] = 1542856,
	[291143] = 134520,
	[291233] = 459041,
	[291238] = 1785788,
	[291241] = 134187,
	[291291] = 134939,
	[292523] = 134939,
	[292812] = 959805,
	[292823] = 960694,
	[292825] = 134439,
	[293349] = 1001977,
	[293350] = 1001977,
	[293568] = 134939,
	[293837] = 135242,
	[293838] = 135242,
	[293839] = 135242,
	[293840] = 135242,
	[293841] = 135242,
	[293842] = 135242,
	[293843] = 135242,
	[293844] = 135242,
	[293845] = 135242,
	[293846] = 135242,
	[293849] = 1505925,
	[293852] = 1001977,
	[293880] = 1001977,
	[293881] = 1001977,
	[293884] = 1001977,
	[293962] = 1001977,
	[293964] = 1001977,
	[293965] = 1001977,
	[294096] = 897131,
	[294097] = 656682,
	[294098] = 2399247,
	[294099] = 133718,
	[294100] = 2061718,
	[294101] = 132806,
	[294102] = 135236,
	[294103] = 134200,
	[294104] = 252129,
	[294105] = 133741,
	[294106] = 533422,
	[294107] = 135435,
	[294108] = 1068933,
	[294109] = 133975,
	[294110] = 1001620,
	[294111] = 133833,
	[294112] = 960678,
	[294113] = 348550,
	[294114] = 134458,
	[294115] = 135434,
	[294173] = 1001977,
	[294174] = 1001977,
	[294312] = 1505952,
	[294314] = 1505949,
	[294315] = 1505955,
	[294335] = 132098,
	[294703] = 132596,
	[297825] = 1001977,
	[297828] = 1001977,
	[297878] = 1001977,
	[297879] = 1001977,
	[297880] = 1001977,
	[297881] = 1001977,
	[297891] = 1001977,
	[297892] = 1001977,
	[297893] = 1001977,
	[297905] = 1500866,
	[297906] = 1500866,
	[297933] = 1500866,
	[297934] = 1500866,
	[298920] = 1001977,
	[298921] = 134424,
	[298963] = 134424,
	[298965] = 134424,
	[299073] = 134424,
	[303016] = 135242,
	[303017] = 135242,
	[303018] = 135242,
	[307265] = 134939,
	[307277] = 132798,
	[307307] = 132622,
	[307325] = 134939,
	[307330] = 132761,
	[307748] = 133461,
	[311218] = 1129654,
	[311902] = 1405815,
	[311903] = 1405815,
	[322533] = 132774,
	[324407] = 1357816,
	[325659] = 986485,
	[325660] = 986485,
	[325661] = 986485,
	[325662] = 986485,
	[325663] = 986485,
	[325664] = 986485,
	[325665] = 986485,
	[325666] = 986485,
	[325667] = 986485,
	[325668] = 986485,
	[326027] = 2915722,
	[326394] = 1542845,
	[326395] = 1542844,
	[326396] = 1542844,
	[326397] = 1542844,
	[326398] = 1542844,
	[326399] = 1542844,
	[326400] = 1542844,
	[326401] = 1542845,
	[326402] = 1542845,
	[326403] = 1542845,
	[326404] = 1542845,
	[326405] = 1542845,
	[326406] = 1542845,
	[326407] = 1542845,
	[326408] = 1542845,
	[326409] = 1542845,
	[326410] = 1542845,
	[326411] = 1542845,
	[326412] = 1542845,
	[326413] = 1542845,
	[326414] = 1542845,
	[326415] = 1542845,
	[326416] = 1542845,
	[326417] = 1542845,
	[326418] = 1542845,
	[326419] = 1542845,
	[327230] = 3066348,
	[327407] = 1542845,
	[327669] = 669468,
	[328343] = 134063,
	[328413] = 136232,
	[329783] = 1542844,
	[329918] = 1542845,
	[329919] = 1542845,
	[330168] = 669468,
	[330169] = 134063,
	[330170] = 136232,
	[330183] = 986485,
	[332220] = 1542844,
	[332568] = 454045,
	[332569] = 454045,
	[332570] = 454045,
	[332571] = 454045,
	[332572] = 454045,
	[332573] = 454045,
	[332574] = 454045,
	[332575] = 454045,
	[332576] = 454045,
	[339770] = 1542845,
	[343611] = 1500908,
	[350978] = 1394946,
	[353484] = 3528423,
	[357758] = 252179,
	[375368] = 4216936,
	[382621] = 4622448,
	[9999908] = 237381,
	[9999909] = 236854,
	[9999910] = 134748,
	[9999911] = 134753,
	[9999912] = 134863,
	[9999913] = 237281,
	[9999914] = 132844,
	[9999915] = 132790,
	[9999916] = 132798,
	[9999917] = 252272,
	[9999918] = 134718,
	[9999919] = 252270,
	[9999920] = 134937,
	[9999946] = 631719,
	[13000000] = 133299,
	[13000001] = 133299,
	[13000002] = 603530,
	[13000003] = 1387618,
	[13000004] = 1498832,
	[13000005] = 1518092,
	[13000006] = 970810,
	[13000007] = 970818,
	[13000008] = 132186,
	[13000009] = 1387618,
	[13000010] = 237147,
	[13000011] = 1498832,
	[13000012] = 1518079,
	[13000013] = 970832,
	[13000014] = 1547462,
	[13000015] = 1526599,
	[13000016] = 237147,
	[13000017] = 603530,
	[13000018] = 237150,
	[13000019] = 1498832,
	[13000020] = 134845,
	[13000021] = 237149,
	[13000022] = 442735,
	[13000023] = 237150,
	[13000024] = 462651,
	[13000025] = 1498832,
	[13000026] = 458176,
	[13000027] = 1526629,
	[13000028] = 1526615,
	[13000029] = 462651,
	[13000030] = 133146,
	[13000031] = 133146,
	[13000032] = 133146,
	[13000033] = 3528282,
	[13000034] = 656576,
	[13000035] = 1041234,
	[13000036] = 1041230,
	[13000037] = 2266815,
	[13000040] = 2125665,
	[13000041] = 514016,
	[13000042] = 133849,
	[13000043] = 1003597,
	[13000044] = 2103819,
	[13000045] = 443368,
}; _.ObjectIcons = ObjectIcons;
local ObjectModels = {
	[31] = 189908,
	[33] = 196979,
	[34] = 189821,
	[35] = 198238,
	[36] = 199567,
	[47] = 199421,
	[55] = 198343,
	[56] = 198343,
	[59] = 189528,
	[60] = 199426,
	[61] = 189541,
	[76] = 199180,
	[256] = 199421,
	[257] = 198280,
	[259] = 199563,
	[261] = 198168,
	[269] = 199563,
	[270] = 199563,
	[287] = 198056,
	[288] = 196979,
	[711] = 199421,
	[1557] = 198598,
	[1561] = 198168,
	[1585] = 197464,
	[1586] = 199634,
	[1593] = 190104,
	[1599] = 189528,
	[1609] = 189709,
	[1610] = 219531,
	[1627] = 198168,
	[1728] = 198435,
	[1738] = 198451,
	[1739] = 198453,
	[1740] = 198451,
	[1763] = 199424,
	[1765] = 196979,
	[2008] = 199428,
	[2059] = 197330,
	[2076] = 198100,
	[2083] = 198455,
	[2289] = 190677,
	[2553] = 198453,
	[2554] = 198453,
	[2555] = 198453,
	[2560] = 198061,
	[2652] = 197330,
	[2656] = 198453,
	[2688] = 199976,
	[2701] = 202445,
	[2702] = 198951,
	[2713] = 199428,
	[2734] = 196979,
	[2744] = 196998,
	[2868] = 198457,
	[2875] = 197330,
	[2908] = 198167,
	[2933] = 199975,
	[3076] = 198457,
	[3238] = 198006,
	[3239] = 196982,
	[3643] = 198238,
	[3972] = 199424,
	[4141] = 197760,
	[5620] = 198947,
	[6751] = 190381,
	[6752] = 190380,
	[7510] = 189772,
	[10076] = 201115,
	[12666] = 198025,
	[15084] = 201020,
	[15085] = 201020,
	[17182] = 197760,
	[17183] = 197760,
	[17184] = 197760,
	[19023] = 305393,
	[19024] = 198951,
	[19595] = 198780,
	[19599] = 198951,
	[19861] = 198036,
	[20805] = 198452,
	[20985] = 204113,
	[20992] = 189676,
	[21015] = 202786,
	[21016] = 202786,
	[21042] = 198660,
	[21581] = 200911,
	[21582] = 200913,
	[21583] = 200912,
	[28604] = 200960,
	[32569] = 196976,
	[35251] = 196979,
	[50961] = 200961,
	[51708] = 201030,
	[61934] = 200925,
	[103821] = 196976,
	[112888] = 198053,
	[112948] = 197617,
	[113757] = 200953,
	[113768] = 199691,
	[113791] = 198067,
	[123329] = 196979,
	[125477] = 199753,
	[131474] = 203420,
	[138492] = 202443,
	[141931] = 201375,
	[141979] = 199748,
	[141980] = 196976,
	[142071] = 197760,
	[142088] = 200640,
	[142122] = 199421,
	[142127] = 200640,
	[142151] = 199737,
	[142179] = 201529,
	[142184] = 196976,
	[142189] = 200259,
	[142195] = 198457,
	[142343] = 201041,
	[142345] = 201022,
	[142475] = 201022,
	[142476] = 201022,
	[142487] = 201020,
	[142696] = 201022,
	[142702] = 198061,
	[142958] = 200913,
	[143980] = 198455,
	[144063] = 201267,
	[144064] = 189528,
	[148498] = 189280,
	[148502] = 305393,
	[148504] = 190634,
	[148512] = 201422,
	[148832] = 190304,
	[148836] = 190363,
	[148838] = 190304,
	[149047] = 198655,
	[149502] = 196976,
	[150075] = 199473,
	[151286] = 198029,
	[152097] = 198067,
	[157936] = 204112,
	[160836] = 196976,
	[160845] = 196976,
	[161495] = 196976,
	[161504] = 200442,
	[161505] = 190677,
	[161521] = 198085,
	[161526] = 197150,
	[164659] = 202750,
	[164661] = 202754,
	[164689] = 203024,
	[164778] = 202749,
	[164780] = 202753,
	[164798] = 199220,
	[164820] = 203051,
	[164867] = 199473,
	[164868] = 199477,
	[164869] = 203016,
	[164885] = 201871,
	[164886] = 201873,
	[164887] = 201877,
	[164888] = 201875,
	[164909] = 190677,
	[164911] = 201058,
	[164953] = 198989,
	[164954] = 219553,
	[164955] = 202759,
	[164956] = 202759,
	[164957] = 202759,
	[164958] = 201087,
	[165554] = 203112,
	[169243] = 200953,
	[171939] = 201873,
	[171942] = 201873,
	[173232] = 203431,
	[173265] = 190617,
	[173284] = 201875,
	[173324] = 201871,
	[173327] = 201877,
	[174594] = 201873,
	[174595] = 201873,
	[174596] = 201873,
	[174597] = 201873,
	[174598] = 201873,
	[174599] = 201877,
	[174600] = 201877,
	[174601] = 201877,
	[174602] = 201877,
	[174603] = 201877,
	[174604] = 201877,
	[174605] = 201875,
	[174606] = 201875,
	[174607] = 201875,
	[174608] = 201871,
	[174682] = 199473,
	[174684] = 201871,
	[174686] = 201875,
	[174708] = 201877,
	[174709] = 201877,
	[174712] = 201873,
	[174713] = 201873,
	[174848] = 203218,
	[175226] = 190548,
	[175227] = 201568,
	[175230] = 201573,
	[175233] = 201568,
	[175245] = 202443,
	[175320] = 199473,
	[175382] = 200953,
	[175385] = 201080,
	[175524] = 201845,
	[175586] = 197394,
	[175587] = 199103,
	[175621] = 200638,
	[175704] = 198452,
	[175724] = 200910,
	[175725] = 200911,
	[175726] = 200912,
	[175727] = 200913,
	[175729] = 200913,
	[175730] = 200913,
	[175731] = 200911,
	[175732] = 200912,
	[175733] = 200914,
	[175734] = 200913,
	[175735] = 200910,
	[175736] = 200911,
	[175737] = 200912,
	[175738] = 200914,
	[175739] = 200912,
	[175740] = 200913,
	[175741] = 200910,
	[175742] = 200912,
	[175745] = 200911,
	[175746] = 200911,
	[175747] = 200914,
	[175748] = 200910,
	[175749] = 200913,
	[175750] = 200912,
	[175751] = 200914,
	[175752] = 200913,
	[175753] = 200911,
	[175754] = 200910,
	[175756] = 200910,
	[175757] = 200913,
	[175758] = 200912,
	[175759] = 200910,
	[175760] = 200914,
	[175761] = 200913,
	[175762] = 200912,
	[175763] = 200912,
	[175854] = 200913,
	[175855] = 200911,
	[175856] = 200914,
	[175886] = 198986,
	[175894] = 191107,
	[175924] = 197626,
	[175925] = 190617,
	[175926] = 198043,
	[175949] = 200640,
	[175950] = 200640,
	[175965] = 219399,
	[175966] = 198130,
	[175970] = 197864,
	[176089] = 198169,
	[176090] = 199671,
	[176091] = 198100,
	[176112] = 196979,
	[176115] = 191094,
	[176116] = 203711,
	[176142] = 203712,
	[176143] = 203713,
	[176190] = 201475,
	[176191] = 201475,
	[176192] = 200902,
	[176196] = 201475,
	[176197] = 201476,
	[176198] = 201476,
	[176249] = 197617,
	[176317] = 196982,
	[176325] = 203431,
	[176361] = 191217,
	[176392] = 191217,
	[176393] = 191217,
	[176582] = 200938,
	[176631] = 202952,
	[177289] = 191217,
	[177490] = 198168,
	[177491] = 201007,
	[177544] = 197617,
	[177667] = 203400,
	[177675] = 189528,
	[177786] = 196987,
	[177787] = 200910,
	[177904] = 191094,
	[177964] = 200024,
	[178609] = 196993,
	[179485] = 199580,
	[179499] = 200377,
	[179501] = 200961,
	[179517] = 200953,
	[179545] = 196976,
	[179547] = 198028,
	[179551] = 200953,
	[179552] = 203431,
	[179559] = 201617,
	[179562] = 189687,
	[179564] = 200953,
	[179697] = 219372,
	[179703] = 199748,
	[179827] = 199473,
	[179832] = 190595,
	[179879] = 203892,
	[179880] = 219250,
	[179913] = 199475,
	[180215] = 219550,
	[180229] = 190688,
	[180366] = 197617,
	[180368] = 200640,
	[180369] = 219404,
	[180448] = 199475,
	[180456] = 202456,
	[180461] = 202457,
	[180466] = 202458,
	[180503] = 198020,
	[180526] = 201029,
	[180570] = 198006,
	[180633] = 201617,
	[180642] = 200963,
	[180652] = 204112,
	[180658] = 219404,
	[180662] = 219411,
	[180665] = 198055,
	[180666] = 198055,
	[180667] = 198044,
	[180682] = 219404,
	[180684] = 219406,
	[180685] = 219411,
	[180690] = 200952,
	[180691] = 200952,
	[180712] = 219407,
	[180717] = 202508,
	[180743] = 199604,
	[180746] = 199605,
	[180747] = 199606,
	[180748] = 199608,
	[180751] = 219411,
	[180793] = 199609,
	[180794] = 198032,
	[180901] = 219411,
	[180918] = 192133,
	[181011] = 191948,
	[181073] = 198100,
	[181074] = 196976,
	[181083] = 196976,
	[181085] = 199636,
	[181147] = 192133,
	[181150] = 198020,
	[181153] = 192133,
	[181366] = 200953,
	[181638] = 192133,
	[181643] = 197330,
	[181649] = 198044,
	[181665] = 197063,
	[181698] = 201618,
	[181748] = 191579,
	[181756] = 198027,
	[181889] = 192468,
	[182030] = 970204,
	[182032] = 198028,
	[182053] = 202097,
	[182115] = 199428,
	[182165] = 199421,
	[182196] = 199744,
	[182197] = 199744,
	[182198] = 199744,
	[182392] = 199475,
	[182393] = 192468,
	[182549] = 198457,
	[182587] = 199473,
	[182588] = 199475,
	[182947] = 200909,
	[182952] = 219411,
	[182953] = 219405,
	[182954] = 219405,
	[182956] = 219405,
	[182957] = 219405,
	[182958] = 219405,
	[182959] = 219405,
	[183284] = 192468,
	[183385] = 202742,
	[183770] = 193552,
	[183811] = 199473,
	[183877] = 192766,
	[184300] = 201097,
	[184465] = 193577,
	[184660] = 191094,
	[184793] = 197063,
	[184825] = 198020,
	[184945] = 199475,
	[184946] = 199476,
	[185035] = 199473,
	[185119] = 199748,
	[185126] = 192011,
	[185165] = 192342,
	[185166] = 191094,
	[185168] = 196989,
	[185302] = 189528,
	[186183] = 2918352,
	[186184] = 2918352,
	[186185] = 2918352,
	[186186] = 2918352,
	[186187] = 2918352,
	[186267] = 199901,
	[186426] = 192468,
	[186585] = 198451,
	[186881] = 198457,
	[186887] = 199901,
	[187236] = 199604,
	[187273] = 202786,
	[187367] = 196998,
	[187565] = 194333,
	[187851] = 189280,
	[187905] = 202490,
	[188085] = 196440,
	[188192] = 200953,
	[188261] = 200908,
	[188364] = 195350,
	[188365] = 192714,
	[188367] = 201022,
	[188418] = 199476,
	[188419] = 194335,
	[188501] = 203096,
	[188502] = 203097,
	[188503] = 203099,
	[188649] = 199424,
	[188667] = 202297,
	[189311] = 200922,
	[189989] = 203234,
	[189990] = 203234,
	[190020] = 199476,
	[190447] = 219382,
	[190453] = 197759,
	[190454] = 197757,
	[190455] = 197758,
	[190535] = 196902,
	[190602] = 196879,
	[190622] = 243885,
	[190623] = 199732,
	[190624] = 199730,
	[190625] = 199726,
	[190643] = 200884,
	[190657] = 196879,
	[190768] = 244222,
	[190917] = 203400,
	[190936] = 191217,
	[191543] = 196982,
	[191728] = 199475,
	[191760] = 243957,
	[191761] = 243957,
	[191766] = 243448,
	[192046] = 219405,
	[192048] = 219405,
	[192049] = 219405,
	[192050] = 219405,
	[192051] = 219405,
	[192052] = 219405,
	[192053] = 219405,
	[192054] = 219405,
	[192057] = 219405,
	[192059] = 219405,
	[192060] = 195374,
	[192071] = 195373,
	[192072] = 195533,
	[192078] = 202496,
	[192079] = 194880,
	[192080] = 243468,
	[192524] = 243887,
	[192708] = 244162,
	[192709] = 244161,
	[192710] = 244163,
	[192711] = 244164,
	[192713] = 244164,
	[192818] = 219476,
	[192827] = 189763,
	[192828] = 219486,
	[192833] = 196979,
	[192865] = 244161,
	[192866] = 244162,
	[192867] = 244164,
	[193195] = 190693,
	[193400] = 243602,
	[193402] = 196989,
	[193426] = 200953,
	[194105] = 197760,
	[194122] = 197760,
	[194213] = 201873,
	[194238] = 244250,
	[194378] = 243448,
	[194387] = 243448,
	[194388] = 243448,
	[194389] = 243448,
	[194390] = 243448,
	[194391] = 243448,
	[194479] = 248068,
	[194555] = 243958,
	[194618] = 198636,
	[194622] = 200609,
	[194714] = 200767,
	[194908] = 198636,
	[194909] = 200609,
	[195134] = 254419,
	[195431] = 197760,
	[195433] = 201275,
	[195435] = 196982,
	[195438] = 198754,
	[195445] = 199976,
	[195497] = 200976,
	[195517] = 198945,
	[195600] = 253308,
	[195642] = 198793,
	[195665] = 312682,
	[195676] = 197760,
	[196393] = 201094,
	[196394] = 310429,
	[196832] = 125825,
	[196833] = 125825,
	[201578] = 333925,
	[201873] = 341870,
	[202080] = 199226,
	[202081] = 199226,
	[202082] = 199226,
	[202083] = 199226,
	[202135] = 189528,
	[202180] = 341746,
	[202407] = 200953,
	[202474] = 200953,
	[202598] = 343855,
	[202613] = 197760,
	[202655] = 511906,
	[202697] = 192702,
	[202701] = 190617,
	[202706] = 200948,
	[202712] = 198020,
	[202776] = 219405,
	[202777] = 219405,
	[202778] = 219405,
	[202779] = 219405,
	[202780] = 219405,
	[202871] = 200961,
	[202975] = 190617,
	[203071] = 511900,
	[203078] = 511890,
	[203128] = 198060,
	[203134] = 198754,
	[203140] = 366782,
	[203186] = 305263,
	[203207] = 198020,
	[203301] = 192649,
	[203305] = 201449,
	[203733] = 199473,
	[203734] = 243448,
	[203755] = 333925,
	[204050] = 365176,
	[204274] = 200908,
	[204282] = 511904,
	[204344] = 198409,
	[204351] = 203892,
	[204372] = 311582,
	[204386] = 311582,
	[204406] = 198061,
	[204437] = 198990,
	[204450] = 198457,
	[204578] = 199563,
	[204817] = 189528,
	[204824] = 189528,
	[204825] = 189528,
	[204959] = 383743,
	[205134] = 200908,
	[205143] = 190617,
	[205198] = 343859,
	[205207] = 200910,
	[205258] = 199105,
	[205266] = 243678,
	[205332] = 191094,
	[205350] = 197760,
	[205476] = 375546,
	[205477] = 199870,
	[205479] = 198198,
	[205540] = 200066,
	[205874] = 199989,
	[205875] = 200995,
	[206109] = 429104,
	[206111] = 429102,
	[206116] = 429104,
	[206293] = 201023,
	[206294] = 429102,
	[206335] = 368543,
	[206336] = 396583,
	[206374] = 200953,
	[206504] = 203430,
	[206569] = 192702,
	[206585] = 194719,
	[206836] = 511898,
	[206944] = 189854,
	[207104] = 309721,
	[207125] = 198168,
	[207179] = 198100,
	[207187] = 511902,
	[207188] = 511888,
	[207189] = 511892,
	[207190] = 511896,
	[207279] = 418794,
	[207303] = 199475,
	[207304] = 199475,
	[207320] = 429102,
	[207321] = 429102,
	[207322] = 429102,
	[207323] = 429104,
	[207324] = 429104,
	[207325] = 429104,
	[207359] = 351241,
	[207406] = 307360,
	[207407] = 195020,
	[207408] = 440160,
	[207409] = 402156,
	[207410] = 405455,
	[207411] = 342586,
	[207412] = 202595,
	[207496] = 446673,
	[207497] = 446673,
	[207498] = 446673,
	[207500] = 446673,
	[207724] = 219411,
	[208311] = 219405,
	[208316] = 429102,
	[208317] = 429104,
	[208365] = 189528,
	[208535] = 202297,
	[208549] = 190688,
	[208550] = 190688,
	[208825] = 201267,
	[208900] = 516734,
	[209072] = 200960,
	[209076] = 200960,
	[209094] = 200960,
	[209095] = 200960,
	[209270] = 305393,
	[209344] = 529309,
	[209345] = 529408,
	[209436] = 199730,
	[209462] = 519875,
	[209497] = 195541,
	[209550] = 526046,
	[209620] = 446671,
	[209673] = 537061,
	[209699] = 530690,
	[209700] = 528748,
	[209701] = 199797,
	[209825] = 242904,
	[209836] = 522284,
	[209842] = 526861,
	[209843] = 531710,
	[209844] = 533100,
	[209845] = 191825,
	[209863] = 392111,
	[209891] = 576516,
	[209892] = 531710,
	[209903] = 189546,
	[209907] = 195922,
	[209921] = 248067,
	[209951] = 200974,
	[209952] = 527531,
	[209953] = 199223,
	[209954] = 201375,
	[209955] = 202737,
	[210001] = 533071,
	[210002] = 533075,
	[210005] = 519913,
	[210015] = 519913,
	[210016] = 519913,
	[210017] = 519913,
	[210018] = 519913,
	[210019] = 519913,
	[210020] = 519913,
	[210184] = 189085,
	[210186] = 189088,
	[210188] = 458025,
	[210209] = 195536,
	[210228] = 243419,
	[210229] = 248066,
	[210238] = 623767,
	[210239] = 623814,
	[210240] = 623817,
	[210416] = 536480,
	[210417] = 605542,
	[210418] = 604719,
	[210565] = 204112,
	[210582] = 204112,
	[210759] = 198642,
	[210887] = 579089,
	[211017] = 531715,
	[211018] = 531718,
	[211019] = 531720,
	[211023] = 219397,
	[211143] = 589967,
	[211147] = 589963,
	[211148] = 590004,
	[211266] = 533020,
	[211268] = 533083,
	[211269] = 533075,
	[211270] = 576565,
	[211312] = 589513,
	[211379] = 530257,
	[211382] = 328308,
	[211420] = 189528,
	[211424] = 521979,
	[211451] = 199704,
	[211452] = 199706,
	[211454] = 193648,
	[211480] = 249508,
	[211506] = 589513,
	[211507] = 589578,
	[211510] = 219372,
	[211517] = 311068,
	[211518] = 311069,
	[211536] = 523160,
	[211537] = 523211,
	[211538] = 523160,
	[211566] = 588531,
	[211684] = 574931,
	[211696] = 594223,
	[211719] = 535027,
	[211721] = 535029,
	[211754] = 534928,
	[211770] = 194086,
	[211780] = 534928,
	[211793] = 202596,
	[211794] = 200640,
	[211807] = 195121,
	[211863] = 623807,
	[211871] = 590966,
	[211872] = 590968,
	[211873] = 590964,
	[211967] = 200953,
	[211990] = 534984,
	[211993] = 534984,
	[211994] = 534984,
	[212003] = 589513,
	[212009] = 604977,
	[212079] = 202596,
	[212135] = 536475,
	[212136] = 536473,
	[212181] = 589976,
	[212278] = 531103,
	[212389] = 521201,
	[212540] = 531097,
	[212541] = 537733,
	[212553] = 576563,
	[212902] = 604977,
	[212923] = 614205,
	[212987] = 307564,
	[212988] = 307564,
	[213267] = 202742,
	[213327] = 534984,
	[213328] = 534984,
	[213329] = 534984,
	[213330] = 534984,
	[213331] = 534984,
	[213332] = 534984,
	[213333] = 534984,
	[213334] = 534984,
	[213362] = 446673,
	[213363] = 615309,
	[213364] = 575063,
	[213366] = 196466,
	[213368] = 616362,
	[213407] = 603545,
	[213409] = 534984,
	[213410] = 534984,
	[213411] = 534984,
	[213412] = 534984,
	[213413] = 534984,
	[213414] = 534984,
	[213415] = 534984,
	[213416] = 534984,
	[213417] = 534984,
	[213418] = 534984,
	[213420] = 534984,
	[213421] = 534984,
	[213422] = 534984,
	[213438] = 576432,
	[213443] = 534984,
	[213445] = 534984,
	[213454] = 196988,
	[213455] = 534984,
	[213456] = 534984,
	[213459] = 534984,
	[213460] = 534984,
	[213461] = 534984,
	[213511] = 534984,
	[213512] = 576426,
	[213649] = 197063,
	[213650] = 197063,
	[213651] = 446673,
	[213653] = 651007,
	[213741] = 605629,
	[213742] = 605542,
	[213748] = 530886,
	[213749] = 651009,
	[213750] = 201276,
	[213751] = 446675,
	[213765] = 200640,
	[213767] = 537040,
	[213768] = 318833,
	[213769] = 446671,
	[213770] = 446677,
	[213771] = 579236,
	[213774] = 579120,
	[213782] = 589967,
	[213793] = 446679,
	[213795] = 534842,
	[213842] = 593274,
	[213844] = 604977,
	[213845] = 575061,
	[213956] = 304695,
	[213959] = 604981,
	[213960] = 651003,
	[213961] = 537034,
	[213962] = 615309,
	[213964] = 615312,
	[213966] = 604977,
	[213967] = 615295,
	[213968] = 615298,
	[213969] = 615370,
	[213970] = 623807,
	[213971] = 242727,
	[213972] = 615372,
	[213973] = 618946,
	[214062] = 604977,
	[214170] = 615994,
	[214175] = 523213,
	[214325] = 196976,
	[214337] = 446675,
	[214338] = 195542,
	[214339] = 446671,
	[214340] = 534954,
	[214403] = 576627,
	[214407] = 196979,
	[214438] = 194086,
	[214439] = 199737,
	[214562] = 392110,
	[214871] = 589967,
	[214903] = 528748,
	[214945] = 623765,
	[214962] = 536486,
	[215705] = 525041,
	[215765] = 534984,
	[215779] = 534984,
	[215780] = 534984,
	[215782] = 534984,
	[215783] = 534984,
	[215785] = 534984,
	[215797] = 534984,
	[215798] = 534984,
	[215799] = 534984,
	[215844] = 198199,
	[216322] = 429104,
	[216362] = 531103,
	[216761] = 219404,
	[216764] = 219406,
	[218055] = 666470,
	[218056] = 666472,
	[218059] = 775412,
	[218427] = 534984,
	[218428] = 534984,
	[218429] = 534984,
	[218430] = 534984,
	[218431] = 534984,
	[218432] = 534984,
	[218433] = 534984,
	[218434] = 534984,
	[218435] = 534984,
	[218436] = 534984,
	[218437] = 534984,
	[218438] = 534984,
	[218593] = 629723,
	[218750] = 521979,
	[218853] = 446679,
	[220641] = 446677,
	[220807] = 193427,
	[220815] = 200950,
	[220820] = 305393,
	[220821] = 305393,
	[220832] = 446671,
	[220901] = 629720,
	[220902] = 446675,
	[220903] = 622749,
	[220904] = 198649,
	[220908] = 629720,
	[220986] = 629720,
	[220994] = 196976,
	[220995] = 196988,
	[220996] = 196989,
	[220997] = 219372,
	[220998] = 384743,
	[220999] = 196982,
	[221000] = 200953,
	[221001] = 196988,
	[221002] = 803755,
	[221003] = 446671,
	[221004] = 446673,
	[221005] = 446675,
	[221006] = 446677,
	[221007] = 629720,
	[221008] = 629723,
	[221009] = 197063,
	[221010] = 253337,
	[221013] = 953811,
	[221014] = 196989,
	[221015] = 219372,
	[221016] = 196982,
	[221017] = 446671,
	[221018] = 446673,
	[221019] = 446675,
	[221020] = 446677,
	[221021] = 197063,
	[221022] = 219372,
	[221023] = 446671,
	[221024] = 200960,
	[221026] = 200960,
	[221027] = 791814,
	[221036] = 198990,
	[221376] = 604364,
	[221413] = 534984,
	[221617] = 321453,
	[221670] = 196989,
	[221671] = 446671,
	[221672] = 519955,
	[221673] = 519955,
	[221689] = 199724,
	[221690] = 796657,
	[221725] = 201845,
	[221747] = 607303,
	[221763] = 457443,
	[221764] = 201746,
	[222684] = 204112,
	[222685] = 191835,
	[222686] = 201618,
	[222687] = 589582,
	[222688] = 623820,
	[222689] = 195324,
	[222776] = 524139,
	[222796] = 243082,
	[223084] = 196989,
	[223085] = 196989,
	[223086] = 196989,
	[223087] = 196989,
	[223088] = 196989,
	[223089] = 196989,
	[223090] = 196989,
	[223091] = 196989,
	[223092] = 196989,
	[223093] = 196989,
	[223094] = 196989,
	[223095] = 196989,
	[223096] = 196989,
	[223097] = 196989,
	[223098] = 196989,
	[223099] = 196989,
	[223100] = 196989,
	[223101] = 196989,
	[223102] = 196989,
	[223103] = 196989,
	[223104] = 196989,
	[223105] = 196989,
	[223106] = 196989,
	[223107] = 196989,
	[223108] = 196989,
	[223109] = 196989,
	[223110] = 196989,
	[223111] = 196989,
	[223112] = 196989,
	[223113] = 196989,
	[223114] = 196989,
	[223115] = 196989,
	[223116] = 446671,
	[223117] = 446671,
	[223118] = 446671,
	[223119] = 519955,
	[223139] = 199989,
	[223193] = 196998,
	[223204] = 196989,
	[223228] = 304794,
	[223533] = 850533,
	[223537] = 658115,
	[223538] = 200228,
	[223539] = 318344,
	[224228] = 200949,
	[224306] = 875607,
	[224392] = 878856,
	[224613] = 200960,
	[224616] = 917936,
	[224623] = 661112,
	[224633] = 878880,
	[224686] = 521770,
	[224713] = 446679,
	[224750] = 198990,
	[224753] = 1003210,
	[224754] = 196976,
	[224755] = 953811,
	[224756] = 987264,
	[224770] = 196988,
	[224780] = 202935,
	[224781] = 197063,
	[224783] = 875134,
	[224784] = 875132,
	[224785] = 512025,
	[225501] = 197063,
	[225502] = 850842,
	[225503] = 197063,
	[225596] = 201766,
	[225726] = 929342,
	[225778] = 916174,
	[226468] = 977179,
	[226831] = 875132,
	[226854] = 194275,
	[226861] = 196988,
	[226862] = 588947,
	[226865] = 875132,
	[226955] = 252302,
	[226956] = 199736,
	[226961] = 199473,
	[226967] = 248066,
	[226976] = 936403,
	[226983] = 446677,
	[226990] = 446671,
	[226993] = 878856,
	[226994] = 446679,
	[226996] = 341989,
	[227069] = 916166,
	[227134] = 446673,
	[227504] = 511490,
	[227527] = 922570,
	[227587] = 875132,
	[227654] = 201060,
	[227737] = 192702,
	[227743] = 575425,
	[227793] = 875132,
	[227806] = 125992,
	[227859] = 344274,
	[227868] = 219404,
	[227951] = 306217,
	[227953] = 902476,
	[227954] = 346121,
	[227955] = 202126,
	[227956] = 197617,
	[227996] = 915963,
	[227998] = 936417,
	[228012] = 603874,
	[228013] = 875378,
	[228014] = 196988,
	[228015] = 196976,
	[228016] = 306201,
	[228017] = 918042,
	[228018] = 446679,
	[228019] = 915961,
	[228020] = 875132,
	[228021] = 197063,
	[228022] = 196525,
	[228023] = 196982,
	[228024] = 942492,
	[228025] = 874401,
	[228026] = 942448,
	[228483] = 196988,
	[228570] = 446673,
	[229314] = 455586,
	[229328] = 878854,
	[229330] = 242728,
	[229331] = 243076,
	[229333] = 936403,
	[229344] = 193577,
	[229354] = 916363,
	[229367] = 199674,
	[229640] = 879808,
	[230252] = 803621,
	[230303] = 199424,
	[230401] = 199192,
	[230402] = 916363,
	[230424] = 197617,
	[230425] = 203724,
	[230428] = 984398,
	[230498] = 892663,
	[230506] = 892663,
	[230544] = 977179,
	[230611] = 874401,
	[230643] = 191835,
	[230664] = 370669,
	[230865] = 936419,
	[230909] = 579113,
	[230933] = 193552,
	[231063] = 774867,
	[231064] = 943615,
	[231069] = 202935,
	[231100] = 796119,
	[231103] = 446673,
	[231644] = 607307,
	[231769] = 367362,
	[231775] = 988056,
	[231901] = 243436,
	[231903] = 382932,
	[231918] = 916168,
	[232024] = 985170,
	[232066] = 446671,
	[232067] = 875132,
	[232090] = 446671,
	[232214] = 446673,
	[232215] = 446673,
	[232216] = 446673,
	[232217] = 446673,
	[232218] = 446671,
	[232219] = 446673,
	[232237] = 446673,
	[232248] = 189528,
	[232250] = 189528,
	[232251] = 189528,
	[232252] = 189528,
	[232353] = 974176,
	[232397] = 944386,
	[232398] = 944386,
	[232400] = 944386,
	[232405] = 192468,
	[232406] = 936415,
	[232416] = 429104,
	[232458] = 446677,
	[232492] = 1020152,
	[232494] = 875132,
	[232507] = 984888,
	[232541] = 984860,
	[232546] = 875603,
	[232547] = 875603,
	[232549] = 875614,
	[232550] = 446673,
	[232571] = 936417,
	[232579] = 661112,
	[232582] = 983325,
	[232583] = 940097,
	[232584] = 446677,
	[232586] = 925591,
	[232587] = 850848,
	[232588] = 850535,
	[232589] = 878856,
	[232590] = 202749,
	[232591] = 147151,
	[232592] = 458025,
	[232595] = 446675,
	[232596] = 879808,
	[232597] = 936417,
	[232598] = 446677,
	[232599] = 953811,
	[232621] = 193862,
	[232624] = 875132,
	[232985] = 977078,
	[232986] = 977074,
	[232989] = 974209,
	[233032] = 878854,
	[233033] = 878856,
	[233034] = 977078,
	[233044] = 196989,
	[233048] = 987197,
	[233052] = 950767,
	[233079] = 850517,
	[233101] = 574913,
	[233103] = 1005490,
	[233107] = 1402263,
	[233113] = 874421,
	[233126] = 512025,
	[233132] = 196998,
	[233134] = 199227,
	[233135] = 953811,
	[233137] = 953811,
	[233139] = 200953,
	[233149] = 874403,
	[233180] = 877914,
	[233206] = 875382,
	[233218] = 936417,
	[233229] = 916185,
	[233241] = 838776,
	[233263] = 200024,
	[233291] = 429104,
	[233391] = 929342,
	[233452] = 189528,
	[233455] = 446679,
	[233457] = 605629,
	[233492] = 197063,
	[233499] = 987264,
	[233501] = 193027,
	[233504] = 197145,
	[233505] = 200964,
	[233507] = 971467,
	[233511] = 936417,
	[233513] = 196707,
	[233520] = 197145,
	[233521] = 977078,
	[233522] = 937012,
	[233523] = 193027,
	[233524] = 200964,
	[233525] = 588947,
	[233526] = 200953,
	[233532] = 146081,
	[233539] = 193781,
	[233549] = 874639,
	[233550] = 200964,
	[233551] = 193782,
	[233552] = 446679,
	[233555] = 874639,
	[233557] = 193781,
	[233558] = 193027,
	[233559] = 196707,
	[233560] = 196306,
	[233561] = 879808,
	[233593] = 979954,
	[233594] = 929342,
	[233598] = 523381,
	[233611] = 875670,
	[233613] = 922572,
	[233618] = 987178,
	[233623] = 977078,
	[233626] = 376264,
	[233633] = 943615,
	[233645] = 979242,
	[233649] = 987264,
	[233650] = 922568,
	[233651] = 242727,
	[233658] = 977078,
	[233696] = 307721,
	[233697] = 200417,
	[233715] = 446671,
	[233768] = 892744,
	[233773] = 902296,
	[233792] = 656602,
	[233917] = 376266,
	[233956] = 969884,
	[233973] = 446679,
	[233975] = 1011411,
	[234054] = 974969,
	[234147] = 974207,
	[234154] = 968422,
	[234155] = 446675,
	[234157] = 985715,
	[234159] = 902294,
	[234243] = 333925,
	[234432] = 446673,
	[234446] = 446675,
	[234449] = 446675,
	[234451] = 446675,
	[234454] = 446675,
	[234455] = 446675,
	[234456] = 953811,
	[234457] = 875128,
	[234458] = 878880,
	[234461] = 329065,
	[234471] = 948445,
	[234472] = 309564,
	[234473] = 446673,
	[234474] = 875614,
	[234618] = 145256,
	[234685] = 902478,
	[234703] = 972295,
	[234704] = 972295,
	[234705] = 972295,
	[234734] = 972295,
	[234735] = 972295,
	[234736] = 972295,
	[234740] = 252302,
	[234744] = 974209,
	[234746] = 974209,
	[234748] = 974209,
	[235073] = 974209,
	[235090] = 974209,
	[235091] = 242730,
	[235095] = 968336,
	[235097] = 355500,
	[235103] = 950769,
	[235104] = 253445,
	[235105] = 253445,
	[235127] = 193027,
	[235129] = 1033504,
	[235135] = 446677,
	[235141] = 968120,
	[235143] = 903257,
	[235168] = 977078,
	[235172] = 974207,
	[235282] = 972293,
	[235289] = 929367,
	[235299] = 446673,
	[235300] = 975395,
	[235307] = 977078,
	[235310] = 353343,
	[235313] = 984881,
	[235365] = 446671,
	[235673] = 200960,
	[235826] = 1003210,
	[235859] = 428634,
	[235860] = 196976,
	[235869] = 903889,
	[235881] = 1003209,
	[236092] = 936417,
	[236096] = 197145,
	[236099] = 874421,
	[236138] = 953811,
	[236139] = 197644,
	[236140] = 978630,
	[236141] = 936417,
	[236147] = 203025,
	[236149] = 198989,
	[236158] = 145215,
	[236165] = 978198,
	[236169] = 194364,
	[236170] = 197148,
	[236178] = 1033545,
	[236206] = 978198,
	[236257] = 200953,
	[236258] = 200964,
	[236259] = 193027,
	[236260] = 193027,
	[236264] = 196707,
	[236265] = 446679,
	[236266] = 200964,
	[236267] = 200953,
	[236269] = 937012,
	[236270] = 446679,
	[236271] = 446679,
	[236274] = 446679,
	[236275] = 200953,
	[236276] = 937012,
	[236278] = 937012,
	[236279] = 446679,
	[236280] = 200953,
	[236282] = 937012,
	[236284] = 971467,
	[236285] = 446679,
	[236288] = 200953,
	[236289] = 446679,
	[236348] = 971467,
	[236349] = 200953,
	[236350] = 446679,
	[236351] = 971467,
	[236399] = 446679,
	[236400] = 971467,
	[236402] = 200953,
	[236404] = 446679,
	[236406] = 971467,
	[236407] = 971467,
	[236483] = 446679,
	[236610] = 446675,
	[236633] = 446671,
	[236693] = 970548,
	[236715] = 948490,
	[236755] = 196988,
	[236935] = 953811,
	[237016] = 199424,
	[237021] = 916164,
	[237022] = 429104,
	[237343] = 197166,
	[237452] = 953811,
	[237461] = 879820,
	[237462] = 892424,
	[237463] = 193414,
	[237464] = 922576,
	[237465] = 971117,
	[237466] = 963814,
	[237467] = 243429,
	[237468] = 977084,
	[237469] = 202801,
	[237470] = 936441,
	[237471] = 593816,
	[237472] = 219491,
	[237473] = 1019382,
	[237474] = 976044,
	[237475] = 979403,
	[237476] = 877759,
	[237477] = 200225,
	[237478] = 916363,
	[237479] = 201641,
	[237480] = 191825,
	[237481] = 577391,
	[237482] = 1044086,
	[237483] = 1085572,
	[237484] = 983119,
	[237511] = 193862,
	[237751] = 929342,
	[237821] = 985170,
	[237946] = 659752,
	[239120] = 936417,
	[239143] = 970220,
	[239171] = 929393,
	[239194] = 446677,
	[239198] = 1062118,
	[239328] = 942843,
	[239791] = 985161,
	[239803] = 1349621,
	[239828] = 165834,
	[239901] = 984888,
	[239925] = 942535,
	[239926] = 942535,
	[240003] = 249606,
	[240215] = 193184,
	[240289] = 1015733,
	[240317] = 382932,
	[240353] = 200136,
	[240354] = 200136,
	[240519] = 1349620,
	[240543] = 953811,
	[240547] = 1097781,
	[240577] = 1064785,
	[240580] = 192714,
	[240605] = 1349620,
	[240608] = 1349620,
	[240609] = 1349620,
	[240612] = 1349620,
	[240614] = 1349620,
	[240616] = 874403,
	[240617] = 571710,
	[240619] = 1349620,
	[240622] = 521201,
	[240623] = 195121,
	[240624] = 975382,
	[240625] = 942843,
	[240629] = 1349621,
	[240630] = 1349620,
	[240631] = 1349621,
	[240634] = 1349621,
	[240635] = 1349621,
	[240637] = 1349622,
	[240638] = 1349621,
	[240639] = 1349622,
	[240641] = 1349621,
	[240642] = 1349621,
	[240643] = 1349621,
	[240644] = 1349620,
	[240645] = 1349622,
	[240646] = 1349621,
	[240649] = 1402263,
	[240651] = 1349620,
	[240652] = 1349621,
	[240653] = 1349620,
	[240654] = 1349620,
	[240655] = 1349622,
	[240657] = 1349620,
	[240690] = 1349621,
	[240855] = 916178,
	[241128] = 196989,
	[241146] = 1402264,
	[241147] = 1402263,
	[241148] = 1402263,
	[241149] = 1402263,
	[241150] = 1402263,
	[241151] = 1402263,
	[241152] = 1402264,
	[241153] = 1402263,
	[241154] = 1402263,
	[241155] = 1402264,
	[241180] = 1402264,
	[241206] = 1402263,
	[241207] = 1402263,
	[241208] = 1402264,
	[241212] = 1402264,
	[241213] = 1402263,
	[241216] = 1402264,
	[241267] = 1402263,
	[241272] = 1402264,
	[241280] = 1402264,
	[241433] = 523211,
	[241434] = 943686,
	[241449] = 875603,
	[241450] = 202751,
	[241504] = 942849,
	[241518] = 1402263,
	[241521] = 522113,
	[241522] = 1119130,
	[241524] = 953811,
	[241533] = 148079,
	[241557] = 1402263,
	[241558] = 1402264,
	[241560] = 953811,
	[241561] = 980090,
	[241562] = 1402263,
	[241563] = 1064382,
	[241564] = 1402263,
	[241565] = 523213,
	[241566] = 969729,
	[241599] = 196317,
	[241600] = 645601,
	[241601] = 936417,
	[241602] = 878880,
	[241605] = 190803,
	[241641] = 1303238,
	[241656] = 985187,
	[241657] = 194083,
	[241664] = 1052603,
	[241665] = 1402264,
	[241666] = 1002900,
	[241671] = 193423,
	[241673] = 196990,
	[241674] = 1097379,
	[241680] = 1402263,
	[241692] = 592070,
	[241699] = 196989,
	[241712] = 446673,
	[241713] = 243033,
	[241714] = 196989,
	[241715] = 446677,
	[241716] = 196987,
	[241717] = 1402270,
	[241726] = 1244489,
	[241742] = 965217,
	[241743] = 1244487,
	[241745] = 878856,
	[241760] = 326812,
	[241764] = 953811,
	[241767] = 1349621,
	[241772] = 1349621,
	[241773] = 1349620,
	[241775] = 978597,
	[241835] = 902292,
	[241841] = 238839,
	[241847] = 929409,
	[241848] = 244252,
	[242242] = 1349620,
	[242249] = 975539,
	[242250] = 1349620,
	[242328] = 1349620,
	[242350] = 1349621,
	[242446] = 1349620,
	[242642] = 1349620,
	[242643] = 1349620,
	[242644] = 1349621,
	[242645] = 1349620,
	[242646] = 1349620,
	[242647] = 1349621,
	[242649] = 975539,
	[242660] = 1349620,
	[242662] = 1349620,
	[242663] = 979397,
	[242664] = 1349621,
	[242665] = 1349620,
	[242666] = 1349621,
	[242667] = 1349620,
	[242668] = 1349622,
	[242669] = 1349620,
	[242670] = 1349621,
	[242671] = 1349622,
	[242675] = 1349620,
	[242678] = 1349621,
	[242683] = 1349621,
	[242959] = 1349621,
	[243280] = 1131795,
	[243281] = 1131797,
	[243282] = 1131798,
	[243283] = 1131783,
	[243321] = 1127329,
	[243323] = 1127332,
	[243392] = 985165,
	[243688] = 1402238,
	[243690] = 1004785,
	[243693] = 446671,
	[243698] = 1402222,
	[243773] = 1402238,
	[243798] = 1100065,
	[243899] = 528625,
	[243911] = 196993,
	[244447] = 202737,
	[244453] = 936441,
	[244473] = 979119,
	[244494] = 1402238,
	[244519] = 1402238,
	[244628] = 446677,
	[244651] = 198017,
	[244678] = 305393,
	[244689] = 1349995,
	[244691] = 1349995,
	[244692] = 1349995,
	[244694] = 1349995,
	[244698] = 1349995,
	[244699] = 1349995,
	[244700] = 1349995,
	[244701] = 1349995,
	[244774] = 1391548,
	[244775] = 1369688,
	[244776] = 1370949,
	[244777] = 1282724,
	[244778] = 1357601,
	[244786] = 1284877,
	[244887] = 1402263,
	[244899] = 1402263,
	[244901] = 1402264,
	[244902] = 1402264,
	[244903] = 1402264,
	[244904] = 1402263,
	[244905] = 1402263,
	[244909] = 1402263,
	[244912] = 1402263,
	[244913] = 1402264,
	[244917] = 1402264,
	[244928] = 1402270,
	[244965] = 979397,
	[244986] = 986958,
	[245216] = 305393,
	[245286] = 192711,
	[245316] = 1349995,
	[245324] = 1244490,
	[245325] = 1244488,
	[245328] = 1365480,
	[245345] = 1349995,
	[245479] = 446677,
	[245524] = 1402238,
	[245525] = 1402225,
	[245527] = 1402238,
	[245528] = 1402238,
	[245529] = 1402225,
	[245530] = 1349622,
	[245531] = 1402225,
	[245532] = 1402238,
	[245533] = 1402238,
	[245534] = 1402225,
	[245535] = 1402225,
	[245536] = 1402222,
	[245537] = 1402222,
	[245538] = 1402225,
	[245541] = 1402225,
	[245542] = 1402238,
	[245543] = 1402238,
	[245545] = 1402225,
	[245547] = 1402225,
	[245548] = 1402238,
	[245550] = 1402238,
	[245551] = 1402225,
	[245553] = 1402238,
	[245554] = 1402225,
	[245555] = 1402225,
	[245579] = 1402238,
	[245580] = 1402225,
	[245581] = 1402225,
	[245601] = 1402225,
	[245602] = 1402238,
	[245603] = 1402225,
	[245688] = 1110188,
	[245793] = 949615,
	[245941] = 1349622,
	[245996] = 1349995,
	[246037] = 1349621,
	[246147] = 1349995,
	[246154] = 193414,
	[246205] = 1349620,
	[246206] = 1349620,
	[246249] = 1349995,
	[246250] = 1355115,
	[246254] = 1349620,
	[246269] = 1349995,
	[246309] = 1349995,
	[246353] = 1349995,
	[246438] = 936413,
	[246524] = 1349620,
	[246555] = 1349995,
	[246556] = 1349995,
	[246557] = 1349995,
	[246558] = 1349995,
	[246559] = 1349995,
	[246560] = 1349995,
	[246561] = 1349995,
	[246562] = 1349995,
	[247694] = 1367347,
	[247797] = 576627,
	[247999] = 1284877,
	[248000] = 1284877,
	[248001] = 1284877,
	[248002] = 1284877,
	[248003] = 1284877,
	[248004] = 1284877,
	[248005] = 1284877,
	[248006] = 1284877,
	[248007] = 1284877,
	[248008] = 1284877,
	[248009] = 1284877,
	[248010] = 1284877,
	[248011] = 1284877,
	[248012] = 1284877,
	[248398] = 192568,
	[248534] = 1337278,
	[248854] = 1341658,
	[249211] = 243298,
	[249997] = 1349620,
	[250080] = 1349620,
	[250081] = 1349620,
	[250083] = 1349620,
	[250084] = 1349620,
	[250085] = 1349620,
	[250087] = 1349620,
	[250088] = 1349620,
	[250090] = 1349620,
	[250091] = 1349620,
	[250092] = 1349621,
	[250097] = 1349620,
	[250098] = 1349620,
	[250102] = 1349621,
	[250103] = 1349620,
	[250104] = 1349620,
	[250106] = 1349620,
	[250107] = 1349622,
	[250108] = 1349620,
	[250109] = 1349621,
	[250383] = 1321134,
	[250541] = 1402238,
	[250984] = 1402263,
	[250985] = 1402263,
	[250987] = 1402263,
	[251032] = 1368709,
	[251124] = 1349622,
	[251168] = 942442,
	[251218] = 1139506,
	[251220] = 1139506,
	[251221] = 1139506,
	[251416] = 1108691,
	[251552] = 1349620,
	[251564] = 305393,
	[251713] = 1402263,
	[251714] = 1402263,
	[251716] = 1402270,
	[251719] = 1402263,
	[251720] = 1402263,
	[251723] = 1402263,
	[251737] = 1402264,
	[251738] = 1402264,
	[251761] = 1402263,
	[251762] = 1402263,
	[251764] = 1402263,
	[251772] = 1402263,
	[251776] = 1402263,
	[251780] = 1402263,
	[251782] = 1402263,
	[251792] = 1402264,
	[251820] = 1314905,
	[251851] = 1402263,
	[251853] = 1402263,
	[251854] = 1402263,
	[251856] = 1402263,
	[251857] = 1402264,
	[251991] = 1361813,
	[252069] = 196982,
	[252107] = 1368866,
	[252232] = 983862,
	[252258] = 1354920,
	[252259] = 1354920,
	[252260] = 1354920,
	[252261] = 1354920,
	[252262] = 1354920,
	[252263] = 1354920,
	[252264] = 1354920,
	[252267] = 1254955,
	[252269] = 936417,
	[252270] = 200960,
	[252272] = 198139,
	[252273] = 1349032,
	[252277] = 1379113,
	[252279] = 1365452,
	[252282] = 970210,
	[252284] = 985362,
	[252289] = 1310395,
	[252331] = 1386540,
	[252385] = 936411,
	[252386] = 936411,
	[252387] = 936411,
	[252388] = 936411,
	[252390] = 936411,
	[252391] = 936411,
	[252395] = 852646,
	[252404] = 1284877,
	[252412] = 658558,
	[252432] = 1108691,
	[252434] = 249664,
	[252446] = 1108691,
	[252447] = 1108691,
	[252448] = 1108691,
	[252449] = 1108691,
	[252450] = 1108691,
	[252557] = 249664,
	[252558] = 249664,
	[252559] = 249664,
	[252560] = 249664,
	[252561] = 249664,
	[252562] = 249664,
	[252563] = 249664,
	[252564] = 249664,
	[252565] = 249664,
	[252570] = 1402264,
	[252802] = 1349620,
	[252803] = 1349995,
	[252805] = 1353175,
	[252806] = 1349995,
	[252807] = 1349620,
	[252808] = 1349620,
	[252810] = 1349620,
	[252812] = 1096610,
	[252813] = 1349620,
	[252814] = 1368866,
	[252815] = 1368866,
	[252816] = 1368866,
	[252817] = 1368866,
	[252819] = 1349620,
	[252820] = 1349620,
	[252821] = 1349621,
	[252822] = 1349622,
	[252824] = 1349621,
	[252828] = 1349620,
	[252829] = 1349620,
	[252830] = 1349620,
	[252831] = 1349622,
	[252833] = 1349621,
	[252834] = 1349620,
	[252835] = 1349620,
	[252836] = 1349620,
	[252837] = 1349621,
	[252838] = 1349621,
	[252839] = 1349620,
	[252840] = 1349620,
	[252841] = 1349620,
	[252842] = 1349621,
	[252844] = 1349621,
	[252850] = 1349620,
	[252860] = 1349620,
	[252876] = 1349620,
	[252880] = 1349621,
	[252881] = 1349621,
	[252882] = 1349621,
	[252883] = 1349621,
	[252884] = 1349622,
	[253161] = 983870,
	[253280] = 1406152,
	[253452] = 1124083,
	[253453] = 1391618,
	[253454] = 1391672,
	[253455] = 1391785,
	[253456] = 1365453,
	[253457] = 1124087,
	[253458] = 1367406,
	[253994] = 200136,
	[254007] = 1139507,
	[254010] = 878863,
	[254025] = 1349620,
	[254027] = 1349620,
	[254028] = 1349620,
	[254126] = 1349620,
	[254127] = 1349620,
	[254128] = 1349621,
	[254141] = 1349620,
	[254262] = 1269714,
	[255344] = 1450461,
	[255828] = 1402225,
	[255829] = 1402225,
	[255963] = 1402263,
	[256790] = 1349620,
	[257290] = 1402225,
	[257291] = 1349620,
	[257393] = 1349621,
	[257545] = 1349621,
	[257546] = 1349621,
	[257978] = 1402238,
	[257999] = 243439,
	[258690] = 1349620,
	[258978] = 191946,
	[258979] = 949611,
	[258980] = 1125316,
	[259806] = 305390,
	[265526] = 1402238,
	[265532] = 1368866,
	[265602] = 200916,
	[266289] = 446679,
	[266851] = 1534531,
	[268478] = 193414,
	[268551] = 219372,
	[268753] = 1349620,
	[269037] = 1308984,
	[269064] = 1349620,
	[269830] = 942865,
	[270855] = 1661948,
	[270917] = 916185,
	[271103] = 1671032,
	[271706] = 1312884,
	[271849] = 1353175,
	[271850] = 1353175,
	[272039] = 1661948,
	[272046] = 202390,
	[272061] = 1661948,
	[272163] = 985300,
	[272165] = 1661948,
	[272172] = 1661948,
	[272179] = 1696367,
	[272181] = 1661948,
	[272220] = 1661948,
	[272270] = 942865,
	[272422] = 916185,
	[272434] = 1572186,
	[272455] = 1353175,
	[272456] = 1353175,
	[272487] = 1405664,
	[272768] = 1244486,
	[272770] = 1353175,
	[272771] = 1353175,
	[272778] = 1692857,
	[272780] = 1693357,
	[272782] = 1685295,
	[273052] = 1616103,
	[273053] = 1616102,
	[273222] = 1353175,
	[273301] = 1062118,
	[273407] = 1062118,
	[273412] = 1062118,
	[273414] = 1062118,
	[273415] = 1062118,
	[273439] = 1062118,
	[273443] = 1062118,
	[273519] = 1353175,
	[273521] = 1353175,
	[273523] = 1353175,
	[273524] = 1353175,
	[273527] = 1353175,
	[273528] = 1353175,
	[273533] = 1353175,
	[273535] = 1353175,
	[273538] = 1353175,
	[273814] = 1712131,
	[273854] = 878854,
	[276187] = 1590841,
	[276223] = 1711488,
	[276224] = 1711483,
	[276225] = 1711483,
	[276226] = 1711483,
	[276227] = 1711488,
	[276228] = 1711483,
	[276229] = 1711483,
	[276230] = 1711488,
	[276234] = 1784467,
	[276236] = 1794519,
	[276237] = 1785284,
	[276238] = 1780102,
	[276239] = 1882354,
	[276240] = 1890602,
	[276242] = 1907780,
	[276251] = 576627,
	[276424] = 1119654,
	[276425] = 1119647,
	[276426] = 944545,
	[276488] = 1663793,
	[276489] = 1352441,
	[276490] = 1711488,
	[276491] = 1711488,
	[276513] = 1091574,
	[276515] = 984242,
	[276616] = 2031162,
	[276617] = 2019658,
	[276618] = 2019856,
	[276619] = 2031164,
	[276620] = 2021566,
	[276621] = 2031158,
	[276622] = 2019659,
	[276623] = 2019857,
	[276735] = 1802580,
	[276837] = 983348,
	[277199] = 305398,
	[277204] = 1352441,
	[277205] = 1352441,
	[277206] = 1352441,
	[277207] = 1352441,
	[277208] = 1352441,
	[277327] = 1711488,
	[277333] = 446679,
	[277336] = 1802264,
	[277340] = 1711488,
	[277342] = 1711488,
	[277343] = 1711488,
	[277344] = 1711488,
	[277346] = 1711488,
	[277373] = 1087664,
	[277384] = 1711488,
	[277444] = 796104,
	[277447] = 794721,
	[277459] = 1777830,
	[277561] = 803755,
	[277637] = 1062118,
	[277715] = 1777743,
	[277885] = 1702787,
	[277886] = 774269,
	[277897] = 1721089,
	[278197] = 243481,
	[278252] = 936419,
	[278313] = 1349040,
	[278368] = 936413,
	[278432] = 1721089,
	[278436] = 1806318,
	[278437] = 1777743,
	[278447] = 1719769,
	[278453] = 1940574,
	[278456] = 1891518,
	[278461] = 1802264,
	[278462] = 1802264,
	[278570] = 375555,
	[278577] = 985170,
	[278669] = 244163,
	[278675] = 1712574,
	[278694] = 1802264,
	[278793] = 1802264,
	[279042] = 1602486,
	[279044] = 362809,
	[279253] = 341746,
	[279260] = 1702787,
	[279299] = 1777743,
	[279609] = 803755,
	[279645] = 1354763,
	[279646] = 985168,
	[279647] = 983860,
	[279689] = 1777743,
	[279750] = 1806321,
	[280504] = 1096610,
	[280522] = 1702787,
	[280576] = 1661562,
	[280619] = 953811,
	[280727] = 936411,
	[280747] = 196690,
	[280755] = 878854,
	[280815] = 1661948,
	[280836] = 1661948,
	[280837] = 1661948,
	[280838] = 1661948,
	[280842] = 1661948,
	[280843] = 1661948,
	[280844] = 1661948,
	[280845] = 1661948,
	[280883] = 1062118,
	[280886] = 1709672,
	[280903] = 1335538,
	[280948] = 321660,
	[280951] = 1805764,
	[280957] = 878854,
	[281079] = 1794518,
	[281092] = 1777743,
	[281230] = 1267024,
	[281312] = 1602493,
	[281326] = 306265,
	[281348] = 576627,
	[281397] = 1806321,
	[281494] = 1806321,
	[281551] = 305399,
	[281583] = 1714199,
	[281639] = 2013140,
	[281646] = 1780619,
	[281647] = 1305630,
	[281655] = 1804876,
	[281673] = 1852972,
	[281718] = 936411,
	[281867] = 1794521,
	[281868] = 1794520,
	[281869] = 1882352,
	[281870] = 1784466,
	[281872] = 1890600,
	[281898] = 1802580,
	[282153] = 953811,
	[282457] = 2020671,
	[282478] = 1602480,
	[282498] = 1674792,
	[282666] = 1672878,
	[282721] = 1702787,
	[282723] = 1702787,
	[284411] = 1712385,
	[284417] = 1712385,
	[284421] = 1777743,
	[284426] = 1952881,
	[284448] = 1805764,
	[284454] = 1802580,
	[284455] = 1802580,
	[286016] = 1852972,
	[286954] = 254419,
	[287081] = 1726777,
	[287185] = 511906,
	[287189] = 191094,
	[287228] = 199473,
	[287229] = 1365480,
	[287232] = 1305630,
	[287239] = 1804876,
	[287304] = 1714199,
	[287318] = 1804876,
	[287320] = 1714199,
	[287324] = 1804876,
	[287326] = 1804876,
	[287327] = 1305630,
	[287398] = 1349040,
	[287440] = 1349040,
	[287441] = 1349040,
	[287442] = 1349040,
	[287958] = 1822634,
	[288157] = 1349040,
	[288167] = 1331241,
	[288214] = 199426,
	[288596] = 1804876,
	[288609] = 1706189,
	[288622] = 1696367,
	[288641] = 1349040,
	[289310] = 1349040,
	[289313] = 1349040,
	[289317] = 307305,
	[289361] = 1349040,
	[289365] = 199426,
	[289521] = 1970909,
	[289647] = 1806321,
	[289728] = 198457,
	[290127] = 1706189,
	[290128] = 1706189,
	[290138] = 254419,
	[290419] = 1349040,
	[290537] = 1696367,
	[290725] = 1804876,
	[290750] = 1838302,
	[290765] = 200135,
	[290993] = 446671,
	[291143] = 197622,
	[291233] = 965879,
	[291238] = 894512,
	[291241] = 848980,
	[291257] = 1806318,
	[291291] = 191094,
	[292523] = 305391,
	[292673] = 936441,
	[292674] = 936441,
	[292675] = 936441,
	[292676] = 936441,
	[292677] = 936441,
	[292686] = 2004170,
	[292812] = 995737,
	[292823] = 219499,
	[292825] = 219491,
	[292843] = 1282669,
	[293110] = 1861550,
	[293131] = 1859375,
	[293134] = 1984003,
	[293349] = 197617,
	[293350] = 1602486,
	[293351] = 1096760,
	[293445] = 1544964,
	[293446] = 194176,
	[293449] = 1708185,
	[293567] = 936419,
	[293568] = 936419,
	[293837] = 1068320,
	[293838] = 1068320,
	[293839] = 1068320,
	[293840] = 1068320,
	[293841] = 1068320,
	[293842] = 1068320,
	[293843] = 1068320,
	[293844] = 1068320,
	[293845] = 1068320,
	[293846] = 1068320,
	[293849] = 1661948,
	[293852] = 1806321,
	[293880] = 1806321,
	[293881] = 1806321,
	[293884] = 1806321,
	[293962] = 1806321,
	[293964] = 1806321,
	[293965] = 1806321,
	[293985] = 1349040,
	[294084] = 1602486,
	[294096] = 1046021,
	[294097] = 940623,
	[294098] = 367326,
	[294099] = 774346,
	[294100] = 1307043,
	[294101] = 1822968,
	[294102] = 939054,
	[294103] = 343460,
	[294104] = 1124095,
	[294105] = 244161,
	[294106] = 189087,
	[294107] = 625180,
	[294108] = 242730,
	[294109] = 960844,
	[294110] = 442505,
	[294111] = 197882,
	[294112] = 523642,
	[294113] = 1360796,
	[294114] = 202596,
	[294115] = 341882,
	[294125] = 2108571,
	[294173] = 446673,
	[294174] = 1806321,
	[294312] = 305392,
	[294314] = 305391,
	[294315] = 936411,
	[294316] = 1804876,
	[294317] = 1806321,
	[294319] = 1804876,
	[294335] = 2020463,
	[294703] = 196989,
	[296252] = 1984114,
	[296479] = 1805764,
	[296536] = 1118879,
	[296573] = 1697821,
	[296574] = 304793,
	[296575] = 1629631,
	[296579] = 1852926,
	[296580] = 198046,
	[296581] = 1659243,
	[296582] = 955699,
	[296583] = 309564,
	[296584] = 936458,
	[296585] = 198990,
	[296586] = 1674793,
	[296587] = 987171,
	[296588] = 2032244,
	[296589] = 970204,
	[296854] = 1931970,
	[296855] = 1959134,
	[296902] = 1931970,
	[296903] = 1931970,
	[296904] = 1931970,
	[296905] = 1931970,
	[296906] = 1931970,
	[296907] = 1931970,
	[296908] = 1931970,
	[296915] = 1982565,
	[296916] = 1982563,
	[296917] = 1982564,
	[296918] = 1982564,
	[297069] = 1602484,
	[297071] = 977078,
	[297074] = 1726769,
	[297485] = 1624533,
	[297489] = 1726769,
	[297490] = 1726777,
	[297491] = 1726753,
	[297492] = 1822636,
	[297493] = 1726753,
	[297494] = 774267,
	[297495] = 1830359,
	[297521] = 774269,
	[297522] = 774267,
	[297523] = 774273,
	[297524] = 774271,
	[297528] = 974983,
	[297627] = 1715645,
	[297628] = 1982565,
	[297629] = 1982563,
	[297630] = 1982564,
	[297631] = 1715645,
	[297632] = 1715645,
	[297700] = 774269,
	[297825] = 1806321,
	[297828] = 1806321,
	[297878] = 1806321,
	[297879] = 1806321,
	[297880] = 1806321,
	[297881] = 1806321,
	[297885] = 774273,
	[297891] = 1402264,
	[297892] = 1402264,
	[297893] = 1402264,
	[297905] = 1957225,
	[297906] = 1852972,
	[297933] = 1852973,
	[297934] = 1532588,
	[297939] = 1695543,
	[297940] = 1720424,
	[297941] = 1669995,
	[297942] = 1852964,
	[298766] = 353152,
	[298767] = 353152,
	[298768] = 1852964,
	[298769] = 353152,
	[298778] = 1349040,
	[298849] = 1349040,
	[298920] = 1806318,
	[298921] = 1726753,
	[298963] = 1726769,
	[298965] = 1726769,
	[299073] = 1726777,
	[303016] = 1068320,
	[303017] = 1068320,
	[303018] = 1068320,
	[303039] = 1305115,
	[307091] = 1346214,
	[307265] = 199421,
	[307277] = 189821,
	[307307] = 199567,
	[307325] = 199421,
	[307330] = 198238,
	[307340] = 196979,
	[307748] = 1331239,
	[307836] = 984397,
	[309498] = 197910,
	[310600] = 1365455,
	[310601] = 1368865,
	[310603] = 2133380,
	[310709] = 196989,
	[310736] = 1096611,
	[311155] = 194086,
	[311218] = 1346214,
	[311822] = 950137,
	[311902] = 1842466,
	[311903] = 1842467,
	[313446] = 1255034,
	[313447] = 1255023,
	[313448] = 199718,
	[316443] = 1346214,
	[316792] = 2205611,
	[316863] = 1802264,
	[319222] = 446671,
	[320514] = 446671,
	[320515] = 446671,
	[320516] = 446671,
	[320517] = 446671,
	[320518] = 446671,
	[322020] = 200137,
	[322066] = 2821927,
	[322413] = 2833918,
	[322533] = 965217,
	[322791] = 2322526,
	[322803] = 2756691,
	[324407] = 1453149,
	[325659] = 2907353,
	[325660] = 2907353,
	[325661] = 2907353,
	[325662] = 2907353,
	[325663] = 2907353,
	[325664] = 2907353,
	[325665] = 2907353,
	[325666] = 2907353,
	[325667] = 2907353,
	[325668] = 2907353,
	[325759] = 311491,
	[325795] = 2123117,
	[325853] = 1392384,
	[325869] = 531055,
	[325873] = 2530473,
	[325874] = 2530474,
	[325875] = 2530472,
	[325894] = 2833918,
	[325954] = 2499911,
	[326026] = 2833918,
	[326027] = 2929684,
	[326047] = 2839405,
	[326140] = 1822634,
	[326141] = 1822634,
	[326142] = 1822634,
	[326148] = 1367068,
	[326394] = 2833918,
	[326395] = 2839405,
	[326396] = 2839405,
	[326397] = 2839405,
	[326398] = 2839405,
	[326399] = 2839405,
	[326400] = 2839405,
	[326401] = 2833918,
	[326402] = 2833918,
	[326403] = 2833918,
	[326404] = 2833918,
	[326405] = 2833918,
	[326406] = 2833918,
	[326407] = 2833918,
	[326408] = 2833918,
	[326409] = 2833918,
	[326410] = 2833918,
	[326411] = 2833918,
	[326412] = 2833918,
	[326413] = 2833918,
	[326414] = 2833918,
	[326415] = 2833918,
	[326416] = 2833918,
	[326417] = 2833918,
	[326418] = 2833918,
	[326419] = 2833918,
	[326588] = 2352150,
	[326594] = 1367404,
	[326598] = 2563954,
	[327170] = 2352153,
	[327221] = 531055,
	[327230] = 1950265,
	[327407] = 219372,
	[327516] = 1950265,
	[327548] = 2439479,
	[327568] = 2123117,
	[327569] = 2123117,
	[327570] = 2123117,
	[327585] = 1822634,
	[327591] = 1367406,
	[327592] = 970212,
	[327596] = 2821927,
	[327597] = 953811,
	[327650] = 341746,
	[327652] = 341870,
	[327669] = 531170,
	[328343] = 2068144,
	[328413] = 538478,
	[329641] = 1349040,
	[329715] = 999889,
	[329783] = 2839405,
	[329805] = 1108688,
	[329918] = 1891518,
	[329919] = 1981374,
	[330168] = 531170,
	[330169] = 2068144,
	[330170] = 538478,
	[330183] = 1805764,
	[330627] = 319484,
	[330634] = 3011956,
	[332220] = 2839405,
	[332568] = 192711,
	[332569] = 192711,
	[332570] = 192711,
	[332571] = 192711,
	[332572] = 192711,
	[332573] = 192711,
	[332574] = 192711,
	[332575] = 192711,
	[332576] = 192711,
	[334216] = 3048900,
	[334220] = 3048900,
	[335655] = 240803,
	[336415] = 3448138,
	[337237] = 3597238,
	[337241] = 3207786,
	[338520] = 1862973,
	[339211] = 955688,
	[339243] = 446677,
	[339248] = 446677,
	[339249] = 446677,
	[339250] = 446677,
	[339283] = 3597238,
	[339601] = 3022977,
	[339625] = 3189119,
	[339641] = 3030673,
	[339770] = 979397,
	[339837] = 987264,
	[339869] = 3595030,
	[341416] = 2432195,
	[341424] = 3638167,
	[342098] = 189092,
	[343611] = 1269450,
	[343698] = 189682,
	[344588] = 526859,
	[344726] = 3045977,
	[345446] = 1062215,
	[345455] = 3638167,
	[345456] = 3638167,
	[345458] = 1254446,
	[347444] = 3036602,
	[348521] = 1957171,
	[348558] = 3045976,
	[348676] = 3096511,
	[348747] = 3448136,
	[349515] = 3448141,
	[349565] = 3597238,
	[349612] = 3756062,
	[349792] = 1662185,
	[349793] = 3607333,
	[349794] = 3597238,
	[349795] = 191107,
	[349796] = 2123117,
	[349797] = 3546735,
	[349798] = 3607335,
	[350802] = 2123117,
	[350804] = 3036171,
	[350972] = 2432195,
	[350978] = 3522547,
	[351467] = 3036585,
	[351487] = 3597238,
	[351540] = 3597238,
	[351541] = 3597238,
	[351542] = 3597238,
	[351543] = 3597238,
	[351544] = 3597238,
	[351545] = 3597238,
	[351874] = 3166135,
	[351885] = 3166135,
	[351886] = 3166135,
	[351887] = 3166135,
	[351888] = 3166135,
	[351889] = 3166135,
	[351948] = 3597238,
	[351980] = 1254446,
	[352027] = 3045976,
	[352028] = 3045976,
	[352086] = 3621781,
	[352181] = 3036134,
	[352182] = 3036147,
	[352428] = 2839472,
	[352433] = 3638167,
	[352490] = 3166135,
	[352520] = 3535749,
	[352596] = 973262,
	[352703] = 3528929,
	[352754] = 3189120,
	[352909] = 1301126,
	[353019] = 3189120,
	[353205] = 3189120,
	[353231] = 3621781,
	[353232] = 3595030,
	[353233] = 3522547,
	[353234] = 3189119,
	[353252] = 3189120,
	[353305] = 1053461,
	[353306] = 3033926,
	[353314] = 3189120,
	[353323] = 3033926,
	[353324] = 3033926,
	[353325] = 3189120,
	[353326] = 3033926,
	[353327] = 3033926,
	[353329] = 3033637,
	[353330] = 3033637,
	[353331] = 3033637,
	[353332] = 3033637,
	[353333] = 3033637,
	[353340] = 3533100,
	[353380] = 969764,
	[353472] = 3590187,
	[353484] = 3308580,
	[353500] = 3189120,
	[353503] = 3189120,
	[353516] = 3189120,
	[353626] = 3638167,
	[353627] = 3638167,
	[353643] = 3189120,
	[353645] = 3036573,
	[353650] = 3189119,
	[353681] = 3053305,
	[353683] = 3053305,
	[353684] = 3053305,
	[353685] = 3053305,
	[353686] = 3053305,
	[353687] = 2839472,
	[353688] = 2839471,
	[353689] = 2839470,
	[353691] = 2839471,
	[353791] = 3595030,
	[353792] = 3607335,
	[353793] = 3607334,
	[353796] = 3528929,
	[353797] = 3607336,
	[353799] = 3607333,
	[353868] = 3023915,
	[353869] = 3177104,
	[353870] = 3023914,
	[353871] = 3023913,
	[353872] = 3095805,
	[353873] = 3095806,
	[353874] = 3158888,
	[353876] = 2994771,
	[353940] = 3189119,
	[353941] = 3189119,
	[353942] = 3189119,
	[353943] = 3189119,
	[353944] = 3189119,
	[353948] = 3535749,
	[353949] = 3535749,
	[354075] = 3152067,
	[354108] = 878854,
	[354109] = 878854,
	[354110] = 878854,
	[354111] = 878854,
	[354112] = 878854,
	[354113] = 878854,
	[354114] = 878854,
	[354115] = 1306557,
	[354116] = 1306556,
	[354121] = 1254446,
	[354122] = 1255202,
	[354123] = 987264,
	[354175] = 3189119,
	[354186] = 878854,
	[354187] = 878854,
	[354188] = 878854,
	[354189] = 878854,
	[354190] = 878854,
	[354191] = 878854,
	[354192] = 878854,
	[354193] = 878854,
	[354202] = 3023914,
	[354208] = 3189120,
	[354211] = 3595030,
	[354213] = 3045971,
	[354214] = 1019643,
	[354275] = 3197319,
	[354283] = 3045972,
	[354284] = 3045975,
	[354285] = 3022977,
	[354286] = 3045972,
	[354287] = 3045975,
	[354288] = 3022977,
	[354289] = 3040704,
	[354467] = 3022977,
	[354645] = 977074,
	[354646] = 975361,
	[354647] = 199704,
	[354648] = 2029167,
	[354649] = 3189119,
	[354650] = 3255405,
	[354651] = 3036126,
	[354652] = 3036103,
	[354662] = 3522547,
	[354852] = 973262,
	[354853] = 973262,
	[354856] = 3193905,
	[354911] = 3158888,
	[355000] = 3522548,
	[355019] = 242891,
	[355020] = 3522514,
	[355021] = 3036109,
	[355035] = 3036549,
	[355037] = 3036549,
	[355038] = 3036549,
	[355040] = 3603419,
	[355041] = 3546657,
	[355048] = 3603419,
	[355049] = 3603419,
	[355194] = 3603417,
	[355195] = 3603417,
	[355196] = 3603417,
	[355286] = 3189120,
	[355296] = 3166135,
	[355355] = 3522548,
	[355435] = 3522133,
	[355449] = 3189119,
	[355798] = 3166684,
	[355865] = 3486912,
	[355872] = 3193912,
	[355880] = 3084156,
	[355886] = 3638167,
	[355947] = 3638167,
	[355971] = 3685406,
	[355980] = 3638167,
	[356535] = 3638167,
	[356555] = 3148980,
	[356693] = 3621781,
	[356697] = 3621781,
	[356700] = 3621781,
	[356705] = 3621781,
	[356709] = 3522547,
	[356712] = 3522547,
	[356716] = 3522547,
	[356720] = 3522547,
	[356725] = 3189119,
	[356728] = 3189119,
	[356733] = 3189119,
	[356737] = 3189119,
	[356741] = 3595030,
	[356744] = 3595030,
	[356748] = 3595030,
	[356752] = 3595030,
	[356757] = 3595030,
	[356818] = 2994771,
	[356820] = 3053305,
	[356823] = 3189120,
	[357228] = 3597238,
	[357229] = 3597238,
	[357230] = 3597238,
	[357231] = 3597238,
	[357232] = 3597238,
	[357233] = 3597238,
	[357234] = 3597238,
	[357235] = 3597238,
	[357236] = 3597238,
	[357237] = 3597238,
	[357238] = 3597238,
	[357246] = 3036568,
	[357467] = 3152071,
	[357487] = 3641682,
	[357515] = 1709134,
	[357526] = 1709139,
	[357541] = 929369,
	[357565] = 243299,
	[357572] = 3502045,
	[357584] = 3685406,
	[357683] = 3056785,
	[357697] = 3595030,
	[357726] = 979112,
	[357758] = 194845,
	[357771] = 3522548,
	[357937] = 3597238,
	[358298] = 3597238,
	[358315] = 1064149,
	[358318] = 3152066,
	[358319] = 1331239,
	[358382] = 3756062,
	[358398] = 3533100,
	[358399] = 3607333,
	[358531] = 200135,
	[358533] = 3450717,
	[358855] = 534613,
	[360054] = 3730958,
	[362489] = 3045977,
	[364345] = 3486892,
	[364483] = 3036556,
	[364899] = 3270074,
	[364926] = 3579718,
	[364932] = 3642574,
	[364937] = 1664985,
	[364987] = 382931,
	[364994] = 1634862,
	[365084] = 3677220,
	[365093] = 576349,
	[368205] = 3677216,
	[368206] = 3677216,
	[368207] = 3677216,
	[368208] = 3677216,
	[368213] = 3677216,
	[368214] = 3677216,
	[368645] = 3677216,
	[368646] = 3677216,
	[368648] = 3677216,
	[368649] = 3677216,
	[368650] = 3677216,
	[368653] = 3677218,
	[368663] = 3036719,
	[368665] = 3566592,
	[368666] = 3605056,
	[368667] = 3036717,
	[368668] = 3566594,
	[368772] = 3836244,
	[368876] = 3677216,
	[368935] = 3677218,
	[368946] = 3993862,
	[368948] = 3993862,
	[368949] = 3993862,
	[368950] = 3993862,
	[368951] = 3993862,
	[368952] = 3993862,
	[368953] = 3993862,
	[369129] = 3718234,
	[369132] = 3677216,
	[369133] = 3609723,
	[369134] = 3677218,
	[369135] = 3609723,
	[369138] = 3609723,
	[369141] = 3677216,
	[369143] = 797815,
	[369144] = 970210,
	[369145] = 3677216,
	[369148] = 3022959,
	[369149] = 4037308,
	[369172] = 3836262,
	[369183] = 1605420,
	[369185] = 4093879,
	[369194] = 1281115,
	[369204] = 3670966,
	[369216] = 3677216,
	[369224] = 249606,
	[369225] = 3846066,
	[369227] = 3993862,
	[369232] = 3998009,
	[369234] = 970206,
	[369235] = 3993862,
	[369236] = 3993862,
	[369245] = 4093879,
	[369292] = 3189120,
	[369294] = 3189120,
	[369295] = 3036605,
	[369296] = 4052078,
	[369297] = 3036603,
	[369304] = 4093879,
	[369327] = 3943696,
	[369329] = 3943696,
	[369330] = 3943696,
	[369331] = 3943696,
	[369332] = 3943696,
	[369333] = 1003213,
	[369334] = 1003213,
	[369335] = 1003213,
	[369336] = 1003213,
	[369337] = 1003213,
	[369339] = 3677216,
	[369340] = 4093879,
	[369341] = 3677216,
	[369432] = 3533100,
	[369437] = 3677216,
	[369438] = 3677216,
	[369439] = 3677216,
	[369440] = 3677216,
	[369602] = 3036572,
	[369757] = 1711483,
	[369893] = 1331239,
	[369894] = 1331239,
	[370140] = 4261540,
	[370469] = 949217,
	[370494] = 4248045,
	[373437] = 219406,
	[373438] = 376277,
	[373439] = 219406,
	[373460] = 3489771,
	[373471] = 4248046,
	[373472] = 4248047,
	[373473] = 4248048,
	[373474] = 4248049,
	[373543] = 4196523,
	[373548] = 4198154,
	[373553] = 4196518,
	[373561] = 4196523,
	[373562] = 4198153,
	[373563] = 4198153,
	[373568] = 4196523,
	[373579] = 4039282,
	[373580] = 4198153,
	[373581] = 4198153,
	[373582] = 4198153,
	[373583] = 4198153,
	[373584] = 4198153,
	[373585] = 4198153,
	[373586] = 4198153,
	[373587] = 4198153,
	[373588] = 4198153,
	[374976] = 4196523,
	[375021] = 353152,
	[375058] = 4248045,
	[375059] = 4248046,
	[375060] = 4248047,
	[375061] = 4248048,
	[375062] = 4248049,
	[375064] = 4248045,
	[375066] = 4248046,
	[375067] = 4248047,
	[375068] = 4248048,
	[375069] = 4248049,
	[375188] = 4081526,
	[375189] = 4081527,
	[375190] = 4081530,
	[375191] = 4081531,
	[375192] = 4081535,
	[375234] = 4572361,
	[375235] = 4572358,
	[375238] = 4572359,
	[375239] = 4572360,
	[375240] = 4572362,
	[375241] = 4498019,
	[375242] = 4498019,
	[375243] = 4498019,
	[375244] = 4498019,
	[375245] = 4498019,
	[375246] = 4498020,
	[375270] = 4196520,
	[375272] = 3677216,
	[375281] = 3925326,
	[375283] = 3923426,
	[375290] = 4196523,
	[375354] = 3677216,
	[375362] = 1003213,
	[375363] = 3677216,
	[375366] = 915963,
	[375368] = 3923426,
	[375369] = 3846065,
	[375370] = 4196520,
	[375371] = 4196520,
	[375373] = 4201719,
	[375376] = 4198154,
	[375382] = 4261537,
	[375383] = 4196520,
	[375387] = 4196520,
	[375388] = 4196520,
	[375389] = 4196520,
	[375390] = 4196520,
	[375391] = 4196520,
	[375393] = 4196520,
	[375396] = 4370753,
	[375397] = 4370753,
	[375398] = 4370753,
	[375399] = 4370753,
	[375400] = 4370753,
	[375401] = 4370753,
	[375402] = 4370753,
	[375403] = 4254628,
	[375404] = 4196523,
	[375405] = 4039279,
	[375408] = 4196523,
	[375411] = 4228011,
	[375413] = 3920034,
	[375422] = 4201284,
	[375423] = 3925326,
	[375478] = 4274744,
	[375479] = 4196520,
	[375481] = 4039287,
	[375483] = 3836264,
	[375484] = 4261537,
	[375485] = 4238675,
	[375486] = 4196520,
	[375492] = 4196523,
	[375493] = 4201286,
	[375494] = 3527748,
	[375495] = 4039277,
	[375496] = 4201288,
	[375498] = 4196520,
	[375502] = 4196520,
	[375516] = 1950289,
	[375517] = 4210792,
	[375530] = 4196523,
	[375536] = 3920034,
	[375538] = 3527748,
	[375668] = 4216698,
	[375693] = 4196520,
	[375694] = 4196520,
	[375746] = 4196520,
	[375748] = 4196520,
	[375889] = 4196520,
	[375893] = 3920034,
	[375900] = 4196520,
	[375902] = 1503243,
	[375903] = 4196520,
	[375905] = 4196520,
	[375907] = 4196520,
	[375915] = 4176991,
	[375950] = 4176996,
	[375972] = 3836252,
	[375973] = 3836262,
	[375974] = 1687825,
	[375981] = 4196520,
	[375982] = 3836262,
	[375983] = 3836262,
	[375984] = 3836262,
	[375985] = 3836262,
	[375986] = 3836262,
	[375987] = 3836262,
	[375988] = 3836262,
	[376041] = 4196523,
	[376123] = 4240484,
	[376124] = 2737661,
	[376175] = 2123117,
	[376213] = 3036134,
	[376325] = 4209026,
	[376386] = 4539374,
	[376416] = 1091591,
	[376426] = 3189120,
	[376451] = 243239,
	[376578] = 4323481,
	[376580] = 970435,
	[376581] = 4299070,
	[376582] = 1602426,
	[376583] = 1702787,
	[376587] = 936417,
	[376657] = 511490,
	[376757] = 199426,
	[377114] = 4392564,
	[377233] = 4216698,
	[377317] = 1255019,
	[377458] = 4216978,
	[377466] = 4570246,
	[377485] = 960848,
	[377499] = 4298560,
	[377534] = 4216697,
	[377899] = 970227,
	[377900] = 4182555,
	[377938] = 219406,
	[378010] = 4216697,
	[378047] = 4216698,
	[378054] = 304638,
	[378088] = 1728502,
	[378820] = 1634604,
	[378857] = 4216697,
	[379168] = 970206,
	[379248] = 4572353,
	[379252] = 4572357,
	[379263] = 4572358,
	[379267] = 4572357,
	[379272] = 4572367,
	[379290] = 4329224,
	[379296] = 197735,
	[379297] = 903296,
	[379314] = 984224,
	[379321] = 659571,
	[380429] = 202801,
	[380430] = 982123,
	[380457] = 984595,
	[380516] = 166027,
	[380518] = 1282673,
	[380533] = 1391790,
	[380540] = 4524394,
	[380545] = 1572186,
	[380547] = 3936820,
	[380548] = 4551450,
	[380549] = 1284871,
	[380550] = 949619,
	[380554] = 850520,
	[380556] = 3189120,
	[380558] = 1104884,
	[380559] = 3489760,
	[380560] = 511490,
	[380567] = 1551359,
	[380569] = 1058986,
	[380570] = 4326554,
	[380571] = 985369,
	[380577] = 3489761,
	[380578] = 4298560,
	[380579] = 4235856,
	[380580] = 4034982,
	[380583] = 978650,
	[380585] = 1383944,
	[380586] = 124639,
	[380587] = 4078325,
	[380588] = 4034269,
	[380589] = 1097912,
	[380590] = 4659624,
	[380591] = 4320282,
	[380592] = 4559315,
	[380593] = 3936818,
	[380595] = 968422,
	[380597] = 4621382,
	[380598] = 446673,
	[380600] = 4632572,
	[380601] = 191029,
	[380602] = 4182544,
	[380604] = 429167,
	[380605] = 892753,
	[380607] = 3285008,
	[380608] = 915959,
	[380610] = 4485599,
	[380611] = 4198215,
	[380612] = 3756062,
	[380615] = 936417,
	[380616] = 1118052,
	[380617] = 1063236,
	[380618] = 4510771,
	[380619] = 3036730,
	[380620] = 4621370,
	[380623] = 3036732,
	[380643] = 4623329,
	[380647] = 4298563,
	[380648] = 4298563,
	[380652] = 4609986,
	[380653] = 4636941,
	[380654] = 3738612,
	[380709] = 929403,
	[380763] = 4498653,
	[380822] = 1383908,
	[380840] = 4561104,
	[380842] = 916363,
	[380843] = 4575531,
	[380847] = 1383923,
	[380859] = 4615240,
	[380860] = 4559315,
	[380867] = 193425,
	[380902] = 3756062,
	[380918] = 4609987,
	[380963] = 3847951,
	[380991] = 189528,
	[381035] = 4641229,
	[381045] = 4618714,
	[381065] = 367743,
	[381069] = 984224,
	[381071] = 950860,
	[381094] = 4504448,
	[381104] = 4612264,
	[381105] = 4612263,
	[381106] = 4612269,
	[381107] = 2059166,
	[381108] = 936411,
	[381110] = 4551449,
	[381153] = 202146,
	[381154] = 4546834,
	[381157] = 1332822,
	[381158] = 4064183,
	[381160] = 4323282,
	[381196] = 4546834,
	[381197] = 4546834,
	[381198] = 4546836,
	[381199] = 4546834,
	[381200] = 4546834,
	[381201] = 4558389,
	[381202] = 4558389,
	[381203] = 4558389,
	[381204] = 4558389,
	[381205] = 4558389,
	[381207] = 4558389,
	[381210] = 4537051,
	[381211] = 4537051,
	[381212] = 4537264,
	[381213] = 4537051,
	[381214] = 4537051,
	[381216] = 4323298,
	[381223] = 4551451,
	[381277] = 3917374,
	[381296] = 337611,
	[381297] = 315395,
	[381336] = 4209027,
	[381340] = 4209028,
	[381341] = 4209028,
	[381343] = 4209026,
	[381353] = 442505,
	[381354] = 536712,
	[381355] = 4278345,
	[381356] = 196146,
	[381357] = 1726753,
	[381358] = 1726753,
	[381359] = 1726753,
	[381361] = 192713,
	[381362] = 190028,
	[381365] = 4198200,
	[381367] = 4198200,
	[381369] = 4198200,
	[381370] = 4198200,
	[381373] = 4198200,
	[381375] = 4198200,
	[381377] = 4198200,
	[381483] = 647739,
	[381484] = 4093782,
	[381485] = 1089856,
	[381510] = 774343,
	[381511] = 893046,
	[381512] = 251568,
	[381513] = 1634862,
	[381514] = 304693,
	[381515] = 4612264,
	[381516] = 4612264,
	[381517] = 4612264,
	[381518] = 4612264,
	[381519] = 4612264,
	[381575] = 4182522,
	[381579] = 4268252,
	[381584] = 4198205,
	[381650] = 4198204,
	[381653] = 4252961,
	[381661] = 4268252,
	[381662] = 4198205,
	[381663] = 965217,
	[381664] = 4198204,
	[381667] = 4198205,
	[381668] = 4268252,
	[381669] = 4198205,
	[381670] = 4198205,
	[381671] = 4268252,
	[381672] = 4268252,
	[381687] = 936413,
	[381691] = 4298558,
	[381701] = 4198205,
	[381705] = 4209027,
	[381706] = 4209028,
	[381707] = 4209026,
	[381708] = 4209024,
	[381709] = 4209028,
	[381711] = 4209028,
	[381712] = 4299070,
	[381713] = 4209027,
	[381715] = 4209026,
	[381718] = 4209026,
	[381722] = 4209027,
	[381730] = 4209027,
	[381731] = 4209026,
	[381732] = 4209026,
	[381733] = 4209028,
	[381734] = 4209028,
	[381735] = 4209027,
	[381736] = 4209026,
	[381957] = 4498021,
	[381958] = 4546835,
	[381959] = 4558390,
	[381960] = 4537107,
	[381964] = 4627222,
	[381981] = 4299070,
	[381983] = 4627222,
	[381985] = 4627222,
	[381987] = 4627222,
	[381989] = 4627222,
	[381991] = 4627222,
	[381993] = 4627222,
	[381995] = 4627222,
	[381997] = 4627222,
	[381999] = 4627222,
	[382001] = 4627222,
	[382003] = 4627222,
	[382029] = 4539376,
	[382071] = 984224,
	[382079] = 4198200,
	[382086] = 4198200,
	[382092] = 4198200,
	[382094] = 4198200,
	[382101] = 4198200,
	[382103] = 4198200,
	[382105] = 4198200,
	[382107] = 4198200,
	[382110] = 4198200,
	[382112] = 4198200,
	[382116] = 4198200,
	[382118] = 4198200,
	[382120] = 4198200,
	[382166] = 4317329,
	[382180] = 219405,
	[382193] = 4216697,
	[382195] = 4216698,
	[382325] = 3532362,
	[382621] = 3998636,
	[383625] = 3857154,
	[383660] = 4320282,
	[383732] = 3857149,
	[383733] = 4539377,
	[383734] = 4539375,
	[383735] = 4539379,
	[384311] = 4323821,
	[384312] = 4337372,
	[384313] = 4323822,
	[384317] = 1391790,
	[384318] = 4324473,
	[384370] = 203402,
	[384405] = 4575536,
	[384653] = 4323821,
	[384654] = 4337372,
	[384744] = 5064153,
	[384763] = 4216697,
	[384980] = 4216698,
	[385001] = 950119,
	[385008] = 167196,
	[385010] = 167196,
	[385021] = 4214533,
	[385022] = 1664285,
	[385028] = 4240491,
	[385032] = 4217886,
	[385064] = 3998034,
	[385074] = 1711483,
	[385075] = 4323482,
	[385396] = 4631398,
	[385398] = 4216698,
	[385401] = 4216698,
	[385415] = 1265380,
	[385467] = 1265380,
	[385468] = 1265380,
	[385469] = 1265380,
	[385520] = 1265380,
	[385533] = 4235619,
	[385565] = 4631398,
	[385581] = 977074,
	[385584] = 4209026,
	[385585] = 4209027,
	[385586] = 4209028,
	[385799] = 4216698,
	[385800] = 4217886,
	[385801] = 4217887,
	[385802] = 4217886,
	[385826] = 4323481,
	[385830] = 4235619,
	[385831] = 4235619,
	[385832] = 4235619,
	[385834] = 4317329,
	[385835] = 4317329,
	[385836] = 4317329,
	[385837] = 4317329,
	[385917] = 4627222,
	[385919] = 4627222,
	[385921] = 4627222,
	[385937] = 4323481,
	[385940] = 197622,
	[385952] = 3718234,
	[385958] = 3936818,
	[385961] = 3936818,
	[386079] = 4216698,
	[386080] = 970204,
	[386083] = 4703525,
	[386086] = 4703525,
	[386088] = 4034955,
	[386089] = 4034955,
	[386090] = 4034955,
	[386091] = 4034955,
	[386104] = 1981374,
	[386106] = 4198200,
	[386108] = 4198200,
	[386123] = 4214533,
	[386138] = 3936818,
	[386139] = 3936818,
	[386140] = 4070769,
	[386157] = 4070769,
	[386158] = 4070769,
	[386168] = 2833918,
	[386353] = 4216698,
	[386354] = 4216698,
	[386421] = 4631398,
	[386422] = 4631398,
	[386423] = 4631398,
	[386424] = 4216698,
	[386425] = 4216698,
	[386426] = 4631398,
	[386427] = 875637,
	[386428] = 4631398,
	[386429] = 4631398,
	[386430] = 4216698,
	[386431] = 4631398,
	[386432] = 4216698,
	[386433] = 4631398,
	[386441] = 4631398,
	[386442] = 4631398,
	[386443] = 4631398,
	[386444] = 4631398,
	[386445] = 4631398,
	[386447] = 4631398,
	[386450] = 4631398,
	[386451] = 4216698,
	[386452] = 1711483,
	[386453] = 4216698,
	[386454] = 253441,
	[386455] = 1096610,
	[386456] = 1096610,
	[386457] = 253441,
	[386458] = 4631398,
	[386459] = 4631398,
	[386460] = 4631398,
	[386461] = 4631398,
	[386462] = 4631398,
	[386463] = 4631398,
	[386470] = 4217887,
	[386472] = 4217886,
	[386484] = 4217885,
	[386531] = 4217887,
	[386532] = 4631398,
	[386547] = 4995951,
	[386555] = 1319079,
	[386556] = 4298410,
	[386559] = 4216698,
	[386573] = 2833918,
	[386578] = 916363,
	[386579] = 916363,
	[386580] = 916363,
	[386581] = 916363,
	[386582] = 916363,
	[386583] = 916363,
	[386585] = 2828327,
	[386586] = 1572190,
	[386587] = 1572128,
	[386588] = 875120,
	[386589] = 875124,
	[386591] = 1608205,
	[386604] = 4631398,
	[386605] = 4217887,
	[386632] = 334368,
	[386633] = 2839405,
	[386648] = 1365486,
	[386660] = 4217885,
	[386668] = 2027712,
	[386669] = 1305203,
	[386680] = 4298560,
	[386683] = 4298558,
	[386687] = 4298558,
	[386688] = 4298560,
	[386690] = 4298558,
	[386762] = 4631398,
	[387493] = 4035893,
	[387496] = 200934,
	[387500] = 125984,
	[387501] = 916363,
	[387503] = 576627,
	[387507] = 1989486,
	[387508] = 4060923,
	[387520] = 936419,
	[387695] = 3936818,
	[387696] = 3936818,
	[387697] = 3936818,
	[387718] = 4070769,
	[387719] = 4070769,
	[387720] = 4070769,
	[387721] = 4070769,
	[387722] = 4070769,
	[387725] = 1383974,
	[387727] = 975539,
	[387728] = 4298562,
	[387729] = 202145,
	[387736] = 244162,
	[387737] = 198017,
	[387746] = 4631398,
	[387749] = 3730985,
	[387853] = 202125,
	[388471] = 4631398,
	[388712] = 1602486,
	[388866] = 4620935,
	[388873] = 1602312,
	[388876] = 4620933,
	[388895] = 4324473,
	[388896] = 4323481,
	[388905] = 984686,
	[388908] = 2851157,
	[388911] = 953811,
	[389102] = 1572190,
	[389103] = 1572190,
	[389104] = 1572128,
	[389105] = 1572128,
	[389106] = 1572190,
	[389107] = 1572190,
	[389108] = 1572190,
	[389111] = 1634928,
	[389114] = 2123117,
	[389173] = 4631398,
	[389231] = 4631398,
	[389471] = 4631398,
	[389540] = 2851157,
	[389545] = 4216698,
	[389546] = 4620935,
	[389564] = 2851157,
	[389599] = 3998034,
	[389789] = 4631398,
	[389902] = 4631398,
	[390008] = 3998034,
	[390009] = 950860,
	[390074] = 4631398,
	[390136] = 973262,
	[390137] = 5091197,
	[390138] = 5091194,
	[390139] = 5091436,
	[390140] = 5091440,
	[390141] = 5091442,
	[390142] = 5091434,
	[390257] = 197845,
	[390258] = 2851157,
	[390559] = 950860,
	[390560] = 4216698,
	[392025] = 792965,
	[392026] = 792965,
	[392030] = 4095171,
	[392031] = 4070769,
	[392032] = 4070769,
	[392335] = 4631398,
	[392569] = 4631398,
	[392570] = 4631398,
	[392571] = 4216698,
	[392572] = 4216698,
	[392573] = 4216698,
	[392580] = 2439479,
	[392581] = 985362,
	[392582] = 2967732,
	[392583] = 1711483,
	[392587] = 2829936,
	[392591] = 4631398,
	[392593] = 2067200,
	[393218] = 4631398,
	[393220] = 4631398,
	[393221] = 4620933,
	[393222] = 2579334,
	[393282] = 979397,
	[393283] = 979397,
	[393957] = 4217887,
	[393958] = 4217886,
	[396019] = 4621388,
	[396020] = 4621388,
	[396339] = 4182533,
	[398133] = 999889,
	[398135] = 999890,
	[398138] = 2902889,
	[398200] = 2579334,
	[398674] = 4298587,
	[398698] = 960856,
	[398751] = 5091435,
	[398752] = 5091443,
	[398753] = 5091439,
	[398754] = 5091441,
	[398755] = 5091434,
	[398756] = 5091442,
	[398758] = 5091440,
	[398759] = 5091434,
	[398760] = 5091442,
	[398761] = 5091436,
	[398762] = 5091440,
	[398764] = 5091434,
	[398765] = 5091442,
	[398766] = 5091436,
	[398767] = 5091440,
	[398770] = 950860,
	[398778] = 343863,
	[398783] = 4034955,
	[398785] = 4576985,
	[398786] = 167196,
	[398787] = 167196,
	[398788] = 167196,
	[398789] = 167196,
	[398790] = 167196,
	[398791] = 950751,
	[398793] = 1052605,
	[398794] = 4556623,
	[398796] = 4563732,
	[398810] = 4631398,
	[398814] = 4631398,
	[398815] = 4216698,
	[398828] = 953811,
	[401236] = 4620929,
	[401238] = 2851157,
	[401240] = 4278333,
	[401241] = 1275568,
	[401292] = 365229,
	[401299] = 392110,
	[401828] = 4323481,
	[401839] = 4216698,
	[401844] = 1255023,
	[401845] = 4539378,
	[401846] = 1806318,
	[402578] = 3656493,
	[402609] = 607277,
	[402627] = 4689413,
	[402632] = 616368,
	[402634] = 4227589,
	[402841] = 4094539,
	[402868] = 4417702,
	[402878] = 878856,
	[402887] = 4034267,
	[402888] = 4420699,
	[402890] = 4324473,
	[402892] = 4298560,
	[403458] = 304794,
	[403498] = 198038,
	[403532] = 1709140,
	[403533] = 1331240,
	[403534] = 199408,
	[403535] = 305398,
	[403536] = 197943,
	[403541] = 244253,
	[403552] = 774346,
	[403567] = 589980,
	[403702] = 936411,
	[403703] = 936411,
	[403704] = 936411,
	[403705] = 936411,
	[403706] = 936411,
	[403707] = 936411,
	[403708] = 936411,
	[403709] = 936411,
	[403710] = 936411,
	[403711] = 936411,
	[403712] = 936411,
	[403713] = 936411,
	[403714] = 936411,
	[403715] = 936411,
	[403716] = 936411,
	[403717] = 936411,
	[403722] = 1355527,
	[403731] = 191177,
	[403786] = 955870,
	[403919] = 2067174,
	[403962] = 929345,
	[404232] = 1119699,
	[404242] = 244162,
	[404260] = 3936818,
	[404314] = 194086,
	[404319] = 83906,
	[404337] = 526102,
	[404432] = 1005455,
	[404480] = 615295,
	[404492] = 4298410,
	[404849] = 4532354,
	[404981] = 526102,
	[404982] = 526102,
	[404987] = 526102,
	[404992] = 526102,
	[405009] = 526102,
	[405010] = 526102,
	[405012] = 526102,
	[405068] = 1367406,
	[405286] = 4324473,
	[405388] = 198038,
	[405489] = 4216697,
	[405510] = 897186,
	[405511] = 897186,
	[405512] = 897186,
	[405513] = 194965,
	[405515] = 1321787,
	[405523] = 4209023,
	[405525] = 189528,
	[405526] = 189528,
	[405529] = 193184,
	[405530] = 189528,
	[405531] = 189528,
	[405532] = 189528,
	[405533] = 189528,
	[405534] = 189528,
	[405535] = 189528,
	[405536] = 189528,
	[405537] = 189528,
	[405538] = 189528,
	[405539] = 189528,
	[405540] = 189528,
	[405541] = 189528,
	[405546] = 194083,
	[405584] = 4070769,
	[405585] = 4070769,
	[405586] = 4070769,
	[405587] = 4070769,
	[405593] = 4317329,
	[405943] = 4298589,
	[405958] = 1124091,
	[405996] = 4420700,
	[406383] = 4640540,
	[407186] = 526102,
	[407192] = 526102,
	[407199] = 526102,
	[407201] = 526102,
	[407691] = 84494,
	[407692] = 77402,
	[407739] = 1349622,
	[407862] = 1327218,
	[408060] = 4324473,
	[408076] = 4324473,
	[408079] = 4324473,
	[408080] = 4324473,
	[408081] = 4324473,
	[408082] = 4324473,
	[408083] = 4324473,
	[408107] = 4895040,
	[408224] = 199989,
	[408226] = 65246,
	[408706] = 5247222,
	[408707] = 4255713,
	[408719] = 1982773,
	[408720] = 1982773,
	[408754] = 84854,
	[408767] = 4213278,
	[408860] = 84489,
	[408934] = 877007,
	[408954] = 875132,
	[408964] = 1113720,
	[408976] = 4298558,
	[408980] = 4288162,
	[409012] = 943682,
	[409016] = 943682,
	[409017] = 943682,
	[409018] = 943682,
	[409019] = 943682,
	[409020] = 943682,
	[409077] = 929407,
	[409120] = 5338871,
	[409166] = 4663520,
	[409200] = 4609995,
	[409208] = 4609995,
	[409209] = 4609995,
	[409211] = 4609995,
	[409212] = 4609995,
	[409214] = 4609995,
	[409222] = 3522548,
	[409302] = 4563732,
	[409320] = 4539378,
	[409329] = 4539378,
	[409333] = 4539378,
	[409338] = 4417702,
	[409440] = 189528,
	[409458] = 953811,
	[409835] = 189528,
	[409849] = 4914526,
	[409914] = 2745106,
	[410045] = 5247212,
	[410046] = 5247218,
	[410048] = 5247222,
	[410179] = 189528,
	[410181] = 189528,
	[410395] = 5007025,
	[410426] = 2833934,
	[410434] = 2833934,
	[410442] = 4995252,
	[410456] = 2833991,
	[410458] = 2367468,
	[410459] = 307027,
	[410469] = 2736566,
	[410475] = 1037393,
	[410479] = 3794106,
	[410484] = 2438984,
	[410529] = 1334477,
	[410534] = 1301126,
	[410550] = 202801,
	[410574] = 4290523,
	[410575] = 4508235,
	[410582] = 4507691,
	[410786] = 1367372,
	[410833] = 198017,
	[410994] = 311986,
	[410998] = 949621,
	[410999] = 936413,
	[411065] = 3522548,
	[411066] = 3522548,
	[411067] = 3522548,
	[411102] = 5010352,
	[411104] = 3036605,
	[411106] = 1608338,
	[411168] = 4298558,
	[411169] = 2357389,
	[411170] = 4485591,
	[411171] = 4756260,
	[411176] = 5281468,
	[411177] = 3563973,
	[411179] = 5157472,
	[411180] = 950715,
	[411181] = 4576987,
	[411447] = 1349621,
	[411463] = 1349621,
	[411465] = 1349621,
	[411466] = 1349621,
	[411560] = 4289130,
	[411561] = 4000445,
	[411562] = 4000442,
	[411571] = 4539355,
	[411622] = 5422076,
	[411623] = 5422076,
	[411624] = 5422076,
	[411691] = 4216583,
	[411778] = 1334478,
	[411878] = 1016121,
	[411930] = 4891997,
	[411936] = 4485606,
	[412066] = 3084327,
	[412950] = 202801,
	[412995] = 3917382,
	[413126] = 3917383,
	[413246] = 5486311,
	[413694] = 5348492,
	[413774] = 1124086,
	[413780] = 4861837,
	[413784] = 200904,
	[413787] = 4861836,
	[414113] = 984875,
	[414169] = 902296,
	[414199] = 5348714,
	[414700] = 1709130,
	[415296] = 4252793,
	[415303] = 903887,
	[415584] = 4508235,
	[416310] = 5204694,
	[416401] = 5204672,
	[416448] = 4289130,
	[416450] = 4000442,
	[416950] = 5551464,
	[416954] = 1049487,
	[416968] = 984207,
	[416969] = 4891997,
	[416970] = 5048188,
	[416971] = 1709047,
	[416973] = 5500648,
	[416974] = 424389,
	[417136] = 955720,
	[417137] = 996198,
	[417138] = 959393,
	[417381] = 4070769,
	[419657] = 5204877,
	[419714] = 977078,
	[419729] = 4871099,
	[420019] = 875382,
	[420039] = 875382,
	[420040] = 877007,
	[420053] = 1254446,
	[420195] = 5456991,
	[420722] = 5679909,
	[420730] = 969801,
	[420734] = 1333857,
	[420954] = 204046,
	[421070] = 1982683,
	[421154] = 204049,
	[421179] = 4756260,
	[421180] = 5489255,
	[421181] = 5489281,
	[421182] = 5489269,
	[421183] = 5489282,
	[421184] = 5489286,
	[421185] = 5489285,
	[421186] = 5489284,
	[421338] = 5489283,
	[421339] = 5489270,
	[421360] = 5282331,
	[421525] = 5408470,
	[421555] = 2133380,
	[421592] = 5503818,
	[421594] = 5169958,
	[421597] = 5347569,
	[421599] = 5355794,
	[421718] = 5155018,
	[421735] = 5203126,
	[421736] = 5155017,
	[421740] = 5155016,
	[421909] = 1011653,
	[422560] = 5546879,
	[423581] = 3026077,
	[423596] = 5486311,
	[423602] = 5486311,
	[423603] = 5486311,
	[423612] = 4609985,
	[423688] = 4485607,
	[423714] = 4691400,
	[423854] = 2174093,
	[423958] = 5154231,
	[423959] = 2123117,
	[423971] = 329444,
	[423977] = 5204694,
	[423978] = 5204694,
	[423979] = 5204694,
	[424098] = 5456991,
	[424253] = 4860713,
	[424343] = 5048188,
	[424347] = 1611366,
	[424436] = 5386357,
	[425875] = 4860703,
	[428135] = 4324473,
	[428167] = 4324473,
	[428199] = 4324473,
	[428472] = 2123117,
	[428699] = 5454456,
	[428814] = 5007036,
	[429301] = 5128195,
	[429765] = 2123117,
	[430215] = 5465249,
	[430284] = 5869303,
	[430337] = 5869303,
	[430340] = 5869303,
	[430341] = 5869303,
	[430342] = 5869303,
	[430343] = 5869303,
	[430344] = 5869303,
	[430345] = 5869303,
	[430358] = 5869303,
	[430551] = 5408535,
	[430581] = 1709396,
	[432893] = 5128195,
	[432894] = 5128195,
	[433090] = 3851915,
	[433101] = 5209191,
	[433102] = 5409332,
	[433109] = 5516435,
	[433370] = 341870,
	[433377] = 5154231,
	[433778] = 5128194,
	[433907] = 3166135,
	[434281] = 5869303,
	[434283] = 5869303,
	[434284] = 5869303,
	[434285] = 5869303,
	[434286] = 5869303,
	[434288] = 5869303,
	[434289] = 5869303,
	[434502] = 953811,
	[434554] = 5869303,
	[434560] = 5869303,
	[434561] = 5869303,
	[434563] = 5869303,
	[434564] = 5869303,
	[434565] = 5869303,
	[434566] = 5869303,
	[434567] = 5869303,
	[434568] = 5869303,
	[434861] = 3802901,
	[434924] = 5869303,
	[434925] = 5869303,
	[434926] = 5869303,
	[434927] = 5869303,
	[434928] = 5869303,
	[434929] = 5869303,
	[434930] = 5869303,
	[434932] = 5869303,
	[435008] = 5154231,
	[435009] = 5869303,
	[436933] = 5355799,
	[437025] = 1255023,
	[437060] = 5007034,
	[437112] = 5500648,
	[437195] = 4609985,
	[437205] = 5007038,
	[437216] = 5516443,
	[437389] = 4996091,
	[437726] = 973608,
	[437767] = 5007037,
	[437769] = 4900382,
	[438037] = 5248827,
	[438038] = 5007035,
	[438039] = 5201698,
	[439291] = 5007036,
	[439314] = 5048188,
	[439324] = 5007036,
	[439334] = 5516443,
	[439339] = 5516443,
	[439348] = 5264289,
	[439382] = 5007036,
	[439463] = 5465249,
	[439473] = 4298558,
	[439474] = 4996087,
	[439531] = 4996083,
	[439532] = 5128449,
	[439562] = 1011653,
	[439890] = 5546879,
	[440914] = 4508236,
	[440926] = 4240491,
	[441231] = 4663520,
	[441358] = 198493,
	[441555] = 198493,
	[441563] = 198493,
	[441577] = 198493,
	[441578] = 198493,
	[441585] = 5201700,
	[441586] = 5007028,
	[441587] = 5007037,
	[441588] = 4996086,
	[441638] = 4551443,
	[441723] = 5209192,
	[441795] = 5197114,
	[441797] = 353152,
	[443638] = 3882683,
	[443995] = 1608312,
	[444022] = 1526090,
	[444028] = 5175407,
	[444029] = 4688599,
	[444030] = 5175408,
	[444066] = 4323481,
	[444215] = 1450066,
	[444261] = 200936,
	[444275] = 200936,
	[444276] = 200936,
	[444277] = 200936,
	[444799] = 4681253,
	[444804] = 4681253,
	[444844] = 4182533,
	[444894] = 1146686,
	[445275] = 5545988,
	[445360] = 4621388,
	[446097] = 5319119,
	[446135] = 977074,
	[446362] = 5228461,
	[446363] = 5636642,
	[446420] = 5545988,
	[446435] = 5760601,
	[446437] = 5760602,
	[446438] = 5760603,
	[446495] = 1255023,
	[449528] = 5204877,
	[451442] = 631725,
	[451538] = 1255023,
	[451598] = 4996091,
	[451967] = 197617,
	[451990] = 5869303,
	[451993] = 5128439,
	[452005] = 125420,
	[452438] = 955688,
	[452696] = 5128194,
	[452706] = 3936818,
	[452710] = 4070769,
	[453167] = 5659419,
	[453186] = 5095674,
	[453283] = 5154231,
	[453359] = 5387323,
	[453374] = 4681253,
	[453716] = 5007036,
	[453741] = 5154231,
	[453749] = 5334701,
	[453751] = 5334700,
	[453752] = 5334701,
	[453753] = 5334702,
	[453754] = 5387324,
	[453755] = 5334703,
	[453937] = 5334700,
	[454021] = 5869303,
	[454023] = 5869303,
	[454024] = 5869303,
	[454037] = 5048188,
	[454038] = 5048188,
	[454039] = 5048188,
	[454049] = 5128194,
	[454090] = 5128194,
	[454091] = 5128194,
	[454092] = 5128194,
	[454093] = 5128194,
	[454094] = 5128194,
	[454176] = 4996086,
	[454189] = 5196330,
	[454200] = 5128194,
	[454201] = 5128194,
	[454202] = 5128194,
	[454207] = 5128194,
	[454313] = 5760596,
	[454316] = 5760596,
	[454318] = 5007036,
	[454320] = 5760596,
	[454321] = 5007036,
	[454323] = 5007036,
	[454327] = 5007036,
	[454328] = 5760596,
	[454330] = 5760596,
	[454331] = 5007036,
	[454332] = 5760596,
	[454334] = 5007036,
	[454335] = 5007025,
	[454336] = 5007025,
	[454337] = 5007036,
	[454338] = 5007025,
	[454339] = 5007036,
	[454340] = 5007036,
	[454342] = 5007036,
	[454343] = 5007027,
	[454344] = 5007027,
	[454346] = 5007036,
	[454348] = 5007027,
	[454350] = 5007027,
	[454404] = 199987,
	[454405] = 199987,
	[454406] = 199983,
	[454407] = 199983,
	[454408] = 199987,
	[454412] = 199987,
	[454414] = 959595,
	[454416] = 199983,
	[454417] = 959595,
	[454418] = 199987,
	[454463] = 5409330,
	[454541] = 5869303,
	[454542] = 5869303,
	[454543] = 5869303,
	[454707] = 1254955,
	[454797] = 5387323,
	[455038] = 5387323,
	[455170] = 4324473,
	[455183] = 5387323,
	[455204] = 1979995,
	[455269] = 3978480,
	[455274] = 3978480,
	[455275] = 3978480,
	[455276] = 3978480,
	[455277] = 3978480,
	[455278] = 3978480,
	[455279] = 5007036,
	[455288] = 3164781,
	[455310] = 936419,
	[455320] = 5007036,
	[455321] = 5007036,
	[455322] = 5007036,
	[455323] = 5007036,
	[455324] = 5007036,
	[455325] = 5007036,
	[455327] = 5007036,
	[455328] = 5007036,
	[455329] = 5007036,
	[455330] = 5007036,
	[455331] = 5007036,
	[455435] = 5007034,
	[455436] = 5007034,
	[455437] = 5007034,
	[455439] = 5007034,
	[455440] = 5007034,
	[455441] = 5007034,
	[455442] = 5007034,
	[455443] = 5007034,
	[455444] = 5007034,
	[455445] = 5007034,
	[455446] = 5007034,
	[455482] = 5128194,
	[455484] = 5128194,
	[455485] = 5128194,
	[455486] = 5128194,
	[455487] = 5128194,
	[455488] = 5128194,
	[455489] = 5128194,
	[455490] = 5128194,
	[455491] = 5128194,
	[455492] = 5128194,
	[455493] = 5128194,
	[455494] = 5128194,
	[455495] = 5128194,
	[455496] = 5128194,
	[455497] = 5128194,
	[455503] = 5128194,
	[455504] = 5128194,
	[455505] = 5128194,
	[455506] = 5128194,
	[455507] = 5128194,
	[455508] = 5128194,
	[455509] = 5128194,
	[455510] = 5128194,
	[455511] = 5128194,
	[455512] = 5128194,
	[455513] = 5128194,
	[455514] = 5128194,
	[455515] = 5128194,
	[455516] = 5128194,
	[455517] = 5128194,
	[455522] = 5128194,
	[455523] = 5128194,
	[455524] = 5128194,
	[455525] = 5128194,
	[455526] = 5128194,
	[455527] = 5128194,
	[455531] = 5128194,
	[455532] = 5128194,
	[455533] = 5128194,
	[455534] = 5128194,
	[455685] = 5409330,
	[455759] = 5936948,
	[455761] = 196999,
	[455768] = 5282318,
	[455795] = 1981372,
	[455890] = 1254955,
	[455914] = 3936818,
	[455938] = 5736938,
	[455939] = 5007038,
	[455940] = 5725602,
	[455941] = 5546875,
	[455942] = 5152461,
	[455943] = 5202158,
	[455944] = 5546875,
	[455945] = 5205910,
	[455947] = 5155026,
	[455949] = 5351166,
	[455967] = 1310395,
	[455970] = 4996085,
	[455971] = 5778208,
	[455972] = 5202153,
	[455973] = 5725602,
	[455974] = 5546876,
	[455975] = 5175545,
	[455976] = 5175546,
	[455977] = 5383286,
	[455978] = 5244652,
	[455979] = 5007027,
	[455980] = 5175545,
	[455981] = 5546880,
	[455982] = 5546882,
	[455983] = 5502808,
	[455984] = 5546880,
	[455985] = 5546881,
	[455995] = 242794,
	[456002] = 1058987,
	[456006] = 1310395,
	[456007] = 4214138,
	[456008] = 929389,
	[456009] = 5364269,
	[456010] = 5152459,
	[456011] = 5549342,
	[456012] = 5152457,
	[456013] = 5152463,
	[456014] = 5175545,
	[456015] = 5204877,
	[456016] = 5280302,
	[456017] = 5199472,
	[456019] = 1310395,
	[456020] = 1240452,
	[456022] = 3305391,
	[456024] = 5203800,
	[456032] = 929401,
	[456036] = 936413,
	[456038] = 305393,
	[456039] = 1331238,
	[456041] = 311987,
	[456061] = 5282318,
	[456581] = 199225,
	[456583] = 955699,
	[456665] = 5306874,
	[456767] = 970251,
	[456820] = 167130,
	[457025] = 315765,
	[457062] = 4323821,
	[457143] = 331512,
	[457156] = 936413,
	[457160] = 936413,
	[457161] = 936413,
	[457168] = 526102,
	[457170] = 526102,
	[457171] = 526102,
	[457172] = 526102,
	[457173] = 526102,
	[457174] = 526102,
	[457176] = 526102,
	[457180] = 526102,
	[457181] = 936413,
	[457182] = 526102,
	[457183] = 526102,
	[457197] = 4496829,
	[457246] = 5154231,
	[457251] = 1715104,
	[457260] = 2123117,
	[457270] = 5154231,
	[457271] = 2123117,
	[457303] = 5869303,
	[459333] = 244062,
	[459368] = 4323481,
	[462417] = 5282318,
	[463104] = 511490,
	[463539] = 5128194,
	[463653] = 5282318,
	[463979] = 5387320,
	[464213] = 1513627,
	[464218] = 576021,
	[464233] = 1806321,
	[464938] = 5128194,
	[465161] = 936411,
	[465183] = 4690413,
	[465208] = 5869303,
	[465234] = 936413,
	[465241] = 4323481,
	[465242] = 4323481,
	[465243] = 4323481,
	[465272] = 331512,
	[465277] = 189528,
	[465294] = 985165,
	[465295] = 4198213,
	[465300] = 1005457,
	[466118] = 936413,
	[466119] = 936413,
	[466120] = 936413,
	[466128] = 1282671,
	[466393] = 353152,
	[466400] = 4008620,
	[466413] = 353152,
	[466420] = 203020,
	[466438] = 5282318,
	[466479] = 2907353,
	[466484] = 2907353,
	[466489] = 2907353,
	[466495] = 2907353,
	[466497] = 2907353,
	[466512] = 877007,
	[466808] = 1702787,
	[466943] = 1269560,
	[466960] = 1349622,
	[466975] = 2745097,
	[467060] = 198143,
	[467064] = 4298558,
	[467075] = 5334402,
	[467083] = 5334402,
	[467191] = 2907352,
	[467293] = 1597754,
	[467305] = 4252799,
	[467329] = 4615240,
	[467334] = 5334402,
	[467336] = 5334402,
	[467337] = 5334402,
	[467338] = 5334402,
	[467339] = 5334402,
	[467342] = 5334402,
	[467351] = 5334402,
	[467403] = 5334402,
	[467489] = 3036555,
	[469327] = 936429,
	[469332] = 1361976,
	[469334] = 1357703,
	[469335] = 3036134,
	[469568] = 199706,
	[469569] = 199708,
	[469573] = 199704,
	[469574] = 199708,
	[469985] = 201047,
	[470229] = 1021411,
	[472068] = 936413,
	[473934] = 200884,
	[473943] = 1103093,
	[474030] = 1611709,
	[474033] = 1121294,
	[474084] = 1140791,
	[474086] = 2261829,
	[474822] = 1402270,
	[475116] = 1068320,
	[475284] = 5205857,
	[475286] = 2736566,
	[476815] = 936413,
	[477098] = 942843,
	[477139] = 196982,
	[477248] = 198022,
	[477366] = 2123117,
	[477605] = 936413,
	[477609] = 936413,
	[477612] = 2459257,
	[478090] = 5282318,
	[485669] = 5409330,
	[487805] = 5409330,
	[487815] = 5409331,
	[487825] = 936429,
	[487847] = 5386357,
	[487851] = 5386357,
	[487855] = 5007022,
	[493375] = 1402270,
	[494475] = 1140790,
	[494499] = 2123117,
	[494923] = 4337371,
	[499127] = 1402264,
	[499466] = 4337371,
	[499551] = 1662886,
	[499620] = 1402270,
	[499862] = 1402270,
	[499863] = 1402270,
	[500407] = 1402270,
	[500682] = 219372,
	[500683] = 446671,
	[500684] = 446673,
	[500685] = 1706189,
	[500686] = 5771275,
	[500688] = 2123117,
	[500689] = 219372,
	[500690] = 446671,
	[505260] = 892744,
	[505503] = 3718225,
	[505504] = 979399,
	[505505] = 984881,
	[505506] = 960872,
	[507120] = 4690953,
}; _.ObjectModels = ObjectModels;

-- Consolidated Object Data
local ALLIANCE_BONFIRES = { 187559,187947,187948,187949,187950,187951,187952,187953,187954,187955,187956,187957,187958,187959,187960,187961,187962,187963,187964,187965,187966,187967,187968,187969,187970,187971,187972,187973,187974,187975,194033,194034,194037,194039,194042,194043,194046,194048,207983,207986,207989,207990,207991,207992,208090,208094,217852,259870,259926,316795,316796,316801 };
local CANDY_BUCKETS = { 189303,190034,190035,190036,190037,190038,190039,190040,190041,190042,190043,190044,190045,190046,190047,190048,190049,190050,190051,190052,190053,190054,190055,190056,190057,190058,190059,190060,190061,190062,190063,190064,190065,190066,190067,190068,190069,190070,190071,190072,190073,190074,190075,190076,190077,190078,190079,190080,190081,190082,190083,190084,190085,190086,190087,190088,190089,190090,190091,190096,190097,190098,190099,190100,190101,190102,190103,190104,190105,190106,190107,190108,190109,190110,190111,190112,190113,190114,190115,190116,191878,191879,191880,191881,191882,191883,192018,194056,194057,194058,194059,194060,194061,194062,194063,194064,194065,194066,194067,194068,194069,194070,194071,194072,194073,194074,194075,194076,194077,194078,194079,194080,194081,194084,194119,208115,208116,208117,208118,208119,208120,208121,208122,208123,208124,208125,208126,208127,208128,208129,208130,208131,208132,208133,208134,208135,208136,208137,208138,208139,208140,208141,208142,208143,208144,208145,208146,208147,208148,208149,208150,208151,208152,208153,208154,208155,208156,208157,208158,208159,208160,208161,208162,208163,208164,208165,208166,208167,208168,208169,208170,208171,208172,208173,208174,208175,208176,208177,208178,208179,208180,208181,208183,215873,215874,215875,215876,215877,215879,215880,215881,215884,215886,215889,215891,215892,215894,215895,215897,215898,215899,215900,215902,215903,215904,215905,215906,215907,215908,215914,215915,243912,251670,251671,251672,316754,316755,401714,401723,401724,401725,401726,401727,401728,401729,401730,401731,401732,401733,401734,401735,401736,401737,401738,401739,401740,401741,401742,401743,401744,401745,401746,401747,401748,401749,401750,401751,401752,401753,401754,401755,401756,401757,407048,464911,464913,464914,464915,464916,464917,464918,464919,464920,464921,464922,464923,464924,464925,464926,464927,464928,464929 };
local HORDE_BONFIRES = { 187564,187914,187916,187917,187919,187920,187921,187922,187923,187924,187925,187926,187927,187928,187929,187930,187931,187932,187933,187934,187935,187936,187937,187938,187939,187940,187941,187942,187943,187944,187945,187946,194032,194035,194036,194038,194040,194044,194045,194049,207982,207984,207985,207987,207988,207993,208089,208093,217851,259871,259927,316788,316791,316793 };
for i,objectID in ipairs(ALLIANCE_BONFIRES) do
	ObjectNames[objectID] = "Alliance Bonfire";
	ObjectIcons[objectID] = 135777;
	ObjectModels[objectID] = 200079;
end
for i,objectID in ipairs(CANDY_BUCKETS) do
	ObjectNames[objectID] = "Candy Bucket";
	ObjectModels[objectID] = 200946;
end
for i,objectID in ipairs(HORDE_BONFIRES) do
	ObjectNames[objectID] = "Horde Bonfire";
	ObjectIcons[objectID] = 135805;
	ObjectModels[objectID] = 200079;
end

-- Phase Database Module
_.PhaseConstants = {
	BLACK_MARKET = 9,
	ELITE_PVP_REQUIREMENT = 4,
	NEVER_IMPLEMENTED = 1,
	REAL_MONEY = 3,
	REMOVED_FROM_GAME = 2,
	TCG = 10,
	UNLEARNABLE = 5,
};
local phases = {
	[1] = {
		name = "Never Implemented [NYI]",
		description = "|cFFFF0000This was never available to players.|r",
		state = 1,
	},
	[2] = {
		name = "Removed From Game",
		description = "|cFFFF0000This has been removed from the game.|r",
		state = 1,
	},
	[3] = {
		name = "Real Money",
		description = "|cFFAAFFAAThis Thing is locked behind a paywall which requires Blizzard Balance or Real Money.|r",
		lore = "|cFFFFAAAAThe act of encouraging the use of real money in any version of the game is widely frowned upon. Participate in this content at your own risk.|r",
		state = 3,
	},
	[4] = {
		name = "PvP Elite/Gladiator",
		description = "|cFFFFAAAAThis can no longer be purchased or unlocked as Transmog unless you have the required PvP Title, required PvP Rating or were in the Top % of that season.|r",
		state = 2,
	},
	[5] = {
		name = "Unlearnable",
		description = "|cFFFFAAAAThis cannot be permanently collected, learned or used for transmog.|r",
		state = 2,
	},
	[6] = {
		name = "Requires Summoning Items",
		description = "|cFFFFAAAAThis is no longer available unless you know someone that has access to the items used to summon the boss.|r",
		lore = "|cFFFFAAAANote: Most Summoning Items can be reobtained if you had them in the past by talking to the respective NPC.|r",
		state = 2,
	},
	[9] = {
		name = "Black Market AH [BMAH]",
		description = "|cFFAAFFAAThis item is available on the Black Market Auction House. The original source may have been removed.|r",
		state = 3,
	},
	[10] = {
		name = "Trading Card Game [TCG]",
		description = "|cFFAAFFAAOriginally obtained via a TCG card that is no longer in print, but may still be available via the Black Market, In-Game, or Real Life Auction House.|r",
		state = 3,
	},
	[38] = {
		name = "Ordos - Legendary Cloak",
		description = "|cFFFFAAAAOnly available to players that completed the Legendary Cloak quest chain during Mists of Pandaria, obtained the Legendary Cloak Appearance during MoP: Remix or via the BMAH.|r",
		state = 2,
	},
};
L.PHASES = phases;

-- Automatic Types
L.ITEM_NAMES = {
	[20946] = "Tactical Task Briefing III",
	[21246] = "Combat Task Briefing I",
	[21247] = "Combat Task Briefing II",
	[202061] = "Step 3: Fill the Barrel",
	[202066] = "Step 4: Keep Filling the Barrel",
	[202069] = "Step 6: Back to the Beginning",
}
L.QUEST_NAMES = {
	[1] = "The \"Chow\" Quest (123)aa",
	[73] = "<TXT> No Reward",
	[137] = "<NYI> <TXT> Stormwind Commendation",
	[241] = "<TEST> HEY MISTER WILSON!",
	[242] = "<UNUSED>",
	[259] = "<UNUSED>",
	[260] = "<UNUSED>",
	[352] = "<UNUSED>",
	[402] = "Sirra is Busy",
	[406] = "<UNUSED>",
	[462] = "<UNUSED>",
	[490] = "<UNUSED>",
	[497] = "<UNUSED>",
	[534] = "<UNUSED>",
	[548] = "[DEPRECATED] <NYI> <TXT> Bloodstone Pendant",
	[612] = "<UNUSED>",
	[636] = "Legends of the Earth <NYI>",
	[708] = "The Black Box",
	[774] = "<UNUSED>",
	[785] = "A Strategic Alliance",
	[787] = "The New Horde",
	[807] = "<UNUSED>",
	[810] = "<UNUSED>",
	[811] = "<UNUSED>",
	[814] = "<UNUSED>",
	[820] = "<UNUSED>",
	[839] = "<UNUSED>",
	[856] = "<UNUSED>",
	[908] = "Amongst the Ruins",
	[912] = "Stonesplinter Trogg Disguise",
	[946] = "<UNUSED>",
	[988] = "<UNUSED>",
	[989] = "<UNUSED>",
	[999] = "When Dreams Turn to Nightmares",
	[1005] = "What Lurks Beyond",
	[1006] = "What Lies Beyond",
	[1099] = "Goblins Win!",
	[1127] = "Fool's Stout",
	[1155] = "<NYI> <TXT> bug crystal side quest",
	[1156] = "<NYI> <TXT> speak to alchemist pestlezugg",
	[1157] = "<NYI> <TXT> pestlezugg needs items",
	[1158] = "<NYI> <TXT> speak to rabine saturna",
	[1161] = "<NYI> <TXT> gossip shade of ambermoon",
	[1162] = "<NYI> <TXT> speak to hamuul runetotem",
	[1163] = "<NYI> <TXT> speak to tyrande whisperwind",
	[1174] = "Gnomes Win!",
	[1263] = "The Burning Inn <CHANGE TO GOSSIP>",
	[1272] = "Finding Reethe <CHANGE INTO GOSSIP>",
	[1277] = "<nyi> <TXT> The Centaur Hoofprints",
	[1278] = "<nyi> <TXT> The Grim Totem Clan",
	[1279] = "<nyi> <TXT>The Centaur Hoofprints",
	[1280] = "<nyi> <TXT>The Centaur Hoofprints",
	[1281] = "Jim's Song <CHANGE TO GOSSIP>",
	[1283] = "Fire at the Shady Rest <CHANGE TO GOSSIP>",
	[1288] = "<nyi> Vimes's Report",
	[1289] = "<nyi> Vimes's Report",
	[1290] = "<nyi> Investigating Mosarn",
	[1291] = "<nyi> <TXT> Centaur Hoofprints",
	[1292] = "<nyi><TXT> Centaur Hoofprints",
	[1293] = "<nyi> <TXT> Centaur Hoofprints",
	[1294] = "<nyi> <TXT>Centaur Sympathies",
	[1295] = "<nyi> <TXT> Course of Action",
	[1296] = "<nyi> <TXT> Course of Action",
	[1297] = "<nyi> <TXT> Course of Action",
	[1298] = "<nyi> <TXT> Thrall's Dirty Work",
	[1299] = "<nyi> <TXT> Thrall's Dirty Work",
	[1300] = "<nyi> <TXT> Lorn Grim Totem",
	[1318] = "Unfinished Gordok Business",
	[1390] = "<nyi> Oops, We Killed Them Again.",
	[1397] = "<nyi> Saved!",
	[1441] = "<UNUSED>",
	[1443] = "<nyi> The Shakedown",
	[1460] = "<UNUSED>",
	[1461] = "<UNUSED>",
	[1500] = "Waking Naralex",
	[1533] = "<NYI> Call of Air",
	[1537] = "<NYI> Call of Air",
	[1538] = "<NYI> Call of Air",
	[1659] = "<UNUSED>",
	[1660] = "<UNUSED>",
	[1662] = "<UNUSED>",
	[1663] = "<UNUSED>",
	[1664] = "<UNUSED>",
	[2000] = "Rokar Bladeshadow",
	[2018] = "Rokar's Test",
	[2019] = "Tools of the Trade",
	[2020] = "<UNUSED>",
	[2058] = "<UNUSED>",
	[2059] = "<UNUSED>",
	[2868] = "<TXT> The Shriveled Heart",
	[2971] = "<UNUSED>",
	[3023] = "<UNUSED>",
	[3064] = "<NYI> <TXT> Pirate Hats",
	[3111] = "<UNUSED> [DEPRECATED]",
	[3241] = "<NYI> <TXT><redux> Dreadmist Peak",
	[3383] = "<UNUSED>",
	[3384] = "<UNUSED>",
	[3401] = "<UNUSED>",
	[3403] = "<UNUSED>",
	[3404] = "<UNUSED>",
	[3405] = "<UNUSED>",
	[3422] = "<UNUSED>",
	[3423] = "<UNUSED>",
	[3424] = "<UNUSED>",
	[3425] = "<UNUSED>",
	[3482] = "<NYI> <TXT> The Pocked Black Box",
	[3515] = "<UNUSED>",
	[3516] = "<UNUSED>",
	[3529] = "<UNUSED>",
	[3530] = "<UNUSED>",
	[3531] = "<UNUSED>",
	[3622] = "<UNUSED>",
	[3623] = "<UNUSED>",
	[3624] = "<UNUSED>",
	[3885] = "<NYI> <TXT> The Gadgetzan Run",
	[3910] = "<NYI> <TXT> The Un'Goro Run",
	[4299] = "<NYI> <TXT>The Tomb of the Seven",
	[4323] = "<NYI> <TXT> Get those Hyenas!!!",
	[4541] = "<NYI> <TXT>",
	[4905] = "<UNUSED>",
	[5101] = "Lee's Ultimate Test Quest... of Doom!",
	[5205] = "<UNUSED>",
	[5207] = "<NYI> <TXT> The True Summoner",
	[5208] = "<NYI> <TXT> The Blessing of Evil",
	[5209] = "<UNUSED>",
	[5303] = "<UNUSED>",
	[5304] = "<UNUSED>",
	[5383] = "Krastinov's Bag of Horrors",
	[5506] = "<UNUSED>",
	[5512] = "<UNUSED>",
	[5516] = "<UNUSED>",
	[5520] = "<UNUSED>",
	[5523] = "<UNUSED>",
	[5530] = "<NYI> <TXT> Necklace of the Dawn",
	[5532] = "<NYI> <TXT> Ring of the Dawn ",
	[5653] = "<NYI> Hex of Weakness",
	[5659] = "<NYI> Touch of Weakness",
	[5664] = "<UNUSED>",
	[5665] = "<UNUSED>",
	[5666] = "<UNUSED>",
	[5667] = "<UNUSED>",
	[5668] = "<NYI> A Blessing of Light",
	[5669] = "<NYI> A Blessing of Light",
	[5670] = "<NYI> A Blessing of Light",
	[5671] = "<NYI> A Blessing of Light",
	[5674] = "Elune's Grace",
	[5681] = "<UNUSED>",
	[5682] = "<UNUSED>",
	[5683] = "<UNUSED>",
	[5684] = "<UNUSED>",
	[5685] = "<NYI> <TXT> The Light Protects You",
	[5686] = "<NYI> The Light Protects You",
	[5687] = "<NYI> The Light Protects You",
	[5688] = "<NYI> <TXT> A Touch of Voodoo",
	[5689] = "<NYI> A Touch of Voodoo",
	[5690] = "<NYI> <TXT> A Touch of Voodoo",
	[5691] = "<NYI> <TXT> In the Dark it was Created",
	[5692] = "<NYI> In the Dark It was Created",
	[5693] = "<NYI> In the Dark It was Created",
	[5694] = "<UNUSED>",
	[5695] = "<UNUSED>",
	[5696] = "<UNUSED>",
	[5697] = "<UNUSED>",
	[5698] = "<NYI> <TXT> A Small Amount of Hope",
	[5699] = "<NYI> A Small Amount of Hope",
	[5700] = "<NYI> A Small Amount of Hope",
	[5701] = "<NYI> <TXT> The Rites of Old",
	[5702] = "<NYI> The Rites of Old",
	[5703] = "<NYI> The Rites of Old",
	[5704] = "<NYI> <TXT> Undead Priest Robe",
	[5705] = "<NYI> No Longer a Shadow",
	[5706] = "<NYI> No Longer a Shadow",
	[5707] = "<NYI> <TXT> Flirting With Darkness",
	[5708] = "<NYI> Flirting With Darkness",
	[5709] = "<NYI> Flirting With Darkness",
	[5710] = "<NYI> <TXT> Troll Priest Robe",
	[5711] = "<NYI> The Lost Ways",
	[5712] = "<NYI> The Lost Ways",
	[6003] = "<nyi> <txt> Green With Envy",
	[6165] = "<NYI> <TXT> Archmage Timolain's Remains",
	[6201] = "<UNUSED> The Legacy of the Ashbringer",
	[6202] = "<UNUSED> Good and Evil",
	[6606] = "A Little Luck",
	[6702] = "[DEPRECATED] <TXT> SF, RFK, GNOMER, BF",
	[6704] = "[DEPRECATED] <TXT> SM, RFD, ULD",
	[6706] = "[DEPRECATED] <TXT> ZUL, ST, MAR",
	[6708] = "[DEPRECATED] <TXT> BRD, DM, BRS",
	[6710] = "[DEPRECATED] <TXT> UBRS, STRATH, SCHOL",
	[6841] = "<UNUSED>",
	[6843] = "Da Foo",
	[7221] = "Speak with Prospector Stonehewer",
	[7222] = "Speak with Voggah Deathgrip",
	[7384] = "<nyi> <txt> The Scale Crafters",
	[7462] = "The Treasure of the Shen'dralar",
	[7478] = "Libram of Rapidity",
	[7479] = "Libram of Focus",
	[7480] = "Libram of Protection",
	[7521] = "Thunderaan the Windseeker",
	[7522] = "Examine the Vessel",
	[7561] = "Rise, Thunderfury!",
	[7681] = "Hunter test quest",
	[7682] = "Hunter test quest2",
	[7741] = "Praise from the Emerald Circle <NYI> <TXT>",
	[7788] = "Vanquish the Invaders!",
	[7789] = "Quell the Silverwing Usurpers",
	[7790] = "The Written Word",
	[7869] = "test quest - do not use",
	[7870] = "test quest2 - do not use",
	[7871] = "Vanquish the Invaders!",
	[7872] = "Vanquish the Invaders!",
	[7873] = "Vanquish the Invaders!",
	[7874] = "Quell the Silverwing Usurpers",
	[7875] = "Quell the Silverwing Usurpers",
	[7876] = "Quell the Silverwing Usurpers",
	[7904] = "<UNUSED>",
	[7906] = "Darkmoon Cards - Beast",
	[7961] = "Waskily Wabbits!",
	[7962] = "Wabbit Pelts",
	[8080] = "Arathi Basin Resources!",
	[8081] = "More Resource Crates",
	[8123] = "Cut Arathor Supply Lines",
	[8124] = "More Resource Crates",
	[8152] = "REUSE",
	[8154] = "Arathi Basin Resources!",
	[8155] = "Arathi Basin Resources!",
	[8156] = "Arathi Basin Resources!",
	[8157] = "More Resource Crates",
	[8158] = "More Resource Crates",
	[8159] = "More Resource Crates",
	[8160] = "Cut Arathor Supply Lines",
	[8161] = "Cut Arathor Supply Lines",
	[8162] = "Cut Arathor Supply Lines",
	[8163] = "More Resource Crates",
	[8164] = "More Resource Crates",
	[8165] = "More Resource Crates",
	[8230] = "Collin's Test Quest",
	[8247] = "<UNUSED>",
	[8248] = "<UNUSED>",
	[8290] = "Vanquish the Invaders!",
	[8291] = "Vanquish the Invaders!",
	[8294] = "Quell the Silverwing Usurpers",
	[8295] = "Quell the Silverwing Usurpers",
	[8297] = "Arathi Basin Resources!",
	[8298] = "More Resource Crates",
	[8299] = "Cut Arathor Supply Lines",
	[8300] = "More Resource Crates",
	[8337] = "<UNUSED>",
	[8339] = "Royalty of the Council <NYI> <TXT> UNUSED",
	[8340] = "Twilight Signet Ring <NYI> <TXT>",
	[8411] = "Mastering the Elements",
	[8444] = "<NYI> <TXT> gossip shade of ambermoon",
	[8445] = "<NYI> <TXT> gossip shade of ambermoon",
	[8459] = "<UNUSED>",
	[8478] = "Choose Your Weapon",
	[8489] = "An Intact Converter",
	[8530] = "The Alliance Needs Singed Corestones!",
	[8531] = "The Alliance Needs More Singed Corestones!",
	[8565] = "Past Victories in Arathi",
	[8566] = "Past Victories in Arathi",
	[8567] = "Past Victories in Warsong Gulch",
	[8568] = "Past Victories in Warsong Gulch",
	[8569] = "Past Efforts in Warsong Gulch",
	[8570] = "Past Efforts in Warsong Gulch",
	[8571] = "<UNUSED> Armor Kits",
	[8617] = "The Horde Needs Singed Corestones!",
	[8618] = "The Horde Needs More Singed Corestones!",
	[8869] = "Sweet Serenity",
	[8896] = "The Dwarven Spy",
	[8973] = "REUSE",
	[9065] = "The \"Chow\" Quest (123)aa",
	[9168] = "Heart of Deatholme",
	[9296] = "reuse",
	[9297] = "reuse",
	[9298] = "reuse",
	[9306] = "<DEPRECATED>Speak with Vindicator Aldar",
	[9307] = "<DEPRECATED>Compassion",
	[9308] = "<DEPRECATED>Blood Elf Remains?",
	[9316] = "[TXT] Goblin Savages",
	[9342] = "Marauding Crust Bursters",
	[9344] = "A Hasty Departure",
	[9346] = "When Helboars Fly",
	[9357] = "Report to Aeldon Sunbrand",
	[9377] = "Thirsting For Power",
	[9380] = "Hounded for More",
	[9382] = "The Fate of the Clefthoof",
	[9384] = "<NYI>Harnessing the Light",
	[9408] = "Forgotten Heroes",
	[9411] = "<UNUSED>Infused Bandages",
	[9412] = "<UNUSED>Crystal Flake Throat Lozenget Lozenge",
	[9413] = "<UNUSED>Crystal Flake Throat Lozenget Lozenge",
	[9414] = "<UNUSED>Infused Bandages",
	[9445] = "<NYI><TXT>Placeholder: A Worthy Offering",
	[9507] = "<DEPRECATED>From the Desk of Mogul Razdunk",
	[9510] = "Bristlehide Clefthoof Hides",
	[9511] = "Kargath's Battle Plans",
	[9556] = "To The Victor...",
	[9568] = "On the Offensive",
	[9577] = "DAILY TEST QUEST (PVP)     TBC:DAILY TEST QUEST (PVP)  WOTLK:DAILY TEST QUEST (PVP)",
	[9583] = "Omar's Test Quest bk",
	[9596] = "<DEPRECATED>Control",
	[9597] = "<UNUSED>",
	[9599] = "<UNUSED>",
	[9613] = "Deprecated: Keanna's Will",
	[9614] = "Deprecated: Reforge a Short Blade",
	[9615] = "Deprecated: Reforge a Long Blade",
	[9650] = "Deprecated: Magical Augmentation",
	[9651] = "Deprecated: Magical Augmentation",
	[9652] = "Deprecated: Physical Enhancement",
	[9653] = "Deprecated: Physical Enhancement",
	[9654] = "Deprecated: A Well Rounded Defense",
	[9655] = "Deprecated: Healing Amplification",
	[9656] = "Deprecated: Lethality First",
	[9657] = "Deprecated: Offensive Channeling",
	[9658] = "Deprecated: Offensive Channeling",
	[9659] = "Deprecated: Healing Amplification",
	[9660] = "Deprecated: Lethality First",
	[9661] = "Deprecated: A Well Rounded Defense",
	[9662] = "Deprecated: Keanna's Freedom",
	[9679] = "<NYI>Return to Knight-Lord Bloodvalor",
	[9695] = "The Sun King's Command",
	[9745] = "<DEPRECATED>Suppressing the Flame",
	[9754] = "",
	[9755] = "",
	[9880] = "Hellfire Penninsula: -pn - A - ToWoW - Hellfire Turnin Cap",
	[9881] = "Hellfire Penninsula: -pn - H - ToWoW - Hellfire Turnin Cap",
	[9926] = "FLAG Shadow Council/Warmaul Questline",
	[9929] = "The Missing Merchant",
	[9930] = "The Missing Merchant",
	[9941] = "Tracking Down the Culprits",
	[9942] = "Tracking Down the Culprits",
	[9943] = "Return to Thander",
	[9947] = "Return to Rokag",
	[9949] = "A Bird's-Eye View",
	[9950] = "A Bird's-Eye View",
	[9952] = "Prospector Balmoral",
	[9953] = "Lookout Nodak",
	[9958] = "Scouting the Defenses",
	[9959] = "Scouting the Defenses",
	[9963] = "Seeking Help from the Source",
	[9964] = "Seeking Help from the Source",
	[9965] = "A Show of Good Faith",
	[9966] = "A Show of Good Faith",
	[9969] = "The Final Reagents",
	[9974] = "The Final Reagents",
	[9975] = "Primal Magic",
	[9976] = "Primal Magic",
	[9980] = "Rescue Deirom!",
	[9981] = "Rescue Deirom!",
	[9984] = "Host of the Hidden City",
	[9985] = "Host of the Hidden City",
	[9988] = "A Dandy's Best Friend",
	[10014] = "The Firewing Point Project",
	[10015] = "The Firewing Point Project",
	[10029] = "The Spirits Are Calling",
	[10032] = "Artifacts from Tuurem",
	[10046] = "Through the Dark Portal",
	[10048] = "A Handful of Magic Dust BETA",
	[10049] = "A Handful of Magic Dust BETA",
	[10053] = "Dealing with Zeth'Gor",
	[10054] = "Impending Doom",
	[10056] = "Bleeding Hollow Supplies",
	[10059] = "Dealing With Zeth'Gor",
	[10060] = "Impending Doom",
	[10084] = "Assault on Mageddon",
	[10089] = "Forge Camps of the Legion",
	[10090] = "The Legion's Plans",
	[10092] = "Assault on Mageddon",
	[10100] = "The Mastermind",
	[10122] = "The Citadel's Reach",
	[10126] = "Warboss Nekrogg's Orders",
	[10127] = "Mission: Sever the Tie",
	[10128] = "Saving Private Imarion",
	[10130] = "The Western Flank",
	[10131] = "Planning the Escape",
	[10133] = "Mission: Kill the Messenger",
	[10135] = "Mission: Be the Messenger [Horde]",
	[10137] = "Provoking the Warboss",
	[10138] = "Under Whose Orders?",
	[10139] = "Dispatching the Commander [Alliance]",
	[10145] = "Mission: Sever the Tie UNUSED",
	[10147] = "Mission: Kill the Messenger",
	[10148] = "Mission: Be the Messenger [Alliance]",
	[10150] = "The Citadel's Reach",
	[10151] = "Warboss Nekrogg's Orders",
	[10152] = "The Western Flank",
	[10153] = "Saving Scout Makha",
	[10154] = "Planning the Escape",
	[10155] = "Provoking the Warboss",
	[10156] = "Under Whose Orders?",
	[10157] = "Dispatching the Commander [Horde]",
	[10158] = "Bleeding Hollow Supplies",
	[10179] = "The Custodian of Kirin'Var",
	[10181] = "Collector's Edition: -pn - E - FLAG",
	[10187] = "A Message for the Archmage",
	[10195] = "Mercenary See, Mercenary Do",
	[10196] = "More Arakkoa Feathers",
	[10215] = "",
	[10244] = "R.T.F.R.C.M.",
	[10260] = "Netherologist Coppernickels",
	[10292] = "More Power!",
	[10370] = "Nazgrel's Command",
	[10375] = "Obsidian Warbeads",
	[10398] = "Return to Honor Hold",
	[10402] = "<TXT>",
	[10404] = "Against the Legion",
	[10441] = "Peddling the Goods",
	[10452] = "DON'T USE [PH] Fel Orc 1",
	[10453] = "DON'T USE [PH] Fel Orc bread",
	[10459] = "Revered Among the Cenarion Expedition",
	[10534] = "Returning Home",
	[10539] = "Returning Home",
	[10558] = "Revered Among Honor Hold",
	[10559] = "Revered Among Thrallmar",
	[10560] = "Revered Among the Sha'tar",
	[10561] = "Revered Among the Keepers of Time",
	[10591] = "DESTROY THIS QUEST!",
	[10610] = "Prospecting Basics",
	[10616] = "<nyi>Breadcrumb",
	[10638] = "NOT A QUEST",
	[10693] = "One Commendation Signet",
	[10694] = "Ten Commendation Signets",
	[10695] = "One Commendation Signet",
	[10696] = "Ten Commendation Signets",
	[10697] = "One Commendation Signet",
	[10698] = "Ten Commendation Signets",
	[10699] = "One Commendation Signet",
	[10700] = "Ten Commendation Signets",
	[10716] = "Test Flight: Raven's Wood <needs reward>",
	[10743] = "[DEPRECATED]<txt>Hero of the Mok'Nathal",
	[10746] = "DEPRECATED Karazhan: LAB - E - Exalted Ring - Caster",
	[10787] = "[DEPRECATED]<txt><nyi>The Dragons of Dragons' End",
	[10844] = "Forge Camp: Anger",
	[10890] = "[UNUSED] <NYI>",
	[11121] = "DAILY TEST QUEST (RAID)",
	[11125] = "[PH] New Hinterlands Quest",
	[11127] = "<NYI>Thunderbrew Secrets",
	[11179] = "[Temporarily Deprecated Awaiting a New Mob]Finlay Is Gutless",
	[11197] = "ZZOLD Upper Deck Promo - Ghost Wolf Mount OLD",
	[11226] = "Upper Deck Promo - Spectral Tiger Mount",
	[11334] = "He Shoots, He Scores!",
	[11345] = "Prizes for Pellets",
	[11353] = "FLAG: Got the work shirt",
	[11401] = "Call the Headless Horseman",
	[11404] = "Call the Headless Horseman",
	[11405] = "Call the Headless Horseman",
	[11425] = "Test Quest - Craig",
	[11435] = "Gathered Pumpkins NYI",
	[11437] = "[PH] Beer Garden A",
	[11438] = "[PH] Beer Garden B",
	[11444] = "[PH] Beer Garden A",
	[11445] = "[PH] Beer Garden B",
	[11493] = "UNUSED",
	[11551] = "Agamath, the First Gate",
	[11552] = "Rohendor, the Second Gate",
	[11553] = "Archonisus, the Final Gate",
	[11558] = "Dangerous Love",
	[11577] = "WoW Collector's Edition: - DEM - E - FLAG",
	[11588] = "REUSE",
	[11589] = "REUSE",
	[11874] = "Upper Deck Promo - Rocket Mount",
	[11939] = "?????",
	[11974] = "[ph] Now, When I Grow Up...",
	[12051] = "Rustling Some Feathers",
	[12186] = "FLAG: Winner",
	[12187] = "FLAG: Participant",
	[12233] = "[Depricated]Sewing Your Seed",
	[12405] = "Candy Bucket",
	[12410] = "Candy Bucket",
	[12479] = "Wrath of the Lich King: Onwards to Northrend!",
	[12480] = "Wrath of the Lich King: Onwards to Northrend!",
	[12490] = "Veehja's Revenge",
	[12600] = "Upper Deck Promo - Bear Mount",
	[12890] = "If Size Mattered...",
	[12923] = "UNUSED",
	[13175] = "Regaining Control",
	[13176] = "Preparing the Delivery",
	[13184] = "Outliving Usefulness",
	[13692] = "The Sword and the Sea",
	[13799] = "Where Are My Keys?",
	[13800] = "Get My Keys",
	[13908] = "Gearing Up To Ride",
	[24788] = "LFGDungeons - Lich King - Heroic Random - 1st",
	[24789] = "LFGDungeons - Lich King - Heroic Random - Nth",
	[24790] = "Daily Normal Random (1st)",
	[24791] = "Daily Normal Random (Nth)",
	[24818] = "A Change of Heart",
	[24867] = "[NOT USED] Lumberjack Slam Placeholder",
	[24881] = "Classic Random 5-15 (1st)",
	[24882] = "LFGDungeons - Classic - Random - 1st",
	[24889] = "Classic Random 5-15 (Nth)",
	[24890] = "LFGDungeons - Classic - Random - Nth",
	[24908] = "[NOT USED] Build the Fort Placeholder",
	[24909] = "[NOT USED] Protect the Pass Placeholder",
	[24922] = "LFGDungeons - Burning Crusade - Heroic Random - 1st",
	[24923] = "LFGDungeons - Burning Crusade - Heroic Random - Nth",
	[25306] = "You're In The Army Gnow!",
	[25482] = "LFGDungeons - Holiday Dungeon - Headless Horseman - 1st",
	[25483] = "LFGDungeons - Holiday Dungeon - Coren Direbrew - 1st",
	[25484] = "LFGDungeons - Holiday Dungeon - Ahune - 1st",
	[25485] = "LFGDungeons - Holiday Dungeon - Crown Chemical - 1st",
	[26704] = "Empower your owl with the purple statue aura",
	[26741] = "Empower your owl with the green statue aura",
	[29407] = "The First Sign of Winter",
	[29531] = "Kill Stuff",
	[29534] = "Collect Things",
	[29541] = "Take Care of It",
	[29546] = "Tipping the Scales",
	[29549] = "Flightmaster Down",
	[29550] = "Saving Snowpuff",
	[29551] = "Grove Stalkers",
	[29554] = "Sunken Junk",
	[29557] = "The Mission Continues",
	[29561] = "Against the Odds",
	[29584] = "Kill Mogu Firestarters",
	[29602] = "Tracking Event: Gryphon Found",
	[29603] = "Tracking Event: Provisioner Found",
	[29610] = "Tracking Event: Player's First Arrival",
	[29621] = "UNUSED",
	[29625] = "UNUSED",
	[29648] = "UNUSED",
	[29693] = "The General's Edge",
	[29696] = "My Stars!",
	[29703] = "Barrel of Monkies",
	[29705] = "Invasion of the Bottle Snatchers",
	[29706] = "Kegplosion",
	[29707] = "Tracking Event: Opened Shackle 1",
	[29708] = "Tracking Event: Opened Shackle 2",
	[29709] = "Tracking Event: Opened Shackle 3",
	[29710] = "Tracking Event: Looted Food Crate",
	[29711] = "Tracking Event: Looted Scroll",
	[29712] = "Horde Justice",
	[29713] = "Standard Protocol",
	[29714] = "Wet Work!",
	[29715] = "The Witch in the Woods",
	[29718] = "Sixteen Fluid Ounces of Prevention",
	[29719] = "The Double Hozu Dare",
	[29720] = "The Jade Witch",
	[29721] = "An Offering",
	[29722] = "A Lesson in Bravery",
	[29724] = "Burial at Sea",
	[29728] = "Explosive Evidence",
	[29729] = "Without a Trace",
	[29732] = "What Goes Down, Must Come Up!",
	[29744] = "Some \"Pupil of Nature\"",
	[29746] = "Breadcrumb Into Ruins",
	[29766] = "A Good Start",
	[29767] = "Fish Fry",
	[29773] = "Wugou, the Spirit of Earth",
	[29805] = "Tracking Event: Found Mishka at Plane",
	[29806] = "The Wanderer",
	[29812] = "Save the Cuddlies",
	[29813] = "Lethal Hangovers",
	[29814] = "Need a Chaser",
	[29816] = "Get a Sample",
	[29817] = "Drunken Tigers",
	[29818] = "Fix the Flavor",
	[29819] = "The New Master",
	[29831] = "DEPRECATED: Terror on the High Seas",
	[29832] = "DEPRECATED: Gathering Evidence",
	[29837] = "Sacred Scroll",
	[29841] = "Lay of the Land[TEMP]",
	[29842] = "Seeking Answers",
	[29843] = "Aunty Lin Windfur",
	[29845] = "DEPRECATED: The Merchants' Plight",
	[29846] = "DEPRECATED: Captain Rufus Hardwick",
	[29849] = "DEPRECATED: Gunner Blastbarrel",
	[29852] = "DEPRECATED: They Call Him Swifthands",
	[29854] = "DEPRECATED: Claiming Kalimdor",
	[29856] = "Cairn of Bone",
	[29857] = "DEPRECATED: Where Are Those Ships?",
	[29858] = "Wisdom of the Ages",
	[29859] = "DEPRECATED: Spies in Our Midst",
	[29867] = "DEPRECATED: Shadow Hunter Urko'jin",
	[29868] = "DEPRECATED: Captain Cartheron",
	[29869] = "One Hand Clapping",
	[29876] = "DEPRECATED: The Third Captain",
	[29878] = "Building a Better Hozen Trap",
	[29880] = "Catch and Release!",
	[29886] = "Zen Healing",
	[29895] = "Trail of the White Pawn",
	[29896] = "Steaking a Claim",
	[29897] = "No Such Thing As A Free Lunch",
	[29902] = "Fighting the Flames",
	[29923] = "The Dream Brew",
	[29938] = "Friends and Foes",
	[30003] = "A Book By Its Cover",
	[30007] = "Tracking Event: Completed Arrival Phase",
	[30009] = "Muster of Fort Grookin",
	[30019] = "A Breach in the Wall",
	[30020] = "Running Out of Options",
	[30021] = "Impenetrable",
	[30122] = "Silver Filigree Flask",
	[30153] = "Full Speed Ahead",
	[30180] = "Labor for Labor",
	[30197] = "Cart Ride",
	[30198] = "NOT USED",
	[30199] = "NOT USED",
	[30201] = "NOT USED",
	[30202] = "NOT USED",
	[30203] = "NOT USED",
	[30215] = "DEPRECATED",
	[30216] = "DEPRECATED",
	[30217] = "DEPRECATED",
	[30218] = "DEPRECATED",
	[30219] = "DEPRECATED",
	[30220] = "DEPRECATED",
	[30221] = "DEPRECATED",
	[30222] = "DEPRECATED",
	[30223] = "DEPRECATED",
	[30224] = "DEPRECATED",
	[30247] = "Roll Club: Vale of Eternal Blossoms",
	[30250] = "Survival Ring: Thunder",
	[30253] = "The Family Farm",
	[30262] = "NOT USED",
	[30278] = "REUSE FOR PROGRESSION",
	[30279] = "REUSE FOR PROGRESSION",
	[30294] = "Small Comforts",
	[30295] = "Turn-in Quest Test Case",
	[30303] = "NOT USED",
	[30311] = "High Standards",
	[30315] = "Normal Quest Test Case",
	[30316] = "Longshot",
	[30343] = "To the Waterline!",
	[30345] = "Poisoned!",
	[30358] = "Gryphon, Down",
	[30362] = "Tanks for Nothing!",
	[30364] = "Fly, Spy!",
	[30377] = "Minimum Safe Distance",
	[30378] = "The Blastmaster",
	[30415] = "Tracking Quest - Successful",
	[30443] = "Walking on Sunwalkers",
	[30458] = "The Scouts Return",
	[30483] = "NOT USED",
	[30501] = "Gossip Accept Quest Test Case",
	[30520] = "Tummy Trouble",
	[30537] = "A Fizzy Fusion",
	[30538] = "Fun for the Little Ones",
	[30609] = "Exit Strategy",
	[30677] = "Shuttle Service",
	[30704] = "Hozen in the Mist",
	[30705] = "Captain's Log",
	[30706] = "Angry Scribblings",
	[30710] = "Provoking the Trolls",
	[30714] = "Destroy the Leaders",
	[30759] = "Sotelo's Quest",
	[30886] = "Example Pandaren Race Quest",
	[30910] = "Greenstone Village",
	[30918] = "Hui's Vengeance",
	[30934] = "Criteria Effects Test Quest",
	[30941] = "Preparing Zouchin Village",
	[30961] = "Savior of the Inkgill",
	[30965] = "Herding Cats",
	[30974] = "Raising Spirits",
	[30986] = "Ancient Mogu Crypt",
	[30990] = "Open the Golden Doors",
	[31017] = "The Humble Grummle",
	[31025] = "Sweet Tooth",
	[31027] = "Defeat the Abomination",
	[31028] = "Paragon 5",
	[31060] = "Dawson test POI",
	[31098] = "Founding of the Order of the Cloud Serpent",
	[31099] = "Klaxx Attack",
	[31101] = "Legends of the Brewfathers",
	[31218] = "FLAG - Unlocked Tenwu",
	[31219] = "FLAG - Unlocked Nurong",
	[31273] = "Relics of the Swarm",
	[31278] = "Figuring out how to make quests",
	[31280] = "Ways of Cooking",
	[31283] = "Theramore Destroyed Tracking",
	[31305] = "The Way of the Grill",
	[31331] = "Figuring out how to make quests",
	[31491] = "The Ten Foot Pole",
	[31518] = "The Vale of Eternal Blossoms",
	[31533] = "The Perfect Feather",
	[31545] = "The Finer Things",
	[31554] = "On The Mend",
	[31557] = "The Finer Things",
	[31558] = "The Finer Things",
	[31559] = "The Finer Things",
	[31560] = "The Finer Things",
	[31561] = "The Finer Things",
	[31562] = "The Finer Things",
	[31563] = "The Finer Things",
	[31564] = "The Finer Things",
	[31565] = "The Finer Things",
	[31566] = "The Finer Things",
	[31567] = "The Finer Things",
	[31600] = "Enable Scenarios",
	[31604] = "Assault on Zan'vess",
	[31654] = "Doors to Vale OPEN",
	[31655] = "Mishi Tracking 1",
	[31665] = "FLAG - Vegetron 4000 Converted",
	[31668] = "Ambush Event Tracking",
	[31685] = "Valley of the Four Winds",
	[31694] = "Hisingen Blues",
	[31697] = "Jeremy's Test Quest",
	[31723] = "Valley of the Four Winds",
	[31731] = "[SINK SHIPS] (Not Used?)",
	[31759] = "[RESCUE GOLDEN LOTUS SQUAD] [GET RID OF THIS?]",
	[31761] = "Breaking Their Spirits (Not Yet Implemented)",
	[31763] = "[KILL GIANT SERPENT] [GET RID OF THIS?]",
	[31764] = "[PUT OUT THE FIRES]",
	[31816] = "Traitor Gluk",
	[31887] = "Pet Battle Trainers: Kalimdor",
	[31888] = "Pet Battle Trainers: Kalimdor",
	[31890] = "Pet Battle Trainers: Kalimdor",
	[31892] = "Pet Battle Trainers: Kalimdor",
	[31893] = "Pet Battle Trainers: Kalimdor",
	[31939] = "Test",
	[31940] = "Battle Pet Trainers: Pandaria",
	[31968] = "Doubt Begins To Surface",
	[31979] = "The Returning Champion",
	[31988] = "Daily Selected Scenario",
	[32013] = "[Coming in Patch 5.1]",
	[32014] = "[Coming Soon...]",
	[32015] = "[Coming Soon...]",
	[32114] = "So, You Wanted to Test Daily Quests?",
	[32129] = "Defense Daily 06",
	[32147] = "Attack Daily 06",
	[32155] = "Necessary Breaks",
	[32159] = "Circle of Life",
	[32173] = "Build Portal 01",
	[32174] = "Build Portal 01",
	[32195] = "Anger Remains",
	[32202] = "Kill Trolls",
	[32203] = "Kill Mogu Spirits",
	[32205] = "Gather Scout Reports",
	[32210] = "Kill mogu boss for key, use object behind jumping puzzle",
	[32211] = "Nalak the Storm Lord",
	[32229] = "Kill Roaming Troll War Party",
	[32231] = "Trailing Light in the Dark",
	[32253] = "REMOVE (No Longer Used)",
	[32263] = "Find scout near enemy camp (injured, port him back)",
	[32267] = "Destroy enemy portal near camp (streaming attackers, defended, enemy can use)",
	[32270] = "Disarm mines near enemy camp (poke them with a stick =P)",
	[32271] = "Set magical mines around camp (using modern warfare lightning)",
	[32272] = "Start and defend summoning ritual near enemy camp",
	[32273] = "Destroy summoning circles in enemy camp (BloodElf_PowerOrb_Red)",
	[32280] = "Metalocalypse",
	[32281] = "Fleshcrafter's End",
	[32286] = "Kill Mogu Blood-seekers (Roaming pairs, actively fighting scouts, and performing rituals on corpses)",
	[32290] = "Unused",
	[32291] = "[PH] The Fall of Shan Bu",
	[32306] = "Lumber Collection Tracking",
	[32311] = "Enlistment Orders",
	[32312] = "Enlistment Orders",
	[32313] = "Hunt Helheim",
	[32314] = "Slaughter Selenora",
	[32358] = "The Soulcore",
	[32359] = "The Eye of the Naaru",
	[32360] = "Awaiting the Black Harvest",
	[32366] = "A Lick of Fire",
	[32367] = "A Bit of Yak",
	[32369] = "Secrets of the Past",
	[32375] = "A Dash of That",
	[32396] = "Uncompletable Binding Quest [DND]",
	[32407] = "[NYI] Magus Commerce Exchange",
	[32415] = "Their Tracks",
	[32422] = "[NYI] Into Violet Hold",
	[32424] = "[NYI] What Had To Be Done",
	[32425] = "[NYI] A Return to Lion's Landing",
	[32433] = "Undermining the Under Miner",
	[32458] = "With the Wind's Blessing...",
	[32459] = "With the Wind's Blessing...",
	[32467] = "Sacrificial Prevention [PH]",
	[32472] = "Frighten Pterodactyls [PH]",
	[32475] = "A Spark of Life",
	[32482] = "Shwayder's Test Quest",
	[32490] = "UNUSED",
	[32492] = "Destroy Cauldrons",
	[32504] = "Mission: The Secrets of Stormwind",
	[32508] = "Welcome to the Island",
	[32566] = "DEBUG: Eligible for All Quests",
	[32569] = "Trailing Light in the Dark",
	[32570] = "Gather Scout Reports",
	[32622] = "Intro Flight",
	[32651] = "Intro Flight",
	[32717] = "REUSE ME",
	[32727] = "Contributed to Server Percentage Daily Tracking Quest",
	[32758] = "Reader for the Dead Tongue",
	[32784] = "On the Trail of Blood",
	[32793] = "Speak to Ga'nar",
	[32797] = "END OF PROTOTYPE! [Return to Durotan at Ogre Citadel]",
	[32799] = "Task: Retrieve Scorpar Husk Fragments",
	[32800] = "Task: Retrieve Wooly Clefthoof Pelts",
	[32801] = "Task: Retrieve Thunderlord Insignias",
	[32802] = "Task: Retrieve Warm Frostpear Bulbs",
	[32910] = "reuse me",
	[32911] = "Vignette: Ancient Clefthoof (Tracking Quest)",
	[32913] = "Vignette: Arranok's Ritual (Tracking Quest)",
	[32914] = "Return to Ga'nar",
	[32917] = "Kyle Currency Test Quest",
	[32920] = "Vignette: Deathtoll",
	[32921] = "Vignette: Skel'tik the Baleful",
	[32934] = "Task: Scorpid Stomp",
	[32936] = "War Horses!",
	[32946] = "This Time",
	[32949] = "Tracking Quest: Guru Kukuru",
	[32952] = "TEST",
	[32958] = "[REUSEME]",
	[32964] = "Tracking Quest: Ghost Pirate Battle - Completed",
	[32965] = "Tracking Quest: Ghost Pirate Battle - Looted Treasure",
	[32972] = "Avatar of Flame Transform Tracking Quest",
	[32973] = "Avatar of Flame Kill Tracking Quest",
	[32982] = "Scavengers of Flame",
	[32995] = "A Blood-Caked Scroll",
	[32996] = "Battle-Hardened Relics",
	[33000] = "Saurfang, Warrior",
	[33001] = "The Armsmasters",
	[33002] = "Scribe Wei Wu",
	[33003] = "Glyph of the Armsmaster",
	[33007] = "Proving Grounds",
	[33012] = "Task: Stonefang Outpost Fires",
	[33015] = "Thunderlord War-Gronn",
	[33016] = "Treasure: Frostwolf Supply Cache",
	[33019] = "NC S1 Q2",
	[33023] = "NC S1 Q6",
	[33025] = "NC S2 Q2",
	[33028] = "To Karabor!",
	[33034] = "[NOTUSED]Vignette: The Obliterator",
	[33035] = "Vignette: Pale Capture",
	[33036] = "Vignette: Starcrusher Roghash",
	[33042] = "Vignette: Tank Construction",
	[33044] = "Vignette: Synodicus",
	[33045] = "Vignette: Foreling Circle Ritual",
	[33051] = "Vignette: Prophecy of Jerrikar",
	[33052] = "Vignette: Prophecy of Kraator",
	[33053] = "Vignette: Prophecy of the Warp-Watcher",
	[33054] = "[NOTUSED]Vignette: Iron Ball Cache",
	[33056] = "Vignette: Hygrocybe",
	[33057] = "Vignette: Rotbelcher",
	[33058] = "Collect Karabor Axes",
	[33060] = "Put down Poisonfiend.",
	[33063] = "[NOTUSED]Vignette: Shadowcaller Anga",
	[33065] = "Vignette: Mooncrush",
	[33067] = "Task: Warsong Riot",
	[33068] = "Task: Retrieve Thunderlord Armbands",
	[33074] = "The Memory of Fire",
	[33085] = "Fallen From the Stars",
	[33108] = "Task: Poisionous bunnies",
	[33110] = "The Usurper",
	[33121] = "DEPRECATED The Celestial Tournament",
	[33122] = "DEPRECATED Great Job, You Won",
	[33123] = "The Celestial Tournament",
	[33124] = "Fishing with Fin - Tracking Quest",
	[33126] = "Task: Clear Out Grimfrost Hill.",
	[33129] = "Task: Poisionous bunnies",
	[33130] = "Task: Poisionous bunnies",
	[33131] = "Put down Poisonfiend.",
	[33148] = "Missing Hunting Party",
	[33149] = "Blackrock Down",
	[33150] = "Brute Beatdown",
	[33154] = "Fight for Freedom",
	[33155] = "Task: Destroy Iron Horde Banners",
	[33157] = "Shadowmoon Phased Terrain Swap 1",
	[33158] = "Shadowmoon Phased Terrain Swap 2",
	[33159] = "Shadowmoon Phased Terrain Swap 3",
	[33223] = "Task: Collect Ogre Queasine",
	[33224] = "Task: Collect Ogre Queasine [FOR TESTING]",
	[33253] = "To the Defense of Karabor",
	[33257] = "Sprite Fright - Tracking Quest",
	[33265] = "The Friendly Foreling",
	[33266] = "A Light in the Dark - Tracking Quest",
	[33268] = "Collect Moonstones",
	[33320] = "Two Birds One Power Core",
	[33323] = "Finale - Tracking Quest",
	[33327] = "This One Is Just Right",
	[33330] = "Task: Trapped Critters",
	[33346] = "5.4 Test - RRP - Top Level Tracking Quest",
	[33347] = "5.4 Test - RRP - Child Level Tracking Quest",
	[33349] = "STARTER QUEST - RED->PURPLE 15",
	[33350] = "Redridge Group Trial",
	[33351] = "Become Chief",
	[33352] = "Tracking Event: Chief killed",
	[33360] = "5.4 Raid - RRP - Boss 1 Legendary Quest",
	[33361] = "5.4 Raid - RRP - Boss 2 Legendary Quest",
	[33362] = "5.4 Raid - RRP - Boss 3 Legendary Quest",
	[33363] = "5.4 Raid - RRP - Boss 4 Legendary Quest",
	[33364] = "5.4 Raid - RRP - Boss 5 Legendary Quest",
	[33365] = "5.4 Raid - RRP - Boss 6 Legendary Quest",
	[33366] = "5.4 Raid - RRP - Boss 7 Legendary Quest",
	[33367] = "5.4 Raid - RRP - Boss 8 Legendary Quest",
	[33368] = "5.4 Raid - RRP - Boss 9 Legendary Quest",
	[33369] = "5.4 Raid - RRP - Boss 10 Legendary Quest",
	[33370] = "5.4 Raid - RRP - Boss 11 Legendary Quest",
	[33371] = "5.4 Raid - RRP - Boss 12 Legendary Quest",
	[33372] = "5.4 Raid - RRP - Boss 13 Legendary Quest",
	[33373] = "5.4 Raid - RRP - Boss 14 Legendary Quest",
	[33381] = "Death of a Tyrant",
	[33382] = "Tracking Quest: Saw Maraad Storm Off",
	[33395] = "Speak to Thrall",
	[33398] = "South Sprint Practice",
	[33400] = "General Problems",
	[33401] = "Torg's Trouble",
	[33402] = "Verick's Vindicators",
	[33409] = "Elwynn Run",
	[33416] = "South Sprint 12",
	[33418] = "Tracking Quest - Failed",
	[33422] = "Elwynn Long Distance Practice",
	[33424] = "Northshire Dash 12",
	[33425] = "Blue/Yellow Sprint 15 INTERNAL REPEATABLE",
	[33428] = "Elwynn Forest Racing",
	[33429] = "Elwynn Long Distance Trial: 25",
	[33431] = "Elwynn South Distance Trial: 30",
	[33432] = "Elwynn South Distance Practice",
	[33434] = "Westfall Race 30",
	[33441] = "Thrall Vision",
	[33442] = "[FLAG] Caravan Position Bitflag 01",
	[33445] = "[FLAG] Caravan Position Bitflag 02",
	[33446] = "[FLAG] Caravan Position Bitflag 03",
	[33447] = "Treasure: Bladespire Craftsman",
	[33448] = "REUSE",
	[33449] = "Northwestern Medicine",
	[33455] = "Westfall Race Practice UNUSED",
	[33456] = "Catapult Vision",
	[33457] = "Catapult Vision",
	[33458] = "Catapult Vision",
	[33463] = "The Iron Tide",
	[33464] = "From Over the Walls",
	[33466] = "Rally the Artificers",
	[33485] = "Multiplayer Race",
	[33492] = "Northshire Sprint Practice",
	[33496] = "Iron Horde in Karabor",
	[33498] = "Treasure: Bladespire Chef",
	[33499] = "Treasure: Time-Warped Ogre",
	[33509] = "Unexpected Assault",
	[33510] = "Unexpected Assault",
	[33516] = "Un-Safety First",
	[33521] = "Save Auchenai Caretakers",
	[33522] = "Felblood",
	[33529] = "Nightmare in the Tomb",
	[33534] = "Find D'kaan",
	[33536] = "The Element of Demise",
	[33545] = "Arkonite Crystals",
	[33547] = "Desperate Times",
	[33549] = "The Cost of Chaos",
	[33557] = "Muddy Waters",
	[33560] = "Light's Rest",
	[33561] = "Multiplayer Race",
	[33562] = "Trophy: Gorg'ak's Obsidian Spines",
	[33571] = "Treasure: Shadowmoon Clan Treasure",
	[33577] = "A New Threat",
	[33588] = "Task: Break Corrupt Deathweb Eggs",
	[33609] = "Northshire Dash Practice",
	[33634] = "6.0 Invasion Opt-Out",
	[33635] = "FLAG - Seen Gazebo Explosion",
	[33638] = "Insatiable Swarms",
	[33641] = "Vignette: Hippo Boss",
	[33644] = "FLAG - Seen Wall Explosion",
	[33656] = "Talbuk Roundup",
	[33658] = "The Iron Missive",
	[33659] = "Task: Put Down Poisoned Elekk",
	[33686] = "That's No Podling",
	[33693] = "Tracking Quest: First Time at Capping Operation",
	[33705] = "Sacking the Saberon Stronghold",
	[33713] = "TASK: Kill Ogre Slavers",
	[33726] = "Tuurem Task TBD",
	[33733] = "Karmaan",
	[33737] = "Strike While the Iron Is Hot",
	[33746] = "[DEPRECATED]Y'kish Joins the Party",
	[33748] = "Tracking Quest - Saberon Servent Snip Scene",
	[33749] = "Quest Reward Summary: Train Depot",
	[33750] = "Quest Reward Summary: Pipeworks",
	[33755] = "First Test Race: 2 Laps",
	[33766] = "The Thing in the Cave",
	[33767] = "The Thing in the Cave",
	[33772] = "6.0 Invasion Opt-Out",
	[33781] = "The Survivalist's Way",
	[33782] = "Keeping the Balance",
	[33783] = "Kuuros Farm",
	[33789] = "[Deprecated] Lifebloom Orchids",
	[33800] = "Darren's Bombing Run of Awesomeness",
	[33817] = "Signs of a Struggle",
	[33822] = "Laabru's Rebellion",
	[33829] = "zzOLD Honor Has its Rewards",
	[33840] = "The Plight of the Worgen",
	[33844] = "The Pale Hunter",
	[33875] = "Goren, Goren, Gone!",
	[33877] = "Destroy Diggers [PH]",
	[33878] = "No Miner Left Behind",
	[33879] = "Goren, Goren, Gone!",
	[33880] = "Collect Crystals [PH]",
	[33881] = "Can't Live With 'Em, Can't Learn Without 'Em",
	[33887] = "Treasure: Mini-War Machine A",
	[33888] = "Treasure: Mini-War Machine B",
	[33889] = "Treasure: Mini-War Machine C",
	[33890] = "Treasure: Mini-War Machine D",
	[33904] = "Balance of Power",
	[33906] = "War Kangaroo!",
	[33907] = "The Power Shards",
	[33908] = "The Power Shards",
	[33910] = "Aklana Rescue",
	[33911] = "No Draenei Left Behind",
	[33913] = "Desperate Times",
	[33921] = "Stolen Axes",
	[33924] = "Saberon Matriarch",
	[33925] = "Treasure: Frostwolf Cache 01",
	[33930] = "Treasure: Saberon Stash",
	[33943] = "Outrider Urukag",
	[33945] = "Treasure: Frostwolf Cache 03",
	[33949] = "Treasure: Frostwolf Cache 07",
	[33952] = "The Hunting Party",
	[33954] = "The Bloodmaul Scheme",
	[33956] = "Missing Frostwolves",
	[33959] = "You Sunk My Battleship!",
	[33968] = "Goren Boss Kill and Collect",
	[33975] = "Treasure: Blasting Charges - Rubble A",
	[33987] = "Intro Tracking",
	[33989] = "Treasure: Blasting Charges - Cave A Cache",
	[33990] = "Treasure: Blasting Charges - Rubble B",
	[33991] = "Treasure: Blasting Charges - Cave B Cache",
	[33995] = "Treasure: Blasting Charges - Rubble C",
	[33996] = "Treasure: Blasting Charges - Cave C Cache",
	[33997] = "Treasure: Blasting Charges - Rubble D",
	[33998] = "Treasure: Blasting Charges - Cave D Cache",
	[34004] = "Hansel, Report",
	[34006] = "Build Us A Backdoor",
	[34008] = "We Are Leaving!",
	[34025] = "Nuke Bastion Rise Tracking Flag",
	[34055] = "Origin Unknown",
	[34059] = "[DEPRECATED] Keeping Calm",
	[34063] = "Enemies Above",
	[34064] = "The Search For Drogguk",
	[34074] = "The Iron March",
	[34077] = "Trouble to the South",
	[34079] = "Mission Successful",
	[34080] = "Return To Sender",
	[34083] = "REUSE",
	[34084] = "[DEPRECATED] Keeping Calm",
	[34120] = "The Shard of Shadows",
	[34121] = "The Shard of Shadows",
	[34127] = "Vignette: Mother Bloodtusk",
	[34141] = "Frostboar Frenzy",
	[34143] = "Vignette: Kal'rak the Drunk",
	[34146] = "Treasure: Gorgrond Treasure 05",
	[34147] = "Treasure: Gorgrond Treasure 01",
	[34149] = "Treasure: Gorgrond Treasure 02",
	[34150] = "[Deprecated] Treasure: Gorgrond Treasure",
	[34151] = "Treasure: Gorgrond Treasure 03",
	[34152] = "Treasure: Gorgrond Treasure 07",
	[34153] = "Treasure: Gorgrond Treasure 04",
	[34155] = "Treasure: Gorgrond Treasure 06",
	[34158] = "Auchindoun Must Not Fall",
	[34160] = "Vignette: Nixxie the Goblin",
	[34162] = "Vignette: Icklarv",
	[34168] = "Vignette: Stormwave",
	[34170] = "Vignette: Moltnar",
	[34172] = "Treasure: Gorgrond Treasure 08",
	[34173] = "Treasure: Gorgrond Treasure 09",
	[34175] = "[Deprecate] Treasure: Gorgrond Treasure 09",
	[34176] = "Treasure: Gorgrond Treasure 11",
	[34177] = "Treasure: Gorgrond Treasure 14",
	[34178] = "[Deprecate]Treasure: Gorgrond Treasure 08",
	[34179] = "Treasure: Gorgrond Treasure 18",
	[34180] = "[Deprecated] Treasure: Gorgrond Treasure 02",
	[34181] = "Mutation Station",
	[34183] = "Bombardment Triggered",
	[34191] = "Vignette: Un'glok Blackfinger",
	[34195] = "Treasure: Gorgrond Treasure 16",
	[34197] = "Vignette: Bloodbloom the Colossus",
	[34198] = "Vignette: Roardan",
	[34200] = "Ruk'Gan Movement.",
	[34201] = "Treasure: Gorgrond Treasure 13",
	[34206] = "Treasure: Gorgrond Treasure 17",
	[34210] = "Treasure: Gorgrond Treasure 19",
	[34211] = "Treasure: Gorgrond Treasure 20",
	[34212] = "Treasure: Gorgrond Treasure",
	[34213] = "They Have My Son",
	[34214] = "Treasure: Gorgrond Treasure 21",
	[34215] = "Treasure: Gorgrond Treasure 22",
	[34217] = "Smash Blon'sky!",
	[34218] = "Treasure: Gorgrond Treasure 23",
	[34219] = "Treasure: Gorgrond Treasure 15",
	[34222] = "Creature Treasure: Iron Horde Blacksmith",
	[34223] = "Creature Treasure: Iron Horde Stable Master",
	[34224] = "Creature Treasure: Bloodcleave",
	[34225] = "Creature Treasure: Iron Horde Slacker",
	[34231] = "Vignette: Giant Snake",
	[34243] = "Vignette: Rak'nar Muzzlebash",
	[34244] = "They Took My Father",
	[34262] = "Treasure: Aruuna Mining Cart",
	[34267] = "Grommar Forces",
	[34268] = "Task: Kill Wildlife",
	[34269] = "Task: Kill Wolf Boss",
	[34282] = "<UNUSED>",
	[34283] = "<UNUSED>",
	[34299] = "A Threat We Can't Ignore",
	[34304] = "Mutation Station",
	[34307] = "<UNUSED>",
	[34308] = "<UNUSED>",
	[34311] = "6.0 Invasion: Opted Out",
	[34317] = "<UNUSED>",
	[34327] = "Bonus Objective: Kill Ogron",
	[34343] = "Bonus Objective: Kill Frostiron Magnaron",
	[34354] = "A Good Death",
	[34359] = "Darktide Defender TEST",
	[34360] = "SHWAYDER TEST",
	[34366] = "Tanaan 01: Front of the Portal",
	[34376] = "Ore Not to Be",
	[34377] = "The Portal Home",
	[34382] = "Vignette: Grand Warlock Duress",
	[34411] = "Creature Treasure: King Slime",
	[34412] = "Creature Treasure: Gnarljaw",
	[34413] = "Lumberstruck",
	[34424] = "The Chase is On",
	[34441] = "The Fewer, the Merrier",
	[34449] = "[Deprecated] Kill Thunderlord Master",
	[34454] = "Mind Controlled Rylaks",
	[34457] = "Bonus Objective: Ogron-Be-Gone",
	[34459] = "Powering the Defenses",
	[34474] = "Follow Spirit",
	[34475] = "Garrison Invasion!",
	[34483] = "Vignette: Galzomar",
	[34499] = "Bonus Objective: Kill Malevolent Breath",
	[34500] = "Bonus Objective: Kill Ogron",
	[34502] = "Bonus Objective: Kill Pale",
	[34509] = "Into the Jaws of the Jungle",
	[34532] = "Tearing Up Talador",
	[34588] = "The Bounty of Bladespire",
	[34589] = "TEST - Quest Objective Completion Effect Not Firing",
	[34591] = "[Deprecated] Clearing out the Shadows",
	[34602] = "Kill Goren",
	[34617] = "QA Test Quest 3",
	[34623] = "<UNUSED>",
	[34633] = "REUSE",
	[34637] = "Open the Portal",
	[34640] = "[Deprecated] Doorway to Draenor",
	[34650] = "Thunderlord Invasion",
	[34652] = "Vignette/Treasure: Savage Clam",
	[34661] = "The Drudgeboat",
	[34669] = "Gather Lumber",
	[34670] = "Professional Processing",
	[34677] = "NOT USED",
	[34684] = "One Step Ahead",
	[34688] = "DEPRECATED",
	[34690] = "Just the Beginning",
	[34691] = "Just the Beginning",
	[34693] = "[Deprecated] Profession Quest",
	[34694] = "[Deprecated] Invasion Quest",
	[34705] = "Tracking Quest - Shadowmoon Intro",
	[34713] = "Treasure: Gronnstalker's Cache",
	[34714] = "Frostfire Ridge: (RRP) - Treasure - Pale Leather Cache",
	[34722] = "Durotan Been Askin' For Ya",
	[34735] = "Thunderlord Invasion!",
	[34738] = "Nullin' Void",
	[34755] = "Vignette: Mining Captain Bashgar",
	[34757] = "[PH] Elixir",
	[34771] = "Good Stuff",
	[34807] = "Vignette: Goldmane the Skinner",
	[34842] = "The Den of Skog",
	[34844] = "We Require More Resources",
	[34845] = "Lurking in the Shadows",
	[34846] = "Fish Fight",
	[34848] = "To Even the Odds",
	[34851] = "Vignette: Gruuk",
	[34905] = "Placeholder Quest",
	[34907] = "Vignette/Treasure: Lagoon Pool/Giant Clam",
	[34944] = "A Flock of Fledglings",
	[34966] = "Doug Test - Daily Repeatable",
	[34970] = "Darkmoon Iron Deck",
	[34973] = "Darkmoon Moon Deck",
	[34974] = "Darkmoon Visions Deck",
	[34975] = "Darkmoon War Deck",
	[35008] = "UNUSED",
	[35020] = "Jared's Test Quest",
	[35057] = "Vignette XP reward - Frostfire",
	[35092] = "The Portal's Power",
	[35105] = "Honor and Remember",
	[35107] = "Book of Alchemical Secrets",
	[35153] = "Vignette: Fungal Praetorian",
	[35161] = "Vignette XP reward - Talador",
	[35172] = "Your Second Blacksmithing Work Order",
	[35193] = "Weapons Of Our Enemies",
	[35203] = "More Materials",
	[35217] = "Pearing It Up",
	[35220] = "Vignette: Kharazos the Triumphant",
	[35221] = "Da Keeper",
	[35222] = "Firing the Mayor",
	[35228] = "Firing the Mayor",
	[35244] = "Vignette: Skagg",
	[35250] = "Test Quest",
	[35252] = "Chest Reward Tracking Quest",
	[35256] = "A Heart Unbroken",
	[35282] = "Treasure - Glowing Blue Mushroom",
	[35292] = "Ang'kra, the Alchemist",
	[35294] = "Jasper Moves",
	[35296] = "Tainted Garden",
	[35306] = "Unused",
	[35308] = "Unused",
	[35310] = "Unused",
	[35313] = "Unused",
	[35314] = "Unused",
	[35326] = "Unused",
	[35346] = "Abatha, the Alchemist",
	[35359] = "unused",
	[35360] = "unused",
	[35361] = "unused",
	[35362] = "unused",
	[35385] = "[Deprectated ] Treasure: Shadowmoon Treasure 07",
	[35394] = "The Pale Threat",
	[35417] = "Unused",
	[35418] = "Unused",
	[35419] = "Unused",
	[35421] = "Unused",
	[35422] = "Unused",
	[35423] = "Unused",
	[35425] = "Unused",
	[35427] = "Unused",
	[35428] = "Unused",
	[35466] = "Unused",
	[35467] = "Unused",
	[35469] = "Unused",
	[35470] = "Unused",
	[35479] = "Unused",
	[35499] = "Blow up towers",
	[35504] = "Iron Joker",
	[35551] = "[Deprecated]",
	[35571] = "Brutality in the Basin, Violence in the Valley",
	[35578] = "Building an Ancient of War",
	[35592] = "Honorable Victor",
	[35604] = "The Epic Eleven",
	[35618] = "Gidwin Goldbraids",
	[35621] = "Tarenar Sunstrike",
	[35624] = "Roona",
	[35635] = "[Deprecated]",
	[35681] = "Garrison Supplies",
	[35703] = "Tracking: Mill Treasure Barrier 1",
	[35711] = "Nagrand - Treasure 059 - Abu'gar's Tenacity",
	[35720] = "Seamless Breastplate",
	[35721] = "Old Balance Treads",
	[35722] = "Re-Soled Treads",
	[35723] = "Two-Toned Greaves",
	[35724] = "Blood-Washed Greaves",
	[35726] = "Balanced Short Sword",
	[35727] = "Slightly-Bent Short Sword",
	[35728] = "Decent Barrier Shield",
	[35729] = "Frosty Bulwark",
	[35740] = "Frightening Voodoo Doll",
	[35741] = "Sad Voodoo Doll",
	[35742] = "Attuned Alchemist Stone",
	[35743] = "Lesser Alchemist Stone",
	[35749] = "Passable Old Staff",
	[35752] = "Magically Banded Totem",
	[35753] = "Sanded Totem",
	[35754] = "Leering Ritual Mask",
	[35755] = "Intricately Carved Battle Staff",
	[35756] = "Disturbing Ritual Mask",
	[35757] = "Extendable Wand",
	[35758] = "Patched Wand",
	[35767] = "Experimental Healing Potion",
	[35768] = "Ultra Healing Potion",
	[35769] = "Empowered Scroll",
	[35770] = "Alchemist Notebook",
	[35771] = "Legible Scroll",
	[35772] = "Alchemist Field Guide",
	[35773] = "Strangely Pleasant Painting",
	[35774] = "Mostly Stable Elixir",
	[35775] = "Moldy Book",
	[35776] = "Overly Clear Book",
	[35777] = "Unbendable Card",
	[35779] = "Bent Card",
	[35780] = "Stable Elixir",
	[35781] = "Restored Infantry Cloak",
	[35783] = "Draenic Survivalist Cloak",
	[35785] = "Abstract Painting",
	[35786] = "Bronze Victory",
	[35787] = "Silver Victory",
	[35788] = "Gold Victory",
	[35789] = "Infantry Leather Cap",
	[35790] = "Heavy Duty Utilicap",
	[35791] = "Absorbable Vellum",
	[35792] = "Stitched Saddle Bag",
	[35793] = "Transferable Vellum",
	[35794] = "Huntsman's Saddlebag",
	[35795] = "Marching Drum",
	[35796] = "Frenzy War Drum",
	[35799] = "Wooly Bedroll",
	[35800] = "Luxurious Bedroll",
	[35801] = "Restored Lace Kerchief",
	[35802] = "Immaculate Lace Kerchief",
	[35803] = "Lesser Mage Robe",
	[35804] = "Primal Mage Robe",
	[35805] = "Heavy Duty Knapsack",
	[35806] = "Rugged Knapsack",
	[35821] = "Trophy of Glory: Sodius",
	[35822] = "Trophy of Glory: Sodius",
	[35823] = "Sparkling Band",
	[35824] = "Renewed Band",
	[35825] = "Imbued Locket",
	[35826] = "Used Locket",
	[35827] = "Focused Crystal",
	[35829] = "Buffed Crystal",
	[35830] = "Immaculate Statue",
	[35831] = "Restored Statue",
	[35832] = "Priceless Gryphon Figurine",
	[35833] = "Crude Gryphon Figurine",
	[35848] = "Basic Medic Kit",
	[35849] = "Combat Medic Kit",
	[35850] = "Protective Medic Vest",
	[35851] = "Battle Medic Vestments",
	[35852] = "Basic Antivenom Kit",
	[35853] = "Super Immunoglobulin Kit",
	[35854] = "Botanic Cure Guide",
	[35855] = "Book of Draenic Cures",
	[35856] = "Standard Survey Bot",
	[35857] = "Turbo Survey Bot",
	[35858] = "Precision-Tuned Scope",
	[35859] = "Hyper Sight Scope",
	[35860] = "Blackrock Fragment Grenade",
	[35862] = "Blackrock Cluster Bomb",
	[35863] = "Proximity Alarm Bot",
	[35864] = "Garrison Defense Bot",
	[35866] = "A Few Artifact Fragments",
	[35996] = "Vignette: Depthroot",
	[36052] = "Nagrand - Treasure 037 - Misplaced Artifacts",
	[36060] = "Seal of Tempered Fate: Apexis Crystals",
	[36072] = "Nagrand - Treasure 056 - Abu'Gar's Favorite Lure",
	[36089] = "Nagrand - Treasure 070 - Abu'Gar's Reel",
	[36095] = "Azuka Bladefury",
	[36113] = "[Deprecated] Azuka Bladefury",
	[36135] = "Rosa is bad",
	[36154] = "[PH] Lumber Mill Rank 02 Alliance",
	[36155] = "[PH] Lumber Mill Rank 03 Alliance",
	[36172] = "[Deprecated] Put out the Fires",
	[36188] = "Moving On Up",
	[36211] = "6.0 Tanaan - Boots Bootstrap",
	[36212] = "6.0 Tanaan - Wrist Bootstrap",
	[36213] = "6.0 Tanaan - Ring Bootstrap",
	[36214] = "6.0 Tanaan - Hands Bootstrap",
	[36263] = "A Strengthened Bond",
	[36293] = "It's Gotta Work!",
	[36303] = "Spires - Vignette Boss 019 - Eyeless",
	[36304] = "Spires - Vignette Boss 022 - Gochar",
	[36312] = "Spires - Vignette Boss 025 - Sun Sage Valarik",
	[36317] = "Treasure: Ogre Arena Entrance Bridge",
	[36318] = "Treasure: Hanging Alliance Platform",
	[36319] = "Treasure: Arakkoa Hut",
	[36320] = "Treasure: Front of Saberon Cave",
	[36321] = "Treasure: Iron Horde Boat Chest",
	[36322] = "Treasure: Ogre Tower Hidden Cache",
	[36323] = "Treasure: Treasure Stump Near Saberon Pond",
	[36324] = "Treasure: In Ogre/Goren Cave",
	[36325] = "Treasure: Above Ogre/Goren Cave",
	[36326] = "Treasure: Under Horde Bridge",
	[36327] = "Treasure: Wrecked Ship",
	[36328] = "Treasure: Behind Arakkoa Camp",
	[36329] = "Treasure: Water in the Red Tree Area",
	[36330] = "Treasure: Ogre Arena Hidden Cache",
	[36331] = "Treasure: Above Ogre Race Track",
	[36332] = "Treasure: Beside Central Pond",
	[36333] = "Treasure: Treasure Stump Near Central Pond",
	[36334] = "Treasure: Beach Near Ogre Race Track",
	[36335] = "Treasure: Treasure Stump Behind Saberon",
	[36336] = "Treasure: On Pillars in Ogre Red Tree Area",
	[36337] = "Treasure: Treasure Stump Near Ogre Race Track",
	[36343] = "UNUSED",
	[36358] = "A Father and His Son",
	[36363] = "Spires - Treasure 037 - Shattered Hand Spoils",
	[36413] = "A Power Restored",
	[36415] = "Spires - Treasure 020 - Reagent Pouch",
	[36424] = "Spires - Treasure 059 - Sun-Touched Cache",
	[36431] = "Vignette: Soul-twister Torek",
	[36452] = "Spawn Tracking & Spell Visuals: Do They Work?",
	[36459] = "Spires - Treasure 056 - Dislodged Saw Blade",
	[36463] = "Spires - Treasure 012 - Taylor's Coffer Key",
	[36479] = "Spires - Vignette 021 - Nightmaw",
	[36496] = "The Lumber Mill",
	[36524] = "Garrison Max-level Choice Reward Summary: Solo",
	[36525] = "Garrison Max-level Choice Reward Summary: Group",
	[36526] = "Garrison Max-level Choice Reward Summary: PvP",
	[36535] = "Garrison Max-level Choice Tracker: (GROUP) Nagrand Ring of Blood",
	[36536] = "Garrison Max-level Choice Tracker: (PVP) Ashran",
	[36542] = "Garrison Max-level Choice Reward Summary: Group",
	[36543] = "Garrison Max-level Choice Reward Summary: PvP",
	[36544] = "Garrison Max-level Choice Reward Summary: Solo",
	[36546] = "Garrison Max-level Choice Tracker: (GROUP) Nagrand Ring of Blood",
	[36548] = "Garrison Max-level Choice Tracker: (PVP) Ashran",
	[36568] = "Vignette: Malgosh Shadowkeeper",
	[36572] = "Tangleheart Return",
	[36593] = "Breakers Invasion! UNUSED",
	[36620] = "Strategic Choices",
	[36659] = "TBD",
	[36661] = "The Power of the Red",
	[36665] = "Garrison Max-level Choice Tracker: ALL CHOICES DEBUG",
	[36666] = "Garrison Max-level Choice Tracker: ALL CHOICES DEBUG",
	[36670] = "The Ring of Blood: Skull Chewer!",
	[36671] = "The Ring of Blood: Fracktus!",
	[36672] = "The Ring of Blood: Venoxis!",
	[36673] = "The Ring of Blood: Dreshax!",
	[36705] = "The Ring of Blood: Mogor!",
	[36834] = "Gorgrond Ogre Gateway - Tracking",
	[36838] = "Your Second Alchemy Work Order",
	[36839] = "Your Second Enchanting Work Order",
	[36840] = "Your Second Engineering Work Order",
	[36841] = "Your Second Inscription Work Order",
	[36842] = "Your Second Jewelcrafting Work Order",
	[36844] = "Your Second Leatherworking Work Order",
	[36845] = "Your Second Tailoring Work Order",
	[36847] = "Spires Ogre Gateway - Tracking",
	[36872] = "Austin's Folly",
	[36873] = "DEPRECATED",
	[36878] = "Treasure: The Light of Karabor",
	[36922] = "zzzzTITLE TEST",
	[36939] = "[UNUSED]Blood of the Annihilan",
	[37113] = "Thisalee Crow",
	[37114] = "Choluna",
	[37120] = "Sunspring POI Tracking Quest",
	[37169] = "Apexis Guardian Ziri'ak",
	[37175] = "Craig's Test Quest Again!",
	[37188] = "A Flash of Bronze...",
	[37194] = "A Flash of Bronze...",
	[37195] = "The Dark Portal",
	[37248] = "Mastering the Menagerie",
	[37259] = "A Worthy Challenge: Teron'gor",
	[37268] = "Shadowmoon Invasion! BETA",
	[37269] = "Shadowmoon Invasion! BETA",
	[37271] = "A Worthy Challenge: Teron'gor",
	[37295] = "Kill Rylai Crestfall",
	[37297] = "Kill Jeron Emberfall",
	[37298] = "Bonus Objective: Kill Warspear Priests",
	[37299] = "Bonus Objective: Kill Stormshield Priests",
	[37305] = "Bronze Victory",
	[37306] = "Silver Victory",
	[37307] = "Gold Victory",
	[37308] = "Garrison Invasion - Reward Tracker - Bronze",
	[37309] = "Garrison Invasion - Reward Tracker - Silver",
	[37310] = "Garrison Invasion - Reward Tracker - Gold",
	[37389] = "Vignette: Ug'lok the Frozen",
	[37471] = "Vignette: Dahrok Boneshatter",
	[37474] = "Basics First",
	[37475] = "Molten Quarry",
	[37476] = "Ashmaul Burial Grounds",
	[37477] = "Brute's Rise",
	[37478] = "Amphitheater of Annihilation",
	[37508] = "Tracking Event: Stacking the Deck",
	[37509] = "Tracking Event: Stacking the Deck",
	[37512] = "Primals Invasion! BETA",
	[37513] = "Ogres Invasion! BETA",
	[37514] = "Breakers Invasion!! BETA",
	[37515] = "The Iron Horde Approaches... BETA",
	[37523] = "Assault on the Gorian Proving Grounds",
	[37524] = "Assault on the Gorian Proving Grounds",
	[37531] = "Tracking - See Closed Chest",
	[37532] = "[UNUSED]Rolling With the Tidestone",
	[37539] = "UNUSED",
	[37567] = "Interact with Dudebro",
	[37584] = "Your Second Alchemy Work Order",
	[37587] = "Your Second Blacksmithing Work Order",
	[37589] = "Your Second Enchanting Work Order",
	[37590] = "Your Second Engineering Work Order",
	[37591] = "Your Second Inscription Work Order",
	[37592] = "Your Second Jewelcrafting Work Order",
	[37593] = "Your Second Leatherworking Work Order",
	[37594] = "Your Second Tailoring Work Order",
	[37595] = "Your Second Inscription Work Order",
	[37597] = "Talk to Testie",
	[37598] = "Abrogator Stones",
	[37599] = "Abrogator Stones",
	[37600] = "Abrogator Stones",
	[37601] = "Abrogator Stones",
	[37602] = "Abrogator Stones",
	[37603] = "Abrogator Stones",
	[37604] = "Abrogator Stones",
	[37605] = "Elemental Runes",
	[37606] = "Elemental Runes",
	[37607] = "Elemental Runes",
	[37608] = "Elemental Runes",
	[37609] = "Elemental Runes",
	[37610] = "Elemental Runes",
	[37611] = "Elemental Runes",
	[37612] = "Elemental Runes",
	[37613] = "Elemental Runes",
	[37614] = "Elemental Runes",
	[37625] = "Assault on Magnarok",
	[37650] = "Vignette: Iron Horde Caravan",
	[37691] = "[DEPRECATED]The Ancient One",
	[37697] = "Treasure Goblin",
	[37749] = "Trials of Khadgar: Iron Maidens",
	[37750] = "Professions Active",
	[37751] = "Bounties Active",
	[37752] = "Pet Battles Active",
	[37753] = "Relic Hunter Active",
	[37754] = "Dungeon Active",
	[37800] = "Tracking Quest: Start the Garrison Campaign",
	[37825] = "Vignette Placeholder",
	[37826] = "Azsuna - Treasure 003 - Plundered Artifacts",
	[37827] = "Azsuna - Treasure 005 - Discarded Flotsam",
	[37833] = "Azsuna - Treasure 010 - Offerings To Elune",
	[37842] = "Vignette: Yaeger-367",
	[37843] = "Mana Bark",
	[37844] = "Essence of the Unbound",
	[37845] = "Rift Rippers",
	[37867] = "Crystalbeard",
	[37888] = "6.2 Tanaan Max-level Choice Reward Summary: Solo",
	[37924] = "Maritime Salvage",
	[37927] = "We Meet at Light's Hope",
	[37930] = "Whelp? That Happened.",
	[37947] = "6.2 Tanaan Max-level Choice Reward Summary: Solo",
	[37962] = "REUSE",
	[37972] = "Pet Battles Not Active",
	[37974] = "Pet Battles Not Active",
	[37975] = "Pet Battles Not Active",
	[37982] = "Art Tracker - Ashbringer - Tier 0 - Base",
	[37983] = "Art Tracker - Ashbringer - Tier 1 - Holy",
	[37984] = "Art Tracker - Ashbringer - Tier 1 - Fire",
	[37985] = "Art Tracker - Ashbringer - Tier 1 - Corrupted",
	[37986] = "Art Tracker - Ashbringer - Tier 2 - Corrupted",
	[37987] = "Art Tracker - Ashbringer - Tier 2 - Fire",
	[37988] = "Art Tracker - Ashbringer - Tier 2 - Holy",
	[38000] = "Azsuna - Treasure 001 - Drowned Ruins",
	[38003] = "Vignette: Killed Gaiju",
	[38004] = "Vignette: Looted Treasure",
	[38005] = "delete me",
	[38006] = "delete me",
	[38007] = "zzOldEMPTY TEST",
	[38022] = "[DEPRECATED]Assault on the Temple of Sha'naar",
	[38194] = "Missive: Assault on the Gorian Proving Grounds",
	[38202] = "Missive: Assault on the Gorian Proving Grounds",
	[38204] = "Assault on the Gorian Proving Grounds",
	[38205] = "Assault on the Gorian Proving Grounds",
	[38214] = "REUSE",
	[38215] = "7.0 Stormheim - Treasure 015 - Haustvald - ZTO",
	[38218] = "Preserving The Lore",
	[38219] = "Defending The Grove",
	[38220] = "Arauk Nashal 70:JP3 - Aggramar's Vault - Tracking Quest Cleared - Aggramar's Vault",
	[38221] = "UNUSED",
	[38222] = "REUSE",
	[38224] = "REUSE",
	[38227] = "A True Leader Inspires Others",
	[38240] = "Raid Active",
	[38244] = "More Ore",
	[38245] = "Lots of Ore",
	[38260] = "Beachhead",
	[38261] = "UNUSED",
	[38278] = "Vignette: Kraw the Mystic",
	[38279] = "The Royal Taster",
	[38280] = "Treasure: Skragg's Buried Treasure",
	[38281] = "Treasure: Spoils of the Burning Crusade",
	[38284] = "Seeds of Remedy",
	[38285] = "Menacing Sprites",
	[38288] = "Raw Beast Hides",
	[38289] = "Raw Beast Hides",
	[38291] = "Some Dust",
	[38292] = "Some Dust",
	[38294] = "Sumptuous Fur",
	[38295] = "Sumptuous Fur",
	[38297] = "Herbs Galore",
	[38298] = "Herbs Galore",
	[38304] = "Val'sharah",
	[38309] = "Content Perk: The Light Reveals",
	[38310] = "Content Perk: Righteous Strength",
	[38311] = "Content Perk: Call of the Highlord",
	[38313] = "[PH] Worg Pelts",
	[38314] = "Vignette: Hidden Demon",
	[38321] = "Blackbeak Overlook",
	[38341] = "Halting the Nightmare",
	[38353] = "Rescued From Darkness",
	[38368] = "Vignette: Hidden Demon",
	[38380] = "Vignette: Hivequeen Zsala",
	[38392] = "7.0 Val'sharah - Treasure 014 - Malorne's Refuge - twh",
	[38393] = "7.0 Val'sharah - Treasure 015 - Malorne's Refuge - twh",
	[38398] = "Vignette: Helyra's Kraken",
	[38434] = "The Ashbringer",
	[38451] = "Vignette: Geir Gutslice",
	[38452] = "Vignette: Hidden Demon",
	[38454] = "Unfortunate Circumstances",
	[38465] = "Vignette: Shyama the Dreaded",
	[38469] = "Bonus Objective: The Moonclaw Vale",
	[38470] = "Rampant Mandragora",
	[38471] = "Elune's Kiss",
	[38491] = "Infected Mushroom",
	[38494] = "7.0 Stormheim - Treasure 016 - Bear Cave - ZTO",
	[38504] = "Shrine of the Bear Twins",
	[38508] = "Shrine of the Bear Twins - Reward",
	[38509] = "7.0 Stormheim - Treasure 021 - Helheim - ZTO",
	[38511] = "7.0 Stormheim - Treasure 022 - Helheim - ZTO",
	[38512] = "Oakleaf",
	[38517] = "Tayla's Rescue",
	[38521] = "Tayla's Rescue - Reward",
	[38535] = "Brimbil's Journey",
	[38548] = "Brimbil's Journey - Reward",
	[38552] = "Lord Hal'shara's Tomb",
	[38575] = "Beachhead",
	[38592] = "6.2 Tanaan Max-level Choice Reward Summary: Group",
	[38594] = "6.2 Tanaan Max-level Choice Reward Summary: Group",
	[38607] = "Gates of Valhallas",
	[38608] = "Reclaim Valhallas",
	[38610] = "Arauk Nashal 70:JP3 - Gates of Valhallas -Tracking quest - Titan Vehicle - Bonus Objective",
	[38633] = "Burning Importance",
	[38648] = "Black Rook Orders",
	[38658] = "Aid For the Wounded",
	[38660] = "Cleansing the Corruption",
	[38661] = "Nightmare Bombs",
	[38664] = "Tracking Quest: Saved Family 1",
	[38665] = "Tracking Quest: Saved Family 2",
	[38667] = "The Demon's Trail",
	[38668] = "Our Last Hope",
	[38669] = "Our Last Hope",
	[38670] = "Goredome 2",
	[38673] = "The Wormtalon Crone",
	[38674] = "Malfurion's Cure",
	[38688] = "Hope Remains",
	[38693] = "[DEPRECATED] Kill Feral Dogs",
	[38697] = "The Sword of Truth",
	[38699] = "Competitive Exorcise",
	[38707] = "DEPRECATED",
	[38708] = "Purge the River",
	[38730] = "Farm Defense",
	[38733] = "DEPRECATED",
	[38734] = "Banshee Queen",
	[38737] = "An End To War",
	[38745] = "Hard Lessons",
	[38827] = "Your Will Be Done",
	[38838] = "Vignette: Enraged Earthservant",
	[38839] = "Done with Waiting",
	[38840] = "Fishy Business",
	[38841] = "Die, Fish-People",
	[38843] = "Smashing Eggs",
	[38844] = "Rally the Wilds Buff Received",
	[38850] = "The Fate of Tirion Fordring",
	[38855] = "zzDEPRECATEDzz Fighting on the Front",
	[38856] = "Holy Retribution",
	[38867] = "Inspiration Strikes",
	[38874] = "BAD",
	[38885] = "Shivering Ashmaw Cub",
	[38890] = "Not Dead Yet!",
	[38892] = "Scouting Report",
	[38895] = "7.0 Val'sharah - Vignette: Swiftflight - Treasure001 - twh",
	[38896] = "Tearing down the Legion",
	[38902] = "Vignette: Coruscating Bloom",
	[38906] = "To the Rescue",
	[38914] = "Secrets of Highmountain",
	[38924] = "Continue the Domination",
	[38926] = "Continue the Domination",
	[38937] = "Unused - Wraith Zapper",
	[38938] = "Unbearable",
	[38940] = "First Mission Complete",
	[38992] = "Mograine's Oath",
	[38993] = "First Mission Sent",
	[39001] = "To Farahlon!",
	[39002] = "Ogres of the Deep",
	[39005] = "Second Mission Sent",
	[39006] = "Second Mission Complete",
	[39009] = "Third Mission Complete",
	[39010] = "Third Mission Sent",
	[39011] = "Black Rook Invasion",
	[39016] = "Unused - The Fish Must Flow",
	[39017] = "Flight Path Unlock",
	[39028] = "REUSE ME",
	[39030] = "Arauk Nashal 70:JP3 - Aggramar's Vault - Tracking Quest Cleared - God-King Intro",
	[39032] = "A Summons from Saylanna",
	[39035] = "Tracking: Horde Siegebreaker",
	[39036] = "Tracking: Alliance Siegebreaker",
	[39037] = "Tracking: Iron Horde Siegebreaker",
	[39038] = "Tracking: Resource Rich",
	[39052] = "Blueprints Are Important",
	[39066] = "[PH] Defeat the Dark Val'kyr",
	[39076] = "DEPRICATED",
	[39094] = "7.0 Val'sharah - Village - Small Treasure 001 - twh",
	[39095] = "7.0 Val'sharah - Village - Small Treasure 002 - twh",
	[39098] = "7.0 Val'sharah - Village - Small Treasure 003 - twh",
	[39099] = "7.0 Val'sharah - Hollow - Small Treasure 000 - twh",
	[39100] = "7.0 Val'sharah - Hollow - Small Treasure 001 - twh",
	[39101] = "7.0 Val'sharah - Hollow - Small Treasure 002 - twh",
	[39103] = "7.0 Val'sharah - Rook - Small Treasure 000 - twh",
	[39104] = "7.0 Val'sharah - Rook - Small Treasure 001 - twh",
	[39105] = "7.0 Val'sharah - Rook - Small Treasure 002 - twh",
	[39106] = "7.0 Val'sharah - Rook - Small Treasure 003 - twh",
	[39109] = "7.0 Val'sharah - Rook - Medium Treasure 001 - twh",
	[39110] = "7.0 Val'sharah - Rook - Large Treasure 000 - twh",
	[39111] = "7.0 Val'sharah - Ruins - Small Treasure 000 - twh",
	[39112] = "7.0 Val'sharah - Ruins - Small Treasure 001 - twh",
	[39113] = "7.0 Val'sharah - Ruins - Small Treasure 002 - twh",
	[39114] = "7.0 Val'sharah - Ruins - Medium Treasure 000 - twh",
	[39116] = "DEPRECATED",
	[39118] = "Lower Citadel Speed Tracking",
	[39125] = "Demon Destroyer",
	[39126] = "Cleansing the Fountain",
	[39129] = "Ill Tempered",
	[39131] = "Possessions of Power",
	[39132] = "The New Chieftain",
	[39135] = "A Sundered Tribe",
	[39136] = "Unused",
	[39138] = "March Forth and Conquer",
	[39147] = "6.2 Tanaan - PTR - Unlock Tanaan Debug",
	[39151] = "Forging the Artifact",
	[39152] = "Felwrought Annihilator Looted",
	[39156] = "Uther's Spirit Honored",
	[39158] = "Vignette: Rally the Wilds",
	[39190] = "DEPRECATED",
	[39200] = "Lynore's Fury",
	[39205] = "The Twisted Garden",
	[39216] = "Ready to forge Tracking Bit",
	[39234] = "Peak Urgency",
	[39263] = "Ashran Excavation",
	[39264] = "Bonus Objective: Ashran Excavation",
	[39269] = "Never Alone",
	[39271] = "First Mission Sent",
	[39273] = "First Mission Complete",
	[39282] = "Second Mission Complete",
	[39285] = "Second Mission Sent",
	[39286] = "A Gruesome Task",
	[39292] = "Ashran Dominance",
	[39294] = "Ashran Dominance",
	[39296] = "Crystal Fissure Treasure",
	[39303] = "Third Mission Sent",
	[39304] = "Third Mission Complete",
	[39311] = "Bitestone Enclave Treasure",
	[39312] = "Thunder Totem Treasure",
	[39324] = "Through the Portal",
	[39352] = "Extinguishing the Sentinels",
	[39353] = "Empower your owl with the red statue aura",
	[39361] = "Equipment Blueprint: Sonic Amplification Field",
	[39362] = "Equipment Blueprint: Q-43 Noisemaker Mines",
	[39367] = "Equipment Blueprint: Extra Quarters",
	[39368] = "Equipment Blueprint: Blast Furnace",
	[39369] = "Equipment Blueprint: Automated Sky Scanner",
	[39370] = "Equipment Blueprint: Ammo Reserves",
	[39382] = "Perrexx the Corruptor",
	[39388] = "Moonclaw's Wisdom",
	[39397] = "Invasion Experience Received",
	[39418] = "Neltharion's Lair Reward Quest",
	[39420] = "Xavius Event TRACKING",
	[39428] = "Satyr Line TRACKING",
	[39436] = "Haglands Treasure",
	[39460] = "Vale POI Event TRACKING",
	[39461] = "NOT USED",
	[39464] = "Artifact Received",
	[39467] = "Vignette: Sorcery and Suction",
	[39493] = "Pinerock Basin Treasure",
	[39506] = "Pinerock Basin Treasure",
	[39507] = "7.0 Highmountain - Treasure 062 - Pinerock Basin",
	[39508] = "Pinerock Basin Treasure",
	[39520] = "Ashran Dominance",
	[39521] = "Continue the Domination",
	[39522] = "Ashran Dominance",
	[39523] = "Continue the Domination",
	[39524] = "Slay Them All!",
	[39525] = "Slay Them All!",
	[39527] = "Wrath of Azshara Reward Quest",
	[39528] = "Wrath of Azshara Heroic Reward Quest",
	[39534] = "FLAG - Enchanting Research S/1/1/1",
	[39535] = "FLAG - Enchanting Research S/1/1/2",
	[39536] = "FLAG - Enchanting Research S/1/1/3",
	[39537] = "FLAG - Enchanting Research S/1/2/1",
	[39538] = "FLAG - Enchanting Research S/1/2/2",
	[39539] = "FLAG - Enchanting Research S/1/2/3",
	[39540] = "FLAG - Enchanting Research S/1/3/1",
	[39541] = "FLAG - Enchanting Research S/1/3/2",
	[39542] = "FLAG - Enchanting Research S/1/3/3",
	[39543] = "FLAG - Enchanting Research S/2/3/3",
	[39544] = "FLAG - Enchanting Research S/2/3/2",
	[39545] = "FLAG - Enchanting Research S/2/3/1",
	[39546] = "FLAG - Enchanting Research S/2/2/3",
	[39547] = "FLAG - Enchanting Research S/2/2/2",
	[39548] = "FLAG - Enchanting Research S/2/2/1",
	[39549] = "FLAG - Enchanting Research S/2/1/3",
	[39550] = "FLAG - Enchanting Research S/2/1/2",
	[39551] = "FLAG - Enchanting Research S/2/1/1",
	[39552] = "FLAG - Enchanting Research S/3/1/1",
	[39553] = "FLAG - Enchanting Research S/3/1/2",
	[39554] = "FLAG - Enchanting Research S/3/1/3",
	[39555] = "FLAG - Enchanting Research S/3/2/1",
	[39556] = "FLAG - Enchanting Research S/3/2/2",
	[39557] = "FLAG - Enchanting Research S/3/2/3",
	[39558] = "FLAG - Enchanting Research S/3/3/1",
	[39559] = "FLAG - Enchanting Research S/3/3/2",
	[39560] = "FLAG - Enchanting Research S/3/3/3",
	[39589] = "A Mysterious Summons",
	[39608] = "Mysterious Brew Consumed",
	[39618] = "FLAG - Enchanting Research G/1/1/1",
	[39619] = "FLAG - Enchanting Research G/1/1/2",
	[39620] = "FLAG - Enchanting Research G/1/1/3",
	[39621] = "FLAG - Enchanting Research G/1/2/1",
	[39622] = "FLAG - Enchanting Research G/1/2/2",
	[39623] = "FLAG - Enchanting Research G/1/2/3",
	[39624] = "FLAG - Enchanting Research G/1/3/1",
	[39625] = "FLAG - Enchanting Research G/1/3/2",
	[39626] = "FLAG - Enchanting Research G/1/3/3",
	[39627] = "FLAG - Enchanting Research G/2/1/1",
	[39628] = "FLAG - Enchanting Research G/2/1/2",
	[39629] = "FLAG - Enchanting Research G/2/1/3",
	[39630] = "FLAG - Enchanting Research G/2/2/1",
	[39631] = "FLAG - Enchanting Research G/2/2/2",
	[39632] = "FLAG - Enchanting Research G/2/2/3",
	[39633] = "FLAG - Enchanting Research G/2/3/1",
	[39634] = "FLAG - Enchanting Research G/2/3/2",
	[39635] = "FLAG - Enchanting Research G/2/3/3",
	[39636] = "FLAG - Enchanting Research G/3/1/1",
	[39637] = "FLAG - Enchanting Research G/3/1/2",
	[39638] = "FLAG - Enchanting Research G/3/1/3",
	[39639] = "FLAG - Enchanting Research G/3/2/1",
	[39640] = "FLAG - Enchanting Research G/3/2/2",
	[39641] = "FLAG - Enchanting Research G/3/2/3",
	[39642] = "FLAG - Enchanting Research G/3/3/1",
	[39643] = "FLAG - Enchanting Research G/3/3/2",
	[39644] = "FLAG - Enchanting Research G/3/3/3",
	[39647] = "Get the Little Ones!",
	[39687] = "Harbingers of the Past",
	[39693] = "The Path of Huln",
	[39714] = "Where Are the Children?",
	[39717] = "Scouting Mission Complete",
	[39730] = "Scouting Mission Complete",
	[39732] = "Scouting Mission Complete",
	[39734] = "Scouting Mission Complete",
	[39743] = "Valhallas Heroic Reward Quest",
	[39744] = "Valhallas Reward Quest",
	[39745] = "Khadgar Teleport",
	[39770] = "Burn the Candle at Both Ends [NOT USED]",
	[39785] = "[PH] Walrus Tusks",
	[39794] = "Lord Maxwell Tyrosus Slotted",
	[39795] = "Vindicator Boros Slotted",
	[39798] = "Lady Liadrin Slotted",
	[39805] = "Drogbar Spellcaster",
	[39807] = "The Snowbringer",
	[39808] = "Sepulcher of the Sky Treasure",
	[39809] = "Path of Huln Treasure",
	[39810] = "Whitewater Wash Treasure",
	[39811] = "Whitewater Wash Treasure",
	[39813] = "Earthmother's Bounty Treasure",
	[39814] = "Lifespring Cavern Treasure",
	[39815] = "Sylvan Falls Treasure",
	[39819] = "Bloodhunt Highland Treasure",
	[39820] = "Bloodhunt Highland Treasure",
	[39821] = "Bloodhunt Highland Treasure",
	[39822] = "Bloodhunt Highland Treasure",
	[39823] = "Bloodhunt Highland Treasure",
	[39825] = "Stonedark Grotto Treasure",
	[39826] = "Witchwood Treasure",
	[39827] = "Haglands Treasure",
	[39846] = "7.0 Dalaran - Treasure 001 - Burnt Cart",
	[39852] = "[PH] Collect Weapons",
	[39854] = "Curse of the Sea",
	[39868] = "Neltharion's Lair Heroic Reward Quest",
	[39869] = "Toll for the Soul",
	[39871] = "Huntress Ellandryn",
	[39896] = "DEPRECATED: The Ringer",
	[39925] = "Emissary Azathar Looted",
	[39926] = "Lord Malus Looted",
	[39927] = "Wingterror Ikzil Looted",
	[39928] = "Uther's Spirit Honored",
	[39929] = "Uther's Spirit Honored",
	[39930] = "Uther's Spirit Honored",
	[39962] = "Trouble for Okuna",
	[39964] = "Pinerock Basin Treasure",
	[39965] = "Sylvan Falls Treasure",
	[39966] = "Riverbend Treasure",
	[39967] = "Thunder Totem Treasure",
	[39968] = "Thunder Totem Treasure",
	[39969] = "Kill Azshara",
	[39979] = "DEPRECATED",
	[39980] = "Highlord Darion Mograine Slotted",
	[39981] = "Thassarian Slotted",
	[39982] = "Koltira Deathweaver Slotted",
	[39989] = "Keepers of the Hammer",
	[39993] = "Abandoned Fishing Pole",
	[39995] = "Rockaway Coast Treasure",
	[39996] = "Rockaway Coast Treasure",
	[39997] = "Rockaway Coast Treasure",
	[39999] = "Rockaway Coast Treasure",
	[40006] = "Sylvan Falls Treasure",
	[40007] = "Fields of An'she Treasure",
	[40066] = "7.0 Stormheim - Treasure 032 - Blackbeak Overlook - twh",
	[40067] = "7.0 Stormheim - Vignette: Boulderfall - twh",
	[40097] = "7.0 Stormheim - Vignette: Sunbreeze - twh",
	[40100] = "7.0 Stormheim - Vignette: Eileen the Raven - twh",
	[40103] = "7.0 ALPHA DK TEST QUEST",
	[40110] = "Disrupt the Inkbinders",
	[40114] = "Prephoof Compound Treasure",
	[40115] = "Prephoof Compound Treasure",
	[40116] = "Prephoof Compound Treasure",
	[40121] = "Ley Line Influences",
	[40124] = "Gift of the Storm Cooldown",
	[40129] = "Repairing the Source",
	[40160] = "Magic Clams",
	[40161] = "Tapping the Underground",
	[40162] = "Snowblind Mesa Treasure",
	[40163] = "Snowblind Mesa Treasure",
	[40164] = "REUSE",
	[40166] = "Leying with Murlocs",
	[40240] = "Looted Blacksmith Defender's Cache",
	[40243] = "Break Weapon Racks",
	[40245] = "Looted Tailoring Defender's Cache",
	[40246] = "Looted Leatherworking Defender's Cache",
	[40250] = "Suramar - Demon Hunter Daily - Choice Reward Summary - 1",
	[40258] = "Suramar - Demon Hunter Daily - Choice Reward Summary - 2",
	[40260] = "Suramar - Demon Hunter Daily - Choice Reward Summary - 3",
	[40268] = "Neltharion's Vault Treasure",
	[40269] = "Torok's Bluff Treasure",
	[40272] = "7.0 Val'sharah - Village - Medium Treasure 001 - twh",
	[40273] = "7.0 Val'sharah - Temple of Elune - Medium Treasure 001 - bic",
	[40296] = "Tracking Quest: Corridor",
	[40305] = "Barracks Drop 01 Tracking Event",
	[40311] = "Titanic Showdown",
	[40312] = "A Timely Opportunity",
	[40313] = "Barracks Drop 02 Tracking Event",
	[40322] = "Bloodhunt Highland Treasure",
	[40323] = "Cave of the Blood Trial Treasure",
	[40333] = "Spiritwind Summit Treasure",
	[40335] = "Sashj'tar Accord DISABLED",
	[40342] = "Surprise the Sashj'tar",
	[40343] = "Magni/Eitrigg Meetup Seen",
	[40346] = "Pilfered Provisions",
	[40369] = "Artifact XP - Ironbranch",
	[40372] = "The Tidemistress",
	[40380] = "Artifact XP - Thondrax",
	[40381] = "Artifact XP - Darkfiend Assassin",
	[40382] = "Artifact XP - Jinikki the Puncturer",
	[40383] = "Artifact XP - Kiranys Duskwhisper",
	[40393] = "Axes for Arrows",
	[40394] = "Fish and Supplies",
	[40396] = "That's the Spirit",
	[40399] = "7.0 Suramar - Vignette: Sailor's Nightmare - twh",
	[40407] = "The Fate of Azeroth",
	[40420] = "Felsoul Hold",
	[40425] = "Artifact XP - Pollous the Fetid",
	[40426] = "Artifact XP - Kalazzius the Guileful",
	[40427] = "Artifact XP - Grelda the Crone",
	[40428] = "Artifact XP - Henry",
	[40429] = "Artifact XP - Perrexx",
	[40430] = "Artifact XP - Wraithtalon",
	[40431] = "Artifact XP - Dreadbog",
	[40432] = "Artifact XP - Razzok",
	[40433] = "Artifact XP - Lyrath Moonfeather",
	[40434] = "Artifact XP - Tur'xoran",
	[40435] = "Artifact XP - Wingterror Ikzil",
	[40436] = "Artifact XP - Thaon Moonclaw",
	[40437] = "Artifact XP - Kagraxxis the Corruptor",
	[40438] = "Artifact XP - Xandris the Betrayer",
	[40439] = "Artifact XP - Sirius Ebonwing",
	[40440] = "Artifact XP - Rotbeak",
	[40441] = "Artifact XP - Lieutenant Desdel Stareye",
	[40442] = "Artifact XP - Varethos",
	[40443] = "Artifact XP - Kester Farseeker",
	[40444] = "Artifact XP - Trelan Shieldbreaker",
	[40445] = "Artifact XP - Starlys Strongbow",
	[40446] = "Artifact XP - Gravax the Desecrator",
	[40447] = "Artifact XP - Verus Shadowfall",
	[40448] = "Artifact XP - Araxxas",
	[40449] = "Artifact XP - Xalythar the Tormentor",
	[40450] = "Artifact XP - Magula",
	[40451] = "Artifact XP - Morphael",
	[40452] = "Artifact XP - Theryssia",
	[40453] = "Artifact XP - Darkest Fear",
	[40454] = "Artifact XP - Imagined Horror",
	[40455] = "Artifact XP - Seersei",
	[40456] = "Artifact XP - Gorebeak",
	[40457] = "Riverbend Treasure",
	[40458] = "Pinerock Basin Treasure",
	[40459] = "Pinerock Basin Treasure",
	[40460] = "Pinerock Basin Treasure",
	[40461] = "Fields of An'she Treasure",
	[40462] = "Fields of An'she Treasure",
	[40463] = "Fields of An'she Treasure",
	[40464] = "Mucksnout Den Treasure",
	[40465] = "Rockcrawler Chasm Treasure",
	[40466] = "Howling Hills Treasure",
	[40467] = "Howling Hills Treasure",
	[40468] = "Bitestone Enclave Treasure",
	[40485] = "Skyhorn Treasure",
	[40486] = "Skyhorn Treasure",
	[40490] = "Thunder Totem Treasure",
	[40492] = "Thunder Totem Treasure",
	[40502] = "Test - Fireball",
	[40504] = "Skyhorn Treasure",
	[40512] = "Snowblind Mesa Treasure",
	[40513] = "Oro's Overlook Treasure",
	[40565] = "REUSEME",
	[40571] = "Darkheart Thicket Heroic Reward Quest",
	[40572] = "Darkheart Thicket Normal Reward Quest",
	[40574] = "Golganneth Shrine Cleansed",
	[40583] = "Making the Cut - Choice UI - Deadly Deep Amber",
	[40586] = "Making the Cut - Choice UI - Quick Azsunite",
	[40587] = "Making the Cut - Choice UI - Masterful Queen's Opal",
	[40590] = "Warrior Inbound",
	[40591] = "The Second Valarjar",
	[40597] = "Thunder Totem Treasure",
	[40598] = "Finishing Touches - Choice UI - Skystone Loop",
	[40599] = "Finishing Touches - Choice UI - Deep Amber Loop",
	[40600] = "Finishing Touches - Choice UI - Azsunite Loop",
	[40622] = "Aman'thul Shrine Cleansed",
	[40628] = "Corrupted Ashbringer",
	[40629] = "Fiery Ashbringer",
	[40630] = "Shattered Ashbringer",
	[40631] = "Basking in Glory",
	[40635] = "Sashj'tar Slayer",
	[40637] = "Proof of Honor",
	[40641] = "Deprecated",
	[40656] = "Cutting the Crystal Flow",
	[40659] = "Seeing Stars",
	[40662] = "Shattered Chosen",
	[40663] = "Fiery Chosen",
	[40664] = "Corrupted Chosen",
	[40670] = "Shattering the Sashj'tar",
	[40674] = "Jars for Jandvik",
	[40676] = "You Must Make Haste",
	[40685] = "Into the Mouth of the Nether",
	[40689] = "Reward: Deadwind Harvester",
	[40690] = "Reward: Staff of Sargeras",
	[40691] = "Reward: Skull of the Man'ari",
	[40693] = "Eyes of Nashal - Choice UI - Deadly Eye of Prophecy",
	[40695] = "Eyes of Nashal - Choice UI - Quick Dawnlight",
	[40696] = "Eyes of Nashal - Choice UI - Masterful Shadowruby",
	[40699] = "Credit - Scenario Complete",
	[40700] = "Xalethar",
	[40719] = "DEPRECATE- REUSE",
	[40720] = "DEPRECATE - REUSE",
	[40721] = "Empower your owl with the blue statue aura",
	[40725] = "Arganax",
	[40726] = "Test Reward Quest",
	[40728] = "Wormgut's Quest",
	[40739] = "FLAG - Reaves Thermal Anvil Module",
	[40741] = "In Need of Information",
	[40742] = "The Elusive Three",
	[40749] = "A Token of Remembrance",
	[40763] = "Casual Redistribution",
	[40764] = "Tracking Quest for Latosius Challenge 1",
	[40766] = "Charfeather",
	[40769] = "Blackroot Idols",
	[40770] = "Keeper's Request",
	[40771] = "Wild By Nature",
	[40775] = "Trophy Hunting",
	[40776] = "Kazok'thul",
	[40777] = "Vittles and Bits",
	[40779] = "We Need Even More Power!",
	[40780] = "Hunting Impaired",
	[40782] = "Relief For Parim",
	[40788] = "Withered and Creeping",
	[40790] = "A Struggle Of Power",
	[40803] = "REUSE ME",
	[40804] = "Li Li Slotted",
	[40805] = "Meet The Master",
	[40806] = "Arcano-Plasm",
	[40807] = "Clearing the Tunnels",
	[40808] = "Fuel Transfer Worker",
	[40810] = "Tracking Quest: Dorion Fed",
	[40811] = "Not to Scale",
	[40812] = "Trident True",
	[40813] = "It's in the Glands",
	[40825] = "Arcano-Plasm",
	[40827] = "Clearing the Tunnels",
	[40828] = "Fuel Transfer Worker",
	[40831] = "Save the Crumbling Coast",
	[40833] = "Mograine's Recruit",
	[40841] = "The Aid of Val'sharah",
	[40845] = "Coastal Healing",
	[40848] = "Foe Underestimation",
	[40851] = "Darkwell's Request",
	[40884] = "Corrupted Into Crystal",
	[40885] = "Transplanting Their Cores",
	[40886] = "Verdant Search",
	[40888] = "Hammer of Khaz'goroth Actived",
	[40889] = "Tidestone of Golganneth Activated",
	[40891] = "Aegis of Aggramar Activated",
	[40906] = "Serpents from the Deep",
	[40918] = "Black Rook Hold Heroic Reward Quest",
	[40939] = "Vignette: Stormwing Matriarch",
	[40940] = "Test Quest Two",
	[40973] = "Creating Time",
	[40974] = "Latosius' Trial",
	[40992] = "Honor Among Thieves",
	[40998] = "Rendezvous",
	[41000] = "King Forgalash's Burden",
	[41004] = "Jandvik Craftsmanship",
	[41005] = "Coastal Cleanup",
	[41006] = "Assassinate That Guy",
	[41007] = "Building a Better Boat",
	[41008] = "Hunter to Hunter",
	[41012] = "Kirin Tor Showdown Seen",
	[41016] = "BC TL",
	[41018] = "UNUSED - Agent of Aid",
	[41027] = "One Last Breath",
	[41029] = "Tracking Quest for Latosius Challenge 2",
	[41031] = "For the People",
	[41041] = "Sashj'tar Allies DISBALED",
	[41042] = "Champion Chomper",
	[41043] = "Jandvik's First Sailor",
	[41044] = "Attack and Assail!",
	[41048] = "7.0 Suramar - Treasure 003 - Jandvik - twh",
	[41049] = "7.0 Suramar - Treasure 004 - Jandvik - twh",
	[41050] = "7.0 Suramar - Treasure 005 - Jandvik - twh",
	[41051] = "7.0 Suramar - Treasure 006 - Jandvik - twh",
	[41058] = "The Forge of Guardians",
	[41065] = "Troubling News",
	[41071] = "Puzzle 1 Solved",
	[41072] = "Puzzle 2 Solved",
	[41073] = "Puzzle 3 Solved",
	[41074] = "Puzzle 4 Solved",
	[41075] = "Puzzle 5 Solved",
	[41082] = "Reward: Aluneth",
	[41083] = "Reward: Felo'melorn",
	[41084] = "Reward: Ebonchill",
	[41101] = "Lady S'theno Calls",
	[41102] = "Trusted Lieutenant",
	[41103] = "Unleashed Havoc",
	[41104] = "The New Jarl",
	[41126] = "7.0 Suramar - Vignette: Flotsam - twh",
	[41128] = "Valhallas - Vignette: Earlnoc - MRN",
	[41134] = "7.0 Suramar - Vignette: Jetsam - twh",
	[41142] = "7.0 Suramar - Vignette: Khory - twh",
	[41147] = "The Other City of Mages",
	[41211] = "Neltharion's Lair: Neltharion's Treasure",
	[41213] = "Artifact XP - Cho'Zok",
	[41229] = "Tracking Quest: Chen Obtained",
	[41241] = "Cursed Queenfish Needed",
	[41248] = "DEPRECATED",
	[41250] = "DEPRECATED",
	[41251] = "DEPRECATED",
	[41281] = "Mounted Shark Fishing",
	[41284] = "Tracking Quest: The Monkey King Obtained",
	[41285] = "Tracking Quest: Li Li Obtained",
	[41400] = "Battle: Pandaren Cuisine!",
	[41405] = "Battle: Pandaren Cuisine - Sungshin Ironpaw",
	[41406] = "Battle: Pandaren Cuisine - Torg Slowflame",
	[41408] = "Battle: Pandaren Cuisine - Elling Trias",
	[41423] = "Suramar Noble District Reward Quest",
	[41424] = "Suramar Noble District Heroic Reward Quest",
	[41431] = "Legion Portal",
	[41559] = "Where's Our Wine? - Tracking",
	[41579] = "DEPRECATED: Calcified Wormscales",
	[41580] = "DEPRECATED: Unscratched Hippogryph Scale",
	[41583] = "DEPRECATED: Slick Seal Hide",
	[41584] = "DEPRECATED: Rugged Wolf Hide",
	[41585] = "DEPRECATED: Musky Bear Hide",
	[41586] = "DEPRECATED: Bristly Ironhorn Hide",
	[41590] = "DEPRECATED: Thick Bear Hide",
	[41591] = "DEPRECATED: Solid Turtleshell Fragment",
	[41608] = "DEPREACTED: Huge Highmountain Salmon",
	[41681] = "7.0 Suramar - Treasure 007 - Jandvik - twh",
	[41682] = "7.0 Suramar - Treasure 008 - Sashj'tar Ruins - twh",
	[41684] = "The Necrodark",
	[41688] = "Ursol",
	[41761] = "Winter Moose Roundup",
	[41779] = "DANGER: Xavrix",
	[41817] = "Skull of the Taskmaster",
	[41820] = "Walk Without Rhythm",
	[41822] = "Following his Hoofsteps",
	[41823] = "Ashes to Ashes",
	[41825] = "Winged Menace",
	[41829] = "The Darkfeather Scout",
	[41831] = "Taurson's Punch Out",
	[41832] = "White Water Terror",
	[41833] = "Grmlrml's Last Ride",
	[41837] = "Rockaway Bully",
	[41839] = "The Taken",
	[41842] = "Bottom of the Food Chain",
	[41845] = "The Tribes Must Be Warned",
	[41846] = "Power in a Vessel",
	[41848] = "Legion Invaders",
	[41856] = "Legion Portal",
	[41857] = "Neltharion's Lair: Stonedark Slaves",
	[41859] = "Rescue Efforts",
	[41872] = "[DEPRECATED]",
	[41874] = "Talked to Tyrande to Start Events",
	[41875] = "Found First Clue",
	[41876] = "Umbraxis Tracker",
	[41879] = "TBD",
	[41880] = "Den of Shadows",
	[41883] = "Whispers from the Shadows",
	[41903] = "Gathering the Pieces",
	[41917] = "Vignette: Bear Cub",
	[41932] = "Legion Portal",
	[41933] = "Legion Portal",
	[41937] = "Combat Training",
	[41942] = "Legion Portal",
	[41947] = "Legion Portal",
	[41951] = "Legion Portal",
	[41952] = "Rescue Efforts",
	[41953] = "Vis'ileth",
	[41954] = "Rescue Efforts",
	[41959] = "Legion Portal",
	[41960] = "Rescue Efforts",
	[41963] = "Knowledge Unlock Daily Tracking Quest",
	[41978] = "A Strong Defense",
	[41979] = "Rescue Efforts",
	[41982] = "Book Read Tracking Quest",
	[41983] = "[NYI] Bear Necessities",
	[41985] = "DEPRECATED: Fevered Request",
	[41986] = "REUSE",
	[41987] = "Garn",
	[41988] = "A Strong Defense",
	[41991] = "Rescue Efforts",
	[41994] = "Legion Portal",
	[41997] = "A Strong Defense",
	[42003] = "Kept Secret, Kept Safe",
	[42012] = "A Gift of Time",
	[42029] = "Rise, Champions [NYI]",
	[42030] = "Building Our Troops [NYI]",
	[42052] = "The Shade of Xavius",
	[42058] = "DEPRECATED: Crumpled Request",
	[42106] = "Party Crasher",
	[42113] = "Tracking Quest",
	[42143] = "The Champion's Call [WIP]",
	[42179] = "[NYI] Pump it Up Again",
	[42215] = "DEPRECATED: Singed Letter",
	[42242] = "Halls of Valor: A Gift for Vethir",
	[42245] = "DEPRECATED: Singed Note",
	[42250] = "DEPRECATED: Fevered Plea",
	[42255] = "DEPRECATED: Bloody Note",
	[42296] = "Calcified Wormscales",
	[42303] = "DEPRECATED: Fevered Note",
	[42308] = "DEPRECATED: Bloody Plea",
	[42309] = "DEPRECATED: Bloody Request",
	[42323] = "DEPRECATED: Fevered Letter",
	[42333] = "DEPRECATED: Crumpled Letter",
	[42334] = "DEPRECATED: Crumpled Note",
	[42340] = "DEPRECATED: Singed Plea",
	[42345] = "DEPRECATED: Fevered Prayer",
	[42350] = "DEPRECATED: Bloody Letter",
	[42351] = "DEPRECATED: Bloody Prayer",
	[42364] = "Tracker Test Quest - DAW",
	[42374] = "7.0 Greeting Kits - Tracking Quest",
	[42379] = "Growing Power",
	[42381] = "Ox'iloth",
	[42426] = "Tracking Quest: Test Enabled",
	[42427] = "Tracking Quest",
	[42448] = "Unholy Destiny",
	[42456] = "Assn Rogue - Flavor Event 01 (Horde)",
	[42461] = "Vanilla 10-19",
	[42482] = "Assn Rogue - Flavor Event 03",
	[42485] = "REUSE ME",
	[42492] = "PH: Withered Scenario",
	[42507] = "Assn Rogue - Flavor Event 04",
	[42566] = "A Blaze of Starlight",
	[42613] = "Growing Power",
	[42617] = "Champion: King Ymiron",
	[42637] = "Tracking Quest",
	[42638] = "Tracking Quest",
	[42672] = "Growing Power",
	[42724] = "Tracking Quest",
	[42726] = "Brutal Gladiator's Battlegear",
	[42729] = "Challenger's Armaments",
	[42807] = "Demon Commander",
	[42822] = "The Banner of the Ebon Blade",
	[42853] = "Champion: Aponi Brightmane [NYI]",
	[42854] = "Champion: Maximillian of Northshire [NYI]",
	[42855] = "Champion: Arator the Redeemer [NYI]",
	[42856] = "Champion: Lord Commander Leothraxion [NYI]",
	[42939] = "Tracking Down Uthalesh",
	[42951] = "Illusion - Glory of the Clans",
	[42952] = "Tracking Down the Skull",
	[42981] = "Pure Water",
	[43206] = "Jeremy's Test Quest",
	[43215] = "Tracking Down the Scepter",
	[43260] = "Growing Power",
	[43263] = "Growing Power",
	[43274] = "reuse me",
	[43295] = "Slaughter the Fel Armies",
	[43308] = "Treasure 071 - Outskirts",
	[43316] = "By Invitation Only",
	[43337] = "Met Sylvanas With Windrunner Bow",
	[43340] = "Tracking Quest",
	[43367] = "Pixie Dust",
	[43404] = "A Gathering for the Grand Master",
	[43405] = "Da-Nel's Second Quest",
	[43406] = "Request for the Deathlord",
	[43408] = "Summons for the Arch Druid",
	[43410] = "The Master is Requested",
	[43411] = "The Master is Requested",
	[43413] = "A Twist in the Nether",
	[43416] = "Treasure",
	[43417] = "The Spirits Call",
	[43419] = "The Light Beckons",
	[43421] = "The Raven Calls",
	[43466] = "Hidden History",
	[43561] = "I Believe I Can Fly!",
	[43584] = "Battlelord of the Valarjar",
	[43635] = "Needs of the Many",
	[43658] = "Hidden Appearance Unlocked",
	[43682] = "Book Presented",
	[43683] = "Traveler Found",
	[43684] = "Notes Read",
	[43685] = "Phylactery Used",
	[43689] = "Soulfiend Tagerma",
	[43690] = "Shroudseeker",
	[43691] = "Plaguemaw",
	[43693] = "Invasion: Azshara",
	[43740] = "Vignette: Roardan",
	[43742] = "Odyn Death Conversation Enabled",
	[43783] = "Field Rations",
	[43787] = "Polymorph: Cliffwing Hippogryph",
	[43788] = "Polymorph: Highpeak Goat",
	[43789] = "Polymorph: Plains Runehorn Calf",
	[43790] = "Polymorph: Wild Dreamrunner",
	[43791] = "Polymorph: Heartwood Doe",
	[43796] = "Draenei Spoken To",
	[43799] = "Summoned Sheep Exploded",
	[43800] = "Stormheim Sheep Exploded",
	[43816] = "Hidden History",
	[43817] = "Hidden History",
	[43818] = "Hidden History",
	[43819] = "Hidden History",
	[43820] = "Hidden History",
	[43821] = "Hidden History",
	[43822] = "Hidden History",
	[43823] = "Hidden History",
	[43824] = "Hidden History",
	[43825] = "Hidden History",
	[43826] = "Hidden History",
	[43828] = "Sheep Summon Daily Roll",
	[43833] = "Treasure 003 - Felsoul Lower",
	[43836] = "[reuse]",
	[43843] = "Treasure 010 - Falanaar Outdoor Ruins",
	[43922] = "Deprecated: Work Order: Warhide Gloves",
	[43990] = "ZZZNOTUSEDZZZ",
	[44005] = "Tracking Quest: Reaction to Warrior Artifacts",
	[44008] = "DO NOT LOCALIZE - TEMP PRE-REQ",
	[44073] = "Help from Within",
	[44078] = "Supporting Cast",
	[44080] = "Friend of the Animals",
	[44085] = "Affliction Chosen",
	[44086] = "Destruction Chosen",
	[44088] = "Demonology Chosen",
	[44091] = "Needs of the Many",
	[44134] = "DEPRECATED",
	[44179] = "Treasure",
	[44200] = "Mathias Visit Not Active 05",
	[44210] = "The Might of Dalaran pt2",
	[44311] = "Burning Plate of the Worldbreaker Available",
	[44312] = "Burning Plate of the Worldbreaker Denied",
	[44339] = "|cFFFFFFFFVolume I|r | The Violet Citadel in new Dalaran.",
	[44340] = "|cFFFFFFFFVolume II|r | Behind Juvess the Duskwhisperer in the Class Order Hall.",
	[44341] = "|cFFFFFFFFVolume III|r | New Hearthglen in Northrend.",
	[44342] = "|cFFFFFFFFVolume VI|r | Archivist Inkforge in the class order hall.",
	[44343] = "|cFFFFFFFFVolume V|r | Chillheart's room in Scholomance.",
	[44344] = "|cFFFFFFFFVolume IV|r | Bookshelf to the left of Meridelle Lightspark in the Class Order Hall. ",
	[44345] = "|cFFFFFFFFVolume VII|r | The Flameweaver's library in Scarlet Halls.",
	[44346] = "|cFFFFFFFFVolume XII|r | Chief Bitterbrine on the Queen's Reprisal in Azsuna.",
	[44347] = "|cFFFFFFFFVolume IX|r | Artificer Lothaire in Moon Guard Stronghold, Suramar.",
	[44348] = "|cFFFFFFFFVolume X|r | Black Rook Hold in corner of room with ghosts and bookshelves.",
	[44349] = "|cFFFFFFFFVolume XI|r | Guardian's Library in old Karazhan.",
	[44350] = "|cFFFFFFFFVolume VIII|r | A rare in the cave southwest of Halls of Valor in Stormheim (Inquisitor Ernstenbok).",
	[44354] = "Tracking Quest - W2 - Spoke to Brann",
	[44358] = "Bonus Book Read Tracking Quest",
	[44359] = "Tracking Quest: Lich King Conversation 01",
	[44360] = "Tracking Quest: Lich King Conversation 02",
	[44361] = "Tracking Quest: Lich King Conversation 03",
	[44362] = "Tracking Quest: Lich King Conversation 04",
	[44374] = "Tracking Quest: Galen Betrayal",
	[44430] = "Unused",
	[44482] = "Recruiting Ebon Knights",
	[44554] = "Mythic Keystone Weekly Tracking Quest",
	[44578] = "Honor the Flame",
	[44584] = "Short-Supply Reward",
	[44616] = "We'll Need Some Obliterum",
	[44697] = "Tracking Quest - Prestige UI - Artifact",
	[44698] = "Ritual Bit",
	[44708] = "Ritual of Doom",
	[44728] = "REUSE ME",
	[44732] = "Morgalash",
	[44761] = "Mysterious Runebound Scroll",
	[44772] = "Ch 5 Available Tracking Quest",
	[44777] = "REUSE ME",
	[44781] = "The Council's Call",
	[44853] = "Melee DPS Chosen",
	[44854] = "AoE Chosen",
	[44864] = "Scarlet Crusader",
	[44885] = "Shipwrecked Survivors",
	[44890] = "Vignette: Azrok the Afflictor",
	[44910] = "unused",
	[44911] = "unused",
	[44913] = "reuse me",
	[44916] = "99.0 [reuse me]",
	[44931] = "REUSE",
	[44941] = "Dances With Ravenbears (UNUSED)",
	[44951] = "Tank Chosen",
	[44963] = "Ranged DPS Chosen",
	[44965] = "Stealth Chosen",
	[44966] = "Healer Chosen",
	[44970] = "Dual Boss Chosen",
	[45022] = "3+ Targets Chosen",
	[45023] = "Hybrid Chosen",
	[45034] = "Fire the Cannons!",
	[45036] = "Asgrim the Dreadkiller",
	[45043] = "The Glowing Bloodthistle Petal",
	[45045] = "The Vial of Ancient Mana",
	[45050] = "Infiltration Plans",
	[45052] = "Depleted Nether Crystal",
	[45053] = "Thief's Instructions",
	[45054] = "Ancient Elven War Orders",
	[45059] = "Fel Infused Totem Fragment",
	[45060] = "Damaged Kirin Tor Insignia",
	[45061] = "Scrolls of the Faldrottin",
	[45095] = "Treasure 001 - Crashed Horde Ship",
	[45096] = "Treasure 002 - Fel Cave",
	[45097] = "Treasure 003 - Puddle Cave",
	[45102] = "Begin the Assault",
	[45104] = "Your Next Assignment...",
	[45105] = "Lord Raz'gor",
	[45110] = "Treasure 004 - Fel Tower 001",
	[45112] = "Signs of Madness",
	[45116] = "Your Next Assignment...",
	[45119] = "Treasure 005 - Fel Tower 002",
	[45120] = "Treasure 019 - Ruined Temple 002",
	[45121] = "Treasure 006 - Pillar 001",
	[45122] = "Treasure 007 - Back Beach",
	[45135] = "Treasure 008 - The Lost Temple",
	[45136] = "Treasure 009 - The Lost Temple 002",
	[45137] = "Treasure 010 - Malgoreth's Chamber",
	[45141] = "Treasure 011 - Vol'jin's Fall",
	[45142] = "Treasure 012 - Behind Tomb of Sargeras",
	[45144] = "Treasure 013 - Ruined Temple",
	[45150] = "Treasure 013 - Fel Tower 003",
	[45151] = "Treasure 015 - Ritual Altar",
	[45152] = "Treasure 036 - Tomb Statue Book",
	[45153] = "Treasure 016 - Undersea Naval Battle",
	[45154] = "Treasure 017 - Egg Cave",
	[45158] = "Treasure 018 - Crashed Alliance Sea Ship",
	[45166] = "Treasure 020 - Murloc Beach Hut",
	[45168] = "Treasure 021 - Above Puddle Cave",
	[45169] = "Treasure 022 - Hub Cliff",
	[45186] = "Treasure 023 - Sargeras Tower 001",
	[45189] = "Treasure 024 - Fel River Rock",
	[45191] = "Treasure 025 - Night Elf Ruins 001",
	[45198] = "Treasure 026 - Fallen Fel Tower",
	[45199] = "Treasure 027 - Kirin Tor Tower",
	[45200] = "Ch 5 Intro Complete Tracking Quest",
	[45201] = "Treasure 028 - Varian's Fall",
	[45202] = "Treasure 029 - Undersea 002",
	[45204] = "ELIGIBLE FOR BROKEN SHORE INTRO",
	[45205] = "Treasure 030 - Broken Ship Tip",
	[45206] = "Overloaded Soulshard",
	[45210] = "Tracking Quest",
	[45211] = "Tracking Quest",
	[45212] = "Tracking Quest",
	[45213] = "Tracking Quest",
	[45214] = "Tracking Quest",
	[45215] = "Tracking Quest",
	[45216] = "Tracking Quest",
	[45217] = "Tracking Quest",
	[45218] = "Tracking Quest",
	[45244] = "Treasure 031 - Cave Underneath Horde Ship",
	[45246] = "Treasure 032 - Fel River Nook",
	[45248] = "Treasure 033 - Fel Crystal Tower 000",
	[45249] = "Treasure 034 - Beach Pole",
	[45250] = "Treasure 035 - Dead Tree",
	[45252] = "Treasure 037 - Above Lost Temple",
	[45253] = "Treasure 038 - Above Felfire Pass",
	[45254] = "Treasure 039 - Felfire Pass Chain Cage",
	[45255] = "Treasure 040 - Fel Waterfall",
	[45256] = "Treasure 041 - Spike Overlook",
	[45257] = "Treasure 042 - Underwater 003",
	[45258] = "Treasure 043 - Underwater 004",
	[45259] = "Treasure 044 - Crashed Alliance Gunship",
	[45264] = "Treasure 045 - South Peak",
	[45270] = "Treasure 046 - Bundle of Cages 000",
	[45276] = "Treasure 047 - Webbed Path",
	[45279] = "Treasure 048 - Western Island Tree",
	[45283] = "Treasure 049 - Behind Purple Ritual",
	[45284] = "Treasure 050 - Spikes Over Green",
	[45286] = "Treasure 051 - Death Knight Overhang",
	[45288] = "Treasure 052 - Green Ritual Chamber",
	[45289] = "Treasure 053 - Underneath Tomb Bridge",
	[45298] = "Treasure 054 - Death Knight Nook",
	[45299] = "Treasure 055 - Felbreach Hollow",
	[45300] = "Treasure 056 - Giant Tree",
	[45305] = "Treasure 057 - East Rock Cliff",
	[45306] = "Treasure 058 - Purple Ritual Chamber",
	[45308] = "Treasure 059 - Northern Night Elf Ruins",
	[45314] = "Treasure 060 - Fel Hammer",
	[45332] = "Tracking Quest - Zirux",
	[45333] = "On Unhallowed Ground",
	[45337] = "Mo'arg Brute Squad",
	[45340] = "Sea Giant's Stash",
	[45351] = "Overloaded Soulshard",
	[45368] = "Fel Shard",
	[45421] = "Vignette: Dirge of Asgrim",
	[45427] = "Short-Supply Reward",
	[45428] = "Short-Supply Reward",
	[45441] = "Adacic Grubs - REWORK",
	[45508] = "Durguth",
	[45509] = "Xavrix",
	[45577] = "thing",
	[45631] = "Avocation of Antonidas",
	[45682] = "Looted Rogue Vault",
	[45728] = "Legion Assault: Thunder Totem",
	[45801] = "Avocation of Antonidas",
	[45802] = "Avocation of Antonidas",
	[45803] = "Avocation of Antonidas",
	[45815] = "Rogue",
	[45816] = "Choose Order Hall to Support",
	[45817] = "Mage",
	[45822] = "Warrior",
	[45823] = "Priest",
	[45824] = "Paladin",
	[45825] = "Death Knight",
	[45826] = "Warlock",
	[45827] = "Monk",
	[45828] = "Demon Hunter",
	[45829] = "Druid",
	[45830] = "Shaman",
	[45831] = "Hunter",
	[45913] = "Broken Shore Main Questline: Tracking Flag",
	[45999] = "The Legion Assault",
	[46002] = "The Legion Assault - Viewed",
	[46036] = "Dreadnaught's Battlegear",
	[46037] = "Ymirjar's Battlegear",
	[46038] = "Ymirjar's Battlegear",
	[46039] = "Ymirjar's Battlegear",
	[46040] = "Battlegear of Iron Wrath",
	[46041] = "Battlegear of Iron Wrath",
	[46042] = "Battlegear of Iron Wrath",
	[46172] = "Greeting Kit",
	[46254] = "TBD",
	[46255] = "X Unstable Portals Disrupted, 1 World Boss Defeated",
	[46256] = "X Treasures Found, 1 Challenge Attempted",
	[46257] = "REUSE ME",
	[46270] = "reuse me",
	[46273] = "The Giver of Quests",
	[46375] = "Vindictive Combatant's Weapons",
	[46376] = "Vindictive Combatant's Weapons",
	[46425] = "Fearless Combatant's Chain Armor",
	[46426] = "Fearless Combatant's Chain Armor",
	[46427] = "Fearless Combatant's Dragonhide Armor",
	[46428] = "Fearless Combatant's Dragonhide Armor",
	[46429] = "Fearless Combatant's Dreadplate Armor",
	[46430] = "Fearless Combatant's Dreadplate Armor",
	[46431] = "Fearless Combatant's Ironskin Armor",
	[46432] = "Fearless Combatant's Ironskin Armor",
	[46433] = "Fearless Combatant's Leather Armor",
	[46434] = "Fearless Combatant's Leather Armor",
	[46435] = "Fearless Combatant's Plate Armor",
	[46436] = "Fearless Combatant's Plate Armor",
	[46437] = "Fearless Combatant's Ringmail Armor",
	[46438] = "Fearless Combatant's Ringmail Armor",
	[46439] = "Fearless Combatant's Satin Armor",
	[46440] = "Fearless Combatant's Satin Armor",
	[46441] = "Fearless Combatant's Scaled Armor",
	[46442] = "Fearless Combatant's Scaled Armor",
	[46443] = "Fearless Combatant's Silk Armor",
	[46444] = "Fearless Combatant's Silk Armor",
	[46445] = "Fearless Combatant's Weapons",
	[46446] = "Fearless Combatant's Weapons",
	[46469] = "Legion Season 3 and 4 - Gladiator's Weapons",
	[46470] = "Legion Season 3 and 4 - Gladiator's Weapons",
	[46493] = "Elite - Legion Season 3 and 4 - Gladiator's Weapons",
	[46494] = "Elite - Legion Season 3 and 4 - Gladiator's Weapons",
	[46497] = "Fearless Combatant's Felweave Armor",
	[46498] = "Fearless Combatant's Felweave Armor",
	[46522] = "Bloodthirsty Gladiator's Weapons",
	[46721] = "Sulfuron Hammer",
	[46753] = "Tracking Quest",
	[46764] = "Enable Challenge Boss Fights",
	[46787] = "Further Advancement",
	[46820] = "REUSE",
	[46823] = "Shadowstrike and Thunderstrike",
	[46824] = "Shadowstrike and Thunderstrike Anniversary",
	[46826] = "Battleplate of the Silver Hand",
	[46831] = "Broken Village",
	[46952] = "|cFFFFFFFFStep 2|r: Show the Pebble to Dog",
	[46996] = "reuse me",
	[47002] = "The Crown of the Triumvirate",
	[47178] = "Tier 2 Mob Daily Bonus",
	[47179] = "Tier 3 Mob Weekly Bonus",
	[47193] = "First Completion",
	[47194] = "First Completion",
	[47195] = "First Completion",
	[47196] = "First Completion",
	[47288] = "Valuable Fossils",
	[47290] = "World Event Dungeon - Hummel",
	[47331] = "Tracking Quest",
	[47359] = "Legion Season 5, 6, and 7 - Gladiator's Weapons",
	[47360] = "Legion Season 5, 6, and 7 - Gladiator's Weapons",
	[47385] = "Tracking Quest",
	[47386] = "Tracking Quest",
	[47424] = "FLAG - First Chromie Saved",
	[47609] = "Wild Gladiator's Chain Armor",
	[47610] = "Golden King Plate",
	[47611] = "Betrayer Regalia",
	[47612] = "Windfury Set",
	[47613] = "Silent Assassin Armor",
	[47614] = "Light Regalia",
	[47615] = "Holy Warrior Plate",
	[47616] = "Regal Lord Armor",
	[47617] = "Elemental Triad Regalia",
	[47618] = "Howling Beast Set",
	[47619] = "Cycle Armor",
	[47620] = "Lich Lord Plate",
	[47715] = "Tracking Quest",
	[47795] = "Chromie Reputation",
	[47796] = "Timewarped Badges",
	[47798] = "Chromie Reputation",
	[47799] = "Chromie Reputation",
	[47800] = "Chromie Reputation Aura",
	[47801] = "Gold",
	[47802] = "Fangs of the Bronze",
	[47803] = "Hide of the Bronze",
	[47804] = "Wings of the Bronze",
	[47805] = "Stolen Time",
	[47806] = "Draconic Assistant",
	[47811] = "Whispers from the Shadows",
	[47820] = "Stolen Time",
	[47821] = "Stolen Time",
	[47825] = "Keepsake Box",
	[47857] = "REUSE ME",
	[47859] = "Tracking Quest",
	[47964] = "Shoe Shine Kit Tracking Quest",
	[48062] = "Scarlet Crusader",
	[48068] = "A Cure for Ebonhorn",
	[48278] = "Fate of the Life-Binder",
	[48340] = "Tracking Quest",
	[48341] = "Tracking Quest",
	[48342] = "Tracking Quest",
	[48377] = "Tracking Quest",
	[48378] = "VO LINES FOR WQ",
	[48379] = "Tracking Quest",
	[48380] = "Tracking Quest",
	[48392] = "Tracking Quest",
	[48393] = "Tracking Quest",
	[48394] = "The Necrodark",
	[48395] = "Whispers from the Shadows",
	[48396] = "Tracking Quest",
	[48435] = "The Spiritwalkers",
	[48489] = "The Spires of Home",
	[48545] = "Strange Ecologies",
	[48547] = "Quest",
	[48548] = "Quest",
	[48631] = "Securing Krokuun",
	[48632] = "Void Extract",
	[48685] = "Lockout Tracking - Boss - Fire",
	[48686] = "Lockout Tracking - Boss - Ice",
	[48687] = "Lockout Tracking - Boss - Blood",
	[48688] = "Lockout Tracking - Boss - Islands",
	[48689] = "Lockout Tracking - Boss - Marsh",
	[48690] = "Lockout Tracking - Boss - Forest",
	[48819] = "Tracking Quest",
	[48906] = "Tracking Quest",
	[48964] = "Immortal Ace",
	[49027] = "Targets of Opportunity: Terminus",
	[49029] = "Invasion of Space",
	[49030] = "Fragments of the Abyss",
	[49031] = "Out With The Inquisitors",
	[49033] = "REUSE ME",
	[49189] = "Intact Demon Eyes",
	[49190] = "More Intact Demon Eyes",
	[49191] = "Many More Intact Demon Eyes",
	[49193] = "A Pile of Intact Demon Eyes",
	[49194] = "Another Pile of Intact Demon Eyes",
	[49200] = "Yet More Intact Demon Eyes",
	[49789] = "The Pledge",
	[49931] = "The Titan's Wrath",
	[50035] = "Bret Test - SQL",
	[50098] = "Steps 1-4: A New Friend",
	[50099] = "2. /whistle at Uuna",
	[50100] = "3. /roar at Uuna",
	[50101] = "4. /cry at Uuna",
	[50102] = "Step 5: Bright Lights",
	[50103] = "Step 6: Wanna be Friends?",
	[50104] = "Step 7: Finding Nuu",
	[50105] = "Step 8: Shooting Stars",
	[50106] = "Step 9: Flower Crown",
	[50107] = "Step 10: Uuna Gets Kidnapped",
	[50108] = "Step 11: Spirit Healer",
	[50109] = "Step 12: A Dark Place",
	[50140] = "Step 1: Gate of the Setting Sun",
	[50141] = "Step 2: Nighthold",
	[50142] = "Step 3: Krasus Landing, Legion Dalaran",
	[50143] = "Step 4: Dragonblight",
	[50144] = "Step 5: Mount Hyjal",
	[50145] = "Step 6: Kun-Lai Summit",
	[50146] = "Step 7: Blackrock Mountain",
	[50147] = "Step 8: Temple of Karabor",
	[50181] = "Blue Crystal Monocle",
	[50183] = "Yellow Crystal Monocle",
	[50185] = "Green Crystal Monocle",
	[50250] = "Posthaste",
	[50384] = "Doug Test - Completable Quest4",
	[52819] = _.L.HEADER_NAMES[-1001096],
	[52917] = "Grimmy Dialogue",
	[53568] = "Kill Credit 1",
	[53569] = "Kill Credit 2",
	[53570] = "Kill Credit 3",
	[53571] = "Power Increased to Level 1",
	[53572] = "Power Increased to Level 2",
	[53573] = "Power Increased to Level 3",
	[53574] = "Power Increased to Level 4",
	[53575] = "Power Increased to Level 5",
	[53576] = "Power Increased to Level 6",
	[53577] = "Power Increased to Level 7",
	[53578] = "Power Increased to Level 8",
	[53579] = "Power Increased to Level 9",
	[53580] = "Power Increased to Level 10",
	[53585] = "Aerie Peak",
	[53586] = "Argent Tournament Grounds",
	[53587] = "Blackrock Depths",
	[53588] = "The Pit",
	[53589] = "Aalgen Point",
	[53590] = "Elemental Plateau",
	[53591] = "Fire Plume Ridge",
	[53592] = "Honor Hold",
	[53593] = "Neltharion's Vault",
	[53594] = "Nethergarde Keep",
	[53595] = "One Keg",
	[53596] = "Ruby Dragonshrine",
	[53597] = "Skald",
	[53598] = "Stormstout Brewery",
	[53599] = "The Hand of Gul'dan",
	[53600] = "Honor's Stand",
	[53601] = "Sulfuron Spire",
	[55424] = "Aspirant Elynna",
	[55660] = "Time Trials",
	[56070] = "Vengeance for the Venthyr",
	[57510] = "Darklord Taraxis",
	[57556] = "The Maw - Weekly Treasures",
	[57597] = "Construct Body: Flytrap",
	[57600] = "Construct Body: Sabrina",
	[57601] = "Construct Body: Professor",
	[57604] = "Construct Body: Neena",
	[57605] = "Construct Body: Roseboil",
	[57608] = "Construct Body: Gas Bag",
	[57611] = "Construct Body: Marz",
	[57671] = "Meeting Blightcaller",
	[57841] = "Main Objective Only",
	[57842] = "Full Clear",
	[57843] = "Full Clear + 2 Masks",
	[57844] = "Full Clear + 4 Masks",
	[57845] = "Main Objective + 2 bonus",
	[57846] = "Full Clear + 1 Mask",
	[57847] = "Full Clear + 3 Masks",
	[57848] = "Full Clear + 5 Masks",
	[58076] = "|cFFFFFFFFStep 1:|r Speak to Amara",
	[58098] = "|cFFFFFFFFStep 2:|r Empty Dish",
	[58099] = "|cFFFFFFFFStep 3:|r Amara's Wish",
	[58186] = "Fracture Chambers, Layer 1",
	[58187] = "Fracture Chambers, Layer 2",
	[58188] = "Fracture Chambers, Layer 3",
	[58189] = "Fracture Chambers, Layer 4",
	[58190] = "Fracture Chambers, Layer 5",
	[58191] = "Fracture Chambers, Layer 6",
	[58192] = "Soulforges, Layer 1",
	[58193] = "Soulforges, Layer 2",
	[58194] = "Soulforges, Layer 3",
	[58195] = "Soulforges, Layer 4",
	[58196] = "Soulforges, Layer 5",
	[58197] = "Soulforges, Layer 6",
	[58198] = "Coldheart Interstitia, Layer 1",
	[58199] = "Coldheart Interstitia, Layer 2",
	[58200] = "Coldheart Interstitia, Layer 3",
	[58201] = "Coldheart Interstitia, Layer 4",
	[58202] = "Coldheart Interstitia, Layer 5",
	[58203] = "Coldheart Interstitia, Layer 6",
	[58204] = "Mort'regar, Layer 1",
	[58205] = "Mort'regar, Layer 2",
	[58410] = "Construct Body: Atticus",
	[58411] = "Construct Body: Iron Phillip",
	[58413] = "Construct Body: Naxx",
	[58414] = "Construct Body: Toothpick",
	[58415] = "Construct Body: Miru",
	[58416] = "Construct Body: Guillotine",
	[58752] = "Feather Fall Tracking Quest",
	[58985] = "Terrified Soul",
	[58999] = "Shackled Soul",
	[59067] = "Orb of Extrication",
	[59076] = "The Minions of Mayhem",
	[59077] = "The Plan",
	[59078] = "The Hook",
	[59079] = "Portal to Paradise",
	[59080] = "Demons!",
	[59081] = "Scum Scrape",
	[59082] = "Next Realm!",
	[59083] = "Sticky Getaway",
	[59084] = "Bybeen Dreadweaver",
	[59085] = "Third Time is a Charm",
	[59086] = "Manor of Minions",
	[59184] = "Borr-Geth",
	[59229] = "Gargantuan Seeker",
	[59259] = "The Eternal Tormentor",
	[59326] = "Mort'regar, Layer 3",
	[59328] = "Skoldus Hall, Layer 1",
	[59329] = "Skoldus Hall, Layer 2",
	[59330] = "Skoldus Hall, Layer 3",
	[59331] = "Skoldus Hall, Layer 4",
	[59332] = "Skoldus Hall, Layer 5",
	[59333] = "Skoldus Hall, Layer 6",
	[59334] = "Mort'regar, Layer 4",
	[59335] = "Mort'regar, Layer 5",
	[59336] = "Mort'regar, Layer 6",
	[59337] = "Upper Reaches, Layer 1",
	[59834] = "Weekly Horrific Core completion",
	[60010] = "Tremaculum: Liberated Souls",
	[60011] = "Calcis: Decryption",
	[60012] = "Zovaal's Cauldron: Stygia Overflow",
	[60058] = "Conquest's Reward",
	[60068] = "Conquest's Reward",
	[60069] = "Conquest's Reward",
	[60070] = "Conquest's Reward",
	[60071] = "Conquest's Reward",
	[60072] = "Conquest's Reward",
	[60073] = "Conquest's Reward",
	[60074] = "Conquest's Reward",
	[60075] = "Conquest's Reward",
	[60076] = "Conquest's Reward",
	[60077] = "Conquest's Reward",
	[60078] = "Conquest's Reward",
	[60079] = "Conquest's Reward",
	[60080] = "Conquest's Reward",
	[60081] = "Conquest's Reward",
	[60082] = "Conquest's Reward",
	[60083] = "Conquest's Reward",
	[60084] = "Conquest's Reward",
	[60085] = "Conquest's Reward",
	[60086] = "Conquest's Reward",
	[60087] = "Conquest's Reward",
	[60088] = "Conquest's Reward",
	[60089] = "Conquest's Reward",
	[60090] = "Conquest's Reward",
	[60091] = "Conquest's Reward",
	[60092] = "Skoldus Hall",
	[60099] = "Fracture Chambers",
	[60100] = "The Soulforges",
	[60101] = "Deadsoul Interstitia",
	[60102] = "Kakophonus",
	[60103] = "The Miscreation Wing",
	[60104] = "Darkness' Domain",
	[60105] = "Sineater Belfry",
	[60106] = "The Upper Reaches",
	[60107] = "The Winding Halls",
	[60138] = "Unlocking the Gates",
	[60155] = "To Open the Way",
	[60157] = "Answers from the Ascended",
	[60172] = "This Quest is Temporary",
	[60216] = "Construct Body: Mama Tomalin",
	[60286] = "A Token of Our Admiration",
	[60474] = "Spawn Tracking Unit-Specified World Effect in a WMO Bug",
	[60499] = "The Light's Retribution",
	[60559] = "Unused",
	[60990] = "Tracking Quest",
	[61062] = "Adjutant Dekaris",
	[61078] = "/pet",
	[61080] = "/curious",
	[61081] = "/sit",
	[61084] = "/sing",
	[61085] = "/dance",
	[61101] = "Upper Reaches, Layer 2",
	[61124] = "Warren Mongrel",
	[61131] = "Upper Reaches, Layer 3",
	[61132] = "Upper Reaches, Layer 4",
	[61133] = "Upper Reaches, Layer 5",
	[61134] = "Upper Reaches, Layer 6",
	[61225] = "Anima Crystal Shard",
	[61235] = "Anima Crystal Shard",
	[61236] = "Anima Crystal Shard",
	[61237] = "Anima Crystal Shard",
	[61238] = "Anima Crystal Shard",
	[61239] = "Anima Crystal Shard",
	[61241] = "Anima Crystal Shard",
	[61244] = "Anima Crystal Shard",
	[61245] = "Anima Crystal Shard",
	[61247] = "Anima Crystal Shard",
	[61249] = "Anima Crystal Shard",
	[61250] = "Anima Crystal Shard",
	[61251] = "Anima Crystal Shard",
	[61253] = "Anima Crystal Shard",
	[61254] = "Anima Crystal Shard",
	[61257] = "Anima Crystal Shard",
	[61258] = "Anima Crystal Shard",
	[61260] = "Anima Crystal Shard",
	[61261] = "Anima Crystal Shard",
	[61263] = "Anima Crystal Shard",
	[61264] = "Anima Crystal Shard",
	[61270] = "Anima Crystal Shard",
	[61271] = "Anima Crystal Shard",
	[61273] = "Anima Crystal Shard",
	[61274] = "Anima Crystal Shard",
	[61275] = "Anima Crystal Shard",
	[61277] = "Anima Crystal Shard",
	[61278] = "Anima Crystal Shard",
	[61279] = "Anima Crystal Shard",
	[61280] = "Anima Crystal Shard",
	[61281] = "Anima Crystal Shard",
	[61282] = "Anima Crystal Shard",
	[61283] = "Anima Crystal Shard",
	[61284] = "Anima Crystal Shard",
	[61285] = "Anima Crystal Shard",
	[61286] = "Anima Crystal Shard",
	[61287] = "Anima Crystal Shard",
	[61288] = "Anima Crystal Shard",
	[61289] = "Anima Crystal Shard",
	[61290] = "Anima Crystal Shard",
	[61291] = "Anima Crystal Shard",
	[61292] = "Anima Crystal Shard",
	[61293] = "Anima Crystal Shard",
	[61294] = "Anima Crystal Shard",
	[61295] = "Anima Crystal Shard",
	[61296] = "Anima Crystal Shard",
	[61297] = "Anima Crystal Shard",
	[61298] = "Anima Crystal Shard",
	[61299] = "Anima Crystal Shard",
	[61300] = "Anima Crystal Shard",
	[61517] = "zz",
	[61521] = "Tracking Quest",
	[61565] = "Tracking Quest",
	[61964] = "Aubrie Weekly Jailers Tower Quest",
	[61969] = "Skoldus Hall, Layer 7",
	[61970] = "Skoldus Hall, Layer 8",
	[61971] = "Fracture Chambers, Layer 7",
	[61972] = "Fracture Chambers, Layer 8",
	[61973] = "Soulforges, Layer 7",
	[61974] = "Soulforges, Layer 8",
	[61975] = "Coldheart Interstitia, Layer 7",
	[61976] = "Coldheart Interstitia, Layer 8",
	[61977] = "Mort'regar, Layer 7",
	[61978] = "Mort'regar, Layer 8",
	[61979] = "Upper Reaches, Layer 7",
	[61980] = "Upper Reaches, Layer 8",
	[62071] = "RRP Test Quest",
	[62072] = "Familiar Faces",
	[62077] = "To the Chase",
	[62149] = "[DNT]",
	[62150] = "[DNT]",
	[62168] = "Bonescript Dispatches",
	[62212] = "Tracking Quest",
	[62230] = "A Stolen Stone Fiend",
	[62233] = "Tracking Quest",
	[62245] = "Venari Rep Token Tracking",
	[62249] = "Venari Rep Token Tracking",
	[62253] = "Tracking Quest",
	[62257] = "Tracking Quest",
	[62289] = "Observing Conflict",
	[62291] = "Venari Rep Token Tracking",
	[62402] = "Timewalking Campaigns",
	[62579] = "Venari Rep Token Tracking",
	[62594] = "The Safety of Others",
	[62595] = "The Safety of Others",
	[62717] = "Venari Rep Token Tracking",
	[62724] = "Ye Olde Test of Strength",
	[62725] = "A Test of Guile",
	[62726] = "Ye Olde Test of Fortitude",
	[62727] = "9.0 Rated PvP Incentive - Shadowlands Season 1 Exclusive Mount",
	[62728] = "9.0 Rated PvP Incentive - Shadowlands Season 1 Saddle",
	[62828] = "[DNT] Door of Shadows",
	[63041] = "Short-Supply Reward",
	[63180] = "Hunt: Shadehounds",
	[63194] = "Hunt: Winged Soul Eaters",
	[63198] = "Hunt: Death Elementals",
	[63199] = "Hunt: Alpha Devourers",
	[63418] = "Exploited Explorers",
	[63419] = "Spores Galore",
	[63671] = "Favor: The Nathrezim Documents",
	[63735] = "Recover the Research",
	[63751] = "A Terrible Power",
	[63766] = "Relic of the First Ones",
	[63868] = "Skoldus Hall, Layer 9",
	[63869] = "Skoldus Hall, Layer 10",
	[63870] = "Skoldus Hall, Layer 11",
	[63871] = "Skoldus Hall, Layer 12",
	[63872] = "Fracture Chambers, Layer 9",
	[63873] = "Fracture Chambers, Layer 10",
	[63874] = "Fracture Chambers, Layer 11",
	[63875] = "Fracture Chambers, Layer 12",
	[63876] = "Soulforges, Layer 9",
	[63877] = "Soulforges, Layer 10",
	[63878] = "Soulforges, Layer 11",
	[63879] = "Soulforges, Layer 12",
	[63880] = "Coldheart Interstitia, Layer 9",
	[63881] = "Coldheart Interstitia, Layer 10",
	[63882] = "Coldheart Interstitia, Layer 11",
	[63883] = "Coldheart Interstitia, Layer 12",
	[63884] = "Mort'regar, Layer 9",
	[63885] = "Mort'regar, Layer 10",
	[63886] = "Mort'regar, Layer 11",
	[63887] = "Mort'regar, Layer 12",
	[63888] = "Upper Reaches, Layer 9",
	[63889] = "Upper Reaches, Layer 10",
	[63890] = "Upper Reaches, Layer 11",
	[63891] = "Upper Reaches, Layer 12",
	[63947] = "Raiders in the Ruins [PH]",
	[63948] = "Seeking the Seeker's Staff [PH]",
	[64006] = "Nav Test: Zereth Mortis",
	[64022] = "2nd Find",
	[64023] = "3rd Find",
	[64024] = "1st Find",
	[64193] = "DEPRECATED: Table of Discontent",
	[64197] = "Placing Stone Ring",
	[64198] = "Placing Runed Band",
	[64199] = "Placing Gold Band",
	[64200] = "Placing Silver Ring",
	[64201] = "Placing Signet Ring",
	[64231] = "[DNT] Training Quest",
	[64235] = "[DNT] Training Kill Quest",
	[64248] = "Third Chain",
	[64249] = "First Chain",
	[64250] = "Second Chain",
	[64280] = "Daily Drop #1",
	[64281] = "Daily Drop #2",
	[64293] = "Day 1",
	[64294] = "Day 2",
	[64295] = "Day 3",
	[64296] = "Day 4",
	[64297] = "Day 5",
	[64299] = "Day 6",
	[64305] = "The Tormentors of Torghast",
	[64306] = "Quest Completion Criteria",
	[64335] = "Stay awhile and listen: Alexandros",
	[64341] = "Bonus Relic Loot #1",
	[64342] = "Bonus Relic Loot #2",
	[64343] = "Bonus Relic Loot #3",
	[64344] = "Bonus Relic Loot #4",
	[64377] = "Stay awhile and listen: Thrall",
	[64429] = "Stay awhile and listen: Uther",
	[64433] = "30 Relic Fragments",
	[64434] = "20 Relic Fragments",
	[64435] = "15 Relic Fragments",
	[64436] = "5 Relic Fragments",
	[64510] = "Peter's Test Task",
	[64517] = "Byron Test - Item Gained",
	[64518] = "Byron Test - Obtain Any Item",
	[64533] = "Stay awhile and listen: Primus",
	[64577] = "Stay awhile and listen: Tal-Galan",
	[64582] = "Yuni-Test",
	[64640] = "AubriesTestQuestForJeff",
	[64649] = "A Mountain of Work to Do",
	[64654] = "Champion: Ben Howell",
	[64747] = "Bonus Relic Loot #5",
	[64748] = "Bonus Relic Loot #6",
	[64749] = "Bonus Relic Loot #7",
	[64750] = "Bonus Relic Loot #8",
	[64751] = "Bonus Relic Loot #9",
	[64752] = "Bonus Relic Loot #10",
	[64753] = "Bonus Relic Loot #11",
	[64754] = "Bonus Relic Loot #12",
	[64755] = "Bonus Relic Loot #13",
	[64756] = "Bonus Relic Loot #14",
	[64757] = "Bonus Relic Loot #15",
	[64784] = "9.0 Rated PvP Incentive - Shadowlands Season 2 Exclusive Mount",
	[64938] = "Corgi Soul",
	[64939] = "Choofa/Squirrel Soul",
	[64982] = "Cat (Well-Fed) Soul",
	[65047] = "Mark of the Nightwing Raven",
	[65152] = "A Hardened Bond",
	[65607] = "Stay awhile and listen: Genn Greymane",
	[65609] = "Stay awhile and listen: Lor'themar Theron",
	[65612] = "Stay awhile and listen: Baine Bloodhoof",
	[65614] = "Stay awhile and listen: Arbiter Pelagos",
	[65621] = "[DEPRECATED] Tracking Quest - Egg Tracker",
	[66359] = "First Daily Completion: 'Unlocking our Past' (Forgemaster Bazentus)",
	[66360] = "First Daily Completion: 'Unlocking our Past' (Sabellian)",
	[66361] = "First Daily Completion: 'Unlocking our Past' (Wrathion)",
	[66362] = "First Daily Completion: 'Unlocking our Past' (Igys the Believer)",
	[66373] = "DF Alchemy Treasure #1",
	[66374] = "DF Alchemy Treasure #2",
	[66375] = "DF Inscription Treasure #1",
	[66376] = "DF Inscription Treasure #2",
	[66377] = "DF Enchanting Treasure #1",
	[66378] = "DF Enchanting Treasure #2",
	[66379] = "DF Engineering Treasure #1",
	[66380] = "DF Engineering Treasure #2",
	[66381] = "DF Blacksmithing Treasure #1",
	[66382] = "DF Blacksmithing Treasure #2",
	[66384] = "DF Leatherworking Treasure #1",
	[66385] = "DF Leatherworking Treasure #2",
	[66386] = "DF Tailoring Treasure #1",
	[66387] = "DF Tailoring Treasure #2",
	[66388] = "DF Jewelcrafting Treasure #1",
	[66389] = "DF Jewelcrafting Treasure #2",
	[66561] = "The Weave of a Tale: Handstand",
	[66562] = "The Weave of a Tale: Slaying",
	[66563] = "The Weave of a Tale: Rarest Fish",
	[66564] = "The Weave of a Tale: Half Squid",
	[66565] = "The Weave of a Tale: Biggest",
	[66566] = "The Weave of a Tale: Average",
	[66567] = "The Weave of a Tale: Whisper",
	[66568] = "The Weave of a Tale: Sword",
	[66569] = "The Weave of a Tale: Slipped",
	[66570] = "The Weave of a Tale: Threw",
	[66571] = "The Weave of a Tale: Ate",
	[66983] = "The Heart of the Deck: Life-Giver",
	[66984] = "The Heart of the Deck: Destroyer",
	[66985] = "The Heart of the Deck: Guardian",
	[66992] = "The Heart of the Deck: Draconic Form",
	[66993] = "The Heart of the Deck: My Form",
	[66994] = "The Heart of the Deck: Motivation",
	[66995] = "The Heart of the Deck: Adaptation",
	[66996] = "The Heart of the Deck: Reaction",
	[70206] = "Stay awhile and listen: Veritistrasz: 1",
	[70217] = "Stay awhile and listen: Veritistrasz: 4",
	[70219] = "Stay awhile and listen: Veritistrasz: 7",
	[70223] = "Stay awhile and listen: Veritistrasz: 9",
	[70231] = "Talk to Emilia Bellocq",
	[70247] = "Hidden Profession Master: Alchemy",
	[70250] = "Hidden Profession Master: Blacksmith",
	[70251] = "Hidden Profession Master: Enchanting",
	[70252] = "Hidden Profession Master: Engineering",
	[70253] = "Hidden Profession Master: Herbalism",
	[70254] = "Hidden Profession Master: Inscription",
	[70255] = "Hidden Profession Master: Jewelcrafting",
	[70256] = "Hidden Profession Master: Leatherworking",
	[70258] = "Hidden Profession Master: Mining",
	[70259] = "Hidden Profession Master: Skinning",
	[70260] = "Hidden Profession Master: Tailoring",
	[70381] = "DF Weekly Skinning Knowledgepoint #1",
	[70383] = "DF Weekly Skinning Knowledgepoint #2",
	[70384] = "DF Weekly Skinning Knowledgepoint #3",
	[70385] = "DF Weekly Skinning Knowledgepoint #4",
	[70386] = "DF Weekly Skinning Knowledgepoint #5",
	[70389] = "DF Weekly Skinning Knowledgepoint #6",
	[70504] = "DF Alchemy Drop #1: Decayed",
	[70511] = "DF Alchemy Drop #2: Elemental",
	[70512] = "DF Blacksmithing Drop #2: Earth Elemental",
	[70513] = "DF Blacksmithing Drop #1: Fire Elemental",
	[70514] = "DF Enchanting Drop #2: Arcane Elemental",
	[70515] = "DF Enchanting Drop #1: Primalist",
	[70516] = "DF Engineering Drop #2: Tyrhold Ancient",
	[70517] = "DF Engineering Drop #1: Dragon-esque",
	[70518] = "DF Inscription Drop #1: Qalashi Djaradin",
	[70519] = "DF Inscription Drop #2: Dragon-kin/Proto Drakes",
	[70520] = "DF Jewelcrafting Drop #2: Earth Elemental",
	[70521] = "DF Jewelcrafting Drop #1: Well Dressed",
	[70522] = "DF Leatherworking Drop #1: Proto Drake",
	[70523] = "DF Leatherworking Drop #2: Sylvern&Vorquin",
	[70524] = "DF Tailoring Drop #2: Ohn'ahran Humanoid",
	[70525] = "DF Tailoring Drop #1: Beast Humanoid",
	[70543] = "Stay awhile and listen: Veritistrasz: 2",
	[70544] = "Stay awhile and listen: Veritistrasz: 3",
	[70546] = "Stay awhile and listen: Veritistrasz: 5",
	[70547] = "Stay awhile and listen: Veritistrasz: 6",
	[70548] = "Stay awhile and listen: Veritistrasz: 8",
	[70709] = "Talk to: Wu'de Prepfoot",
	[70906] = "1st Weekly Grand Hunt",
	[70907] = "Repeatable Grand Hunt",
	[71136] = "2nd Weekly Grand Hunt",
	[71137] = "3rd Weekly Grand Hunt",
	[71857] = "DF Weekly Herbalism Knowledgepoint #1",
	[71858] = "DF Weekly Herbalism Knowledgepoint #2",
	[71859] = "DF Weekly Herbalism Knowledgepoint #3",
	[71860] = "DF Weekly Herbalism Knowledgepoint #4",
	[71861] = "DF Weekly Herbalism Knowledgepoint #5",
	[71864] = "DF Weekly Herbalism Knowledgepoint #6",
	[71934] = "Disenchanted Glimmer of Fire",
	[71935] = "Disenchanted Glimmer of Frost",
	[71936] = "Disenchanted Glimmer of Air",
	[71937] = "Disenchanted Glimmer of Earth",
	[71938] = "Disenchanted Glimmer of Order",
	[72059] = "Stay awhile and listen: Commander Lethanak",
	[72089] = "To Skytop Observatory",
	[72096] = "Release Kite: Wingrest Embassy",
	[72097] = "Release Kite: Skytop Observatory",
	[72098] = "Release Kite: Crumbling Life Archway",
	[72099] = "Release Kite: Hatchery Observatory",
	[72100] = "Release Kite: Obsidian Observatory",
	[72101] = "Release Kite: Apex Canopy",
	[72102] = "Release Kite: The Overflowing Spring",
	[72103] = "Release Kite: Concord Observatory",
	[72104] = "Release Kite: Uktulut Backwater",
	[72105] = "Release Kite: Life-Binder Conservatory",
	[72160] = "DF Weekly Mining Knowledgepoint #1",
	[72161] = "DF Weekly Mining Knowledgepoint #2",
	[72162] = "DF Weekly Mining Knowledgepoint #3",
	[72163] = "DF Weekly Mining Knowledgepoint #4",
	[72164] = "DF Weekly Mining Knowledgepoint #5",
	[72165] = "DF Weekly Mining Knowledgepoint #6",
	[72174] = "Theory in Practice: Bob",
	[72176] = "Theory in Practice: Toughscale",
	[72177] = "Theory in Practice: Mr.Nibbles",
	[72178] = "Theory in Practice: Baron von Swoopenbite",
	[72179] = "Theory in Practice: Lord Firegiggle",
	[72258] = "Ruby Feast Daily Lockout",
	[72270] = "Talk to Zeldis",
	[72285] = "Stay awhile and listen: Scalecommander Azurathel",
	[72286] = "Stay awhile and listen: Genn Greymane",
	[72287] = "Stay awhile and listen: High Exarch Turalyon",
	[72288] = "Stay awhile and listen: Baine and Mayla",
	[72289] = "Stay awhile and listen: Lor'themar and Thalyssra",
	[72290] = "Stay awhile and listen: Cindrethresh and Emberthal",
	[72351] = "Talk to Zeldis again",
	[72352] = "Move closer to Sneaky Mud Mask",
	[72362] = "Warmode Bounty Looted",
	[72366] = "Dragonflight Campaign Completed [Account]",
	[72376] = "Warmode Crate Looted",
	[72377] = "Warmode Crate Looted",
	[72676] = "Step 1: Dance, Dance 'Til You're Dead",
	[72738] = "Step 7: The Way to an Otto's Heart",
	[72808] = "Step 5: One Last Fish",
	[74105] = "DF Inscription Order: Inscription",
	[74106] = "DF Inscription Order: Mining",
	[74107] = "DF Inscription Order: Herbalism",
	[74108] = "DF Inscription Order: Alchemy",
	[74109] = "DF Inscription Order: Blacksmith",
	[74110] = "DF Inscription Order: Enchanting",
	[74111] = "DF Inscription Order: Engineering",
	[74112] = "DF Inscription Order: Jewelcrafting",
	[74113] = "DF Inscription Order: Leatherworking",
	[74114] = "DF Inscription Order: Skinning",
	[74115] = "DF Inscription Order: Tailoring",
	[74579] = "Daily Zul'Gurub Cache",
	[74957] = "Increased X-45 Heartbreaker Droprate (Daily Accountwide)",
	[75526] = "First Rock Mouse",
	[75527] = "Second Rock Mouse",
	[75534] = "Third Rock Mouse",
	[75535] = "Fourth Rock Mouse",
	[75658] = "Zaralek Cavern Unlocked [Account]",
	[75708] = "Weekly: A Race To The Finish",
	[77230] = "Pay Shakey's Tab",
	[77397] = "Talk with 'Appraiser' Sazsel Stickyfingers",
	[77595] = "Quantum Sword (One-Handed) completed.",
	[77596] = "Quantum Mace (One-Handed) completed.",
	[77597] = "Quantum Axe (One-Handed) completed.",
	[77598] = "Quantum Greatsword (Two-Handed) completed.",
	[77599] = "Quantum Greataxe (Two-Handed) completed.",
	[77600] = "Quantum Greathammer/Mace (Two-Handed) completed.",
	[77601] = "Quantum Staff completed.",
	[77602] = "Quantum Polearm completed.",
	[77603] = "Quantum Bow completed.",
	[77604] = "Quantum Crossbow completed.",
	[77605] = "Quantum Firearm/Gun completed.",
	[77606] = "Quantum Knife/Dagger completed.",
	[77607] = "Quantum Knuckles/Fist Weapon completed.",
	[77608] = "Quantum Warglaives completed.",
	[77609] = "Quantum Focus/Off-hand completed.",
	[77610] = "Quantum Wand completed.",
	[77611] = "Quantum Shield completed.",
	[77622] = "Quantum Legs (Plate) completed.",
	[77623] = "Quantum Legs (Mail) completed.",
	[77624] = "Quantum Legs (Leather) completed.",
	[77625] = "Quantum Legs (Cloth) completed.",
	[77626] = "Quantum Headpiece (Plate) completed.",
	[77627] = "Quantum Headpiece (Mail) completed.",
	[77628] = "Quantum Headpiece (Leather) completed.",
	[77629] = "Quantum Headpiece (Cloth) completed.",
	[77630] = "Quantum Gloves (Plate) completed.",
	[77631] = "Quantum Gloves (Mail) completed.",
	[77632] = "Quantum Gloves (Leather) completed.",
	[77633] = "Quantum Gloves (Cloth) completed.",
	[77634] = "Quantum Chestpiece (Plate) completed.",
	[77635] = "Quantum Chestpiece (Mail) completed.",
	[77636] = "Quantum Chestpiece (Leather) completed.",
	[77637] = "Quantum Chestpiece (Cloth) completed.",
	[77638] = "Quantum Shoulders (Plate) completed.",
	[77639] = "Quantum Shoulders (Mail) completed.",
	[77640] = "Quantum Shoulders (Leather) completed.",
	[77641] = "Quantum Shoulders (Cloth) completed.",
	[77775] = "Coren Direbrew killed. Cheers...",
	[77973] = "Third Lock",
	[77974] = "First Lock",
	[78912] = "When donating to the Gala (daily)",
	[79104] = "Increased Renewed Proto-Drake: Love Armor Droprate (Daily Accountwide)",
	[79706] = "Stay awhile and listen: Faerin Lothar",
	[79971] = "Stay awhile and listen: Alleria Windrunner",
	[80020] = "Stay awhile and listen: Locus-Walker",
	[80099] = "Zalamar Invasion",
	[80100] = "Xibala Incursion",
	[80101] = "Wailing Tideways",
	[80102] = "Tidebreak Summit",
	[80103] = "Valley of a Thousand Legs",
	[80104] = "Scorched Crypt",
	[80105] = "The Eternal Forge",
	[80106] = "Soryn's Meadow",
	[80107] = "The Slagmire",
	[80108] = "Vakthros Summit",
	[80109] = "Obsidian Rest",
	[80413] = "First War Supply Chest of the Day!",
	[80414] = "First War Supply Chest of the Day!",
	[80415] = "First War Supply Chest of the Day!",
	[80416] = "First War Supply Chest of the Day!",
	[80540] = "Bullion Capped",
	[81416] = "TWW Weekly Herbalism Knowledgepoint #1",
	[81417] = "TWW Weekly Herbalism Knowledgepoint #2",
	[81418] = "TWW Weekly Herbalism Knowledgepoint #3",
	[81419] = "TWW Weekly Herbalism Knowledgepoint #4",
	[81420] = "TWW Weekly Herbalism Knowledgepoint #5",
	[81421] = "TWW Weekly Herbalism Knowledgepoint #6",
	[81459] = "TWW Weekly Skinning Knowledgepoint #1",
	[81460] = "TWW Weekly Skinning Knowledgepoint #2",
	[81461] = "TWW Weekly Skinning Knowledgepoint #3",
	[81462] = "TWW Weekly Skinning Knowledgepoint #4",
	[81463] = "TWW Weekly Skinning Knowledgepoint #5",
	[81464] = "TWW Weekly Skinning Knowledgepoint #6",
	[81513] = "Stay awhile and listen: Faerin Lothar",
	[81594] = "Stay awhile and listen: Faerin Lothar",
	[81597] = "The Weaver considers you an Acquaintance.",
	[81598] = "The Weaver considers you a Crony.",
	[81599] = "The Weaver considers you an Accomplice.",
	[81600] = "The Weaver considers you a Collaborator.",
	[81601] = "The General considers you an Acquaintance.",
	[81602] = "The General considers you a Crony.",
	[81603] = "The General considers you an Accomplice.",
	[81604] = "The General considers you a Collaborator.",
	[81605] = "The Vizier considers you an Acquaintance.",
	[81606] = "The Vizier considers you a Crony.",
	[81607] = "The Vizier considers you an Accomplice.",
	[81626] = "The General considers you a Crony.",
	[81627] = "The Weaver considers you a Crony.",
	[81631] = "Stay awhile and listen: Faerin Lothar",
	[81635] = "Stay awhile and listen: Nalina Ironsong",
	[81636] = "Stay awhile and listen: General Steelstrike",
	[81946] = "Stay awhile and listen: Anduin Wrynn",
	[82006] = "Speak to Attica Whiskervale",
	[82012] = "Talk with Sky-Captain Dornald",
	[82024] = "Talk with Sky-Captain Clairmonte",
	[82025] = "Talk with Sky-Captain Aerthin",
	[82026] = "Talk with Sky-Captain Onaro",
	[82033] = "Stay awhile and listen: Alleria Windrunner",
	[82162] = "Stay awhile and listen: Prophet Velen",
	[82459] = "Stay awhile and listen: Anduin Wrynn",
	[82460] = "Stay awhile and listen: Magni Bronzebeard",
	[82461] = "Stay awhile and listen: Dagran Thaurissan II",
	[82462] = "Stay awhile and listen: Moira Thaurissan",
	[82538] = "Stay awhile and listen: General Steelstrike",
	[82541] = "Stay awhile and listen: Merrix <Councilward>",
	[82542] = "Stay awhile and listen: Rooktender Lufsela",
	[82543] = "Increased Noble Flying Carpet Droprate (Daily Accountwide)",
	[82581] = "You heard a rumor. Go and investigate.",
	[82640] = "You heard a rumor. Go and investigate.",
	[82642] = "You heard a rumor. Go and investigate.",
	[82644] = "You heard a rumor. Go and investigate.",
	[82646] = "You heard a rumor. Go and investigate.",
	[82648] = "You heard a rumor. Go and investigate.",
	[82749] = "Times Lost, Found and Borrowed have been reset. You should visit Maera Ashyld at the outskirts of Stagnant Mire.",
	[82751] = "First Crab",
	[82752] = "Second Crab",
	[82753] = "Third Crab",
	[82754] = "Fourth Crab",
	[82755] = "Fifth Crab",
	[82756] = "Sixth Crab",
	[82918] = "Bloody Perch Derby Bonus Mark",
	[82919] = "Crystalline Sturgeon Derby Bonus Mark",
	[82920] = "Bismuth Bitterling Derby Bonus Mark",
	[82921] = "Nibbling Minnow Derby Bonus Mark",
	[82922] = "Whispering Stargazer Derby Bonus Mark",
	[82923] = "Goldengill Trout Derby Bonus Mark",
	[82924] = "Specular Rainbowfish Derby Bonus Mark",
	[82925] = "Quiet River Bass Derby Bonus Mark",
	[82926] = "Dornish Pike Derby Bonus Mark",
	[82927] = "Roaring Anglerseeker Derby Bonus Mark",
	[82928] = "Arathor Hammerfish Derby Bonus Mark",
	[82929] = "Regal Dottyback Derby Bonus Mark",
	[82930] = "Kaheti Slum Shark Derby Bonus Mark",
	[82931] = "Pale Huskfish Derby Bonus Mark",
	[82932] = "Sanguine Dogfish Derby Bonus Mark",
	[82933] = "Spiked Sea Raven Derby Bonus Mark",
	[82934] = "Queen's Lurefish Derby Bonus Mark",
	[82935] = "Cursed Ghoulfish Derby Bonus Mark",
	[82936] = "Awoken Coelacanth Derby Bonus Mark",
	[82947] = "Dilly-Dally Dace Derby Bonus Mark",
	[83049] = "TWW Weekly Mining Knowledgepoint #6",
	[83050] = "TWW Weekly Mining Knowledgepoint #5",
	[83051] = "TWW Weekly Mining Knowledgepoint #4",
	[83052] = "TWW Weekly Mining Knowledgepoint #3",
	[83053] = "TWW Weekly Mining Knowledgepoint #2",
	[83054] = "TWW Weekly Mining Knowledgepoint #1",
	[83093] = "|cFFFFFFFFStep 3|r: Interact with the Half-Buried Dog Bowl",
	[83094] = "|cFFFFFFFFStep 4|r: Interact with Dog",
	[83134] = "Increased Cliffside Wylderdrake: Midsummer Fire Festival Armor Droprate (Daily Accountwide)",
	[83253] = "TWW Weekly Alchemy Treasure #1",
	[83255] = "TWW Weekly Alchemy Treasure #2",
	[83256] = "TWW Weekly Blacksmithing Treasure #2",
	[83257] = "TWW Weekly Blacksmithing Treasure #1",
	[83258] = "TWW Weekly Enchanting Treasure #1",
	[83259] = "TWW Weekly Enchanting Treasure #2",
	[83260] = "TWW Weekly Engineering Treasure #1",
	[83261] = "TWW Weekly Engineering Treasure #2",
	[83262] = "TWW Weekly Inscription Treasure #2",
	[83264] = "TWW Weekly Inscription Treasure #1",
	[83265] = "TWW Weekly Jewelcrafting Treasure #1",
	[83266] = "TWW Weekly Jewelcrafting Treasure #2",
	[83267] = "TWW Weekly Leatherworking Treasure #1",
	[83268] = "TWW Weekly Leatherworking Treasure #2",
	[83269] = "TWW Weekly Tailoring Treasure #2",
	[83270] = "TWW Weekly Tailoring Treasure #1",
	[83300] = "Answer 1: That the Cosmos consisted of monopole elemental phase spaces.",
	[83301] = "Answer 2: Patience and respect.",
	[83302] = "Answer 3: Seek shelter and light. Have plans, have backup plans. Find joy while sheltering.",
	[83303] = "Answer 4: The third fleet.",
	[83304] = "Answer 5: The Remains of gods.",
	[83305] = "Answer 6: From the letters of Mereldar.",
	[83488] = "Rak-Ush Stagshell World Quests Unlocked.",
	[83724] = "|cFFFFFFFFStep 3|r: Return to the Grimoire",
	[83741] = "|cFFFFFFFFStep 1|r: Interact with the Fleshy Grimoire",
	[83744] = "|cFFFFFFFFStep 2D|r: Find Another You in Wildcamp Or'lay",
	[83745] = "|cFFFFFFFFStep 2C|r: Find Another You in Faerin's Advance",
	[83746] = "|cFFFFFFFFStep 2A|r: Find Another You in Mmarl",
	[83747] = "|cFFFFFFFFStep 2B|r: Find Another You in The Weaver's Lair",
	[83831] = "Complete the Guest Relations tutorial quest chain.",
	[84009] = "Stay awhile and listen: Alleria Windrunner",
	[84026] = "Plaguehart weekly reputation obtained.",
	[84028] = "Gar'loc weekly reputation obtained.",
	[84029] = "Escaped Cutthroat weekly reputation obtained.",
	[84030] = "Tempest Lord Incarnus weekly reputation obtained.",
	[84031] = "Kronolith, Might of the Mountain weekly reputation obtained.",
	[84032] = "Shallowshell the Clacker weekly reputation obtained.",
	[84033] = "Twice-Stinger the Wretched weekly reputation obtained.",
	[84034] = "Flamekeeper Graz weekly reputation obtained.",
	[84036] = "Clawbreaker K'zithix weekly reputation obtained.",
	[84037] = "Tephratennae weekly reputation obtained.",
	[84038] = "Sweetspark the Oozeful weekly reputation obtained.",
	[84039] = "Matriarch Charfuria weekly reputation obtained.",
	[84040] = "Terror of Forge weekly reputation obtained.",
	[84041] = "Zilthara weekly reputation obtained.",
	[84042] = "Cragmund weekly reputation obtained.",
	[84043] = "Trungal weekly reputation obtained.",
	[84044] = "Charmonger weekly reputation obtained.",
	[84045] = "Coalesced Monstrosity weekly reputation obtained.",
	[84046] = "Automaxor weekly reputation obtained.",
	[84047] = "Kelpmire weekly reputation obtained.",
	[84048] = "Hungerer of the Deeps weekly reputation obtained.",
	[84049] = "Spore-Infused Shalewing weekly reputation obtained.",
	[84050] = "Disturbed Earthgorger weekly reputation obtained.",
	[84051] = "Moth'ethk weekly reputation obtained.",
	[84052] = "Crazed Cabbage Smacker weekly reputation obtained.",
	[84053] = "Deathpetal weekly reputation obtained.",
	[84054] = "Croakit weekly reputation obtained.",
	[84055] = "Toadstomper weekly reputation obtained.",
	[84056] = "Duskshadow weekly reputation obtained.",
	[84057] = "Parasidious weekly reputation obtained.",
	[84058] = "Ravageant weekly reputation obtained.",
	[84059] = "Finclaw Bloodtide weekly reputation obtained.",
	[84060] = "Murkspike weekly reputation obtained.",
	[84061] = "The Taskmaker weekly reputation obtained.",
	[84062] = "Sloshmuck weekly reputation obtained.",
	[84063] = "Lytfang the Lost weekly reputation obtained.",
	[84064] = "The Perchfather weekly reputation obtained.",
	[84065] = "Horror of the Shallows weekly reputation obtained.",
	[84066] = "Strength of Beledar weekly reputation obtained.",
	[84067] = "Sir Alastair Purefire weekly reputation obtained.",
	[84068] = "Pride of Beledar weekly reputation obtained.",
	[84069] = "The Groundskeeper weekly reputation obtained.",
	[84070] = "Xishorr weekly reputation obtained.",
	[84071] = "Kaheti Silk Hauler weekly reputation obtained.",
	[84072] = "XT-Minecrusher 8700 weekly reputation obtained.",
	[84073] = "Cha'tak weekly reputation obtained.",
	[84074] = "Monstrous Lasharoth weekly reputation obtained.",
	[84075] = "Maddened Siegebomber weekly reputation obtained.",
	[84076] = "Enduring Gutterface weekly reputation obtained.",
	[84077] = "Jix'ak the Crazed weekly reputation obtained.",
	[84078] = "The Oozekhan weekly reputation obtained.",
	[84079] = "Harverster Qixt weekly reputation obtained.",
	[84080] = "Umbraclaw Matra weekly reputation obtained.",
	[84081] = "Deepcrawler Tx'kesh weekly reputation obtained.",
	[84082] = "Skrimisher Sa'zryk weekly reputation obtained.",
	[84139] = "Stay awhile and listen: Anduin Wrynn",
	[84290] = "TWW Weekly Enchanting Disenchant #1",
	[84291] = "TWW Weekly Enchanting Disenchant #2",
	[84292] = "TWW Weekly Enchanting Disenchant #3",
	[84293] = "TWW Weekly Enchanting Disenchant #4",
	[84294] = "TWW Weekly Enchanting Disenchant #5",
	[84295] = "TWW Weekly Enchanting Disenchant #6",
	[84335] = "Stay awhile and listen: Alleria Windrunner",
	[84345] = "Stay awhile and listen: High Exarch Turalyon",
	[84447] = "Unbound Spoils Looted.",
	[84448] = "Unbound Spoils Looted.",
	[84449] = "Unbound Spoils Looted.",
	[84530] = "The General considers you an Accessory.",
	[84531] = "The General considers you an Abettor.",
	[84532] = "The General considers you a Conspirator.",
	[84533] = ("The General considers you a Mastermind. Congratulations, Anub'%s."):format(UnitName("player")),
	[84534] = "The Vizier considers you an Accessory.",
	[84535] = "The Vizier considers you an Abettor.",
	[84536] = "The Vizier considers you a Conspirator.",
	[84537] = ("The Vizier considers you a Mastermind. Congratulations, %s, Hand of the Vizier."):format(UnitName("player")),
	[84538] = "The Weaver considers you an Accessory.",
	[84539] = "The Weaver considers you an Abettor.",
	[84540] = "The Weaver considers you a Conspirator.",
	[84541] = ("The Weaver considers you a Mastermind. Congratulations, Silksinger %s."):format(UnitName("player")),
	[84562] = "Severed Threads Active",
	[84620] = "Stay awhile and listen: Magni Bronzebeard",
	[84631] = "Awakening The Machine: Wave 5 Completed.",
	[84632] = "Awakening The Machine: Wave 10 Completed.",
	[84633] = "Awakening The Machine: Wave 15 Completed.",
	[84634] = "Awakening The Machine: Wave 20 Completed. Congratulations.",
	[84676] = "Acquire The Light of Their Love buff stacked 3 times",
	[84677] = "Acquire the Key of Shadows from the Ny'Alotha Obelisk",
	[84685] = "Talk to the Dalaran Survivor while using the Detective title",
	[84699] = "Stay awhile and listen: Moira Thaurissan",
	[84702] = "Press the Red Button 100 times",
	[84703] = "Press the Red Button 1000 times",
	[84743] = "Stay awhile and listen: Moira Thaurissan",
	[84754] = "Stay awhile and listen: Alleria Windrunner",
	[84780] = "Use the Scroll of Fel Binding at Uther's Tomb",
	[84786] = "Acquire the Piece of Hate from the Lucky slot machine consoles",
	[84806] = "Appease the Spirit of Collections (Sin)",
	[84807] = "Appease the Spirit of Collections (Corruption)",
	[84808] = "Appease the Spirit of Collections (Temptation)",
	[84809] = "Appease the Spirit of Collections (Blood)",
	[84810] = "Appease the Spirit of Collections (Shadow)",
	[84811] = "Acquire the Ancient Shaman Blood",
	[84813] = "Stay awhile and listen: Rooktender Lufsela",
	[84814] = "Stay awhile and listen: Dagran Thaurissan II (Vault of Memory)",
	[84815] = "Stay awhile and listen: Merrix <Councilward>",
	[84823] = "Acquire the Warden's Mirror",
	[84829] = "Insert the Ancient Shaman Blood into the Enigma Machine",
	[84830] = "Insert the Warden's Mirror into the Enigma Machine",
	[84837] = "Decipher the Enigma Machine",
	[84916] = "Place the Sentry Statue in the Vault of Mirrors",
	[85103] = "Stay awhile and listen: Apprentice Tanmar",
	[85156] = "Stay awhile and listen: Angorla",
	[85157] = "Stay awhile and listen: Didi the Wrench",
	[85159] = "Zovex weekly reputation obtained.",
	[85160] = "Kereke weekly reputation obtained.",
	[85161] = "Rotfist weekly reputation obtained.",
	[85162] = "Deepflayer Broodmother weekly reputation obtained.",
	[85163] = "Lurker of the Deeps weekly reputation obtained.",
	[85164] = "Beledar's Spawn weekly reputation obtained.",
	[85165] = "Deathtide weekly reputation obtained.",
	[85166] = "Tka'ktath weekly reputation obtained.",
	[85167] = "The One Left weekly reputation obtained.",
	[85680] = "Stay awhile and listen: Adelgonn ",
	[85681] = "Stay awhile and listen: Moira Thaurissan",
	[85682] = "Stay awhile and listen: Magni Bronzebeard",
	[85799] = "Use the Turbulent Runekey in The Forgotten Vault (Storm Phase)",
	[85800] = "Use the Cyclonic Runekey in The Forgotten Vault (Storm Phase)",
	[85801] = "Use the Torrential Runekey in The Forgotten Vault (Storm Phase)",
	[85802] = "Use the Whirling Runekey in The Forgotten Vault (Storm Phase)",
	[85803] = "Use the Thunderous Runekey in The Forgotten Vault (Storm Phase)",
	[86240] = "Give Marmaduke the Well Loved Squeaky Toy",
	[86818] = "Stay awhile and listen: Archamge Aethas Sunreaver",
	[86819] = "Stay awhile and listen: Archmage Khadgar",
}
L.SOURCE_NAMES = {
	[90628] = "Monel-Hardened Breastplate",
	[90629] = "Monel-Hardened Boots",
	[90630] = "Monel-Hardened Gauntlets",
	[90631] = "Monel-Hardened Helm",
	[90632] = "Monel-Hardened Greaves",
	[90633] = "Monel-Hardened Pauldrons",
	[90634] = "Monel-Hardened Waistguard",
	[90635] = "Monel-Hardened Armguards",
	[90636] = "Stormsteel Legguards",
	[90637] = "Stormsteel Girdle",
	[90638] = "Monel-Hardened Shield",
	[90639] = "Monel-Hardened Shield",
	[90640] = "Monel-Hardened Shield",
	[90641] = "Stormsteel Shield",
	[90642] = "Stormsteel Shield",
	[90643] = "Stormsteel Shield",
	[90644] = "Monel-Hardened Hatchet",
	[90645] = "Monel-Hardened Hatchet",
	[90646] = "Monel-Hardened Hatchet",
	[90647] = "Monel-Hardened Battleaxe",
	[90648] = "Monel-Hardened Battleaxe",
	[90649] = "Monel-Hardened Battleaxe",
	[90653] = "Monel-Hardened Cutlass",
	[90654] = "Monel-Hardened Cutlass",
	[90655] = "Monel-Hardened Cutlass",
	[90656] = "Monel-Hardened Claymore",
	[90657] = "Monel-Hardened Claymore",
	[90658] = "Monel-Hardened Claymore",
	[90662] = "Monel-Hardened Deckpounder",
	[90663] = "Monel-Hardened Deckpounder",
	[90664] = "Monel-Hardened Deckpounder",
	[90665] = "Monel-Hardened Shanker",
	[90666] = "Monel-Hardened Shanker",
	[90667] = "Monel-Hardened Shanker",
	[90668] = "Monel-Hardened Polearm",
	[90669] = "Monel-Hardened Polearm",
	[90670] = "Monel-Hardened Polearm",
	[90671] = "Stormsteel Spear",
	[90672] = "Stormsteel Spear",
	[90673] = "Stormsteel Spear",
	[90674] = "Stormsteel Dagger",
	[90675] = "Stormsteel Dagger",
	[90676] = "Stormsteel Dagger",
	[90677] = "Stormsteel Greatsword",
	[90678] = "Stormsteel Greatsword",
	[90679] = "Stormsteel Greatsword",
	[90683] = "Stormsteel Axe",
	[90684] = "Stormsteel Axe",
	[90685] = "Stormsteel Axe",
	[95894] = "Honorable Combatant's Shield",
	[95895] = "Honorable Combatant's Shield",
	[95896] = "Honorable Combatant's Shield",
	[95897] = "Honorable Combatant's Hatchet",
	[95898] = "Honorable Combatant's Hatchet",
	[95899] = "Honorable Combatant's Hatchet",
	[95900] = "Honorable Combatant's Cutlass",
	[95901] = "Honorable Combatant's Cutlass",
	[95902] = "Honorable Combatant's Cutlass",
	[95903] = "Honorable Combatant's Battleaxe",
	[95904] = "Honorable Combatant's Battleaxe",
	[95905] = "Honorable Combatant's Battleaxe",
	[95906] = "Honorable Combatant's Deckpounder",
	[95907] = "Honorable Combatant's Deckpounder",
	[95908] = "Honorable Combatant's Deckpounder",
	[95909] = "Honorable Combatant's Claymore",
	[95910] = "Honorable Combatant's Claymore",
	[95911] = "Honorable Combatant's Claymore",
	[95912] = "Honorable Combatant's Shanker",
	[95913] = "Honorable Combatant's Shanker",
	[95914] = "Honorable Combatant's Shanker",
	[95915] = "Honorable Combatant's Polearm",
	[95916] = "Honorable Combatant's Polearm",
	[95917] = "Honorable Combatant's Polearm",
	[95920] = "Honorable Combatant's Plate Boots",
	[95922] = "Honorable Combatant's Plate Gauntlets",
	[95926] = "Honorable Combatant's Plate Greaves",
	[95930] = "Honorable Combatant's Plate Waistguard",
	[95932] = "Honorable Combatant's Plate Armguards",
	[97972] = "Stormsteel Shield",
	[97973] = "Stormsteel Shield",
	[97974] = "Stormsteel Shield",
	[97975] = "Honorable Combatant's Aegis",
	[97976] = "Honorable Combatant's Aegis",
	[97977] = "Honorable Combatant's Aegis",
	[97978] = "Honorable Combatant's Plate Boots",
	[97980] = "Honorable Combatant's Plate Gauntlets",
	[97982] = "Honorable Combatant's Plate Greaves",
	[97984] = "Honorable Combatant's Plate Waistguard",
	[97986] = "Honorable Combatant's Plate Armguards",
	[98004] = "Monel-Hardened Polearm",
	[98005] = "Monel-Hardened Polearm",
	[98006] = "Monel-Hardened Polearm",
	[98007] = "Stormsteel Spear",
	[98008] = "Stormsteel Spear",
	[98009] = "Stormsteel Spear",
	[98010] = "Stormsteel Dagger",
	[98011] = "Stormsteel Dagger",
	[98012] = "Stormsteel Dagger",
	[98013] = "Honorable Combatant's Cutlass",
	[98014] = "Honorable Combatant's Cutlass",
	[98015] = "Honorable Combatant's Cutlass",
	[98016] = "Honorable Combatant's Deckpounder",
	[98017] = "Honorable Combatant's Deckpounder",
	[98018] = "Honorable Combatant's Deckpounder",
	[98019] = "Honorable Combatant's Shanker",
	[98020] = "Honorable Combatant's Shanker",
	[98021] = "Honorable Combatant's Shanker",
	[98022] = "Honorable Combatant's Polearm",
	[98023] = "Honorable Combatant's Polearm",
	[98024] = "Honorable Combatant's Polearm",
	[99938] = "Honorable Combatant's Plate Boots",
	[99939] = "Honorable Combatant's Plate Boots",
	[99940] = "Honorable Combatant's Plate Gauntlets",
	[99941] = "Honorable Combatant's Plate Gauntlets",
	[99942] = "Honorable Combatant's Plate Greaves",
	[99943] = "Honorable Combatant's Plate Greaves",
	[99944] = "Honorable Combatant's Plate Waistguard",
	[99945] = "Honorable Combatant's Plate Waistguard",
	[99946] = "Honorable Combatant's Plate Armguards",
	[99947] = "Honorable Combatant's Plate Armguards",
	[100021] = "Honorable Combatant's Plate Boots",
	[100022] = "Honorable Combatant's Plate Boots",
	[100023] = "Honorable Combatant's Plate Gauntlets",
	[100024] = "Honorable Combatant's Plate Gauntlets",
	[100025] = "Honorable Combatant's Plate Greaves",
	[100026] = "Honorable Combatant's Plate Greaves",
	[100027] = "Honorable Combatant's Plate Waistguard",
	[100028] = "Honorable Combatant's Plate Waistguard",
	[100029] = "Honorable Combatant's Plate Armguards",
	[100030] = "Honorable Combatant's Plate Armguards",
}

-- Supported Locales
local simplifiedLocale = GetLocale():sub(1,2);
if simplifiedLocale == "de" then
localize(L.HEADER_NAMES, {
	[-1000006] = "Zusätzliche Beute",
	[-1000008] = "Klassenprozess",
	[-1000010] = "Gemeinsame Bossbeute",
	[-1000019] = "Erkundung",
	[-1000035] = "Rätsel",
	[-1000048] = "Drachen des Alptraums",
	[-1000087] = "Paktangriffe",
	[-1000089] = "Sanktumaufwertungen",
	[-1000090] = "Seelengestalt Formen",
	[-1000091] = "Gebäude",
	[-1000092] = "Garnisonen",
	[-1000132] = "Hasserfüllten Gladiator",
	[-1000138] = "Aspiranten Rüstung",
	[-1000139] = "Kämpfer Rüstung",
	[-1000140] = "Elite Rüstung",
	[-1000141] = "Gladiatoren Rüstung",
	[-1000145] = "Alle Rollen",
	[-1000146] = "DDs",
	[-1000147] = "Heiler",
	[-1000162] = "Geteilte Vorlagen",
	[-1000163] = "Einzigartige Vorlagen",
	[-1000168] = "Die Vier Reiter",
	[-1000179] = "Friedhof",
	[-1000180] = "Bibliothek",
	[-1000181] = "Waffenkammer",
	[-1000182] = "Kathedrale",
	[-1000186] = "Sturm auf die Zitadelle",
	[-1000187] = "Die Seuchenwerke",
	[-1000201] = "Dunkelmond-Jahrmarkt",
	[-1000203] = "Dunkelmond-Jahrmarkt Tanzspiel",
	[-1000204] = "Herausforderung des Feuervogels",
	[-1000205] = "Schießbude",
	[-1000206] = "Hau-den-Gnoll",
	[-1000207] = "Tag der Toten",
	[-1000210] = "Der Pokal der Östlichen Königreiche",
	[-1000211] = "Kalimdorpokal",
	[-1000219] = "Angelwettstreit der Kalu'ak",
	[-1000223] = "Sonnenwendfest",
	[-1000226] = "Piratentag",
	[-1000227] = "Anglerwettbewerb im Schlingendorntal",
	[-1000235] = "Die Öffnung des Dunklen Portals",
	[-1000236] = "Das Szepter der Sandstürme",
	[-1000261] = "Hearthstone Söldner",
	[-1000301] = "Schlachtzugbrowser (5.4)",
	[-1000304] = "Heroisch (5.4)",
	[-1000305] = "Schrottplatz",
	[-1000309] = "Angriff auf das Dunkle Portal",
	[-1000312] = "Grenze des Äons",
	[-1000316] = "Ereignisliste",
	[-1000317] = "Der große Odyn und der Feuerlord",
	[-1000318] = "Der Wanderer und die Schlange",
	[-1000319] = "Hallen des Goldes und des Ruhmes",
	[-1000320] = "Das Auge des Hüters",
	[-1000321] = "Die erste der Val'kyr",
	[-1000322] = "Die Versiegelung der Hallen der Tapferkeit",
	[-1000329] = "Ereignisliste",
	[-1000336] = "Rang 1",
	[-1000337] = "Rang 2",
	[-1000338] = "Rang 3",
	[-1000339] = "Rang 4",
	[-1000340] = "Zerbrochener Spiegel",
	[-1000341] = "Zerbrochener Spiegel",
	[-1000342] = "Zerbrochener Spiegel",
	[-1000343] = "Zerbrochener Spiegel",
	[-1000344] = "Zerbrochener Spiegel",
	[-1000345] = "Zerbrochener Spiegel",
	[-1000346] = "Zerbrochener Spiegel",
	[-1000347] = "Zerbrochener Spiegel",
	[-1000348] = "Zerbrochener Spiegel",
	[-1000349] = "Zerbrochener Spiegel",
	[-1000350] = "Zerbrochener Spiegel",
	[-1000351] = "Zerbrochener Spiegel",
	[-1000352] = "Klan Aylaag",
	[-1000365] = "20. Geburtstag von Diablo",
	[-1000366] = "Ein gieriger Abgesandter",
	[-1000373] = "Neuer Charakter",
	[-1000374] = "Verbündete Völker",
	[-1000375] = "10. Jubiläum von Hearthstone",
	[-1000379] = "Kopfgeld",
	[-1000380] = "Kopfgeld",
	[-1000381] = "Kukurus Schatzkammer",
	[-1000853] = "Kriegsrat der Sargerei",
	[-1000855] = "Todesschwadron der Verlassenen",
	[-1000858] = "Amateurjäger",
	[-1000862] = "Kataklysmischer Gladiator: Season 11",
	[-1000865] = "Schlachtfeld: Brachland",
	[-1000869] = "Die Eiserne Invasion",
	[-1000870] = "Trollinvasion",
	[-1000883] = "Haustierkampf Instanzen",
	[-1000919] = "Traditionsrüstung",
	[-1000923] = "Drachenwächtermanuskript",
	[-1000924] = "Urstürme",
	[-1000937] = "Gewölbe von Zskera",
	[-1000938] = "Schnüffelsuchen",
	[-1000944] = "Tauschhandels",
	[-1000945] = "Angriffe von Fyrakk",
	[-1001006] = "Garnisonskampagne",
	[-1001034] = "Elementare Bande",
	[-1001035] = "Saisonfisch: Sommerbarsch",
	[-1001036] = "Saisonfisch: Winterkalmar",
	[-1001045] = "Gästebetreuungen",
	[-1001059] = "Feuerstürme",
	[-1001060] = "Sandstürme",
	[-1001061] = "Schneestürme",
	[-1001062] = "Gewitterstürme",
	[-1001087] = "Außenposten",
	[-1001094] = "Ungewertet",
	[-1001095] = "|cffFF0000Ogom der Mangler scheint gerade dann zu erscheinen, wenn Sie den täglichen „Angriff auf das Eiserne Belagerungswerk“ durchführen. Diese Quest war seit Beginn von Legion nicht mehr aktiv und die käufliche Quest „Missive: Angriff auf das Eiserne Belagerungswerk“ funktioniert auch nicht.|r",
	[-1001096] = "|cFFFFFFFFSchritt 1:|r Auffällige Notiz",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000025] = "Es muss möglicherweise ein bestimmter Feiertag aktiv sein, um hier genannte Dinge abschließen zu können.",
	[-1000162] = "Die Gegenstände in dieser Liste teilen ihre Vorlage mit dem oben genannten Gegenstand. Im Modus für Einzigartige Vorlagen kann diese Liste Ihnen helfen zu verstehen, warum ein bestimmter Gegenstand als gesammelt markiert ist, oder ob nicht.",
	[-1000163] = "Dieser Gegenstand hat eine einzigartige Vorlage. Ihr müsst diesen Gegenstand erhalten, um die Vorlage eurer Sammlung hinzuzufügen.",
	[-1000380] = "Diese Liste enthält nicht erhältliche Gegenstände, die von ATT Discord als Fehler gemeldet wurden, die Blizzard noch beheben muss.\n\nHINWEIS: Alle Filter werden aus Sichtbarkeitsgründen in dieser Liste ignoriert. In dieser Liste sind nur Gegenstände enthalten, die aufgrund von Fahrlässigkeit aus dem Spiel entfernt wurden, und nicht ein riesiger feuerspeiender Drache.\n\nAn Blizzard-Entwickler: Bitte beheben Sie die unten aufgeführten Gegenstände und Begegnungen.",
	[-1000853] = "Streift ungefähr im Kreis durch das Gebiet.",
	[-1000855] = "Es gibt einen laufenden 4x4-Kampf. Unterstützen Sie die Allianz, indem Sie die Todesschwadron der Forsaken besiegen.",
	[-1000856] = "Es gibt einen laufenden 4x4-Kampf. Unterstützen Sie die Horde, indem Sie die Worgenpirscher besiegen.",
	[-1000858] = "Drei Jäger haben Mara Swiftmane umzingelt. Wenn Sie sie in den Kampf verwickeln, wird in der Nähe von Mara Swiftmane eine zerschlagene Truhe erscheinen. Sobald der Kampf vorbei ist, wird Mara sich bei Ihnen bedanken und Sie mit der ramponierten Truhe zurücklassen.",
});
localize(L.FILTER_ID_TYPES, {
	[11] = "Artefakte",
	[103] = "Waffenverzauberungen",
});
localize(ObjectNames, {
	[31] = "Alte Löwenstatue",
	[33] = "Verschlossene Truhe",
	[34] = "Alter Henkelkrug",
	[35] = "Schließkiste des Kapitäns",
	[36] = "Zerbrochenes Fass",
	[47] = "GESUCHT:",
	[55] = "Ein halb aufgefressener Körper",
	[56] = "Rolfs Leichnam",
	[59] = "Ein Haufen lockere Erde",
	[60] = "GESUCHT: Gath'Ilzogg",
	[61] = "Ein verwittertes Grab",
	[76] = "Ein leerer Krug",
	[256] = "GESUCHT",
	[257] = "Verdächtiges Fass",
	[259] = "Halb vergrabenes Fass",
	[261] = "Beschädigte Kiste",
	[269] = "Bewachtes Fass mit Donnerbräu Lager",
	[270] = "Unbewachtes Fass mit Donnerbräu Lager",
	[287] = "Buchmacher Herods Aufzeichnungen",
	[288] = "Buchmacher Herods Geldkassette",
	[711] = "GESUCHT!",
	[1557] = "Lilliths Esstisch",
	[1561] = "Versiegelte Kiste",
	[1585] = "Sprengladung",
	[1586] = "Kiste mit Kerzen",
	[1593] = "Boot mit Leichen",
	[1599] = "Flaches Grab",
	[1609] = "Katapult des Drachenmals",
	[1610] = "Pyrophor-Mineralvorkommen",
	[1627] = "Kiste aus Dalaran",
	[1728] = "Staubiger Teppich",
	[1738] = "Dokumente des Syndikats",
	[1739] = "Dokumente des Syndikats",
	[1740] = "Dokumente des Syndikats",
	[1763] = "GESUCHT",
	[1765] = "Abgenutzte Holztruhe",
	[2008] = "Gefährlich!",
	[2059] = "Eine Zwergenleiche",
	[2076] = "Blubbernder Kessel",
	[2083] = "Blutsegelkorrespondenz",
	[2289] = "Unbrauchbares Rettungsboot",
	[2553] = "Eine glitschige Rolle",
	[2554] = "Cortellos Rätsel",
	[2555] = "Modrige Rolle",
	[2560] = "Halb vergrabene Flasche",
	[2652] = "Ebenezer Rostlockes Leichnam",
	[2656] = "Durchnässter Brief",
	[2688] = "Schlüsselstein",
	[2701] = "Regenbogenfarbene Splitter",
	[2702] = "Stein der Inneren Bindung",
	[2713] = "Steckbriefbrett",
	[2734] = "Vollgelaufene Truhe",
	[2744] = "Riesenmuschel",
	[2868] = "Zerknitterte Karte",
	[2875] = "Ramponiertes Zwergenskelett",
	[2908] = "Versiegelte Vorratskiste",
	[2933] = "Siegel der Erde",
	[3076] = "Schmutzbefleckte Karte",
	[3238] = "Chens leeres Fässchen",
	[3239] = "Benedicts Truhe",
	[3643] = "Alte Schließkiste",
	[3972] = "GESUCHT",
	[4141] = "Steuerkonsole",
	[5620] = "Fehlerhafte Kraftsteine",
	[6751] = "Sonderbare fruchtbeladene Pflanze",
	[6752] = "Sonderbare wedelbestückte Pflanze",
	[7510] = "Sprießender Wedel",
	[10076] = "Wahrsageschale",
	[12666] = "Zwielichtfoliant",
	[15084] = "Der Funkelmat 5200",
	[15085] = "Der Funkelmat 5200",
	[17182] = "Dröhnkiste 827",
	[17183] = "Dröhnkiste 411",
	[17184] = "Dröhnkiste 323",
	[19023] = "|cFFFFFFFFSchritt 7:|r Seite 2351",
	[19024] = "Verborgener Schrein",
	[19595] = "Torhüter-Unterstand",
	[19599] = "Krallenbau-Hort",
	[19861] = "Henrik Lonebrows Tagebuch",
	[20805] = "Rizzels Pläne",
	[20985] = "Lockere Erde",
	[20992] = "Schwarzer Schild",
	[21015] = "Hufabdrücke",
	[21016] = "Hufabdrücke",
	[21042] = "Abzeichen der Wache von Theramore",
	[21581] = "Folgen des Zweiten Krieges",
	[21582] = "Jenseits des Dunklen Portals",
	[21583] = "Die Kaldorei und der Brunnen der Ewigkeit",
	[28604] = "Verstreute Kiste",
	[32569] = "Galens Geldkassette",
	[35251] = "Karnitols Truhe",
	[50961] = "Malems Truhe",
	[51708] = "Elizas Graberde",
	[61934] = "Kohlenpfanne der schlafenden Flamme",
	[103821] = "Doans Geldkassette",
	[112888] = "Staubiges Regal",
	[112948] = "Verschlossene Geldkassette der 'Kühnheit'",
	[113757] = "Schattenschmiedecache",
	[113791] = "Kohlenpfanne von Everfount",
	[123329] = "Baelogs Truhe",
	[125477] = "Verdächtige Urne",
	[131474] = "Die Scheiben von Norgannon",
	[138492] = "Splitter von Myzrael",
	[141931] = "Hippogryphenei",
	[141979] = "Antiker Schatz",
	[141980] = "Geisterhafte Schließkassette",
	[142071] = "Ei-o-Mat",
	[142088] = "Schrifttafel des Willens",
	[142122] = "Steckbrief",
	[142127] = "Rin'jis Geheimnis",
	[142151] = "Versiegeltes Fass",
	[142179] = "Pavillon von Solarsal",
	[142184] = "Truhe des Kapitäns",
	[142189] = "Unauffälliger Orientierungspunkt",
	[142195] = "Schlachtplan der Waldpfoten",
	[142343] = "Podest von Uldum",
	[142345] = "Matrix-Prägograph 3005-A",
	[142475] = "Matrix-Prägograph 3005-B",
	[142476] = "Matrix-Prägograph 3005-C",
	[142487] = "Der Funkelmat 5200",
	[142696] = "Matrix-Prägograph 3005-D",
	[142702] = "Giftflasche",
	[142958] = "Feralas: Ein historischer Abriss",
	[143980] = "Gordunnischriftrolle",
	[144063] = "Monolith von Equinex",
	[144064] = "Gordunnierdhügel",
	[148498] = "Altar von Suntara",
	[148502] = "|cFFFFFFFFSchritt 1:|r Seite 9",
	[148504] = "Ein verdächtiger Grabstein",
	[148512] = "Essenz-Born",
	[148832] = "Statue der Atal'ai",
	[148836] = "Altar von Hakkar",
	[148838] = "Götze von Hakkar",
	[149047] = "Fackel der Vergeltung",
	[149502] = "Hort des schwarzen Drachenschwarms",
	[150075] = "Steckbrief",
	[151286] = "Kaldoreifoliant der Beschwörung",
	[152097] = "Belnistrasz' Kohlenpfanne",
	[157936] = "Erdhaufen von Un'Goro",
	[160836] = "Reliktkasten",
	[160845] = "Dunkler Kasten",
	[161495] = "Geheimsafe",
	[161504] = "Ein kleines Pack",
	[161505] = "Ein havariertes Floß",
	[161521] = "Forscherausrüstung",
	[161526] = "Kiste mit Lebensmitteln",
	[164659] = "Grüner Machtkristall",
	[164661] = "Gelber Machtkristall",
	[164689] = "Denkmal für Franclorn Schmiedevater",
	[164778] = "Blauer Machtkristall",
	[164780] = "Roter Machtkristall",
	[164798] = "Evowurzel",
	[164820] = "Namensschild des Dunkelbewahrers",
	[164867] = "GESUCHT",
	[164868] = "SOFORT TÖTEN",
	[164869] = "Spektraler Kelch",
	[164885] = "Verderbter Nachtdrache",
	[164886] = "Verderbte Liedblume",
	[164887] = "Verderbte Windblüte",
	[164888] = "Verderbte Peitscherwurzel",
	[164909] = "Havariertes Ruderboot",
	[164911] = "Fässchen mit Donnerbräu Lagerbier",
	[164953] = "Große Lederrucksäcke",
	[164954] = "Kapsel der Zukk'ash",
	[164955] = "Nördlicher Kristallpylon",
	[164956] = "Westlicher Kristallpylon",
	[164957] = "Östlicher Kristallpylon",
	[164958] = "Blutblütensprössling",
	[165554] = "Herz des Berges",
	[169243] = "Truhe der Sieben",
	[171939] = "Verderbte Liedblume",
	[171942] = "Verderbte Liedblume",
	[173232] = "Schmiedekunstpläne",
	[173265] = "Hölzernes Plumpsklo",
	[173284] = "Verderbte Peitscherwurzel",
	[173324] = "Verderbter Nachtdrache",
	[173327] = "Verderbte Windblüte",
	[174594] = "Verderbte Liedblume",
	[174595] = "Verderbte Liedblume",
	[174596] = "Verderbte Liedblume",
	[174597] = "Verderbte Liedblume",
	[174598] = "Verderbte Liedblume",
	[174599] = "Verderbte Windblüte",
	[174600] = "Verderbte Windblüte",
	[174601] = "Verderbte Windblüte",
	[174602] = "Verderbte Windblüte",
	[174603] = "Verderbte Windblüte",
	[174604] = "Verderbte Windblüte",
	[174605] = "Verderbte Peitscherwurzel",
	[174606] = "Verderbte Peitscherwurzel",
	[174607] = "Verderbte Peitscherwurzel",
	[174608] = "Verderbter Nachtdrache",
	[174682] = "Vorsicht, Pterrordax!",
	[174684] = "Verderbter Nachtdrache",
	[174686] = "Verderbte Peitscherwurzel",
	[174708] = "Verderbte Windblüte",
	[174709] = "Verderbte Windblüte",
	[174712] = "Verderbte Liedblume",
	[174713] = "Verderbte Liedblume",
	[174848] = "Testausrüstung",
	[175226] = "Gestrandete Meereskreatur",
	[175227] = "Gestrandete Meereskreatur",
	[175230] = "Gestrandete Meereskreatur",
	[175233] = "Gestrandete Meereskreatur",
	[175245] = "Vater Flamme",
	[175320] = "GESUCHT: Gurgelbacke!",
	[175369] = "Dienstboteneingang am Ältestenplatz",
	[175382] = "Doomriggers Kasten",
	[175385] = "Dunkelsteinschrifttafel",
	[175524] = "Geheimnisvoller roter Kristall",
	[175586] = "Jarons Wagen",
	[175587] = "Beschädigte Kiste",
	[175621] = "Uroks Tributhaufen",
	[175704] = "Angesengter Brief",
	[175724] = "Sargeras und der Verrat",
	[175725] = "Die Alten Götter und die Ordnung von Azeroth",
	[175726] = "Der Bund der Drachenschwärme",
	[175727] = "Der Krieg der Ahnen",
	[175729] = "Der Hyjal und Illidans Geschenk",
	[175730] = "Der Weltenbaum und der Smaragdgrüne Traum",
	[175731] = "Die Verbannung der Hochelfen",
	[175732] = "Die Schildwachen und die lange Wacht",
	[175733] = "Die Gründung von Quel'Thalas",
	[175734] = "Arathor und die Trollkriege",
	[175735] = "Die Wächter von Tirisfal",
	[175736] = "Eisenschmiede - Das Erwachen der Zwerge",
	[175737] = "Die sieben Königreiche",
	[175738] = "Aegwynn und die Drachenjagd",
	[175739] = "Krieg der Drei Hämmer",
	[175740] = "Der letzte Wächter",
	[175741] = "Kil'jaeden und der Schattenpakt",
	[175742] = "Aufstieg der Horde",
	[175745] = "Das Dunkle Portal und der Untergang von Sturmwind",
	[175746] = "Die Allianz von Lordaeron",
	[175747] = "Die Invasion von Draenor",
	[175748] = "Die Geburt des Lichkönigs",
	[175749] = "Eiskrone und Frostthron",
	[175750] = "Die Schlacht von Grim Batol",
	[175751] = "Die Lethargie der Orcs",
	[175752] = "Die neue Horde",
	[175753] = "Der Krieg der Spinne",
	[175754] = "Kel'Thuzad und das Entstehen der Geißel",
	[175756] = "Die Geißel von Lordaeron",
	[175757] = "Sonnenbrunnen - Der Fall von Quel'Thalas",
	[175758] = "Archimondes Rückkehr und die Flucht nach Kalimdor",
	[175759] = "Der aufstrebende Verräter",
	[175760] = "Aufstieg der Blutelfen",
	[175761] = "Bürgerkrieg in den Pestländern",
	[175762] = "Der Triumph des Lichkönigs",
	[175763] = "Alter Hass - Die Kolonialisierung von Kalimdor",
	[175854] = "Die Zwillingsimperien",
	[175855] = "Der Fall des Imperiums",
	[175856] = "Der Zorn des Seelenschinders",
	[175886] = "Beschlagene Pike",
	[175894] = "Janices Paket",
	[175924] = "Verschlossener Schrank",
	[175925] = "Plumpsklo",
	[175926] = "Frau Dalsons Tagebuch",
	[175949] = "Fünfte Schrifttafel von Mosh'aru",
	[175950] = "Sechste Schrifttafel von Mosh'aru",
	[175965] = "Frostraunens Balsamierungsflüssigkeit",
	[175966] = "Verzauberter scharlachroter Faden",
	[175970] = "Ungeschmiedete runenverzierte Brustplatte",
	[176089] = "Ungebrannte Plattenstulpen",
	[176090] = "Menschliche Überreste",
	[176091] = "Kessel der Totenwaldfelle",
	[176112] = "Malors Geldkassette",
	[176115] = "Steckbrief: Arnak Grimmtotem",
	[176116] = "Pamelas Puppenkopf",
	[176142] = "Pamelas Puppe, linke Seite",
	[176143] = "Pamelas Puppe, rechte Seite",
	[176190] = "Gestrandete Meeresschildkröte",
	[176191] = "Gestrandete Meeresschildkröte",
	[176192] = "Verzeichnis der Abtrünnigen",
	[176196] = "Gestrandete Meeresschildkröte",
	[176197] = "Gestrandete Meeresschildkröte",
	[176198] = "Gestrandete Meeresschildkröte",
	[176249] = "Geißeldaten",
	[176317] = "Der Argentumtresor",
	[176325] = "Schmiedekunstpläne",
	[176361] = "Geißelkessel",
	[176392] = "Geißelkessel",
	[176393] = "Geißelkessel",
	[176582] = "Schalentierfalle",
	[176631] = "Menethils Geschenk",
	[177289] = "Geißelkessel",
	[177490] = "Kiste vom Sägewerk des Nordkamms",
	[177491] = "Termitenfass",
	[177544] = "Josephs Truhe",
	[177667] = "Zerrissene Rolle",
	[177675] = "Erdhaufen",
	[177786] = "Rackmores Truhe",
	[177787] = "Rackmores Logbuch",
	[177904] = "Steckbrief: Besseleth",
	[177964] = "Tiefenstein",
	[178609] = "Feiertagsschnee",
	[179485] = "Beschädigte Falle",
	[179499] = "Gerbekorb der Oger",
	[179501] = "Knot Zwingschraubs Behälter",
	[179517] = "Schatz der Shen'dralar",
	[179545] = "Die Truhe des Prinzen",
	[179547] = "Ein verstaubter Foliant",
	[179551] = "Hydraxis Truhe",
	[179552] = "Bauplan: Feldreparaturbot 74A",
	[179559] = "Teufelsrankensplitter",
	[179562] = "Erhitzte Uralte Klinge",
	[179564] = "Tribut der Gordok",
	[179697] = "Arenaschatztruhe",
	[179703] = "Behälter des Feuerfürsten",
	[179827] = "Gesucht/Vermisst/Verloren & Gefunden",
	[179832] = "Verziertes Kissen von Kissenquetscher",
	[179879] = "Befehlskugel",
	[179880] = "Drakkisaths Brandzeichen",
	[179913] = "Zu den Waffen!",
	[180215] = "Thoriumvorkommen der Hakkari",
	[180229] = "Verwunschener Hoodoohaufen",
	[180327] = "Kohlenpfanne des Wahnsinns",
	[180366] = "Ramponierter Ausrüstungskasten",
	[180368] = "Schrifttafel des Wahnsinns",
	[180369] = "Schlammiges aufgewühltes Gewässer",
	[180448] = "Steckbrief: Totenstachel",
	[180456] = "Geringer Windstein",
	[180461] = "Windstein",
	[180466] = "Großer Windstein",
	[180503] = "Sandiges Kochbuch",
	[180526] = "Gong von Bethekk",
	[180570] = "Bierfässchen",
	[180633] = "Kristallträne",
	[180642] = "Unscheinbare Kiste",
	[180652] = "Frisch aufgewühlter Dreck",
	[180658] = "Ein Schwarm Deviatfische",
	[180662] = "Schiffswrackteile",
	[180665] = "Drakonisch für Dummies",
	[180666] = "Drakonisch für Dummies",
	[180667] = "Drakonisch für Dummies",
	[180682] = "Ein Schwarm öliger Schwarzmaulfische",
	[180684] = "Ein Schwarm großer Weisenfische",
	[180685] = "Schwimmende Wrackteile",
	[180690] = "Großer Skarabäuskasten",
	[180691] = "Skarabäuskasten",
	[180712] = "Steinschuppenaalschwarm",
	[180717] = "Der Skarabäusgong",
	[180743] = "Sorgfältig verpacktes Geschenk",
	[180746] = "Leicht geschütteltes Geschenk",
	[180747] = "Fröhlich verpacktes Geschenk",
	[180748] = "Tickendes Geschenk",
	[180751] = "Treibende Wrackteile",
	[180793] = "Festtagsgeschenk",
	[180794] = "Tagebuch von Jandice Barov",
	[180796] = "PX-238 Winterwundervolt",
	[180901] = "Blutsegelwrackteile",
	[180918] = "GESUCHT: Thaelis der Manadurstige",
	[181011] = "Magister Nachtschimmers Tagebuch",
	[181073] = "Duftender Kessel",
	[181074] = "Arenabeute",
	[181083] = "Sothos' und Jariens Erbstücke",
	[181085] = "Vorratskiste von Stratholme",
	[181147] = "Steckbrief",
	[181150] = "Staubiges Tagebuch",
	[181153] = "Gesucht: Kel'gash der Boshafte",
	[181366] = "Truhe der Vier Reiter",
	[181638] = "Steckbrief",
	[181643] = "Federbarts Überreste",
	[181649] = "Federbarts Tagebuch",
	[181665] = "Grabtruhe",
	[181698] = "Leerstein",
	[181748] = "Blutkristall",
	[181756] = "Zerfleddertes altes Buch",
	[181889] = "Steckbrief",
	[182032] = "Galaens Tagebuch",
	[182053] = "Glühkappe",
	[182115] = "Steckbrief",
	[182165] = "Steckbrief",
	[182196] = "Arkaner Behälter",
	[182197] = "Arkaner Behälter",
	[182198] = "Arkaner Behälter",
	[182392] = "Aushang von Garadar",
	[182393] = "Aushang von Telaar",
	[182549] = "Höllenorcpläne",
	[182587] = "Steckbrief",
	[182588] = "Steckbrief",
	[182947] = "Kodex des Blutes",
	[182952] = "Treibgut der Dampfpumpe",
	[182953] = "Ein Schwarm Sporenfische",
	[182954] = "Ein Brackwasserschwarm",
	[182956] = "Ein Schwarm Stachelflosser",
	[182957] = "Ein Hochlandschwarm",
	[182958] = "Ein Schwarm Matschflosser",
	[182959] = "Ein Schwarm Blauflossen",
	[183284] = "Steckbrief",
	[183385] = "Bluthibiskus",
	[183770] = "Steuerkonsole von B'naar",
	[183811] = "Steckbrief",
	[183877] = "Bedienungskonsole des Astraltransporters",
	[184300] = "Nekromantischer Fokus",
	[184465] = "Behälter der Legion",
	[184660] = "Steckbrief",
	[184793] = "Primitive Truhe",
	[184825] = "Foliant der Lashh'an",
	[184945] = "Steckbrief",
	[184946] = "Steckbrief",
	[185035] = "Steckbrief",
	[185119] = "Staubbedeckte Truhe",
	[185126] = "Kristallgefängnis",
	[185165] = "Legionskommunikator",
	[185166] = "Steckbrief",
	[185168] = "Verstärkte Teufelseisentruhe",
	[185302] = "Fei-Feis Versteck",
	[185522] = "Shaffars Stasiskammer",
	[186183] = "Festtagsfass der Gerstenbräus",
	[186184] = "Festtagsfass der Donnerbräus",
	[186185] = "Festtagsfass der Gordok",
	[186186] = "Festtagsfass der Brauerei Drohn",
	[186187] = "Festtagsfass von T'chalis Voodoobrauerei",
	[186267] = "Kürbisschrein",
	[186426] = "Steckbrief",
	[186585] = "Rolle aus Drachenhaut",
	[186887] = "Große Kürbislaterne",
	[187236] = "Winterhauchgeschenk",
	[187273] = "Verdächtiger Hufabdruck",
	[187367] = "Winterflossenmuschel",
	[187565] = "Ältester Atkanok",
	[187851] = "Kultistenschrein",
	[187905] = "Schweres leuchtendes Ei",
	[188085] = "Verseuchtes Korn",
	[188192] = "Eiskiste",
	[188261] = "Zerfleddertes Tagebuch",
	[188364] = "Defekte Krabbenfalle",
	[188365] = "Herz der Uralten",
	[188367] = "Tragbarer Seismograph",
	[188418] = "GESUCHT!",
	[188419] = "Ältester Mana'loa",
	[188501] = "Teil eines Kriegsgolems",
	[188502] = "Teil eines Kriegsgolems",
	[188503] = "Teil eines Kriegsgolems",
	[188649] = "Steckbrief",
	[188667] = "Bernsteinsamen",
	[189311] = "Fleischgebundener Foliant",
	[189989] = "Zerstörte Maulwurfmaschine der Dunkeleisenzwerge",
	[189990] = "Zerstörte Maulwurfmaschine der Dunkeleisenzwerge",
	[190020] = "GESUCHT!",
	[190447] = "Motor einer Flugmaschine",
	[190453] = "Ersatzteile der Venture Co.",
	[190454] = "Ersatzteile der Venture Co.",
	[190455] = "Ersatzteile der Venture Co.",
	[190622] = "Robuste Ranke",
	[190625] = "Bananenstaude",
	[190643] = "Donnerbräus Dschungelpunsch",
	[190768] = "Verwitterte Kiste",
	[190917] = "Liegengelassene Post",
	[190936] = "Seuchenkessel",
	[191543] = "Truhe des Scharlachroten Ansturms",
	[191728] = "GESUCHT!",
	[191760] = "Konsole der Bibliothek des Erfinders",
	[191761] = "Prototypenkonsole",
	[191766] = "Drakurus Befehle",
	[192046] = "Ein Schwarm Muschelrückengroppen",
	[192048] = "Ein Schwarm Engelsdrachenfische",
	[192049] = "Ein Schwarm Fangzahnheringe",
	[192050] = "Ein Schwarm Winterlachse",
	[192051] = "Ein Schwarm boreanischer Galeeren",
	[192052] = "Ein Schwarm imperialer Mantarochen",
	[192053] = "Ein Schwarm Tiefseemonsterbäuche",
	[192054] = "Ein Schwarm Mondlichtsepia",
	[192057] = "Ein Schwarm Nesselfische",
	[192059] = "Ein Schwarm Glasflossenelritzen",
	[192060] = "Fjorns Amboss",
	[192071] = "Fjorns Amboss",
	[192072] = "Harpunenkiste",
	[192078] = "Hodirs Horn",
	[192079] = "Hodirs Speer",
	[192080] = "Hodirs Helm",
	[192524] = "Arngrimm der Unersättliche",
	[192708] = "Die Schulen der arkanen Magie - Einleitung",
	[192709] = "Die Schulen der arkanen Magie - Bannung",
	[192710] = "Die Schulen der arkanen Magie - Beschwörung",
	[192711] = "Die Schulen der arkanen Magie - Weissagung",
	[192713] = "Die Schulen der arkanen Magie - Verzauberung",
	[192818] = "Energieerfüllter Pilz",
	[192827] = "Wilder Senf",
	[192828] = "Kristallsangkarotte",
	[192833] = "Bridenbrads Hab und Gut",
	[192865] = "Die Schulen der arkanen Magie - Illusion",
	[192866] = "Die Schulen der arkanen Magie - Nekromantie",
	[192867] = "Die Schulen der arkanen Magie - Transmutation",
	[193195] = "Gefrorenes Herz",
	[193400] = "Saronitbombenstapel",
	[193402] = "Verrostete Truhe eines Gefangenen",
	[193426] = "Truhe der Vier Reiter",
	[194092] = "Geschwärzte Urne",
	[194105] = "Dröhnkiste 413",
	[194122] = "Dröhnkiste 723",
	[194213] = "Winterhyazinthe",
	[194238] = "Klinge von Drak'Mar",
	[194378] = "Gestohlenes Dokument der Forscherliga",
	[194387] = "Gestohlenes Dokument der Forscherliga",
	[194388] = "Gestohlenes Dokument der Forscherliga",
	[194389] = "Gestohlenes Dokument der Forscherliga",
	[194390] = "Gestohlenes Dokument der Forscherliga",
	[194391] = "Gestohlenes Dokument der Forscherliga",
	[194479] = "Blut im Wasser",
	[194555] = "Archivumkonsole",
	[194618] = "Lanzenständer",
	[194622] = "Lanzenständer",
	[194714] = "Widerliche Werkbank",
	[194908] = "Lanzenständer",
	[194909] = "Lanzenständer",
	[195134] = "Die Bombe",
	[195431] = "Hauptquartierfunkgerät",
	[195433] = "Uralte Schrifttafel",
	[195435] = "Waffenkiste",
	[195438] = "Elunes Kelch",
	[195445] = "Uralter Vortexrunenstein",
	[195497] = "Elunes Kohlenbecken",
	[195517] = "Elunes Dienstmaid",
	[195600] = "Schwelender Stein",
	[195642] = "Kraftstein der Naga",
	[195676] = "Geheimer Laborquäkkasten",
	[196393] = "Zerbrochenes Relikt",
	[196394] = "Kiste mit Alraunenessenz",
	[196832] = "Oberer Seherstein",
	[196833] = "Unterer Seherstein",
	[201578] = "Rekrutierungsplakat für Schraubgesellen",
	[201873] = "Truhe des Kanonenboots",
	[202080] = "Pfeils Nest",
	[202081] = "Takks Nest",
	[202082] = "Nest der Ravasaurusmatriarchin",
	[202083] = "Nest der Scharfzahnmatriarchin",
	[202135] = "Dadangas Grab",
	[202180] = "Truhe des Kanonenboots",
	[202407] = "Sandscharrers Kiste",
	[202474] = "Vorsintflutliche Kiste",
	[202598] = "Großer fieser Auslöser",
	[202613] = "Plattformsteuerungskonsole",
	[202655] = "Archäologischer trollischer Fund",
	[202697] = "Auge des Zwielichts",
	[202701] = "Plumpskloversteck",
	[202706] = "Kessel des Schattenhammers",
	[202712] = "Die Zwielichtapokryphen",
	[202776] = "Ein Schwarm Bergforellen",
	[202777] = "Ein Schwarm Hochlandguppys",
	[202778] = "Ein Schwarm Albinohöhlenfische",
	[202779] = "Ein Schwarm Schwarzbauchmatschflosser",
	[202780] = "Klafteraalschwarm",
	[202871] = "Versunkene Kiste",
	[202975] = "Plumpsklo unter Wasser",
	[203071] = "Archäologischer nachtelfischer Fund",
	[203078] = "Archäologischer nerubischer Fund",
	[203128] = "Zerbrochene Flasche",
	[203134] = "Leeres Podest",
	[203140] = "Zerbrochene Zacke",
	[203186] = "BETRETEN VERBOTEN!",
	[203207] = "Kodex der Schatten",
	[203301] = "Dreizacke der Naga",
	[203305] = "Schmelztiegel von Nazsharin",
	[203733] = "Steckbrieftafel",
	[203734] = "Urkunde von Westfall",
	[203755] = "Rekrutierungsplakat für Schraubgesellen",
	[204050] = "Blaupausen der Feindbrecher",
	[204274] = "Logbuch des Kapitäns",
	[204282] = "Archäologischer zwergischer Fund",
	[204344] = "GESUCHT!",
	[204351] = "Ettinsteuerungskugel",
	[204372] = "Zanzils Portal",
	[204386] = "Zanzils Portal",
	[204406] = "Halb vergrabene Flasche",
	[204437] = "Schwarzfelsschlüsselbeutel",
	[204450] = "Kapitän Stillwassers Karten",
	[204578] = "Fass mit Doppelrum",
	[204817] = "Lichtgeschmiedete Rute",
	[204824] = "Lichtgeschmiedeter Bogen",
	[204825] = "Lichtgeschmiedetes Wappen",
	[204959] = "Riesiger Painithaufen",
	[205134] = "Logbuch des Schmiedemeisters",
	[205143] = "Verlassenes Plumpsklo",
	[205198] = "Sprengstoffhaufen",
	[205207] = "Maziels Tagebuch",
	[205258] = "Zerbrochene Waffenkiste",
	[205266] = "Aufwendige Scheibe",
	[205332] = "Steckbrief",
	[205350] = "Kommunikationskonsole der Horde",
	[205476] = "Buch der verlorenen Seelen",
	[205477] = "Mondstahlbarren",
	[205479] = "Mondbestrahltes Holz",
	[205540] = "Verfallenes Skelett",
	[205874] = "Sandbedeckte Hieroglyphen",
	[205875] = "Leuchtsignal des Kreuzzüglers",
	[206109] = "Auf Befehl des Kriegshäuptlings",
	[206111] = "Heldenaufruf",
	[206116] = "Auf Befehl des Kriegshäuptlings",
	[206293] = "A.I.D.A.-Terminal",
	[206294] = "Heldenaufruf",
	[206335] = "Steinplatte",
	[206336] = "Marmorplatte",
	[206374] = "Schatz der Behüter",
	[206504] = "Rheas Abschiedsnotiz",
	[206569] = "Auge des Zwielichts",
	[206585] = "Totem von Ruumbo",
	[206836] = "Archäologischer fossiler Fund",
	[206944] = "Schaufel",
	[207104] = "Hauptkontrollpumpe",
	[207125] = "Kiste mit übriggebliebenen Vorräten",
	[207179] = "Kessel",
	[207187] = "Archäologischer orcischer Fund",
	[207188] = "Archäologischer draeneiischer Fund",
	[207189] = "Archäologischer Fund der Vrykul",
	[207190] = "Archäologischer Fund der Tol'vir",
	[207279] = "Auf Befehl des Kriegshäuptlings",
	[207303] = "Abenteuertafel",
	[207304] = "Abenteuertafel",
	[207320] = "Heldenaufruf",
	[207321] = "Heldenaufruf",
	[207322] = "Heldenaufruf",
	[207323] = "Auf Befehl des Kriegshäuptlings",
	[207324] = "Auf Befehl des Kriegshäuptlings",
	[207325] = "Auf Befehl des Kriegshäuptlings",
	[207359] = "Reines Zwielichtei",
	[207406] = "Seltsamer Brunnen",
	[207407] = "Zerbrochene Säule",
	[207408] = "Magische Kohlenpfanne",
	[207409] = "Grab der Tol'vir",
	[207410] = "Große Steintafel",
	[207411] = "Zwergischer Knochenhaufen",
	[207412] = "Steintafel",
	[207496] = "Schatzkiste der Dunkeleisenzwerge",
	[207497] = "Schatzkiste der Dunkeleisenzwerge",
	[207498] = "Schatzkiste der Dunkeleisenzwerge",
	[207500] = "Schatzkiste der Dunkeleisenzwerge",
	[207724] = "Schiffswracktrümmer",
	[208311] = "Ein Schwarm Tiefseeweisenfische",
	[208316] = "Heldenaufruf",
	[208317] = "Auf Befehl des Kriegshäuptlings",
	[208365] = "Vor kurzem aufgewühlter Erdhaufen",
	[208535] = "Getrocknete Eichel",
	[208549] = "Voodoohaufen",
	[208550] = "Voodoohaufen",
	[208825] = "Schrein der Vorfahren",
	[208900] = "Portal in die Feuerlande",
	[209072] = "Gestohlene Kiste",
	[209076] = "Ansons Kiste",
	[209094] = "Gestohlene Kiste",
	[209095] = "Edgars Kiste",
	[209270] = "|cFFFFFFFFSchritt 2:|r Seite 78",
	[209344] = "Obstgartenwerkzeug",
	[209345] = "Obstgartenwerkzeug",
	[209436] = "Reife Orange",
	[209462] = "Rattanrute",
	[209497] = "Gestohlene Süßigkeiten",
	[209550] = "Rötelblattbüschel",
	[209620] = "Dunkelmond-Schatzkiste",
	[209673] = "Säule des Jadetigers",
	[209699] = "Jadecong",
	[209700] = "Gesprungene Ritualschale",
	[209701] = "Geruchsintensive Ritualkerze",
	[209825] = "Gezeitennebelkappe",
	[209836] = "Frisch gefallene Blütenblätter",
	[209842] = "Pangs besonders scharfer Tofu",
	[209843] = "Angs Sommerwassermelone",
	[209844] = "Angs riesige rosa Rübe",
	[209845] = "Köstliches Gebräu",
	[209863] = "Jadebrocken",
	[209891] = "Gestohlene Rübe",
	[209892] = "Gestohlene Wassermelone",
	[209903] = "Grüner Zweig",
	[209907] = "Wiesenringelblume",
	[209921] = "Schlammiges Wasser",
	[209951] = "Seidenstück",
	[209952] = "Jademond",
	[209953] = "Kaiserschwalbenei",
	[209954] = "Ei eines Weißkopfkranichs",
	[209955] = "Ei eines Hornschnabelschreiters",
	[210001] = "Gestohlener Malzsack",
	[210002] = "Gestohlener Gerstesack",
	[210005] = "Waffenständer",
	[210015] = "Waffenständer",
	[210016] = "Waffenständer",
	[210017] = "Waffenständer",
	[210018] = "Waffenständer",
	[210019] = "Waffenständer",
	[210020] = "Waffenständer",
	[210184] = "Glitschiger Matschflosser",
	[210186] = "Glitschiger Matschflosser",
	[210188] = "Regennasse Honigwaben",
	[210209] = "Kaiserlicher Lotus",
	[210228] = "Pigmentkrug",
	[210229] = "Wasser der Jugend",
	[210238] = "Schlangenei",
	[210239] = "Schlangenei",
	[210240] = "Schlangenei",
	[210416] = "Moguartefakt",
	[210417] = "Moguartefakt",
	[210418] = "Moguartefakt",
	[210565] = "Dunkle Erde",
	[210582] = "Dunkle Erde",
	[210759] = "Pfeil für Kommandantin Hsieh",
	[210887] = "Unverdorbene Versorgungsgüter",
	[211017] = "Wurzelgemüse",
	[211018] = "Wurzelgemüse",
	[211019] = "Wurzelgemüse",
	[211023] = "Gusseiserner Topf",
	[211143] = "Mogurelikt",
	[211147] = "Mogurelikt",
	[211148] = "Mogurelikt",
	[211266] = "Gestohlene Versorgungsgüter",
	[211268] = "Gestohlene Versorgungsgüter",
	[211269] = "Gestohlene Versorgungsgüter",
	[211270] = "Gestohlene Versorgungsgüter",
	[211312] = "Explosives Fass",
	[211379] = "Holzbrett",
	[211382] = "Zäher Seetang",
	[211420] = "Sandklumpen",
	[211424] = "Alchemieschriftrolle",
	[211451] = "Himmelblaue Gabe des Kranichs",
	[211452] = "Bronzene Gabe des Kranichs",
	[211454] = "Kafa'kota-Strauch",
	[211480] = "Kafa'kota-Beeren",
	[211506] = "Topf mit Pech",
	[211507] = "Topf mit Pech",
	[211510] = "Besitztümer des Weisen Liao",
	[211517] = "Knotranke",
	[211518] = "Knotranke",
	[211536] = "Gestohlene Tasche mit Glücksbringern",
	[211537] = "Gestohlene Tasche mit Glücksbringern",
	[211538] = "Gestohlene Tasche mit Glücksbringern",
	[211566] = "Bleichwindtotem",
	[211684] = "Zunderblüte",
	[211696] = "Gestohlener Hopfensack",
	[211719] = "Zitronenveilchen",
	[211721] = "Zitronenveilchen",
	[211754] = "Seltsamer Text",
	[211770] = "Tafel aus der Shendynastie",
	[211780] = "Seltsamer Text",
	[211793] = "Tafel der Waidynastie",
	[211794] = "Tafel der Qiangdynastie",
	[211807] = "Mogutruhe",
	[211863] = "Krik'thik-Bein",
	[211871] = "Schreckenskugel",
	[211872] = "Schreckenskugel",
	[211873] = "Schreckenskugel",
	[211967] = "Truhe des Königs",
	[211990] = "Ho-zen-Sprache",
	[211993] = "Ho-zen-Reife",
	[211994] = "Die Verwüstung der Ho-zen",
	[212003] = "Ölfass der Yaungol",
	[212009] = "Bernfragment",
	[212079] = "Mantisrelikt",
	[212135] = "Feuerpfeile der Shado-Pan",
	[212136] = "Feuerpfeile der Shado-Pan",
	[212181] = "Uralte Statue",
	[212278] = "Geschütztes Ungafass",
	[212389] = "Rolle der Vorzeichen",
	[212540] = "Verlorenes Fässchen",
	[212541] = "Verlorener Krug",
	[212553] = "Verlorene Picknickutensilien",
	[212902] = "Ausgehärteter Bern",
	[212923] = "Bernsammler",
	[212987] = "Stacheliger Seestern",
	[212988] = "Stacheliger Seestern",
	[213267] = "Angstschatten",
	[213327] = "Die Saurok",
	[213328] = "Der Trotzkopf",
	[213329] = "Die Deserteure",
	[213330] = "Das letzte Gefecht",
	[213331] = "Tal der Kaiser",
	[213332] = "Die verlorene Dynastie",
	[213333] = "Geisterbinder",
	[213334] = "Der Donnerkönig",
	[213362] = "Schiffstruhe",
	[213363] = "Wodins Mantisfetzer",
	[213364] = "Uralte pandarische Spitzhacke",
	[213366] = "Uralter pandarischer Teekessel",
	[213368] = "Pandarische Glücksmünze",
	[213407] = "Quan Tou Kuo der Zweifäustige",
	[213409] = "Zyklus der Mantis",
	[213410] = "Mantisgesellschaft",
	[213411] = "Bern",
	[213412] = "Die Kaiserin",
	[213413] = "Pandarische Kampftaktiken",
	[213414] = "Vergesst niemals",
	[213415] = "Die ersten Mönche",
	[213416] = "Gemeinsam sind wir stark",
	[213417] = "Taktiken der Yaungol",
	[213418] = "Vorherrschaft",
	[213420] = "Gefangen in einem fremden Land",
	[213421] = "Des Kaisers Bürde - Teil 3",
	[213422] = "Des Kaisers Bürde - Teil 4",
	[213438] = "Ren Yun der Blinde",
	[213443] = "Des Kaisers Bürde - Teil 6",
	[213445] = "Des Kaisers Bürde - Teil 5",
	[213454] = "Tropfs Spind",
	[213455] = "Des Kaisers Bürde - Teil 7",
	[213456] = "Des Kaisers Bürde - Teil 8",
	[213459] = "Der Geburtsort Liu Langs",
	[213460] = "Ein berühmt-berüchtigter Kaufvertrag",
	[213461] = "Die wandernde Witwe",
	[213511] = "Sieg am Kun-Lai",
	[213512] = "Xin Wo Yin mit dem gebrochenen Herzen",
	[213649] = "Truhe mit geklauten Waren",
	[213650] = "Schatztruhe der Shed-Ling",
	[213651] = "Ausrüstungsspind",
	[213653] = "Pandarischer Fischspeer",
	[213741] = "Uralter Stab der Jinyu",
	[213742] = "Hammer der zehn Donner",
	[213748] = "Pandarischer Ritualstein",
	[213749] = "Stab des verborgenen Meisters",
	[213750] = "Steintafel der Saurok",
	[213751] = "Stoffkiste des Berggeists",
	[213765] = "Tafel von Ren Yun",
	[213767] = "Versteckter Schatz",
	[213768] = "Kriegerspeer der Ho-zen",
	[213769] = "Schatztruhe der Ho-zen",
	[213770] = "Gestohlene Berggeiststatue",
	[213771] = "Statue von Xuen",
	[213774] = "Besitztümer des verschollenen Abenteurers",
	[213782] = "Terrakottakopf",
	[213793] = "Rikktiks Schatulle",
	[213795] = "Geheimnisse der Sturmbräus",
	[213842] = "Stapel mit Yaungolwaffen",
	[213844] = "In Bern eingeschlossene Motte",
	[213845] = "Der Hammer der Torheit",
	[213956] = "Fragment des Schreckens",
	[213959] = "Erstarrtes Harz von Kri'vess",
	[213960] = "Feuerträger der Yaungol",
	[213961] = "Zurückgelassene Warenkiste",
	[213962] = "Schnellstoßdolch des Windschnitters",
	[213964] = "Maliks tapferer Speer",
	[213966] = "In Bern eingeschlossene Halskette",
	[213967] = "Klinge des Ersten",
	[213968] = "Schwärmendes Spaltbeil von Ka'roz",
	[213969] = "Mutationsstab des Sezierers",
	[213970] = "Blutgetränktes Chitinfragment",
	[213971] = "Medaillon des Schwarmwächters",
	[213972] = "Klinge des vergifteten Geistes",
	[213973] = "Schallrelais der Klaxxi",
	[214062] = "Leuchtender Bern",
	[214170] = "Ei der Vor'thik",
	[214175] = "Tasche mit Wukaowaren",
	[214325] = "Vergessene Schließkassette",
	[214337] = "Edelsteinkästchen",
	[214338] = "Opfergabe des Erinnerns",
	[214339] = "Kiste mit Vorräten",
	[214340] = "Bootsbauanweisungen",
	[214403] = "Papierstapel",
	[214407] = "Mo-Mos Schatztruhe",
	[214438] = "Uralte Mogutafel",
	[214439] = "Fass mit Bananenrum",
	[214562] = "Sha-besessener Kristall",
	[214871] = "Zerschmetterter Zerstörer",
	[214903] = "Der Tan-Chao",
	[214945] = "Onyxei",
	[214962] = "Requirierter Raketenzünder",
	[215705] = "Schrein der Ackerbauern",
	[215765] = "Warten auf die Schildkröte",
	[215779] = "Wasserschmieden",
	[215780] = "Wassersprecher",
	[215782] = "Ursprünge",
	[215783] = "Berufung",
	[215785] = "Hingabe zur Leidenschaft",
	[215797] = "Des Kaisers Bürde - Teil 2",
	[215798] = "Yaungöl",
	[215799] = "Des Kaisers Bürde - Teil 1",
	[215844] = "Flaggenmast",
	[216322] = "Steckbrieftafel",
	[216362] = "Ein Fass Metallbräu",
	[216761] = "Ein Schwarm Meeresfische",
	[216764] = "Ein Schwarm Weisenfische",
	[218055] = "Loabeseelte Klinge",
	[218056] = "Loabeseelte Klinge",
	[218059] = "Zandalaritrank",
	[218427] = "Weg zur Mündigkeit",
	[218428] = "Für Rat und König",
	[218429] = "Die Schatten des Loa",
	[218430] = "Der dunkle Prophet Zul",
	[218432] = "Der heilige Berg",
	[218433] = "Einigkeit hat ihren Preis",
	[218434] = "Das Problem mit den Pandaren",
	[218435] = "Vertreter der Ordnung",
	[218436] = "Schatten, Sturm und Stein",
	[218437] = "Der Fluch und das Schweigen",
	[218438] = "Das Zeitalter der Hundert Könige",
	[218593] = "Schatztruhe des Donnerkönigs",
	[218750] = "Arbeitsaufträge",
	[218853] = "Sturmtruhe",
	[220641] = "Donnerfürstentruhe",
	[220807] = "Ewiges Geistergehölz",
	[220815] = "Einsturzstelle",
	[220820] = "|cFFFFFFFFSchritt 6:|r Seite 1127",
	[220821] = "|cFFFFFFFFSchritt 5:|r Seite 845",
	[220832] = "Versunkener Schatz",
	[220901] = "Funkelnde Schatztruhe",
	[220902] = "Verschnürte Schatztruhe",
	[220903] = "Glitzernde Kranichstatue",
	[220904] = "Felsbrecherhammer",
	[220908] = "Nebelbedeckte Schatztruhe",
	[220986] = "Schwarzwaches Strandgut",
	[220994] = "Zeitlose Truhe",
	[220995] = "Zeitlose Truhe",
	[220996] = "Zeitlose Truhe",
	[220997] = "Zeitlose Truhe",
	[220998] = "Zeitlose Truhe",
	[220999] = "Zeitlose Truhe",
	[221000] = "Zeitlose Truhe",
	[221001] = "Zeitlose Truhe",
	[221002] = "Zeitlose Truhe",
	[221003] = "Zeitlose Truhe",
	[221004] = "Zeitlose Truhe",
	[221005] = "Zeitlose Truhe",
	[221006] = "Zeitlose Truhe",
	[221007] = "Zeitlose Truhe",
	[221008] = "Zeitlose Truhe",
	[221009] = "Zeitlose Truhe",
	[221010] = "Zeitlose Truhe",
	[221013] = "Zeitlose Truhe",
	[221014] = "Zeitlose Truhe",
	[221015] = "Zeitlose Truhe",
	[221016] = "Zeitlose Truhe",
	[221017] = "Zeitlose Truhe",
	[221018] = "Zeitlose Truhe",
	[221019] = "Zeitlose Truhe",
	[221020] = "Zeitlose Truhe",
	[221021] = "Zeitlose Truhe",
	[221023] = "Zeitlose Truhe",
	[221024] = "Zeitlose Truhe",
	[221026] = "Zeitlose Truhe",
	[221027] = "Verdächtig leerer Panzer",
	[221036] = "Funkelnder Schatzbeutel",
	[221376] = "Fragment des alten Zeichens",
	[221413] = "Schriftrolle der Familie Lin",
	[221617] = "Totenkopftruhe",
	[221670] = "Moosüberwucherte Truhe",
	[221671] = "Robuste Truhe",
	[221672] = "Schwelende Truhe",
	[221673] = "Lodernde Truhe",
	[221689] = "Reife Knackfrucht",
	[221690] = "Sandbedecktes Ei",
	[221725] = "Aufgeladener Kristall",
	[221747] = "Riesiger Yakbraten",
	[221763] = "Feuermohn",
	[221764] = "Gerösteter Samen",
	[222684] = "Glitzernder Sand",
	[222685] = "Kranichnest",
	[222686] = "Unheimlicher Kristall",
	[222687] = "Vorräte von Ordos",
	[222688] = "Feuersturmei",
	[222689] = "Feueraltar von Ordos",
	[222776] = "Zeitverlorener Schrein",
	[222796] = "Helm der Familie Wolkenschlag",
	[223084] = "Moosüberwucherte Truhe",
	[223085] = "Moosüberwucherte Truhe",
	[223086] = "Moosüberwucherte Truhe",
	[223087] = "Moosüberwucherte Truhe",
	[223088] = "Moosüberwucherte Truhe",
	[223089] = "Moosüberwucherte Truhe",
	[223090] = "Moosüberwucherte Truhe",
	[223091] = "Moosüberwucherte Truhe",
	[223092] = "Moosüberwucherte Truhe",
	[223093] = "Moosüberwucherte Truhe",
	[223094] = "Moosüberwucherte Truhe",
	[223095] = "Moosüberwucherte Truhe",
	[223096] = "Moosüberwucherte Truhe",
	[223097] = "Moosüberwucherte Truhe",
	[223098] = "Moosüberwucherte Truhe",
	[223099] = "Moosüberwucherte Truhe",
	[223100] = "Moosüberwucherte Truhe",
	[223101] = "Moosüberwucherte Truhe",
	[223102] = "Moosüberwucherte Truhe",
	[223103] = "Moosüberwucherte Truhe",
	[223104] = "Moosüberwucherte Truhe",
	[223105] = "Moosüberwucherte Truhe",
	[223106] = "Moosüberwucherte Truhe",
	[223107] = "Moosüberwucherte Truhe",
	[223108] = "Moosüberwucherte Truhe",
	[223109] = "Moosüberwucherte Truhe",
	[223110] = "Moosüberwucherte Truhe",
	[223111] = "Moosüberwucherte Truhe",
	[223112] = "Moosüberwucherte Truhe",
	[223113] = "Moosüberwucherte Truhe",
	[223114] = "Moosüberwucherte Truhe",
	[223115] = "Moosüberwucherte Truhe",
	[223116] = "Robuste Truhe",
	[223117] = "Robuste Truhe",
	[223118] = "Robuste Truhe",
	[223119] = "Schwelende Truhe",
	[223139] = "Verfluchter Grabstein",
	[223193] = "Riesenmuschel",
	[223204] = "Moosüberwucherte Truhe",
	[223228] = "Südseefeuerbräu",
	[223533] = "Friedliche Opfergabe",
	[223537] = "Flammenherzschal",
	[223538] = "Dreizack des Flusssprechers",
	[223539] = "Schneewehentigerkrallen",
	[224228] = "Blubbernder Kessel",
	[224306] = "Gesprengte Fesseln",
	[224392] = "Sklavengeheimvorrat",
	[224613] = "Zuschauerkiste",
	[224616] = "Obsidianpetroglyphe",
	[224623] = "Wackelndes Ei",
	[224633] = "Vorräte der Eisernen Horde",
	[224713] = "Truhe der Felsbrecher",
	[224750] = "Hängender Ranzen",
	[224753] = "Schuppiges Rylakei",
	[224754] = "Vollgelaufene Truhe",
	[224755] = "Tribut der Eisernen Horde",
	[224756] = "Alchemistenbeutel",
	[224770] = "Schatz des Exilanten des Schattenmondklans",
	[224780] = "Opferdolch des Schattenmondklans",
	[224781] = "Zerfallender Korb",
	[224783] = "Behälter mit doppeltem Boden",
	[224784] = "Truhe des Verteidigers",
	[224785] = "Dämonentruhe",
	[225501] = "Friedliche Opfergabe",
	[225502] = "Friedliche Opfergabe",
	[225503] = "Friedliche Opfergabe",
	[225596] = "Stachlige Kaktusfeige",
	[225726] = "Stilllegungsbefehl für den Eisenschredder",
	[225778] = "Barums Notizen",
	[226468] = "Schamanenstein der Frostwölfe",
	[226831] = "Kiste des Astrologen",
	[226854] = "Gepanzerter Elekkstoßzahn",
	[226861] = "Ronokks Habseligkeiten",
	[226862] = "Riesiger Mondweidenzapfen",
	[226865] = "Fracht der Rabenkönigin",
	[226955] = "Kriegshorn des Arenameisters",
	[226956] = "Haufen mysteriöser Früchte",
	[226961] = "Steckbrieftafel",
	[226967] = "Lagunenteich",
	[226976] = "Deceptias schwelende Stiefel",
	[226983] = "Klippenspringertruhe",
	[226990] = "Versorgungslager",
	[226993] = "Vorratslager eines Überlebenskünstlers",
	[226994] = "Grimmfrostschatz",
	[226996] = "Gorenessensreste",
	[227069] = "Hastig geschriebene Notiz",
	[227134] = "Lieferung der Eisernen Horde",
	[227504] = "Stachelspeer der Donnerfürsten",
	[227527] = "Lichtbringer",
	[227587] = "Yuuris Geschenk",
	[227654] = "Knochenmalmerspeer",
	[227737] = "Kommunikator des Schattenrats",
	[227743] = "Fantastischer Fisch",
	[227793] = "Aarkos Familienschatz",
	[227806] = "Vom Kampf gezeichnetes Frostwolfbanner",
	[227859] = "Hoffnung",
	[227868] = "Glitzernder Teich",
	[227951] = "Rooks Angelzubehör",
	[227953] = "Krug gealterten Eisenweins",
	[227954] = "Leuchtende Muschel",
	[227955] = "Amethylkristall",
	[227956] = "Schließkiste des Vorarbeiters",
	[227996] = "Seltsames Todesnetzei",
	[227998] = "Ockbars Bündel",
	[228012] = "Verkohltes Schwert",
	[228013] = "Schatz des Bauern",
	[228014] = "Relikt von Aruuna",
	[228015] = "Eiserne Truhe",
	[228016] = "Fass mit Fischen",
	[228017] = "Draeneiwaffen",
	[228018] = "Reliquiar des Seelenbinders",
	[228019] = "Eingesponnener Sack",
	[228020] = "Relikt von Telmor",
	[228021] = "Schatz der Ango'rosh",
	[228022] = "Licht des Meeres",
	[228023] = "Knochenmalmerüberreste",
	[228024] = "Minenlore von Aruuna",
	[228025] = "Keluus Habseligkeiten",
	[228026] = "Purer Kristallstaub",
	[228483] = "Rostiger Tresor",
	[228570] = "Ketyas Vorratskiste",
	[229314] = "Goblingedankenkontrollgerät",
	[229328] = "Botenbeutel",
	[229330] = "Mysteriöser Ring",
	[229331] = "Ein mystischer Hut",
	[229333] = "Mysteriöse Stiefel",
	[229344] = "Vergrabener zeitfluktuierender Stab",
	[229354] = "Glänzende Münze",
	[229367] = "Gefrorenes Orcskelett",
	[229640] = "Gefrorene Frostwolfaxt",
	[230252] = "Brennende Perle",
	[230303] = "Steckbrieftafel",
	[230401] = "Versiegelter Krug",
	[230402] = "Glücksmünze",
	[230424] = "Schneebedeckte Schließkassette",
	[230425] = "Abgenagter Knochen",
	[230428] = "Qualmendes Echteisenvorkommen",
	[230498] = "Donnerfürstenkäfig",
	[230506] = "Donnerfürstenkäfig",
	[230544] = "Schamanenstein der Frostwölfe",
	[230611] = "Beutesack der Fahlen",
	[230643] = "Terokrallennest",
	[230664] = "Torvaths Kristallklinge",
	[230865] = "Liste mit Zutaten",
	[230909] = "Vergessene Vorräte",
	[230933] = "Zentralsteuerungskonsole der Verteidigungspylonen",
	[231063] = "Madame Senas Materialvorrat",
	[231064] = "Madame Senas anderer Materialvorrat",
	[231069] = "Seltsam aussehender Dolch",
	[231100] = "Eisranke",
	[231103] = "Geplünderte Beute",
	[231644] = "Gehörnter Schädel",
	[231769] = "Leuchtender Pilz",
	[231775] = "Herz des Magnarons",
	[231901] = "Ogerschriftrollen",
	[231903] = "Rauschebarts Bericht",
	[231918] = "Laandas Schriftrolle",
	[232024] = "Angriffspläne des Kriegshymnenklans",
	[232066] = "Versunkener Schatz",
	[232067] = "Gestohlener Schatz",
	[232090] = "Schrottos gestohlene Vorräte",
	[232214] = "Ogerbeute",
	[232215] = "Gorr'thoggs persönliche Reserve",
	[232216] = "Ogerbeute",
	[232217] = "Ogerbeute",
	[232218] = "Doorogs Geheimvorrat",
	[232219] = "Ogerbeute",
	[232237] = "Ogerbeute",
	[232248] = "Pippers' vergrabene Vorräte",
	[232250] = "Pippers' vergrabene Vorräte",
	[232251] = "Pippers' vergrabene Vorräte",
	[232252] = "Pippers' vergrabene Vorräte",
	[232353] = "Aufseherstuhl",
	[232397] = "Anschlagbrett",
	[232398] = "Steckbrieftafel",
	[232400] = "Anschlagbrett",
	[232405] = "Steckbrief",
	[232406] = "Bündel eines Abenteurers",
	[232416] = "Kommandotafel",
	[232458] = "Nizzix' Truhe",
	[232492] = "Verdammnisgeschoss",
	[232494] = "Pilzbedeckte Truhe",
	[232507] = "Mondsturzei",
	[232541] = "Minenwagen",
	[232546] = "Ogerbeute",
	[232547] = "Ogerbeute",
	[232549] = "Ogerbeute",
	[232550] = "Ogerbeute",
	[232571] = "Goblinbündel",
	[232579] = "Kaliriei",
	[232582] = "A'kumbos Asche",
	[232583] = "Geschnitztes Trinkhorn",
	[232584] = "Dampfdruckvorräte",
	[232586] = "Rovos Dolch",
	[232587] = "Uzkos Krimskrams",
	[232588] = "Grekas Urne",
	[232589] = "Veemas Kräuterbeutel",
	[232590] = "Leerenerfüllter Kristall",
	[232591] = "Gabe unter Geliebten",
	[232592] = "Sumpfleuchterstock",
	[232595] = "Dampfdruckvorräte",
	[232596] = "Großaxt der Ahnen",
	[232597] = "Goblinbündel",
	[232598] = "Dampfdruckvorräte",
	[232599] = "Beute des Kriegshymnenklans",
	[232621] = "Seltsame Spore",
	[232624] = "Mikkals Truhe",
	[232985] = "Dampfdruckvorräte",
	[232986] = "Geheimer Vorrat",
	[232989] = "Korb mit Arakkoawaren",
	[233032] = "Beutel des Bergsteigers",
	[233033] = "Dampfdruckvorräte",
	[233034] = "Dampfdruckvorräte",
	[233044] = "Pilzbedeckte Truhe",
	[233048] = "Leuchtende Traumblüte",
	[233052] = "Dampfdruckvorräte",
	[233079] = "Requirierte Vorräte des Kriegshymnenklans",
	[233101] = "Versunkenes Fischerboot",
	[233103] = "Schließkassette des Kriegshymnenklans",
	[233107] = "Kleine Schatztruhe",
	[233113] = "Speer des Kriegshymnenklans",
	[233126] = "Schattenmondschatzkiste",
	[233132] = "Süßwassermuschel",
	[233134] = "Goldkaliriei",
	[233135] = "Schatz des Kriegshymnenklans",
	[233137] = "Schatz der Brennenden Klinge",
	[233139] = "Uralte Titanentruhe",
	[233149] = "Schatz des Lachenden Schädels",
	[233180] = "Feuer der Eisernen Horde",
	[233206] = "Zurückgelassene Fracht",
	[233218] = "Bündel eines Abenteurers",
	[233229] = "Fluchfoliant des Schattenrats",
	[233241] = "Leuchtender Höhlenpilz",
	[233263] = "Schamanenstein",
	[233291] = "Kommandotafel",
	[233391] = "Gronnkontrollbefehle",
	[233452] = "Ein Haufen Dreck",
	[233455] = "Abgenutzte Steintruhe",
	[233457] = "Stab eines Abenteurers",
	[233492] = "Opfergabe an die Elemente",
	[233499] = "Tasche eines Abenteurers",
	[233501] = "Mysteriöse versteinerte Schote",
	[233504] = "Überreste von Grimnir Aschpick",
	[233505] = "Unbekanntes versteinertes Ei",
	[233507] = "Vergessenes Ogerversteck",
	[233511] = "Bündel eines Abenteurers",
	[233513] = "Vergessenes Schädelversteck",
	[233520] = "Überreste von Erkunder und Ingenieur Toldirk Aschenlampe",
	[233521] = "Vorräte des Kriegshymnenklans",
	[233522] = "Obsidiankristallformation",
	[233523] = "Mysteriöse versteinerte Schote",
	[233524] = "Unbekanntes versteinertes Ei",
	[233525] = "Essenzsamen der Botani",
	[233526] = "Uralte Titanentruhe",
	[233532] = "Geschnitzter Knochendolch",
	[233539] = "Trümmer der Genedar",
	[233549] = "Trümmer der Genedar",
	[233550] = "Unbekanntes versteinertes Ei",
	[233551] = "Trümmer der Genedar",
	[233552] = "Abgenutzte Steintruhe",
	[233555] = "Trümmer der Genedar",
	[233557] = "Trümmer der Genedar",
	[233558] = "Mysteriöse versteinerte Schote",
	[233559] = "Vergessenes Schädelversteck",
	[233560] = "Oshu'gunfragment",
	[233561] = "Pokkars dreizehnte Axt",
	[233593] = "Polierter Saberonschädel",
	[233594] = "Thukmars Aufzeichnungen",
	[233598] = "Elementarfesseln",
	[233611] = "Hochfelshammer",
	[233613] = "Verteidigungsschild von Telaar",
	[233618] = "Ogerperlen",
	[233623] = "Beutel eines Abenteurers",
	[233626] = "Grauschlunds Knochenhaufen",
	[233633] = "Unangetasteter Holzstapel",
	[233645] = "Helm des Kriegshymnenklans",
	[233649] = "Beutel des Glücksspielers",
	[233650] = "Streitkolben eines Abenteurers",
	[233651] = "Verlorener Anhänger",
	[233658] = "Beutel eines Abenteurers",
	[233696] = "Wichtige Expeditionsvorräte",
	[233697] = "Saberonvorrat",
	[233715] = "Goldzehs Plündergut",
	[233768] = "Elixier der Fahlen",
	[233773] = "Beutel voller Kräuter",
	[233792] = "Trümmerhaufen",
	[233917] = "Femur der Unwahrscheinlichkeit",
	[233956] = "Blutige Klinge",
	[233973] = "Güte der Elemente",
	[233975] = "Scubis Du-Du",
	[234054] = "Warmes Gorenei",
	[234147] = "Habseligkeiten der Ausgestoßenen",
	[234154] = "Verlegte Schriftrollen",
	[234155] = "Relikte der Ausgestoßenen",
	[234157] = "Frakturierter Sonnenstein",
	[234159] = "Verlorenes Kräuterbündel",
	[234243] = "Übertrieben knalliger Zettel",
	[234432] = "Ogronbeute",
	[234446] = "Relikte der Ausgestoßenen",
	[234449] = "Relikte der Ausgestoßenen",
	[234451] = "Relikte der Ausgestoßenen",
	[234454] = "Relikte der Ausgestoßenen",
	[234455] = "Relikte der Ausgestoßenen",
	[234456] = "Kassette der Zerschmetterten Hand",
	[234457] = "Früchtekorb",
	[234458] = "Truhe der Zerschmetterten Hand",
	[234461] = "Giftzahntoxin",
	[234471] = "Spray-o-Mat 5000 XT",
	[234472] = "Seemann Zazzuks 180-prozentiger Rum",
	[234473] = "Kampagnenspenden",
	[234474] = "Saberonvorrat",
	[234618] = "Geschenk Anzus",
	[234685] = "Geheime Kriegspläne",
	[234703] = "Elixier der Schattensicht",
	[234704] = "Elixier der Schattensicht",
	[234705] = "Elixier der Schattensicht",
	[234734] = "Elixier der Schattensicht",
	[234735] = "Elixier der Schattensicht",
	[234736] = "Elixier der Schattensicht",
	[234740] = "Orcsignalhorn",
	[234744] = "Opfergabe an die Rabenmutter",
	[234746] = "Opfergabe an die Rabenmutter",
	[234748] = "Opfergabe an die Rabenmutter",
	[235073] = "Opfergabe an die Rabenmutter",
	[235090] = "Opfergabe an die Rabenmutter",
	[235091] = "Verlorener Ring",
	[235095] = "Verlegte Schriftrolle",
	[235097] = "Ephials dunkler Foliant",
	[235103] = "Garnisonsvorräte",
	[235104] = "Sonnenberührte Truhe",
	[235105] = "Sonnenberührte Truhe",
	[235127] = "Mysteriöse versteinerte Schote",
	[235129] = "Angereicherte Samen",
	[235135] = "Geschmuggelte Apexisartefakte",
	[235141] = "Sprengladung der Eisernen Horde",
	[235143] = "Assassinenspeer",
	[235168] = "Beutel der Ausgestoßenen",
	[235172] = "Habseligkeiten der Ausgestoßenen",
	[235282] = "Ritualgebräu der Sethekk",
	[235289] = "Hammer eines Garnisonsarbeiters",
	[235299] = "Kupferknausers Bezahlung",
	[235300] = "Mysteriöse Pilze",
	[235307] = "Durchnässter Sack",
	[235310] = "Schredderteile",
	[235313] = "Liegen gelassene Spitzhacke",
	[235365] = "Admiral Taylors Truhe",
	[235673] = "Wackelnde Kiste",
	[235826] = "Riesiges Rylakei",
	[235859] = "Brokors Beutel",
	[235860] = "Orcskelett",
	[235869] = "Waffenständer",
	[235881] = "Versteinertes Rylakei",
	[236092] = "Versteckter Notfallrucksack",
	[236096] = "Überreste von Balldir Tiefstein",
	[236099] = "Sonnenbeschienener Speer",
	[236138] = "Vorratstruhe der Eisernen Horde",
	[236139] = "Entdeckerkanister",
	[236140] = "Gorentunnel",
	[236141] = "Liegen gelassenes Bündel",
	[236147] = "Hammer des Verteidigers",
	[236149] = "Sashas Geheimvorrat",
	[236158] = "Armbrust des Scharfschützen",
	[236165] = "Kriegsplanungskarte",
	[236169] = "Abbaubarer wertvoller Kristall",
	[236170] = "Überreste von Balik Erzmalmer",
	[236178] = "Versteckte Immermornvorräte",
	[236206] = "Kriegsplanungskarte",
	[236257] = "Uralte Titanentruhe",
	[236258] = "Unbekanntes versteinertes Ei",
	[236259] = "Mysteriöse versteinerte Schote",
	[236260] = "Mysteriöse versteinerte Schote",
	[236264] = "Vergessenes Schädelversteck",
	[236265] = "Abgenutzte Steintruhe",
	[236266] = "Unbekanntes versteinertes Ei",
	[236267] = "Uralte Titanentruhe",
	[236269] = "Obsidiankristallformation",
	[236270] = "Abgenutzte Steintruhe",
	[236271] = "Abgenutzte Steintruhe",
	[236274] = "Abgenutzte Steintruhe",
	[236275] = "Uralte Titanentruhe",
	[236276] = "Obsidiankristallformation",
	[236278] = "Obsidiankristallformation",
	[236279] = "Abgenutzte Steintruhe",
	[236280] = "Uralte Titanentruhe",
	[236282] = "Obsidiankristallformation",
	[236284] = "Uraltes Ogerversteck",
	[236285] = "Abgenutzte Steintruhe",
	[236288] = "Uralte Titanentruhe",
	[236289] = "Abgenutzte Steintruhe",
	[236348] = "Uraltes Ogerversteck",
	[236349] = "Uralte Titanentruhe",
	[236350] = "Abgenutzte Steintruhe",
	[236351] = "Uraltes Ogerversteck",
	[236399] = "Abgenutzte Steintruhe",
	[236400] = "Uraltes Ogerversteck",
	[236402] = "Uralte Titanentruhe",
	[236404] = "Abgenutzte Steintruhe",
	[236406] = "Uraltes Ogerversteck",
	[236407] = "Uraltes Ogerversteck",
	[236483] = "Gabe der Urtume",
	[236610] = "Geistergabe",
	[236633] = "Schmugglerversteck",
	[236693] = "Munition der Eisernen Horde",
	[236715] = "Seltsamer Schädel",
	[236755] = "Staubige Truhe",
	[236935] = "Schatz der Brennenden Klinge",
	[237016] = "Gesucht: Kuu'rat",
	[237021] = "Gesucht: Kliaas Stachel",
	[237022] = "Kommandotafel",
	[237343] = "Fass Pfählerbräu",
	[237452] = "Truhe der Eisernen Horde",
	[237461] = "Olafs Schild",
	[237462] = "Fürchterlich saure Lösung",
	[237463] = "Seltsamer Messingkompass",
	[237464] = "Seelenschnittklinge",
	[237465] = "Seelenflechtgefäß",
	[237466] = "Sonnenkristall",
	[237467] = "Makelloses Gefieder",
	[237468] = "Pips verbesserter Kürschner",
	[237469] = "Abgestoßene Protodrachenklaue",
	[237470] = "Dunkles Pergament",
	[237471] = "Silberspitzenpfeil",
	[237472] = "Seltsam leuchtender Wedel",
	[237473] = "Überwuchertes Artefakt",
	[237474] = "Riesige Waffenkiste",
	[237475] = "Eiserner Gliedmaßenspalter",
	[237476] = "Eiserner Miniaturstern",
	[237477] = "Ogerstammbaum",
	[237478] = "Verlockend glänzendes Etwas",
	[237479] = "Alptraumglocke",
	[237480] = "Windsturm in der Flasche",
	[237481] = "Flammenfliegen in der Flasche",
	[237482] = "Schlüssel zum Leerentor",
	[237483] = "Raschelndes Pfauenkükennest",
	[237484] = "Autokanone der Eisernen Horde",
	[237511] = "Seltsame Spore",
	[237751] = "Angriffsbefehle der Eisernen Horde",
	[237821] = "Klingenwuts Befehle",
	[237946] = "Geistertruhe",
	[239120] = "Bündel von Okuna Langhauer",
	[239143] = "Glas warme Milch",
	[239171] = "Glas warme Milch",
	[239194] = "Noranas Vorräte",
	[239198] = "Isaaris Vorräte",
	[239328] = "Schließkiste des Kapitäns",
	[239791] = "Aufzeichnungen eines Reliktjägers",
	[239803] = "Schatztruhe",
	[239828] = "Rand der Realität",
	[239901] = "Leerenkrallenei",
	[239925] = "Gefrorener Schamanenstein",
	[239926] = "Glühender Schamanenstein",
	[240003] = "Merkwürdiger Saphir",
	[240215] = "Asche eines gefallenen Kreuzfahrers",
	[240289] = "Verwitterte Axt",
	[240317] = "Iskars Foliant der Schatten",
	[240353] = "Scheinbar unbehüteter Schatz",
	[240354] = "Tatsächlich unbehüteter Schatz",
	[240519] = "Kleine Schatztruhe",
	[240543] = "Gestohlene Kapitänskiste",
	[240547] = "Orcschädel",
	[240577] = "Die Klinge von Kra'nak",
	[240580] = "Höllenfeuerjuwel",
	[240605] = "Kleine Schatztruhe",
	[240608] = "Kleine Schatztruhe",
	[240609] = "Kleine Schatztruhe",
	[240612] = "Kleine Schatztruhe",
	[240614] = "Kleine Schatztruhe",
	[240616] = "Vereiste Vorräte",
	[240617] = "Beutel der verlorenen Schildwache",
	[240619] = "Kleine Schatztruhe",
	[240622] = "Schriftrollenbehälter des Wächters",
	[240623] = "Sylvanas' Schließkiste",
	[240624] = "Feendrachennest",
	[240625] = "Re­li­qui­ar der Hohepriesterin",
	[240629] = "Schatztruhe",
	[240630] = "Kleine Schatztruhe",
	[240631] = "Schatztruhe",
	[240634] = "Schatztruhe",
	[240635] = "Schatztruhe",
	[240637] = "Glitzernde Schatztruhe",
	[240638] = "Umkämpfter Schatz",
	[240639] = "Glitzernde Schatztruhe",
	[240641] = "Schatztruhe",
	[240642] = "Schatztruhe",
	[240643] = "Schatztruhe",
	[240644] = "Kleine Schatztruhe",
	[240645] = "Glitzernde Schatztruhe",
	[240646] = "Schatztruhe",
	[240649] = "Kleine Schatztruhe",
	[240651] = "Kleine Schatztruhe",
	[240652] = "Schatztruhe",
	[240653] = "Kleine Schatztruhe",
	[240654] = "Kleine Schatztruhe",
	[240655] = "Glitzernde Schatztruhe",
	[240657] = "Kleine Schatztruhe",
	[240690] = "Schatztruhe",
	[240855] = "Foliant der Geheimnisse",
	[241128] = "Unbewachter Distelblattschatz",
	[241146] = "Schatztruhe",
	[241147] = "Kleine Schatztruhe",
	[241148] = "Kleine Schatztruhe",
	[241149] = "Kleine Schatztruhe",
	[241150] = "Kleine Schatztruhe",
	[241151] = "Kleine Schatztruhe",
	[241152] = "Schatztruhe",
	[241153] = "Kleine Schatztruhe",
	[241154] = "Kleine Schatztruhe",
	[241155] = "Schatztruhe",
	[241180] = "Schatztruhe",
	[241206] = "Kleine Schatztruhe",
	[241207] = "Kleine Schatztruhe",
	[241208] = "Schatztruhe",
	[241212] = "Schatztruhe",
	[241213] = "Kleine Schatztruhe",
	[241216] = "Schatztruhe",
	[241267] = "Kleine Schatztruhe",
	[241272] = "Schatztruhe",
	[241280] = "Schatztruhe",
	[241433] = "Vergessener Sack",
	[241434] = "Verkeilter Jagdspeer",
	[241449] = "Schatz der Schwarzfanginsel",
	[241450] = "Kristallisierter Teufelsstachel",
	[241504] = "Polierter Kristall",
	[241518] = "Kleine Schatztruhe",
	[241521] = "Schlangenbeschwörerflöte",
	[241522] = "Die perfekte Blüte",
	[241524] = "Fahlenjägerausrüstung",
	[241533] = "Vergessene Klinge eines Champions",
	[241557] = "Kleine Schatztruhe",
	[241558] = "Schatztruhe",
	[241560] = "Kriegsvorrat des Blutenden Auges",
	[241561] = "Juwel des gefallenen Sterns",
	[241562] = "Kleine Schatztruhe",
	[241563] = "Weihrauchschwenker der Pein",
	[241564] = "Kleine Schatztruhe",
	[241565] = "Beuteschatz des Blutenden Auges",
	[241566] = "Runenverzierter Oberschenkelknochen",
	[241599] = "Merkwürdige Frucht",
	[241600] = "Weggeworfener Helm",
	[241601] = "Hab und Gut eines Spähers",
	[241602] = "Vergessene Vorräte der Eisernen Horde",
	[241605] = "Kristallisierte Essenz der Elemente",
	[241641] = "Fuchsblume",
	[241656] = "Überwuchertes Relikt",
	[241657] = "Juwelenbesetzte Arakkoaeffigie",
	[241664] = "\"Geborgtes\" verzaubertes Fernglas",
	[241665] = "Schatztruhe",
	[241666] = "Mysteriöser verderbter Obelisk",
	[241671] = "Vergessener Splitter der Litanei",
	[241673] = "Beuteschatz des Blutenden Auges",
	[241674] = "Schädel des irren Häuptlings",
	[241680] = "Kleine Schatztruhe",
	[241692] = "Axt des wimmernden Wolfs",
	[241699] = "Kriegsbeute",
	[241712] = "Eisenbarts Schatz",
	[241713] = "Das Auge von Grannok",
	[241714] = "Eingelagerte Seebeute der Eisernen Horde",
	[241715] = "Eingelagerte Seebeute der Eisernen Horde",
	[241716] = "Eingelagerte Seebeute der Eisernen Horde",
	[241717] = "Glitzernde Schatztruhe",
	[241726] = "Leysteinvorkommen",
	[241742] = "Buch von Zyzzix",
	[241743] = "Teufelsschiefervorkommen",
	[241745] = "Teufelsdurchtränkter Beutel",
	[241760] = "Opferklinge",
	[241764] = "Eingelagerte Beute des Blutenden Auges",
	[241767] = "Schatztruhe",
	[241772] = "Schatztruhe",
	[241773] = "Kleine Schatztruhe",
	[241775] = "Kohlenbecken des Erwachens",
	[241835] = "Pilzvorrat des Blutenden Auges",
	[241841] = "Geplünderter mystischer Stab",
	[241847] = "Der Schild des Kommandanten",
	[241848] = "Schillernde Rute",
	[242242] = "Kleine Schatztruhe",
	[242249] = "Teilweise abgebauter Apexiskristall",
	[242250] = "Kleine Schatztruhe",
	[242328] = "Kleine Schatztruhe",
	[242350] = "Schatztruhe",
	[242446] = "Kleine Schatztruhe",
	[242642] = "Kleine Schatztruhe",
	[242643] = "Kleine Schatztruhe",
	[242644] = "Schatztruhe",
	[242645] = "Kleine Schatztruhe",
	[242646] = "Kleine Schatztruhe",
	[242647] = "Schatztruhe",
	[242649] = "Teufelsbesudelte Apexisformation",
	[242660] = "Kleine Schatztruhe",
	[242662] = "Kleine Schatztruhe",
	[242663] = "Kleine Schatztruhe",
	[242664] = "Schatztruhe",
	[242665] = "Kleine Schatztruhe",
	[242666] = "Schatztruhe",
	[242667] = "Kleine Schatztruhe",
	[242668] = "Glitzernde Schatztruhe",
	[242669] = "Kleine Schatztruhe",
	[242670] = "Schatztruhe",
	[242671] = "Glitzernde Schatztruhe",
	[242675] = "Kleine Schatztruhe",
	[242678] = "Schatztruhe",
	[242683] = "Schatztruhe",
	[242959] = "Schatztruhe",
	[243280] = "Pepe der Pirat",
	[243281] = "Pepe der Ninja",
	[243282] = "Pepe der Wikinger",
	[243283] = "Pepe der Ritter",
	[243321] = "Stein der Wildheit",
	[243323] = "Stein des Gleichgewichts",
	[243392] = "Alchemiebuch",
	[243688] = "Schatztruhe",
	[243690] = "Juwelenbesetztes Ei",
	[243693] = "Truhe des toten Mannes",
	[243698] = "Glitzernde Schatztruhe",
	[243773] = "Schatztruhe",
	[243798] = "Ein dampfendes Schmuckkästchen",
	[243899] = "Kaputter Leyflammenbrenner",
	[243911] = "Schneehügel",
	[244447] = "Weißes Murlocei",
	[244453] = "Cullens Späherreport",
	[244473] = "Gestohlene Güter aus Donnertotem",
	[244494] = "Schatztruhe",
	[244519] = "Schatztruhe",
	[244628] = "Taursons Preis",
	[244651] = "Schlüpfriger Romantikschmöker",
	[244678] = "|cFFFFFFFFSchritt 8:|r Seite 5555",
	[244689] = "Kleine Schatztruhe",
	[244691] = "Kleine Schatztruhe",
	[244692] = "Kleine Schatztruhe",
	[244694] = "Kleine Schatztruhe",
	[244698] = "Kleine Schatztruhe",
	[244699] = "Kleine Schatztruhe",
	[244700] = "Kleine Schatztruhe",
	[244701] = "Kleine Schatztruhe",
	[244775] = "Traumlaub",
	[244776] = "Traumlaub",
	[244778] = "Sternlichtrose",
	[244786] = "Teufelswurz",
	[244887] = "Kleine Schatztruhe",
	[244899] = "Kleine Schatztruhe",
	[244901] = "Schatztruhe",
	[244902] = "Schatztruhe",
	[244903] = "Schatztruhe",
	[244904] = "Kleine Schatztruhe",
	[244905] = "Kleine Schatztruhe",
	[244909] = "Kleine Schatztruhe",
	[244912] = "Kleine Schatztruhe",
	[244913] = "Schatztruhe",
	[244917] = "Schatztruhe",
	[244928] = "Glitzernde Schatztruhe",
	[244965] = "Gussis Truhe",
	[244986] = "Legionsportal",
	[245216] = "|cFFFFFFFFSchritt 3:|r Seite 161",
	[245286] = "Kristallkatzenstatuette",
	[245316] = "Kleine Schatztruhe",
	[245324] = "Reiches Leysteinvorkommen",
	[245325] = "Reiches Teufelsschiefervorkommen",
	[245328] = "Verzauberte Schriftrolle",
	[245345] = "Kleine Schatztruhe",
	[245479] = "Ramponierte Truhe",
	[245524] = "Schatztruhe",
	[245525] = "Kleine Schatztruhe",
	[245527] = "Schatztruhe",
	[245528] = "Schatztruhe",
	[245529] = "Kleine Schatztruhe",
	[245530] = "Glitzernde Schatztruhe",
	[245531] = "Kleine Schatztruhe",
	[245532] = "Schatztruhe",
	[245533] = "Schatztruhe",
	[245534] = "Kleine Schatztruhe",
	[245535] = "Kleine Schatztruhe",
	[245536] = "Glitzernde Schatztruhe",
	[245537] = "Glitzernde Schatztruhe",
	[245538] = "Kleine Schatztruhe",
	[245541] = "Kleine Schatztruhe",
	[245542] = "Schatztruhe",
	[245543] = "Schatztruhe",
	[245545] = "Kleine Schatztruhe",
	[245547] = "Kleine Schatztruhe",
	[245548] = "Schatztruhe",
	[245550] = "Schatztruhe",
	[245551] = "Kleine Schatztruhe",
	[245553] = "Schatztruhe",
	[245554] = "Kleine Schatztruhe",
	[245555] = "Kleine Schatztruhe",
	[245579] = "Schatztruhe",
	[245580] = "Kleine Schatztruhe",
	[245581] = "Kleine Schatztruhe",
	[245601] = "Kleine Schatztruhe",
	[245602] = "Schatztruhe",
	[245603] = "Kleine Schatztruhe",
	[245688] = "Zerbrochene Graburne",
	[245793] = "Zerfleddertes Tagebuch",
	[245941] = "Warpspeicher",
	[245996] = "Kleine Schatztruhe",
	[246037] = "Schatztruhe",
	[246147] = "Kleine Schatztruhe",
	[246154] = "Kaputte Spielzeugkiste",
	[246205] = "Kleine Schatztruhe",
	[246206] = "Kleine Schatztruhe",
	[246249] = "Kleine Schatztruhe",
	[246250] = "Brief von Jabrul",
	[246254] = "Staubige Truhe",
	[246269] = "Kleine Schatztruhe",
	[246309] = "Kleine Schatztruhe",
	[246353] = "Kleine Schatztruhe",
	[246438] = "Blingtron-Schaltplan",
	[246524] = "Kleine Schatztruhe",
	[246555] = "Kleine Schatztruhe",
	[246556] = "Kleine Schatztruhe",
	[246557] = "Kleine Schatztruhe",
	[246558] = "Kleine Schatztruhe",
	[246559] = "Kleine Schatztruhe",
	[246560] = "Kleine Schatztruhe",
	[246561] = "Kleine Schatztruhe",
	[246562] = "Kleine Schatztruhe",
	[247694] = "Kel'danaths Rucksack",
	[247797] = "Verlorene Post",
	[247999] = "Teufelswurz",
	[248000] = "Teufelswurz",
	[248001] = "Teufelswurz",
	[248002] = "Teufelswurz",
	[248003] = "Teufelswurz",
	[248004] = "Teufelswurz",
	[248005] = "Teufelswurz",
	[248006] = "Teufelswurz",
	[248007] = "Teufelswurz",
	[248008] = "Teufelswurz",
	[248009] = "Teufelswurz",
	[248010] = "Teufelswurz",
	[248011] = "Teufelswurz",
	[248012] = "Teufelswurz",
	[248398] = "Kommunikationsgerät der Astralen",
	[248534] = "Tränen von Elune",
	[248854] = "Desmonds Schließkassette",
	[249211] = "Zerrissene Shal'doreiseide",
	[249997] = "Kleine Schatztruhe",
	[250080] = "Kleine Schatztruhe",
	[250081] = "Kleine Schatztruhe",
	[250083] = "Kleine Schatztruhe",
	[250084] = "Kleine Schatztruhe",
	[250085] = "Kleine Schatztruhe",
	[250087] = "Kleine Schatztruhe",
	[250088] = "Kleine Schatztruhe",
	[250090] = "Kleine Schatztruhe",
	[250091] = "Kleine Schatztruhe",
	[250092] = "Schatztruhe",
	[250097] = "Kleine Schatztruhe",
	[250098] = "Kleine Schatztruhe",
	[250102] = "Schatztruhe",
	[250103] = "Kleine Schatztruhe",
	[250104] = "Kleine Schatztruhe",
	[250106] = "Kleine Schatztruhe",
	[250107] = "Glitzernde Schatztruhe",
	[250108] = "Kleine Schatztruhe",
	[250109] = "Schatztruhe",
	[250383] = "Mondschattenrelikt",
	[250541] = "Schatztruhe",
	[250984] = "Kleine Schatztruhe",
	[250985] = "Schatztruhe",
	[250987] = "Kleine Schatztruhe",
	[251032] = "Schrank",
	[251124] = "Glitzernde Schatztruhe",
	[251168] = "Flüchtiger Kristall",
	[251218] = "Rollos Runenstein",
	[251220] = "Ragnars Runenstein",
	[251221] = "Flokis Runenstein",
	[251416] = "Uralter Manabrocken",
	[251552] = "Kleine Schatztruhe",
	[251564] = "|cFFFFFFFFSchritt 4:|r Seite 655",
	[251713] = "Kleine Schatztruhe",
	[251714] = "Kleine Schatztruhe",
	[251716] = "Glitzernde Schatztruhe",
	[251719] = "Kleine Schatztruhe",
	[251720] = "Kleine Schatztruhe",
	[251723] = "Kleine Schatztruhe",
	[251737] = "Schatztruhe",
	[251738] = "Schatztruhe",
	[251761] = "Kleine Schatztruhe",
	[251762] = "Kleine Schatztruhe",
	[251764] = "Kleine Schatztruhe",
	[251772] = "Kleine Schatztruhe",
	[251776] = "Kleine Schatztruhe",
	[251780] = "Kleine Schatztruhe",
	[251782] = "Kleine Schatztruhe",
	[251792] = "Kleine Schatztruhe",
	[251820] = "Schatztruhe",
	[251851] = "Kleine Schatztruhe",
	[251853] = "Kleine Schatztruhe",
	[251854] = "Kleine Schatztruhe",
	[251856] = "Kleine Schatztruhe",
	[251857] = "Schatztruhe",
	[251991] = "Die Aegis von Aggramar",
	[252069] = "Alainas Habseligkeiten",
	[252107] = "Inaktiver telemantischer Signalgeber",
	[252232] = "Aponis Buchband",
	[252258] = "Leylinienzuleitung",
	[252259] = "Leylinienzuleitung",
	[252260] = "Leylinienzuleitung",
	[252261] = "Leylinienzuleitung",
	[252262] = "Leylinienzuleitung",
	[252263] = "Leylinienzuleitung",
	[252264] = "Leylinienzuleitung",
	[252267] = "Großer geplünderter Sack",
	[252269] = "Rucksack voller Kampftränke",
	[252270] = "Geheimnisvolle Kiste",
	[252272] = "Verrauchte Stiefel",
	[252273] = "Kiste voller Wurfdolche",
	[252277] = "Disteltee",
	[252279] = "Gestohlener Foliant der Artefaktüberlieferung",
	[252282] = "Glitzernder Schlüsselsatz",
	[252284] = "Haufen Haftbomben",
	[252289] = "Rauchpulver",
	[252331] = "Reisender Pepe",
	[252385] = "Ausgerissene Seite",
	[252386] = "Seite mit abgenutztem Rand",
	[252387] = "Seite mit Eselsohren",
	[252388] = "Angesengte Seite",
	[252390] = "Seite mit Tintenkleksen",
	[252391] = "Hastig bekritzelte Seite",
	[252395] = "Anbindepfosten für Todesstreitrösser",
	[252404] = "Teufelswurz",
	[252412] = "|cFFFFFFFFSchritt 2:|r Erdhaufen",
	[252432] = "Schimmernde uralte Manazusammenballung",
	[252434] = "|cFFFFFFFFSchritt 12:|r Hungernde Kugel X",
	[252446] = "Schimmernde uralte Manazusammenballung",
	[252447] = "Schimmernde uralte Manazusammenballung",
	[252448] = "Schimmernde uralte Manazusammenballung",
	[252449] = "Schimmernde uralte Manazusammenballung",
	[252450] = "Schimmernde uralte Manazusammenballung",
	[252557] = "|cFFFFFFFFSchritt 3:|r Hungernde Kugel I",
	[252558] = "|cFFFFFFFFSchritt 4:|r Hungernde Kugel II",
	[252559] = "|cFFFFFFFFSchritt 5:|r Hungernde Kugel III",
	[252560] = "|cFFFFFFFFSchritt 6:|r Hungernde Kugel IV",
	[252561] = "|cFFFFFFFFSchritt 7:|r Hungernde Kugel V",
	[252562] = "|cFFFFFFFFSchritt 8:|r Hungernde Kugel VI",
	[252563] = "|cFFFFFFFFSchritt 9:|r Hungernde Kugel VII",
	[252564] = "|cFFFFFFFFSchritt 10:|r Hungernde Kugel VIII",
	[252565] = "|cFFFFFFFFSchritt 11:|r Hungernde Kugel IX",
	[252570] = "Truhe mit Reichtümern aus der Himmelsfeste",
	[252802] = "Kleine Schatztruhe",
	[252803] = "Kleine Schatztruhe",
	[252805] = "Schatztruhe",
	[252806] = "Kleine Schatztruhe",
	[252807] = "Kleine Schatztruhe",
	[252808] = "Kleine Schatztruhe",
	[252810] = "Kleine Schatztruhe",
	[252812] = "Schatztruhe",
	[252813] = "Kleine Schatztruhe",
	[252814] = "Inaktiver telemantischer Signalgeber",
	[252815] = "Inaktiver telemantischer Signalgeber",
	[252816] = "Inaktiver telemantischer Signalgeber",
	[252817] = "Inaktiver telemantischer Signalgeber",
	[252819] = "Kleine Schatztruhe",
	[252820] = "Kleine Schatztruhe",
	[252821] = "Schatztruhe",
	[252822] = "Glitzernde Schatztruhe",
	[252824] = "Schatztruhe",
	[252828] = "Kleine Schatztruhe",
	[252829] = "Kleine Schatztruhe",
	[252830] = "Kleine Schatztruhe",
	[252831] = "Glitzernde Schatztruhe",
	[252833] = "Schatztruhe",
	[252834] = "Kleine Schatztruhe",
	[252835] = "Kleine Schatztruhe",
	[252836] = "Kleine Schatztruhe",
	[252837] = "Schatztruhe",
	[252838] = "Schatztruhe",
	[252839] = "Kleine Schatztruhe",
	[252840] = "Kleine Schatztruhe",
	[252841] = "Kleine Schatztruhe",
	[252842] = "Schatztruhe",
	[252844] = "Schatztruhe",
	[252850] = "Kleine Schatztruhe",
	[252860] = "Kleine Schatztruhe",
	[252876] = "Kleine Schatztruhe",
	[252880] = "Schatztruhe",
	[252881] = "Schatztruhe",
	[252882] = "Schatztruhe",
	[252883] = "Schatztruhe",
	[252884] = "Glitzernde Schatztruhe",
	[253161] = "Hainranke",
	[253280] = "Leysteinflöz",
	[253452] = "Anfängerleitfaden für Dimensionsreisen, Kap. 1: Navigation durch die Zeit",
	[253453] = "Anfängerleitfaden für Dimensionsreisen, Kap. 2: Orte, die vielen heilig sind",
	[253454] = "Anfängerleitfaden für Dimensionsreisen, Kap. 3: Wasser, einfach nur Wasser",
	[253455] = "Anfängerleitfaden für Dimensionsreisen, Kap. 4: Risiken und Nutzen",
	[253456] = "Anfängerleitfaden für Dimensionsreisen, Kap. 5: Unterwegs andere finden",
	[253457] = "Anfängerleitfaden für Dimensionsreisen, Kap. 6: Aufgestaute Energie",
	[253458] = "Anfängerleitfaden für Dimensionsreisen, Kap. 7: Unser Vermächtnis",
	[253994] = "Scheinbar unbehüteter Schatz",
	[254007] = "Altar des Scharfrichters",
	[254010] = "Vorräte des Irdenen Rings",
	[254025] = "Kleine Schatztruhe",
	[254027] = "Kleine Schatztruhe",
	[254028] = "Kleine Schatztruhe",
	[254126] = "Kleine Schatztruhe",
	[254127] = "Kleine Schatztruhe",
	[254128] = "Schatztruhe",
	[254141] = "Kleine Schatztruhe",
	[254262] = "Eule der Behüter",
	[255344] = "Teufelsschieferflöz",
	[255828] = "Kleine Schatztruhe",
	[255829] = "Kleine Schatztruhe",
	[255963] = "Erbtruhe der Vrykul",
	[256790] = "Elfische Schatztruhe",
	[257290] = "Truhe des Hochbergklans",
	[257291] = "Schatztruhe der Nachtgeborenen",
	[257393] = "Schatztruhe",
	[257545] = "Schatztruhe",
	[257546] = "Schatztruhe",
	[257978] = "Schatztruhe",
	[257999] = "Technik: Foliant des ruhigen Gemüts",
	[258690] = "Kleine Schatztruhe",
	[258978] = "Durchnässter Foliant",
	[258979] = "Teufelsversehrter Foliant",
	[258980] = "Verfluchter Foliant",
	[259806] = "Rezept für Liebestrank",
	[265526] = "Schatztruhe",
	[265532] = "Telemantischer Signalgeber",
	[265602] = "Versiegelter Foliant",
	[266289] = "Zeitverlorene Kiste",
	[266851] = "Zauberstab des simulierten Lebens",
	[268478] = "Abgenutztes Schmuckstück",
	[268551] = "Seltsame Wyrmzungentruhe",
	[268753] = "Kleine Schatztruhe",
	[269037] = "Loser Stein",
	[269064] = "Kleine Schatztruhe",
	[269830] = "|cFFFFFFFFSchritt 9:|r Gabe der Gedankensucher",
	[270855] = "|cFFFFFFFFSchritt 1:|r Unscheinbare Notiz",
	[270917] = "Verzeichnis von Schluchtbach",
	[271103] = "Gebetsbildnis",
	[271706] = "Jägertafel",
	[271849] = "Kriegsvorräte der Eredar",
	[271850] = "Kriegsvorräte der Eredar",
	[272039] = "|cFFFFFFFFSchritt 2:|r Unscheinbare Notiz",
	[272046] = "|cFFFFFFFFSchritt 3:|r Gedankenlarve",
	[272061] = "|cFFFFFFFFSchritt 4:|r Unscheinbare Notiz",
	[272163] = "|cFFFFFFFFSchritt 5:|r Seltsamer Schädel",
	[272165] = "|cFFFFFFFFSchritt 6:|r Unscheinbare Notiz",
	[272172] = "|cFFFFFFFFSchritt 7:|r Unscheinbare Notiz",
	[272179] = "Bekanntmachung des Bürgermeisters",
	[272181] = "|cFFFFFFFFSchritt 8:|r Unscheinbare Notiz",
	[272220] = "|cFFFFFFFFSchritt 9:|r Unscheinbare Notiz",
	[272270] = "|cFFFFFFFFSchritt 10:|r Verlangen des Rätslers",
	[272422] = "Sanftmuts Zauberbuch",
	[272434] = "Wasserstein",
	[272455] = "Kriegsvorräte der Eredar",
	[272456] = "Kriegsvorräte der Eredar",
	[272487] = "|cFFFFFFFFSchritt 14:|r Seltsam gefärbtes Ei",
	[272768] = "Empyriumvorkommen",
	[272770] = "Kriegsvorräte der Eredar",
	[272771] = "Kriegsvorräte der Eredar",
	[272778] = "Reiches Empyriumvorkommen",
	[272780] = "Empyriumflöz",
	[272782] = "Astralwinde",
	[273052] = "Teufelsverkrustetes Kraut",
	[273053] = "Teufelsverkrustetes Kräuterbüschel",
	[273222] = "Kriegsvorräte der Eredar",
	[273301] = "Uralte Truhe der Eredar",
	[273407] = "Uralte Truhe der Eredar",
	[273412] = "Uralte Truhe der Eredar",
	[273414] = "Uralte Truhe der Eredar",
	[273415] = "Uralte Truhe der Eredar",
	[273439] = "Uralte Truhe der Eredar",
	[273443] = "Leerendurchtränkte Truhe",
	[273519] = "Kriegsvorräte der Legion",
	[273521] = "Kriegsvorräte der Legion",
	[273523] = "Kriegsvorräte der Legion",
	[273524] = "Kriegsvorräte der Legion",
	[273527] = "Kriegsvorräte der Legion",
	[273528] = "Kriegsvorräte der Legion",
	[273533] = "Kriegsvorräte der Legion",
	[273535] = "Kriegsvorräte der Legion",
	[273538] = "Kriegsvorräte der Legion",
	[273814] = "Klingenbewehrter Talisman",
	[273854] = "Rucksack",
	[276223] = "Schatztruhe der Eredar",
	[276224] = "Kiste mit Diebesgut",
	[276225] = "Streitiger Studentenschatz",
	[276226] = "Leerenberührte Truhe",
	[276227] = "Geheimversteck der Augari",
	[276228] = "Truhe des verzweifelten Eredar",
	[276229] = "Zerschmetterte Haustruhe",
	[276230] = "Schatz des Verdammnissuchers",
	[276234] = "Flussknospe",
	[276236] = "Sternmoos",
	[276237] = "Akundas Biss",
	[276238] = "Winterkuss",
	[276239] = "Sirenendorn",
	[276240] = "Meeresstängel",
	[276242] = "Ankerkraut",
	[276251] = "Ausgrabungsinventar",
	[276424] = "Intakte Wichtelknochen",
	[276425] = "Intakter Scheusalknochen",
	[276426] = "Intakter Ur'zulknochen",
	[276488] = "Azeritkanonenkugel",
	[276489] = "Turmkiste der Legion",
	[276490] = "Notfallkiste der Krokul",
	[276491] = "Verlorene Krokultruhe",
	[276513] = "Intakter Matschflosser",
	[276515] = "Angelrute",
	[276616] = "Monelitvorkommen",
	[276617] = "Sturmsilbervorkommen",
	[276618] = "Platinvorkommen",
	[276619] = "Monelitflöz",
	[276620] = "Sturmsilberflöz",
	[276621] = "Reiches Monelitvorkommen",
	[276622] = "Reiches Sturmsilbervorkommen",
	[276623] = "Schatztruhe",
	[276735] = "Opfergaben der Auserwählten",
	[276837] = "Rezeptstein",
	[277199] = "Verwitterte Auftragsliste",
	[277204] = "Vergessene Vorräte der Legion",
	[277205] = "Uralte Kriegstruhe der Legion",
	[277206] = "Teufelsgebundene Truhe",
	[277207] = "Schatz der Legion",
	[277208] = "Verwitterte Teufelstruhe",
	[277327] = "Augarirunentruhe",
	[277333] = "Uralter Sarkophag",
	[277336] = "Schatztruhe",
	[277340] = "Geheime Augaritruhe",
	[277342] = "Augaribesitztümer",
	[277343] = "Verschollener Augarischatz",
	[277344] = "Wertvolle Augariandenken",
	[277346] = "Vermisste Augaritruhe",
	[277373] = "Schimmernder Seetang",
	[277384] = "Herrenloser Schatz",
	[277444] = "Zurückgeholter Schmuck",
	[277447] = "Verehrte Überreste",
	[277459] = "Schweinsbildnis",
	[277561] = "Schatz des Kriegsherrn",
	[277637] = "Leerendurchtränkte Truhe",
	[277715] = "Verfluchte Truhe der Nazmani",
	[277885] = "Wunjas Schatz",
	[277886] = "Zauberfoliant der Anderen Seite",
	[277897] = "Brodelnde Truhe",
	[278197] = "Phiole mit Gegengift",
	[278252] = "Auftragszettel",
	[278313] = "Scharf formulierter Brief",
	[278368] = "Zerfledderte Notiz",
	[278432] = "Offensichtlich sichere Truhe",
	[278436] = "Angeschwemmte Truhe",
	[278437] = "Opfergabe für Bwonsamdi",
	[278447] = "Speer des treulosen Fallenstellers",
	[278453] = "Voodoototem",
	[278456] = "Schatztruhe",
	[278461] = "Schatztruhe",
	[278462] = "Schatztruhe",
	[278570] = "Uraltes Tagebuch",
	[278577] = "Zerrissenes Sendschreiben der Horde",
	[278669] = "Geschäftsbuch von Fallhafen",
	[278675] = "Verfluchtes Bildnis",
	[278694] = "Schatztruhe",
	[278793] = "Schatztruhe",
	[279042] = "Schmugglervorrat",
	[279044] = "Binsen der Zandalari",
	[279253] = "Glückstruhe von Horace dem Glückspilz",
	[279260] = "\"Genial\" getarnte Truhe",
	[279299] = "Giftsiegeltruhe",
	[279609] = "Schätze Pandarias",
	[279645] = "Foliant der Vergessenheit",
	[279646] = "Blutwachenchronik",
	[279647] = "Foliant der Opferung",
	[279689] = "Verlorener Schatz der Nazmani",
	[279750] = "Heubedeckte Truhe",
	[280504] = "Verschluckte Truhe",
	[280522] = "Halb verdauter Schatz",
	[280576] = "Eingeschlossene Schriftrolle",
	[280619] = "Alte eisenbeschlagene Truhe",
	[280727] = "Verkohlte Nachricht",
	[280747] = "Schattenträne",
	[280755] = "Quintins Beutel",
	[280815] = "|cFFFFFFFFSchritt 1:|r Brief von Frau Graham I",
	[280836] = "|cFFFFFFFFSchritt 2:|r Brief von Frau Graham II",
	[280837] = "|cFFFFFFFFSchritt 3:|r Brief von Frau Graham III",
	[280838] = "|cFFFFFFFFSchritt 4:|r Brief von Frau Graham IV",
	[280842] = "|cFFFFFFFFSchritt 5:|r Brief von Frau Graham V",
	[280843] = "|cFFFFFFFFSchritt 6:|r Brief von Frau Graham VI",
	[280844] = "|cFFFFFFFFSchritt 7:|r Brief von Frau Graham VII",
	[280845] = "|cFFFFFFFFSchritt 8:|r Geschenk von Frau Graham",
	[280883] = "Sonnengebleichte Truhe",
	[280886] = "Sternenberührte Truhe",
	[280903] = "Verlorenes Katzenspielzeug",
	[280948] = "Plumpsklo des Schattenhammerkults",
	[280951] = "Aschenwindschätze",
	[280957] = "Zukashis Säckchen",
	[281079] = "Sternmoos",
	[281092] = "Schatz des Hexendoktors",
	[281230] = "Förmliche Einladung",
	[281312] = "Gestohlene Versorgungsgüter",
	[281326] = "Falkenkäfig",
	[281348] = "Auseinanderfallender Brief",
	[281397] = "Schatztruhe der Schwertwasserkorsaren",
	[281494] = "Frostige Schatztruhe",
	[281551] = "Plakat: Hilfe gesucht",
	[281583] = "Uraltes Reliquiar",
	[281639] = "Zerbröckelnde Statue",
	[281646] = "Honigbottich",
	[281647] = "Aushang",
	[281655] = "Geschenk der gebrochenen Herzen",
	[281673] = "Tagebuch eines Bewohners von Korlach",
	[281718] = "AUSHILFE GESUCHT",
	[281867] = "Sternmoos",
	[281868] = "Sternmoos",
	[281869] = "Sirenendorn",
	[281870] = "Flussknospe",
	[281872] = "Meeresstängel",
	[281898] = "Dazars vergessene Truhe",
	[282153] = "Versunkene Schließkassette",
	[282457] = "Dornenwachentotem",
	[282478] = "Leere Kiste",
	[282498] = "Wüstenflöte",
	[282666] = "Urne von Agussu",
	[282721] = "Schatztruhe",
	[282723] = "Schatztruhe",
	[284411] = "Schatztruhe",
	[284417] = "Schatztruhe",
	[284421] = "Schatztruhe",
	[284426] = "Vergrabene Abbaumaschine",
	[284448] = "Versteckte Truhe eines Gelehrten",
	[284454] = "Beute der Haibraut",
	[284455] = "Klage des Verbannten",
	[286016] = "Schiffslogbuch",
	[286954] = "Botbrecherbombe",
	[287081] = "Uralte Schrifttafel",
	[287185] = "Gesucht: Dunkelsprecher Jo'la",
	[287189] = "Gesucht: Gefährliche Bestien",
	[287228] = "Gesucht: Dunkler Chronist",
	[287229] = "Gesucht: Dunkler Chronist",
	[287232] = "Späherbericht",
	[287239] = "Grayals letzte Opfergabe",
	[287304] = "Beute des verschollenen Entdeckers",
	[287318] = "Sandwütervorrat",
	[287320] = "Gestrandeter Schatz",
	[287324] = "Gier des Ausgräbers",
	[287326] = "Zem'lans vergrabener Schatz",
	[287327] = "Späherbericht",
	[287398] = "Gesucht: Za'roco",
	[287440] = "Gesucht: Taz'raka",
	[287441] = "Gesucht: Sandspäher Vesarik",
	[287442] = "Gesucht: Teilnehmer für Kobraausflug",
	[287958] = "Anschlagbrett",
	[288157] = "Gesucht: Yarsel'ghun",
	[288167] = "Maries Paket",
	[288214] = "Steckbrief",
	[288596] = "Truhe der Geheimnisse",
	[288609] = "Tortollanertruhe",
	[288622] = "Steckbrief",
	[288641] = "GESUCHT: Greifenentführer",
	[289310] = "GESUCHT: Tobender Erdwächter",
	[289313] = "GESUCHT: Die Hornisse",
	[289317] = "Seetang",
	[289361] = "GESUCHT: Rüstmeister Ssylis",
	[289365] = "Steckbrief",
	[289521] = "Titanentranslokator",
	[289647] = "Verwitterte Schatztruhe",
	[289728] = "Käpt'n Gulnakus Schatzkarte",
	[290127] = "Tortollanertruhe",
	[290128] = "Tortollanertruhe",
	[290138] = "Botbrecherbombe",
	[290419] = "Steckbrief",
	[290537] = "Hilfe gesucht",
	[290725] = "Reichtümer von Tor'nowa",
	[290750] = "Vorräte der Jambani",
	[290765] = "Großer Haufen Gold",
	[290993] = "Beute der Eisenfluträuber",
	[291143] = "Ranahs Schraubenschlüssel",
	[291233] = "Sauroliskenschwanz",
	[291238] = "Bwonsamdis Tränen",
	[291241] = "Runzelwurzel",
	[291257] = "Kleine Schatztruhe",
	[291291] = "Gesucht: Wilderer",
	[292523] = "Steckbrief",
	[292673] = "Eine feuchte Schriftrolle",
	[292674] = "Eine feuchte Schriftrolle",
	[292675] = "Eine feuchte Schriftrolle",
	[292676] = "Eine feuchte Schriftrolle",
	[292677] = "Eine feuchte Schriftrolle",
	[292686] = "Ominöser Altar",
	[292812] = "Saphiramaraina",
	[292823] = "Krag'was Zorn",
	[292825] = "Steinblüte",
	[292843] = "Juwel der Fügung",
	[293134] = "Große Azeritgranate",
	[293349] = "Zurückgelassene Vesperdose",
	[293350] = "Geschnitzte Holztruhe",
	[293351] = "Trüffel",
	[293445] = "Trüffel",
	[293446] = "Trüffel",
	[293449] = "Trüffel",
	[293567] = "Steckbrief",
	[293568] = "Steckbrief",
	[293837] = "|cFFFFFFFFSchritt 2:|r Gewöhnlicher Kieselstein I",
	[293838] = "|cFFFFFFFFSchritt 3:|r Gewöhnlicher Kieselstein II",
	[293839] = "|cFFFFFFFFSchritt 4:|r Gewöhnlicher Kieselstein III",
	[293840] = "|cFFFFFFFFSchritt 5:|r Gewöhnlicher Kieselstein IV",
	[293841] = "|cFFFFFFFFSchritt 6:|r Gewöhnlicher Kieselstein V",
	[293842] = "|cFFFFFFFFSchritt 7:|r Gewöhnlicher Kieselstein VI",
	[293843] = "|cFFFFFFFFSchritt 8:|r Gewöhnlicher Kieselstein VII",
	[293844] = "|cFFFFFFFFSchritt 9:|r Gewöhnlicher Kieselstein VIII",
	[293845] = "|cFFFFFFFFSchritt 10:|r Gewöhnlicher Kieselstein IX",
	[293846] = "|cFFFFFFFFSchritt 11:|r Gewöhnlicher Kieselstein X",
	[293849] = "Auffällige Notiz",
	[293852] = "Vergrabene Schatzkiste",
	[293880] = "Vergrabene Schatzkiste",
	[293881] = "Vergrabene Schatzkiste",
	[293884] = "Vergrabene Schatzkiste",
	[293962] = "Heikler Vorrat eines Adligen",
	[293964] = "Vergessener Schmugglervorrat",
	[293965] = "Vorrat der Knochenritzer",
	[293985] = "Gesucht: Schlachtmetzler",
	[294084] = "Beutetruhe des Abenteurerclubs",
	[294096] = "Erleuchtete Kugel",
	[294097] = "Seltsamer Samen",
	[294098] = "Winziger Frosch",
	[294099] = "Morscher Knochen",
	[294100] = "Verlegte Kerze",
	[294101] = "Komischer Becher",
	[294102] = "Interessanter Stein",
	[294103] = "Blühende Lilie",
	[294104] = "Hübsche Blume",
	[294105] = "Altes Buch",
	[294106] = "Toter Fisch",
	[294107] = "Raues Brett",
	[294108] = "Verlorener Ring",
	[294109] = "Vergammelnder Apfel",
	[294110] = "Abgebrochener Zahn",
	[294111] = "Abgetragener Helm",
	[294112] = "Grünes Blatt",
	[294113] = "Muffige Stoffbahn",
	[294114] = "Zerbrochene Schrifttafel",
	[294115] = "Ausgebrannte Fackel",
	[294125] = "Ankerkraut",
	[294173] = "Vorratstruhe der Venture Co.",
	[294174] = "Vergessene Truhe",
	[294312] = "Grimms Freundesliste",
	[294314] = "Grimms Feindesliste",
	[294315] = "Grimms Lieblingsrezept",
	[294316] = "Verlorene Opfergaben von Kimbul",
	[294317] = "Totholztruhe",
	[294319] = "Im Sand versunkener Schatz",
	[294335] = "Verfaulte Kartoffel",
	[294703] = "Grimms rostige Schließkiste",
	[296252] = "Kiste mit großen Azeritgranaten",
	[296479] = "Schließkiste des Lordadmirals",
	[296536] = "Blutige Schildwachengleve",
	[296573] = "Jasons rostige Klinge",
	[296574] = "Ians leere Flasche",
	[296575] = "Julies gesprungene Schüssel",
	[296579] = "Brians kaputter Kompass",
	[296580] = "Ofers gebundenes Notizbuch",
	[296581] = "Skyes Lieblingsstein",
	[296582] = "Juliens linker Stiefel",
	[296583] = "Navarros Fläschchen",
	[296584] = "Zachs Feldflasche",
	[296585] = "Damarcus' Rucksack",
	[296586] = "Rachels Flöte",
	[296587] = "Joshs Reißzahnhalskette",
	[296588] = "Porträt von Kommandant Martens",
	[296589] = "Kurts verschnörkelter Schlüssel",
	[296854] = "Uralte Schriftrolle der Gezeitenweisen",
	[296855] = "Trüffel",
	[296902] = "Uralte Schriftrolle der Gezeitenweisen",
	[296903] = "Uralte Schriftrolle der Gezeitenweisen",
	[296904] = "Uralte Schriftrolle der Gezeitenweisen",
	[296905] = "Uralte Schriftrolle der Gezeitenweisen",
	[296906] = "Uralte Schriftrolle der Gezeitenweisen",
	[296907] = "Uralte Schriftrolle der Gezeitenweisen",
	[296908] = "Uralte Schriftrolle der Gezeitenweisen",
	[296915] = "Druststele: Der Kreis",
	[296916] = "Druststele: Das Ritual",
	[296917] = "Druststele: Der Baum",
	[296918] = "Druststele: Atem zu Stein",
	[297069] = "Kommode",
	[297071] = "Kleiner Münzenbeutel",
	[297074] = "Legend'n der Loa: Gral",
	[297485] = "Legend'n der Loa: Sethraliss",
	[297489] = "Legend'n der Loa: Krag'wa",
	[297490] = "Legend'n der Loa: Rezan",
	[297491] = "Legend'n der Loa: Bwonsamdi",
	[297492] = "Anschlagbrett",
	[297493] = "Legend'n der Loa: Shadra",
	[297494] = "Legend'n der Loa: Kimbul",
	[297495] = "Legend'n der Loa: Akunda",
	[297521] = "Legend'n der Loa: Gonk",
	[297522] = "Legend'n der Loa: Hir'eek",
	[297523] = "Legend'n der Loa: Torga",
	[297524] = "Legend'n der Loa: Pa'ku",
	[297528] = "Legend'n der Loa: Jani",
	[297627] = "Druststele: Opfer",
	[297628] = "Druststele: Konstrukte",
	[297629] = "Druststele: Der Zyklus",
	[297630] = "Druststele: Konflikt",
	[297631] = "Druststele: Der geschundene Mann",
	[297632] = "Druststele: Hüter des Waldes",
	[297700] = "Legend'n der Loa: Zandalar",
	[297825] = "Gespinstbedeckte Schatztruhe",
	[297828] = "Händlertruhe",
	[297878] = "Verhexte Truhe",
	[297879] = "Zaubergeschützte Schatzkiste",
	[297880] = "Bezauberte Truhe",
	[297881] = "Verzauberte Truhe",
	[297885] = "Legend'n der Loa: Torcali",
	[297891] = "Runengebundene Truhe",
	[297892] = "Runengebundene Kiste",
	[297893] = "Runengebundene Lade",
	[297905] = "Jays Gesangbuch",
	[297906] = "Russells Gesangbuch",
	[297933] = "Staubiges Gesangbuch",
	[297934] = "Gesangbuch des Halunken",
	[297939] = "Armbrust des Glutordens",
	[297940] = "Messer des Glutordens",
	[297941] = "Hut des Glutordens",
	[297942] = "Fläschchen des Glutordens",
	[298766] = "Alte Armbrust",
	[298767] = "Altes Messer",
	[298768] = "Altes Fläschchen",
	[298769] = "Alter Hut",
	[298778] = "Steckbrief",
	[298849] = "Steckbrief",
	[298920] = "Gestohlener Dornsprecherschatz",
	[298921] = "Uralte Steintafel der Nazmani",
	[298963] = "Verwitterte Steintafel der Nazmani",
	[298965] = "Gesprungene Steintafel",
	[299073] = "Zerbrochene Steintafel",
	[303016] = "|cFFFFFFFFSchritt 14:|r Gewöhnlicher Kieselstein XIII",
	[303017] = "|cFFFFFFFFSchritt 13:|r Gewöhnlicher Kieselstein XII",
	[303018] = "|cFFFFFFFFSchritt 12:|r Gewöhnlicher Kieselstein XI",
	[303039] = "Seltsamer Getreidesack",
	[307091] = "Ominöser flüsternder Dolch",
	[307265] = "Steckbrief",
	[307277] = "Alter Henkelkrug",
	[307307] = "Zerbrochenes Fass",
	[307325] = "Steckbrief",
	[307330] = "Schließkiste des Kapitäns",
	[307340] = "Verschlossene Truhe",
	[307748] = "Brief der Venture Co.",
	[307836] = "Zwielichterz",
	[309498] = "Rüstungsständer",
	[310600] = "Uralter Foliant der Kaldorei",
	[310601] = "Abgelegtes Nachtsäblerzaumzeug",
	[310603] = "Bogen der Hohepriesterin",
	[310709] = "Durchnässte Truhe",
	[310736] = "Erzkiste",
	[311155] = "Uralte Schrifttafel",
	[311218] = "Xal'atath, Klinge des Schwarzen Imperiums",
	[311822] = "Botstörer",
	[311902] = "Lockere Teile",
	[311903] = "Lockere Teile",
	[313446] = "Treibgut der Silbermorgen",
	[313447] = "Treibgut der Silbermorgen",
	[313448] = "Treibgut der Silbermorgen",
	[316443] = "Xal'atath, Klinge des Schwarzen Imperiums",
	[316792] = "Gestohlenes Eisenerz",
	[316863] = "Verlorenes Zandalarirelikt",
	[319222] = "Dunkelküstenschatz",
	[320514] = "Dunkelküstenschatz",
	[320515] = "Dunkelküstenschatz",
	[320516] = "Dunkelküstenschatz",
	[320517] = "Dunkelküstenschatz",
	[320518] = "Dunkelküstenschatz",
	[322020] = "Haufen Münzen",
	[322066] = "Leylinienakkumulator",
	[322413] = "Glitzernde Truhe",
	[322533] = "Mardivas' Foliant der Elemente",
	[322791] = "Kelpbeere",
	[322803] = "Kelpbeere",
	[324407] = "Leerenwurzeln",
	[325659] = "Mechanisierte Truhe",
	[325660] = "Mechanisierte Truhe",
	[325661] = "Mechanisierte Truhe",
	[325662] = "Mechanisierte Truhe",
	[325663] = "Mechanisierte Truhe",
	[325664] = "Mechanisierte Truhe",
	[325665] = "Mechanisierte Truhe",
	[325666] = "Mechanisierte Truhe",
	[325667] = "Mechanisierte Truhe",
	[325668] = "Mechanisierte Truhe",
	[325759] = "Manaversetzte Muschel",
	[325795] = "Versunkene Truhe",
	[325853] = "Leeres Bücherregal",
	[325869] = "Leeres Fass",
	[325873] = "Reiches Osmenitvorkommen",
	[325874] = "Osmenitflöz",
	[325875] = "Osmenitvorkommen",
	[325894] = "Arkane Truhe",
	[325954] = "Unleserliche Schatzkarte",
	[326026] = "Leerentruhe",
	[326027] = "Wiederverwertisierer DX-82",
	[326047] = "Verstärkte Truhe",
	[326140] = "Steckbrieftafel",
	[326141] = "Steckbrieftafel",
	[326142] = "Steckbrieftafel",
	[326148] = "Angriffspläne der Naga",
	[326394] = "Arkane Truhe",
	[326395] = "Leuchtende arkane Truhe",
	[326396] = "Leuchtende arkane Truhe",
	[326397] = "Leuchtende arkane Truhe",
	[326398] = "Leuchtende arkane Truhe",
	[326399] = "Leuchtende arkane Truhe",
	[326400] = "Leuchtende arkane Truhe",
	[326401] = "Arkane Truhe",
	[326402] = "Arkane Truhe",
	[326403] = "Arkane Truhe",
	[326404] = "Arkane Truhe",
	[326405] = "Arkane Truhe",
	[326406] = "Arkane Truhe",
	[326407] = "Arkane Truhe",
	[326408] = "Arkane Truhe",
	[326409] = "Arkane Truhe",
	[326410] = "Arkane Truhe",
	[326411] = "Arkane Truhe",
	[326412] = "Arkane Truhe",
	[326413] = "Arkane Truhe",
	[326414] = "Arkane Truhe",
	[326415] = "Arkane Truhe",
	[326416] = "Arkane Truhe",
	[326417] = "Arkane Truhe",
	[326418] = "Arkane Truhe",
	[326419] = "Arkane Truhe",
	[326588] = "Azeritwaffentruhe",
	[326594] = "Arkaner Foliant",
	[327170] = "Waffenständer",
	[327221] = "Kelpbeerenfass",
	[327230] = "Geléeablagerung",
	[327407] = "Wertvoller Ogerschatz",
	[327516] = "Geléeablagerung",
	[327548] = "Kraftzellenbaupläne",
	[327568] = "Piratentruhe",
	[327569] = "Piratentruhe",
	[327570] = "Piratentruhe",
	[327585] = "Steckbrieftafel",
	[327591] = "Erhaltenes Tagebuch",
	[327592] = "Verzaubertes Schloss",
	[327596] = "Zerbrochener abyssischer Fokus",
	[327597] = "Alte rostige Truhe",
	[327650] = "Kiste mit Kriegsvorräten",
	[327652] = "Kiste mit Kriegsvorräten",
	[327669] = "Maßvoller Bierlementar",
	[328343] = "Düsterbräuzahnrad",
	[328413] = "Totem der Ho-zen",
	[329641] = "Gesucht: Zankfett und Rohtrogg",
	[329715] = "Nützliche Teile",
	[329783] = "Leuchtende arkane Truhe",
	[329805] = "Merkwürdiger Kristall",
	[329918] = "Schätze der Stacheleber",
	[329919] = "Gestohlene Vorräte",
	[330168] = "Maßvoller Bierlementar",
	[330169] = "Düsterbräuzahnrad",
	[330170] = "Totem der Ho-zen",
	[330183] = "Schließkassette der Eisenfluträuber",
	[330627] = "Gefahrenzeichen",
	[332220] = "Leuchtende arkane Truhe",
	[332568] = "Kristallkatzenstatuette",
	[332569] = "Kristallkatzenstatuette",
	[332570] = "Kristallkatzenstatuette",
	[332571] = "Kristallkatzenstatuette",
	[332572] = "Kristallkatzenstatuette",
	[332573] = "Kristallkatzenstatuette",
	[332574] = "Kristallkatzenstatuette",
	[332575] = "Kristallkatzenstatuette",
	[332576] = "Kristallkatzenstatuette",
	[334216] = "Truhe des Schwarzen Imperiums",
	[334220] = "Truhe des Schwarzen Imperiums",
	[335655] = "Oonars Arm",
	[336415] = "Weggeworfene Schriftrolle",
	[337237] = "Verlorene Schatztruhe",
	[337241] = "Verstaute Ausrüstung",
	[338520] = "Dämmermoorpilz",
	[339211] = "Leerer Teller",
	[339243] = "Befallene Schließkassette",
	[339248] = "Befallene Truhe",
	[339249] = "Befallene Truhe",
	[339250] = "Befallene Truhe",
	[339283] = "Truhe des vergessenen Adligen",
	[339601] = "Schriftrolle der Äonen",
	[339625] = "Sophias Gabe",
	[339641] = "Läuternder Trunk",
	[339770] = "Herrenlose Schatztruhe",
	[339837] = "Pulverfass",
	[339869] = "Truhe der Kuratorin",
	[341416] = "Kerkerfallgatterkette",
	[341424] = "Vergessene Andenken",
	[342098] = "Haubenlockes Glattrasurset",
	[343611] = "Leerenberührtes Ei",
	[343698] = "Leerenberührter Schädel",
	[344588] = "Supis Supersuppentopf",
	[344726] = "Dunkle Predigt",
	[345446] = "Großes Horn des Runenhirsches",
	[345455] = "Truhe mit Konstruktvorräten",
	[345456] = "Augentruhe",
	[345458] = "Preissack",
	[347444] = "Kunstvoller Knochenschild",
	[348521] = "Seltsamer Auswuchs",
	[348558] = "Notiz",
	[348676] = "Ballistenbolzen",
	[348747] = "Schlammige Schriftrolle",
	[349515] = "Zerfleddertes Tagebuch",
	[349565] = "Truhe der neidischen Träume",
	[349612] = "Gesucht: Gutachter Vix",
	[349792] = "Diebestrophäe",
	[349793] = "Zurückgelassene Beute eines Wanderers",
	[349794] = "Remlates versteckter Schatz",
	[349795] = "Bündel der flüchtigen Seele",
	[349796] = "Kiste mit vergoldeter Pflaume",
	[349797] = "Zurückgelassene Kuriositäten",
	[349798] = "Geschmuggelte Truhe",
	[350802] = "Gespinstversiegelte Truhe",
	[350804] = "Zerbrochene Harfe",
	[350972] = "Zellenfallgatterkette",
	[350978] = "Truhe des Konservatoriums der Königin",
	[351467] = "Verblasste Inschrift",
	[351487] = "Geheimer Schatz",
	[351540] = "Geheimer Schatz",
	[351541] = "Geheimer Schatz",
	[351542] = "Geheimer Schatz",
	[351543] = "Geheimer Schatz",
	[351544] = "Geheimer Schatz",
	[351545] = "Geheimer Schatz",
	[351874] = "Gesucht: Vollstrecker Kristoff",
	[351885] = "Gesucht: Aggregat des Unheils",
	[351886] = "Gesucht: Herzog Anton",
	[351887] = "Gesucht: Lord Darion",
	[351888] = "Gesucht: Beschwörer Marcelis",
	[351889] = "Gesucht: Der fahle Schrecken",
	[351948] = "Vergessene Truhe",
	[351980] = "Verlegte Vorräte",
	[352027] = "Steckbriefschriftrolle",
	[352028] = "Steckbriefschriftrolle",
	[352086] = "Schwarzhundtruhe",
	[352181] = "Zauberstab im Sprigganformat",
	[352182] = "Stangenwaffe im Sprigganformat",
	[352428] = "Vesperglocke der Tugenden",
	[352433] = "Augenlager",
	[352490] = "Tretet der Rebellion bei!",
	[352520] = "Medaillon des Stolzes",
	[352596] = "Sprießender Auswuchs",
	[352703] = "Die Ernte",
	[352754] = "Silberne Schließkassette",
	[352909] = "Schimmerflossenschuppe",
	[353019] = "Silberne Schließkassette",
	[353205] = "Silberne Schließkassette",
	[353231] = "Knochengebundene Kiste",
	[353232] = "Kahlholzkiste",
	[353233] = "Verzauberte Truhe",
	[353234] = "Vergoldete Truhe",
	[353252] = "Silberne Schließkassette",
	[353305] = "Steinbrecherhammer",
	[353306] = "Verrottete Hülle",
	[353314] = "Silberne Schließkassette",
	[353323] = "Verrottete Hülle",
	[353324] = "Verrottete Hülle",
	[353325] = "Silberne Schließkassette",
	[353326] = "Verrottete Hülle",
	[353327] = "Verrottete Hülle",
	[353329] = "Feenvorrat",
	[353330] = "Feenvorrat",
	[353331] = "Feenvorrat",
	[353332] = "Feenvorrat",
	[353333] = "Feenvorrat",
	[353340] = "Staubiges Buch",
	[353380] = "Halis' Henkelmann",
	[353472] = "Strahlendes Schwert",
	[353484] = "Die Große Schatzkammer",
	[353500] = "Silberne Schließkassette",
	[353503] = "Silberne Schließkassette",
	[353516] = "Silberne Schließkassette",
	[353626] = "Verschlossener Werkzeugkasten",
	[353627] = "Frontrationen",
	[353643] = "Silberne Schließkassette",
	[353645] = "Marileths Tagebuch",
	[353650] = "Goldene Truhe des Provosten",
	[353681] = "Mondlichtkapsel",
	[353683] = "Mondlichtkapsel",
	[353684] = "Mondlichtkapsel",
	[353685] = "Mondlichtkapsel",
	[353686] = "Mondlichtkapsel",
	[353687] = "Zerbrochene Glocke",
	[353688] = "Zerbrochene Glocke",
	[353689] = "Zerbrochene Glocke",
	[353691] = "Himmelsglocke",
	[353791] = "Schlosschließkassette",
	[353792] = "Dorfschließkassette",
	[353793] = "Gemeindetruhe",
	[353796] = "Reliquiar der Erinnerung",
	[353797] = "Vorräte der Steinlegion",
	[353799] = "Hoffnungsbrecherbündel",
	[353868] = "Versteckter Vorrat",
	[353869] = "Versteckter Vorrat",
	[353870] = "Versteckter Vorrat",
	[353871] = "Versteckter Vorrat",
	[353872] = "Versteckter Vorrat",
	[353873] = "Versteckter Vorrat",
	[353874] = "Animazapfen",
	[353876] = "Tugend der Bußfertigkeit",
	[353940] = "Gabe von Vesiphone",
	[353941] = "Gabe von Chyrus",
	[353942] = "Gabe von Agthia",
	[353943] = "Gabe von Thenios",
	[353944] = "Gabe von Devos",
	[353948] = "Medaillon der Begierde",
	[353949] = "Medaillon der Habsucht",
	[354075] = "Leeres Pergament",
	[354108] = "Steingeborenensäckchen",
	[354109] = "Steingeborenensäckchen",
	[354110] = "Steingeborenensäckchen",
	[354111] = "Steingeborenensäckchen",
	[354112] = "Steingeborenensäckchen",
	[354113] = "Steingeborenensäckchen",
	[354114] = "Steingeborenensäckchen",
	[354115] = "Preis des Faustkämpfers",
	[354116] = "Preis des Faustkämpfers",
	[354121] = "Preis des Faustkämpfers",
	[354122] = "Preis des Faustkämpfers",
	[354123] = "Preis des Faustkämpfers",
	[354175] = "Vorrat der Aufgestiegenen",
	[354186] = "Steingeborenensäckchen",
	[354187] = "Steingeborenensäckchen",
	[354188] = "Steingeborenensäckchen",
	[354189] = "Steingeborenensäckchen",
	[354190] = "Steingeborenensäckchen",
	[354191] = "Steingeborenensäckchen",
	[354192] = "Steingeborenensäckchen",
	[354193] = "Steingeborenensäckchen",
	[354202] = "Verlassener Vorrat",
	[354208] = "Gestohlene Ausrüstung",
	[354211] = "Belohnung der Gier",
	[354213] = "Notizen des verlorenen Jüngers",
	[354214] = "Harnisch des Larionbändigers",
	[354275] = "Experimentelles Konstruktteil",
	[354283] = "Mercias Vermächtnis: Kapitel eins",
	[354284] = "Mercias Vermächtnis: Kapitel zwei",
	[354285] = "Mercias Vermächtnis: Kapitel drei",
	[354286] = "Mercias Vermächtnis: Kapitel vier",
	[354287] = "Mercias Vermächtnis: Kapitel fünf",
	[354288] = "Mercias Vermächtnis: Kapitel sechs",
	[354289] = "Werkzeuge des Windschmieds",
	[354467] = "Mercias Vermächtnis: Kapitel sieben",
	[354645] = "Verlorenes Säckchen",
	[354646] = "Uraltes Wolkenfederei",
	[354647] = "Lebhafte Drachenfeder",
	[354648] = "Dunkelvorstoßvorräte",
	[354649] = "Reliktschatz",
	[354650] = "Traumsangherz",
	[354651] = "Verzauberter Traumfänger",
	[354652] = "Feenschatz",
	[354662] = "Schwer zu findende Feentruhe",
	[354852] = "Sprießender Auswuchs",
	[354853] = "Sprießender Auswuchs",
	[354856] = "Schleimbedeckte Kiste",
	[354911] = "Aufgequollener Animasamen",
	[355000] = "Truhe der Nacht",
	[355019] = "Rohe Traumseide",
	[355020] = "Verzauberter Zweig",
	[355021] = "Faeornament",
	[355035] = "Runenlade der Auserwählten",
	[355037] = "Runengebundene Lade",
	[355038] = "Runengebundene Lade",
	[355040] = "Rune der Rituale",
	[355041] = "Truhe des Mondes",
	[355048] = "Rune der Rituale",
	[355049] = "Rune der Rituale",
	[355194] = "Rune der Konstrukte",
	[355195] = "Rune der Konstrukte",
	[355196] = "Rune der Konstrukte",
	[355286] = "Gedenkopfergaben",
	[355296] = "Kopfgeld: Wildtierkontrolle",
	[355355] = "Harmonische Truhe",
	[355435] = "Vesperglocke des Silberwinds",
	[355449] = "Gabe des Silberwinds",
	[355798] = "Käfig",
	[355865] = "Gefäß mit auffälligem Schleim",
	[355872] = "Gestohlener Krug",
	[355880] = "Das Necro-mjam-nicon",
	[355886] = "Seuchensturztruhe",
	[355947] = "Glutherns Vorrat",
	[355971] = "Steingeborenengleve",
	[355980] = "Truhe des Ritualisten",
	[356535] = "Schatz des Runensprechers",
	[356555] = "Eurydeas Halskette",
	[356693] = "Baronin Vashjs extravaganter Tribut",
	[356697] = "Alexandros Mograines extravaganter Tribut",
	[356700] = "Großmeister Voles extravaganter Tribut",
	[356705] = "Seuchenerfinder Marileths extravaganter Tribut",
	[356709] = "Lady Mondbeeres extravaganter Tribut",
	[356712] = "Jagdhauptmann Korayns extravaganter Tribut",
	[356716] = "Dromanin Aliothes extravaganter Tribut",
	[356720] = "Choofas extravaganter Tribut",
	[356725] = "Polemarchos Adrestes' extravaganter Tribut",
	[356728] = "Mikanikos' extravaganter Tribut",
	[356733] = "Kleias und Pelagos' extravaganter Tribut",
	[356737] = "Sikas extravaganter Tribut",
	[356741] = "Extravaganter Tribut der Gräfin",
	[356744] = "Rendels und Knüppelfratzes extravaganter Tribut",
	[356748] = "Steinkopfs extravaganter Tribut",
	[356752] = "Grufthüter Kassirs extravaganter Tribut",
	[356757] = "Verlangen der Gier",
	[356818] = "Bußfertigkeit der Reinheit",
	[356820] = "Große Mondlichtkapsel",
	[356823] = "Truhe des Wolkenwanderers",
	[357228] = "Vergessene Truhe",
	[357229] = "Vergessene Truhe",
	[357230] = "Vergessene Truhe",
	[357231] = "Vergessene Truhe",
	[357232] = "Vergessene Truhe",
	[357233] = "Vergessene Truhe",
	[357234] = "Vergessene Truhe",
	[357235] = "Vergessene Truhe",
	[357236] = "Vergessene Truhe",
	[357237] = "Vergessene Truhe",
	[357238] = "Vergessene Truhe",
	[357246] = "Zerfledderte Schriftrolle",
	[357467] = "Verbotene Tinte",
	[357487] = "Schicker Sonnenschirm",
	[357515] = "Sack Hafer",
	[357526] = "Leerer Wassereimer",
	[357541] = "Weggeworfenes Hufeisen",
	[357565] = "Vergessene Angelrute",
	[357572] = "Rapier der Furchtlosen",
	[357584] = "Vyrthas Schreckensgleve",
	[357683] = "Behelfsmäßige Schlammlache des Ausgestoßenen",
	[357697] = "Schatz des Zuchtmeisters",
	[357726] = "Zerbrochener Speer",
	[357758] = "Seuchenfass",
	[357771] = "Vergrabene Truhe",
	[357937] = "Vergrabene Truhe",
	[358298] = "Schließkassette der verbotenen Kammer",
	[358315] = "Skeletthandfragmente",
	[358318] = "Gräberporträt von R. Suavel",
	[358319] = "Notiz des Zauberers",
	[358382] = "Gesucht: Chelicera",
	[358398] = "Verschollenes Tagebuch",
	[358399] = "Sechsmeilenrucksack",
	[358531] = "Epischer Riesenschatz",
	[358533] = "Vergessene Vorräte",
	[358855] = "Beschädigter Rucksack des sicheren Fallens",
	[360054] = "Klebrige Katze",
	[362489] = "Elysischer Erlass",
	[364345] = "Ein schwach leuchtender Samen",
	[364483] = "Leeres Schlummertrunkfass",
	[364899] = "Kristallisierte Stygia",
	[364926] = "Runengeschmiedete Fesseln",
	[364932] = "Lodernder Barren",
	[364937] = "Phasenschröpfer",
	[364987] = "Mittlertagebuch",
	[364994] = "Spektralhacke",
	[365084] = "Pike des Quälers",
	[365093] = "Theotars Liederbücher",
	[368205] = "Schlundgebundene Truhe",
	[368206] = "Schlundgebundene Truhe",
	[368207] = "Schlundgebundene Truhe",
	[368208] = "Schlundgebundene Truhe",
	[368213] = "Schlundgebundene Truhe",
	[368214] = "Schlundgebundene Truhe",
	[368347] = "Versteckte Risstruhe",
	[368645] = "Versteckte Risstruhe",
	[368646] = "Versteckte Risstruhe",
	[368648] = "Versteckte Risstruhe",
	[368649] = "Versteckte Risstruhe",
	[368650] = "Versteckte Risstruhe",
	[368653] = "Ätherwyrmkäfig",
	[368663] = "Minimons rechte Hand",
	[368665] = "Minimons Ersatzarm",
	[368666] = "Minimons Kopf",
	[368667] = "Minimons Oberkörper",
	[368668] = "Minimons Unterkörper",
	[368772] = "Siegelgezeichnete Schriftrolle",
	[368876] = "Schlundgebundene Truhe",
	[368935] = "Sündensturzkreischerkäfig",
	[368946] = "Gestohlenes Animagefäß",
	[368948] = "Gestohlenes Animagefäß",
	[368949] = "Gestohlenes Animagefäß",
	[368950] = "Gestohlenes Animagefäß",
	[368951] = "Gestohlenes Animagefäß",
	[368952] = "Gestohlenes Animagefäß",
	[368953] = "Gestohlenes Animagefäß",
	[369129] = "Nilganihmahts Goldband",
	[369132] = "Versiegelte Herrschaftstruhe",
	[369133] = "Herrschaftssiegel #1",
	[369134] = "Versiegelter Herrschaftskäfig",
	[369135] = "Herrschaftssiegel #2",
	[369138] = "Siegel der Herrschaftstruhe",
	[369141] = "Schlundgebundene Truhe",
	[369143] = "Viertel eines uralten Rings",
	[369144] = "Schlüsselring der Plagerin",
	[369145] = "Vorratskiste von Helgarde",
	[369148] = "Glitzerndes Nestmaterial",
	[369149] = "Vergessene Feder",
	[369172] = "Verlorenes Andenken",
	[369183] = "Heruntergefallenes Nest",
	[369185] = "Korthianische Reliktschatulle",
	[369194] = "Animabeladenes Ei",
	[369204] = "Versetztes Relikt",
	[369216] = "Helgebundene Truhe",
	[369224] = "Juwelenbesetztes Herz von Ezekiel",
	[369225] = "Befallener Überrest",
	[369227] = "Gestohlenes Animagefäß",
	[369232] = "Opferkiste",
	[369234] = "Opferschlüssel",
	[369235] = "Gestohlenes Animagefäß",
	[369236] = "Gestohlenes Animagefäß",
	[369245] = "Korthianische Reliktschatulle",
	[369292] = "Relikttruhe",
	[369294] = "Relikttruhe",
	[369295] = "Knochenhaufen",
	[369296] = "Splitterfellvorrat",
	[369297] = "Knochenhaufen",
	[369304] = "Korthianische Reliktschatulle",
	[369327] = "Invasiver Schlundpilz",
	[369329] = "Invasiver Schlundpilz",
	[369330] = "Invasiver Schlundpilz",
	[369331] = "Invasiver Schlundpilz",
	[369332] = "Invasiver Schlundpilz",
	[369333] = "Nest aus ungewöhnlichen Materialien",
	[369334] = "Nest aus ungewöhnlichen Materialien",
	[369335] = "Nest aus ungewöhnlichen Materialien",
	[369336] = "Nest aus ungewöhnlichen Materialien",
	[369337] = "Nest aus ungewöhnlichen Materialien",
	[369339] = "Schlundgebundene Truhe",
	[369340] = "Korthianische Reliktschatulle",
	[369341] = "Schlundgebundene Truhe",
	[369432] = "Verlegter Venthyrfoliant",
	[369437] = "Rissgebundene Truhe",
	[369438] = "Rissgebundene Truhe",
	[369439] = "Rissgebundene Truhe",
	[369440] = "Rissgebundene Truhe",
	[369602] = "Hände des Widerstands",
	[369757] = "Untergetauchte Truhe",
	[369893] = "Dringendes Schreiben",
	[369894] = "Dringendes Schreiben",
	[370140] = "Beschädigter Behälter der Jiro",
	[370469] = "Spektrales Futter",
	[370494] = "Toccatianische Truhe",
	[373437] = "Stinkender Blobfischschwarm",
	[373438] = "Spiralkrallententakel",
	[373439] = "Ein Schwarm Flossenfische",
	[373460] = "Faenetz",
	[373471] = "Mezzonische Truhe",
	[373472] = "Glissandische Truhe",
	[373473] = "Fugalische Truhe",
	[373474] = "Kantarische Truhe",
	[373543] = "Bibliotheksarchiv",
	[373548] = "Vorlagenarchiv",
	[373553] = "Teleporter",
	[373561] = "Vergessenes Protoarchiv",
	[373562] = "Erregbare Konkordanz",
	[373563] = "Wechselhafte Konkordanz",
	[373568] = "Verschlossene Provistruhe",
	[373579] = "Entdeckung des Spürauges",
	[373580] = "Stille Konkordanz",
	[373581] = "Erregbare Konkordanz",
	[373582] = "Wechselhafte Konkordanz",
	[373583] = "Stille Konkordanz",
	[373584] = "Erregbare Konkordanz",
	[373585] = "Wechselhafte Konkordanz",
	[373586] = "Stille Konkordanz",
	[373587] = "Erregbare Konkordanz",
	[373588] = "Wechselhafte Konkordanz",
	[374976] = "Symphonisches Archiv",
	[375021] = "Zugrunde gegangenes Automa",
	[375058] = "Toccatianische Truhe",
	[375059] = "Mezzonische Truhe",
	[375060] = "Glissandische Truhe",
	[375061] = "Fugalische Truhe",
	[375062] = "Kantarische Truhe",
	[375064] = "Toccatianische Truhe",
	[375066] = "Mezzonische Truhe",
	[375067] = "Glissandische Truhe",
	[375068] = "Fugalische Truhe",
	[375069] = "Kantarische Truhe",
	[375188] = "Anordnung des Gewölbten Alkovens",
	[375189] = "Anordnung des Bereichernden Alkovens",
	[375190] = "Anordnung des Runden Alkovens",
	[375191] = "Anordnung des Inaktiven Alkovens",
	[375192] = "Anordnung des Prächtigen Alkovens",
	[375234] = "Gehärtetes Drakoniumvorkommen",
	[375235] = "Geschmolzenes Drakoniumvorkommen",
	[375238] = "Titanversetztes Drakoniumvorkommen",
	[375239] = "Urdrakoniumvorkommen",
	[375240] = "Wutentbranntes Drakoniumvorkommen",
	[375241] = "Blasenmohn",
	[375242] = "Titanenberührter Blasenmohn",
	[375243] = "Wutentbrannter Blasenmohn",
	[375244] = "Eisiger Blasenmohn",
	[375245] = "Windgepeitschter Blasenmohn",
	[375246] = "Verrotteter Blasenmohn",
	[375270] = "Protoformbauplan",
	[375272] = "Schlundgebundene Truhe",
	[375281] = "Gestohlenes Relikt",
	[375283] = "Filtrationsanlage",
	[375290] = "Chiffrengebundene Truhe",
	[375354] = "Herrschaftstruhe",
	[375362] = "Ornidennest",
	[375363] = "Schlundgebundene Vorratstruhe",
	[375366] = "Tarachnideneier",
	[375368] = "Schöpfungskatalysatorkonsole",
	[375369] = "Angenagter Handkoffer",
	[375370] = "Protoformbauplan",
	[375371] = "Protoformbauplan",
	[375373] = "Weggeworfener Automaschrott",
	[375376] = "Gefallenes Gewölbe",
	[375382] = "Zerschmetterte Vorratskiste",
	[375383] = "Protoformbauplan",
	[375387] = "Protoformbauplan",
	[375388] = "Protoformbauplan",
	[375389] = "Protoformbauplan",
	[375390] = "Protoformbauplan",
	[375391] = "Protoformbauplan",
	[375393] = "Protoformbauplan",
	[375396] = "Klumpiger Sandhaufen",
	[375397] = "Glitzernder Sandhaufen",
	[375398] = "Unbeständiger Sandhaufen",
	[375399] = "Summender Sandhaufen",
	[375400] = "Verformter Sandhaufen",
	[375401] = "Funkelnder Sandhaufen",
	[375402] = "Tickender Sandhaufen",
	[375403] = "Breibedecktes Relikt",
	[375404] = "Sandgeschliffene Truhe",
	[375405] = "Geklautes Artefakt",
	[375408] = "Reserve des Architekten",
	[375411] = "Verwechseltes Ovoid",
	[375413] = "Vorräte des ertrunkenen Mittlers",
	[375422] = "Überwucherte Protofrucht",
	[375423] = "Opfergabe an die Ersten",
	[375478] = "Protomineralienextraktor",
	[375479] = "Protoformbauplan",
	[375481] = "Stibitzte Kuriosität",
	[375483] = "Gestohlene Schriftrolle",
	[375484] = "Dankbares Geschenk",
	[375485] = "Protofloraernter",
	[375486] = "Protoformbauplan",
	[375492] = "Syntaktisches Gewölbe",
	[375493] = "Reife Protobirne",
	[375494] = "Rundtruhe",
	[375495] = "Wogendes Blattwerk",
	[375496] = "Ein Scheffel Progenitorerzeugnisse",
	[375498] = "Protoformbauplan",
	[375502] = "Protoformbauplan",
	[375516] = "Verlorene Wabe",
	[375517] = "Verdächtig aussehender Trümmerhaufen",
	[375530] = "Vergessener Schatztresor",
	[375536] = "Xy'raths präparierte Truhe",
	[375538] = "Verlorener Ovoid",
	[375668] = "Neblige Schatzkiste",
	[375693] = "Protoformbauplan",
	[375694] = "Protoformbauplan",
	[375746] = "Prototypbauplan",
	[375748] = "Protoformbauplan",
	[375889] = "Protoformbauplan",
	[375893] = "Sehr wertvoller Schatz",
	[375900] = "Protoformbauplan",
	[375902] = "Zerfleddertes Astraltuch",
	[375903] = "Protoformbauplan",
	[375905] = "Protoformbauplan",
	[375907] = "Protoformbauplan",
	[375915] = "Schimmer des Gleichmuts",
	[375950] = "Schmuckstück der reinen Innovation",
	[375972] = "Gesucht: Custos",
	[375973] = "Firim im Exil, Teil 1",
	[375974] = "Kristallisiertes Echo des Ersten Lieds",
	[375981] = "Protoformbauplan",
	[375982] = "Firim im Exil, Teil 2",
	[375983] = "Firim im Exil, Teil 3",
	[375984] = "Firim im Exil, Teil 4",
	[375985] = "Firim im Exil, Teil 5",
	[375986] = "Firim im Exil, Teil 6",
	[375987] = "Firim im Exil, Teil 7",
	[375988] = "Firim im Exil, Epilog",
	[376041] = "Verhüllte Chiffrentruhe",
	[376124] = "Tasche mit verzaubertem Wind",
	[376175] = "Vorratskiste der Vollsegel",
	[376213] = "Geheimnisvoller Zauberstab",
	[376325] = "So nah, so fern",
	[376386] = "Bewegte Erde",
	[376416] = "Ellas Lieblingsspielzeuge",
	[376426] = "Magiegebundene Truhe",
	[376451] = "Bronzestoppuhr",
	[376578] = "Titanentruhe",
	[376580] = "Depot der Djaradin",
	[376581] = "Klankiste",
	[376582] = "Kiste der Tuskarr",
	[376583] = "Mit Moder bedeckte Kiste",
	[376587] = "Expeditionsspäherpack",
	[376657] = "Uraltes Monument",
	[376757] = "GESUCHT: Frigellus",
	[377114] = "Rolle mit schwerem Seil",
	[377233] = "Hessethiashs erbärmlich versteckter Schatz",
	[377485] = "Saurer Apfel",
	[377499] = "Über die Entstehung der Drakonidenarten",
	[377534] = "Abgelieferter Tresor",
	[377899] = "Versteckte Flunkergeisel",
	[377900] = "Kriegsspeer der Nokhud",
	[377938] = "Prismatischer Springerschwarm",
	[378010] = "Vergessener Drachenschatz",
	[378054] = "Springflutbräu",
	[378088] = "Kristalline Blume",
	[378820] = "Sprudelpunsch",
	[378857] = "Verlorene Obsidiantruhe",
	[379168] = "Verlorener Truhenschlüssel",
	[379248] = "Drakoniumvorkommen",
	[379252] = "Drakoniumvorkommen",
	[379263] = "Reiches Drakoniumvorkommen",
	[379267] = "Reiches Drakoniumvorkommen",
	[379272] = "Drakoniumflöz",
	[379290] = "Verzierte Statue",
	[379296] = "Abgebrochene Leiste",
	[379297] = "Krach-Bumm-Gesöff",
	[379314] = "Gefülltes Fischernetz",
	[379321] = "Mysteriöser Tatzenabdruck",
	[380429] = "Goldene Klaue",
	[380430] = "Schwanzfragment",
	[380457] = "Experimenteller Verderbniskessel",
	[380516] = "Glimmer der Weisheit",
	[380533] = "Schneebedeckte Schriftrolle",
	[380540] = "Verzierte Statue",
	[380545] = "Schönes Juwel des Malers",
	[380547] = "Verfallerfülltes Gerböl",
	[380548] = "Vergessenes Schmuckkästchen",
	[380549] = "Interessanter blauer Stoffballen",
	[380550] = "Foliant des vergesslichen Lehrlings",
	[380554] = "Gut eingetanzte Trommel",
	[380556] = "Harmonische Truhe",
	[380558] = "Verzauberte Trümmer",
	[380559] = "Frostgeschmiedeter Trank",
	[380560] = "Deaktivierte Teslaspule",
	[380567] = "Sturm-Acht",
	[380569] = "Kristalliner Überwuchs",
	[380570] = "Merkwürdige Glyphe",
	[380571] = "Bummthyrrakete",
	[380577] = "Erhabener Malygit",
	[380578] = "Welplingzähmen leicht gemacht",
	[380579] = "Ersatzwerkzeuge der Djaradin",
	[380580] = "Lavaerfüllter Samen",
	[380583] = "Modernde Brackenfelldecke",
	[380585] = "Hervorgebrochene Alexstraszitansammlung",
	[380586] = "Mysteriöse Kessel",
	[380587] = "Kiste mit behandelten Bälgen",
	[380588] = "Miniaturbanner des bronzenen Drachenschwarms",
	[380589] = "Leicht verzauberte Überreste",
	[380590] = "Gut isolierter Krug",
	[380591] = "Streng bewachter Glitzerkram",
	[380592] = "Sturmgebundenes Horn",
	[380593] = "Beutel voller verrotteter Schuppen",
	[380595] = "Mattes Pergament",
	[380597] = "Kampfgestählter Zentaurenteppich",
	[380598] = "Angesengte Kiste",
	[380600] = "Angereicherter Erdsplitter",
	[380601] = "Staubige Dunkelmondkarte",
	[380602] = "Windgesegneter Balg",
	[380604] = "Mysteriöses Banner",
	[380605] = "Verbotenes Gemisch",
	[380607] = "Angesengter Wanderstoff",
	[380608] = "Seidene Überraschung",
	[380610] = "Pulsierende Erdrune",
	[380611] = "Feldflasche mit verdächtigem Wasser",
	[380612] = "Referenzblatt für Gebärdensprache",
	[380615] = "Bündel des Wilderers",
	[380616] = "Kleiner Korb mit Feuerwasserpulver",
	[380617] = "Waffendiagramm der Qalashi",
	[380618] = "Drakonischer Flux",
	[380619] = "Eigentümliche Barren",
	[380620] = "Uralte Speersplitter",
	[380623] = "Zauberberührte Zange",
	[380643] = "Schockgefrorene Schriftrolle",
	[380647] = "Vergessener arkaner Foliant",
	[380648] = "Seltsames Buch",
	[380652] = "Gebrochene titanische Sphäre",
	[380653] = "Yennus Drachen",
	[380654] = "Brustplatte des toten Mannes",
	[380709] = "Zeichnungen der Stulpen des Falkners",
	[380763] = "Uralter Drachenwebrahmen",
	[380822] = "Feuriger Edelstein",
	[380840] = "Zerfledderter Reiterbeutel",
	[380842] = "Goldmünze",
	[380843] = "Gummifisch",
	[380847] = "Smaragdedelsteinklumpen",
	[380859] = "Spielzeugboot der Tuskarr",
	[380860] = "Zentaurenhorn",
	[380867] = "Bernsteinklumpen",
	[380902] = "Felder der Wildheit",
	[380918] = "Zerbrochene verzierte Statue",
	[380963] = "Kleiner Aschehaufen",
	[380991] = "Erdhaufen",
	[381035] = "Die Große Schatzkammer",
	[381045] = "Goldener Drachenkelch",
	[381065] = "Defektes Portal",
	[381069] = "Gefülltes Fischernetz",
	[381071] = "Kasten mit Steinen",
	[381094] = "Eleganter Leinwandpinsel",
	[381104] = "Reiches Serevitvorkommen",
	[381105] = "Reiches Serevitvorkommen",
	[381106] = "Serevitflöz",
	[381107] = "Sandhaufen",
	[381108] = "Yennus Karte",
	[381110] = "Vergessenes Schmuckkästchen",
	[381153] = "Rubinedelsteinklumpen",
	[381154] = "Krümmrinde",
	[381157] = "Saphiredelsteinklumpen",
	[381158] = "Dreschflegel des Gnollunholds",
	[381160] = "Verlorener Kompass",
	[381196] = "Titanenberührte Krümmrinde",
	[381197] = "Wutentbrannte Krümmrinde",
	[381198] = "Verrottete Krümmrinde",
	[381199] = "Windgepeitschte Krümmrinde",
	[381200] = "Eisige Krümmrinde",
	[381201] = "Eisiges Steinbrich",
	[381202] = "Windgepeitschtes Steinbrich",
	[381203] = "Verrottetes Steinbrich",
	[381204] = "Wutentbranntes Steinbrich",
	[381205] = "Titanenberührtes Steinbrich",
	[381207] = "Steinbrich",
	[381210] = "Titanenberührte Hochblume",
	[381211] = "Wutentbrannte Hochblume",
	[381212] = "Verrottete Hochblume",
	[381213] = "Windgepeitschte Hochblume",
	[381214] = "Eisige Hochblume",
	[381216] = "Landvermesserlupe",
	[381223] = "Gesprungenes Stundenglas",
	[381277] = "Fass voller beschlagnahmter Leckerlis",
	[381296] = "Fürchterliche Sauerei",
	[381297] = "Verlegtes Gepäck",
	[381336] = "Ein kleiner Teil",
	[381340] = "Neltharusständer",
	[381341] = "Willkommen dem Ersten",
	[381343] = "Lernt und gedeiht",
	[381353] = "Steinerner Drachenzahn",
	[381354] = "Gewickeltes Goldband",
	[381355] = "Fein geschnitzter Flügel",
	[381356] = "Kaltgewaschene Drachenklaue",
	[381357] = "Steintafel",
	[381358] = "Steintafel",
	[381359] = "Steintafel",
	[381361] = "Kostbares Steinfragment",
	[381362] = "Bruchstück einer Skulptur",
	[381365] = "Flagge der Drachenschuppenexpedition",
	[381367] = "Flagge der Drachenschuppenexpedition",
	[381369] = "Flagge der Drachenschuppenexpedition",
	[381370] = "Flagge der Drachenschuppenexpedition",
	[381373] = "Flagge der Drachenschuppenexpedition",
	[381375] = "Flagge der Drachenschuppenexpedition",
	[381377] = "Flagge der Drachenschuppenexpedition",
	[381483] = "Preis der Marmoni",
	[381484] = "Gut erhaltener Knochen",
	[381485] = "Verlorenes Seifenstück eines Abenteurers",
	[381510] = "Knochen fliegender Fische",
	[381511] = "Harpunenspitze",
	[381512] = "Holzstab",
	[381513] = "Alte Spitzhacke",
	[381514] = "Wassergeschliffener Basalt",
	[381515] = "Gehärtetes Serevitvorkommen",
	[381516] = "Geschmolzenes Serevitvorkommen",
	[381517] = "Titanenberührtes Serevitvorkommen",
	[381518] = "Urserevitvorkommen",
	[381519] = "Wutentbranntes Serevitvorkommen",
	[381575] = "Entenfallen-Set",
	[381579] = "Anfrage des Archivars",
	[381584] = "Anfrage des Archivars",
	[381650] = "Anfrage des Archivars",
	[381653] = "Einschreibungen für Zahnflatterfeuer",
	[381661] = "Anfrage des Archivars",
	[381662] = "Anfrage des Archivars",
	[381663] = "Manastürmen für Anfänger",
	[381664] = "Anfrage des Archivars",
	[381667] = "Anfrage des Archivars",
	[381668] = "Anfrage des Archivars",
	[381669] = "Anfrage des Archivars",
	[381670] = "Anfrage des Archivars",
	[381671] = "Anfrage des Archivars",
	[381672] = "Anfrage des Archivars",
	[381687] = "Weggeworfene Notiz",
	[381691] = "Ein schlüpfriger Romantikschmöker: Die lüsterne drakonische Magierin",
	[381701] = "GESUCHT: Mara'nar der Donnernde",
	[381705] = "Die Gnollkriege",
	[381706] = "Eure Träumerin",
	[381707] = "Smaragdgrüne Träume",
	[381708] = "Das erste Kurnal",
	[381709] = "Wind, Holz, Wasser",
	[381711] = "Im'bunatas Segen",
	[381712] = "Wassergebundene Truhe",
	[381713] = "Ein solides Fundament",
	[381715] = "Achtung: Umgehende Evakuierung",
	[381718] = "Der Schwur",
	[381722] = "Erhaltung von Vakthros",
	[381730] = "Mächtige Enten",
	[381731] = "Eine Nachricht zur rechten Zeit",
	[381732] = "Segen des Hüters",
	[381733] = "Wächterschwingen",
	[381734] = "Gemeinsam gebunden",
	[381735] = "Notizen des Verwalters",
	[381957] = "Üppiger Blasenmohn",
	[381958] = "Üppige Krümmrinde",
	[381959] = "Üppiges Steinbrich",
	[381960] = "Üppige Hochblume",
	[381964] = "Deaktivierter Signaltransmitter",
	[381981] = "Truhe der Flut",
	[381983] = "Deaktivierter Signaltransmitter",
	[381985] = "Deaktivierter Signaltransmitter",
	[381987] = "Deaktivierter Signaltransmitter",
	[381989] = "Deaktivierter Signaltransmitter",
	[381991] = "Deaktivierter Signaltransmitter",
	[381993] = "Deaktivierter Signaltransmitter",
	[381995] = "Deaktivierter Signaltransmitter",
	[381997] = "Deaktivierter Signaltransmitter",
	[381999] = "Deaktivierter Signaltransmitter",
	[382001] = "Deaktivierter Signaltransmitter",
	[382003] = "Deaktivierter Signaltransmitter",
	[382029] = "Bewegte Erde",
	[382071] = "Gefülltes Fischernetz",
	[382079] = "Flagge der Drachenschuppenexpedition",
	[382086] = "Flagge der Drachenschuppenexpedition",
	[382092] = "Flagge der Drachenschuppenexpedition",
	[382094] = "Flagge der Drachenschuppenexpedition",
	[382101] = "Flagge der Drachenschuppenexpedition",
	[382103] = "Flagge der Drachenschuppenexpedition",
	[382105] = "Flagge der Drachenschuppenexpedition",
	[382107] = "Flagge der Drachenschuppenexpedition",
	[382110] = "Flagge der Drachenschuppenexpedition",
	[382112] = "Flagge der Drachenschuppenexpedition",
	[382116] = "Flagge der Drachenschuppenexpedition",
	[382118] = "Flagge der Drachenschuppenexpedition",
	[382120] = "Flagge der Drachenschuppenexpedition",
	[382166] = "Das Rubinfestmahl!",
	[382180] = "Überhitzter Magmadrescherschwarm",
	[382193] = "Truhe der Elemente",
	[382195] = "Elementargebundene Truhe",
	[382325] = "Onyxedelsteinklumpen",
	[382621] = "Belebungskatalysatorkonsole",
	[383625] = "Kiste mit frischem Leuchtfisch",
	[383660] = "Salzkristall",
	[383732] = "Angelzubehör der Tuskarr",
	[383733] = "Bewegte Erde",
	[383734] = "Bewegte Erde",
	[383735] = "Bewegte Erde",
	[384311] = "Uralter Band",
	[384312] = "Uralter Band",
	[384313] = "Uralter Band",
	[384317] = "Zusammengeknüllter Bauplan",
	[384318] = "Unauffälliges Lesezeichen",
	[384370] = "Vorsätzlich schlampige Notizen",
	[384405] = "Halbgarer Fisch",
	[384653] = "Uralter Band",
	[384654] = "Uralter Band",
	[384763] = "Verbotener Schatz",
	[384980] = "Mysteriöse Truhe",
	[385001] = "Leeres Fischfass",
	[385008] = "Gesponnene Netze",
	[385010] = "Gesponnene Netze",
	[385021] = "Versteinertes Drachenei",
	[385022] = "Erodiertes Fossil",
	[385028] = "Machtvolles Fläschchen der Erneuerung",
	[385032] = "Goldhaufen",
	[385064] = "Eisstachel",
	[385074] = "Magiegebundene Truhe",
	[385075] = "Magiegebundene Truhe",
	[385396] = "Urzeitliche Flammentruhe",
	[385398] = "Sengende Truhe",
	[385401] = "Sengende Truhe",
	[385415] = "Knochenhaufen",
	[385467] = "Knochenhaufen",
	[385468] = "Knochenhaufen",
	[385469] = "Knochenhaufen",
	[385520] = "Knochenhaufen",
	[385533] = "Sendestein: Protest",
	[385565] = "Lodernde Schattenflammentruhe",
	[385581] = "Henrys Handtasche",
	[385584] = "Anspruch auf Perfektion",
	[385585] = "Bindende Schwure",
	[385586] = "Urgewalt",
	[385799] = "Gehärtete Schließkassette",
	[385800] = "Goldhaufen",
	[385801] = "Goldhaufen",
	[385802] = "Goldhaufen",
	[385826] = "Titanenkiste",
	[385830] = "Sendestein: Erster Bericht",
	[385831] = "Sendestein: Die Gefangene",
	[385832] = "Empfangsstein: Letzte Warnung",
	[385834] = "Tagebucheintrag: Experimente",
	[385835] = "Tagebucheintrag: Relikte",
	[385836] = "Tagebucheintrag: Die Horte",
	[385837] = "Tagebucheintrag: Stille",
	[385917] = "Deaktivierter Signaltransmitter",
	[385919] = "Deaktivierter Signaltransmitter",
	[385921] = "Deaktivierter Signaltransmitter",
	[385937] = "Titanenkiste",
	[385940] = "Runenschraubenschlüssel",
	[385952] = "Ungewöhnlicher Ring",
	[385961] = "Rumble-Münzenbeutel",
	[386079] = "Ordentlich zerkaute Truhe",
	[386080] = "Sengender Schlüssel",
	[386083] = "Brodelnde Kugel",
	[386086] = "Brodelnde Truhe",
	[386088] = "Ritualopfergaben",
	[386089] = "Ritualopfergaben",
	[386090] = "Ritualopfergaben",
	[386091] = "Ritualopfergaben",
	[386104] = "Uralte Zaqalitruhe",
	[386106] = "Flagge der Drachenschuppenexpedition",
	[386108] = "Flagge der Drachenschuppenexpedition",
	[386123] = "Verkohltes Ei",
	[386138] = "Rumble-Münzenbeutel",
	[386139] = "Rumble-Münzenbeutel",
	[386158] = "Rumble-Folientasche",
	[386168] = "Truhe der Weitenschuppen",
	[386353] = "Gehärtete Truhe",
	[386354] = "Gehärtete Truhe",
	[386421] = "Urzeitliche Flammentruhe",
	[386422] = "Urzeitliche Flammentruhe",
	[386423] = "Urzeitliche Flammentruhe",
	[386424] = "Sengende Truhe",
	[386425] = "Sengende Truhe",
	[386426] = "Urzeitliche Erdtruhe",
	[386427] = "Karren mit Steinbruch",
	[386428] = "Urzeitliche Erdtruhe",
	[386429] = "Urzeitliche Erdtruhe",
	[386430] = "Gehärtete Truhe",
	[386431] = "Urzeitliche Erdtruhe",
	[386432] = "Gehärtete Truhe",
	[386433] = "Urzeitliche Windtruhe",
	[386441] = "Urzeitliche Windtruhe",
	[386442] = "Urzeitliche Leerentruhe",
	[386443] = "Urzeitliche Windtruhe",
	[386444] = "Urzeitliche Wassertruhe",
	[386445] = "Urzeitliche Wassertruhe",
	[386447] = "Urzeitliche Wassertruhe",
	[386450] = "Urzeitliche Wassertruhe",
	[386451] = "Windgebundene Schließkassette",
	[386452] = "Leerengebundene Schließkassette",
	[386453] = "Windgebundene Schließkassette",
	[386454] = "Eistruhe",
	[386455] = "Hartpanzertruhe",
	[386456] = "Hartpanzertruhe",
	[386457] = "Gefrorene Kiste",
	[386458] = "Urzeitliche Verfalltruhe",
	[386459] = "Urzeitliche Verfalltruhe",
	[386460] = "Urzeitliche Arkantruhe",
	[386461] = "Urzeitliche Arkantruhe",
	[386462] = "Urzeitliche Bluttruhe",
	[386463] = "Urzeitliche Goldtruhe",
	[386470] = "Goldhaufen",
	[386472] = "Goldhaufen",
	[386484] = "Goldhaufen",
	[386531] = "Goldhaufen",
	[386532] = "Urzeitliche Goldtruhe",
	[386547] = "Durchdringungsform",
	[386555] = "Seltsamer runder Gegenstand",
	[386556] = "Staubige Vase",
	[386559] = "Gesicherte Lieferung",
	[386573] = "Verzierte Schlüsselschatulle",
	[386578] = "Neltharions Geschenkmarke",
	[386579] = "Neltharions Geschenkmarke",
	[386580] = "Neltharions Geschenkmarke",
	[386581] = "Neltharions Geschenkmarke",
	[386582] = "Neltharions Geschenkmarke",
	[386583] = "Neltharions Geschenkmarke",
	[386585] = "Experimenteller Verschmelzer",
	[386586] = "Prismatisches Fragment",
	[386587] = "Prismatisches Fragment",
	[386588] = "Kristallkorb",
	[386589] = "Kristallkorb",
	[386591] = "Leere Phiole",
	[386604] = "Urzeitliche Goldtruhe",
	[386605] = "Goldhaufen",
	[386632] = "Experimentelles Drachenpack",
	[386633] = "Kiste der Stürme",
	[386648] = "Mysteriöse Schriftrolle",
	[386660] = "Goldhaufen",
	[386668] = "Zerschmettertes Schmuckstück der Hakkari",
	[386669] = "Zerbrochenes Schmuckstück der Hakkari",
	[386680] = "Mysteriöser Almanach",
	[386683] = "Versengtes Buch",
	[386687] = "Gealtertes Tagebuch",
	[386688] = "Leerer Foliant",
	[386690] = "Unklares Kompendium",
	[386762] = "Urzeitliche Rüstungstruhe",
	[387493] = "Einzigartiger Fisch",
	[387496] = "Kohlenpfanne des Wahnsinns",
	[387500] = "Frostiger Schneemann",
	[387501] = "Neltharions Geschenkmarke",
	[387503] = "Versiegelter Brief an Neltharion",
	[387507] = "Azeritpulverfass",
	[387508] = "Zündfackel",
	[387520] = "TICKET: Glimmeroggspiele",
	[387695] = "Rumble-Münzenbeutel",
	[387697] = "Rumble-Münzenbeutel",
	[387718] = "Rumble-Folientasche",
	[387720] = "Rumble-Folientasche",
	[387721] = "Rumble-Folientasche",
	[387722] = "Rumble-Folientasche",
	[387725] = "Leuchtender Kristall",
	[387727] = "Schwefelkristall",
	[387728] = "Oper der Aspekte",
	[387729] = "Magmakristall",
	[387736] = "Die Alten Götter und die Ordnung von Azeroth",
	[387737] = "Lebendiges Buch",
	[387746] = "Urzeitliche Geistertruhe",
	[387749] = "Belebter Kristallrücken",
	[387853] = "Zertrümmerte Kristalle",
	[388471] = "Geplünderte urzeitliche Truhe",
	[388712] = "Operntruhe",
	[388866] = "Reagenzientopf",
	[388873] = "Goldbeutel der Eisenfluträuber",
	[388876] = "Reagenzientopf",
	[388895] = "Wahlloses Gekritzel",
	[388896] = "Kristallummantelte Truhe",
	[388905] = "Neltharions Werkzeugsatz",
	[388908] = "Träger Glibber",
	[388911] = "Alter Koffer",
	[389102] = "Prismatisches Fragment",
	[389103] = "Prismatisches Fragment",
	[389104] = "Prismatisches Fragment",
	[389105] = "Prismatisches Fragment",
	[389106] = "Prismatisches Fragment",
	[389107] = "Prismatisches Fragment",
	[389108] = "Prismatisches Fragment",
	[389111] = "Durchnässtes Bündel",
	[389114] = "Lang verlorene Truhe",
	[389173] = "Urzeitliche Bluttruhe",
	[389231] = "Urzeitliche Musiktruhe",
	[389471] = "Große Obsidiantruhe",
	[389540] = "Schleimiger Glibber",
	[389545] = "Mysteriöse Truhe",
	[389546] = "Reagenzientopf",
	[389564] = "Geistloser Schleim",
	[389599] = "Eisstachel",
	[389789] = "Urzeitliche Erdtruhe",
	[389902] = "Urzeitliche Erdtruhe",
	[390008] = "Eis",
	[390009] = "Kasten mit Steinen",
	[390074] = "Urzeitliche Tiefseetruhe",
	[390136] = "Sporengebundene Essenz",
	[390137] = "Metamorphes Serevitvorkommen",
	[390138] = "Metamorphes Drakoniumvorkommen",
	[390139] = "Flackernde Hochblume",
	[390140] = "Flackerndes Steinbrich",
	[390141] = "Flackernde Krümmrinde",
	[390142] = "Flackernder Blasenmohn",
	[390257] = "Plüschbär",
	[390258] = "Träger Glibber",
	[390559] = "Kasten mit Steinen",
	[390560] = "Verschlossene Forschungstruhe",
	[392025] = "Geformte Münzen",
	[392026] = "Neltharions Münzform",
	[392030] = "Schwarzstahlhammer",
	[392031] = "Rumble-Folientasche",
	[392032] = "Rumble-Folientasche",
	[392335] = "Urzeitliche Rüstungstruhe",
	[392569] = "Kettengebundene urzeitliche Truhe",
	[392570] = "Kettengebundene urzeitliche Truhe",
	[392571] = "Kettengebundene Schließkassette",
	[392572] = "Kettengebundene Schließkassette",
	[392573] = "Kettengebundene Schließkassette",
	[392580] = "Verlegte Auslassblaupläne von Aberrus",
	[392581] = "Unachtsam weggeworfene Bomben",
	[392582] = "Fehlerhaftes Überlebenspaket",
	[392583] = "Leerengebundene Schließkassette",
	[392587] = "Kaputter Wyrmlochgenerator",
	[392591] = "Truhe der Schwärme",
	[392593] = "Unauffälliger Datenschürfer",
	[393218] = "Urzeitliche Arkantruhe",
	[393220] = "Urzeitliche Farbentruhe",
	[393221] = "Reagenzientopf",
	[393222] = "Vorratskoffer",
	[393282] = "Ballonkiste",
	[393283] = "Ballonkiste",
	[393957] = "Goldhaufen",
	[393958] = "Goldhaufen",
	[396019] = "Gestohlenes Lager",
	[396020] = "Gestohlenes Lager",
	[396339] = "Von Motten geplünderte Tasche",
	[398133] = "Bolzen und Bronze",
	[398135] = "Weggeworfener Drakothystbohrer",
	[398138] = "Geschmolzener Späherbot",
	[398200] = "Vergessene Schließkassette",
	[398674] = "Schillerndes Flugblatt",
	[398698] = "Quietschender Lochkäse",
	[398751] = "Üppiger Blasenmohn",
	[398752] = "Üppige Krümmrinde",
	[398753] = "Üppige Hochblume",
	[398754] = "Üppiges Steinbrich",
	[398755] = "Blasenmohn",
	[398756] = "Krümmrinde",
	[398758] = "Steinbrich",
	[398759] = "Titanenberührter Blasenmohn",
	[398760] = "Titanenberührte Krümmrinde",
	[398761] = "Titanenberührte Hochblume",
	[398762] = "Titanenberührtes Steinbrich",
	[398764] = "Wutentbrannter Blasenmohn",
	[398765] = "Wutentbrannte Krümmrinde",
	[398766] = "Wutentbrannte Hochblume",
	[398767] = "Wutentbranntes Steinbrich",
	[398770] = "Kasten mit Steinen",
	[398778] = "Widerwärtiger Bottich",
	[398783] = "Flammenerfülltes Schuppenöl",
	[398785] = "Lavageschmiedetes \"Ledermesser\"",
	[398786] = "Gesponnene Netze",
	[398787] = "Gesponnene Netze",
	[398788] = "Gesponnene Netze",
	[398789] = "Gesponnene Netze",
	[398790] = "Gesponnene Netze",
	[398791] = "Schwefeldurchtränkte Häute",
	[398793] = "Lavaübergossener Schattenkristall",
	[398794] = "Schimmernde aquatische Kugel",
	[398796] = "Resonierender Arkankristall",
	[398810] = "Belohnung der Treue",
	[398814] = "Geschmolzener Schatz",
	[398815] = "Gesicherte Lieferung",
	[398828] = "Truhe der massiven Muckis",
	[401236] = "Unterernährte Exemplare",
	[401238] = "Markgereifter Schleim",
	[401240] = "Verdächtiger Schimmel",
	[401241] = "Schroffe Schneckenhäuser",
	[401292] = "Leicht durchgeschüttelte Juwelen",
	[401299] = "Zerbrochener Tauschfelsbrocken",
	[401828] = "Reliquiar von Nal ks'kol",
	[401839] = "Belohnung des Träumers",
	[401844] = "Stinkender Müllhaufen",
	[401845] = "Stinkende bewegte Erde",
	[401846] = "Stinkende Schatztruhe",
	[402578] = "Leuchtender Schlüssel",
	[402609] = "Dämonisches Tor",
	[402627] = "Abgenutzter Brennofen",
	[402632] = "Schwefel-Rettungsring",
	[402634] = "Ältestenspeer der Zaqali",
	[402841] = "Empfindliches experimentelles Ei",
	[402868] = "Zurückgelassener Reservefallschirm",
	[402878] = "Medizinisches Verbandsset benutzen",
	[402887] = "Fein besticktes Banner",
	[402888] = "Aufwendige Zaqali-Runen",
	[402890] = "Zischender Runenentwurf",
	[402892] = "Uralte Forschung",
	[403458] = "Trunk der Furchtloser Funke",
	[403498] = "Evas Tagebuch",
	[403532] = "Eimer mit Brunnenwasser",
	[403533] = "Nicht zugestellte Rauchwarenlieferung",
	[403534] = "Zertrampelte Puppe",
	[403535] = "Die Besitzurkunde für Andorhal",
	[403536] = "Der Weg hinaus",
	[403552] = "Evas Oberschenkelknochen",
	[403567] = "Gesprungene Anstecknadel der Argentumdämmerung",
	[403702] = "Verlorene Seite",
	[403703] = "Verlorene Seite",
	[403704] = "Verlorene Seite",
	[403705] = "Verlorene Seite",
	[403706] = "Verlorene Seite",
	[403707] = "Verlorene Seite",
	[403708] = "Verlorene Seite",
	[403709] = "Verlorene Seite",
	[403710] = "Verlorene Seite",
	[403711] = "Verlorene Seite",
	[403712] = "Verlorene Seite",
	[403713] = "Verlorene Seite",
	[403714] = "Verlorene Seite",
	[403715] = "Verlorene Seite",
	[403716] = "Verlorene Seite",
	[403717] = "Verlorene Seite",
	[403722] = "Praktischerweise verlegter Haken",
	[403731] = "Gefrorene Rune",
	[403786] = "Schädel mit Geweih",
	[403919] = "Mechanisiertes Zahnrad",
	[403962] = "Omarions zweiter Leitfaden",
	[404232] = "Bleiche Flammenblüte",
	[404242] = "Öldurchtränktes Buch",
	[404260] = "Rätsel gelöst!",
	[404314] = "Gesprungene Steintafel",
	[404337] = "Schankfass",
	[404432] = "Blutdurchtränktes Buch",
	[404480] = "Gezacktes Mantisschwert",
	[404492] = "Vergoldete Vase",
	[404849] = "Schreckenswindnest",
	[404981] = "Schankfass",
	[404982] = "Schankfass",
	[404987] = "Schankfass",
	[404992] = "Schankfass",
	[405009] = "Schankfass",
	[405012] = "Schankfass",
	[405388] = "Bekanntes Tagebuch",
	[405510] = "Uralter Hebel",
	[405511] = "Uralter Hebel",
	[405512] = "Uralter Hebel",
	[405515] = "Verzauberter Kasten",
	[405525] = "Lockerer Erdhaufen",
	[405526] = "Lockerer Erdhaufen",
	[405529] = "Lockerer Erdhaufen",
	[405530] = "Lockerer Erdhaufen",
	[405531] = "Lockerer Erdhaufen",
	[405532] = "Lockerer Erdhaufen",
	[405534] = "Lockerer Erdhaufen",
	[405535] = "Lockerer Erdhaufen",
	[405537] = "Lockerer Erdhaufen",
	[405538] = "Lockerer Erdhaufen",
	[405540] = "Lockerer Erdhaufen",
	[405541] = "Lockerer Erdhaufen",
	[405584] = "Rumble-Folientasche",
	[405585] = "Rumble-Folientasche",
	[405586] = "Rumble-Folientasche",
	[405587] = "Rumble-Folientasche",
	[405593] = "Archive von Azeroth!",
	[405943] = "Drakonidischer Schriftrollenbehälter",
	[405996] = "Uralte Bürgschaftstafel der Zaqali",
	[406383] = "Portal in die Feuerlande",
	[407186] = "Schankfass",
	[407192] = "Schankfass",
	[407199] = "Schankfass",
	[407201] = "Schankfass",
	[408107] = "Kristalline Leuchtblüte",
	[408224] = "Hastig beschriebener Stein",
	[408706] = "Magische Blüte",
	[408707] = "Seltsame Knolle",
	[408767] = "Staubiger Beutel",
	[408934] = "Konstrukteurswerkzeuge",
	[408954] = "Schließkassette des Konstrukteurs",
	[408964] = "Satyrtotem",
	[408976] = "Uralter Foliant",
	[408980] = "Tyrs Vermächtnis",
	[409012] = "Verkaufszertifikat des Auktionshauses",
	[409018] = "Forschungsnotiz",
	[409019] = "Hastig geschriebene Notiz",
	[409020] = "Notiz an Kritha",
	[409077] = "Angesengter Handzettel",
	[409120] = "Behälter voller kosmischer Mysterien",
	[409166] = "Titanenkraftrelais",
	[409200] = "Zerbrochene Urne",
	[409208] = "Zerbrochene Urne",
	[409209] = "Zerbrochene Urne",
	[409211] = "Zerbrochene Urne",
	[409212] = "Zerbrochene Urne",
	[409214] = "Zerbrochene Urne",
	[409222] = "Segen von Ursol",
	[409302] = "Zerstreuungskristall",
	[409320] = "Vergrabenes Objekt",
	[409329] = "Vergrabenes Objekt",
	[409333] = "Vergrabenes Objekt",
	[409338] = "Angespültes Bündel",
	[409440] = "Pinienmaushaufen",
	[409458] = "Verlorener Angelbedarf",
	[409835] = "Lockerer Erdhaufen",
	[409849] = "Eschenholzforschungsband",
	[409914] = "Mimirons Boosterteil",
	[410045] = "Alterslose Blüte",
	[410046] = "Alterslose Blüte",
	[410048] = "Alterslose Blüte",
	[410181] = "Lockerer Erdhaufen",
	[410395] = "Dokumente der Belagerungsfeste",
	[410426] = "Halbvoller Trank des traumlosen Schlafs",
	[410434] = "Spritztrank der Narkolepsie",
	[410442] = "Die Wurzel des Problems",
	[410456] = "Experimenteller Traumfänger",
	[410458] = "Schlaflositron",
	[410459] = "Hochlandleitstein",
	[410469] = "Ungeschlüpfte Batterie",
	[410475] = "Versteinerte Hoffnung",
	[410479] = "Unpolierter Makel",
	[410484] = "Verschmolzener Traumstein",
	[410529] = "Büschel Traumsäblerfell",
	[410534] = "Abgeworfene Feendrachenschuppen",
	[410550] = "Traumkrallenklaue",
	[410574] = "Reines Traumwasser",
	[410575] = "Immerflammenkern",
	[410582] = "Essenz der Träume",
	[410786] = "Alydrus' Forschungsnotizen",
	[410833] = "Die Neuschmiedung von Tyrs Wache",
	[410994] = "Karte der Sicherheitseinrichtungen von Burg Schattenfang",
	[410998] = "Formel: Berauschendes giftiges Parfüm",
	[410999] = "Memo von Apotheker Hummel",
	[411065] = "Segen von Ashamane",
	[411066] = "Segen von Aviana",
	[411067] = "Segen von Goldrinn",
	[411102] = "Luftschifftrümmer",
	[411104] = "Stark ausgebleichte Knochen",
	[411106] = "Verwitterter Stoff",
	[411168] = "Winnies Notizen zu Flora und Fauna",
	[411169] = "Säule des Hainhüters",
	[411170] = "Schattenbindungsrune der Primalisten",
	[411171] = "Enorm weicher Wildstoff",
	[411176] = "Flauschiges Kissen",
	[411177] = "Kuschelkumpel",
	[411179] = "Schild der Verteidigerin von Amirdrassil",
	[411180] = "Todespirscherchassis",
	[411181] = "Flammengebundener Reißer",
	[411447] = "Nie erwachendes Echo",
	[411463] = "Nie erwachendes Echo",
	[411465] = "Nie erwachendes Echo",
	[411466] = "Nie erwachendes Echo",
	[411560] = "Lavenblüte",
	[411561] = "Zuckerorchidee",
	[411562] = "Orangener Sternanis",
	[411571] = "Freydrins Shillelagh",
	[411622] = "Maschinistensockel",
	[411623] = "Maschinistensockel",
	[411624] = "Maschinistensockel",
	[411691] = "Glänzende neue Waffe",
	[411778] = "Pollenerfüllte Probe eines Borstenpetzpelzes",
	[411878] = "Interessanter Schrott",
	[411930] = "Schwarzpulverfass",
	[411936] = "Kugelposition",
	[412066] = "Wurfstein",
	[412950] = "Mondgesegnete Klaue",
	[412995] = "Kleine Schachtel mit Phiolen",
	[413126] = "Kasten mit Handwerkswaren",
	[413246] = "Elementarer Schlickhügel",
	[413694] = "Verdächtiger Schacht",
	[413774] = "Die Legende von Elun'Ahir",
	[413780] = "Über das Wesen des Traums",
	[413784] = "Selbstbackende Kekse auf Kräuterbasis",
	[413787] = "Die Tragödie von Erinethria",
	[414113] = "Sivsteinvorkommen",
	[414169] = "Geheimnisvolle Samen",
	[414199] = "Haufen Irdeneneigentum",
	[414700] = "Astralzucker",
	[415303] = "Magisch versiegeltes Paket",
	[415584] = "Zischender Magmakern",
	[416310] = "Truhe der Kobyss",
	[416401] = "Speer der Kobyss",
	[416448] = "Üppige Lavenblüte",
	[416450] = "Üppiger orangener Sternanis",
	[416950] = "Unsortierter Erzhaufen",
	[416954] = "Erzfragment",
	[416968] = "Stillsteinfang",
	[416969] = "Erntewein",
	[416970] = "Landwirtschaftliche Vorräte von Heilsturz",
	[416971] = "Gelbbrauner Mais",
	[416973] = "Arathiwerkzeugkasten",
	[416974] = "Aufgerollter Arathiteppich",
	[417136] = "Interessanter Schrott",
	[417137] = "Interessanter Schrott",
	[417138] = "Interessanter Schrott",
	[420019] = "Konstrukteurswerkzeuge",
	[420039] = "Konstrukteurswerkzeuge",
	[420040] = "Konstrukteurswerkzeuge",
	[420730] = "Erzader",
	[420734] = "Aschenbruch",
	[420954] = "Geschnitztes Auge",
	[421154] = "Geschnitztes Auge",
	[421179] = "Kaldoreischlafsack",
	[421180] = "Kaldoreirucksack",
	[421181] = "Kaldoreidolch",
	[421182] = "Kaldoreihorn",
	[421183] = "Kaldoreitasche",
	[421184] = "Kaldoreischild",
	[421185] = "Kaldoreispeer",
	[421186] = "Kaldoreifernrohr",
	[421338] = "Kaldoreitasche",
	[421339] = "Kaldoreihorn",
	[421360] = "Denkstättengebinde",
	[421525] = "Leuchties",
	[421555] = "Kaldoreimondbogen",
	[421592] = "Lebensersparnisse",
	[421594] = "Einträgliche Anstellung",
	[421597] = "Dorfmitte",
	[421599] = "Lokale Industrie",
	[421718] = "Pepe der Drache",
	[421735] = "Beweiskräftige Blume",
	[421736] = "Pepe der Entdecker",
	[421740] = "Pepe der Tuskarr",
	[421909] = "Gefallener Verteidiger",
	[422560] = "Maevests Kompass",
	[423596] = "Sandhaufen",
	[423602] = "Sandhaufen",
	[423603] = "Sandhaufen",
	[423612] = "Titanenartefakte",
	[423688] = "Titanengerät",
	[423714] = "Dämmerstielstängel",
	[423854] = "Seelenbrunnen",
	[423958] = "Arathikiste",
	[423971] = "Korallenverschmolzene Muschel",
	[423977] = "Truhe der Kobyss",
	[423978] = "Truhe der Kobyss",
	[423979] = "Truhe der Kobyss",
	[424253] = "Korgrans Laterne",
	[424343] = "Medizinische Vorräte",
	[424436] = "Propaganda des Ordens der Nacht",
	[425875] = "Expresstransportkiste",
	[428167] = "Weggeworfene Forschungsnotizen",
	[428199] = "Weggeworfene Forschungsnotizen",
	[428699] = "Zischendes Fass",
	[428814] = "Unverdächtige Kiste",
	[429301] = "Lieferkiste",
	[430215] = "Geschmolzenes Wachs",
	[430284] = "Strahlendes Überbleibsel",
	[430337] = "Strahlendes Überbleibsel",
	[430340] = "Strahlendes Überbleibsel",
	[430341] = "Strahlendes Überbleibsel",
	[430342] = "Strahlendes Überbleibsel",
	[430343] = "Strahlendes Überbleibsel",
	[430344] = "Strahlendes Überbleibsel",
	[430345] = "Strahlendes Überbleibsel",
	[430358] = "Strahlendes Überbleibsel",
	[430551] = "Kohlelieferung",
	[432893] = "Lieferkiste",
	[432894] = "Lieferkiste",
	[433090] = "Energieerfüllter Unterton",
	[433101] = "Tasche mit leuchtenden Splittern",
	[433102] = "Belegbündel",
	[433109] = "Nerubische Seidenseile",
	[433370] = "Kiste mit Kriegsvorräten",
	[433377] = "Erntekiste",
	[433778] = "Vergrabener Schatz",
	[433907] = "Propaganda des Ordens der Nacht",
	[434281] = "Strahlendes Überbleibsel",
	[434283] = "Strahlendes Überbleibsel",
	[434284] = "Strahlendes Überbleibsel",
	[434285] = "Strahlendes Überbleibsel",
	[434286] = "Strahlendes Überbleibsel",
	[434288] = "Strahlendes Überbleibsel",
	[434289] = "Strahlendes Überbleibsel",
	[434502] = "Anglervorratskiste",
	[434560] = "Strahlendes Überbleibsel",
	[434563] = "Strahlendes Überbleibsel",
	[434565] = "Strahlendes Überbleibsel",
	[434566] = "Strahlendes Überbleibsel",
	[434567] = "Strahlendes Überbleibsel",
	[434568] = "Strahlendes Überbleibsel",
	[434924] = "Strahlendes Überbleibsel",
	[434925] = "Strahlendes Überbleibsel",
	[434927] = "Strahlendes Überbleibsel",
	[434928] = "Strahlendes Überbleibsel",
	[434930] = "Strahlendes Überbleibsel",
	[434932] = "Strahlendes Überbleibsel",
	[436933] = "Weichschnauzes Lieblingsschaufel",
	[437060] = "Tribut des Aspiranten",
	[437205] = "Kriegskasse der Sureki",
	[437216] = "Schattenwerfer der Sureki",
	[437389] = "Vergessenes Denkmal",
	[437726] = "Leuchtender Schattenpilz",
	[437767] = "Kiste voll Heilsturzkräuter",
	[438037] = "Schwarzblutgefäß",
	[438038] = "Giftmischerfläschchen",
	[438039] = "Alchemistische Instrumente",
	[439291] = "Wiedererlangte Waren",
	[439314] = "Lagervorräte",
	[439324] = "Weggeworfene Artefakte",
	[439334] = "Schattenwerfer der Sureki",
	[439339] = "Schattenwerfer der Sureki",
	[439348] = "Mutagenvorrat",
	[439382] = "Verdächtige Lieferung",
	[439463] = "Verschütteter Feuerhonig",
	[439474] = "Waffen der Königinnenwache",
	[439531] = "Unbeaufsichtigte Armbrust",
	[439532] = "Schmiedewerkzeug der Sureki",
	[439562] = "Gefallener Luftritter",
	[440914] = "Opfergabe aus reinem Wasser",
	[440926] = "Krug voller Schleim",
	[441585] = "Brennendes Giftfläschchen",
	[441586] = "Militärkorrespondenz",
	[441587] = "Kiste mit leeren Phiolen",
	[441588] = "Konfiszierte Waffen",
	[441723] = "Hofsäckchen",
	[441797] = "Leerenvernarbter Sturmhammer",
	[444028] = "Lichtgebadeter Lotus",
	[444029] = "Lichtgebadeter Lotus",
	[444030] = "Lichtgebadeter Lotus",
	[444066] = "Schatz des Hüters",
	[444261] = "Blaubeerenexplosion kaufen - 5 Silber",
	[444275] = "Mangorowahnsinn kaufen - 5 Silber",
	[444276] = "Ultraorange kaufen - 5 Silber",
	[444277] = "Meeresausbruch kaufen - 5 Silber",
	[445275] = "Königliche Sureki-Schließkassette",
	[445360] = "Gestohlene Beute",
	[446362] = "Blutroter Bezauberer",
	[446363] = "Bernblüte",
	[446435] = "Violetter Faden",
	[446437] = "Blutroter Faden",
	[446438] = "Goldener Faden",
	[449528] = "Opalbergbauwerkzeuge",
	[451598] = "Vergessenes Denkmal",
	[451967] = "Vesperdose des Hügelpinnenhofs",
	[451990] = "Strahlendes Überbleibsel",
	[451993] = "Nerubisches Gerät",
	[452005] = "Kleines Schweinchen",
	[452438] = "Halb vergrabener Hundenapf",
	[452696] = "Reliquiar des Maschinenflüsterers",
	[452706] = "In den Tiefen verlorenes Säckchen",
	[452710] = "In den Tiefen verlorenes überquellendes Säckchen",
	[453167] = "Aufgewühlter Luchsschatz",
	[453186] = "Nachthofwuchsling",
	[453283] = "Schmugglerschatz",
	[453359] = "Dunkles Ritual",
	[453374] = "Schattige Essenz",
	[453716] = "Kiste mit teuren Trünken",
	[453741] = "Belohnung des Meisters der Lehren",
	[453749] = "Palawltars Kodex der dimensionalen Struktur",
	[453751] = "Pflege und Ernährung des Kaiserluchses",
	[453752] = "Richtlinien der Schattensperrstunde",
	[453753] = "Beledar - Vision des Kaisers",
	[453754] = "Das Lied von Renilash",
	[453755] = "Das große Buch über die Idiome der Arathi",
	[453937] = "500 Gerichte mit Höhlenfischen und Pilzen",
	[454021] = "Strahlendes Überbleibsel",
	[454023] = "Strahlendes Überbleibsel",
	[454038] = "Gestohlene Vorräte",
	[454039] = "Gestohlene Vorräte",
	[454049] = "|cff1EFF00Robuste Truhe",
	[454090] = "|cff1EFF00Robuste Truhe",
	[454091] = "|cff1EFF00Robuste Truhe",
	[454092] = "|cff1EFF00Robuste Truhe",
	[454093] = "|cff1EFF00Robuste Truhe",
	[454094] = "|cff1EFF00Robuste Truhe",
	[454176] = "Waffen der Kaheti",
	[454189] = "Opalerz",
	[454200] = "|cff1EFF00Robuste Truhe",
	[454201] = "|cff1EFF00Robuste Truhe",
	[454202] = "|cff1EFF00Robuste Truhe",
	[454207] = "|cff1EFF00Robuste Truhe",
	[454313] = "Königin Xekatha",
	[454316] = "Königin Zavra",
	[454318] = "Fingerhuts Vorräte",
	[454320] = "Königin Anub'izek",
	[454321] = "Fingerhuts Vorräte",
	[454323] = "Fingerhuts Vorräte",
	[454327] = "Fingerhuts Vorräte",
	[454328] = "Stränge der Erinnerung",
	[454330] = "Abhandlung über Gestalten: Huscher",
	[454331] = "Fingerhuts Vorräte",
	[454332] = "Abhandlung über Gestalten: Weise",
	[454334] = "Fingerhuts Vorräte",
	[454335] = "Entomologische Abhandlung über Maden, Band 1",
	[454336] = "Entomologische Abhandlung über Maden, Band 2",
	[454337] = "Fingerhuts Vorräte",
	[454338] = "Entomologische Abhandlung über Maden, Band 3",
	[454339] = "Fingerhuts Vorräte",
	[454340] = "Fingerhuts Vorräte",
	[454342] = "Fingerhuts Vorräte",
	[454343] = "Ethos des Krieges, Teil 1",
	[454344] = "Ethos des Krieges, Teil 2",
	[454346] = "Fingerhuts Vorräte",
	[454348] = "Ethos des Krieges, Teil 3",
	[454350] = "Ethos des Krieges, Teil 4",
	[454404] = "Hathlaz' Plakette",
	[454405] = "Attwogaz' Plakette",
	[454406] = "Krattdaz' Plakette",
	[454407] = "Uisgaz' Plakette",
	[454408] = "Venedaz' Plakette",
	[454412] = "Merunths Plakette",
	[454414] = "Varerkos Plakette",
	[454416] = "Alfrithas Plakette",
	[454417] = "Gundrigs Plakette",
	[454418] = "Sathilgas Plakette",
	[454463] = "Gesucht: der Gemeindebrecher",
	[454541] = "Strahlendes Überbleibsel",
	[454542] = "Strahlendes Überbleibsel",
	[454543] = "Strahlendes Überbleibsel",
	[454797] = "Sie kommen aus den Tiefen",
	[455038] = "\"Schachzug des Lichts\"-Strategien",
	[455170] = "Zerbröselndes Eisenholzpergament",
	[455183] = "Journal der Schattensperrstunde",
	[455269] = "Notizen zu den Maschinenflüsterern: Fragment I",
	[455274] = "Notizen zu den Maschinenflüsterern: Fragment II",
	[455275] = "Notizen zu den Maschinenflüsterern: Fragment III",
	[455276] = "Notizen zu den Maschinenflüsterern: Fragment IV",
	[455277] = "Notizen zu den Maschinenflüsterern: Fragment V",
	[455278] = "Notizen zu den Maschinenflüsterern: Fragment VI",
	[455279] = "Anerkennung des Wesirs",
	[455288] = "Fleischiger Foliant",
	[455310] = "Lauscht historischen Geschichten bei der Geschichtenbühne!",
	[455320] = "Anerkennung des Wesirs",
	[455321] = "Anerkennung des Wesirs",
	[455322] = "Anerkennung des Wesirs",
	[455323] = "Anerkennung des Wesirs",
	[455324] = "Anerkennung des Wesirs",
	[455325] = "Anerkennung des Wesirs",
	[455327] = "Anerkennung des Wesirs",
	[455328] = "Anerkennung des Wesirs",
	[455329] = "Anerkennung des Wesirs",
	[455330] = "Anerkennung des Wesirs",
	[455331] = "Anerkennung des Wesirs",
	[455435] = "Tribut des Aspiranten",
	[455436] = "Tribut des Aspiranten",
	[455437] = "Tribut des Aspiranten",
	[455439] = "Tribut des Aspiranten",
	[455440] = "Tribut des Aspiranten",
	[455441] = "Tribut des Aspiranten",
	[455442] = "Tribut des Aspiranten",
	[455443] = "Tribut des Aspiranten",
	[455444] = "Tribut des Aspiranten",
	[455445] = "Tribut des Aspiranten",
	[455446] = "Tribut des Aspiranten",
	[455482] = "|cff1EFF00Robuste Truhe",
	[455484] = "|cff1EFF00Robuste Truhe",
	[455485] = "|cff1EFF00Robuste Truhe",
	[455486] = "|cff1EFF00Robuste Truhe",
	[455487] = "|cff1EFF00Robuste Truhe",
	[455488] = "|cff1EFF00Robuste Truhe",
	[455489] = "|cff1EFF00Robuste Truhe",
	[455490] = "|cff1EFF00Robuste Truhe",
	[455491] = "|cff1EFF00Robuste Truhe",
	[455492] = "|cff1EFF00Robuste Truhe",
	[455493] = "|cff1EFF00Robuste Truhe",
	[455494] = "|cff1EFF00Robuste Truhe",
	[455495] = "|cff1EFF00Robuste Truhe",
	[455496] = "|cff1EFF00Robuste Truhe",
	[455497] = "|cff1EFF00Robuste Truhe",
	[455503] = "|cff1EFF00Robuste Truhe",
	[455504] = "|cff1EFF00Robuste Truhe",
	[455505] = "|cff1EFF00Robuste Truhe",
	[455506] = "|cff1EFF00Robuste Truhe",
	[455507] = "|cff1EFF00Robuste Truhe",
	[455508] = "|cff1EFF00Robuste Truhe",
	[455509] = "|cff1EFF00Robuste Truhe",
	[455510] = "|cff1EFF00Robuste Truhe",
	[455511] = "|cff1EFF00Robuste Truhe",
	[455512] = "|cff1EFF00Robuste Truhe",
	[455513] = "|cff1EFF00Robuste Truhe",
	[455514] = "|cff1EFF00Robuste Truhe",
	[455515] = "|cff1EFF00Robuste Truhe",
	[455516] = "|cff1EFF00Robuste Truhe",
	[455517] = "|cff1EFF00Robuste Truhe",
	[455522] = "|cff1EFF00Robuste Truhe",
	[455523] = "|cff1EFF00Robuste Truhe",
	[455524] = "|cff1EFF00Robuste Truhe",
	[455525] = "|cff1EFF00Robuste Truhe",
	[455526] = "|cff1EFF00Robuste Truhe",
	[455527] = "|cff1EFF00Robuste Truhe",
	[455531] = "|cff1EFF00Robuste Truhe",
	[455532] = "|cff1EFF00Robuste Truhe",
	[455533] = "|cff1EFF00Robuste Truhe",
	[455534] = "|cff1EFF00Robuste Truhe",
	[455685] = "RUF DES TIEFENFORSCHERS: Terrorschacht",
	[455759] = "Riesige Raptorenklaue",
	[455768] = "Triefende Feierkiste",
	[455938] = "Nadelkissen der Neruber",
	[455939] = "Nerubische Steppdecke",
	[455940] = "Winkelmesser des königlichen Ausstatters",
	[455941] = "Rollschneider der Arathi",
	[455942] = "Schere des irdenen Nähers",
	[455943] = "Runenverzierte irdene Nadeln",
	[455944] = "Maßband der Irdenen",
	[455945] = "Trennmesser aus Dornogal",
	[455974] = "Feiner Bohrer des Juweliers",
	[455975] = "Gemeißelte Steinakte",
	[455976] = "Edelsteinzange der Irdenen",
	[455977] = "Behutsamer Juwelenhammer",
	[455980] = "Gemeißelte Markierung des Kalligraphen",
	[455981] = "Füllhalter des Informanten",
	[455985] = "Federkiel des Schreibers aus Dornogal",
	[456009] = "Geschliffener Edelstein der Irdenen",
	[456010] = "Drahtbürste des Spinnlings",
	[456011] = "Nerubische Schmiedeausrüstung",
	[456012] = "Strahlende Zange",
	[456014] = "Meißel der Irdenen",
	[456015] = "Klemme des schallenden Hammers",
	[456016] = "Hammer aus Dornogal",
	[456017] = "Uralter Amboss der Irdenen",
	[456022] = "Gravierter Rührstab",
	[456024] = "Metallrahmen aus Dornogal",
	[456032] = "Zerknittertes Papier",
	[456036] = "Loses Papier",
	[456038] = "Nasses Papier",
	[456039] = "Zusammengeknüllter Brief",
	[456041] = "Gefaltetes Papier",
	[456061] = "Ramponierte Feierkiste",
	[456581] = "Eigelege",
	[456583] = "Verlorener Schuh",
	[456767] = "Rotes Haar",
	[456820] = "Merkwürdige Fackel",
	[457025] = "Vorkalibriertes Goblintransportschiff",
	[457062] = "Himmelskapitänin Lancekats Fluch",
	[457156] = "Zerrissene Notiz",
	[457160] = "Zerrissene Notiz",
	[457161] = "Zerrissene Notiz",
	[457197] = "Montiertes Fernglas",
	[457246] = "Feldarbeitervorrat",
	[457251] = "Alte verrottende Kiste",
	[457270] = "Feldmesserkiste",
	[457303] = "Strahlendes Überbleibsel",
	[459333] = "Juwelenbesetztes Auge",
	[459368] = "Halb vergrabene Truhe",
	[462417] = "Durchnässte Feierkiste",
	[463104] = "Nolas letzter Wunsch",
	[463653] = "Dreckverkrustete Feierkiste",
	[465161] = "Wasserfester Verkaufsbeleg",
	[465234] = "Fehlende Seite aus Yennus Knabberkodex",
	[465277] = "Erdhaufen",
	[466438] = "Verkohlte Feierkiste",
	[466512] = "Kristallisierte Feierkiste",
	[467060] = "Wollknäuel",
	[467064] = "Questtagebuch",
	[467075] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[467083] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[467191] = "Verschlüsselte Truhe",
	[467293] = "Kauspielzeug",
	[467305] = "Spielzeugkiste",
	[467329] = "Marus Spielzeug",
	[467334] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[467336] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[467338] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[467339] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[467342] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[467351] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[467403] = "Fortunakarte des Dunkelmond-Jahrmarkts",
	[469568] = "Verbrannte Feder",
	[469569] = "Ausgezupfte Feder",
	[469573] = "Gefrorene Feder",
	[469574] = "Normale Feder",
	[469985] = "Eisblock",
	[470229] = "Kuscheltier",
	[472068] = "Zeichnung eines Bakars",
	[473934] = "Eigentum von Smutholomäus",
	[477139] = "Fundbüro",
	[478090] = "Verschimmelte Feierkiste",
	[485669] = "RUF DES TIEFENFORSCHERS: Fungusphantasterei",
	[487805] = "RUF DES TIEFENFORSCHERS: Erdwühlerminen",
	[487851] = "RUF DES TIEFENFORSCHERS: Spiralgewebe",
	[499466] = "Zerlumptes Tagebuch aus Kul Tiras",
	[499551] = "Schwarzstahlkanonenkugeln",
	[505260] = "Trank der Wahrheit",
	[505505] = "Eisenspitzhacke",
	[9999908] = "|cFFFFFFFFSchritt 1:|r Gather Consumables.",
	[9999909] = "|cFFFFFFFFSchritt 2:|r Caverns of Consumption",
	[9999910] = "|cFFFFFFFFSchritt 3:|r Fire Barrier",
	[9999911] = "|cFFFFFFFFSchritt 4:|r Prismatic Barrier",
	[9999912] = "|cFFFFFFFFSchritt 5:|r Gewissenhafte Beobachterin",
	[9999913] = "|cFFFFFFFFSchritt 6:|r Vine Barrier",
	[9999914] = "|cFFFFFFFFSchritt 7:|r Water Barrier",
	[9999915] = "|cFFFFFFFFSchritt 8:|r Steinbehüter",
	[9999916] = "|cFFFFFFFFSchritt 9:|r Ethereal Barrier",
	[9999917] = "|cFFFFFFFFSchritt 10:|r Merkwürdiger Stein",
	[9999918] = "|cFFFFFFFFSchritt 11:|r Metal Gate",
	[9999919] = "|cFFFFFFFFSchritt 12:|r Würfel der Weisheit",
	[9999920] = "|cFFFFFFFFSchritt 13:|r Stumpfe Tafel",
	[13000000] = "|cFFFFFFFFSchritt 1:|r Purchase Talisman der wahren Schatzjagd",
	[13000001] = "|cFFFFFFFFSchritt 2:|r Equip Talisman",
	[13000002] = "|cFFFFFFFF"..AUCTION_HOUSE_HEADER_ITEM.." 1:|r Schillernde Murlochautcreme",
	[13000003] = "Glitzerkiemenglitter",
	[13000004] = "|cFFFFFFFFSchritt 1:|r Muschel",
	[13000005] = "|cFFFFFFFFSchritt 2:|r Gesunder Großhaizahn",
	[13000006] = "|cFFFFFFFFSchritt 3:|r Rasieraallarve",
	[13000007] = "|cFFFFFFFFSchritt 4:|r Wohlgenährter Knabberfisch",
	[13000008] = "|cFFFFFFFFSchritt 5:|r Frisch abgestreifter Krabbenpanzer",
	[13000009] = "|cFFFFFFFFSchritt 6:|r Glitzerkiemenglitter",
	[13000010] = "Symbiotisches Plankton",
	[13000011] = "|cFFFFFFFFSchritt 1:|r Muschel",
	[13000012] = "|cFFFFFFFFSchritt 2:|r Riesiger abgeschnittener Riesenzehnagel",
	[13000013] = "|cFFFFFFFFSchritt 3:|r Makruraauge",
	[13000014] = "|cFFFFFFFFSchritt 4:|r Versehentlich abgetrennte Seepferdflosse",
	[13000015] = "|cFFFFFFFFSchritt 5:|r Glänzende Seeschlangenschuppe",
	[13000016] = "|cFFFFFFFFSchritt 6:|r Symbiotisches Plankton",
	[13000017] = "Schillernde Murlochautcreme",
	[13000018] = "|cFFFFFFFF"..AUCTION_HOUSE_HEADER_ITEM.." 2:|r Potenter Schneckenschleim",
	[13000019] = "|cFFFFFFFFSchritt 1:|r Muschel",
	[13000020] = "|cFFFFFFFFSchritt 2:|r Schwarze Vantuskalmartinte",
	[13000021] = "|cFFFFFFFFSchritt 3:|r Extrem glitschiger Aalschleim",
	[13000022] = "|cFFFFFFFFSchritt 4:|r Verkrustetes Schneckenhaus",
	[13000023] = "|cFFFFFFFFSchritt 5:|r Potenter Schneckenschleim",
	[13000024] = "|cFFFFFFFF"..AUCTION_HOUSE_HEADER_ITEM.." 3:|r Eingefangene Kavitationsblase",
	[13000025] = "|cFFFFFFFFSchritt 1:|r Muschel",
	[13000026] = "|cFFFFFFFFSchritt 2:|r Sehr hübsche Koralle",
	[13000027] = "|cFFFFFFFFSchritt 3:|r Irisierende Schillerrochenhaut",
	[13000028] = "|cFFFFFFFFSchritt 4:|r Üppige Luxschuppenschuppe",
	[13000029] = "|cFFFFFFFFSchritt 5:|r Eingefangene Kavitationsblase",
	[13000030] = "Purchase Rotes Kristallmonokel",
	[13000031] = "Rotes Kristallmonokel",
	[13000032] = "|cFFFFFFFFSchritt 3:|r Pick a Monocle (Or Don't!)",
	[13000033] = "|cFFFFFFFFSchritt 4:|r Suramar Beams",
	[13000034] = "|cFFFFFFFFSchritt 5:|r Cat Code",
	[13000035] = "|cFFFFFFFFSchritt 6:|r Jumping Puzzle",
	[13000036] = "|cFFFFFFFFSchritt 7:|r Arcane Lava",
	[13000037] = "|cFFFFFFFFSchritt 8:|r Das Schwarmbewusstsein",
});
for i,objectID in ipairs(ALLIANCE_BONFIRES) do ObjectNames[objectID] = "Freudenfeuer der Allianz"; end
for i,objectID in ipairs(CANDY_BUCKETS) do ObjectNames[objectID] = "Eimer mit Süßigkeiten"; end
for i,objectID in ipairs(HORDE_BONFIRES) do ObjectNames[objectID] = "Freudenfeuer der Horde"; end
end
if simplifiedLocale == "fr" then
localize(L.HEADER_NAMES, {
	[-1000000] = "Est",
	[-1000001] = "Nord",
	[-1000002] = "Sud",
	[-1000003] = "Ouest",
	[-1000006] = "Rouleau Bonus",
	[-1000008] = "Essai de Classe",
	[-1000012] = "Objet commun de donjon",
	[-1000013] = "Objets communs des vendeurs",
	[-1000045] = "Récompenses de la zone",
	[-1000048] = "Dragons du Cauchemar",
	[-1000055] = "Événement chronométré",
	[-1000056] = "Premier coffre",
	[-1000057] = "Second coffre",
	[-1000058] = "Troisième coffre",
	[-1000059] = "Coffre final",
	[-1000087] = "Assauts de congrégation",
	[-1000089] = "Améliorations du sanctum",
	[-1000090] = "Forme d'âme",
	[-1000092] = "Garnisons",
	[-1000126] = "Connaissance hebdomadaire de profession",
	[-1000127] = select(2,GetAchievementInfo(2091))..": Saison 1",
	[-1000128] = select(2,GetAchievementInfo(418))..": Saison 2",
	[-1000129] = select(2,GetAchievementInfo(419))..": Saison 3",
	[-1000130] = select(2,GetAchievementInfo(420))..": Saison 4",
	[-1000131] = select(2,GetAchievementInfo(3336))..": Saison 5",
	[-1000132] = "Gladiateur Haineux",
	[-1000133] = select(2,GetAchievementInfo(3436))..": Saison 6",
	[-1000134] = select(2,GetAchievementInfo(3758))..": Saison 7",
	[-1000135] = select(2,GetAchievementInfo(4599))..": Saison 8",
	[-1000138] = "Équipement Aspirant",
	[-1000139] = "Équipement Combattant",
	[-1000140] = "Équipement Élite",
	[-1000141] = "Équipement Gladiateur",
	[-1000145] = "Tous les Rôles",
	[-1000146] = "Dégâts",
	[-1000147] = "Soigneurs",
	[-1000162] = "Apparences Partagées",
	[-1000163] = "Apparence unique",
	[-1000165] = "Ensembles Tier 0.5",
	[-1000166] = "Capitaines",
	[-1000168] = "Les quatre cavaliers",
	[-1000173] = DUNGEON_FLOOR_DIREMAUL5.." (Est)",
	[-1000174] = DUNGEON_FLOOR_DIREMAUL1.." (Nord)",
	[-1000175] = DUNGEON_FLOOR_DIREMAUL2.." (Ouest)",
	[-1000179] = "Cimetière",
	[-1000180] = "Librairie",
	[-1000181] = "Armurerie",
	[-1000182] = "Cathédrale",
	[-1000185] = "Défenseurs Atal'ai",
	[-1000186] = "La prise de la citadelle",
	[-1000187] = "La Pesterie",
	[-1000190] = "L'antre de la Folie",
	[-1000201] = "Foire de Sombrelune",
	[-1000203] = "Foire de Sombrelune Jeu de Danse",
	[-1000204] = "Défi de l’Oiseau de feu",
	[-1000205] = "Stand de tir",
	[-1000206] = "Cogne-Gnoll",
	[-1000207] = "Jour des morts",
	[-1000219] = "Le tournoi de pêche kalu'ak",
	[-1000223] = "Fête du Feu du solstice d’été",
	[-1000226] = "Jour des pirates",
	[-1000227] = "Concours de pêche de Strangleronce",
	[-1000234] = "Effort de guerre d’Ahn'Qiraj",
	[-1000235] = "L'ouverture de la Porte des ténèbres",
	[-1000236] = "Le Sceptre des Sables changeants",
	[-1000244] = "Edition Collector",
	[-1000247] = "Édition BC Classic Deluxe",
	[-1000261] = "Hearthstone Mercenaires",
	[-1000301] = "Recherche de Raid (5.4)",
	[-1000304] = "Héroïque (5.4)",
	[-1000305] = "La casse",
	[-1000309] = "Prise D'assaut de la Porte des Ténèbres",
	[-1000312] = "marges des Éons",
	[-1000316] = "Rouleau d'événement",
	[-1000317] = "Le grand Odyn et le seigneur du feu",
	[-1000323] = "Il s’appelait Sang de dragon",
	[-1000324] = "Les dernières paroles d’Asgrim le Tueur de l’effroi",
	[-1000325] = "Le credo de la vierge guerrière",
	[-1000326] = "La prophétie de Rythas l’Oracle",
	[-1000327] = "Les leçons du poing noir",
	[-1000328] = "La folie de Volund",
	[-1000329] = "Rouleau d'événement",
	[-1000336] = "Rang 1",
	[-1000337] = "Rang 2",
	[-1000338] = "Rang 3",
	[-1000339] = "Rang 4",
	[-1000340] = "Miroir brisé",
	[-1000341] = "Miroir brisé",
	[-1000342] = "Miroir brisé",
	[-1000343] = "Miroir brisé",
	[-1000344] = "Miroir brisé",
	[-1000345] = "Miroir brisé",
	[-1000346] = "Miroir brisé",
	[-1000347] = "Miroir brisé",
	[-1000348] = "Miroir brisé",
	[-1000349] = "Miroir brisé",
	[-1000350] = "Miroir brisé",
	[-1000351] = "Miroir brisé",
	[-1000352] = "Clan des Aylaags",
	[-1000353] = "Grandes Chasses",
	[-1000362] = "Tour du monde d’Uuna",
	[-1000365] = "20e anniversaire de Diablo",
	[-1000366] = "Émissaire cupide",
	[-1000373] = "Nouveau personnage",
	[-1000374] = "Races alliées",
	[-1000375] = "10e anniversaire de Hearthstone",
	[-1000379] = "Prime",
	[-1000380] = "Prime",
	[-1000381] = "Cache de Koukourou",
	[-1000853] = "Conseil de guerre sargereï",
	[-1000855] = "Escadron de la Mort Abandonné",
	[-1000856] = "Traqueurs Worgens",
	[-1000858] = "Chasseurs Amateurs",
	[-1000860] = select(2,GetAchievementInfo(6002))..": Saison 9",
	[-1000861] = select(2,GetAchievementInfo(6124))..": Saison 10",
	[-1000862] = "Gladiateur cataclysmique: Saison 11",
	[-1000865] = "Champ de bataille : les Tarides",
	[-1000869] = "L’invasion de Fer",
	[-1000870] = "L’incursion trolle",
	[-1000883] = "Mascotte des combat des donjons",
	[-1000900] = "Zone Perdue",
	[-1000901] = "Zone Corrompue",
	[-1000919] = "Armure ancestrale",
	[-1000923] = "Manuscrit guette-drake",
	[-1000924] = "Les Tempêtes Primordiales",
	[-1000936] = "Rotation Rare de DF",
	[-1000937] = "Caveaux de Zskera",
	[-1000938] = "Recherches olfactives",
	[-1000944] = "Marchandage",
	[-1000945] = "Assauts de Fyrakk",
	[-1001034] = "Liens élémentaires",
	[-1001035] = "Poisson de saison : bar d'été",
	[-1001036] = "Poisson de saison : calmar d'hiver",
	[-1001045] = "Relations clientèle",
	[-1001059] = "Tempêtes de feu",
	[-1001060] = "Tempêtes de sable",
	[-1001061] = "Tempêtes de neige",
	[-1001062] = "Coups de tonnerre",
	[-1001075] = "Pré-Lancement de l’Extension",
	[-1001087] = "Avant-postes",
	[-1001095] = "|cffFF0000Ogom le Mangler semble apparaître lorsque vous effectuez l'« Assaut quotidien sur les usines de siège de fer ». Cette quête n'était plus active depuis le début de Legion et la quête achetable « Missive : Assaut sur les usines de siège de fer » ne fonctionne pas non plus.|r",
	[-1001096] = "|cFFFFFFFFÉtape 1:|r Note mise en évidence",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000018] = "Ces objets peuvent être obtenus en effectuant des quêtes d’émissaire ou en l’obtaenant via un coffre de parangon.",
	[-1000033] = "Contient des objets de récompenses ou disponibles dans d’autres contenus de la section qui les contient.\nIls sont regroupés ici dans le but de réduire la duplication de nombreuses sources possibles.",
	[-1000035] = "Vilains secrets...",
	[-1000043] = "Les quêtes mondiales sont des quêtes limitées dans le temps, disponibles dans des lieux spécifiques avec des récompenses variables.\n\nN’oublie pas de consulter souvent la fenêtre des quêtes mondiales ATT (/attwq) pour voir quelles sont les objets limités dans le temps que tu dois collecter !",
	[-1000045] = "Ces objets peuvent provenir de coffres au trésor répétitifs, Criquet à souhait, de quêtes mondiales ou des missions de la table de commandement.",
	[-1000162] = "Les éléments de cette liste sont des apparences partagées pour l'élément ci-dessus. En mode Apparence unique, cette liste peut vous aider à comprendre pourquoi ou pourquoi un élément spécifique serait marqué Collecté.",
	[-1000163] = "Cet article a une apparence unique. Vous devez collecter cet objet spécifiquement pour gagner l’apparence.",
	[-1000380] = "Cette liste contient des éléments impossibles à obtenir que ATT Discord a signalés comme des bogues que Blizzard n'a pas encore corrigés.\n\nREMARQUE : Tous les filtres sont ignorés dans cette liste pour des raisons de visibilité. Seuls les éléments retirés du jeu en raison d'une négligence plutôt que d'un gigantesque dragon cracheur de feu sont présents sur cette liste.\n\nAux développeurs de Blizzard : veuillez corriger les éléments et les rencontres répertoriés ci-dessous.",
	[-1000850] = "Contient des objets de récompenses ou disponibles dans d’autres contenus de la section qui les contient.\nIls sont regroupés ici dans le but de réduire la duplication de nombreuses sources possibles.",
	[-1000851] = "Contient des objets de récompenses ou disponibles dans d’autres contenus de la section qui les contient.\nIls sont regroupés ici dans le but de réduire la duplication de nombreuses sources possibles.",
	[-1000853] = "Patrouille dans la zone en formant à peu près un cercle.",
	[-1000855] = "Il y a une bataille en 4x4 en cours. Aidez l'Alliance en battant l'escadron de la mort abandonné.",
	[-1000856] = "Il y a une bataille en 4x4 en cours. Aidez la Horde en battant les Worgen Stalkers.",
	[-1000858] = "Trois chasseurs ont encerclé Mara Swiftmane. Engagez-les au combat et un coffre battu apparaîtra près de Mara Swiftmane. Une fois la bataille terminée, Mara vous remerciera et vous laissera avec le coffre battu.",
	[-1001041] = "Contient des objets de récompenses ou disponibles dans d’autres contenus de la section qui les contient.\nIls sont regroupés ici dans le but de réduire la duplication de nombreuses sources possibles.",
});
localize(L.HEADER_LORE, {
	[-1000308] = "Les objets suivants peuvent être créés en utilisant un Fardeau de l'éternité sur un jeton de Cache d'armure du Temps figé pour une double dose de RNG inutile.",
});
localize(L.FILTER_ID_TYPES, {
	[11] = "Artéfact",
});
localize(ObjectNames, {
	[31] = "Statue du vieux lion",
	[33] = "Coffre verrouillé",
	[34] = "Vieille cruche",
	[35] = "Coffre du capitaine",
	[36] = "Tonneau cassé",
	[47] = "Avis de recherche !",
	[55] = "Un corps à moitié dévoré",
	[56] = "Cadavre de Rolf",
	[59] = "Monticule de poussière",
	[60] = "Avis de recherche : Gath'Ilzogg",
	[61] = "Un tombeau dégradé par les intempéries",
	[76] = "Une jarre vide",
	[256] = "Avis de recherche !",
	[257] = "Tonneau suspect",
	[259] = "Tonneau à moitié enseveli",
	[261] = "Caisse endommagée",
	[269] = "Tonneau de Tonneblonde gardé",
	[270] = "Tonneau de Tonneblonde non gardé",
	[287] = "Archives d'Hérode la Paperasse",
	[288] = "Coffre-fort d'Hérode la Paperasse",
	[711] = "Avis de recherche !",
	[1557] = "Table de dîner de Lillith",
	[1561] = "Caisse scellée",
	[1585] = "Charge explosive",
	[1586] = "Caisse de bougies",
	[1593] = "Bateau chargé de cadavres",
	[1599] = "Tombe peu profonde",
	[1609] = "Catapulte des Gueules-de-dragon",
	[1610] = "Filon d'incendicite",
	[1627] = "Caisse de Dalaran",
	[1728] = "Carpette poussiéreuse",
	[1738] = "Documents du Syndicat",
	[1739] = "Documents du Syndicat",
	[1740] = "Documents du Syndicat",
	[1763] = "AVIS DE RECHERCHE",
	[1765] = "Coffre en bois usé",
	[2008] = "Dangereux !",
	[2059] = "Un cadavre de Nain",
	[2076] = "Chaudron bouillonnant",
	[2083] = "Correspondance de la Voile sanglante",
	[2289] = "Canot de sauvetage abîmé",
	[2553] = "Un parchemin trempé",
	[2554] = "Devinette de Cortello",
	[2555] = "Parchemin moisi",
	[2560] = "Bouteille à moitié ensevelie",
	[2652] = "Cadavre d'Ebenezer Bouclerouille",
	[2656] = "Lettre détrempée",
	[2688] = "Clé cruciale",
	[2701] = "Fragments iridescents",
	[2702] = "Pierre de Lien intérieure",
	[2713] = "Tableau des recherches",
	[2734] = "Coffre détrempé",
	[2744] = "Palourde géante",
	[2868] = "Carte chiffonnée",
	[2875] = "Squelette de Nain décrépi",
	[2908] = "Caisse de ravitaillements scellée",
	[2933] = "Sceau de la Terre",
	[3076] = "Carte couverte de poussière",
	[3238] = "Tonneau vide de Chen",
	[3239] = "Coffre de Benedict",
	[3643] = "Vieille cantine",
	[3972] = "AVIS DE RECHERCHE",
	[4141] = "Console de contrôle",
	[5620] = "Pierres de puissance imparfaites",
	[6751] = "Plante aux fruits étranges",
	[6752] = "Plantes aux feuilles étranges",
	[7510] = "Racine éclose",
	[10076] = "Coupe de divination",
	[12666] = "Tome du Crépuscule",
	[15084] = "Le Brille-o-Matic 5200",
	[15085] = "Le Brille-o-Matic 5200",
	[17182] = "Bigobox 827",
	[17183] = "Bigobox 411",
	[17184] = "Bigobox 323",
	[19023] = "|cFFFFFFFFÉtape 7:|r Page 2351",
	[19024] = "Autel caché",
	[19595] = "Banque du portier",
	[19599] = "Provision du corbeau",
	[19861] = "Journal d'Henrig Lonebrow",
	[20805] = "Plans de Séhouf",
	[20985] = "Poussière flottante",
	[20992] = "Bouclier noir",
	[21015] = "Traces de sabot",
	[21016] = "Traces de sabot",
	[21042] = "Ecusson de la garde de Theramore",
	[21581] = "Au lendemain de la Deuxième guerre",
	[21582] = "Au-delà de la Porte des ténèbres",
	[21583] = "Les Kaldorei et le Puits d'Eternité",
	[28604] = "Caisse éparpillée",
	[32569] = "Coffre de Galen",
	[35251] = "Coffre de Karnitol",
	[50961] = "Coffre de Malem",
	[51708] = "Boue du tombeau d'Eliza",
	[61934] = "Brasero de la Flamme Dormante",
	[103821] = "Coffre de Doan",
	[112888] = "Étagère poussiéreuse",
	[112948] = "Coffre verrouillé de l'Intrépide",
	[113757] = "Cachette d'Ombreforge",
	[113791] = "Brasero de la Fontaine éternelle",
	[123329] = "Coffre de Baelog",
	[125477] = "Urne ostentatoire",
	[131474] = "Les disques de Norgannon",
	[138492] = "Fragments de Myzrael",
	[141931] = "Œuf d'hippogriffe",
	[141979] = "Trésor ancien",
	[141980] = "Coffret spectral",
	[142071] = "Œuf-O-Matic",
	[142088] = "Tablette de volonté",
	[142122] = "Avis de recherche",
	[142127] = "Secret de Rin'ji",
	[142151] = "Tonneau scellé",
	[142179] = "Belvédère de Solarsal",
	[142184] = "Coffre du capitaine",
	[142189] = "Monument dissimulé",
	[142195] = "Plan de bataille des Griffebois",
	[142343] = "Piédestal d'Uldum",
	[142345] = "Matrice d'encodage 3005-A",
	[142475] = "Matrice d'encodage 3005-B",
	[142476] = "Matrice d'encodage 3005-C",
	[142487] = "Le Brille-o-Matic 5200",
	[142696] = "Matrice d'encodage 3005-D",
	[142702] = "Bouteille de venin",
	[142958] = "Féralas : une histoire",
	[143980] = "Parchemin gordunni",
	[144063] = "Monolithe d'Equinex",
	[144064] = "Monticule de poussière de Gordunni",
	[148498] = "Autel de Suntara",
	[148502] = "|cFFFFFFFFÉtape 1:|r Page 9",
	[148504] = "Une tombe ostentatoire",
	[148512] = "Réceptacle d'essence",
	[148832] = "Statue atal'ai",
	[148836] = "Autel d'Hakkar",
	[148838] = "Idole d'Hakkar",
	[149047] = "Torche de vindicte",
	[149502] = "Trésor du Vol noir",
	[150075] = "Avis de recherche",
	[151286] = "Tome d'invocation kaldorei",
	[152097] = "Brasero de Belnistrasz",
	[157936] = "Tas de poussière d'Un'Goro",
	[160836] = "Coffret à relique",
	[160845] = "Coffre sombre",
	[161495] = "Coffre secret",
	[161504] = "Un petit paquet",
	[161505] = "Une épave de radeau",
	[161521] = "Equipement de recherche",
	[161526] = "Caisse de nourriture",
	[164659] = "Cristal de puissance vert",
	[164661] = "Cristal de puissance jaune",
	[164689] = "Monument de Franclorn Le Forgebusier",
	[164778] = "Cristal de puissance bleu",
	[164780] = "Cristal de puissance rouge",
	[164798] = "Evoracine",
	[164820] = "Nom du Gardien noir",
	[164867] = "AVIS DE RECHERCHE",
	[164868] = "TUER À VUE",
	[164869] = "Calice spectral",
	[164885] = "Dragon nocturne corrompu",
	[164886] = "Fleur-de-chant corrompue",
	[164887] = "Fleur-de-vent corrompue",
	[164888] = "Navetille corrompue",
	[164909] = "Épave de barque",
	[164911] = "Tonneau de Tonnebière",
	[164953] = "Grands sacs à dos en cuir",
	[164954] = "Alvéole de Zukk'ash",
	[164955] = "Pylône de cristal nord",
	[164956] = "Pylône de cristal ouest",
	[164957] = "Pylône de cristal est",
	[164958] = "Pousse de Pétale-de-sang",
	[165554] = "Cœur de la montagne",
	[169243] = "Coffre des sept",
	[171939] = "Fleur-de-chant corrompue",
	[171942] = "Fleur-de-chant corrompue",
	[173232] = "Plans de forgeron",
	[173265] = "Toilettes en bois",
	[173284] = "Navetille corrompue",
	[173324] = "Dragon nocturne corrompu",
	[173327] = "Fleur-de-vent corrompue",
	[174594] = "Fleur-de-chant corrompue",
	[174595] = "Fleur-de-chant corrompue",
	[174596] = "Fleur-de-chant corrompue",
	[174597] = "Fleur-de-chant corrompue",
	[174598] = "Fleur-de-chant corrompue",
	[174599] = "Fleur-de-vent corrompue",
	[174600] = "Fleur-de-vent corrompue",
	[174601] = "Fleur-de-vent corrompue",
	[174602] = "Fleur-de-vent corrompue",
	[174603] = "Fleur-de-vent corrompue",
	[174604] = "Fleur-de-vent corrompue",
	[174605] = "Navetille corrompue",
	[174606] = "Navetille corrompue",
	[174607] = "Navetille corrompue",
	[174608] = "Dragon nocturne corrompu",
	[174682] = "Attention aux pterreurdactyles",
	[174684] = "Dragon nocturne corrompu",
	[174686] = "Navetille corrompue",
	[174708] = "Fleur-de-vent corrompue",
	[174709] = "Fleur-de-vent corrompue",
	[174712] = "Fleur-de-chant corrompue",
	[174713] = "Fleur-de-chant corrompue",
	[174848] = "Equipement de test",
	[175226] = "Créature marine échouée",
	[175227] = "Créature marine échouée",
	[175230] = "Créature marine échouée",
	[175233] = "Créature marine échouée",
	[175245] = "Flamme du père",
	[175320] = "AVIS DE RECHERCHE : Fondeboue !",
	[175369] = "Entrée de service de la place des Anciens",
	[175382] = "Coffret de Frèteruine",
	[175385] = "Tablette de Sombrepierre",
	[175524] = "Mystérieux cristal rouge",
	[175586] = "Chariot de Jaron",
	[175587] = "Caisse endommagée",
	[175621] = "Autel des offrandes d'Urok",
	[175704] = "Lettre roussie",
	[175724] = "Sargeras et la trahison",
	[175725] = "Les Dieux très anciens et l'ordonnancement d'Azeroth",
	[175726] = "Le fardeau des Vols draconiques",
	[175727] = "La guerre des Anciens",
	[175729] = "Le mont Hyjal et le cadeau d'Illidan",
	[175730] = "L'Arbre-Monde et le Rêve d'émeraude",
	[175731] = "L'exil des Haut-Elfes",
	[175732] = "Les Sentinelles et la longue veille",
	[175733] = "La fondation de Quel'Thalas",
	[175734] = "Arathor et les Guerres trolles",
	[175735] = "Les Gardiens de Tirisfal",
	[175736] = "Forgefer - l'Eveil des Nains",
	[175737] = "Les sept royaumes",
	[175738] = "Aegwynn et la chasse au dragon",
	[175739] = "La guerre des Trois marteaux",
	[175740] = "Le dernier gardien",
	[175741] = "Kil'jaeden et le Pacte des ombres",
	[175742] = "La montée de la Horde",
	[175745] = "La Porte des ténèbres et la chute de Hurlevent",
	[175746] = "L'Alliance de Lordaeron",
	[175747] = "L'invasion de Draenor",
	[175748] = "La Naissance du roi-liche",
	[175749] = "La Couronne et le Trône de glace",
	[175750] = "La bataille de Grim Batol",
	[175751] = "La léthargie des Orcs",
	[175752] = "La nouvelle Horde",
	[175753] = "La guerre de l'Araignée",
	[175754] = "Kel'Thuzad et l'avènement du Fléau",
	[175756] = "Le Fléau de Lordaeron",
	[175757] = "Puits de soleil - La chute de Quel'Thalas",
	[175758] = "Le retour d'Archimonde et la fuite vers Kalimdor",
	[175759] = "L’histoire du Traître",
	[175760] = "La montée des Elfes de sang",
	[175761] = "Guerre civile dans les Maleterres",
	[175762] = "Le triomphe du roi-liche",
	[175763] = "Anciennes haines - La colonisation de Kalimdor",
	[175854] = "Les empires jumeaux",
	[175855] = "La chute de l'empire",
	[175856] = "La colère du fléau des âmes",
	[175886] = "Pique de fortune",
	[175894] = "Colis de Janice",
	[175924] = "Cabinet verrouillé",
	[175925] = "Toilettes",
	[175926] = "Journal de Mme Dalson",
	[175949] = "Cinquième tablette Mosh'aru",
	[175950] = "Sixième tablette Mosh'aru",
	[175965] = "Fluide d’embaumement de Murmegivre",
	[175966] = "Fil écarlate enchanté",
	[175970] = "Cuirasse runique inachevée",
	[176089] = "Gantelets en plaques inachevés",
	[176090] = "Cadavres humains",
	[176091] = "Chaudron des Mort-bois",
	[176112] = "Coffre de Malor",
	[176115] = "Avis de recherche : Arnak Totem-sinistre",
	[176116] = "Tête de la poupée de Pamela",
	[176142] = "Flanc gauche de la poupée de Pamela",
	[176143] = "Flanc droit de la poupée de Pamela",
	[176190] = "Tortue de mer échouée",
	[176191] = "Tortue de mer échouée",
	[176192] = "Catalogue de l'Indocile",
	[176196] = "Tortue de mer échouée",
	[176197] = "Tortue de mer échouée",
	[176198] = "Tortue de mer échouée",
	[176249] = "Donnée du Fléau",
	[176317] = "Le Coffre d'argent",
	[176325] = "Plans de forgeron",
	[176361] = "Chaudron du Fléau",
	[176392] = "Chaudron du Fléau",
	[176393] = "Chaudron du Fléau",
	[176582] = "Casier à crustacés",
	[176631] = "Don de Menethil",
	[177289] = "Chaudron du Fléau",
	[177490] = "Caisse de la scierie de la Crête du nord",
	[177491] = "Tonneau de termites",
	[177544] = "Coffre de Joseph",
	[177667] = "Parchemin déchiré",
	[177675] = "Monticule de poussière",
	[177786] = "Coffre de Rackmore",
	[177787] = "Journal de Rackmore",
	[177904] = "Avis de recherche : Besseleth",
	[177964] = "Pierre de la Brasse",
	[178609] = "Neige d'hiver",
	[179485] = "Piège cassé",
	[179499] = "Panier de tanin ogre",
	[179501] = "Réserve de Noué Dédodevie",
	[179517] = "Trésor des Shen'dralar",
	[179545] = "Le coffre du prince",
	[179547] = "Un tome poussiéreux",
	[179551] = "Coffre d'Hydraxis",
	[179552] = "Schéma : Robot réparateur 74A",
	[179559] = "Fragment de gangrevigne",
	[179562] = "Ancienne épée chauffée",
	[179564] = "Tribut des Gordok",
	[179697] = "Coffre au trésor de l'arène",
	[179703] = "Cachette du seigneur du Feu",
	[179827] = "Avis de recherche / Disparu / Trouvé & Perdu",
	[179832] = "Oreiller brodé de Pincetaie",
	[179879] = "Orbe de commandement",
	[179880] = "Marque de Drakkisath",
	[179913] = "Aux armes !",
	[180215] = "Filon de thorium hakkari",
	[180229] = "Pile de déchets",
	[180327] = "Brasero de la Folie",
	[180366] = "Boîte d'appâts abîmée",
	[180368] = "Tablette de la folie",
	[180369] = "Eaux troubles et agitées",
	[180448] = "Avis de recherche : Poigne-de-mort",
	[180456] = "Pierre des vents inférieure",
	[180461] = "Pierre du vent",
	[180466] = "Pierre des vents supérieure",
	[180503] = "Livre de cuisine sableux",
	[180526] = "Gong de Bethekk",
	[180570] = "Tonneau",
	[180633] = "Larme cristalline",
	[180642] = "Caisse anodine",
	[180652] = "Terre fraîchement remuée",
	[180658] = "Banc de poissons déviants",
	[180662] = "Débris de goélette",
	[180665] = "Le draconique pour les nuls",
	[180666] = "Le draconique pour les nuls",
	[180667] = "Le draconique pour les nuls",
	[180682] = "Banc de bouches-noires huileux",
	[180684] = "Banc de grandes sagerelles",
	[180685] = "Débris trempés",
	[180690] = "Grand coffre de scarabées",
	[180691] = "Coffre de scarabées",
	[180712] = "Banc d'anguilles pierre-écaille",
	[180717] = "Le gong du Scarabée",
	[180743] = "Cadeau soigneusement emballé",
	[180746] = "Cadeau secoué doucement",
	[180747] = "Cadeau à l'emballage multicolore",
	[180748] = "Cadeau tic-taquant",
	[180751] = "Débris flottants",
	[180793] = "Cadeau de fête",
	[180794] = "Journal de Jandice Barov",
	[180796] = "Fabulovolt PX-238 Hiver",
	[180901] = "Débris de la Voile sanglante",
	[180918] = "Avis de recherche : Thaelis l'Affameur",
	[181011] = "Journal du magistère Ternesoir",
	[181073] = "Chaudron parfumé",
	[181074] = "Butin de l'arène",
	[181083] = "Possessions de Sothos et Jarien",
	[181085] = "Caisse de fournitures de Stratholme",
	[181147] = "Avis de recherche",
	[181150] = "Journal poussiéreux",
	[181153] = "Avis de recherche : Kel'gash le Malfaisant",
	[181366] = "Coffre des quatre cavaliers",
	[181638] = "Avis de recherche",
	[181643] = "Cadavre de Barbe-de-plumes",
	[181649] = "Journal de Barbe-de-plumes",
	[181665] = "Coffre funéraire",
	[181698] = "Pierre de Vide",
	[181748] = "Cristal de sang",
	[181756] = "Livre ancien endommagé",
	[181889] = "Avis de recherche",
	[182032] = "Journal de Galaen",
	[182053] = "Chapeluisant",
	[182115] = "Avis de recherche",
	[182165] = "Avis de recherche",
	[182196] = "Récipient arcanique",
	[182197] = "Récipient arcanique",
	[182198] = "Récipient arcanique",
	[182392] = "Panneau d'affichage de Garadar",
	[182393] = "Panneau d'affichage de Telaar",
	[182549] = "Plans des Gangr'orcs",
	[182587] = "Avis de recherche",
	[182588] = "Avis de recherche",
	[182947] = "Le Codex de sang",
	[182952] = "Détritus de la pompe à vapeur",
	[182953] = "Banc de poissons-spores",
	[182954] = "Banc mixte en eaux saumâtres",
	[182956] = "Banc de dards",
	[182957] = "Banc mixte des hautes-terres",
	[182958] = "Banc d'éperlans",
	[182959] = "Banc de tassergals",
	[183284] = "Avis de recherche",
	[183385] = "Hibiscus sanguin",
	[183770] = "Console de contrôle de B'naar",
	[183811] = "Avis de recherche",
	[183877] = "Panneau de contrôle du transporteur éthérien",
	[184300] = "Focalisation nécromantique",
	[184465] = "Cache de la Légion",
	[184660] = "Avis de recherche",
	[184793] = "Coffre primitif",
	[184825] = "Tome lashh'an",
	[184945] = "Avis de recherche",
	[184946] = "Avis de recherche",
	[185035] = "Avis de recherche",
	[185119] = "Coffre couvert de poussière",
	[185126] = "Prison de cristal",
	[185165] = "Communicateur de la Légion",
	[185166] = "Avis de recherche",
	[185168] = "Coffre en gangrefer renforcé",
	[185302] = "Cache de Fei Fei",
	[185522] = "Chambre de stase de Shaffar",
	[186183] = "Tonneau de fête brasselorge",
	[186184] = "Tonneau de fête tonnebière",
	[186185] = "Tonneau de fête gordok",
	[186186] = "Tonneau de fête de la distillerie Drohn",
	[186187] = "Tonneau de fête de bière vaudou de T'chali",
	[186267] = "Sanctuaire de citrouille",
	[186426] = "Avis de recherche",
	[186585] = "Parchemin en peau de dragon",
	[186887] = "Grosse citrouille de la Sanssaint",
	[187236] = "Cadeau du Voile d'hiver",
	[187273] = "Empreinte de sabot suspecte",
	[187367] = "Palourde aileron-d'hiver",
	[187565] = "Ancien Atkanok",
	[187851] = "Sanctuaire du sectateur",
	[187905] = "Œuf massif luminescent",
	[188085] = "Céréales pestiférées",
	[188192] = "Coffre de glace",
	[188261] = "Journal endommagé",
	[188364] = "Piège à crabes détruit",
	[188365] = "Cœur des anciens",
	[188367] = "Sismographe portable",
	[188418] = "Avis de recherche !",
	[188419] = "Ancien Mana'loa",
	[188501] = "Pièce de golem de guerre",
	[188502] = "Pièce de golem de guerre",
	[188503] = "Pièce de golem de guerre",
	[188649] = "Avis de recherche",
	[188667] = "Ambregraine",
	[189311] = "Tome relié de chair",
	[189989] = "Débris de la taupe mécanique sombrefer",
	[189990] = "Débris de la taupe mécanique sombrefer",
	[190020] = "Avis de recherche !",
	[190447] = "Moteur de machine volante",
	[190453] = "Pièces détachées de la KapitalRisk",
	[190454] = "Pièces détachées de la KapitalRisk",
	[190455] = "Pièces détachées de la KapitalRisk",
	[190535] = "Zim’Abwa",
	[190602] = "Zim’Torga",
	[190622] = "Liane solide",
	[190623] = "Papaye",
	[190625] = "Régime de bananes",
	[190643] = "Punch de la jungle de Tonnebière",
	[190657] = "Zim’Rhuk",
	[190768] = "Coffre vétuste",
	[190917] = "Courrier abandonné",
	[190936] = "Chaudron de peste",
	[191543] = "Malle de l'Assaut écarlate",
	[191728] = "Avis de recherche !",
	[191760] = "Console de la bibliothèque de l'inventeur",
	[191761] = "Console prototype",
	[191766] = "Ordres de Drakuru",
	[192046] = "Banc de rascasses dos-de-moule",
	[192048] = "Banc de demoiselles aileron-de-dragon",
	[192049] = "Banc de harengs crocs-pointus",
	[192050] = "Banc de saumons glaciaires",
	[192051] = "Banc de poissons-méduses boréens",
	[192052] = "Banc de raies manta impériales",
	[192053] = "Banc de baudroies abyssales",
	[192054] = "Banc de seiches lueur-de-lune",
	[192057] = "Banc de méduses",
	[192059] = "Banc de vairons nageverres",
	[192060] = "L’enclume de Fjorn",
	[192071] = "L’enclume de Fjorn",
	[192072] = "Caisse de harpons",
	[192078] = "Cor de Hodir",
	[192079] = "Lance de Hodir",
	[192080] = "Heaume de Hodir",
	[192524] = "Arngrim l'Insatiable",
	[192708] = "Les écoles de magie des arcanes - Introduction",
	[192709] = "Les écoles de magie des arcanes - Abjuration",
	[192710] = "Les écoles de magie des arcanes - Invocation",
	[192711] = "Les écoles de magie des arcanes - Divination",
	[192713] = "Les écoles de magie des arcanes - Enchantement",
	[192818] = "Champignon infusé",
	[192827] = "Moutarde sauvage",
	[192828] = "Carotte du Chant de cristal",
	[192833] = "Possessions de Bridenbrad",
	[192865] = "Les écoles de magie des arcanes - Illusion",
	[192866] = "Les écoles de magie des arcanes - Nécromancie",
	[192867] = "Les écoles de magie des arcanes - Transmutation",
	[193195] = "Cristal vibrant",
	[193400] = "Pile de bombes en saronite",
	[193402] = "Cantine rouillée du prisonnier",
	[193426] = "Coffre des quatre cavaliers",
	[194092] = "Urne noircie",
	[194105] = "Bigobox 413",
	[194122] = "Bigobox 723",
	[194213] = "Jacinthe d'hiver",
	[194238] = "Lame de Drak'Mar",
	[194378] = "Document volé de la Ligue des explorateurs",
	[194387] = "Document volé de la Ligue des explorateurs",
	[194388] = "Document volé de la Ligue des explorateurs",
	[194389] = "Document volé de la Ligue des explorateurs",
	[194390] = "Document volé de la Ligue des explorateurs",
	[194391] = "Document volé de la Ligue des explorateurs",
	[194479] = "Flaque de sang",
	[194555] = "Console de l'Archivum",
	[194618] = "Râtelier de lances",
	[194622] = "Râtelier de lances",
	[194714] = "Etabli dégoûtant",
	[194908] = "Râtelier de lances",
	[194909] = "Râtelier de lances",
	[195134] = "La bombe",
	[195431] = "Radio du quartier-général",
	[195433] = "Tablettes antiques",
	[195435] = "Râtelier d'armes",
	[195438] = "Coupe d'Élune",
	[195445] = "Ancienne pierre runique du vortex",
	[195497] = "Brasero d'Élune",
	[195517] = "Suivante d'Élune",
	[195600] = "Pierre fumante",
	[195642] = "Pierre de puissance naga",
	[195665] = "Coffre d'offrande de la Croisade d'argent",
	[195676] = "Haut-parleur du Laboratoire secret",
	[196393] = "Relique cassée",
	[196394] = "Caisse d'essence de mandragore",
	[196832] = "Pierre de vision supérieure",
	[196833] = "Pierre de vision inférieure",
	[201578] = "Poster de recrutement des Disjoncteurs",
	[201873] = "Armurerie de la canonnière",
	[202080] = "Œuf de Flèche",
	[202081] = "Œuf de Takk",
	[202082] = "Œuf de matriarche ravasaure",
	[202083] = "Œuf de matriarche tranchegueule",
	[202135] = "Tombe de Dadanga",
	[202180] = "Armurerie de la canonnière",
	[202407] = "Coffre balayé par le sable",
	[202474] = "Coffre antédiluvien",
	[202598] = "Bon gros détonateur",
	[202613] = "Panneau de contrôle de la plateforme",
	[202655] = "Trouvaille archéologique trolle",
	[202697] = "Œil du Crépuscule",
	[202701] = "Planque des toilettes",
	[202706] = "Chaudron du Crépuscule",
	[202712] = "L'apocryphe du Crépuscule",
	[202776] = "Banc de truites de montagne",
	[202777] = "Banc de guppys des hautes-terres",
	[202778] = "Banc de tétras cavernicoles albinos",
	[202779] = "Banc d'éperlans ventre-noir",
	[202780] = "Banc d'anguilles des profondeurs",
	[202871] = "Caisse engloutie",
	[202975] = "Toilettes submergées",
	[203071] = "Trouvaille archéologique elfe de la nuit",
	[203078] = "Trouvaille archéologique nérubienne",
	[203128] = "Bouteille cassée",
	[203134] = "Piédestal vide",
	[203140] = "Dent de trident naga brisée",
	[203186] = "ENTRÉE INTERDITE !",
	[203207] = "Codex des ombres",
	[203301] = "Tridents nagas",
	[203305] = "Creuset de Nazsharin",
	[203733] = "Tableau de récompense",
	[203734] = "Titre de propriété de la marche de l'Ouest",
	[203755] = "Poster de recrutement des Disjoncteurs",
	[204050] = "Plans du Tranche-menace",
	[204274] = "Journal du capitaine",
	[204282] = "Trouvaille archéologique naine",
	[204344] = "Avis de recherche !",
	[204351] = "Orbe de contrôle d'ettin",
	[204372] = "Portail de Zanzil",
	[204386] = "Portail de Zanzil",
	[204406] = "Bouteille à moitié ensevelie",
	[204437] = "Bourse à clés de Rochenoire",
	[204450] = "Cartes du capitaine Eau-Plate",
	[204578] = "Tonneau de double-rhum",
	[204817] = "Bâtonnet de Sancteforge",
	[204824] = "Arche de Sancteforge",
	[204825] = "Écu de Sancteforge",
	[204959] = "Bloc de dolorite gigantesque",
	[205134] = "Journal du maître-forge",
	[205143] = "Toilettes abandonnées",
	[205198] = "Pile d'explosifs",
	[205207] = "Journal de Maziel",
	[205258] = "Caisse d'armes cassée",
	[205266] = "Disque élaboré",
	[205332] = "Avis de recherche",
	[205350] = "Panneau de communication de la Horde",
	[205476] = "Livre des âmes perdues",
	[205477] = "Lingots d'acier lunaire",
	[205479] = "Bois frôlelune",
	[205540] = "Squelette décrépit",
	[205874] = "Hiéroglyphes couverts de sable",
	[205875] = "Fusée du croisé",
	[206109] = "Tableau de commandement du chef de guerre",
	[206111] = "Tableau de l’appel des héros",
	[206116] = "Tableau de commandement du chef de guerre",
	[206293] = "Terminal A.I.D.A.",
	[206294] = "Tableau de l’appel des héros",
	[206335] = "Bloc de pierre",
	[206336] = "Bloc de marbre",
	[206374] = "Trésor des guetteurs",
	[206504] = "Dernière note de Rhea",
	[206569] = "Œil du Crépuscule",
	[206585] = "Totem de Ruumbo",
	[206836] = "Trouvaille archéologique fossile",
	[206944] = "Pelle",
	[207104] = "Pompe de commande du maître",
	[207125] = "Caisse de fournitures abandonnées",
	[207179] = "Chaudron tombe-hiver",
	[207187] = "Trouvaille archéologique orque",
	[207188] = "Trouvaille archéologique draeneï",
	[207189] = "Trouvaille archéologique vrykule",
	[207190] = "Trouvaille archéologique tol'vir",
	[207279] = "Tableau de commandement du chef de guerre",
	[207303] = "Tableau d'aventure",
	[207304] = "Tableau d'aventure",
	[207320] = "Tableau de l’appel des héros",
	[207321] = "Tableau de l’appel des héros",
	[207322] = "Tableau de l’appel des héros",
	[207323] = "Tableau de commandement du chef de guerre",
	[207324] = "Tableau de commandement du chef de guerre",
	[207325] = "Tableau de commandement du chef de guerre",
	[207359] = "Œuf pur du Crépuscule",
	[207406] = "Fontaine étrange",
	[207407] = "Pilier Brisé",
	[207408] = "Brasero magique",
	[207409] = "Tombe tol'vir",
	[207410] = "Grand obélisque en pierre",
	[207411] = "Tas d'os nain",
	[207412] = "Tablette en pierre",
	[207496] = "Coffre en sombrefer",
	[207497] = "Coffre en sombrefer",
	[207498] = "Coffre en sombrefer",
	[207500] = "Coffre en sombrefer",
	[207724] = "Débris d’épave",
	[208311] = "Banc de sagerelles abyssales",
	[208316] = "Tableau de l’appel des héros",
	[208317] = "Tableau de commandement du chef de guerre",
	[208365] = "Tas de terre remué récemment",
	[208535] = "Gland séché",
	[208549] = "Pile vaudou",
	[208550] = "Pile vaudou",
	[208825] = "Sanctuaire des Ancêtres",
	[208900] = "Portail vers les terres de Feu",
	[209072] = "Caisse volée",
	[209076] = "Caisse d’Anson",
	[209094] = "Caisse volée",
	[209095] = "Caisse d’Edgar",
	[209270] = "|cFFFFFFFFÉtape 2:|r Page 78",
	[209344] = "Outil du verger",
	[209345] = "Outil du verger",
	[209436] = "Orange mûre",
	[209462] = "Canne en rotin",
	[209497] = "Friandises volées",
	[209550] = "Grappe de cramoisine",
	[209620] = "Coffre au trésor de Sombrelune",
	[209673] = "Pilier du tigre de jade",
	[209699] = "Cong de jade",
	[209700] = "Bol rituel ébréché",
	[209701] = "Bougie de rituel âcre",
	[209825] = "Amanite de Raz-de-Brume",
	[209836] = "Pétales fraîchement tombés",
	[209842] = "Tofu extra épicé de Pang",
	[209843] = "Pastèque estivale d’Ang",
	[209844] = "Navet rose géant d’Ang",
	[209845] = "Bière alléchante",
	[209863] = "Morceau de jade",
	[209891] = "Navet volé",
	[209892] = "Pastèque volée",
	[209903] = "Branche verte",
	[209907] = "Souci des prés",
	[209921] = "Eau boueuse",
	[209951] = "Carré de soie",
	[209952] = "Jadelune",
	[209953] = "Œuf de sterne empereur",
	[209954] = "Œuf de grue blanche-pêche",
	[209955] = "Œuf de trotteur calao",
	[210001] = "Sac de malt volé",
	[210002] = "Sac d’orge volé",
	[210005] = "Râtelier d’armes",
	[210015] = "Râtelier d’armes",
	[210016] = "Râtelier d’armes",
	[210017] = "Râtelier d’armes",
	[210018] = "Râtelier d’armes",
	[210019] = "Râtelier d’armes",
	[210020] = "Râtelier d’armes",
	[210184] = "Éperlan luisant",
	[210186] = "Éperlan luisant",
	[210188] = "Rayon de miel luisant de pluie",
	[210209] = "Lotus impérial",
	[210228] = "Pot de pigment",
	[210229] = "Eau de la jeunesse",
	[210238] = "Œuf de serpent",
	[210239] = "Œuf de serpent",
	[210240] = "Œuf de serpent",
	[210416] = "Artéfact mogu",
	[210417] = "Artéfact mogu",
	[210418] = "Artéfact mogu",
	[210565] = "Terre sombre",
	[210582] = "Terre sombre",
	[210759] = "Flèche pour le commandant Hsieh",
	[210887] = "Fournitures non corrompues",
	[211017] = "Racine",
	[211018] = "Racine",
	[211019] = "Racine",
	[211023] = "Marmite en fonte",
	[211143] = "Relique mogu",
	[211147] = "Relique mogu",
	[211148] = "Relique mogu",
	[211266] = "Fournitures volées",
	[211268] = "Fournitures volées",
	[211269] = "Fournitures volées",
	[211270] = "Fournitures volées",
	[211312] = "Baril d’explosifs",
	[211379] = "Planche abandonnée",
	[211382] = "Varech résistant",
	[211420] = "Motte de sable",
	[211424] = "Parchemin d’alchimie",
	[211451] = "Don de la grue céruléen",
	[211452] = "Don de la grue bronze",
	[211454] = "Buisson de kafa’kota",
	[211480] = "Baies de kafa’kota",
	[211506] = "Pot de poix",
	[211507] = "Pot de poix",
	[211510] = "Affaires du sage Liao",
	[211517] = "Recroquevrille",
	[211518] = "Recroquevrille",
	[211536] = "Sac de grigris volés",
	[211537] = "Sac de grigris volés",
	[211538] = "Sac de grigris volés",
	[211566] = "Totem de Vent-Blême",
	[211684] = "Fleurs volatiles",
	[211696] = "Sac de houblon volé",
	[211719] = "Cédrat pourpre",
	[211721] = "Cédrat pourpre",
	[211754] = "Texte curieux",
	[211770] = "Tablette de la dynastie Shen",
	[211780] = "Texte curieux",
	[211793] = "Tablette de la dynastie Wai",
	[211794] = "Tablette de la dynastie Qiang",
	[211807] = "Coffre mogu",
	[211863] = "Membre de krik’thik",
	[211871] = "Orbe funeste",
	[211872] = "Orbe funeste",
	[211873] = "Orbe funeste",
	[211967] = "Coffre du roi",
	[211990] = "Discours hozen",
	[211993] = "Maturité hozen",
	[211994] = "Les ravages hozen",
	[212003] = "Baril de naphte yaungol",
	[212009] = "Fragment d’ambre",
	[212079] = "Relique mantide",
	[212135] = "Flèches enflammées pandashan",
	[212136] = "Flèches enflammées pandashan",
	[212181] = "Statue ancienne",
	[212278] = "Tonneau d’Unga protégé",
	[212389] = "Parchemin d’auspice",
	[212540] = "Tonneau perdu",
	[212541] = "Chope perdue",
	[212553] = "Fournitures de pique-nique perdues",
	[212902] = "Ambre solidifié",
	[212923] = "Collecteur d’ambre",
	[212987] = "Minuscule étoile de mer",
	[212988] = "Minuscule étoile de mer",
	[213267] = "Sombreffroi",
	[213327] = "Les Sauroks",
	[213328] = "Les rebelles",
	[213329] = "Les déserteurs",
	[213330] = "La bataille finale",
	[213331] = "Vallée des empereurs",
	[213332] = "La dynastie perdue",
	[213333] = "Lieurs d’esprit",
	[213334] = "Le roi-tonnerre",
	[213362] = "Placard de bateau",
	[213363] = "Perforeuse mantide de Wodin",
	[213364] = "Pioche de mineur pandaren ancienne",
	[213366] = "Théière pandarène ancienne",
	[213368] = "Pièce porte-bonheur pandarène",
	[213407] = "Quan Tou Kuo l’Ambidextre",
	[213409] = "Le Cycle des mantides",
	[213410] = "La société mantide",
	[213411] = "Ambre",
	[213412] = "L’Impératrice",
	[213413] = "Tactiques de combat pandaren",
	[213414] = "N’oublions jamais",
	[213415] = "Les Premiers Moines",
	[213416] = "Ensemble, nous sommes puissants",
	[213417] = "Tactiques yaungoles",
	[213418] = "Domination",
	[213420] = "Piégés en terre inconnue",
	[213421] = "Le fardeau de l’empereur III",
	[213422] = "Le fardeau de l’empereur IV",
	[213438] = "Ren Yun l’Aveugle",
	[213443] = "Le fardeau de l’empereur VI",
	[213445] = "Le fardeau de l’empereur V",
	[213454] = "Cantine de Trempette",
	[213455] = "Le fardeau de l’empereur VII",
	[213456] = "Le fardeau de l’empereur VIII",
	[213459] = "Lieu de naissance de Liu Lang",
	[213460] = "Un acte de vente des plus célèbres",
	[213461] = "La veuve vagabonde",
	[213511] = "Victoire à Kun-Lai",
	[213512] = "Xin Wo Yin au cœur brisé",
	[213649] = "Cache de fournitures chapardées",
	[213650] = "Cache au trésor virmène",
	[213651] = "Placard d’équipement",
	[213653] = "Lance de pêche pandarène",
	[213741] = "Bâton ancien de jinyu",
	[213742] = "Marteau des Cent tonnerres",
	[213748] = "Pierre rituelle pandarène",
	[213749] = "Bâton du maître caché",
	[213750] = "Tablette saurok en pierre",
	[213751] = "Coffre de lutin en tissu",
	[213765] = "Tablette de Ren Yun",
	[213767] = "Trésor caché",
	[213768] = "Lance de guerrier hozen",
	[213769] = "Cache au trésor hozen",
	[213770] = "Trésor de lutin volé",
	[213771] = "Statue de Xuen",
	[213774] = "Affaires de l’aventurier perdu",
	[213782] = "Tête en terre cuite",
	[213793] = "Minuscule coffre de Rikktik",
	[213795] = "Secrets des Brune d’Orage",
	[213842] = "Planque d’armes yaungoles",
	[213844] = "Phalène pris dans l’ambre",
	[213845] = "Le Marteau de la Folie",
	[213956] = "Fragment d’effroi",
	[213959] = "Sève de Kri’vess durcie",
	[213960] = "Porte-feu yaungol",
	[213961] = "Caisse de marchandises abandonnée",
	[213962] = "Dague de frappes rapides de saccageur des vents",
	[213964] = "Lance vaillante de Malik",
	[213966] = "Collier pris dans l’ambre",
	[213967] = "Lame du Premier",
	[213968] = "Fendoir de Ka’roz foisonnant",
	[213969] = "Bâton de mutation du disséqueur",
	[213970] = "Fragment de chitine imprégné de sang",
	[213971] = "Médaillon de gardien de l’essaim",
	[213972] = "Lame de l’esprit empoisonné",
	[213973] = "Relais sonique klaxxi",
	[214062] = "Ambre luminescent",
	[214170] = "Œuf vor’thik",
	[214175] = "Sac de fournitures de Wu Kao",
	[214325] = "Coffret oublié",
	[214337] = "Planque de gemmes",
	[214338] = "Offrandes du souvenir",
	[214339] = "Coffre de fournitures",
	[214340] = "Instructions pour la construction de bateau",
	[214403] = "Pile de papiers",
	[214407] = "Coffre au trésor de Mo Mo",
	[214438] = "Tablette mogu ancienne",
	[214439] = "Tonneau de rhum infusé à la banane",
	[214562] = "Cristal hanté par les sha",
	[214871] = "Destructeur brisé",
	[214903] = "Le tan-chao",
	[214945] = "Œuf d’onyx",
	[214962] = "Lanceur de feux d’artifice réquisitionné",
	[215705] = "Autel des Laboureurs",
	[215765] = "En attendant la tortue",
	[215779] = "Forge-l’eau",
	[215780] = "Les Eauracles",
	[215782] = "Les Origines",
	[215783] = "L’appel du devoir",
	[215785] = "Embrasser ses passions",
	[215797] = "Le fardeau de l’empereur II",
	[215798] = "Yaunghuile",
	[215799] = "Le fardeau de l’empereur I",
	[215844] = "Mât du drapeau",
	[216322] = "Tableau de récompense",
	[216362] = "Un tonneau de bière métallique",
	[216761] = "Banc de poissons océaniques",
	[216764] = "Banc de sagerelles",
	[218055] = "Lame imprégnée par les Loas",
	[218056] = "Lame imprégnée par les Loas",
	[218059] = "Potion zandalari",
	[218427] = "La force de l’âge",
	[218428] = "Notre roi et conseil",
	[218429] = "Les ombres des Loas",
	[218430] = "Le sombre prophète Zul",
	[218432] = "La montagne sacrée",
	[218433] = "L’unité a un coût",
	[218434] = "La question des Pandarens",
	[218435] = "Les agents de l’Ordre",
	[218436] = "L’Ombre, la Tempête et la Pierre",
	[218437] = "La malédiction et le silence",
	[218438] = "L’ère des cents rois",
	[218593] = "Trésor du roi-tonnerre",
	[218750] = "Commandes",
	[218853] = "Coffre orageux",
	[220641] = "Cache sire-tonnerre",
	[220807] = "Bois de lutins sans fin",
	[220815] = "Éboulement",
	[220820] = "|cFFFFFFFFÉtape 6:|r Page 1127",
	[220821] = "|cFFFFFFFFÉtape 5:|r Page 845",
	[220832] = "Trésor englouti",
	[220901] = "Coffre au trésor resplendissant",
	[220902] = "Coffre au trésor fermé par une corde",
	[220903] = "Statue de grue resplendissante",
	[220904] = "Marteau brise-roc",
	[220908] = "Coffre au trésor couvert par la brume",
	[220986] = "Cargaison de la Garde noire",
	[220994] = "Coffre intemporel",
	[220995] = "Coffre intemporel",
	[220996] = "Coffre intemporel",
	[220997] = "Coffre intemporel",
	[220998] = "Coffre intemporel",
	[220999] = "Coffre intemporel",
	[221000] = "Coffre intemporel",
	[221001] = "Coffre intemporel",
	[221002] = "Coffre intemporel",
	[221003] = "Coffre intemporel",
	[221004] = "Coffre intemporel",
	[221005] = "Coffre intemporel",
	[221006] = "Coffre intemporel",
	[221007] = "Coffre intemporel",
	[221008] = "Coffre intemporel",
	[221009] = "Coffre intemporel",
	[221010] = "Coffre intemporel",
	[221013] = "Coffre intemporel",
	[221014] = "Coffre intemporel",
	[221015] = "Coffre intemporel",
	[221016] = "Coffre intemporel",
	[221017] = "Coffre intemporel",
	[221018] = "Coffre intemporel",
	[221019] = "Coffre intemporel",
	[221020] = "Coffre intemporel",
	[221021] = "Coffre intemporel",
	[221023] = "Coffre intemporel",
	[221024] = "Coffre intemporel",
	[221026] = "Coffre intemporel",
	[221027] = "Carapace visiblement vide",
	[221036] = "Sacoche au trésor resplendissante",
	[221376] = "Fragment d’un vieux panneau",
	[221413] = "Parchemin familial de Lin",
	[221617] = "Coffre recouvert de crânes",
	[221670] = "Coffre couvert de mousse",
	[221671] = "Coffre solide",
	[221672] = "Coffre fumant",
	[221673] = "Coffre flamboyant",
	[221689] = "Croquefruit mûr",
	[221690] = "Œuf couvert de sable",
	[221725] = "Cristal chargé",
	[221747] = "Enorme rôti de yack",
	[221763] = "Pavot de feu",
	[221764] = "Graine torréfiée",
	[222684] = "Sable luisant",
	[222685] = "Nid de grues",
	[222686] = "Cristal sinistre",
	[222687] = "Ravitaillement ordon",
	[222688] = "Œuf tempête-de-feu",
	[222689] = "Autel ardent d’Ordos",
	[222776] = "Sanctuaire perdu dans le temps",
	[222796] = "Heaume de la famille Foudre des Nuages",
	[223084] = "Coffre couvert de mousse",
	[223085] = "Coffre couvert de mousse",
	[223086] = "Coffre couvert de mousse",
	[223087] = "Coffre couvert de mousse",
	[223088] = "Coffre couvert de mousse",
	[223089] = "Coffre couvert de mousse",
	[223090] = "Coffre couvert de mousse",
	[223091] = "Coffre couvert de mousse",
	[223092] = "Coffre couvert de mousse",
	[223093] = "Coffre couvert de mousse",
	[223094] = "Coffre couvert de mousse",
	[223095] = "Coffre couvert de mousse",
	[223096] = "Coffre couvert de mousse",
	[223097] = "Coffre couvert de mousse",
	[223098] = "Coffre couvert de mousse",
	[223099] = "Coffre couvert de mousse",
	[223100] = "Coffre couvert de mousse",
	[223101] = "Coffre couvert de mousse",
	[223102] = "Coffre couvert de mousse",
	[223103] = "Coffre couvert de mousse",
	[223104] = "Coffre couvert de mousse",
	[223105] = "Coffre couvert de mousse",
	[223106] = "Coffre couvert de mousse",
	[223107] = "Coffre couvert de mousse",
	[223108] = "Coffre couvert de mousse",
	[223109] = "Coffre couvert de mousse",
	[223110] = "Coffre couvert de mousse",
	[223111] = "Coffre couvert de mousse",
	[223112] = "Coffre couvert de mousse",
	[223113] = "Coffre couvert de mousse",
	[223114] = "Coffre couvert de mousse",
	[223115] = "Coffre couvert de mousse",
	[223116] = "Coffre solide",
	[223117] = "Coffre solide",
	[223118] = "Coffre solide",
	[223119] = "Coffre fumant",
	[223139] = "Pierre tombale maudite",
	[223193] = "Palourde géante",
	[223204] = "Coffre couvert de mousse",
	[223228] = "Brassefeu des mers du Sud",
	[223533] = "Offrande pacifique",
	[223537] = "Châle cœur-de-flammes",
	[223538] = "Trident du Ruisseauracle",
	[223539] = "Griffes de tigre des congères",
	[224228] = "Chaudron bouillonnant",
	[224306] = "Chaînes brisées",
	[224392] = "Planque d’esclave",
	[224613] = "Coffre de spectateur",
	[224616] = "Pétroglyphe sur obsidienne",
	[224623] = "Œuf de rylak frétillant",
	[224633] = "Fournitures de la Horde de Fer",
	[224686] = "Pierrentraille du Dévoreur",
	[224713] = "Cache de Cognecombe",
	[224750] = "Sacoche suspendue",
	[224753] = "Œuf de rylak écailleux",
	[224754] = "Coffre détrempé",
	[224755] = "Offrande de la Horde de Fer",
	[224756] = "Sacoche de l’alchimiste",
	[224770] = "Trésor d’exilé d’Ombrelune",
	[224780] = "Dague sacrificielle d’Ombrelune",
	[224781] = "Panier en décomposition",
	[224783] = "Jarre à faux fond",
	[224784] = "Cache du redresseur de torts",
	[224785] = "Cache démoniaque",
	[225501] = "Offrande pacifique",
	[225502] = "Offrande pacifique",
	[225503] = "Offrande pacifique",
	[225596] = "Nopal épineux",
	[225726] = "Ordre de déclassement du déchiqueteur de Fer",
	[225778] = "Notes de Barum",
	[226468] = "Pierre chamanique de Loup-de-Givre",
	[226831] = "Boîte d’astrologue",
	[226854] = "Défense d’elekk cuirassé",
	[226861] = "Affaires de Ronokk",
	[226862] = "Cône de saule lunaire géant",
	[226865] = "Cargaison de la reine corbeau",
	[226955] = "Cor de guerre du maître de l’arène",
	[226956] = "Pile de fruits mystérieuse",
	[226961] = "Tableau de récompense",
	[226967] = "Bassin du lagon",
	[226976] = "Bottes fumantes de Deceptia",
	[226983] = "Cache de bondisseur des combes",
	[226990] = "Réserve de fournitures",
	[226993] = "Cache de survivaliste",
	[226994] = "Trésor de Triste-Givre",
	[226996] = "Restes de goren",
	[227069] = "Note écrite à la hâte",
	[227134] = "Cargaison de la Horde de Fer",
	[227504] = "Lance barbelée sire-tonnerre",
	[227527] = "Porte-Lumière",
	[227587] = "Cadeau de Yuuri",
	[227654] = "Lance de mâche-les-os",
	[227737] = "Communicateur du Conseil des ombres",
	[227743] = "Poisson fantastique",
	[227793] = "Trésor de la famille d’Aarko",
	[227806] = "Bannière loup-de-givre détériorée",
	[227859] = "Espoir",
	[227868] = "Bassin étincelant",
	[227951] = "Boîte de pêche de Freux",
	[227953] = "Cruche de vin de Fer vieilli",
	[227954] = "Coquille lumineuse",
	[227955] = "Cristal améthyle",
	[227956] = "Boîte à repas du contremaître",
	[227996] = "Œuf de sépultoile bizarre",
	[227998] = "Sac d’Ockbar",
	[228012] = "Épée carbonisée",
	[228013] = "Butin du fermier",
	[228014] = "Relique d’Aruuna",
	[228015] = "Boîte en fer",
	[228016] = "Tonneau de poissons",
	[228017] = "Armes draeneï",
	[228018] = "Reliquaire de la lieuse d’âme",
	[228019] = "Sac entoilé",
	[228020] = "Relique de Telmor",
	[228021] = "Trésor d’Ango’rosh",
	[228022] = "Lumière de la Mer",
	[228023] = "Restes de Mâche-les-Os",
	[228024] = "Chariot de mine d’Aruuna",
	[228025] = "Affaires de Keluu",
	[228026] = "Poussière de cristal pure",
	[228483] = "Coffret rouillé",
	[228570] = "Planque de Ketya",
	[229314] = "Appareil de contrôle mental gobelin",
	[229328] = "Sacoche de l’émissaire",
	[229330] = "Anneau mystérieux",
	[229331] = "Un chapeau mystique",
	[229333] = "Bottes mystérieuses",
	[229344] = "Bâton distordu dans le temps enterré",
	[229354] = "Pièce brillante",
	[229367] = "Squelette d’Orc gelé",
	[229640] = "Hache loup-de-givre gelée",
	[230252] = "Perle ardente",
	[230303] = "Tableau de récompense",
	[230401] = "Cruche scellée",
	[230402] = "Pièce porte-bonheur",
	[230424] = "Coffre renforcé couvert de neige",
	[230425] = "Os rongé",
	[230428] = "Gisement fumant de vérifer",
	[230498] = "Cage sire-tonnerre",
	[230506] = "Cage sire-tonnerre",
	[230544] = "Pierre chamanique de Loup-de-Givre",
	[230611] = "Sac de butin de blafard",
	[230643] = "Nid de terogriffe",
	[230664] = "La lame de cristal de Torvath",
	[230865] = "Liste d’ingrédients",
	[230909] = "Fournitures oubliées",
	[230933] = "Console de commande centrale du pylône de défense",
	[231063] = "Planque de matériaux de dame Sena",
	[231064] = "Autre planque de matériaux de dame Sena",
	[231069] = "Dague suspecte",
	[231100] = "Glacelierre",
	[231103] = "Butin pillé",
	[231644] = "Crâne cornu",
	[231769] = "Champignon luminescent",
	[231775] = "Cœur du Magnaron",
	[231901] = "Parchemins ogres",
	[231903] = "Rapport de Barbe-Fourbe",
	[231918] = "Parchemin de Laanda",
	[232024] = "Plans d’attaque des Chanteguerres",
	[232066] = "Trésor englouti",
	[232067] = "Trésor volé",
	[232090] = "Fournitures volées de Brib",
	[232214] = "Butin ogre",
	[232215] = "Réserve personnelle de Gorr’thogg",
	[232216] = "Butin ogre",
	[232217] = "Butin ogre",
	[232218] = "Planque secrète de Portog",
	[232219] = "Butin ogre",
	[232237] = "Butin ogre",
	[232248] = "Fournitures enterrées par Toufou",
	[232250] = "Fournitures enterrées par Toufou",
	[232251] = "Fournitures enterrées par Toufou",
	[232252] = "Fournitures enterrées par Toufou",
	[232353] = "Chaise du surveillant",
	[232397] = "Panneau d’affichage",
	[232398] = "Tableau de récompense",
	[232400] = "Panneau d’affichage",
	[232405] = "Avis de recherche",
	[232406] = "Sac à dos de l’aventurier",
	[232416] = "Tableau de commandement",
	[232458] = "Coffre de Nizzix",
	[232492] = "Obus maudit",
	[232494] = "Coffre couvert de champignons",
	[232507] = "Œuf de Chutelune",
	[232541] = "Chariot de mine",
	[232546] = "Butin ogre",
	[232547] = "Butin ogre",
	[232549] = "Butin ogre",
	[232550] = "Butin ogre",
	[232571] = "Sac à dos gobelin",
	[232579] = "Œuf de kaliri",
	[232582] = "Cendres d’A’kumbo",
	[232583] = "Corne à boire gravée",
	[232584] = "Ravitaillement de Gentepression",
	[232586] = "Dague de Rovo",
	[232587] = "Gris-gris d’Uzko",
	[232588] = "Urne de Greka",
	[232589] = "Sac d’herbes de Veema",
	[232590] = "Cristal imprégné du Vide",
	[232591] = "Offrande du bien-aimé",
	[232592] = "Ruche de flammeroles",
	[232595] = "Ravitaillement de Gentepression",
	[232596] = "Bardiche ancestrale",
	[232597] = "Sac à dos gobelin",
	[232598] = "Ravitaillement de Gentepression",
	[232599] = "Butin des Chanteguerres",
	[232621] = "Spore étrange",
	[232624] = "Coffre de Mikkal",
	[232985] = "Ravitaillement de Gentepression",
	[232986] = "Fortune cachée",
	[232989] = "Corbeille de marchandises arakkoa",
	[233032] = "Sac à dos d’alpiniste",
	[233033] = "Ravitaillement de Gentepression",
	[233034] = "Ravitaillement de Gentepression",
	[233044] = "Coffre couvert de moisissures",
	[233048] = "Fronderêve brillant",
	[233052] = "Ravitaillement de Gentepression",
	[233079] = "Fournitures chanteguerres soustraites",
	[233101] = "Bateau de pêche coulé",
	[233103] = "Coffret chanteguerre",
	[233107] = "Petit coffre au trésor",
	[233113] = "Lance chanteguerre",
	[233126] = "Trésor d’Ombrelune",
	[233132] = "Palourde d’eau douce",
	[233134] = "Œuf de kaliri doré",
	[233135] = "Cache chanteguerre",
	[233137] = "Cache de la Lame-Ardente",
	[233139] = "Coffre de Titan ancien",
	[233149] = "Cache du Crâne-Ricanant",
	[233180] = "Feu de joie de la Horde de Fer",
	[233206] = "Chargement abandonné",
	[233218] = "Sac à dos de l’aventurier",
	[233229] = "Tome des malédictions du Conseil des ombres",
	[233241] = "Champignon luminescent de la caverne",
	[233263] = "Pierre chamanique",
	[233291] = "Tableau de commandement",
	[233391] = "Ordres d’armement",
	[233452] = "Un tas de terre",
	[233455] = "Vieux caveau en pierre",
	[233457] = "Bâton de l’aventurier",
	[233492] = "Offrande élémentaire",
	[233499] = "Sac de l’aventurier",
	[233501] = "Mystérieuse cosse pétrifiée",
	[233504] = "Cadavre de Grimnir Cendrepioche",
	[233505] = "Œuf pétrifié non identifié",
	[233507] = "Cache ogre oubliée",
	[233511] = "Sac à dos de l’aventurier",
	[233513] = "Cache de crânes oubliée",
	[233520] = "Cadavre de l’ingexplorateur Toldirk Lampacendre",
	[233521] = "Fournitures chanteguerres",
	[233522] = "Formation de cristaux d’obsidienne",
	[233523] = "Mystérieuse cosse pétrifiée",
	[233524] = "Œuf pétrifié non identifié",
	[233525] = "Graine d’essence de botani",
	[233526] = "Coffre de Titan ancien",
	[233532] = "Dague gravée en os",
	[233539] = "Débris du Génédar",
	[233549] = "Débris du Génédar",
	[233550] = "Œuf pétrifié non identifié",
	[233551] = "Débris du Génédar",
	[233552] = "Vieux caveau en pierre",
	[233555] = "Débris du Génédar",
	[233557] = "Débris du Génédar",
	[233558] = "Mystérieuse cosse pétrifiée",
	[233559] = "Cache de crânes oubliée",
	[233560] = "Fragment d’Oshu’gun",
	[233561] = "Treizième hache de Pokhar",
	[233593] = "Crâne de sabron poli",
	[233594] = "Recherches de Thukmar",
	[233598] = "Chaînes élémentaires",
	[233611] = "Merlin de Cognefort",
	[233613] = "Bouclier de défenseur de Telaar",
	[233618] = "Perles ogres",
	[233623] = "Bourse de l’aventurier",
	[233626] = "Pile d’os de Grisegueule",
	[233633] = "Pile de bois inutilisé",
	[233645] = "Heaume chanteguerre",
	[233649] = "Bourse du parieur",
	[233650] = "Masse de l’aventurier",
	[233651] = "Pendentif perdu",
	[233658] = "Bourse de l’aventurier",
	[233696] = "Fournitures d’exploration importantes",
	[233697] = "Planque de sabron",
	[233715] = "Butin d’Orpion",
	[233768] = "Élixir de blafard",
	[233773] = "Sac d’herbes",
	[233792] = "Pile de débris",
	[233917] = "Fémur d’improbabilité",
	[233956] = "Lame ensanglantée",
	[233973] = "Butin des éléments",
	[233975] = "Roubie Rou",
	[234054] = "Œuf de goren chaud",
	[234147] = "Effets personnels de paria",
	[234154] = "Parchemins égarés",
	[234155] = "Reliques des parias",
	[234157] = "Héliolite fracturée",
	[234159] = "Sacoche d’herbes perdue",
	[234243] = "Note très bariolée",
	[234432] = "Butin ogron",
	[234446] = "Reliques des parias",
	[234449] = "Reliques des parias",
	[234451] = "Reliques des parias",
	[234454] = "Reliques des parias",
	[234455] = "Reliques des parias",
	[234456] = "Coffret de la Main-Brisée",
	[234457] = "Corbeille de fruits",
	[234458] = "Cache de la Main-Brisée",
	[234461] = "Venin de croc-toxique",
	[234471] = "Auto-vaporisateur 5000 XT",
	[234472] = "Rhum à 90 degrés du marin Zazzuk",
	[234473] = "Cadeau de campagne électorale",
	[234474] = "Planque de sabron",
	[234618] = "Présent d’Anzu",
	[234685] = "Plans stratégiques secrets",
	[234703] = "Élixir de vue de l’Ombre",
	[234704] = "Élixir de vue de l’Ombre",
	[234705] = "Élixir de vue de l’Ombre",
	[234734] = "Élixir de vue de l’Ombre",
	[234735] = "Élixir de vue de l’Ombre",
	[234736] = "Élixir de vue de l’Ombre",
	[234740] = "Cor d’alarme orc",
	[234744] = "Offrande à la Mère corbeau",
	[234746] = "Offrande à la Mère corbeau",
	[234748] = "Offrande à la Mère corbeau",
	[235073] = "Offrande à la Mère corbeau",
	[235090] = "Offrande à la Mère corbeau",
	[235091] = "Anneau perdu",
	[235095] = "Parchemin égaré",
	[235097] = "Grimoire occulte d’Ephial",
	[235103] = "Ravitaillement du fief",
	[235104] = "Cache touchée par le soleil",
	[235105] = "Cache touchée par le soleil",
	[235127] = "Mystérieuse cosse pétrifiée",
	[235129] = "Graines enrichies",
	[235135] = "Artéfacts apogides de contrebande",
	[235141] = "Explosifs de la Horde de Fer",
	[235143] = "Lance de l’assassin",
	[235168] = "Bourse de paria",
	[235172] = "Effets personnels de paria",
	[235282] = "Breuvage rituel sethekk",
	[235289] = "Marteau d’ouvrier du fief",
	[235299] = "Gages de Chique-Piécette",
	[235300] = "Champignons mystérieux",
	[235307] = "Sacoche détrempée",
	[235310] = "Pièces de déchiqueteur",
	[235313] = "Pioche de mineur abandonnée",
	[235365] = "Coffre de l’amiral Taylor",
	[235673] = "Une caisse agitée",
	[235826] = "Œuf de rylak géant",
	[235859] = "Sac de Brokor",
	[235860] = "Squelette orc",
	[235869] = "Cache d’armes",
	[235881] = "Œuf de rylak pétrifié",
	[236092] = "Sac à dos d’urgence bien rangé",
	[236096] = "Dépouille de Baldir Fonderoc",
	[236099] = "Lance de Solegrâce",
	[236138] = "Coffre de fournitures de l’Alliance",
	[236139] = "Boîte d’explorateur",
	[236140] = "Tunnel goren",
	[236141] = "Paquet abandonné",
	[236147] = "Marteau du redresseur de torts",
	[236149] = "Planque secrète de Sasha",
	[236158] = "Arbalète de tireur d’élite",
	[236165] = "Carte de préparation de guerre",
	[236169] = "Précieux cristal récoltable",
	[236170] = "Dépouille de Balik Broie-Minerai",
	[236178] = "Planque de fournitures d’Aube-Éternelle",
	[236206] = "Carte de préparation de guerre",
	[236257] = "Coffre de Titan ancien",
	[236258] = "Œuf pétrifié non identifié",
	[236259] = "Mystérieuse cosse pétrifiée",
	[236260] = "Mystérieuse cosse pétrifiée",
	[236264] = "Cache de crânes oubliée",
	[236265] = "Vieux caveau en pierre",
	[236266] = "Œuf pétrifié non identifié",
	[236267] = "Coffre de Titan ancien",
	[236269] = "Formation de cristaux d’obsidienne",
	[236270] = "Vieux caveau en pierre",
	[236271] = "Vieux caveau en pierre",
	[236274] = "Vieux caveau en pierre",
	[236275] = "Coffre de Titan ancien",
	[236276] = "Formation de cristaux d’obsidienne",
	[236278] = "Formation de cristaux d’obsidienne",
	[236279] = "Vieux caveau en pierre",
	[236280] = "Coffre de Titan ancien",
	[236282] = "Formation de cristaux d’obsidienne",
	[236284] = "Ancienne cache ogre",
	[236285] = "Vieux caveau en pierre",
	[236288] = "Coffre de Titan ancien",
	[236289] = "Vieux caveau en pierre",
	[236348] = "Ancienne cache ogre",
	[236349] = "Coffre de Titan ancien",
	[236350] = "Vieux caveau en pierre",
	[236351] = "Ancienne cache ogre",
	[236399] = "Vieux caveau en pierre",
	[236400] = "Ancienne cache ogre",
	[236402] = "Coffre de Titan ancien",
	[236404] = "Vieux caveau en pierre",
	[236406] = "Ancienne cache ogre",
	[236407] = "Ancienne cache ogre",
	[236483] = "Présent des anciens",
	[236610] = "Présent de l’esprit",
	[236633] = "Cache de contrebandier",
	[236693] = "Munitions de la Horde de Fer",
	[236715] = "Crâne étrange",
	[236755] = "Coffret poussiéreux",
	[236935] = "Cache de la Lame-Ardente",
	[237016] = "Avis de recherche : Kuu’rat",
	[237021] = "Avis de recherche : le dard de Kliaa",
	[237022] = "Tableau de commandement",
	[237343] = "Tonneau de bière d’empaleur",
	[237452] = "Coffre de la Horde de Fer",
	[237461] = "Bouclier d’Olaf",
	[237462] = "Solution affreusement acide",
	[237463] = "Etrange boussole en cuivre",
	[237464] = "Lame d’animatomie",
	[237465] = "Réceptacle de tissemâne",
	[237466] = "Cristal soleil",
	[237467] = "Plumage en parfait état",
	[237468] = "Dépeceuse améliorée de Pépin",
	[237469] = "Griffe perdue de proto-dragon",
	[237470] = "Parchemin noir",
	[237471] = "Flèche bordée d’argent",
	[237472] = "Feuille étrangement lumineuse",
	[237473] = "Artéfact couvert de végétation",
	[237474] = "Enorme caisse d’armes",
	[237475] = "Fendoir à membres de Fer",
	[237476] = "Etoile de Fer miniature",
	[237477] = "Arbre généalogique ogre",
	[237478] = "Truc extrêmement brillant",
	[237479] = "Carillon cauchemardesque",
	[237480] = "Tempête de vent en bouteille",
	[237481] = "Flamouche en bouteille",
	[237482] = "Clé du portail du Vide",
	[237483] = "Nid de paonne agité",
	[237484] = "Canon automatique de Fer",
	[237511] = "Spore étrange",
	[237751] = "Ordres d’attaque de la Horde de Fer",
	[237821] = "Ordres de Lames-Furieuses",
	[237946] = "Coffre spirituel",
	[239120] = "Sac d’Okuna Longue-Défense",
	[239143] = "Verre de lait chaud",
	[239171] = "Verre de lait chaud",
	[239194] = "Cache de Norana",
	[239198] = "Cache d’Isaari",
	[239328] = "Coffre du capitaine",
	[239791] = "Notes de chasse aux reliques",
	[239803] = "Coffre au trésor",
	[239828] = "Frontière du réel",
	[239901] = "Œuf de serre du Vide",
	[239925] = "Pierre chamanique gelée",
	[239926] = "Pierre chamanique en fusion",
	[240003] = "Saphir étrange",
	[240215] = "Cendres d’un croisé déchu",
	[240289] = "Hache abîmée",
	[240317] = "Tome des ombres d’Iskar",
	[240353] = "Trésor apparemment pas gardé",
	[240354] = "Trésor vraiment pas gardé",
	[240519] = "Petit coffre au trésor",
	[240543] = "Coffre volé du capitaine",
	[240547] = "Crâne d’Orc",
	[240577] = "Lame de Kra’nak",
	[240580] = "Joyau des Flammes infernales",
	[240605] = "Petit coffre au trésor",
	[240608] = "Petit coffre au trésor",
	[240609] = "Petit coffre au trésor",
	[240612] = "Petit coffre au trésor",
	[240614] = "Petit coffre au trésor",
	[240616] = "Fournitures gelées",
	[240617] = "Bourse de la sentinelle perdue",
	[240619] = "Petit coffre au trésor",
	[240622] = "Étui à parchemin du gardien",
	[240623] = "Coffre de Sylvanas",
	[240624] = "Nid de dragon féerique",
	[240625] = "Reliquaire de la grande prêtresse",
	[240629] = "Coffre au trésor",
	[240630] = "Petit coffre au trésor",
	[240631] = "Coffre au trésor",
	[240634] = "Coffre au trésor",
	[240635] = "Coffre au trésor",
	[240637] = "Coffre au trésor scintillant",
	[240638] = "Coffre au trésor",
	[240639] = "Coffre au trésor scintillant",
	[240641] = "Coffre au trésor",
	[240642] = "Coffre au trésor",
	[240643] = "Coffre au trésor",
	[240644] = "Petit coffre au trésor",
	[240645] = "Coffre au trésor scintillant",
	[240646] = "Coffre au trésor",
	[240649] = "Petit coffre au trésor",
	[240651] = "Petit coffre au trésor",
	[240652] = "Coffre au trésor",
	[240653] = "Petit coffre au trésor",
	[240654] = "Petit coffre au trésor",
	[240655] = "Coffre au trésor scintillant",
	[240657] = "Petit coffre au trésor",
	[240690] = "Coffre au trésor",
	[240855] = "Grimoire des secrets",
	[241128] = "Trésor de chardofeuille sans surveillance",
	[241146] = "Coffre au trésor",
	[241147] = "Petit coffre au trésor",
	[241148] = "Petit coffre au trésor",
	[241149] = "Petit coffre au trésor",
	[241150] = "Petit coffre au trésor",
	[241151] = "Petit coffre au trésor",
	[241152] = "Coffre au trésor",
	[241153] = "Petit coffre au trésor",
	[241154] = "Petit coffre au trésor",
	[241155] = "Coffre au trésor",
	[241180] = "Coffre au trésor",
	[241206] = "Petit coffre au trésor",
	[241207] = "Petit coffre au trésor",
	[241208] = "Coffre au trésor",
	[241212] = "Coffre au trésor",
	[241213] = "Petit coffre au trésor",
	[241216] = "Coffre au trésor",
	[241267] = "Petit coffre au trésor",
	[241272] = "Coffre au trésor",
	[241280] = "Coffre au trésor",
	[241433] = "Sac oublié",
	[241434] = "Lance de chasse plantée",
	[241449] = "Cache de l’île des Crocs-Noirs",
	[241450] = "Pointe gangrenée cristallisée",
	[241504] = "Cristal poli",
	[241518] = "Petit coffre au trésor",
	[241521] = "Flûte du charmeur de serpents",
	[241522] = "Bourgeon parfait",
	[241524] = "Équipement d’extermination des blafards",
	[241533] = "Lame du champion oublié",
	[241557] = "Petit coffre au trésor",
	[241558] = "Coffre au trésor",
	[241560] = "Coffre de guerre de l’Orbite-Sanglante",
	[241561] = "Joyau de l’étoile tombée",
	[241562] = "Petit coffre au trésor",
	[241563] = "Encensoir de tourment",
	[241564] = "Petit coffre au trésor",
	[241565] = "Trésor de l’Orbite-Sanglante pillé",
	[241566] = "Fémur gravé de runes",
	[241599] = "Fruit étrange",
	[241600] = "Heaume abandonné",
	[241601] = "Effets personnels de l’éclaireur",
	[241602] = "Fournitures de la Horde de Fer oubliées",
	[241605] = "Essence des éléments cristallisée",
	[241641] = "Vulpille",
	[241656] = "Relique recouverte par la végétation",
	[241657] = "Effigie arakkoa ornée de joyaux",
	[241664] = "Longue-vue enchantée « empruntée »",
	[241665] = "Coffre au trésor",
	[241666] = "Mystérieux obélisque corrompu",
	[241671] = "Fragment de formule oublié",
	[241673] = "Trésor de l’Orbite-Sanglante pillé",
	[241674] = "Crâne du chef fou",
	[241680] = "Petit coffre au trésor",
	[241692] = "Hache du loup hurlant",
	[241699] = "Butin de guerre",
	[241712] = "Trésor de Barbe-de-Fer",
	[241713] = "Œil de Grannok",
	[241714] = "Butin planqué de la mer de Fer",
	[241715] = "Butin planqué de la mer de Fer",
	[241716] = "Butin planqué de la mer de Fer",
	[241717] = "Coffre au trésor scintillant",
	[241726] = "Gisement de tellurium",
	[241742] = "Livre de Zyzzix",
	[241743] = "Gisement de gangreschiste",
	[241745] = "Sacoche imprégnée d’énergie gangrenée",
	[241760] = "Lame sacrificielle",
	[241764] = "Butin planqué de l’Orbite-Sanglante",
	[241767] = "Coffre au trésor",
	[241772] = "Coffre au trésor",
	[241773] = "Petit coffre au trésor",
	[241775] = "Brasero de l’Éveil",
	[241835] = "Planque de champignons de l’Orbite-Sanglante",
	[241841] = "Bâton mystique pillé",
	[241847] = "Bouclier du commandant",
	[241848] = "Bâtonnet éblouissant",
	[242242] = "Petit coffre au trésor",
	[242249] = "Cristal apogide partiellement miné",
	[242250] = "Petit coffre au trésor",
	[242328] = "Petit coffre au trésor",
	[242350] = "Coffre au trésor",
	[242446] = "Petit coffre au trésor",
	[242642] = "Petit coffre au trésor",
	[242643] = "Petit coffre au trésor",
	[242644] = "Coffre au trésor",
	[242645] = "Petit coffre au trésor",
	[242646] = "Petit coffre au trésor",
	[242647] = "Coffre au trésor",
	[242649] = "Formation apogide gangrenée",
	[242660] = "Petit coffre au trésor",
	[242662] = "Petit coffre au trésor",
	[242663] = "Petit coffre au trésor",
	[242664] = "Coffre au trésor",
	[242665] = "Petit coffre au trésor",
	[242666] = "Coffre au trésor",
	[242667] = "Petit coffre au trésor",
	[242668] = "Coffre au trésor scintillant",
	[242669] = "Petit coffre au trésor",
	[242670] = "Coffre au trésor",
	[242671] = "Coffre au trésor scintillant",
	[242675] = "Petit coffre au trésor",
	[242678] = "Coffre au trésor",
	[242683] = "Coffre au trésor",
	[242959] = "Coffre au trésor",
	[243280] = "Pépé pirate",
	[243281] = "Pépé ninja",
	[243282] = "Pépé viking",
	[243283] = "Pépé chevalier",
	[243321] = "Pierre farouche",
	[243323] = "Pierre de l’équilibre",
	[243392] = "Livre d’alchimie",
	[243688] = "Coffre au trésor",
	[243690] = "Œuf orné de joyaux",
	[243693] = "Le coffre du mort",
	[243698] = "Coffre au trésor scintillant",
	[243773] = "Coffre au trésor",
	[243798] = "Boîte à bijoux torride",
	[243899] = "Brûle-flamme tellurique cassé",
	[243911] = "Monticule de neige",
	[244447] = "Œuf de Murloc blanc",
	[244453] = "Rapport de reconnaissance de Cullen",
	[244473] = "Marchandises de Totem-du-Tonnerre volées",
	[244494] = "Coffre au trésor",
	[244519] = "Coffre au trésor",
	[244628] = "Prix de Taurson",
	[244651] = "Roman d’amour torride",
	[244678] = "|cFFFFFFFFÉtape 8:|r Page 5555",
	[244689] = "Petit coffre au trésor",
	[244691] = "Petit coffre au trésor",
	[244692] = "Petit coffre au trésor",
	[244694] = "Petit coffre au trésor",
	[244698] = "Petit coffre au trésor",
	[244699] = "Petit coffre au trésor",
	[244700] = "Petit coffre au trésor",
	[244701] = "Petit coffre au trésor",
	[244775] = "Songefeuille",
	[244776] = "Songefeuille",
	[244778] = "Rose lumétoile",
	[244786] = "Gangrèche",
	[244887] = "Petit coffre au trésor",
	[244899] = "Petit coffre au trésor",
	[244901] = "Coffre au trésor",
	[244902] = "Coffre au trésor",
	[244903] = "Coffre au trésor",
	[244904] = "Petit coffre au trésor",
	[244905] = "Petit coffre au trésor",
	[244909] = "Petit coffre au trésor",
	[244912] = "Petit coffre au trésor",
	[244913] = "Coffre au trésor",
	[244917] = "Coffre au trésor",
	[244928] = "Coffre au trésor scintillant",
	[244965] = "Coffre de Sheddle",
	[244986] = "Portail de la Légion",
	[245216] = "|cFFFFFFFFÉtape 3:|r Page 161",
	[245286] = "Figurine de chat en cristal",
	[245316] = "Petit coffre au trésor",
	[245324] = "Riche gisement de tellurium",
	[245325] = "Riche gisement de gangreschiste",
	[245328] = "Parchemin enchanté",
	[245345] = "Petit coffre au trésor",
	[245479] = "Coffre endommagé",
	[245524] = "Coffre au trésor",
	[245525] = "Petit coffre au trésor",
	[245527] = "Coffre au trésor",
	[245528] = "Coffre au trésor",
	[245529] = "Petit coffre au trésor",
	[245530] = "Coffre au trésor scintillant",
	[245531] = "Petit coffre au trésor",
	[245532] = "Coffre au trésor",
	[245533] = "Coffre au trésor",
	[245534] = "Petit coffre au trésor",
	[245535] = "Petit coffre au trésor",
	[245536] = "Coffre au trésor scintillant",
	[245537] = "Coffre au trésor scintillant",
	[245538] = "Petit coffre au trésor",
	[245541] = "Petit coffre au trésor",
	[245542] = "Coffre au trésor",
	[245543] = "Coffre au trésor",
	[245545] = "Petit coffre au trésor",
	[245547] = "Petit coffre au trésor",
	[245548] = "Coffre au trésor",
	[245550] = "Coffre au trésor",
	[245551] = "Petit coffre au trésor",
	[245553] = "Coffre au trésor",
	[245554] = "Petit coffre au trésor",
	[245555] = "Petit coffre au trésor",
	[245579] = "Coffre au trésor",
	[245580] = "Petit coffre au trésor",
	[245581] = "Petit coffre au trésor",
	[245601] = "Petit coffre au trésor",
	[245602] = "Coffre au trésor",
	[245603] = "Petit coffre au trésor",
	[245688] = "Urne mortuaire brisée",
	[245793] = "Journal endommagé",
	[245941] = "Cache dimensionnelle",
	[245996] = "Petit coffre au trésor",
	[246037] = "Coffre au trésor",
	[246147] = "Petit coffre au trésor",
	[246154] = "Coffre à jouets cassé",
	[246205] = "Petit coffre au trésor",
	[246206] = "Petit coffre au trésor",
	[246249] = "Petit coffre au trésor",
	[246250] = "Lettre de Jabrouf",
	[246254] = "Coffre poussiéreux",
	[246269] = "Petit coffre au trésor",
	[246309] = "Petit coffre au trésor",
	[246353] = "Petit coffre au trésor",
	[246438] = "Dessin des circuits du Bling-o-tron",
	[246524] = "Petit coffre au trésor",
	[246555] = "Petit coffre au trésor",
	[246556] = "Petit coffre au trésor",
	[246557] = "Petit coffre au trésor",
	[246558] = "Petit coffre au trésor",
	[246559] = "Petit coffre au trésor",
	[246560] = "Petit coffre au trésor",
	[246561] = "Petit coffre au trésor",
	[246562] = "Petit coffre au trésor",
	[247694] = "Fourre-tout de Kel’danath",
	[247797] = "Courrier perdu",
	[247999] = "Gangrèche",
	[248000] = "Gangrèche",
	[248001] = "Gangrèche",
	[248002] = "Gangrèche",
	[248003] = "Gangrèche",
	[248004] = "Gangrèche",
	[248005] = "Gangrèche",
	[248006] = "Gangrèche",
	[248007] = "Gangrèche",
	[248008] = "Gangrèche",
	[248009] = "Gangrèche",
	[248010] = "Gangrèche",
	[248011] = "Gangrèche",
	[248012] = "Gangrèche",
	[248398] = "Appareil de communication éthérien",
	[248534] = "Larmes d’Élune",
	[248854] = "Coffret de Desmond",
	[249211] = "Soie shal’dorei déchirée",
	[249997] = "Petit coffre au trésor",
	[250080] = "Petit coffre au trésor",
	[250081] = "Petit coffre au trésor",
	[250083] = "Petit coffre au trésor",
	[250084] = "Petit coffre au trésor",
	[250085] = "Petit coffre au trésor",
	[250087] = "Petit coffre au trésor",
	[250088] = "Petit coffre au trésor",
	[250090] = "Petit coffre au trésor",
	[250091] = "Petit coffre au trésor",
	[250092] = "Coffre au trésor",
	[250097] = "Petit coffre au trésor",
	[250098] = "Petit coffre au trésor",
	[250102] = "Coffre au trésor",
	[250103] = "Petit coffre au trésor",
	[250104] = "Petit coffre au trésor",
	[250106] = "Petit coffre au trésor",
	[250107] = "Coffre au trésor scintillant",
	[250108] = "Petit coffre au trésor",
	[250109] = "Coffre au trésor",
	[250383] = "Relique de Lunombrage",
	[250541] = "Coffre au trésor",
	[250984] = "Petit coffre au trésor",
	[250985] = "Coffre au trésor",
	[250987] = "Petit coffre au trésor",
	[251124] = "Coffre au trésor scintillant",
	[251168] = "Cristal éphémère",
	[251218] = "Pierre runique de Rollo",
	[251220] = "Pierre runique de Ragnar",
	[251221] = "Pierre runique de Floki",
	[251416] = "Morceau de mana ancestral",
	[251552] = "Petit coffre au trésor",
	[251564] = "|cFFFFFFFFÉtape 4:|r Page 655",
	[251713] = "Petit coffre au trésor",
	[251714] = "Petit coffre au trésor",
	[251716] = "Coffre au trésor scintillant",
	[251719] = "Petit coffre au trésor",
	[251720] = "Petit coffre au trésor",
	[251723] = "Petit coffre au trésor",
	[251737] = "Coffre au trésor",
	[251738] = "Coffre au trésor",
	[251761] = "Petit coffre au trésor",
	[251762] = "Petit coffre au trésor",
	[251764] = "Petit coffre au trésor",
	[251772] = "Petit coffre au trésor",
	[251776] = "Petit coffre au trésor",
	[251780] = "Petit coffre au trésor",
	[251782] = "Petit coffre au trésor",
	[251792] = "Petit coffre au trésor",
	[251820] = "Coffre au trésor",
	[251851] = "Petit coffre au trésor",
	[251853] = "Petit coffre au trésor",
	[251854] = "Petit coffre au trésor",
	[251856] = "Petit coffre au trésor",
	[251857] = "Coffre au trésor",
	[251991] = "Égide d’Aggramar",
	[252069] = "Affaires d’Alaina",
	[252107] = "Balise de télémancie inactive",
	[252232] = "Libram d’Aponi",
	[252258] = "Alimentation tellurique",
	[252259] = "Alimentation tellurique",
	[252260] = "Alimentation tellurique",
	[252261] = "Alimentation tellurique",
	[252262] = "Alimentation tellurique",
	[252263] = "Alimentation tellurique",
	[252264] = "Alimentation tellurique",
	[252267] = "Grand sac pillé",
	[252269] = "Sac de potions de bataille",
	[252270] = "Caisse mystérieuse",
	[252272] = "Bottes fumées",
	[252273] = "Boîte de dagues de lancer",
	[252277] = "Thé de chardon",
	[252279] = "Tome sur les armes prodigieuses volé",
	[252282] = "Jeu de clés étincelant",
	[252284] = "Tas de bombes collantes",
	[252289] = "Poussière évanescente",
	[252331] = "Pépé voyageur",
	[252385] = "Page déchirée",
	[252386] = "Page aux bords abîmés",
	[252387] = "Page écornée",
	[252388] = "Page roussie",
	[252390] = "Page tachée d’encre",
	[252391] = "Page griffonnée en toute hâte",
	[252395] = "Barre d’attache de destrier de la mort",
	[252404] = "Gangrèche",
	[252412] = "|cFFFFFFFFÉtape 2:|r Monticule de poussière",
	[252432] = "Amas de mana ancestral chatoyant",
	[252434] = "|cFFFFFFFFÉtape 12:|r Orbe affamé X",
	[252446] = "Amas de mana ancestral chatoyant",
	[252447] = "Amas de mana ancestral chatoyant",
	[252448] = "Amas de mana ancestral chatoyant",
	[252449] = "Amas de mana ancestral chatoyant",
	[252450] = "Amas de mana ancestral chatoyant",
	[252557] = "|cFFFFFFFFÉtape 3:|r Orbe affamé I",
	[252558] = "|cFFFFFFFFÉtape 4:|r Orbe affamé II",
	[252559] = "|cFFFFFFFFÉtape 5:|r Orbe affamé III",
	[252560] = "|cFFFFFFFFÉtape 6:|r Orbe affamé IV",
	[252561] = "|cFFFFFFFFÉtape 7:|r Orbe affamé V",
	[252562] = "|cFFFFFFFFÉtape 8:|r Orbe affamé VI",
	[252563] = "|cFFFFFFFFÉtape 9:|r Orbe affamé VII",
	[252564] = "|cFFFFFFFFÉtape 10:|r Orbe affamé VIII",
	[252565] = "|cFFFFFFFFÉtape 11:|r Orbe affamé IX",
	[252570] = "Coffre de richesses du Séjour céleste",
	[252802] = "Petit coffre au trésor",
	[252803] = "Petit coffre au trésor",
	[252805] = "Coffre au trésor",
	[252806] = "Petit coffre au trésor",
	[252807] = "Petit coffre au trésor",
	[252808] = "Petit coffre au trésor",
	[252810] = "Petit coffre au trésor",
	[252812] = "Coffre au trésor",
	[252813] = "Petit coffre au trésor",
	[252814] = "Balise de télémancie inactive",
	[252815] = "Balise de télémancie inactive",
	[252816] = "Balise de télémancie inactive",
	[252817] = "Balise de télémancie inactive",
	[252819] = "Petit coffre au trésor",
	[252820] = "Petit coffre au trésor",
	[252821] = "Coffre au trésor",
	[252822] = "Coffre au trésor scintillant",
	[252824] = "Coffre au trésor",
	[252828] = "Petit coffre au trésor",
	[252829] = "Petit coffre au trésor",
	[252830] = "Petit coffre au trésor",
	[252831] = "Coffre au trésor scintillant",
	[252833] = "Coffre au trésor",
	[252834] = "Petit coffre au trésor",
	[252835] = "Petit coffre au trésor",
	[252836] = "Petit coffre au trésor",
	[252837] = "Coffre au trésor",
	[252838] = "Coffre au trésor",
	[252839] = "Petit coffre au trésor",
	[252840] = "Petit coffre au trésor",
	[252841] = "Petit coffre au trésor",
	[252842] = "Coffre au trésor",
	[252844] = "Coffre au trésor",
	[252850] = "Petit coffre au trésor",
	[252860] = "Petit coffre au trésor",
	[252876] = "Petit coffre au trésor",
	[252880] = "Coffre au trésor",
	[252881] = "Coffre au trésor",
	[252882] = "Coffre au trésor",
	[252883] = "Coffre au trésor",
	[252884] = "Coffre au trésor scintillant",
	[253161] = "Liane du bosquet",
	[253280] = "Veine de tellurium",
	[253452] = "Guide du débutant en failles dimensionnelles - Ch. 1 : Voyager dans le temps",
	[253453] = "Guide du débutant en failles dimensionnelles - Ch. 2 : Des sites sacrés pour beaucoup",
	[253454] = "Guide du débutant en failles dimensionnelles - Ch. 3 : Que d’eau, que d’eau !",
	[253455] = "Guide du débutant en failles dimensionnelles - Ch. 4 : Risques et récompenses",
	[253456] = "Guide du débutant en failles dimensionnelles - Ch. 5 : Rencontres en chemin",
	[253457] = "Guide du débutant en failles dimensionnelles - Ch. 6 : Énergie accumulée",
	[253458] = "Guide du débutant en failles dimensionnelles - Ch. 7 : Notre héritage",
	[253994] = "Trésor apparemment pas gardé",
	[254007] = "Autel de l’Exécutrice",
	[254010] = "Fournitures du Cercle terrestre",
	[254025] = "Petit coffre au trésor",
	[254027] = "Petit coffre au trésor",
	[254028] = "Petit coffre au trésor",
	[254126] = "Petit coffre au trésor",
	[254127] = "Petit coffre au trésor",
	[254128] = "Coffre au trésor",
	[254141] = "Petit coffre au trésor",
	[254262] = "Hibou des guetteurs",
	[255344] = "Veine de gangreschiste",
	[255828] = "Petit coffre au trésor",
	[255829] = "Petit coffre au trésor",
	[255963] = "Coffre ancestral vrykul",
	[256790] = "Coffre au trésor elfique",
	[257290] = "Coffre clanique de Haut-Roc",
	[257291] = "Coffre au trésor sacrenuit",
	[257393] = "Coffre au trésor",
	[257545] = "Coffre au trésor",
	[257546] = "Coffre au trésor",
	[257978] = "Coffre au trésor",
	[257999] = "Technique : Tome de l’esprit tranquille",
	[258690] = "Petit coffre au trésor",
	[258978] = "Tome détrempé",
	[258979] = "Tome ravagé par l’énergie gangrenée",
	[258980] = "Tome maudit",
	[259806] = "Recette de philtre d'amour",
	[265526] = "Coffre au trésor",
	[265532] = "Balise de télémancie",
	[265602] = "Tome scellé",
	[266289] = "Coffre perdu dans le temps",
	[266851] = "Baguette d'existence artificielle",
	[268478] = "Bijou endommagé",
	[268551] = "Cache de langue-de-wyrm curieux",
	[268753] = "Petit coffre au trésor",
	[269037] = "Caillou déchaussé",
	[269064] = "Petit coffre au trésor",
	[269830] = "|cFFFFFFFFÉtape 9:|r Don des cherche-esprits",
	[270855] = "|cFFFFFFFFÉtape 1:|r Note anodine",
	[270917] = "Registre de Ruisseval",
	[271103] = "Effigie de prière",
	[271706] = "Tableau des chasseurs",
	[271849] = "Fournitures de guerre érédars",
	[271850] = "Fournitures de guerre érédars",
	[272039] = "|cFFFFFFFFÉtape 2:|r Note anodine",
	[272046] = "|cFFFFFFFFÉtape 3:|r Larve d'esprit",
	[272061] = "|cFFFFFFFFÉtape 4:|r Note anodine",
	[272163] = "|cFFFFFFFFÉtape 5:|r Crâne étrange",
	[272165] = "|cFFFFFFFFÉtape 6:|r Note anodine",
	[272172] = "|cFFFFFFFFÉtape 7:|r Note anodine",
	[272179] = "Bulletin du maire",
	[272181] = "|cFFFFFFFFÉtape 8:|r Note anodine",
	[272220] = "|cFFFFFFFFÉtape 9:|r Note anodine",
	[272270] = "|cFFFFFFFFÉtape 10:|r Vœu du mystère",
	[272422] = "Grimoire d’Héléna",
	[272434] = "Pierre d’eau",
	[272455] = "Fournitures de guerre érédars",
	[272456] = "Fournitures de guerre érédars",
	[272487] = "|cFFFFFFFFÉtape 14:|r Œuf de couleur étrange",
	[272768] = "Gisement d'empyrium",
	[272770] = "Fournitures de guerre érédars",
	[272771] = "Fournitures de guerre érédars",
	[272778] = "Riche gisement d'empyrium",
	[272780] = "Veine d'empyrium",
	[272782] = "Astralée",
	[273052] = "Herbe incrustée de corruption",
	[273053] = "Touffe d’herbe incrustée de corruption",
	[273222] = "Fournitures de guerre érédars",
	[273301] = "Ancienne cache érédar",
	[273407] = "Ancienne cache érédar",
	[273412] = "Ancienne cache érédar",
	[273414] = "Ancienne cache érédar",
	[273415] = "Ancienne cache érédar",
	[273439] = "Ancienne cache érédar",
	[273443] = "Cache infiltrée par le Vide",
	[273519] = "Fournitures de guerre de la Légion",
	[273521] = "Fournitures de guerre de la Légion",
	[273523] = "Fournitures de guerre de la Légion",
	[273524] = "Fournitures de guerre de la Légion",
	[273527] = "Fournitures de guerre de la Légion",
	[273528] = "Fournitures de guerre de la Légion",
	[273533] = "Fournitures de guerre de la Légion",
	[273535] = "Fournitures de guerre de la Légion",
	[273538] = "Fournitures de guerre de la Légion",
	[273814] = "Charme-lame",
	[273854] = "Sac à dos",
	[276223] = "Cache au trésor érédar",
	[276224] = "Coffre de biens mal acquis",
	[276225] = "Surplus surprenant d’étudiant",
	[276226] = "Coffre teinté de vide",
	[276227] = "Planque secrète augari",
	[276228] = "Cache d’érédar désespéré",
	[276229] = "Coffre de maison brisé",
	[276230] = "Trésor du cherche-destin",
	[276234] = "Rivebulbe",
	[276236] = "Mousse étoilée",
	[276237] = "Mâche d’Akunda",
	[276238] = "Bise-d’hiver",
	[276239] = "Épine de sirène",
	[276240] = "Brins-de-mer",
	[276242] = "Ancoracée",
	[276251] = "Inventaire de l’excavation",
	[276424] = "Os de diablotin intacts",
	[276425] = "Os de démon intact",
	[276426] = "Os d’ur’zul intact",
	[276488] = "Boulet de canon en azérite",
	[276489] = "Coffre de tour de la Légion",
	[276490] = "Cache krokul d’urgence",
	[276491] = "Coffre krokul perdu",
	[276513] = "Éperlan intact",
	[276515] = "Canne à pêche",
	[276616] = "Gisement de monélite",
	[276617] = "Gisement de foudrargent",
	[276618] = "Gisement de platine",
	[276619] = "Veine de monélite",
	[276620] = "Veine de foudrargent",
	[276621] = "Riche gisement de monélite",
	[276622] = "Riche gisement de foudrargent",
	[276623] = "Coffre au trésor",
	[276735] = "Offrandes des élus",
	[276837] = "Caillou à recettes",
	[277199] = "Liste de tâches abîmée",
	[277204] = "Fournitures de la Légion oubliées",
	[277205] = "Ancienne cache de guerre de la Légion",
	[277206] = "Coffre gangre-lié",
	[277207] = "Cache au trésor de la Légion",
	[277208] = "Gangrecoffre usé",
	[277327] = "Coffre orné de runes augari",
	[277333] = "Sarcophage ancien",
	[277336] = "Coffre au trésor",
	[277340] = "Coffre augari secret",
	[277342] = "Fournitures augari",
	[277343] = "Trésor augari perdu depuis longtemps",
	[277344] = "Souvenirs augari précieux",
	[277346] = "Coffre augari manquant",
	[277373] = "Algue scintillante",
	[277384] = "Trésor abandonné",
	[277444] = "Bijoux recouvrés",
	[277447] = "Restes vénérés",
	[277459] = "Effigie de cochon",
	[277561] = "Cache de seigneur de guerre",
	[277637] = "Cache infiltrée par le Vide",
	[277715] = "Coffre nazmani maudit",
	[277885] = "Trésor de Wunja",
	[277886] = "Grimoire de l’Autre côté",
	[277897] = "Cache bouillonnante",
	[278197] = "Fiole d’antidote",
	[278252] = "Offre d’emploi",
	[278313] = "Lettre gratinée",
	[278368] = "Note en lambeaux",
	[278432] = "Coffre manifestement sûr",
	[278436] = "Coffre naufragé",
	[278437] = "Offrande à Bwonsamdi",
	[278447] = "Lance de trappeur infidèle",
	[278453] = "Totem vaudou",
	[278456] = "Coffre au trésor",
	[278461] = "Coffre au trésor",
	[278462] = "Coffre au trésor",
	[278570] = "Journal antique",
	[278577] = "Missive de la Horde déchirée",
	[278669] = "Grand livre de Havrebrune",
	[278675] = "Effigie maudite",
	[278694] = "Coffre au trésor",
	[278793] = "Coffre au trésor",
	[279042] = "Cache de contrebandier",
	[279044] = "Joncs zandalari",
	[279253] = "Coffre porte-bonheur de Horace le Chanceux",
	[279260] = "Coffre « habilement » déguisé",
	[279299] = "Sceau venimeux",
	[279609] = "Butin de Pandarie",
	[279645] = "Tome de l’oubli",
	[279646] = "Chroniques de la garde de sang",
	[279647] = "Tome du Sacrifice",
	[279689] = "Trésor nazmani perdu",
	[279750] = "Coffre couvert de foin",
	[280504] = "Coffre avalé",
	[280522] = "Trésor partiellement digéré",
	[280576] = "Parchemin dans son étui",
	[280619] = "Vieux coffre bardé de fer",
	[280727] = "Note calcinée",
	[280747] = "Larme d’ombre",
	[280755] = "Sacoche de Quentin",
	[280815] = "|cFFFFFFFFÉtape 1:|r Lettre de Mme Graham I",
	[280836] = "|cFFFFFFFFÉtape 2:|r Lettre de Mme Graham II",
	[280837] = "|cFFFFFFFFÉtape 3:|r Lettre de Mme Graham III",
	[280838] = "|cFFFFFFFFÉtape 4:|r Lettre de Mme Graham IV",
	[280842] = "|cFFFFFFFFÉtape 5:|r Lettre de Mme Graham V",
	[280843] = "|cFFFFFFFFÉtape 6:|r Lettre de Mme Graham VI",
	[280844] = "|cFFFFFFFFÉtape 7:|r Lettre de Mme Graham VII",
	[280845] = "|cFFFFFFFFÉtape 8:|r Cadeau de Mme Graham",
	[280883] = "Coffre abîmé par le soleil",
	[280886] = "Coffre touché par les étoiles",
	[280903] = "Jouet pour chat perdu",
	[280948] = "Appentis du Crépuscule",
	[280951] = "Butin corsandre",
	[280957] = "Sacoche de Zukashi",
	[281079] = "Mousse étoilée",
	[281092] = "Magot de féticheur",
	[281230] = "Invitation officielle",
	[281312] = "Fournitures volées",
	[281326] = "Cage à épervier",
	[281348] = "Lettre désagrégée",
	[281397] = "Coffre au trésor des Éperonneurs",
	[281494] = "Coffre au trésor givré",
	[281551] = "Avis d’offre d’emploi",
	[281583] = "Reliquaire ancien",
	[281639] = "Statue croulante",
	[281646] = "Cuve de miel",
	[281647] = "Avis posté",
	[281655] = "Don du cœur brisé",
	[281673] = "Journal de villageois de Corlain",
	[281718] = "ON EMBAUCHE",
	[281867] = "Mousse étoilée",
	[281868] = "Mousse étoilée",
	[281869] = "Épine de sirène",
	[281870] = "Rivebulbe",
	[281872] = "Brins-de-mer",
	[281898] = "Coffre oublié de Dazar",
	[282153] = "Coffre renforcé englouti",
	[282457] = "Totem roncegarde",
	[282478] = "Caisse vide",
	[282498] = "Flûte du désert",
	[282666] = "Urne d’Agussu",
	[282721] = "Coffre au trésor",
	[282723] = "Coffre au trésor",
	[284411] = "Coffre au trésor",
	[284417] = "Coffre au trésor",
	[284421] = "Coffre au trésor",
	[284426] = "Engin d’extraction enfoui",
	[284448] = "Coffre d’érudit caché",
	[284454] = "Prime de la Squale",
	[284455] = "La lamente de l’exil",
	[286016] = "Journal de bord",
	[286954] = "Bombe anti-robot",
	[287081] = "Tablette antique",
	[287185] = "Avis de recherche : sombre orateur Jo’la",
	[287189] = "Avis de recherche : bêtes dangereuses",
	[287228] = "Avis de recherche : chroniqueur sombre",
	[287229] = "Avis de recherche : chroniqueur sombre",
	[287232] = "Rapport de reconnaissance",
	[287239] = "Dernière offrande de Grayal",
	[287304] = "Trésor des explorateurs perdus",
	[287318] = "Réserve furie-des-sables",
	[287320] = "Cache abandonnée",
	[287324] = "Avidité de l’excavateur",
	[287326] = "Trésor enfoui de Zem’lan",
	[287327] = "Rapport de reconnaissance",
	[287398] = "Avis de recherche : Za’roco",
	[287440] = "Avis de recherche : Taz’raka",
	[287441] = "Avis de recherche : éclaireur des sables Vesarik",
	[287442] = "Avis de recherche : participants à l’excursion Cobra",
	[287958] = "Panneau d’affichage",
	[288157] = "Avis de recherche : Yarsel’ghun",
	[288167] = "Paquet de Marie",
	[288214] = "Avis de recherche",
	[288596] = "Cache de secrets",
	[288609] = "Coffre tortollan",
	[288622] = "Avis de recherche",
	[288641] = "Avis de recherche : kidnappeurs de griffons",
	[289310] = "Avis de recherche : garde-terre déchaîné",
	[289313] = "Avis de recherche : le Frelon",
	[289317] = "Algue",
	[289361] = "Avis de recherche : intendant Ssylis",
	[289365] = "Avis de recherche",
	[289521] = "Transposeur des Titans",
	[289647] = "Coffre au trésor abîmé",
	[289728] = "Carte au trésor du capitaine Gulnaku",
	[290127] = "Coffre tortollan",
	[290128] = "Coffre tortollan",
	[290138] = "Bombe anti-robot",
	[290419] = "Avis de recherche",
	[290537] = "Offre d’emploi",
	[290725] = "Richesses de Tor’nowa",
	[290750] = "Réserve jambani",
	[290765] = "Grand tas de pièces d’or",
	[290993] = "Butin des Lamineurs",
	[291143] = "Clé de Ranah",
	[291233] = "Queue de saurolisque",
	[291238] = "Larmes de Bwonsamdi",
	[291241] = "Racine noueuse",
	[291257] = "Petit coffre au trésor",
	[291291] = "Avis de recherche : braconnier",
	[292523] = "Avis de recherche",
	[292673] = "Un parchemin humide",
	[292674] = "Un parchemin humide",
	[292675] = "Un parchemin humide",
	[292676] = "Un parchemin humide",
	[292677] = "Un parchemin humide",
	[292686] = "Autel menaçant",
	[292812] = "Amaraina saphir",
	[292823] = "Ire de Krag’wa",
	[292825] = "Pierrelette",
	[292843] = "Gemme d’acquiescement",
	[293110] = "Pépé’jin",
	[293131] = "Pépé",
	[293134] = "Grande grenade d’azérite",
	[293349] = "Boîte à repas abandonnée",
	[293350] = "Coffre en bois sculpté",
	[293351] = "Truffe",
	[293445] = "Truffe",
	[293446] = "Truffe",
	[293449] = "Truffe",
	[293567] = "Avis de recherche",
	[293568] = "Avis de recherche",
	[293837] = "|cFFFFFFFFÉtape 2:|r Caillou ordinaire I",
	[293838] = "|cFFFFFFFFÉtape 3:|r Caillou ordinaire II",
	[293839] = "|cFFFFFFFFÉtape 4:|r Caillou ordinaire III",
	[293840] = "|cFFFFFFFFÉtape 5:|r Caillou ordinaire IV",
	[293841] = "|cFFFFFFFFÉtape 6:|r Caillou ordinaire V",
	[293842] = "|cFFFFFFFFÉtape 7:|r Caillou ordinaire VI",
	[293843] = "|cFFFFFFFFÉtape 8:|r Caillou ordinaire VII",
	[293844] = "|cFFFFFFFFÉtape 9:|r Caillou ordinaire VIII",
	[293845] = "|cFFFFFFFFÉtape 10:|rCaillou ordinaire IX",
	[293846] = "|cFFFFFFFFÉtape 11:|rCaillou ordinaire X",
	[293849] = "Note mise en évidence",
	[293852] = "Coffre au trésor enfoui",
	[293880] = "Coffre au trésor enfoui",
	[293881] = "Coffre au trésor enfoui",
	[293884] = "Coffre au trésor enfoui",
	[293962] = "Cache de noble précaire",
	[293964] = "Cache de contrebandier oubliée",
	[293965] = "Cache sculptivoire",
	[293985] = "On recherche : Étripeur de guerre",
	[294084] = "Planque à butin du Club des aventuriers",
	[294096] = "Orbe allumé",
	[294097] = "Graine étrange",
	[294098] = "Grenouille minuscule",
	[294099] = "Os fragile",
	[294100] = "Bougie égarée",
	[294101] = "Tasse étrange",
	[294102] = "Rocher intéressant",
	[294103] = "Lys éclos",
	[294104] = "Jolie fleur",
	[294105] = "Vieux livre",
	[294106] = "Poisson mort",
	[294107] = "Planche griffée",
	[294108] = "Anneau perdu",
	[294109] = "Pomme pourrie",
	[294110] = "Dent cassée",
	[294111] = "Heaume usé",
	[294112] = "Feuille charnue",
	[294113] = "Chiffon moisi",
	[294114] = "Tablette brisée",
	[294115] = "Torche cendreuse",
	[294125] = "Ancoracée",
	[294173] = "Coffre de fournitures de la KapitalRisk",
	[294174] = "Coffre oublié",
	[294312] = "Liste d’amis d’Osselet",
	[294314] = "Liste d’ennemis d’Osselet",
	[294315] = "Recette préférée d’Osselet",
	[294316] = "Offrandes perdues de Kimbul",
	[294317] = "Coffre du Bois mort",
	[294319] = "Trésor enfoui dans le sable",
	[294335] = "Patate pourrie",
	[294703] = "Coffret rouillé d’Osselet",
	[296252] = "Boîte de grandes grenades d’azérite",
	[296479] = "Cantine de l’amiral suprême",
	[296536] = "Glaive de sentinelle ensanglanté",
	[296573] = "Lame rouillée de Jason",
	[296574] = "Bouteille vide de Ian",
	[296575] = "Assiette ébréchée de Julie",
	[296579] = "Boussole cassée de Brian",
	[296580] = "Journal relié d’Ofer",
	[296581] = "Caillou préféré de Skye",
	[296582] = "Botte gauche de Julien",
	[296583] = "Flacon de Navarro",
	[296584] = "Gourde de Zach",
	[296585] = "Sac à dos de Damarcus",
	[296586] = "Flûte de Rachel",
	[296587] = "Croc en collier de Josh",
	[296588] = "Portrait du commandant Martens",
	[296589] = "Clé ornée de Kurt",
	[296854] = "Parchemin d’eaugure ancien",
	[296855] = "Truffe",
	[296902] = "Parchemin d’eaugure ancien",
	[296903] = "Parchemin d’eaugure ancien",
	[296904] = "Parchemin d’eaugure ancien",
	[296905] = "Parchemin d’eaugure ancien",
	[296906] = "Parchemin d’eaugure ancien",
	[296907] = "Parchemin d’eaugure ancien",
	[296908] = "Parchemin d’eaugure ancien",
	[296915] = "Stèle drust : le cercle",
	[296916] = "Stèle drust : le rituel",
	[296917] = "Stèle drust : l’arbre",
	[296918] = "Stèle drust : souffle de pierre",
	[297069] = "Penderie",
	[297071] = "Petit sac de pièces",
	[297074] = "Contes des Loas : Gral",
	[297485] = "Contes des Loas : Sephraliss",
	[297489] = "Contes des Loas : Krag’wa",
	[297490] = "Contes des Loas : Rezan",
	[297491] = "Contes des Loas : Bwonsamdi",
	[297492] = "Panneau d’affichage",
	[297493] = "Contes des Loas : Shadra",
	[297494] = "Contes des Loas : Kimbul",
	[297495] = "Contes des Loas : Akunda",
	[297521] = "Contes des Loas : Gonk",
	[297522] = "Contes des Loas : Hir’eek",
	[297523] = "Contes des Loas : Torga",
	[297524] = "Contes des Loas : Pa’ku",
	[297528] = "Contes des Loas : Jani",
	[297627] = "Stèle drust : sacrifice",
	[297628] = "Stèle drust : assemblages",
	[297629] = "Stèle drust : le cycle",
	[297630] = "Stèle drust : conflit",
	[297631] = "Stèle drust : l’homme écorché",
	[297632] = "Stèle drust : protecteurs de la forêt",
	[297700] = "Contes des Loas : Zandalar",
	[297825] = "Coffre couvert de toiles d’araignée",
	[297828] = "Coffre de marchand",
	[297878] = "Coffre maléficié",
	[297879] = "Coffre ensorcelé",
	[297880] = "Coffre envoûté",
	[297881] = "Coffre enchanté",
	[297885] = "Contes des Loas : Torcali",
	[297891] = "Cache runeliée",
	[297892] = "Coffre runelié",
	[297893] = "Malle runeliée",
	[297905] = "Chansonnier de Jay",
	[297906] = "Chansonnier de Russel",
	[297933] = "Chansonnier poussiéreux",
	[297934] = "Chansonnier de brigand",
	[297939] = "Arbalète de l’Ordre des Braises",
	[297940] = "Couteau de l’Ordre des Braises",
	[297941] = "Chapeau de l’Ordre des Braises",
	[297942] = "Flacon de l’Ordre des Braises",
	[298766] = "Vieille arbalète",
	[298767] = "Vieux couteau",
	[298768] = "Vieille flasque",
	[298769] = "Vieux chapeau",
	[298778] = "Avis de recherche",
	[298849] = "Avis de recherche",
	[298920] = "Cache parlépine pillée",
	[298921] = "Tablette nazmani antique",
	[298963] = "Tablette nazmani dégradée par les intempéries",
	[298965] = "Tablette craquelée",
	[299073] = "Tablette fracturée",
	[303016] = "|cFFFFFFFFÉtape 14:|r Caillou ordinaire XIII",
	[303017] = "|cFFFFFFFFÉtape 13:|r Caillou ordinaire XII",
	[303018] = "|cFFFFFFFFÉtape 12:|r Caillou ordinaire XI",
	[303039] = "Sac de grain étrange",
	[307091] = "Dague aux murmures inquiétants",
	[307265] = "Avis de recherche",
	[307277] = "Vieille cruche",
	[307307] = "Tonneau cassé",
	[307325] = "Avis de recherche",
	[307330] = "Cantine du capitaine",
	[307340] = "Coffre verrouillé",
	[307748] = "Lettre de la KapitalRisk",
	[307836] = "Minerai du Crépuscule",
	[309498] = "Présentoir à armure",
	[310600] = "Tome kaldorei ancien",
	[310601] = "Bride de sabre-de-nuit abandonnée",
	[310603] = "Arc de la grande prêtresse",
	[310709] = "Coffre détrempé",
	[310736] = "Caisse de minerai",
	[311155] = "Tablette antique",
	[311218] = "Xal’atath, lame de l’Empire noir",
	[311822] = "Brouilleur de robots",
	[311902] = "Pièces détachées",
	[311903] = "Pièces détachées",
	[313446] = "Débris de l’Aube argentée",
	[313447] = "Débris de l’Aube argentée",
	[313448] = "Débris de l’Aube argentée",
	[316443] = "Xal’atath, lame de l’Empire noir",
	[316792] = "Minerai de fer chapardé",
	[316863] = "Relique zandalari perdue",
	[319222] = "Cache de Sombrivage",
	[320514] = "Cache de Sombrivage",
	[320515] = "Cache de Sombrivage",
	[320516] = "Cache de Sombrivage",
	[320517] = "Cache de Sombrivage",
	[320518] = "Cache de Sombrivage",
	[322020] = "Tas de pièces",
	[322066] = "Accumulateur tellurique",
	[322413] = "Coffre scintillant",
	[322533] = "Grimoire des éléments de Mardivas",
	[322791] = "Baie de varech",
	[322803] = "Baie de varech",
	[324407] = "Racines du Vide",
	[325659] = "Coffre mécanisé",
	[325660] = "Coffre mécanisé",
	[325661] = "Coffre mécanisé",
	[325662] = "Coffre mécanisé",
	[325663] = "Coffre mécanisé",
	[325664] = "Coffre mécanisé",
	[325665] = "Coffre mécanisé",
	[325666] = "Coffre mécanisé",
	[325667] = "Coffre mécanisé",
	[325668] = "Coffre mécanisé",
	[325759] = "Palourde imprégnée de mana",
	[325795] = "Coffre englouti",
	[325853] = "Bibliothèque vide",
	[325869] = "Fût vide",
	[325873] = "Riche gisement d’osménite",
	[325874] = "Veine d’osménite",
	[325875] = "Gisement d’osménite",
	[325894] = "Cache des Arcanes",
	[325954] = "Carte au trésor illisible",
	[326026] = "Cache du Vide",
	[326027] = "Recyclériseur DX-82",
	[326047] = "Cache renforcée",
	[326140] = "Tableau de récompense",
	[326141] = "Tableau de récompense",
	[326142] = "Tableau de récompense",
	[326148] = "Plans d’attaque nagas",
	[326394] = "Coffre arcanique",
	[326395] = "Malle arcanique luisante",
	[326396] = "Malle arcanique luisante",
	[326397] = "Malle arcanique luisante",
	[326398] = "Malle arcanique luisante",
	[326399] = "Malle arcanique luisante",
	[326400] = "Malle arcanique luisante",
	[326401] = "Coffre arcanique",
	[326402] = "Coffre arcanique",
	[326403] = "Coffre arcanique",
	[326404] = "Coffre arcanique",
	[326405] = "Coffre arcanique",
	[326406] = "Coffre arcanique",
	[326407] = "Coffre arcanique",
	[326408] = "Coffre arcanique",
	[326409] = "Coffre arcanique",
	[326410] = "Coffre arcanique",
	[326411] = "Coffre arcanique",
	[326412] = "Coffre arcanique",
	[326413] = "Coffre arcanique",
	[326414] = "Coffre arcanique",
	[326415] = "Coffre arcanique",
	[326416] = "Coffre arcanique",
	[326417] = "Coffre arcanique",
	[326418] = "Coffre arcanique",
	[326419] = "Coffre arcanique",
	[326588] = "Cache d’armes azéritiques",
	[326594] = "Tome des Arcanes",
	[326598] = "Zin’anthide",
	[327170] = "Râtelier d’armes",
	[327221] = "Fût de baies de varech",
	[327230] = "Dépôt de gelée",
	[327407] = "Planque ogre précieuse",
	[327516] = "Dépôt de gelée",
	[327548] = "Plans de bloc d’alimentation",
	[327568] = "Coffre de pirates",
	[327569] = "Coffre de pirates",
	[327570] = "Coffre de pirates",
	[327585] = "Tableau de récompense",
	[327591] = "Journal en bon état",
	[327592] = "Verrou enchanté",
	[327596] = "Focalisateur abyssal endommagé",
	[327597] = "Vieux coffre rouillé",
	[327650] = "Coffre de fournitures de guerre",
	[327652] = "Coffre de fournitures de guerre",
	[327669] = "Elémenbière contenu",
	[328343] = "Rouage navrebière",
	[328413] = "Totem hozen",
	[329641] = "Avis de recherche : Cachal et Troggeur",
	[329715] = "Pièces disparates utiles",
	[329783] = "Malle arcanique luisante",
	[329805] = "Cristal étrange",
	[329918] = "Trésors hurans",
	[329919] = "Fournitures volées",
	[330168] = "Elémenbière contenu",
	[330169] = "Rouage navrebière",
	[330170] = "Totem hozen",
	[330183] = "Coffret des Lamineurs",
	[330627] = "Panneau d’avertissement",
	[332220] = "Malle arcanique luisante",
	[332568] = "Figurine de chat en cristal",
	[332569] = "Figurine de chat en cristal",
	[332570] = "Figurine de chat en cristal",
	[332571] = "Figurine de chat en cristal",
	[332572] = "Figurine de chat en cristal",
	[332573] = "Figurine de chat en cristal",
	[332574] = "Figurine de chat en cristal",
	[332575] = "Figurine de chat en cristal",
	[332576] = "Figurine de chat en cristal",
	[334216] = "Cache de l’Empire noir",
	[334220] = "Cache de l’Empire noir",
	[335655] = "Bras d’Oonar",
	[336415] = "Parchemin abandonné",
	[337237] = "Caveau perdu",
	[337241] = "Réserve d’équipement",
	[338520] = "Champignon fangenuit",
	[339211] = "Assiette vide",
	[339243] = "Coffre-fort infesté",
	[339248] = "Cache infestée",
	[339249] = "Cache infestée",
	[339250] = "Cache infestée",
	[339283] = "Coffre de noble oublié",
	[339601] = "Parchemin des éons",
	[339625] = "Don de Sophia",
	[339641] = "Breuvage purificateur",
	[339770] = "Coffre au trésor abandonné",
	[339837] = "Sac de poudre",
	[339869] = "Coffre de la Conservatrice",
	[341416] = "Chaîne de herse de caveau",
	[341424] = "Souvenirs oubliés",
	[342098] = "Nécessaire de rasage de précision de Coiffeboucle",
	[343611] = "Œuf touché par le Vide",
	[343698] = "Crâne touché par le Vide",
	[344588] = "Ragoût ragoûtant du régisseur",
	[344726] = "Sermon sombre",
	[345446] = "Grande corne du cerf runique",
	[345455] = "Coffre de fournitures pour assemblage",
	[345456] = "Coffre de la maison des Yeux",
	[345458] = "Sac de récompenses",
	[347444] = "Bouclier d’os orné",
	[348521] = "Étrange excroissance",
	[348558] = "Avertissement",
	[348676] = "Carreau de baliste",
	[348747] = "Parchemin boueux",
	[349515] = "Journal endommagé",
	[349565] = "Coffre des rêves envieux",
	[349612] = "Avis de recherche : expert Vix",
	[349792] = "Trophée de chapardeur",
	[349793] = "Butin de voyageur abandonné",
	[349794] = "Cache de Remlate",
	[349795] = "Paquet d’âme en fuite",
	[349796] = "Coffre de la prune d’or",
	[349797] = "Bibelots abandonnés",
	[349798] = "Cache clandestine",
	[350802] = "Coffre scellé par de la toile",
	[350804] = "Harpe cassée",
	[350972] = "Chaîne de herse de cellule",
	[350978] = "Cache du jardin d’hiver de la Reine",
	[351467] = "Épitaphe effacée",
	[351487] = "Trésor secret",
	[351540] = "Trésor secret",
	[351541] = "Trésor secret",
	[351542] = "Trésor secret",
	[351543] = "Trésor secret",
	[351544] = "Trésor secret",
	[351545] = "Trésor secret",
	[351874] = "Avis de recherche : massacreur Kristof",
	[351885] = "Avis de recherche : Concrétion de fatalité",
	[351886] = "Avis de recherche : duc Anton",
	[351887] = "Avis de recherche : seigneur Darion",
	[351888] = "Avis de recherche : invocateur Marcélis",
	[351889] = "Avis de recherche : le Fléau blafard",
	[351948] = "Coffre oublié",
	[351980] = "Fournitures égarées",
	[352027] = "Avis de recherche",
	[352028] = "Avis de recherche",
	[352086] = "Cache de Noir-Mâtin",
	[352181] = "Baguette pour spriggans",
	[352182] = "Arme d’hast pour spriggans",
	[352428] = "Bourdon des vertus",
	[352433] = "Cache des Yeux",
	[352490] = "Rejoignez la rébellion !",
	[352520] = "Médaillon de l’orgueil",
	[352596] = "Pousse germée",
	[352703] = "La Moisson",
	[352754] = "Coffre renforcé en argent",
	[352909] = "Écaille de luisaileron",
	[353019] = "Coffre renforcé en argent",
	[353205] = "Coffre renforcé en argent",
	[353231] = "Coffre os-lié",
	[353232] = "Coffre du bois morne",
	[353233] = "Coffre enchanté",
	[353234] = "Coffre doré",
	[353252] = "Coffre renforcé en argent",
	[353305] = "Maillet brise-pierres",
	[353306] = "Bogue putréfiée",
	[353314] = "Coffre renforcé en argent",
	[353323] = "Bogue putréfiée",
	[353324] = "Bogue putréfiée",
	[353325] = "Coffre renforcé en argent",
	[353326] = "Bogue putréfiée",
	[353327] = "Bogue putréfiée",
	[353329] = "Planque féerique",
	[353330] = "Planque féerique",
	[353331] = "Planque féerique",
	[353332] = "Planque féerique",
	[353333] = "Planque féerique",
	[353340] = "Livre poussiéreux",
	[353380] = "Casse-croûte d’Halis",
	[353472] = "Épée radieuse",
	[353484] = "La grande chambre-forte",
	[353500] = "Coffre renforcé en argent",
	[353503] = "Coffre renforcé en argent",
	[353516] = "Coffre renforcé en argent",
	[353626] = "Boîte à outils verrouillée",
	[353627] = "Rations de la Ligne de front",
	[353643] = "Coffre renforcé en argent",
	[353645] = "Journal de Marileth",
	[353650] = "Coffre doré du régisseur",
	[353681] = "Cosse de lumilune",
	[353683] = "Cosse de lumilune",
	[353684] = "Cosse de lumilune",
	[353685] = "Cosse de lumilune",
	[353686] = "Cosse de lumilune",
	[353687] = "Cloche brisée",
	[353688] = "Cloche brisée",
	[353689] = "Cloche brisée",
	[353691] = "Cloche aérienne",
	[353791] = "Coffre-fort du château",
	[353792] = "Coffre-fort du village",
	[353793] = "Coffre paroissial",
	[353796] = "Reliquaire du souvenir",
	[353797] = "Fournitures de la Légion de pierre",
	[353799] = "Sac de brisespoir",
	[353868] = "Trésor caché",
	[353869] = "Trésor caché",
	[353870] = "Trésor caché",
	[353871] = "Trésor caché",
	[353872] = "Trésor caché",
	[353873] = "Trésor caché",
	[353874] = "Gland d’anima",
	[353876] = "Vertu de pénitence",
	[353940] = "Don de Vésiphone",
	[353941] = "Don de Chyrus",
	[353942] = "Don d’Agthia",
	[353943] = "Don de Thénios",
	[353944] = "Don de Déva",
	[353948] = "Médaillon du désir",
	[353949] = "Médaillon de l’avarice",
	[354075] = "Parchemin vierge",
	[354108] = "Sacoche vive-pierre",
	[354109] = "Sacoche vive-pierre",
	[354110] = "Sacoche vive-pierre",
	[354111] = "Sacoche vive-pierre",
	[354112] = "Sacoche vive-pierre",
	[354113] = "Sacoche vive-pierre",
	[354114] = "Sacoche vive-pierre",
	[354115] = "Trophée de pugiliste",
	[354116] = "Trophée de pugiliste",
	[354121] = "Trophée de pugiliste",
	[354122] = "Trophée de pugiliste",
	[354123] = "Trophée de pugiliste",
	[354175] = "Cache des transcendés",
	[354186] = "Sacoche vive-pierre",
	[354187] = "Sacoche vive-pierre",
	[354188] = "Sacoche vive-pierre",
	[354189] = "Sacoche vive-pierre",
	[354190] = "Sacoche vive-pierre",
	[354191] = "Sacoche vive-pierre",
	[354192] = "Sacoche vive-pierre",
	[354193] = "Sacoche vive-pierre",
	[354202] = "Réserves abandonnées",
	[354208] = "Équipement volé",
	[354211] = "Récompense de la cupidité",
	[354213] = "Notes du disciple disparu",
	[354214] = "Harnais de dresseur de volion",
	[354275] = "Pièce d’assemblage expérimental",
	[354283] = "L’héritage de Mercia : chapitre I",
	[354284] = "L’héritage de Mercia : chapitre II",
	[354285] = "L’héritage de Mercia : chapitre III",
	[354286] = "L’héritage de Mercia : chapitre IV",
	[354287] = "L’héritage de Mercia : chapitre V",
	[354288] = "L’héritage de Mercia : chapitre VI",
	[354289] = "Outils de Forgevent",
	[354467] = "L’héritage de Mercia : chapitre VII",
	[354645] = "Sacoche perdue",
	[354646] = "Œuf de plume-des-nuées ancien",
	[354647] = "Plume de dragon vigoureuse",
	[354648] = "Fournitures sombres-confins",
	[354649] = "Cache de reliques",
	[354650] = "Cœur chanterêve",
	[354651] = "Capturêve enchanté",
	[354652] = "Trésor féerique",
	[354662] = "Cache féerique insaisissable",
	[354852] = "Pousse germée",
	[354853] = "Pousse germée",
	[354856] = "Caisse couverte de vase",
	[354911] = "Graine d’anima gonflée",
	[355000] = "Cache de la Nuit",
	[355019] = "Soie onirique brute",
	[355020] = "Rameau enchanté",
	[355021] = "Ornement faë",
	[355035] = "Malle runique des Élus",
	[355037] = "Malle runeliée",
	[355038] = "Malle runeliée",
	[355040] = "Rune des Rituels",
	[355041] = "Cache de la Lune",
	[355048] = "Rune des Rituels",
	[355049] = "Rune des Rituels",
	[355194] = "Rune des Assemblages",
	[355195] = "Rune des Assemblages",
	[355196] = "Rune des Assemblages",
	[355286] = "Offrandes du souvenir",
	[355296] = "Prime : régulation de la faune",
	[355355] = "Coffre harmonique",
	[355435] = "Bourdon du Vent d’argent",
	[355449] = "Don du Vent d’argent",
	[355865] = "Cuve de gelée voyante",
	[355872] = "Bocal volé",
	[355880] = "Le Nécronom-i-miam",
	[355886] = "Coffre de la peste",
	[355947] = "Planque de Glutharn",
	[355971] = "Glaive vive-pierre",
	[355980] = "Cache du ritualiste",
	[356535] = "Trésor du parle-runes",
	[356555] = "Collier d’Eurydéa",
	[356693] = "Tribut extravagant de la baronne Vashj",
	[356697] = "Tribut extravagant d’Alexandros Mograine",
	[356700] = "Tribut extravagant du grand maître Vole",
	[356705] = "Tribut extravagant de Marileth, catalyseur de peste",
	[356709] = "Tribut extravagant de dame Baie-de-Lune",
	[356712] = "Tribut extravagant du capitaine de l’Hallali Korayn",
	[356716] = "Tribut extravagant de la dromane Aliothe",
	[356720] = "Tribut extravagant de Choufa",
	[356725] = "Tribut extravagant du marchedroit Adrestès",
	[356728] = "Tribut extravagant de Mikanikos",
	[356733] = "Tribut extravagant de Kléia et Pélagos",
	[356737] = "Tribut extravagant de Sika",
	[356741] = "Tribut extravagant de la comtesse",
	[356744] = "Tribut extravagant de Rondel et Férul",
	[356748] = "Tribut extravagant de Tête-de-Caillasse",
	[356752] = "Tribut extravagant du gardien de la crypte Kassir",
	[356757] = "Désir de l’avidité",
	[356818] = "Pénitence de la pureté",
	[356820] = "Grande cosse de lumilune",
	[356823] = "Coffre de marche-nuage",
	[357228] = "Coffre oublié",
	[357229] = "Coffre oublié",
	[357230] = "Coffre oublié",
	[357231] = "Coffre oublié",
	[357232] = "Coffre oublié",
	[357233] = "Coffre oublié",
	[357234] = "Coffre oublié",
	[357235] = "Coffre oublié",
	[357236] = "Coffre oublié",
	[357237] = "Coffre oublié",
	[357238] = "Coffre oublié",
	[357246] = "Parchemin en lambeaux",
	[357467] = "Encre interdite",
	[357487] = "Parasol élégant",
	[357515] = "Sac d’avoine",
	[357526] = "Seau d’eau vide",
	[357541] = "Fer à cheval abandonné",
	[357565] = "Canne à pêche oubliée",
	[357572] = "Rapière de l’intrépide",
	[357584] = "Glaive-d’effroi de Vrytha",
	[357683] = "Tourbière de fortune de paria",
	[357697] = "Trésor du sous-chef",
	[357726] = "Lance brisée",
	[357758] = "Tonneau de peste",
	[357771] = "Cache enfouie",
	[357937] = "Cache enfouie",
	[358298] = "Coffre de la chambre Interdite",
	[358315] = "Fragments de main squelettique",
	[358318] = "Portrait purotin de R. Suavel",
	[358319] = "Message de l’ensorceleur",
	[358382] = "Avis de recherche : Chélicère",
	[358398] = "Journal perdu",
	[358399] = "Sac de six lieues",
	[358531] = "Cache géante de trésors épiques",
	[358533] = "Fournitures oubliées",
	[358855] = "Sac à dos de chute amortie endommagé",
	[360054] = "Chat collant",
	[362489] = "Décret élyséen",
	[364345] = "Graine faiblement luminescente",
	[364483] = "Fût de pousse-café vide",
	[364899] = "Stygies cristallisées",
	[364926] = "Entraves runeforgées",
	[364932] = "Lingot incandescent",
	[364937] = "Siphonneur phasique",
	[364987] = "Journal de négociant",
	[364994] = "Pioche spectrale",
	[365084] = "Pique de tourmenteur",
	[365093] = "Livres de chants festifs de Théotar",
	[368205] = "Cache antrelige",
	[368206] = "Cache antrelige",
	[368207] = "Cache antrelige",
	[368208] = "Cache antrelige",
	[368213] = "Cache antrelige",
	[368214] = "Cache antrelige",
	[368347] = "Cache secrète de la faille",
	[368645] = "Cache secrète de la faille",
	[368646] = "Cache secrète de la faille",
	[368648] = "Cache secrète de la faille",
	[368649] = "Cache secrète de la faille",
	[368650] = "Cache secrète de la faille",
	[368653] = "Cage à wyrm d’éther",
	[368663] = "Main droite de Tit’Abom",
	[368665] = "Bras de rechange de Tit’Abom",
	[368666] = "Tête de Tit’Abom",
	[368667] = "Torse de Tit’Abom",
	[368668] = "Tronc de Tit’Abom",
	[368772] = "Parchemin scellé",
	[368876] = "Cache antrelige",
	[368935] = "Cage à hurleuse de Tombe-Vice",
	[368946] = "Réceptacle d’anima volé",
	[368948] = "Réceptacle d’anima volé",
	[368949] = "Réceptacle d’anima volé",
	[368950] = "Réceptacle d’anima volé",
	[368951] = "Réceptacle d’anima volé",
	[368952] = "Réceptacle d’anima volé",
	[368953] = "Réceptacle d’anima volé",
	[369129] = "Bague en or de Nilganihmaht",
	[369132] = "Coffre scellé par la domination",
	[369133] = "Sceau de domination #1",
	[369134] = "Cage scellée par la domination",
	[369135] = "Sceau de domination #2",
	[369138] = "Sceau de domination du coffre",
	[369141] = "Cache antrelige",
	[369143] = "Anneau ancien morcelé",
	[369144] = "Trousseau de clés de la Persécutrice",
	[369145] = "Cache de fournitures de Helgarde",
	[369148] = "Matériau de nid scintillant",
	[369149] = "Plume oubliée",
	[369172] = "Souvenir perdu",
	[369183] = "Nid déplacé",
	[369185] = "Boîte à reliques korthienne",
	[369194] = "Œuf chargé d’anima",
	[369204] = "Relique déplacée",
	[369216] = "Coffre ligenfer",
	[369224] = "Cœur minéral d’Ezekiel",
	[369225] = "Vestiges contaminés",
	[369227] = "Réceptacle d’anima volé",
	[369232] = "Boîte d’offrandes",
	[369234] = "Clé des offrandes",
	[369235] = "Réceptacle d’anima volé",
	[369236] = "Réceptacle d’anima volé",
	[369245] = "Boîte à reliques korthienne",
	[369292] = "Cache à relique",
	[369294] = "Cache à relique",
	[369295] = "Pile d’ossements",
	[369296] = "Cachette de cuirasaure",
	[369297] = "Pile d’ossements",
	[369304] = "Boîte à reliques korthienne",
	[369327] = "Champignantre envahissant",
	[369329] = "Champignantre envahissant",
	[369330] = "Champignantre envahissant",
	[369331] = "Champignantre envahissant",
	[369332] = "Champignantre envahissant",
	[369333] = "Tas de matériaux inhabituels",
	[369334] = "Tas de matériaux inhabituels",
	[369335] = "Tas de matériaux inhabituels",
	[369336] = "Tas de matériaux inhabituels",
	[369337] = "Tas de matériaux inhabituels",
	[369339] = "Cache antrelige",
	[369340] = "Boîte à reliques korthienne",
	[369341] = "Cache antrelige",
	[369432] = "Tome venthyr égaré",
	[369437] = "Cache liée à la faille",
	[369438] = "Cache liée à la faille",
	[369439] = "Cache liée à la faille",
	[369440] = "Cache liée à la faille",
	[369602] = "Mains de la défiance",
	[369757] = "Coffre submergé",
	[369893] = "Missive urgente",
	[369894] = "Missive urgente",
	[370140] = "Butin jiro endommagé",
	[370469] = "Céréales spectrales",
	[370494] = "Cache toccatienne",
	[373437] = "Banc de poissons-blob âcres",
	[373438] = "Liane serre-pelote",
	[373439] = "Banc de nectalies",
	[373460] = "Filet faë",
	[373471] = "Cache mezzonique",
	[373472] = "Cache glissandienne",
	[373473] = "Cache fuguéale",
	[373474] = "Cache cantabilienne",
	[373543] = "Caveau de la bibliothèque",
	[373548] = "Modèle d’archive",
	[373553] = "Téléporteur",
	[373561] = "Proto-chambre oubliée",
	[373562] = "Harmonique fébrile",
	[373563] = "Harmonique changeant",
	[373568] = "Cache verrouillée de Provis",
	[373579] = "Découverte d’œil indiscret",
	[373580] = "Harmonique serein",
	[373581] = "Harmonique fébrile",
	[373582] = "Harmonique changeant",
	[373583] = "Harmonique serein",
	[373584] = "Harmonique fébrile",
	[373585] = "Harmonique changeant",
	[373586] = "Harmonique serein",
	[373587] = "Harmonique fébrile",
	[373588] = "Harmonique changeant",
	[374976] = "Caveau symphonique",
	[375021] = "Automa défunt",
	[375058] = "Cache toccatienne",
	[375059] = "Cache mezzonique",
	[375060] = "Cache glissandienne",
	[375061] = "Cache fuguéale",
	[375062] = "Cache cantabilienne",
	[375064] = "Cache toccatienne",
	[375066] = "Cache mezzonique",
	[375067] = "Cache glissandienne",
	[375068] = "Cache fuguéale",
	[375069] = "Cache cantabilienne",
	[375188] = "Agencement de l’alcôve Concave",
	[375189] = "Agencement de l’alcôve du Répertoire",
	[375190] = "Agencement de l’alcôve Incurvée",
	[375191] = "Agencement de l’alcôve Dormante",
	[375192] = "Agencement de l’alcôve Aveuglante",
	[375234] = "Gisement de draconium durci",
	[375235] = "Gisement de draconium fondu",
	[375238] = "Gisement de draconium touché par les Titans",
	[375239] = "Gisement de draconium primordial",
	[375240] = "Gisement de draconium ardent",
	[375241] = "Pavot à bulle",
	[375242] = "Pavot à bulle touché par les Titans",
	[375243] = "Pavot à bulle ardent",
	[375244] = "Pavot à bulle algide",
	[375245] = "Pavot à bulle balayé par le vent",
	[375246] = "Pavot à bulle décomposé",
	[375270] = "Schéma de protoforme",
	[375272] = "Cache antrelige",
	[375281] = "Relique volée",
	[375283] = "Matrice de percolation",
	[375290] = "Coffre lié par un cryptogramme",
	[375354] = "Cache de domination",
	[375362] = "Nid d’oiseau",
	[375363] = "Coffre de fournitures antreliges",
	[375366] = "Œufs de tarachnidé",
	[375368] = "Console de catalyseur de création",
	[375369] = "Malle rongée",
	[375370] = "Schéma de protoforme",
	[375371] = "Schéma de protoforme",
	[375373] = "Débris d’Automa abandonné",
	[375376] = "Caveau déchu",
	[375382] = "Caisse de fournitures écrasée",
	[375383] = "Schéma de protoforme",
	[375387] = "Schéma de protoforme",
	[375388] = "Schéma de protoforme",
	[375389] = "Schéma de protoforme",
	[375390] = "Schéma de protoforme",
	[375391] = "Schéma de protoforme",
	[375393] = "Schéma de protoforme",
	[375396] = "Tas de sable irrégulier",
	[375397] = "Tas de sable luisant",
	[375398] = "Tas de sable changeant",
	[375399] = "Tas de sable bourdonnant",
	[375400] = "Tas de sable difforme",
	[375401] = "Tas de sable étincelant",
	[375402] = "Tas de sable cliquetant",
	[375403] = "Relique couverte de pulpe",
	[375404] = "Coffre érodé",
	[375405] = "Artéfact chipé",
	[375408] = "Réserve de l’architecte",
	[375411] = "Ovoïde incorrect",
	[375413] = "Fournitures de négociant noyé",
	[375422] = "Protofruit surdimensionné",
	[375423] = "Offrande aux Fondateurs",
	[375478] = "Extracteur de proto-minerai",
	[375479] = "Schéma de protoforme",
	[375481] = "Bibelot chapardé",
	[375483] = "Parchemin volé",
	[375484] = "Bénédiction de reconnaissance",
	[375485] = "Moissonneur de protoflore",
	[375486] = "Schéma de protoforme",
	[375492] = "Coffre syntaxique",
	[375493] = "Proto-poire mûre",
	[375494] = "Cache incurvée",
	[375495] = "Feuillage ondulant",
	[375496] = "Boisseau de denrées des Progéniteurs",
	[375498] = "Schéma de protoforme",
	[375502] = "Schéma de protoforme",
	[375516] = "Rayon de miel égaré",
	[375517] = "Tas de gravats suspect",
	[375530] = "Salle du trésor oubliée",
	[375536] = "Cache piégée de Xy’rath",
	[375538] = "Ovoïde perdu",
	[375668] = "Coffre au trésor brumeux",
	[375693] = "Schéma de protoforme",
	[375694] = "Schéma de protoforme",
	[375746] = "Schéma de prototype",
	[375748] = "Schéma de protoforme",
	[375889] = "Schéma de protoforme",
	[375893] = "Cache précieuse",
	[375900] = "Schéma de protoforme",
	[375902] = "Drapé éthérien déchiré",
	[375903] = "Schéma de protoforme",
	[375905] = "Schéma de protoforme",
	[375907] = "Schéma de protoforme",
	[375915] = "Lueur de sérénité",
	[375950] = "Babiole d’innovation pure",
	[375972] = "On recherche : Custos",
	[375973] = "L’exil de Firim, 1re partie",
	[375974] = "Écho du premier chant cristallisé",
	[375981] = "Schéma de protoforme",
	[375982] = "L’exil de Firim, 2e partie",
	[375983] = "L’exil de Firim, 3e partie",
	[375984] = "L’exil de Firim, 4e partie",
	[375985] = "L’exil de Firim, 5e partie",
	[375986] = "L’exil de Firim, 6e partie",
	[375987] = "L’exil de Firim, 7e partie",
	[375988] = "L’exil de Firim, épilogue",
	[376041] = "Cache cryptique dissimulée",
	[376124] = "Sac de vents enchantés",
	[376175] = "Coffre de fournitures des Gréements",
	[376213] = "Baguette mystérieuse",
	[376325] = "Si près et pourtant si loin",
	[376386] = "Terre retournée",
	[376426] = "Coffre lié par magie",
	[376451] = "Chronomètre de bronze",
	[376578] = "Coffre des Titans",
	[376580] = "Cache djaradine",
	[376581] = "Coffre clanique",
	[376582] = "Coffre rohart",
	[376583] = "Coffre couvert de putréfaction",
	[376587] = "Paquetage d’éclaireur de l’expédition",
	[376657] = "Monument ancien",
	[376757] = "ON RECHERCHE : Frigellus",
	[377114] = "Bobine de corde lourde",
	[377233] = "Coffre au trésor mal caché d’Hessethiash",
	[377458] = "Râtelier d’armes abandonné",
	[377485] = "Pomme aigre",
	[377499] = "De l’Origine des espèces draconiques",
	[377534] = "Coffre-fort livré",
	[377899] = "Otage bufflacien caché",
	[377900] = "Lance de guerre nokhud",
	[377938] = "Banc de bondisseurs prismatiques",
	[378010] = "Trésor draconique oublié",
	[378047] = "Coffret d’émeraude",
	[378054] = "Bière des baïnes",
	[378088] = "Fleur cristalline",
	[378820] = "Punch moussboum",
	[378857] = "Cache d’obsidienne perdue",
	[379248] = "Gisement de draconium",
	[379252] = "Gisement de draconium",
	[379263] = "Riche gisement de draconium",
	[379267] = "Riche gisement de draconium",
	[379272] = "Filon de draconium",
	[379290] = "Statue ornementale",
	[379296] = "Bande brisée",
	[379297] = "Piquette bam-boum",
	[379314] = "Filet de pêche plein",
	[379321] = "Trace de patte mystérieuse",
	[380429] = "Griffe d’or",
	[380430] = "Fragment de queue",
	[380457] = "Chaudron de putréfaction expérimental",
	[380516] = "Lueur de sagesse",
	[380533] = "Parchemin couvert de neige",
	[380540] = "Statue ornementale",
	[380545] = "Beau joyau du peintre",
	[380547] = "Huile de tannage imprégnée de putréfaction",
	[380548] = "Boîte à bijoux oubliée",
	[380549] = "Rouleau de tissu bleu intriguant",
	[380550] = "Tome de l’apprenti étourdi",
	[380554] = "Tambour dansant",
	[380556] = "Coffre harmonique",
	[380559] = "Potion forgegivre",
	[380560] = "Bobine Tesla neutralisée",
	[380567] = "Huit d’Orages",
	[380569] = "Lacis cristallin",
	[380570] = "Glyphe étrange",
	[380571] = "Roquette boumthyr",
	[380577] = "Malygite noble",
	[380578] = "L’art d’élever un jeune dragonnet",
	[380579] = "Outils de rechange djaradins",
	[380580] = "Graine imprégnée de lave",
	[380583] = "Couverture fougerobe putréfiée",
	[380585] = "Amas éruptif d’alexstraszite",
	[380586] = "Chaudrons mystérieux",
	[380587] = "Caisse de peaux traitées",
	[380588] = "Bannière du Vol de bronze miniature",
	[380589] = "Restes légèrement enchantés",
	[380590] = "Tasse bien isolée",
	[380591] = "Trésor jalousement gardé",
	[380592] = "Corne tempétueuse",
	[380593] = "Sac d’écailles putréfiées",
	[380595] = "Parchemin gelé",
	[380597] = "Couverture de centaure aguerri",
	[380598] = "Coffre roussi",
	[380600] = "Éclat de terre enrichi",
	[380601] = "Carte de Sombrelune poussiéreuse",
	[380602] = "Peau bénie par le vent",
	[380604] = "Bannière mystérieuse",
	[380605] = "Décoction de contrebande",
	[380607] = "Tissu itinérant roussi",
	[380610] = "Rune de terre vibrante",
	[380611] = "Gourde d’eau suspecte",
	[380612] = "Fiche sur la langue des signes",
	[380615] = "Sac de braconnage",
	[380616] = "Petit panier de poudre d’eau-de-feu",
	[380617] = "Diagramme d’arme qalashi",
	[380618] = "Flux draconique",
	[380619] = "Lingots étranges",
	[380620] = "Éclats de lance antique",
	[380623] = "Pince touchée par la magie",
	[380643] = "Parchemin surgelé",
	[380647] = "Tome des Arcanes oublié",
	[380648] = "Livre étrange",
	[380652] = "Sphère titanesque fracturée",
	[380653] = "Cerf-volant de Yennu",
	[380654] = "Pansière du Mort",
	[380709] = "Dessins de gantelets de fauconnerie",
	[380763] = "Rouet tisse-dragon ancien",
	[380822] = "Gemme ignée",
	[380840] = "Sac de monte déchiré",
	[380842] = "Pièce d’or",
	[380843] = "Poisson en caoutchouc",
	[380847] = "Amas d’émeraudes",
	[380859] = "Bateau jouet rohart",
	[380860] = "Cor de Centaure",
	[380867] = "Amas d’ambre",
	[380902] = "Champs de Férocité",
	[380918] = "Statue ornementale brisée",
	[380963] = "Petit tas de cendres",
	[380991] = "Tas de terre",
	[381035] = "Grande chambre forte",
	[381045] = "Gobelet draconique en or",
	[381065] = "Portail d’accès endommagé",
	[381069] = "Filet de pêche plein",
	[381071] = "Boîte de pierres",
	[381094] = "Pinceau d’artiste élégant",
	[381104] = "Riche gisement de sérévite",
	[381105] = "Riche gisement de sérévite",
	[381106] = "Filon de sérévite",
	[381108] = "Carte de Yennu",
	[381110] = "Boîte à bijoux oubliée",
	[381153] = "Amas de rubis",
	[381154] = "Écorce tordue",
	[381157] = "Amas de saphirs",
	[381158] = "Fléau de démon gnoll",
	[381160] = "Boussole perdue",
	[381196] = "Écorce tordue touchée par les Titans",
	[381197] = "Écorce tordue ardente",
	[381198] = "Écorce tordue décomposée",
	[381199] = "Écorce tordue balayée par le vent",
	[381200] = "Écorce tordue algide",
	[381201] = "Saxifrage algide",
	[381202] = "Saxifrage balayée par le vent",
	[381203] = "Saxifrage décomposée",
	[381204] = "Saxifrage ardente",
	[381205] = "Saxifrage touchée par les Titans",
	[381210] = "Hochenblume touchée par les Titans",
	[381211] = "Hochenblume ardente",
	[381212] = "Hochenblume décomposée",
	[381213] = "Hochenblume balayée par le vent",
	[381214] = "Hochenblume algide",
	[381216] = "Loupe de géomètre",
	[381223] = "Sablier fissuré",
	[381277] = "Tonneau de friandises confisquées",
	[381296] = "Désordre horrible",
	[381297] = "Bagage égaré",
	[381336] = "Fragmentaire",
	[381340] = "Neltharus l’inébranlable",
	[381341] = "Accueil du premier",
	[381343] = "Apprendre et grandir",
	[381353] = "Dent draconique en pierre",
	[381354] = "Bague en or enveloppée",
	[381355] = "Aile finement sculptée",
	[381356] = "Griffe draconique glaciale",
	[381357] = "Tablette en pierre",
	[381358] = "Tablette en pierre",
	[381359] = "Tablette en pierre",
	[381361] = "Fragment de pierre précieuse",
	[381362] = "Morceau de sculpture",
	[381365] = "Drapeau de l’expédition du Dracaret",
	[381367] = "Drapeau de l’expédition du Dracaret",
	[381369] = "Drapeau de l’expédition du Dracaret",
	[381370] = "Drapeau de l’expédition du Dracaret",
	[381373] = "Drapeau de l’expédition du Dracaret",
	[381375] = "Drapeau de l’expédition du Dracaret",
	[381377] = "Drapeau de l’expédition du Dracaret",
	[381483] = "Trésor de marmoni",
	[381484] = "Os bien conservé",
	[381485] = "Barre de savon égarée",
	[381510] = "Arêtes de poisson volant",
	[381511] = "Tête de harpon",
	[381512] = "Manche en bois",
	[381513] = "Vieille pioche",
	[381514] = "Basalte poli par la mer",
	[381515] = "Gisement de sérévite durcie",
	[381516] = "Gisement de sérévite fondue",
	[381517] = "Gisement de sérévite touchée par les Titans",
	[381518] = "Gisement de sérévite primordiale",
	[381519] = "Gisement de sérévite ardente",
	[381575] = "Nécessaire pour piège à canard",
	[381579] = "Requête des archives",
	[381584] = "Requête des archives",
	[381650] = "Requête des archives",
	[381653] = "Inscriptions à Croc-claque-crame",
	[381661] = "Requête des archives",
	[381662] = "Requête des archives",
	[381663] = "La tempête de mana pour les novices",
	[381664] = "Requête des archives",
	[381667] = "Requête des archives",
	[381668] = "Requête des archives",
	[381669] = "Requête des archives",
	[381670] = "Requête des archives",
	[381671] = "Requête des archives",
	[381672] = "Requête des archives",
	[381687] = "Note abandonnée",
	[381691] = "Un roman d’amour torride : Une Dragonne incendiaire",
	[381701] = "ON RECHERCHE : Mara’nar l’Orageux",
	[381705] = "Les guerres des Gnolls",
	[381706] = "Ta Rêveuse",
	[381707] = "Rêves d’émeraude",
	[381708] = "Le premier Khural",
	[381709] = "Vent, pierre et eau",
	[381711] = "Bénédiction d’Im’bounata",
	[381712] = "Coffre cerclé d’eau",
	[381713] = "Une solide fondation",
	[381715] = "Alerte : évacuation immédiate",
	[381718] = "Le serment",
	[381722] = "Entretien du Vakthros",
	[381730] = "Canards puissants",
	[381731] = "Un message opportun",
	[381732] = "Bénédiction du gardien",
	[381733] = "Ailes de gardien",
	[381734] = "Liées ensemble",
	[381735] = "Notes de gardien",
	[381957] = "Pavot à bulle luxuriant",
	[381958] = "Écorce tordue luxuriante",
	[381959] = "Saxifrage luxuriante",
	[381960] = "Hochenblume luxuriante",
	[381964] = "Transmetteur de signaux désactivé",
	[381981] = "Coffre du déluge",
	[381983] = "Transmetteur de signaux désactivé",
	[381985] = "Transmetteur de signaux désactivé",
	[381987] = "Transmetteur de signaux désactivé",
	[381989] = "Transmetteur de signaux désactivé",
	[381991] = "Transmetteur de signaux désactivé",
	[381993] = "Transmetteur de signaux désactivé",
	[381995] = "Transmetteur de signaux désactivé",
	[381997] = "Transmetteur de signaux désactivé",
	[381999] = "Transmetteur de signaux désactivé",
	[382001] = "Transmetteur de signaux désactivé",
	[382003] = "Transmetteur de signaux désactivé",
	[382029] = "Terre retournée",
	[382071] = "Filet de pêche plein",
	[382079] = "Drapeau de l’expédition du Dracaret",
	[382086] = "Drapeau de l’expédition du Dracaret",
	[382092] = "Drapeau de l’expédition du Dracaret",
	[382094] = "Drapeau de l’expédition du Dracaret",
	[382101] = "Drapeau de l’expédition du Dracaret",
	[382103] = "Drapeau de l’expédition du Dracaret",
	[382105] = "Drapeau de l’expédition du Dracaret",
	[382107] = "Drapeau de l’expédition du Dracaret",
	[382110] = "Drapeau de l’expédition du Dracaret",
	[382112] = "Drapeau de l’expédition du Dracaret",
	[382116] = "Drapeau de l’expédition du Dracaret",
	[382118] = "Drapeau de l’expédition du Dracaret",
	[382120] = "Drapeau de l’expédition du Dracaret",
	[382166] = "Au Festin rubis !",
	[382180] = "Banc de requins-renards magmatiques surchauffé",
	[382193] = "Coffre des éléments",
	[382195] = "Coffre lié par les élémentaires",
	[382325] = "Amas de gemmes d’onyx",
	[382621] = "Console de catalyseur de rétablissement",
	[383625] = "Caisse de loupiotes fraîches",
	[383660] = "Cristal de sel",
	[383732] = "Boîte d’appâts de pêche rohart",
	[383733] = "Terre retournée",
	[383734] = "Terre retournée",
	[383735] = "Terre retournée",
	[384311] = "Volume ancien",
	[384312] = "Volume ancien",
	[384313] = "Volume ancien",
	[384317] = "Schéma froissé",
	[384318] = "Marque-page discret",
	[384370] = "Notes délibérément en souffrance",
	[384405] = "Poisson à moitié cuit",
	[384653] = "Volume ancien",
	[384654] = "Volume ancien",
	[384763] = "Provisions interdites",
	[384980] = "Coffre mystérieux",
	[385008] = "Toiles tissées",
	[385010] = "Toiles tissées",
	[385021] = "Œuf de Dragon pétrifié",
	[385022] = "Fossile érodé",
	[385028] = "Puissante flasque du renouveau",
	[385032] = "Pile d’or",
	[385064] = "Pointe de glace",
	[385074] = "Coffre lié par magie",
	[385075] = "Coffre lié par magie",
	[385396] = "Cache de feu primordial",
	[385398] = "Coffre calciné",
	[385401] = "Coffre calciné",
	[385415] = "Tas d’os",
	[385467] = "Tas d’os",
	[385468] = "Tas d’os",
	[385469] = "Tas d’os",
	[385520] = "Tas d’os",
	[385533] = "Pierre d’envoi : doléance",
	[385565] = "Coffre d’ombreflamme flamboyant",
	[385584] = "Perfection à l’œuvre",
	[385585] = "Serments inviolables",
	[385586] = "Puissance primordiale",
	[385799] = "Coffre-fort durci",
	[385800] = "Pile d’or",
	[385801] = "Pile d’or",
	[385802] = "Pile d’or",
	[385826] = "Coffret des Titans",
	[385830] = "Pierre d’envoi : rapport initial",
	[385831] = "Pierre d’envoi : la prisonnière",
	[385832] = "Pierre de réception : dernier avertissement",
	[385834] = "Entrée du journal : expériences",
	[385835] = "Entrée du journal : reliques",
	[385836] = "Entrée du journal : les couvoirs",
	[385837] = "Entrée du journal : silence",
	[385917] = "Transmetteur de signaux désactivé",
	[385919] = "Transmetteur de signaux désactivé",
	[385921] = "Transmetteur de signaux désactivé",
	[385937] = "Coffret des Titans",
	[385940] = "Clé runique",
	[385952] = "Anneau inhabituel",
	[386079] = "Coffre bien mâché",
	[386080] = "Clé brûlante",
	[386083] = "Orbe bouillonnant",
	[386086] = "Cache bouillonnante",
	[386088] = "Offrandes rituelles",
	[386089] = "Offrandes rituelles",
	[386090] = "Offrandes rituelles",
	[386091] = "Offrandes rituelles",
	[386104] = "Coffre zaqali ancien",
	[386106] = "Drapeau de l’expédition du Dracaret",
	[386108] = "Drapeau de l’expédition du Dracaret",
	[386123] = "Œuf calciné",
	[386168] = "Cache longuécaille",
	[386353] = "Coffre durci",
	[386354] = "Coffre durci",
	[386421] = "Cache de feu primordial",
	[386422] = "Cache de feu primordial",
	[386423] = "Cache de feu primordial",
	[386424] = "Coffre calciné",
	[386425] = "Coffre calciné",
	[386426] = "Cache de terre primordiale",
	[386427] = "Chariot de pierres brisées",
	[386428] = "Cache de terre primordiale",
	[386429] = "Cache de terre primordiale",
	[386430] = "Coffre durci",
	[386431] = "Cache de terre primordiale",
	[386432] = "Coffre durci",
	[386433] = "Cache de vent primordial",
	[386441] = "Cache de vent primordial",
	[386442] = "Cache de Vide primordial",
	[386443] = "Cache de vent primordial",
	[386444] = "Cache d’eau primordiale",
	[386445] = "Cache d’eau primordiale",
	[386447] = "Cache d’eau primordiale",
	[386450] = "Cache d’eau primordiale",
	[386451] = "Coffre-fort cerclé de vent",
	[386452] = "Coffre-fort cerclé de vide",
	[386453] = "Coffre-fort cerclé de vent",
	[386454] = "Coffre de glace",
	[386455] = "Coffre robuste",
	[386456] = "Coffre robuste",
	[386457] = "Coffret gelé",
	[386458] = "Cache de décomposition primordiale",
	[386459] = "Cache de décomposition primordiale",
	[386460] = "Cache des arcanes primordiales",
	[386461] = "Cache des arcanes primordiales",
	[386462] = "Cache de sang primordial",
	[386463] = "Cache d’or primordial",
	[386470] = "Pile d’or",
	[386472] = "Pile d’or",
	[386484] = "Pile d’or",
	[386531] = "Pile d’or",
	[386532] = "Cache d’or primordial",
	[386547] = "Moule de suffusion",
	[386555] = "Objet circulaire étrange",
	[386556] = "Vase poussiéreux",
	[386559] = "Cargaison sécurisée",
	[386573] = "Boîte à clé ornée",
	[386578] = "Jeton offert par Neltharion",
	[386579] = "Jeton offert par Neltharion",
	[386580] = "Jeton offert par Neltharion",
	[386581] = "Jeton offert par Neltharion",
	[386582] = "Jeton offert par Neltharion",
	[386583] = "Jeton offert par Neltharion",
	[386585] = "Assembleur expérimental",
	[386586] = "Fragment prismatique",
	[386587] = "Fragment prismatique",
	[386588] = "Panier de cristaux",
	[386589] = "Panier de cristaux",
	[386591] = "Fiole vide",
	[386604] = "Cache d’or primordial",
	[386605] = "Pile d’or",
	[386632] = "Pack draconique expérimental",
	[386633] = "Coffre des tempêtes",
	[386648] = "Parchemin mystérieux",
	[386660] = "Pile d’or",
	[386668] = "Bijou hakkari fracassé",
	[386669] = "Bijou hakkari fragmenté",
	[386680] = "Almanach mystérieux",
	[386683] = "Livre calciné",
	[386687] = "Journal patiné",
	[386688] = "Tome vierge",
	[386690] = "Compendium ambigu",
	[386762] = "Cache d’armure primordiale",
	[387493] = "Poisson unique",
	[387496] = "Brasero de la Folie",
	[387500] = "Bonhomme de neige glacial",
	[387501] = "Jeton offert par Neltharion",
	[387503] = "Lettre scellée à l’attention de Neltharion",
	[387507] = "Baril de poudre d’azérite",
	[387508] = "Torche d’allumage",
	[387520] = "TICKET : Jeux de Phosphorogg",
	[387695] = "Sac de pièces Rumble",
	[387697] = "Sac de pièces Rumble",
	[387718] = "Sac de Rumble métallisés",
	[387725] = "Cristal luminescent",
	[387727] = "Cristal sulfurique",
	[387728] = "Opéra des Aspects",
	[387729] = "Cristal de magma",
	[387736] = "Les Dieux très anciens et l’ordonnancement d’Azeroth",
	[387737] = "Livre vivant",
	[387746] = "Cache d’esprit primordial",
	[387749] = "Cristalépine animé",
	[387853] = "Cristaux brisés",
	[388471] = "Cache primordiale pillée",
	[388712] = "Coffre d’opéra",
	[388866] = "Pot de composants",
	[388873] = "Sac de pièces des Lamineurs",
	[388876] = "Pot de composants",
	[388895] = "Annotations diverses",
	[388896] = "Coffre enveloppé de cristal",
	[388905] = "Outils de Neltharion",
	[388908] = "Gelée inerte",
	[388911] = "Vieille malle",
	[389102] = "Fragment prismatique",
	[389103] = "Fragment prismatique",
	[389104] = "Fragment prismatique",
	[389105] = "Fragment prismatique",
	[389106] = "Fragment prismatique",
	[389107] = "Fragment prismatique",
	[389108] = "Fragment prismatique",
	[389111] = "Paquet détrempé",
	[389114] = "Cache perdue depuis longtemps",
	[389173] = "Cache de sang primordial",
	[389231] = "Cache de musique primordiale",
	[389471] = "Grande cache d’obsidienne",
	[389540] = "Gelée visqueuse",
	[389545] = "Coffre mystérieux",
	[389546] = "Pot de composants",
	[389564] = "Gelée décérébrée",
	[389599] = "Pointe de glace",
	[389789] = "Cache de terre primordiale",
	[389902] = "Cache de terre primordiale",
	[390008] = "Glace",
	[390009] = "Boîte de pierres",
	[390074] = "Cache primordiale des profondeurs de l’océan",
	[390136] = "Essence sporeliée",
	[390137] = "Gisement de sérévite métamorphique",
	[390138] = "Gisement de draconium métamorphique",
	[390139] = "Hochenblume diaprée",
	[390140] = "Saxifrage diaprée",
	[390141] = "Écorce tordue diaprée",
	[390142] = "Pavot à bulle diapré",
	[390257] = "Ours empaillé",
	[390258] = "Gelée inerte",
	[390559] = "Boîte de pierres",
	[390560] = "Coffre de recherche verrouillé",
	[392025] = "Pièces moulées",
	[392026] = "Moulage de pièces de Neltharion",
	[392030] = "Marteau en noiracier",
	[392335] = "Cache d’armure primordiale",
	[392569] = "Cache primordiale scellée par des chaînes",
	[392570] = "Cache primordiale scellée par des chaînes",
	[392571] = "Coffre-fort scellé par des chaînes",
	[392572] = "Coffre-fort scellé par des chaînes",
	[392573] = "Coffre-fort scellé par des chaînes",
	[392580] = "Plans d’évacuation d’Aberrus égaré",
	[392581] = "Bombes imprudemment abandonnées",
	[392582] = "Kit de survie défectueux",
	[392583] = "Coffre-fort cerclé de vide",
	[392587] = "Générateur de trou de wyrm cassé",
	[392591] = "Coffre des Vols",
	[392593] = "Collecteur de données discret",
	[393218] = "Cache des arcanes primordiales",
	[393220] = "Cache de peinture primordiale",
	[393221] = "Pot de composants",
	[393222] = "Malle de fournitures",
	[393282] = "Boîte à ballons",
	[393283] = "Boîte à ballons",
	[393957] = "Pile d’or",
	[393958] = "Pile d’or",
	[396019] = "Butin volé",
	[396020] = "Butin volé",
	[396339] = "Bourse volée par les phalènes",
	[398133] = "Boulons et cuivre",
	[398135] = "Perceuse en dracothyste abandonnée",
	[398138] = "Explorobot fondu",
	[398200] = "Coffret oublié",
	[398674] = "Prospectus coloré",
	[398698] = "Gruyère grinçant",
	[398751] = "Pavot à bulle luxuriant",
	[398752] = "Écorce tordue luxuriante",
	[398753] = "Hochenblume luxuriante",
	[398754] = "Saxifrage luxuriante",
	[398755] = "Pavot à bulle",
	[398756] = "Écorce tordue",
	[398759] = "Pavot à bulle touché par les Titans",
	[398760] = "Écorce tordue touchée par les Titans",
	[398761] = "Hochenblume touchée par les Titans",
	[398762] = "Saxifrage touchée par les Titans",
	[398764] = "Pavot à bulle ardent",
	[398765] = "Écorce tordue ardente",
	[398766] = "Hochenblume ardente",
	[398767] = "Saxifrage ardente",
	[398770] = "Boîte de pierres",
	[398778] = "Cuve répugnante",
	[398783] = "Huile d’écaille imprégnée de flammes",
	[398785] = "« Couteau » de travail du cuir forgé dans la lave",
	[398786] = "Toiles tissées",
	[398787] = "Toiles tissées",
	[398788] = "Toiles tissées",
	[398789] = "Toiles tissées",
	[398790] = "Toiles tissées",
	[398791] = "Peaux imprégnées de soufre",
	[398793] = "Cristal d’ombre trempé dans la lave",
	[398794] = "Orbe aqueux chatoyant",
	[398796] = "Cristal arcanique résonnant",
	[398810] = "Récompense de loyauté",
	[398814] = "Butin en fusion",
	[398815] = "Cargaison sécurisée",
	[398828] = "Coffre de gains massifs",
	[401236] = "Spécimen mal nourri",
	[401238] = "Gelée médulienne",
	[401240] = "Moisissure suspecte",
	[401241] = "Coquilles d’escargot ignorées",
	[401292] = "Joyaux légèrement chamboulés",
	[401299] = "Rocher de marchandage brisé",
	[401828] = "Reliquaire de Nal Ks’kol",
	[401839] = "Butin de la Rêveuse",
	[401844] = "Tas de déchets kifouette",
	[401845] = "Terre retournée kifouette",
	[401846] = "Coffre au trésor kifouette",
	[402578] = "Clé luminescente",
	[402609] = "Porte des démons",
	[402627] = "Four très usé",
	[402632] = "Bouée du soufre",
	[402634] = "Lance d’ancien zaqali",
	[402841] = "Œuf expérimental délicat",
	[402868] = "Chute de tissu abandonnée",
	[402878] = "Trousse médicale de campagne utilisée",
	[402887] = "Bannière magnifiquement brodée",
	[402888] = "Runes complexes zaqalis",
	[402890] = "Émanation de rune sifflante",
	[402892] = "Recherches anciennes",
	[403458] = "Breuvage de l’Audacieux",
	[403498] = "Journal d’Éva",
	[403532] = "Seau d’eau de fontaine",
	[403533] = "Chargement de fumigènes non livré",
	[403534] = "Poupée piétinée",
	[403535] = "Titre de propriété d’Andorhal",
	[403536] = "La route à suivre",
	[403552] = "Fémur d’Éva",
	[403567] = "Brevet de l’Aube d’argent fendu",
	[403702] = "Page perdue",
	[403703] = "Page perdue",
	[403704] = "Page perdue",
	[403705] = "Page perdue",
	[403706] = "Page perdue",
	[403707] = "Page perdue",
	[403708] = "Page perdue",
	[403709] = "Page perdue",
	[403710] = "Page perdue",
	[403711] = "Page perdue",
	[403712] = "Page perdue",
	[403713] = "Page perdue",
	[403714] = "Page perdue",
	[403715] = "Page perdue",
	[403716] = "Page perdue",
	[403717] = "Page perdue",
	[403722] = "Crochet égaré bien pratique",
	[403731] = "Rune de givre",
	[403786] = "Crâne à ramures",
	[403919] = "Rouage mécanique",
	[403962] = "Deuxième recueil d’Omarion",
	[404232] = "Fleur-du-Crépuscule pâle",
	[404242] = "Livre trempé de pétrole",
	[404260] = "Énigme résolue !",
	[404314] = "Tablette en pierre ébréchée",
	[404337] = "Tonneau d’ardoise de bar",
	[404432] = "Livre trempé de sang",
	[404480] = "Epée mantide entaillée",
	[404492] = "Vase doré",
	[404849] = "Nid de corveffroi",
	[404981] = "Tonneau d’ardoise de bar",
	[404982] = "Tonneau d’ardoise de bar",
	[404987] = "Tonneau d’ardoise de bar",
	[404992] = "Tonneau d’ardoise de bar",
	[405009] = "Tonneau d’ardoise de bar",
	[405012] = "Tonneau d’ardoise de bar",
	[405388] = "Journal familier",
	[405515] = "Boîte enchantée",
	[405532] = "Monticule de terre meuble",
	[405584] = "Sac de Rumble métallisés",
	[405593] = "Archives d’Azeroth !",
	[405943] = "Étui à parchemin drakônide",
	[405996] = "Tablette de lien commercial zaqali antique",
	[406383] = "Portail des terres de Feu",
	[407186] = "Tonneau d’ardoise de bar",
	[407192] = "Tonneau d’ardoise de bar",
	[407199] = "Tonneau d’ardoise de bar",
	[407201] = "Tonneau d’ardoise de bar",
	[408107] = "Lumiflore cristalline",
	[408224] = "Pierre griffonnée à la hâte",
	[408706] = "Floraison magique",
	[408707] = "Nœud étrange",
	[408767] = "Sac poussiéreux",
	[408934] = "Outils d’artificier",
	[408976] = "Tome ancien",
	[408980] = "L’Héritage de Tyr",
	[409077] = "Pamphlet roussi",
	[409120] = "Cache des mystères cosmiques",
	[409166] = "Relais de puissance des Titans",
	[409200] = "Urne brisée",
	[409208] = "Urne brisée",
	[409209] = "Urne brisée",
	[409211] = "Urne brisée",
	[409212] = "Urne brisée",
	[409214] = "Urne brisée",
	[409222] = "Bienfait d’Ursol",
	[409302] = "Cristal de dispersement",
	[409320] = "Objet enterré",
	[409329] = "Objet enterré",
	[409333] = "Objet enterré",
	[409338] = "Sac échoué",
	[409440] = "Réserve de musaraigne des pins",
	[409458] = "Fournitures de pêche perdues",
	[409835] = "Monticule de terre meuble",
	[409849] = "Classeur de recherches sur le frêne",
	[409914] = "Pièce du propulseur de Mimiron",
	[410045] = "Fleur éternelle",
	[410046] = "Fleur éternelle",
	[410048] = "Fleur éternelle",
	[410395] = "Registres du bastion du Siège",
	[410426] = "Potion de sommeil sans rêve supérieure à moitié pleine",
	[410434] = "Potion d’aspergement de narcolepsie",
	[410442] = "Les racines du problème",
	[410456] = "Capturêve experimental",
	[410459] = "Magnétite des hautes-terres",
	[410469] = "Batterie non éclose",
	[410475] = "Espoir pétrifié",
	[410479] = "Défaut non poli",
	[410484] = "Pierre onirique coalescente",
	[410529] = "Touffe de poils de sabre de rêve",
	[410534] = "Mue d’écailles de dragon féerique",
	[410550] = "Serre de serre de rêve",
	[410574] = "Eau de rêve pure",
	[410575] = "Noyau semperardent",
	[410582] = "Essence des rêves",
	[410786] = "Notes de recherche d’Alydrus",
	[410833] = "Reforger la Garde de Tyr",
	[410994] = "Carte de la sécurité du donjon d’Ombrecroc",
	[410998] = "Formule : parfum entêtant toxique",
	[410999] = "Note de l’apothicaire Hummel",
	[411065] = "Bienfait d’Ashamane",
	[411066] = "Bienfait d’Aviana",
	[411067] = "Bienfait de Goldrinn",
	[411102] = "Décombres d’aéronef",
	[411104] = "Os bien blanchis",
	[411106] = "Tissu abîmé",
	[411168] = "Notes de Winnie sur la flore et la faune",
	[411169] = "Pilier du gardien du bosquet",
	[411170] = "Rune d’ombrelien primaliste",
	[411171] = "Trame-sauvage particulièrement douce",
	[411176] = "Oreiller moelleux",
	[411177] = "Copain de câlin",
	[411179] = "Bouclier de défenseur d’Amirdrassil",
	[411180] = "Châssis de nécrotraqueur",
	[411181] = "Moissonneur flammelige",
	[411447] = "Écho non réveillé",
	[411463] = "Écho non réveillé",
	[411465] = "Écho non réveillé",
	[411466] = "Écho non réveillé",
	[411560] = "Fleur de lavande",
	[411561] = "Orchidée en sucre",
	[411562] = "Illicium orange",
	[411571] = "Shillelagh de Freydrin",
	[411622] = "Socle de machiniste",
	[411623] = "Socle de machiniste",
	[411624] = "Socle de machiniste",
	[411691] = "Arme toute neuve",
	[411778] = "Échantillon de fourrure d’hoursute amalgamée de pollen",
	[411878] = "Pièces intrigantes",
	[411930] = "Tonneau de poudre noire",
	[411936] = "Emplacement de l’orbe",
	[412066] = "Pierre de lancer",
	[412950] = "Griffe bénie par la Lune",
	[412995] = "Petite boîte de fioles",
	[413126] = "Boîte de produits artisanaux",
	[413246] = "Tas de vase élémentaire",
	[413694] = "Bouche d’aération suspecte",
	[413774] = "La légende d’Élun’Ahir",
	[413780] = "De la nature du Rêve",
	[413784] = "Cookies auto préparés à base d’herbes",
	[413787] = "La tragédie d’Érinéthria",
	[414113] = "Dépôt de sivpierre",
	[414169] = "Graines mystérieuses",
	[414199] = "Tas de possessions terrestres",
	[414700] = "Sucre éthéré",
	[415296] = "Trousse de réparation",
	[415303] = "Colis scellé par magie",
	[415584] = "Cœur de magma crépitant",
	[416310] = "Coffre kobyss",
	[416401] = "Lance kobyss",
	[416448] = "Fleur de lavande luxuriante",
	[416450] = "Illicium orange luxuriant",
	[416950] = "Tas de minerai à trier",
	[416954] = "Fragment de minerai",
	[416968] = "Prise de Roche-Tranquille",
	[416969] = "Vin de vendanges",
	[416970] = "Provisions de la ferme de Sainte-Chute",
	[416971] = "Maïs de Sainte-Chute",
	[416973] = "Boîte à outils arathie",
	[416974] = "Tapis arathi roulé",
	[417136] = "Pièces intrigantes",
	[417137] = "Pièces intrigantes",
	[417138] = "Pièces intrigantes",
	[419729] = "Œufs étranges",
	[420019] = "Outils d’artificière",
	[420039] = "Outils d’artificière",
	[420040] = "Outils d’artificière",
	[420730] = "Filon de minerai",
	[420734] = "Cendrepli",
	[420954] = "Œil gravé",
	[421070] = "Sacoche de vestige",
	[421154] = "Œil gravé",
	[421179] = "Sac de couchage kaldorei",
	[421180] = "Sac à dos kaldorei",
	[421181] = "Dague kaldorei",
	[421182] = "Corne kaldorei",
	[421183] = "Sac kaldorei",
	[421184] = "Bouclier kaldorei",
	[421185] = "Lance kaldorei",
	[421186] = "Longue-vue kaldorei",
	[421338] = "Sac kaldorei",
	[421339] = "Corne kaldorei",
	[421360] = "Gerbe du souvenir",
	[421525] = "Qui-brille",
	[421555] = "Arc de lune kaldorei",
	[421592] = "Économies d’une vie",
	[421594] = "Emploi lucratif",
	[421597] = "Centre du village",
	[421599] = "Industrie locale",
	[421718] = "Pépé le Dragon",
	[421735] = "Fleur de preuve",
	[421736] = "Pépé l’explorateur",
	[421740] = "Pépé le Rohart",
	[421909] = "Défenseur défunt",
	[422560] = "Boussole de Maevest",
	[423596] = "Tas de sable",
	[423602] = "Tas de sable",
	[423603] = "Tas de sable",
	[423612] = "Artéfacts des Titans",
	[423688] = "Appareil des Titans",
	[423714] = "Pied de noctetige",
	[423854] = "Puits des âmes",
	[423959] = "Coffre de fournitures estompé",
	[423971] = "Palourde à corail fusionné",
	[423977] = "Coffre kobyss",
	[423978] = "Coffre kobyss",
	[423979] = "Coffre kobyss",
	[424253] = "Lanterne de Korgran",
	[424343] = "Fournitures médicales",
	[424436] = "Propagande de l’Ordre de la nuit",
	[425875] = "Caisse de transport prioritaire",
	[428167] = "Notes de recherche abandonnées",
	[428199] = "Notes de recherche abandonnées",
	[428699] = "Tonneau grésillant",
	[428814] = "Boîte anodine",
	[429301] = "Caisse de cargaison",
	[430215] = "Cire fondue",
	[430284] = "Vestige radieux",
	[430337] = "Vestige radieux",
	[430340] = "Vestige radieux",
	[430341] = "Vestige radieux",
	[430342] = "Vestige radieux",
	[430343] = "Vestige radieux",
	[430344] = "Vestige radieux",
	[430345] = "Vestige radieux",
	[430358] = "Vestige radieux",
	[432893] = "Caisse de cargaison",
	[432894] = "Caisse de cargaison",
	[433090] = "Argile imprégnée",
	[433101] = "Sac d’éclats luminescents",
	[433102] = "Liasse de reçus",
	[433109] = "Cordes en soie nérubienne",
	[433370] = "Coffre de fournitures de guerre",
	[433377] = "Boîte de la moisson",
	[433778] = "Trésor enfoui",
	[433907] = "Propagande de l’Ordre de la nuit",
	[434281] = "Vestige radieux",
	[434283] = "Vestige radieux",
	[434284] = "Vestige radieux",
	[434285] = "Vestige radieux",
	[434286] = "Vestige radieux",
	[434288] = "Vestige radieux",
	[434289] = "Vestige radieux",
	[434502] = "Caisse de ravitaillement des Hameçonneurs",
	[434554] = "Vestige radieux",
	[434560] = "Vestige radieux",
	[434563] = "Vestige radieux",
	[434564] = "Vestige radieux",
	[434565] = "Vestige radieux",
	[434566] = "Vestige radieux",
	[434567] = "Vestige radieux",
	[434568] = "Vestige radieux",
	[434924] = "Vestige radieux",
	[434925] = "Vestige radieux",
	[434926] = "Vestige radieux",
	[434927] = "Vestige radieux",
	[434928] = "Vestige radieux",
	[434930] = "Vestige radieux",
	[436933] = "Pelle favorite de Museau-doux",
	[437060] = "Tribut de l’aspirant",
	[437216] = "Lance-ombre sureki",
	[437389] = "Mémorial oublié",
	[437726] = "Champiombre luminescent",
	[437767] = "Caisse d’herbes de Sainte-Chute",
	[438037] = "Réceptacle de Sang noir",
	[438038] = "Flacon de venimancie",
	[438039] = "Matériel d’alchimie",
	[439291] = "Marchandises saisies",
	[439314] = "Fournitures de campement",
	[439324] = "Artéfacts abandonnés",
	[439334] = "Lance-ombre sureki",
	[439339] = "Lance-ombre sureki",
	[439348] = "Cache de mutagène",
	[439382] = "Cargaison suspecte",
	[439463] = "Miel-feu renversé",
	[439473] = "Tenir et l’Ordre de la nuit",
	[439474] = "Armement de la garde de la reine",
	[439531] = "Arbaleste sans surveillance",
	[439532] = "Outil de forge sureki",
	[439562] = "Aérochevalier défunt",
	[440914] = "Offrande d’eau pure",
	[440926] = "Bocal de mucus",
	[441585] = "Flacon de venin brûlant",
	[441586] = "Correspondance militaire",
	[441587] = "Caisse de flacons vides",
	[441588] = "Armes confisquées",
	[441723] = "Sacoche de ferme",
	[444028] = "Lotus baigné de lumière",
	[444029] = "Lotus baigné de lumière",
	[444030] = "Lotus baigné de lumière",
	[444066] = "Magot du gardien",
	[444261] = "Acheter du Banana Bam : 5 pièces d’argent",
	[444275] = "Acheter du Mangoro Mania : 5 pièces d’argent",
	[444276] = "Acheter de l’Orange O-pocalypse : 5 pièces d’argent",
	[444277] = "Acheter de l’Urtic’Huître : 5 pièces d’argent",
	[445275] = "Coffre renforcé sureki royal",
	[445360] = "Butin dérobé",
	[446362] = "Charmeur écarlate",
	[446363] = "Fleur d’ambre",
	[446435] = "Fil violet",
	[446437] = "Fil écarlate",
	[446438] = "Fil d’or",
	[449528] = "Outils de minage d’opale",
	[451442] = "Ail secret",
	[451598] = "Mémorial oublié",
	[451967] = "Boîte à repas de Heaume-Colline",
	[451990] = "Vestige radieux",
	[451993] = "Appareil nérubien",
	[452005] = "P’tit Groin",
	[452438] = "Gamelle pour chien partiellement enterrée",
	[452696] = "Reliquaire du mandataire des machines",
	[452706] = "Sacoche perdue dans l’abîme",
	[452710] = "Sacoche débordante perdue dans l’abîme",
	[453167] = "Trésor du lynx perturbé",
	[453186] = "Croissancile de nocteferme",
	[453283] = "Trésor du contrebandier",
	[453359] = "Rituel des ténèbres",
	[453374] = "Essence ombreuse",
	[453716] = "Cache de boissons onéreuses",
	[453741] = "Récompense du maître des traditions",
	[453749] = "Codex de structure dimensionnelle de Paloltar",
	[453751] = "Soins et alimentation du lynx impérial",
	[453752] = "Directives du couvre-feu de l’ombre",
	[453753] = "Beledar – la Vision de l’empereur",
	[453754] = "Le Chant de Renilash",
	[453755] = "Le Grand Livre des expressions arathies",
	[453937] = "500 plats avec des champignons et des poissons des grottes",
	[454021] = "Vestige radieux",
	[454023] = "Vestige radieux",
	[454024] = "Vestige radieux",
	[454038] = "Fournitures volées",
	[454039] = "Fournitures volées",
	[454049] = "|cff1EFF00Coffre solide",
	[454090] = "|cff1EFF00Coffre solide",
	[454091] = "|cff1EFF00Coffre solide",
	[454092] = "|cff1EFF00Coffre solide",
	[454093] = "|cff1EFF00Coffre solide",
	[454094] = "|cff1EFF00Coffre solide",
	[454176] = "Armes kahetis",
	[454189] = "Minerai d’opale",
	[454200] = "|cff1EFF00Coffre solide",
	[454201] = "|cff1EFF00Coffre solide",
	[454202] = "|cff1EFF00Coffre solide",
	[454207] = "|cff1EFF00Coffre solide",
	[454313] = "Reine Xekatha",
	[454316] = "Reine Zaltra",
	[454318] = "Cachette de Croquette",
	[454320] = "Reine Anub’izek",
	[454321] = "Cachette de Croquette",
	[454323] = "Cachette de Croquette",
	[454327] = "Cachette de Croquette",
	[454328] = "Filaments de souvenir",
	[454330] = "Traité sur les formes : grouilleurs",
	[454331] = "Cachette de Croquette",
	[454332] = "Traité sur les formes : sages",
	[454334] = "Cachette de Croquette",
	[454335] = "Essai entomologique sur les vers, volume 1",
	[454336] = "Essai entomologique sur les vers, volume 2",
	[454337] = "Cachette de Croquette",
	[454338] = "Essai entomologique sur les vers, volume 3",
	[454339] = "Cachette de Croquette",
	[454340] = "Cachette de Croquette",
	[454342] = "Cachette de Croquette",
	[454343] = "Éthos de la guerre, partie 1",
	[454344] = "Éthos de la guerre, partie 2",
	[454346] = "Cachette de Croquette",
	[454348] = "Éthos de la guerre, partie 3",
	[454350] = "Éthos de la guerre, partie 4",
	[454404] = "Plaque d’Hathlaz",
	[454405] = "Plaque d’Attwogaz",
	[454406] = "Plaque de Krattdaz",
	[454407] = "Plaque d’Uisgaz",
	[454408] = "Plaque de Venedaz",
	[454412] = "Plaque de Merunth",
	[454414] = "Plaque de Varerko",
	[454416] = "Plaque d’Alfritha",
	[454417] = "Plaque de Gundrig",
	[454418] = "Plaque de Sathilga",
	[454463] = "Avis de recherche : brise-quartier",
	[454541] = "Vestige radieux",
	[454542] = "Vestige radieux",
	[454543] = "Vestige radieux",
	[454797] = "Des profondeurs ils émergent",
	[455038] = "Règles du Gambit de la Lumière",
	[455170] = "Papyrus en bois de fer effrité",
	[455183] = "Journal du couvre-feu de l’ombre",
	[455269] = "Notes sur les mandataires des machines : fragment I",
	[455274] = "Notes sur les mandataires des machines : fragment II",
	[455275] = "Notes sur les mandataires des machines : fragment III",
	[455276] = "Notes sur les mandataires des machines : fragment IV",
	[455277] = "Notes sur les mandataires des machines : fragment V",
	[455278] = "Notes sur les mandataires des machines : fragment VI",
	[455279] = "Appréciation du vizir",
	[455288] = "Grimoire en chair",
	[455310] = "Écoutez des récits historiques à la scène du Conteur !",
	[455320] = "Appréciation du vizir",
	[455321] = "Appréciation du vizir",
	[455322] = "Appréciation du vizir",
	[455323] = "Appréciation du vizir",
	[455324] = "Appréciation du vizir",
	[455325] = "Appréciation du vizir",
	[455328] = "Appréciation du vizir",
	[455329] = "Appréciation du vizir",
	[455330] = "Appréciation du vizir",
	[455331] = "Appréciation du vizir",
	[455435] = "Tribut de l’aspirant",
	[455436] = "Tribut de l’aspirant",
	[455437] = "Tribut de l’aspirant",
	[455439] = "Tribut de l’aspirant",
	[455440] = "Tribut de l’aspirant",
	[455441] = "Tribut de l’aspirant",
	[455442] = "Tribut de l’aspirant",
	[455443] = "Tribut de l’aspirant",
	[455444] = "Tribut de l’aspirant",
	[455445] = "Tribut de l’aspirant",
	[455446] = "Tribut de l’aspirant",
	[455482] = "|cff1EFF00Coffre solide",
	[455484] = "|cff1EFF00Coffre solide",
	[455485] = "|cff1EFF00Coffre solide",
	[455486] = "|cff1EFF00Coffre solide",
	[455487] = "|cff1EFF00Coffre solide",
	[455488] = "|cff1EFF00Coffre solide",
	[455489] = "|cff1EFF00Coffre solide",
	[455490] = "|cff1EFF00Coffre solide",
	[455491] = "|cff1EFF00Coffre solide",
	[455492] = "|cff1EFF00Coffre solide",
	[455493] = "|cff1EFF00Coffre solide",
	[455494] = "|cff1EFF00Coffre solide",
	[455495] = "|cff1EFF00Coffre solide",
	[455496] = "|cff1EFF00Coffre solide",
	[455497] = "|cff1EFF00Coffre solide",
	[455503] = "|cff1EFF00Coffre solide",
	[455504] = "|cff1EFF00Coffre solide",
	[455505] = "|cff1EFF00Coffre solide",
	[455506] = "|cff1EFF00Coffre solide",
	[455507] = "|cff1EFF00Coffre solide",
	[455508] = "|cff1EFF00Coffre solide",
	[455509] = "|cff1EFF00Coffre solide",
	[455510] = "|cff1EFF00Coffre solide",
	[455511] = "|cff1EFF00Coffre solide",
	[455512] = "|cff1EFF00Coffre solide",
	[455513] = "|cff1EFF00Coffre solide",
	[455514] = "|cff1EFF00Coffre solide",
	[455515] = "|cff1EFF00Coffre solide",
	[455516] = "|cff1EFF00Coffre solide",
	[455517] = "|cff1EFF00Coffre solide",
	[455522] = "|cff1EFF00Coffre solide",
	[455523] = "|cff1EFF00Coffre solide",
	[455524] = "|cff1EFF00Coffre solide",
	[455525] = "|cff1EFF00Coffre solide",
	[455526] = "|cff1EFF00Coffre solide",
	[455527] = "|cff1EFF00Coffre solide",
	[455531] = "|cff1EFF00Coffre solide",
	[455532] = "|cff1EFF00Coffre solide",
	[455533] = "|cff1EFF00Coffre solide",
	[455534] = "|cff1EFF00Coffre solide",
	[455685] = "APPEL DU GOUFFRE : fosse de l’Effroi",
	[455759] = "Griffe de raptor massive",
	[455761] = "Gérald",
	[455768] = "Caisse d’anniversaire trempée",
	[455939] = "Couette nérubienne",
	[455942] = "Cisoire de rapiéçage terrestre",
	[455943] = "Aiguilles runiques terrestres",
	[455944] = "Mètre ruban terrestre",
	[455945] = "Découd-vite de Dornogal",
	[455947] = "Fer de tannage nérubien",
	[455949] = "Agent de tannage arathi",
	[455976] = "Pince à gemmes terrestre",
	[455980] = "Marqueur ciselé de calligraphe",
	[456009] = "Gemme terrestre broyée",
	[456012] = "Pinces rayonnantes",
	[456016] = "Marteau de Dornogal",
	[456017] = "Enclume terrestre ancienne",
	[456022] = "Touillette gravée",
	[456024] = "Cadre de Dornogal en métal",
	[456032] = "Papier froissé",
	[456036] = "Papier volant",
	[456038] = "Papier humide",
	[456039] = "Lettre chiffonnée",
	[456041] = "Papier plié",
	[456061] = "Caisse d’anniversaire abîmée",
	[456767] = "Cheveux roux",
	[456820] = "Torche étrange",
	[457025] = "Vaisseau de transport gobelin précalibré",
	[457062] = "Malédiction du capitaine des cieux Lancekat",
	[457156] = "Note déchirée",
	[457160] = "Note déchirée",
	[457161] = "Note déchirée",
	[457197] = "Longue-vue montée",
	[457246] = "Réserve d’ouvrière agricole",
	[457270] = "Boîte de géomètre",
	[457303] = "Vestige radieux",
	[459333] = "Œil orné de joyaux",
	[459368] = "Coffre partiellement enterré",
	[462417] = "Caisse d’anniversaire détrempée",
	[463104] = "La dernière volonté de Nola",
	[463653] = "Caisse d’anniversaire couverte de poussière",
	[465161] = "Récépissé de vente imperméable",
	[465234] = "Page manquante du carnet de croquant de Yennu",
	[465277] = "Monticule de poussière",
	[466438] = "Caisse d’anniversaire carbonisée",
	[466512] = "Caisse d’anniversaire cristallisée",
	[467060] = "Pelote de laine",
	[467064] = "Journal de quêtes",
	[467075] = "Carte de bonne aventure de Sombrelune",
	[467083] = "Carte de bonne aventure de Sombrelune",
	[467191] = "Coffre codé",
	[467293] = "Jouet pour chien",
	[467305] = "Coffre à jouets",
	[467329] = "Jouet de Maru",
	[467334] = "Carte de bonne aventure de Sombrelune",
	[467336] = "Carte de bonne aventure de Sombrelune",
	[467338] = "Carte de bonne aventure de Sombrelune",
	[467339] = "Carte de bonne aventure de Sombrelune",
	[467342] = "Carte de bonne aventure de Sombrelune",
	[467351] = "Carte de bonne aventure de Sombrelune",
	[467403] = "Carte de bonne aventure de Sombrelune",
	[469568] = "Plume brûlée",
	[469569] = "Plume arrachée",
	[469573] = "Plume gelée",
	[469574] = "Plume normale",
	[469985] = "Bloc de glace",
	[470229] = "Peluche",
	[472068] = "Croquis de bakar",
	[473934] = "Propriété de Cuistolomée",
	[477139] = "Objets trouvés",
	[478090] = "Caisse d’anniversaire moisie",
	[485669] = "APPEL DU GOUFFRE : Folie fongique",
	[487805] = "APPEL DU GOUFFRE : mines de Rampeterre",
	[487851] = "APPEL DU GOUFFRE : la Trame spiralée",
	[499466] = "Journal kultirassien en lambeaux",
	[499551] = "Boulets en noiracier",
	[505260] = "Potion de vérité",
	[505505] = "Pioche de minage en fer",
	[9000000] = "Pierre de vent sculptée",
	[9999908] = "|cFFFFFFFFÉtape 1:|r Rassemblez les consommables.",
	[9999909] = "|cFFFFFFFFÉtape 2:|r Caverns of Consumption",
	[9999910] = "|cFFFFFFFFÉtape 3:|r Barrière de feu",
	[9999911] = "|cFFFFFFFFÉtape 4:|r Barrière prismatique",
	[9999912] = "|cFFFFFFFFÉtape 5:|r Guetteuse consciencieuse",
	[9999913] = "|cFFFFFFFFÉtape 6:|r Barrière de vigne",
	[9999914] = "|cFFFFFFFFÉtape 7:|r Barrière d'eau",
	[9999915] = "|cFFFFFFFFÉtape 8:|r Guetteur de pierre",
	[9999916] = "|cFFFFFFFFÉtape 9:|r Barrière éthérienne",
	[9999917] = "|cFFFFFFFFÉtape 10:|r Pierre étrange",
	[9999918] = "|cFFFFFFFFÉtape 11:|r Porte en métal",
	[9999919] = "|cFFFFFFFFÉtape 12:|r Cube de sagesse",
	[9999920] = "|cFFFFFFFFÉtape 13:|r Plaque ternie",
	[9999946] = "Invoquer Baa'l",
	[13000000] = "|cFFFFFFFFÉtape 1:|r Acheter un Talisman Trouveur de Trésors Tangibles",
	[13000001] = "|cFFFFFFFFÉtape 2:|r Équiper le Talisman Trouveur de Trésors Tangibles",
	[13000002] = "|cFFFFFFFF"..AUCTION_HOUSE_HEADER_ITEM.." 1:|r Lotion scintillante murloc pour la peau",
	[13000003] = "Paillettes de branchies-irisées",
	[13000004] = "|cFFFFFFFFÉtape 1:|r Coquillage",
	[13000005] = "|cFFFFFFFFÉtape 2:|r Dent de grand requin non cariée",
	[13000006] = "|cFFFFFFFFÉtape 3:|r Larve d’anguille-scie",
	[13000007] = "|cFFFFFFFFÉtape 4:|r Poisson-docteur repu",
	[13000008] = "|cFFFFFFFFÉtape 5:|r Carapace de crabe fraîchement muée",
	[13000009] = "|cFFFFFFFFÉtape 6:|r Paillettes de branchies-irisées",
	[13000010] = "Plancton symbiotique",
	[13000011] = "|cFFFFFFFFÉtape 1:|r Coquillage",
	[13000012] = "|cFFFFFFFFÉtape 2:|r Rognure d’ongle de géant géante",
	[13000013] = "|cFFFFFFFFÉtape 3:|r Œil de makrura",
	[13000014] = "|cFFFFFFFFÉtape 4:|r Aileron d’hippocampe coupé accidentellement",
	[13000015] = "|cFFFFFFFFÉtape 5:|r Écaille de serpent de mer brillante",
	[13000016] = "|cFFFFFFFFÉtape 6:|r Plancton symbiotique",
	[13000017] = "Lotion scintillante murloc pour la peau",
	[13000018] = "|cFFFFFFFF"..AUCTION_HOUSE_HEADER_ITEM.." 2:|r Glaire gluante de gastéropode",
	[13000019] = "|cFFFFFFFFÉtape 1:|r Coquillage",
	[13000020] = "|cFFFFFFFFÉtape 2:|r Encre noire de calmar de Vantus",
	[13000021] = "|cFFFFFFFFÉtape 3:|r Gelée d’anguille super glissante",
	[13000022] = "|cFFFFFFFFÉtape 4:|r Coquille de bulot incrustée de pierres",
	[13000023] = "|cFFFFFFFFÉtape 5:|r Glaire gluante de gastéropode",
	[13000024] = "|cFFFFFFFF"..AUCTION_HOUSE_HEADER_ITEM.." 3:|r Bulle de cavitation emprisonnée",
	[13000025] = "|cFFFFFFFFÉtape 1:|r Coquillage",
	[13000026] = "|cFFFFFFFFÉtape 2:|r Très joli corail",
	[13000027] = "|cFFFFFFFFÉtape 3:|r Peau de raie-miroir iridescente",
	[13000028] = "|cFFFFFFFFÉtape 4:|r Écaille de luxécaille luxueuse",
	[13000029] = "|cFFFFFFFFÉtape 5:|r Bulle de cavitation emprisonnée",
	[13000030] = "Acheter un Monocle de cristal rouge",
	[13000031] = "Monocle de cristal rouge",
	[13000032] = "|cFFFFFFFFÉtape 3:|r Choisir un monocle (Ou pas !)",
	[13000033] = "|cFFFFFFFFÉtape 4:|r Raypons de Suramar",
	[13000034] = "|cFFFFFFFFÉtape 5:|r Code du Chat",
	[13000035] = "|cFFFFFFFFÉtape 6:|r Casse-tête de saut",
	[13000036] = "|cFFFFFFFFÉtape 7:|r Lave arcanique",
	[13000037] = "|cFFFFFFFFÉtape 8:|r Conscience collective",
});
for i,objectID in ipairs(ALLIANCE_BONFIRES) do ObjectNames[objectID] = "Feu de joie de l'Alliance"; end
for i,objectID in ipairs(CANDY_BUCKETS) do ObjectNames[objectID] = "Seau de bonbons"; end
for i,objectID in ipairs(HORDE_BONFIRES) do ObjectNames[objectID] = "Feu de joie de la Horde"; end
end
if simplifiedLocale == "it" then
localize(L.HEADER_NAMES, {
	[-1000006] = "Tiro Bonus",
	[-1000008] = "Prova di Classe",
	[-1000087] = "Assalti delle Congreghe",
	[-1000089] = "Potenziamenti al Santuario",
	[-1000092] = "Guarnigioni",
	[-1000132] = "Gladiatore Perfido",
	[-1000162] = "Aspetti Condivisi",
	[-1000163] = "Aspetto unico",
	[-1000168] = "I Cavalieri dell'Apocalisse",
	[-1000186] = "Assalto alla rocca",
	[-1000187] = "Sale della Pestilenza",
	[-1000201] = "Fiera di Lunacupa",
	[-1000203] = "Fiera di Lunacupa Gioco della Danza",
	[-1000204] = "Sfida dell'Uccello di Fuoco",
	[-1000205] = "Tiro a Segno",
	[-1000206] = "Pesta-lo-Gnoll",
	[-1000207] = "Giorno dei Morti",
	[-1000219] = "La gara di pesca dei Kalu'ak",
	[-1000223] = "Fuochi di Mezza Estate",
	[-1000226] = "Giorno dei Pirati",
	[-1000227] = "Gara di Pesca a Rovotorto",
	[-1000235] = "L'apertura del Portale Oscuro",
	[-1000236] = "Scettro delle Sabbie Mutevoli",
	[-1000261] = "Hearthstone Mercenari",
	[-1000305] = "Discarica",
	[-1000309] = "Assalto al Portale Oscuro",
	[-1000312] = "Confine degli Eoni",
	[-1000316] = "Rotolo di eventi",
	[-1000329] = "Rotolo di eventi",
	[-1000340] = "Specchio Rotto",
	[-1000341] = "Specchio Rotto",
	[-1000342] = "Specchio Rotto",
	[-1000343] = "Specchio Rotto",
	[-1000344] = "Specchio Rotto",
	[-1000345] = "Specchio Rotto",
	[-1000346] = "Specchio Rotto",
	[-1000347] = "Specchio Rotto",
	[-1000348] = "Specchio Rotto",
	[-1000349] = "Specchio Rotto",
	[-1000350] = "Specchio Rotto",
	[-1000351] = "Specchio Rotto",
	[-1000366] = "Un emissario avido",
	[-1000373] = "Nuovo personaggio",
	[-1000374] = "Razze Alleate",
	[-1000375] = "10° anniversario di Hearthstone",
	[-1000379] = "Premio",
	[-1000380] = "Premio",
	[-1000381] = "Cassa di Kukuru",
	[-1000853] = "Concilio di Guerra Sargerei",
	[-1000855] = "Squadra della Morte Abbandonata",
	[-1000856] = "Cacciatori Worgen",
	[-1000858] = "Cacciatori Dilettanti",
	[-1000862] = "Gladiatore Cataclismico: Season 11",
	[-1000865] = "Campo di battaglia: le Savane",
	[-1000869] = "L'invasione di ferro",
	[-1000870] = "L'incursione dei Troll",
	[-1000919] = "Armatura Retaggio",
	[-1000923] = "Manoscritto del Guardadraghi",
	[-1000924] = "Tempeste Primordiali",
	[-1000937] = "Cripte di Zskera",
	[-1000938] = "Il Fiutatutto",
	[-1000944] = "Baratto",
	[-1000945] = "Assalti di Fyrakk",
	[-1001034] = "Legami Elementali",
	[-1001035] = "Pesce di stagione: spigola estiva",
	[-1001036] = "Pesce di stagione: calamari invernali",
	[-1001045] = "Relazioni con gli Ospiti",
	[-1001059] = "Tempeste di Fuoco",
	[-1001060] = "Tempeste di Sabbia",
	[-1001061] = "Tempeste di Neve",
	[-1001062] = "Tempeste di Fulmini",
	[-1001095] = "|cffFF0000Ogom the Mangler sembra apparire solo quando stai eseguendo l'\"Assalto alle officine d'assedio di ferro\" giornaliero. Questa missione non era attiva dall'inizio di Legion e neanche la missione acquistabile \"Missiva: Assalto alle officine d'assedio di ferro\" funziona.|r",
	[-1001096] = "|cFFFFFFFFStep 1:|r Nota Vistosa",
});
localize(L.HEADER_DESCRIPTIONS, {
	[-1000162] = "Gli elementi in questo elenco sono aspetti condivisi per l'elemento precedente. Nella modalità Aspetto unico, questo elenco può aiutarti a capire perché o perché un oggetto specifico verrebbe contrassegnato come Raccolto.",
	[-1000163] = "Questo oggetto ha un aspetto unico. Devi raccogliere questo oggetto appositamente per guadagnare l'aspetto.",
	[-1000380] = "Questo elenco contiene elementi non ottenibili che ATT Discord ha segnalato come bug che Blizzard deve ancora correggere.\n\nNOTA: tutti i filtri vengono ignorati in questo elenco per motivi di visibilità. In questo elenco sono presenti solo gli oggetti rimossi dal gioco a causa di negligenza e non un gigantesco drago sputafuoco.\n\nAgli sviluppatori Blizzard: correggete gli oggetti e gli incontri elencati di seguito.",
	[-1000853] = "Pattuglia l'area approssimativamente in cerchio.",
	[-1000855] = "C'è una battaglia 4x4 in corso. Aiuta l'Alleanza sconfiggendo la Squadra della Morte dei Rinnegati.",
	[-1000856] = "C'è una battaglia 4x4 in corso. Aiuta l'Orda sconfiggendo i Worgen Stalker.",
	[-1000858] = "Tre cacciatori hanno circondato Mara Mantoveloce. Coinvolgili in combattimento e un forziere malconcio verrà generato vicino a Mara Swiftmane. Una volta terminata la battaglia, Mara ti ringrazierà e ti lascerà con il baule malconcio.",
});
localize(ObjectNames, {
	[31] = "Vecchia Statua di Leone",
	[34] = "Vecchio Fiasco",
	[35] = "Scrigno del Capitano",
	[36] = "Barile Spezzato",
	[47] = "Ricercato!",
	[55] = "Corpo Smangiucchiato",
	[56] = "Cadavere di Rolf",
	[60] = "Ricercato: Gath'ilzogg",
	[61] = "Tomba Rovinata",
	[256] = "Ricercato!",
	[257] = "Barile Sospetto",
	[259] = "Barile Mezzo Sepolto",
	[261] = "Cassa Danneggiata",
	[269] = "Barile Custodito di Birra del Tuono",
	[1557] = "Tavolo da Pranzo di Lillith",
	[1561] = "Cassa Sigillata",
	[1586] = "Cassa di Candele",
	[1609] = "Catapulta delle Fauci di Drago",
	[1627] = "Cassa di Dalaran",
	[1740] = "Documenti della Lega dei Tagliagole",
	[1765] = "Cassa di Legno Consumata",
	[2059] = "Cadavere di un Nano",
	[2076] = "Calderone Ribollente",
	[2083] = "Corrispondenza dei Velerosse",
	[2289] = "Scialuppa di Salvataggio Rovinata",
	[2553] = "Pergamena Zuppa",
	[2555] = "Pergamena Ammuffita",
	[2652] = "Cadavere di Ebenezer Rustlocke",
	[2688] = "Pietra Angolare",
	[2701] = "Frammento Iridescente",
	[2702] = "Pietra del Vincolo Interno",
	[2713] = "Bacheca dei Ricercati",
	[2734] = "Cassa Fradicia",
	[2868] = "Mappa Sgualcita",
	[2875] = "Scheletro Danneggiato di Nano",
	[2908] = "Cassa di Rifornimenti Sigillata",
	[3076] = "Mappa Macchiata",
	[3643] = "Vecchio Scrigno",
	[3972] = "RICERCATO",
	[4141] = "Console di Comando",
	[5620] = "Pietre del Potere Difettose",
	[6751] = "Strana Pianta da Frutto",
	[6752] = "Strana Pianta Frondosa",
	[7510] = "Pianta Rigogliosa",
	[15084] = "Lavatutto 5200",
	[15085] = "Lavatutto 5200",
	[17182] = "Transanalizzatore 827",
	[17183] = "Transanalizzatore 411",
	[19023] = "|cFFFFFFFFStep 7:|r Pagina 2.351",
	[19024] = "Santuario Nascosto",
	[20985] = "Terra Smossa",
	[20992] = "Scudo Nero",
	[21042] = "Distintivo della Guardia di Theramore",
	[21581] = "Le Conseguenze della Seconda Guerra",
	[21582] = "Oltre il Portale Oscuro",
	[21583] = "I Kaldorei e il Pozzo dell'Eternità",
	[32569] = "Forziere di Galen",
	[35251] = "Cassa di Karnitol",
	[61934] = "Braciere della Fiamma Sopita",
	[112888] = "Mensola Polverosa",
	[112948] = "Forziere Chiuso dell'Intrepida",
	[113757] = "Scrigno di Forgiascura",
	[123329] = "Cassa di Baelog",
	[125477] = "Urna Notevole",
	[131474] = "Dischi di Norgannon",
	[138492] = "Frammento di Myzrael",
	[141931] = "Uovo di Ippogrifo",
	[141979] = "Tesoro Antico",
	[142088] = "Tavoletta della Volontà",
	[142122] = "Manifesto dei Ricercati",
	[142151] = "Barile Sigillato",
	[142179] = "Padiglione di Solarsal",
	[142184] = "Cassa del Capitano",
	[142195] = "Piani di Battaglia degli Gnoll",
	[142343] = "Piedistallo di Uldum",
	[142475] = "Perforatrice per Matrici 3005-B",
	[142476] = "Perforatrice per Matrici 3005-C",
	[142487] = "Lavatutto 5200",
	[142696] = "Perforatrice per Matrici 3005-D",
	[142702] = "Bottiglia di Veleno",
	[143980] = "Pergamena dei Gordunni",
	[144063] = "Monolito Equinex",
	[148498] = "Altare di Suntara",
	[148502] = "|cFFFFFFFFStep 1:|r Pagina 9",
	[148504] = "Lapide Notevole",
	[152097] = "Braciere di Belnistrasz",
	[160836] = "Reliquiario",
	[160845] = "Forziere Oscuro",
	[161495] = "Cassaforte Segreta",
	[161505] = "Zattera Distrutta",
	[161521] = "Equipaggiamento Scientifico",
	[161526] = "Cassa di Cibo",
	[164659] = "Cristallo Energetico Verde",
	[164661] = "Cristallo Energetico Giallo",
	[164689] = "Monumento a Franclorn Forgiabruna",
	[164778] = "Cristallo Energetico Blu",
	[164780] = "Cristallo Energetico Rosso",
	[164820] = "Targa del Guardiano Oscuro",
	[164867] = "RICERCATO",
	[164868] = "UCCIDERE A VISTA",
	[164869] = "Calice Spettrale",
	[164909] = "Barca a Remi Distrutta",
	[164911] = "Barile di Birra dei Birratuono",
	[164953] = "Grosse Sacche in Pelle",
	[164954] = "Baccello Zukk'ash",
	[164955] = "Pilastro di Cristallo Settentrionale",
	[164956] = "Pilastro di Cristallo Occidentale",
	[164957] = "Pilastro di Cristallo Orientale",
	[164958] = "Germoglio Petalorosso",
	[165554] = "Cuore della Montagna",
	[169243] = "Cassa dei Sette",
	[173232] = "Progetti di Forgiatura",
	[173265] = "Latrina di Legno",
	[174682] = "Attenzione ai Pterrordattili",
	[174848] = "Equipaggiamento di Prova",
	[175227] = "Creatura Marina Arenata",
	[175245] = "Padre Fiamma",
	[175382] = "Scrigno del Portarovina",
	[175385] = "Tavoletta di Pietra Nera",
	[175586] = "Carro di Jaron",
	[175587] = "Cassa Danneggiata",
	[175724] = "Sargeras e il Tradimento",
	[175725] = "Gli Dei Antichi e l'Ordine di Azeroth",
	[175726] = "Le Cariche degli Stormi dei Draghi",
	[175727] = "La Guerra degli Antichi",
	[175729] = "Il Monte Hyjal e il Dono di Illidan",
	[175730] = "L'Albero del Mondo e il Sogno di Smeraldo",
	[175731] = "L'Esilio degli Alti Elfi",
	[175732] = "Le Sentinelle e la Lunga Attesa",
	[175733] = "La Fondazione di Quel'Thalas",
	[175734] = "Arathor e le Guerre dei Troll",
	[175735] = "I Guardiani di Tirisfal",
	[175736] = "Forgiardente - Il Risveglio dei Nani",
	[175737] = "I Sette Regni",
	[175738] = "Aegwynn e la Caccia ai Draghi",
	[175739] = "La Guerra dei Tre Martelli",
	[175740] = "L'Ultimo Guardiano",
	[175741] = "Kil'jaeden e il Patto dell'Ombra",
	[175742] = "L'Ascesa dell'Orda",
	[175745] = "Il Portale Oscuro e la Caduta di Roccavento",
	[175746] = "L'Alleanza di Lordaeron",
	[175747] = "L'Invasione di Draenor",
	[175748] = "La Nascita del Re dei Lich",
	[175749] = "La Corona di Ghiaccio e il Trono di Ghiaccio",
	[175750] = "La Battaglia di Grim Batol",
	[175751] = "Il Letargo degli Orchi",
	[175752] = "La Nuova Orda",
	[175753] = "La Guerra del Ragno",
	[175754] = "Kel'Thuzad e la Nascita del Flagello",
	[175756] = "Il Flagello di Lordaeron",
	[175757] = "Il Pozzo Solare - La Caduta di Quel'Thalas",
	[175758] = "Il Ritorno di Archimonde e il Viaggio Verso Kalimdor",
	[175759] = "L'Ascesa del Traditore",
	[175760] = "L'Ascesa degli Elfi del Sangue",
	[175761] = "La Guerra Civile nelle Terre Infette",
	[175762] = "Il Trionfo del Re dei Lich",
	[175763] = "Vecchi Rancori - La Colonizzazione di Kalimdor",
	[175854] = "Gli Imperi Gemelli",
	[175855] = "La Caduta degli Imperi",
	[175856] = "La Furia dello Scortica Anime",
	[175886] = "Picca a Spuntoni",
	[175925] = "Latrina",
	[175949] = "Quinta Tavoletta Mosh'aru",
	[175950] = "Sesta Tavoletta Mosh'aru",
	[175966] = "Filo Scarlatto Incantato",
	[175970] = "Pettorale Corazzato Runico Non Forgiato",
	[176089] = "Guanti Lunghi a Piastre non Fusi",
	[176090] = "Resti di Umanoide",
	[176091] = "Calderone dei Legnomorto",
	[176112] = "Forziere di Malor",
	[176116] = "Testa della Bambola di Pamela",
	[176142] = "Parte Sinistra della Bambola di Pamela",
	[176143] = "Parte Destra della Bambola di Pamela",
	[176190] = "Tartaruga Marina Arenata",
	[176196] = "Tartaruga Marina Arenata",
	[176249] = "Dati sul Flagello",
	[176325] = "Progetti di Forgiatura",
	[176392] = "Calderone del Flagello",
	[176582] = "Trappola per Crostacei",
	[176631] = "Dono di Menethil",
	[177544] = "Cassa di Joseph",
	[177667] = "Pergamena Strappata",
	[177786] = "Cassa di Rackmore",
	[177787] = "Diario di Rackmore",
	[177964] = "Pietra Profonda",
	[178609] = "Neve Festiva",
	[179485] = "Trappola Rotta",
	[179499] = "Cestello di Colorante Ogre",
	[179517] = "Il Tesoro degli Shen'dralar",
	[179545] = "Cassa del Principe",
	[179552] = "Schema: Robot di Riparazione 74A",
	[179559] = "Frammento di Vil Vite",
	[179564] = "Tributo dei Gordok",
	[179697] = "Cassa del Tesoro dell'Arena",
	[179703] = "Cassa del Signore del Fuoco",
	[179832] = "Cuscino Decorato di Pillaclencher",
	[179879] = "Globo del Comando",
	[179880] = "Marchio di Drakkisath",
	[180327] = "Braciere della Follia",
	[180448] = "Manifesto dei Ricercati: Chelafunesta",
	[180456] = "Pietra del Vento Minore",
	[180461] = "Pietra del Vento",
	[180466] = "Pietra del Vento Maggiore",
	[180503] = "Libro di Ricette Insabbiato",
	[180570] = "Barile",
	[180633] = "Lacrima di Cristallo",
	[180642] = "Cassa Incospicua",
	[180658] = "Banco di Pesci Mutanti",
	[180662] = "Rottami di Goletta",
	[180665] = "Draconico per Negati",
	[180666] = "Draconico per Negati",
	[180667] = "Draconico per Negati",
	[180682] = "Banco di Boccanera Oleosi",
	[180684] = "Banco di Gran Pescisalvia",
	[180685] = "Rottami Fradici",
	[180690] = "Grande Forziere dello Scarabeo",
	[180691] = "Forziere dello Scarabeo",
	[180712] = "Banco di Anguille Squamapietra",
	[180743] = "Regalo Incartato con Cura",
	[180746] = "Dono Dolcemente Scosso",
	[180747] = "Regalo Incartato Gioiosamente",
	[180748] = "Regalo Ticchettante",
	[180751] = "Rottami Galleggianti",
	[180793] = "Dono Festivo",
	[180796] = "Trasmutometro Invernale PX-238",
	[180901] = "Rottami dei Velerosse",
	[180918] = "Ricercato: Thaelis il Famelico",
	[181011] = "Diario del Magistro Lungovespro",
	[181073] = "Calderone Profumato",
	[181085] = "Cassa di Rifornimenti di Stratholme",
	[181147] = "Manifesto dei Ricercati",
	[181150] = "Diario Impolverato",
	[181153] = "Manifesto dei Ricercati: Kel'gash il Perfido",
	[181366] = "Cassa dei Cavalieri dell'Apocalisse",
	[181638] = "Manifesto dei Ricercati",
	[181649] = "Diario di Barbapiuma",
	[181665] = "Cassa Funebre",
	[181698] = "Pietra del Vuoto",
	[181748] = "Cristallo di Sangue",
	[181756] = "Antico Libro Rovinato",
	[181889] = "Manifesto dei Ricercati",
	[182032] = "Diario di Galaen",
	[182053] = "Cappaluce",
	[182115] = "Manifesto dei Ricercati",
	[182165] = "Manifesto dei Ricercati",
	[182196] = "Contenitore Arcano",
	[182197] = "Contenitore Arcano",
	[182198] = "Contenitore Arcano",
	[182392] = "Bacheca di Garadar",
	[182393] = "Bacheca di Telaar",
	[182549] = "Piani dei Vilorchi",
	[182587] = "Manifesto dei Ricercati",
	[182588] = "Manifesto dei Ricercati",
	[182947] = "Il Codice del Sangue",
	[182952] = "Rottami di Pompa del Vapore",
	[182953] = "Banco di Pescispora",
	[182954] = "Banco di Pesci d'Acqua Salmastra",
	[182956] = "Banco di Pesci Persico",
	[182957] = "Banco di Pesci delle Alture",
	[182958] = "Banco di Pescifango",
	[182959] = "Banco di Pesci Azzurri",
	[183284] = "Manifesto dei Ricercati",
	[183385] = "Ibisco Vermiglio",
	[183770] = "Console di Comando B'naar",
	[183811] = "Manifesto dei Ricercati",
	[183877] = "Pannello di Controllo del Teletrasporto Etereo",
	[184300] = "Focalizzatore Negromantico",
	[184465] = "Cassa della Legione",
	[184660] = "Manifesto dei Ricercati",
	[184793] = "Cassa Primitiva",
	[184825] = "Tomo Lashh'an",
	[184945] = "Manifesto dei Ricercati",
	[184946] = "Manifesto dei Ricercati",
	[185035] = "Manifesto dei Ricercati",
	[185119] = "Cassa Impolverata",
	[185126] = "Prigione di Cristallo",
	[185165] = "Comunicatore della Legione",
	[185166] = "Manifesto dei Ricercati",
	[185168] = "Cassa Rinforzata di Vilferro",
	[185302] = "Cassa di Fei Fei",
	[185522] = "Camera di Stasi degli Shaffar",
	[186183] = "Barile Festivo dei Maltorzo",
	[186184] = "Barile Festivo dei Birratuono",
	[186185] = "Barile Festivo Gordok",
	[186186] = "Barile Festivo della Distilleria di Drohn",
	[186187] = "Barile Festivo di Birra Vudù di T'chali",
	[186267] = "Santuario della Zucca",
	[186426] = "Manifesto dei Ricercati",
	[186585] = "Rotolo di Pelle di Drago",
	[186887] = "Grande Jack Lanterna",
	[187236] = "Regalo di Grande Inverno",
	[187273] = "Impronta di Zoccolo Sospetta",
	[187367] = "Bivalve di Pinnafredda",
	[187565] = "Anziano Atkanok",
	[187851] = "Santuario dei Cultisti",
	[187905] = "Uovo Rilucente Enorme",
	[188085] = "Grano Infetto",
	[188192] = "Cassa di Ghiaccio",
	[188261] = "Diario Rovinato",
	[188364] = "Trappola per Granchi Distrutta",
	[188365] = "Cuore degli Antichi",
	[188367] = "Sismografo Portatile",
	[188418] = "Ricercato!",
	[188419] = "Anziano Mana'loa",
	[188501] = "Pezzo di Golem da Guerra",
	[188502] = "Pezzo di Golem da Guerra",
	[188503] = "Pezzo di Golem da Guerra",
	[188649] = "Manifesto dei Ricercati",
	[188667] = "Frutto d'Ibisco",
	[189311] = "Tomo Rilegato con la Carne",
	[189989] = "Relitto della Trivella dei Ferroscuro",
	[189990] = "Relitto della Trivella dei Ferroscuro",
	[190020] = "Ricercato!",
	[190447] = "Motore della Macchina Volante",
	[190453] = "Pezzi di Ricambio della S.P.R. &amp; Co.",
	[190454] = "Pezzi di Ricambio della S.P.R. &amp; Co.",
	[190455] = "Pezzi di Ricambio della S.P.R. &amp; Co.",
	[190622] = "Liana Resistente",
	[190623] = "Papaia",
	[190624] = "Arancia",
	[190625] = "Casco di Banane",
	[190643] = "Punch della Giungla dei Birratuono",
	[190768] = "Forziere Consumato dal Tempo",
	[190917] = "Posta Abbandonata",
	[190936] = "Calderone della Piaga",
	[191543] = "Baule della Furia Scarlatta",
	[191728] = "Ricercato!",
	[191760] = "Console della Biblioteca dell'Intelletto",
	[191761] = "Console dei Prototipi",
	[191766] = "Ordini da Drakuru",
	[192046] = "Banco di Dragonetti",
	[192048] = "Banco di Pesci Angelo Pinnadrago",
	[192049] = "Banco di Aringhe Zannute",
	[192050] = "Banco di Salmoni Nordici",
	[192051] = "Banco di Meduse Boreali",
	[192052] = "Banco di Mante Imperiali",
	[192053] = "Banco di Pesci Palla Oceanici",
	[192054] = "Banco di Seppie di Lunafulgida",
	[192057] = "Banco di Ragnoli",
	[192059] = "Banco di Pesci di Vetro",
	[192060] = "Incudine di Fjorn",
	[192071] = "Incudine di Fjorn",
	[192072] = "Cassa degli Arpioni",
	[192078] = "Corno di Hodir",
	[192079] = "Lancia di Hodir",
	[192080] = "Elmo di Hodir",
	[192524] = "Arngrim l'Insaziabile",
	[192708] = "Guida Pratica alle Scuole della Magia Arcana - Introduzione",
	[192709] = "Guida Pratica alle Scuole della Magia Arcana - Abiurazione",
	[192710] = "Guida Pratica alle Scuole della Magia Arcana - Evocazione",
	[192711] = "Guida Pratica alle Scuole della Magia Arcana - Divinazione",
	[192713] = "Guida Pratica alle Scuole della Magia Arcana - Incantamento",
	[192818] = "Fungo Umido",
	[192827] = "Senape Selvatica",
	[192828] = "Carota della Foresta di Cristallo",
	[192833] = "Spada di Bridenbrad",
	[192865] = "Guida Pratica alle Scuole della Magia Arcana - Illusione",
	[192866] = "Guida Pratica alle Scuole della Magia Arcana - Negromanzia",
	[192867] = "Guida Pratica alle Scuole della Magia Arcana - Trasmutazione",
	[193195] = "Cristallo Pulsante",
	[193400] = "Pila di Bombe di Saronite",
	[193402] = "Scrigno Arrugginito del Prigioniero",
	[193426] = "Cassa dei Cavalieri dell'Apocalisse",
	[194092] = "Urna Annerita",
	[194105] = "Transanalizzatore 413",
	[194122] = "Transanalizzatore 723",
	[194213] = "Giacinto Invernale",
	[194238] = "Lama di Drak'Mar",
	[194378] = "Documento Rubato della Lega degli Esploratori",
	[194387] = "Documento Rubato della Lega degli Esploratori",
	[194388] = "Documento Rubato della Lega degli Esploratori",
	[194389] = "Documento Rubato della Lega degli Esploratori",
	[194390] = "Documento Rubato della Lega degli Esploratori",
	[194391] = "Documento Rubato della Lega degli Esploratori",
	[194479] = "Pozza di Sangue",
	[194555] = "Console dell'Archivum",
	[194618] = "Rastrelliera delle Lance",
	[194622] = "Rastrelliera delle Lance",
	[194714] = "Tavolo da Lavoro Disgustoso",
	[194908] = "Rastrelliera delle Lance",
	[194909] = "Rastrelliera delle Lance",
	[195134] = "La Bomba",
	[195431] = "Radio del Quartier Generale",
	[195433] = "Antiche Tavolette",
	[195435] = "Armadietto delle Armi",
	[195438] = "Coppa di Elune",
	[195445] = "Antico Monolito del Vortice",
	[195497] = "Braciere di Elune",
	[195517] = "Vergine di Elune",
	[195600] = "Pietra Ardente",
	[195642] = "Pietra del Potere Naga",
	[195676] = "Raucofono del Laboratorio Segreto",
	[196393] = "Reliquia Danneggiata",
	[196394] = "Cassa di Essenza di Mandragora",
	[196832] = "Remotovisore Superiore",
	[196833] = "Remotovisore Inferiore",
	[201578] = "Cartello di Reclutamento dei Forzatori",
	[201873] = "Armeria della Cannoniera",
	[202080] = "Nido di Dart",
	[202081] = "Nido di Takk",
	[202082] = "Nido della Matriarca Devasauro",
	[202083] = "Nido della Matriarca Boccaguzza",
	[202135] = "Tomba di Dadanga",
	[202180] = "Armeria della Cannoniera",
	[202407] = "Cassa dei Raschiasabbia",
	[202474] = "Arca Antidiluviana",
	[202598] = "Detonatore Grande e Grosso",
	[202613] = "Pannello di Controllo della Piattaforma",
	[202655] = "Ritrovamento Archeologico Troll",
	[202697] = "Occhio del Crepuscolo",
	[202701] = "Nascondiglio della Latrina",
	[202706] = "Calderone del Crepuscolo",
	[202712] = "Testi Apocrifi del Crepuscolo",
	[202776] = "Banco di Trote Fario",
	[202777] = "Banco di Bavose delle Alture",
	[202778] = "Banco di Pesci Cavernicoli Albini",
	[202779] = "Banco di Pescifango Ventrenero",
	[202780] = "Banco di Anguille Abissali",
	[202871] = "Cassa Affondata",
	[202975] = "Latrina Sommersa",
	[203071] = "Ritrovamento Archeologico Elfico",
	[203078] = "Ritrovamento Archeologico Nerubiano",
	[203128] = "Bottiglia Rotta",
	[203134] = "Piedistallo Vuoto",
	[203140] = "Forcone Spezzato",
	[203186] = "ALLA LARGA!",
	[203207] = "Codice delle Ombre",
	[203301] = "Tridenti Naga",
	[203305] = "Crogiolo di Nazsharin",
	[203733] = "Bacheca delle Taglie",
	[203734] = "Atto delle Marche Occidentali",
	[203755] = "Cartello di Reclutamento dei Forzatori",
	[204050] = "Progetti dell'Ira del Mare",
	[204274] = "Diario del Capitano",
	[204282] = "Ritrovamento Archeologico Nanico",
	[204344] = "Ricercato!",
	[204351] = "Globo di Controllo Ettin",
	[204372] = "Portale di Zanzil",
	[204386] = "Portale di Zanzil",
	[204406] = "Bottiglia Mezza Sepolta",
	[204437] = "Sacca della Chiave dei Roccianera",
	[204450] = "Carte del Capitano Acquaferma",
	[204578] = "Barile di Doppiorum",
	[204817] = "Verga Forgiata nella Luce",
	[204824] = "Arco Forgiato nella Luce",
	[204825] = "Scudo Forgiato nella Luce",
	[204959] = "Formazione Gigante di Painite",
	[205134] = "Diario del Mastro Forgiatore",
	[205143] = "Latrina Abbandonata",
	[205198] = "Mucchio di Esplosivi",
	[205207] = "Diario di Maziel",
	[205258] = "Cassa di Armi Rotta",
	[205266] = "Disco Lavorato",
	[205332] = "Manifesto dei Ricercati",
	[205350] = "Pannello di Comunicazione dell'Orda",
	[205476] = "Libro delle Anime Perdute",
	[205477] = "Lingotti d'Acciaio Lunare",
	[205479] = "Legno di Luna Lucente",
	[205540] = "Scheletro Decrepito",
	[205874] = "Geroglifici Coperti dalla Sabbia",
	[205875] = "Bengala del Crociato",
	[206109] = "Bacheca degli Ordini del Capoguerra",
	[206111] = "Bacheca degli Eroi",
	[206116] = "Bacheca degli Ordini del Capoguerra",
	[206293] = "Terminale A.I.D.A.",
	[206294] = "Bacheca degli Eroi",
	[206335] = "Lastrone di Pietra",
	[206336] = "Lastra di Marmo",
	[206374] = "Manufatto dei Guardiani",
	[206504] = "Appunto Finale di Rhea",
	[206569] = "Occhio del Crepuscolo",
	[206585] = "Totem di Ruumbo",
	[206836] = "Ritrovamento Archeologico Fossile",
	[206944] = "Badile",
	[207104] = "Pompa di Controllo Principale",
	[207125] = "Cassa di Provviste Avanzate",
	[207179] = "Calderone dei Freddinverno",
	[207187] = "Ritrovamento Archeologico Orchesco",
	[207188] = "Ritrovamento Archeologico Draenei",
	[207189] = "Ritrovamento Archeologico Vrykul",
	[207190] = "Ritrovamento Archeologico Tol'vir",
	[207279] = "Bacheca degli Ordini del Capoguerra",
	[207303] = "Bacheca degli Avventurieri",
	[207304] = "Bacheca degli Avventurieri",
	[207320] = "Bacheca degli Eroi",
	[207321] = "Bacheca degli Eroi",
	[207322] = "Bacheca degli Eroi",
	[207323] = "Bacheca degli Ordini del Capoguerra",
	[207324] = "Bacheca degli Ordini del Capoguerra",
	[207325] = "Bacheca degli Ordini del Capoguerra",
	[207359] = "Uovo Puro del Crepuscolo",
	[207406] = "Strana Fontana",
	[207407] = "Pilastro Spezzato",
	[207408] = "Braciere Magico",
	[207409] = "Tomba dei Tol'vir",
	[207410] = "Grande Obelisco di Pietra",
	[207411] = "Cumulo d'Ossa Nanico",
	[207412] = "Tavoletta di Pietra",
	[207496] = "Baule del Tesoro di Ferroscuro",
	[207497] = "Baule del Tesoro di Ferroscuro",
	[207498] = "Baule del Tesoro di Ferroscuro",
	[207500] = "Baule del Tesoro di Ferroscuro",
	[207724] = "Pezzi del Relitto",
	[208311] = "Banco di Pescisalvia Oceanici",
	[208316] = "Bacheca degli Eroi",
	[208317] = "Bacheca degli Ordini del Capoguerra",
	[208365] = "Mucchio di Terra Recentemente Smosso",
	[208535] = "Ghianda Essiccata",
	[208549] = "Pila Vudù",
	[208550] = "Pila Vudù",
	[208825] = "Santuario degli Antenati",
	[208900] = "Portale per le Terre del Fuoco",
	[209072] = "Cassa Rubata",
	[209076] = "Cassa di Anson",
	[209094] = "Cassa Rubata",
	[209095] = "Cassa di Edgar",
	[209270] = "|cFFFFFFFFStep 2:|r Pagina 78",
	[209344] = "Attrezzo da Frutteto",
	[209345] = "Attrezzo da Frutteto",
	[209436] = "Arancia Matura",
	[209462] = "Canna di Rattan",
	[209497] = "Dolce Rubato",
	[209550] = "Fascio di Fogliarossa",
	[209620] = "Baule del Tesoro di Lunacupa",
	[209673] = "Statua di Tigre di Giada",
	[209699] = "Cong di Giada",
	[209700] = "Ciotola Rituale Scheggiata",
	[209701] = "Candela Rituale Profumata",
	[209825] = "Fungo delle Maree",
	[209836] = "Petali Appena Caduti",
	[209842] = "Tofu Piccante di Pang",
	[209843] = "Anguria Estiva di Ang",
	[209844] = "Rapa Gigante di Ang",
	[209845] = "Birra Ghiotta",
	[209863] = "Pezzo di Giada",
	[209891] = "Rapa Rubata",
	[209892] = "Anguria Rubata",
	[209903] = "Ramo Verde",
	[209907] = "Calendula di Prato",
	[209921] = "Acqua Fangosa",
	[209951] = "Bozzolo di Seta",
	[209952] = "Giadaluna",
	[209953] = "Uovo di Sterna Imperatrice",
	[209954] = "Uovo di Gru dalla Cresta Rossa",
	[209955] = "Uovo di Zampalunga dal Becco Cornuto",
	[210001] = "Sacco di Grano Rubato",
	[210002] = "Sacco di Grano Rubato",
	[210005] = "Rastrelliera delle Armi",
	[210015] = "Rastrelliera delle Armi",
	[210016] = "Rastrelliera delle Armi",
	[210017] = "Rastrelliera delle Armi",
	[210018] = "Rastrelliera delle Armi",
	[210019] = "Rastrelliera delle Armi",
	[210020] = "Rastrelliera delle Armi",
	[210184] = "Pescefango Viscido",
	[210186] = "Pescefango Viscido",
	[210188] = "Favo Levigato dalla Pioggia",
	[210209] = "Loto Imperiale",
	[210228] = "Vaso con Pigmento",
	[210229] = "Acqua della Giovinezza",
	[210238] = "Uovo di Serpe",
	[210239] = "Uovo di Serpe",
	[210240] = "Uovo di Serpe",
	[210416] = "Manufatto dei Mogu",
	[210417] = "Manufatto dei Mogu",
	[210418] = "Manufatto dei Mogu",
	[210565] = "Terreno Smosso",
	[210582] = "Terreno Smosso",
	[210759] = "Freccia dei Pandaren",
	[210887] = "Rifornimenti Incontaminati",
	[211017] = "Tubero",
	[211018] = "Tubero",
	[211019] = "Tubero",
	[211023] = "Pentolone di Ferro",
	[211143] = "Reliquia dei Mogu",
	[211147] = "Reliquia dei Mogu",
	[211148] = "Reliquia dei Mogu",
	[211266] = "Scorte Rubate",
	[211268] = "Scorte Rubate",
	[211269] = "Scorte Rubate",
	[211270] = "Scorte Rubate",
	[211312] = "Barile di Esplosivi",
	[211379] = "Assi di Scarto",
	[211382] = "Alghe Robuste",
	[211420] = "Mucchio di Sabbia",
	[211451] = "Dono Ceruleo della Gru Maestosa",
	[211452] = "Dono Bronzeo della Gru Maestosa",
	[211454] = "Cespuglio di Kafa'kota",
	[211480] = "Bacche di Kafa'kota",
	[211506] = "Vaso di Pece",
	[211507] = "Vaso di Pece",
	[211510] = "Proprietà del Saggio Liao",
	[211517] = "Rampitorto",
	[211518] = "Rampitorto",
	[211536] = "Borsa di Portabene Rubati",
	[211537] = "Borsa di Portabene Rubati",
	[211538] = "Borsa di Portabene Rubati",
	[211566] = "Totem di Vento Pallido",
	[211684] = "Boccioli Volatili",
	[211696] = "Sacco di Luppolo Rubato",
	[211719] = "Violetta al Limone",
	[211721] = "Violetta al Limone",
	[211754] = "Testo Bizzarro",
	[211770] = "Tavoletta della Dinastia Shen",
	[211780] = "Testo Bizzarro",
	[211793] = "Tavoletta della Dinastia Wai",
	[211794] = "Tavoletta della Dinastia Qiang",
	[211807] = "Cassa dei Mogu",
	[211863] = "Arto di Krik'thik",
	[211871] = "Globo del Terrore",
	[211872] = "Globo del Terrore",
	[211873] = "Globo del Terrore",
	[211967] = "Forziere del Re",
	[211990] = "Mokkan del Linguaggio degli Hozen",
	[211993] = "Mokkan della Maturità degli Hozen",
	[211994] = "Mokkan dei Saccheggi degli Hozen",
	[212003] = "Barile di Petrolio degli Yaungol",
	[212009] = "Frammento d'Ambra",
	[212079] = "Reliquia dei Mantid",
	[212135] = "Frecce Incendiarie degli Shandaren",
	[212136] = "Frecce Incendiarie degli Shandaren",
	[212181] = "Statua Antica",
	[212278] = "Barile degli Unga Protetto",
	[212389] = "Pergamena del Presagio",
	[212540] = "Barile Perduto",
	[212541] = "Set di Boccali Perduti",
	[212553] = "Attrezzatura da Picnic Perduta",
	[212902] = "Blocco d'Ambra Solidificato",
	[212923] = "Portagiare d'Ambra",
	[212987] = "Stella Marina Spinosa",
	[212988] = "Stella Marina Spinosa",
	[213267] = "Ombra del Terrore",
	[213327] = "Mokkan dei Saurok",
	[213328] = "Mokkan dell'Insolenza",
	[213329] = "Mokkan dei Disertori",
	[213330] = "Mokkan dell'Ultima Difesa",
	[213331] = "Mokkan della Valle degli Imperatori",
	[213332] = "Mokkan della Dinastia Perduta",
	[213333] = "Mokkan dei Vincolaspiriti",
	[213334] = "Mokkan del Re del Tuono",
	[213362] = "Baule della Nave",
	[213363] = "Daga Fendimantid di Wodin",
	[213364] = "Antico Piccone dei Pandaren",
	[213366] = "Antica Teiera dei Pandaren",
	[213368] = "Moneta dei Pandaren Fortunata",
	[213407] = "Testamento di Quan Tou Kuo Doppio Pugno",
	[213409] = "Mokkan del Ciclo dei Mantid",
	[213410] = "Mokkan della Società dei Mantid",
	[213411] = "Mokkan dell'Ambra",
	[213412] = "Mokkan dell'Imperatrice",
	[213413] = "Mokkan delle Tattiche di Combattimento dei Pandaren",
	[213414] = "Mokkan del Ricordo Imperituro",
	[213415] = "Mokkan dei Primi Monaci",
	[213416] = "Mokkan della Forza del Gruppo",
	[213417] = "Mokkan delle Tattiche degli Yaungol",
	[213418] = "Mokkan del Dominio",
	[213420] = "Mokkan dei Prigionieri in una Terra Straniera",
	[213421] = "Mokkan del Fardello dell'Imperatore - Parte 3",
	[213422] = "Mokkan del Fardello dell'Imperatore - Parte 4",
	[213438] = "Storia di Ren Yun il Cieco",
	[213443] = "Mokkan del Fardello dell'Imperatore - Parte 6",
	[213445] = "Mokkan del Fardello dell'Imperatore - Parte 5",
	[213454] = "Scrigno di Libeccio",
	[213455] = "Mokkan del Fardello dell'Imperatore - Parte 7",
	[213456] = "Mokkan del Fardello dell'Imperatore - Parte 8",
	[213459] = "Mokkan della Gioventù di Liu Lang",
	[213460] = "Mokkan della Bottega di Shen-Zin",
	[213461] = "Mokkan della Vedova Errante",
	[213511] = "Mokkan della Vittoria nel Kun-Lai",
	[213512] = "Testamento di Xin Wo Yin Cuore Infranto",
	[213649] = "Cassa di Beni Rubati",
	[213650] = "Scrigno del Tesoro dei Leproratti",
	[213651] = "Baule di Equipaggiamenti",
	[213653] = "Lancia da Pesca dei Pandaren",
	[213741] = "Antico Bastone dei Jinyu",
	[213742] = "Martello dei Dieci Tuoni",
	[213748] = "Pietra Rituale dei Pandaren",
	[213749] = "Bastone del Maestro Nascosto",
	[213750] = "Tavoletta di Pietra dei Saurok",
	[213751] = "Vesti di Stoffa del Folletto",
	[213765] = "Tavoletta di Ren Yun",
	[213767] = "Tesoro Nascosto",
	[213768] = "Lancia del Guerriero Hozen",
	[213769] = "Scrigno del Tesoro degli Hozen",
	[213770] = "Tesoro Rubato del Folletto",
	[213771] = "Statua di Xuen",
	[213774] = "Effetti Personali dell'Avventuriero Perduto",
	[213782] = "Testa di Terracotta",
	[213793] = "Scrigno di Riggatigga",
	[213795] = "Ricette dei Triplo Malto",
	[213842] = "Nascondiglio delle Armi degli Yaungol",
	[213844] = "Falena Imprigionata nell'Ambra",
	[213845] = "Martello della Follia",
	[213956] = "Frammento di Terrore",
	[213959] = "Linfa di Kri'vess Indurita",
	[213960] = "Fuoco Portatile degli Yaungol",
	[213961] = "Cassa di Oggetti Abbandonata",
	[213962] = "Pugnale Veloce del Razziatore del Vento",
	[213964] = "Lancia Animosa di Malik",
	[213966] = "Collana Imprigionata nell'Ambra",
	[213967] = "Lama di Prima Qualità",
	[213968] = "Mannaia Ronzante di Ka'roz",
	[213969] = "Bastone della Mutazione del Vivisezionatore",
	[213970] = "Frammento di Chitina Insanguinato",
	[213971] = "Medaglione del Custode dello Sciame",
	[213972] = "Lama della Mente Velenosa",
	[213973] = "Ripetitore Sonico dei Klaxxi",
	[214062] = "Ambra Luminosa",
	[214170] = "Uovo dei Vor'thik",
	[214175] = "Sacca di Rifornimenti dei Wu Kao",
	[214325] = "Scrigno Dimenticato",
	[214337] = "Nascondiglio delle Gemme",
	[214338] = "Offerta di Ricordo",
	[214339] = "Cassa di Provviste",
	[214340] = "Istruzioni per Costruire una Nave",
	[214403] = "Mucchio di Fogli",
	[214407] = "Cassa del Tesoro di Mo-Mo",
	[214438] = "Antica Tavoletta dei Mogu",
	[214439] = "Barile di Rum alla Banana",
	[214562] = "Cristallo Infestato dallo Sha",
	[214871] = "Distruttore Infranto",
	[214903] = "Tan-Chao",
	[214945] = "Uovo d'Onice",
	[214962] = "Mortaio per Fuochi d'Artificio Requisito",
	[215705] = "Santuario dei Coltivatori",
	[215765] = "Mokkan dell'Attesa della Tartaruga",
	[215779] = "Mokkan della Forgiatura Con l'Acqua",
	[215780] = "Mokkan degli Oratori dell'Acqua",
	[215782] = "Mokkan delle Origini",
	[215783] = "Mokkan della Divisione dei Ruoli",
	[215785] = "Mokkan dell'Abbraccio delle Passioni",
	[215797] = "Mokkan del Fardello dell'Imperatore - Parte 2",
	[215798] = "Mokkan del Petrolio degli Yaungol",
	[215799] = "Mokkan del Fardello dell'Imperatore - Parte 1",
	[215844] = "Asta della Bandiera",
	[216322] = "Bacheca delle Taglie",
	[216362] = "Barile di Birra Metallica",
	[216761] = "Banco di Pesci Oceanici",
	[216764] = "Banco di Pescisalvia",
	[218055] = "Lama Infusa dai Loa",
	[218056] = "Lama Infusa dai Loa",
	[218059] = "Pozione degli Zandalari",
	[218427] = "Mokkan della Maturità",
	[218428] = "Mokkan del Concilio e del Re",
	[218429] = "Mokkan delle Ombre dei Loa",
	[218430] = "Mokkan del Profeta Oscuro Zul",
	[218432] = "Mokkan della Montagna Sacra",
	[218433] = "Mokkan del Prezzo dell'Unità",
	[218434] = "Mokkan del Problema dei Pandaren",
	[218435] = "Mokkan degli Agenti dell'Ordine",
	[218436] = "Mokkan dell'Ombra, della Tempesta e della Pietra",
	[218437] = "Mokkan della Maledizione e del Silenzio",
	[218438] = "Mokkan dell'Era dei Cento Re",
	[218593] = "Tesoro del Re del Tuono",
	[218750] = "Incarichi di Lavoro",
	[218853] = "Forziere Tempestoso",
	[220641] = "Cassa degli Spaccatuono",
	[220807] = "Cristallo Fatato Imperituro",
	[220815] = "Crollo",
	[220820] = "|cFFFFFFFFStep 6:|r Pagina 1.127",
	[220821] = "|cFFFFFFFFStep 5:|r Pagina 845",
	[220832] = "Tesoro Sommerso",
	[220901] = "Cassa del Tesoro Rilucente",
	[220902] = "Cassa del Tesoro delle Corde",
	[220903] = "Statua di Gru Ronzante",
	[220904] = "Martello Spaccapietre",
	[220908] = "Cassa del Tesoro Coperta di Nebbia",
	[220986] = "Cassa del Tesoro della Guardia Nera",
	[220994] = "Cassa Senza Tempo",
	[220995] = "Cassa Senza Tempo",
	[220996] = "Cassa Senza Tempo",
	[220997] = "Cassa Senza Tempo",
	[220998] = "Cassa Senza Tempo",
	[220999] = "Cassa Senza Tempo",
	[221000] = "Cassa Senza Tempo",
	[221001] = "Cassa Senza Tempo",
	[221002] = "Cassa Senza Tempo",
	[221003] = "Cassa Senza Tempo",
	[221004] = "Cassa Senza Tempo",
	[221005] = "Cassa Senza Tempo",
	[221006] = "Cassa Senza Tempo",
	[221007] = "Cassa Senza Tempo",
	[221008] = "Cassa Senza Tempo",
	[221009] = "Cassa Senza Tempo",
	[221010] = "Cassa Senza Tempo",
	[221013] = "Cassa Senza Tempo",
	[221014] = "Cassa Senza Tempo",
	[221015] = "Cassa Senza Tempo",
	[221016] = "Cassa Senza Tempo",
	[221017] = "Cassa Senza Tempo",
	[221018] = "Cassa Senza Tempo",
	[221019] = "Cassa Senza Tempo",
	[221020] = "Cassa Senza Tempo",
	[221021] = "Cassa Senza Tempo",
	[221023] = "Cassa Senza Tempo",
	[221024] = "Cassa Senza Tempo",
	[221026] = "Cassa Senza Tempo",
	[221027] = "Guscio Stranamente Vuoto",
	[221036] = "Sacca del Tesoro Rilucente",
	[221376] = "Frammento di una Vecchia Insegna",
	[221413] = "Pergamena della Famiglia di Lin",
	[221617] = "Cassa Ricoperta di Teschi",
	[221670] = "Cassa Ricoperta di Muschio",
	[221671] = "Cassa Resistente",
	[221672] = "Scrigno Infuocato",
	[221673] = "Cassa Fiammeggiante",
	[221689] = "Frutta Croccante Matura",
	[221690] = "Uovo Coperto di Sabbia",
	[221725] = "Cristallo Caricato",
	[221747] = "Enorme Arrosto di Yak",
	[221763] = "Papavero del Fuoco",
	[221764] = "Seme Tostato",
	[222684] = "Sabbia Scintillante",
	[222685] = "Nido di Gru",
	[222686] = "Cristallo Innaturale",
	[222687] = "Rifornimenti degli Ordon",
	[222688] = "Uovo di Serpe di Fuoco",
	[222689] = "Incensiere di Ordos",
	[222776] = "Santuario Senza Tempo",
	[222796] = "Elmo della Famiglia Nube Truce",
	[223084] = "Cassa Ricoperta di Muschio",
	[223085] = "Cassa Ricoperta di Muschio",
	[223086] = "Cassa Ricoperta di Muschio",
	[223087] = "Cassa Ricoperta di Muschio",
	[223088] = "Cassa Ricoperta di Muschio",
	[223089] = "Cassa Ricoperta di Muschio",
	[223090] = "Cassa Ricoperta di Muschio",
	[223091] = "Cassa Ricoperta di Muschio",
	[223092] = "Cassa Ricoperta di Muschio",
	[223093] = "Cassa Ricoperta di Muschio",
	[223094] = "Cassa Ricoperta di Muschio",
	[223095] = "Cassa Ricoperta di Muschio",
	[223096] = "Cassa Ricoperta di Muschio",
	[223097] = "Cassa Ricoperta di Muschio",
	[223098] = "Cassa Ricoperta di Muschio",
	[223099] = "Cassa Ricoperta di Muschio",
	[223100] = "Cassa Ricoperta di Muschio",
	[223101] = "Cassa Ricoperta di Muschio",
	[223102] = "Cassa Ricoperta di Muschio",
	[223103] = "Cassa Ricoperta di Muschio",
	[223104] = "Cassa Ricoperta di Muschio",
	[223105] = "Cassa Ricoperta di Muschio",
	[223106] = "Cassa Ricoperta di Muschio",
	[223107] = "Cassa Ricoperta di Muschio",
	[223108] = "Cassa Ricoperta di Muschio",
	[223109] = "Cassa Ricoperta di Muschio",
	[223110] = "Cassa Ricoperta di Muschio",
	[223111] = "Cassa Ricoperta di Muschio",
	[223112] = "Cassa Ricoperta di Muschio",
	[223113] = "Cassa Ricoperta di Muschio",
	[223114] = "Cassa Ricoperta di Muschio",
	[223115] = "Cassa Ricoperta di Muschio",
	[223116] = "Cassa Resistente",
	[223117] = "Cassa Resistente",
	[223118] = "Cassa Resistente",
	[223119] = "Scrigno Infuocato",
	[223139] = "Lapide Maledetta",
	[223193] = "Mollusco Gigante",
	[223204] = "Cassa Ricoperta di Muschio",
	[223228] = "Fiammardente dei Mari del Sud",
	[223533] = "Offerte di Pace",
	[223537] = "Scialle Cuorfiamma",
	[223538] = "Tridente dell'Oratore del Fiume",
	[223539] = "Artigli di Tigre di Neve Lesta",
	[224228] = "Calderone Ribollente",
	[224306] = "Catene Spezzate",
	[224392] = "Nascondiglio dello Schiavo",
	[224613] = "Scrigno dello Spettatore",
	[224616] = "Petroglifo d'Ossidiana",
	[224623] = "Uovo Dimenante",
	[224633] = "Provviste dell'Orda di Ferro",
	[224686] = "Calcolo del Divoratore",
	[224713] = "Cassa dei Magliorupe",
	[224750] = "Sacchetto Penzolante",
	[224753] = "Uovo di Rylak Squamoso",
	[224754] = "Cassa Fradicia",
	[224755] = "Tributo dell'Orda di Ferro",
	[224756] = "Borsa dell'Alchimista",
	[224770] = "Tesoro degli Esiliati Torvaluna",
	[224780] = "Pugnale Sacrificale dei Torvaluna",
	[224781] = "Cestino Marcio",
	[224783] = "Vaso con Doppiofondo",
	[224784] = "Cassa del Vendicatore",
	[224785] = "Cassa Demoniaca",
	[225501] = "Offerte di Pace",
	[225502] = "Offerte di Pace",
	[225503] = "Offerte di Pace",
	[225596] = "Nopal Spinoso",
	[225726] = "Ordini di Smantellamento del Segatronchi di Ferro",
	[225778] = "Appunti di Barum",
	[226468] = "Pietra Sciamanica dei Lupi Bianchi",
	[226831] = "Scatola dell'Astrologo",
	[226854] = "Zanna di Elekk Corazzata",
	[226861] = "Effetti Personali di Ronokk",
	[226862] = "Cono di Salice Lunare Gigante",
	[226865] = "Carico della Regina dei Corvi",
	[226955] = "Corno da Guerra del Signore dell'Arena",
	[226956] = "Piatto di Frutta Misteriosa",
	[226961] = "Bacheca delle Taglie",
	[226967] = "Pozza della Laguna",
	[226976] = "Stivali Fumanti di Ingannia",
	[226983] = "Cassa del Saltarupi",
	[226990] = "Scarti di Fornitura",
	[226993] = "Cassa del Survivalista",
	[226994] = "Tesoro dei Gelotetro",
	[226996] = "Avanzi di Goren",
	[227069] = "Appunto Scritto di Fretta",
	[227134] = "Spedizione dell'Orda di Ferro",
	[227504] = "Lancia Spinosa degli Spaccatuono",
	[227527] = "Mazza Portaluce",
	[227587] = "Dono di Yuuri",
	[227654] = "Lancia Tritaossa",
	[227737] = "Comunicatore del Concilio dell'Ombra",
	[227743] = "Pesce Fantastico",
	[227793] = "Tesoro della Famiglia di Aarko",
	[227806] = "Stendardo dei Lupi Bianchi Consumato",
	[227859] = "Speranza",
	[227868] = "Pozza Luccicante",
	[227951] = "Cassetta da Pescatore di Rook",
	[227953] = "Brocca di Vinferro Invecchiato",
	[227954] = "Guscio Luminoso",
	[227955] = "Cristallo di Ametile",
	[227956] = "Cestino della Merenda del Caposquadra",
	[227996] = "Uovo di Tessimorte Strano",
	[227998] = "Zaino di Ockbar",
	[228012] = "Spada Carbonizzata",
	[228013] = "Bottino del Contadino",
	[228014] = "Reliquia di Aruuna",
	[228015] = "Scatola di Ferro",
	[228016] = "Barile di Pesce",
	[228017] = "Armi dei Draenei",
	[228018] = "Reliquiario della Vincolatrice d'Anime",
	[228019] = "Sacca Avvolta da Ragnatele",
	[228020] = "Reliquia di Temor",
	[228021] = "Tesoro di Ango'rosh",
	[228022] = "Luce del Mare",
	[228023] = "Resti di Tritaossa",
	[228024] = "Carrello Minerario di Aruuna",
	[228025] = "Effetti Personali di Keluu",
	[228026] = "Polvere di Cristallo Pura",
	[228483] = "Scrigno Arrugginito",
	[228570] = "Nascondiglio di Ketya",
	[229314] = "Dispositivo di Controllo Mentale dei Goblin",
	[229328] = "Borsa dell'Inviato",
	[229330] = "Anello Misterioso",
	[229331] = "Cappello Mistico",
	[229333] = "Stivali Misteriosi",
	[229344] = "Bastone Plasmatempo Spinoso",
	[229354] = "Moneta Lucida",
	[229367] = "Scheletro di Orco Congelato",
	[229640] = "Ascia Congelata dei Lupi Bianchi",
	[230252] = "Perla Ardente",
	[230303] = "Bacheca delle Taglie",
	[230401] = "Vaso Sigillato",
	[230402] = "Moneta Fortunata",
	[230424] = "Forziere Coperto di Neve",
	[230425] = "Osso Spolpato",
	[230428] = "Deposito Infuocato di Puroferro",
	[230498] = "Gabbia degli Spaccatuono",
	[230506] = "Gabbia degli Spaccatuono",
	[230544] = "Pietra Sciamanica dei Lupi Bianchi",
	[230611] = "Sacco del Bottino dei Pallidi",
	[230643] = "Nido di Grinfiafurente",
	[230664] = "Lama di Cristallo di Torvath",
	[230865] = "Lista di ingredienti",
	[230909] = "Rifornimenti Dimenticati",
	[230933] = "Console di Comando Centrale del Pilone",
	[231063] = "Nascondiglio dei Materiali di Dama Sena",
	[231064] = "Nascondiglio degli Altri Materiali di Dama Sena",
	[231069] = "Pugnale dall'Aspetto Strano",
	[231100] = "Pianta Rampicante Glaciale",
	[231103] = "Bottino Depredato",
	[231644] = "Teschio Cornuto",
	[231769] = "Fungo Luminoso",
	[231775] = "Cuore del Magnaron",
	[231901] = "Pergamene degli Ogre",
	[231903] = "Rapporto di Razziabarba",
	[231918] = "Pergamena di Laanda",
	[232024] = "Piani d'Attacco dei Cantaguerra",
	[232066] = "Tesoro Sommerso",
	[232067] = "Tesoro Rubato",
	[232090] = "Scorte Rubate di Spark",
	[232214] = "Bottino degli Ogre",
	[232215] = "Riserva Personale di Gorr'thog",
	[232216] = "Bottino degli Ogre",
	[232217] = "Bottino degli Ogre",
	[232218] = "Nascondiglio Segreto di Doorog",
	[232219] = "Bottino degli Ogre",
	[232237] = "Bottino degli Ogre",
	[232248] = "Rifornimenti Seppelliti di Pippers",
	[232250] = "Rifornimenti Seppelliti di Pippers",
	[232251] = "Rifornimenti Seppelliti di Pippers",
	[232252] = "Rifornimenti Seppelliti di Pippers",
	[232353] = "Scranno del Sovrintendente",
	[232397] = "Bacheca",
	[232398] = "Bacheca delle Taglie",
	[232400] = "Bacheca",
	[232405] = "Manifesto dei Ricercati",
	[232406] = "Zaino dell'Avventuriero",
	[232416] = "Bacheca degli Ordini",
	[232458] = "Cassa di Nizzix",
	[232492] = "Colpo della Rovina",
	[232494] = "Cassa Ricoperta di Funghi",
	[232507] = "Uovo di Calaluna",
	[232541] = "Carrello Minerario",
	[232546] = "Bottino degli Ogre",
	[232547] = "Bottino degli Ogre",
	[232549] = "Bottino degli Ogre",
	[232550] = "Bottino degli Ogre",
	[232571] = "Pacco dei Goblin",
	[232579] = "Uovo di Kaliri",
	[232582] = "Ceneri di A'kumbo",
	[232583] = "Corno per Libagioni",
	[232584] = "Rifornimenti degli Spargifumo",
	[232586] = "Pugnale di Rovo",
	[232587] = "Cianfrusaglie di Uzko",
	[232588] = "Urna di Greka",
	[232589] = "Sacca per Erbe di Veema",
	[232590] = "Cristallo Infuso di Vuoto",
	[232591] = "Offerte Adorate",
	[232592] = "Alveare di Ardipaludi",
	[232595] = "Rifornimenti degli Spargifumo",
	[232596] = "Grandascia Ancestrale",
	[232597] = "Pacco dei Goblin",
	[232598] = "Rifornimenti degli Spargifumo",
	[232599] = "Spoglie dei Cantaguerra",
	[232621] = "Strana Spora",
	[232624] = "Cassa di Mikkal",
	[232985] = "Rifornimenti degli Spargifumo",
	[232986] = "Scorte Nascoste",
	[232989] = "Cestino di Beni degli Arakkoa",
	[233032] = "Zaino dello Scalatore",
	[233033] = "Rifornimenti degli Spargifumo",
	[233034] = "Rifornimenti degli Spargifumo",
	[233044] = "Cassa Ricoperta di Funghi",
	[233048] = "Petalonirico Lucente",
	[233052] = "Rifornimenti degli Spargifumo",
	[233079] = "Rifornimenti Confiscati dei Cantaguerra",
	[233101] = "Nave da Pesca Affondata",
	[233103] = "Scrigno dei Cantaguerra",
	[233107] = "Cassa del Tesoro Piccola",
	[233113] = "Lancia dei Cantaguerra",
	[233126] = "Tesoro dei Torvaluna",
	[233132] = "Mollusco d'Acqua Dolce",
	[233134] = "Uovo di Kaliri Dorato",
	[233135] = "Cassa dei Cantaguerra",
	[233137] = "Cassa delle Lame Ardenti",
	[233139] = "Antica Cassa dei Titani",
	[233149] = "Cassa dei Teschio Ridente",
	[233180] = "Falò dell'Orda di Ferro",
	[233206] = "Merce Abbandonata",
	[233218] = "Zaino dell'Avventuriero",
	[233229] = "Tomo delle Maledizioni del Concilio dell'Ombra",
	[233241] = "Fungo di Caverna Luminoso",
	[233263] = "Pietra Sciamanica",
	[233291] = "Bacheca degli Ordini",
	[233391] = "Ordini sugli Armamenti",
	[233452] = "Mucchio di Terra",
	[233455] = "Contenitore di Pietra Vecchio",
	[233457] = "Bastone dell'Avventuriero",
	[233492] = "Offerta Elementale",
	[233499] = "Sacca dell'Avventuriero",
	[233501] = "Baccello Misterioso Pietrificato",
	[233504] = "Resti di Grimnir Piccacinerea",
	[233505] = "Uovo Pietrificato Sconosciuto",
	[233507] = "Cassa degli Ogre Dimenticata",
	[233511] = "Zaino dell'Avventuriero",
	[233513] = "Cassa di Teschi Dimenticata",
	[233520] = "Resti dell'Ingegnere Esploratore Toldirk Lumecinereo",
	[233521] = "Rifornimenti dei Cantaguerra",
	[233522] = "Formazione di Cristalli d'Obsidio",
	[233523] = "Baccello Misterioso Pietrificato",
	[233524] = "Uovo Pietrificato Sconosciuto",
	[233525] = "Seme dell'Essenza dei Botani",
	[233526] = "Antica Cassa dei Titani",
	[233532] = "Pugnale d'Osso Intagliato",
	[233539] = "Detriti della Genedar",
	[233549] = "Detriti della Genedar",
	[233550] = "Uovo Pietrificato Sconosciuto",
	[233551] = "Detriti della Genedar",
	[233552] = "Contenitore di Pietra Vecchio",
	[233555] = "Detriti della Genedar",
	[233557] = "Detriti della Genedar",
	[233558] = "Baccello Misterioso Pietrificato",
	[233559] = "Cassa di Teschi Dimenticata",
	[233560] = "Frammento di Oshu'gun",
	[233561] = "Tredicesima Ascia di Pokkar",
	[233593] = "Teschio di Saberon Lucidato",
	[233594] = "Appunti di Thukmar",
	[233598] = "Manette Elementali",
	[233611] = "Martello degli Altomaglio",
	[233613] = "Scudo da Difesa di Telaar",
	[233618] = "Catenina degli Ogre",
	[233623] = "Borsa dell'Avventuriero",
	[233626] = "Mucchio d'Ossa di Faucebigia",
	[233633] = "Pila di Legna Inutilizzata",
	[233645] = "Elmo dei Cantaguerra",
	[233649] = "Borsellino dello Scommettitore",
	[233650] = "Mazza dell'Avventuriero",
	[233651] = "Pendente Perduto",
	[233658] = "Borsa dell'Avventuriero",
	[233696] = "Importanti Rifornimenti per Esplorazioni",
	[233697] = "Cassa dei Saberon",
	[233715] = "Bottino di Ditodorato",
	[233768] = "Elisir dei Pallidi",
	[233773] = "Sacca di Erbe",
	[233792] = "Mucchio di Macerie",
	[233917] = "Femore dell'Improbabilità",
	[233956] = "Lama Insanguinata",
	[233973] = "Bottino degli Elementi",
	[233975] = "Regalino di Rooby",
	[234054] = "Uovo di Goren Caldo",
	[234147] = "Beni degli Esiliati",
	[234154] = "Pergamene Smarrite",
	[234155] = "Reliquie degli Esiliati",
	[234157] = "Pietrasole Fratturata",
	[234159] = "Borsa di Erbe Perduta",
	[234243] = "Nota Eccessivamente Vistosa",
	[234432] = "Bottino degli Ogron",
	[234446] = "Reliquie degli Esiliati",
	[234449] = "Reliquie degli Esiliati",
	[234451] = "Reliquie degli Esiliati",
	[234454] = "Reliquie degli Esiliati",
	[234455] = "Reliquie degli Esiliati",
	[234456] = "Scrigno dei Manomozza",
	[234457] = "Cestino di Frutta",
	[234458] = "Cassa dei Manomozza",
	[234461] = "Veleno di Zannatossica",
	[234471] = "Spruzzomatic 5000 XT",
	[234472] = "Rum Invecchiato del Marinaio Zazzuk",
	[234473] = "Contributi alla Campagna",
	[234474] = "Cassa dei Saberon",
	[234618] = "Dono di Anzu",
	[234685] = "Piani di Guerra Segreti",
	[234703] = "Elisir della Visione d'Ombra",
	[234704] = "Elisir della Visione d'Ombra",
	[234705] = "Elisir della Visione d'Ombra",
	[234734] = "Elisir della Visione d'Ombra",
	[234735] = "Elisir della Visione d'Ombra",
	[234736] = "Elisir della Visione d'Ombra",
	[234740] = "Corno da Segnalazione degli Orchi",
	[234744] = "Offerte alla Madre dei Corvi",
	[234746] = "Offerte alla Madre dei Corvi",
	[234748] = "Offerte alla Madre dei Corvi",
	[235073] = "Offerte alla Madre dei Corvi",
	[235090] = "Offerte alla Madre dei Corvi",
	[235091] = "Anello Perduto",
	[235095] = "Pergamena Smarrita",
	[235097] = "Grimorio Oscuro di Ephial",
	[235103] = "Forniture della Guarnigione",
	[235104] = "Cassa del Tocco Solare",
	[235105] = "Cassa del Tocco Solare",
	[235127] = "Baccello Misterioso Pietrificato",
	[235129] = "Semi Arricchiti",
	[235135] = "Manufatti Apexis di Contrabbando",
	[235141] = "Esplosivi dell'Orda di Ferro",
	[235143] = "Lancia dell'Assassino",
	[235168] = "Borsa dell'Esiliato",
	[235172] = "Beni degli Esiliati",
	[235282] = "Bevanda Rituale dei Sethekk",
	[235289] = "Martello da Lavoratore della Guarnigione",
	[235299] = "Pagamento di Piegamonete",
	[235300] = "Funghi Misteriosi",
	[235307] = "Borsa Fradicia",
	[235310] = "Parti di Segatronchi",
	[235313] = "Piccone da Minatore Abbandonato",
	[235365] = "Forziere dell'Ammiraglio Taylor",
	[235673] = "Cassa Irrequieta",
	[235826] = "Gigantesco Uovo di Rylak",
	[235859] = "Sacca di Brokor",
	[235860] = "Scheletro di Orco",
	[235869] = "Cassa di Armi",
	[235881] = "Uovo Pietrificato di Rylak",
	[236092] = "Zaino d'Emergenza Nascosto",
	[236096] = "Resti di Balldir Rocciafonda",
	[236099] = "Lancia del Bacino del Sole",
	[236138] = "Cassa di Rifornimenti di Ferro",
	[236139] = "Contenitore da Esploratore",
	[236140] = "Tunnel dei Goren",
	[236141] = "Pacco Scartato",
	[236147] = "Martello del Vendicatore",
	[236149] = "Nascondiglio Segreto di Sasha",
	[236158] = "Balestra del Cecchino",
	[236165] = "Mappa dei Piani di Guerra",
	[236169] = "Cristallo Prezioso Raccoglibile",
	[236170] = "Resti di Balik Tritagemme",
	[236178] = "Cassa di Forniture di Vespreterno",
	[236206] = "Mappa dei Piani di Guerra",
	[236257] = "Antica Cassa dei Titani",
	[236258] = "Uovo Pietrificato Sconosciuto",
	[236259] = "Baccello Misterioso Pietrificato",
	[236260] = "Baccello Misterioso Pietrificato",
	[236264] = "Cassa di Teschi Dimenticata",
	[236265] = "Contenitore di Pietra Vecchio",
	[236266] = "Uovo Pietrificato Sconosciuto",
	[236267] = "Antica Cassa dei Titani",
	[236269] = "Formazione di Cristalli d'Obsidio",
	[236270] = "Contenitore di Pietra Vecchio",
	[236271] = "Contenitore di Pietra Vecchio",
	[236274] = "Contenitore di Pietra Vecchio",
	[236275] = "Antica Cassa dei Titani",
	[236276] = "Formazione di Cristalli d'Obsidio",
	[236278] = "Formazione di Cristalli d'Obsidio",
	[236279] = "Contenitore di Pietra Vecchio",
	[236280] = "Antica Cassa dei Titani",
	[236282] = "Formazione di Cristalli d'Obsidio",
	[236284] = "Antica Cassa degli Ogre",
	[236285] = "Contenitore di Pietra Vecchio",
	[236288] = "Antica Cassa dei Titani",
	[236289] = "Contenitore di Pietra Vecchio",
	[236348] = "Antica Cassa degli Ogre",
	[236349] = "Antica Cassa dei Titani",
	[236350] = "Contenitore di Pietra Vecchio",
	[236351] = "Antica Cassa degli Ogre",
	[236399] = "Contenitore di Pietra Vecchio",
	[236400] = "Antica Cassa degli Ogre",
	[236402] = "Antica Cassa dei Titani",
	[236404] = "Contenitore di Pietra Vecchio",
	[236406] = "Antica Cassa degli Ogre",
	[236407] = "Antica Cassa degli Ogre",
	[236483] = "Dono degli Antichi",
	[236610] = "Dono dello Spirito",
	[236633] = "Cassa del Contrabbandiere",
	[236693] = "Munizioni dell'Orda di Ferro",
	[236715] = "Teschio Strano",
	[236755] = "Scrigno Impolverato",
	[236935] = "Cassa delle Lame Ardenti",
	[237016] = "Ricercato: Kuu'rat",
	[237021] = "Ricercato: Kliaa",
	[237022] = "Bacheca degli Ordini",
	[237343] = "Barile di Birra Impalante",
	[237452] = "Cassa dell'Orda di Ferro",
	[237461] = "Scudo di Olaf",
	[237462] = "Soluzione Acida Terribile",
	[237463] = "Strana Bussola d'Ottone",
	[237464] = "Lama Taglianime",
	[237465] = "Ampolla d'Anime",
	[237466] = "Cristallo Solare",
	[237467] = "Piumaggio Primevo",
	[237468] = "Scuoiatore Perfezionato di Finkle",
	[237469] = "Artiglio di Proto-Drago Spezzato",
	[237470] = "Cartapecora Oscura",
	[237471] = "Freccia Foderata d'Argento",
	[237472] = "Strana Fronda Luminescente",
	[237473] = "Manufatto Troppo Cresciuto",
	[237474] = "Enorme Cassa di Armi",
	[237475] = "Spezzarti di Ferro",
	[237476] = "Pirostella in Miniatura",
	[237477] = "Storia di Famiglia degli Ogre",
	[237478] = "Cosa Molto Luccicante",
	[237479] = "Campana dell'Incubo",
	[237480] = "Tempesta di Vento Imbottigliata",
	[237481] = "Fiammola Imbottigliata",
	[237482] = "Chiave del Portale del Vuoto",
	[237483] = "Nido di Cucciolo di Pavone Frusciante",
	[237484] = "Autocannone di Ferro",
	[237511] = "Strana Spora",
	[237751] = "Ordini d'Attacco dell'Orda di Ferro",
	[237821] = "Ordini di Lamafuriosa",
	[237946] = "Scrigno dello Spirito",
	[239120] = "Zaino di Okuna Zannelunghe",
	[239143] = "Bicchiere di Latte Caldo",
	[239171] = "Bicchiere di Latte Caldo",
	[239194] = "Cassa di Norana",
	[239198] = "Cassa di Isaari",
	[239328] = "Scrigno del Capitano",
	[239791] = "Appunti sulla Caccia alle Reliquie",
	[239803] = "Cassa del Tesoro",
	[239828] = "Confini della Realtà",
	[239925] = "Pietra Sciamanica Congelata",
	[239926] = "Pietra Sciamanica Magmatica",
	[240003] = "Strano Zaffiro",
	[240215] = "Ceneri del Crociato Caduto",
	[240289] = "Ascia Logora",
	[240317] = "Tomo delle Ombre di Iskar",
	[240353] = "Tesoro Apparentemente Incustodito",
	[240354] = "Tesoro Non Sorvegliato",
	[240519] = "Cassa del Tesoro Piccola",
	[240543] = "Cassa del Capitano Rubata",
	[240547] = "Teschio di Orco",
	[240577] = "Lama di Kra'nak",
	[240580] = "Gioiello del Fuoco Infernale",
	[240605] = "Cassa del Tesoro Piccola",
	[240608] = "Cassa del Tesoro Piccola",
	[240609] = "Cassa del Tesoro Piccola",
	[240612] = "Cassa del Tesoro Piccola",
	[240614] = "Cassa del Tesoro Piccola",
	[240616] = "Forniture Congelate",
	[240617] = "Sacca della Sentinella Perduta",
	[240619] = "Cassa del Tesoro Piccola",
	[240622] = "Portapergamene del Custode",
	[240623] = "Forziere di Sylvanas",
	[240624] = "Nido di Drago Fatato",
	[240625] = "Reliquiario della Gran Sacerdotessa",
	[240629] = "Cassa del Tesoro",
	[240630] = "Cassa del Tesoro Piccola",
	[240631] = "Cassa del Tesoro",
	[240634] = "Cassa del Tesoro",
	[240635] = "Cassa del Tesoro",
	[240637] = "Cassa del Tesoro Luccicante",
	[240638] = "Tesoro Conteso",
	[240639] = "Cassa del Tesoro Luccicante",
	[240641] = "Cassa del Tesoro",
	[240642] = "Cassa del Tesoro",
	[240643] = "Cassa del Tesoro",
	[240644] = "Cassa del Tesoro Piccola",
	[240645] = "Cassa del Tesoro Luccicante",
	[240646] = "Cassa del Tesoro",
	[240649] = "Cassa del Tesoro Piccola",
	[240651] = "Cassa del Tesoro Piccola",
	[240652] = "Cassa del Tesoro",
	[240653] = "Cassa del Tesoro Piccola",
	[240654] = "Cassa del Tesoro Piccola",
	[240655] = "Cassa del Tesoro Luccicante",
	[240657] = "Cassa del Tesoro Piccola",
	[240690] = "Cassa del Tesoro",
	[240855] = "Tomo dei Segreti",
	[241128] = "Tesoro degli Sferzafoglie Incustodito",
	[241146] = "Cassa del Tesoro",
	[241147] = "Cassa del Tesoro Piccola",
	[241148] = "Cassa del Tesoro Piccola",
	[241149] = "Cassa del Tesoro Piccola",
	[241150] = "Cassa del Tesoro Piccola",
	[241151] = "Cassa del Tesoro Piccola",
	[241152] = "Cassa del Tesoro",
	[241153] = "Cassa del Tesoro Piccola",
	[241154] = "Cassa del Tesoro Piccola",
	[241155] = "Cassa del Tesoro",
	[241180] = "Cassa del Tesoro",
	[241206] = "Cassa del Tesoro Piccola",
	[241207] = "Cassa del Tesoro Piccola",
	[241208] = "Cassa del Tesoro",
	[241212] = "Cassa del Tesoro",
	[241213] = "Cassa del Tesoro Piccola",
	[241216] = "Cassa del Tesoro",
	[241267] = "Cassa del Tesoro Piccola",
	[241272] = "Cassa del Tesoro",
	[241280] = "Cassa del Tesoro",
	[241433] = "Sacca Dimenticata",
	[241434] = "Lancia da Caccia Impiantata",
	[241449] = "Cassa dell'Isola degli Artiglionero",
	[241450] = "Vilspina Cristallizzata",
	[241504] = "Cristallo Lucidato",
	[241518] = "Cassa del Tesoro Piccola",
	[241521] = "Flauto dell'Incantatore di Serpenti",
	[241522] = "Bocciolo Perfetto",
	[241524] = "Equipaggiamento per Rimozione Pallidi",
	[241533] = "Lama del Campione Dimenticato",
	[241557] = "Cassa del Tesoro Piccola",
	[241558] = "Cassa del Tesoro",
	[241560] = "Cassa da Guerra dei Guerci Insanguinati",
	[241561] = "Gioiello della Stella Caduta",
	[241562] = "Cassa del Tesoro Piccola",
	[241563] = "Incensiere del Tormento",
	[241564] = "Cassa del Tesoro Piccola",
	[241565] = "Tesoro dei Guerci Insanguinati Depredato",
	[241566] = "Femore Runico",
	[241599] = "Frutto Strano",
	[241600] = "Elmo Scartato",
	[241601] = "Beni dell'Esploratore",
	[241602] = "Forniture dell'Orda di Ferro Dimenticate",
	[241605] = "Essenza degli Elementi Cristallizzata",
	[241641] = "Fiorvolpe",
	[241656] = "Reliquia Ipertrofica",
	[241657] = "Effige degli Arakkoa Ingioiellata",
	[241664] = "Cannocchiale Incantato \"Prestato\"",
	[241665] = "Cassa del Tesoro",
	[241666] = "Obelisco Misterioso Corrotto",
	[241671] = "Frammento di Cifrario Dimenticato",
	[241673] = "Tesoro dei Guerci Insanguinati Depredato",
	[241674] = "Teschio del Capo Pazzo",
	[241680] = "Cassa del Tesoro Piccola",
	[241692] = "Ascia del Lupo Piangente",
	[241699] = "Spoglie di Guerra",
	[241712] = "Tesoro di Barbaferro",
	[241713] = "Occhio di Grannok",
	[241714] = "Bottino Segreto del Mare di Ferro",
	[241715] = "Bottino Segreto del Mare di Ferro",
	[241716] = "Bottino Segreto del Mare di Ferro",
	[241717] = "Cassa del Tesoro Luccicante",
	[241726] = "Deposito di Fagliaroccia",
	[241742] = "Libro di Zyzzix",
	[241743] = "Deposito di Vilardesia",
	[241745] = "Sacchetto Vilinzuppato",
	[241760] = "Lama Sacrificale",
	[241764] = "Bottino Segreto dei Guerci Insanguinati",
	[241767] = "Cassa del Tesoro",
	[241772] = "Cassa del Tesoro",
	[241773] = "Cassa del Tesoro Piccola",
	[241775] = "Braciere del Risveglio",
	[241835] = "Scorta di Funghi dei Guerci Insanguinati",
	[241841] = "Bastone Mistico Depredato",
	[241847] = "Scudo del Comandante",
	[241848] = "Verga Abbagliante",
	[242242] = "Cassa del Tesoro Piccola",
	[242249] = "Cristallo Apexis Parzialmente Estratto",
	[242250] = "Cassa del Tesoro Piccola",
	[242328] = "Cassa del Tesoro Piccola",
	[242350] = "Cassa del Tesoro",
	[242446] = "Cassa del Tesoro Piccola",
	[242642] = "Cassa del Tesoro Piccola",
	[242643] = "Cassa del Tesoro Piccola",
	[242644] = "Cassa del Tesoro",
	[242645] = "Cassa del Tesoro Piccola",
	[242646] = "Cassa del Tesoro Piccola",
	[242647] = "Cassa del Tesoro",
	[242649] = "Formazione Apexis Vilcorrotta",
	[242660] = "Cassa del Tesoro Piccola",
	[242662] = "Cassa del Tesoro Piccola",
	[242663] = "Cassa del Tesoro Piccola",
	[242664] = "Cassa del Tesoro",
	[242665] = "Cassa del Tesoro Piccola",
	[242666] = "Cassa del Tesoro",
	[242667] = "Cassa del Tesoro Piccola",
	[242668] = "Cassa del Tesoro Luccicante",
	[242669] = "Cassa del Tesoro Piccola",
	[242670] = "Cassa del Tesoro",
	[242671] = "Cassa del Tesoro Luccicante",
	[242675] = "Cassa del Tesoro Piccola",
	[242678] = "Cassa del Tesoro",
	[242683] = "Cassa del Tesoro",
	[242959] = "Cassa del Tesoro",
	[243280] = "Pepe Pirata",
	[243281] = "Pepe Ninja",
	[243282] = "Pepe Vichingo",
	[243283] = "Pepe Cavaliere",
	[243321] = "Pietra Ferina",
	[243323] = "Pietra dell'Equilibrio",
	[243392] = "Libro di Alchimia",
	[243688] = "Cassa del Tesoro",
	[243690] = "Uovo Ingioiellato",
	[243693] = "Scrigno del Morto",
	[243698] = "Cassa del Tesoro Luccicante",
	[243773] = "Cassa del Tesoro",
	[243798] = "Scrigno di Gioielli Romantico",
	[243911] = "Mucchio di Neve",
	[244447] = "Uovo di Murloc Bianco",
	[244453] = "Rapporto Esplorativo di Cullen",
	[244473] = "Beni Rubati di Totem del Fulmine",
	[244494] = "Cassa del Tesoro",
	[244519] = "Cassa del Tesoro",
	[244628] = "Premio di Taurson",
	[244651] = "Romanzo Rosa",
	[244678] = "|cFFFFFFFFStep 8:|r Pagina 5.555",
	[244689] = "Cassa del Tesoro Piccola",
	[244691] = "Cassa del Tesoro Piccola",
	[244692] = "Cassa del Tesoro Piccola",
	[244694] = "Cassa del Tesoro Piccola",
	[244698] = "Cassa del Tesoro Piccola",
	[244699] = "Cassa del Tesoro Piccola",
	[244700] = "Cassa del Tesoro Piccola",
	[244701] = "Cassa del Tesoro Piccola",
	[244775] = "Erbonirica",
	[244776] = "Erbonirica",
	[244778] = "Rosa Lucestellare",
	[244786] = "Vilpianta",
	[244887] = "Cassa del Tesoro Piccola",
	[244899] = "Cassa del Tesoro Piccola",
	[244901] = "Cassa del Tesoro",
	[244902] = "Cassa del Tesoro",
	[244903] = "Cassa del Tesoro",
	[244904] = "Cassa del Tesoro Piccola",
	[244905] = "Cassa del Tesoro Piccola",
	[244909] = "Cassa del Tesoro Piccola",
	[244912] = "Cassa del Tesoro Piccola",
	[244913] = "Cassa del Tesoro",
	[244917] = "Cassa del Tesoro",
	[244928] = "Cassa del Tesoro Luccicante",
	[244965] = "Cassa di Sheddle",
	[244986] = "Portale della Legione",
	[245216] = "|cFFFFFFFFStep 3:|r Pagina 161",
	[245286] = "Statuetta Felina Cristallina",
	[245316] = "Cassa del Tesoro Piccola",
	[245324] = "Deposito Ricco di Fagliaroccia",
	[245325] = "Deposito Ricco di Vilardesia",
	[245328] = "Pergamena Incantata",
	[245345] = "Cassa del Tesoro Piccola",
	[245479] = "Cassa Danneggiata",
	[245524] = "Cassa del Tesoro",
	[245525] = "Cassa del Tesoro Piccola",
	[245527] = "Cassa del Tesoro",
	[245528] = "Cassa del Tesoro",
	[245529] = "Cassa del Tesoro Piccola",
	[245530] = "Cassa del Tesoro Luccicante",
	[245531] = "Cassa del Tesoro Piccola",
	[245532] = "Cassa del Tesoro",
	[245533] = "Cassa del Tesoro",
	[245534] = "Cassa del Tesoro Piccola",
	[245535] = "Cassa del Tesoro Piccola",
	[245536] = "Cassa del Tesoro Luccicante",
	[245537] = "Cassa del Tesoro Luccicante",
	[245538] = "Cassa del Tesoro Piccola",
	[245541] = "Cassa del Tesoro Piccola",
	[245542] = "Cassa del Tesoro",
	[245543] = "Cassa del Tesoro",
	[245545] = "Cassa del Tesoro Piccola",
	[245547] = "Cassa del Tesoro Piccola",
	[245548] = "Cassa del Tesoro",
	[245550] = "Cassa del Tesoro",
	[245551] = "Cassa del Tesoro Piccola",
	[245553] = "Cassa del Tesoro",
	[245554] = "Cassa del Tesoro Piccola",
	[245555] = "Cassa del Tesoro Piccola",
	[245579] = "Cassa del Tesoro",
	[245580] = "Cassa del Tesoro Piccola",
	[245581] = "Cassa del Tesoro Piccola",
	[245601] = "Cassa del Tesoro Piccola",
	[245602] = "Cassa del Tesoro",
	[245603] = "Cassa del Tesoro Piccola",
	[245688] = "Urna Funeraria Spaccata",
	[245793] = "Diario Rovinato",
	[245941] = "Cassa Distorcente",
	[245996] = "Cassa del Tesoro Piccola",
	[246037] = "Cassa del Tesoro",
	[246147] = "Cassa del Tesoro Piccola",
	[246154] = "Scatola dei Giocattoli Rotta",
	[246205] = "Cassa del Tesoro Piccola",
	[246206] = "Cassa del Tesoro Piccola",
	[246249] = "Cassa del Tesoro Piccola",
	[246250] = "Lettera da Jabrul",
	[246254] = "Forziere Impolverato",
	[246269] = "Cassa del Tesoro Piccola",
	[246309] = "Cassa del Tesoro Piccola",
	[246353] = "Cassa del Tesoro Piccola",
	[246438] = "Schema dei Circuiti di Orotron",
	[246524] = "Cassa del Tesoro Piccola",
	[246555] = "Cassa del Tesoro Piccola",
	[246556] = "Cassa del Tesoro Piccola",
	[246557] = "Cassa del Tesoro Piccola",
	[246558] = "Cassa del Tesoro Piccola",
	[246559] = "Cassa del Tesoro Piccola",
	[246560] = "Cassa del Tesoro Piccola",
	[246561] = "Cassa del Tesoro Piccola",
	[246562] = "Cassa del Tesoro Piccola",
	[247694] = "Zaino di Kel'danath",
	[247797] = "Posta Perduta",
	[247999] = "Vilpianta",
	[248000] = "Vilpianta",
	[248001] = "Vilpianta",
	[248002] = "Vilpianta",
	[248003] = "Vilpianta",
	[248004] = "Vilpianta",
	[248005] = "Vilpianta",
	[248006] = "Vilpianta",
	[248007] = "Vilpianta",
	[248008] = "Vilpianta",
	[248009] = "Vilpianta",
	[248010] = "Vilpianta",
	[248011] = "Vilpianta",
	[248012] = "Vilpianta",
	[248398] = "Dispositivo di Comunicazione Etereo",
	[248534] = "Lacrime di Elune",
	[248854] = "Scrigno di Desmond",
	[249211] = "Seta Shal'dorei Strappata",
	[249997] = "Cassa del Tesoro Piccola",
	[250080] = "Cassa del Tesoro Piccola",
	[250081] = "Cassa del Tesoro Piccola",
	[250083] = "Cassa del Tesoro Piccola",
	[250084] = "Cassa del Tesoro Piccola",
	[250085] = "Cassa del Tesoro Piccola",
	[250087] = "Cassa del Tesoro Piccola",
	[250088] = "Cassa del Tesoro Piccola",
	[250090] = "Cassa del Tesoro Piccola",
	[250091] = "Cassa del Tesoro Piccola",
	[250092] = "Cassa del Tesoro",
	[250097] = "Cassa del Tesoro Piccola",
	[250098] = "Cassa del Tesoro Piccola",
	[250102] = "Cassa del Tesoro",
	[250103] = "Cassa del Tesoro Piccola",
	[250104] = "Cassa del Tesoro Piccola",
	[250106] = "Cassa del Tesoro Piccola",
	[250107] = "Cassa del Tesoro Luccicante",
	[250108] = "Cassa del Tesoro Piccola",
	[250109] = "Cassa del Tesoro",
	[250383] = "Reliquia di Ombraluna",
	[250541] = "Cassa del Tesoro",
	[250984] = "Cassa del Tesoro Piccola",
	[250985] = "Cassa del Tesoro",
	[250987] = "Cassa del Tesoro Piccola",
	[251032] = "Comò",
	[251124] = "Cassa del Tesoro Luccicante",
	[251168] = "Cristallo Effimero",
	[251218] = "Pietra Runica di Rollo",
	[251220] = "Pietra Runica di Ragnar",
	[251221] = "Pietra Runica di Floki",
	[251416] = "Pezzo di Mana Antico",
	[251552] = "Cassa del Tesoro Piccola",
	[251564] = "|cFFFFFFFFStep 4:|r Pagina 655",
	[251713] = "Cassa del Tesoro Piccola",
	[251714] = "Cassa del Tesoro Piccola",
	[251716] = "Cassa del Tesoro Luccicante",
	[251719] = "Cassa del Tesoro Piccola",
	[251720] = "Cassa del Tesoro Piccola",
	[251723] = "Cassa del Tesoro Piccola",
	[251737] = "Cassa del Tesoro",
	[251738] = "Cassa del Tesoro",
	[251761] = "Cassa del Tesoro Piccola",
	[251762] = "Cassa del Tesoro Piccola",
	[251764] = "Cassa del Tesoro Piccola",
	[251772] = "Cassa del Tesoro Piccola",
	[251776] = "Cassa del Tesoro Piccola",
	[251780] = "Cassa del Tesoro Piccola",
	[251782] = "Cassa del Tesoro Piccola",
	[251792] = "Cassa del Tesoro Piccola",
	[251820] = "Cassa del Tesoro",
	[251851] = "Cassa del Tesoro Piccola",
	[251853] = "Cassa del Tesoro Piccola",
	[251854] = "Cassa del Tesoro Piccola",
	[251856] = "Cassa del Tesoro Piccola",
	[251857] = "Cassa del Tesoro",
	[251991] = "Egida di Aggramar",
	[252107] = "Segnalatore Telemantico Disattivato",
	[252232] = "Libram di Aponi",
	[252258] = "Fonte di Faglia",
	[252259] = "Fonte di Faglia",
	[252260] = "Fonte di Faglia",
	[252261] = "Fonte di Faglia",
	[252262] = "Fonte di Faglia",
	[252263] = "Fonte di Faglia",
	[252264] = "Fonte di Faglia",
	[252267] = "Grosso Sacco Saccheggiato",
	[252269] = "Pacco di Pozioni da Battaglia",
	[252270] = "Cassa Misteriosa",
	[252272] = "Stivali Fumanti",
	[252273] = "Scatola di Pugnali da Lancio",
	[252277] = "Tè di Sboccialesto",
	[252279] = "Tomo Rubato della Storia dell'Artefatto",
	[252282] = "Mazzo di Chiavi Luccicante",
	[252284] = "Mucchio di Bombe Appiccicose",
	[252289] = "Polvere Rimovente",
	[252331] = "Pepe Viaggiatore",
	[252385] = "Pagina Strappata",
	[252386] = "Pagina dai Bordi Consumati",
	[252387] = "Pagina con Orecchia",
	[252388] = "Pagina Bruciata",
	[252390] = "Pagina Macchiata di Inchiostro",
	[252391] = "Pagina Scarabocchiata di Fretta",
	[252395] = "Palo del Nerodestriero",
	[252404] = "Vilpianta",
	[252412] = "|cFFFFFFFFStep 2:|r Mucchio di Terra",
	[252432] = "Antica Formazione di Mana Scintillante",
	[252434] = "|cFFFFFFFFStep 12:|r Globo Famelico X",
	[252446] = "Antica Formazione di Mana Scintillante",
	[252447] = "Antica Formazione di Mana Scintillante",
	[252448] = "Antica Formazione di Mana Scintillante",
	[252449] = "Antica Formazione di Mana Scintillante",
	[252450] = "Antica Formazione di Mana Scintillante",
	[252557] = "|cFFFFFFFFStep 3:|r Globo Famelico I",
	[252558] = "|cFFFFFFFFStep 4:|r Globo Famelico II",
	[252559] = "|cFFFFFFFFStep 5:|r Globo Famelico III",
	[252560] = "|cFFFFFFFFStep 6:|r Globo Famelico IV",
	[252561] = "|cFFFFFFFFStep 7:|r Globo Famelico V",
	[252562] = "|cFFFFFFFFStep 8:|r Globo Famelico VI",
	[252563] = "|cFFFFFFFFStep 9:|r Globo Famelico VII",
	[252564] = "|cFFFFFFFFStep 10:|r Globo Famelico VIII",
	[252565] = "|cFFFFFFFFStep 11:|r Globo Famelico IX",
	[252570] = "Cassa di Ricchezze della Rocca Celeste",
	[252802] = "Cassa del Tesoro Piccola",
	[252803] = "Cassa del Tesoro Piccola",
	[252805] = "Cassa del Tesoro",
	[252806] = "Cassa del Tesoro Piccola",
	[252807] = "Cassa del Tesoro Piccola",
	[252808] = "Cassa del Tesoro Piccola",
	[252810] = "Cassa del Tesoro Piccola",
	[252812] = "Cassa del Tesoro",
	[252813] = "Cassa del Tesoro Piccola",
	[252814] = "Segnalatore Telemantico Disattivato",
	[252815] = "Segnalatore Telemantico Disattivato",
	[252816] = "Segnalatore Telemantico Disattivato",
	[252817] = "Segnalatore Telemantico Disattivato",
	[252819] = "Cassa del Tesoro Piccola",
	[252820] = "Cassa del Tesoro Piccola",
	[252821] = "Cassa del Tesoro",
	[252822] = "Cassa del Tesoro Luccicante",
	[252824] = "Cassa del Tesoro",
	[252828] = "Cassa del Tesoro Piccola",
	[252829] = "Cassa del Tesoro Piccola",
	[252830] = "Cassa del Tesoro Piccola",
	[252831] = "Cassa del Tesoro Luccicante",
	[252833] = "Cassa del Tesoro",
	[252834] = "Cassa del Tesoro Piccola",
	[252835] = "Cassa del Tesoro Piccola",
	[252836] = "Cassa del Tesoro Piccola",
	[252837] = "Cassa del Tesoro",
	[252838] = "Cassa del Tesoro",
	[252839] = "Cassa del Tesoro Piccola",
	[252840] = "Cassa del Tesoro Piccola",
	[252841] = "Cassa del Tesoro Piccola",
	[252842] = "Cassa del Tesoro",
	[252844] = "Cassa del Tesoro",
	[252850] = "Cassa del Tesoro Piccola",
	[252860] = "Cassa del Tesoro Piccola",
	[252876] = "Cassa del Tesoro Piccola",
	[252880] = "Cassa del Tesoro",
	[252881] = "Cassa del Tesoro",
	[252882] = "Cassa del Tesoro",
	[252883] = "Cassa del Tesoro",
	[252884] = "Cassa del Tesoro Luccicante",
	[253161] = "Viticcio del Bosco",
	[253280] = "Vena di Fagliaroccia",
	[253452] = "Guida Introduttiva ai Varchi Dimensionali 1 - Navigare nel Tempo",
	[253453] = "Guida Introduttiva ai Varchi Dimensionali 2 - I Posti Sacri",
	[253454] = "Guida Introduttiva ai Varchi Dimensionali 3 - Solo Acqua",
	[253455] = "Guida Introduttiva ai Varchi Dimensionali 4 - Rischi e Benefici",
	[253456] = "Guida Introduttiva ai Varchi Dimensionali 5 - Incontrare il Prossimo",
	[253457] = "Guida Introduttiva ai Varchi Dimensionali 6 - L'Energia Repressa",
	[253458] = "Guida Introduttiva ai Varchi Dimensionali 7 - Il Nostro Retaggio",
	[253994] = "Tesoro Apparentemente Incustodito",
	[254007] = "Altare dell'Esecutore",
	[254010] = "Rifornimenti del Circolo della Terra",
	[254025] = "Cassa del Tesoro Piccola",
	[254027] = "Cassa del Tesoro Piccola",
	[254028] = "Cassa del Tesoro Piccola",
	[254126] = "Cassa del Tesoro Piccola",
	[254127] = "Cassa del Tesoro Piccola",
	[254128] = "Cassa del Tesoro",
	[254141] = "Cassa del Tesoro Piccola",
	[254262] = "Gufo delle Custodi",
	[255344] = "Vena di Vilardesia",
	[255828] = "Cassa del Tesoro Piccola",
	[255829] = "Cassa del Tesoro Piccola",
	[255963] = "Cassa Ancestrale dei Vrykul",
	[256790] = "Cassa del Tesoro Elfica",
	[257290] = "Cassa dei Clan di Alto Monte",
	[257291] = "Cassa del Tesoro dei Nobili Oscuri",
	[257393] = "Cassa del Tesoro",
	[257545] = "Cassa del Tesoro",
	[257546] = "Cassa del Tesoro",
	[257978] = "Cassa del Tesoro",
	[257999] = "Tecnica: Tomo della Mente Tranquilla",
	[258690] = "Cassa del Tesoro Piccola",
	[258978] = "Tomo Fradicio",
	[258979] = "Tomo Rovinato dal Vile",
	[258980] = "Tomo Maledetto",
	[259806] = "Ricetta della Pozione d'Amore",
	[265526] = "Cassa del Tesoro",
	[265532] = "Segnalatore Telemantico",
	[265602] = "Tomo Sigillato",
	[266289] = "Cassa Perduta nel Tempo",
	[266851] = "Bacchetta della Vita Simulata",
	[268478] = "Monile Rovinato",
	[268551] = "Cassa dei Drachilingua Strana",
	[269037] = "Ciottolo Instabile",
	[269064] = "Cassa del Tesoro Piccola",
	[269830] = "|cFFFFFFFFStep 9:|r Dono dei Cercatori Mentali",
	[270855] = "|cFFFFFFFFStep 1:|r Nota Incospicua",
	[270917] = "Registro degli Acqualunga",
	[271103] = "Effige di Preghiera",
	[271706] = "Tavola dei Cacciatori",
	[271849] = "Rifornimenti di Guerra degli Eredar",
	[271850] = "Rifornimenti di Guerra degli Eredar",
	[272039] = "|cFFFFFFFFStep 2:|r Nota Incospicua",
	[272046] = "|cFFFFFFFFStep 3:|r Larva Mentale",
	[272061] = "|cFFFFFFFFStep 4:|r Nota Incospicua",
	[272163] = "|cFFFFFFFFStep 5:|r Strano Teschio",
	[272165] = "|cFFFFFFFFStep 6:|r Nota Incospicua",
	[272172] = "|cFFFFFFFFStep 7:|r Nota Incospicua",
	[272179] = "Bollettino del Sindaco",
	[272181] = "|cFFFFFFFFStep 8:|r Nota Incospicua",
	[272220] = "|cFFFFFFFFStep 9:|r Nota Incospicua",
	[272270] = "|cFFFFFFFFStep 10:|r Desiderio dell'Enigmista",
	[272422] = "Grimorio di Helena",
	[272434] = "Pietra d'Acqua",
	[272455] = "Rifornimenti di Guerra degli Eredar",
	[272456] = "Rifornimenti di Guerra degli Eredar",
	[272487] = "|cFFFFFFFFStep 14:|r Uovo dal Colore Strano",
	[272768] = "Deposito d'Empirio",
	[272770] = "Rifornimenti di Guerra degli Eredar",
	[272771] = "Rifornimenti di Guerra degli Eredar",
	[272778] = "Deposito Ricco d'Empirio",
	[272780] = "Vena d'Empirio",
	[272782] = "Gloria Astrale",
	[273052] = "Erba Vilincrostata",
	[273053] = "Fascio d'Erba Vilincrostata",
	[273222] = "Rifornimenti di Guerra degli Eredar",
	[273301] = "Antica Cassa degli Eredar",
	[273407] = "Antica Cassa degli Eredar",
	[273412] = "Antica Cassa degli Eredar",
	[273414] = "Antica Cassa degli Eredar",
	[273415] = "Antica Cassa degli Eredar",
	[273439] = "Antica Cassa degli Eredar",
	[273443] = "Cassa con Infiltrazioni di Vuoto",
	[273519] = "Rifornimenti di Guerra della Legione",
	[273521] = "Rifornimenti di Guerra della Legione",
	[273523] = "Rifornimenti di Guerra della Legione",
	[273524] = "Rifornimenti di Guerra della Legione",
	[273527] = "Rifornimenti di Guerra della Legione",
	[273528] = "Rifornimenti di Guerra della Legione",
	[273533] = "Rifornimenti di Guerra della Legione",
	[273535] = "Rifornimenti di Guerra della Legione",
	[273538] = "Rifornimenti di Guerra della Legione",
	[273814] = "Talismano Tagliente",
	[273854] = "Zaino",
	[276223] = "Scrigno del Tesoro degli Eredar",
	[276224] = "Cassa di Guadagni Disonesti",
	[276225] = "Forniture Sorprendentemente Eccedenti dello Studente",
	[276226] = "Cassa Venata di Vuoto",
	[276227] = "Scorte Segrete degli Augari",
	[276228] = "Cassa dell'Eredar Disperato",
	[276229] = "Cassa della Casa Distrutta",
	[276230] = "Tesoro del Cercatore della Rovina",
	[276234] = "Baccello Fluviale",
	[276236] = "Muschio Stellare",
	[276237] = "Morso di Akunda",
	[276238] = "Bacio dell'Inverno",
	[276239] = "Pruno di Sirena",
	[276240] = "Steli Marini",
	[276242] = "Alga d'Ancora",
	[276251] = "Inventario degli Scavi",
	[276424] = "Ossa di Imp Intatte",
	[276425] = "Osso di Demonio Intatto",
	[276426] = "Osso di Ur'zul Intatto",
	[276488] = "Palla di Cannone d'Azerite",
	[276489] = "Cassa della Torre della Legione",
	[276490] = "Scrigno d'Emergenza dei Krokul",
	[276491] = "Forziere del Krokul Perduto",
	[276513] = "Pescefango Intatto",
	[276515] = "Bastone da Pesca",
	[276616] = "Deposito di Monelite",
	[276617] = "Deposito di Argento della Tempesta",
	[276618] = "Deposito di Platino",
	[276619] = "Vena di Monelite",
	[276620] = "Vena di Argento della Tempesta",
	[276621] = "Deposito Ricco di Monelite",
	[276622] = "Deposito Ricco di Argento della Tempesta",
	[276623] = "Cassa del Tesoro",
	[276735] = "Offerte del Prescelto",
	[276837] = "Roccia con Ricetta",
	[277199] = "Lista di Lavori Logora",
	[277204] = "Rifornimenti della Legione Dimenticati",
	[277205] = "Cassa di Rifornimenti di Guerra Antichi della Legione",
	[277206] = "Cassa Vilvincolata",
	[277207] = "Tesoro della Legione",
	[277208] = "Vilcassa Logora",
	[277327] = "Cassa Runica degli Augari",
	[277333] = "Sarcofago Antico",
	[277336] = "Cassa del Tesoro",
	[277340] = "Cassa Segreta degli Augari",
	[277342] = "Beni degli Augari",
	[277343] = "Tesoro degli Augari Perduto da Tempo",
	[277344] = "Ricordi Preziosi degli Augari",
	[277346] = "Cassa Perduta degli Augari",
	[277373] = "Alga Marina Luccicante",
	[277384] = "Tesoro Abbandonato",
	[277444] = "Bijou Rivendicati",
	[277447] = "Resti Venerati",
	[277459] = "Effige del Maiale",
	[277561] = "Cassa del Signore della Guerra",
	[277637] = "Cassa con Infiltrazioni di Vuoto",
	[277715] = "Cassa Maledetta dei Nazmani",
	[277885] = "Collezione di Wunja",
	[277886] = "Grimorio dell'Aldilà",
	[277897] = "Cassa Ribollente",
	[278197] = "Fiala di Antidoto",
	[278252] = "Volantino di Lavoro",
	[278313] = "Lettera Severa",
	[278368] = "Nota Lacera",
	[278432] = "Cassa Evidentemente Sicura",
	[278436] = "Cassa Naufragata",
	[278437] = "Offerte per Bwonsamdi",
	[278447] = "Lancia del Bracconiere Senzafede",
	[278453] = "Totem del Vudù",
	[278456] = "Cassa del Tesoro",
	[278461] = "Cassa del Tesoro",
	[278462] = "Cassa del Tesoro",
	[278570] = "Diario Antico",
	[278577] = "Missiva dell'Orda Strappata",
	[278669] = "Libro Mastro di Malautunno",
	[278675] = "Effige Maledetta",
	[278694] = "Cassa del Tesoro",
	[278793] = "Cassa del Tesoro",
	[279042] = "Scorte del Contrabbandiere",
	[279044] = "Giunchi degli Zandalari",
	[279253] = "Cassa Fortunata di Horace il Fortunato",
	[279260] = "Cassa Ben Camuffata",
	[279299] = "Sigillo Venefico",
	[279609] = "Spoglie di Pandaria",
	[279645] = "Tomo dell'Oblio",
	[279646] = "Cronache della Guardia del Sangue",
	[279647] = "Tomo del Sacrificio",
	[279689] = "Tesoro Perduto dei Nazmani",
	[279750] = "Cassa Ricoperta di Fieno",
	[280504] = "Cassa Masticata",
	[280522] = "Tesoro Semidigerito",
	[280576] = "Pergamena Sigillata",
	[280619] = "Vecchia Cassa Rinforzata",
	[280727] = "Nota Carbonizzata",
	[280747] = "Squarcio d'Ombra",
	[280755] = "Borsa di Quintin",
	[280815] = "|cFFFFFFFFStep 1:|r Lettera da Dama Graham I",
	[280836] = "|cFFFFFFFFStep 2:|r Lettera da Dama Graham II",
	[280837] = "|cFFFFFFFFStep 3:|r Lettera da Dama Graham III",
	[280838] = "|cFFFFFFFFStep 4:|r Lettera da Dama Graham IV",
	[280842] = "|cFFFFFFFFStep 5:|r Lettera da Dama Graham V",
	[280843] = "|cFFFFFFFFStep 6:|r Lettera da Dama Graham VI",
	[280844] = "|cFFFFFFFFStep 7:|r Lettera da Dama Graham VII",
	[280845] = "|cFFFFFFFFStep 8:|r Dono da Dama Graham",
	[280883] = "Cassa Consumata dal Sole",
	[280886] = "Cassa Toccata dalle Stelle",
	[280948] = "Latrina del Crepuscolo",
	[280951] = "Spoglie dei Bracescura",
	[281079] = "Muschio Stellare",
	[281092] = "Scorta del Taumaturgo",
	[281230] = "Invito Formale",
	[281312] = "Scorte Rubate",
	[281326] = "Gabbia del Falco",
	[281348] = "Lettera Accartocciata",
	[281397] = "Cassa del Tesoro degli Sferzamaree",
	[281494] = "Cassa del Tesoro Congelata",
	[281551] = "Manifesto Aiuto Cercasi",
	[281583] = "Reliquiario Antico",
	[281639] = "Statua Sgretolata",
	[281646] = "Tino di Miele",
	[281647] = "Avviso Appeso",
	[281655] = "Dono del Cuore Spezzato",
	[281673] = "Diario di Cittadino di Corlain",
	[281718] = "AIUTO CERCASI",
	[281867] = "Muschio Stellare",
	[281868] = "Muschio Stellare",
	[281869] = "Pruno di Sirena",
	[281870] = "Baccello Fluviale",
	[281872] = "Steli Marini",
	[281898] = "Cassa Dimenticata di Dazar",
	[282153] = "Forziere Sommerso",
	[282457] = "Totem della Guardia dei Rovi",
	[282478] = "Cassa Vuota",
	[282498] = "Flauto del Deserto",
	[282666] = "Urna di Agussu",
	[282721] = "Cassa del Tesoro",
	[282723] = "Cassa del Tesoro",
	[284411] = "Cassa del Tesoro",
	[284417] = "Cassa del Tesoro",
	[284421] = "Cassa del Tesoro",
	[284426] = "Macchina da Estrazione Sepolta",
	[284448] = "Cassa Nascosta dello Studioso",
	[284454] = "Bottino dello Squalo Bianco",
	[284455] = "Lamento dell'Esule",
	[286016] = "Diario di Bordo",
	[286954] = "Bomba Robodemolitrice",
	[287081] = "Antica Tavoletta",
	[287185] = "RICERCATO: Oratore Oscuro Jo'la",
	[287189] = "RICERCATO: Bestie Pericolose",
	[287228] = "RICERCATO: Storiografo Oscuro",
	[287229] = "RICERCATO: Storiografo Oscuro",
	[287232] = "Rapporto Esplorativo",
	[287239] = "Ultima Offerta di Grayal",
	[287304] = "Bottino Perduto dell'Esploratore",
	[287318] = "Riserva dei Sabbiafurente",
	[287320] = "Cassa Naufragata",
	[287324] = "Avidità dello Scavatore",
	[287326] = "Tesoro Sepolto di Zem'lan",
	[287327] = "Rapporto Esplorativo",
	[287398] = "RICERCATO: Za'roco",
	[287440] = "RICERCATO: Taz'raka",
	[287441] = "RICERCATO: Esploratore delle Sabbie Vesarik",
	[287442] = "RICERCATI: Partecipanti all'Escursione dei Cobra",
	[287958] = "Bacheca",
	[288157] = "Ricercato: Yarsel'ghun",
	[288167] = "Pacchetto di Marie",
	[288214] = "Manifesto dei Ricercati",
	[288596] = "Cassa di Segreti",
	[288609] = "Cassa dei Tortolliani",
	[288622] = "Manifesto dei Ricercati",
	[288641] = "RICERCATO: Rapitore di Grifoni",
	[289310] = "RICERCATO: Guardiaterra Infuriato",
	[289313] = "RICERCATO: La Vespa",
	[289317] = "Alga Marina",
	[289361] = "RICERCATO: Quartiermastro Ssylis",
	[289365] = "Manifesto dei Ricercati",
	[289521] = "Traslocatore dei Titani",
	[289647] = "Cassa del Tesoro Logora",
	[289728] = "Mappa del Tesoro del Capitano Gulnaku",
	[290127] = "Cassa dei Tortolliani",
	[290128] = "Cassa dei Tortolliani",
	[290138] = "Bomba Robodemolitrice",
	[290419] = "Manifesto dei Ricercati",
	[290537] = "Aiuto Cercasi",
	[290725] = "Tesoro di Tor'nowa",
	[290750] = "Deposito dei Jambani",
	[290765] = "Grande Pila di Monete d'Oro",
	[290993] = "Bottino dei Marferreo",
	[291143] = "Chiave Meccanica di Ranah",
	[291233] = "Coda di Saurolisco",
	[291238] = "Lacrime di Bwonsamdi",
	[291241] = "Radice di Gnarl",
	[291257] = "Cassa del Tesoro Piccola",
	[291291] = "RICERCATO: Bracconiere",
	[292523] = "Manifesto dei Ricercati",
	[292673] = "Pergamena Umida",
	[292674] = "Pergamena Umida",
	[292675] = "Pergamena Umida",
	[292676] = "Pergamena Umida",
	[292677] = "Pergamena Umida",
	[292686] = "Altare Inquietante",
	[292812] = "Amaraina di Zaffiro",
	[292823] = "Ira di Krag'wa",
	[292825] = "Sbocciapietra",
	[292843] = "Gemma dell'Acquiescenza",
	[293134] = "Grossa Granata d'Azerite",
	[293349] = "Cestino della Merenda Scartato",
	[293350] = "Cassa di Legno Intagliata",
	[293351] = "Tartufo",
	[293445] = "Tartufo",
	[293446] = "Tartufo",
	[293449] = "Tartufo",
	[293567] = "Manifesto dei Ricercati",
	[293568] = "Manifesto dei Ricercati",
	[293837] = "|cFFFFFFFFStep 2:|r Sasso Comune I",
	[293838] = "|cFFFFFFFFStep 3:|r Sasso Comune II",
	[293839] = "|cFFFFFFFFStep 4:|r Sasso Comune III",
	[293840] = "|cFFFFFFFFStep 5:|r Sasso Comune IV",
	[293841] = "|cFFFFFFFFStep 6:|r Sasso Comune V",
	[293842] = "|cFFFFFFFFStep 7:|r Sasso Comune VI",
	[293843] = "|cFFFFFFFFStep 8:|r Sasso Comune VII",
	[293844] = "|cFFFFFFFFStep 9:|r Sasso Comune VIII",
	[293845] = "|cFFFFFFFFStep 10:|r Sasso Comune IX",
	[293846] = "|cFFFFFFFFStep 11:|r Sasso Comune X",
	[293849] = "Nota Vistosa",
	[293852] = "Forziere del Tesoro Sepolto",
	[293880] = "Forziere del Tesoro Sepolto",
	[293881] = "Forziere del Tesoro Sepolto",
	[293884] = "Forziere del Tesoro Sepolto",
	[293962] = "Scorta del Nobile Precaria",
	[293964] = "Scorte del Contrabbandiere Dimenticate",
	[293965] = "Cassetta dei Bendarozza",
	[293985] = "RICERCATO: Sbudellaguerra",
	[294084] = "Bottino Segreto della Compagnia dell'Avventuriero",
	[294096] = "Globo Acceso",
	[294105] = "Vecchio Libro",
	[294106] = "Pesce Morto",
	[294107] = "Tavola Graffiata",
	[294108] = "Anello Perduto",
	[294109] = "Mela Avariata",
	[294110] = "Dente Rotto",
	[294111] = "Elmo Usato",
	[294112] = "Foglia Frondosa",
	[294113] = "Stoffa Ammuffita",
	[294114] = "Tavoletta Spezzata",
	[294115] = "Torcia Incenerita",
	[294125] = "Alga d'Ancora",
	[294173] = "Cassa di Rifornimenti della S.P.R. & Co.",
	[294174] = "Cassa Dimenticata",
	[294312] = "Elenco degli Amici di Tetry",
	[294314] = "Elenco dei Nemici di Tetry",
	[294315] = "Ricette Preferite di Tetry",
	[294316] = "Offerte Perdute di Kimbul",
	[294317] = "Cassa dei Legnomorto",
	[294319] = "Tesoro Sepolto nella Sabbia",
	[294335] = "Patata Marcia",
	[294703] = "Scrigno Arrugginito di Tetry",
	[296252] = "Scatola di Grosse Granate d'Azerite",
	[296479] = "Scrigno dell'Ammiraglio Supremo",
	[296536] = "Trilama Insanguinata della Sentinella",
	[296573] = "Lama Arrugginita di Jason",
	[296574] = "Bottiglia Vuota di Ian",
	[296575] = "Piatto Spaccato di Julie",
	[296579] = "Bussola Rotta di Brian",
	[296580] = "Diario Rilegato di Ofer",
	[296581] = "Sassolino di Skye",
	[296582] = "Stivale Sinistro di Julien",
	[296583] = "Fiasca di Navarro",
	[296584] = "Borraccia di Zach",
	[296585] = "Zaino di Damarcus",
	[296586] = "Flauto di Rachel",
	[296587] = "Collana di Zanne di Josh",
	[296588] = "Ritratto del Comandante Martens",
	[296589] = "Chiave Adornata di Kurt",
	[296854] = "Antica Pergamena dei Saggi delle Maree",
	[296855] = "Tartufo",
	[296902] = "Antica Pergamena dei Saggi delle Maree",
	[296903] = "Antica Pergamena dei Saggi delle Maree",
	[296904] = "Antica Pergamena dei Saggi delle Maree",
	[296905] = "Antica Pergamena dei Saggi delle Maree",
	[296906] = "Antica Pergamena dei Saggi delle Maree",
	[296907] = "Antica Pergamena dei Saggi delle Maree",
	[296908] = "Antica Pergamena dei Saggi delle Maree",
	[296915] = "Stele dei Drust: Circolo",
	[296916] = "Stele dei Drust: Rituale",
	[296917] = "Stele dei Drust: Albero",
	[296918] = "Stele dei Drust: Soffio nella Pietra",
	[297069] = "Cassettone",
	[297071] = "Piccola Borsa di Monete",
	[297074] = "Storie dei Loa: Gral",
	[297485] = "Storie dei Loa: Sethraliss",
	[297489] = "Storie dei Loa: Krag'wa",
	[297490] = "Storie dei Loa: Rezan",
	[297491] = "Storie dei Loa: Bwonsamdi",
	[297492] = "Bacheca",
	[297493] = "Storie dei Loa: Shadra",
	[297494] = "Storie dei Loa: Kimbul",
	[297495] = "Storie dei Loa: Akunda",
	[297521] = "Storie dei Loa: Gonk",
	[297522] = "Storie dei Loa: Hir'eek",
	[297523] = "Storie dei Loa: Torga",
	[297524] = "Storie dei Loa: Pa'ku",
	[297528] = "Storie dei Loa: Jani",
	[297627] = "Stele dei Drust: Sacrificio",
	[297628] = "Stele dei Drust: Costrutti",
	[297629] = "Stele dei Drust: Il Ciclo",
	[297630] = "Stele dei Drust: Conflitto",
	[297631] = "Stele dei Drust: Lo Scorticato",
	[297632] = "Stele dei Drust: Protettori della Foresta",
	[297700] = "Storie dei Loa: Zandalar",
	[297825] = "Cassa Coperta di Ragnatele",
	[297828] = "Cassa del Mercante",
	[297878] = "Cassa Maledetta",
	[297879] = "Cassa Magica",
	[297880] = "Cassa Stregata",
	[297881] = "Cassa Incantata",
	[297885] = "Storie dei Loa: Torcali",
	[297891] = "Scorta Vincolata alle Rune",
	[297892] = "Cassa Runica",
	[297893] = "Scrigno Runico",
	[297905] = "Libro di Canzoni di Jay",
	[297906] = "Libro di Canzoni di Russel",
	[297933] = "Libro di Canzoni Impolverato",
	[297934] = "Libro di Canzoni della Canaglia",
	[297939] = "Balestra dell'Ordine delle Braci",
	[297940] = "Coltello dell'Ordine delle Braci",
	[297941] = "Cappello dell'Ordine delle Braci",
	[297942] = "Tonico dell'Ordine delle Braci",
	[298766] = "Vecchia Balestra",
	[298767] = "Vecchio Coltello",
	[298768] = "Vecchio Tonico",
	[298769] = "Vecchio Pileo",
	[298778] = "Manifesto dei Ricercati",
	[298849] = "Manifesto dei Ricercati",
	[298920] = "Scrigno dei Cantaspine Rubato",
	[298921] = "Tavoletta Antica dei Nazmani",
	[298963] = "Tavoletta Logora dei Nazmani",
	[298965] = "Tavoletta Spaccata",
	[299073] = "Tavoletta Fratturata",
	[303016] = "|cFFFFFFFFStep 14:|r Sasso Comune XIII",
	[303017] = "|cFFFFFFFFStep 13:|r Sasso Comune XII",
	[303018] = "|cFFFFFFFFStep 12:|r Sasso Comune XI",
	[303039] = "Sacco di Grano Curioso",
	[307091] = "Pugnale Sussurrante Inquietante",
	[307265] = "Manifesto dei Ricercati",
	[307277] = "Vecchio Fiasco",
	[307307] = "Barile Spezzato",
	[307325] = "Manifesto dei Ricercati",
	[307330] = "Scrigno del Capitano",
	[307340] = "Cassa Chiusa",
	[307836] = "Minerale del Crepuscolo",
	[309498] = "Supporto per Armatura",
	[310600] = "Antico Tomo Kaldorei",
	[310601] = "Briglia di Fiera della Notte Scartata",
	[310603] = "Arco della Gran Sacerdotessa",
	[310709] = "Cassa Fradicia",
	[310736] = "Cassa di Minerali",
	[311155] = "Antica Tavoletta",
	[311822] = "Disturbatore Robotico",
	[311902] = "Componenti Sciolti",
	[313446] = "Merci Recuperate dell'Alba d'Argento",
	[313447] = "Merci Recuperate dell'Alba d'Argento",
	[313448] = "Merci Recuperate dell'Alba d'Argento",
	[316792] = "Minerale di Ferro Trafugato",
	[319222] = "Cassa di Rivafosca",
	[320514] = "Cassa di Rivafosca",
	[320515] = "Cassa di Rivafosca",
	[320516] = "Cassa di Rivafosca",
	[320517] = "Cassa di Rivafosca",
	[320518] = "Cassa di Rivafosca",
	[322020] = "Pila di Monete",
	[322066] = "Accumulatore delle Linee di Faglia",
	[322413] = "Cassa Luccicante",
	[322533] = "Tomo degli Elementi di Mardivas",
	[322791] = "Algabacca",
	[322803] = "Algabacca",
	[324407] = "Radici del Vuoto",
	[325659] = "Forziere Meccanizzato",
	[325660] = "Forziere Meccanizzato",
	[325661] = "Forziere Meccanizzato",
	[325662] = "Forziere Meccanizzato",
	[325663] = "Forziere Meccanizzato",
	[325664] = "Forziere Meccanizzato",
	[325665] = "Forziere Meccanizzato",
	[325666] = "Forziere Meccanizzato",
	[325667] = "Forziere Meccanizzato",
	[325668] = "Forziere Meccanizzato",
	[325759] = "Bivalve Infuso di mana",
	[325795] = "Cassa Sprofondata",
	[325853] = "Libreria Vuota",
	[325869] = "Barile Vuoto",
	[325873] = "Deposito Ricco di Osmenite",
	[325874] = "Vena di Osmenite",
	[325875] = "Deposito di Osmenite",
	[325894] = "Cassa Arcana",
	[325954] = "Mappa del Tesoro Illeggibile",
	[326026] = "Cassa del Vuoto",
	[326027] = "Riciclaggiatore DX-82",
	[326047] = "Cassa Rinforzata",
	[326140] = "Bacheca delle Taglie",
	[326141] = "Bacheca delle Taglie",
	[326142] = "Bacheca delle Taglie",
	[326148] = "Piani d'attacco dei Naga",
	[326394] = "Cassa Arcana",
	[326395] = "Baule Arcano Luminoso",
	[326396] = "Baule Arcano Luminoso",
	[326397] = "Baule Arcano Luminoso",
	[326398] = "Baule Arcano Luminoso",
	[326399] = "Baule Arcano Luminoso",
	[326400] = "Baule Arcano Luminoso",
	[326401] = "Cassa Arcana",
	[326402] = "Cassa Arcana",
	[326403] = "Cassa Arcana",
	[326404] = "Cassa Arcana",
	[326405] = "Cassa Arcana",
	[326406] = "Cassa Arcana",
	[326407] = "Cassa Arcana",
	[326408] = "Cassa Arcana",
	[326409] = "Cassa Arcana",
	[326410] = "Cassa Arcana",
	[326411] = "Cassa Arcana",
	[326412] = "Cassa Arcana",
	[326413] = "Cassa Arcana",
	[326414] = "Cassa Arcana",
	[326415] = "Cassa Arcana",
	[326416] = "Cassa Arcana",
	[326417] = "Cassa Arcana",
	[326418] = "Cassa Arcana",
	[326419] = "Cassa Arcana",
	[326588] = "Cassa d'Armi d'Azerite",
	[326594] = "Tomo Arcano",
	[327170] = "Rastrelliera delle Armi",
	[327221] = "Botte di Algabacca",
	[327230] = "Deposito di Pappa Reale",
	[327407] = "Scorte Preziose degli Ogre",
	[327516] = "Deposito di Pappa Reale",
	[327548] = "Progetti della Batteria",
	[327568] = "Cassa dei Pirati",
	[327569] = "Cassa dei Pirati",
	[327570] = "Cassa dei Pirati",
	[327585] = "Bacheca delle Taglie",
	[327591] = "Diario Conservato",
	[327592] = "Lucchetto Incantato",
	[327596] = "Focus Abissale Rotto",
	[327597] = "Vecchia Cassa Arrugginita",
	[327650] = "Cassa di Rifornimenti da Guerra",
	[327652] = "Cassa di Rifornimenti da Guerra",
	[329641] = "Ricercati: Junkmatt e Roadtrogg",
	[329715] = "Pezzi e Pezzettini Utili",
	[329805] = "Cristallo Strano",
	[329918] = "Tesori dei Verrospino",
	[329919] = "Rifornimenti Rubati",
	[330168] = "Elementale Alcolico Contenuto",
	[330183] = "Scrigno dei Marferreo",
	[330627] = "Segnale di Pericolo",
	[332568] = "Statuetta Felina Cristallina",
	[332569] = "Statuetta Felina Cristallina",
	[332570] = "Statuetta Felina Cristallina",
	[332571] = "Statuetta Felina Cristallina",
	[332572] = "Statuetta Felina Cristallina",
	[332573] = "Statuetta Felina Cristallina",
	[332574] = "Statuetta Felina Cristallina",
	[332575] = "Statuetta Felina Cristallina",
	[332576] = "Statuetta Felina Cristallina",
	[334216] = "Cassa dell'Impero Nero",
	[334220] = "Cassa dell'Impero Nero",
	[335655] = "Braccio di Oonar",
	[336415] = "Pergamena Scartata",
	[337237] = "Segrete Perdute",
	[337241] = "Equipaggiamento Nascosto",
	[338520] = "Fungo di Stagnofosco",
	[339211] = "Ciotola Vuota",
	[339243] = "Forziere Infestato",
	[339248] = "Cassa Infestata",
	[339249] = "Cassa Infestata",
	[339250] = "Cassa Infestata",
	[339283] = "Cassa dei Nobili Dimenticata",
	[339601] = "Pergamena degli Eoni",
	[339625] = "Dono di Sofia",
	[339641] = "Bevanda Purificante",
	[339770] = "Cassa del Tesoro Abbandonata",
	[339837] = "Borsa di Polvere",
	[339869] = "Cassa del Curatore",
	[341416] = "Catena della Saracinesca delle Segrete",
	[341424] = "Ricordi Dimenticati",
	[343611] = "Uovo Toccato dal Vuoto",
	[343698] = "Teschio Toccato dal Vuoto",
	[344588] = "Brodo di Toto",
	[344726] = "Sermone Oscuro",
	[345446] = "Grande Corno del Cervo delle Rune",
	[345455] = "Cassa di Rifornimenti del Costrutto",
	[345456] = "Cassa di Occhi",
	[345458] = "Borsa Premio",
	[347444] = "Scudo d'Ossa Decorato",
	[348521] = "Crescita Strana",
	[348558] = "Avviso",
	[348676] = "Dardo di Balista",
	[348747] = "Pergamena Infangata",
	[349515] = "Diario Rovinato",
	[349565] = "Cassa dei Sogni Invidiosi",
	[349612] = "Ricercato: Valutatore Vix",
	[349792] = "Premio di Filcher",
	[349793] = "Spoglie Abbandonante del Viandante",
	[349794] = "Forziere Nascosto di Tardasonno",
	[349795] = "Raccolta delle Anime in Fuga",
	[349796] = "Cassa della Prugna Dorata",
	[349797] = "Rarità Abbandonate",
	[349798] = "Scrigno di Contrabbando",
	[350802] = "Cassa Sigillata con le Ragnatele",
	[350804] = "Arpa Rotta",
	[350972] = "Catena della Saracinesca della Cella",
	[350978] = "Cassa del Vivaio della Regina",
	[351467] = "Epitaffio Sbiadito",
	[351487] = "Tesoro Segreto",
	[351540] = "Tesoro Segreto",
	[351541] = "Tesoro Segreto",
	[351542] = "Tesoro Segreto",
	[351543] = "Tesoro Segreto",
	[351544] = "Tesoro Segreto",
	[351545] = "Tesoro Segreto",
	[351874] = "Ricercato: Esecutore Kristoff",
	[351885] = "Ricercato: Aggregato della Rovina",
	[351886] = "Ricercato: Duca Anton",
	[351887] = "Ricercato: Sire Darion",
	[351888] = "Ricercato: Evocatore Marcelis",
	[351889] = "Ricercata: La Rovina Pallida",
	[351948] = "Cassa Dimenticata",
	[351980] = "Rifornimenti Smarriti",
	[352027] = "Pergamena del Ricercato",
	[352028] = "Pergamena del Ricercato",
	[352086] = "Cassa dei Segugi Neri",
	[352181] = "Bacchetta a Misura di Spriggan",
	[352182] = "Arma ad Asta a Misura di Spriggan",
	[352428] = "Vespro delle Virtù",
	[352433] = "Scrigno degli Occhi",
	[352490] = "Unisciti alla Ribellione!",
	[352520] = "Medaglione dell'Orgoglio",
	[352596] = "Crescita Germogliante",
	[352703] = "La Mietitura",
	[352754] = "Forziere d'Argento",
	[353019] = "Forziere d'Argento",
	[353205] = "Forziere d'Argento",
	[353231] = "Cassa Legaossa",
	[353232] = "Cassa di Legnocupo",
	[353233] = "Cassa Incantata",
	[353234] = "Forziere Dorato",
	[353252] = "Forziere d'Argento",
	[353305] = "Mazzuolo di Spaccapietra",
	[353306] = "Guscio Decomposto",
	[353314] = "Forziere d'Argento",
	[353323] = "Guscio Decomposto",
	[353324] = "Guscio Decomposto",
	[353325] = "Forziere d'Argento",
	[353326] = "Guscio Decomposto",
	[353327] = "Guscio Decomposto",
	[353329] = "Scorte dei Silfidi",
	[353330] = "Scorte dei Silfidi",
	[353331] = "Scorte dei Silfidi",
	[353332] = "Scorte dei Silfidi",
	[353333] = "Scorte dei Silfidi",
	[353340] = "Libro Impolverato",
	[353380] = "Cestino del Pranzo di Halis",
	[353472] = "Spada Radiosa",
	[353484] = "La Gran Banca",
	[353500] = "Forziere d'Argento",
	[353503] = "Forziere d'Argento",
	[353516] = "Forziere d'Argento",
	[353626] = "Cassetta degli Attrezzi Chiusa",
	[353627] = "Razioni del Fronte di Battaglia",
	[353643] = "Forziere d'Argento",
	[353645] = "Diario di Marileth",
	[353650] = "Forziere Dorato del Factotum",
	[353681] = "Baccello della Luce Lunare",
	[353683] = "Baccello della Luce Lunare",
	[353684] = "Baccello della Luce Lunare",
	[353685] = "Baccello della Luce Lunare",
	[353686] = "Baccello della Luce Lunare",
	[353687] = "Campana Rotta",
	[353688] = "Campana Rotta",
	[353689] = "Campana Rotta",
	[353691] = "Campana della Vetta",
	[353791] = "Forziere del Castello",
	[353792] = "Forziere del Villaggio",
	[353793] = "Cassa del Distretto",
	[353796] = "Reliquiario della Rimembranza",
	[353797] = "Rifornimenti della Legione di Pietra",
	[353799] = "Zaino del Frangifede",
	[353868] = "Scorta Nascosta",
	[353869] = "Scorta Nascosta",
	[353870] = "Scorta Nascosta",
	[353871] = "Scorta Nascosta",
	[353872] = "Scorta Nascosta",
	[353873] = "Scorta Nascosta",
	[353874] = "Cono d'Animum",
	[353876] = "Virtù del Pentimento",
	[353940] = "Dono di Vesifone",
	[353941] = "Dono di Chyrus",
	[353942] = "Dono di Agthia",
	[353943] = "Dono di Thenios",
	[353944] = "Dono di Devos",
	[353948] = "Medaglione del Desiderio",
	[353949] = "Medaglione dell'Avarizia",
	[354075] = "Cartapecora Vuota",
	[354108] = "Borsa dei Litogeni",
	[354109] = "Borsa dei Litogeni",
	[354110] = "Borsa dei Litogeni",
	[354111] = "Borsa dei Litogeni",
	[354112] = "Borsa dei Litogeni",
	[354113] = "Borsa dei Litogeni",
	[354114] = "Borsa dei Litogeni",
	[354115] = "Premio del Pugile",
	[354116] = "Premio del Pugile",
	[354121] = "Premio del Pugile",
	[354122] = "Premio del Pugile",
	[354123] = "Premio del Pugile",
	[354175] = "Cassa dell'Ascensione",
	[354186] = "Borsa dei Litogeni",
	[354187] = "Borsa dei Litogeni",
	[354188] = "Borsa dei Litogeni",
	[354189] = "Borsa dei Litogeni",
	[354190] = "Borsa dei Litogeni",
	[354191] = "Borsa dei Litogeni",
	[354192] = "Borsa dei Litogeni",
	[354193] = "Borsa dei Litogeni",
	[354202] = "Scorte Abbandonate",
	[354208] = "Equipaggiamento Rubato",
	[354211] = "Ricompensa dell'Avidità",
	[354213] = "Note del Discepolo Perduto",
	[354214] = "Bardatura del Domatore di Larion",
	[354275] = "Parte di Costrutto Sperimentale",
	[354283] = "Retaggio di Mercia: Capitolo Uno",
	[354284] = "Retaggio di Mercia: Capitolo Due",
	[354285] = "Retaggio di Mercia: Capitolo Tre",
	[354286] = "Retaggio di Mercia: Capitolo Quattro",
	[354287] = "Retaggio di Mercia: Capitolo Cinque",
	[354288] = "Retaggio di Mercia: Capitolo Sei",
	[354289] = "Attrezzi del Forgiavento",
	[354467] = "Retaggio di Mercia: Capitolo Sette",
	[354645] = "Borsa Perduta",
	[354646] = "Antico Uovo di Piumanube",
	[354647] = "Piuma di Drago Vigorosa",
	[354648] = "Rifornimenti di Poggioscuro",
	[354649] = "Scorta di Reliquie",
	[354650] = "Cuore di Cantonirico",
	[354651] = "Acchiappasogni Incantato",
	[354652] = "Collezione dei Silfidi",
	[354662] = "Scrigno Elusivo dei Silfidi",
	[354852] = "Crescita Germogliante",
	[354853] = "Crescita Germogliante",
	[354856] = "Cassa Coperta di Poltiglia",
	[354911] = "Seme dell'Animum Rigonfio",
	[355000] = "Scrigno della Notte",
	[355019] = "Seta Onirica Grezza",
	[355020] = "Ramo Incantato",
	[355021] = "Ornamento dei Silfi",
	[355035] = "Scrigno Runico Prescelto",
	[355037] = "Scrigno Runico",
	[355038] = "Scrigno Runico",
	[355040] = "Runa dei Rituali",
	[355041] = "Scrigno della Luna",
	[355048] = "Runa dei Rituali",
	[355049] = "Runa dei Rituali",
	[355194] = "Runa dei Costrutti",
	[355195] = "Runa dei Costrutti",
	[355196] = "Runa dei Costrutti",
	[355286] = "Offerte Commemorative",
	[355296] = "Incarico: Contenimento bestiale",
	[355355] = "Forziere Armonico",
	[355435] = "Vespro del Vento d'Argento",
	[355449] = "Dono del Vento d'Argento",
	[355798] = "Gabbia",
	[355865] = "Vasca di Poltiglia Appariscente",
	[355872] = "Vaso Rubato",
	[355880] = "Necronom-i-nom",
	[355886] = "Cassa del Caduto della Piaga",
	[355947] = "Cassa di Glutharn",
	[355980] = "Scrigno del Ritualista",
	[356535] = "Collezione dell'Oratore Runico",
	[356555] = "La Collana di Eurydea",
	[356697] = "Tributo Smodato di Alexandros Mograine",
	[356700] = "Tributo Smodato del Gran Maestro Vole",
	[356705] = "Tributo Smodato dell'Architetto della Piaga Marileth",
	[356709] = "Tributo Smodato di Dama Baccaluna",
	[356712] = "Tributo Smodato del Capitano della Caccia Korayn",
	[356728] = "Tributo Smodato di Mikanikos",
	[356737] = "Tributo Smodato di Sika",
	[356752] = "Tributo Smodato del Custode delle Cripte Kassir",
	[356757] = "Desiderio dell'Avidità",
	[356818] = "Penitenza della Purezza",
	[356820] = "Grosso Baccello della Luce Lunare",
	[356823] = "Scrigno del Calca Nubi",
	[357228] = "Cassa Dimenticata",
	[357229] = "Cassa Dimenticata",
	[357230] = "Cassa Dimenticata",
	[357231] = "Cassa Dimenticata",
	[357232] = "Cassa Dimenticata",
	[357233] = "Cassa Dimenticata",
	[357234] = "Cassa Dimenticata",
	[357235] = "Cassa Dimenticata",
	[357236] = "Cassa Dimenticata",
	[357237] = "Cassa Dimenticata",
	[357238] = "Cassa Dimenticata",
	[357246] = "Pergamena Lacera",
	[357467] = "Inchiostro Proibito",
	[357487] = "Parasole Stiloso",
	[357515] = "Sacca di Avena",
	[357526] = "Secchio d'Acqua Vuoto",
	[357541] = "Ferro di Cavallo Scartato",
	[357565] = "Canna da Pesca Dimenticata",
	[357572] = "Stocco dell'Impavido",
	[357584] = "Lama da Guerra di Vyrtha",
	[357683] = "Pozza di Fango Improvvisata dell'Esiliato",
	[357697] = "Manufatto del Coordinatore",
	[357726] = "Lancia Spezzata",
	[357758] = "Barile di Piaga",
	[357771] = "Cassa Sepolta",
	[357937] = "Cassa Sepolta",
	[358298] = "Scrigno della Stanza Proibita",
	[358315] = "Frammenti di Mano Scheletrica",
	[358318] = "Ritratto del Dragatore di R. Suavel",
	[358319] = "Nota dell'Occultista",
	[358382] = "Ricercato: Chelicera",
	[358398] = "Diario Perduto",
	[358399] = "Zaino delle Sei Leghe",
	[358531] = "Cassa Gigante di Tesori Epici",
	[358533] = "Rifornimenti Dimenticati",
	[358855] = "Zaino della Caduta Sicura Danneggiato",
	[360054] = "Gatto Appiccicoso",
	[362489] = "Decreto Elisio",
	[364345] = "Seme Debolmente Luminoso",
	[364483] = "Barile di Cicchetti Vuoto",
	[364899] = "Stigia Cristallizzata",
	[364926] = "Catene Runaforgiate",
	[364932] = "Lingotto Fiammeggiante",
	[364937] = "Risucchiatore Fasico",
	[364987] = "Diario dell'Alienatore",
	[364994] = "Piccone Spettrale",
	[365084] = "Picca del Tormentatore",
	[365093] = "Libri di Canti di Teotar",
	[368205] = "Scrigno dei Giurafauce",
	[368206] = "Scrigno dei Giurafauce",
	[368207] = "Scrigno dei Giurafauce",
	[368208] = "Scrigno dei Giurafauce",
	[368213] = "Scrigno dei Giurafauce",
	[368214] = "Scrigno dei Giurafauce",
	[368347] = "Forziere Nascosto della Fenditura",
	[368645] = "Forziere Nascosto della Fenditura",
	[368646] = "Forziere Nascosto della Fenditura",
	[368648] = "Forziere Nascosto della Fenditura",
	[368649] = "Forziere Nascosto della Fenditura",
	[368650] = "Forziere Nascosto della Fenditura",
	[368653] = "Gabbia del Dragone dell'Etere",
	[368663] = "Mano Destra di Abominietto",
	[368665] = "Braccio di Riserva di Abominietto",
	[368666] = "Testa di Abominietto",
	[368667] = "Torso di Abominietto",
	[368668] = "Tronco di Abominietto",
	[368772] = "Pergamena con Sigillo",
	[368876] = "Scrigno dei Giurafauce",
	[368935] = "Gabbia dello Stridente di Oblio del Peccato",
	[368946] = "Ricettacolo d'Animum Rubato",
	[368948] = "Ricettacolo d'Animum Rubato",
	[368949] = "Ricettacolo d'Animum Rubato",
	[368950] = "Ricettacolo d'Animum Rubato",
	[368951] = "Ricettacolo d'Animum Rubato",
	[368952] = "Ricettacolo d'Animum Rubato",
	[368953] = "Ricettacolo d'Animum Rubato",
	[369129] = "Vera d'Oro di Nilganihmaht",
	[369132] = "Cassa Sigillata del Dominio",
	[369133] = "Sigillo del Dominio #1",
	[369134] = "Gabbia Sigillata del Dominio",
	[369135] = "Sigillo del Dominio #2",
	[369138] = "Sigillo della Cassa del Dominio",
	[369141] = "Scrigno dei Giurafauce",
	[369143] = "Anello Antico Diviso in Quattro",
	[369144] = "Mazzo di Chiavi della Straziatrice",
	[369145] = "Cassa di Rifornimenti di Helgarde",
	[369148] = "Materiale del Nido Scintillante",
	[369149] = "Piuma Dimenticata",
	[369172] = "Ricordo Perduto",
	[369183] = "Nido Rimosso",
	[369185] = "Scatola di Reliquie di Korthia",
	[369194] = "Uovo Carico d'Animum",
	[369204] = "Reliquia Fuori Posto",
	[369216] = "Cassa degli Helsvorn",
	[369224] = "Cuore di Ezekiel Ingioiellato",
	[369225] = "Vestigia Infestate",
	[369227] = "Ricettacolo d'Animum Rubato",
	[369232] = "Scatola delle Offerte",
	[369234] = "Chiave delle Offerte",
	[369235] = "Ricettacolo d'Animum Rubato",
	[369236] = "Ricettacolo d'Animum Rubato",
	[369245] = "Scatola di Reliquie di Korthia",
	[369292] = "Cassa di Reliquie",
	[369294] = "Cassa di Reliquie",
	[369295] = "Pila d'Ossa",
	[369296] = "Scorte dei Pellescheggia",
	[369297] = "Pila d'Ossa",
	[369304] = "Scatola di Reliquie di Korthia",
	[369327] = "Fungofauce Invasivo",
	[369329] = "Fungofauce Invasivo",
	[369330] = "Fungofauce Invasivo",
	[369331] = "Fungofauce Invasivo",
	[369332] = "Fungofauce Invasivo",
	[369333] = "Nido di Materiali Insoliti",
	[369334] = "Nido di Materiali Insoliti",
	[369335] = "Nido di Materiali Insoliti",
	[369336] = "Nido di Materiali Insoliti",
	[369337] = "Nido di Materiali Insoliti",
	[369339] = "Scrigno dei Giurafauce",
	[369340] = "Scatola di Reliquie di Korthia",
	[369341] = "Scrigno dei Giurafauce",
	[369432] = "Tomo dei Venthyr Smarrito",
	[369437] = "Cassa Vincolata alla Fenditura",
	[369438] = "Cassa Vincolata alla Fenditura",
	[369439] = "Cassa Vincolata alla Fenditura",
	[369440] = "Cassa Vincolata alla Fenditura",
	[369602] = "Mani della Ribellione",
	[369757] = "Forziere Sommerso",
	[369893] = "Missiva Urgente",
	[369894] = "Missiva Urgente",
	[370140] = "Scorte dei Jiro Danneggiate",
	[370469] = "Nutrimento Spettrale",
	[370494] = "Cassa Toccatiana",
	[373471] = "Cassa Mezzonica",
	[373472] = "Cassa Glissandiana",
	[373473] = "Cassa Fuguelica",
	[373474] = "Cassa Cantarica",
	[373543] = "Scrigno della Biblioteca",
	[373548] = "Archivio dei Progetti",
	[373553] = "Teletrasporto",
	[373561] = "Proto-Cripta Dimenticata",
	[373562] = "Indice Emozionante",
	[373563] = "Indice Mercuriale",
	[373568] = "Cassa di Provis Chiusa",
	[373579] = "Scoperta dell'Occhio Indiscreto",
	[373580] = "Indice Tranquillo",
	[373581] = "Indice Emozionante",
	[373582] = "Indice Mercuriale",
	[373583] = "Indice Tranquillo",
	[373584] = "Indice Emozionante",
	[373585] = "Indice Mercuriale",
	[373586] = "Indice Tranquillo",
	[373587] = "Indice Emozionante",
	[373588] = "Indice Mercuriale",
	[374976] = "Volta Sinfonica",
	[375021] = "Automa Defunto",
	[375058] = "Cassa Toccatiana",
	[375059] = "Cassa Mezzonica",
	[375060] = "Cassa Glissandiana",
	[375061] = "Cassa Fuguelica",
	[375062] = "Cassa Cantarica",
	[375064] = "Cassa Toccatiana",
	[375066] = "Cassa Mezzonica",
	[375067] = "Cassa Glissandiana",
	[375068] = "Cassa Fuguelica",
	[375069] = "Cassa Cantarica",
	[375188] = "Disposizione dell'Alcova della Curvatura",
	[375189] = "Disposizione dell'Alcova del Repertorio",
	[375190] = "Disposizione dell'Alcova Rotonda",
	[375191] = "Disposizione dell'Alcova Dormiente",
	[375192] = "Disposizione dell'Alcova Fulgida",
	[375234] = "Deposito Indurito di Draconium",
	[375235] = "Deposito Fuso di Draconium",
	[375238] = "Deposito Toccato dai Titani di Draconium",
	[375239] = "Deposito Primordiale di Draconium",
	[375240] = "Deposito Impetuoso di Draconium",
	[375241] = "Papavero Bolla",
	[375242] = "Papavero Bolla Toccato dai Titani",
	[375243] = "Papavero Bolla Impetuoso",
	[375244] = "Papavero Bolla Gelato",
	[375245] = "Papavero Bolla Scompigliato",
	[375246] = "Papavero Bolla Decaduto",
	[375270] = "Schema di Protoforma",
	[375272] = "Scrigno dei Giurafauce",
	[375281] = "Reliquia Rubata",
	[375283] = "Matrice di Filtrazione",
	[375290] = "Cassa Vincolata al Codice",
	[375354] = "Scrigno del Dominio",
	[375362] = "Nido di Aviano",
	[375363] = "Cassa di Rifornimenti dei Giurafauce",
	[375366] = "Uova di Taracnide",
	[375368] = "Console del Catalizzatore della Creazione",
	[375369] = "Borsa Morsicata",
	[375370] = "Schema di Protoforma",
	[375371] = "Schema di Protoforma",
	[375373] = "Pezzo di Automa Scartato",
	[375376] = "Cassaforte Caduta",
	[375382] = "Cassa di Rifornimenti Frantumata",
	[375383] = "Schema di Protoforma",
	[375387] = "Schema di Protoforma",
	[375388] = "Schema di Protoforma",
	[375389] = "Schema di Protoforma",
	[375390] = "Schema di Protoforma",
	[375391] = "Schema di Protoforma",
	[375393] = "Schema di Protoforma",
	[375396] = "Cumulo di Sabbia Grumoso",
	[375397] = "Cumulo di Sabbia Scintillante",
	[375398] = "Cumulo di Sabbia Mutevole",
	[375399] = "Cumulo di Sabbia Ronzante",
	[375400] = "Cumulo di Sabbia Deforme",
	[375401] = "Cumulo di Sabbia Sfavillante",
	[375402] = "Cumulo di Sabbia Ticchettante",
	[375403] = "Reliquia Coperta di Poltiglia",
	[375404] = "Cassa Consumata dalla Sabbia",
	[375405] = "Manufatto Rubato",
	[375408] = "Riserva dell'Architetto",
	[375411] = "Ovoide Sbagliato",
	[375413] = "Rifornimenti degli Alienatori Annegati",
	[375422] = "Protofrutto Ipertrofico",
	[375423] = "Offerte ai Primi",
	[375478] = "Estrattore di Proto-Minerale",
	[375479] = "Schema di Protoforma",
	[375481] = "Stranezza Sottratta",
	[375483] = "Pergamena Rubata",
	[375484] = "Dono Grato",
	[375485] = "Mietitore di Protoflora",
	[375486] = "Schema di Protoforma",
	[375492] = "Scrigno Sintattico",
	[375493] = "Protopera Matura",
	[375494] = "Cassa Arrotondata",
	[375495] = "Fogliame Ondeggiante",
	[375496] = "Carico di Prodotti dei Progenitori",
	[375498] = "Schema di Protoforma",
	[375502] = "Schema di Protoforma",
	[375516] = "Favo Perduto",
	[375517] = "Mucchio di Macerie Sospetto",
	[375530] = "Tesoro Dimenticato",
	[375536] = "Cassa Esplosiva di Xy'rath",
	[375538] = "Ovoide Perduto",
	[375668] = "Cassa del Tesoro Nebbiosa",
	[375693] = "Schema di Protoforma",
	[375694] = "Schema di Protoforma",
	[375746] = "Schema di Prototipo",
	[375748] = "Schema di Protoforma",
	[375889] = "Schema di Protoforma",
	[375893] = "Scrigno di Grande Valore",
	[375900] = "Schema di Protoforma",
	[375902] = "Drappo Etereo Strappato",
	[375903] = "Schema di Protoforma",
	[375905] = "Schema di Protoforma",
	[375907] = "Schema di Protoforma",
	[375915] = "Barlume della Serenità",
	[375950] = "Ninnolo di Pura Innovazione",
	[375972] = "Ricercato: Custos",
	[375973] = "Firim in Esilio, Parte 1",
	[375974] = "Eco Cristallizzata del Primo Canto",
	[375981] = "Schema di Protoforma",
	[375982] = "Firim in Esilio, Parte 2",
	[375983] = "Firim in Esilio, Parte 3",
	[375984] = "Firim in Esilio, Parte 4",
	[375985] = "Firim in Esilio, Parte 5",
	[375986] = "Firim in Esilio, Parte 6",
	[375987] = "Firim in Esilio, Parte 7",
	[376041] = "Cassa del Codice Ammantata",
	[376175] = "Cassa di Provviste a Vele Spiegate",
	[376325] = "Così Vicino, Così Lontano",
	[376386] = "Terra Smossa",
	[376426] = "Cassa Vincolata dalla Magia",
	[376451] = "Cronometro di Bronzo",
	[376578] = "Cassa dei Titani",
	[376580] = "Cassa dei Djaradin",
	[376581] = "Cassa del Clan",
	[376582] = "Cassa dei Tuskarr",
	[376583] = "Cassa Ricoperta di Decadimento",
	[376587] = "Zaino dell'Esploratore della Spedizione",
	[376757] = "RICERCATO: Frigellus",
	[377114] = "Rotolo di Corda Pesante",
	[377485] = "Mela Acida",
	[377499] = "Sulle Origini delle Specie Draconiche",
	[377534] = "Scrigno Consegnato",
	[377899] = "Ostaggio dei Drospi Cornuti Nascosto",
	[377900] = "Lancia da Guerra Nokhud",
	[377938] = "Banco di Saltatori Prismatici",
	[378010] = "Tesoro dei Draghi Dimenticato",
	[378047] = "Cassa di Smeraldo",
	[378054] = "Birra di Marea",
	[378088] = "Fiore Cristallino",
	[378820] = "Punch al Popfizz",
	[378857] = "Cassa d'Ossidiana Perduta",
	[379248] = "Deposito di Draconium",
	[379252] = "Deposito di Draconium",
	[379263] = "Deposito Ricco di Draconium",
	[379267] = "Deposito Ricco di Draconium",
	[379272] = "Vena di Draconium",
	[379290] = "Statua Adornata",
	[379297] = "Melma Bum Bum",
	[379314] = "Rete da Pesca Piena",
	[379321] = "Impronte di Zampe Misteriose",
	[380429] = "Artiglio Dorato",
	[380430] = "Brandello di Coda",
	[380457] = "Calderone del Decadimento Sperimentale",
	[380516] = "Scintilla di Saggezza",
	[380533] = "Pergamena Ricoperta di Neve",
	[380540] = "Statua Adornata",
	[380545] = "Bel Gioiello del Pittore",
	[380547] = "Olio per Tannatura Infuso di Decadimento",
	[380548] = "Scrigno di Gioielli Dimenticati",
	[380549] = "Rotolo di Stoffa Blu Affascinante",
	[380550] = "Tomo dell'Apprendista Smemorato",
	[380554] = "Tamburo Ritmico",
	[380556] = "Forziere Armonico",
	[380558] = "Macerie Incantate",
	[380559] = "Pozione Forgiata dal Gelo",
	[380567] = "Otto di Tempeste",
	[380569] = "Rampicante Cristallino",
	[380571] = "Razzo di Boomthyr",
	[380577] = "Malygosite Superba",
	[380578] = "Come addestrare un draghetto",
	[380579] = "Attrezzi dei Djaradin di riserva",
	[380580] = "Gemma Infusa di Lava",
	[380583] = "Coperta dei Felcepelle Decadente",
	[380585] = "Formazione di Alexstraszite Eruttata",
	[380587] = "Cassa di Pelli Trattate",
	[380588] = "Stendardo in Miniatura dello Stormo dei Draghi di Bronzo",
	[380590] = "Boccale ben Isolato",
	[380591] = "Luccichio Gelosamente Custodito",
	[380592] = "Corno del Vincolo della Tempesta",
	[380593] = "Borsa di Scaglie Decadute",
	[380595] = "Cartapecora Gelata",
	[380597] = "Tappeto da Centauro Temprato dalla Battaglia",
	[380600] = "Scheggia Terrestre Arricchita",
	[380601] = "Carta di Lunacupa Polverosa",
	[380602] = "Pelle Benedetta dal Vento",
	[380604] = "Stendardo Misterioso",
	[380605] = "Mistura di Contrabbando",
	[380607] = "Tessuto Nomade Bruciato",
	[380610] = "Runa della Terra Pulsante",
	[380611] = "Borraccia di Acqua Sospetta",
	[380612] = "Informazioni di riferimento per la lingua dei segni",
	[380615] = "Zaino del Bracconiere",
	[380616] = "Cestino Piccolo di Polvere di Acquardente",
	[380617] = "Schema delle armi dei Qalashi",
	[380618] = "Flusso Draconico",
	[380619] = "Lingotti bizzarri",
	[380620] = "Scheggia di Lancia Antica",
	[380623] = "Pinze Toccate dalla Magia",
	[380643] = "Pergamena Congelata",
	[380647] = "Tomo Arcano Dimenticato",
	[380648] = "Libro Bizzarro",
	[380652] = "Sfera Titanica Spaccata",
	[380653] = "Aquilone di Yennu",
	[380654] = "Cotta del Morto",
	[380709] = "Disegni per Guanti del Falconiere",
	[380763] = "Telaio di Teladraconica Antico",
	[380822] = "Gemma Ignea",
	[380840] = "Zaino da Cavallo Rovinato",
	[380842] = "Moneta d'Oro",
	[380843] = "Pesce di Gomma",
	[380859] = "Barca Giocattolo dei Tuskarr",
	[380860] = "Corno di Centauro",
	[380867] = "Formazione di Gemme d'Ambra",
	[380902] = "Campi della Ferocia",
	[380918] = "Statua Adornata Rotta",
	[381035] = "La Gran Banca",
	[381045] = "Calice del Drago Dorato",
	[381065] = "Portale Rotto",
	[381069] = "Rete da Pesca Piena",
	[381071] = "Scatola di Rocce",
	[381094] = "Spazzola Elegante",
	[381104] = "Deposito di Serevite Ricco",
	[381105] = "Deposito di Serevite Ricco",
	[381106] = "Vena di Serevite",
	[381108] = "Mappa di Yennu",
	[381110] = "Scrigno di Gioielli Dimenticati",
	[381153] = "Formazione di Gemme di Rubino",
	[381154] = "Scorzatorta",
	[381158] = "Flagello Demoniaco degli Gnoll",
	[381160] = "Bussola Perduta",
	[381196] = "Scorzatorta Toccata dai Titani",
	[381197] = "Scorzatorta Impetuosa",
	[381198] = "Scorzatorta Decaduta",
	[381199] = "Scorzatorta Scompigliata",
	[381200] = "Scorzatorta Gelata",
	[381201] = "Sassifraga Gelata",
	[381202] = "Sassifraga Scompigliata",
	[381203] = "Sassifraga Decaduta",
	[381204] = "Sassifraga Impetuosa",
	[381205] = "Sassifraga Toccata dai Titani",
	[381207] = "Sassifraga",
	[381210] = "Altofiore Toccato dai Titani",
	[381211] = "Altofiore Impetuoso",
	[381212] = "Altofiore Decaduto",
	[381213] = "Altofiore Scompigliato",
	[381214] = "Altofiore Gelato",
	[381216] = "Lente d'Ingrandimento dell'Ispettore",
	[381277] = "Barile di Dolcetti Confiscati",
	[381296] = "Un disastro",
	[381297] = "Bagaglio Smarrito",
	[381336] = "Una Piccola parte",
	[381340] = "Supporti di Neltharus",
	[381341] = "Benvenuto al Primo",
	[381343] = "Impara e Cresci",
	[381357] = "Tavoletta di Pietra",
	[381358] = "Tavoletta di Pietra",
	[381359] = "Tavoletta di Pietra",
	[381361] = "Frammento di Pietra Preziosa",
	[381365] = "Bandiera della Spedizione delle Scaglie di Drago",
	[381367] = "Bandiera della Spedizione delle Scaglie di Drago",
	[381369] = "Bandiera della Spedizione delle Scaglie di Drago",
	[381370] = "Bandiera della Spedizione delle Scaglie di Drago",
	[381373] = "Bandiera della Spedizione delle Scaglie di Drago",
	[381375] = "Bandiera della Spedizione delle Scaglie di Drago",
	[381377] = "Bandiera della Spedizione delle Scaglie di Drago",
	[381483] = "Premio della Marmosona",
	[381484] = "Osso Ben Conservato",
	[381485] = "Saponetta Perduta dell'Avventuriero",
	[381510] = "Lische di Pesce Volanti",
	[381511] = "Punta d'Arpione",
	[381512] = "Palo di Legno",
	[381514] = "Basalto Lucidato dal Mare",
	[381515] = "Deposito Indurito di Serevite",
	[381516] = "Deposito Fuso di Serevite",
	[381517] = "Deposito Toccato dai Titani di Serevite",
	[381518] = "Deposito Primordiale di Serevite",
	[381519] = "Deposito Impetuoso di Serevite",
	[381575] = "Kit per Trappola per Anatre",
	[381579] = "Richiesta degli Archivisti",
	[381584] = "Richiesta degli Archivisti",
	[381650] = "Richiesta degli Archivisti",
	[381653] = "Iscrizioni a Zanne Ali Fuoco.",
	[381661] = "Richiesta degli Archivisti",
	[381662] = "Richiesta degli Archivisti",
	[381663] = "Tempesta di Mana per Principianti",
	[381664] = "Richiesta degli Archivisti",
	[381667] = "Richiesta degli Archivisti",
	[381668] = "Richiesta degli Archivisti",
	[381669] = "Richiesta degli Archivisti",
	[381670] = "Richiesta degli Archivisti",
	[381671] = "Richiesta degli Archivisti",
	[381672] = "Richiesta degli Archivisti",
	[381687] = "Nota Scartata",
	[381691] = "Romanzo Osé: La Lussuriosa Maliarda Draconiana",
	[381701] = "RICERCATO: Mara'nar il Tonante",
	[381705] = "Le Guerre degli Gnoll",
	[381706] = "La Tua Sognatrice",
	[381707] = "Sogni di Smeraldo",
	[381708] = "Il Primo Kurnal",
	[381709] = "Vento, Legno, Acqua",
	[381711] = "Benedizione di Im'bunata",
	[381712] = "Cassa Vincolata dall'Acqua",
	[381713] = "Fondamenta Solide",
	[381715] = "Attenzione: Evacuazione Immediata",
	[381718] = "Il Giuramento",
	[381722] = "Manutenzione di Vakthros",
	[381730] = "Anatre Vigorose",
	[381731] = "Messaggio Tempestivo",
	[381732] = "Benedizione del Custode",
	[381733] = "Ali Guardiane",
	[381734] = "Vincolati Insieme",
	[381735] = "Appunti del Sorvegliante",
	[381957] = "Papavero Bolla Lussureggiante",
	[381958] = "Scorzatorta Lussureggiante",
	[381959] = "Sassifraga Lussureggiante",
	[381960] = "Altofiore Lussureggiante",
	[381964] = "Trasmettitore di Segnale disattivato",
	[381981] = "Cassa dell'Alluvione",
	[381983] = "Trasmettitore di Segnale disattivato",
	[381985] = "Trasmettitore di segnale disattivato",
	[381987] = "Trasmettitore di segnale disattivato",
	[381989] = "Trasmettitore di Segnale disattivato",
	[381991] = "Trasmettitore di Segnale disattivato",
	[381993] = "Trasmettitore di Segnale disattivato",
	[381995] = "Trasmettitore di segnale disattivato",
	[381997] = "Trasmettitore di Segnale disattivato",
	[381999] = "Trasmettitore di Segnale disattivato",
	[382001] = "Trasmettitore di segnale disattivato",
	[382029] = "Terra Smossa",
	[382071] = "Rete da Pesca Piena",
	[382079] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382086] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382092] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382094] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382101] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382103] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382105] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382107] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382110] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382112] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382116] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382118] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382120] = "Bandiera della Spedizione delle Scaglie di Drago",
	[382166] = "Banchetto di Rubino!",
	[382180] = "Banco di Plesiosauri del Magma Surriscaldato",
	[382193] = "Cassa degli Elementi",
	[382195] = "Cassa Vincolata dagli Elementi",
	[382325] = "Formazione di Gemme d'Onice",
	[382621] = "Console del Catalizzatore del Ripristino",
	[383625] = "Cassa di Pescilume Freschi",
	[383660] = "Cristallo di Sale",
	[383732] = "Cassetta da Pescatore dei Tuskarr",
	[383733] = "Terra Smossa",
	[383734] = "Terra Smossa",
	[383735] = "Terra Smossa",
	[384311] = "Volume Antico",
	[384312] = "Volume Antico",
	[384313] = "Volume Antico",
	[384317] = "Schema Accartocciato",
	[384318] = "Segnalibro Incospicuo",
	[384370] = "Appunti Deliberatamente Negligenti",
	[384405] = "Pesce Semibollito",
	[384653] = "Volume Antico",
	[384654] = "Volume Antico",
	[384763] = "Scorta Proibita",
	[384980] = "Cassa Misteriosa",
	[385008] = "Ragnatele Tessute",
	[385010] = "Ragnatele Tessute",
	[385021] = "Uovo di Drago Pietrificato",
	[385022] = "Fossile Eroso",
	[385028] = "Tonico del Rinnovamento Potente",
	[385032] = "Mucchio d'Oro",
	[385064] = "Punta di Ghiaccio",
	[385074] = "Cassa Vincolata dalla Magia",
	[385075] = "Cassa Vincolata dalla Magia",
	[385396] = "Cassa del Fuoco Primordiale",
	[385398] = "Cassa Rovente",
	[385401] = "Cassa Rovente",
	[385415] = "Cumulo d'Ossa",
	[385467] = "Cumulo d'Ossa",
	[385468] = "Cumulo d'Ossa",
	[385469] = "Cumulo d'Ossa",
	[385520] = "Cumulo d'Ossa",
	[385533] = "Pietra dell'Invio: Protesta",
	[385565] = "Cassa d'Ombrofuoco Fiammeggiante",
	[385584] = "Perfezione Esigente",
	[385585] = "Giuramenti Vincolanti",
	[385586] = "Potere Primordiale",
	[385799] = "Forziere Indurito",
	[385800] = "Mucchio d'Oro",
	[385801] = "Mucchio d'Oro",
	[385802] = "Mucchio d'Oro",
	[385826] = "Scrigno Titanico",
	[385830] = "Pietra dell'Invi