---@class QuestieTBCNpcFixes
local QuestieTBCNpcFixes = QuestieLoader:CreateModule("QuestieTBCNpcFixes")

---@type QuestieDB
local QuestieDB = QuestieLoader:ImportModule("QuestieDB")
---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")

function QuestieTBCNpcFixes:Load()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs
    local npcFlags = QuestieDB.npcFlags
    local waypointPresets = QuestieDB.waypointPresets

    return {
        [331] = {
            [npcKeys.questStarts] = {8250,64038},
        },
        [2385] = {
            [npcKeys.spawns] = {[zoneIDs.HILLSBRAD_FOOTHILLS] = {{63.59,67.96},{58.52,55.59},{60.98,50.92},{70.35,67.98},{61.14,66.86},{57.56,49.97},{66.26,74.09},{60.16,58.47},{56.7,60.08},{58.98,56.53},{57.68,59.31},{67.97,80.87},{61.79,69.02},{66.33,75.32},{64.98,66.4},{64.87,69.26},{65.09,72.99},{62.62,71.43}}},
        },
        [2552] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{32.04,46.29},{35.61,49.41},{37.5,40.95},{35.1,46.16}}},
        },
        [2553] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{31,42.4},{31.8,46.4},{34.6,39.4},{34.6,39.6},{35.2,46.4},{35.6,49.4},{37.4,40.8},{37.6,41}}},
            [npcKeys.waypoints] = {},
        },
        [2554] = {
            [npcKeys.waypoints] = {},
        },
        [2556] = {
            [npcKeys.spawns] = {[zoneIDs.ARATHI_HIGHLANDS] = {{63.51,71.64},{67.08,70.15},{59.93,71.64},{62.55,73.17},{67.98,78.74},{67.65,77.23},{67.74,77.06},{67.93,76.49},{68.55,76.41},{69.97,68.65},{71.2,65.91},{71.25,69.92},{70.91,67.35},{70.64,69.64},{70.02,71.75},{69.03,71.98},{69.13,79.46},{72.68,64.43},{71.88,63.02},{64.28,68.95},{68.74,73.43},{66.03,81.88},{67.55,81.59},{66.28,82.24},{69.88,81.13},{69.55,81.58},{68.29,80.06},{69.17,81.66},{69.19,82.41},{68.17,79.5},{67.75,81.95},{67.18,80.83},{70.04,77.34},{68.99,78.68},{70.45,78.2},{69.75,78.01}}},
        },
        [4323] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{41.87,80.76},{41.38,77.81},{42.77,81.06},{43.25,81.46},{42.14,76.6},{44.81,76.61},{45.68,84.1},{55.1,73.11},{51.06,74.15},{46.55,84.9},{51.74,67.65},{47.74,70.1},{44.76,73.97},{45.06,78.74},{54.38,70.54},{44.6,81.58},{46.67,82.35},{47.27,82.46},{43.57,70.0},{45.76,72.13},{45.51,73.14},{46.82,71.51},{50.51,71.97},{48.94,70.24},{50.01,69.05},{46.2,65.05},{48.18,80.52},{44.11,66.44},{44.93,64.48},{46.71,65.42},{47.21,67.19},{43.08,69.23},{43.71,64.4},{45.79,65.18},{45.95,67.21},},},
        },
        [4324] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{45.78,82.35},{41.5,79.51},{42.8,79.17},{42.19,78.86},{45.77,84.33},{55.46,83.41},{55.02,84.13},{51.41,71.02},{49.11,68.06},{44.83,75.86},{45.56,68.91},{45.07,69.71},{47.18,77.95},{52.72,70.07},{48.46,78.55},{56.37,70.08},{43.03,82.1},{45.21,67.98},{46.45,83.4},{46.48,67.42},{42.48,65.63},{47.74,66.3},{48.45,67.02},},},
        },
        [4358] = {
            [npcKeys.spawns] = {},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4359] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{57.13,15.03},{57.42,14.93},{57.44,15.17},{58.2,16.26},{57.98,15.41},{58.06,15.91},{58.48,16.22},{58.36,15.33},{58.85,14.9},{54.17,15.11},{54.07,14.94},{59.14,15.51},{54.57,15.53},{57.34,15.54},{54.19,15.66},{53.78,15.15},{55.36,16.61},{54.74,16.48},{57.45,16.0},{57.6,15.85},{57.49,16.58}}},
        },
        [4360] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{57,11},{57.4,10.4},{57.8,11.6},{58,11},{58.2,9.2},{58.4,8.4},{58.4,10.2},{58.6,8},{59,10.8},{59.4,9.4},{59.4,9.8},{59.6,7.2},{59.6,9.2},{59.6,9.8},{59.6,10.6},{59.8,7.6},{61.8,7.4},{62.4,8},{62.8,8},{62.8,9},{63,7.2},{63.2,6}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [4361] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH]={{57,11},{57.4,10.4},{57.8,11.6},{58,11},{58.2,9.2},{58.4,8.4},{58.4,10.2},{58.6,8},{59,10.8},{59.4,9.4},{59.4,9.8},{59.6,7.2},{59.6,9.2},{59.6,9.8},{59.6,10.6},{59.8,7.6},{61.8,7.4},{62.4,8},{62.8,8},{62.8,9},{63,7.2},{63.2,6}}},
            [npcKeys.zoneID] = zoneIDs.DUSTWALLOW_MARSH,
        },
        [5082] = {
            [npcKeys.spawns] = {[zoneIDs.WETLANDS] = {{8.4,61.8}}}, -- New position in TBC
        },
        [5676] = {
            [npcKeys.zoneID] = zoneIDs.ORGRIMMAR,
            [npcKeys.spawns] = {
                [zoneIDs.GHOSTLANDS] = {{27,15.2}},
                [zoneIDs.UNDERCITY] = {{86.51,26.94}},
                [zoneIDs.STORMWIND_CITY] = {{25.16,77.49}},
                [zoneIDs.ORGRIMMAR] = {{49.66,50.14}},
            },
        },
        [6072] = {
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{78.95,84.67},{78.8,82.4},{77.8,83.6},{78.6,85.6}}},
        },
        [8580] = {
            [npcKeys.spawns] = {[zoneIDs.THE_TEMPLE_OF_ATAL_HAKKAR] = {{-1,-1}}},
        },
        [8888] = {
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{28.96,28.93},},},
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
        },
        [9046] = {
            [npcKeys.spawns] = {
                [zoneIDs.BURNING_STEPPES]={{34.94,27.86},},
                [zoneIDs.SEARING_GORGE]={{43.34,99.17},},
            },
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
        },
        [10182] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{25.6,70.0}}},
            [npcKeys.waypoints] = {},
        },
        [11943] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{51,41}}},
        },
        [11980] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{71.0,62.2}}},
            [npcKeys.waypoints] = {},
        },
        [14387] = {
            [npcKeys.spawns] = {
                [zoneIDs.BURNING_STEPPES] = {{26.4,24.45},},
                [zoneIDs.SEARING_GORGE] = {{32.13,94.7},},
            },
            [npcKeys.zoneID] = zoneIDs.BURNING_STEPPES,
        },
        [17767] = {
            [npcKeys.spawns] = {[zoneIDs.HYJAL_SUMMIT] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.HYJAL_SUMMIT,
        },
        [17830] = {
            [npcKeys.spawns] = {[zoneIDs.RAGEFIRE_CHASM] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.RAGEFIRE_CHASM,
        },
        [15350] = {
            [npcKeys.spawns] = {
                [zoneIDs.ORGRIMMAR]={{80.68,30.51}},
                [zoneIDs.THUNDER_BLUFF]={{57.8,76.4}},
                [zoneIDs.UNDERCITY]={{58.27,97.9}},
                [zoneIDs.SILVERMOON_CITY]={{97,38.3}},
                [zoneIDs.SHATTRATH_CITY]={{66.96,56.6}},
            },
        },
        [15351] = {
            [npcKeys.spawns] = {
                [zoneIDs.IRONFORGE]={{70.41,91.10}},
                [zoneIDs.SHATTRATH_CITY]={{67.41,33.86}},
                [zoneIDs.DARNASSUS]={{58.02,34.52}},
                [zoneIDs.THE_EXODAR]={{24.55,55.42}},
                [zoneIDs.STORMWIND_CITY]={{82.91,14.16}},
            },
        },
        [15493] = {
            [npcKeys.spawns] = {[3430]={{46.8,46.4}}},
        },
        [15658] = {
            [npcKeys.waypoints] = {},
        },
        [15668] = {
            [npcKeys.waypoints] = {},
        },
        [15669] = {
            [npcKeys.waypoints] = {},
        },
        [15895] = {
            [npcKeys.spawns] = {[1657]={{33.89,13.87}},[1497]={{65.62,36.0}},[1637]={{41.66,31.98}},[1638]={{71.12,28.2}},[1537]={{28.85,16.23}},[1519]={{23.22,53.24}}, -- original data
                               [zoneIDs.THE_EXODAR]={{74,57.5}}, -- correction
                               [zoneIDs.SILVERMOON_CITY]={{73.1,82.6}}},
        },
        [15920] = {
            [npcKeys.waypoints] = {[zoneIDs.EVERSONG_WOODS]={{{30,58.6}}}},
        },
        [15967] = {
            [npcKeys.waypoints] = {},
        },
        [16033] = {
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES]={{32.29,25.8},},[zoneIDs.SEARING_GORGE]={{39.87,96.46},},},
        },
        [16224] = {
            [npcKeys.waypoints] = {},
        },
        [16245] = {
            [npcKeys.waypoints] = {[zoneIDs.GHOSTLANDS] = {{{35.0,75.04},{36.85,68.71},{38.43,58.59},{36.4,51.93},{34.26,52.17},{34.3,49.7},{34.26,52.17},{36.4,51.93},{38.43,58.59},{36.85,68.71},{37.72,63.38},{38.17,56.86},{37.85,50.32},{38,45.5},{38.8,39.5},{39.1,34.9},{39.4,31.9},{39.1,34.9},{38.8,39.5},{38,45.5},{37.85,50.32},{38.17,56.86},{37.72,63.38},{35.0,75.04}}}},
        },
        [16333] = {
            [npcKeys.waypoints] = {},
        },
        [16700] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [16808] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [16809] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [16817] = {
            [npcKeys.spawns] = {
                [zoneIDs.TELDRASSIL]={{56.5,92.3}},
                [zoneIDs.STORMWIND_CITY]={{38.6,61.8}},
                [zoneIDs.IRONFORGE]={{63.81,25.31}},
                [zoneIDs.SHATTRATH_CITY]={{61.39,31.91}},
                [zoneIDs.THE_EXODAR]={{41.62,25.28}},
            },
        },
        [16818] = {
            [npcKeys.spawns] = {
                [zoneIDs.THUNDER_BLUFF]={{21.33,26.44}},
                [zoneIDs.SHATTRATH_CITY]={{62.16,32.04}},
                [zoneIDs.UNDERCITY]={{67.62,8.28}},
                [zoneIDs.ORGRIMMAR]={{46.7,38.0}},
                [zoneIDs.SILVERMOON_CITY]={{69.83,42.99}},
            },
        },
        [16927] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA]={{37.8,58.71},{37.7,58.88},{37.37,61.08},{36.55,57.83},{37.18,59.21},{37.79,62.12},{35.31,62.14},{35.18,62.99},{36.99,64.38},{35.36,63.18},{36.53,64.41},{35.31,69.79},{35.21,69.45},{34.57,66.62},{34.66,66.76},{34.15,65.74},{34.05,65.65},{33.3,64.8},{33.25,65.03},{32.8,65.87},{32.87,65.84},{35.04,59.27},{33.84,60.63},{33.96,60.9},{34.32,59.03},{34.36,58.67},{33.29,60.46},{33.51,58.77},{33.42,59.07},{34.6,57.88},{33.07,60.34},{32.09,61.48},{32.33,61.24},{32.06,61.02},{32.61,63.69},{32.81,63.61},{31.46,65.95},{31.46,66.1},{30.66,66.84},{30.54,66.36},{31.02,64.56},{31.03,64.77},{31.16,63.3},{31.14,62.91},{31.32,61.74},{31.49,61.91},{29.64,64.99},{30.79,61.11},{30.75,60.85},{31.32,60.41},{29.4,63.24},{30.28,60.1},{30.0,59.98},{31.39,60.21},{30.28,59.75},{29.44,65.19},{28.32,66.86},{28.45,66.54},{28.01,68.25},{27.8,68.29},{28.99,69.8},{28.97,69.83},{29.44,68.62},{29.58,68.61},{27.72,69.55},{27.38,69.08},{28.97,71.66},{29.59,70.57},{29.52,70.47},{28.89,71.41},{30.12,71.48},{30.16,71.71},{29.47,72.84},{29.46,72.62}}},
        },
        [16944] = {
            [npcKeys.waypoints] = {},
        },
        [16992] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{43.24,76.62},{42.95,76.43},{42.88,75.41},{43.11,78.29},{42.58,78.1},{44.3,79.35},{43.19,80.51},{26.33,66.82},{26.2,66.41},{23.66,61.87},{24.33,60.97},{22.99,58.95},{23.72,59.86},{22.45,58.09},{24.6,58.71},{24.39,57.88},{23.65,57.97},{23.06,56.98},{24.79,62.83},{25.41,63.77},{24.78,56.3},{24.05,55.43},{24.26,57.07},{25.19,53.55},{23.41,56.27},{23.56,54.34},{24.27,54.24},{23.98,52.22},{24.61,51.82},{23.11,53.18},{23.08,51.08},{24.0,50.7},{22.46,52.25},{22.4,54.07},{21.74,55.02},{22.37,55.94},{19.96,54.71},{21.19,55.99},{20.03,56.73},{20.36,57.06},{21.79,56.96},{19.04,56.28},{19.04,55.08},{18.66,56.61},{18.32,53.76},{17.58,54.21},{16.99,52.16},{17.39,53.31},{27.45,42.55},{25.59,41.21},{26.48,37.46},{26.74,37.48},{28.07,39.46},{27.31,39.01},{26.83,40.01},{27.57,41.47},{27.15,41.57},{28.34,41.75},{28.29,40.58},{29.45,43.69},{31.44,44.43},{30.88,43.32},{31.05,41.48},{29.47,39.59}}},
        },
        [16994] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{39.04,40.32}}},
        },
        [17000] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{40.22,31.09}}},
        },
        [17076] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERMOON_CITY]={{92.2,36.4}}},
            [npcKeys.zoneID] = zoneIDs.SILVERMOON_CITY,
        },
        [17085] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{28.94,81.46}}},
        },
        [17087] = {
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE] = {{71.8,40.2}}},
        },
        [17101] = {
            [npcKeys.waypoints] = {},
        },
        [17110] = {
            [npcKeys.waypoints] = {},
        },
        [17116] = {
            [npcKeys.waypoints] = {},
        },
        [17204] = {
            [npcKeys.spawns] = {[zoneIDs.THE_EXODAR] = {{29.8,32.8}}},
            [npcKeys.waypoints] = {[zoneIDs.THE_EXODAR] = {{{29.8,32.8},{30.3,33.2},{31,32.4},{31,28.9},{31.3,27.7},{31,28.9},{31,32.4},{30.3,33.2},{29.8,32.8}}}},
            [npcKeys.zoneID] = zoneIDs.THE_EXODAR,
        },
        [17206] = {
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE]={{11.36,82.34}}},
            [npcKeys.zoneID] = zoneIDs.AZUREMYST_ISLE,
        },
        [17214] = {
            [npcKeys.waypoints] = {},
        },
        [17240] = {
            [npcKeys.waypoints] = {},
        },
        [17241] = {
            [npcKeys.waypoints] = {},
        },
        [17288] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [17290] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [17294] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [17296] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [17301] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [17311] = {
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE] = {{16.6,94.4}}},
            [npcKeys.zoneID] = zoneIDs.AZUREMYST_ISLE,
            [npcKeys.waypoints] = {},
        },
        [17318] = {
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE] = {{18.48,84.35}}},
        },
        [17350] = {
            [npcKeys.spawns] = {[zoneIDs.BLOODMYST_ISLE]={{43.74,24.11},{40.46,26.0},{47.68,32.78},{48.1,31.75},{35.84,43.61},{34.28,44.08},{31.29,42.66},{36.9,49.07},{36.72,50.54},{39.66,51.11},{43.58,51.24},{45.15,57.08},{42.6,58.1},{39.37,55.07},{43.64,62.19},{39.6,41.7},{43.7,39.3},{44.8,39.9}}},
        },
        [17352] = {
            [npcKeys.spawns] = {[zoneIDs.BLOODMYST_ISLE]={{36,75.6},{36.4,74},{36.4,74.6},{36.8,71.6},{36.8,74.4},{37.4,75.8},{43.8,91},{45.6,53.4},{45.8,55},{46.8,54.4},{47.2,54.8},{47.4,53.2},{48,53.4},{48,61.2},{48,68.4},{48.4,58.4},{48.4,73.2},{48.4,73.8},{48.4,86.6},{48.6,56.8},{48.6,73},{49,71.4},{49,72.4},{49,83.6},{49.2,74.2},{49.4,55.8},{49.6,51.6},{49.6,72.4},{49.8,74.4},{49.8,74.6},{49.8,76.6},{50,44},{50,54},{50,75.8},{50.2,49.6},{50.2,51.2},{50.2,53},{50.4,72.8},{50.6,71},{50.6,71.8},{50.6,73},{51,48.4},{51.2,48.6},{51.2,74.2},{51.2,79.4},{51.4,74.6},{51.6,51.2},{51.6,74},{51.6,74.6},{51.8,48.6},{51.8,73.4},{52.2,48},{52.8,80.8},{53.4,63.8},{53.4,79.6},{53.6,65.4},{53.6,82},{54,72.6},{55.4,47},{55.4,72.8},{56,47},{56,63.6},{56.2,45.2},{56.2,49.2},{56.4,48.4},{56.4,50.6},{56.4,60.6},{57,50.8},{57.4,68},{57.8,49.2},{57.8,60.8},{58,49.6},{58.2,68},{58.4,64},{58.6,50.4},{59.6,53},{59.6,59.2},{60,60},{61.2,57.4},{62.8,52.8},{63.2,59.8}}},
        },
        [17359] = {
            [npcKeys.spawns] = {[zoneIDs.BLOODMYST_ISLE]={{25.94,40.96}}},
            [npcKeys.zoneID] = zoneIDs.BLOODMYST_ISLE,
        },
        [17413] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA]={{26.9,37.46}}},
        },
        [17465] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [17527] = {
            [npcKeys.spawns] = {[zoneIDs.BLOODMYST_ISLE]={{28.06,62.73},{24.3,63.8},{26.4,57.9},{36.25,55.46},{30.41,61.4},{25.73,60.87},{25.8,47.18},{31.96,59.48},{33.61,60.7},{31.77,52.59},{36.32,48.56},{27.22,48.75},{23.34,48.27},{27.8,43.92},{24.86,43.0},{25.45,45.19},{32.67,54.68},{29.72,55.59},{26.27,55.7},{24.23,46.11},{26.62,46.33},{27.43,47.8},{28.21,50.03},{34.67,57.85},{33.42,57.18},{30.91,54.27},{31.14,56.93},{34.8,52.67},{33.4,51.94},{32.37,64.86},{30.73,59.36},{28.96,61.8},{28.78,58.66},{27.69,58.03},{30.14,69.42},{29.3,69.88},{30.88,71.57}}},
        },
        [17550] = {
            [npcKeys.waypoints] = {},
        },
        [17587] = {
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE]={{42.86,57.14},{37.84,18.12},{39.6,37.8},{56.83,59.81},{40.27,71.21},{46.6,31.9},{55.2,28.6},{53.6,42.6},{58.6,41.6},{55.2,47.4}}},
        },
        [17610] = {
            [npcKeys.waypoints] = {},
        },
        [17613] = {
            [npcKeys.spawns] = {[zoneIDs.DEADWIND_PASS]={{46.93,75.64}}},
        },
        [17671] = {
            [npcKeys.spawns] = {[zoneIDs.THE_SHATTERED_HALLS]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_SHATTERED_HALLS,
        },
        [17682] = {
            [npcKeys.waypoints] = {},
        },
        [17702] = {
            [npcKeys.spawns] = {[zoneIDs.BLOODMYST_ISLE]={{64.2,76.4}}},
        },
        [17713] = {
            [npcKeys.waypoints] = {},
        },
        [17715] = {
            [npcKeys.spawns] = {[zoneIDs.BLOODMYST_ISLE]={{86,54}}},
            [npcKeys.zoneID] = zoneIDs.BLOODMYST_ISLE,
        },
        [17334] = {
            [npcKeys.waypoints] = {},
        },
        [17336] = {
            [npcKeys.waypoints] = {},
        },
        [17536] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.HELLFIRE_RAMPARTS,
        },
        [17537] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_RAMPARTS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.HELLFIRE_RAMPARTS,
        },
        [17544] = {
            [npcKeys.spawns] = {[zoneIDs.SILVERMOON_CITY] = {{92.6,37.5}}},
            [npcKeys.zoneID] = zoneIDs.SILVERMOON_CITY,
        },
        [17589] = {
            [npcKeys.waypoints] = {},
        },
        [17592] = {
            [npcKeys.spawns] = {[zoneIDs.BLOODMYST_ISLE]={{72.81,20.83}}},
            [npcKeys.waypoints] = {},
        },
        [17612] = {
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE] = {{31.8,25.4},{34.0,25.4},{34.4,22.8},{34.0,20.8},{34.6,17.6},{34.2,14.6},{35.2,12.6},{35.6,11.6}}},
        },
        [17831] = {
            [npcKeys.waypoints] = {[zoneIDs.ZANGARMARSH] = {{{23.32,66.21},{23.28,66.08},{23.39,65.98},{23.51,66.01},{23.67,66.09},{24.52,66.48},{24.69,66.5},{24.52,66.48},{23.7,66.18},{23.48,66.01},{23.39,66.01},{23.34,66.1},{23.32,66.21}}}},
        },
        [17839] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BLACK_MORASS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_BLACK_MORASS,
        },
        [17881] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BLACK_MORASS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_BLACK_MORASS,
        },
        [17923] = {
            [npcKeys.waypoints] = {[zoneIDs.ZANGARMARSH] = {{{19,62.4},{19,63.5},{19.2,64.6}}}},
        },
        [17975] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_BOTANICA,
        },
        [17976] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_BOTANICA,
        },
        [18096] = {
            [npcKeys.spawns] = {[zoneIDs.OLD_HILLSBRAD_FOOTHILLS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.OLD_HILLSBRAD_FOOTHILLS,
        },
        [18099] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{62.02,23.95}}},
            [npcKeys.waypoints] = {[zoneIDs.NAGRAND] = {{{61.26,24.88},{61.21,24.90},{61.17,24.92},{61.12,24.93},{61.08,24.94},{61.04,24.95},{60.99,24.95},{60.95,24.96},{60.90,24.97},{60.86,24.97},{60.81,24.98},{60.77,24.99},{60.72,25.01},{60.68,25.02},{60.63,25.03},{60.59,25.03},{60.55,25.00},{60.52,24.96},{60.49,24.91},{60.48,24.90},{60.44,24.86},{60.41,24.82},{60.37,24.77},{60.34,24.73},{60.30,24.69},{60.27,24.64},{60.23,24.60},{60.20,24.56},{60.16,24.52},{60.13,24.47},{60.09,24.43},{60.07,24.37},{60.06,24.31},{60.05,24.24},{60.05,24.17},{60.04,24.10},{60.03,24.04},{60.02,23.97},{60.01,23.91},{60.00,23.84},{59.99,23.77},{59.98,23.71},{59.97,23.64},{59.96,23.58},{59.95,23.51},{59.94,23.44},{59.93,23.38},{59.92,23.31},{59.90,23.25},{59.88,23.19},{59.87,23.12},{59.84,23.07},{59.82,23.01},{59.80,22.94},{59.78,22.88},{59.76,22.82},{59.73,22.77},{59.71,22.71},{59.68,22.66},{59.65,22.61},{59.61,22.57},{59.58,22.52},{59.58,22.45},{59.60,22.39},{59.62,22.33},{59.64,22.26},{59.65,22.20},{59.67,22.14},{59.69,22.07},{59.70,22.01},{59.71,21.95},{59.73,21.88},{59.74,21.82},{59.76,21.75},{59.77,21.69},{59.79,21.63},{59.81,21.56},{59.82,21.50},{59.84,21.43},{59.85,21.37},{59.88,21.31},{59.91,21.28},{59.95,21.24},{59.99,21.21},{60.03,21.17},{60.07,21.13},{60.11,21.10},{60.15,21.07},{60.19,21.03},{60.22,20.99},{60.26,20.96},{60.30,20.92},{60.34,20.89},{60.38,20.88},{60.42,20.90},{60.46,20.94},{60.50,20.98},{60.58,21.06},{60.62,21.10},{60.65,21.14},{60.69,21.18},{60.72,21.22},{60.76,21.27},{60.79,21.31},{60.83,21.34},{60.87,21.39},{60.89,21.45},{60.90,21.51},{60.92,21.57},{60.94,21.63},{60.96,21.70},{60.98,21.76},{61.00,21.82},{61.03,21.88},{61.05,21.93},{61.09,21.98},{61.12,22.02},{61.16,22.06},{61.19,22.11},{61.22,22.16},{61.26,22.20},{61.29,22.23},{61.34,22.24},{61.38,22.22},{61.42,22.19},{61.46,22.16},{61.50,22.12},{61.54,22.08},{61.57,22.04},{61.61,22.01},{61.65,22.02},{61.70,22.04},{61.74,22.05},{61.79,22.07},{61.83,22.09},{61.87,22.11},{61.92,22.12},{61.96,22.13},{62.00,22.15},{62.03,22.21},{62.05,22.27},{62.07,22.33},{62.08,22.34},{62.10,22.40},{62.13,22.45},{62.15,22.51},{62.17,22.57},{62.18,22.64},{62.17,22.70},{62.17,22.77},{62.16,22.84},{62.14,22.90},{62.14,22.97},{62.13,23.04},{62.13,23.10},{62.12,23.17},{62.11,23.24},{62.10,23.30},{62.10,23.37},{62.09,23.44},{62.08,23.50},{62.07,23.57},{62.06,23.64},{62.05,23.70},{62.04,23.77},{62.04,23.84},{62.03,23.90},{62.02,23.97},{62.01,24.04},{62.00,24.10},{62.00,24.17},{61.98,24.22},{61.94,24.26},{61.91,24.31},{61.88,24.35},{61.84,24.40},{61.81,24.45},{61.78,24.50},{61.75,24.54},{61.71,24.57},{61.66,24.59},{61.62,24.62},{61.58,24.64},{61.54,24.66},{61.50,24.69},{61.45,24.72},{61.41,24.75},{61.37,24.78},{61.33,24.81},{61.29,24.84},{61.25,24.87},{61.26,24.88},}}},
        },
        [18120] = {
            [npcKeys.waypoints] = {},
        },
        [18121] = {
            [npcKeys.waypoints] = {},
        },
        [18152] = {
            [npcKeys.spawns] = {[zoneIDs.ZANGARMARSH] = {{26.4,22}}},
        },
        [18238] = {
            [npcKeys.npcFlags] = QuestieDB.npcFlags.QUEST_GIVER,
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{32.27,58.41},{37.92,27.53}}},
            [npcKeys.waypoints] = {[zoneIDs.NAGRAND] = {{{34.47,21.69},{34.54,21.97},{34.62,22.40},{34.72,22.80},{34.83,23.14},{34.95,23.48},{35.06,23.82},{35.14,24.18},{35.21,24.54},{35.28,24.91},{35.34,25.28},{35.42,25.64},{35.53,25.83},{35.71,26.08},{35.90,26.34},{36.10,26.58},{36.30,26.81},{36.52,27.01},{36.75,27.17},{36.98,27.32},{37.22,27.42},{37.47,27.48},{37.73,27.52},{37.98,27.53},{38.23,27.50},{38.47,27.39},{38.70,27.23},{38.93,27.06},{39.15,26.89},{39.38,26.72},{39.61,26.55},{39.83,26.37},{40.07,26.23},{40.32,26.19},{40.55,26.32},{40.74,26.57},{40.94,26.81},{41.14,27.03},{41.32,27.30},{41.48,27.59},{41.63,27.90},{41.78,28.21},{41.93,28.51},{42.09,28.81},{42.25,29.10},{42.41,29.40},{42.54,29.73},{42.67,30.05},{42.81,30.36},{42.97,30.66},{43.16,30.92},{43.35,31.16},{43.58,31.34},{43.80,31.52},{44.02,31.71},{44.23,31.91},{44.45,32.10},{44.67,32.30},{44.89,32.49},{45.10,32.69},{45.32,32.89},{45.53,33.09},{45.77,33.23},{46.01,33.34},{46.24,33.50},{46.43,33.75},{46.62,34.00},{46.83,34.22},{47.03,34.44},{47.22,34.70},{47.30,34.83}},{{28.43,53.59},{28.45,53.75},{28.50,54.13},{28.56,54.49},{28.56,54.87},{28.53,55.25},{28.53,55.63},{28.60,55.99},{28.72,56.33},{28.87,56.64},{29.02,56.94},{29.19,57.23},{29.38,57.47},{29.59,57.68},{29.80,57.89},{30.01,58.11},{30.20,58.36},{30.38,58.62},{30.44,58.69},{30.54,58.75},{30.67,58.82},{30.76,58.83},{31.01,58.78},{31.25,58.66},{31.49,58.57},{31.74,58.53},{32.00,58.50},{32.24,58.42},{32.49,58.38},{32.75,58.36},{33.00,58.33},{33.17,58.28},{33.37,58.13},{33.58,57.91},{33.80,57.74},{34.04,57.60},{34.27,57.45},{34.49,57.25},{34.69,57.02},{34.91,56.84},{35.14,56.68},{35.39,56.59},{35.54,56.48},{35.74,56.24},{35.94,56.02},{36.14,55.78},{36.33,55.52},{36.52,55.27},{36.68,55.08},{36.90,54.97},{37.09,54.94},{37.35,54.97},{37.60,55.00},{37.85,55.05},{37.97,55.15},{38.15,55.41},{38.33,55.68},{38.53,55.92},{38.73,56.15},{38.92,56.40},{39.11,56.65},{39.30,56.90},{39.49,57.15},{39.69,57.40},{39.90,57.60},{40.12,57.78},{40.34,57.98},{40.55,58.20},{40.75,58.43},{40.97,58.63},{41.19,58.79},{41.44,58.89},{41.69,58.94},{41.93,59.05},{42.16,59.20},{42.41,59.26},{42.66,59.28},{42.92,59.29},{43.17,59.32},{43.42,59.36},{43.67,59.42},{43.92,59.45},{44.17,59.51},{44.43,59.54},{44.68,59.54}}}},
        },
        [18294] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{71.4,40.6}}},
            [npcKeys.zoneID] = zoneIDs.NAGRAND,
        },
        [18369] = {
            [npcKeys.waypoints] = {},
        },
        [18398] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{43.7,20.4}}},
        },
        [18399] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{43.7,20.4}}},
        },
        [18400] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{43.7,20.4}}},
        },
        [18401] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{43.7,20.4}}},
        },
        [18402] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{43.7,20.4}}},
        },
        [18472] = {
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS] = {{-1,-1}}},
        },
        [18473] = {
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS] = {{-1,-1}}},
        },
        [18482] = {
            [npcKeys.waypoints] = {[3519]={{{41.44,25.93},{41.14,25.65},{40.8,25.49},{40.49,25.5},{40.31,25.56},{39.94,25.78},{39.72,25.98},{39.49,26.24},{39.31,26.38},{39.12,26.49},{38.77,26.57},{38.5,26.6},{38.27,26.6},{38.09,26.52}},{{38.05,26.6},{38.27,26.68},{38.5,26.71},{38.81,26.68},{39.17,26.56},{39.49,26.35},{39.66,26.18},{39.85,25.99},{40.16,25.76},{40.51,25.61},{40.82,25.64},{41.1,25.75},{41.32,25.91},{41.65,26.22},{41.99,26.5},{42.33,26.66},{42.65,26.68},{43.07,26.62},{43.43,26.38},{43.74,26.22},{44.13,26.18},{44.39,26.23},{44.85,26.5},{45.24,26.6},{45.53,26.55},{45.85,26.44},{46.15,26.38},{46.39,26.43},{46.59,26.56},{46.88,26.9},{47.11,27.09},{47.42,27.21},{47.86,27.25},{48.19,27.36},{48.47,27.59},{48.81,27.9},{49.23,28.11},{49.61,28.34},{49.92,28.69},{50.2,29.07},{50.46,29.28},{50.77,29.39},{51.03,29.38},{50.99,29.31},{50.65,29.25},{50.36,29.06},{50.09,28.72},{49.83,28.4},{49.59,28.17},{49.16,27.97},{48.86,27.8},{48.52,27.48},{48.2,27.26},{47.84,27.14},{47.35,27.1},{47.08,26.94},{46.87,26.72},{46.6,26.42},{46.34,26.27},{45.97,26.28},{45.55,26.47},{45.15,26.46},{44.75,26.33},{44.41,26.14},{44.1,26.08},{43.79,26.12},{43.46,26.27},{43.17,26.46},{42.84,26.56},{42.47,26.58},{42.2,26.5},{41.94,26.37},{41.68,26.17}}}},
        },
        [18533] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{55.6,69.9}}},
            [npcKeys.zoneID] = zoneIDs.TEROKKAR_FOREST,
        },
        [18537] = {
            [npcKeys.waypoints] = {},
        },
        [18538] = {
            [npcKeys.waypoints] = {},
        },
        [18542] = {
            [npcKeys.npcFlags] = 128,
        },
        [18707] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{27.05,55.66}}},
        },
        [18816] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{41.2,44.2}}},
        },
        [18817] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{41.2,44.2}}},
        },
        [19305] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{13.64,39.12}}},
        },
        [19412] = {
            [npcKeys.spawns] = {[zoneIDs.AUCHENAI_CRYPTS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.AUCHENAI_CRYPTS,
        },
        [19456] = {
            [npcKeys.spawns] = {[zoneIDs.EVERSONG_WOODS] = {{37.8,86.2}}},
            [npcKeys.zoneID] = zoneIDs.EVERSONG_WOODS,
        },
        [19493] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM]={{40.8,72.6}}},
        },
        [19505] = {
            [npcKeys.spawns] = {[zoneIDs.THE_BOTANICA]={{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_BOTANICA,
        },
        [19543] = {
            [npcKeys.waypoints] = {[zoneIDs.NETHERSTORM] = {{{60.4,88.01},{60.4,88.01}},{{56.74,86.64},{56.83,86.81},{56.85,86.83}}}},
        },
        [19544] = {
            [npcKeys.waypoints] = {[zoneIDs.NETHERSTORM] = {{{59.79,85.72},{59.82,85.65},{59.92,85.48},{60.29,84.92},{60.0,84.48},{59.76,84.54},{59.7,84.79},{59.76,84.56},{59.98,84.48},{60.29,84.9},{59.91,85.48},{59.83,85.66},{59.47,86.17},{59.76,85.75}},{{56.51,87.65},{56.39,87.75},{56.39,87.75}}}},
        },
        [19545] = {
            [npcKeys.waypoints] = {[zoneIDs.NETHERSTORM] = {{{59.74,87.05},{59.87,86.87},{59.53,86.36},{58.93,85.67},{59.37,86.13},{59.87,86.85},{59.71,87.13},{59.83,87.44},{59.64,87.72},{59.52,87.55},{59.64,87.74},{59.86,87.46},{59.71,87.1}},{{55.32,87.28},{55.1,87.53},{55.1,87.53},{55.11,87.51}}}},
        },
        [19546] = {
            [npcKeys.waypoints] = {[zoneIDs.NETHERSTORM] = {{{58.06,88.65},{58.09,88.7},{58.45,88.32},{59.07,88.35},{59.01,88.19},{59.07,88.3},{58.86,88.37},{58.4,88.35},{58.12,88.68},{57.74,88.08},{58.06,88.64}},{{55.43,86.62},{55.42,86.57},{55.46,86.51}}}},
        },
        [19622] = {
            [npcKeys.spawns] = {[zoneIDs.TEMPEST_KEEP] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.TEMPEST_KEEP,
        };
        [19644] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM] = {{31.36,66.15}}},
            [npcKeys.zoneID] = zoneIDs.NETHERSTORM,
        },
        [19657] = {
            [npcKeys.waypoints] = {[zoneIDs.NETHERSTORM] = {{{57.45,67.37},{57.36,67.08},{57.27,66.84},{57.17,66.59},{57.13,66.47},{57.2,66.31},{57.22,66.12},{57.24,65.95},{57.26,65.78},{57.12,65.76},{57.06,65.77},{57.12,65.76},{57.26,65.78},{57.24,65.95},{57.22,66.12},{57.2,66.31},{57.13,66.47},{57.17,66.59},{57.27,66.84},{57.36,67.08}}}},
        },
        [19671] = {
            [npcKeys.spawns] = {[zoneIDs.MANA_TOMBS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.MANA_TOMBS,
        },
        [19705] = {
            [npcKeys.waypoints] = {[zoneIDs.NETHERSTORM] = {{{56.06,66.4},{56.2,66.18},{56.42,66.34},{56.62,66.04},{56.81,65.71},{56.61,66.07},{56.42,66.35},{56.2,66.2},{56.05,66.43},{55.97,66.69},{55.8,66.74},{55.63,66.74},{55.39,66.82},{55.19,66.86},{55.4,66.81},{55.65,66.73},{55.82,66.74}}}},
        },
        [19715] = {
            [npcKeys.waypoints] = {[3703]={{{50.45,34.4},{54.63,32.79},{58.13,34.57},{61.15,39.01},{61.98,45.28},{60.86,51.22},{57.72,55.32},{53.67,57.02},{49.6,54.96},{46.63,50.49},{45.98,44.33},{47.04,38.76},{50.45,34.4}}}},
        },
        [19735] = {
            [npcKeys.spawns] = {[zoneIDs.THE_MECHANAR] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_MECHANAR,
        },
        [19909] = {
            [npcKeys.friendlyToFaction] = "H",
        },
        [19911] = {
            [npcKeys.friendlyToFaction] = "A",
        },
        [19915] = {
            [npcKeys.friendlyToFaction] = "A",
        },
        [19923] = {
            [npcKeys.friendlyToFaction] = "H",
        },
        [19925] = {
            [npcKeys.friendlyToFaction] = "A",
        },
        [19942] = {
            [npcKeys.spawns] = {[zoneIDs.BLASTED_LANDS]={{58.2,55}}},
        },
        [20145] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{45.6,82.4},{46.2,83.2},{46.6,83},{48.2,85},{48.8,82.4},{49.4,82.8},{50,82},{50.2,83.2},{50.2,83.6},{51,82.6}}},
        },
        [20390] = {
            [npcKeys.friendlyToFaction] = "H",
        },
        [20440] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM]={{26.07,38.78}}},
            [npcKeys.zoneID] = zoneIDs.NETHERSTORM,
        },
        [20497] = {
            [npcKeys.friendlyToFaction] = "A",
        },
        [20499] = {
            [npcKeys.friendlyToFaction] = "H",
        },
        [20518] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM]={{71.2,38.8}}},
            [npcKeys.zoneID] = zoneIDs.NETHERSTORM,
        },
        [20520] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM] = {{54.52,39.93},{54.53,40.28},{54.28,40.29},{54.53,40.6},{54.77,40.28},{54.76,39.91},{54.46,46.37},{54.82,46.79},{54.63,46.76},{54.45,46.73},{54.73,46.57},{54.54,46.55},{54.38,46.53},{54.64,46.39}}},
        },
        [20600] = {
            [npcKeys.waypoints] = {[zoneIDs.BLADES_EDGE_MOUNTAINS]={{{58.08,64.77},{58.59,60.8},{59.37,57.56},{59.88,56.51},{60.85,55.47},{61.49,55.45},{62.31,55.97},{63.47,55.79},{64.11,55.01},{64.87,54.74},{65.45,54.8},{66.23,56.32},{66.73,57.29},{67.71,58.45},{67.92,59.64},{67.96,61.14},{68.2,62.06},{68.33,63.37},{67.94,64.46},{68.15,66.08},{68.22,67.54},{68.02,69.14},{68.06,70.5},{68.17,71.93},{68.17,73.35},{67.99,75.05},}}},
        },
        [20680] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA]={{14.32,62.18}}},
            [npcKeys.waypoints] = {[zoneIDs.HELLFIRE_PENINSULA] = {{{14.34,61.07},{14.32,59.92},{14.32,58.88},{14.32,57.9},{14.32,56.98},{14.33,58.76},{14.31,59.58},{14.31,60.21},{14.31,60.95},{14.32,62.16},{14.32,62.16}}}},
        },
        [20706] = {
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.SETHEKK_HALLS,
        },
        [20787] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM] = {{53.3,41.43}}},
            [npcKeys.zoneID] = zoneIDs.NETHERSTORM,
        },
        [20869] = {
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCATRAZ,
        },
        [20912] = {
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCATRAZ,
        },
        [21181] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{43.2,46.2}}},
        },
        [21118] = {
            [npcKeys.waypoints] = {},
        },
        [21446] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{38.8,56},{39,57.6},{39.2,57.4},{39.4,53},{40.2,50},{40.4,57.8},{42,57.2},{42,57.6},{42.4,53.8},{43,47.2},{43,50}}},
        },
        [21452] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{47.0,77.8},{46.6,79.2}}},
        },
        [21638] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{50.88,54.76}}},
        },
        [21651] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{61,75.4},{61,75.6},{61,80},{61.4,73},{61.4,73.6},{61.6,73.2},{61.6,80},{62,74.4},{62,74.6},{63.2,79.6},{67.4,78.8},{67.4,79.6},{67.6,79.8},{67.8,79},{68.4,74.2},{68.6,73.6},{69.4,78.2},{69.4,79.2},{69.6,74.4},{69.6,78.4},{69.6,79},{70,74.8},{70,84.4},{70.2,83.2},{70.2,84.8},{70.8,84.8},{71.4,81.8},{71.4,82.6},{71.6,82.4},{71.6,82.6},{72.2,88},{72.6,83},{73,83.6},{73.4,80.4},{73.4,80.6},{74,80.2},{74,80.6},{74.6,87.4},{74.6,88.6},{75,86.2},{75,88},{75.2,81.2}}},
        },
        [21685] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY]={{42.8,44.95}}},
        },
        [21735] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{37.80,38.73}}},
        },
        [21763] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{61,78.8},{61.4,75.4},{61.4,75.6},{61.4,78},{61.6,78},{61.8,75.6},{62,75},{62.2,74.4},{65.8,79.4},{66,79.6},{68,80.2},{68.4,85.2},{68.6,74.4},{69,85.6},{69.2,85.4},{69.4,74.8},{69.4,75.6},{69.6,74.4},{69.6,74.8},{69.6,76},{69.6,84.8},{69.8,79.6},{70,79.4},{70,83.6},{70.2,83.4},{70.4,82},{70.6,82.2},{71.8,85.6},{72,85.4},{72.2,88},{72.8,87.8},{73,84.4},{73,84.8},{73.4,82},{73.6,87.8},{73.8,83.2},{73.8,86},{73.8,86.6},{74.4,81},{74.4,84.2},{74.6,83},{74.6,87.4},{74.6,87.6},{75.2,81.2},{75.2,81.6}}},
        },
        [21784] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{34.10,47.35}}},
            [npcKeys.waypoints] = {[zoneIDs.SHADOWMOON_VALLEY] = {{{34.10,47.35},{34.58,48.30},{35.12,48.53},{35.53,48.98},{39.97,49.30},{41.09,50.89},{42.60,51.81},{43.62,51.94},{44.21,52.18},{46.90,57.19},{47.71,57.48},{50.89,57.52},{53.64,56.93},{54.10,57.00},{55.16,57.46},{55.71,56.94},{56.02,55.91},{56.77,55.38},{58.49,52.75},{62.57,52.73},{62.96,52.56},{63.19,51.82},{63.15,48.66},{63.62,46.00},{63.44,43.97},{62.59,32.80},{62.37,32.19},{60.90,31.12},{59.77,31.22},{59.08,31.88},{55.41,31.85},{54.67,30.86},{54.13,30.90},{52.78,29.08},{52.53,28.52},{50.88,28.32},{49.62,25.80},{48.04,25.11},{47.09,23.79},{46.13,23.87},{45.60,25.31},{42.19,27.72},{41.78,30.09},{39.92,32.56},{38.54,33.60},{36.73,33.94},{35.88,34.73},{35.30,34.85},{35.37,42.85},{34.77,44.19},{34.61,45.11},{34.80,45.93},{34.68,47.04},{34.38,47.37},{34.10,47.35},}}},
        },
        [21787] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{60.8,75.6},{61,74.8},{61,80.2},{61.2,79.2},{61.4,73.6},{61.8,73.4},{61.8,73.6},{62,74.6},{63,79.6},{65.8,78.2},{65.8,79.2},{66.4,79.8},{67.2,79},{67.4,79.8},{67.6,79.8},{68.2,73.8},{68.8,74},{69,78.8},{69.2,78.4},{69.4,74.6},{69.6,78.4},{69.8,75.2},{70,79.4},{70,79.6},{70.2,74.4},{70.2,83.2},{70.4,85},{70.6,84.2},{70.6,85},{71.2,82.4},{71.2,82.6},{71.6,81.8},{72,85.4},{72,85.6},{72.4,88},{73,82.8},{73,83.6},{73.4,80.2},{73.4,80.6},{73.6,81},{74,80.2},{74.4,88.4},{74.6,88.2},{74.6,88.6},{75,81.2},{75.2,86},{75.2,86.8}}},
        },
        [21838] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{66.22,77.48}}},
            [npcKeys.zoneID] = zoneIDs.TEROKKAR_FOREST,
        },
        [21894] = {
            [npcKeys.spawns] = {[zoneIDs.ZANGARMARSH]={{15.9,40.5}}},
        },
        [21925] = {
            [npcKeys.zoneID] = zoneIDs.NETHERSTORM,
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM]={{41.24,21.74},{39.62,20.63},{42.72,21.59},{41.29,23.27}}},
        },
        [21959] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY]={{23.04,40.74},{23.18,40.73},{22.43,40.72},{22.72,40.95},{22.59,40.96},{23.18,41.21},{22.74,41.19},{23.03,41.2},{22.89,41.21},{22.42,41.19},{22.9,40.96},{23.18,40.97},{22.58,41.19},{23.04,40.96},{22.44,40.96},{22.13,40.27},{21.97,40.27},{22.14,40.04},{22.14,39.37},{22.16,38.92},{21.97,39.6},{21.81,39.39},{21.83,40.07},{21.99,38.92},{21.82,39.83},{21.82,39.61},{21.98,39.83},{21.97,40.06},{21.98,39.14},{21.97,39.38},{21.82,40.29},{21.82,39.16},{21.81,38.93}}},
        },
        [21962] = {
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCATRAZ,
        },
        [21998] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{51.23,62.75},{52.45,59.19}}},
        },
        [22025] = {
            [npcKeys.waypoints] = {[zoneIDs.SHADOWMOON_VALLEY] = {{{39.78,30.03},{39.77,30.3},{39.88,30.65},{40.04,30.92},{40.12,30.89},{40.25,30.57},{40.41,30.42},{40.46,30.12},{40.45,29.65},{40.32,29.19},{39.71,29.14}}}},
        },
        [22059] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{51.23,62.75},{52.45,59.19}}},
        },
        [22275] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{60.02,9.5},{27.4,68.56},{31.76,63.8},{33.41,51.84},{28.8,46.51},{64.67,10.89},{69.01,13.89}}},
        },
        [22281] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{37.76,41.43},{33.91,44.18},{35.59,36.7},{30.99,86.48},{26.79,83.57},{30.21,77.19},{27.07,75.62},{31.63,39.26}}},
            [npcKeys.zoneID] = zoneIDs.BLADES_EDGE_MOUNTAINS,
        },
        [22307] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{48.71,51.37},{40.48,48.2},{49.03,81.33},{53.12,70.73},{52.29,58.52}}},
        },
        [22337] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{25.44,70.85},{24.3,71.11},{24.28,71.34},{23.44,71.64},{24.51,72.8},{25.44,74.28},{23.38,72.01},{23.19,73.32},{23.27,74.51},{23.56,73.89},{25.01,74.65},{23.08,73.99},{25.33,74.17},{24.99,74.41},{24.85,71.71},{24.3,71.2},{23.15,74.47},{25.09,74.8},{25.57,70.52}}},
        },
        [22370] = {
            [npcKeys.waypoints] = {[zoneIDs.TEROKKAR_FOREST] = {{{38.17,51.74},{38.22,50.7},{37.89,49.88},{37.16,50.22},{37.33,51.01}}}},
        },
        [22374] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{47.31,49.66}}},
        },
        [22408] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM] = {{35.6,66.6}}},
        },
        [22423] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{61.4,59.9},{64.9,68.1}}},
        },
        [22434] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{30.59,22.19}}},
        },
        [22441] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{48.7,67.2}}},
            [npcKeys.waypoints] = {},
        },
        [22454] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{44.4,74.0},{44.6,75.4},{45.0,74.4},{45.6,73.6}}},
        },
        [22817] = {
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY]={{75.23,48.0},},},
            [npcKeys.zoneID] = zoneIDs.SHATTRATH_CITY,
            [npcKeys.questStarts] = {10945,10951,10953,10963,10967,11975}, -- removed the SWP quest
        },
        [22818] = {
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY]={{75.23,48.0},},},
            [npcKeys.zoneID] = zoneIDs.SHATTRATH_CITY,
            [npcKeys.questEnds] = {10943,10950,10952,10962}, -- removed the horde starting quest
        },
        [22890] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOW_LABYRINTH] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.SHADOW_LABYRINTH,
        },
        [22891] = {
            [npcKeys.spawns] = {[zoneIDs.THE_STEAMVAULT] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_STEAMVAULT,
        },
        [22892] = {
            [npcKeys.spawns] = {[zoneIDs.THE_ARCATRAZ] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.THE_ARCATRAZ,
        },
        [22910] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{60.7,25.46}}},
        },
        [22911] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{77.53,31.2}}},
        },
        [22920] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{51.1,11.6}}},
        },
        [22932] = {
            [npcKeys.waypoints] = {[zoneIDs.BLADES_EDGE_MOUNTAINS]={{{29.54,59.72},{30.6,59.5},{31.5,58.1},{31.5,56.8},{30.5,56.2},{30.0,54.5},{30.5,56.2},{31.5,56.8},{31.5,58.1},{30.6,59.5},{29.54,59.72}}}},
        },
        [23035] = {
            [npcKeys.spawns] = {[zoneIDs.SETHEKK_HALLS] = {{-1,-1},},},
        },
        [23053] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{55,45}}},
            [npcKeys.zoneID] = zoneIDs.BLADES_EDGE_MOUNTAINS,
        },
        [23061] = {
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{27.15,64.8}}},
        },
        [23068] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{70.1,74.4},},},
        },
        [23100] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{44.2,41.0},},},
        },
        [23161] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{70.23,83.35},{70.06,79.45},{73.5,80.7},{69.67,74.72},{75.24,81.2},{72.23,88.18},{74.79,87.51},{61.99,74.66},{61.38,78.07}}},
            [npcKeys.zoneID] = zoneIDs.TEROKKAR_FOREST,
        },
        [23162] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{70.23,83.35},{70.06,79.45},{73.5,80.7},{69.67,74.72},{75.24,81.2},{72.23,88.18},{74.79,87.51},{61.99,74.66},{61.38,78.07}}},
            [npcKeys.zoneID] = zoneIDs.TEROKKAR_FOREST,
        },
        [23163] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{70.23,83.35},{70.06,79.45},{73.5,80.7},{69.67,74.72},{75.24,81.2},{72.23,88.18},{74.79,87.51},{61.99,74.66},{61.38,78.07}}},
            [npcKeys.zoneID] = zoneIDs.TEROKKAR_FOREST,
        },
        [23165] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST]={{70.23,83.35},{70.06,79.45},{73.5,80.7},{69.67,74.72},{75.24,81.2},{72.23,88.18},{74.79,87.51},{61.99,74.66},{61.38,78.07}}},
            [npcKeys.zoneID] = zoneIDs.TEROKKAR_FOREST,
        },
        [23149] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY]={{65.43,90.13},{63.05,87.74}}},
        },
        [23261] = {
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{66.71,14.3}}},
        },
        [23271] = {
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY] = {{35.05,32.39}}},
        },
        [23281] = {
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{62.75,7.33}}},
        },
        [23282] = {
            [npcKeys.waypoints] = {},
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{33.99,54.79}}},
        },
        [23324] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY]={{73.99,88.44},{74.35,88.95},{72.78,90.02},{74.36,88.01},{73.08,89.32},{72.97,90.0},{72.77,89.23},{73.65,88.13},{73.94,88.65}}},
        },
        [23338] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{46.5,45.1},{60.6,60.1},},},
        },
        [23353] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{37.76,41.43},{33.91,44.18},{35.59,36.7},{30.99,86.48},{26.79,83.57},{30.21,77.19},{27.07,75.62},{31.63,39.26}}},
            [npcKeys.zoneID] = zoneIDs.BLADES_EDGE_MOUNTAINS,
        },
        [23354] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{37.76,41.43},{33.91,44.18},{35.59,36.7},{30.99,86.48},{26.79,83.57},{30.21,77.19},{27.07,75.62},{31.63,39.26}}},
            [npcKeys.zoneID] = zoneIDs.BLADES_EDGE_MOUNTAINS,
        },
        [23355] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{37.76,41.43},{33.91,44.18},{35.59,36.7},{30.99,86.48},{26.79,83.57},{30.21,77.19},{27.07,75.62},{31.63,39.26}}},
            [npcKeys.zoneID] = zoneIDs.BLADES_EDGE_MOUNTAINS,
        },
        [23383] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{75.07,86.3},{68.4,74.1},{61.0,75.5},},},
        },
        [23786] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{40.6,68.0},{41.4,67.0},{42.2,65.8},{42.2,67.8},{42.4,67.2},{42.6,67.8},{43.0,65.4},{43.0,65.6},{43.4,67.0},{43.6,66.8},{43.8,67.6},{44.0,63.6},{44.0,65.2},{44.2,66.2},{44.6,65.6},{44.8,65.4},{44.8,66.6},{45.2,63.6},{45.6,68.4},{45.8,64.8},{46.0,66.2},{46.0,67.2},{46.2,69.0},{46.6,65.8}}},
        },
        [23789] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{52.2,76.2}}},
        },
        [23861] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{52.2,22.2},{52.4,24.2},{52.4,24.6},{52.4,27.4},{52.8,27.6},{53.0,21.6},{53.0,23.6},{53.0,27.2},{53.4,20.8},{53.6,27.8},{54.0,23.0},{54.0,29.0},{54.4,25.0},{55.0,21.4},{55.2,22.6},{55.4,22.0},{55.4,24.0},{55.8,21.0},{55.8,22.6},{56.0,24.0},{56.0,28.2},{56.0,28.6},{56.4,22.4},{56.4,27.4},{56.8,22.4},{56.8,23.4},{56.8,25.0},{57.0,23.8},{57.0,26.2},{57.0,30.4},{57.2,21.0},{57.2,26.8},{57.2,28.2},{57.4,30.6},{57.6,21.4},{57.6,23.2},{57.6,27.8},{57.6,28.8},{58.2,22.0},{58.2,26.4},{58.6,22.4},{58.6,26.0},{58.8,23.4},{59.2,25.0}}},
        },
        [23904] = {
            [npcKeys.spawns] = {[zoneIDs.SCARLET_MONASTERY] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.SCARLET_MONASTERY,
        },
        [23905] = {
            [npcKeys.spawns] = {[zoneIDs.DUSTWALLOW_MARSH] = {{69.61,51.77}}},
        },
        [24202] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{52,66.6}},[zoneIDs.IRONFORGE]={{30.2,66.5}}},
        },
        [24203] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{70.2,36.3}},[zoneIDs.IRONFORGE]={{64,78.2}}},
        },
        [24204] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{43.9,36.8}},[zoneIDs.IRONFORGE]={{64.3,24.3}}},
        },
        [24205] = {
            [npcKeys.spawns] = {[zoneIDs.ORGRIMMAR] = {{37.3,74.3}},[zoneIDs.IRONFORGE]={{32.2,21}}},
        },
        [24782] = {
            [npcKeys.spawns] = {[zoneIDs.DUSKWOOD] = {{16.9,33.4}}},
        },
        [24848] = {
            [npcKeys.spawns] = {[zoneIDs.MAGISTERS_TERRACE] = {{-1,-1}}},
            [npcKeys.zoneID] = zoneIDs.MAGISTERS_TERRACE,
        },
        [24885] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{55.8,53.8}}},
        },
        [24976] = {
            [npcKeys.spawns] = {[zoneIDs.ISLE_OF_QUEL_DANAS]={{44.72,39.4},{45.24,39.11},{44.96,38.06},{44.37,38.57},{41.96,36.96},{42.8,36.41},{43.47,34.13},{42.9,35.53},{42.72,34.86},{41.93,33.91},{41.24,34.38},{41.25,35.96},{40.53,40.54},{40.43,39.99},{41.86,39.73},{41.5,39.17},{41.6,39.19},{41.97,39.75},{41.67,40.57},{41.57,40.51},{41.95,42.42},{39.97,40.87},{44.65,37.13},{39.84,39.64},{40.46,39.52},{42.05,39.26}}},
        },
        [24978] = {
            [npcKeys.spawns] = {[zoneIDs.ISLE_OF_QUEL_DANAS]={{39.47,41.21},{40.62,34.25},{44.24,41.13},{45.66,37.18},{40.34,43.75},{46.03,38.17},{45.4,40.5},{42.85,33.03},{43.96,33.41},{44.9,36.27},{44.25,35.77},{43.66,35.48},{39.93,40.74},{41.23,42.68},{42.84,41.87},{42.64,43.16},{42.7,40.57},{41.86,41.91},{42.12,43.45},{41.54,33.53},{41.26,33.75},{41.44,36.53},{43.34,37.53},{42.22,38.17},{44.96,38.63},{44.7,38.83},{40.01,40.62},{42.56,36.0},{42.24,34.97},{41.59,35.42},{41.89,36.46},{42.43,35.95},{42.24,35.12},{41.81,35.5},{41.92,36.23},{40.0,43.0},{40.3,42.57},{41.26,43.89},{40.93,43.52}}},
        },
        [24979] = {
            [npcKeys.spawns] = {[zoneIDs.ISLE_OF_QUEL_DANAS]={{40.46,41.56},{41.33,37.33},{41.93,43.46},{43.18,34.85},{40.97,36.5},{40.48,36.31},{40.67,39.16},{38.86,40.98},{38.83,40.54},{38.82,40.14},{38.85,39.79},{43.17,38.98},{43.45,38.8},{43.71,38.74},{40.45,40.8},{40.28,40.18},{39.72,39.66}}},
        },
        [25324] = {
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{15.5,19.0},{9.3,13.0}}},
        },
        [25580] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{38.73,12.8}}},
        },
        [25863] = {
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{14.2,16.8},{14.4,18.2},{14.4,19.2},{14.4,19.8},{14.4,22.4},{15.0,18.2},{15.2,18.6},{15.4,17.4},{15.4,20.0},{15.4,20.8},{15.6,17.4},{15.6,20.2},{16.0,18.4},{16.0,19.2},{16.0,20.8},{16.6,19.2},{16.6,19.6},{16.8,18.4},{16.8,20.6}}},
        },
        [25888] = {
            [npcKeys.spawns] = {[zoneIDs.AZUREMYST_ISLE] = {{44.5,52.5}}},
        },
        [25889] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{41.4,65.9}}},
        },
        [25891] = {
            [npcKeys.spawns] = {[zoneIDs.BLOODMYST_ISLE] = {{55.8,67.9}}},
        },
        [25892] = {
            [npcKeys.spawns] = {[zoneIDs.BURNING_STEPPES] = {{80.3,62.9}}},
        },
        [25899] = {
            [npcKeys.spawns] = {[zoneIDs.FERALAS] = {{28.3,43.9}}},
        },
        [25903] = {
            [npcKeys.spawns] = {[zoneIDs.NAGRAND] = {{49.7,69.4}}},
        },
        [25905] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{39.7,54.7}}},
        },
        [25907] = {
            [npcKeys.spawns] = {[zoneIDs.TEROKKAR_FOREST] = {{54.1,55.6}}},
        },
        [25909] = {
            [npcKeys.spawns] = {[zoneIDs.WESTERN_PLAGUELANDS] = {{43.5,82.3}}},
        },
        [25912] = {
            [npcKeys.spawns] = {[zoneIDs.ZANGARMARSH] = {{69.1,51.9}}},
        },
        [25913] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM] = {{31.2,62.7}}},
        },
        [25918] = {
            [npcKeys.spawns] = {[zoneIDs.NETHERSTORM] = {{32.0,68.0}}},
        },
        [25926] = {
            [npcKeys.spawns] = {[zoneIDs.BLADES_EDGE_MOUNTAINS] = {{50.0,58.3}}},
        },
        [25929] = {
            [npcKeys.spawns] = {[zoneIDs.DUROTAR] = {{52.2,47.3}}},
        },
        [25931] = {
            [npcKeys.spawns] = {[zoneIDs.EVERSONG_WOODS] = {{46.4,50.6}}},
        },
        [25933] = {
            [npcKeys.spawns] = {[zoneIDs.GHOSTLANDS] = {{46.9,26.3}}},
        },
        [25936] = {
            [npcKeys.spawns] = {[zoneIDs.MULGORE] = {{51.8,59.8}}},
        },
        [25938] = {
            [npcKeys.spawns] = {[zoneIDs.SHADOWMOON_VALLEY] = {{33.5,30.6}}},
        },
        [25946] = {
            [npcKeys.spawns] = {[zoneIDs.TIRISFAL_GLADES] = {{57.2,51.8}}},
        },
        [25975] = {
            [npcKeys.spawns] = {
                [zoneIDs.TELDRASSIL]={{56.56,92.09}},
                [zoneIDs.IRONFORGE]={{65.36,25.06}},
                [zoneIDs.STORMWIND_CITY]={{39.36,62.2}},
                [zoneIDs.THE_EXODAR]={{40.90,25.59}},
            },
        },
        [26116] = {
            [npcKeys.spawns] = {[zoneIDs.ASHENVALE] = {{9.62,12.20},{9.25,11.50},{9.66,11.17}}},
        },
        [26178] = {
            [npcKeys.spawns] = {[zoneIDs.DESOLACE] = {{40.35,30.27},{40.26,31.35},{39.28,30.35}}},
        },
        [26204] = {
            [npcKeys.spawns] = {[zoneIDs.STRANGLETHORN_VALE] = {{21.17,22.74},{21.30,23.36},{21.26,24.30}}},
        },
        [26113] = {
            [npcKeys.spawns] = {
                [zoneIDs.UNDERCITY]={{68.87,8.47}},
                [zoneIDs.THUNDER_BLUFF]={{21.72,25.35}},
                [zoneIDs.ORGRIMMAR]={{47.14,38.15}},
                [zoneIDs.SILVERMOON_CITY]={{69.48,42.45}},
            },
        },
        [26123] = {
            [npcKeys.spawns] = {
                [zoneIDs.IRONFORGE]={{64.82,26.28}},
                [zoneIDs.TELDRASSIL]={{56.02,92.22}},
                [zoneIDs.THE_EXODAR]={{42.51,25.97}},
                [zoneIDs.STORMWIND_CITY]={{37.92,61.42}},
            },
        },
        [26124] = {
            [npcKeys.spawns] = {
                [zoneIDs.UNDERCITY]={{68.07,11.2}},
                [zoneIDs.THUNDER_BLUFF]={{20.87,24.18}},
                [zoneIDs.ORGRIMMAR]={{47.36,39.22}},
                [zoneIDs.SILVERMOON_CITY]={{70.39,44.30}},
            },
        },
        [26214] = {
            [npcKeys.spawns] = {[zoneIDs.SEARING_GORGE] = {{16.02,36.87},{14.66,34.22},{13.55,37.20}}},
        },
        [26215] = {
            [npcKeys.spawns] = {[zoneIDs.SILITHUS] = {{66.60,20.62},{67.03,18.72},{67.45,20.14}}},
        },
        [26216] = {
            [npcKeys.spawns] = {[zoneIDs.HELLFIRE_PENINSULA] = {{84.2,47.0},{84.2,53.4},{85.4,47.0},{85.6,53.2},{85.8,47.2},{85.8,47.6}}},
        },
        [26221] = {
            [npcKeys.spawns] = {
                [zoneIDs.TELDRASSIL]={{56.1,92.16}},
                [zoneIDs.UNDERCITY]={{66.9,13.53}},
                [zoneIDs.THUNDER_BLUFF]={{22.16,23.98}},
                [zoneIDs.SHATTRATH_CITY]={{60.68,30.62}},
                [zoneIDs.IRONFORGE]={{65.14,27.71}},
                [zoneIDs.ORGRIMMAR]={{46.44,38.69}},
                [zoneIDs.SILVERMOON_CITY]={{68.68,42.94}},
                [zoneIDs.THE_EXODAR]={{43.27,26.26}},
                [zoneIDs.STORMWIND_CITY]={{38.31,61.84}},
            },
        },
        [26760] = {
            [npcKeys.npcFlags] = npcFlags.NONE,
        },
        [28318] = {
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY]={{44.22,34.85}}},
        },
        [29087] = {
            [npcKeys.spawns] = {[zoneIDs.SHATTRATH_CITY]={{53.93,34.3}}},
        },
        [178420] = {
            [npcKeys.name] = "Magister Astalor Bloodsworn",
            [npcKeys.minLevel] = 60,
            [npcKeys.maxLevel] = 60,
            [npcKeys.zoneID] = zoneIDs.SILVERMOON_CITY,
            [npcKeys.spawns] = {[zoneIDs.SILVERMOON_CITY] = {{92.3,36.5}}},
            [npcKeys.friendlyToFaction] = "H",
        },
    }
end

-- This should allow manual fix for npc availability
function QuestieTBCNpcFixes:LoadFactionFixes()
    local npcKeys = QuestieDB.npcKeys
    local zoneIDs = ZoneDB.zoneIDs

    local npcFixesHorde = {
        [23537] = {
            [npcKeys.spawns] = {
                [zoneIDs.TIRISFAL_GLADES]={{60.45,53.41},{61.89,52.98},{60.4,52.95},{61.8,52.95},{61.66,52.94},{60.51,53.22},{56.97,53.03},{61.53,52.91},{61.19,52.55},{61.39,52.85},{60.31,52.93},{61.52,52.95},{59.84,52.3},{60.2,52.83},{59.93,52.44},{61.59,53.05},{60.14,52.7},{60.06,52.3},{60.11,52.44},{61.09,52.39},{59.71,52.17},{60.95,51.55},{61.01,52.25},{60.95,51.72},{60.99,51.6},{60.77,51.68},{60.85,51.51},{60.75,51.8},{61.07,51.68},{60.68,51.55},{61.13,51.38},{61.3,51.36},{61.39,51.38},{60.73,51.24},{61.56,51.42},{61.57,51.27},{60.52,51.08},{60.35,50.98},{60.26,50.92},{56.33,53.05},{56.65,53.38}},
                [zoneIDs.DUROTAR]={{51.93,41.62},{51.94,41.56},{51.88,41.7},{51.97,41.52},{51.98,41.67},{53.14,42.3},{51.63,42.26},{53.11,42.36},{51.67,42.22},{51.63,42.5},{51.76,42.0},{53.15,42.47},{53.12,42.43},{51.59,42.29},{51.73,42.22},{53.05,41.97},{53.17,42.37},{53.06,42.09},{51.75,42.41},{51.57,42.47},{53.06,43.0},{52.12,43.65},{52.2,43.61},{52.02,43.47},{52.11,43.49},{51.79,43.26},{53.22,42.73},{53.22,42.74},{53.17,42.84},{52.08,43.52},{51.94,42.98},{51.89,43.27},{51.78,43.2},{51.95,43.3},{51.75,43.44},{53.17,42.68},{49.11,42.99},{49.15,43.17},{49.23,42.9},{49.28,43.09},{49.29,43.41}},
                [zoneIDs.EVERSONG_WOODS]={{47.65,47.43},{47.79,47.26},{47.77,47.3},{47.87,47.14},{47.77,47.3},{47.69,47.42},{47.76,47.32},{47.83,47.2},{47.75,47.28},{47.86,47.16},{47.84,47.2},{47.78,47.23},{47.68,47.43},{47.68,47.42},{47.88,47.13},{47.7,47.35},{47.85,47.14},{47.72,47.36},{48.21,46.4},{48.21,46.34},{48.21,46.17},{48.19,46.27},{48.21,46.16},{48.19,46.35},{48.21,46.46},{48.21,46.16},{48.19,46.17},{48.21,46.27},{48.21,46.24},{48.21,46.03},{48.19,45.98},{48.21,45.89},{48.19,46.09},{48.21,46.01},{48.21,46.08},{48.21,45.97},{46.62,55.02},{46.56,55.2},{46.5,55.36},{46.37,55.34},{46.25,55.32}},
            },
        },
    }

    local npcFixesAlliance = {
        [23537] = {
            [npcKeys.spawns] = {
                [zoneIDs.AZUREMYST_ISLE]={{48.77,49.92},{48.67,48.99},{43.8,51.94},{43.5,51.93},{43.43,51.53},{43.64,52.09},{43.34,51.76},{49.4,52.55},{49.34,52.74},{49.4,52.67},{49.34,52.49},{49.32,52.6},{49.43,52.34},{49.51,52.28},{49.4,52.4},{49.61,52.29},{49.84,52.56},{49.89,52.66},{49.55,52.33},{49.72,52.42},{49.84,52.68},{49.46,52.36},{49.8,52.42},{49.71,52.33},{48.87,49.73},{48.67,49.99},{48.87,49.53},{48.84,49.79},{48.77,49.48},{48.46,49.98},{48.81,49.57},{48.55,50.01},{48.9,49.65},{48.7,49.95},{48.47,49.86},{48.54,49.93},{48.76,49.23},{48.75,49.31},{48.83,49.4},{48.74,49.08}},
                [zoneIDs.ELWYNN_FOREST]={{42.94,66.17},{41.9,65.92},{43.08,65.55},{43.12,66.49},{43.07,65.82},{42.96,65.71},{42.99,66.5},{41.65,65.23},{42.99,66.53},{41.35,65.23},{41.82,65.31},{43.1,65.75},{41.84,65.76},{43.09,65.61},{41.88,65.4},{43.07,66.22},{43.1,65.36},{43.06,66.13},{41.52,65.1},{41.74,65.29},{43.24,65.55},{41.78,66.06},{43.13,65.33},{42.75,65.28},{41.93,65.65},{41.62,66.03},{43.27,66.51},{43.2,66.51},{43.13,66.53},{43.37,66.51},{41.66,66.11},{43.41,66.59},{41.5,65.99},{41.4,66.12},{41.17,65.77},{41.27,65.99},{42.55,59.35},{42.63,60.0},{42.71,59.37},{42.39,59.7},{42.91,59.38}},
                [zoneIDs.DUN_MOROGH]={{47.01,52.55},{47.17,51.91},{47.06,51.83},{47.1,52.83},{47.06,51.75},{47.02,52.34},{47.16,51.75},{46.97,51.75},{46.82,52.19},{47.01,52.4},{46.88,52.21},{47.3,51.9},{45.98,51.93},{46.87,51.75},{47.24,51.75},{45.98,51.79},{47.01,52.8},{47.02,52.5},{47.32,51.75},{47.01,52.25},{45.98,52.06},{47.01,52.64},{47.03,52.66},{46.99,52.19},{46.91,52.25},{46.95,51.83},{46.83,51.84},{45.92,51.56},{45.98,51.65},{45.85,52.09},{45.8,51.54},{45.76,52.21},{45.63,51.31},{45.63,51.43},{45.74,51.43},{45.67,52.35},{47.19,57.3},{47.29,57.17},{47.3,56.96},{47.41,57.14},{47.31,57.38}},
            },
        },
    }

    if UnitFactionGroup("Player") == "Horde" then
        return npcFixesHorde
    else
        return npcFixesAlliance
    end
end
