---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local trackerOptionsLocales = {
    ["Tracker"] = {
        ["ptBR"] = "Rastreador",
        ["ruRU"] = "Трекер Questie",
        ["deDE"] = "Tracker",
        ["koKR"] = "추적기",
        ["esMX"] = "Rastreador",
        ["enUS"] = true,
        ["zhCN"] = "追踪",
        ["zhTW"] = "任務清單",
        ["esES"] = "Rastreador",
        ["frFR"] = "Suivi",
    },
    ["Tracker Options"] = {
        ["ptBR"] = "Opções do rastreador para missões",
        ["ruRU"] = "Настройки трекера (окна отслеживания) заданий",
        ["deDE"] = "Questie-Tracker Einstellungen",
        ["koKR"] = "퀘스트 추적기 설정",
        ["esMX"] = "Opciones del Rastreador",
        ["enUS"] = true,
        ["zhCN"] = "任务追踪选项",
        ["zhTW"] = "任務清單選項",
        ["esES"] = "Opciones del Rastreador",
        ["frFR"] = "Options du suivi des quêtes",
    },
    ---------------------------------------------------------
    ["Auto Track Quests"] = {
        ["ptBR"] = "Missões de rastreamento automático",
        ["ruRU"] = "Автоотслеживание",
        ["deDE"] = "Quests automatisch verfolgen",
        ["koKR"] = "자동 추적 퀘스트",
        ["esMX"] = "Misiones de seguimiento automático",
        ["enUS"] = true,
        ["zhCN"] = "自动追踪任务",
        ["zhTW"] = "自動追蹤所有任務",
        ["esES"] = "Misiones de seguimiento automático",
        ["frFR"] = "Suivi auto des quêtes",
    },
    ["This is the same as 'Enable Automatic Quest Tracking' in the Blizzard Interface Options. When enabled, the Questie Tracker will automatically track all Quests in your Quest Log. Disabling this option will untrack all Quests. You will have to manually select which Quests to track.\n\nNOTE: 'Show Complete Quests' is disabled while this option is not being used."] = {
        ["ptBR"] = "É o mesmo que 'Ativar rastreamento automático de missões' nas opções da interface. Quando ativado, o Questie Rastreador rastreia automaticamente todas as missões em seu registro. Isso evita o rastreamento manual com a tecla Shift pressionada.",
        ["ruRU"] = "Когда включено, трекер будет автоматически отслеживать все задания в вашем журнале (это то же самое, что и 'Отслеживание заданий' в настройках интерфейса игры). Отключение данной настройки приведет к отмене отслеживания всех заданий в вашем журнале, вам придется вручную выбрать задания для отслеживания.\n\nПРИМЕЧАНИЕ: Настройка 'Выполненные задания' будет отключена при отключении данной настройки",
        ["deDE"] = "Dies ist dasselbe wie 'Automatische Questverfolgung aktivieren' in den Schnittstellenoptionen. Wenn aktiviert, verfolgt der Questie Tracker automatisch alle Quests im Questlog. Dies verhindert die manuelle Verfolgung durch 'Umschalten + Linksklick'.",
        ["koKR"] = "인터페이스 옵션의 '자동 퀘스트 추적 사용 '과 동일합니다. 활성화하면 Questie Tracker가 로그의 모든 퀘스트를 자동으로 추적합니다. 이렇게하면 Shift- 클릭 수동 추적이 방지됩니다.",
        ["esMX"] = "Esto es lo mismo que 'Habilitar el seguimiento automático de misiones' en las opciones de la interfaz. Cuando está habilitado, el Rastreador de Questie rastreará automáticamente todas las misiones en tu registro. Esto evita el seguimiento manual de clic de cambio.",
        ["enUS"] = true,
        ["zhCN"] = "这与界面选项中的“启用自动任务跟踪”相同。 启用后，Questie 追踪将自动追踪日志中的所有任务。 这样可以防止按住Shift键单击手动追踪。",
        ["zhTW"] = "和遊戲內建的選項 '啟用自動追蹤任務' 相同。啟用時，Questie 任務清單將會自動追蹤任務日誌中的所有任務。停用此選項將會取消追蹤所有任務，必須手動選擇要追蹤的任務。\n\n注意: 停用此選項時也會停用 '顯示已完成的任務'。",
        ["esES"] = "Esto es lo mismo que 'Habilitar el seguimiento automático de misiones' en las opciones de la interfaz. Cuando está habilitado, el Rastreador de Questie rastreará automáticamente todas las misiones en tu registro. Esto evita el seguimiento manual de clic de cambio.",
        ["frFR"] = "Cela revient à utiliser 'Activer le suivi automatique des quêtes' dans les options d'interface. Le suivi des quêtes suivra alors automatiquement toutes les quêtes de votre journal et cela empêchera le suivi manuel Maj-clic.",
    },
    ---------------------------------------------------------
    ["Show Completed Quests"] = {
        ["ptBR"] = "Mostrar Missões Completas",
        ["ruRU"] = "Выполненные задания",
        ["deDE"] = "Abgeschlossene Quests anzeigen",
        ["koKR"] = "완료된 퀘스트 표시",
        ["esMX"] = "Mostrar misiones completas",
        ["enUS"] = true,
        ["zhCN"] = "显示已完成的任务",
        ["zhTW"] = "顯示已完成的任務",
        ["esES"] = "Mostrar misiones completas",
        ["frFR"] = "Quêtes terminées",
    },
    ["When this is checked, completed Quests will show in the Questie Tracker.\n\nNOTE: This setting only works when 'Auto Track Quests' is enabled."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Показать/скрыть выполненные задания в трекере.\n\nПРИМЕЧАНИЕ: Эта настройка работает только при включенной настройке 'Автоотслеживание'",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，任务列表中会显示已完成的任务\n\n注意: 必须先启用 '自动追踪所有任务'，此设置才有用。",
        ["zhTW"] = "啟用時，任務清單中會顯示已完成的任務。\n\n注意: 必須先啟用 '自動追蹤所有任務'，此設定才有效果。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Show Quest Level"] = {
        ["ptBR"] = "Mostrar nível da missão",
        ["ruRU"] = "Уровень заданий",
        ["deDE"] = "Questlevel anzeigen",
        ["koKR"] = "퀘스트 레벨 표시",
        ["esMX"] = "Mostrar nivel de misión",
        ["enUS"] = true,
        ["zhCN"] = "显示任务等级",
        ["zhTW"] = "顯示任務等級",
        ["esES"] = "Mostrar nivel de misión",
        ["frFR"] = "Afficher le niveau des quêtes",
    },
    ["When this is checked, the Quest Level Tags for Quest Titles will show in the Questie Tracker."] = {
        ["ptBR"] = "Quando isso estiver marcado, as tags de nível de missão para títulos de missão serão exibidas no Questie Rastreador.",
        ["ruRU"] = "Показать/скрыть уровень заданий слева от их названий",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Quest-Level-Tags für Quest-Titel im Questie-Tracker angezeigt.",
        ["koKR"] = "이 옵션을 선택하면 퀘스트 제목에 대한 퀘스트 레벨 태그가 Questie 트래커에 표시됩니다.",
        ["esMX"] = "Cuando esto está marcado, las etiquetas de nivel de búsqueda para los títulos de búsqueda se mostrarán en el Rastreador de Questie.",
        ["enUS"] = true,
        ["zhCN"] = "选中后，任务标题的任务等级将显示在Questie追踪窗口",
        ["zhTW"] = "啟用時，任務清單中的任務標題將會顯示任務等級。",
        ["esES"] = "Cuando esto está marcado, las etiquetas de nivel de búsqueda para los títulos de búsqueda se mostrarán en el Rastreador de Questie.",
        ["frFR"] = "Affiche le niveau des quêtes avec le titre des quêtes.",
    },
    ---------------------------------------------------------
    ["Auto Minimize Completed Quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Свернуть выполненные",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "自动收起已完成的任务",
        ["zhTW"] = "自動最小化已完成的任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["When this is checked, completed Quests will automatically minimize."] = {
        ["ptBR"] = "Quando isso estiver marcado, as missões concluídas serão automaticamente minimizadas.",
        ["ruRU"] = "Когда включено, задания будут автоматически сворачиваться после их выполнения",
        ["deDE"] = "Wenn dies aktiviert ist, werden abgeschlossene Quests automatisch minimiert.",
        ["koKR"] = "이 옵션을 선택하면 완료된 퀘스트가 자동으로 최소화됩니다.",
        ["esMX"] = "Cuando esto está marcado, las misiones completadas se minimizarán automáticamente",
        ["enUS"] = true,
        ["zhCN"] = "选中后，已完成的任务将自动收起",
        ["zhTW"] = "啟用時，已完成的任務會自動收合起來。",
        ["esES"] = "Cuando esto está marcado, las misiones completadas se minimizarán automáticamente",
        ["frFR"] = "Réduit automatique les quêtes terminées.",
    },
    ---------------------------------------------------------
    ["Hide Completed Quest Objectives"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Скрыть выполн. цели заданий",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "隐藏已完成的任务目标",
        ["zhTW"] = "隱藏已完成的任務目標",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["When this is checked, completed Quest Objectives will automatically be removed from the Questie Tracker."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Когда включено, выполненные цели заданий будут автоматически изъяты из трекера",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，已完成的任务目标将会自动从任务列表中移除。",
        ["zhTW"] = "啟用時，已完成的任務目標將會自動從任務清單中移除。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Hide Blizzard Completion Text"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Скрыть текст Blizzard",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "隐藏内建的完成信息",
        ["zhTW"] = "隱藏內建的完成訊息",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["When this is checked, Blizzard Completion Text will be hidden for completed Quests and instead show the old Questie tags: \"Quest Complete!\" or \"Quest Failed!\""] = {
        ["ptBR"] = false,
        ["ruRU"] = "Когда включено, Blizzard-ский текст об окончании задания будет скрыт, а вместо него будет отображен текст Questie: 'Задание выполнено!' или 'Задание провалено!'",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，完成任务时不会显示游戏内建的完成信息，而会显示传统的信息：\"任务完成！\" 和 \"任务失败！\"",
        ["zhTW"] = "啟用時，完成任務時不會顯示遊戲內建的完成訊息，而會顯示傳統的訊息: \"任務完成!\" or \"任務失敗!\"",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only
    ["Hide Completed Achieve Objectives"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Скрыть выполн. цели достижений",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "隐藏已完成的成就目标",
        ["zhTW"] = "隱藏已完成的成就目標",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["When this is checked, completed Achievement Objectives will automatically be removed from the Questie Tracker."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Когда включено, выполненные цели достижений будут автоматически изъяты из трекера",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，已完成的成就目标将会自动从任务列表中移除。",
        ["zhTW"] = "啟用時，已完成的成就目標將會自動從任務清單中移除。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Show Blizzard Timer"] = {
        ["ptBR"] = "Mostrar temporizador da Blizzard",
        ["ruRU"] = "Таймер Blizzard",
        ["deDE"] = "Blizzard Timer anzeigen",
        ["koKR"] = "블리자드 타이머 표시",
        ["esMX"] = "Mostrar temporizador de Blizzard",
        ["enUS"] = true,
        ["zhCN"] = "显示暴雪计时器",
        ["zhTW"] = "顯示內建任務計時器",
        ["esES"] = "Mostrar temporizador de Blizzard",
        ["frFR"] = "Chrono par défaut",
    },
    ["When this is checked, the default Blizzard Timer Frame for Quests will be shown instead of being embedded inside the Questie Tracker."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Quadro de temporizador padrão da Blizzard para missões será mostrado em vez de incorporado no rastreador.",
        ["ruRU"] = "Когда включено, будет отображаться стандартный таймер Blizzard вместо встраивания его в трекер",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Standard-Blizzard-Timer-Frame für Quests angezeigt, anstatt in den Tracker eingebettet zu sein.",
        ["koKR"] = "이 옵션을 선택하면 추적기에 내장 된 대신 퀘스트에 대한 기본 블리자드 타이머 프레임이 표시됩니다.",
        ["esMX"] = "Cuando esto está marcado, se mostrará el Marco predeterminado del temporizador de Blizzard para las misiones en lugar de estar incrustado dentro del rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "启用后，任务计时器将会显示",
        ["zhTW"] = "啟用時，會顯示遊戲內建的任務計時器框架，而不會內嵌在任務清單裡面。",
        ["esES"] = "Cuando esto está marcado, se mostrará el Marco predeterminado del temporizador de Blizzard para las misiones en lugar de estar incrustado dentro del rastreador.",
        ["frFR"] = "Active l'affichage du chronomètre de l'interface de base pour les quêtes au lieu d'indiquer le temps restant directement dans le suivi des quêtes.",
    },
    ---------------------------------------------------------
    ["Enable Active Quests Header"] = {
        ["ptBR"] = "Ativar cabeçalho",
        ["ruRU"] = "Заголовок 'Активные задания'",
        ["deDE"] = "Header anzeigen",
        ["koKR"] = "헤더 활성화",
        ["esMX"] = "Habilitar encabezado",
        ["enUS"] = true,
        ["zhCN"] = "启用标题",
        ["zhTW"] = "顯示標題列",
        ["esES"] = "Habilitar encabezado",
        ["frFR"] = "Activer l'en-tête",
    },
    ["When this is checked, the Active Quests Header will become visible and the total number of Quests you have in your Quest Log will be shown.\n\nNOTE: When this is disabled, the Questie Icon will fade in while your mouse is over the Tracker."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Показать/скрыть заголовок 'Активные задания'. В нем показано текущее количество заданий в вашем журнале заданий\n\nПРИМЕЧАНИЕ: Когда отключено, при наведении на трекер в правом верхнем углу появится значок Questie",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，会显示标题和任务总数。\n\n注意: 停用时。鼠标指向任务列表时才会显示。",
        ["zhTW"] = "啟用時，會顯示標題列和任務總數。\n\n注意: 停用時，滑鼠指向任務清單時才會顯示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Auto Move Active Quests Header"] = {
        ["ptBR"] = "Mover cabeçalho automaticamente",
        ["ruRU"] = "Автоперемещение заголовка",
        ["deDE"] = "Header automatisch verschieben",
        ["koKR"] = "자동 이동 헤더",
        ["esMX"] = "Encabezado de movimiento automático",
        ["enUS"] = true,
        ["zhCN"] = "自动移动标题",
        ["zhTW"] = "標題列在下方",
        ["esES"] = "Encabezado de movimiento automático",
        ["frFR"] = "Ajustement auto",
    },
    ["When this is checked, the Active Quests Header will automatically move to the bottom of the Questie Tracker.\n\nNOTE: This setting only works while the 'Tracker Growth Direction' setting is set to 'Up & Right' or 'Up & Left'."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Когда включено, заголовок 'Активные задания' будет автоматически перемещаться в низ трекера.\n\nПРИМЕЧАНИЕ: Эта настройка работает только тогда, когда 'Изменение размера трекера' имеет значение 'Вверх и вправо' или 'Вверх и влево'",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，标题会自动移动到任务列表的下方。\n\n只有在 '列表增长方向' 设为 '上 & 右' 或 '上 & 左' 时，此设定才有效果。",
        ["zhTW"] = "啟用時，標題列會自動移動到任務清單的下方。\n\n只有在 '清單增長方向' 設為 '上 & 右' 或 '上 & 左' 時，此設定才有效果。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Sticky Durability Frame"] = {
        ["ptBR"] = "Quadro de durabilidade aderente",
        ["ruRU"] = "Индикатор прочности",
        ["deDE"] = "Starre Haltbarkeitsanzeige",
        ["koKR"] = "달라붙는 프레임",
        ["esMX"] = "Marco de durabilidad fijo",
        ["enUS"] = true,
        ["zhCN"] = "锁定任务道具",
        ["zhTW"] = "耐久度貼齊清單",
        ["esES"] = "Marco de durabilidad fijo",
        ["frFR"] = "Ajust auto durabilité",
    },
    ["When this is checked, the durability frame will be placed on the left or right side of the Questie Tracker depending on where the Tracker is placed on your screen."] = {
        ["ptBR"] = "Quando isso estiver marcado, o quadro de durabilidade será colocado no lado esquerdo ou direito do Rastreador, dependendo de onde o Rastreador estiver colocado na tela.",
        ["ruRU"] = "Когда включено, индикатор прочности снаряжения будет расположен с левой или правой стороны трекера (в зависимости от положения трекера на экране)",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird die Haltbarkeitsanzeige auf der linken oder rechten Seite des Trackers platziert, je nachdem, wo sich der Tracker auf dem Bildschirm befindet.",
        ["koKR"] = "이 옵션을 선택하면 화면에서 트래커의 위치에 따라 내구성 프레임이 트래커의 왼쪽 또는 오른쪽에 배치됩니다.",
        ["esMX"] = "Cuando esto está marcado, el marco de durabilidad se colocará en el lado izquierdo o derecho del Rastreador, dependiendo de dónde esté ubicado el Rastreador en su pantalla.",
        ["enUS"] = true,
        ["zhCN"] = "选中此选项时，道具框架将根据追踪器在屏幕上的放置位置放置在追踪器的左侧或右侧。",
        ["zhTW"] = "啟用時，裝備耐久度框架會放在任務清單的左側或右側，依據任務清單在畫面上的位置而定。",
        ["esES"] = "Cuando esto está marcado, el marco de durabilidad se colocará en el lado izquierdo o derecho del Rastreador, dependiendo de dónde esté ubicado el Rastreador en su pantalla.",
        ["frFR"] = "Active le placement automatique du cadre de durabilité sur le côté gauche ou droit de la fenêtre de suivi selon l'endroit où celle-ci se trouve sur l'écran.",
    },
    ---------------------------------------------------------
    ["Minimize In Combat"] = {
        ["ptBR"] = "Minimizar em combate",
        ["ruRU"] = "Свернуть в бою",
        ["deDE"] = "Im Kampf minimieren",
        ["koKR"] = "전투 최소화",
        ["esMX"] = "Minimizar en combate",
        ["enUS"] = true,
        ["zhCN"] = "在战斗中最小化",
        ["zhTW"] = "戰鬥中最小化",
        ["esES"] = "Minimizar en combate",
        ["frFR"] = "Réduire en combat",
    },
    ["When this is checked, the Questie Tracker will automatically be minimized while entering combat."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Rastreador será automaticamente minimizado ao entrar em combate.",
        ["ruRU"] = "Когда включено, при входе в бой трекер будет автоматически свернут",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Tracker beim Eintritt in den Kampf automatisch minimiert.",
        ["koKR"] = "이 옵션을 선택하면 전투에 들어가는 동안 트래커가 자동으로 최소화됩니다.",
        ["esMX"] = "Cuando esto está marcado, el Rastreador se minimizará automáticamente al entrar en combate",
        ["enUS"] = true,
        ["zhCN"] = "选中后，在进入战斗状态时，追踪器将自动最小化。",
        ["zhTW"] = "啟用時，進入戰鬥後會自動將任務清單最小化。",
        ["esES"] = "Cuando esto está marcado, el Rastreador se minimizará automáticamente al entrar en combate",
        ["frFR"] = "Active la réduction automatique du suivi de quête lors des combats.",
    },
    ---------------------------------------------------------
    ["Minimize In Dungeons"] = {
        ["ptBR"] = "Minimizar em masmorras",
        ["ruRU"] = "Свернуть в подземельях",
        ["deDE"] = "In Instanzen minimieren",
        ["koKR"] = false,
        ["esMX"] = "Minimizar en calabozos",
        ["enUS"] = true,
        ["zhCN"] = "地下城时最小化",
        ["zhTW"] = "地城中最小化",
        ["esES"] = "Minimizar en mazmorras",
        ["frFR"] = "Minimiser dans les donjons",
    },
    ["When this is checked, the Questie Tracker will automatically be minimized when entering a dungeon."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Rastreador será minimizado automaticamente ao entrar em uma masmorra.",
        ["ruRU"] = "Когда включено, при входе в подземелье трекер будет автоматически свернут",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Tracker beim Betreten eines Dungeons automatisch minimiert.",
        ["koKR"] = false,
        ["esMX"] = "Cuando esto está marcado, el Rastreador se minimizará automáticamente al entrar a un calabozo.",
        ["enUS"] = true,
        ["zhCN"] = "选中此项后，进入地下城时跟踪器将自动最小化。",
        ["zhTW"] = "啟用時，進入地城後會自動將任務清單最小化。",
        ["esES"] = "Cuando esto está marcado, el Rastreador se minimizará automáticamente al entrar a una mazmorra.",
        ["frFR"] = "La fenêtre du suivi sera automatiquement minimisée lors de l'entrée dans un donjon.",
    },
    ---------------------------------------------------------
    ["Fade Min/Max Buttons"] = {
        ["ptBR"] = "Desvanecer botões Min/Max",
        ["ruRU"] = "Скрыть '+' и '–'",
        ["deDE"] = "Min/Max ausblenden",
        ["koKR"] = "페이드 최소 / 최대 BTN",
        ["esMX"] = "Desvanecer botones Min/Máx",
        ["enUS"] = true,
        ["zhCN"] = "淡化按钮",
        ["zhTW"] = "淡出最大化/最小化按鈕",
        ["esES"] = "Desvanecer botones Min/Máx",
        ["frFR"] = "Fondu des boutons +/-",
    },
    ["When this is checked, the Minimize and Maximize Buttons will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, os botões Minimizar e Maximizar desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, кнопки сворачивания и разворачивания заданий исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Schaltflächen zum Minimieren und Maximieren von Quests ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 옵션을 선택하면 사용하지 않을 때 최소화 및 최대화 버튼이 사라지고 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, los botones Minimizar y Maximizar se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中时，自动淡化按钮",
        ["zhTW"] = "啟用時，滑鼠沒有指向最大化和最小化按鈕時會變成透明。",
        ["esES"] = "Cuando esto está marcado, los botones Minimizar y Maximizar se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu des boutons + et - ce qui les rend transparents en dehors du survol de la souris.",
    },
    ---------------------------------------------------------
    ["Fade Quest Item Buttons"] = {
        ["ptBR"] = "Desvanecer BTNs do item de missão",
        ["ruRU"] = "Скрыть предметы заданий",
        ["deDE"] = "Questgegenstände ausblenden",
        ["koKR"] = "페이드 퀘스트 아이템 BTN",
        ["esMX"] = "Desvanecer botones de objetos de misiones",
        ["enUS"] = true,
        ["zhCN"] = "淡化任务道具按钮",
        ["zhTW"] = "淡出任務物品按鈕",
        ["esES"] = "Desvanecer botones de objetos de misiones",
        ["frFR"] = "Fondu des objets de quête",
    },
    ["When this is checked, the Quest Item Buttons will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, os botões de itens da missão desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, кнопки предметов заданий исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden die Schaltflächen für die Questgegenstände ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 항목을 체크하면 퀘스트 아이템 버튼이 사라지고 사용하지 않을 때 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, los Botones de Objetos de Búsqueda se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中此项时，任务项按钮将在不使用时自动淡化",
        ["zhTW"] = "啟用時，滑鼠沒有指向任務物品按鈕時會變成透明。",
        ["esES"] = "Cuando esto está marcado, los Botones de Objetos de Búsqueda se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu des boutons d'objet de quête ce qui les rend transparents en dehors du survol de la souris.",
    },
    ---------------------------------------------------------
    ["Enable Background"] = {
        ["ptBR"] = "Ativar plano de fundo",
        ["ruRU"] = "Фон трекера",
        ["deDE"] = "Hintergrund anzeigen",
        ["koKR"] = "배경 사용",
        ["esMX"] = "Habilitar fondo",
        ["enUS"] = true,
        ["zhCN"] = "启用背景",
        ["zhTW"] = "顯示背景",
        ["esES"] = "Habilitar fondo",
        ["frFR"] = "Activer l'arrière-plan",
    },
    ["When this is checked, the Questie Tracker Background becomes visible."] = {
        ["ptBR"] = "Quando isso estiver marcado, o fundo do rastreador de missões fica visível.",
        ["ruRU"] = "Показать/скрыть фон трекера",
        ["deDE"] = "Wenn diese Option aktiviert ist, wird der Questie Tracker-Hintergrund angezeigt.",
        ["koKR"] = "이 옵션을 선택하면 Questie 추적기 배경이 나타납니다.",
        ["esMX"] = "Cuando esto está marcado, el fondo del Rastreador de Questie se vuelve visible",
        ["enUS"] = true,
        ["zhCN"] = "选中后，将显示追踪器背景。",
        ["zhTW"] = "啟用時，任務清單會顯示背景顏色。",
        ["esES"] = "Cuando esto está marcado, el fondo del Rastreador de Questie se vuelve visible",
        ["frFR"] = "Active l'arrière-plan du suivi des quêtes Questie.",
    },
    ---------------------------------------------------------
    ["Enable Border"] = {
        ["ptBR"] = "Ativar borda",
        ["ruRU"] = "Граница фона",
        ["deDE"] = "Rahmen anzeigen",
        ["koKR"] = "테두리 활성화",
        ["esMX"] = "Habilitar borde",
        ["enUS"] = true,
        ["zhCN"] = "启用边框",
        ["zhTW"] = "顯示邊框",
        ["esES"] = "Habilitar borde",
        ["frFR"] = "Activer la bordure",
    },
    ["When this is checked, the Questie Tracker Border becomes visible."] = {
        ["ptBR"] = "Quando isso estiver marcado, a borda do rastreador de missões fica visível.",
        ["ruRU"] = "Показать/скрыть границу фона трекера",
        ["deDE"] = "Wenn dies aktiviert ist, wird der Rand des Questie Trackers sichtbar.",
        ["koKR"] = "이 옵션을 선택하면 Questie 트래커 테두리가 나타납니다.",
        ["esMX"] = "Cuando esto está marcado, el borde del Rastreador de Questie se vuelve visible",
        ["enUS"] = true,
        ["zhCN"] = "选中后，将显示边框。",
        ["zhTW"] = "啟用時，任務清單會顯示邊框。",
        ["esES"] = "Cuando esto está marcado, el borde del Rastreador de Questie se vuelve visible",
        ["frFR"] = "Active la bordure du suivi des quêtes Questie.",
    },
    ---------------------------------------------------------
    ["Fade Background"] = {
        ["ptBR"] = "Desvanecer fundo",
        ["ruRU"] = "Скрыть фон и границу",
        ["deDE"] = "Hintergrund verblassen",
        ["koKR"] = "페이드 배경",
        ["esMX"] = "Fundido de fondo",
        ["enUS"] = true,
        ["zhCN"] = "淡化背景",
        ["zhTW"] = "淡出背景",
        ["esES"] = "Fundido de fondo",
        ["frFR"] = "Fondu de l'arrière-plan",
    },
    ["When this is checked, the Questie Tracker Backdrop and Border (if enabled) will fade and become transparent when not in use."] = {
        ["ptBR"] = "Quando isso estiver marcado, o Pano de fundo e a borda do Questie Rastreador (se ativado) desaparecerão e se tornarão transparentes quando não estiverem em uso.",
        ["ruRU"] = "Когда включено, фон и граница трекера исчезают и становятся прозрачными при неиспользовании",
        ["deDE"] = "Wenn diese Option aktiviert ist, werden der Hintergrund des Questie Trackers und der Rahmen (falls aktiviert) ausgeblendet und transparent, wenn sie nicht verwendet werden.",
        ["koKR"] = "이 옵션을 선택하면 Questie 트래커 배경 및 테두리 (사용 가능한 경우)가 사라지고 사용하지 않을 때 투명 해집니다.",
        ["esMX"] = "Cuando esto está marcado, el fondo y el borde del Rastreador de Questie (si está habilitado) se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["enUS"] = true,
        ["zhCN"] = "选中后，自动淡化背景及边框",
        ["zhTW"] = "啟用時，滑鼠沒有指向任務清單時，背景和 (如果有啟用) 邊框會變成透明。",
        ["esES"] = "Cuando esto está marcado, el fondo y el borde del Rastreador de Questie (si está habilitado) se desvanecerán y se volverán transparentes cuando no estén en uso",
        ["frFR"] = "Active le fondu de l'arrière-plan du suivi des quêtes Questie lorsque celui-ci est activé.",
    },
    ---------------------------------------------------------
    ["Hide Tracker Sizer"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Скрыть сайзер трекера",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "隐藏列表大小调整点",
        ["zhTW"] = "隱藏清單大小調整點",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["When this is checked, the Questie Tracker Sizer that appears in the bottom or top right hand corner will be hidden."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Когда включено, скрывается сайзер (изменитель размера трекера), который отображается в правом нижнем или в правом верхнем углу",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，任务列表下方或右上角调整点不会显示。",
        ["zhTW"] = "啟用時，任務清單下方或右上角調整點不會顯示出來。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Always Show Tracker"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Всегда отображать трекер",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "总是显示任务列表",
        ["zhTW"] = "總是顯示任務清單",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["When this is checked, the Questie Trackers 'Active Quests Header' will always be visible when nothing is being tracked versus being hidden completely.\n\nNOTE: If the 'Active Quests Header' is in a disabled state, enabling this option will toggle it on when nothing is being tracked then toggle back off when you track something."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Когда включено, заголовок 'Активные задания' будет всегда отображаться, даже если не отслеживается ни одно задание.\n\nПРИМЕЧАНИЕ: Если заголовок 'Активные задания' отключен, то включение данной настройки будет включать его, когда ничего не отслеживается, и выключать, когда что-нибудь отслеживается",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，没有追踪任何洞悉也会显示任务列表的标题，不会完全隐藏。\n\n注意: 如果 '显示标题' 是停用的，启用次选项时，没有追踪任何东西会让 '显示标题' 变成启用，有追踪时则会停用 '显示标题'。",
        ["zhTW"] = "啟用時，沒有追蹤任何東西也會顯示任務清單的標題列，不會完全隱藏。\n\n注意: 如果 '顯示標題列' 是停用的，啟用此選項時，沒有追蹤任何東西會讓 '顯示標題列' 變成啟用，有追蹤時則會停用 '顯示標題列'。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only
    ["List Achievements First"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Достижения вверху",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "成就排前面",
        ["zhTW"] = "成就排在前面",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["When this is checked, the Questie Tracker will list Achievements first then Quests."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Когда включено, достижения в трекере будут отображаться сверху заданий",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，任务追踪列表会将成就排在任务的前面",
        ["zhTW"] = "啟用時，任務追蹤清單會將成就排列在任務的前面。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    -- VoiceOver Tracker Integration
    ["Sticky VoiceOver Frame"] = {
        ["ptBR"] = false,
        ["ruRU"] = false,
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "语音贴齐清单",
        ["zhTW"] = "語音貼齊清單",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["When this is checked, the VoiceOver talking head / sound queue frame will be placed on the left or right side of the Questie Tracker depending on where the Tracker is placed on your screen."] = {
        ["ptBR"] = false,
        ["ruRU"] = false,
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用时，语音框会放在任务列表的左侧或右侧，根据任务列表在界面上的位置而定。",
        ["zhTW"] = "啟用時，語音框架會放在任務清單的左側或右側，依據任務清單在畫面上的位置而定。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Lock Tracker"] = {
        ["ptBR"] = "Bloqueado o rastreador",
        ["ruRU"] = "Заблокировать трекер",
        ["deDE"] = "Tracker sperren",
        ["koKR"] = "추적기 잠금",
        ["esMX"] = "Bloquear rastreador",
        ["enUS"] = true,
        ["zhCN"] = "锁定框体",
        ["zhTW"] = "鎖定任務清單",
        ["esES"] = "Bloquear rastreador",
        ["frFR"] = "Verrouiller la fenêtre du suivi",
    },
    ["When this is checked, the Questie Tracker is locked and you need to hold CTRL when you want to move it."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Когда это включено, то трекер заблокирован, и для его перемещения вам нужно зажать Ctrl",
        ["deDE"] = "Wenn dies aktiviert ist, dann muss STRG gedrückt gehalten werden, wenn der Tracker bewegt werden soll.",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "启用此选项，追踪器被锁定，您需要按住 CTRL 键才能移动它。",
        ["zhTW"] = "啟用時，會鎖定任務清單，必須按住 CTRL 鍵才能移動它。",
        ["esES"] = false,
        ["frFR"] = "Lorsque ceci est coché, le traqueur est vérouillé, maintenez CTRL lorsque vous souhaitez le déplacer.",
    },
    ---------------------------------------------------------
    ["Disable Tracker"] = {
        ["ptBR"] = "Desativar o rastreador",
        ["ruRU"] = "Отключение",
        ["deDE"] = "Deaktiviere den Tracker",
        ["koKR"] = "트래커 비활성화",
        ["esMX"] = "Deshabilitar el rastreador",
        ["enUS"] = true,
        ["zhCN"] = "禁用追踪器",
        ["zhTW"] = "停用任務清單",
        ["esES"] = "Deshabilitar el rastreador",
        ["frFR"] = "Suivi par défaut",
    },
    ["Disabling the Tracker will replace the Questie Tracker with the default Blizzard Quest Tracker.\n\nNOTE: This setting is saved Per Character and will reload the UI."] = {
        ["ptBR"] = "Desativar o Rastreador substituirá o Questie Rastreador pelo Blizzard Quest Rastreador padrão.",
        ["ruRU"] = "После нажатия данной кнопки трекер Questie заменится трекером Blizzard.\n\nПРИМЕЧАНИЕ: Эта настройка действует для каждого персонажа отдельно и перезапускает пользовательский интерфейс",
        ["deDE"] = "Durch Deaktivieren des Trackers wird der Questie-Tracker durch den Standard-Blizzard-Quest-Tracker ersetzt.",
        ["koKR"] = "추적기를 비활성화하면 Questie 추적기가 기본 블리자드 퀘스트 추적기로 대체됩니다.",
        ["esMX"] = "Deshabilitar el Rastreador reemplazará el Rastreador de misiones con el Rastreador de misiones de Blizzard predeterminado.",
        ["enUS"] = true,
        ["zhCN"] = "禁用跟踪器会将Questie追踪器替换为默认的暴雪任务追踪器。",
        ["zhTW"] = "停用任務位置提示插件的任務清單，改用遊戲內建的。\n\n此設定是每個角色分開儲存的，更改後會重新載入介面。",
        ["esES"] = "Deshabilitar el Rastreador reemplazará el Rastreador de misiones con el Rastreador de misiones de Blizzard predeterminado.",
        ["frFR"] = "L'activation du suivi des quêtes par défaut remplacera le suivi des quêtes Questie.",
    },
    ---------------------------------------------------------
    ["Enable Tracker"] = {
        ["ptBR"] = "Ativar o rastreador",
        ["ruRU"] = "Включить трекер",
        ["deDE"] = "Den Tracker anzeigen",
        ["koKR"] = "트래커 활성화",
        ["esMX"] = "Habilitar el rastreador",
        ["enUS"] = true,
        ["zhCN"] = "启用跟踪器",
        ["zhTW"] = "啟用任務清單",
        ["esES"] = "Habilitar el rastreador",
        ["frFR"] = "Suivi Questie",
    },
    ["Enabling the Tracker will replace the default Blizzard Quest Tracker with the Questie Tracker.\n\nNOTE: This setting is saved Per Character and will reload the UI."] = {
        ["ptBR"] = "A ativação do Rastreador substituirá o Blizzard Quest Rastreador padrão pelo Questie Rastreador.",
        ["ruRU"] = "После нажатия данной кнопки трекер Blizzard заменится трекером Questie.\n\nПРИМЕЧАНИЕ: Эта настройка действует для каждого персонажа отдельно и перезапускает пользовательский интерфейс",
        ["deDE"] = "Durch Aktivieren des Trackers wird der Standard-Blizzard-Quest-Tracker durch den Questie-Tracker ersetzt.",
        ["koKR"] = "추적기를 활성화하면 기본 블리자드 퀘스트 추적기가 Questie 추적기로 대체됩니다.",
        ["esMX"] = "Habilitar el Rastreador reemplazará el Rastreador de misiones de Blizzard predeterminado con el Rastreador de misiones.",
        ["enUS"] = true,
        ["zhCN"] = "启用跟踪器会将默认的暴雪自带任务追踪器替换为Questie追踪器。",
        ["zhTW"] = "啟用任務位置提示插件的任務清單來取代遊戲內建的。\n\n此設定是每個角色分開儲存的，更改後會重新載入介面。",
        ["esES"] = "Habilitar el Rastreador reemplazará el Rastreador de misiones de Blizzard predeterminado con el Rastreador de misiones.",
        ["frFR"] = "L'activation du suivi des quêtes Questie remplacera le suivi des quêtes par défaut.",
    },
    ---------------------------------------------------------
    ["Reset Tracker"] = {
        ["ptBR"] = "Redefinir posição do rastreador",
        ["ruRU"] = "Сброс позиции",
        ["deDE"] = "Tracker-Position zurücksetzen",
        ["koKR"] = "추적기 위치 재설정",
        ["esMX"] = "Restablecer posición del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "重置追踪器位置",
        ["zhTW"] = "重置任務清單",
        ["esES"] = "Restablecer posición del rastreador",
        ["frFR"] = "Réinitialiser position",
    },
    ["If the Questie Tracker is stuck offscreen or lost, you can reset it's location to the center of the screen with this button."] = {
        ["ptBR"] = "Se o rastreador do Questie estiver preso fora da tela ou perdido, você poderá redefinir sua localização para o centro da tela com este botão (pode exigir / recarregar).",
        ["ruRU"] = "Если трекер исчез полностью или оказался за пределами экрана, то нажатие этой кнопки сбросит его положение в центр экрана (может потребоваться перезагрузка пользовательского интерфейса командой '/reload')",
        ["deDE"] = "Wenn der Questie-Tracker außerhalb des Bildschirms hängen bleibt oder verloren geht, kann seine Position mit dieser Schaltfläche auf die Mitte des Bildschirms zurückgesetzt werden (erfordert möglicherweise ein /reload).",
        ["koKR"] = "Questie 트래커가 화면을 벗어나거나 잃어버린 경우이 버튼을 사용하여 화면 중앙으로 위치를 재설정 할 수 있습니다 (/ 재로드 필요).",
        ["esMX"] = "Si el rastreador Questie está atascado o perdido, puede restablecer su ubicación en el centro de la pantalla con este botón (puede requerir / volver a cargar).",
        ["enUS"] = true,
        ["zhCN"] = "如果Questie追踪器卡在屏幕外或丢失，您可以使用此按钮将其位置重置到屏幕中央（可能需要重载界面 /reload）。",
        ["zhTW"] = "如果任務清單跑出畫面或不見了，使用這個按鈕可以將它重置到畫面的中間。",
        ["esES"] = "Si el rastreador Questie está atascado o perdido, puede restablecer su ubicación en el centro de la pantalla con este botón (puede requerir / volver a cargar).",
        ["frFR"] = "Si le suivi des quêtes Questie est bloqué hors écran ou perdu, vous pouvez réinitialiser son emplacement au centre de l'écran avec ce bouton (peut nécessiter de /reload).",
    },
    ---------------------------------------------------------
    ["Save Tracker (Character)"] = {
        ["ptBR"] = "Salvar rastreador por personagem",
        ["ruRU"] = "Сохранить отдельно",
        ["deDE"] = "Tracker pro Char speichern",
        ["koKR"] = "문자 당 트래커 저장",
        ["esMX"] = "Guardar Rastreador por Char",
        ["enUS"] = true,
        ["zhCN"] = "根据角色自定义设置",
        ["zhTW"] = "角色專用設定",
        ["esES"] = "Guardar Rastreador por Char",
        ["frFR"] = "Réglages par perso",
    },
    ["The Questie Trackers Location and Set Point is currently being saved Per Character. This allows you to cusomize each character's Tracker location.\n\nNOTE: Upon enabling Per Character, the Questie Tracker will be reset to the center of your screen. Move the Tracker to your desired location and set the size. When you are ready, type '/reload' to finalize your settings."] = {
        ["ptBR"] = "No momento, você está salvando o local do Questie Rastreador e o tamanho por personagem. Isso permite que você personalize a localização do rastreador de cada personagem.\n\nNOTA: Ao ativar o Per Character, o rastreador será redefinido no centro do seu Mova o Rastreador para o local desejado e defina o tamanho. Quando estiver pronto, digite '/recarregar' para finalizar suas configurações.",
        ["ruRU"] = "В данный момент положение и размер трекера сохраняются для каждого персонажа отдельно.\n\nПРИМЕЧАНИЕ: При изменении этой настройки положение трекера будет сброшено в центр экрана. После этого нужно переместить трекер в необходимое место и установить его размер. Для завершения настройки нужно перезагрузить пользовательский интерфейс командой '/reload'",
        ["deDE"] = "Die Position und Größe des Questie-Trackers wird aktuell pro Charakter gespeichert. Auf diese Weise kann der Tracker-Standort auf jeden Charakters unterschiedlich eingestellt werden.\n\nHINWEIS: Wenn 'Pro Charakter' aktiviert wird, wird die Position des Trackers zurückgesetzt. Anschließend sollte der Tracker an den gewünschten Ort verschoeben und die Größe passen eingestellt werden. Das Einstellen wird mit einem '/reload' abgeschlossen.",
        ["koKR"] = "현재 Questie Tracker 위치 및 문자 당 크기를 저장하고 있습니다. 이렇게하면 각 문자의 추적기 위치를 조절할 수 있습니다.\n\n참고 : 문자 별을 활성화하면 추적기가 중앙으로 재설정됩니다. 추적기를 원하는 위치로 이동하고 크기를 설정하십시오. 준비가되면 '/reload'를 입력하여 설정을 완료하십시오.",
        ["esMX"] = "Actualmente está guardando la ubicación y el tamaño del Rastreador de Questie por personaje. Esto le permite personalizar la ubicación del rastreador de cada personaje.\n\nNOTA: Al habilitar Por personaje, el Tracker se reiniciará en el centro de su pantalla. Mueva el Rastreador a su ubicación deseada y configure el tamaño. Cuando esté listo, escriba '/reload' para finalizar su configuración.",
        ["enUS"] = true,
        ["zhCN"] = "您当前正在保存Questie追踪窗口的位置和大小。这使您可以自定义每个角色的不同设定。\n\n注意：启用这个设定后，跟踪器将重置为您的屏幕中间。将追踪窗口移至你想要的位置并设置大小。设置好后，输入'/reload'完成设置。",
        ["zhTW"] = "讓每個角色分開儲存任務清單的位置和大小，以便自訂每個角色的清單位置。\n\n注意: 啟用此設定後，任務清單會被重置到畫面中間，請將清單移動到你想要的位置並且調整大小，調整好後請輸入 '/reload' 來完成設定。",
        ["esES"] = "Actualmente está guardando la ubicación y el tamaño del Rastreador de Questie por personaje. Esto le permite personalizar la ubicación del rastreador de cada personaje.\n\nNOTA: Al habilitar Por personaje, el Tracker se reiniciará en el centro de su pantalla. Mueva el Rastreador a su ubicación deseada y configure el tamaño. Cuando esté listo, escriba '/reload' para finalizar su configuración.",
        ["frFR"] = "Vous enregistrez actuellement vos réglages pour ce personnage uniquement. Cela vous permet de personnaliser l'emplacement du suivi des quêtes pour chacun de vos personnages.\n\nREMARQUE : L'activation de ce mode réinitialisera la fenêtre de suivi au centre de l'écran. Déplacez-la à l'emplacement souhaité et définissez-en la taille. Tapez ensuite '/reload' pour enregistrer vos réglages. ",
    },
    ---------------------------------------------------------
    ["Save Tracker (Global)"] = {
        ["ptBR"] = "Salvar global do rastreador",
        ["ruRU"] = "Сохранить глобально",
        ["deDE"] = "Tracker global speichern",
        ["koKR"] = "추적기 글로벌 저장",
        ["esMX"] = "Guardar Rastreador Global",
        ["enUS"] = true,
        ["zhCN"] = "所有角色统一设定",
        ["zhTW"] = "帳號共用設定",
        ["esES"] = "Guardar Rastreador Global",
        ["frFR"] = "Réglages partagés",
    },
    ["The Questie Trackers Location and Set Point is currently being saved Globally. This allows you to have one setting for all characters.\n\nNOTE: Upon enabling Global, the Questie Tracker will be reset to the center of your screen. Move the Tracker to your desired location and set the size. When you are ready, type '/reload' to finalize your settings."] = {
        ["ptBR"] = "No momento, você está salvando o local e o tamanho do Questie Rastreador globalmente. Isso permite que você tenha uma configuração para todos os caracteres.\n\nNOTA: Ao ativar Global, o Rastreador será redefinido para o centro da tela Mova o Rastreador para o local desejado e defina o tamanho. Quando estiver pronto, digite '/recarregar' para finalizar suas configurações.",
        ["ruRU"] = "В данный момент положение и размер трекера сохраняются одинаково для всех персонажей.\n\nПРИМЕЧАНИЕ: При изменении этой настройки положение трекера будет сброшено в центр экрана. После этого нужно переместить трекер в необходимое место и установить его размер. Для завершения настройки нужно перезагрузить пользовательский интерфейс командой '/reload'",
        ["deDE"] = "Die Position und Größe des Questie-Trackers wird aktuell global gespeichert. Auf diese Weise kann der Tracker-Standort für alle Charakter gleichermaßen eingestellt werden.\n\nHINWEIS: Wenn 'Pro Charakter' aktiviert wird, wird die Position des Trackers zurückgesetzt. Anschließend sollte der Tracker an den gewünschten Ort verschoeben und die Größe passen eingestellt werden. Das Einstellen wird mit einem '/reload' abgeschlossen.",
        ["koKR"] = "현재 Questie 추적기 위치 및 크기를 전역으로 저장하고 있습니다. 모든 문자에 대해 하나의 설정을 지정할 수 있습니다.\n\n참고 : 전역을 활성화하면 추적기가 화면 중앙으로 재설정됩니다. 추적기를 원하는 위치로 이동하고 크기를 설정하십시오. 준비가되면 '/reload'를 입력하여 설정을 완료하십시오.",
        ["esMX"] = "Actualmente está guardando la ubicación y el tamaño del Rastreador de Questie a nivel mundial. Esto le permite tener una configuración para todos los caracteres.\n\nNOTA: Al habilitar Global, el Tracker se restablecerá en el centro de su pantalla . Mueva el Rastreador a su ubicación deseada y establezca el tamaño. Cuando esté listo, escriba '/reload' para finalizar su configuración.",
        ["enUS"] = true,
        ["zhCN"] = "您当前正在全局保存Questie追踪窗口的位置和大小。这使您可以对所有角色进行一次设置。\n\n注意：启用这项设定后，追踪将会重置到屏幕中心。将追踪移至所需位置并设置大小。设置好后，输入'/reload'完成设置。",
        ["zhTW"] = "統一儲存任務清單的位置和大小，以便讓所有角色都使用相同的設定。\n\n注意: 啟用此設定後，任務清單會被重置到畫面中間，請將清單移動到你想要的位置並且調整大小，調整好後請輸入 '/reload' 來完成設定。",
        ["esES"] = "Actualmente está guardando la ubicación y el tamaño del Rastreador de Questie a nivel mundial. Esto le permite tener una configuración para todos los caracteres.\n\nNOTA: Al habilitar Global, el Tracker se restablecerá en el centro de su pantalla . Mueva el Rastreador a su ubicación deseada y establezca el tamaño. Cuando esté listo, escriba '/reload' para finalizar su configuración.",
        ["frFR"] = "Vous enregistrez actuellement vos réglages de façon partagée. Cela vous permet d'avoir une seule configuration partagée entre tous vos personnages.\n\nREMARQUE : L'activation de ce mode réinitialisera la fenêtre de suivi au centre de l'écran. Déplacez-la à l'emplacement souhaité et définissez-en la taille. Tapez ensuite '/reload' pour enregistrer vos réglages.",
    },
    ---------------------------------------------------------
    ["Objective Color"] = {
        ["ptBR"] = "Cor do objectivo",
        ["ruRU"] = "Цвет целей",
        ["deDE"] = "Questzielfarbe",
        ["koKR"] = "퀘스트 목표 색상",
        ["esMX"] = "Color de objectivo",
        ["enUS"] = true,
        ["zhCN"] = "目标着色",
        ["zhTW"] = "任務目標顏色",
        ["esES"] = "Color de objectivo",
        ["frFR"] = "Couleur des objectifs :",
    },
    ["Change the color of Objectives in the Questie Tracker by how complete they are.\n\nNOTE: The Minimalistic option will not display the \"Blizzard Completion Text\" and just label the Quest as either \"Quest Complete!\" or \"Quest Failed!\"."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Изменение цвета целей заданий в трекере в зависимости от прогресса выполнения.\n\nПРИМЕЧАНИЕ: Настройка 'Минимализм' не будет отображать Blizzard-ский текст об окончании задания, вместо этого будут отображаться или 'Задание выполнено!', или 'Задание провалено!'",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "列表中的任务目标会根据完成度变换颜色。\n\n极简的选项不会显示游戏内建任务完成信息，只会显示 \"任务完成！\" 或 \"任务失败！\"。",
        ["zhTW"] = "清單中的任務目標會依據完成度變換顏色。\n\n極簡的選項將不會顯示遊戲內建的任務完成訊息，只會顯示 \"任務完成!\" 或 \"任務失敗!\"。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Red to Green"] = {
        ["ptBR"] = "Vermelho ao verde",
        ["ruRU"] = "От красного к зеленому",
        ["deDE"] = "Rot zu Grün",
        ["koKR"] = "빨간색에서 초록색",
        ["esMX"] = "Rojo a Verde",
        ["enUS"] = true,
        ["zhCN"] = "由红至绿",
        ["zhTW"] = "紅變綠",
        ["esES"] = "Rojo a Verde",
        ["frFR"] = "Rouge à vert",
    },
    ["White"] = {
        ["ptBR"] = "Branco",
        ["ruRU"] = "Белый",
        ["deDE"] = "Weiß",
        ["koKR"] = "하얀색",
        ["esMX"] = "Blanco",
        ["enUS"] = true,
        ["zhCN"] = "白色",
        ["zhTW"] = "白色",
        ["esES"] = "Blanco",
        ["frFR"] = "Blanc",
    },
    ["White and Green"] = {
        ["ptBR"] = "Branco e verde",
        ["ruRU"] = "Белый и зеленый",
        ["deDE"] = "Weiß und Grün",
        ["koKR"] = "하얀색에서 초록색",
        ["esMX"] = "Blanco y Verde",
        ["enUS"] = true,
        ["zhCN"] = "白和绿",
        ["zhTW"] = "白和綠",
        ["esES"] = "Blanco y Verde",
        ["frFR"] = "Blanc et vert",
    },
    ["White to Green"] = {
        ["ptBR"] = "Branco ao verde",
        ["ruRU"] = "От белого к зеленому",
        ["deDE"] = "Weiß zu Grün",
        ["koKR"] = "하얀색에서 초록색",
        ["esMX"] = "Blanco a Verde",
        ["enUS"] = true,
        ["zhCN"] = "由白至绿",
        ["zhTW"] = "白變綠",
        ["esES"] = "Blanco a Verde",
        ["frFR"] = "Blanc à vert",
    },
    ["Minimalistic"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Минимализм",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "极简",
        ["zhTW"] = "極簡",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Objective Sorting"] = {
        ["ptBR"] = "Classificando objetivos",
        ["ruRU"] = "Сортировка целей",
        ["deDE"] = "Questzielsortierung",
        ["koKR"] = "퀘스트 목표 정렬",
        ["esMX"] = "Orden de objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标排序",
        ["zhTW"] = "任務目標排序",
        ["esES"] = "Orden de objetivos",
        ["frFR"] = "Méthode de tri des objectifs :",
    },
    -- Classic and TBC only --
    ["How Objectives are sorted in the Questie Tracker."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выбор типа сортировки целей заданий в трекере",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务目标在列表中如何排序。",
        ["zhTW"] = "任務目標在清單中如何排序。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    -- Wrath of the Lich King only --
    ["How Objectives are sorted in the Questie Tracker.\n\nNOTE: This will not sort Achievements."] = {
        ["ptBR"] = "Como os objectivos são classificadas no Rastreador",
        ["ruRU"] = "Выбор типа сортировки целей заданий в трекере.\n\nПРИМЕЧАНИЕ: Это не сортирует достижения",
        ["deDE"] = "Wie Questziele im Tracker sortiert werden.",
        ["koKR"] = "추적기에서 퀘스트 목표를 어떻게 정렬해서 보여줄지 설정합니다.",
        ["esMX"] = "La manera que se ordena los objetivos en el rastreador.",
        ["enUS"] = true,
        ["zhCN"] = "追踪列表中的任务要如何排序",
        ["zhTW"] = "任務目標在清單中如何排序。\n\n注意: 不會影響成就。",
        ["esES"] = "La manera que se ordena los objetivos en el rastreador.",
        ["frFR"] = "Comment les objectifs sont triés dans le Traqueur",
    },
    ---------------------------------------------------------
    ["By %% Complete"] = {
        ["ptBR"] = false,
        ["ruRU"] = "По %% выполнения",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "按完成度 %%",
        ["zhTW"] = "依完成度 %%",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["By %% Complete (Reversed)"] = {
        ["ptBR"] = false,
        ["ruRU"] = "По %% выполнения (убыв.)",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "按完成度 %%（反向）",
        ["zhTW"] = "依完成度 %% (反向)",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["By Level"] = {
        ["ptBR"] = "Por nivel",
        ["ruRU"] = "По уровню",
        ["deDE"] = "Nach Level",
        ["koKR"] = "레벨 순서",
        ["esMX"] = "Por Nivel",
        ["enUS"] = true,
        ["zhCN"] = "按等级",
        ["zhTW"] = "依等級",
        ["esES"] = "Por Nivel",
        ["frFR"] = "Par niveau",
    },
    ["By Level (Reversed)"] = {
        ["ptBR"] = "Por nível (invertido)",
        ["ruRU"] = "По уровню (убыв.)",
        ["deDE"] = "Nach Level (Absteigend)",
        ["koKR"] = "레벨 순서 (역순)",
        ["esMX"] = "Por Nivel (Inverso)",
        ["enUS"] = true,
        ["zhCN"] = "按等级（反向）",
        ["zhTW"] = "依等級 (反向)",
        ["esES"] = "Por Nivel (Inverso)",
        ["frFR"] = "Par niveau (inversé)",
    },
    ["By Proximity"] = {
        ["ptBR"] = "Por proximidade",
        ["ruRU"] = "По близости",
        ["deDE"] = "Nach Nähe",
        ["koKR"] = "가까운",
        ["esMX"] = "Por proximidad",
        ["enUS"] = true,
        ["zhCN"] = "按远近",
        ["zhTW"] = "依遠近",
        ["esES"] = "Por proximidad",
        ["frFR"] = "Par proximité",
    },
    ["By Proximity (Reversed)"] = {
        ["ptBR"] = false,
        ["ruRU"] = "По близости (убыв.)",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "按远近（反向）",
        ["zhTW"] = "依遠近 (反向)",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["By Zone"] = {
        ["ptBR"] = "Por zona",
        ["ruRU"] = "По игровой зоне",
        ["deDE"] = "Nach Zone",
        ["koKR"] = "지역별",
        ["esMX"] = "Por zona",
        ["enUS"] = true,
        ["zhCN"] = "按区域",
        ["zhTW"] = "依區域",
        ["esES"] = "Por zona",
        ["frFR"] = "Par zone",
    },
    ["By Zone Prox"] = {
        ["ptBR"] = false,
        ["ruRU"] = "По дальности зоны",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "按区域远近",
        ["zhTW"] = "依區域遠近",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["By Zone Prox (Reversed)"] = {
        ["ptBR"] = false,
        ["ruRU"] = "По дальности зоны (убыв.)",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "按区域远近（反向）",
        ["zhTW"] = "依區域遠近 (反向)",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Set |cFF54e33bTomTom|r Target"] = {
        ["ptBR"] = "Defina o alvo |cFF54e33bTomTom|r",
        ["ruRU"] = "Установить точку |cFF54e33bTomTom|r",
        ["deDE"] = "|cFF54e33bTomTom|r-Ziel setzen",
        ["koKR"] = "|cFF54e33bTomTom|r 대상 설정",
        ["esMX"] = "Establecer objetivo de|cFF54e33bTomTom|r",
        ["enUS"] = true,
        ["zhCN"] = "显示|cFF54e33bTomTom|r箭头",
        ["zhTW"] = "|cFF54e33bTomTom|r 開始導航",
        ["esES"] = "Establecer objetivo de|cFF54e33bTomTom|r",
        ["frFR"] = "Définir un point |cFF54e33bTomTom|r",
    },
    -- Classic and TBC only --
    ["This shortcut will set the TomTom arrow to point to either an NPC or the first incomplete Quest Objective (if location data is available)."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Сочетание клавиш для установки точки TomTom либо на NPC, либо на первую невыполненную цель задания (если имеются координаты)",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "此功能会开始 TomTom 导航箭头到 NPC或 第一个未完成的任务目标（如果有位置资料的话）。",
        ["zhTW"] = "此功能會開始 TomTom 導航箭頭到 NPC 或第一個未完成的任務目標 (如果有位置資料的話)。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    -- Wrath of the Lich King only --
    ["This shortcut will set the TomTom arrow to point to either an NPC or the first incomplete Quest Objective (if location data is available).\n\nNOTE: This will not work with Achievements."] = {
        ["ptBR"] = "Atalho para abrir TomTom",
        ["ruRU"] = "Сочетание клавиш для установки точки TomTom либо на NPC, либо на первую невыполненную цель задания (если имеются координаты).\n\nПРИМЕЧАНИЕ: Это не работает с достижениями",
        ["deDE"] = "Der Tracker-Shortcut, um TomTom zu öffnen The tracker shortcut to open TomTom.",
        ["koKR"] = "추적기에서 TomTom 애드온을 여는 단축키를 설정합니다.",
        ["esMX"] = "El atajo del rastreador para abrir TomTom",
        ["enUS"] = true,
        ["zhCN"] = "在任务追踪上开启TomTom的快捷键",
        ["zhTW"] = "此功能會開始 TomTom 導航箭頭到 NPC 或第一個未完成的任務目標 (如果有位置資料的話)。\n\n注意: 無法用於成就。",
        ["esES"] = "El atajo del rastreador para abrir TomTom",
        ["frFR"] = "Définis le raccourci servant à ouvrir TomTom.",
    },
    ---------------------------------------------------------
    -- Classic and TBC only --
    ["Show in Quest Log"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Показать в журнале заданий",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "显示任务日志",
        ["zhTW"] = "顯示任務日誌",
        ["esES"] = false,
        ["frFR"] = false,
    },
    -- Classic and TBC only --
    ["This shortcut will open the Quest Log with the clicked Quest selected."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Сочетание клавиш для открытия задания в журнале заданий",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "此功能会打开任务日志并显示选点的任务。",
        ["zhTW"] = "此功能會打開任務日誌並顯示選點的任務。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only --
    ["Show Quest / Achievement"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Задание / Достижение",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "显示任务 / 成就",
        ["zhTW"] = "顯示任務 / 成就",
        ["esES"] = false,
        ["frFR"] = false,
    },
    -- Wrath of the Lich King only --
    ["This shortcut will open the Quest Log with the clicked Quest selected or open Achievements with the clicked Achievement selected."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Сочетание клавиш для открытия задания в журнале заданий или достижения в окне достижений",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "此功能会打开任务日志并显示选点的任务，或是打开成就窗口并显示选点的成就。",
        ["zhTW"] = "此功能會打開任務日誌並顯示選點的任務，或是打開成就視窗並顯示選點的的成就。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    -- Classic and TBC only --
    ["Untrack / Link Quest"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Отмена / Ссылка",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "取消追踪 / 任务链接",
        ["zhTW"] = "取消追蹤 / 任務連結",
        ["esES"] = false,
        ["frFR"] = false,
    },
    -- Classic and TBC only --
    ["This shortcut removes a Quest from the Questie Tracker when the chat input box is NOT visible, otherwise this will link a Quest to chat."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Сочетание клавиш для отмены отслеживания задания в трекере. Если активно поле ввода чата, то вместо отмены отслеживания в чат отправится ссылка на задание",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "正在聊天視窗打字時，此功能會產生可以貼到聊天視窗的任務連結。不是正在打字時會從任務清單中移除任務。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    -- Wrath of the Lich King only --
    ["Untrack / Link"] = {
        ["ptBR"] = "Remover Rastreio/Vincular missão",
        ["ruRU"] = "Отмена / Ссылка",
        ["deDE"] = "Quest verlinken/entfernen",
        ["koKR"] = "추적종료 / 링크 퀘스트",
        ["esMX"] = "No rastrear/vincular misión",
        ["enUS"] = true,
        ["zhCN"] = "停止追踪 / 链接",
        ["zhTW"] = "取消追蹤 / 任務連結",
        ["esES"] = "No rastrear/vincular misión",
        ["frFR"] = "Ne plus traquer et partager le lien de la quête",
    },
    -- Wrath of the Lich King only --
    ["This shortcut removes a Quest or an Achievement from the Questie Tracker when the chat input box is NOT visible, otherwise this will link a Quest or an Achievement to chat."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Сочетание клавиш для отмены отслеживания задания или достижения в трекере. Если активно поле ввода чата, то вместо отмены отслеживания в чат отправится ссылка на задание или достижение",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "正在聊天窗口打字时，此功能会产生可以点到聊天窗口的任务或者成就链接。不是正在打字时会从任务列表中移除任务或成就。",
        ["zhTW"] = "正在聊天視窗打字時，此功能會產生可以貼到聊天視窗的任務或成就連結。不是正在打字時會從任務清單中移除任務或成就。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Tracker Growth Direction"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Изменение размера трекера",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "列表增长方向",
        ["zhTW"] = "清單增長方向",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["This determines the direction in which the Questie Tracker grows when you add or remove Quests. For example, if you use the 'Up & Right' option then the ideal place for the Tracker should be in the lower left-hand corner of your screen. This allows the 'Sizer Mode: Auto' to push the Tracker Height and Width 'Up & Right' so the Tracker doesn't inadvertently cover up elements of your UI.\n\nNOTE: This will also move the Active Quests Header (if enabled) to the bottom of the Questie Tracker when using the options 'Up & Right' or the 'Up & Left' setting. You can override this behavior by disabling the 'Auto Move Active Quests Header' option to force the Active Quests Header to remain at the top of the Questie Tracker. The 'Auto Move Active Quests Header' option is disabled when the options 'Down & Right' or 'Down & Left' are used."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Определяет направление, в котором изменяется размер трекера при добавлении или удалении заданий. Например, при использовании значения 'Вверх и вправо' идеальным расположением для трекера будет нижний левый угол вашего экрана. Это позволяет сайзеру (изменитель размера трекера) в режиме 'Авто' выставлять высоту и ширину трекера 'Вверх и вправо' так, чтобы трекер случайно не скрыл элементы вашего интерфейса.\n\nПРИМЕЧАНИЕ: Эта настройка также передвинет заголовок 'Активные задания' (если включено) в низ трекера при использовании значения 'Вверх и вправо' или 'Вниз и влево'. Вы можете переопределить данное поведение путем отключения настройки 'Автоперемещение заголовка' для того, чтобы заголовок 'Активные задания' оставался наверху трекера. Настройка 'Автоперемещение заголовка' отключается при использовании значения 'Вниз и вправо' или 'Вниз и влево'",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "新增或移除任务时，任务列表的增长方向。例如：列表在界面的左下方时，可以使用 '上 & 右'，让 '调整大小模式：自动 ' 往 '上 & 右' 调整列表的高度和宽度，列表便不会挡住其他界面清。\n\n注意: 使用 '上 & 右' 和 '上 & 左' 时也会将标题移动到列表下方（如果有启用标题的话），停用 '标题在下方' 选项可以强制让标题保持在列表上方。使用 '下 & 右' 和 '下 & 左' 时会停用 '标题在下方'。",
        ["zhTW"] = "新增或移除任務時，任務清單的延伸方向。例如清單位置在畫面的左下方時，可以使用 '上 & 右'，讓 '調整大小模式: 自動' 往 '上 & 右' 調整清單的高度和寬度，清單便不會擋住其他介面。\n\n注意: 使用 '上 & 右' 和 '上 & 左' 時也會將標題列移動到清單下方 (如果有啟用標題列的話)，停用 '標題列在下方' 選項可以強制讓標題列保持在清單的上方。使用 '下 & 右' 和 '下 & 左' 時會停用 '標題列在下方'。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Up & Right"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Вверх и вправо",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "上 & 右",
        ["zhTW"] = "上 & 右",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Up & Left"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Вверх и влево",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "上 & 左",
        ["zhTW"] = "上 & 左",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Down & Right"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Вниз и вправо",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "下 & 右",
        ["zhTW"] = "下 & 右",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Down & Left"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Вниз и влево",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "下 & 左",
        ["zhTW"] = "下 & 左",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Font Size for Active Quests Header"] = {
        ["ptBR"] = "Tamanho da fonte para missões ativas",
        ["ruRU"] = "Размер шрифта заголовка 'Активные задания'",
        ["deDE"] = "Schriftgröße für aktive Quests",
        ["koKR"] = "활성 퀘스트의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para misiones activas",
        ["enUS"] = true,
        ["zhCN"] = "当前任务字体大小",
        ["zhTW"] = "標題列文字大小",
        ["esES"] = "Tamaño de fuente para misiones activas",
        ["frFR"] = "Taille de police pour les quêtes actives",
    },
    ["The font size used for the Active Quests Header."] = {
        ["ptBR"] = "O tamanho da fonte que o Missões ativas usa.",
        ["ruRU"] = "Размер шрифта, используемого в заголовке трекера",
        ["deDE"] = "Die Schriftgröße die für aktive Quests verwendet wird.",
        ["koKR"] = "Active Quests에서 사용하는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente que utiliza misiones activas.",
        ["enUS"] = true,
        ["zhCN"] = "当前任务使用的字体大小。",
        ["zhTW"] = "標題列文字的字體大小。",
        ["esES"] = "El tamaño de fuente que utiliza misiones activas.",
        ["frFR"] = "Taille de police utilisée par Active Quests.",
    },
    ---------------------------------------------------------
    ["Font for Active Quests Header"] = {
        ["ptBR"] = "Fonte para missões ativas",
        ["ruRU"] = "Шрифт заголовка",
        ["deDE"] = "Schriftart für aktive Quests",
        ["koKR"] = "활성 퀘스트를위한 글꼴",
        ["esMX"] = "Fuente para misiones activas",
        ["enUS"] = true,
        ["zhCN"] = "当前任务的字体",
        ["zhTW"] = "標題列字體",
        ["esES"] = "Fuente para misiones activas",
        ["frFR"] = "Police pour les quêtes actives",
    },
    ["The font used for the Active Quests Header."] = {
        ["ptBR"] = "A fonte Missões ativas usa.",
        ["ruRU"] = "Шрифт, используемый в заголовке 'Активные задания'",
        ["deDE"] = "Die Schriftart die für aktive Quests verwendet wird.",
        ["koKR"] = "액티브 퀘스트 글꼴이 사용합니다.",
        ["esMX"] = "La fuente que utiliza misiones activas.",
        ["enUS"] = true,
        ["zhCN"] = "当前任务使用的字体。",
        ["zhTW"] = "標題列文字的字體。",
        ["esES"] = "La fuente que utiliza misiones activas.",
        ["frFR"] = "La police utilisée par Active Quests.",
    },
    ---------------------------------------------------------
    ["Font Size for Zone Names"] = {
        ["ptBR"] = "Tamanho da fonte para nomes de zonas",
        ["ruRU"] = "Размер шрифта названий игровых зон",
        ["deDE"] = "Schriftgröße für Zonennamen",
        ["koKR"] = "영역 이름의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para nombres de zona",
        ["enUS"] = true,
        ["zhCN"] = "区域名称字体大小",
        ["zhTW"] = "區域名稱文字大小",
        ["esES"] = "Tamaño de fuente para nombres de zona",
        ["frFR"] = "Taille de police pour les noms de zone",
    },
    ["The font size used for zone names."] = {
        ["ptBR"] = "O tamanho da fonte usada para nomes de zonas.",
        ["ruRU"] = "Размер шрифта, используемого в названиях игровых зон",
        ["deDE"] = "Die Schriftgröße die für Zonennamen verwendet wird.",
        ["koKR"] = "영역 이름에 사용되는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente utilizado para los nombres de zona.",
        ["enUS"] = true,
        ["zhCN"] = "区域名称使用的字体大小。",
        ["zhTW"] = "區域名稱文字的字體大小。",
        ["esES"] = "El tamaño de fuente utilizado para los nombres de zona.",
        ["frFR"] = "La taille de police utilisée pour les noms de zone.",
    },
    ---------------------------------------------------------
    ["Font for Zone Names"] = {
        ["ptBR"] = "Fonte para nomes de zonas",
        ["ruRU"] = "Шрифт названий игровых зон",
        ["deDE"] = "Schriftart für Zonennamen",
        ["koKR"] = "영역 이름의 글꼴",
        ["esMX"] = "Fuente para nombres de zona",
        ["enUS"] = true,
        ["zhCN"] = "区域名称字体",
        ["zhTW"] = "區域名稱字體",
        ["esES"] = "Fuente para nombres de zona",
        ["frFR"] = "Police pour les noms de zone",
    },
    ["The font used for zone names."] = {
        ["ptBR"] = "A fonte usada para nomes de zona.",
        ["ruRU"] = "Шрифт, используемый в названиях игровых зон",
        ["deDE"] = "Die Schriftart die für Zonennamen verwendet wird.",
        ["koKR"] = "영역 이름에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los nombres de zona.",
        ["enUS"] = true,
        ["zhCN"] = "区域名称使用的字体",
        ["zhTW"] = "區域名稱文字的字體。",
        ["esES"] = "La fuente utilizada para los nombres de zona.",
        ["frFR"] = "La police utilisée pour les noms de zone.",
    },
    ---------------------------------------------------------
    ["Font Size for Quest Titles"] = {
        ["ptBR"] = "Tamanho da fonte dos títulos das missões",
        ["ruRU"] = "Размер шрифта названий заданий",
        ["deDE"] = "Schriftgröße für Questtitel",
        ["koKR"] = "퀘스트 제목의 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para títulos de búsqueda",
        ["enUS"] = true,
        ["zhCN"] = "任务标题字体大小",
        ["zhTW"] = "任務標題文字大小",
        ["esES"] = "Tamaño de fuente para títulos de búsqueda",
        ["frFR"] = "Taille de police pour les titres de quête",
    },
    ["The font size used for Quest Titles.\n\nNOTE: Objective font size will auto adjust to less than or equal to Quest font size. This is necessary to avoid any text collisions and formatting abnormalities."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Размер шрифта, используемого в названиях заданий.\n\nПРИМЕЧАНИЕ: Размер шрифта целей будет автоматически скорректирован до значения меньше или равно 'Размер шрифта названий заданий'. Это необходимо для того, чтобы избежать любых проблем с текстом и форматированием",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务标题文字的字体大小。\n\n注意: 任务目标文字大小会自动调整为小于或等于任务文字大小大小，这是为了避免任务文字冲突和格式异常而必需的设定。",
        ["zhTW"] = "任務標題文字的字體大小。\n\n注意: 任務目標文字大小會自動調整為小於或等於任務文字大小，這是為了避免任何文字衝突和格式異常而必須的。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ---------------------------------------------------------
    ["Font for Quest Titles"] = {
        ["ptBR"] = "Fonte para títulos de missão",
        ["ruRU"] = "Шрифт названий заданий",
        ["deDE"] = "Schriftart für Questtitel",
        ["koKR"] = "퀘스트 타이틀용 글꼴",
        ["esMX"] = "Fuente para los títulos de misión",
        ["enUS"] = true,
        ["zhCN"] = "任务标题字体",
        ["zhTW"] = "任務標題字體",
        ["esES"] = "Fuente para los títulos de Misión",
        ["frFR"] = "Police pour les titres de quête",
    },
    ["The font used for Quest Titles."] = {
        ["ptBR"] = "A fonte usada para os títulos das missões.",
        ["ruRU"] = "Шрифт, используемый в названиях заданий",
        ["deDE"] = "Die Schriftart die für Questtitel verwendet wird.",
        ["koKR"] = "퀘스트 제목에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los títulos de misiones.",
        ["enUS"] = true,
        ["zhCN"] = "任务标题使用的字体。",
        ["zhTW"] = "任務標題文字的字體。",
        ["esES"] = "La fuente utilizada para los títulos de misiones.",
        ["frFR"] = "La police utilisée pour les titres de quête.",
    },
    ---------------------------------------------------------
    ["Font Size for Objectives"] = {
        ["ptBR"] = "Tamanho da fonte para objetivos",
        ["ruRU"] = "Размер шрифта целей",
        ["deDE"] = "Schriftgröße für Questziele",
        ["koKR"] = "목표를위한 글꼴 크기",
        ["esMX"] = "Tamaño de fuente para objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标字体大小",
        ["zhTW"] = "任務目標文字大小",
        ["esES"] = "Tamaño de fuente para objetivos",
        ["frFR"] = "Taille de police pour les objectifs",
    },
    ["The font size used for Objectives.\n\nNOTE: Objective font size will auto adjust to less than or equal to Quest font size. This is necessary to avoid any text collisions and formatting abnormalities."] = {
        ["ptBR"] = "O tamanho da fonte usada para os objetivos.",
        ["ruRU"] = "Размер шрифта, используемого в наименованиях целей заданий.\n\nПРИМЕЧАНИЕ: Размер шрифта целей будет автоматически скорректирован до значения меньше или равно 'Размер шрифта названий заданий'. Это необходимо для того, чтобы избежать любых проблем с текстом и форматированием",
        ["deDE"] = "Die Schriftgröße die für Questziele verwendet wird.",
        ["koKR"] = "목표에 사용되는 글꼴 크기입니다.",
        ["esMX"] = "El tamaño de fuente utilizado para los objetivos.",
        ["enUS"] = true,
        ["zhCN"] = "用于目标使用的字体大小",
        ["zhTW"] = "任務目標文字的字體大小。",
        ["esES"] = "El tamaño de fuente utilizado para los objetivos.",
        ["frFR"] = "La taille de police utilisée pour les objectifs.",
    },
    ---------------------------------------------------------
    ["Font for Objectives"] = {
        ["ptBR"] = "Fonte para objetivos",
        ["ruRU"] = "Шрифт целей",
        ["deDE"] = "Schriftart für Questziele",
        ["koKR"] = "목표를위한 글꼴",
        ["esMX"] = "Fuente para objetivos",
        ["enUS"] = true,
        ["zhCN"] = "目标字体",
        ["zhTW"] = "任務目標字體",
        ["esES"] = "Fuente para objetivos",
        ["frFR"] = "Police pour objectifs",
    },
    ["The font used for Objectives."] = {
        ["ptBR"] = "A fonte usada para objetivos.",
        ["ruRU"] = "Шрифт, используемый в наименовании целей",
        ["deDE"] = "Die Schriftart die für Questziele verwendet wird.",
        ["koKR"] = "목표에 사용되는 글꼴입니다.",
        ["esMX"] = "La fuente utilizada para los objetivos.",
        ["enUS"] = true,
        ["zhCN"] = "用于目标的字体。",
        ["zhTW"] = "任務目標文字的字體。",
        ["esES"] = "La fuente utilizada para los objetivos.",
        ["frFR"] = "La police utilisée pour les objectifs.",
    },
    ---------------------------------------------------------
    ["Padding Between Quests"] = {
        ["ptBR"] = "Preenchimento entre missões",
        ["ruRU"] = "Отступ между заданиями",
        ["deDE"] = "Abstand zwischen Quests",
        ["koKR"] = "퀘스트간 간격 설정",
        ["esMX"] = "Espaciado ente misiones",
        ["enUS"] = true,
        ["zhCN"] = "任务间距",
        ["zhTW"] = "任務間距",
        ["esES"] = "Espaciado ente misiones",
        ["frFR"] = "Espacement entre les quêtes",
    },
    ["The amount of padding between Quests in the Questie Tracker.\n\nNOTE: Changing this setting while in Sizer Manual Mode will reset the Sizer back to Auto Mode"] = {
        ["ptBR"] = "A quantidade de preenchimento entre missões no Questie Tracker.\n\nOBSERVAÇÃO: Alterar esta configuração no modo Manual do Medidor irá redefinir o Medidor de volta para o Modo Automático",
        ["ruRU"] = "Установка отступа между заданиями в трекере.\n\nПРИМЕЧАНИЕ: Если сайзер (изменитель размера трекера) в ручном режиме, то изменение этой настройки сбросит режим сайзера на автоматический",
        ["deDE"] = "Der Abstand zwischen Quests im Questie-Tracker.\n\nHINWEIS: Wenn Sie diese Einstellung im manuellen Sizer-Modus ändern, wird der Sizer wieder in den automatischen Modus zurückgesetzt",
        ["koKR"] = "Questie Tracker에서 퀘스트 사이의 패딩 양입니다.\n\n참고: Sizer 수동 모드에서 이 설정을 변경하면 Sizer가 다시 자동 모드로 재설정됩니다.",
        ["esMX"] = "La cantidad de relleno entre Quests en Questie Tracker.\n\nNOTA: Cambiar esta configuración mientras está en el modo manual de Sizer restablecerá el Sizer nuevamente al modo automático",
        ["enUS"] = true,
        ["zhCN"] = "Questie Tracker 中任务之间的填充量。\n\n注意：在 Sizer 手动模式下更改此设置会将 Sizer 重置为自动模式",
        ["zhTW"] = "清單中每個任務之間的距離。\n\n注意: 在手動調整大小的模式下更改此設定會重置為自動模式。",
        ["esES"] = "La cantidad de relleno entre Quests en Questie Tracker.\n\nNOTA: Cambiar esta configuración mientras está en el modo manual de Sizer restablecerá el Sizer nuevamente al modo automático",
        ["frFR"] = "La quantité de rembourrage entre les quêtes dans le suivi des quêtes.\n\nREMARQUE : La modification de ce paramètre en mode manuel du calibreur réinitialisera le calibreur en mode automatique.",
    },
    ---------------------------------------------------------
    ["Outline for Zones, Titles, and Objectives"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Обводка шрифта",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "区域、标题和任务目标的文字外框",
        ["zhTW"] = "區域、標題和任務目標的文字外框",
        ["esES"] = false,
        ["frFR"] = "Contours des Zones, des Titres et des Objectifs",
    },
    ["The outline used for Quest Zones, Titles, and Objectives in the Questie Tracker."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Обводка для шрифта названий игровых зон, названий заданий и целей",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "区域、标题和任务目标文字的外框样式。",
        ["zhTW"] = "區域、標題和任務目標文字的外框樣式。",
        ["esES"] = false,
        ["frFR"] = "Contour utilisé pour les zones de quêtes, les titres et les objectifs dans le traqueur",
    },
    ---------------------------------------------------------
    ["Tracker Backdrop Alpha"] = {
        ["ptBR"] = "Alfa do cenário do rastreador",
        ["ruRU"] = "Непрозрачность фона",
        ["deDE"] = "Tracker Hintergrund Alpha",
        ["koKR"] = "트래커 배경 알파",
        ["esMX"] = "Alfa del fondo del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "背景透明度",
        ["zhTW"] = "背景透明度",
        ["esES"] = "Alfa del fondo del rastreador",
        ["frFR"] = "Opacité de l'arrière-plan",
    },
    ["The alpha level of the Questie Trackers backdrop. A setting of 100 percent is fully visible."] = {
        ["ptBR"] = "O nível alfa do cenário do rastreador",
        ["ruRU"] = "Уровень непрозрачности фона трекера",
        ["deDE"] = "Das Alpha-Level des Tracker-Hintergrunds",
        ["koKR"] = "트래커 배경의 알파 수준",
        ["esMX"] = "El nivel alfa del fondo del rastreador",
        ["enUS"] = true,
        ["zhCN"] = "设置背景的透明度",
        ["zhTW"] = "任務清單背景的透明度，100% 是完全不透明。",
        ["esES"] = "El nivel alfa del fondo del rastreador",
        ["frFR"] = "Définis l'opacité de l'arrière-plan du suivi des quêtes Questie.",
    },
    ---------------------------------------------------------
    ["Tracker Height Ratio"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Соотношение высоты трекера",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "列表高度比例",
        ["zhTW"] = "清單高度比例",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The height of the Questie Tracker based on percentage of usable screen height. A setting of 100 percent would make the Tracker fill the players entire screen height.\n\nNOTE: This setting only applies while in Sizer Mode: Auto"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Высота трекера, основанная на процентах от высоты экрана. Значение 100 заставит трекер заполнять всю высоту экрана.\n\nПРИМЕЧАНИЕ: Эта настройка работает только тогда, когда сайзер (изменитель размера трекера) в автоматическом режиме",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "列表高度依据可用的界面高度百分比，100%会让列表和界面一样高。\n\n注意：此设定只在调整大小模式为自动时有效。",
        ["zhTW"] = "清單高度依據可用的畫面高度百分比，100% 會讓清單和畫面一樣高。\n\n注意: 此設定只在調整大小模式為自動時有效。",
        ["esES"] = false,
        ["frFR"] = false,
    },
}

for k, v in pairs(trackerOptionsLocales) do
    l10n.translations[k] = v
end
