-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                          https://tradeskillmaster.com                          --
--    All Rights Reserved - Detailed license information included with addon.     --
-- ------------------------------------------------------------------------------ --

local TSM = select(2, ...) ---@type TSM
local Locale = TSM.Include("Locale")
if not Locale.ShouldLoad("zhTW") then return end
local L = {}

-- LOCALE STRINGS START HERE
L["%d Characters"] = "%d 角色"
L["%d Custom Sources"] = "%d 客製來源"
L["%d Faction-Realms"] = "%d 陣營-服務器"
L["%d Groups"] = "%d 群組"
L["%d Groups Selected"] = "%d 群組已選"
L["%d Guilds"] = "%d 公會"
L["%d Items"] = "%d 物品"
L["%d Operations"] = "%d 作業"
L["%d Players"] = "%d 玩家"
L["%d Professions"] = "%d 個專業技能"
L["%d Rarities"] = "%d 稀有"
L["%d Results"] = "%d 結果"
L["%d Selected"] = "%d 已選"
L["%d Sources"] = "%d 來源"
L["%d Sub-Groups"] = "%d 子群組"
L["%d Types"] = "%d 類型"
L["%d auctions"] = "%d 拍賣"
L["%d groups"] = "%d 群組"
L["%d groups were created and %d items were added from the table."] = "%d 群組已創建，並從表單添加 %d 物品。"
L["%d of %d"] = "發佈 %d 堆，每堆 %d 個"
L["%d subgroups included"] = "包括 %d 子群組"
L["%d |4Group:Groups; Selected (%d |4Item:Items;)"] = "%d|4Group:群組; 已選擇(%d |4項目:項目;)"
L["%s %s Operations"] = "%s %s 作業"
L["%s (%s bags, %s bank, %s AH, %s mail)"] = "%s (%s 包包, %s 銀行, %s 拍賣場, %s 信箱)"
L["%s (%s player, %s alts, %s AH)"] = "%s (%s 玩家, %s 小號, %s 拍賣行)"
L["%s (%s player, %s alts, %s guild, %s AH)"] = "%s (%s玩家, %s小號, %s公會, %s 拍賣行)"
L["%s (%s profit)"] = "%s (%s 利潤)"
L["%s - %s has been reset to default values."] = "%s - %s 已重置爲默認值。"
L["%s Crafts"] = "%s制造"
L["%s Items Bought"] = "%s 進貨"
L["%s Items Cancelled"] = "%s 撤消物品"
L["%s Items Expired"] = "%s 到期品"
L["%s Items Resold"] = "%s 轉售"
L["%s Items Selected"] = "%s 已選物品"
L["%s Items Sold"] = "%s 銷貨"
L["%s Items Total"] = "%s 所有物品"
L["%s Operations"] = "%s 作業"
L["%s Posted Auctions"] = "%s 個拍賣公告"
L["%s Posted Auctions (Filtered)"] = "%s 個拍賣公告（已篩選）"
L["%s Sold Auctions"] = "%s 個售出的拍賣"
L["%s Sold Auctions (Filtered)"] = "%s 個售出的拍賣（已篩選）"
L["%s Total"] = "%s 總值"
L["%s Total Profit"] = "%s 總利潤"
L["%s ago"] = "%s前"
L["%s group is already up to date."] = "%s 群組已準備好更新。"
L["%s group updated with %d items and %d materials."] = "%s 群組已更新 %d 物品和 %d 材料。"
L["%s in guild vault"] = "%s 在公會銀行。"
L["%s is a valid custom price but %s is an invalid item."] = "%s 是一個有效的自定義價格但 %s 是一個無效的物品。"
L["%s is a valid custom price but did not give a value for %s."] = "%s 是一個有效的自定義價格但沒有為 %s 給出一個值。"
L["%s is not a valid custom price and gave the following error: %s"] = "%s 不是一個有效的自定義價格,錯誤資訊: %s"
L["%s is not a valid source."] = "%s is not a valid source."
L["%s operation"] = "%s 作業"
L["%s operations"] = "%s 作業"
L["%s previously had the max number of operations, so removed %s."] = "%s 先前操作量已達最大值，所以移除 %s。"
L["%s removed."] = "%s 移除。"
L["%s sent you %s"] = "%s 發送給你 %s"
L["%s sent you %s and %s"] = "%s 發送給你 %s 和 %s"
L["%s sent you a COD of %s for %s"] = "%s 發送你貨到付款 %s，價格 %s"
L["%s sent you a message: %s"] = "%s 發你訊息: %s"
L["%s total"] = "%s 全部"
L["%sDrag%s to move this button"] = "%s拖曳%s 移動該按紐"
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."] = "%s重要提示：|r 當上次保存本服會計數據時，數據太大，WoW無法處理，爲免損壞保存變量，所以自動清理的舊數據。已保留最後 %s 購買數據。"
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."] = "%s重要提示:|r 當上次保存本服會計數據時，數據太大，WoW無法處理，爲避免損壞保存變量，所以自動清理了舊數據。已保留最後 %s 銷售數據。"
L["%sLeft-Click%s to open the main window"] = "%s左鍵單擊%s 開啟主視窗"
L["%sLeft-Click|r to ignore an item for this session. Hold %sShift|r to ignore permanently. You can remove items from permanent ignore in the Vendoring settings."] = "%s左鍵單擊|r將在此次任務中忽略一個物品。同時按住%sShift|r將永久忽略它。可在NPC商店設置中，從永久忽略列表中移除。"
L["'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."] = "'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."
L["'%s' is not a valid argument for convert()."] = "'%s' is not a valid argument for convert()."
L["'%s' is not a valid item argument."] = "'%s' is not a valid item argument."
L["(%d/500 Characters)"] = "(%d/500 角色)"
L["(minimum 0 - maximum %d)"] = "(最小0-最大%d)"
L["1 Group"] = "1 個群組"
L["1 Item"] = "1 個物品"
L["1D"] = "1天"
L["1M"] = "1月"
L["1W"] = "1週"
L["1Y"] = "1年"
L["2Y"] = "兩年"
L["3M"] = "1季"
L["6M"] = "半年"
L["A custom price of %s for %s evaluates to %s."] = "%s的自定義價格為%s到%s。"
L["A profile with that name already exists on the target account. Rename it first and try again."] = "目標帳戶上已存在同名配置文件。 請改名後重試。"
L["A profile with this name already exists."] = "同名配置文件已存在。"
L["A scan is already in progress. Please stop that scan before starting another one."] = "正在掃描，在開始另一掃描之前，請停止該掃描。"
L["A single craft makes %d and you only need to restock %d."] = "單次製造%d，僅需補貨%d个。"
L["AH"] = "拍賣場"
L["AH (Crafting)"] = "拍賣行（制造業）"
L["AH (Disenchanting)"] = "拍賣場 (分解)"
L["AH BUSY"] = "拍賣行繁忙"
L["AHDB Minimum Bid"] = "AHDB最低競價"
L["AHDB Minimum Buyout"] = "AHDB最低一口價"
L["ALT"] = "ALT"
L["Above max expires."] = "超過上限會過期。"
L["Above max price. Not posting."] = "高於最高價。 不發布。"
L["Above max price. Posting at max."] = "高於最高價。 按最高價發布。"
L["Above max price. Posting at min."] = "高於最高價。 按最低價發布。"
L["Above max price. Posting at normal."] = "高於最高價。 按正常價發布。"
L["Accept COD?"] = "接受貨到付款？"
L["Accepting this item will cost: %s"] = "接受該物品將花費：%s"
L["Account Syncing"] = "帳戶同步"
L["Account sync removed. Please delete the account sync from the other account as well."] = "帳戶同步已刪除。 請同時從另一個帳戶中刪除該帳戶同步。"
L["Accounting"] = "會計"
L["Active"] = "輸入框/選項"
L["Active Alt"] = "搜索框/小標題字體"
L["Activity Type"] = "活動類型"
L["Add"] = "增加"
L["Add %d |4Item:Items"] = "增加 %d  |4物品：物品"
L["Add %s Operation"] = "增加 %s 作業"
L["Add More Operations"] = "增加更多作業"
L["Add Operation"] = "增加作業"
L["Add Subject / Description"] = "添加主題 / 說明"
L["Add a new custom source"] = "增加一個新的客製來源"
L["Add account"] = "增加帳戶"
L["Add operation to groups"] = "增加作業到群組"
L["Add subject & description (optional)"] = "添加主題 & 說明 (可選)"
L["Add to Mail"] = "添加至郵件"
L["Added %s to %s."] = "已將%s添加到%s。"
L["Added '%s' profile which was received from %s."] = "添加了從%s收到的'%s'個人資料。"
L["Additional error suppressed"] = "隱藏的其他錯誤"
L["Adjust how TSM values crafted items when calculating profit."] = "調整TSM在計算利潤時如何估值製造品。"
L["Adjust how crafted items are restocked."] = "調整專業製品補貨方式。"
L["Adjust how items are mailed."] = "調整如何郵寄物品。"
L["Adjust some general settings."] = "調整一些常規設置。"
L["Adjust the settings below to set how groups attached to this operation will be auctioned."] = "調整以下設置以設定如何拍賣與該操作關聯的群組。"
L["Adjust the settings below to set how groups attached to this operation will be cancelled."] = "調整以下設置以設定如何取消此操作的群組。"
L["Adjust the settings below to set how groups attached to this operation will be priced."] = "調整下列設定來制定附加在此作業的群組如何定價。"
L["Advanced Item Search"] = "進階物品搜尋"
L["Alarm Clock"] = "警示鐘"
L["All"] = "所有"
L["All Auctions"] = "所有拍賣"
L["All Bought"] = "購入的拍賣"
L["All Cancelled"] = "撤銷的拍賣"
L["All Characters"] = "所有角色"
L["All Expired"] = "期滿的拍賣"
L["All Faction-Realms"] = "所有陣營-服務器"
L["All Guilds"] = "所有公會"
L["All Item Classes"] = "所有物品類別"
L["All Other"] = "其他所有"
L["All Players"] = "所有玩家"
L["All Professions"] = "所有專業技能"
L["All Rarites"] = "所有稀有"
L["All Rarities"] = "所有稀有"
L["All Selected"] = "所有已選"
L["All Slots"] = "所有插槽"
L["All Sold"] = "所有已售"
L["All Sources"] = "所有來源"
L["All Subclasses"] = "所有子群組"
L["All Time"] = "全部時間"
L["All Types"] = "所有類型"
L["Allow partial stack"] = "允許部分堆疊"
L["Allows for testing of custom prices"] = "允許測試自定義價格"
L["Alt Guild Bank"] = "小號公會銀行"
L["Alts"] = "替代項\\小號"
L["Alts AH"] = "小號拍賣行"
L["Amount"] = "數量"
L["Amount kept in bags"] = "背包持有數量"
L["Amount of bag space to keep free"] = "背包保留可用空間"
L["An old TSM addon was found installed. Please remove %s and any other old TSM addons to avoid issues."] = "發現安裝有舊的TSM插件。請刪除%s和任何其他舊的TSM插件，以避免出現問題。"
L["App Not Synced"] = "程式未同步"
L["App Synced %s Ago"] = "程式已同步 %s"
L["Appearance"] = "外觀"
L["Apply operation to group"] = "套用作業到群組"
L["Are you sure you want to clear accounting data older than %d days for the currenet realm?"] = "Are you sure you want to clear accounting data older than %d days for the currenet realm?"
L["Are you sure you want to delete the selected operations?"] = "你確定要刪除所選作業嗎？"
L["Are you sure you want to delete this operation?"] = "你確定要刪除這個作業嗎?"
L["At above max price and not undercut."] = "你的售價高於設定最高價格，但仍然是市場最低價"
L["At normal price and not undercut."] = "你的售價是你設定的正常價格，同時也是市場最低價"
L["Attachments"] = "附件"
L["Auction"] = "拍賣"
L["Auction House Cut"] = "拍賣費"
L["Auction House Sounds"] = "拍賣場音效"
L["Auction Window Close"] = "關閉拍賣視窗"
L["Auction Window Open"] = "開啟拍賣視窗"
L["Auction duration"] = "拍賣競標時間"
L["Auction has been bid on."] = "拍賣已結標"
L["Auction sale sound"] = "拍賣賣出音效"
L["AuctionDB"] = "AuctionDB"
L["AuctionDB - Historical Price"] = "AuctionDB - Historical Price"
L["AuctionDB - Market Value"] = "AuctionDB - 市值"
L["AuctionDB - Minimum Buyout"] = "AuctionDB - 最低一口價"
L["AuctionDB - Recent Value"] = "AuctionDB - Recent Value"
L["AuctionDB - Region Historical Price"] = "AuctionDB - Region Historical Price"
L["AuctionDB - Region Market Value Average"] = "AuctionDB - Region Market Value Average"
L["AuctionDB - Region Sale Average"] = "AuctionDB - Region Sale Average"
L["AuctionDB - Region Sale Rate"] = "AuctionDB - Region Sale Rate"
L["AuctionDB - Region Sold Per Day"] = "AuctionDB - Region Sold Per Day"
L["AuctionDB Realm Data is %s Old"] = "AuctionDB 服務器數據是 %s 舊的。"
L["AuctionDB Region Data is %s Old"] = "AuctionDB 區域數據是 %s 舊的。"
L["Auctionator - Auction Value"] = "Auctionator - 拍賣價格"
L["Auctioneer - Appraiser"] = "Auctioneer - 出價"
L["Auctioneer - Market Value"] = "Auctioneer - 市值"
L["Auctioneer - Minimum Buyout"] = "Auctioneer - 最小直購價"
L["Auctioning"] = "拍賣"
L["Auctioning %s button"] = "拍賣 %s 按钮"
L["Auctioning Details"] = "拍賣細節"
L["Auctioning Log"] = "拍賣日誌"
L["Auctioning Operation"] = "拍賣作業"
L["Auctioning operation"] = "拍賣作業"
L["Auctioning operations control posting to and canceling from the AH."] = "拍賣作業控制著拍賣場的發佈與撤銷."
L["Auctions"] = "拍賣"
L["Auto Quest Complete"] = "自動完成任務"
L["Auto-focus browse search input"] = "自動選定搜索框"
L["Average Earned per Day"] = "日均收益"
L["Average Prices:"] = "平均價格："
L["Average Profit per Day"] = "日均利潤"
L["Average Spent per Day"] = "日均支出"
L["Avg Buy Price"] = "平均進價"
L["Avg Profit"] = "平均利潤"
L["Avg Sell Price"] = "平均售價"
L["BUSY"] = "繁忙"
L["BUY"] = "購買"
L["Back"] = "上一頁"
L["Bag"] = "背包"
L["Bags"] = "背包"
L["Bank"] = "Bank"
L["Banking"] = "銀行業務"
L["Banks"] = "銀行"
L["Base Group"] = "基礎群組"
L["Base Item"] = "基本物品"
L["Below is a list of all available price sources, along with a brief description of what they represent."] = "以下是可用價格源列表，並對它們代表的含義附有簡短的描述"
L["Below min price. Posting at max."] = "低於最低價。以最高價發佈。"
L["Below min price. Posting at min."] = "低於最低價。以最低價發佈。"
L["Below min price. Posting at normal."] = "低於最低價。以正常價發佈。"
L["Below you can ignore this operation on certain characters or realms."] = "以下你可以指定在角色和服務器忽略的操作。"
L["Bid %d / %d"] = "競拍 %d / %d"
L["Bid (item)"] = "出價（物品）"
L["Bid (stack)"] = "競拍（堆疊）"
L["Bid (total)"] = "競拍（總計）"
L["Bid / Buyout"] = "競價/一口價"
L["Bid Auction"] = "競拍"
L["Bid Price"] = "出價金額"
L["Bid Sniper Paused"] = "競標狙擊已暫停"
L["Bid Sniper Running"] = "競標狙擊運行"
L["Bid percent must be between 0 and 100."] = "競價比例必須在0到100之間。"
L["Bidding Auction"] = "競標拍賣"
L["Blacklisted players"] = "黑名單玩家"
L["Bought"] = "購貨"
L["Bought %d of %s from %s for %s"] = "買入 %d 個 %s，從%s ，價格  %s"
L["Bought %sx%d for %s from %s"] = "購買 %s x %d 共 %s 從 %s"
L["Bound Actions"] = "限制操作"
L["Browse"] = "瀏覽"
L["Browse / Sniper"] = "瀏覽 / 狙擊"
L["Buy"] = "購買"
L["Buy %d / %d"] = "購買%d/%d"
L["Buy %d / %d (Confirming %d / %d)"] = "購買%d/%d（確認中%d/%d）"
L["Buy Auction"] = "競拍"
L["Buy Commodity"] = "購買商品"
L["Buy Commodity (%02d)"] = "Buy Commodity (%02d)"
L["Buy Groups"] = "購買群組"
L["Buy Options"] = "購買選項"
L["Buy from AH"] = "從拍賣行購買"
L["Buy from AH (Crafting)"] = "從拍賣行購買（製造）"
L["Buy from AH (Disenchant)"] = "從拍賣行購買（分解）"
L["Buy from Vendor"] = "向NPC購買"
L["Buyback All"] = "全部購回"
L["Buyer/Seller"] = "買方/賣方"
L["Buyout"] = "一口價"
L["Buyout (item)"] = "直購（物品）"
L["Buyout (stack)"] = "一口價（堆疊）"
L["Buyout (total)"] = "一口價（總計）"
L["Buyout Above Threshold"] = "Buyout Above Threshold"
L["Buyout Price"] = "直購價"
L["Buyout Sniper Paused"] = "一口價狙擊暫停"
L["Buyout Sniper Running"] = "一口價狙擊運行"
L["Buyout confirmation alert"] = "一口價確認警告"
L["COD"] = "COD貨到付款"
L["CRAFT"] = "製造"
L["CRAFTING"] = "製造"
L["CTRL"] = "CTRL"
L["Can't load TSM tooltip while in combat"] = "戰鬥中無法載入TSM提示"
L["Cancel"] = "取消"
L["Cancel %d / %d"] = "取消 %d / %d"
L["Cancel Auction"] = "取消拍賣"
L["Cancel Scan"] = "取消掃描"
L["Cancel auctions with bids"] = "取消已被競標的拍賣"
L["Cancel or Post"] = "取消或發佈"
L["Cancel to repost higher"] = "取消並以更高價格發佈"
L["Cancel undercut auctions"] = "取消非最低價的拍賣"
L["Canceled information"] = "被取消的信息"
L["Canceling"] = "撤銷"
L["Canceling %d / %d"] = "取消中  %d / %d"
L["Canceling %d Auctions..."] = "取消 %d 拍賣..."
L["Canceling Options"] = "撤銷選項"
L["Canceling auction you've undercut."] = "取消被壓價的拍賣"
L["Canceling disabled."] = "取消被禁用。"
L["Canceling to repost at higher price."] = "取消並以更高價格重新發佈。"
L["Canceling to repost at reset price."] = "取消並以重設價格重新發佈。"
L["Canceling to repost higher."] = "取消並以更高價格發佈。"
L["Canceling undercut auctions and to repost higher."] = "取消非最低價的拍賣並以更有利潤的價格發佈"
L["Canceling undercut auctions."] = "取消非最低價的拍賣（保證金不退）"
L["Cancelled"] = "取消"
L["Cancelled Since Last Sale"] = "自上次售出後取消"
L["Cancelled auction of %sx%d"] = "取消%sx%d的拍賣"
L["Cancelled:"] = "已取消："
L["Cannot repair from the guild bank!"] = "無法從公會銀行修理"
L["Cannot use additional filters with /crafting or /disenchant."] = "在/crafting 或 /disenchant 後不能添加額外篩選命令。"
L["Cash Register"] = "收銀臺"
L["Changes to the specified profile (i.e. '/tsm profile Default' changes to the 'Default' profile)"] = "切換至指定的配置文件（如：'/tsm profile Default' 切換至 'Default' 配置文件）"
L["Character"] = "角色"
L["Chat Tab"] = "聊天標籤"
L["Cheapest auction below min price."] = "低於最低價不發佈"
L["Clear All"] = "清除全部"
L["Clear Data"] = "清除資料"
L["Clear Filters"] = "清除篩選"
L["Clear Old Data"] = "清除舊資料"
L["Clear Old Data?"] = "清除舊資料?"
L["Click and drag to resize this window."] = "點擊並拖曳來調整視窗大小."
L["Click to hide this item for the current session. Hold shift to hide this item permanently."] = "單擊以隱藏當前會話的此項。按住Shift鍵可永久隱藏該項目。"
L["Coins (%s)"] = "貨幣 (%s)"
L["Combine Partial Stacks"] = "合併堆疊"
L["Combining..."] = "合併中..."
L["Confirm"] = "確認"
L["Confirm complete sound"] = "確認完成音效"
L["Confirmation %s button"] = "確認 %s 按鈕"
L["Confirming %d / %d"] = "確認中 %d / %d"
L["Confirming..."] = "Confirming..."
L["Connected to %s"] = "已連接 %s"
L["Connecting to %s"] = "正在連接 %s"
L["Contacts"] = "聯絡簿"
L["Contains auctions above your alert threshold!"] = "包含高於您的驚爆閾值的拍賣！"
L["Contains auctions above your material value!"] = "Contains auctions above your material value!"
L["Convert Value (%s)"] = "Convert Value (%s)"
L["Cooldown"] = "冷卻"
L["Cooldowns"] = "冷卻"
L["Copy Letter"] = "複製信件"
L["Cost"] = "成本"
L["Could not create macro as you already have too many. Delete one of your existing macros and try again."] = "無法創建宏，因爲你的宏已經滿了。刪除一個現有宏後重試。"
L["Could not find profile '%s'. Possible profiles: '%s'"] = "找不到配置文件 '%s' 。可能的配置文件：'%s' 。"
L["Could not sell items due to not having free bag space available to split a stack of items."] = "由於沒有可用分開堆疊物品的空餘背包空間，因此無法出售物品。"
L["Craft"] = "製造"
L["Craft (Profitable)"] = "製造（有利潤）"
L["Craft (Unprofitable)"] = "製造（無利潤）"
L["Craft Next"] = "製造下一個"
L["Craft Value"] = "製造價值"
L["Craft Vellum"] = "Craft Vellum"
L["Crafted Items"] = "製成品"
L["Crafter"] = "製造者"
L["Crafting"] = "製造"
L["Crafting %s button"] = "製造 %s 按鈕"
L["Crafting Cost"] = "製造成本"
L["Crafting Material Cost"] = "製造材料成本"
L["Crafting Mode"] = "製造模式"
L["Crafting UI Improvements"] = "Crafting UI Improvements"
L["Crafting Value"] = "製造價值"
L["Crafting cost"] = "製造成本"
L["Crafting operation"] = "製造作業"
L["Crafting operations control how queuing profession crafts."] = "製造作業控制製造專業如何排隊。"
L["Crafts"] = "製造品"
L["Create Groups from Table"] = "從表單創建群組"
L["Create New"] = "建立新檔"
L["Create New Group"] = "建立新群組"
L["Create New Operation"] = "建立新作業"
L["Create Profession Groups"] = "創建專業群組"
L["Create macro"] = "建立巨集"
L["Create new profile"] = "創建新配置文件"
L["Current Price"] = "當前價"
L["Custom"] = "自定義"
L["Custom Price"] = "自定義價格"
L["Custom Source"] = "自定義來源"
L["Custom Sources"] = "客製來源"
L["Custom Theme"] = "自定義主題"
L["Custom price name %s already exists."] = "自定義價格名稱 %s 已經存在。"
L["Custom price name %s is a reserved word which cannot be used."] = "自定義價格名稱 %s 是保留字段，無法使用。"
L["Custom price names can only contain lowercase letters."] = "自定義價格名稱只能包含小寫字母。"
L["Custom source (%s)"] = "自定義來源 (%s)"
L["Custom sources allow you to create more advanced prices for use throughout the addon. You'll be able to use these new variables in the same way you can use the built-in price sources such as %s and %s."] = "客製來源允許你建立更進階的價格在整個addon裡使用. 你將可以使用這些新的變數就如同你可以使用內建的價格來源一樣, 例如 %s 與 %s."
L["DAILY PURCHASES"] = "日進貨數"
L["DAILY SALES"] = "日銷售數"
L["Dalaran"] = "達拉然"
L["Dashboard"] = "儀錶板"
L["Default Price"] = "默認價格"
L["Default craft value method"] = "默認製成品估價方法"
L["Default material cost method"] = "預設材料成本方案"
L["Default price configuration"] = "預設價格配置"
L["Define what priority Gathering gives certain sources."] = "給確定源定義收集優先級"
L["Delete %d Operations"] = "刪除 %d 作業"
L["Delete Group?"] = "刪除群組?"
L["Delete Operation?"] = "刪除作業?"
L["Delete Operations"] = "刪除作業"
L["Delete Operations?"] = "刪除作業?"
L["Delete Profile?"] = "刪除配置文件？"
L["Delete Record?"] = "刪除記錄？"
L["Delete the profile"] = "刪除這個配置文件"
L["Deleting this group (%s) will also remove any sub-groups attached to this group."] = "刪除這個群組(%s)也同時會移除這個群組內的子群組."
L["Deposit"] = "保證金"
L["Deposit Cost"] = "保證金費用"
L["Deposit reagents"] = "存放到材料銀行"
L["Deselect All"] = "取消全選"
L["Destroy Next"] = "立即分解"
L["Destroy Value"] = "分解價值"
L["Destroy value"] = "分解價值"
L["Destroy value source"] = "分解價值來源"
L["Destroying"] = "分解"
L["Destroying %s button"] = "分解 %s 按鈕"
L["Destroying will ignore %s permanently. You can remove it from the ignored list in the settings."] = "分解工具將永久忽略%s。 你可以在設置中將該物品移除忽略列表。"
L["Destroying will ignore %s until you log out."] = "分解工具將在登出前忽略%s。"
L["Destroying..."] = "分解..."
L["Detailed crafting cost"] = "詳細製造成本"
L["Details"] = "細節"
L["Did not cancel %s because your cancel to repost threshold (%s) is invalid. Check your settings."] = "未取消%s，因爲你的取消並重新發佈的閾值(%s)無效，請檢查你的設置。"
L["Did not cancel %s because your maximum price (%s) is invalid. Check your settings."] = "未取消%s，因爲你的最高價格(%s)無效。請檢查你的設置。"
L["Did not cancel %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "未取消%s，因為你的最高價格(%s)低於最低價格(%s)。請檢查你的設置。"
L["Did not cancel %s because your minimum price (%s) is invalid. Check your settings."] = "未取消%s，因爲你的最低價(%s)無效。請檢查你的設置。"
L["Did not cancel %s because your normal price (%s) is invalid. Check your settings."] = "未取消%s，因爲你的正常價(%s)無效。請檢查你的設置。"
L["Did not cancel %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "未取消%s，因爲你的正常價(%s)低於你的最低價 (%s)。請檢查你的設置。"
L["Did not cancel %s because your undercut (%s) is invalid. Check your settings."] = "未取消%s，因爲你的壓價 (%s)無效。請檢查你的設置。"
L["Did not change prices due to an invalid bid or buyout value."] = "未修改價格，存在無效的標定價格或一口價。"
L["Did not post %s because Blizzard didn't provide all necessary information for it. Try again later."] = "未發佈%s，因爲暴雪未提供全部必要的信息。請稍後重試。"
L["Did not post %s because the owner of the lowest auction (%s) is on both the blacklist and whitelist which is not allowed. Adjust your settings to correct this issue."] = "未發佈%s，因爲不允許最低價拍賣者（%s）同時出現在黑名單和白名單上。修改你的設置來更正這個問題。"
L["Did not post %s because you or one of your alts (%s) is on the blacklist which is not allowed. Remove this character from your blacklist."] = "未發佈%s，因爲不允許你或者你的小號（%s）在黑名單中。請從黑名單移除這個角色。"
L["Did not post %s because your keep quantity (%s) is invalid. Check your settings."] = "未發佈%s，因爲你的保留量（%s）無效。請檢查設置。"
L["Did not post %s because your max expires (%s) is invalid. Check your settings."] = "未發佈%s，因爲你的最長過期時間（%s）無效。請檢查設置。"
L["Did not post %s because your maximum price (%s) is invalid. Check your settings."] = "未發佈%s，因爲你的最高價（%s）無效。請檢查設置。"
L["Did not post %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "未發佈%s，因爲你的最高價（%s）低於最低價（%s）。請檢查設置。"
L["Did not post %s because your minimum price (%s) is invalid. Check your settings."] = "未發佈%s，因爲你的最低價（%s）無效。請檢查設置。"
L["Did not post %s because your normal price (%s) is invalid. Check your settings."] = "未發佈%s，因爲你的正常價（%s）無效。請檢查設置。"
L["Did not post %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "未發佈%s，因爲你的正常價（%s）低於最低價（%s）。請檢查設置。"
L["Did not post %s because your post cap (%s) is invalid. Check your settings."] = "未發佈%s，因爲你的最大發佈數目（%s）無效。請檢查設置。"
L["Did not post %s because your stack size (%s) is invalid. Check your settings."] = "未發佈%s，因爲你的堆疊大小（%s）無效。請檢查設置。"
L["Did not post %s because your undercut (%s) is invalid. Check your settings."] = "未發佈%s，因爲你的壓價（%s）無效。請檢查設置。"
L["Disable invalid price warnings"] = "禁用無效價格提醒"
L["Disenchant Search"] = "分解搜索"
L["Disenchant Search Options"] = "分解搜索選項"
L["Disenchant Value"] = "分解價值"
L["Disenchanting Options"] = "分解選項"
L["Display total money received in chat"] = "在聊天欄顯示收取的總金額"
L["Don't Post Items"] = "不發佈物品"
L["Don't post after this many expires"] = "多少次過期後就不再公告"
L["Don't prompt to record trades"] = "不立即記錄交易"
L["Done Canceling"] = "取消完成"
L["Done Posting"] = "發佈完成"
L["Done Scanning"] = "完成掃瞄"
L["Done rebuilding item cache."] = "重建物品緩存完成"
L["Down"] = "下"
L["Duplicate the profile"] = "複製配置文件"
L["Duration"] = "持續時間"
L["Duskwood"] = "暮色森林"
L["EXPENSES"] = "費用"
L["Edit"] = "編輯"
L["Edit Post"] = "編輯發佈"
L["Embed TSM tooltip"] = "嵌入TSM 提示"
L["Empty bags"] = "清空背包"
L["Empty price string."] = "清空價格字串。"
L["Enable TSM tooltips"] = "開啟 TSM 提示框"
L["Enable automatic stack combination"] = "啓用自動堆疊"
L["Enable buying"] = "啓用購買"
L["Enable inbox chat messages"] = "啓用收件箱聊天信息"
L["Enable region-wide trading (requires reload)"] = "Enable region-wide trading (requires reload)"
L["Enable restock"] = "啓用補貨"
L["Enable selling"] = "啓用銷售"
L["Enable sending chat messages"] = "啓用發郵件聊天信息"
L["Enchant"] = "附魔"
L["Ensure both characters are online and try again."] = "確認角色都在線然後重試。"
L["Enter Filter"] = "輸入篩選"
L["Enter Keyword"] = "輸入關鍵字"
L["Enter a value from %d - %d"] = "輸入%d - %d的值"
L["Enter a value from %d - %d%%"] = "輸入%d - %d%%的值"
L["Enter name of logged-in character on other account"] = "輸入其他賬戶已登錄角色名"
L["Enter player name"] = "輸入玩家名稱"
L["Enter profile name"] = "輸入配置名稱"
L["Enter recipient name"] = "輸入收件人名稱"
L["Establishing connection to %s. Make sure that you've entered this character's name on the other account."] = "正在與%s建立連接，請確保你在其他賬戶上輸入過這個角色名。"
L["Establishing connection..."] = "正在建立連接..."
L["Estimated Profit"] = "Estimated Profit"
L["Estimated Time"] = "Estimated Time"
L["Estimated deliver time"] = "預計交付時間"
L["Exact Match"] = "完全匹配"
L["Example"] = "示例"
L["Example Item"] = "示例物品"
L["Example Tooltip"] = "提示框範例"
L["Exclude custom sources?"] = "排除客製來源?"
L["Exclude operations?"] = "排除作業?"
L["Exit"] = "離開"
L["Expand / Collapse All Groups"] = "展開 / 摺疊所有群組"
L["Expenses"] = "費用"
L["Expirations"] = "到期"
L["Expired"] = "到期"
L["Expired Auctions"] = "到期拍賣"
L["Expired Since Last Sale"] = "自上次銷售起過期"
L["Expired information"] = "過期信息"
L["Expires"] = "信件保留時間"
L["Expires Since Last Sale"] = "自上次銷售起過期"
L["Expiring Mails"] = "過期郵件"
L["Exploration"] = "探測"
L["Export"] = "匯出"
L["Export Custom Theme"] = "匯出定製主題"
L["Export String"] = "匯出字符串"
L["Export theme"] = "匯出主題"
L["Export this group"] = "匯出這個群組"
L["Failed Auctions"] = "流標"
L["Failed to bid on auction of %s (x%s) for %s."] = "無法在%s（x%s）的拍賣中爲%s出價。"
L["Failed to bid on auction of %s."] = "未能在%s拍賣中出價。"
L["Failed to buy auction of %s (x%s) for %s."] = "購買%s（x%s）拍賣失敗，出價爲%s。"
L["Failed to buy auction of %s."] = "購買%s拍賣失敗。"
L["Failed to buy auction."] = "購買拍賣失敗"
L["Failed to cancel auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "因拍賣行繁忙無法取消拍賣。請確認沒有其他插件正在掃描拍賣行，然後重試。"
L["Failed to find auction for %s, so removing it from the results."] = "從拍賣行找不到%s，故從結果中刪除它。"
L["Failed to move group, as a group with the same name already exists in the target location."] = "Failed to move group, as a group with the same name already exists in the target location."
L["Failed to post %sx%d as the item no longer exists in your bags."] = "無法發佈%sx%d，因爲該物品已經不在你背包中。"
L["Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."
L["Failed to send profile."] = "發送配置文件失敗。"
L["Failed to send profile. Ensure both characters are online and try again."] = "發送配置文件失敗。請確保角色都在線，然後重試。"
L["Failed to start sniper. No groups have a Sniper operation applied."] = "無法開始狙擊。因爲沒有群組設置了狙擊作業。"
L["Favorite Scans"] = "收藏的掃描"
L["Favorite Searches"] = "喜愛的搜索"
L["Favorited Patterns"] = "喜愛的配方"
L["Filter by Keyword"] = "以關鍵字篩選"
L["Filter by Price Source"] = "以價格來源篩選"
L["Filter by Profession"] = "以專業技能篩選"
L["Filter by duration"] = "以競標時間篩選"
L["Filter by groups"] = "以群組篩選"
L["Filter by keyword"] = "以關鍵字篩選"
L["Filter group item lists based on the following price source"] = "以下列價格來源篩選群組物品清單"
L["Finding Selected Auction"] = "查找選定的拍賣"
L["First Auctioning Operation Max Price"] = "首次拍賣最高價"
L["First Auctioning Operation Min Price"] = "首次拍賣最低價"
L["First Auctioning Operation Normal Price"] = "首次拍賣正常價"
L["Fishing Reel In"] = "釣魚卷軸"
L["For more info, visit %s. For help, join us in Discord: %s."] = "更多信息，請到 %s。 尋求幫助，請在Discord: %s加入我們。"
L["Forget Character"] = "遺忘角色"
L["Found auction sound"] = "找到拍賣音效"
L["Frame"] = "框體"
L["Friends"] = "好友"
L["From"] = "來自"
L["Full convert tooltip"] = "Full convert tooltip"
L["Full destroy tooltip"] = "Full destroy tooltip"
L["Full inventory"] = "全部庫存"
L["GVault"] = "公會銀行"
L["Garrison"] = "要塞"
L["Gathering"] = "採集"
L["Gathering Search"] = "採集搜索"
L["Gathering Setup"] = "採集設定"
L["General Options"] = "常規選項"
L["General Settings"] = "一般設定"
L["Get from Bank"] = "從銀行獲得"
L["Get from Guild Bank"] = "從公會銀行獲得"
L["Gets items from the bank or guild bank matching the item or partial text entered."] = "從銀行或公會銀行獲取與輸入的物品名或部分文字匹配的物品。"
L["Gold"] = "金幣"
L["Great Deals Search"] = "大的最划算交易搜索"
L["Group Management"] = "群組管理"
L["Group Search"] = "群組搜索"
L["Group already exists."] = "群組已存在。"
L["Group name"] = "群組名稱"
L["Grouped Items"] = "已入群組的物品"
L["Grouping Pets by Level"] = "Grouping Pets by Level"
L["Groups"] = "群組"
L["Groups & Operations"] = "群組 & 作業"
L["Groups Using"] = "在用群組"
L["Guild"] = "公會"
L["Guild Bank"] = "公會銀行"
L["HIGH"] = "高點"
L["Have"] = "擁有"
L["Have Mats"] = "有材料"
L["Have Skill Ups"] = "技能可提升"
L["Here you can add/remove what groups this operation is attached to."] = "在這裏你可以添加/移除某個分組到該作業。"
L["Hide Columns"] = "隱藏直欄"
L["Hide auctions with bids"] = "隱藏已競標拍賣"
L["Hide minimap icon"] = "隱藏小地圖圖示"
L["Hiding the TSM Banking UI. Type '/tsm bankui' to reopen it."] = "隱藏TSM銀行助手,輸入'/tsm bankui' 可重新打開。"
L["Hiding the TSM Task List UI. Type '/tsm tasklist' to reopen it."] = "隱藏TSM任務清單。輸入 '/tsm tasklist' 可重新打開。"
L["High Bidder"] = "高出價者"
L["Historical Price"] = "歷史價格"
L["Historical price"] = "歷史價格"
L["Hold ALT to repair from the guild bank."] = "按住ALT鍵從公會銀行修理"
L["Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."] = "按住SHIFT鍵可在“%s”之後自動重發郵件，按住CTRL键可演示一次，該演示僅在聊天消息顯示結果並不實際寄出。"
L["Hold SHIFT to continue after the inbox refreshes"] = "按住SHIFT可在收件箱刷新後繼續"
L["Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."] = "按住SHIFT键可在收件箱刷新後繼續，按住CTRL键可不打開附有金幣的郵件。"
L["Hold SHIFT to not continue after the inbox refreshes"] = "按住SHIFT以在收件箱刷新後不繼續。"
L["Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."] = "按住SHFIT以在收件箱刷新後不繼續，按住CTRL以不打開附有金幣的郵件。"
L["Hold SHIFT while dragging to scale the window instead."] = "拖曳時按住SHIFT鍵來調整視窗尺寸與字體大小。"
L["Hold shift to move the items to the parent group instead of removing them."] = "按住SHIFT可將物品移到父組，而不是移除他們。"
L["Hr"] = "小時"
L["Hrs"] = "小時"
L["If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."] = "If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."
L["If you have multiple profiles set up with operations, enabling this will cause all but the current profile's operations to be irreversibly lost."] = "如果您有多個配置文件設置了作業，啓用此選項將導致除當前配置文件外的所有作業不可逆轉地丟失。"
L["Ignore Auctions Below Min"] = "忽略最低價以下的拍賣"
L["Ignore Characters"] = "忽略角色"
L["Ignore Guilds"] = "忽略公會"
L["Ignore auctions by duration"] = "按持續時間忽略拍賣"
L["Ignore operation on characters"] = "在角色上忽略作業"
L["Ignore operation on faction-realms"] = "在陣營伺服器上忽略作業"
L["Ignored Cooldowns"] = "忽略冷卻"
L["Ignored Items"] = "忽略物品"
L["Import"] = "匯入"
L["Import Groups & Operations"] = "匯入群組 & 作業"
L["Import String"] = "匯入字串"
L["Import Summary"] = "匯入總覽"
L["Import Theme"] = "匯入主題"
L["Import group"] = "匯入群組"
L["Imported Group"] = "已匯入群組"
L["Imported group (%s) with %d items, %d operations, and %d custom sources."] = "已匯入群組（%s），含有 %d 物品，%d 作業， 和 %d 客製來源。"
L["In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."] = "In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."
L["Inbox Settings"] = "收件設定"
L["Include operations?"] = "包刮作業?"
L["Include soulbound items"] = "包含靈魂綁定的物品"
L["Information"] = "資訊"
L["Invalid Quantity"] = "無效數量"
L["Invalid custom price source for %s. %s"] = "無效的自定義價格源%s. %s"
L["Invalid custom price."] = "無效的自定義價格。"
L["Invalid group name."] = "無效群組名。"
L["Invalid numeric value."] = "無效數值"
L["Invalid operation name."] = "無效作業名稱"
L["Invalid player name."] = "無效玩家名稱。"
L["Invalid price."] = "無效價格。"
L["Invalid search filter (%s)."] = "無效搜索篩選(%s)。"
L["Invalid search term."] = "無效搜索字詞。"
L["Invalid search term. Cannot filter by price here."] = "無效搜索詞。這裏不能用價格篩選。"
L["Invalid seller data returned by server."] = "伺服器返回無效的賣家數據。"
L["Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."] = "無效壓價。設置你的壓價爲0銅幣，以達到不壓價且發佈在現在最低拍賣價之前。"
L["Inventory"] = "存貨"
L["Inventory / Gold Graph"] = "庫存 / 金幣 圖表"
L["Inventory Options"] = "存貨選項"
L["It appears that you've manually copied your saved variables between accounts which will cause TSM's automatic sync'ing to not work. You'll need to undo this, and/or delete the TradeSkillMaster saved variables files on both accounts (with WoW closed) in order to fix this."] = "你似乎在賬號間手動複製了SavedVariables，導致TSM的自動同步無法工作。你需要撤銷此更改，並/或 刪除這些賬號的TSM SavedVariables來修復此問題（需先關閉魔獸世界）。"
L["Item"] = "物品"
L["Item Class"] = "物品類別"
L["Item Level"] = "物品等級"
L["Item Level Range"] = "物品等級範圍"
L["Item Name"] = "物品名稱"
L["Item Quality"] = "物品品質"
L["Item Selection"] = "物品選擇"
L["Item Slot"] = "物品插槽"
L["Item Subclass"] = "物品子類"
L["Item Value"] = "物品價值"
L["Item/Group is invalid (see chat)."] = "物品/群組無效（見對話視窗）。"
L["Items"] = "物品"
L["Items Using"] = "在用物品"
L["Keep in bags quantity"] = "背包保留數量"
L["Keep in bank quantity"] = "銀行保留數量"
L["Keep quantity"] = "保留數量"
L["Keep this amount"] = "保留這個數量"
L["Keeping %d."] = "保留 %d 。"
L["Keeping undercut auctions posted."] = "保持發佈的低價拍賣。"
L["LEAST GROUPS"] = "最少群組"
L["LEAST ITEMS"] = "最少物品"
L["LOW"] = "低點"
L["Last 14 Days"] = "過去14天"
L["Last 3 Days"] = "過去3天"
L["Last 30 Days"] = "過去30天"
L["Last 60 Days"] = "過去60天"
L["Last 7 Days"] = "過去7天"
L["Last Purchased"] = "上次買入"
L["Last Sold"] = "上次售出"
L["Ledger"] = "分類賬簿"
L["Level Up"] = "升級"
L["Limit"] = "限制"
L["Link to Another Operation"] = "連接到另一個作業"
L["Lock Column Width"] = "鎖定直欄寬度"
L["Lock task list's background"] = "鎖定後臺任務列表"
L["Looks like TradeSkillMaster has encountered an error. Please help the author fix this error by following the instructions shown."] = "看起來TradeSkillMaster似乎發生了一個錯誤。請按照下列指示協助作者修正此問題。"
L["Loop detected in the following custom price:"] = "在以下自定義價格中循環檢測："
L["Lowest auction by whitelisted player."] = "最低價拍賣爲白名單玩家。"
L["MAX"] = "MAX"
L["MOST GROUPS"] = "最多群組"
L["MOST ITEMS"] = "最多物品"
L["MOVE"] = "移動"
L["MOVING"] = "移動"
L["Macro Setup"] = "建立巨集"
L["Macro created and scroll wheel bound!"] = "已創建宏並綁定滑鼠滾輪！"
L["Macros"] = "巨集"
L["Mail"] = "信箱"
L["Mail Disenchantables"] = "郵寄可分解物品"
L["Mail Selected Groups"] = "郵寄已選群組"
L["Mail Selected Groups (Auto Resend)"] = "郵寄所選群組（自動複寄）"
L["Mail Selected Groups (Dry Run + Auto Resend)"] = "郵寄所選群組（試運行+自動複寄）"
L["Mail Selected Groups (Dry Run)"] = "郵寄所選群組（試運行）"
L["Mail disenchantables max quality"] = "郵寄可分解物品的最高品質"
L["Mail to %s"] = "郵寄給 %s"
L["Mailing"] = "郵務"
L["Mailing all to %s."] = "郵寄所有給 %s 。"
L["Mailing operation"] = "郵務作業"
L["Mailing operations control mailing to other characters."] = "郵寄作業控制如何給其他角色發郵件。"
L["Mailing up to %d to %s."] = "郵寄最多 %d  給 %s 。"
L["Make Cash On Delivery?"] = "付款取信?"
L["Make Operations Global?"] = "是作業全局化？"
L["Management Options"] = "管理選項"
L["Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."] = "Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."
L["Many commonly-used actions in TSM can be added to a macro and bound to your scroll wheel. Use the options below to setup this macro and scroll wheel binding."] = "TSM許多動作可以添加巨集並綁定滑鼠滾輪。使用以下選項以創建巨集並綁定滑鼠滾輪。"
L["Map Ping"] = "地圖Ping"
L["Market Value"] = "市值"
L["Market Value Price Source"] = "市值價格來源"
L["Market value"] = "市值"
L["Market value and trend"] = "Market value and trend"
L["Market value price source"] = "市值價格來源"
L["Mat Price"] = "材料價格"
L["Mat cost"] = "原材料成本"
L["Match stack size"] = "匹配堆疊大小"
L["Match whitelisted players"] = "符合白名單玩家"
L["Material Cost"] = "材料成本"
L["Materials"] = "材料"
L["Materials to Gather"] = "需收集材料"
L["Max"] = "最大"
L["Max Buy Price"] = "最高進價"
L["Max Price"] = "最高價格"
L["Max Sell Price"] = "最高售價"
L["Max Shopping Price"] = "最高商店價格"
L["Max destroy value (Enter '0c' to disable)"] = "最高分解價值 (輸入 '0c' 禁用)"
L["Max expires to bank"] = "最大到期存銀行"
L["Max market value (Enter '0c' to disable)"] = "最高市值（輸入'0c'為關閉）"
L["Max quantity"] = "最大數量"
L["Max shopping price"] = "最高商店價格"
L["Max sniper price"] = "最高狙擊價格"
L["Maximum Quantity to Buy"] = "最高買入量"
L["Maximum amount already posted."] = "已發佈的最大數量"
L["Maximum auction price"] = "最高拍賣價格"
L["Maximum disenchant level"] = "最高分解等級"
L["Maximum disenchant quality"] = "最高分解品質"
L["Maximum disenchant search percent"] = "最高分解搜索百分比"
L["Maximum price"] = "最高價格"
L["Maximum restock quantity"] = "最大補貨數量"
L["Midnight"] = "午夜"
L["Mill"] = "Mill"
L["Mill Value"] = "研磨價值"
L["Min"] = "最小"
L["Min 0 - Max 20"] = "最少 0 - 最多 20"
L["Min 0.5 - Max 10"] = "最小 0.5 - 最大 10"
L["Min Buy Price"] = "最低進價"
L["Min Buyout"] = "最低一口價"
L["Min Sell Price"] = "最低售價"
L["Min buyout"] = "最低一口價"
L["Min number of expires"] = "最小過期數"
L["Min profit amount"] = "最低利潤"
L["Min/Normal/Max Prices"] = "最低/正常/最高 價格"
L["Min/Normal/Max price"] = "最低/正常/最高 價格"
L["Minimum Rarity"] = "最低稀有品質"
L["Minimum disenchant level"] = "最低分解等級"
L["Minimum price"] = "發佈的最低價格（提示：例如不要低於成本+拍賣行手續費）"
L["Minimum restock quantity"] = "Minimum restock quantity"
L["Missing Materials"] = "缺少材料"
L["Modifiers"] = "修飾鍵"
L["Money Frame Open"] = "金钱框体打开"
L["Money Transfer"] = "轉移金錢"
L["Move %d already grouped items?"] = "移動 %d 已分群組物品？"
L["Move %d |4Item:Items"] = "移動 %d |4 物品:物品"
L["Move Item"] = "移動物品"
L["Move Quantity Options"] = "移動數量選項"
L["Move all to Bags"] = "搬移全部到背包"
L["Move to Parent Group"] = "移到父群組"
L["Move to bags"] = "移到背包"
L["Move to bank"] = "移到銀行"
L["Moving"] = "移動"
L["Multiple Items"] = "多個物品"
L["Must be between %d and %s."] = "必須在 %d 和 %s 之間。"
L["My Auctions"] = "我的拍賣"
L["My Auctions %s button"] = "我的拍賣 %s 按鈕"
L["NEED MATS"] = "需要材料"
L["NO ITEMS"] = "無物品"
L["NOT OPEN"] = "未打開"
L["NOTE: The import contained %d invalid items which were ignored."] = "提示：匯入包含%d 無效物品，已忽略。"
L["NOTE: The import contained %d operations with at least one invalid setting which was reset."] = "注意：匯入中有%d作業，至少含有一個已重置的無效設定。"
L["NPC"] = "NPC"
L["Name"] = "名稱"
L["New Group"] = "新群組"
L["New Operation"] = "新作業"
L["News & Information"] = "新聞訊息"
L["No Attachments"] = "沒有附件"
L["No AuctionDB Realm Data"] = "無AuctionDB伺服器數據"
L["No AuctionDB Region Data"] = "無AuctionDB區域數據"
L["No Characters"] = "無角色"
L["No Faction-Realms"] = "無陣營-伺服器"
L["No Guilds"] = "無公會"
L["No Materials to Gather"] = "無需收集的材料"
L["No Operation Selected"] = "無已選作業"
L["No Players"] = "無玩家"
L["No Profession Opened"] = "無開啟的專業技能"
L["No Professions"] = "無專業技能"
L["No Rarities"] = "沒有稀有"
L["No Sound"] = "無音效"
L["No Sources"] = "無來源"
L["No Types"] = "無類型"
L["No group selected"] = "未選擇群組"
L["No item specified. Usage: /tsm restock_help [ITEM_LINK]"] = "未指定物品。 用法：/tsm restock help [物品鏈接]"
L["No posting."] = "無正在發佈。"
L["No profile specified. Possible profiles: '%s'"] = "無指定配置。可能的配置： '%s'"
L["No recent AuctionDB scan data found."] = "未找到最近的AuctionDB掃描數據"
L["No recipe selected"] = "No recipe selected"
L["No value was returned by the custom price for the specified item."] = "定製價格來源未返回指定物品的價值。"
L["No, cancel"] = "No, cancel"
L["None"] = "無"
L["None (Always Show)"] = "無 (總是顯示)"
L["None Selected"] = "未選"
L["Nongroup to bank"] = "未分群組存銀行"
L["Normal price"] = "正常價格"
L["Not Connected"] = "未連接上"
L["Not Enough Money"] = "金額不足"
L["Not Scanned"] = "未掃描的"
L["Not canceling auction at reset price."] = "不取消轉賣價格的拍賣。"
L["Not canceling auction below min price."] = "不取消低於最低價的拍賣。"
L["Not canceling."] = "不取消"
L["Not enough items in bags."] = "背包物品不足。"
L["Not enough money to cancel."] = "沒有足夠的金幣以取消。"
L["Nothing to move."] = "無物可移動。"
L["Nothing to send."] = "無物可郵寄。"
L["Number Owned"] = "擁有的數量"
L["Number of days"] = "Number of days"
L["OPEN"] = "開啟"
L["Offline"] = "下線"
L["On Cooldown for %s"] = "On Cooldown for %s"
L["Only show craftable"] = "只顯示可製造物品"
L["Only show items with disenchant values above this price"] = "只顯示分解價值在這個價格之上的物品"
L["Only show sold auctions"] = "只顯示已出售的拍賣"
L["Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."] = "Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."
L["Open All Mail"] = "開啟全部郵件"
L["Open All Mail Without Money"] = "打開所有沒有金幣的郵件"
L["Open Mail"] = "開啟郵件"
L["Open Mail Without Money"] = "打開無金幣郵件"
L["Open Task List"] = "打開任務列表"
L["Open mail complete sound"] = "開啟郵件完成音效"
L["Opens the Destroying frame if there's stuff in your bags to be destroyed."] = "背包有可分解物品時，打開TSM分解窗口。"
L["Operation"] = "作業"
L["Operations"] = "作業"
L["Options specific to Sniper are below."] = "以下是狙擊選項。"
L["Order Confirmation"] = "訂單確認"
L["Orgrimmar"] = "奧格瑞瑪"
L["Oribos Exchange Realm Price"] = "Oribos Exchange Realm Price"
L["Oribos Exchange Region Price"] = "Oribos Exchange Region Price"
L["Other"] = "其他"
L["Other Character"] = "其他角色"
L["Override Parent Operations"] = "覆蓋父作業"
L["Override default craft value"] = "覆蓋默認製造價值"
L["PROFIT"] = "利潤"
L["Parent Items"] = "父項目"
L["Pausing Scan..."] = "掃描暫停中..."
L["Per Item"] = "每項"
L["Per Stack"] = "每堆疊"
L["Performing a dry-run of your Mailing operations for the selected groups."] = "爲選定群組演示郵寄作業。"
L["Player Gold"] = "玩家金錢"
L["Player Invite Accept"] = "接受玩家邀請"
L["Post"] = "發佈"
L["Post / Cancel"] = "發佈 / 取消"
L["Post Auction"] = "發佈拍賣"
L["Post Items from Bags"] = "發佈背包裡的物品"
L["Post Quantity"] = "發佈數量"
L["Post Scan"] = "發佈掃描"
L["Post Selected"] = "發佈所選"
L["Post at Maximum Price"] = "以最高價格發佈"
L["Post at Minimum Price"] = "以最低價格發佈"
L["Post at Normal Price"] = "以正常價格發佈"
L["Post cap"] = "發佈上限"
L["Post cap to bags"] = "從背包發佈最大數量"
L["Post from Shopping Scan"] = "從購買掃描發佈"
L["Postage"] = "郵資"
L["Posted at whitelisted player's price."] = "按白名單玩家價格發佈。"
L["Posted:"] = "已發佈："
L["Posting"] = "發佈中"
L["Posting %d / %d"] = "發佈中 %d / %d"
L["Posting %d items for %s hours."] = "發佈 %d 物品 %s 小時。"
L["Posting %d stack(s) of %d for %s hours."] = "發佈 %d堆，每堆%d，%s小時。"
L["Posting Options"] = "發佈選項"
L["Posting Price"] = "發佈價格"
L["Posting at normal price."] = "以正常價格發佈。"
L["Posting at whitelisted player's price."] = "正以白名單玩家價格發佈。"
L["Posting at your current price."] = "以你目前的價格發佈。"
L["Posting disabled."] = "禁用發佈。"
L["Posts"] = "發佈"
L["Potential"] = "潛在"
L["Prepare Bid"] = "準備競價"
L["Prepare Buy"] = "準備購買"
L["Preparing..."] = "準備中..."
L["Prevent closing the Auction House with the esc key"] = "禁用ESC關閉拍賣行"
L["Primary"] = "背景色"
L["Primary Alt"] = "次級背景色"
L["Prints out the available price sources for use in custom prices"] = "輸出可用的價格源，以用於自定義價格"
L["Prints out the version numbers of all installed modules"] = "輸出已安裝模組的版本號"
L["Prints the slash command help listing"] = "輸出斜槓命令幫助列表"
L["Profession"] = "專業技能"
L["Profession Info"] = "專業技能信息"
L["Professions Used In"] = "涉及專業"
L["Profile changed to '%s'."] = "配置文件變爲：“%s”。"
L["Profiles"] = "配置檔"
L["Profit"] = "利潤"
L["Profit (Total)"] = "利潤（總計）"
L["Prospect"] = "Prospect"
L["Prospect Value"] = "預期價格"
L["Purchase"] = "購買"
L["Purchase / Sale Info"] = "購買 / 銷售 信息"
L["Purchase Data"] = "購買數據"
L["Purchase Item"] = "購買物品"
L["Purchase information"] = "購買信息"
L["Purchased (Min/Avg/Max Price)"] = "買入（最小/平均/最高價格）"
L["Purchased (Total Price)"] = "買入（總價）"
L["Purchases"] = "進貨"
L["Purchasing Auction"] = "從拍賣行購買"
L["Puts items matching the item or partial text entered into the bank or guild bank."] = "將與輸入的物品或部分文本匹配的物品放入銀行或公會銀行。"
L["Qty"] = "數量"
L["Quantity"] = "數量"
L["Quantity Purchased:"] = "已買入數量："
L["Quantity Sold:"] = "已銷售數量："
L["Quantity to move"] = "需移動數量"
L["Quest Added"] = "任務已添加"
L["Quest Completed"] = "任務已完成"
L["Quest Objectives Complete"] = "任務目標完成"
L["Queue"] = "隊列"
L["Queue (%d)"] = "Queue (%d)"
L["Queue Summary"] = "Queue Summary"
L["Quickly mail all excess disenchantable items to a character"] = "快速將所有多餘的可分解物品郵寄給一個角色"
L["Quickly mail all excess gold (limited to a certain amount) to a character"] = "快速將所有多餘的金幣（限定一個數量）郵寄給一個角色。"
L["Raid Warning"] = "副本警告"
L["Rank %d"] = "等級 %d"
L["Read More"] = "閱讀更多"
L["Ready Check"] = "準備好檢查"
L["Ready to Cancel"] = "準備撤銷"
L["Reagent Quality"] = "Reagent Quality"
L["Recent"] = "最近"
L["Recent Scans"] = "最近掃描"
L["Recent Searches"] = "最近的搜索"
L["Recent Value"] = "Recent Value"
L["Recent value"] = "Recent value"
L["Recipe Name"] = "配方名稱"
L["Recipient"] = "收件人"
L["Region Avg Daily Sold"] = "區域平均每日出售"
L["Region Historical Price"] = "區域歷史價格"
L["Region Market Value Avg"] = "區域市場平均價"
L["Region Sale Avg"] = "區域平均銷量"
L["Region Sale Rate"] = "區域成交率"
L["Region avg daily sold"] = "區域平均每日出售"
L["Region historical price"] = "區域歷史價格"
L["Region market value"] = "區域市場價"
L["Region market value and trend"] = "Region market value and trend"
L["Region sale avg"] = "區域平均銷量"
L["Region sale rate"] = "區域成交率"
L["Reload"] = "重載"
L["Reload UI (%02d)"] = "重載 (%02d)"
L["Reload UI (%d)"] = "重載 (%d)"
L["Remove"] = "移除"
L["Remove %d |4Item:Items"] = "移除 %d |4物品:物品"
L["Remove Data Older Than (Days)"] = "清除超過(天)的舊資料"
L["Remove this account sync and all synced data from this account"] = "刪除該賬號同步和從該賬號同步的所有數據"
L["Removed a total of %s old records."] = "共移除 %s 舊記錄"
L["Removed custom price source (%s) which has an invalid name."] = "移除名稱無效的自定義價格源（%s）。"
L["Rename"] = "重新命名"
L["Rename Profile"] = "重命名配置文件"
L["Rename Search"] = "重命名搜索名"
L["Rename the profile"] = "重命名這個配置文件名"
L["Rename this group"] = "重新命名這個群組"
L["Repair"] = "修理物品"
L["Repair Bill"] = "修繕費"
L["Repair from Guild Bank"] = "公會銀行修理"
L["Replace %d existing operations and %d existing custom sources?"] = "是否替換%d 現有作業和 %d 現有價格來源？"
L["Replace %d existing operations?"] = "替代 %d 存在的作業?"
L["Reply"] = "回覆"
L["Report Spam"] = "垃圾信回報"
L["Reports"] = "報告"
L["Repost threshold"] = "更高價格重新發佈的閾值"
L["Required Level"] = "所需等級"
L["Required Level Range"] = "所需等級範圍"
L["Resale"] = "轉售"
L["Rescan"] = "重新掃描"
L["Reset"] = "重置"
L["Reset All Filters"] = "重置所有篩選器"
L["Reset Filters"] = "重置篩選"
L["Reset Operation?"] = "重置作業?"
L["Reset Profile?"] = "重置配置文件"
L["Reset Table"] = "重置表格"
L["Reset Zoom"] = "重置縮放"
L["Reset the current profile to default settings"] = "重置當前配置爲默認設置"
L["Reset to Default"] = "重置爲默認"
L["Resetting the operation will return all inputs back to default and cannot be unddone. Click confirm to reset."] = "重置這項操作將會把所有已輸入內容還原至默認設置且不能被撤銷。點擊確認以重置。"
L["Restart"] = "重啓"
L["Restart delay (minutes)"] = "延後重啓（分鐘）"
L["Restock Groups"] = "Restock Groups"
L["Restock Options"] = "補貨選項"
L["Restock TSM Groups"] = "Restock TSM Groups"
L["Restock bags"] = "背包補貨"
L["Restock help for %s: %s"] = "補貨幫助 %s: %s"
L["Restock quantity"] = "補貨數量"
L["Restock target to max quantity"] = "補貨至最大數量"
L["Restocking to %d."] = "補貨至 %d。"
L["Restocking with a min profit."] = "按最小利潤補貨。"
L["Restocking with no min profit."] = "無最低利潤補貨。"
L["Restore bags"] = "恢復背包"
L["Resuming Scan..."] = "繼續掃描..."
L["Retail Region-Wide Tracking"] = "Retail Region-Wide Tracking"
L["Retrying %d auction(s) which failed."] = "重試 %d 失敗的拍賣"
L["Revenue"] = "收入"
L["Right-Click to reset the window size, scale, and position to their defaults."] = "按右鍵使視窗尺寸, 字體大小, 與視窗位置回到預設值."
L["Run Advanced Item Search"] = "高級物品搜索"
L["Run Bid Sniper"] = "運行狙擊競價"
L["Run Buyout Sniper"] = "運行狙擊一口價"
L["Run Cancel Scan"] = "執行撤銷掃描"
L["Run Post Scan"] = "執行發佈掃描"
L["Run Shopping Scan"] = "執行商店掃描"
L["Running Sniper Scan"] = "執行狙擊掃描"
L["SALES"] = "銷貨收入"
L["SCAN ALL"] = "全部掃描"
L["SCANNING"] = "掃描中"
L["SENDING"] = "發送中"
L["SHIFT"] = "SHIFT"
L["SOURCE %d"] = "來源 %d"
L["Sale"] = "出售"
L["Sale Data"] = "出售數據"
L["Sale Price"] = "售價"
L["Sale Rate"] = "成交率"
L["Sale information"] = "出售信息"
L["Sale rate"] = "成交率"
L["Sales"] = "銷貨收入"
L["Salvage"] = "Salvage"
L["Save & Close"] = "Save & Close"
L["Saved"] = "Saved"
L["Scan"] = "掃描"
L["Scan Paused"] = "暫停掃描"
L["Scan complete sound"] = "掃描完成音效"
L["Scan was slowed down by %s seconds by other AH addons (%s seconds by %s)."] = "其他AH插件將掃描速度減慢了 %s 秒 (%s 秒 因 %s)。"
L["Scanning"] = "掃描中"
L["Scanning (%d Items)"] = "掃描中（%d 物品）"
L["Scroll Wheel Options"] = "滾輪選項"
L["Scroll wheel direction"] = "滾輪方向"
L["Search"] = "搜尋"
L["Search %s operations"] = "搜尋 %s 作業"
L["Search Bags"] = "搜索背包"
L["Search Groups"] = "搜尋群組"
L["Search Operations"] = "搜尋作業"
L["Search Patterns"] = "搜尋配方"
L["Search Results"] = "搜索結果"
L["Search Vendor"] = "搜尋賣主"
L["Search items"] = "搜尋物品"
L["Search items in group"] = "搜尋群組中的物品"
L["Search items in mailbox"] = "搜尋郵箱裡的物品"
L["Search the auction house"] = "搜尋拍賣場"
L["Select / Deselect All Groups"] = "全選 / 不選 所有組"
L["Select / Deselect All Items"] = "全選 / 不選 所有物品"
L["Select / Deselect All Results"] = "全選 / 不選 所有結果"
L["Select Action"] = "選擇行動"
L["Select All"] = "全選"
L["Select Auction to Cancel"] = "選擇要撤銷的拍賣"
L["Select Crafted Item Quality"] = "Select Crafted Item Quality"
L["Select Group"] = "選擇群組"
L["Select Items to Attach"] = "選擇物品附上"
L["Select a Source"] = "選擇一個來源"
L["Select an Auction to Buy"] = "選擇一個拍賣並購買"
L["Select crafter"] = "選擇製造者"
L["Select included subgroups"] = "選擇包含子群組"
L["Select professions"] = "選擇專業"
L["Selected Items (%d)"] = "Selected Items (%d)"
L["Sell"] = "出售"
L["Sell All"] = "出售所有"
L["Sell BoEs"] = "銷售裝備綁定物品"
L["Sell Groups"] = "出售群組"
L["Sell Options"] = "出售選項"
L["Sell Trash"] = "出售垃圾"
L["Sell soulbound items"] = "出售靈魂綁定物品"
L["Sell to Vendor"] = "賣給商人"
L["Seller"] = "賣家"
L["Selling soulbound items."] = "出售靈魂綁定物品"
L["Send"] = "發送"
L["Send Disenchantables"] = "郵寄可分解物品"
L["Send Excess Gold to Banker"] = "郵寄多餘金幣給銀行號"
L["Send Gold"] = "寄送金額"
L["Send Mail"] = "發送郵件"
L["Send Money"] = "寄送金錢"
L["Send grouped items individually"] = "單獨郵寄分組物品"
L["Send your active profile to this synced account"] = "發送你的現用配置文件給同步賬號"
L["Sender"] = "寄件人"
L["Sending %s to %s"] = "發送%s到%s"
L["Sending %s to %s with a COD of %s"] = "發送%s 給 %s，到付金額爲%s"
L["Sending Settings"] = "送件設定"
L["Sending your '%s' profile to %s. Please keep both characters online until this completes. This will take approximately: %s"] = "正在發送你的 '%s' 配置文件給 %s。請保持角色都在線，直到完成。將花費大約時間：%s"
L["Sending..."] = "發送中..."
L["Set bid as percentage of buyout"] = "設定出價為直購價的百分比"
L["Set how items are moved out of the bank."] = "設置物品如何從銀行移出。"
L["Set how items are restocked from the bank."] = "設置物品如何從銀行補貨。"
L["Set keep in bags quantity"] = "設置背包保留數量"
L["Set keep in bank quantity"] = "設置銀行保留數量"
L["Set max quantity"] = "設置最大數量"
L["Set min profit"] = "設置最小利潤"
L["Set move quantity"] = "設置移動數量"
L["Set stack size"] = "設置堆疊大小"
L["Set stack size for restock"] = "爲補貨設置堆疊大小"
L["Set what is bought from a vendor."] = "設置從商店買入。"
L["Set what is sold to a vendor."] = "設置把什麼賣給商店。"
L["Set what items are shown during a Shopping scan."] = "設置在購物掃描期間顯示的項目。"
L["Set what items are shown during a Sniper scan."] = "設置在狙擊掃描期間顯示的項目。"
L["Set your active profile or create a new one."] = "設置當前配置或創建一個新配置。"
L["Settings"] = "設定"
L["Setup various sounds that play when doing Auctioning scans."] = "設定在拍賣掃描時播放的各種音效."
L["Share operations between all profiles"] = "Share operations between all profiles"
L["Shopping"] = "購買"
L["Shopping %s button"] = "購買 %s 按鈕"
L["Shopping Operation Max Price"] = "購買作業最高限價"
L["Shopping for auctions including those above the max price."] = "購買拍賣品（包括那些高於最高價的）"
L["Shopping for auctions with a max price set."] = "購買拍賣品（在最高價限定下）。"
L["Shopping operation"] = "購買作業"
L["Shopping operations control buyout from the AH."] = "購買作業控制如何從AH買入。"
L["Shortfall to bags"] = "背包短缺"
L["Show auctions above max price"] = "顯示高於最高限價的拍賣"
L["Show confirmation alert if buyout is above the alert price"] = "在購買高於警示價格時，顯示確認警示。"
L["Show destroying frame automatically"] = "自動顯示分解框體"
L["Show on modifier"] = "按修飾鍵顯示（Alt、Ctrl、Shift）"
L["Show only auctions with bids"] = "僅顯示有競價的拍賣"
L["Show results as:"] = "結果顯示為："
L["Show total gold in header"] = "在頂部顯示總金幣"
L["Show ungrouped items as:"] = "無群組物品顯示爲："
L["Showing %s Mail"] = "顯示 %s 郵件"
L["Showing %s of %d Mail"] = "顯示 %s 第 %d 郵件"
L["Showing %s of %d Mails"] = "顯示 %s 共 %d 郵件"
L["Showing all %s Mails"] = "顯示所有 %s 郵件"
L["Simple convert tooltip"] = "Simple convert tooltip"
L["Simple destroy tooltip"] = "Simple destroy tooltip"
L["Simple inventory"] = "簡單庫存"
L["Skip"] = "略過"
L["Skipped:"] = "略過:"
L["Skipped: No assigned operation"] = "略過：未分配作業"
L["Slash Commands:"] = "斜線命令列表："
L["Smart Avg Buy Price"] = "智能平均買入價"
L["Sniper"] = "狙擊"
L["Sniper %s button"] = "狙擊 %s 按鈕"
L["Sniper Below Price"] = "狙擊低於價格"
L["Sniper Operation Below Price"] = "狙擊作業低於價格"
L["Sniper Options"] = "狙擊選項"
L["Sniper operation"] = "狙擊作業"
L["Sniper operations control sniping from the AH."] = "狙擊作業控制從拍賣行狙擊。"
L["Sniping items below a max price"] = "狙擊物品低於最高價"
L["Sold"] = "售出"
L["Sold %d of %s to %s for %s"] = "售出 %d 個 %s 給 %s，售價 %s"
L["Sold %s worth of items."] = "出售價值 %s 的物品。"
L["Sold (Min/Avg/Max Price)"] = "出售（最低/平均/最高 價格）"
L["Sold (Total Price)"] = "出售（總價）"
L["Sold [%s]x%d for %s to %s"] = "販售 [%s] x %d 共 %s 給 %s"
L["Sold for:"] = "售出共："
L["Some general Accounting options are below."] = "下列是一些一般會計選項."
L["Some general Auctioning options are below."] = "下列是一些一般拍賣選項."
L["Some general Browse/Sniper options are below."] = "下列是一些一般瀏覽/狙擊選項."
L["Some general TSM options are below."] = "下面是一些一般TSM選項."
L["Some general appearance options are below."] = "下列是一些一般外觀選項."
L["Some general options for the TSM tooltip information are below."] = "以下是TSM鼠標提示信息一般選項。"
L["Some options for the Disenchant Search are below."] = "以下是一些分解搜索選項。"
L["Source"] = "來源"
L["Sources"] = "來源"
L["Sources to include for restock"] = "需包含的補貨來源"
L["Specific Item"] = "指定物品"
L["Stack"] = "堆疊"
L["Stack / Quantity"] = "堆疊 / 數量"
L["Stack size"] = "堆疊大小"
L["Stack size multiple"] = "多個堆疊大小"
L["Stack(s)"] = "堆疊"
L["Start either a 'Buyout' or 'Bid' sniper using the buttons above."] = "使用上面按鈕啓動“一口價” 或 “競標價”狙擊搜索。"
L["Starting Scan..."] = "開始掃描..."
L["Stormwind"] = "暴風城"
L["String"] = "字串"
L["Subject"] = "主題"
L["Subject & Description added"] = "添加主題 & 說明"
L["Successfully sent your '%s' profile to %s!"] = "發送你的'%s' 配置文件給 %s成功！"
L["Supported value range: %d - %d"] = "支援數值範圍: %d - %d"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["Switch to %s"] = "切換至 %s"
L["Sync Setup Error: The specified player on the other account is not currently online."] = "同步設置錯誤：其他賬戶的指定角色目前離線。"
L["Sync Setup Error: This character is already part of a known account."] = "同步設置錯誤：這個角色已經在已知賬戶中。"
L["Sync Setup Error: You entered the name of the current character and not the character on the other account."] = "同步設置錯誤：你輸入的是當前角色名，而不是另一個賬號的角色名。"
L["Sync Status"] = "同步狀態"
L["TOP PURCHASE"] = "最高進貨額"
L["TOP SALE"] = "最高銷售額"
L["TSM %s: What's new"] = "TSM %s: 新變化"
L["TSM Accounting"] = "TSM 會計"
L["TSM AuctionDB"] = "TSM 拍賣數據庫"
L["TSM Auctioning"] = "TSM 拍賣"
L["TSM Crafting"] = "TSM 製造"
L["TSM Desktop App Status (%s)"] = "TSM桌面程式狀態（%s）"
L["TSM General Info"] = "TSM 一般資訊"
L["TSM Shopping"] = "TSM購物"
L["TSM Sniper"] = "TSM狙擊"
L["TSM TASK LIST"] = "TSM 任務清單"
L["TSM Version Info:"] = "TSM 版本資訊："
L["TSM can automatically sync data between multiple WoW accounts."] = "TSM能自動在多個WoW帳戶間同步資料。"
L["TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"] = "TSM檢測到您剛剛將%s交易給%s以換取%s。您想讓會計模塊保存這筆交易的記錄嗎？"
L["TSM doesn't currently have any AuctionDB pricing data for your realm. We recommend you download the TSM Desktop Application from %s to automatically update your AuctionDB data (and auto-backup your TSM settings)."] = "TSM现無本服AuctionDB。請從%s下載TSM程式，更新AuctionDB、自動備份TSM設置（限美歐服）。"
L["TSM failed to scan some auctions. Please rerun the scan."] = "TSM未能掃描有些拍賣。請重新運行掃描。"
L["TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."] = "TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."
L["TSM is missing important information from the TSM Desktop Application. Please ensure the TSM Desktop Application is running and is properly configured."] = "TSM缺少TSM桌面程式的重要訊息。請確保TSM桌面程式正在運行且正確配置。"
L["TSM is not yet ready to establish a new sync connection. Please try again later."] = "TSM尚未準備好建立新的同步連接。請稍後重試。"
L["TSM will not undercut any players you add to your whitelist."] = "TSM將不會對你白名單中的玩家做削價。"
L["TSM4"] = "TSM4"
L["Target character"] = "目標角色"
L["Target shortfall to bags"] = "目標背包短缺"
L["Tasks Added to Task List"] = "任務已添加至任務列表"
L["Tells you why a specific item is not being restocked and added to the queue."] = "告知你某個物品爲什麼沒有補貨，也沒有添加到隊列。"
L["Text (%s)"] = "文字 (%s)"
L["The '%s' function has an invalid number of arguments."] = "The '%s' function has an invalid number of arguments."
L["The '%s' item parameter was used outside of a custom source."] = "The '%s' item parameter was used outside of a custom source."
L["The 'Craft Value Method' did not return a value for this item."] = "“製成品估價方法“沒有給出該物品的估值"
L["The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."] = "TSM移除了 '智能平均買入價' 設定， 並替換爲新的 '智能平均購入SmartAvgBuy'價格來源。 請恰當的更新你的自定義價格。"
L["The AH does not support specifying a copper value (only gold and silver)."] = "拍賣行不支持設定銅幣價格（僅支持金幣和銀幣）。"
L["The Base Group contains all ungrouped items in the game. Use the search and filter controls to find items to add to other groups."] = "基本群組包含了遊戲中所有的未群組物品. 使用搜尋與篩選的功能來找到物品, 將其加入其他群組."
L["The TradeSkillMaster_AppHelper addon is installed, but not enabled. TSM has enabled it and requires a reload."] = "插件TradeSkillMaster_AppHelper已安裝, 但沒啓用. TSM現已啓用它並需要重載。."
L["The buyout price for %s would be above the maximum allowed price. Skipping this item."] = "購買%s出價超過了允許的最高價。忽略此物品。"
L["The canlearn filter was ignored because the CanIMogIt addon was not found."] = "由於未找到CanIMogIt插件，忽略canlearn篩選器。"
L["The max quantity cannot be zero."] = "最大數量不能是0。"
L["The min profit did not evaluate to a valid value for this item."] = "The min profit did not evaluate to a valid value for this item."
L["The name portion of the search term must be at least 3 characters if present."] = "搜索詞的名稱部分必須至少包含3個字符（如果有）。"
L["The pasted value was not valid. Ensure you are pasting the entire import string."] = "粘貼的價格無效。請確認你粘貼了完整的匯入字符串。"
L["The player \\\"%s\\\" is already on your whitelist."] = "The player \\\"%s\\\" is already on your whitelist."
L["The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."] = "價格必須包含g/s/c標籤。例如 '1g 2s' 表示1金2銀。"
L["The profit of this item (%s) is below the min profit (%s)."] = "這個物品（%s）利潤低於最小利潤（%s）。"
L["The same filter was specified multiple times."] = "多次重複指定同一篩選器。"
L["The search term must be at least 3 characters."] = "搜索詞必須至少有3個字符。"
L["The seller name of the lowest auction for %s was not given by the server. Skipping this item."] = "伺服器沒有給出 %s的最低拍賣賣家的名字。忽略該物品。"
L["The specified filter was empty."] = "这个筛选器是空的。"
L["The specified item is not supported for crafting searches."] = "製造搜索不支持指定物品。"
L["The specified item is not supported for disenchant searches."] = "分解搜索不支持指定物品。"
L["The specified item was not found."] = "指定物品沒找到。"
L["The unlearned filter was ignored because the CanIMogIt addon was not found."] = "筛选器unlearned 已忽略，因为CanIMogIt插件未找到。"
L["The value must be greater than 0."] = "該值必須比0大。"
L["The value must be greater than or equal of 0."] = "The value must be greater than or equal of 0."
L["The value was greater than the maximum allowed auction house price."] = "這個值大於拍賣行允許的最大值。"
L["Themes"] = "主題"
L["There are unbalanced parentheses in this custom string."] = "There are unbalanced parentheses in this custom string."
L["There is currently no profession open, so cannot create profession groups."] = "現在沒打開專業技能，所以沒法創建專業群組。"
L["There is no Crafting operation applied to this item's TSM group (%s)."] = "沒有製作作業應用到這個物品的TSM群組（%s）。"
L["This custom string is too complex for WoW to handle; use custom sources to simplify it."] = "This custom string is too complex for WoW to handle; use custom sources to simplify it."
L["This is not a valid profile name. Profile names must be at least one character long and may not contain '@' characters."] = "這不是有效的配置名字。配置文件名必須至少一個字符，且不含”@“字符。"
L["This item does not have a crafting cost. Check that all of its mats have mat prices."] = "此物品沒有製造成本，請檢查所有材料是否有材料價格。"
L["This item is not in a TSM group."] = "這物品不在TSM群組中。"
L["This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."] = "當爲群組補貨時，物品會添加到隊列。如果沒有發生，請訪問http://support.tradeskillmaster.com尋求幫助。"
L["This operation is applied to the base group which includes every item not in another group."] = "這個作業已分配給基礎群組，基礎群組包含了不在其他群組的所有物品。"
L["This price is above your confirmation alert threshold."] = "此價格高於確認警報閾值。"
L["This price is above your material value."] = "This price is above your material value."
L["This profession is not open."] = "專業技能未打開。"
L["This record belongs to another account and can only be deleted on that account."] = "這個記錄屬於另一個賬號，只能在該賬號下刪除。"
L["This will permanently delete the '%s' profile."] = "這將永久刪除  '%s' 配置文件。"
L["This will reset all groups and operations (if not stored globally) to be wiped from '%s'."] = "這將重置要從“%s”中擦除的所有群組和作業（如果不是全局存儲的）。"
L["Time"] = "時間"
L["Time Frame"] = "時段"
L["Tinker"] = "修理"
L["Toggles the TSM Banking UI if either the bank or guild bank is currently open."] = "當銀行或公會銀行打開時，打開銀行助手界面。"
L["Toggles the TSM Crafting UI."] = "切換TSM製造界面。"
L["Toggles the TSM Task List UI"] = "切換TSM任務列表界面"
L["Toggles the main TSM window"] = "切换TSM主窗口"
L["Tooltip Options"] = "提示框選項"
L["Tooltip Settings"] = "提示框設定"
L["Tooltip price format"] = "提示框價格格式"
L["Top Buyers"] = "頂部買家"
L["Top Item"] = "最佳品項"
L["Top Sellers"] = "頂部賣家"
L["Total"] = "總數"
L["Total Gold"] = "總金額"
L["Total Gold Collected: %s"] = "總共獲得金額: %s"
L["Total Gold Earned"] = "收益總額"
L["Total Gold Spent"] = "支出總額"
L["Total Inventory Quantity"] = "總庫存數量"
L["Total Items"] = "總品項"
L["Total Postage"] = "總郵資"
L["Total Price"] = "總價"
L["Total Prices:"] = "總價："
L["Total Profit"] = "總利潤"
L["Total Value"] = "總值"
L["Track Sales / Purchases via trade"] = "通過貿易跟蹤銷售/採購"
L["Transform"] = "Transform"
L["Transform Value"] = "轉化價值"
L["Type"] = "類型"
L["Uncollected Only"] = "僅未收集"
L["Undercut amount"] = "削價幅度"
L["Undercut by whitelisted player."] = "被白名單玩家壓價。"
L["Undercutting blacklisted player."] = "被黑名單玩家壓價。"
L["Undercutting competition."] = "削價發佈"
L["Unexpected word ('%s') in custom string."] = "Unexpected word ('%s') in custom string."
L["Ungrouped Items"] = "未入群組的物品"
L["Ungrouped Items in Bags"] = "背包裡未被群組的物品"
L["Unit Price"] = "單價"
L["Unknown Item"] = "未知物品"
L["Unknown word (%s)."] = "未知關鍵字 (%s)。"
L["Unlock Column Width"] = "未鎖定列寬"
L["Unwrap Gift"] = "打開禮包"
L["Up"] = "上"
L["Up to date"] = "更新"
L["Update existing macro"] = "更新現有宏巨集"
L["Updating"] = "更新中"
L["Upgrades Only"] = "僅有提升"
L["Usable Only"] = "僅可用"
L["Usage: /tsm price <Item Link> <Custom String>"] = "用法: /tsm price <物品連接> <Custom String>"
L["Use the settings below to control which lines are shown in tooltips."] = "使用下列設定決定提示框裡顯示的資訊。"
L["Use this list to manage what cooldowns you'd like TSM to ignore from crafting."] = "使用這個列表來管理你希望TSM在製造過程中忽略哪些冷卻時間。"
L["Use this list to manage what items you'd like TSM to ignore from destroying."] = "使用這個列表來管理你希望TSM分解時忽略的物品。"
L["Value"] = "價值"
L["Value Price Source"] = "價值價格來源"
L["Value must be between %d and %d."] = "值必須在 %d 和 %d之間。"
L["Values"] = "價值"
L["Vendor"] = "供應商"
L["Vendor Buy Price"] = "供應商進價"
L["Vendor Search"] = "供應商搜尋"
L["Vendor Sell"] = "供應商銷售"
L["Vendor Sell Price"] = "供應商售價"
L["Vendor Trade"] = "Vendor Trade"
L["Vendor Trade Value"] = "Vendor Trade Value"
L["Vendor buy price"] = "供應商進價"
L["Vendor sell price"] = "供應商售價"
L["Vendoring"] = "供應"
L["Vendoring %s button"] = "供應 %s 按鈕"
L["Vendoring operation"] = "供應商作業"
L["Vendoring operations control selling to and buying from a vendor."] = "供應操作控制和商人的買賣。"
L["WARNING: The macro was too long, so was truncated to fit by WoW."] = "警告：宏太長，所以被WoW截斷以適應。"
L["WARNING: Your minimum price for %s is below its vendorsell price (with AH cut taken into account). Consider raising your minimum price, or vendoring the item."] = "警告：%s的最低價低於賣店價（扣除AH手續費等）。請提高最低價，或直接賣給NPC。"
L["WOW UI"] = "WOW UI"
L["Warehousing"] = "倉儲"
L["Warehousing operation"] = "倉儲作業"
L["Warehousing operations control moving in and out of the bank."] = "倉庫選項控制銀行物品的進出。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "倉庫會轉移該群組最多每樣%d物品，當背包 > 銀行/公會銀行時每樣保留 %d 物品，當銀行/公會銀行 > 背包時每樣保留 %d 物品。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "倉庫會轉移該群組最多每樣%d物品，當背包 > 銀行/公會銀行時每樣保留 %d 物品，當銀行/公會銀行 > 背包時每樣保留 %d 物品。補貨模塊會維持%d物品在背包中。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank."] = "倉庫會轉移該群組最多每樣%d物品，當背包 > 銀行/公會銀行時，每樣保留 %d 物品。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "倉庫會轉移該群組最多每樣%d物品，當背包 > 銀行/公會銀行時，每樣保留 %d 物品。補貨模塊會維持%d物品在背包中。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags."] = "倉庫會轉移該群組最多每樣%d物品，當銀行/公會銀行 > 背包時，每樣保留 %d 物品。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "倉庫會轉移該群組最多每樣%d物品，當銀行/公會銀行 > 背包時，每樣保留 %d 物品。補貨模塊會維持%d物品在背包中。"
L["Warehousing will move a max of %d of each item in this group."] = "倉庫會轉移該群組最多每樣%d物品。"
L["Warehousing will move a max of %d of each item in this group. Restock will maintain %d items in your bags."] = "倉庫會轉移該群組最多每樣%d物品，補貨模塊會維持%d物品在背包中。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "倉庫會轉移該群組所有物品，當背包 > 銀行/公會銀行時每樣保留 %d 物品，當銀行/公會銀行 > 背包時每樣保留 %d 物品。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "倉庫會轉移該群組所有物品，當背包 > 銀行/公會銀行時每樣保留 %d 物品，當銀行/公會銀行 > 背包時每樣保留 %d 物品。補貨模塊會維持%d物品在背包中。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank."] = "倉庫會轉移該群組所有物品，當背包 > 銀行/公會銀行時，每樣保留 %d 物品。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "倉庫會轉移該群組所有物品，當背包 > 銀行/公會銀行時，每樣保留 %d 物品。補貨模塊會維持%d物品在背包中。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags."] = "倉庫會轉移該群組所有物品，當銀行/公會銀行 > 背包時，每樣保留 %d 物品。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "倉庫會轉移該群組所有物品，當銀行/公會銀行 > 背包時，每樣保留 %d 物品。補貨模塊會保留%d物品在背包中。"
L["Warehousing will move all of the items in this group."] = "倉庫會轉移該群組所有物品。"
L["Warehousing will move all of the items in this group. Restock will maintain %d items in your bags."] = "倉庫會移動該組所有物品。補貨模塊會保留%d 物品在背包中。"
L["When above maximum:"] = "當市場價高於你設定的最高價格時"
L["When below minimum:"] = "當市場商品售價低於你設定的最低價格時："
L["Whitelist"] = "白名單"
L["Whitelisted characters"] = "白名單角色"
L["Winamp"] = "Winamp風格"
L["Would send %s to %s"] = "將發送%s給%s"
L["Would send %s to %s with a COD of %s"] = "將發送%s給%s，到付價%s"
L["Yes, I'm sure"] = "Yes, I'm sure"
L["Yes, I'm sure (%02d)"] = "Yes, I'm sure (%02d)"
L["You are not on one of the listed characters."] = "你的角色不在列表中。"
L["You can clear old Accounting data for the current realm below to keep things running smoothly."] = "You can clear old Accounting data for the current realm below to keep things running smoothly."
L["You can import custom themes by pasting an import string into the box below."] = "在下框中粘貼導入字符串，以導入自定義主題。"
L["You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"] = "你可以粘貼字符串在下框中，以導入群組。可導入的群組字符串可以去這裏找：https://tradeskillmaster.com/group-maker/all"
L["You can now group pets by level, just like items."] = "You can now group pets by level, just like items."
L["You can use the export string below to share this custom theme with others."] = "你可用以下導出字符串，分享自定義主題給其他人。"
L["You can use the export string below to share this group with others."] = "你可以使用下列的匯出字串來分享這個群組給其他人。"
L["You cannot use %s as part of this custom price."] = "你不能使用%s作為自定義價格的一部份。"
L["You do not need to add \\\"%s\\\", alts are whitelisted automatically."] = "You do not need to add \\\"%s\\\", alts are whitelisted automatically."
L["You don't know how to craft this item."] = "你未學會製造這個物品。"
L["You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."] = "你要麼至少已經有了這個物品的最大補貨數量，要麼需要加入隊列的數值小於最小補貨數量。"
L["You must reload your UI for these settings to take effect. Reload now?"] = "你需要重載UI來使這些設置生效。是否現在重載？"
L["You won an auction for %sx%d for %s"] = "你贏得 %s x %d 的拍賣，共花了 %s。"
L["You've been phased which has caused the AH to stop working due to a bug on Blizzard's end. Please close and reopen the AH and restart Sniper."] = "由於暴雪終端的一個bug，你已經被分階段處理，導致AH停止工作。請關閉並重新打開拍賣行，重啓狙擊。"
L["You've been undercut."] = "你已被削價。"
L["Your Buyout"] = "你的直購價"
L["Your auction has not been undercut."] = "你的拍賣未被壓價。"
L["Your auction of %s expired"] = "你拍賣的%s 過期了。"
L["Your auction of %s has sold for %s!"] = "你拍賣的 %s 以 %s 售出！"
L["Your auction of %s has sold!"] = "Your auction of %s has sold!"
L["Your craft value method for '%s' was invalid so it has been returned to the default. Details: %s"] = "你爲%s設置的製造品估價方法無效，所以返回了默認值。詳見：%s"
L["Your default craft value method was invalid so it has been returned to the default. Details: %s"] = "你的默認製造品估值方法無效，所以返回了默認設定。詳情：%s"
L["Your max restock (%s) is invalid for %s."] = "最大補貨量（%s）對於%s無效。"
L["Your min restock (%s) is invalid for %s."] = "最小補貨量（%s）對於%s無效。"
L["Your restock quantity is invalid. It must be between %d and %s."] = "你的補貨數量無效。它必須在%d 和 %s之間。"
L["Your task list is currently empty."] = "您的任務列表當前為空。"
L["ilvl"] = "物品等級"
-- LOCALE STRINGS END HERE

Locale.SetTable(L)
