if not WeakAuras.IsLibsOK() then return end
--- @type string, Private
local AddonName, Private = ...

local WeakAuras = WeakAuras;
local L = WeakAuras.L;

local encounter_list = ""
function Private.InitializeEncounterAndZoneLists()
  if encounter_list ~= "" then
    return
  end
  local raids = {
    {
      L["Vault of Archavon"],
      {
        { L["Archavon the Stone Watcher"], 772 },
        { L["Emalon the Storm Watcher"], 774 },
        { L["Koralon the Flame Watcher"], 776 },
        { L["Toravon the Ice Watcher"], 885 },
      }
    },
    {
      L["Naxxramas"],
      {
        -- The Arachnid Quarter
        { L["Anub'Rekhan"], 1107 },
        { L["Grand Widow Faerlina"], 1110 },
        { L["Maexxna"], 1116 },
        -- The Plague Quarter
        { L["Noth the Plaguebringer"], 1117 },
        { L["Heigan the Unclean"], 1112 },
        { L["Loatheb"], 1115 },
        -- The Military Quarter
        { L["Instructor Razuvious"], 1113 },
        { L["Gothik the Harvester"], 1109 },
        { L["The Four Horsemen"], 1121 },
        -- The Construct Quarter
        { L["Patchwerk"], 1118 },
        { L["Grobbulus"], 1111 },
        { L["Gluth"], 1108 },
        { L["Thaddius"], 1120 },
        -- Frostwyrm Lair
        { L["Sapphiron"], 1119 },
        { L["Kel'Thuzad"], 1114 }
      }
    },
    {
      L["The Obsidian Sanctum"],
      {
        { L["Tenebron"], 736 },
        { L["Shadron"], 738 },
        { L["Vesperon"], 740 },
        { L["Sartharion"], 742 },
      }
    },
    {
      L["The Eye of Eternity"],
      {
        { L["Malygos"], 734 },
      }
    },
    {
      L["Ulduar"],
      {
        -- The Siege of Ulduar
        { L["Flame Leviathan"], 744 },
        { L["Ignis the Furnace Master"], 745 },
        { L["Razorscale"], 746 },
        { L["XT-002 Deconstructor"], 747 },
        -- The Antechamber of Ulduar
        { L["Assembly of Iron"], 748 },
        { L["Kologarn"], 749 },
        { L["Auriaya"], 750 },
        -- The Keepers of Ulduar
        { L["Freya"], 753 },
        { L["Hodir"], 751 },
        { L["Mimiron"], 754 },
        { L["Thorim"], 752 },
        -- The Descent into Madness
        { L["General Vezax"], 755 },
        { L["Yogg-Saron"], 756 },
        -- Celestial Planetarium
        { L["Algalon the Observer"], 757 },
      }
    },
    {
      L["Trial of the Crusader"],
      {
        { L["Northrend Beasts"], 629 },
        { L["Lord Jaraxxus"], 633 },
        { L["Faction Champions"], 637 },
        { L["Val'kyr Twins"], 641 },
        { L["Anub'arak"], 645 },
      }
    },
    {
      L["Onyxia's Lair"],
      {
        { L["Onyxia"], 1084 },
      }
    },
    {
      L["Icecrown Citadel"],
      {
        -- The Lower Spire
        { L["Lord Marrowgar"], 845 },
        { L["Lady Deathwhisper"], 846 },
        { L["Gunship Battle"], 847 },
        { L["Deathbringer Saurfang"], 848 },
        -- The Plagueworks
        { L["Festergut"], 849 },
        { L["Rotface"], 850 },
        { L["Professor Putricide"], 851 },
        -- The Crimson Hall
        { L["Blood Prince Council"], 852 },
        { L["Blood-Queen Lana'thel"], 853 },
        -- The Frostwing Halls
        { L["Valithria Dreamwalker"], 854 },
        { L["Sindragosa"], 855 },
        -- The Frozen Throne
        { L["The Lich King"], 856 },
      }
    },
    {
      L["The Ruby Sanctum"],
      {
        { L["Baltharus the Warborn"], 890 },
        { L["General Zarithrian"], 893 },
        { L["Saviana Ragefire"], 891 },
        { L["Halion"], 887 },
      }
    },
  }
  for _, raid in ipairs(raids) do
    encounter_list = ("%s|cffffd200%s|r\n"):format(encounter_list, raid[1])
    for _, boss in ipairs(raid[2]) do
        encounter_list = ("%s%s: %d\n"):format(encounter_list, boss[1], boss[2])
    end
    encounter_list = encounter_list .. "\n"
  end

  encounter_list = encounter_list:sub(1, -3) .. "\n\n" .. L["Supports multiple entries, separated by commas\n"]
end

function Private.get_encounters_list()
  return encounter_list
end

function Private.get_zoneId_list()
  return ""
end

Private.talentInfo = {
  ["DEATHKNIGHT"] = {
    {
      135770, -- [1]
      7, -- [2]
      3, -- [3]
      50371, -- [4]
    }, -- [1]
    {
      135067, -- [1]
      2, -- [2]
      1, -- [3]
      49393, -- [4]
    }, -- [2]
    {
      132455, -- [1]
      1, -- [2]
      1, -- [3]
      49483, -- [4]
    }, -- [3]
    {
      237529, -- [1]
      3, -- [2]
      1, -- [3]
      48982, -- [4]
    }, -- [4]
    {
      237529, -- [1]
      4, -- [2]
      1, -- [3]
      49489, -- [4]
    }, -- [5]
    {
      237518, -- [1]
      3, -- [2]
      2, -- [3]
      49480, -- [4]
    }, -- [6]
    {
      132090, -- [1]
      6, -- [2]
      2, -- [3]
      49504, -- [4]
    }, -- [7]
    {
      237533, -- [1]
      1, -- [2]
      2, -- [3]
      49491, -- [4]
    }, -- [8]
    {
      132284, -- [1]
      2, -- [2]
      2, -- [3]
      49509, -- [4]
    }, -- [9]
    {
      132205, -- [1]
      5, -- [2]
      4, -- [3]
      49005, -- [4]
    }, -- [10]
    {
      136005, -- [1]
      5, -- [2]
      3, -- [3]
      50029, -- [4]
    }, -- [11]
    {
      237536, -- [1]
      4, -- [2]
      4, -- [3]
      55136, -- [4]
    }, -- [12]
    {
      237512, -- [1]
      7, -- [2]
      2, -- [3]
      49016, -- [4]
    }, -- [13]
    {
      136181, -- [1]
      8, -- [2]
      2, -- [3]
      49530, -- [4]
    }, -- [14]
    {
      135675, -- [1]
      9, -- [2]
      2, -- [3]
      55050, -- [4]
    }, -- [15]
    {
      135771, -- [1]
      9, -- [2]
      3, -- [3]
      49534, -- [4]
    }, -- [16]
    {
      132094, -- [1]
      9, -- [2]
      1, -- [3]
      50150, -- [4]
    }, -- [17]
    {
      136211, -- [1]
      7, -- [2]
      1, -- [3]
      49543, -- [4]
    }, -- [18]
    {
      135277, -- [1]
      11, -- [2]
      2, -- [3]
      49028, -- [4]
    }, -- [19]
    {
      135772, -- [1]
      5, -- [2]
      1, -- [3]
      49395, -- [4]
    }, -- [20]
    {
      132330, -- [1]
      1, -- [2]
      3, -- [3]
      55226, -- [4]
    }, -- [21]
    {
      237531, -- [1]
      4, -- [2]
      3, -- [3]
      49497, -- [4]
    }, -- [22]
    {
      136168, -- [1]
      8, -- [2]
      3, -- [3]
      55233, -- [4]
    }, -- [23]
    {
      136080, -- [1]
      10, -- [2]
      2, -- [3]
      61158, -- [4]
    }, -- [24]
    {
      135372, -- [1]
      3, -- [2]
      3, -- [3]
      50034, -- [4]
    }, -- [25]
    {
      236310, -- [1]
      6, -- [2]
      3, -- [3]
      53138, -- [4]
    }, -- [26]
    {
      135378, -- [1]
      2, -- [2]
      3, -- [3]
      55108, -- [4]
    }, -- [27]
    {
      237517, -- [1]
      8, -- [2]
      1, -- [3]
      62908, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135892, -- [1]
      1, -- [2]
      3, -- [3]
      49789, -- [4]
    }, -- [41]
    {
      136223, -- [1]
      4, -- [2]
      4, -- [3]
      49657, -- [4]
    }, -- [42]
    {
      136141, -- [1]
      2, -- [2]
      3, -- [3]
      49664, -- [4]
    }, -- [43]
    {
      237520, -- [1]
      9, -- [2]
      2, -- [3]
      49143, -- [4]
    }, -- [44]
    {
      132388, -- [1]
      8, -- [2]
      3, -- [3]
      51271, -- [4]
    }, -- [45]
    {
      136213, -- [1]
      5, -- [2]
      4, -- [3]
      49796, -- [4]
    }, -- [46]
    {
      135849, -- [1]
      4, -- [2]
      3, -- [3]
      50115, -- [4]
    }, -- [47]
    {
      135833, -- [1]
      11, -- [2]
      2, -- [3]
      49184, -- [4]
    }, -- [48]
    {
      132734, -- [1]
      5, -- [2]
      2, -- [3]
      51109, -- [4]
    }, -- [49]
    {
      135840, -- [1]
      6, -- [2]
      3, -- [3]
      59057, -- [4]
    }, -- [50]
    {
      135294, -- [1]
      6, -- [2]
      2, -- [3]
      49538, -- [4]
    }, -- [51]
    {
      135791, -- [1]
      9, -- [2]
      1, -- [3]
      50152, -- [4]
    }, -- [52]
    {
      136107, -- [1]
      10, -- [2]
      2, -- [3]
      50130, -- [4]
    }, -- [53]
    {
      135152, -- [1]
      7, -- [2]
      2, -- [3]
      49203, -- [4]
    }, -- [54]
    {
      135728, -- [1]
      1, -- [2]
      2, -- [3]
      50147, -- [4]
    }, -- [55]
    {
      132147, -- [1]
      2, -- [2]
      4, -- [3]
      50138, -- [4]
    }, -- [56]
    {
      135773, -- [1]
      7, -- [2]
      3, -- [3]
      50385, -- [4]
    }, -- [57]
    {
      136083, -- [1]
      5, -- [2]
      3, -- [3]
      49791, -- [4]
    }, -- [58]
    {
      237526, -- [1]
      1, -- [2]
      1, -- [3]
      51456, -- [4]
    }, -- [59]
    {
      135859, -- [1]
      2, -- [2]
      2, -- [3]
      55062, -- [4]
    }, -- [60]
    {
      132373, -- [1]
      9, -- [2]
      3, -- [3]
      50191, -- [4]
    }, -- [61]
    {
      252994, -- [1]
      3, -- [2]
      1, -- [3]
      50887, -- [4]
    }, -- [62]
    {
      135305, -- [1]
      4, -- [2]
      2, -- [3]
      51130, -- [4]
    }, -- [63]
    {
      135609, -- [1]
      3, -- [2]
      3, -- [3]
      51473, -- [4]
    }, -- [64]
    {
      135714, -- [1]
      8, -- [2]
      2, -- [3]
      54637, -- [4]
    }, -- [65]
    {
      136187, -- [1]
      3, -- [2]
      2, -- [3]
      49039, -- [4]
    }, -- [66]
    {
      252994, -- [1]
      6, -- [2]
      1, -- [3]
      55610, -- [4]
    }, -- [67]
    {
      135864, -- [1]
      7, -- [2]
      1, -- [3]
      50043, -- [4]
    }, -- [68]
    {
      132148, -- [1]
      8, -- [2]
      1, -- [3]
      66192, -- [4]
    }, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136126, -- [1]
      1, -- [2]
      2, -- [3]
      49568, -- [4]
    }, -- [81]
    {
      136144, -- [1]
      2, -- [2]
      2, -- [3]
      49565, -- [4]
    }, -- [82]
    {
      237524, -- [1]
      2, -- [2]
      4, -- [3]
      49572, -- [4]
    }, -- [83]
    {
      136066, -- [1]
      8, -- [2]
      2, -- [3]
      49632, -- [4]
    }, -- [84]
    {
      136207, -- [1]
      2, -- [2]
      1, -- [3]
      49562, -- [4]
    }, -- [85]
    {
      136119, -- [1]
      6, -- [2]
      4, -- [3]
      52143, -- [4]
    }, -- [86]
    {
      132099, -- [1]
      3, -- [2]
      3, -- [3]
      49158, -- [4]
    }, -- [87]
    {
      136132, -- [1]
      5, -- [2]
      1, -- [3]
      49194, -- [4]
    }, -- [88]
    {
      132182, -- [1]
      11, -- [2]
      2, -- [3]
      49206, -- [4]
    }, -- [89]
    {
      136195, -- [1]
      6, -- [2]
      3, -- [3]
      56835, -- [4]
    }, -- [90]
    {
      136127, -- [1]
      9, -- [2]
      1, -- [3]
      49655, -- [4]
    }, -- [91]
    {
      132109, -- [1]
      4, -- [2]
      3, -- [3]
      49628, -- [4]
    }, -- [92]
    {
      136196, -- [1]
      5, -- [2]
      2, -- [3]
      49638, -- [4]
    }, -- [93]
    {
      132728, -- [1]
      8, -- [2]
      3, -- [3]
      49222, -- [4]
    }, -- [94]
    {
      136182, -- [1]
      3, -- [2]
      1, -- [3]
      55237, -- [4]
    }, -- [95]
    {
      136120, -- [1]
      6, -- [2]
      2, -- [3]
      49611, -- [4]
    }, -- [96]
    {
      136194, -- [1]
      5, -- [2]
      3, -- [3]
      49599, -- [4]
    }, -- [97]
    {
      135775, -- [1]
      7, -- [2]
      3, -- [3]
      50392, -- [4]
    }, -- [98]
    {
      237532, -- [1]
      2, -- [2]
      3, -- [3]
      49589, -- [4]
    }, -- [99]
    {
      135564, -- [1]
      10, -- [2]
      2, -- [3]
      50121, -- [4]
    }, -- [100]
    {
      237534, -- [1]
      4, -- [2]
      2, -- [3]
      51267, -- [4]
    }, -- [101]
    {
      132095, -- [1]
      9, -- [2]
      2, -- [3]
      51161, -- [4]
    }, -- [102]
    {
      135695, -- [1]
      3, -- [2]
      2, -- [3]
      51465, -- [4]
    }, -- [103]
    {
      135774, -- [1]
      1, -- [2]
      1, -- [3]
      51746, -- [4]
    }, -- [104]
    {
      132152, -- [1]
      7, -- [2]
      4, -- [3]
      63560, -- [4]
    }, -- [105]
    {
      237530, -- [1]
      9, -- [2]
      3, -- [3]
      55090, -- [4]
    }, -- [106]
    {
      136056, -- [1]
      1, -- [2]
      3, -- [3]
      55133, -- [4]
    }, -- [107]
    {
      237510, -- [1]
      7, -- [2]
      2, -- [3]
      51052, -- [4]
    }, -- [108]
    {
      237511, -- [1]
      4, -- [2]
      4, -- [3]
      55623, -- [4]
    }, -- [109]
    {
      136199, -- [1]
      6, -- [2]
      1, -- [3]
      55667, -- [4]
    }, -- [110]
    {
      136224, -- [1]
      7, -- [2]
      1, -- [3]
      66817, -- [4]
    }, -- [111]
    [121] = {
      "DeathKnightBlood", -- [1]
      "DeathKnightFrost", -- [2]
      "DeathKnightUnholy", -- [3]
    },
  },
  ["WARRIOR"] = {
    {
      132090, -- [1]
      3, -- [2]
      4, -- [3]
      12867, -- [4]
    }, -- [1]
    {
      135328, -- [1]
      5, -- [2]
      4, -- [3]
      12815, -- [4]
    }, -- [2]
    {
      132282, -- [1]
      1, -- [2]
      1, -- [3]
      12664, -- [4]
    }, -- [3]
    {
      133476, -- [1]
      5, -- [2]
      3, -- [3]
      12704, -- [4]
    }, -- [4]
    {
      132337, -- [1]
      2, -- [2]
      1, -- [3]
      12697, -- [4]
    }, -- [5]
    {
      132155, -- [1]
      1, -- [2]
      3, -- [3]
      12658, -- [4]
    }, -- [6]
    {
      136031, -- [1]
      2, -- [2]
      3, -- [3]
      12677, -- [4]
    }, -- [7]
    {
      132316, -- [1]
      6, -- [2]
      3, -- [3]
      23695, -- [4]
    }, -- [8]
    {
      132269, -- [1]
      1, -- [2]
      2, -- [3]
      16466, -- [4]
    }, -- [9]
    {
      135275, -- [1]
      3, -- [2]
      1, -- [3]
      12963, -- [4]
    }, -- [10]
    {
      132397, -- [1]
      5, -- [2]
      1, -- [3]
      12785, -- [4]
    }, -- [11]
    {
      132306, -- [1]
      5, -- [2]
      2, -- [3]
      12328, -- [4]
    }, -- [12]
    {
      132367, -- [1]
      6, -- [2]
      1, -- [3]
      20505, -- [4]
    }, -- [13]
    {
      132355, -- [1]
      7, -- [2]
      2, -- [3]
      12294, -- [4]
    }, -- [14]
    {
      132400, -- [1]
      4, -- [2]
      2, -- [3]
      12712, -- [4]
    }, -- [15]
    {
      135881, -- [1]
      3, -- [2]
      2, -- [3]
      12296, -- [4]
    }, -- [16]
    {
      135995, -- [1]
      2, -- [2]
      2, -- [3]
      12960, -- [4]
    }, -- [17]
    {
      132312, -- [1]
      3, -- [2]
      3, -- [3]
      16494, -- [4]
    }, -- [18]
    {
      132344, -- [1]
      9, -- [2]
      2, -- [3]
      29623, -- [4]
    }, -- [19]
    {
      132346, -- [1]
      9, -- [2]
      1, -- [3]
      29724, -- [4]
    }, -- [20]
    {
      132175, -- [1]
      7, -- [2]
      1, -- [3]
      29838, -- [4]
    }, -- [21]
    {
      132334, -- [1]
      9, -- [2]
      3, -- [3]
      29859, -- [4]
    }, -- [22]
    {
      132355, -- [1]
      8, -- [2]
      2, -- [3]
      35449, -- [4]
    }, -- [23]
    {
      236305, -- [1]
      6, -- [2]
      4, -- [3]
      46855, -- [4]
    }, -- [24]
    {
      236317, -- [1]
      8, -- [2]
      3, -- [3]
      46860, -- [4]
    }, -- [25]
    {
      132349, -- [1]
      7, -- [2]
      3, -- [3]
      46866, -- [4]
    }, -- [26]
    {
      236303, -- [1]
      11, -- [2]
      2, -- [3]
      46924, -- [4]
    }, -- [27]
    {
      132364, -- [1]
      10, -- [2]
      2, -- [3]
      56614, -- [4]
    }, -- [28]
    {
      236276, -- [1]
      4, -- [2]
      3, -- [3]
      56638, -- [4]
    }, -- [29]
    {
      132340, -- [1]
      7, -- [2]
      4, -- [3]
      12330, -- [4]
    }, -- [30]
    {
      132335, -- [1]
      8, -- [2]
      1, -- [3]
      64976, -- [4]
    }, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      136035, -- [1]
      3, -- [2]
      4, -- [3]
      12861, -- [4]
    }, -- [41]
    {
      136224, -- [1]
      4, -- [2]
      3, -- [3]
      13048, -- [4]
    }, -- [42]
    {
      132152, -- [1]
      6, -- [2]
      3, -- [3]
      12974, -- [4]
    }, -- [43]
    {
      132292, -- [1]
      1, -- [2]
      3, -- [3]
      12856, -- [4]
    }, -- [44]
    {
      136075, -- [1]
      1, -- [2]
      2, -- [3]
      12835, -- [4]
    }, -- [45]
    {
      136097, -- [1]
      2, -- [2]
      3, -- [3]
      13002, -- [4]
    }, -- [46]
    {
      136147, -- [1]
      3, -- [2]
      2, -- [3]
      12323, -- [4]
    }, -- [47]
    {
      132366, -- [1]
      2, -- [2]
      2, -- [3]
      12879, -- [4]
    }, -- [48]
    {
      136146, -- [1]
      5, -- [2]
      2, -- [3]
      12292, -- [4]
    }, -- [49]
    {
      132338, -- [1]
      3, -- [2]
      1, -- [3]
      20496, -- [4]
    }, -- [50]
    {
      136012, -- [1]
      7, -- [2]
      2, -- [3]
      23881, -- [4]
    }, -- [51]
    {
      136218, -- [1]
      3, -- [2]
      3, -- [3]
      16492, -- [4]
    }, -- [52]
    {
      136009, -- [1]
      6, -- [2]
      1, -- [3]
      20501, -- [4]
    }, -- [53]
    {
      135358, -- [1]
      4, -- [2]
      2, -- [3]
      20503, -- [4]
    }, -- [54]
    {
      132307, -- [1]
      5, -- [2]
      3, -- [3]
      29889, -- [4]
    }, -- [55]
    {
      132147, -- [1]
      4, -- [2]
      1, -- [3]
      23588, -- [4]
    }, -- [56]
    {
      132369, -- [1]
      7, -- [2]
      4, -- [3]
      29776, -- [4]
    }, -- [57]
    {
      132222, -- [1]
      5, -- [2]
      1, -- [3]
      29592, -- [4]
    }, -- [58]
    {
      132275, -- [1]
      8, -- [2]
      4, -- [3]
      29763, -- [4]
    }, -- [59]
    {
      132352, -- [1]
      9, -- [2]
      2, -- [3]
      29801, -- [4]
    }, -- [60]
    {
      132344, -- [1]
      7, -- [2]
      1, -- [3]
      56924, -- [4]
    }, -- [61]
    {
      236308, -- [1]
      8, -- [2]
      1, -- [3]
      46911, -- [4]
    }, -- [62]
    {
      236306, -- [1]
      9, -- [2]
      3, -- [3]
      46915, -- [4]
    }, -- [63]
    {
      236316, -- [1]
      11, -- [2]
      2, -- [3]
      46917, -- [4]
    }, -- [64]
    {
      236171, -- [1]
      9, -- [2]
      1, -- [3]
      60970, -- [4]
    }, -- [65]
    {
      236310, -- [1]
      10, -- [2]
      2, -- [3]
      56932, -- [4]
    }, -- [66]
    {
      135053, -- [1]
      1, -- [2]
      1, -- [3]
      61222, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136056, -- [1]
      2, -- [2]
      3, -- [3]
      12753, -- [4]
    }, -- [81]
    {
      135892, -- [1]
      3, -- [2]
      4, -- [3]
      12764, -- [4]
    }, -- [82]
    {
      132326, -- [1]
      1, -- [2]
      3, -- [3]
      12666, -- [4]
    }, -- [83]
    {
      132277, -- [1]
      1, -- [2]
      1, -- [3]
      12818, -- [4]
    }, -- [84]
    {
      236309, -- [1]
      2, -- [2]
      2, -- [3]
      50687, -- [4]
    }, -- [85]
    {
      132363, -- [1]
      4, -- [2]
      3, -- [3]
      12811, -- [4]
    }, -- [86]
    {
      132353, -- [1]
      3, -- [2]
      2, -- [3]
      12799, -- [4]
    }, -- [87]
    {
      236318, -- [1]
      7, -- [2]
      2, -- [3]
      50720, -- [4]
    }, -- [88]
    {
      132357, -- [1]
      5, -- [2]
      3, -- [3]
      12958, -- [4]
    }, -- [89]
    {
      132362, -- [1]
      5, -- [2]
      1, -- [3]
      12803, -- [4]
    }, -- [90]
    {
      132343, -- [1]
      4, -- [2]
      2, -- [3]
      12804, -- [4]
    }, -- [91]
    {
      132325, -- [1]
      5, -- [2]
      2, -- [3]
      12809, -- [4]
    }, -- [92]
    {
      135871, -- [1]
      3, -- [2]
      1, -- [3]
      12975, -- [4]
    }, -- [93]
    {
      135321, -- [1]
      6, -- [2]
      3, -- [3]
      16542, -- [4]
    }, -- [94]
    {
      134952, -- [1]
      1, -- [2]
      2, -- [3]
      12727, -- [4]
    }, -- [95]
    {
      132341, -- [1]
      7, -- [2]
      1, -- [3]
      29594, -- [4]
    }, -- [96]
    {
      133123, -- [1]
      8, -- [2]
      2, -- [3]
      29144, -- [4]
    }, -- [97]
    {
      132360, -- [1]
      3, -- [2]
      3, -- [3]
      29599, -- [4]
    }, -- [98]
    {
      132345, -- [1]
      7, -- [2]
      3, -- [3]
      29792, -- [4]
    }, -- [99]
    {
      135291, -- [1]
      9, -- [2]
      2, -- [3]
      20243, -- [4]
    }, -- [100]
    {
      236311, -- [1]
      8, -- [2]
      3, -- [3]
      46949, -- [4]
    }, -- [101]
    {
      236315, -- [1]
      10, -- [2]
      2, -- [3]
      46953, -- [4]
    }, -- [102]
    {
      236312, -- [1]
      11, -- [2]
      2, -- [3]
      46968, -- [4]
    }, -- [103]
    {
      236307, -- [1]
      9, -- [2]
      3, -- [3]
      47296, -- [4]
    }, -- [104]
    {
      236319, -- [1]
      9, -- [2]
      1, -- [3]
      57499, -- [4]
    }, -- [105]
    {
      134976, -- [1]
      10, -- [2]
      3, -- [3]
      58874, -- [4]
    }, -- [106]
    {
      132361, -- [1]
      4, -- [2]
      1, -- [3]
      59089, -- [4]
    }, -- [107]
    [121] = {
      "WarriorArms", -- [1]
      "WarriorFury", -- [2]
      "WarriorProtection", -- [3]
    },
  },
  ["SHAMAN"] = {
    {
      135817, -- [1]
      2, -- [2]
      1, -- [3]
      16161, -- [4]
    }, -- [1]
    {
      136014, -- [1]
      5, -- [2]
      2, -- [3]
      16041, -- [4]
    }, -- [2]
    {
      135807, -- [1]
      1, -- [2]
      3, -- [3]
      16108, -- [4]
    }, -- [3]
    {
      136116, -- [1]
      1, -- [2]
      2, -- [3]
      16112, -- [4]
    }, -- [4]
    {
      135830, -- [1]
      3, -- [2]
      3, -- [3]
      60188, -- [4]
    }, -- [5]
    {
      135824, -- [1]
      4, -- [2]
      1, -- [3]
      16544, -- [4]
    }, -- [6]
    {
      136115, -- [1]
      7, -- [2]
      2, -- [3]
      16166, -- [4]
    }, -- [7]
    {
      136170, -- [1]
      3, -- [2]
      2, -- [3]
      16164, -- [4]
    }, -- [8]
    {
      135850, -- [1]
      3, -- [2]
      1, -- [3]
      16116, -- [4]
    }, -- [9]
    {
      135990, -- [1]
      6, -- [2]
      3, -- [3]
      16582, -- [4]
    }, -- [10]
    {
      136094, -- [1]
      2, -- [2]
      2, -- [3]
      28998, -- [4]
    }, -- [11]
    {
      136099, -- [1]
      5, -- [2]
      1, -- [3]
      29000, -- [4]
    }, -- [12]
    {
      136213, -- [1]
      4, -- [2]
      4, -- [3]
      29065, -- [4]
    }, -- [13]
    {
      135791, -- [1]
      2, -- [2]
      3, -- [3]
      29180, -- [4]
    }, -- [14]
    {
      136111, -- [1]
      5, -- [2]
      4, -- [3]
      30666, -- [4]
    }, -- [15]
    {
      136028, -- [1]
      6, -- [2]
      1, -- [3]
      30674, -- [4]
    }, -- [16]
    {
      136050, -- [1]
      8, -- [2]
      3, -- [3]
      30679, -- [4]
    }, -- [17]
    {
      135829, -- [1]
      9, -- [2]
      2, -- [3]
      30706, -- [4]
    }, -- [18]
    {
      237576, -- [1]
      8, -- [2]
      2, -- [3]
      51470, -- [4]
    }, -- [19]
    {
      237572, -- [1]
      9, -- [2]
      1, -- [3]
      51479, -- [4]
    }, -- [20]
    {
      237583, -- [1]
      9, -- [2]
      3, -- [3]
      51482, -- [4]
    }, -- [21]
    {
      237588, -- [1]
      7, -- [2]
      3, -- [3]
      51486, -- [4]
    }, -- [22]
    {
      237589, -- [1]
      11, -- [2]
      2, -- [3]
      51490, -- [4]
    }, -- [23]
    {
      136234, -- [1]
      10, -- [2]
      2, -- [3]
      62101, -- [4]
    }, -- [24]
    {
      135782, -- [1]
      8, -- [2]
      1, -- [3]
      63372, -- [4]
    }, -- [25]
    nil, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      136056, -- [1]
      3, -- [2]
      4, -- [3]
      16272, -- [4]
    }, -- [41]
    {
      132152, -- [1]
      4, -- [2]
      2, -- [3]
      16284, -- [4]
    }, -- [42]
    {
      136095, -- [1]
      2, -- [2]
      3, -- [3]
      16287, -- [4]
    }, -- [43]
    {
      136051, -- [1]
      2, -- [2]
      4, -- [3]
      51881, -- [4]
    }, -- [44]
    {
      136098, -- [1]
      2, -- [2]
      1, -- [3]
      16293, -- [4]
    }, -- [45]
    {
      136023, -- [1]
      1, -- [2]
      1, -- [3]
      52456, -- [4]
    }, -- [46]
    {
      135814, -- [1]
      3, -- [2]
      1, -- [3]
      29080, -- [4]
    }, -- [47]
    {
      132325, -- [1]
      2, -- [2]
      2, -- [3]
      16305, -- [4]
    }, -- [48]
    {
      136162, -- [1]
      1, -- [2]
      3, -- [3]
      17489, -- [4]
    }, -- [49]
    {
      135892, -- [1]
      4, -- [2]
      3, -- [3]
      16309, -- [4]
    }, -- [50]
    {
      132269, -- [1]
      5, -- [2]
      2, -- [3]
      16268, -- [4]
    }, -- [51]
    {
      136027, -- [1]
      3, -- [2]
      3, -- [3]
      43338, -- [4]
    }, -- [52]
    {
      132314, -- [1]
      7, -- [2]
      3, -- [3]
      17364, -- [4]
    }, -- [53]
    {
      132215, -- [1]
      6, -- [2]
      3, -- [3]
      29086, -- [4]
    }, -- [54]
    {
      136114, -- [1]
      5, -- [2]
      1, -- [3]
      29193, -- [4]
    }, -- [55]
    {
      136110, -- [1]
      6, -- [2]
      1, -- [3]
      30809, -- [4]
    }, -- [56]
    {
      132147, -- [1]
      7, -- [2]
      2, -- [3]
      30798, -- [4]
    }, -- [57]
    {
      136055, -- [1]
      9, -- [2]
      1, -- [3]
      30814, -- [4]
    }, -- [58]
    {
      132148, -- [1]
      7, -- [2]
      1, -- [3]
      30819, -- [4]
    }, -- [59]
    {
      136088, -- [1]
      9, -- [2]
      2, -- [3]
      30823, -- [4]
    }, -- [60]
    {
      237581, -- [1]
      8, -- [2]
      3, -- [3]
      51522, -- [4]
    }, -- [61]
    {
      237587, -- [1]
      8, -- [2]
      1, -- [3]
      51527, -- [4]
    }, -- [62]
    {
      136024, -- [1]
      9, -- [2]
      3, -- [3]
      51524, -- [4]
    }, -- [63]
    {
      237584, -- [1]
      10, -- [2]
      2, -- [3]
      51532, -- [4]
    }, -- [64]
    {
      237577, -- [1]
      11, -- [2]
      2, -- [3]
      51533, -- [4]
    }, -- [65]
    {
      136012, -- [1]
      5, -- [2]
      3, -- [3]
      51885, -- [4]
    }, -- [66]
    {
      136097, -- [1]
      1, -- [2]
      2, -- [3]
      16130, -- [4]
    }, -- [67]
    {
      236289, -- [1]
      8, -- [2]
      2, -- [3]
      60103, -- [4]
    }, -- [68]
    {
      135776, -- [1]
      6, -- [2]
      4, -- [3]
      63374, -- [4]
    }, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136109, -- [1]
      3, -- [2]
      4, -- [3]
      16240, -- [4]
    }, -- [81]
    {
      135845, -- [1]
      3, -- [2]
      3, -- [3]
      55198, -- [4]
    }, -- [82]
    {
      132315, -- [1]
      3, -- [2]
      1, -- [3]
      16198, -- [4]
    }, -- [83]
    {
      136052, -- [1]
      1, -- [2]
      2, -- [3]
      16229, -- [4]
    }, -- [84]
    {
      136043, -- [1]
      3, -- [2]
      2, -- [3]
      16232, -- [4]
    }, -- [85]
    {
      136053, -- [1]
      4, -- [2]
      2, -- [3]
      16206, -- [4]
    }, -- [86]
    {
      136080, -- [1]
      2, -- [2]
      1, -- [3]
      16209, -- [4]
    }, -- [87]
    {
      135861, -- [1]
      7, -- [2]
      2, -- [3]
      16190, -- [4]
    }, -- [88]
    {
      136076, -- [1]
      5, -- [2]
      3, -- [3]
      16188, -- [4]
    }, -- [89]
    {
      135865, -- [1]
      6, -- [2]
      3, -- [3]
      16213, -- [4]
    }, -- [90]
    {
      135859, -- [1]
      2, -- [2]
      3, -- [3]
      16217, -- [4]
    }, -- [91]
    {
      136107, -- [1]
      4, -- [2]
      3, -- [3]
      16221, -- [4]
    }, -- [92]
    {
      136057, -- [1]
      1, -- [2]
      3, -- [3]
      16225, -- [4]
    }, -- [93]
    {
      136041, -- [1]
      2, -- [2]
      2, -- [3]
      29191, -- [4]
    }, -- [94]
    {
      136044, -- [1]
      5, -- [2]
      1, -- [3]
      29202, -- [4]
    }, -- [95]
    {
      136035, -- [1]
      5, -- [2]
      4, -- [3]
      30866, -- [4]
    }, -- [96]
    {
      136059, -- [1]
      8, -- [2]
      3, -- [3]
      30869, -- [4]
    }, -- [97]
    {
      136042, -- [1]
      8, -- [2]
      2, -- [3]
      30873, -- [4]
    }, -- [98]
    {
      136089, -- [1]
      9, -- [2]
      2, -- [3]
      974, -- [4]
    }, -- [99]
    {
      136060, -- [1]
      7, -- [2]
      1, -- [3]
      30886, -- [4]
    }, -- [100]
    {
      136089, -- [1]
      9, -- [2]
      3, -- [3]
      51561, -- [4]
    }, -- [101]
    {
      237573, -- [1]
      8, -- [2]
      1, -- [3]
      51555, -- [4]
    }, -- [102]
    {
      237571, -- [1]
      9, -- [2]
      1, -- [3]
      51558, -- [4]
    }, -- [103]
    {
      237590, -- [1]
      10, -- [2]
      2, -- [3]
      51566, -- [4]
    }, -- [104]
    {
      252995, -- [1]
      11, -- [2]
      2, -- [3]
      61295, -- [4]
    }, -- [105]
    {
      236288, -- [1]
      7, -- [2]
      3, -- [3]
      51886, -- [4]
    }, -- [106]
    [121] = {
      "ShamanElementalCombat", -- [1]
      "ShamanEnhancement", -- [2]
      "ShamanRestoration", -- [3]
    },
  },
  ["MAGE"] = {
    {
      135894, -- [1]
      1, -- [2]
      1, -- [3]
      12592, -- [4]
    }, -- [1]
    {
      136170, -- [1]
      2, -- [2]
      3, -- [3]
      12577, -- [4]
    }, -- [2]
    {
      135892, -- [1]
      1, -- [2]
      2, -- [3]
      12840, -- [4]
    }, -- [3]
    {
      136129, -- [1]
      5, -- [2]
      4, -- [3]
      12503, -- [4]
    }, -- [4]
    {
      136096, -- [1]
      1, -- [2]
      3, -- [3]
      16770, -- [4]
    }, -- [5]
    {
      136116, -- [1]
      3, -- [2]
      2, -- [3]
      12469, -- [4]
    }, -- [6]
    {
      136006, -- [1]
      3, -- [2]
      1, -- [3]
      12606, -- [4]
    }, -- [7]
    {
      136153, -- [1]
      4, -- [2]
      1, -- [3]
      12605, -- [4]
    }, -- [8]
    {
      135733, -- [1]
      2, -- [2]
      1, -- [3]
      54659, -- [4]
    }, -- [9]
    {
      136031, -- [1]
      5, -- [2]
      2, -- [3]
      12043, -- [4]
    }, -- [10]
    {
      136048, -- [1]
      7, -- [2]
      2, -- [3]
      12042, -- [4]
    }, -- [11]
    {
      135856, -- [1]
      4, -- [2]
      2, -- [3]
      12598, -- [4]
    }, -- [12]
    {
      136222, -- [1]
      6, -- [2]
      2, -- [3]
      15060, -- [4]
    }, -- [13]
    {
      136208, -- [1]
      4, -- [2]
      3, -- [3]
      18464, -- [4]
    }, -- [14]
    {
      136011, -- [1]
      2, -- [2]
      2, -- [3]
      29444, -- [4]
    }, -- [15]
    {
      135736, -- [1]
      5, -- [2]
      1, -- [3]
      31570, -- [4]
    }, -- [16]
    {
      135732, -- [1]
      6, -- [2]
      3, -- [3]
      31572, -- [4]
    }, -- [17]
    {
      135752, -- [1]
      6, -- [2]
      1, -- [3]
      54354, -- [4]
    }, -- [18]
    {
      136096, -- [1]
      7, -- [2]
      1, -- [3]
      31583, -- [4]
    }, -- [19]
    {
      135740, -- [1]
      8, -- [2]
      3, -- [3]
      31588, -- [4]
    }, -- [20]
    {
      136091, -- [1]
      9, -- [2]
      2, -- [3]
      31589, -- [4]
    }, -- [21]
    {
      135734, -- [1]
      10, -- [2]
      3, -- [3]
      35581, -- [4]
    }, -- [22]
    {
      236223, -- [1]
      8, -- [2]
      2, -- [3]
      44379, -- [4]
    }, -- [23]
    {
      236219, -- [1]
      7, -- [2]
      3, -- [3]
      44396, -- [4]
    }, -- [24]
    {
      236225, -- [1]
      3, -- [2]
      3, -- [3]
      44399, -- [4]
    }, -- [25]
    {
      236222, -- [1]
      10, -- [2]
      2, -- [3]
      44403, -- [4]
    }, -- [26]
    {
      236205, -- [1]
      11, -- [2]
      2, -- [3]
      44425, -- [4]
    }, -- [27]
    {
      236221, -- [1]
      9, -- [2]
      3, -- [3]
      54490, -- [4]
    }, -- [28]
    {
      135754, -- [1]
      3, -- [2]
      4, -- [3]
      54646, -- [4]
    }, -- [29]
    {
      236226, -- [1]
      4, -- [2]
      4, -- [3]
      55340, -- [4]
    }, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135805, -- [1]
      3, -- [2]
      4, -- [3]
      12351, -- [4]
    }, -- [41]
    {
      135806, -- [1]
      4, -- [2]
      2, -- [3]
      13043, -- [4]
    }, -- [42]
    {
      135827, -- [1]
      4, -- [2]
      1, -- [3]
      12873, -- [4]
    }, -- [43]
    {
      135812, -- [1]
      1, -- [2]
      3, -- [3]
      12341, -- [4]
    }, -- [44]
    {
      135807, -- [1]
      1, -- [2]
      1, -- [3]
      11080, -- [4]
    }, -- [45]
    {
      135815, -- [1]
      3, -- [2]
      1, -- [3]
      12353, -- [4]
    }, -- [46]
    {
      135808, -- [1]
      3, -- [2]
      3, -- [3]
      11366, -- [4]
    }, -- [47]
    {
      135821, -- [1]
      3, -- [2]
      2, -- [3]
      12358, -- [4]
    }, -- [48]
    {
      236228, -- [1]
      2, -- [2]
      3, -- [3]
      12350, -- [4]
    }, -- [49]
    {
      135903, -- [1]
      5, -- [2]
      3, -- [3]
      11113, -- [4]
    }, -- [50]
    {
      136115, -- [1]
      5, -- [2]
      2, -- [3]
      11368, -- [4]
    }, -- [51]
    {
      135818, -- [1]
      2, -- [2]
      1, -- [3]
      12848, -- [4]
    }, -- [52]
    {
      135817, -- [1]
      6, -- [2]
      3, -- [3]
      12400, -- [4]
    }, -- [53]
    {
      135824, -- [1]
      7, -- [2]
      2, -- [3]
      11129, -- [4]
    }, -- [54]
    {
      135813, -- [1]
      1, -- [2]
      2, -- [3]
      54734, -- [4]
    }, -- [55]
    {
      135820, -- [1]
      4, -- [2]
      4, -- [3]
      29076, -- [4]
    }, -- [56]
    {
      135823, -- [1]
      5, -- [2]
      1, -- [3]
      31640, -- [4]
    }, -- [57]
    {
      135788, -- [1]
      6, -- [2]
      1, -- [3]
      31642, -- [4]
    }, -- [58]
    {
      135822, -- [1]
      7, -- [2]
      3, -- [3]
      31680, -- [4]
    }, -- [59]
    {
      135789, -- [1]
      7, -- [2]
      1, -- [3]
      34296, -- [4]
    }, -- [60]
    {
      135812, -- [1]
      8, -- [2]
      3, -- [3]
      31658, -- [4]
    }, -- [61]
    {
      134153, -- [1]
      9, -- [2]
      2, -- [3]
      31661, -- [4]
    }, -- [62]
    {
      236215, -- [1]
      8, -- [2]
      1, -- [3]
      64357, -- [4]
    }, -- [63]
    {
      236216, -- [1]
      9, -- [2]
      1, -- [3]
      44443, -- [4]
    }, -- [64]
    {
      236218, -- [1]
      9, -- [2]
      3, -- [3]
      44448, -- [4]
    }, -- [65]
    {
      236207, -- [1]
      10, -- [2]
      2, -- [3]
      44472, -- [4]
    }, -- [66]
    {
      236220, -- [1]
      11, -- [2]
      2, -- [3]
      44457, -- [4]
    }, -- [67]
    {
      135829, -- [1]
      2, -- [2]
      2, -- [3]
      54749, -- [4]
    }, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      135846, -- [1]
      1, -- [2]
      2, -- [3]
      16766, -- [4]
    }, -- [81]
    {
      135842, -- [1]
      1, -- [2]
      1, -- [3]
      12497, -- [4]
    }, -- [82]
    {
      135845, -- [1]
      3, -- [2]
      1, -- [3]
      12953, -- [4]
    }, -- [83]
    {
      135854, -- [1]
      1, -- [2]
      3, -- [3]
      55094, -- [4]
    }, -- [84]
    {
      135857, -- [1]
      3, -- [2]
      3, -- [3]
      12488, -- [4]
    }, -- [85]
    {
      135852, -- [1]
      5, -- [2]
      3, -- [3]
      12490, -- [4]
    }, -- [86]
    {
      135864, -- [1]
      2, -- [2]
      4, -- [3]
      12571, -- [4]
    }, -- [87]
    {
      135860, -- [1]
      4, -- [2]
      2, -- [3]
      12519, -- [4]
    }, -- [88]
    {
      135849, -- [1]
      4, -- [2]
      3, -- [3]
      12983, -- [4]
    }, -- [89]
    {
      135836, -- [1]
      6, -- [2]
      3, -- [3]
      28593, -- [4]
    }, -- [90]
    {
      135838, -- [1]
      3, -- [2]
      2, -- [3]
      12472, -- [4]
    }, -- [91]
    {
      135850, -- [1]
      2, -- [2]
      2, -- [3]
      28332, -- [4]
    }, -- [92]
    {
      135988, -- [1]
      7, -- [2]
      2, -- [3]
      11426, -- [4]
    }, -- [93]
    {
      135865, -- [1]
      5, -- [2]
      2, -- [3]
      11958, -- [4]
    }, -- [94]
    {
      135855, -- [1]
      2, -- [2]
      1, -- [3]
      15047, -- [4]
    }, -- [95]
    {
      136141, -- [1]
      4, -- [2]
      1, -- [3]
      16758, -- [4]
    }, -- [96]
    {
      135989, -- [1]
      2, -- [2]
      3, -- [3]
      29440, -- [4]
    }, -- [97]
    {
      135851, -- [1]
      5, -- [2]
      4, -- [3]
      31669, -- [4]
    }, -- [98]
    {
      236209, -- [1]
      6, -- [2]
      1, -- [3]
      55092, -- [4]
    }, -- [99]
    {
      135833, -- [1]
      7, -- [2]
      3, -- [3]
      31678, -- [4]
    }, -- [100]
    {
      135846, -- [1]
      8, -- [2]
      2, -- [3]
      31683, -- [4]
    }, -- [101]
    {
      135862, -- [1]
      9, -- [2]
      2, -- [3]
      31687, -- [4]
    }, -- [102]
    {
      236227, -- [1]
      8, -- [2]
      3, -- [3]
      44545, -- [4]
    }, -- [103]
    {
      236206, -- [1]
      9, -- [2]
      1, -- [3]
      44549, -- [4]
    }, -- [104]
    {
      135862, -- [1]
      9, -- [2]
      3, -- [3]
      44561, -- [4]
    }, -- [105]
    {
      236208, -- [1]
      10, -- [2]
      2, -- [3]
      44571, -- [4]
    }, -- [106]
    {
      236214, -- [1]
      11, -- [2]
      2, -- [3]
      44572, -- [4]
    }, -- [107]
    {
      236224, -- [1]
      7, -- [2]
      1, -- [3]
      54787, -- [4]
    }, -- [108]
    [121] = {
      "MageArcane", -- [1]
      "MageFire", -- [2]
      "MageFrost", -- [3]
    },
  },
  ["PRIEST"] = {
    {
      136107, -- [1]
      2, -- [2]
      4, -- [3]
      14774, -- [4]
    }, -- [1]
    {
      135939, -- [1]
      7, -- [2]
      2, -- [3]
      10060, -- [4]
    }, -- [2]
    {
      132156, -- [1]
      4, -- [2]
      2, -- [3]
      14781, -- [4]
    }, -- [3]
    {
      135995, -- [1]
      1, -- [2]
      2, -- [3]
      14791, -- [4]
    }, -- [4]
    {
      135940, -- [1]
      3, -- [2]
      3, -- [3]
      14769, -- [4]
    }, -- [5]
    {
      135987, -- [1]
      2, -- [2]
      3, -- [3]
      14767, -- [4]
    }, -- [6]
    {
      135926, -- [1]
      2, -- [2]
      2, -- [3]
      14771, -- [4]
    }, -- [7]
    {
      136090, -- [1]
      3, -- [2]
      1, -- [3]
      14777, -- [4]
    }, -- [8]
    {
      135863, -- [1]
      3, -- [2]
      2, -- [3]
      14751, -- [4]
    }, -- [9]
    {
      136170, -- [1]
      4, -- [2]
      4, -- [3]
      14772, -- [4]
    }, -- [10]
    {
      135948, -- [1]
      5, -- [2]
      3, -- [3]
      63574, -- [4]
    }, -- [11]
    {
      136053, -- [1]
      2, -- [2]
      1, -- [3]
      14785, -- [4]
    }, -- [12]
    {
      136031, -- [1]
      5, -- [2]
      2, -- [3]
      18555, -- [4]
    }, -- [13]
    {
      237538, -- [1]
      10, -- [2]
      2, -- [3]
      52800, -- [4]
    }, -- [14]
    {
      135868, -- [1]
      4, -- [2]
      1, -- [3]
      33172, -- [4]
    }, -- [15]
    {
      136158, -- [1]
      6, -- [2]
      1, -- [3]
      33190, -- [4]
    }, -- [16]
    {
      135740, -- [1]
      6, -- [2]
      3, -- [3]
      34910, -- [4]
    }, -- [17]
    {
      135886, -- [1]
      7, -- [2]
      3, -- [3]
      63506, -- [4]
    }, -- [18]
    {
      135936, -- [1]
      9, -- [2]
      2, -- [3]
      33206, -- [4]
    }, -- [19]
    {
      135737, -- [1]
      7, -- [2]
      1, -- [3]
      45244, -- [4]
    }, -- [20]
    {
      237537, -- [1]
      8, -- [2]
      3, -- [3]
      47508, -- [4]
    }, -- [21]
    {
      237539, -- [1]
      9, -- [2]
      1, -- [3]
      47515, -- [4]
    }, -- [22]
    {
      237548, -- [1]
      8, -- [2]
      2, -- [3]
      47537, -- [4]
    }, -- [23]
    {
      237545, -- [1]
      11, -- [2]
      2, -- [3]
      47540, -- [4]
    }, -- [24]
    {
      135969, -- [1]
      1, -- [2]
      3, -- [3]
      52803, -- [4]
    }, -- [25]
    {
      237543, -- [1]
      9, -- [2]
      3, -- [3]
      47517, -- [4]
    }, -- [26]
    {
      135923, -- [1]
      8, -- [2]
      1, -- [3]
      57472, -- [4]
    }, -- [27]
    {
      135940, -- [1]
      5, -- [2]
      1, -- [3]
      33202, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135928, -- [1]
      3, -- [2]
      4, -- [3]
      15363, -- [4]
    }, -- [41]
    {
      135967, -- [1]
      1, -- [2]
      3, -- [3]
      15011, -- [4]
    }, -- [42]
    {
      135977, -- [1]
      5, -- [2]
      3, -- [3]
      15031, -- [4]
    }, -- [43]
    {
      135973, -- [1]
      4, -- [2]
      3, -- [3]
      15017, -- [4]
    }, -- [44]
    {
      136057, -- [1]
      6, -- [2]
      3, -- [3]
      15356, -- [4]
    }, -- [45]
    {
      135953, -- [1]
      1, -- [2]
      2, -- [3]
      17191, -- [4]
    }, -- [46]
    {
      135916, -- [1]
      4, -- [2]
      2, -- [3]
      15014, -- [4]
    }, -- [47]
    {
      135918, -- [1]
      1, -- [2]
      1, -- [3]
      15012, -- [4]
    }, -- [48]
    {
      135976, -- [1]
      2, -- [2]
      2, -- [3]
      27904, -- [4]
    }, -- [49]
    {
      135943, -- [1]
      5, -- [2]
      1, -- [3]
      15018, -- [4]
    }, -- [50]
    {
      135954, -- [1]
      3, -- [2]
      1, -- [3]
      19236, -- [4]
    }, -- [51]
    {
      135971, -- [1]
      2, -- [2]
      3, -- [3]
      18535, -- [4]
    }, -- [52]
    {
      132864, -- [1]
      5, -- [2]
      2, -- [3]
      20711, -- [4]
    }, -- [53]
    {
      135949, -- [1]
      4, -- [2]
      1, -- [3]
      27790, -- [4]
    }, -- [54]
    {
      135877, -- [1]
      3, -- [2]
      2, -- [3]
      27816, -- [4]
    }, -- [55]
    {
      135980, -- [1]
      7, -- [2]
      2, -- [3]
      724, -- [4]
    }, -- [56]
    {
      135878, -- [1]
      7, -- [2]
      3, -- [3]
      33146, -- [4]
    }, -- [57]
    {
      135981, -- [1]
      6, -- [2]
      1, -- [3]
      33154, -- [4]
    }, -- [58]
    {
      135913, -- [1]
      8, -- [2]
      2, -- [3]
      33162, -- [4]
    }, -- [59]
    {
      135905, -- [1]
      7, -- [2]
      1, -- [3]
      34860, -- [4]
    }, -- [60]
    {
      135887, -- [1]
      9, -- [2]
      2, -- [3]
      34861, -- [4]
    }, -- [61]
    {
      236254, -- [1]
      9, -- [2]
      1, -- [3]
      63543, -- [4]
    }, -- [62]
    {
      237550, -- [1]
      9, -- [2]
      3, -- [3]
      47560, -- [4]
    }, -- [63]
    {
      237549, -- [1]
      8, -- [2]
      3, -- [3]
      63737, -- [4]
    }, -- [64]
    {
      237541, -- [1]
      10, -- [2]
      2, -- [3]
      47567, -- [4]
    }, -- [65]
    {
      237542, -- [1]
      11, -- [2]
      2, -- [3]
      47788, -- [4]
    }, -- [66]
    {
      135982, -- [1]
      8, -- [2]
      1, -- [3]
      64129, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136123, -- [1]
      4, -- [2]
      4, -- [3]
      15332, -- [4]
    }, -- [81]
    {
      136223, -- [1]
      1, -- [2]
      3, -- [3]
      15310, -- [4]
    }, -- [82]
    {
      136126, -- [1]
      2, -- [2]
      3, -- [3]
      15328, -- [4]
    }, -- [83]
    {
      136188, -- [1]
      1, -- [2]
      1, -- [3]
      15336, -- [4]
    }, -- [84]
    {
      136205, -- [1]
      2, -- [2]
      1, -- [3]
      15320, -- [4]
    }, -- [85]
    {
      136224, -- [1]
      3, -- [2]
      2, -- [3]
      15316, -- [4]
    }, -- [86]
    {
      136207, -- [1]
      2, -- [2]
      2, -- [3]
      15317, -- [4]
    }, -- [87]
    {
      135994, -- [1]
      4, -- [2]
      2, -- [3]
      15311, -- [4]
    }, -- [88]
    {
      136230, -- [1]
      5, -- [2]
      2, -- [3]
      15286, -- [4]
    }, -- [89]
    {
      136208, -- [1]
      3, -- [2]
      3, -- [3]
      15407, -- [4]
    }, -- [90]
    {
      136200, -- [1]
      7, -- [2]
      2, -- [3]
      15473, -- [4]
    }, -- [91]
    {
      136164, -- [1]
      5, -- [2]
      1, -- [3]
      15487, -- [4]
    }, -- [92]
    {
      136184, -- [1]
      3, -- [2]
      1, -- [3]
      15448, -- [4]
    }, -- [93]
    {
      136130, -- [1]
      4, -- [2]
      3, -- [3]
      17323, -- [4]
    }, -- [94]
    {
      136165, -- [1]
      5, -- [2]
      3, -- [3]
      27840, -- [4]
    }, -- [95]
    {
      136035, -- [1]
      5, -- [2]
      4, -- [3]
      33215, -- [4]
    }, -- [96]
    {
      136204, -- [1]
      7, -- [2]
      3, -- [3]
      33225, -- [4]
    }, -- [97]
    {
      135978, -- [1]
      9, -- [2]
      2, -- [3]
      34914, -- [4]
    }, -- [98]
    {
      237569, -- [1]
      6, -- [2]
      1, -- [3]
      33371, -- [4]
    }, -- [99]
    {
      136176, -- [1]
      8, -- [2]
      3, -- [3]
      33193, -- [4]
    }, -- [100]
    {
      136221, -- [1]
      8, -- [2]
      1, -- [3]
      47570, -- [4]
    }, -- [101]
    {
      237566, -- [1]
      10, -- [2]
      3, -- [3]
      51167, -- [4]
    }, -- [102]
    {
      237568, -- [1]
      9, -- [2]
      1, -- [3]
      64044, -- [4]
    }, -- [103]
    {
      237567, -- [1]
      9, -- [2]
      3, -- [3]
      47582, -- [4]
    }, -- [104]
    {
      237563, -- [1]
      11, -- [2]
      2, -- [3]
      47585, -- [4]
    }, -- [105]
    {
      136188, -- [1]
      1, -- [2]
      2, -- [3]
      15338, -- [4]
    }, -- [106]
    {
      252996, -- [1]
      6, -- [2]
      3, -- [3]
      63627, -- [4]
    }, -- [107]
    [121] = {
      "PriestDiscipline", -- [1]
      "PriestHoly", -- [2]
      "PriestShadow", -- [3]
    },
  },
  ["WARLOCK"] = {
    {
      136157, -- [1]
      3, -- [2]
      2, -- [3]
      17785, -- [4]
    }, -- [1]
    {
      136223, -- [1]
      4, -- [2]
      2, -- [3]
      18095, -- [4]
    }, -- [2]
    {
      136118, -- [1]
      1, -- [2]
      3, -- [3]
      17814, -- [4]
    }, -- [3]
    {
      136169, -- [1]
      2, -- [2]
      4, -- [3]
      17805, -- [4]
    }, -- [4]
    {
      136230, -- [1]
      1, -- [2]
      2, -- [3]
      18176, -- [4]
    }, -- [5]
    {
      136138, -- [1]
      2, -- [2]
      1, -- [3]
      18180, -- [4]
    }, -- [6]
    {
      136126, -- [1]
      2, -- [2]
      3, -- [3]
      18183, -- [4]
    }, -- [7]
    {
      136127, -- [1]
      4, -- [2]
      1, -- [3]
      18219, -- [4]
    }, -- [8]
    {
      136141, -- [1]
      7, -- [2]
      3, -- [3]
      18220, -- [4]
    }, -- [9]
    {
      136188, -- [1]
      5, -- [2]
      2, -- [3]
      63108, -- [4]
    }, -- [10]
    {
      136195, -- [1]
      6, -- [2]
      2, -- [3]
      18275, -- [4]
    }, -- [11]
    {
      136132, -- [1]
      3, -- [2]
      3, -- [3]
      18288, -- [4]
    }, -- [12]
    {
      136162, -- [1]
      5, -- [2]
      3, -- [3]
      18223, -- [4]
    }, -- [13]
    {
      136163, -- [1]
      2, -- [2]
      2, -- [3]
      18372, -- [4]
    }, -- [14]
    {
      136139, -- [1]
      1, -- [2]
      1, -- [3]
      18829, -- [4]
    }, -- [15]
    {
      136137, -- [1]
      8, -- [2]
      3, -- [3]
      32484, -- [4]
    }, -- [16]
    {
      136147, -- [1]
      8, -- [2]
      1, -- [3]
      30057, -- [4]
    }, -- [17]
    {
      136180, -- [1]
      7, -- [2]
      2, -- [3]
      30064, -- [4]
    }, -- [18]
    {
      136228, -- [1]
      9, -- [2]
      2, -- [3]
      30108, -- [4]
    }, -- [19]
    {
      136198, -- [1]
      5, -- [2]
      1, -- [3]
      32394, -- [4]
    }, -- [20]
    {
      136118, -- [1]
      4, -- [2]
      4, -- [3]
      32383, -- [4]
    }, -- [21]
    {
      136217, -- [1]
      6, -- [2]
      1, -- [3]
      54038, -- [4]
    }, -- [22]
    {
      237557, -- [1]
      9, -- [2]
      1, -- [3]
      47200, -- [4]
    }, -- [23]
    {
      236296, -- [1]
      10, -- [2]
      2, -- [3]
      47205, -- [4]
    }, -- [24]
    {
      236295, -- [1]
      7, -- [2]
      1, -- [3]
      47197, -- [4]
    }, -- [25]
    {
      236298, -- [1]
      11, -- [2]
      2, -- [3]
      48181, -- [4]
    }, -- [26]
    {
      136183, -- [1]
      3, -- [2]
      1, -- [3]
      53759, -- [4]
    }, -- [27]
    {
      136227, -- [1]
      9, -- [2]
      3, -- [3]
      58435, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135230, -- [1]
      1, -- [2]
      1, -- [3]
      18693, -- [4]
    }, -- [41]
    {
      136218, -- [1]
      1, -- [2]
      2, -- [3]
      18696, -- [4]
    }, -- [42]
    {
      136172, -- [1]
      1, -- [2]
      3, -- [3]
      18699, -- [4]
    }, -- [43]
    {
      136168, -- [1]
      2, -- [2]
      1, -- [3]
      18704, -- [4]
    }, -- [44]
    {
      136221, -- [1]
      2, -- [2]
      2, -- [3]
      18707, -- [4]
    }, -- [45]
    {
      136082, -- [1]
      3, -- [2]
      3, -- [3]
      18708, -- [4]
    }, -- [46]
    {
      136164, -- [1]
      4, -- [2]
      3, -- [3]
      18710, -- [4]
    }, -- [47]
    {
      135932, -- [1]
      2, -- [2]
      3, -- [3]
      18744, -- [4]
    }, -- [48]
    {
      136220, -- [1]
      3, -- [2]
      1, -- [3]
      18756, -- [4]
    }, -- [49]
    {
      136203, -- [1]
      6, -- [2]
      2, -- [3]
      23825, -- [4]
    }, -- [50]
    {
      132386, -- [1]
      5, -- [2]
      3, -- [3]
      18768, -- [4]
    }, -- [51]
    {
      136206, -- [1]
      4, -- [2]
      2, -- [3]
      18773, -- [4]
    }, -- [52]
    {
      136165, -- [1]
      7, -- [2]
      3, -- [3]
      35693, -- [4]
    }, -- [53]
    {
      136171, -- [1]
      5, -- [2]
      1, -- [3]
      30326, -- [4]
    }, -- [54]
    {
      136160, -- [1]
      3, -- [2]
      2, -- [3]
      19028, -- [4]
    }, -- [55]
    {
      236301, -- [1]
      6, -- [2]
      3, -- [3]
      47247, -- [4]
    }, -- [56]
    {
      136185, -- [1]
      3, -- [2]
      4, -- [3]
      30145, -- [4]
    }, -- [57]
    {
      136216, -- [1]
      9, -- [2]
      2, -- [3]
      30146, -- [4]
    }, -- [58]
    {
      136150, -- [1]
      8, -- [2]
      2, -- [3]
      30248, -- [4]
    }, -- [59]
    {
      136149, -- [1]
      7, -- [2]
      1, -- [3]
      30321, -- [4]
    }, -- [60]
    {
      236292, -- [1]
      7, -- [2]
      2, -- [3]
      47193, -- [4]
    }, -- [61]
    {
      236299, -- [1]
      9, -- [2]
      1, -- [3]
      54349, -- [4]
    }, -- [62]
    {
      237564, -- [1]
      1, -- [2]
      4, -- [3]
      47231, -- [4]
    }, -- [63]
    {
      237561, -- [1]
      9, -- [2]
      3, -- [3]
      63123, -- [4]
    }, -- [64]
    {
      237562, -- [1]
      10, -- [2]
      2, -- [3]
      47240, -- [4]
    }, -- [65]
    {
      237558, -- [1]
      11, -- [2]
      2, -- [3]
      59672, -- [4]
    }, -- [66]
    {
      135808, -- [1]
      8, -- [2]
      3, -- [3]
      63158, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      135831, -- [1]
      2, -- [2]
      3, -- [3]
      17780, -- [4]
    }, -- [81]
    {
      136146, -- [1]
      1, -- [2]
      3, -- [3]
      17792, -- [4]
    }, -- [82]
    {
      136197, -- [1]
      1, -- [2]
      2, -- [3]
      17803, -- [4]
    }, -- [83]
    {
      135817, -- [1]
      5, -- [2]
      2, -- [3]
      17834, -- [4]
    }, -- [84]
    {
      136191, -- [1]
      3, -- [2]
      2, -- [3]
      17877, -- [4]
    }, -- [85]
    {
      136133, -- [1]
      4, -- [2]
      2, -- [3]
      17918, -- [4]
    }, -- [86]
    {
      135827, -- [1]
      4, -- [2]
      4, -- [3]
      17930, -- [4]
    }, -- [87]
    {
      135826, -- [1]
      6, -- [2]
      3, -- [3]
      17958, -- [4]
    }, -- [88]
    {
      136207, -- [1]
      3, -- [2]
      3, -- [3]
      59741, -- [4]
    }, -- [89]
    {
      135807, -- [1]
      7, -- [2]
      2, -- [3]
      17962, -- [4]
    }, -- [90]
    {
      135813, -- [1]
      5, -- [2]
      3, -- [3]
      18130, -- [4]
    }, -- [91]
    {
      135805, -- [1]
      2, -- [2]
      1, -- [3]
      18120, -- [4]
    }, -- [92]
    {
      135809, -- [1]
      3, -- [2]
      1, -- [3]
      18127, -- [4]
    }, -- [93]
    {
      135819, -- [1]
      4, -- [2]
      1, -- [3]
      18136, -- [4]
    }, -- [94]
    {
      135830, -- [1]
      7, -- [2]
      4, -- [3]
      63245, -- [4]
    }, -- [95]
    {
      136201, -- [1]
      9, -- [2]
      2, -- [3]
      30283, -- [4]
    }, -- [96]
    {
      136196, -- [1]
      8, -- [2]
      2, -- [3]
      30292, -- [4]
    }, -- [97]
    {
      136214, -- [1]
      7, -- [2]
      3, -- [3]
      30296, -- [4]
    }, -- [98]
    {
      136178, -- [1]
      6, -- [2]
      1, -- [3]
      30302, -- [4]
    }, -- [99]
    {
      135823, -- [1]
      5, -- [2]
      1, -- [3]
      34939, -- [4]
    }, -- [100]
    {
      132221, -- [1]
      2, -- [2]
      2, -- [3]
      63351, -- [4]
    }, -- [101]
    {
      236290, -- [1]
      9, -- [2]
      1, -- [3]
      47260, -- [4]
    }, -- [102]
    {
      236300, -- [1]
      8, -- [2]
      3, -- [3]
      54118, -- [4]
    }, -- [103]
    {
      236297, -- [1]
      10, -- [2]
      2, -- [3]
      47270, -- [4]
    }, -- [104]
    {
      236291, -- [1]
      11, -- [2]
      2, -- [3]
      50796, -- [4]
    }, -- [105]
    {
      236294, -- [1]
      9, -- [2]
      3, -- [3]
      47223, -- [4]
    }, -- [106]
    [121] = {
      "WarlockCurses", -- [1]
      "WarlockSummoning", -- [2]
      "WarlockDestruction", -- [3]
    },
  },
  ["HUNTER"] = {
    {
      132159, -- [1]
      2, -- [2]
      2, -- [3]
      19551, -- [4]
    }, -- [1]
    {
      136076, -- [1]
      1, -- [2]
      2, -- [3]
      19556, -- [4]
    }, -- [2]
    {
      132242, -- [1]
      3, -- [2]
      1, -- [3]
      19560, -- [4]
    }, -- [3]
    {
      132179, -- [1]
      4, -- [2]
      2, -- [3]
      19573, -- [4]
    }, -- [4]
    {
      132127, -- [1]
      7, -- [2]
      2, -- [3]
      19574, -- [4]
    }, -- [5]
    {
      132111, -- [1]
      5, -- [2]
      2, -- [3]
      19577, -- [4]
    }, -- [6]
    {
      132121, -- [1]
      5, -- [2]
      1, -- [3]
      20895, -- [4]
    }, -- [7]
    {
      136080, -- [1]
      1, -- [2]
      3, -- [3]
      19587, -- [4]
    }, -- [8]
    {
      136006, -- [1]
      5, -- [2]
      4, -- [3]
      19592, -- [4]
    }, -- [9]
    {
      134297, -- [1]
      4, -- [2]
      3, -- [3]
      19602, -- [4]
    }, -- [10]
    {
      134355, -- [1]
      2, -- [2]
      3, -- [3]
      19612, -- [4]
    }, -- [11]
    {
      132091, -- [1]
      3, -- [2]
      3, -- [3]
      19620, -- [4]
    }, -- [12]
    {
      134296, -- [1]
      6, -- [2]
      3, -- [3]
      19625, -- [4]
    }, -- [13]
    {
      132210, -- [1]
      2, -- [2]
      1, -- [3]
      35030, -- [4]
    }, -- [14]
    {
      132163, -- [1]
      2, -- [2]
      4, -- [3]
      19575, -- [4]
    }, -- [15]
    {
      132158, -- [1]
      6, -- [2]
      1, -- [3]
      34454, -- [4]
    }, -- [16]
    {
      132173, -- [1]
      7, -- [2]
      1, -- [3]
      34460, -- [4]
    }, -- [17]
    {
      132167, -- [1]
      7, -- [2]
      3, -- [3]
      34465, -- [4]
    }, -- [18]
    {
      132209, -- [1]
      8, -- [2]
      3, -- [3]
      34470, -- [4]
    }, -- [19]
    {
      132166, -- [1]
      9, -- [2]
      2, -- [3]
      34692, -- [4]
    }, -- [20]
    {
      236184, -- [1]
      8, -- [2]
      1, -- [3]
      53253, -- [4]
    }, -- [21]
    {
      236177, -- [1]
      9, -- [2]
      3, -- [3]
      53260, -- [4]
    }, -- [22]
    {
      236172, -- [1]
      3, -- [2]
      2, -- [3]
      53265, -- [4]
    }, -- [23]
    {
      236175, -- [1]
      11, -- [2]
      2, -- [3]
      53270, -- [4]
    }, -- [24]
    {
      236186, -- [1]
      9, -- [2]
      1, -- [3]
      53264, -- [4]
    }, -- [25]
    {
      236202, -- [1]
      10, -- [2]
      2, -- [3]
      56318, -- [4]
    }, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      135860, -- [1]
      1, -- [2]
      1, -- [3]
      19412, -- [4]
    }, -- [41]
    {
      135865, -- [1]
      4, -- [2]
      3, -- [3]
      19420, -- [4]
    }, -- [42]
    {
      132212, -- [1]
      2, -- [2]
      2, -- [3]
      19423, -- [4]
    }, -- [43]
    {
      132312, -- [1]
      1, -- [2]
      3, -- [3]
      19431, -- [4]
    }, -- [44]
    {
      135130, -- [1]
      3, -- [2]
      3, -- [3]
      19434, -- [4]
    }, -- [45]
    {
      132218, -- [1]
      3, -- [2]
      2, -- [3]
      19456, -- [4]
    }, -- [46]
    {
      132330, -- [1]
      5, -- [2]
      3, -- [3]
      24691, -- [4]
    }, -- [47]
    {
      132204, -- [1]
      4, -- [2]
      2, -- [3]
      19466, -- [4]
    }, -- [48]
    {
      132271, -- [1]
      2, -- [2]
      3, -- [3]
      19490, -- [4]
    }, -- [49]
    {
      135753, -- [1]
      5, -- [2]
      1, -- [3]
      35102, -- [4]
    }, -- [50]
    {
      132206, -- [1]
      5, -- [2]
      2, -- [3]
      23989, -- [4]
    }, -- [51]
    {
      132329, -- [1]
      7, -- [2]
      2, -- [3]
      19506, -- [4]
    }, -- [52]
    {
      135615, -- [1]
      6, -- [2]
      4, -- [3]
      19509, -- [4]
    }, -- [53]
    {
      132168, -- [1]
      6, -- [2]
      1, -- [3]
      34476, -- [4]
    }, -- [54]
    {
      132217, -- [1]
      2, -- [2]
      1, -- [3]
      34484, -- [4]
    }, -- [55]
    {
      132177, -- [1]
      8, -- [2]
      2, -- [3]
      34489, -- [4]
    }, -- [56]
    {
      132323, -- [1]
      9, -- [2]
      2, -- [3]
      34490, -- [4]
    }, -- [57]
    {
      132174, -- [1]
      3, -- [2]
      1, -- [3]
      34954, -- [4]
    }, -- [58]
    {
      132205, -- [1]
      3, -- [2]
      4, -- [3]
      34949, -- [4]
    }, -- [59]
    {
      132330, -- [1]
      7, -- [2]
      3, -- [3]
      35111, -- [4]
    }, -- [60]
    {
      236198, -- [1]
      7, -- [2]
      1, -- [3]
      53238, -- [4]
    }, -- [61]
    {
      236201, -- [1]
      8, -- [2]
      3, -- [3]
      53232, -- [4]
    }, -- [62]
    {
      236204, -- [1]
      9, -- [2]
      1, -- [3]
      53217, -- [4]
    }, -- [63]
    {
      236182, -- [1]
      9, -- [2]
      3, -- [3]
      53224, -- [4]
    }, -- [64]
    {
      236173, -- [1]
      10, -- [2]
      2, -- [3]
      53246, -- [4]
    }, -- [65]
    {
      236176, -- [1]
      11, -- [2]
      2, -- [3]
      53209, -- [4]
    }, -- [66]
    {
      236179, -- [1]
      1, -- [2]
      2, -- [3]
      53622, -- [4]
    }, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136047, -- [1]
      6, -- [2]
      1, -- [3]
      24297, -- [4]
    }, -- [81]
    {
      136100, -- [1]
      2, -- [2]
      2, -- [3]
      19388, -- [4]
    }, -- [82]
    {
      132149, -- [1]
      2, -- [2]
      3, -- [3]
      63458, -- [4]
    }, -- [83]
    {
      236185, -- [1]
      4, -- [2]
      4, -- [3]
      56344, -- [4]
    }, -- [84]
    {
      132293, -- [1]
      3, -- [2]
      4, -- [3]
      19287, -- [4]
    }, -- [85]
    {
      132219, -- [1]
      2, -- [2]
      1, -- [3]
      24283, -- [4]
    }, -- [86]
    {
      132269, -- [1]
      3, -- [2]
      3, -- [3]
      19298, -- [4]
    }, -- [87]
    {
      132336, -- [1]
      5, -- [2]
      3, -- [3]
      19306, -- [4]
    }, -- [88]
    {
      135881, -- [1]
      5, -- [2]
      2, -- [3]
      19373, -- [4]
    }, -- [89]
    {
      136181, -- [1]
      9, -- [2]
      2, -- [3]
      3674, -- [4]
    }, -- [90]
    {
      135125, -- [1]
      7, -- [2]
      2, -- [3]
      19386, -- [4]
    }, -- [91]
    {
      132277, -- [1]
      1, -- [2]
      3, -- [3]
      19160, -- [4]
    }, -- [92]
    {
      136223, -- [1]
      3, -- [2]
      1, -- [3]
      19259, -- [4]
    }, -- [93]
    {
      236183, -- [1]
      1, -- [2]
      1, -- [3]
      52788, -- [4]
    }, -- [94]
    {
      132207, -- [1]
      6, -- [2]
      3, -- [3]
      34493, -- [4]
    }, -- [95]
    {
      132214, -- [1]
      2, -- [2]
      4, -- [3]
      34496, -- [4]
    }, -- [96]
    {
      132216, -- [1]
      7, -- [2]
      3, -- [3]
      34499, -- [4]
    }, -- [97]
    {
      132295, -- [1]
      7, -- [2]
      1, -- [3]
      34503, -- [4]
    }, -- [98]
    {
      132178, -- [1]
      8, -- [2]
      1, -- [3]
      34839, -- [4]
    }, -- [99]
    {
      132153, -- [1]
      3, -- [2]
      2, -- [3]
      19503, -- [4]
    }, -- [100]
    {
      132327, -- [1]
      1, -- [2]
      2, -- [3]
      19500, -- [4]
    }, -- [101]
    {
      236200, -- [1]
      8, -- [2]
      2, -- [3]
      53297, -- [4]
    }, -- [102]
    {
      236199, -- [1]
      9, -- [2]
      1, -- [3]
      53299, -- [4]
    }, -- [103]
    {
      236187, -- [1]
      9, -- [2]
      4, -- [3]
      53304, -- [4]
    }, -- [104]
    {
      236181, -- [1]
      10, -- [2]
      3, -- [3]
      53292, -- [4]
    }, -- [105]
    {
      236178, -- [1]
      11, -- [2]
      2, -- [3]
      53301, -- [4]
    }, -- [106]
    {
      236180, -- [1]
      5, -- [2]
      1, -- [3]
      56341, -- [4]
    }, -- [107]
    {
      133713, -- [1]
      4, -- [2]
      2, -- [3]
      56337, -- [4]
    }, -- [108]
    [121] = {
      "HunterBeastMastery", -- [1]
      "HunterMarksmanship", -- [2]
      "HunterSurvival", -- [3]
    },
  },
  ["DRUID"] = {
    {
      136006, -- [1]
      1, -- [2]
      2, -- [3]
      16818, -- [4]
    }, -- [1]
    {
      136096, -- [1]
      2, -- [2]
      4, -- [3]
      16822, -- [4]
    }, -- [2]
    {
      136065, -- [1]
      3, -- [2]
      4, -- [3]
      16820, -- [4]
    }, -- [3]
    {
      136104, -- [1]
      3, -- [2]
      1, -- [3]
      16840, -- [4]
    }, -- [4]
    {
      136087, -- [1]
      2, -- [2]
      1, -- [3]
      16847, -- [4]
    }, -- [5]
    {
      135753, -- [1]
      4, -- [2]
      3, -- [3]
      16924, -- [4]
    }, -- [6]
    {
      136045, -- [1]
      5, -- [2]
      2, -- [3]
      5570, -- [4]
    }, -- [7]
    {
      136062, -- [1]
      3, -- [2]
      2, -- [3]
      61346, -- [4]
    }, -- [8]
    {
      136057, -- [1]
      6, -- [2]
      2, -- [3]
      16899, -- [4]
    }, -- [9]
    {
      136075, -- [1]
      4, -- [2]
      2, -- [3]
      16913, -- [4]
    }, -- [10]
    {
      136036, -- [1]
      7, -- [2]
      2, -- [3]
      24858, -- [4]
    }, -- [11]
    {
      132132, -- [1]
      5, -- [2]
      1, -- [3]
      33591, -- [4]
    }, -- [12]
    {
      132113, -- [1]
      6, -- [2]
      3, -- [3]
      33596, -- [4]
    }, -- [13]
    {
      132123, -- [1]
      6, -- [2]
      1, -- [3]
      33956, -- [4]
    }, -- [14]
    {
      136033, -- [1]
      7, -- [2]
      4, -- [3]
      33602, -- [4]
    }, -- [15]
    {
      132146, -- [1]
      8, -- [2]
      3, -- [3]
      33607, -- [4]
    }, -- [16]
    {
      132129, -- [1]
      9, -- [2]
      3, -- [3]
      33831, -- [4]
    }, -- [17]
    {
      135138, -- [1]
      2, -- [2]
      2, -- [3]
      35364, -- [4]
    }, -- [18]
    {
      236156, -- [1]
      7, -- [2]
      3, -- [3]
      48396, -- [4]
    }, -- [19]
    {
      236163, -- [1]
      8, -- [2]
      1, -- [3]
      48393, -- [4]
    }, -- [20]
    {
      236170, -- [1]
      9, -- [2]
      2, -- [3]
      50516, -- [4]
    }, -- [21]
    {
      236151, -- [1]
      9, -- [2]
      1, -- [3]
      48525, -- [4]
    }, -- [22]
    {
      236154, -- [1]
      9, -- [2]
      4, -- [3]
      48514, -- [4]
    }, -- [23]
    {
      236168, -- [1]
      11, -- [2]
      2, -- [3]
      48505, -- [4]
    }, -- [24]
    {
      236150, -- [1]
      10, -- [2]
      2, -- [3]
      48511, -- [4]
    }, -- [25]
    {
      135730, -- [1]
      1, -- [2]
      3, -- [3]
      57814, -- [4]
    }, -- [26]
    {
      136045, -- [1]
      5, -- [2]
      3, -- [3]
      57851, -- [4]
    }, -- [27]
    {
      136060, -- [1]
      3, -- [2]
      3, -- [3]
      57865, -- [4]
    }, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      134355, -- [1]
      2, -- [2]
      3, -- [3]
      16931, -- [4]
    }, -- [41]
    {
      132121, -- [1]
      1, -- [2]
      3, -- [3]
      16862, -- [4]
    }, -- [42]
    {
      132190, -- [1]
      1, -- [2]
      2, -- [3]
      16938, -- [4]
    }, -- [43]
    {
      132114, -- [1]
      5, -- [2]
      1, -- [3]
      16941, -- [4]
    }, -- [44]
    {
      134297, -- [1]
      3, -- [2]
      3, -- [3]
      16944, -- [4]
    }, -- [45]
    {
      132089, -- [1]
      2, -- [2]
      1, -- [3]
      16949, -- [4]
    }, -- [46]
    {
      132278, -- [1]
      4, -- [2]
      3, -- [3]
      37117, -- [4]
    }, -- [47]
    {
      136231, -- [1]
      4, -- [2]
      1, -- [3]
      16968, -- [4]
    }, -- [48]
    {
      132185, -- [1]
      4, -- [2]
      2, -- [3]
      16975, -- [4]
    }, -- [49]
    {
      132183, -- [1]
      5, -- [2]
      3, -- [3]
      49377, -- [4]
    }, -- [50]
    {
      132141, -- [1]
      2, -- [2]
      2, -- [3]
      16999, -- [4]
    }, -- [51]
    {
      136095, -- [1]
      3, -- [2]
      1, -- [3]
      24866, -- [4]
    }, -- [52]
    {
      135879, -- [1]
      6, -- [2]
      2, -- [3]
      24894, -- [4]
    }, -- [53]
    {
      136112, -- [1]
      7, -- [2]
      2, -- [3]
      17007, -- [4]
    }, -- [54]
    {
      236169, -- [1]
      3, -- [2]
      2, -- [3]
      61336, -- [4]
    }, -- [55]
    {
      132130, -- [1]
      5, -- [2]
      4, -- [3]
      33873, -- [4]
    }, -- [56]
    {
      132139, -- [1]
      7, -- [2]
      4, -- [3]
      33957, -- [4]
    }, -- [57]
    {
      132126, -- [1]
      6, -- [2]
      3, -- [3]
      33856, -- [4]
    }, -- [58]
    {
      132138, -- [1]
      8, -- [2]
      3, -- [3]
      33867, -- [4]
    }, -- [59]
    {
      132135, -- [1]
      9, -- [2]
      2, -- [3]
      33917, -- [4]
    }, -- [60]
    {
      136112, -- [1]
      7, -- [2]
      3, -- [3]
      34300, -- [4]
    }, -- [61]
    {
      236165, -- [1]
      4, -- [2]
      4, -- [3]
      48410, -- [4]
    }, -- [62]
    {
      236164, -- [1]
      10, -- [2]
      2, -- [3]
      51269, -- [4]
    }, -- [63]
    {
      236158, -- [1]
      8, -- [2]
      4, -- [3]
      48485, -- [4]
    }, -- [64]
    {
      132135, -- [1]
      9, -- [2]
      3, -- [3]
      48491, -- [4]
    }, -- [65]
    {
      236159, -- [1]
      9, -- [2]
      1, -- [3]
      48495, -- [4]
    }, -- [66]
    {
      236149, -- [1]
      11, -- [2]
      2, -- [3]
      50334, -- [4]
    }, -- [67]
    {
      132117, -- [1]
      8, -- [2]
      1, -- [3]
      57877, -- [4]
    }, -- [68]
    {
      132091, -- [1]
      6, -- [2]
      1, -- [3]
      57881, -- [4]
    }, -- [69]
    {
      132140, -- [1]
      10, -- [2]
      3, -- [3]
      63503, -- [4]
    }, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136078, -- [1]
      1, -- [2]
      1, -- [3]
      17051, -- [4]
    }, -- [81]
    {
      135881, -- [1]
      1, -- [2]
      3, -- [3]
      17061, -- [4]
    }, -- [82]
    {
      136042, -- [1]
      1, -- [2]
      2, -- [3]
      17066, -- [4]
    }, -- [83]
    {
      136041, -- [1]
      2, -- [2]
      1, -- [3]
      17073, -- [4]
    }, -- [84]
    {
      136085, -- [1]
      6, -- [2]
      3, -- [3]
      17078, -- [4]
    }, -- [85]
    {
      136116, -- [1]
      2, -- [2]
      3, -- [3]
      16835, -- [4]
    }, -- [86]
    {
      136017, -- [1]
      3, -- [2]
      2, -- [3]
      16864, -- [4]
    }, -- [87]
    {
      136074, -- [1]
      5, -- [2]
      2, -- [3]
      24946, -- [4]
    }, -- [88]
    {
      135863, -- [1]
      3, -- [2]
      1, -- [3]
      17108, -- [4]
    }, -- [89]
    {
      136081, -- [1]
      4, -- [2]
      3, -- [3]
      17113, -- [4]
    }, -- [90]
    {
      136076, -- [1]
      5, -- [2]
      1, -- [3]
      17116, -- [4]
    }, -- [91]
    {
      132150, -- [1]
      2, -- [2]
      2, -- [3]
      17120, -- [4]
    }, -- [92]
    {
      136107, -- [1]
      5, -- [2]
      4, -- [3]
      17124, -- [4]
    }, -- [93]
    {
      135900, -- [1]
      4, -- [2]
      2, -- [3]
      24972, -- [4]
    }, -- [94]
    {
      134914, -- [1]
      7, -- [2]
      2, -- [3]
      18562, -- [4]
    }, -- [95]
    {
      132125, -- [1]
      6, -- [2]
      1, -- [3]
      33880, -- [4]
    }, -- [96]
    {
      132124, -- [1]
      8, -- [2]
      2, -- [3]
      33890, -- [4]
    }, -- [97]
    {
      132137, -- [1]
      7, -- [2]
      3, -- [3]
      33883, -- [4]
    }, -- [98]
    {
      132145, -- [1]
      9, -- [2]
      2, -- [3]
      65139, -- [4]
    }, -- [99]
    {
      136037, -- [1]
      7, -- [2]
      1, -- [3]
      34153, -- [4]
    }, -- [100]
    {
      236161, -- [1]
      3, -- [2]
      3, -- [3]
      48412, -- [4]
    }, -- [101]
    {
      236160, -- [1]
      10, -- [2]
      3, -- [3]
      51183, -- [4]
    }, -- [102]
    {
      236153, -- [1]
      11, -- [2]
      2, -- [3]
      48438, -- [4]
    }, -- [103]
    {
      236155, -- [1]
      8, -- [2]
      3, -- [3]
      48500, -- [4]
    }, -- [104]
    {
      236166, -- [1]
      9, -- [2]
      1, -- [3]
      48545, -- [4]
    }, -- [105]
    {
      236157, -- [1]
      9, -- [2]
      3, -- [3]
      48537, -- [4]
    }, -- [106]
    {
      136097, -- [1]
      10, -- [2]
      1, -- [3]
      63411, -- [4]
    }, -- [107]
    [121] = {
      "DruidBalance", -- [1]
      "DruidFeralCombat", -- [2]
      "DruidRestoration", -- [3]
    },
  },
  ["PALADIN"] = {
    {
      135736, -- [1]
      1, -- [2]
      2, -- [3]
      20208, -- [4]
    }, -- [1]
    {
      135915, -- [1]
      5, -- [2]
      2, -- [3]
      20216, -- [4]
    }, -- [2]
    {
      135872, -- [1]
      3, -- [2]
      1, -- [3]
      31821, -- [4]
    }, -- [3]
    {
      135928, -- [1]
      3, -- [2]
      3, -- [3]
      20235, -- [4]
    }, -- [4]
    {
      135920, -- [1]
      2, -- [2]
      1, -- [3]
      20239, -- [4]
    }, -- [5]
    {
      135970, -- [1]
      4, -- [2]
      3, -- [3]
      20245, -- [4]
    }, -- [6]
    {
      136090, -- [1]
      2, -- [2]
      2, -- [3]
      20261, -- [4]
    }, -- [7]
    {
      135933, -- [1]
      4, -- [2]
      1, -- [3]
      20256, -- [4]
    }, -- [8]
    {
      135913, -- [1]
      3, -- [2]
      2, -- [3]
      20215, -- [4]
    }, -- [9]
    {
      132325, -- [1]
      1, -- [2]
      3, -- [3]
      20332, -- [4]
    }, -- [10]
    {
      135917, -- [1]
      5, -- [2]
      3, -- [3]
      20361, -- [4]
    }, -- [11]
    {
      135972, -- [1]
      7, -- [2]
      2, -- [3]
      20473, -- [4]
    }, -- [12]
    {
      135938, -- [1]
      6, -- [2]
      3, -- [3]
      25829, -- [4]
    }, -- [13]
    {
      135984, -- [1]
      2, -- [2]
      3, -- [3]
      25836, -- [4]
    }, -- [14]
    {
      135948, -- [1]
      5, -- [2]
      1, -- [3]
      31823, -- [4]
    }, -- [15]
    {
      135950, -- [1]
      6, -- [2]
      1, -- [3]
      31826, -- [4]
    }, -- [16]
    {
      135876, -- [1]
      7, -- [2]
      3, -- [3]
      31830, -- [4]
    }, -- [17]
    {
      135931, -- [1]
      7, -- [2]
      1, -- [3]
      31836, -- [4]
    }, -- [18]
    {
      135921, -- [1]
      8, -- [2]
      3, -- [3]
      31841, -- [4]
    }, -- [19]
    {
      135895, -- [1]
      9, -- [2]
      1, -- [3]
      31842, -- [4]
    }, -- [20]
    {
      236261, -- [1]
      8, -- [2]
      1, -- [3]
      53553, -- [4]
    }, -- [21]
    {
      236251, -- [1]
      10, -- [2]
      3, -- [3]
      53557, -- [4]
    }, -- [22]
    {
      236247, -- [1]
      11, -- [2]
      2, -- [3]
      53563, -- [4]
    }, -- [23]
    {
      236254, -- [1]
      10, -- [2]
      2, -- [3]
      53576, -- [4]
    }, -- [24]
    {
      236248, -- [1]
      4, -- [2]
      4, -- [3]
      53661, -- [4]
    }, -- [25]
    {
      236256, -- [1]
      9, -- [2]
      3, -- [3]
      54155, -- [4]
    }, -- [26]
    nil, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      132110, -- [1]
      8, -- [2]
      1, -- [3]
      20135, -- [4]
    }, -- [41]
    {
      135893, -- [1]
      4, -- [2]
      3, -- [3]
      20140, -- [4]
    }, -- [42]
    {
      135892, -- [1]
      3, -- [2]
      3, -- [3]
      20147, -- [4]
    }, -- [43]
    {
      135964, -- [1]
      2, -- [2]
      2, -- [3]
      20175, -- [4]
    }, -- [44]
    {
      135882, -- [1]
      5, -- [2]
      3, -- [3]
      20182, -- [4]
    }, -- [45]
    {
      135321, -- [1]
      6, -- [2]
      3, -- [3]
      20198, -- [4]
    }, -- [46]
    {
      135880, -- [1]
      7, -- [2]
      2, -- [3]
      20925, -- [4]
    }, -- [47]
    {
      136051, -- [1]
      5, -- [2]
      2, -- [3]
      20911, -- [4]
    }, -- [48]
    {
      135883, -- [1]
      1, -- [2]
      2, -- [3]
      63650, -- [4]
    }, -- [49]
    {
      135962, -- [1]
      3, -- [2]
      2, -- [3]
      20470, -- [4]
    }, -- [50]
    {
      135963, -- [1]
      4, -- [2]
      2, -- [3]
      20488, -- [4]
    }, -- [51]
    {
      135994, -- [1]
      2, -- [2]
      3, -- [3]
      20100, -- [4]
    }, -- [52]
    {
      135978, -- [1]
      2, -- [2]
      1, -- [3]
      53519, -- [4]
    }, -- [53]
    {
      135896, -- [1]
      6, -- [2]
      1, -- [3]
      31849, -- [4]
    }, -- [54]
    {
      135870, -- [1]
      7, -- [2]
      3, -- [3]
      31852, -- [4]
    }, -- [55]
    {
      135986, -- [1]
      8, -- [2]
      3, -- [3]
      31860, -- [4]
    }, -- [56]
    {
      135874, -- [1]
      9, -- [2]
      2, -- [3]
      31935, -- [4]
    }, -- [57]
    {
      132154, -- [1]
      1, -- [2]
      3, -- [3]
      20266, -- [4]
    }, -- [58]
    {
      236252, -- [1]
      9, -- [2]
      3, -- [3]
      53585, -- [4]
    }, -- [59]
    {
      236267, -- [1]
      9, -- [2]
      1, -- [3]
      53592, -- [4]
    }, -- [60]
    {
      236253, -- [1]
      11, -- [2]
      2, -- [3]
      53595, -- [4]
    }, -- [61]
    {
      236259, -- [1]
      10, -- [2]
      3, -- [3]
      53696, -- [4]
    }, -- [62]
    {
      236264, -- [1]
      10, -- [2]
      2, -- [3]
      53711, -- [4]
    }, -- [63]
    {
      253400, -- [1]
      3, -- [2]
      1, -- [3]
      64205, -- [4]
    }, -- [64]
    {
      253400, -- [1]
      4, -- [2]
      1, -- [3]
      53530, -- [4]
    }, -- [65]
    {
      135958, -- [1]
      7, -- [2]
      1, -- [3]
      33776, -- [4]
    }, -- [66]
    nil, -- [67]
    nil, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      135906, -- [1]
      2, -- [2]
      3, -- [3]
      20045, -- [4]
    }, -- [81]
    {
      132275, -- [1]
      6, -- [2]
      2, -- [3]
      20057, -- [4]
    }, -- [82]
    {
      132269, -- [1]
      1, -- [2]
      2, -- [3]
      20064, -- [4]
    }, -- [83]
    {
      135863, -- [1]
      1, -- [2]
      3, -- [3]
      20105, -- [4]
    }, -- [84]
    {
      133041, -- [1]
      5, -- [2]
      1, -- [3]
      20113, -- [4]
    }, -- [85]
    {
      135957, -- [1]
      3, -- [2]
      2, -- [3]
      20121, -- [4]
    }, -- [86]
    {
      135942, -- [1]
      7, -- [2]
      2, -- [3]
      20066, -- [4]
    }, -- [87]
    {
      135924, -- [1]
      2, -- [2]
      2, -- [3]
      20337, -- [4]
    }, -- [88]
    {
      132347, -- [1]
      3, -- [2]
      3, -- [3]
      20375, -- [4]
    }, -- [89]
    {
      135959, -- [1]
      2, -- [2]
      1, -- [3]
      25957, -- [4]
    }, -- [90]
    {
      135904, -- [1]
      4, -- [2]
      1, -- [3]
      25988, -- [4]
    }, -- [91]
    {
      135985, -- [1]
      3, -- [2]
      1, -- [3]
      26016, -- [4]
    }, -- [92]
    {
      135937, -- [1]
      3, -- [2]
      4, -- [3]
      26023, -- [4]
    }, -- [93]
    {
      135889, -- [1]
      4, -- [2]
      4, -- [3]
      31868, -- [4]
    }, -- [94]
    {
      135934, -- [1]
      5, -- [2]
      3, -- [3]
      31869, -- [4]
    }, -- [95]
    {
      135897, -- [1]
      6, -- [2]
      3, -- [3]
      31872, -- [4]
    }, -- [96]
    {
      236257, -- [1]
      7, -- [2]
      3, -- [3]
      31878, -- [4]
    }, -- [97]
    {
      135905, -- [1]
      8, -- [2]
      2, -- [3]
      31881, -- [4]
    }, -- [98]
    {
      135924, -- [1]
      4, -- [2]
      3, -- [3]
      35397, -- [4]
    }, -- [99]
    {
      135891, -- [1]
      9, -- [2]
      2, -- [3]
      35395, -- [4]
    }, -- [100]
    {
      236262, -- [1]
      8, -- [2]
      3, -- [3]
      53376, -- [4]
    }, -- [101]
    {
      236266, -- [1]
      9, -- [2]
      1, -- [3]
      53648, -- [4]
    }, -- [102]
    {
      236260, -- [1]
      10, -- [2]
      2, -- [3]
      53382, -- [4]
    }, -- [103]
    {
      236250, -- [1]
      11, -- [2]
      2, -- [3]
      53385, -- [4]
    }, -- [104]
    {
      236246, -- [1]
      7, -- [2]
      1, -- [3]
      53488, -- [4]
    }, -- [105]
    {
      236263, -- [1]
      9, -- [2]
      3, -- [3]
      53503, -- [4]
    }, -- [106]
    [121] = {
      "PaladinHoly", -- [1]
      "PaladinProtection", -- [2]
      "PaladinCombat", -- [3]
    },
  },
  ["ROGUE"] = {
    {
      132273, -- [1]
      4, -- [2]
      3, -- [3]
      14117, -- [4]
    }, -- [1]
    {
      132109, -- [1]
      3, -- [2]
      3, -- [3]
      14137, -- [4]
    }, -- [2]
    {
      132277, -- [1]
      1, -- [2]
      3, -- [3]
      14142, -- [4]
    }, -- [3]
    {
      132151, -- [1]
      1, -- [2]
      2, -- [3]
      14148, -- [4]
    }, -- [4]
    {
      132122, -- [1]
      2, -- [2]
      1, -- [3]
      14161, -- [4]
    }, -- [5]
    {
      136147, -- [1]
      6, -- [2]
      3, -- [3]
      14159, -- [4]
    }, -- [6]
    {
      132292, -- [1]
      1, -- [2]
      1, -- [3]
      14164, -- [4]
    }, -- [7]
    {
      132090, -- [1]
      2, -- [2]
      4, -- [3]
      13866, -- [4]
    }, -- [8]
    {
      132354, -- [1]
      3, -- [2]
      2, -- [3]
      14169, -- [4]
    }, -- [9]
    {
      132298, -- [1]
      5, -- [2]
      3, -- [3]
      14176, -- [4]
    }, -- [10]
    {
      135988, -- [1]
      5, -- [2]
      2, -- [3]
      14177, -- [4]
    }, -- [11]
    {
      132205, -- [1]
      7, -- [2]
      2, -- [3]
      58426, -- [4]
    }, -- [12]
    {
      136130, -- [1]
      6, -- [2]
      2, -- [3]
      14195, -- [4]
    }, -- [13]
    {
      136023, -- [1]
      3, -- [2]
      1, -- [3]
      14983, -- [4]
    }, -- [14]
    {
      132293, -- [1]
      4, -- [2]
      2, -- [3]
      16515, -- [4]
    }, -- [15]
    {
      132108, -- [1]
      9, -- [2]
      1, -- [3]
      58410, -- [4]
    }, -- [16]
    {
      132295, -- [1]
      8, -- [2]
      3, -- [3]
      31236, -- [4]
    }, -- [17]
    {
      132304, -- [1]
      9, -- [2]
      2, -- [3]
      1329, -- [4]
    }, -- [18]
    {
      132296, -- [1]
      5, -- [2]
      1, -- [3]
      31209, -- [4]
    }, -- [19]
    {
      132286, -- [1]
      7, -- [2]
      3, -- [3]
      31383, -- [4]
    }, -- [20]
    {
      132301, -- [1]
      5, -- [2]
      4, -- [3]
      31245, -- [4]
    }, -- [21]
    {
      236270, -- [1]
      7, -- [2]
      1, -- [3]
      51626, -- [4]
    }, -- [22]
    {
      236284, -- [1]
      9, -- [2]
      3, -- [3]
      51629, -- [4]
    }, -- [23]
    {
      236268, -- [1]
      2, -- [2]
      2, -- [3]
      51633, -- [4]
    }, -- [24]
    {
      236274, -- [1]
      8, -- [2]
      1, -- [3]
      51636, -- [4]
    }, -- [25]
    {
      236269, -- [1]
      10, -- [2]
      2, -- [3]
      51669, -- [4]
    }, -- [26]
    {
      236276, -- [1]
      11, -- [2]
      2, -- [3]
      51662, -- [4]
    }, -- [27]
    nil, -- [28]
    nil, -- [29]
    nil, -- [30]
    nil, -- [31]
    nil, -- [32]
    nil, -- [33]
    nil, -- [34]
    nil, -- [35]
    nil, -- [36]
    nil, -- [37]
    nil, -- [38]
    nil, -- [39]
    nil, -- [40]
    {
      132222, -- [1]
      2, -- [2]
      4, -- [3]
      13845, -- [4]
    }, -- [41]
    {
      135641, -- [1]
      3, -- [2]
      3, -- [3]
      13807, -- [4]
    }, -- [42]
    {
      133476, -- [1]
      5, -- [2]
      1, -- [3]
      13803, -- [4]
    }, -- [43]
    {
      136047, -- [1]
      4, -- [2]
      3, -- [3]
      13789, -- [4]
    }, -- [44]
    {
      132269, -- [1]
      2, -- [2]
      2, -- [3]
      13854, -- [4]
    }, -- [45]
    {
      136189, -- [1]
      1, -- [2]
      2, -- [3]
      13863, -- [4]
    }, -- [46]
    {
      132155, -- [1]
      1, -- [2]
      1, -- [3]
      13792, -- [4]
    }, -- [47]
    {
      136205, -- [1]
      3, -- [2]
      1, -- [3]
      13872, -- [4]
    }, -- [48]
    {
      136206, -- [1]
      7, -- [2]
      2, -- [3]
      13750, -- [4]
    }, -- [49]
    {
      132219, -- [1]
      4, -- [2]
      1, -- [3]
      13867, -- [4]
    }, -- [50]
    {
      132147, -- [1]
      1, -- [2]
      3, -- [3]
      13852, -- [4]
    }, -- [51]
    {
      132307, -- [1]
      4, -- [2]
      2, -- [3]
      13875, -- [4]
    }, -- [52]
    {
      132350, -- [1]
      5, -- [2]
      2, -- [3]
      13877, -- [4]
    }, -- [53]
    {
      135328, -- [1]
      5, -- [2]
      3, -- [3]
      13964, -- [4]
    }, -- [54]
    {
      132336, -- [1]
      3, -- [2]
      2, -- [3]
      14251, -- [4]
    }, -- [55]
    {
      132275, -- [1]
      4, -- [2]
      4, -- [3]
      61331, -- [4]
    }, -- [56]
    {
      135882, -- [1]
      6, -- [2]
      2, -- [3]
      30920, -- [4]
    }, -- [57]
    {
      132353, -- [1]
      7, -- [2]
      1, -- [3]
      61329, -- [4]
    }, -- [58]
    {
      132283, -- [1]
      6, -- [2]
      3, -- [3]
      31126, -- [4]
    }, -- [59]
    {
      132300, -- [1]
      7, -- [2]
      3, -- [3]
      31131, -- [4]
    }, -- [60]
    {
      132308, -- [1]
      9, -- [2]
      2, -- [3]
      32601, -- [4]
    }, -- [61]
    {
      135673, -- [1]
      8, -- [2]
      3, -- [3]
      35553, -- [4]
    }, -- [62]
    {
      132306, -- [1]
      2, -- [2]
      1, -- [3]
      14166, -- [4]
    }, -- [63]
    {
      236282, -- [1]
      8, -- [2]
      1, -- [3]
      51679, -- [4]
    }, -- [64]
    {
      236285, -- [1]
      9, -- [2]
      1, -- [3]
      51674, -- [4]
    }, -- [65]
    {
      132100, -- [1]
      9, -- [2]
      3, -- [3]
      58413, -- [4]
    }, -- [66]
    {
      236278, -- [1]
      10, -- [2]
      2, -- [3]
      51689, -- [4]
    }, -- [67]
    {
      236277, -- [1]
      11, -- [2]
      2, -- [3]
      51690, -- [4]
    }, -- [68]
    nil, -- [69]
    nil, -- [70]
    nil, -- [71]
    nil, -- [72]
    nil, -- [73]
    nil, -- [74]
    nil, -- [75]
    nil, -- [76]
    nil, -- [77]
    nil, -- [78]
    nil, -- [79]
    nil, -- [80]
    {
      136129, -- [1]
      1, -- [2]
      2, -- [3]
      13971, -- [4]
    }, -- [81]
    {
      132320, -- [1]
      2, -- [2]
      3, -- [3]
      14063, -- [4]
    }, -- [82]
    {
      136159, -- [1]
      4, -- [2]
      2, -- [3]
      13980, -- [4]
    }, -- [83]
    {
      136056, -- [1]
      4, -- [2]
      1, -- [3]
      14071, -- [4]
    }, -- [84]
    {
      135994, -- [1]
      3, -- [2]
      1, -- [3]
      14066, -- [4]
    }, -- [85]
    {
      132366, -- [1]
      1, -- [2]
      3, -- [3]
      14072, -- [4]
    }, -- [86]
    {
      132310, -- [1]
      2, -- [2]
      2, -- [3]
      14094, -- [4]
    }, -- [87]
    {
      132282, -- [1]
      4, -- [2]
      3, -- [3]
      14080, -- [4]
    }, -- [88]
    {
      136220, -- [1]
      5, -- [2]
      3, -- [3]
      14083, -- [4]
    }, -- [89]
    {
      136121, -- [1]
      5, -- [2]
      2, -- [3]
      14185, -- [4]
    }, -- [90]
    {
      136136, -- [1]
      3, -- [2]
      2, -- [3]
      14278, -- [4]
    }, -- [91]
    {
      136183, -- [1]
      7, -- [2]
      2, -- [3]
      14183, -- [4]
    }, -- [92]
    {
      136168, -- [1]
      5, -- [2]
      4, -- [3]
      16511, -- [4]
    }, -- [93]
    {
      135315, -- [1]
      3, -- [2]
      3, -- [3]
      14173, -- [4]
    }, -- [94]
    {
      132294, -- [1]
      2, -- [2]
      1, -- [3]
      30893, -- [4]
    }, -- [95]
    {
      132089, -- [1]
      5, -- [2]
      1, -- [3]
      30895, -- [4]
    }, -- [96]
    {
      135540, -- [1]
      6, -- [2]
      3, -- [3]
      30906, -- [4]
    }, -- [97]
    {
      132291, -- [1]
      7, -- [2]
      1, -- [3]
      31213, -- [4]
    }, -- [98]
    {
      132305, -- [1]
      8, -- [2]
      2, -- [3]
      31220, -- [4]
    }, -- [99]
    {
      132299, -- [1]
      6, -- [2]
      1, -- [3]
      31223, -- [4]
    }, -- [100]
    {
      132303, -- [1]
      9, -- [2]
      2, -- [3]
      36554, -- [4]
    }, -- [101]
    {
      132285, -- [1]
      7, -- [2]
      3, -- [3]
      31230, -- [4]
    }, -- [102]
    {
      236286, -- [1]
      8, -- [2]
      3, -- [3]
      51696, -- [4]
    }, -- [103]
    {
      236275, -- [1]
      9, -- [2]
      1, -- [3]
      51701, -- [4]
    }, -- [104]
    {
      236287, -- [1]
      9, -- [2]
      3, -- [3]
      58415, -- [4]
    }, -- [105]
    {
      236280, -- [1]
      10, -- [2]
      2, -- [3]
      51712, -- [4]
    }, -- [106]
    {
      236279, -- [1]
      11, -- [2]
      2, -- [3]
      51713, -- [4]
    }, -- [107]
    {
      132340, -- [1]
      1, -- [2]
      1, -- [3]
      58425, -- [4]
    }, -- [108]
    [121] = {
      "RogueAssassination", -- [1]
      "RogueCombat", -- [2]
      "RogueSubtlety", -- [3]
    },
  },
}

Private.AtlasList = {'CommittedName','MainPet-PetFamilyFrame','Timer-Frame','MainPet-HealthBarBG','Timer-BG','BackupPet-DeadFrame','MainPet-HealthBarFrame','Start-VersusSplash','BackupPet-Frame','BattleHUD-Top','BattleBar-ButtonBG-EndCap','BattleBar-SwapPetFrame-DeadIcon','MainPet-HealthBarFill','BattleBar-EndCap','BattleBar-Button-Highlight','BattleBar-SwapPetFrame','Timer-Fill','BattleBar-SwapPetIcon','MainPet-Frame','BattleBar-Countdown-Shadow','BattleBar-ButtonBG-Divider','BattleBar-SwapPetShadow','BattleBar-SwapPetFrame-Highlight','MainPet-PetFamilyActivate','MainPet-LevelBubble','BattleHUD-Versus','_BattleBar-ButtonBGMid','_BattleBar-Mid','BackArrow-Brown','MapCornerShadow-Left','MapCornerShadow-Right','NoQuestsBackground','OptionsIcon-Brown','QuestCollapse-Hide-Down','QuestCollapse-Hide-Up','QuestCollapse-Show-Down','QuestCollapse-Show-Up','QuestDetails-RewardsBottomOverlay','QuestDetails-RewardsOverlay','QuestDetails-TopOverlay','QuestDetailsBackgrounds','QuestionMarkContinent-Icon','QuestionMarkContinent-IconHighlight','QuestLogBackground','StoryHeader-BG','StoryHeader-CheevoIcon','StoryHeader-Shadow','TaskPOI-Icon','TaskPOI-IconHighlight','TaskPOI-IconSelect','UI-OuterBorderButtonPatch','UI-SquareButtonBrown-Down','UI-SquareButtonBrown-Up','QuestItemBorder-Small','QuestItemBorder','Talent-Separator','Talent-BottomLeftCurlies','Talent-Highlight','Talent-TopRightCurlies','Talent-TopLeftCurlies','Talent-Background','Talent-Selection','Talent-RingWithDot','Talent-BottomRightCurlies','PetJournal-BattleSlot-Active','PetJournal-BattleSlot-Locked','PetJournal-PetCard-BG','PetJournal-BattleSlotFrame-Corner','PetJournal-ExpBar-Left','PetJournal-BattleSlotTitle-Right','PetJournal-ExpBar-Background','PetJournal-PetBattleAchievementGlow','PetJournal-HealthBar-Left','PetJournal-PetCard-Abilities','PetJournal-BattleSlot-AbilityBorder','PetJournal-ExpBar-Divider','PetJournal-ExpBar-Right','PetJournal-BattleSlot-IconBorder','PetJournal-LevelBubble','PetJournal-ExpBar-Mid','PetJournal-PetBattleAchievementBG','PetJournal-BattleSlot-Shadow','PetJournal-BattleSlotTitle-Left','PetJournal-HealthBar-Mid','PetJournal-HealthBar-Right','PetJournal-HealthBar-Background','_BattleSlotTitle-BG','_BattleSlotFrame-Top','_BattleSlotFrame-Divider','_BattleSlotTitle-Mid','MountJournalIcons-Alliance','MountJournalIcons-Horde','_Talent-blue-glow','_Talent-Bottom-Tile','_Talent-Top-Tile','bluemenu-Ring','PetJournal-FavoritesIcon','NewCharacter-Alliance','NewCharacter-Horde','Garr_InfoBox-Corner','Garr_InfoBoxBorder-BigBottomCorner','Garr_InfoBoxBorder-Corner','Garr_InfoBoxBorder-FiligreeCorner','Garr_WoodFrameCorner','_Garr_InfoBox-Top','_Garr_InfoBoxBorder-BigBottom','_Garr_InfoBoxBorder-Top','_Garr_WoodFrameTile-Bottom','_Garr_WoodFrameTile-Top','_Garr_XPBar_Mid','!Garr_InfoBox-Left','!Garr_InfoBoxBorder-Left','!Garr_WoodFrameTile-Left','Garr_BuildingIconRing_','Garr_BuildingPlacementExplosion','Garr_CostBar','Garr_FollowerPortrait_Bg','Garr_FollowerPortrait_Ring','Garr_FollowerPortrait_TimerBG','Garr_FollowerPortrait_TimerFill','Garr_LevelBadge_1','Garr_LevelBadge_2','Garr_LevelBadge_3','Garr_LevelUpgradeArrow','Garr_LevelUpgradeLocked','Garr_ListButton-Highlight','Garr_ListButton-Selection','Garr_ListButton','Garr_ListTab-Highlight','Garr_ListTab-Select','Garr_ListTab','Garr_MaterialIcon','Garr_MonumentLocked','Garr_MonumentOpen','Garr_PlanIcon-List','Garr_PlansRequiredIcon','Garr_Plot_Glow_3','Garr_Plot_Glow_2','Garr_Plot_Glow_1','Garr_Plot_Glow_4','Garr_Specialization_FrameLeft','Garr_Specialization_FrameMid','Garr_Specialization_IconBorder','Garr_Specialization_IconSelected','Garr_TownHallBanner_Left','Garr_TownHallBanner_LevelFiligree','Garr_TownHallBanner_Mid','Garr_TownHallBanner_Right','Garr_TreasureIcon','Garr_XPBar_Left','Garr_XPBar_Nub','Garr_Map_Shadowmoon1_A','Garr_Map_Shadowmoon2_A','Garr_Map_Shadowmoon3_A','Garr_Plot_Shadowmoon_A_4','Garr_Plot_Shadowmoon_A_1','Garr_Plot_Shadowmoon_A_2','Garr_Plot_Shadowmoon_A_3','Garr_InfoBox-BackgroundTile','Garr_WoodFrame-BackgroundTile','Garr_InfoBox-CornerShadow','GarrBuilding_Default_Info','GarrBuilding_Default_Map','GarrBuilding_EmptyPlot_1_A_Info','GarrBuilding_Armory_1_A_Info','GarrBuilding_Armory_2_A_Info','GarrBuilding_Armory_3_A_Info','GarrBuilding_Armory_1_A_Map','GarrBuilding_Armory_2_A_Map','GarrBuilding_Armory_3_A_Map','GarrBuilding_Alchemy_1_A_Info','GarrBuilding_Alchemy_2_A_Info','GarrBuilding_Alchemy_3_A_Info','GarrBuilding_Alchemy_1_A_Map','GarrBuilding_Alchemy_2_A_Map','GarrBuilding_Alchemy_3_A_Map','DruidEclipse-LunarCover','DruidEclipse-SolarCover','DruidEclipse-Arrow','DruidEclipse-BaseBar','DruidEclipse-BaseMoon','DruidEclipse-BaseSun','DruidEclipse-Diamond','DruidEclipse-Line','DruidEclipse-LunarBar','DruidEclipse-LunarMoon','DruidEclipse-LunarSun','DruidEclipse-SolarBar','DruidEclipse-SolarMoon','DruidEclipse-SolarSun','Garr_BuildIcon','Garr_BuildingConfirmation','Garr_BuildingIconTimerBG','Garr_BuildingIconTimerFill','Garr_BuildingTimerBG','Garr_BuildingTimerFill','Garr_BuildingTimerGlow','Garr_BuildingUpgradeExplosion','Garr_LevelBadgeGlow','Garr_NotificationGlow','Garr_UpgradeBanner','Garr_UpgradeIcon','Garr_UpgradeIconTimerBG','Garr_UpgradeIconTimerFill','Garr_UpgradeTimerBG','Garr_UpgradeTimerFill','Garr_UpgradeTimerGlow','Garr_Toast','Garr_BuildingShadowOverlay','GarrMission_Bg-DarkEdgeCorner','GarrMission_CounterCheck','GarrMission_EncounterAbilityBorder','GarrMission_EncounterBar-BG','GarrMission_EncounterBar-End','GarrMission_EncounterBar-Fill','GarrMission_EncounterBar-PortraitRing','GarrMission_EncounterBar-Spark','GarrMission_EncounterBar-Xbg','GarrMission_EncounterBar-Xleft','GarrMission_FollowerAbilityRollout','GarrMission_FollowerPartyBox_Lg','GarrMission_FollowerPartyBox_Sm','GarrMission_ItemFrame','GarrMission_LevelUpBanner','GarrMission_LocationCover-Side','GarrMission_ParchmentHeader-End','GarrMission_PartyBuffsBG','GarrMission_PortraitRing','GarrMission_PortraitRing_Empty','GarrMission_PortraitRing_Enemy','GarrMission_PortraitRing_LevelBorder','GarrMission_RareGlowBG','GarrMission_RewardsBanner-Desaturate','GarrMission_RewardsBanner','GarrMission_RewardsBG-Desaturate','GarrMission_RewardsBG','GarrMission_RewardsBorder-Corner-Desaturate','GarrMission_RewardsBorder-Corner','GarrMission_Silhouettes-1Alliance','GarrMission_Silhouettes-1Horde','GarrMission_SingleModelBG','GarrMission_StartMissionFrame','_GarrMission_Bg-BottomEdge','_GarrMission_Bg-BottomEdgeSmall','_GarrMission_LocationCover-Bottom','_GarrMission_ParchmentHeader-Mid','_GarrMission_RewardsBorder-Top-Desaturate','_GarrMission_RewardsBorder-Top','_GarrMission_TopBorder-Highlight','_GarrMission_TopBorder-Select','_GarrMission_TopBorder','_GarrMission_XPBar-BG','_GarrMission_XPBar-Fill','_Garr_InfoBoxBorderMission-Top','!GarrMission_Bg-Edge','!GarrMission_RewardsBorder-Left-Desaturate','!GarrMission_RewardsBorder-Left','!Garr_InfoBoxBorderMission-Left','Garr_InfoBoxMission-BackgroundTile','GarrMission_FollowerListButton','GarrMission_FollowerListButton-Highlight','GarrMission_FollowerListButton-Select','GarrMission_FollowerPageHeaderBG','GarrMission_IconLevelBG','GarrMission_ListGlow-Highlight','GarrMission_ListGlow-Select','GarrMission_PlayerLootFrame','GarrMission_RareOverlay','GarrMission_TopBorderCorner','GarrMission_TopBorderCorner-Highlight','GarrMission_TopBorderCorner-Select','GarrMission_UsefulAbilityIcon','GarrMission_XPBarBig-End','GarrMission_XPBarBig-LevelBorder','GarrMission_XPBarBig-Mid','Garr_InfoBoxBorderMission-Corner','PartySizeIcon','GarrMission_CurrencyIcon-Material','GarrMission_CurrencyIcon-Salvage','GarrMission_CurrencyIcon-Xp','_GarrMissionLocation-TannanJungle-Back','_GarrMissionLocation-TannanJungle-Fore','_GarrMissionLocation-TannanJungle-Mid','GarrMission_MissionParchment','GarrBuilding_MageTower_1_A_Info','GarrBuilding_MageTower_2_A_Info','GarrBuilding_MageTower_3_A_Info','GarrBuilding_TownHall_1_A_Info','GarrBuilding_TownHall_2_A_Info','GarrBuilding_TownHall_3_A_Info','GarrBuilding_TownHall_3_A_Map','GarrBuilding_TownHall_2_A_Map','GarrBuilding_TownHall_1_A_Map','GarrBuilding_MageTower_1_A_Map','GarrBuilding_MageTower_2_A_Map','GarrBuilding_MageTower_3_A_Map','GarrBuilding_Inn_1_A_Info','GarrBuilding_Inn_1_A_Map','GarrBuilding_Inn_2_A_Info','GarrBuilding_Inn_3_A_Info','GarrBuilding_Inn_2_A_Map','GarrBuilding_Inn_3_A_Map','GarrBuilding_Mine_1_A_Info','GarrBuilding_Mine_2_A_Info','GarrBuilding_Mine_3_A_Info','GarrBuilding_Mine_1_A_Map','GarrBuilding_Mine_2_A_Map','GarrBuilding_Mine_3_A_Map','GarrBuilding_Barracks_1_A_Map','GarrBuilding_Barracks_2_A_Map','GarrBuilding_Barracks_3_A_Map','GarrBuilding_Barracks_1_A_Info','GarrBuilding_Barracks_2_A_Info','GarrBuilding_Barracks_3_A_Info','GarrBuilding_Engineering_1_A_Info','GarrBuilding_Engineering_2_A_Info','GarrBuilding_Engineering_3_A_Info','GarrBuilding_Engineering_1_A_Map','GarrBuilding_Engineering_2_A_Map','GarrBuilding_Engineering_3_A_Map','Rewards-Shadow','OBJFX_LineBurst','OBJBonusBar-Top','OBJFX_LineGlow','Objective-Header','Rewards-Top','OBJFX_StarBurst','Objective-Nub','OBJFX_Glow','shadoworbs-small-Orb-Bg','shadoworbs-small-Orb','shadoworbs-small-Frame-OrbHighlight','shadoworbs-large-Orb','shadoworbs-large-Frame','shadoworbs-large-Orb-Bg','shadoworbs-large-Frame-OrbHighlight','shadoworbs-small-Frame','achievementcompare-GreenCheckmark','achievementcompare-YellowCheckmark','MonkUI-background-shadow','MonkUI-OrbOff','MonkUI-OrbOff-small','MonkUI-LightOrb-small','MonkUI-background','MonkUI-LightOrb','Garr_InfoBoxMission-Corner','_Garr_InfoBoxMission-Top','!Garr_InfoBoxMission-Left','bags-newitem','Tracker-Check','_GarrMission_MissionListTopHighlight','GarrMission_PartyBuffAbilityBorder','collections-icon-favorites','collections-itemborder-collected','collections-itemborder-uncollected-innerglow','collections-itemborder-uncollected','collections-levelplate-black','collections-levelplate-gold','collections-newglow','collections-slotheader','collections-background-filagree','collections-background-corner','collections-background-tile','_collections-background-line','collections-background-shadow-small','collections-background-shadow-large','bags-junkcoin','bags-innerglow','Capacitance-Blacksmithing-BG','Capacitance-Blacksmithing-IconBG','Capacitance-Blacksmithing-IconBorder','Capacitance-Blacksmithing-TimerBG','Capacitance-Blacksmithing-TimerFill','Capacitance-Blacksmithing-TimerFrame','Capacitance-General-EmptyFollower','Capacitance-General-ItemBorder','Capacitance-General-LockIcon','Capacitance-General-WorkOrderActive','Capacitance-General-WorkOrderArrow','Capacitance-General-WorkOrderBorder','Capacitance-General-WorkOrderCheckmark','Capacitance-General-WorkOrderEmpty','Capacitance-General-LevelBorder','Capacitance-General-PortraitRing','minortalents-icon-book','minortalents-iconcover','_minortalents-iconspinner','Objective-Fail','minortalents-backplate','minortalents-descriptionshadow','characterundelete-RestoreButton','bank-slots-shadow','bank-slots','Garr_MissionToast','Garr_FollowerToast-Epic','Garr_FollowerToast-Rare','Garr_FollowerToast-Uncommon','Garr_MissionToast-IconBG','Garr_Map_Frostfire1_H','Garr_Map_Frostfire2_H','Garr_Map_Frostfire3_H','ZoneAbility-Generic-AbilityBar-Glow','ZoneAbility-Generic-AbilityBar','ZoneAbility-Generic-IconBorder','ZoneAbility-Generic-SpellBox','groupfinder-icon-voice','groupfinder-icon-friend','GarrBuilding_Barn_1_A_Info','GarrBuilding_Barn_2_A_Info','GarrBuilding_Barn_3_A_Info','GarrBuilding_Barn_1_A_Map','GarrBuilding_Barn_2_A_Map','GarrBuilding_Barn_3_A_Map','GarLanding-Bottom','GarLanding-Left','GarLanding-Right','GarrLanding-InvasionBadge-Glow','GarrLanding-InvasionBadge','GarrLanding-MissionListBG','GarrLanding-Top','GarrLanding-TradeskillTimer-BG','GarrLanding_Watermark-Tradeskill','GarrLanding-FollowerScrollFrame','GarrLanding-lowerleft','GarrLanding-lowerright','GarrLanding-upperleft','GarrLanding-upperright','GarrLanding-HeaderBar','GarrLanding-MiddleTile','GarrLanding-Mission-Complete','GarrLanding-Mission-InProgress','GarrLanding-Building-Complete','GarrLanding-Building-InProgress','Garr_BuildingInfoShadow','GarrBuilding_Farm_1_A_Info','GarrBuilding_Farm_2_A_Info','GarrBuilding_Farm_3_A_Info','GarrBuilding_Farm_1_A_Map','GarrBuilding_Farm_2_A_Map','GarrBuilding_Farm_3_A_Map','GarrBuilding_LumberMill_1_A_Info','GarrBuilding_LumberMill_2_A_Info','GarrBuilding_LumberMill_3_A_Info','GarrBuilding_LumberMill_1_A_Map','GarrBuilding_LumberMill_2_A_Map','GarrBuilding_LumberMill_3_A_Map','GarrBuilding_SalvageYard_1_A_Info','GarrBuilding_SalvageYard_1_A_Map','GarrBuilding_SparringArena_1_A_Info','GarrBuilding_SparringArena_2_A_Info','GarrBuilding_SparringArena_3_A_Info','GarrBuilding_SparringArena_1_A_Map','GarrBuilding_SparringArena_2_A_Map','GarrBuilding_SparringArena_3_A_Map','GarrBuilding_Stables_1_A_Info','GarrBuilding_Stables_2_A_Info','GarrBuilding_Stables_3_A_Info','GarrBuilding_Stables_1_A_Map','GarrBuilding_Stables_2_A_Map','GarrBuilding_Stables_3_A_Map','GarrBuilding_Storehouse_1_A_Info','GarrBuilding_Storehouse_1_A_Map','GarrBuilding_TradingPost_1_A_Info','GarrBuilding_TradingPost_2_A_Info','GarrBuilding_TradingPost_3_A_Info','GarrBuilding_TradingPost_1_A_Map','GarrBuilding_TradingPost_2_A_Map','GarrBuilding_TradingPost_3_A_Map','Objective-ItemBorder','Garr_Building-AddFollowerPlus','Monuments-Frame','Monuments-LeftButton-Down','Monuments-LeftButton-Up','Monuments-RightButton-Down','Monuments-RightButton-Up','Monuments-LockedOverlay','Monuments-Lock','BonusChest-KeyholeBurst','BonusChest-KeyholeGlow','BonusChest-Lock','BonusChest-CircleGlow','guild-levelring','Calendar_Quest','groupfinder-highlightbar-green','groupfinder-highlightbar-yellow','groupfinder-icon-greencheckmark','groupfinder-icon-redx','groupfinder-button-arenas','groupfinder-button-battlegrounds','groupfinder-button-cover','groupfinder-button-custom-pve','groupfinder-button-custom-pvp','groupfinder-button-dungeons','groupfinder-button-questing','groupfinder-button-raids-bc','groupfinder-button-raids-cataclysm','groupfinder-button-raids-classic','groupfinder-button-raids-mists','groupfinder-button-raids-wrath','groupfinder-button-ratedbgs','groupfinder-button-scenarios','groupfinder-button-skirmishes','groupfinder-highlightbar-blue','Garr_SwapIcon','Garr_BuildFX-Glow','Garr_BuildFX-Lines','Garr_LockedBuilding','Garr_UpgradeFX-Glow','BonusChest-ItemBorder-Uncommon','BonusChest-Burst-Uncommon','bags-glow-purple','bags-glow-blue','bags-glow-orange','bags-glow-green','bags-glow-heirloom','bags-glow-white','bags-glow-flash','LFG-lock','Garr_Building_MaterialFrame','Garr_Mission_MaterialFrame','GarrMission_RewardsListBG','GarrMission_RewardsShadow','Garr_MissionList-CostBG','Garr_MissionList-IconBG','GarrMission_ParchmentHeaderSelect-End','_GarrMission_ParchmentHeaderSelect-Mid','GarrMission_MissionCostStartButtonBg','GarMission_ChestPercentageShadow','GarrMission_ChestOpenTextGlow','GarrMission_PortraitRing_Glow','GarrMission_PortraitRing_Highlight','splash-bigbutton','BonusChest-Smoke-Uncommon','splash-botleft','splash-boost-botleft','splash-boost-right','splash-boost-topleft','splash-601-botleft','splash-601-right','splash-601-topleft','splash-600-botleft','splash-600-right','splash-600-topleft','GarrMission_CheckGlow','GarrMission_MissionIcon-Blacksmithing','GarrMission_MissionIcon-Combat','GarrMission_MissionIcon-Exploration','GarrMission_ClassIcon-Hunter','GarrMission_ClassIcon-Warrior','GarrMission_ClassIcon-Priest','GarrMission_ClassIcon-Monk','GarrMission_ClassIcon-Rogue','GarrMission_ClassIcon-Mage','GarrMission_ClassIcon-Warlock','GarrMission_ClassIcon-Shaman','GarrMission_ClassIcon-Druid','GarrMission_ClassIcon-Paladin','GarrMission_ClassIcon-DeathKnight','GarrMission_EncounterBar-Xright','Garr_MissionFX-Glow','Garr_MissionFX-Lines','groupfinder-icon-leader','Garr_Map_Frostfire4_H','Garr_Map_Shadowmoon4_A','GarrMission-FollowerItemBg','bags-button-autosort-down','bags-button-autosort-up','bags-roundhighlight','GarrLanding-MinimapIcon-Alliance-Down','GarrLanding-MinimapIcon-Alliance-Up','GarrLanding-MinimapIcon-Horde-Up','GarrLanding-MinimapIcon-Horde-Down','GarrLanding-CircleGlow','GarrLanding-MinimapAlertBG','GarrLanding-SideToast-Glow','GarrLanding-TopTabHighlight','GarrLanding-TopTabSelected','GarrLanding-TopTabUnselected','Alliance_Tier1_Barracks','Alliance_Tier1_Professions','Alliance_Tier1_TownHall','GarrMission_MissionStart','loottoast-arrow-blue','loottoast-arrow-green','loottoast-arrow-orange','loottoast-arrow-purple','loottoast-bg-questrewardupgrade','loottoast-glow','loottoast-itemborder-blue','loottoast-itemborder-glow','loottoast-itemborder-green','loottoast-itemborder-orange','loottoast-itemborder-purple','loottoast-sheen','Headhunter_AbilityBorderGlow','Headhunter_BG','Headhunter_LineHeader','_GarrMissionLocation-FrostfireRidge-Back','_GarrMissionLocation-FrostfireRidge-Fore','_GarrMissionLocation-FrostfireRidge-Mid','GarrLanding_RewardsShadow','GarrLanding_RewardsListBG','GarrLandingList-CostBG','GarrMission_MissionIcon-Enchanting','GarrMission_MissionIcon-Salvage','GarrMission_MissionIcon-Provision','GarrMission_MissionIcon-Generic','GarrMission_MissionIcon-Siege','GarrMission_MissionIcon-Alchemy','GarrMission_MissionIcon-Wildlife','GarrMission_MissionIcon-Tailoring','GarrMission_MissionIcon-Training','GarrMission_MissionIcon-Trading','GarrMission_MissionIcon-Jewelcrafting','GarrMission_MissionIcon-Defense','GarrMission_MissionIcon-Construction','GarrMission_MissionIcon-Inscription','GarrMission_MissionIcon-Logistics','GarrMission_MissionIcon-Engineering','GarrMission_MissionIcon-Patrol','GarrMission_MissionIcon-Recruit','GarrMission_MissionIcon-Leatherworking','GarrBuilding_Jewelcrafting_1_A_Info','GarrBuilding_Jewelcrafting_2_A_Info','GarrBuilding_Jewelcrafting_3_A_Info','GarrBuilding_Jewelcrafting_1_A_Map','GarrBuilding_Jewelcrafting_2_A_Map','GarrBuilding_Jewelcrafting_3_A_Map','GarrBuilding_Enchanting_1_A_Info','GarrBuilding_Enchanting_2_A_Info','GarrBuilding_Enchanting_3_A_Info','GarrBuilding_Enchanting_1_A_Map','GarrBuilding_Enchanting_2_A_Map','GarrBuilding_Enchanting_3_A_Map','GarrBuilding_Blacksmith_1_A_Info','GarrBuilding_Blacksmith_2_A_Info','GarrBuilding_Blacksmith_3_A_Info','GarrBuilding_Blacksmith_1_A_Map','GarrBuilding_Blacksmith_2_A_Map','GarrBuilding_Blacksmith_3_A_Map','GarrBuilding_Fishing_1_A_Info','GarrBuilding_Fishing_2_A_Info','GarrBuilding_Fishing_3_A_Info','GarrBuilding_Fishing_1_A_Map','GarrBuilding_Fishing_2_A_Map','GarrBuilding_Fishing_3_A_Map','GarrBuilding_Workshop_1_A_Info','GarrBuilding_Workshop_2_A_Info','GarrBuilding_Workshop_3_A_Info','GarrBuilding_Workshop_1_A_Map','GarrBuilding_Workshop_2_A_Map','GarrBuilding_Workshop_3_A_Map','groupfinder-eye-highlight','GarrBuilding_Tailoring_1_A_Info','GarrBuilding_Tailoring_2_A_Info','GarrBuilding_Tailoring_3_A_Info','GarrBuilding_Tailoring_1_A_Map','GarrBuilding_Tailoring_2_A_Map','GarrBuilding_Tailoring_3_A_Map','GarrBuilding_Inscription_1_A_Info','GarrBuilding_Inscription_2_A_Info','GarrBuilding_Inscription_3_A_Info','GarrBuilding_Inscription_1_A_Map','GarrBuilding_Inscription_2_A_Map','GarrBuilding_Inscription_3_A_Map','GarrBuilding_Leatherworking_1_A_Info','GarrBuilding_Leatherworking_2_A_Info','GarrBuilding_Leatherworking_3_A_Info','GarrBuilding_Leatherworking_1_A_Map','GarrBuilding_Leatherworking_2_A_Map','GarrBuilding_Leatherworking_3_A_Map','GarrLanding-TradeskillTimer-ParchmentBG','GarrBuilding_EmptyPlot_A_1','GarrBuilding_EmptyPlot_A_2','GarrBuilding_EmptyPlot_A_3','GarrLanding-ShipmentCompleteGlow','GarrBuilding_PetStable_1_A_Info','GarrBuilding_PetStable_1_A_Map','_GarrMissionLocation-Gorgrond-Back','_GarrMissionLocation-Gorgrond-Fore','_GarrMissionLocation-Nagrand-Back','_GarrMissionLocation-Nagrand-Fore','_GarrMissionLocation-Nagrand-Mid','_GarrMissionLocation-Talador-Back','_GarrMissionLocation-Talador-Fore','_GarrMissionLocation-Talador-Mid','_GarrMissionLocation-ShadowmoonValley-Back','_GarrMissionLocation-ShadowmoonValley-Fore','_GarrMissionLocation-ShadowmoonValley-Mid','_GarrMissionLocation-SpiresofArak-Back','_GarrMissionLocation-SpiresofArak-Fore','_GarrMissionLocation-SpiresofArak-Mid','_GarrMissionLocation-Underground-Back','_GarrMissionLocation-Underground-Fore','_GarrMissionLocation-Underground-Mid','_GarrMissionLocation-TownHorde-Back','_GarrMissionLocation-TownHorde-Fore','_GarrMissionLocation-TownHorde-Mid','_GarrMissionLocation-TownAlliance-Back','_GarrMissionLocation-TownAlliance-Fore','_GarrMissionLocation-TownAlliance-Mid','GarrBuilding_Tailoring_1_H_Info','GarrBuilding_Tailoring_1_H_Map','GarrBuilding_Tailoring_2_H_Info','GarrBuilding_Tailoring_3_H_Info','GarrBuilding_Tailoring_2_H_Map','GarrBuilding_Tailoring_3_H_Map','GarrBuilding_Leatherworking_1_H_Info','GarrBuilding_Leatherworking_2_H_Info','GarrBuilding_Leatherworking_3_H_Info','GarrBuilding_Leatherworking_1_H_Map','GarrBuilding_Leatherworking_2_H_Map','GarrBuilding_Leatherworking_3_H_Map','GarrBuilding_Jewelcrafting_1_H_Info','GarrBuilding_Jewelcrafting_2_H_Info','GarrBuilding_Jewelcrafting_3_H_Info','GarrBuilding_Jewelcrafting_1_H_Map','GarrBuilding_Jewelcrafting_2_H_Map','GarrBuilding_Jewelcrafting_3_H_Map','GarrBuilding_Inscription_1_H_Info','GarrBuilding_Inscription_2_H_Info','GarrBuilding_Inscription_3_H_Info','GarrBuilding_Inscription_1_H_Map','GarrBuilding_Inscription_2_H_Map','GarrBuilding_Inscription_3_H_Map','GarrBuilding_Engineering_1_H_Info','GarrBuilding_Engineering_2_H_Info','GarrBuilding_Engineering_3_H_Info','GarrBuilding_Engineering_1_H_Map','GarrBuilding_Engineering_2_H_Map','GarrBuilding_Engineering_3_H_Map','GarrBuilding_Enchanting_1_H_Info','GarrBuilding_Enchanting_2_H_Info','GarrBuilding_Enchanting_3_H_Info','GarrBuilding_Enchanting_1_H_Map','GarrBuilding_Enchanting_2_H_Map','GarrBuilding_Enchanting_3_H_Map','GarrBuilding_Blacksmith_1_H_Info','GarrBuilding_Blacksmith_2_H_Info','GarrBuilding_Blacksmith_3_H_Info','GarrBuilding_Blacksmith_1_H_Map','GarrBuilding_Blacksmith_2_H_Map','GarrBuilding_Blacksmith_3_H_Map','GarrBuilding_Alchemy_1_H_Info','GarrBuilding_Alchemy_2_H_Info','GarrBuilding_Alchemy_3_H_Info','GarrBuilding_Alchemy_1_H_Map','GarrBuilding_Alchemy_2_H_Map','GarrBuilding_Alchemy_3_H_Map','GarrBuilding_Barn_1_H_Info','GarrBuilding_Barn_2_H_Info','GarrBuilding_Barn_3_H_Info','GarrBuilding_Barn_1_H_Map','GarrBuilding_Barn_2_H_Map','GarrBuilding_Barn_3_H_Map','GarrBuilding_Fishing_1_H_Info','GarrBuilding_Fishing_2_H_Info','GarrBuilding_Fishing_3_H_Info','GarrBuilding_Fishing_1_H_Map','GarrBuilding_Fishing_2_H_Map','GarrBuilding_Fishing_3_H_Map','GarrBuilding_Farm_1_H_Info','GarrBuilding_Farm_1_H_Map','GarrBuilding_EmptyPlot_H_3','GarrBuilding_EmptyPlot_H_2','GarrBuilding_EmptyPlot_H_1','GarrBuilding_Inn_1_H_Info','GarrBuilding_Inn_2_H_Info','GarrBuilding_Inn_3_H_Info','GarrBuilding_Inn_1_H_Map','GarrBuilding_Inn_2_H_Map','GarrBuilding_Inn_3_H_Map','GarrBuilding_TownHall_1_H_Info','GarrBuilding_TownHall_2_H_Info','GarrBuilding_TownHall_3_H_Info','GarrBuilding_TownHall_1_H_Map','GarrBuilding_TownHall_2_H_Map','GarrBuilding_TownHall_3_H_Map','GarrBuilding_Storehouse_1_H_Info','GarrBuilding_Storehouse_1_H_Map','GarrBuilding_SalvageYard_1_H_Info','GarrBuilding_SalvageYard_1_H_Map','GarrBuilding_Barracks_1_H_Info','GarrBuilding_Barracks_2_H_Info','GarrBuilding_Barracks_3_H_Info','GarrBuilding_Barracks_1_H_Map','GarrBuilding_Barracks_2_H_Map','GarrBuilding_Barracks_3_H_Map','GarrBuilding_SparringArena_1_H_Info','GarrBuilding_SparringArena_2_H_Info','GarrBuilding_SparringArena_3_H_Info','GarrBuilding_SparringArena_1_H_Map','GarrBuilding_SparringArena_2_H_Map','GarrBuilding_SparringArena_3_H_Map','GarrBuilding_Armory_1_H_Info','GarrBuilding_Armory_2_H_Info','GarrBuilding_Armory_3_H_Info','GarrBuilding_Armory_1_H_Map','GarrBuilding_Armory_2_H_Map','GarrBuilding_Armory_3_H_Map','GarrBuilding_MageTower_1_H_Info','GarrBuilding_MageTower_2_H_Info','GarrBuilding_MageTower_3_H_Info','GarrFollower-Shadow','GarrBuilding_MageTower_1_H_Map','GarrBuilding_MageTower_2_H_Map','GarrBuilding_MageTower_3_H_Map','GarrBuilding_Stables_2_H_Info','GarrBuilding_Stables_3_H_Info','GarrBuilding_Stables_1_H_Info','GarrBuilding_Stables_1_H_Map','GarrBuilding_Stables_2_H_Map','GarrBuilding_Stables_3_H_Map','GarrBuilding_TradingPost_1_H_Info','GarrBuilding_TradingPost_2_H_Info','GarrBuilding_TradingPost_3_H_Info','GarrBuilding_TradingPost_1_H_Map','GarrBuilding_TradingPost_2_H_Map','GarrBuilding_TradingPost_3_H_Map','GarrBuilding_Workshop_1_H_Info','GarrBuilding_Workshop_2_H_Info','GarrBuilding_Workshop_3_H_Info','GarrBuilding_Workshop_1_H_Map','GarrBuilding_Workshop_2_H_Map','GarrBuilding_Workshop_3_H_Map','GarrBuilding_Mine_1_H_Info','GarrBuilding_Mine_1_H_Map','GarrBuilding_LumberMill_1_H_Info','GarrBuilding_LumberMill_2_H_Info','GarrBuilding_LumberMill_3_H_Info','GarrBuilding_LumberMill_1_H_Map','GarrBuilding_LumberMill_2_H_Map','GarrBuilding_LumberMill_3_H_Map','GarrBuilding_PetStable_1_H_Info','GarrBuilding_PetStable_1_H_Map','GarrMission-AllianceChest','GarrMission-HordeChest','DungeonTargetIndicator','GarrMission_PortraitRing_Darkener','GarrMission_PortraitRing_Quality','BonusChest-OrangeSmoke-Wide','BonusChest-OrangeGlow-Wide','loottoast-bg-alliance','loottoast-bg-horde','groupfinder-button-highlight','groupfinder-button-select','groupfinder-button-cover-down','GarrMission_EncounterBar-CheckMark-Left','GarrMission_EncounterBar-CheckMark-Right','GarrMission_EncounterBar-CheckMark','GarrMission_EncounterBar-CheckMarkCircleSwipe','Alliance_Tier1_Mine','Alliance_Tier1_Trading1','Alliance_Tier1_Armory1','Alliance_Tier1_Mage1','Alliance_Tier1_Mage2','Alliance_Tier1_Armory2','Alliance_Tier1_Stables1','Alliance_Tier1_Barracks1','Alliance_Tier1_Stables2','Alliance_Tier1_Lumber1','Alliance_Tier1_Barn2','Alliance_Tier1_Professions2','Alliance_Tier1_Inn1','Alliance_Tier1_Farm','Menagery1','Alliance_Tier1_Arena2','Alliance_Tier1_Lumber2','Alliance_Tier1_Trading2','Alliance_Tier1_Fishing','Alliance_Tier1_Barn1','Alliance_Tier1_Inn2','Alliance_Tier1_Arena1','Alliance_Tier2_Arena1','Alliance_Tier2_Arena2','Alliance_Tier2_Armory1','Alliance_Tier2_Armory2','Alliance_Tier2_Barn1','Alliance_Tier2_Barn2','Alliance_Tier2_Barracks1','Alliance_Tier2_Inn1','Alliance_Tier2_Inn2','Alliance_Tier2_Lumber1','Alliance_Tier2_Lumber2','Alliance_Tier2_Mage1','Alliance_Tier2_Mage2','Alliance_Tier2_Stables1','Alliance_Tier2_Stables2','Alliance_Tier2_Trading1','Alliance_Tier2_Trading2','Alliance_Tier3_Barn1','Alliance_Tier3_Lumber1','Alliance_Tier3_Mage2','Alliance_Tier3_Inn1','Alliance_Tier3_Barracks1','Alliance_Tier3_Armory2','Alliance_Tier3_Mage1','Alliance_Tier3_Lumber2','Alliance_Tier3_Inn2','Alliance_Tier3_Stables1','Alliance_Tier3_Trading2','Alliance_Tier3_Arena1','Alliance_Tier3_Trading1','Alliance_Tier3_Stables2','Alliance_Tier3_Barn2','Alliance_Tier3_Armory1','Alliance_Tier3_Arena2','Alliance_Tier1_Barracks2','Alliance_Tier2_Barracks2','Alliance_Tier3_Barracks2','Alliance_Tier1_Workshop1','Alliance_Tier1_Workshop2','Alliance_Tier2_Workshop1','Alliance_Tier2_Workshop2','Alliance_Tier3_Workshop1','Alliance_Tier3_Workshop2','StreamCinematic-LK-Down','StreamCinematic-LK-Up','StreamCinematic-WOD-Down','StreamCinematic-WOD-Up','StreamCinematic-BC-Down','StreamCinematic-BC-Up','StreamCinematic-CC-Down','StreamCinematic-CC-Up','StreamCinematic-Classic-Down','StreamCinematic-Classic-Up','StreamCinematic-DownloadIcon','StreamCinematic-Highlight','StreamCinematic-PlayButton','StreamCinematic-ProgressBarBG','StreamCinematic-MOP-Down','StreamCinematic-MOP-Up','accountupgradebanner-bc','accountupgradebanner-cataclysm','accountupgradebanner-classic','accountupgradebanner-mop','accountupgradebanner-wod','accountupgradebanner-wotlk','MissionFX-Smoke','MissionFX-SparkLines','Horde_Tier1_Arena1','Horde_Tier1_Arena2','Horde_Tier1_Armory1','Horde_Tier1_Armory2','Horde_Tier1_Barn1','Horde_Tier1_Barn2','Horde_Tier1_Barracks1','Horde_Tier1_Barracks2','Horde_Tier1_Farm1','Horde_Tier1_Fishing1','Horde_Tier1_Inn1','Horde_Tier1_Inn2','Horde_Tier1_Lumber1','Horde_Tier1_Lumber2','Horde_Tier1_Mage1','Horde_Tier1_Mage2','Horde_Tier1_Mine1','Horde_Tier1_Profession1','Horde_Tier1_Profession2','Horde_Tier1_Profession3','Horde_Tier1_Stables1','Horde_Tier1_Stables2','Horde_Tier1_Trading1','Horde_Tier1_Trading2','Horde_Tier1_Workshop1','Horde_Tier1_Workshop2','Horde_Tier2_Arena1','Horde_Tier2_Arena2','Horde_Tier2_Armory1','Horde_Tier2_Armory2','Horde_Tier2_Barn1','Horde_Tier2_Barn2','Horde_Tier2_Barracks1','Horde_Tier2_Barracks2','Horde_Tier2_Inn1','Horde_Tier2_Inn2','Horde_Tier2_Lumber1','Horde_Tier2_Lumber2','Horde_Tier2_Mage1','Horde_Tier2_Mage2','Horde_Tier2_Stables1','Horde_Tier2_Stables2','Horde_Tier2_Trading1','Horde_Tier2_Trading2','Horde_Tier2_Workshop1','Horde_Tier2_Workshop2','Horde_Tier3_Arena1','Horde_Tier3_Arena2','Horde_Tier3_Armory1','Horde_Tier3_Armory2','Horde_Tier3_Barn1','Horde_Tier3_Barn2','Horde_Tier3_Barracks1','Horde_Tier3_Barracks2','Horde_Tier3_Inn1','Horde_Tier3_Inn2','Horde_Tier3_Lumber1','Horde_Tier3_Lumber2','Horde_Tier3_Mage1','Horde_Tier3_Mage2','Horde_Tier3_Stables1','Horde_Tier3_Stables2','Horde_Tier3_Trading1','Horde_Tier3_Trading2','Horde_Tier3_Workshop1','Horde_Tier3_Workshop2','GarrMission_TabGlow','Garr_Plot_Frostfire_H_3','Garr_Plot_Frostfire_H_2','Garr_Plot_Frostfire_H_1','Garr_Plot_Frostfire_H_4','BonusChest-GreenGlow-Wide','GarrMission_PortraitRing_iLvlBorder','bags-icon-consumables','bags-icon-equipment','bags-icon-tradegoods','search-highlight','search-select','_search-rowbg','GarrMission_EncounterAbilityBorder-Lg','GarrMission_EncounterBar-Elite','GarrMission_RewardsBox_Shadow','GarrMission_MissionCompleteChanceBg','GarrMission_CurrentEncounter-Glow','GarrMission_CurrentEncounter-SpikeyGlow','_GarrMissionLocation-Gorgrond-Mid','GarrMissionLocation-FrostfireRidge-List','GarrMissionLocation-Gorgrond-List','GarrMissionLocation-Nagrand-List','GarrMissionLocation-ShadowmoonValley-List','GarrMissionLocation-SpiresofArak-List','GarrMissionLocation-Talador-List','GarrMissionLocation-TannanJungle-List','groupfinder-icon-class-deathknight','groupfinder-icon-class-druid','groupfinder-icon-class-hunter','groupfinder-icon-class-mage','groupfinder-icon-class-monk','groupfinder-icon-class-paladin','groupfinder-icon-class-priest','groupfinder-icon-class-rogue','groupfinder-icon-class-shaman','groupfinder-icon-class-warlock','groupfinder-icon-class-warrior','groupfinder-icon-emptyslot','groupfinder-icon-quest','groupfinder-icon-role-large-dps','groupfinder-icon-role-large-heal','groupfinder-icon-role-large-tank','_GarrMissionLocation-BlackrockMountain-Back','_GarrMissionLocation-BlackrockMountain-Fore','_GarrMissionLocation-BlackrockMountain-Mid','_GarrMissionLocation-BlackrockMountain-List','GarrLanding-Tab-Bottom-Selected','GarrLanding-Tab-Bottom-Unselected','GarrLanding-Tab-Bottom-Highlight','challenges-timerborder','challenges-blackfade','challenges-timerbg','challenges-bannershine','challenges-toast','Banner-BgFiligree','Banner-FiligreeShadow','Banner-SmallFiligree','ScenariosIcon','ScenarioTrackerToast-FinalFiligree','ScenarioTrackerToast','Toast-Flash','Toast-Frame','Toast-IconBG','challenges-nomedal','Bonus-ToastBanner','groupfinder-button-ashran','groupfinder-background-arenas','groupfinder-background-ashran','groupfinder-background-battlegrounds','groupfinder-background-custom-pve','groupfinder-background-custom-pvp','groupfinder-background-dungeons','groupfinder-background-questing','groupfinder-background-raids-bc','groupfinder-background-raids-cataclysm','groupfinder-background-raids-classic','groupfinder-background-raids-mists','groupfinder-background-raids-wrath','groupfinder-background-ratedbgs','groupfinder-background-scenarios','groupfinder-background-skirmishes','groupfinder-background-raids-warlords','groupfinder-button-raids-warlords','GarrLanding-Tab-Bottom-Selected-Right','GarrLanding-Tab-Bottom-Unselected-Left','GarrLanding-Tab-Bottom-Selected-Left','GarrLanding-Tab-Bottom-Highlight-Right','GarrLanding-Tab-Bottom-Highlight-Left','GarrLanding-Tab-Bottom-Unselected-Right','collections-watermark-toy','CacheToast-Glow','CacheToast','NPE_ExclamationPoint','NPE_Icon','NPE_LeftClick','NPE_RightClick','NPE_TurnIn','NPE_ArrowDownGlow','NPE_ArrowUpGlow','NPE_ArrowUp','NPE_ArrowDown','NPE_ArrowRightGlow','NPE_keyboard','NPE_ArrowRight','NPE_ArrowLeftGlow','NPE_ArrowLeft','UI-Minimap-Clock','GarrLanding-TradeskillTimer-Border','barbershop-background','groupfinder-waitdot','OBJFX-BarGlow','deathrecap-icon-tombstone','collections-watermark-heirloom','Crop-Corner','Crop-Side','Crop-Top','WoWShare-AchievementIcon','WoWShare-AddButton-Down','WoWShare-AddButton-Up','WoWShare-ChatIcon','WoWShare-Highlight','WoWShare-ItemQualityBorder','WoWShare-Plus','WoWShare-Selection','WoWShare-ItemIcon','WoWShare-ScreenshotIcon','token-button-category','token-itemslot','token-choice-bnet','token-choice-wow','WoWShare-EdgeArt','UI-DialogBox-goldbutton-down-right-blue','UI-DialogBox-goldbutton-down-left-blue','UI-DialogBox-goldbutton-up-middle-blue','UI-DialogBox-goldbutton-up-right-blue','UI-DialogBox-goldbutton-up-left-blue','UI-DialogBox-goldbutton-down-middle-blue','BossBanner-BottomFillagree','BossBanner-SkullCircle','BossBanner-TopFillagree','BossBanner-RedFlash','BossBanner-LeftFillagree','BossBanner-RightFillagree','BossBanner-SkullSpikes','deathrecap-iconborder','deathrecap-background-innerglow','!GeneralFrame-InsetFrame-Left','!GeneralFrame-InsetFrame-Right','GeneralFrame-HorizontalBar-Left','GeneralFrame-HorizontalBar-Right','GeneralFrame-InsetFrame-BottomLeft','GeneralFrame-InsetFrame-BottomRight','GeneralFrame-InsetFrame-TopLeft','GeneralFrame-InsetFrame-TopRight','_GeneralFrame-HorizontalBar','_GeneralFrame-InsetFrame-Bottom','_GeneralFrame-InsetFrame-Top','collections-upgradeglow','XPBarAnim-OrangeGain','XPBarAnim-OrangeSpark','XPBarAnim-OrangeTrail','XPBarAnim-OrangeGlow','XPBarAnim-GlowLines','collections-upgradeglow-blue','splash-610-botleft','splash-610-right','splash-610-topleft','Garr_MissionToast-Blank','colorblind-bar-green','colorblind-bar-red','colorblind-bar-yellow','colorblind-colorwheel','GarrMission_MissionTooltipAway','GarrMission_MissionTooltipWorking','GarrMission_CounterHalfCheck','TalkingHeads-Glow-TopSpike','TalkingHeads-PortraitBg','TalkingHeads-TextBackground','TalkingHeads-PortraitFrame','TalkingHeads-Glow-TopBarGlow','TalkingHeads-Glow-SideBarGlow','TalkingHeads-Glow-Sheen','TalkingHeads-Glow-TextSheen','GarrMission-AbilityHighlight','token-info-background','WoWShare-TwitterLogo','token-info-arrow','adventureguide-pane-large','adventureguide-ring','BossBanner-BgBanner-Bottom','BossBanner-BgBanner-Top','LootBanner-IconGlow','LootBanner-ItemBg','LootBanner-LootBagCircle','BossBanner-BgBanner-Mid','LootToast-LessAwesome','transmog-frame-pink','transmog-frame-red','transmog-frame-selected','transmog-frame','transmog-icon-chat','transmog-icon-checkmark','transmog-icon-remove','transmog-icon-revert-small-disabled','transmog-icon-revert-small','transmog-icon-revert','transmog-wardrobe-border-collected','transmog-wardrobe-border-highlighted','transmog-wardrobe-border-selected','transmog-wardrobe-border-uncollected','adventureguide-pane-small','NavalMap01','!ShipMission_Bg-Edge','!ShipMission_RewardsBorder-Left-Desaturate','!GarrMission_Bg-DarkEdge','!ShipMission_Bg-DarkEdge','_ShipMission_Bg-BottomEdge','_ShipMission_Bg-BottomEdgeSmall','_ShipMission_LocationCover-Bottom','_ShipMission_RewardsBorder-Top-Desaturate','_ShipMission_TopBorder','ShipMission_FollowerListButton-Highlight','ShipMission_FollowerListButton-Select','ShipMission_FollowerListButton','ShipMission_IconLevelBG','ShipMission_TopBorderCorner','ShipMission_Bg-DarkEdgeCorner','ShipMission_BoatRarity-Epic','ShipMission_BoatRarity-Rare','ShipMission_BoatRarity-Uncommon','ShipMission_DangerousSkull','ShipMission_EncounterAbilityBorder-Lg','ShipMission_EncounterAbilityBorder','ShipMission_LocationCover-Side','ShipMission_MissionCostStartButtonBg','ShipMission_RewardsBG-Desaturate','ShipMission_RewardsBorder-Corner-Desaturate','ShipMission_StartMissionFrame','ShipMissionParchment-Tile','_GarrMissionLocation-TannanSea-Back','_GarrMissionLocation-TannanSea-Fore','_GarrMissionLocation-TannanSea-Mid','ShipMission_CurrencyIcon-Oil','NavalMap-Horde-Fog','NavalMap-Horde-Highlight','NavalMap-Alliance-Fog','NavalMap-IronHorde-Fog','NavalMap-OpenWaters-Fog','NavalMap-Alliance-Highlight','NavalMap-IronHorde-Highlight','NavalMap-OpenWaters-Highlight','ShipMission_FollowerBG','ShipMission_FollowerBG-Glow','Ships_GalleonH-List','Ships_GalleonH-Portrait','Ships_GalleonH-Map','ShipMissionIcon-Combat-Map','ShipMissionIcon-Combat-MapBadge','ShipMissionIcon-Oil-Map','ShipMissionIcon-Oil-MapBadge','ShipMissionIcon-SiegeA-Map','ShipMissionIcon-SiegeA-MapBadge','ShipMissionIcon-SiegeH-Map','ShipMissionIcon-SiegeH-MapBadge','ShipMissionIcon-Training-Map','ShipMissionIcon-Training-MapBadge','ShipMissionIcon-Treasure-Map','ShipMissionIcon-Treasure-MapBadge','Ships_TroopTransport-List','Ships_TroopTransport-Portrait','Ships_TroopTransport-Map','Ships_EnemyTroopTransport-Portrait','Ships_Dreadnaught-List','Ships_Dreadnaught-Portrait','Ships_Dreadnaught-Map','Ships_EnemyDreadnaught-Portrait','Ships_SubmarineH-List','Ships_SubmarineH-Portrait','Ships_SubmarineH-Map','Ships_EnemySubmarineH-Portrait','Ships_SubmarineA-List','Ships_SubmarineA-Portrait','Ships_SubmarineA-Map','Ships_EnemySubmarineA-Portrait','ShipMissionIcon-Combat-Mission','ShipMissionIcon-Oil-Mission','ShipMissionIcon-SiegeA-Mission','ShipMissionIcon-SiegeH-Mission','ShipMissionIcon-Training-Mission','ShipMissionIcon-Treasure-Mission','Ships_EnemyGalleonH-Portrait','Ships_GalleonA-List','Ships_GalleonA-Portrait','Ships_GalleonA-Map','Ships_EnemyGalleonA-Portrait','Ships_CargoShip-List','Ships_CargoShip-Portrait','Ships_CargoShip-Map','Ships_EnemyCargoShip-Portrait','Ships_Carrier-List','Ships_Carrier-Portrait','Ships_Carrier-Map','Ships_EnemyCarrier-Portrait','ShipMission_ShipFollower-EquipmentBG','ShipMission_ShipFollower-EquipmentFrame','ShipMission_ShipFollower-Lock-Epic','ShipMission_ShipFollower-Lock-Rare','ShipMission_ShipFollower-TypeFrame','transmog-frame-small-pink','transmog-frame-small','transmog-frame-small-selected','transmog-frame-small-red','ShipMission-RedGlowRing','adventureguide-rewardring','WildBattlePet','StableMaster','ArchBlob','Banker','Focus','BattleMaster','Ammunition','Class','Profession','Target','Food','Reagents','Innkeeper','Auctioneer','Repair','Mailbox','FlightMaster','None','QuestBlob','TrivialQuests','Poisons','PlayerFriend','QuestRepeatableTurnin','MantidTowerDestroyed','PortalRed','QuestTurnin','Object','Gear','MonsterFriend','MonsterEnemy','PortalPurple','DungeonSkull','PlayerNeutral','MonsterNeutral','PortalBlue','QuestLegendaryTurnin','QuestDaily','PlayerControlled','VignetteLoot','VignetteEvent','PlayerEnemy','PartyMember','XMarksTheSpot','QuestObjective','QuestLegendary','ArtifactQuest','QuestNormal','VignetteLootElite','FlightPath','VignetteEventElite','ChatBallon','MantidTower','RaidMember','VignetteKill','QuestBonusObjective','ArtifactQuestTurnin','SmallQuestBang','VignetteKillElite','GreenCross','PlayerDeadBlip','PlayerPartyBlip','PlayerRaidBlip','Vehicle-Air-Alliance','Vehicle-Air-Horde','Vehicle-Air-Occupied','Vehicle-Air-Unoccupied','Vehicle-AllianceCart','Vehicle-Carriage','Vehicle-Ground-Occupied','Vehicle-Ground-Unoccupied','Vehicle-GrummleConvoy','Vehicle-HammerGold-1','Vehicle-HammerGold-2','Vehicle-HammerGold-3','Vehicle-HammerGold','Vehicle-HordeCart','Vehicle-Mogu','Vehicle-SilvershardMines-Arrow','Vehicle-SilvershardMines-MineCart','Vehicle-SilvershardMines-MineCartBlue','Vehicle-SilvershardMines-MineCartRed','Vehicle-TempleofKotmogu-CyanBall','Vehicle-TempleofKotmogu-GreenBall','Vehicle-TempleofKotmogu-OrangeBall','Vehicle-TempleofKotmogu-PurpleBall','Vehicle-Trap-Gold','Vehicle-Trap-Grey','Vehicle-Trap-Red','QuestSkull','Focus-Tracker','MagePortalAlliance','MagePortalHorde','QuestArtifact','QuestArtifactTurnin','Target-Tracker','WarlockPortalAlliance','WarlockPortalHorde','WildBattlePet-Tracker','WildBattlePetCapturable','CrossedFlags','CrossedFlagsWithTimer','MiniMap-DeadArrow','MiniMap-PositionArrows','MiniMap-QuestArrow','MiniMap-VignetteArrow','MinimapArrow','Rotating-MinimapArrow','Rotating-MinimapGroupArrow','Rotating-MinimapGuideArrow','MiniMap-PositionArrowDown','MiniMap-PositionArrowUp','MovieRecordingIcon','BossBanner-RedLightning','Artifacts-PerkRing-GoldMedal','Artifacts-PerkRing-MainProc-Glow','Artifacts-PerkRing-MainProc','Artifacts-PerkRing-Small','Artifacts-PointsBox','Artifacts-PerkRing-Highlight','ArtifactsFX-SpinningGlowys','ArtifactsFX-StarBurst','ArtifactsFX-Whirls','ArtifactsFX-YellowRing','Artifacts-DemonHunter-BG','Artifacts-Paladin-BG','Artifacts-PointsBoxGreen','ArtifactsFX-PointSideBurstLeft','ArtifactsFX-PointSideBurstRight','vas-receipt-selectedcharbg','Ships_CarrierA-List','Ships_CarrierA-Portrait','Ships_CarrierA-Map','Ships_CarrierH-Map','Ships_CarrierH-List','Ships_CarrierH-Portrait','GarrLanding-ShipMission-Complete','GarrLanding-ShipMission-InProgress','_GarrMissionLocation-FrostfireSea-Back','_GarrMissionLocation-FrostfireSea-Fore','_GarrMissionLocation-FrostfireSea-Mid','_GarrMissionLocation-ShadowmoonSea-Back','_GarrMissionLocation-ShadowmoonSea-Fore','_GarrMissionLocation-ShadowmoonSea-Mid','_GarrMissionLocation-NagrandSea-Back','_GarrMissionLocation-NagrandSea-Fore','_GarrMissionLocation-NagrandSea-Mid','ShipMission_Toast','adventureguide-redx','Artifacts-MageArcane-BG','GarrisonFX_BlueFlare','GarrMission_WeakEncounterAbilityBorder-Lg','bonusobjectives-bar-bg','bonusobjectives-bar-fill','bonusobjectives-bar-frame','bonusobjectives-bar-glow-ring','bonusobjectives-bar-glow','bonusobjectives-bar-ring','bonusobjectives-bar-sheen','bonusobjectives-bar-spark','bonusobjectives-bar-starburst','bonusobjectives-title-bg','bonusobjectives-title-icon','ShipMission_NameBG','ShipMission_PartyBuffsBG','Ships_DreadnaughtA-List','Ships_DreadnaughtA-Portrait','Ships_DreadnaughtA-Map','Ships_DreadnaughtH-List','Ships_DreadnaughtH-Portrait','Ships_DreadnaughtH-Map','Ships_EnemyDreadnaughtH-Portrait','Ships_EnemyDreadnaughtA-Portrait','FontStyle_Parchment','FontStyle_BlueGradient','FontStyle_Garrisons','FontStyle_IronHordeMetal','FontStyle_Legion','FontStyle_Metal','splash-620-botleft','splash-620-right','splash-620-topleft','Artifacts-DeathKnightFrost-BG','shop-card-darkcover','Artifacts-Warrior-BG','Artifacts-Rogue-BG','Artifacts-Druid-BG','ShipMissionIcon-Bonus-Mission','ShipMissionIcon-Bonus-Map','ShipMissionIcon-Bonus-MapBadge','NavalMap-CircleGlowTrails','NavalMap-LargeBonusCircle','NavalMap-SmallBonusCircle','GarrisonFX-StarBurst','GarrMission_WeakEncounterAbilityBorder','ShipMission-TimerBG','services-icon-warning','ShipMissionIcon-Legendary-Map','ShipMissionIcon-Legendary-MapBadge','ShipMissionIcon-Legendary-Mission','_ForgeBorder-Top','!ForgeBorder-Right','_DemonHunter-DemonicFuryBar','services-icon-goldborder','vas-receipt-brownarrow','vas-receipt-greenbg','Ships_EnemyCarrierA-Portrait','Ships_EnemyCarrierH-Portrait','LootToast-MoreAwesome','legioninvasion-map-icon-portal-large','legioninvasion-map-icon-portal','legioninvasion-scenario-rewardring','legioninvasion-ScenarioTrackerToast','legioninvasion-Toast-Frame','legioninvasion-map-cover','ShipMissionIcon-SiegeIHA-Map','ShipMissionIcon-SiegeIHA-MapBadge','ShipMissionIcon-SiegeIHH-Map','ShipMissionIcon-SiegeIHH-MapBadge','ShipMissionIcon-SiegeIHA-Mission','ShipMissionIcon-SiegeIHH-Mission','tournamentarena-flag-large-blue-flash','tournamentarena-flag-large-blue','tournamentarena-flag-large-red-flash','tournamentarena-flag-large-red','tournamentarena-frame-bg-side-blue','tournamentarena-frame-bg-side-red','tournamentarena-frame-bot','tournamentarena-frame-botleft','tournamentarena-frame-botright','tournamentarena-frame-left','tournamentarena-frame-right','tournamentarena-frame-top','tournamentarena-frame-topleft','tournamentarena-frame-topright','tournamentarena-titlebackplate','honorsystem-bar-background','honorsystem-bar-frame','honorsystem-bar-spark','honorsystem-bar-rewardborder-prestige-flash','honorsystem-bar-rewardborder-prestige','honorsystem-bar-rewardborder','honorsystem-prestige-laurel-bg-alliance','honorsystem-prestige-laurel-bg-horde','honorsystem-prestige-laurel','honorsystem-talents-bg','_honorsystem-bar-fill','honorsystem-icon-prestige-1','honorsystem-icon-prestige-10','honorsystem-icon-prestige-11','honorsystem-icon-prestige-2','honorsystem-icon-prestige-3','honorsystem-icon-prestige-4','honorsystem-icon-prestige-5','honorsystem-icon-prestige-6','honorsystem-icon-prestige-7','honorsystem-icon-prestige-8','honorsystem-icon-prestige-9','bonusobjectives-title-icon-honor','honorsystem-bar-frame-small','honorsystem-bar-rewardborder-circle','honorsystem-icon-bonus','honorsystem-portrait-alliance','honorsystem-portrait-horde','DemonInvasion1','DemonInvasion2','DemonInvasion3','DemonInvasion4','_Shaman-MaelstromBar','_Druid-LunarBar','titleprestige-glowcover','titleprestige-prestigeicon','titleprestige-starglow','titleprestige-title','titleprestige-title2','titleprestige-wreath','titleprestige-title-bg','titleprestige-ember','services-popup-bot','services-popup-botleft','services-popup-botright','services-popup-top','services-popup-topleft','services-popup-topright','services-popup-bg','services-popup-left','services-popup-right','titleprestige-wings','titleprestige-wings2','titleprestige-wings-white','titleprestige-wings2-white','titleprestige-starcrown','AdventureMapLabel-Large','AdventureMapLabel-Small','AdventureMapIcon-DailyQuest','AdventureMapIcon-MissionCombat','AdventureMapIcon-Quest','AdventureMapIcon-SandboxQuest','QuestPortraitIcon-SandboxQuest','Mage-ArcaneCharge','Mage-ArcaneChargeBar','Priest-InsanityOverlay','_Priest-InsanityBar','Legion-boostpopup-bottom','Legion-boostpopup-middle','Legion-boostpopup-top','AdventureMapIcon-Lock','AdventureMapLabel-MissionTimer','AdventureMapLabel-QuestDiscovered','FXAM-QuestBang','FXAM-SmallSpikeyGlow','Mission-FollowerPortraitFrame','Mission-LootBackgroundGlow','FogofWar','AdventureMapQuest-QuestPane','AdventureMapQuest-RewardsPanel','AdventureMapQuest-ItemNameBG','charactercreate-banner-bottom','charactercreate-banner-middle','charactercreate-banner-top','Artifacts-Shaman-BG','Artifacts-Hunter-BG','Artifacts-Priest-BG','Artifacts-Monk-BG','Artifacts-Warlock-BG','services-checkmark','services-cover-ring','services-cover','services-icon-bonus-large','services-icon-bonus-red','services-icon-bonus','services-icon-processing','services-number-1','services-number-2','services-number-3','services-number-4','services-number-5','services-number-6','services-number-7','services-number-8','services-number-9','services-ring-countcircle','services-ring-large-glow','services-ring-large-glowpulse','services-ring-large-glowspin','services-ring-large','services-ring-wod','services-ring','services-yellowarrow','transmog-nav-slot-back','transmog-nav-slot-chest','transmog-nav-slot-feet','transmog-nav-slot-hands','transmog-nav-slot-head','transmog-nav-slot-legs','transmog-nav-slot-mainhand','transmog-nav-slot-selected','transmog-nav-slot-shirt','transmog-nav-slot-shoulder','transmog-nav-slot-tabard','transmog-nav-slot-waist','transmog-nav-slot-wrist','boostpopup-wod-bottom','boostpopup-wod-middle','boostpopup-wod-top','Relic-Arcane-Slot','Relic-Arcane-TraitBG','Relic-Arcane-TraitGlow','Relic-Arcane-TraitGlowRing','Relic-Blood-Slot','Relic-Blood-TraitBG','Relic-Blood-TraitGlow','Relic-Blood-TraitGlowRing','Relic-Fel-Slot','Relic-Fel-TraitBG','Relic-Fel-TraitGlow','Relic-Fel-TraitGlowRing','Relic-Fire-Slot','Relic-Fire-TraitBG','Relic-Fire-TraitGlow','Relic-Fire-TraitGlowRing','Relic-Frost-Slot','Relic-Frost-TraitBG','Relic-Frost-TraitGlow','Relic-Frost-TraitGlowRing','Relic-Holy-Slot','Relic-Holy-TraitBG','Relic-Holy-TraitGlow','Relic-Holy-TraitGlowRing','Relic-Iron-Slot','Relic-Iron-TraitBG','Relic-Iron-TraitGlow','Relic-Iron-TraitGlowRing','Relic-Life-Slot','Relic-Life-TraitBG','Relic-Life-TraitGlow','Relic-Life-TraitGlowRing','Relic-Shadow-Slot','Relic-Shadow-TraitBG','Relic-Shadow-TraitGlow','Relic-Shadow-TraitGlowRing','Relic-SlotBG','Relic-Water-Slot','Relic-Water-TraitBG','Relic-Water-TraitGlow','Relic-Water-TraitGlowRing','Relic-Wind-Slot','Relic-Wind-TraitBG','Relic-Wind-TraitGlow','Relic-Wind-TraitGlowRing','transmog-toast-bg','FullAlert-BigSpike','FullAlert-SoftCurveGlow','FullAlert-YellowCurveGlow','FullAlert-FrameGlow','accountupgradebanner-legion','Glues-WoW-LegionLogo','Glues-WoW-LegionLogo_cn','Glues-WoW-LegionLogo_tw','shop-games-legion','shop-games-legiondeluxe-card','shop-games-magnifyingglass','shop-games-legiondeluxe','Barbershop-Bottom','Barbershop-Top','!Barbershop-MiddleTile','AftLevelup-CloudyLineLeft','AftLevelup-CloudyLineRight','AftLevelup-Dots1','AftLevelup-Dots2','AftLevelup-GlowLine','AftLevelup-IconFrame','AftLevelup-IconGlow','AftLevelup-Lines1','AftLevelup-Lines2','AftLevelup-SoftCloud','AftLevelup-ToastBG','AftLevelup-FiligreeLeft','AftLevelup-FiligreeRight','transmog-nav-slot-secondaryhand','AftLevelup-WhiteIconGlow','AftLevelup-WhiteStarBurst','_transmog-preview-QuestPortrait-Divider_noname','_transmog-preview-QuestPortrait-StoneSwirls-Top','transmog-icon-downarrow','Forge-ColorSwatch','Forge-ColorSwatchBorder','Forge-ColorSwatchSelection','Forge-Lock','ForgeBorder-CornerBottomLeft','ForgeBorder-CornerBottomRight','ForgeBorder-CornerTopRight','Forge-Background','Artifacts-HeaderBG','Artifacts-Paladin-Header','Artifacts-DeathKnightFrost-Header','Artifacts-DemonHunter-Header','Artifacts-Druid-Header','search-iconframe-large','search-highlight-large','Artifacts-Hunter-Header','Artifacts-MageArcane-Header','Artifacts-Monk-Header','Artifacts-Priest-Header','Artifacts-Rogue-Header','Artifacts-Shaman-Header','Artifacts-Warlock-Header','Artifacts-Warrior-Header','titleprestige-prestigeiconplate-alliance','titleprestige-prestigeiconplate-horde','Artifacts-PerkRing-WhiteGlow','AdventureMapQuest-PortraitBG','Rune-01-dark','Rune-01-light','Rune-02-dark','Rune-02-light','Rune-03-dark','Rune-03-light','Rune-04-dark','Rune-04-light','Rune-05-dark','Rune-05-light','Rune-06-dark','Rune-06-light','Rune-07-dark','Rune-07-light','Rune-08-dark','Rune-08-light','Rune-09-dark','Rune-09-light','Rune-10-dark ','Rune-10-light','Rune-11-dark','Rune-11-light','Mage-ArcaneCharge-CircleGlow','Mage-ArcaneCharge-Rune','Mage-ArcaneCharge-SmallSpark','Mage-ArcaneCharge-Spark','Forge-AppearanceStrip','Forge-ColorSwatchBackground','Forge-ColorSwatchHighlight','AdventureMap_TopBorder','AdventureMap_TileBg','Artifacts-PriestShadow-BG','Artifacts-PriestShadow-Header','bags-glow-artifact','AdventureMap-InsetMapBorder','Artifacts-Paladin-KnowledgeRank','ClassOverlay-HolyPower1off','ClassOverlay-HolyPower1on','ClassOverlay-HolyPower2off','ClassOverlay-HolyPower2on','ClassOverlay-HolyPower3off','ClassOverlay-HolyPower3on','ClassOverlay-HolyPower4off','ClassOverlay-HolyPower4on','ClassOverlay-HolyPower5off','ClassOverlay-HolyPower5on','ClassOverlay-HolyPowerBG','Artifacts-DeathKnightFrost-KnowledgeRank','Artifacts-DemonHunter-KnowledgeRank','Artifacts-Druid-KnowledgeRank','Artifacts-Hunter-KnowledgeRank','Artifacts-MageArcane-KnowledgeRank','Artifacts-Monk-KnowledgeRank','Artifacts-Priest-KnowledgeRank','Artifacts-PriestShadow-KnowledgeRank','Artifacts-Rogue-KnowledgeRank','Artifacts-Shaman-KnowledgeRank','Artifacts-Warlock-KnowledgeRank','Artifacts-Warrior-KnowledgeRank','ClassOverlay-Fury','ClassOverlay-FuryBG','ClassOverlay-Rune','ClassOverlay-RunicPower','ClassOverlay-RunicPowerBg','ClassOverlay-ComboPoint','LegionSplash-NewCharacter','LegionSplash-DemonHunterButton','LegionSplash-Logo','LegionSplash-NewCharacterButton','LegionSplash-DemonHunter','legioninvasion-title-bg','transmog-nav-slot-enchant','transmog-nav-slot-selected-small','nameplates-bar-background','honorsystem-portrait-neutral','nameplates-holypower1-off','nameplates-holypower1-on','nameplates-holypower2-off','nameplates-holypower2-on','nameplates-holypower3-off','nameplates-holypower3-on','nameplates-holypower4-off','nameplates-holypower4-on','nameplates-playerhealth-background','nameplates-InterruptShield','nameplate-WarlockShard-Off','nameplate-WarlockShard-On','nameplate-WarlockShard-Glow','ClassOverlay-ComboPoint-Off','Insanity-DrippyPurple1','Insanity-DrippyPurple2','Insanity-PortraitOverlay','Insanity-PurpleBurstOn','Insanity-ShadowBurstOn','Insanity-Tentacles','Insanity-TopPurpleShadow','options-notch','Insanity-Spark','tradeskills-star-off','tradeskills-star','tradeskill-background-recipe','tradeskill-background-recipe-unlearned','loottoast-itemborder-heirloom','ComboPoints-AllPointsBG','ComboPoints-PointBg','ComboPoints-ComboPointDash','ComboPoints-ComboPointDash-Bg','ComboPoints-ComboPoint','ComboPoints-FX-Circle','ComboPoints-FX-Dash','ComboPoints-FX-Star','obliterumforge-background','obliterumforge-slotted-corners-glow','obliterumforge-slotted-corners','ChallengeMode-AffixRing-Lg','ChallengeMode-AffixRing-Sm','ChallengeMode-DungeonIconFrame','ChallengeMode-KeystoneFrame','ChallengeMode-KeystoneSlotBG','ChallengeMode-KeystoneSlotFrame','ChallengeMode-KeystoneSlotFrameGlow','ChallengeMode-MainTabBg','ChallengeMode-ThinDivider','_DemonHunter-DemonicPainBar','GlyphIcon-Spellbook','ChallengeMode-Runes-GlowLarge','ChallengeMode-Runes-Large','ChallengeMode-Runes-LineGlow','BossBanner-PortraitBorder','ChallengeMode-SoftYellowGlow','ChallengeMode-SpikeyStar','ChallengeMode-Timer','ChallengeMode-TimerBG','ChallengeMode-TimerFill','ChallengeMode-WhiteSpikeyGlow','ChallengeMode-Runes-BackgroundCoverGlow','ChallengeMode-Runes-GlowBurstLarge','ChallengeMode-Runes-GlowSmall','ChallengeMode-RuneBG','ChallengeMode-Runes-BackgroundBurst','ChallengeMode-Runes-BL-Glow','ChallengeMode-Runes-BR-Glow','ChallengeMode-Runes-InnerCircleGlow','ChallengeMode-Runes-L-Glow','ChallengeMode-Runes-R-Glow','ChallengeMode-Runes-Small','ChallengeMode-Runes-T-Glow','ChallengeMode-Runes-CircleGlow','recipetoast-bg','recipetoast-icon-star','transmog-wardrobe-border-unusable','worldquest-icon-clock','worldquest-questmarker-dragon-glow','worldquest-questmarker-dragon','worldquest-questmarker-epic-down','worldquest-questmarker-epic','worldquest-questmarker-glow','worldquest-questmarker-questbang','worldquest-tracker-checkmark','worldquest-tracker-questmarker-gray','worldquest-tracker-questmarker','worldquest-tracker','ChallengeMode-Runes-SmallCircleGlow','worldquest-questmarker-questionmark','ChallengeMode-Runes-Shockwave','ChallengeMode-Chest','worldquest-icon-pvp-ffa','worldquest-tracker-ring-selected','worldquest-tracker-ring','ChallengeMode-icon-chest','ChallengeMode-icon-redline','ChallengeMode-TimerBG-back','LegionMissionIcon-ZoneSupportAlliance-Map','orderhalltalents-background-mage','orderhalltalents-background-deathknight','orderhalltalents-background-demonhunter','orderhalltalents-background-druid','orderhalltalents-background-hunter','orderhalltalents-background-monk','orderhalltalents-background-paladin','orderhalltalents-background-priest','orderhalltalents-background-rogue','orderhalltalents-background-shaman','orderhalltalents-background-warlock','orderhalltalents-background-warrior','orderhalltalents-choice-background','orderhalltalents-spellborder-green','orderhalltalents-spellborder-yellow','orderhalltalents-spellborder','LegionMissionIcon-ZoneSupportAlliance-MapBadge','LegionMissionIcon-ZoneSupportHorde-Map','LegionMissionIcon-ZoneSupportHorde-MapBadge','LegionMissionIcon-ZoneSupportAlliance-Mission','LegionMissionIcon-ZoneSupportHorde-Mission','orderhalltalents-timer-bg','legionmission-map-orderhall-deathknight','legionmission-map-orderhall-demonhunter','legionmission-map-orderhall-druid','legionmission-map-orderhall-glow','legionmission-map-orderhall-hunter','legionmission-map-orderhall-mage','legionmission-map-orderhall-monk','legionmission-map-orderhall-paladin','legionmission-map-orderhall-priest','legionmission-map-orderhall-rogue','legionmission-map-orderhall-shaman','legionmission-map-orderhall-warlock','legionmission-map-orderhall-warrior','legionmission-map-orderhall-textglow','worldquest-icon-alchemy','worldquest-icon-archaeology','worldquest-icon-blacksmithing','worldquest-icon-cooking','worldquest-icon-enchanting','worldquest-icon-engineering','worldquest-icon-firstaid','worldquest-icon-fishing','worldquest-icon-herbalism','worldquest-icon-inscription','worldquest-icon-jewelcrafting','worldquest-icon-leatherworking','worldquest-icon-mining','worldquest-icon-skinning','worldquest-icon-tailoring','worldquest-icon-petbattle','DemonInvasion5','book-bg','book-line','_orderhall-commandbar-bg','worldquest-icon-boss','transmog-icon-hidden','orderhalltalents-choice-arrow-large','orderhalltalents-choice-background-on','LegendaryToast-particles3','LegendaryToast-particles2','LegendaryToast-background','LegendaryToast-ring1','LegendaryToast-particles1','tradeskills-iconborder','LegendaryToast-OrangeStarglow','loottoast-itemborder-artifact','adventureguide-icon-whatsnew','adventureguide-microbutton-alert','transmog-frame-blackcover','transmog-frame-highlighted','transmog-background-race-bloodelf','transmog-background-race-human','transmog-background-race-draenei','transmog-background-race-dwarf','transmog-background-race-gnome','transmog-background-race-goblin','transmog-background-race-nightelf','transmog-background-race-orc','transmog-background-race-pandaren','transmog-background-race-tauren','transmog-background-race-troll','transmog-background-race-undead','transmog-background-race-worgen','AdventureMap-combatally-clouds','AdventureMap-combatally-empty','AdventureMap-combatally-ring','AdventureMap-textlabelglow','legionmission-EncounterAbilityBorder-Lg','legionmission-EncounterAbilityBorder','worldquest-followerabilityframe','worldquest-questmarker-abilityhighlight','transmog-frame-highlighted-small','nameplates-bar-background-white','_honorsystem-bar-fill-rested','honorsystem-bar-frame-exhaustiontick-highlight','honorsystem-bar-frame-exhaustiontick','legionmission-complete-background-deathknight','legionmission-complete-background-demonhunter','legionmission-complete-background-druid','legionmission-complete-background-hunter','legionmission-complete-background-mage','legionmission-complete-background-monk','legionmission-complete-background-paladin','legionmission-complete-background-priest','legionmission-complete-background-rogue','legionmission-complete-background-shaman','legionmission-complete-background-warlock','legionmission-complete-background-warrior','legionmission-landingpage-background-deathknight','legionmission-landingpage-background-demonhunter','legionmission-landingpage-background-druid','legionmission-landingpage-background-hunter','legionmission-landingpage-background-mage','legionmission-landingpage-background-monk','legionmission-landingpage-background-paladin','legionmission-landingpage-background-priest','legionmission-landingpage-background-rogue','legionmission-landingpage-background-shaman','legionmission-landingpage-background-warlock','legionmission-landingpage-background-warrior','legionmission-landingbutton-deathknight-down','legionmission-landingbutton-deathknight-up','legionmission-landingbutton-demonhunter-down','legionmission-landingbutton-demonhunter-up','legionmission-landingbutton-druid-down','legionmission-landingbutton-druid-up','legionmission-landingbutton-hunter-down','legionmission-landingbutton-hunter-up','legionmission-landingbutton-mage-down','legionmission-landingbutton-mage-up','legionmission-landingbutton-monk-down','legionmission-landingbutton-monk-up','legionmission-landingbutton-paladin-down','legionmission-landingbutton-paladin-up','legionmission-landingbutton-priest-down','legionmission-landingbutton-priest-up','legionmission-landingbutton-rogue-down','legionmission-landingbutton-rogue-up','legionmission-landingbutton-shaman-down','legionmission-landingbutton-shaman-up','legionmission-landingbutton-warlock-down','legionmission-landingbutton-warlock-up','legionmission-landingbutton-warrior-down','legionmission-landingbutton-warrior-up','transmog-wardrobe-border-current','transmog-wardrobe-border-selected-wisp','transmog-wardrobe-border-current-transmogged','glueannouncementpopup-arrow','glueannouncementpopup-background','glueannouncementpopup-icon-info','glueannouncementpopup-inset','loottab-set-itemborder-green','loottab-set-itemborder-purple','loottab-set-itemborder-blue','poi-alliance','poi-horde','GarrisonTroops-Health-Consume','GarrisonTroops-Health','BonusChest-BonusTextGlow','GarrMission_ClassIcon-DeathKnight-Blood','GarrMission_ClassIcon-DeathKnight-Frost','GarrMission_ClassIcon-DeathKnight-Unholy','GarrMission_ClassIcon-DemonHunter-Havoc','GarrMission_ClassIcon-DemonHunter-Vengeance','GarrMission_ClassIcon-Druid-Balance','GarrMission_ClassIcon-Druid-Feral','GarrMission_ClassIcon-Druid-Guardian','GarrMission_ClassIcon-Druid-Restoration','GarrMission_ClassIcon-Hunter-BeastMastery','GarrMission_ClassIcon-Hunter-Marksmanship','GarrMission_ClassIcon-Hunter-Survival','GarrMission_ClassIcon-Mage-Arcane','GarrMission_ClassIcon-Mage-Fire','GarrMission_ClassIcon-Mage-Frost','GarrMission_ClassIcon-Monk-Brewmaster','GarrMission_ClassIcon-Monk-Mistweaver','GarrMission_ClassIcon-Monk-Windwalker','GarrMission_ClassIcon-Paladin-Holy','GarrMission_ClassIcon-Paladin-Protection','GarrMission_ClassIcon-Paladin-Retribution','GarrMission_ClassIcon-Priest-Discipline','GarrMission_ClassIcon-Priest-Holy','GarrMission_ClassIcon-Priest-Shadow','GarrMission_ClassIcon-Rogue-Assassination','GarrMission_ClassIcon-Rogue-Outlaw','GarrMission_ClassIcon-Rogue-Subtlety','GarrMission_ClassIcon-Shaman-Elemental','GarrMission_ClassIcon-Shaman-Enhancement','GarrMission_ClassIcon-Shaman-Restoration','GarrMission_ClassIcon-Warlock-Affliction','GarrMission_ClassIcon-Warlock-Demonology','GarrMission_ClassIcon-Warlock-Destruction','GarrMission_ClassIcon-Warrior-Arms','GarrMission_ClassIcon-Warrior-Fury','GarrMission_ClassIcon-Warrior-Protection','legionmission-background-combatally','_GarrMissionLocation-Legion-Mid','_GarrMissionLocation-Highmountain-Mid','_GarrMissionLocation-Dalaran-Mid','_GarrMissionLocation-Azsuna-Mid','_GarrMissionLocation-Stormheim-Mid','_GarrMissionLocation-Suramar-Mid','_GarrMissionLocation-Valsharah-Mid','legionmission-hearts-background','GarrMissionLocation-Azsuna-List','GarrMissionLocation-Dalaran-List','GarrMissionLocation-Highmountain-List','GarrMissionLocation-Legion-List','GarrMissionLocation-Stormheim-List','GarrMissionLocation-Suramar-List','GarrMissionLocation-Valsharah-List','poi-workorders','groupfinder-background-raids-legion','groupfinder-button-raids-legion','orderhall-commandbar-iconmask','GarrMission-NeutralChest','worldquest-tracker-lock','ClassTrial-End-Frame','ClassTrial-Hunter-Ring','ClassTrial-Priest-Ring','ClassTrial-DeathKnight-Ring','ClassTrial-Warrior-Ring','ClassTrial-Paladin-Ring','ClassTrial-Warlock-Ring','ClassTrial-Druid-Ring','ClassTrial-Monk-Ring','ClassTrial-Mage-Ring','ClassTrial-Rogue-Ring','Legion-boostpopup-exit-frame','transmog-wardrobe-border-selected-smoke','legionmission-icon-currency','UI-CharacterCreate-MetalFrame-Horizontal','UI-CharacterCreate-MetalFrame-Vertical','ClassTrial-Timer-Mid','ClassTrial-Timer-RightCorner','ClassTrial-Timer','UI-CharacterCreate-LargeButton-Blue-Highlight','UI-CharacterCreate-LargeButton-Yellow-Highlight','UI-CharacterCreate-LargeButton','UI-CharacterCreate-Metal-Finery-Corner','UI-CharacterCreate-Metal-Small-Finery','UI-CharacterCreate-PadLock','UI-Character-Info-Paladin-BG','UI-Character-Info-Priest-BG','UI-Character-Info-Warlock-BG','UI-Character-Info-Line-Bounce','UI-Character-Info-Shaman-BG','UI-Character-Info-ItemLevel-Bounce','UI-Character-Info-Warrior-BG','UI-Character-Info-Title','UI-Character-Info-Mage-BG','UI-Character-Info-Rogue-BG','UI-Character-Info-Monk-BG','UI-Character-Info-DeathKnight-BG','UI-Character-Info-DemonHunter-BG','UI-Character-Info-Druid-BG','UI-Character-Info-Hunter-BG','Relic-SlotBG-Glass','loottab-set-itemborder-artifact','loottab-set-itemborder-white','loottab-set-itemborder-orange','Artifacts-BG-Shadow','worldquest-questmarker-rare-down','worldquest-questmarker-rare','poi-majorcity','poi-town','pvpqueue-bg-alliance','pvpqueue-bg-horde','honorsystem-prestige-smallwreath','orderhall-commandbar-mapbutton-down','orderhall-commandbar-mapbutton-up','worldquest-tracker-bg-noemissary','Quest-Alliance-WaxSeal','Quest-Horde-WaxSeal','QuestBG-Alliance','QuestBG-Horde','insetshadow','ChallengeMode-guild-background','ChallengeMode-RankLineDivider','_Talent-green-glow','legionmission-lock','honorsystem-prestige-rewardline','orderhalltalents-done-checkmark','orderhalltalents-done-glow','map-icon-ignored-blueexclaimation','map-icon-ignored-bluequestion','map-icon-deathknightclasshall','Dungeon','Raid','map-icon-SuramarDoor.tga','ClassTrial-Shaman-Ring','Mobile-BonusIcon','Mobile-CombatBadgeIcon','Mobile-CombatIcon','Mobile-LegendaryQuestIcon','Mobile-QuestIcon','Mobile-TreasureIcon','ClassHall_StoneFrame-BackgroundTile','ClassHall_InfoBoxMission-BackgroundTile','StoneFrameCorner-TopLeft','ClassHall-Circle-Mage','_StoneFrameTile-Bottom','_StoneFrameTile-Top','ClassHall-Circle-DeathKnight','ClassHall-Circle-Hunter','ClassHall-Circle-Warrior','ClassHall-Circle-Druid','ClassHall-Circle-Warlock','ClassHall-Circle-Shaman','ClassHall-Circle-Rogue','ClassHall-Circle-Monk','ClassHall-Circle-DemonHunter','ClassHall-Circle-Priest','ClassHall-Circle-Paladin','!StoneFrameTile-Left','ClassHall_ParchmentHeaderSelect-End','_ClassHall_ParchmentHeaderSelect-Mid','_ClassHall_ParchmentHeader-Mid','ClassHall_ParchmentHeader-End','Mobile-CombatIcon-Desaturated','Mobile-BonusIcon-Desaturated','Mobile-TreasureIcon-Desaturated','Mobile-QuestIcon-Desaturated','Mobile-LegendaryQuestIcon-Desaturated','ClassHall-TreasureIcon-Desaturated','ClassHall-LegendaryIcon-Desaturated','ClassHall-QuestIcon-Desaturated','ClassHall-BonusIcon-Desaturated','ClassHall-CombatIcon-Desaturated','worldquest-icon-dungeon','honorsystem-bar-lock','Mobile-Alchemy','Mobile-Archeology','Mobile-Blacksmithing','Mobile-Cooking','Mobile-Enchanting','Mobile-Enginnering','Mobile-FirstAid','Mobile-Fishing','Mobile-Herbalism','Mobile-Inscription','Mobile-Jewelcrafting','Mobile-Leatherworking','Mobile-MechanicIcon-Curse','Mobile-MechanicIcon-Disorienting','Mobile-MechanicIcon-Lethal','Mobile-MechanicIcon-Slowing','Mobile-Mining','Mobile-Pets','Mobile-Skinning','Mobile-Tailoring','Taxi_Frame_Gray','Taxi_Frame_Green','UI-Taxi-Icon-Nub','!UI-Taxi-Line','_UI-Taxi-Line-horizontal','Mobile-MechanicIcon-Powerful','GarrMission_ClassIcon-DemonHunter-Outcast','splash-703-botleft','splash-703-right','splash-703-topleft','splash-704-botleft','splash-704-right','splash-704-topleft','splash-705-botleft','splash-705-right','splash-705-topleft','inspect-talent-selected','loottab-background','loottab-set-background','AutoQuest-badgeborder','ClassHall_Follower-EquipmentBG','ClassHall_Follower-EquipmentFrame','ClassHall_InfoBoxMission-Corner','_ClassHall_InfoBoxMission-Top','!ClassHall_InfoBoxMission-Left','ClassHall_ParchmentHeader-End-2','ClassHall_ParchmentHeaderSelect-End-2','ClassHall-CombatAlly','nameplates-icon-elite-gold','nameplates-icon-elite-silver','StreamCinematic-Legion-Down','StreamCinematic-Legion-Up','GarrMission_ClassIcon-Karazhan','WhiteCircle-RaidBlips','WhiteDotCircle-RaidBlips','friendslist-categorybutton-arrow-down','friendslist-categorybutton-arrow-right','friendslist-categorybutton','Taxi_Frame_Yellow','pvprated-loottoast-bg-alliance','pvprated-loottoast-bg-horde','128-RedButton-Highlight','128-RedButton-LeftCorner-Disabled','128-RedButton-LeftCorner-Pressed','128-RedButton-LeftCorner','128-RedButton-RightCorner-Disabled','128-RedButton-RightCorner-Pressed','128-RedButton-RightCorner','_128-RedButton-Tile-Disabled','_128-RedButton-Tile-Pressed','_128-RedButton-Tile','bags-greenarrow','socialqueuing-icon-clock','socialqueuing-icon-eye','socialqueuing-icon-group','quickjoin-button-friendslist-down','quickjoin-button-friendslist-up','quickjoin-button-quickjoin-down','quickjoin-button-quickjoin-up','quickjoin-toast-background','quickjoin-toast-lines','macropopup-bottomleft','macropopup-bottomright','macropopup-topleft','macropopup-topright','_macropopup-bottom','_macropopup-top','!macropopup-left','!macropopup-right','macropopup-scrollbar-bottom','macropopup-scrollbar-top','!macropopup-scrollbar-middle','socialqueuing-row-highlight','socialqueuing-row-select','splash-710-botleft','splash-710-right','splash-710-topleft','groupfinder-icon-class-demonhunter','AncientMana','quickjoin-button-group-down','quickjoin-button-group-up','socialqueuing-friendlist-summonbutton-disabled','socialqueuing-friendlist-summonbutton-down','socialqueuing-friendlist-summonbutton-up','worldquest-icon-burninglegion','worldquest-icon-raid','GarrMission-AbilityHighlight-Error','transmog-set-border-collected','transmog-set-border-current-transmogged','transmog-set-border-current','transmog-set-border-highlighted','transmog-set-border-selected','transmog-set-border-unusable','transmog-set-iconrow-background','ParagonReputation_Bag','ParagonReputation_Checkmark','ParagonReputation_Glow','Legionfall_Background','Legionfall_Banner','Legionfall_BarBackground','Legionfall_BarFrame','Legionfall_BarSpark','Legionfall_BuildingInfoBackground','Legionfall_GrayFrame','Legionfall_Padlock','_Legionfall_BarFill_Active','_Legionfall_BarFill_UnderAttack','_Legionfall_BarFill_UnderConstruction','legionmission-portraitring-epicplus','legionmission-portraitring_levelborder_epicplus','Legionfall_CommandCenter_Completed','Legionfall_CommandCenter_Destroyed','Legionfall_CommandCenter_UnderAttack','Legionfall_CommandCenter_UnderConstruction','Legionfall_MageTower_Completed','Legionfall_MageTower_Destroyed','Legionfall_MageTower_UnderAttack','Legionfall_MageTower_UnderConstruction','Legionfall_NetherDisruptor_Completed','Legionfall_NetherDisruptor_Destroyed','Legionfall_NetherDisruptor_UnderAttack','Legionfall_NetherDisruptor_UnderConstruction','Artifacts-DeathKnightFrost-BG-Rune','Artifacts-ItemIconBorder','Artifacts-PerkRing-Final','Artifacts-DeathKnightFrost-FinalIcon','Legionfall_GrayBanner','Legionfall_GreenFrame','Legionfall_RedFrame','Legionfall_YellowFrame','Legionfall_ExitFrame','equipmentmanager-spec-border','Artifacts-DemonHunter-BG-rune','Artifacts-Druid-BG-rune','Artifacts-Hunter-BG-rune','Artifacts-MageArcane-BG-rune','Artifacts-Monk-BG-rune','Artifacts-Paladin-BG-rune','Artifacts-Priest-BG-rune','Artifacts-PriestShadow-BG-rune','Artifacts-Rogue-BG-rune','Artifacts-Shaman-BG-rune','Artifacts-Warlock-BG-rune','Artifacts-Warrior-BG-rune','Artifacts-PerkRing-Final-Shine','Talent-Selection-Legendary','Artifacts-DemonHunter-FinalIcon','Artifacts-Druid-FinalIcon','Artifacts-Hunter-FinalIcon','Artifacts-MageArcane-FinalIcon','Artifacts-Monk-FinalIcon','Artifacts-Paladin-FinalIcon','Artifacts-Priest-FinalIcon','Artifacts-PriestShadow-FinalIcon','Artifacts-Rogue-FinalIcon','Artifacts-Shaman-FinalIcon','Artifacts-Warlock-FinalIcon','Artifacts-Warrior-FinalIcon','Artifacts-CrestRune-Gold','LegionfallMapBanner','QuestBG-Legionfall','Quest-Legionfall-WaxSeal','poi-transmogrifier','Artifacts-Anim-Sparks','worldquest-emissary-ring','worldquest-emissary-tracker-checkmark','splash-720-botleft','splash-720-right','splash-720-topleft','DemonShip','Artifacts-Anim-Orb','Artifacts-Anim-Glowies','Legionfall_BarFrame-Glow','transmog-set-model-cutoff-fade','MountToast-Background','PetToast-background','honorsystem-icon-enlistmentbonus','Artifacts-Anim-CrackedGround','Legionfall_GrayFrame_Buffs','DemonShip_East','DK-Blood-Rune-CDFill','DK-BloodUnholy-Rune-CDSpark','DK-Frost-Rune-CDFill','DK-Frost-Rune-CDSpark','DK-Unholy-Rune-CDFill','Warlock-Bar-EmptyShards','Warlock-EmptyShard','Warlock-FillShard','Warlock-ReadyShard-Glow','Warlock-ReadyShard','Warlock-Shard-Spark','CastBar','CurrentPlayer-Glow','DarkTutorialFrameBackground','DeathIcon','HealerBadge','HealingDampening','InterruptOverlay','RedCCIconGlow','ScoreDivider','ScoreTeam','TankBadge','TargetCrosshairs','tournamentarena-frame-bg-corner-blue','tournamentarena-frame-bg-corner-red','UI-Feedback-Border','UnitFrame-NoMana','UnitFrame-NoTrinket','UnitFrame','UnitFrame_CCOverlay-NoMana','UnitFrame_CCOverlay','UnitFrame_DeathOverlay-NoMana','UnitFrame_DeathOverlay','UnitFrame_FocusFireOverlay-NoMana','UnitFrame_FocusFireOverlay','UnitFrame_CurrentPlayer_CCOverlay','UnitFrame_CurrentPlayer_DeathOverlay','UnitFrame_CurrentPlayer-NoMana','UnitFrame_CurrentPlayer-NoTrinket','UnitFrame_CurrentPlayer','UnitFrame_CurrentPlayerGlow','UnitFrame_CurrentPlayer_FocusFireOverlay-NoMana','UnitFrame_CurrentPlayer_FocusFireOverlay','UnitFrame_CurrentPlayer_CCOverlay-NoMana','UnitFrame_CurrentPlayer_DeathOverlay-NoMana','UnitFrame_CurrentPlayerGlow-NoMana','DK-Blood-Rune-Ready','DK-Rune-CD','DK-Rune-Glow','DK-Unholy-Rune-Ready','DK-Frost-Rune-Ready','raceicon-bloodelf-male','raceicon-draenei-female','raceicon-draenei-male','raceicon-dwarf-female','raceicon-dwarf-male','raceicon-gnome-female','raceicon-gnome-male','raceicon-goblin-male','raceicon-human-female','raceicon-human-male','raceicon-nightelf-female','raceicon-nightelf-male','raceicon-orc-female','raceicon-orc-male','raceicon-pandaren-female','raceicon-pandaren-male','raceicon-tauren-female','raceicon-tauren-male','raceicon-troll-female','raceicon-troll-male','raceicon-undead-female','raceicon-undead-male','raceicon-worgen-female','raceicon-worgen-male','poi-graveyard-neutral','poi-door-arrow-down','poi-door-arrow-up','poi-door','tournamentarena-winnerline','UI-MoneyFrame-Large','talenttree-chromie-background','worldstate-capturebar-blue','worldstate-capturebar-gray','worldstate-capturebar-green','worldstate-capturebar-purple','worldstate-capturebar-red','worldstate-capturebar-yellow','splash-725-botleft','splash-725-right','splash-725-topleft','TaxiNode_Alliance','TaxiNode_Horde','TaxiNode_Neutral','FlightMaster_Argus-Taxi_Frame_Gray','FlightMaster_Argus-Taxi_Frame_Yellow','Darklink-ball','Darklink-glow','Darklink','Darkstone1','Darkstone2','Darkstone3','Darkstone4','Darkstone5','Darkstone6','Darkstone7','Darktrait-border','Lightlink-ball','Lightlink-glow','Lightlink','Lightstone1','Lightstone2','Lightstone3','Lightstone4','Lightstone5','Lightstone6','Lightstone7','Lighttrait-border','simplecheckout-close-hover-1x','simplecheckout-close-hover-2x','simplecheckout-close-normal-1x','simplecheckout-close-normal-2x','simplecheckout-close-pressed-1x','simplecheckout-close-pressed-2x','Darktrait-Glow','Lighttrait-glow','Mixedtrait-border','Relic-Rankframe-glow','Relic-Rankframe','Relic-Rankselected-circle','Relic-Rankselected-UpperGlow','Relicforge-background','Relicforge-Bottomframe','Relicforge-Bottomleft-corner','Relicforge-Bottomright-corner','Relicforge-Leftframe','Relicforge-Relicsbackground','Relicforge-Rightframe','Relicforge-Slot-background','Relicforge-Slot-frame','Relicforge-Topdecoration','Relicforge-Topframe','Relicforge-Topleft-corner','Relicforge-Topright-corner','Darklink-active','Disablelink','Lightlink-active','Darktrait-backglow','Lighttrait-backglow','dressingroom-background-deathknight','dressingroom-background-demonhunter','dressingroom-background-druid','dressingroom-background-hunter','dressingroom-background-mage','dressingroom-background-monk','dressingroom-background-paladin','dressingroom-background-priest','dressingroom-background-rogue','dressingroom-background-shaman','dressingroom-background-warlock','dressingroom-background-warrior','Darklink-blackinside','Lightlink-blackinside','worldstate-capturebar-frame-factions','worldstate-capturebar-frame','worldstate-capturebar-spark-green','worldstate-capturebar-spark-yellow','worldstate-capturebar-glow','worldstate-capturebar-arrow','worldstate-capturebar-frame-separater','poi-rift1','poi-rift2','countdown-swords','countdown-swords-glow','AlliedRace-TraitsBorder','AlliedRace-UnlockingFrame-Background','AlliedRace-UnlockingFrame-BottomButtonsMouseOverGlow','AlliedRace-UnlockingFrame-BottomButtonsSelectionGlow','AlliedRace-UnlockingFrame-Female','AlliedRace-UnlockingFrame-GenderMouseOverGlow','AlliedRace-UnlockingFrame-GenderSelectionGlow','AlliedRace-UnlockingFrame-LeftRotation','AlliedRace-UnlockingFrame-Male','AlliedRace-UnlockingFrame-RightRotation','AlliedRace-UnlockingFrame-ZoomIn','AlliedRace-UnlockingFrame-ZoomOut','AlliedRace-UnlockingFrame-ModelBackground-Highmountain','AlliedRace-UnlockingFrame-ModelBackground-Nightborne','AlliedRace-UnlockingFrame-ModelBackground-Voidelf','AlliedRace-Crest-Highmountain','AlliedRace-Crest-Lightforge','AlliedRace-Crest-Nightborne','AlliedRace-Crest-Voidelf','FlightMaster_VindicaarArgus-Taxi_Frame_Gray','FlightMaster_VindicaarArgus-Taxi_Frame_Green','FlightMaster_VindicaarArgus-Taxi_Frame_Yellow','FlightMaster_VindicaarMacAree-Taxi_Frame_Gray','FlightMaster_VindicaarMacAree-Taxi_Frame_Green','FlightMaster_VindicaarMacAree-Taxi_Frame_Yellow','FlightMaster_VindicaarStygianWake-Taxi_Frame_Gray','FlightMaster_VindicaarStygianWake-Taxi_Frame_Green','FlightMaster_VindicaarStygianWake-Taxi_Frame_Yellow','Relic-Rankdisable-DarkGlow','ArtifactsFX-PointSideBurstLeft-Purple','ArtifactsFX-PointSideBurstRight-Purple','ArtifactsFX-SpinningGlowys-Purple','ArtifactsFX-StarBurst-Purple','ArtifactsFX-Whirls-Purple','ArtifactsFX-YellowRing-Purple','AdventureMap_TileBg_Parchment','_GarrMissionLocation-Argus-Mid','GarrMissionLocation-Argus-List','Darktrait-border-selected','Lighttrait-border-selected','Neutralstone1','Neutralstone2','Neutralstone3','Neutralstone4','Neutralstone5','Neutralstone6','Neutralstone7','Neutraltrait-border-selected','Neutraltrait-border','poi-door-down','poi-door-left','poi-door-right','poi-door-up','QuestBG-TheHandofFate','splash-730-botleft','splash-730-right','splash-730-topleft','Neutraltrait-backglow','Neutraltrait-Glow','AftLevelup-NeutralStarBurst','AftLevelup-PurpleStarBurst','Artifacts-PerkRing-NeutralGlow','Artifacts-PerkRing-PurpleGlow','ArtifactsFX-Whirls-Neutral','ArtifactsFX-YellowRing-Neutral','Rune-01-neutral','Rune-01-purple','Rune-02-neutral','Rune-02-purple','Rune-03-neutral','Rune-03-purple','Rune-04-neutral','Rune-04-purple','Rune-05-neutral','Rune-05-purple','Rune-06-neutral','Rune-06-purple','GarrMission_ClassIcon-Voidscarred','GarrMission_ClassIcon-ArgussianReach','GarrMission_ClassIcon-ArmyoftheLight','AntoranWastes_Highlight','Relicforge-Relicsbackground-Previewtraits','Relicforge-Slot-frame-Active','Krokuun_Highlight','MacAree_Highlight','FlightMaster_Argus-Taxi_Frame_Green','BrokenIslesHightlight','hud-MainMenuBar-arrowdown-disabled','hud-MainMenuBar-arrowdown-down','hud-MainMenuBar-arrowdown-highlight','hud-MainMenuBar-arrowdown-up','hud-MainMenuBar-arrowup-disabled','hud-MainMenuBar-arrowup-down','hud-MainMenuBar-arrowup-highlight','hud-MainMenuBar-arrowup-up','hud-MainMenuBar-gryphon','AlliedRace-UnlockingFrame-ModelFrame','AlliedRace-UnlockingFrame-RaceBanner','AlliedRace-UnlockingFrame-ModelBackground-Lightforge','shop-card-half-brownbox','shop-card-half-brownboxlegionbundle','shop-card-half-legion','shop-card-half-legiondeluxe','shop-card-full-legiondeluxe','hud-MainMenuBar-experiencebar-large-double','hud-MainMenuBar-experiencebar-large-single','hud-MainMenuBar-experiencebar-small-double','hud-MainMenuBar-experiencebar-small-single','hud-MainMenuBar-large','hud-MainMenuBar-small','shop-card-half-hover','hud-microbutton-LFG-Up','hud-microbutton-Achievement-Disabled','hud-microbutton-LFG-Down','hud-microbutton-BStore-Down','hud-microbutton-Socials-Disabled','hud-microbutton-MainMenu-Up','hud-microbutton-Quest-Disabled','hud-microbutton-Achievement-Down','hud-microbutton-BStore-Up','hud-microbutton-Quest-Up','hud-microbutton-Quest-Down','hud-microbutton-Spellbook-Down','hud-microbutton-EJ-Down','hud-microbutton-Socials-Up','hud-microbutton-LFG-Disabled','hud-microbutton-StreamDL-Up','hud-microbutton-Character-Down','hud-microbutton-StreamDL-Down','hud-microbutton-MainMenu-Down','hud-microbutton-MainMenu-Disabled','hud-microbutton-Talents-Disabled','hud-microbutton-BStore-Disabled','hud-microbutton-Mounts-Disabled','hud-microbutton-Mounts-Up','hud-microbutton-Character-Up','hud-microbutton-Socials-Down','hud-microbutton-Spellbook-Up','hud-microbutton-Talents-Down','hud-microbutton-Mounts-Down','hud-microbutton-EJ-Disabled','hud-microbutton-EJ-Up','hud-microbutton-Spellbook-Disabled','hud-microbutton-Talents-Up','hud-MicroBagBar','hud-microbutton-Achievement-Up','AlliedRaces-AllianceHordeBanner','loottoast-itemborder-gold','hud-microbutton-highlight','shop-card-bundle-hover','shop-card-bundle-legion','shop-card-bundle-reaver-argi','shop-card-bundle','shop-card-bundle-selected','raceicon-voidelf-male','raceicon-goblin-female','raceicon-nightborne-male','raceicon-lightforged-male','raceicon-nightborne-female','raceicon-highmountain-female','raceicon-voidelf-female','raceicon-lightforged-female','raceicon-bloodelf-female','raceicon-highmountain-male','bags-icon-addslots','shop-card-bundle-alteracpup-feydragon','shop-card-bundle-starseekers','bags-static','category-icon-ring','vas-receipt-icon-characterborder','warboard-header-alliance','warboard-header-horde','warboard-parchment-answerborder','warboard-parchment','warboard-title-alliance-left','warboard-title-alliance-right','warboard-title-horde-left','warboard-title-horde-right','warboard-title-neutral-left','warboard-title-neutral-right','_warboard-title-alliance-middle','_warboard-title-horde-middle','_warboard-title-neutral-middle','warboard-background','warboard-zone-classic-Ashenvale','warboard-zone-classic-Azshara','warboard-zone-classic-AzuremystIsle','warboard-zone-classic-BloodmystIsle','warboard-zone-classic-Darkshore','warboard-zone-classic-DunMorogh','warboard-zone-classic-Durotar','warboard-zone-classic-ElwynnForest','warboard-zone-classic-EversongWoods','warboard-zone-classic-Ghostlands','warboard-zone-classic-Gilneas','warboard-zone-classic-HillsbradFoothills','warboard-zone-classic-LochModan','warboard-zone-classic-LostIsles','warboard-zone-classic-Mulgore','warboard-zone-classic-NorthernBarrens','warboard-zone-classic-RedridgeMountains','warboard-zone-classic-SilverpineForest','warboard-zone-classic-SouthernBarrens','warboard-zone-classic-Teldrassil','warboard-zone-classic-TirisfalGlades','warboard-zone-classic-WanderingIsle','warboard-zone-classic-Westfall','warboard-zone-classic-ArathiHighlands','warboard-zone-classic-Badlands','warboard-zone-classic-BlastedLands','warboard-zone-classic-BurningSteppes','warboard-zone-classic-CapeofStranglethorn','warboard-zone-classic-Desolace','warboard-zone-classic-Duskwood','warboard-zone-classic-DustwallowMarsh','warboard-zone-classic-EasternPlaguelands','warboard-zone-classic-Felwood','warboard-zone-classic-Feralas','warboard-zone-classic-Hinterlands','warboard-zone-classic-NorthernStranglethorn','warboard-zone-classic-SearingGorge','warboard-zone-classic-Silithus','warboard-zone-classic-StonetalonMountains','warboard-zone-classic-SwampofSorrows','warboard-zone-classic-Tanaris','warboard-zone-classic-ThousandNeedles','warboard-zone-classic-UngoroCrater','warboard-zone-classic-WesternPlaguelands','warboard-zone-classic-Wetlands','warboard-zone-classic-Winterspring','warboard-zone-bc-BladesEdgeMountains','warboard-zone-bc-HellfirePeninsula','warboard-zone-bc-IsleofQuelDanas','warboard-zone-bc-Nagrand','warboard-zone-bc-Netherstorm','warboard-zone-bc-ShadowmoonValley','warboard-zone-bc-TerokkarForest','warboard-zone-bc-Zangarmarsh','warboard-zone-wotlk-BoreanTundra','warboard-zone-wotlk-CrystalsongForest','warboard-zone-wotlk-Dalaran','warboard-zone-wotlk-Dragonblight','warboard-zone-wotlk-GrizzlyHills','warboard-zone-wotlk-HowlingFjord','warboard-zone-wotlk-Icecrown','warboard-zone-wotlk-SholazarBasin','warboard-zone-wotlk-StormPeaks','warboard-zone-wotlk-ZulDrak','warboard-zone-cata-TwilightHighlands','warboard-zone-cata-Deepholm','warboard-zone-cata-MountHyjal','warboard-zone-cata-ElementalBonds','warboard-zone-cata-Vashjir','warboard-zone-cata-MoltenFront','warboard-zone-cata-Uldum','warboard-zone-mop-DreadWastes','warboard-zone-mop-IsleofGiants','warboard-zone-mop-IsleoftheThunderKing','warboard-zone-mop-JadeForest','warboard-zone-mop-KrasarangWilds','warboard-zone-mop-KunLaiSummit','warboard-zone-mop-TimelessIsle','warboard-zone-mop-TownlongSteppes','warboard-zone-mop-ValeofEternalBlossoms','warboard-zone-mop-ValleyoftheFourWinds','warboard-zone-wod-FrostfireRidge','warboard-zone-wod-Gorgrond','warboard-zone-wod-Nagrand','warboard-zone-wod-ShadowmoonValley','warboard-zone-wod-SpiresofArak','warboard-zone-wod-Talador','warboard-zone-wod-TanaanJungle','warboard-zone-wod-TanaanJungleIntro','AzeriteReady','AzeriteSpawning','splash-735-botleft','splash-735-right','splash-735-topleft','shop-card-full-bfadeluxe','accountupgradebanner-bfa','shop-card-half-brownboxbfabundle','shop-card-half-bfadeluxe','shop-card-half-bfa','hud-microbutton-highlightalert','communities-icon-notification','communities-create-button-bnet-down','communities-create-button-bnet-up','communities-create-button-highlight','communities-create-button-wow-down','communities-create-button-wow-up','communities-create-avatar-border-hover','communities-create-avatar-border-selected','communities-ring-blue','communities-ring-gold','alliance_icon_and_flag-dynamicIcon','alliance_icon_and_flag-flash','alliance_icon_and_flag-icon','alliance_icon_horde_flag-dynamicIcon','alliance_icon_horde_flag-flash','alliance_icon_horde_flag-icon','alliance_tower-icon','coin-icon','combat_swords-dynamicIcon','combat_swords-flash','combat_swords-icon','dreadlord-icon','horde_icon_alliance_flag-dynamicIcon','horde_icon_alliance_flag-flash','horde_icon_alliance_flag-icon','horde_icon_and_flag-dynamicIcon','horde_icon_and_flag-flash','horde_icon_and_flag-icon','horde_tower-icon','neutral_tower-icon','placeholder-icon','pvp_ffa-icon','skull_bones-icon','sniper_shot-icon','communities-create-button-wow-alliance','communities-create-button-wow-horde','communities-icon-addgroupplus','communities-icon-lock','communities-icon-invitemail','communities-widebackground','macropopup-bottomright-nobuttons','macropopup-intersect-left','macropopup-intersect-right','macropopup-topleft2','macropopup-topright2','_macropopup-top2','ui-frame-neutral-cardparchment','ui-frame-neutral-cardparchmentwider','ui-frame-neutral-corner','ui-frame-neutral-exitbuttonborder','ui-frame-neutral-portrait','ui-frame-neutral-portraitdisable','ui-frame-neutral-portraitwider','ui-frame-neutral-portraitwiderdisable','ui-frame-neutral-ribbon','ui-frame-neutral-titleleft','ui-frame-neutral-titleright','_ui-frame-neutral-tilebottom','_ui-frame-neutral-tiletop','_ui-frame-neutral-titlemiddle','communities-chat-date-line-orange','communities-chat-date-line','communities-guildbanner-background','communities-guildbanner-border','communities-nav-button-green-normal','communities-nav-button-green-pressed','hud-microbutton-Guild-Banner','communities-icon-chat','communities-icon-addchannelplus','communities-create-button-bnet-highlight','communities-icon-redx','hud-microbutton-communities-icon-notification','ui-frame-diamondmetal-cornerbottomleft','ui-frame-diamondmetal-cornerbottomright','ui-frame-diamondmetal-cornertopleft','ui-frame-diamondmetal-cornertopright','_ui-frame-diamondmetal-edgebottom','_ui-frame-diamondmetal-edgetop','!ui-frame-diamondmetal-edgeleft','!ui-frame-diamondmetal-edgeright','chatframe-button-down','chatframe-button-highlight','chatframe-button-highlightalert','chatframe-button-icon-headset','chatframe-button-icon-mic-off','chatframe-button-icon-mic-on','chatframe-button-icon-mic-silenced-off','chatframe-button-icon-mic-silenced','chatframe-button-icon-speaker-off','chatframe-button-icon-speaker-on','chatframe-button-icon-speaker-silenced','chatframe-button-icon-voicechat','chatframe-button-up','chatframe-scrollbar-knob','voicechat-channellist-category-background','voicechat-channellist-category-highlight','voicechat-channellist-category-minus','voicechat-channellist-category-plus','voicechat-channellist-icon-headphone-off','voicechat-channellist-icon-headphone-on','voicechat-channellist-row-background','voicechat-channellist-row-background2','voicechat-channellist-row-highlight','voicechat-channellist-row-selected','voicechat-icon-headphone-off','voicechat-icon-headphone-on','voicechat-icon-headphone-pending','voicechat-icon-headphone-pendingdot-1','voicechat-icon-headphone-pendingdot-2','voicechat-icon-headphone-pendingdot-3','voicechat-icon-headphone-switch','voicechat-icon-loudnessbar-1','voicechat-icon-loudnessbar-2','voicechat-icon-loudnessbar-3','voicechat-icon-mic-mute','voicechat-icon-mic-mutesilenced','voicechat-icon-mic-silenced','voicechat-icon-mic','voicechat-icon-speaker-mute','voicechat-icon-speaker-mutesilenced','voicechat-icon-speaker-silenced','voicechat-icon-speaker','voicechat-icon-textchat-silenced','voicechat-portrait-drag','voicechat-portrait-ring','battlefieldminimap-border-bottom','battlefieldminimap-border-bottomleft','battlefieldminimap-border-bottomright','battlefieldminimap-border-left','battlefieldminimap-border-right','battlefieldminimap-border-top','battlefieldminimap-border-topleft','battlefieldminimap-border-topright','CGuy_AOI','CGuy_AOIAsset','CGuy_Arrow','CGuy_BottomArrow','CGuy_BottomArrowHighlight','CGuy_ConfigReplace','CGuy_Control','CGuy_ControlDefaults','CGuy_Export','CGuy_GafferPushed','CGuy_GafferUp','CGuy_Import','CGuy_New','CGuy_NewConfig','CGuy_Path','CGuy_Pause','CGuy_Play','CGuy_Point','CGuy_Record','CGuy_Rename','CGuy_Replace','CGuy_Stop','CGuy_TopArrow','CGuy_TopArrowHighlight','CGuy_AOIFollowsCamera','CGuy_FixedTimeStep','CGuy_ReorientToUnit','CGuy_AOIFollowsCameraActive','CGuy_CalcOrientation','CGuy_FixedTimeStepActive','CGuy_PlayActive','CGuy_RecordActive','CGuy_ReorientToUnitActive','CGuy_StopActive','bar-end','cast-bar-end','health-bar-end','health_end','metal-bar','portrait-frame-nameplate','portrait-frame','trinket-frame','_bar-mid','_cast-bar-mid','_health-bar-mid','cast-bar-fill-end','portrait-frame-color','_cast-bar-fill-mid','armor-fill-end','flag-1','flag-2','icon-healer','icon-tank','_armor-fill-mid','_health_mid','commentatorspellborder','frame-timer','healing-bg','score-team','_score-team-mid','portrait-frame-nameplate-scaledup','flag-outline','icon-death','icon-wow','metal-bar-small','portrait-frame-small','chatbubble-nineslice-center','chatbubble-nineslice-cornerbottomleft','chatbubble-nineslice-cornerbottomright','chatbubble-nineslice-cornertopleft','chatbubble-nineslice-cornertopright','_chatbubble-nineslice-edgebottom','_chatbubble-nineslice-edgetop','chatbubble-tail','!chatbubble-nineslice-edgeleft','!chatbubble-nineslice-edgeright','ui_editor_eye_icon','classic-burningcrusadetransition-choice-frame','classic-burningcrusadetransition-choice-line-current','classic-burningcrusadetransition-choice-line-other','classic-burningcrusadetransition-choice-logo-current-zhcn','classic-burningcrusadetransition-choice-logo-current-zhtw','classic-burningcrusadetransition-choice-logo-current','classic-burningcrusadetransition-choice-logo-other-zhcn','classic-burningcrusadetransition-choice-logo-other-zhtw','classic-burningcrusadetransition-choice-logo-other','ui-paidcharactercustomization-button-activatecharacter','cosmic-azeroth-highlight','cosmic-outland-highlight','cosmic-outland-highlight_resize','cosmic-azeroth-highlight_resize','ui-frame-diamondmetal-header-cornerleft-2x','ui-frame-diamondmetal-header-cornerright-2x','_ui-frame-diamondmetal-header-tile-2x','creditsscreen-highlight','creditsscreen-selected','_creditsscreen-gradient-tile','auctionhouse-icon-checkmark','auctionhouse-icon-clock','auctionhouse-icon-coin-copper','auctionhouse-icon-coin-gold','auctionhouse-icon-coin-silver','auctionhouse-icon-favorite-off','auctionhouse-icon-favorite','auctionhouse-icon-socket','auctionhouse-itemheaderframe','auctionhouse-itemicon-border-account','auctionhouse-itemicon-border-artifact','auctionhouse-itemicon-border-blue','auctionhouse-itemicon-border-gray','auctionhouse-itemicon-border-green','auctionhouse-itemicon-border-orange','auctionhouse-itemicon-border-purple','auctionhouse-itemicon-border-white','auctionhouse-itemicon-cover','auctionhouse-itemicon-empty','auctionhouse-itemicon-small-border','auctionhouse-nav-button-highlight','auctionhouse-nav-button-secondary-highlight','auctionhouse-nav-button-secondary-select','auctionhouse-nav-button-secondary','auctionhouse-nav-button-select','auctionhouse-nav-button-tertiary-filterline','auctionhouse-nav-button','auctionhouse-rowstripe-1','auctionhouse-rowstripe-2','auctionhouse-selltab-left','auctionhouse-selltab-middle','auctionhouse-selltab-right','auctionhouse-ui-dropdown-arrow-disabled','auctionhouse-ui-dropdown-arrow-down','auctionhouse-ui-dropdown-arrow-up','auctionhouse-ui-dropdown-left','auctionhouse-ui-dropdown-middle','auctionhouse-ui-dropdown-right','auctionhouse-ui-filter-redx','auctionhouse-ui-inputfield-left','auctionhouse-ui-inputfield-middle','auctionhouse-ui-inputfield-right','auctionhouse-ui-loadingspinner','auctionhouse-ui-row-highlight','auctionhouse-ui-row-select','auctionhouse-ui-sortarrow','shop-card-full-bcc-darkportalpassupgrade','shop-card-half-bcc-darkportalpass','shop-card-half-bcc-darkportalpassdeluxe','classicon-druid','classicon-hunter','classicon-mage','classicon-paladin','classicon-priest','classicon-rogue','classicon-shaman','classicon-warlock','classicon-warrior','ui-scrollbar-button-overlay-horizontal','ui-scrollbar-button-overlay','ui-scrollbar-endcap-bottom','ui-scrollbar-endcap-left','ui-scrollbar-endcap-right','ui-scrollbar-endcap-top','ui-scrollbar-knob-endcap-bottom-disabled','ui-scrollbar-knob-endcap-bottom','ui-scrollbar-knob-endcap-left-disabled','ui-scrollbar-knob-endcap-left','ui-scrollbar-knob-endcap-right-disabled','ui-scrollbar-knob-endcap-right','ui-scrollbar-knob-endcap-top-disabled','ui-scrollbar-knob-endcap-top','ui-scrollbar-knob-mouseover-endcap-bottom','ui-scrollbar-knob-mouseover-endcap-left','ui-scrollbar-knob-mouseover-endcap-right','ui-scrollbar-knob-mouseover-endcap-top','ui-scrollbar-scrolldownbutton-disabled','ui-scrollbar-scrolldownbutton-down','ui-scrollbar-scrolldownbutton-highlight','ui-scrollbar-scrolldownbutton-up','ui-scrollbar-scrollleftbutton-disabled','ui-scrollbar-scrollleftbutton-down','ui-scrollbar-scrollleftbutton-highlight','ui-scrollbar-scrollleftbutton-up','ui-scrollbar-scrollrightbutton-disabled','ui-scrollbar-scrollrightbutton-down','ui-scrollbar-scrollrightbutton-highlight','ui-scrollbar-scrollrightbutton-up','ui-scrollbar-scrollupbutton-disabled','ui-scrollbar-scrollupbutton-down','ui-scrollbar-scrollupbutton-highlight','ui-scrollbar-scrollupbutton-up','ui-scrollbar-center','ui-scrollbar-knob-center-disabled','ui-scrollbar-knob-center','ui-scrollbar-knob-mouseover-center','ui-scrollbar-knob-center-disabled-horizontal','ui-scrollbar-knob-center-horizontal','ui-scrollbar-knob-mouseover-center-horizontal','_ui-scrollbar-center','circlemaskscalable','metal-bar-battlegrounds','tooltip-nineslice-cornerbottomleft','tooltip-nineslice-cornerbottomright','tooltip-nineslice-cornertopleft','tooltip-nineslice-cornertopright','_tooltip-nineslice-edgebottom','_tooltip-nineslice-edgetop','!tooltip-nineslice-edgeleft','!tooltip-nineslice-edgeright','tooltip-glues-nineslice-cornerbottomleft','tooltip-glues-nineslice-cornerbottomright','tooltip-glues-nineslice-cornertopleft','tooltip-glues-nineslice-cornertopright','_tooltip-glues-nineslice-edgebottom','_tooltip-glues-nineslice-edgetop','!tooltip-glues-nineslice-edgeleft','!tooltip-glues-nineslice-edgeright','tooltip-glues-nineslice-center','tooltip-nineslice-center','clickcastlist-buttonbackground','clickcastlist-buttonhighlight','clickcastlist-buttonnew','gmchat-icon-alert','gmchat-icon-blizz','gmchat-icon-wow','gmchat-nineslice-cornerbottomleft','gmchat-nineslice-cornerbottomright','gmchat-nineslice-cornertopleft','gmchat-nineslice-cornertopright','gmchat-watermark-blizzard','gmglow-nineslice-cornerbottomleft','gmglow-nineslice-cornerbottomright','gmglow-nineslice-cornertopleft','gmglow-nineslice-cornertopright','_gmchat-nineslice-edgebottom','_gmchat-nineslice-edgetop','_gmglow-nineslice-edgebottom','_gmglow-nineslice-edgetop','chatframe-button-icon-tts','common-search-border-left','common-search-border-middle','common-search-border-right','common-search-clearbutton','common-search-magnifyingglass','voicechat-channellist-icon-stt-off','voicechat-channellist-icon-stt-on','voicechat-icon-stt','reportlist-buttonselect','ui-scrollbar-classicscrolldownbutton-disabled','ui-scrollbar-classicscrolldownbutton-down','ui-scrollbar-classicscrolldownbutton-highlight','ui-scrollbar-classicscrolldownbutton-up','ui-scrollbar-classicscrollupbutton-disabled','ui-scrollbar-classicscrollupbutton-down','ui-scrollbar-classicscrollupbutton-highlight','ui-scrollbar-classicscrollupbutton-up','ui-classicscrollbar-endcap-bottom-rounded','ui-classicscrollbar-endcap-bottom','ui-classicscrollbar-endcap-top','ui-classicscrollbar-center','groupfinder-background-classic','newplayerchat-chaticon-guide','newplayerchat-chaticon-newcomer','shop-card-full-classicwotlk-goodies','shop-card-half-classicwotlk-goodiesepic','shop-card-half-classicwotlk-goodieshero','shop-card-full-classicwotlk-goodies-heroictoepic','classicon-deathknight'}
