--[[

	This file is part of 'Masque', an add-on for World of Warcraft. For bug reports,
	documentation and license information, please visit https://github.com/SFX-WoW/Masque.

	* File...: Locales\deDE.lua

	deDE Locale

	[ Notes ]

	To help with translations, use the localization system on CurseForge (https://www.curseforge.com/wow/addons/masque/localization)
	or contribute directly on GitHub (https://github.com/SFX-WoW/Masque).

]]

if GetLocale() ~= "deDE" then return end

local _, Core = ...
local L = Core.Locale

----------------------------------------
-- About Masque
---

L["About Masque"] = "Über Masque"
L["API"] = "API"
-- L["For more information, please visit one of the sites listed below."] = "For more information, please visit one of the sites listed below."
-- L["Masque is a skinning engine for button-based add-ons."] = "Masque is a skinning engine for button-based add-ons."
-- L["Select to view."] = "Select to view."
-- L["Supporters"] = "Supporters"
-- L["You must have an add-on that supports Masque installed to use it."] = "You must have an add-on that supports Masque installed to use it."

----------------------------------------
-- Advanced Settings
---

-- L["Advanced"] = "Advanced"
-- L["Advanced Settings"] = "Advanced Settings"
-- L["Cast Animations"] = "Cast Animations"
-- L["Cooldown Animations"] = "Cooldown Animations"
-- L["Enable animations when action button cooldowns finish."] = "Enable animations when action button cooldowns finish."
-- L["Enable cast animations on action buttons."] = "Enable cast animations on action buttons."
-- L["Enable interrupt animations on action buttons."] = "Enable interrupt animations on action buttons."
-- L["Enable targeting reticles on action buttons."] = "Enable targeting reticles on action buttons."
-- L["Flash and Loop"] = "Flash and Loop"
-- L["Interrupt Animations"] = "Interrupt Animations"
-- L["Loop Only"] = "Loop Only"
-- L["Select which spell alert animations are enabled."] = "Select which spell alert animations are enabled."
-- L["Spell Alerts"] = "Spell Alerts"
-- L["Targeting Reticles"] = "Targeting Reticles"
-- L["This section will allow you to adjust button settings for the default interface."] = "This section will allow you to adjust button settings for the default interface."

----------------------------------------
-- Blizzard Classic Skin
---

-- L["The default Classic button style."] = "The default Classic button style."

----------------------------------------
-- Blizzard Modern Skin
---

-- L["The default Dragonflight button style."] = "The default Dragonflight button style."

----------------------------------------
-- Classic Redux Skin
---

L["A modified version of the Classic button style."] = "Eine optisch verbesserte Version der Standardschaltflächen des Spiels."

----------------------------------------
-- Core Settings
---

L["About"] = "Über"
L["This section will allow you to view information about Masque and any skins you have installed."] = "Dieser Abschnitt zeigt dir Infomationen über Masque und aller installierten Skins."

----------------------------------------
-- Developer Settings
---

L["Causes Masque to throw Lua errors whenever it encounters a problem with an add-on or skin."] = "Veranlasst Masque Lua-Fehler auszugeben, wann immer es ein Problem mit einem Addon oder einer Optik gibt."
L["Clean Database"] = "Datenbank bereinigen"
L["Click to purge the settings of all unused add-ons and groups."] = "Klicken, um die Einstellungen von allen ungenutzten Add-Ons und Gruppen zu bereinigen."
L["Debug Mode"] = "Debugmodus"
L["Developer"] = "Entwickler"
L["Developer Settings"] = "Entwicklereinstellungen"
L["Masque debug mode disabled."] = "Masque Debugmodus deaktiviert."
L["Masque debug mode enabled."] = "Masque Debugmodus aktiviert."
-- L["This action cannot be undone. Continue?"] = "This action cannot be undone. Continue?"
-- L["This section will allow you to adjust settings that affect working with Masque's API."] = "This section will allow you to adjust settings that affect working with Masque's API."

----------------------------------------
-- Dream Skin
---

L["A square skin with trimmed icons and a semi-transparent background."] = "Eine rechteckige Optik mit beschnittenen Symbolen und einem halbtransparenten Hintergrund."

----------------------------------------
-- General Settings
---

L["General Settings"] = "Allgemeine Einstellungen"
-- L["This section will allow you to adjust Masque's interface and performance settings."] = "This section will allow you to adjust Masque's interface and performance settings."

----------------------------------------
-- Installed Skins
---

L["Author"] = "Autor"
L["Authors"] = "Autoren"
L["Compatible"] = "Kompatibel"
L["Description"] = "Beschreibung"
-- L["Discord"] = "Discord"
L["Installed Skins"] = "Installierte Optiken"
L["No description available."] = "Keine Beschreibung verfügbar."
L["Status"] = "Status"
L["The status of this skin is unknown."] = "Der Status dieser Optik ist unbekannt."
-- L["This section provides information on any skins you have installed."] = "This section provides information on any skins you have installed."
L["This skin is compatible with Masque."] = "Diese Optik ist mit Masque kompatibel."
L["This skin is outdated but is still compatible with Masque."] = "Dieser Skin ist veraltet, aber noch immer mit Masque kompatibel."
L["Unknown"] = "Unbekannt"
L["Version"] = "Version"
L["Website"] = "Webseite"
L["Websites"] = "Webseiten"

----------------------------------------
-- Interface Settings
---

-- L["Add-On Compartment"] = "Add-On Compartment"
-- L["Alternate Sorting"] = "Alternate Sorting"
-- L["Causes the skins included with Masque to be listed above third-party skins."] = "Causes the skins included with Masque to be listed above third-party skins."
L["Click to reload the interface."] = "Klicken, um die Benutzeroberfläche neu zu laden."
L["Interface"] = "Interface"
L["Interface Settings"] = "Interfaceeinstellungen"
-- L["Load the skin information panel."] = "Load the skin information panel."
-- L["Menu Icon"] = "Menu Icon"
-- L["Minimap"] = "Minimap"
-- L["None"] = "None"
L["Reload Interface"] = "Benutzeroberfläche neu laden."
-- L["Requires an interface reload."] = "Requires an interface reload."
-- L["Select where Masque's menu icon is displayed."] = "Select where Masque's menu icon is displayed."
L["Skin Information"] = "Optikinformation"
-- L["Stand-Alone GUI"] = "Stand-Alone GUI"
-- L["This section will allow you to adjust settings that affect Masque's interface."] = "This section will allow you to adjust settings that affect Masque's interface."
-- L["Use a resizable, stand-alone options window."] = "Use a resizable, stand-alone options window."

----------------------------------------
-- LDB Launcher
---

L["Click to open Masque's settings."] = "Klicken, um die Masque-Einstellungen zu öffnen."
-- L["Unavailable in combat."] = "Unavailable in combat."

----------------------------------------
-- Modern Enhanced Skin
---

-- L["An enhanced version of the Dragonflight button style."] = "An enhanced version of the Dragonflight button style."

----------------------------------------
-- Profile Settings
---

L["Profile Settings"] = "Profileinstellungen."

----------------------------------------
-- Skin Settings
---

-- L["Adjust the scale of this group's skin."] = "Adjust the scale of this group's skin."
L["Backdrop"] = "Hintergrund Einstellungen"
L["Checked"] = "Ausgewählt"
L["Color"] = "Farbe"
L["Colors"] = "Farben"
L["Cooldown"] = "Abklingzeit"
L["Disable"] = "Deaktivieren"
L["Disable the skinning of this group."] = "Deaktiviert die Aussehensveränderung dieser Gruppe."
L["Enable"] = "Aktivieren"
-- L["Enable skin scaling."] = "Enable skin scaling."
L["Enable the Backdrop texture."] = "Aktiviert die Hintergrundtextur."
-- L["Enable the Gloss texture."] = "Enable the Gloss texture."
-- L["Enable the Shadow texture."] = "Enable the Shadow texture."
L["Flash"] = "Leuchten"
L["Global"] = "Global"
L["Global Settings"] = "Globale Einstellungen"
L["Gloss"] = "Glanz"
L["Highlight"] = "Hervorheben"
L["Normal"] = "Normal"
-- L["Pulse"] = "Pulse"
L["Pushed"] = "Gedrückt"
L["Reset all skin options to the defaults."] = "Setzt alle Optikoptionen auf Standard zurück."
L["Reset Skin"] = "Optik zurücksetzen"
-- L["Scale"] = "Scale"
L["Set the color of the Backdrop texture."] = "Lege die Farbe der Hintergrundtextur fest"
L["Set the color of the Checked texture."] = "Lege die Farbe der Markiert-Textur fest"
L["Set the color of the Cooldown animation."] = "Lege die Farbe der Abklingzeit-Animation fest."
L["Set the color of the Flash texture."] = "Lege die Farbe der Leucht-Textur fest"
L["Set the color of the Gloss texture."] = "Lege die Farbe der Glanz-Textur fest"
L["Set the color of the Highlight texture."] = "Lege die Farbe Hervorgehoben-Textur"
L["Set the color of the Normal texture."] = "Lege die Farbe der Normal-Textur fest"
L["Set the color of the Pushed texture."] = "Lege die Farbe der Gedrückt-Textur fest"
-- L["Set the color of the Shadow texture."] = "Set the color of the Shadow texture."
L["Set the skin for this group."] = "Lege die Optik dieser Gruppe fest"
L["Shadow"] = "Schatten"
-- L["Show the pulse effect when a cooldown finishes."] = "Show the pulse effect when a cooldown finishes."
L["Skin"] = "Optik"
L["Skin Settings"] = "Optikeinstellungen"
-- L["This section will allow you to adjust the skin settings of all buttons registered to %s."] = "This section will allow you to adjust the skin settings of all buttons registered to %s."
-- L["This section will allow you to adjust the skin settings of all buttons registered to %s. This will overwrite any per-group settings."] = "This section will allow you to adjust the skin settings of all buttons registered to %s. This will overwrite any per-group settings."
L["This section will allow you to adjust the skin settings of all registered buttons. This will overwrite any per-add-on settings."] = "Dieser Abschnitt ermöglicht es dir die Einstellungen der Optiken von allen registrierten Schaltflächen zu verändern. Dies wird jegliche addonspezifischen Einstellungen überschreiben."
L["This section will allow you to skin the buttons of the add-ons and add-on groups registered with Masque."] = "Dieser Abschnitt ermöglicht es dir, das Aussehen von Buttons der Addons und Addongruppen anzupassen, die mit Masque verbunden sind."

----------------------------------------
-- Zoomed Skin
---

L["A square skin with zoomed icons and a semi-transparent background."] = "Eine rechteckige Optik mit vergrößerten Symbolen und einem halbtransparenten Hintergrund."
