---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local generalOptionsLocales = {
    ["General"] = {
        ["ptBR"] = "Opções",
        ["ruRU"] = "Общее",
        ["deDE"] = "Allgemein",
        ["koKR"] = "일반",
        ["esMX"] = "Opciones",
        ["enUS"] = true,
        ["zhCN"] = "选项",
        ["zhTW"] = "一般",
        ["esES"] = "Opciones",
        ["frFR"] = "Options",
    },
    ["General Options"] = {
        ["ptBR"] = "Opções Generais",
        ["ruRU"] = "Общие настройки",
        ["deDE"] = "Allgemeine Einstellungen",
        ["koKR"] = "일반 설정",
        ["esMX"] = "Opciones de Questie",
        ["enUS"] = true,
        ["zhCN"] = "Questie选项",
        ["zhTW"] = "一般選項",
        ["esES"] = "Opciones de Questie",
        ["frFR"] = "Options générales",
    },
    ["Enable Icons"] = {
        ["ptBR"] = "Ativar os ícones",
        ["ruRU"] = "Значки Questie",
        ["deDE"] = "Icons aktivieren",
        ["koKR"] = "아이콘 활성화",
        ["esMX"] = "Habilitar Iconos",
        ["enUS"] = true,
        ["zhCN"] = "启用Questie",
        ["zhTW"] = "啟用圖示",
        ["esES"] = "Habilitar Iconos",
        ["frFR"] = "Activer les icônes",
    },
    ["Enable or disable Questie icons."] = {
        ["ptBR"] = "Ativar ou desativar os ícones da Questie",
        ["ruRU"] = "Показать/скрыть значки Questie",
        ["deDE"] = "Aktivieren/Deaktivieren der Questie-Icons",
        ["koKR"] = "Questie 아이콘을 활성화합니다.",
        ["esMX"] = "Habilitar iconos de Questie",
        ["enUS"] = true,
        ["zhCN"] = "启用或禁用Questie图标",
        ["zhTW"] = "啟用或停用任務位置提示的圖示。",
        ["esES"] = "Habilitar iconos de Questie",
        ["frFR"] = "Activer les icônes de Questie",
    },
    ["Config Tracking Icons"] = {
        ["ptBR"] = "Configurar ícones de rastreamento",
        ["ruRU"] = "Отслеживаемые значки",
        ["deDE"] = "Tracking Icons konfigurieren",
        ["koKR"] = "추적 아이콘 설정",
        ["esMX"] = "Configurar iconos de seguimiento",
        ["enUS"] = true,
        ["zhCN"] = "显示追踪图标",
        ["zhTW"] = "設定追蹤圖示",
        ["esES"] = "Configurar iconos de seguimiento",
        ["frFR"] = "Configurer les icônes de suivi",
    },
    ["Allows to select which the tracking icons (like Mailbox, Repair-NPCs) to show on the map and minimap."] = {
        ["ptBR"] = "Permite selecionar quais ícones de rastreamento (como Caixa de Correio, PNJ de Reparo) mostrar no mapa e minimapa.",
        ["ruRU"] = "Позволяет выбрать, какие отслеживаемые значки (почтовый ящик, ремонт и проч.) отображать на карте и миникарте",
        ["deDE"] = "Ermöglicht das Konfigurieren der Tracking Icons (z.B. Briefkästen, Reparatur-NPCs) auf der Karte und Minimap.",
        ["koKR"] = "지도에 표시할 추적 아이콘(예: 우체통, 수리NPC)을 선택할 수 있습니다.",
        ["esMX"] = "Permite seleccionar qué iconos de seguimiento (como Buzón, PNJ de Reparación) se mostrarán en el mapa y el minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "允许在地图和小地图上显示选择追踪图标（例如“邮箱”，“修理”）。",
        ["zhTW"] = "可以選擇哪些追蹤圖示 (例如郵箱、修理商人) 要顯示在地圖和小地圖上。",
        ["esES"] = "Permite seleccionar qué iconos de seguimiento (como Buzón, PNJ de Reparación) se mostrarán en el mapa y el minimapa.",
        ["frFR"] = "Permet de sélectionner les icônes de suivi (comme la boîte aux lettres, les PNJ de réparation) à afficher sur la carte et la mini-carte.",
    },
    ["Icon Types"] = {
        ["ptBR"] = "Tipos de ícones",
        ["ruRU"] = "Типы значков",
        ["deDE"] = "Icon-Arten",
        ["koKR"] = "아이콘 유형",
        ["esMX"] = "Tipos de icono",
        ["enUS"] = true,
        ["zhCN"] = "图标类别",
        ["zhTW"] = "圖示類型",
        ["esES"] = "Tipos de icono",
        ["frFR"] = "Types d'icônes",
    },
    ["When this is enabled, the quest turn-in locations will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando ativado, os locais de ativação da missão serão exibidos no mapa / mapa mínimo",
        ["ruRU"] = "Показать/скрыть местоположения выполненных заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der abgeschlossenen Quests auf der Karte/Minimap.",
        ["koKR"] = "퀘스트 완료 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de misión completada apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上标记提交任务的地点",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示回任務的位置。",
        ["esES"] = "Cuando está habilitado los iconos de misión completada apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des lieux où rendre les quêtes sur la carte/mini-carte.",
    },
    ["Enable Map Icons"] = {
        ["ptBR"] = "Ativar ícones do mapa",
        ["ruRU"] = "Значки на карте мира",
        ["deDE"] = "Karten-Icons anzeigen",
        ["koKR"] = "지도 아이콘 활성화",
        ["esMX"] = "Habilitar iconos en el mapa",
        ["enUS"] = true,
        ["zhCN"] = "启用大地图图标",
        ["zhTW"] = "啟用大地圖圖示",
        ["esES"] = "Habilitar iconos en el mapa",
        ["frFR"] = "Activer les icônes sur la carte",
    },
    ["Show/hide all icons from the main map."] = {
        ["ptBR"] = "Mostrar / ocultar todos os ícones na carta principal",
        ["ruRU"] = "Показать/скрыть все значки на карте мира",
        ["deDE"] = "Aktiviert/Deaktiviert alle Icons auf der Karte",
        ["koKR"] = "세계 지도에 퀘스트 아이콘을 표시합니다.",
        ["esMX"] = "Mostrar/Esconder todos los iconos del mapa principal",
        ["enUS"] = true,
        ["zhCN"] = "启用或停用大地图上的所有图标",
        ["zhTW"] = "顯示/隱藏世界地圖上的所有圖示。",
        ["esES"] = "Mostrar/Esconder todos los iconos del mapa principal",
        ["frFR"] = "Active l'affichage de toutes les icônes sur la carte.",
    },
    ["Enable Minimap Icons"] = {
        ["ptBR"] = "Ativar ícones do Mini-mapa",
        ["ruRU"] = "Значки на миникарте",
        ["deDE"] = "Minimap-Icons anzeigen",
        ["koKR"] = "미니맵 아이콘 활성화",
        ["esMX"] = "Habilitar iconos del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "启用小地图标记",
        ["zhTW"] = "啟用小地圖圖示",
        ["esES"] = "Habilitar iconos del minimapa",
        ["frFR"] = "Activer les icônes sur la mini-carte",
    },
    ["Show/hide all icons from the minimap."] = {
        ["ptBR"] = "Mostrar / ocultar todos os ícones no mini-mapa",
        ["ruRU"] = "Показать/скрыть все значки на миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert alle Icons auf der Minimap",
        ["koKR"] = "미니맵에 퀘스트 아이콘을 표시합니다.",
        ["esMX"] = "Mostrar/Esconder todos los iconos del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "启用或停用小地图上的所有图标",
        ["zhTW"] = "顯示/隱藏小地圖上的所有圖示。",
        ["esES"] = "Mostrar/Esconder todos los iconos del minimapa",
        ["frFR"] = "Active l'affichage de toutes les icônes sur la mini-carte.",
    },
    ["Hide unexplored area Icons"] = {
        ["ptBR"] = "Ocultar ícones da área inexplorada",
        ["ruRU"] = "Значки неисследованных зон",
        ["deDE"] = "Icons in nicht entdeckten Gebieten verbergen",
        ["koKR"] = "미탐험 지역 아이콘 가리기",
        ["esMX"] = "Esconder icono de áreas inexploradas.",
        ["enUS"] = true,
        ["zhCN"] = "隐藏未探测区域图标",
        ["zhTW"] = "隱藏未探索區域的圖示",
        ["esES"] = "Esconder icono de áreas inexploradas.",
        ["frFR"] = "Masquer les icônes des zones inexplorées",
    },
    ["Hide icons in unexplored areas."] = {
        ["ptBR"] = "Oculta ícones em áreas inexploradas.",
        ["ruRU"] = "Показать/скрыть значки в неисследованных областях карты",
        ["deDE"] = "Verbirgt die Questie Icons in nicht entdeckten Gebieten.",
        ["koKR"] = "미탐험 지역의 아이콘을 가립니다.",
        ["esMX"] = "Esconder iconos en áreas inexploradas.",
        ["enUS"] = true,
        ["zhCN"] = "隐藏未探测区域中的图标",
        ["zhTW"] = "隱藏在尚未探索的區域內的圖示。",
        ["esES"] = "Esconder iconos en áreas inexploradas.",
        ["frFR"] = "Désactive l'affichage des icônes dans les zones inexplorées.",
    },
    ["Hide icons of untracked quests"] = {
        ["ptBR"] = "Ocultar ícones de missões não rastreadas",
        ["ruRU"] = "Значки неотслеживаемых заданий",
        ["deDE"] = "Icons nicht getrackter Quests verbergen",
        ["koKR"] = false,
        ["esMX"] = "Ocultar iconos de misiones sin seguimiento",
        ["enUS"] = true,
        ["zhCN"] = "隐藏未追踪的任务图标",
        ["zhTW"] = "隱藏未追蹤任務的圖示",
        ["esES"] = "Ocultar iconos de misiones sin seguimiento",
        ["frFR"] = "Masquer les icônes des quêtes non suivies",
    },
    ["Hide icons for quests that are not tracked."] = {
        ["ptBR"] = "Oculta ícones para missões que não são rastreadas.",
        ["ruRU"] = "Показать/скрыть значки заданий, которые не отслеживаются в трекере",
        ["deDE"] = "Verbirgt die Icons aller Quests die nicht vom Tracker getrackt werden.",
        ["koKR"] = false,
        ["esMX"] = "Oculta los iconos de las misiones que no se rastrean.",
        ["enUS"] = true,
        ["zhCN"] = "隐藏追踪器上未追踪的任务图标",
        ["zhTW"] = "隱藏沒有在任務追蹤清單中的任務的圖示。",
        ["esES"] = "Oculta los iconos de las misiones que no se rastrean.",
        ["frFR"] = "Masquez les icônes pour les quêtes qui ne sont pas suivies.",
    },
    ["Show custom quest frame icons"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значки пользователя в диалогах",
        ["deDE"] = "Zeige angepasste Icons in Quest-Fenster",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "显示自定义任务窗口图标",
        ["zhTW"] = "顯示自訂任務視窗圖示",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Use custom Questie icons for NPC dialogs, reflecting the status and type of each quest."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Показать/скрыть пользовательские значки, отражающие статус и тип каждого задания, во время диалога с NPC",
        ["deDE"] = "Questie zeigt in NPC-Dialogen angepasste Icons, die den Status und Typ jeder Quest widerspiegeln.",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "NPC 对话框显示任务位置提示插件的自定义图标，反应出每个任务的状态和类型。",
        ["zhTW"] = "NPC 對話框顯示任務位置提示插件的自訂圖示，反應出每個任務的狀態和類型。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Enable Available Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões disponíveis",
        ["ruRU"] = "Значки доступных заданий",
        ["deDE"] = "Icons zu verfügbaren Quests anzeigen",
        ["koKR"] = "수행 가능한 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misión disponible",
        ["enUS"] = true,
        ["zhCN"] = "启用可接任务图标",
        ["zhTW"] = "啟用可接的任務圖示",
        ["esES"] = "Habilitar iconos de misión disponible",
        ["frFR"] = "Icônes des quêtes disponibles",
    },
    ["When this is enabled, the locations of available quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando esta opção está ativada, os locais de ativação da missão serão exibidos no mapa / mini mapa",
        ["ruRU"] = "Показать/скрыть местоположения доступных заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der verfügbaren Quests auf der Karte/Minimap.",
        ["koKR"] = "수행 가능한 퀘스트 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de misión disponible apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上标记可接任务的地点",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示可取得任務的位置。",
        ["esES"] = "Cuando está habilitado los iconos de misión disponible apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des lieux où prendre les quêtes sur la carte/mini-carte.",
    },
    ["Enable Event Quest Icons"] = {
        ["ptBR"] = "Ativar ícones da missão de eventos",
        ["ruRU"] = "Значки заданий игровых событий",
        ["deDE"] = "Event-Quest anzeigen",
        ["koKR"] = "이벤트 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de eventos",
        ["enUS"] = true,
        ["zhCN"] = "启用事件任务图标",
        ["zhTW"] = "啟用事件任務圖示",
        ["esES"] = "Habilitar iconos de misiones de eventos",
        ["frFR"] = "Icônes des quêtes d'évènement",
    },
    ["When this is enabled, the locations of active event quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, a busca de locais de eventos será mostrada no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий игровых событий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Event-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 이벤트 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está marcado, la localización de misiones de eventos mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，事件任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示可取得事件任務的位置。",
        ["esES"] = "Si está marcado, la localización de misiones de eventos mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes des évènements mondiaux sur la carte/mini-carte.",
    },
    ["Enable Objective Icons"] = {
        ["ptBR"] = "Ativar ícones do objectivo",
        ["ruRU"] = "Значки целей заданий",
        ["deDE"] = "Icons zu Questzielen anzeigen",
        ["koKR"] = "퀘스트 목표 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de objetivo",
        ["enUS"] = true,
        ["zhCN"] = "启用互动目标图标",
        ["zhTW"] = "啟用任務目標圖示",
        ["esES"] = "Habilitar iconos de objetivo",
        ["frFR"] = "Icônes des objectifs",
    },
    ["When this is enabled, quest objective icons will be shown on the map/minimap."] = {
        ["ptBR"] = "Se ativado, os ícones do objectivo da missão serão exibidos no mapa / mini-carta",
        ["ruRU"] = "Показать/скрыть значки целей заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der Questziele auf der Karte/Minimap.",
        ["koKR"] = "퀘스트 목표 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de objetivo apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上显示任务互动目标",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示任務目標圖示。",
        ["esES"] = "Cuando está habilitado los iconos de objetivo apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des icônes des objectifs de quête sur la carte/mini-carte.",
    },
    ["Enable Repeatable Quest Icons"] = {
        ["ptBR"] = "Mostrar missões repetíveis no mapa",
        ["ruRU"] = "Значки повторяемых заданий",
        ["deDE"] = "Wiederholbare Quests anzeigen",
        ["koKR"] = "지도에 반복 퀘스트를 표시",
        ["esMX"] = "Mostrar misiones repetibles",
        ["enUS"] = true,
        ["zhCN"] = "启用重复的任务图标",
        ["zhTW"] = "顯示可重覆接取的任務圖示",
        ["esES"] = "Mostrar misiones repetibles",
        ["frFR"] = "Quêtes répétables sur la carte",
    },
    ["When this is enabled, the locations of repeatable quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Escolha se missões repetíveis devem estar visíveis no mapa e no minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения повторяемых заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von wiederholbaren Quests auf der Karte/Minimap.",
        ["koKR"] = "지도나 미니맵에 반복 퀘스트를 표시할지 말지 선택합니다.",
        ["esMX"] = "Muestra las misiones repetibles en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，重复任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示可以重覆接取的任務。",
        ["esES"] = "Muestra las misiones repetibles en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes répétables sur la carte et la mini-carte.",
    },
    ["Enable Raid Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de raide",
        ["ruRU"] = "Значки рейдовых заданий",
        ["deDE"] = "Raid-Quests anzeigen",
        ["koKR"] = "레이드 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de bandas",
        ["enUS"] = true,
        ["zhCN"] = "启用团队任务图标",
        ["zhTW"] = "啟用團隊任務圖示",
        ["esES"] = "Habilitar iconos de misiones de bandas",
        ["frFR"] = "Icônes des quêtes de raid",
    },
    ["When this is enabled, the locations of raid quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão da raide serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения рейдовых заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Raid-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 레이드 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está marcado, la localización de misiones de bandas mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，团队任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示團隊任務。",
        ["esES"] = "Si está marcado, la localización de misiones de bandas mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de raid sur la carte/mini-carte.",
    },
    ["Enable Dungeon Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de masmorra",
        ["ruRU"] = "Значки заданий подземелий",
        ["deDE"] = "Dungeon-Quests anzeigen",
        ["koKR"] = "던전 퀘스트 활성화",
        ["esMX"] = "Habilitar iconos de misiones de calabozos",
        ["enUS"] = true,
        ["zhCN"] = "启用副本任务图标",
        ["zhTW"] = "啟用地城任務圖示",
        ["esES"] = "Habilitar iconos de misiones de mazmorras",
        ["frFR"] = "Icônes des quêtes de donjon",
    },
    ["When this is enabled, the locations of dungeon quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão da masmorra serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий подземелий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Dungeon-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 던전 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está marcado, la localización de misiones de calabozos mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，副本任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示地城任務。",
        ["esES"] = "Si está marcado, la localización de misiones de mazmorras mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de donjon sur la carte/mini-carte.",
    },
    ["Enable Completed Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões concluídas",
        ["ruRU"] = "Значки выполненных заданий",
        ["deDE"] = "Icons zu abgeschlossenen Quests anzeigen",
        ["koKR"] = "퀘스트 완료 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misión completada",
        ["enUS"] = true,
        ["zhCN"] = "启用提交任务标记",
        ["zhTW"] = "啟用已完成的任務圖示",
        ["esES"] = "Habilitar iconos de misión completada",
        ["frFR"] = "Icônes des quêtes terminées",
    },
    ["Enable PvP Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de JxJ",
        ["ruRU"] = "Значки PvP-заданий",
        ["deDE"] = "PvP-Quests anzeigen",
        ["koKR"] = "PVP 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de JcJ",
        ["enUS"] = true,
        ["zhCN"] = "启用PVP任务图标",
        ["zhTW"] = "啟用 PvP 任務圖示",
        ["esES"] = "Habilitar iconos de misiones de JcJ",
        ["frFR"] = "Icônes des quêtes JcJ",
    },
    ["When this is enabled, the locations of PvP quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão de JxJ serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения PvP-заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von PvP-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, PVP 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está marcado, la localización de misiones de JcJ mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，PVP任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示 PvP 任務。",
        ["esES"] = "Si está marcado, la localización de misiones de JcJ mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes JcJ sur la carte/mini-carte.",
    },
    ["Enable AQ War Effort Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de Guerra em Ahn'Qiraj",
        ["ruRU"] = "Значки военной кампании Ан'Киража",
        ["deDE"] = "AQ Kriegsanstrengungen Quests anzeigen",
        ["koKR"] = "안퀴라즈 반납 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de la Guerra de Ahn'Qiraj",
        ["enUS"] = true,
        ["zhCN"] = "启用安其拉战备任务图标",
        ["zhTW"] = "啟用安其拉之門戰火任務圖示",
        ["esES"] = "Habilitar iconos de misiones de la Guerra de Ahn'Qiraj",
        ["frFR"] = "Icônes de l'Effort de guerre d'AQ",
    },
    ["When this is enabled, the locations of the AQ War Effort quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão de Guerra em Ahn'Qiraj serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий военной кампании Ан'Киража на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der AQ Kriegsanstrengungen Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 안퀴라즈 반납 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está habilitado, las localizaciones de las misiones de la Guerra de Ahn'Qiraj mostrarán en el mapa/minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，安其拉战备任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示安其拉之門戰火任務。",
        ["esES"] = "Si está habilitado, las localizaciones de las misiones de la Guerra de Ahn'Qiraj mostrarán en el mapa/minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de l'Effort de guerre d'Ahn'Qiraj sur la carte/mini-carte.",
    },
    ["Toggle pfQuest/ClassicCodex icon style"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значки pfQuest/ClassicCodex",
        ["deDE"] = "pfQuest/ClassicCodex Iconstil umschalten",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "切换 pfQuest/ClassicCodex 图标风格",
        ["zhTW"] = "切換 pfQuest/ClassicCodex 圖示風格",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Toggles between Questie icon style and pfQuest/ClassicCodex icon style.\n\nToggling affects the following settings:\n\n- Objective icons\n- "] = {
        ["ptBR"] = false,
        ["ruRU"] = "Переключает между стилями значков Questie или pfQuest/ClassicCodex.\n\nЭто влияет на:\n\n- Значки целей заданий\n- ",
        ["deDE"] = "Schaltet zwischen Questie Iconstil und pfQuest/ClassicCodex Iconstil um.\n\nUmschalten beeinflusst die folgenden Einstellungen:\n\n- Zielicons\n- ",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "切换要使用任务提示插件的图标风格，还是 pfQuest/ClassicCodex icon 的图标风格。\n\n切换风格会影响下列设置：\n\n- 任务目标提示图标\n- ",
        ["zhTW"] = "切換要使用任務位置提示插件的圖示風格，還是 pfQuest/ClassicCodex 的圖示風格。\n\n切換風格會影響下列設定:\n\n- 任務目標圖示\n- ",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Icon Overrides (show/hide)"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Переопределение значков",
        ["deDE"] = "Icons überschreiben",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "覆盖图标 （显示/隐藏）",
        ["zhTW"] = "圖示覆蓋 (顯示/隱藏)",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Slay objectives"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Убийство",
        ["deDE"] = "Tötungsziele",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "击杀目标",
        ["zhTW"] = "擊殺目標",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for quest objectives where you need to kill an NPC"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно убить NPC",
        ["deDE"] = "Das Icon welches für Questziele wo du jemanden töten musst angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务需要你击杀 NPC 时显示的图标。",
        ["zhTW"] = "任務目標需要你擊殺 NPC 時顯示的圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Loot objectives"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Добыча",
        ["deDE"] = "Plünderungsziele",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "拾取物品",
        ["zhTW"] = "拾取物品",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for quest objectives where you need to loot an item"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно добыть предмет",
        ["deDE"] = "Das Icon welches für Questziele wo du etwas plündern musst angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务需要你拾取物品时显示的图标",
        ["zhTW"] = "任務目標需要你拾取物品時顯示的圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Object objectives"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Объект",
        ["deDE"] = "Objektziele",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "与道具互动",
        ["zhTW"] = "與物件互動",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for quest objectives where you need to interact with an object"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно провзаимодействовать с объектом",
        ["deDE"] = "Das Icon welches für Questziele wo du mit einem Objekt interagieren musst angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务需要你和道具互动时显示的图标。",
        ["zhTW"] = "任務目標需要你和物件互動時顯示的圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Event objectives"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Событие",
        ["deDE"] = "Ereignisziele",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "做些事情",
        ["zhTW"] = "做些事情",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for quest objectives where you need to do something in a certain area, like exploring it or casting a spell there"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно сделать что-либо в определенной области, например, исследовать ее или произнести там заклинание",
        ["deDE"] = "Das Icon welches für Questziele angezeigt wird wo du in einem bestimmten Gebiet etwas machen musst, wie es zu erkunden oder dort einen Zauberspruch zu benutzen",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务需要在指定区域做某些事情时显示的图标，例如：探索区域或者在那里施放技能。",
        ["zhTW"] = "任務目標需要你在指定區域做某些事情時顯示的圖示，例如探索該區域或在那裏施放法術。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Talk objectives"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Разговор",
        ["deDE"] = "Gesprächsziele",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "对话",
        ["zhTW"] = "說話",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for quest objectives where you need to talk to an NPC"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно поговорить с NPC",
        ["deDE"] = "Das Icon welches für Questziele wo du mit einem NPC sprechen musst angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务需要你和 NCP 对话时显示的图标。",
        ["zhTW"] = "任務目標需要你和 NPC 說話時顯示的圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Normal Quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Обычные задания",
        ["deDE"] = "Normale Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "一般任务",
        ["zhTW"] = "一般任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Available quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Доступные",
        ["deDE"] = "Verfügbare Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可接的任务",
        ["zhTW"] = "可接的任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for available quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для доступных заданий",
        ["deDE"] = "Das Icon welches für verfügbare Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可接取的任务显示的图标",
        ["zhTW"] = "可取得的任務所顯示的圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Unavailable and trivial quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Серые",
        ["deDE"] = "Nicht verfügbare und triviale Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "无法接取和低等任务",
        ["zhTW"] = "無法取得和低等任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for quests that require additional conditions to be met before they can be accepted, or are so low level they don't reward experience"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для серых заданий: недоступные (для принятия которых требуются определенные условия) и низкоуровневые (за выполнение которых вы не получите опыт)",
        ["deDE"] = "Das Icon welches für Quests angezeigt wird die zusätzliche Bedingungen haben bevor sie akzeptiert werden können, oder so niedriglevelig sind, dass sie keine Erfahrung gewähren",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "需要额外条件才能接取的任务，或者是等级太低没有经验值的任务图标。",
        ["zhTW"] = "需要額外條件才能接取的任務，或是等級太低沒有經驗值的任務圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Complete quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выполненные",
        ["deDE"] = "Abgeschlossene Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "完成任务",
        ["zhTW"] = "完成任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for completed quests that can be handed in"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для выполненных заданий",
        ["deDE"] = "Das Icon welches für abgeschlossene Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "已完成，可以交回的任务图标。",
        ["zhTW"] = "已完成，可以交回的任務圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Repeatable Quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Повторяемые задания",
        ["deDE"] = "Wiederholbare Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "重复性任务",
        ["zhTW"] = "重覆性任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Available repeatable quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Доступные",
        ["deDE"] = "Verfügbare wiederholbare Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可接的重复性任务",
        ["zhTW"] = "可接的重覆性任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for available repeatable quests like dailies"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для повторяемых заданий типа ежедневных",
        ["deDE"] = "Das Icon welches für verfügbare wiederholbare Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可接取的重复性任务图标，例如：每日。",
        ["zhTW"] = "可取得的重覆性任務的圖示，例如每日。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Complete repeatable quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выполненные",
        ["deDE"] = "Abgeschlossene wiederholbare Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "完成重复性任务",
        ["zhTW"] = "完成重覆性任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for repeatable quests that can be handed in"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для выполненных повторяемых заданий типа ежедневных",
        ["deDE"] = "Das Icon welches für wiederholbare Quests angezeigt wird, die abgegeben werden können",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可以交回的重复性任务图标。",
        ["zhTW"] = "可以交回的重覆性任務圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Event Quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Задания игровых событий",
        ["deDE"] = "Event-Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "节日任务",
        ["zhTW"] = "活動任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Available event quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Доступные",
        ["deDE"] = "Verfügbare Event-Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可接的节日任务",
        ["zhTW"] = "可接的活動任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for available event quests during holidays"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для доступных заданий игровых событий во время праздников",
        ["deDE"] = "Das Icon welches für verfügbare Event-Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "节庆期间可以取得的节日任务",
        ["zhTW"] = "節慶期間可以取得的活動任務。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Complete event quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выполненные",
        ["deDE"] = "Abgeschlossene Event-Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "完成节日任务",
        ["zhTW"] = "完成活動任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for event quests that can be handed in"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для выполненных заданий игровых событий во время праздников",
        ["deDE"] = "Das Icon welches für Event-Quests angezeigt wird, die abgegeben werden können",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可以交回的节日任务图标。",
        ["zhTW"] = "可以交回的活動任務圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["PvP Quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "PvP-задания",
        ["deDE"] = "PvP-Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "PVP 任务",
        ["zhTW"] = "PvP 任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Available PvP quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Доступные",
        ["deDE"] = "Verfügbare PvP-Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可接的 PVP 任务",
        ["zhTW"] = "可接的 PvP 任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for available PvP quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для доступных PVP-заданий",
        ["deDE"] = "Das Icon welches für verfügbare PvP-Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可取得的 PVP 任务图标。",
        ["zhTW"] = "可取得的 PvP 任務圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Complete PvP quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выполненные",
        ["deDE"] = "Abgeschlossene PvP-Quests",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "完成 PVP 任务",
        ["zhTW"] = "完成 PvP 任務",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The icon that is displayed for PvP quests that can be handed in"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Значок для выполненных PVP-заданий",
        ["deDE"] = "Das Icon welches für PvP-Quests angezeigt wird, die abgegeben werden können",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "可以交回的 PVP 任务图标。",
        ["zhTW"] = "可以交回的 PvP 任務圖示。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Enable Minimap Button"] = {
        ["ptBR"] = "Ative o botão da mini-carta",
        ["ruRU"] = "Кнопка у миникарты",
        ["deDE"] = "Minimap-Button aktivieren",
        ["koKR"] = "미니맵 버튼 활성화",
        ["esMX"] = "Habilitar icono del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "启用Questie的小地图按钮",
        ["zhTW"] = "啟用小地圖按鈕",
        ["esES"] = "Habilitar icono del minimapa",
        ["frFR"] = "Bouton autour de la mini-carte",
    },
    ["Enable or disable the Questie minimap button. You can still access the options menu with /questie."] = {
        ["ptBR"] = "Ative ou desative o botão da mini-carta da missão. Você ainda pode acessar o menu de opções com o Questie",
        ["ruRU"] = "Показать/скрыть кнопку Questie у миникарты. Доступ к настройкам аддона также можно получить через команду '/questie'",
        ["deDE"] = "Questie Minimap-Button aktivieren/deaktivieren. Mit /questie kannst du trotzdem die Einstellungen aufrufen.",
        ["koKR"] = "Questie 미니맵 버튼을 사용합니다. /questie 명령어로도 설정 메뉴를 열 수 있습니다.",
        ["esMX"] = "Habilita o deshabilita el icono del minimapa. Puedes seguir accediendo al menú de opciones con /questie",
        ["enUS"] = true,
        ["zhCN"] = "启用小地图按钮；禁用后以 /questie 打开配置",
        ["zhTW"] = "啟用或停用任務位置提示的小地圖按鈕，停用後仍可輸入 /questie 開啟設定選項。",
        ["esES"] = "Habilita o deshabilita el icono del minimapa. Puedes seguir accediendo al menú de opciones con /questie",
        ["frFR"] = "Active le bouton Questie autour de la mini-carte. Le panneau de configuration reste accessible avec la commande /questie.",
    },
    ["Enable Instant Quest Text"] = {
        ["ptBR"] = "Ativar texto de pesquisa instantânea",
        ["ruRU"] = "Мгновенное отображение текста",
        ["deDE"] = "Questtext sofort anzeigen",
        ["koKR"] = "퀘스트 내용 바로 표시",
        ["esMX"] = "Habilitar el texto automático de misiones",
        ["enUS"] = true,
        ["zhCN"] = "立即显示任务文本",
        ["zhTW"] = "啟用立即顯示任務內容",
        ["esES"] = "Habilitar el texto automático de misiones",
        ["frFR"] = "Activer Texte instantané (quêtes)",
    },
    ["Toggles the default Instant Quest Text option. This is just a shortcut for the WoW option in Interface."] = {
        ["ptBR"] = "Ativa / desativa a opção Texto da missão instantânea. Este é apenas um atalho para a opção WoW na Interface",
        ["ruRU"] = "Включает мгновенное отображение полного текста заданий. Это всего лишь ярлык для стандартной опции в настройках интерфейса игры",
        ["deDE"] = "Die Standardeinstellung für 'Questtext sofort anzeigen' aktivieren/deaktivieren. Dies ist nur eine Abkürzung zum WoW-Interface-Menü.",
        ["koKR"] = "퀘스트 지문이 한번에 표시됩니다. 이 설정은 게임설정의 '퀘스트 내용 바로 표시'와 동일합니다.",
        ["esMX"] = "Habilita el texto automático de misiones. Es simplemente un atajo a la opción de la interfaz de WoW",
        ["enUS"] = true,
        ["zhCN"] = "使任务直接显示完整文本，这其实是一个暴雪原生自带的功能",
        ["zhTW"] = "啟用遊戲內建的立刻顯示任務內容選項，這只是方便調整魔獸介面設定中的選項的捷徑。",
        ["esES"] = "Habilita el texto automático de misiones. Es simplemente un atajo a la opción de la interfaz de WoW",
        ["frFR"] = "Active l'option Texte instantané (quêtes). Cela revient à cocher l'option du même nom dans Interface/Affichage.",
    },
    ["Auto Accept Quests"] = {
        ["ptBR"] = "Aceitar automaticamente missões",
        ["ruRU"] = "Автопринятие заданий",
        ["deDE"] = "Quests automatisch annehmen",
        ["koKR"] = "자동 퀘스트 수락",
        ["esMX"] = "Aceptar misiones automáticamente",
        ["enUS"] = true,
        ["zhCN"] = "自动接受任务",
        ["zhTW"] = "自動接受任務",
        ["esES"] = "Aceptar misiones automáticamente",
        ["frFR"] = "Acceptation automatique des quêtes",
    },
    ["Enable or disable Questie auto-accepting quests."] = {
        ["ptBR"] = "Ativa ou desativa as missões de aceitação automática da Questie.",
        ["ruRU"] = "Включить/отключить автоматическое принятие заданий",
        ["deDE"] = "Aktiviert/Deaktiviert, ob Questie Quests automatisch annimmt.",
        ["koKR"] = "퀘스티 자동 퀘스트 수락을 할지 말지 선택합니다.",
        ["esMX"] = "Habilita o deshabilita aceptar misiones automáticamente.",
        ["enUS"] = true,
        ["zhCN"] = "启用后和NPC对话，自动接受任务。",
        ["zhTW"] = "啟用或停用自動接受任務。",
        ["esES"] = "Habilita o deshabilita aceptar misiones automáticamente.",
        ["frFR"] = "Active l'acceptation automatique des quêtes par Questie.",
    },
    ["Auto Complete"] = {
        ["ptBR"] = "Autocompletar",
        ["ruRU"] = "Автозавершение заданий",
        ["deDE"] = "Quests automatisch abgeben",
        ["koKR"] = "자동 완료",
        ["esMX"] = "Completar misiones automáticamente",
        ["enUS"] = true,
        ["zhCN"] = "自动完成",
        ["zhTW"] = "自動交回任務",
        ["esES"] = "Completar misiones automáticamente",
        ["frFR"] = "Complétion automatique",
    },
    ["Enable or disable Questie auto-completing quests."] = {
        ["ptBR"] = "Ative ou desative autocompletar missões.",
        ["ruRU"] = "Включить/отключить автоматическое завершение выполненных заданий",
        ["deDE"] = "Aktiviert/Deaktiviert, ob Questie Quests automatisch abgibt.",
        ["koKR"] = "퀘스트 자동 퀘스트 완료를 할지 말지 선택합니다.",
        ["esMX"] = "Habilita o deshabilita completar misiones automáticamente.",
        ["enUS"] = true,
        ["zhCN"] = "启用后和NPC交谈，自动完成。",
        ["zhTW"] = "啟用或停用完成任務並與指定任務 NPC 交談時，自動回報並完成任務。",
        ["esES"] = "Habilita o deshabilita completar misiones automáticamente.",
        ["frFR"] = "Active/désactive la complétion automatique des quêtes par Questie.",
    },
    ["Enable Automatic NPC Dialog"] = {
        ["ptBR"] = "Ativar diálogo do NPC automática",
        ["ruRU"] = "Автодиалог с NPC",
        ["deDE"] = "NPC-Dialoge automatisieren",
        ["koKR"] = "자동 NPC 대화 활성화",
        ["esMX"] = "Habilitar el diálogo automático de PNJ",
        ["enUS"] = true,
        ["zhCN"] = "自动执行NPC对话",
        ["zhTW"] = "啟用自動進行 NPC 對話",
        ["esES"] = "Habilitar el diálogo automático de PNJ",
        ["frFR"] = "Activation des dialogues PNJ automatiques",
    },
    ["Enable or disable Questie automatically advancing through NPC dialog."] = {
        ["ptBR"] = "Ativa ou desativa o Questie avançando automaticamente através da caixa de diálogo do NPC",
        ["ruRU"] = "Включить/отключить автоматическое ведение диалога с NPC",
        ["deDE"] = "Aktiviert/Deaktiviert, ob Questie Dialoge mit NPCs automatisch durchführt",
        ["koKR"] = "NPC 대화 상자를 통해 자동으로 진행 중인 Questie를 활성화 또는 비활성화합니다.",
        ["esMX"] = "Habilita o deshabilita que Questie avanza automáticamente a través del diálogo PNJ",
        ["enUS"] = true,
        ["zhCN"] = "启用或禁用Questie自动和NPC的对话框。",
        ["zhTW"] = "啟用或停用任務位置提示插件的自動與 NPC 進行對話功能。",
        ["esES"] = "Habilita o deshabilita que Questie avanza automáticamente a través del diálogo PNJ",
        ["frFR"] = "Active/désactive l'avancement automatique des dialogues PNJ par Questie.",
    },
    ["Auto Modifier"] = {
        ["ptBR"] = "Edição automática",
        ["ruRU"] = "Авто-модификатор",
        ["deDE"] = "Auto Modifikator",
        ["koKR"] = "자동 수정",
        ["esMX"] = "Auto modificador",
        ["enUS"] = true,
        ["zhCN"] = "自动调整",
        ["zhTW"] = "自動輔助鍵",
        ["esES"] = "Auto modificador",
        ["frFR"] = "Modificateur Auto",
    },
    ["The modifier to NOT auto-accept/-complete quests when either option is enabled and you interact with a quest NPC."] = {
        ["ptBR"] = "O modificador para NÃO aceitar automaticamente / completar missões quando uma das opções está ativada e você interage com um PNJ de missão.",
        ["ruRU"] = "Клавиша, при зажатии которой автопринятие/автозавершение задания НЕ сработает при его принятии/завершении",
        ["deDE"] = "Die Taste, um Quests NICHT automatisch anzunehmen/abzugeben, wenn die jeweilige Einstellung aktiviert ist und mit einem Quest NPC interagiert wird.",
        ["koKR"] = "두 옵션 중 하나를 사용하고 사용자가 퀘스트 NPC와 상호 작용할 때 퀘스트를 자동 수락/완성하지 않음.",
        ["esMX"] = "El modificador para NO aceptar/completar automáticamente las misiones cuando cualquiera de las opciones está habilitada e interactúas con un asignador de misión.",
        ["enUS"] = true,
        ["zhCN"] = "当与NPC互动时，即便您已启用自动接受/自动完成，启用额外按键以触发对应功能.",
        ["zhTW"] = "與 NPC 互動時按住輔助鍵則 '不會' 自動接受/完成任務。",
        ["esES"] = "El modificador para NO aceptar/completar automáticamente las misiones cuando cualquiera de las opciones está habilitada e interactúas con un asignador de misión.",
        ["frFR"] = "Le modificateur pour NE PAS accepter/compléter automatiquement une quête lorsque l'une de ces options est active et que vous interagissez avec un PNJ de quête.",
    },
    ["Accept trivial (low level) quests"] = {
        ["ptBR"] = "Aceitar missões triviais (nível baixo)",
        ["ruRU"] = "Автопринятие низкоуровневых",
        ["deDE"] = "Triviale (niedrigstufige) Quests annehmen",
        ["koKR"] = "저레벨 퀘스트 수락",
        ["esMX"] = "Aceptar misiones triviales (de bajo nivel)",
        ["enUS"] = true,
        ["zhCN"] = "自动接受低级任务",
        ["zhTW"] = "接受不重要的 (低等級) 任務",
        ["esES"] = "Aceptar misiones triviales (de bajo nivel)",
        ["frFR"] = "Accepter les quêtes obsolètes (bas niveau)",
    },
    ["When this is enabled trivial (gray) quests will be auto accepted as well."] = {
        ["ptBR"] = "Quando isso estiver ativado, missões triviais (cinza) também serão aceitas automaticamente.",
        ["ruRU"] = "Включить/отключить автоматическое принятие заданий низкого уровня (серых)",
        ["deDE"] = "Aktiviert/Deaktiviert, ob Questie triviale (graune) Quests automatisch annimmt.",
        ["koKR"] = "이 옵션을 선택하면 저레벨(회색) 퀘스트도 자동으로 수락됩니다.",
        ["esMX"] = "Si está habilitado, las misiones triviales (grises) también se aceptarán automáticamente.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，低级（灰色）的任务也会被自动接受。",
        ["zhTW"] = "啟用時，也會自動接受不重要的 (灰色) 任務。",
        ["esES"] = "Si está habilitado, las misiones triviales (grises) también se aceptarán automáticamente.",
        ["frFR"] = "Étend l'acceptation automatique aux quêtes obsolètes (grises).",
    },
    ["Quest Level Options"] = {
        ["ptBR"] = "Opções de nível de missão",
        ["ruRU"] = "Настройки уровней заданий",
        ["deDE"] = "Questlevel-Einstellungen",
        ["koKR"] = "퀘스트 레벨 설정",
        ["esMX"] = "Opciones para el nivel de las misiones",
        ["enUS"] = true,
        ["zhCN"] = "任务等级选项",
        ["zhTW"] = "任務等級選項",
        ["esES"] = "Opciones para el nivel de las misiones",
        ["frFR"] = "Options du niveau des quêtes",
    },
    ["Show All Quests below range (Low level quests)"] = {
        ["ptBR"] = "Veja todas as missões abaixo (missões de nível inferior)",
        ["ruRU"] = "Низкоуровневые задания",
        ["deDE"] = "Zeige niedrigstufige Quests",
        ["koKR"] = "범위를 벗어난 모든 퀘스트 표시 (저레벨 퀘스트 표시)",
        ["esMX"] = "Mostrar todas las misiones por debajo del rango (Misiones de bajo nivel)",
        ["enUS"] = true,
        ["zhCN"] = "显示所有低等级任务",
        ["zhTW"] = "顯示所有低於此範圍的任務 (低等級任務)",
        ["esES"] = "Mostrar todas las misiones por debajo del rango (Misiones de bajo nivel)",
        ["frFR"] = "Afficher toutes les quêtes obsolètes",
    },
    ["Enable or disable showing of showing low level quests on the map."] = {
        ["ptBR"] = "Ative ou desative a exibição das missões de baixo nível exibidas no mapa.",
        ["ruRU"] = "Показать/скрыть низкоуровневые (серые) задания на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert niedrigstufige Quests auf der Karte",
        ["koKR"] = "퀘스트 표시 범위를 벗어난 저레벨 퀘스트도 모두 표시합니다.",
        ["esMX"] = "Habilita o deshabilita que se muestren misiones de bajo nivel en el mapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用后，在地图上显示低等级任务。",
        ["zhTW"] = "啟用或停用在地圖上顯示低等級任務。",
        ["esES"] = "Habilita o deshabilita que se muestren misiones de bajo nivel en el mapa.",
        ["frFR"] = "Active l'affichage de toutes les quêtes vertes et grises sur la carte.",
    },
    ["Enable manual minimum level offset"] = {
        ["ptBR"] = "Ativar deslocamento de nível mínimo manual",
        ["ruRU"] = "Ручное смещение мин. уровня",
        ["deDE"] = "Manuelles Minimallevel aktivieren",
        ["koKR"] = "저레벨 퀘스트 표시 범위 활성화",
        ["esMX"] = "Habilitar compensación de nivel mínimo manual",
        ["enUS"] = true,
        ["zhCN"] = "启用自定义最小任务等级",
        ["zhTW"] = "啟用手動調整最低等級",
        ["esES"] = "Habilitar compensación de nivel mínimo manual",
        ["frFR"] = "Régler manuellement l'écart de niveaux inférieurs",
    },
    ["Enable manual minimum level offset instead of the automatic GetQuestGreenLevel function."] = {
        ["ptBR"] = "Ativa o deslocamento de nível mínimo manual em vez da função automática GetQuestGreenLevel.",
        ["ruRU"] = "Включить/отключить ручное смещение минимального уровня заданий вместо автоматической функции 'зеленые задания'",
        ["deDE"] = "Aktiviert/Deaktiviert das manuelle Setzen eines Minimallevels anstatt die GetQuestGreenLevel zu verwenden.",
        ["koKR"] = "저레벨 퀘스트 표시 범위를 활성화합니다. 해당 범위 내의 퀘스트는 적정 레벨 퀘스트로 간주되어 녹색으로 표시됩니다.",
        ["esMX"] = "Habilite la compensación de nivel mínimo manual en lugar de la función automática GetQuestGreenLevel.",
        ["enUS"] = true,
        ["zhCN"] = "启用自定义最小任务等级，而不是自动获取绿色任务等级的功能.",
        ["zhTW"] = "啟用手動調整最低等級，而不是自動的 GetQuestGreenLevel 函數。",
        ["esES"] = "Habilite la compensación de nivel mínimo manual en lugar de la función automática GetQuestGreenLevel.",
        ["frFR"] = "Active le réglage manuel de l'écart maximal entre le niveau des quêtes de niveaux inférieurs et le votre. Par défaut toutes les quêtes vertes seront affichées et toutes les grises seront cachées.",
    },
    ["< Show below level"] = {
        ["ptBR"] = "<Mostrar o nível abaixo do nível>",
        ["ruRU"] = "Ниже вашего уровня",
        ["deDE"] = "< Zeige unter Level",
        ["koKR"] = "< 저레벨 퀘스트 표시 범위",
        ["esMX"] = "< Niveles por debajo",
        ["enUS"] = true,
        ["zhCN"] = "< 低于等级",
        ["zhTW"] = "< 顯示低於等級",
        ["esES"] = "< Niveles por debajo",
        ["frFR"] = "< Afficher sous le niveau",
    },
    ["How many levels below your character to show. ( Default: %s )"] = {
        ["ptBR"] = "Quantos níveis sobre o seu personagem para exibir. (Por defeito: %s",
        ["ruRU"] = "Отображение заданий, у которых уровень ниже, чем ваш уровень, на выбранное значение (по умолчанию: %s)",
        ["deDE"] = "Quests bis X Level unter deinem eigenen anzeigen. ( Standard: %s )",
        ["koKR"] = "현재 레벨보다 얼마나 낮은 퀘스트까지 표시할지 설정합니다. ( 기본값: %s )",
        ["esMX"] = "Cuantos niveles por debajo de tu personaje. ( Por defecto: %s )",
        ["enUS"] = true,
        ["zhCN"] = "显示比你低了多少级的任务（默认：%s）",
        ["zhTW"] = "要顯示低於你的角色多少等級以內的任務。(預設值: %s )",
        ["esES"] = "Cuantos niveles por debajo de tu personaje. ( Por defecto: %s )",
        ["frFR"] = "Définis l'écart maximal entre le niveau des quêtes et celui du joueur. (Par défaut : %s)",
    },
    ["Level from"] = {
        ["ptBR"] = "De Nível",
        ["ruRU"] = "Уровень от",
        ["deDE"] = "Level ab",
        ["koKR"] = "Level from",
        ["esMX"] = "De nivel",
        ["enUS"] = true,
        ["zhCN"] = "等级从",
        ["zhTW"] = "從等級",
        ["esES"] = "De nivel",
        ["frFR"] = "Du niveau :",
    },
    ["Minimum quest level to show."] = {
        ["ptBR"] = "Nível mínimo de missão para mostrar.",
        ["ruRU"] = "Минимальный уровень заданий для отображения",
        ["deDE"] = "Zeige Quests ab dem eingestellten Level.",
        ["koKR"] = "표시하는 최소 퀘스트 레벨",
        ["esMX"] = "Nivel mínimo de misión para mostrar.",
        ["enUS"] = true,
        ["zhCN"] = "显示最低任务等级。",
        ["zhTW"] = "要顯示的最低任務等級。",
        ["esES"] = "Nivel mínimo de misión para mostrar.",
        ["frFR"] = "Niveau minimum des quêtes à afficher.",
    },
    ["Level to"] = {
        ["ptBR"] = "Para Nível",
        ["ruRU"] = "Уровень до",
        ["deDE"] = "Level bis",
        ["koKR"] = "Level to",
        ["esMX"] = "A nivel",
        ["enUS"] = true,
        ["zhCN"] = "到等级",
        ["zhTW"] = "到等級",
        ["esES"] = "A nivel",
        ["frFR"] = "Au niveau :",
    },
    ["Maximum quest level to show."] = {
        ["ptBR"] = "Nível máximo de missões para mostrar.",
        ["ruRU"] = "Максимальный уровень заданий для отображения",
        ["deDE"] = "Zeige Quests bis zu dem eingestellten Level.",
        ["koKR"] = "표시하는 최고 퀘스트 레벨",
        ["esMX"] = "Máximo nivel de misión para mostrar.",
        ["enUS"] = true,
        ["zhCN"] = "显示最高任务等级",
        ["zhTW"] = "要顯示的最高任務等級。",
        ["esES"] = "Máximo nivel de misión para mostrar.",
        ["frFR"] = "Niveau maximum des quêtes à afficher.",
    },
    ["Enable absolute level range"] = {
        ["ptBR"] = "Ativar faixa de nível absoluto",
        ["ruRU"] = "Ручной диапазон",
        ["deDE"] = "Absolute Levelbegrenzung aktivieren",
        ["koKR"] = "Level 범위 표시",
        ["esMX"] = "Habilitar rango de nivel absoluto",
        ["enUS"] = true,
        ["zhCN"] = "任务等级范围",
        ["zhTW"] = "啟用絕對等級範圍",
        ["esES"] = "Habilitar rango de nivel absoluto",
        ["frFR"] = "Utiliser l'écart absolu",
    },
    ["Change the level offset to absolute level values."] = {
        ["ptBR"] = "Altere o deslocamento do nível para valores de nível absolutos.",
        ["ruRU"] = "Ручной выбор уровня отображаемых заданий",
        ["deDE"] = "Ändert die relative Levelbegrenzung zu einem absoluten Start- und Endwert.",
        ["koKR"] = "Level 오프셋을 절대 Level 값으로 변경합니다.",
        ["esMX"] = "Cambia la compensación de nivel a valores de nivel absoluto.",
        ["enUS"] = true,
        ["zhCN"] = "变更任务等级平均值成绝对任务等级范围值。",
        ["zhTW"] = "等級差距改為絕對數值。",
        ["esES"] = "Cambia la compensación de nivel a valores de nivel absoluto.",
        ["frFR"] = "Remlace l'écart de niveau par des valeurs absolues et affiche toutes les quêtes comprises entre les niveaux X et le niveau Y.",
    },
    ["Objective icon cluster amount"] = {
        ["ptBR"] = "Quantidade de ícones de objetivos",
        ["ruRU"] = "Группировка значков",
        ["deDE"] = "Ziel-Icon-Cluster-Menge",
        ["koKR"] = "퀘스트 목표 아이콘 합치기",
        ["esMX"] = "Cantidad de objetivos a agrupar",
        ["enUS"] = true,
        ["zhCN"] = "任务目标密度",
        ["zhTW"] = "任務目標圖示密集度",
        ["esES"] = "Cantidad de objetivos a agrupar",
        ["frFR"] = "Fusion des icônes des objectifs",
    },
    ["How much objective icons should cluster."] = {
        ["ptBR"] = "Quantos ícones de objetivos devem ser agrupados.",
        ["ruRU"] = "Установка количества значков целей, при котором значки будут группироваться",
        ["deDE"] = "Wie viele Ziel-Icons in einem Cluster gezeigt werden sollen.",
        ["koKR"] = "퀘스트 목표 아이콘을 몇개까지 합쳐서 보여줄지 설정합니다.",
        ["esMX"] = "Cuántos iconos de objetivo deberian agruparse.",
        ["enUS"] = true,
        ["zhCN"] = "目标图标代表多少怪",
        ["zhTW"] = "任務目標圖示代表多少怪。",
        ["esES"] = "Cuántos iconos de objetivo deberian agruparse.",
        ["frFR"] = "Définis le nombre d'icônes des objectifs proches les unes des autres à fusionner.",
    },
    ["Isle of Quel'Danas Phase"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза Острова Кель'Данас",
        ["deDE"] = "Insel von Quel'Danas Phase",
        ["koKR"] = false,
        ["esMX"] = "Fase de Isla of Quel'Danas",
        ["enUS"] = true,
        ["zhCN"] = "奎尔丹纳斯岛阶段",
        ["zhTW"] = "奎爾達納斯島階段",
        ["esES"] = "Fase de Isla of Quel'Danas",
        ["frFR"] = "Phase de L'île de Quel'Danas",
    },
    ["Select the phase fitting your realm progress on the Isle of Quel'Danas"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выбор фазы прогресса Острова Кель'Данас на вашем сервере",
        ["deDE"] = "Setz die Phase entsprechend des Fortschritts deines Servers",
        ["koKR"] = false,
        ["esMX"] = "Selecciona la fase que se ajuste al progreso de tu reino en la Isla de Quel'Danas",
        ["enUS"] = true,
        ["zhCN"] = "选择适合你在奎尔丹纳斯岛上阶段的任务进度",
        ["zhTW"] = "選擇符合你的伺服器在奎爾達納斯島上的任務階段。",
        ["esES"] = "Selecciona la fase que se ajuste al progreso de tu reino en la Isla de Quel'Danas",
        ["frFR"] = "Choisissez la phase correspondante à votre serveur pour la progression sur l'Ile de Quel'Danas",
    },
    ["Disable Phase reminder"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Отключить напоминание",
        ["deDE"] = "Phasen Erinnerung deaktivieren",
        ["koKR"] = false,
        ["esMX"] = "Deshabilitar recordatorio de fase",
        ["enUS"] = true,
        ["zhCN"] = "禁用进度提醒",
        ["zhTW"] = "停用階段提醒",
        ["esES"] = "Deshabilitar recordatorio de fase",
        ["frFR"] = "Désactiver le rappel de phase.",
    },
    ["Enable or disable the reminder on login to set the Isle of Quel'Danas phase"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Включить/отключить напоминание выбора фазы Острова Кель'Данас при входе в игру",
        ["deDE"] = "Aktiviert/Deaktiviert die Erinnerung beim Login die Phase für die Insel von Quel'Danas anzupassen",
        ["koKR"] = false,
        ["esMX"] = "Habilita o deshabilita el recordatorio al iniciar sesión para configurar la fase de la Isla de Quel'Danas",
        ["enUS"] = true,
        ["zhCN"] = "启用或禁用来设置登录时提醒奎尔丹纳斯岛的进度阶段",
        ["zhTW"] = "啟用或停用登入時提醒奎爾達納斯島上的任務階段。",
        ["esES"] = "Habilita o deshabilita el recordatorio al iniciar sesión para configurar la fase de la Isla de Quel'Danas",
        ["frFR"] = "Activer ou désactiver le rappel du choix de la phase sur l'Ile de Quel'Danas à la connection.",
    },
    ["Current active phase of Isle of Quel'Danas is '%s'. Check the General settings to change the phase or disable this message."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Текущая фаза Острова Кель'Данас: '%s'. Для изменения фазы или для отключения этого сообщения проверьте настройки (вкладка 'Общее').",
        ["deDE"] = "Aktuell aktive Phase auf der Insel von Quel'Danas ist '%s'. Zum Ändern der Phase oder dieser Erinnerung schau in die Allgemein Einstellungen.",
        ["koKR"] = false,
        ["esMX"] = "La fase activa actual de la Isla de Quel'Danas es '%s'. Verifique la configuración general para cambiar la fase o deshabilitar este mensaje.",
        ["enUS"] = true,
        ["zhCN"] = "启用或禁用设置登录时提醒奎尔丹纳斯岛当前阶段是'%s'。检查常规设置来更改阶段或禁用此消息。",
        ["zhTW"] = "奎爾達納斯島現在的進度是 '%s'，可以在一般設定中更改階段或是停用此訊息。",
        ["esES"] = "La fase activa actual de la Isla de Quel'Danas es '%s'. Verifique la configuración general para cambiar la fase o deshabilitar este mensaje.",
        ["frFR"] = "La phase actuelle de l'Ile de Quel Danas est '%s'. Vérifiez vos paramètres généraux pour la changer la phase en cours ou désactiver ce message.",
    },
    ["You picked up a quest from '%s'. Automatically switching to this phase..."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Вы приняли задание из '%s'. Автоматическое переключение на эту фазу...",
        ["deDE"] = "Du hast eine Quest aus '%s' angenommen. Es wird automatisch zu dieser Phase gewechselt...",
        ["koKR"] = false,
        ["esMX"] = "Elegiste una misión de '%s'. Cambiando automáticamente a esta fase...",
        ["enUS"] = true,
        ["zhCN"] = "你从'%s'那里接了一个任务，自动切换到这个阶段...",
        ["zhTW"] = "你和 '%s' 接了任務，自動切換到此階段...",
        ["esES"] = "Elegiste una misión de '%s'. Cambiando automáticamente a esta fase...",
        ["frFR"] = "Vous avez accepté la quête de ‘%s’. Changement automatique pour la phase …",
    },
    ["Phase 1 - Sun's Reach Sanctum"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 1 - Святилище Солнечного Края",
        ["deDE"] = "Phase 1 - Sanktum der Sonnenweiten",
        ["koKR"] = false,
        ["esMX"] = "Fase 1 - Sagrario de Tramo del Sol",
        ["enUS"] = true,
        ["zhCN"] = "第 1 阶段 - 攻占阳湾圣殿",
        ["zhTW"] = "階段 1 - 攻佔太陽海灣聖殿",
        ["esES"] = "Fase 1 - Sagrario de Tramo del Sol",
        ["frFR"] = "Phase 1 - Sanctum des confins du soleil",
    },
    ["Phase 2 - Activating the Sunwell Portal"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 2 - Портал в Шаттрате",
        ["deDE"] = "Phase 2 - Portal zur Insel von Quel'Danas",
        ["koKR"] = false,
        ["esMX"] = "Fase 2 - Activar el Portal de La Fuente del Sol",
        ["enUS"] = true,
        ["zhCN"] = "第 2 阶段 - 激活太阳之井大门",
        ["zhTW"] = "階段 2 - 啟動太陽之井傳送門",
        ["esES"] = "Fase 2 - Activar el Portal de La Fuente del Sol",
        ["frFR"] = "Phase 2 - Activer le portail du Puit du soleil",
    },
    ["Phase 2.1 - Sun's Reach Armory"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 2.1 - Оружейная",
        ["deDE"] = "Phase 2.1 - Waffenkammer der Sonnenweiten",
        ["koKR"] = false,
        ["esMX"] = "Fase 2.1 - Arsenal de Tramo del Sol",
        ["enUS"] = true,
        ["zhCN"] = "第 2.1 阶段 - 攻占阳湾军械库",
        ["zhTW"] = "階段 2.1 - 攻佔太陽海灣軍械庫",
        ["esES"] = "Fase 2.1 - Arsenal de Tramo del Sol",
        ["frFR"] = "Phase 2.1 - Armurerie des confins du soleil",
    },
    ["Phase 3 - Rebuilding the Anvil and Forge"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 3 - Наковальня и кузница",
        ["deDE"] = "Phase 3 - Schmiede und Amboss",
        ["koKR"] = false,
        ["esMX"] = "Fase 3 - Reconstruyendo el Yunque y la Forja",
        ["enUS"] = true,
        ["zhCN"] = "第 3 阶段 - 重建鐵砧和熔爐",
        ["zhTW"] = "階段 3 - 重建鐵砧和熔爐",
        ["esES"] = "Fase 3 - Reconstruyendo el Yunque y la Forja",
        ["frFR"] = "Phase 3 - Rebâtir la forge et l'enclume",
    },
    ["Phase 3.1 - Sun's Reach Harbor"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 3.1 - Гавань Солнечного Края",
        ["deDE"] = "Phase 3.1 - Hafen der Sonnenweiten",
        ["koKR"] = false,
        ["esMX"] = "Fase 3.1 - Puerto de Tramo del Sol",
        ["enUS"] = true,
        ["zhCN"] = "第 3.1 阶段 - 攻占阳湾港口",
        ["zhTW"] = "階段 3.1 - 攻佔太陽海灣港口",
        ["esES"] = "Fase 3.1 - Puerto de Tramo del Sol",
        ["frFR"] = "Phase 3.1 - Port des confins du soleil ",
    },
    ["Phase 4 - Creating the Alchemy Lab"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 4 - Лаборатория",
        ["deDE"] = "Phase 4 - Alchemielabor",
        ["koKR"] = false,
        ["esMX"] = "Fase 4 - Crear el laboratorio de alquimia",
        ["enUS"] = true,
        ["zhCN"] = "第 4 阶段 - 建设炼金实验室",
        ["zhTW"] = "階段 4 - 建設煉金實驗室",
        ["esES"] = "Fase 4 - Crear el laboratorio de alquimia",
        ["frFR"] = "Phase 4 - Créer le laboratoire d'alchimie",
    },
    ["Phase 4.1 - Building the Monument to the Fallen"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 4.1 - Монумент Павшим",
        ["deDE"] = "Phase 4.1 - Monument für die Gefallenen",
        ["koKR"] = false,
        ["esMX"] = "Fase 4.1 - Construcción del Monumento a los Caídos",
        ["enUS"] = true,
        ["zhCN"] = "第 4.1 阶段 - 为阵亡者建造纪念碑",
        ["zhTW"] = "階段 4.1 - 為陣亡者建造紀念碑",
        ["esES"] = "Fase 4.1 - Construcción del Monumento a los Caídos",
        ["frFR"] = "Phase 4.1 - Construire le monument aux morts",
    },
    ["Phase 4.2 - Sun's Reach"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 4.2 - Солнечный Край",
        ["deDE"] = "Phase 4.2 - Sonnenweiten",
        ["koKR"] = false,
        ["esMX"] = "Fase 4.2 - Tramo del Sol",
        ["enUS"] = true,
        ["zhCN"] = "第 4.2 阶段 - 破碎残阳的延伸",
        ["zhTW"] = "階段 4.2 - 破碎殘陽的延伸",
        ["esES"] = "Fase 4.2 - Tramo del Sol",
        ["frFR"] = "Phase 4.2 - Confins du soleil",
    },
    ["Phase 5"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Фаза 5",
        ["deDE"] = true,
        ["koKR"] = false,
        ["esMX"] = "Fase 5",
        ["enUS"] = true,
        ["zhCN"] = "第 5 阶段",
        ["zhTW"] = "階段 5",
        ["esES"] = "Fase 5",
        ["frFR"] = true,
    },
    ["Sounds"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Звуки",
        ["deDE"] = true,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "音效",
        ["zhTW"] = "音效",
        ["esES"] = false,
        ["frFR"] = "Sons",
    },
    ["Play a short sound when completing a quest when it is ready to turn in."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Воспроизводить короткий звук при выполнении задания, обозначая готовность его сдачи",
        ["deDE"] = "Spielt einen kurzen Ton, wenn eine Quest fertig ist und abgegeben werden kann.",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "完成任务可以接回的时候播放音效。",
        ["zhTW"] = "完成任務可以接回的時候播放音效。",
        ["esES"] = false,
        ["frFR"] = "Jouer un court son lorsqu'une quête est complétée et prête à rendre.",
    },
    ["Quest objective completed"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Цель задания выполнена",
        ["deDE"] = "Quest-Ziel abgeschlossen",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "达成任务目标",
        ["zhTW"] = "達成任務目標",
        ["esES"] = false,
        ["frFR"] = "Objectif de quête complété",
    },
    ["Play a short sound when completing a quest objective."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Воспроизводить короткий звук при выполнении цели задания",
        ["deDE"] = "Spielt einen kurzen Ton, wenn ein Quest-Ziel abgeschlossen ist.",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "完成任务目标时播放音效。",
        ["zhTW"] = "完成任務目標時播放音效。",
        ["esES"] = false,
        ["frFR"] = "Jouer un court son lorsqu'un objectif de quête est complété.",
    },
    ["Quest Complete Sound Selection"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выбор звука",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "选择任务完成音效",
        ["zhTW"] = "選擇任務完成音效",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The sound you hear when a quest is completed"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Звук при выполнении задания",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务完成时听到的音效。",
        ["zhTW"] = "任務完成時聽到的音效。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Objective Complete Sound Selection"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выбор звука",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "选择任务目标达成音效",
        ["zhTW"] = "選擇任務目標達成音效",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The sound you hear when an objective is completed"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Звук при выполнении цели задания",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务目标达成时听到的音效。",
        ["zhTW"] = "任務目標達成時聽到的音效。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Quest objective progress"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Прогресс цели задания",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务进度",
        ["zhTW"] = "任務目標進度",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Play a short sound when making progress on a quest objective."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Воспроизводить короткий звук при прогрессе цели задания",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务有进度时播放音效。",
        ["zhTW"] = "任務目標有進度時播放音效。",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Objective Progress Sound Selection"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Выбор звука",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "选择任务进度音效",
        ["zhTW"] = "選擇任務目標進度音效",
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["The sound you hear when you make progress on a quest objective"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Звук при прогрессе цели задания",
        ["deDE"] = false,
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = "任务有进度时听到的音效。",
        ["zhTW"] = "任務目標有進度時聽到的音效。",
        ["esES"] = false,
        ["frFR"] = false,
    },
}

for k, v in pairs(generalOptionsLocales) do
    l10n.translations[k] = v
end
