---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local outlandLocales = {
    ["Wrathscale Lair"] = {
        ["ptBR"] = "Covil dos Escamódios",
        ["ruRU"] = "Логово клана Зловещей Чешуи",
        ["deDE"] = "Hassprankenzuflucht",
        ["koKR"] = "성난비늘 둥지",
        ["esMX"] = "Guarida Escama de Cólera",
        ["enUS"] = true,
        ["frFR"] = "Repaire des Irécailles",
        ["esES"] = "Guarida Escama de Cólera",
        ["zhTW"] = "怒鱗巢穴",
        ["zhCN"] = "怒鳞巢穴",
    },
    ["Wayne's Refuge"] = {
        ["ptBR"] = "Refúgio de Wayne",
        ["ruRU"] = "Приют Уэйна",
        ["deDE"] = "Waynes Zuflucht",
        ["koKR"] = "웨인의 은거처",
        ["esMX"] = "Refugio de Wayne",
        ["enUS"] = true,
        ["frFR"] = "Refuge de Wayne",
        ["esES"] = "Refugio de Wayne",
        ["zhTW"] = "韋恩的避難所",
        ["zhCN"] = "韦恩的避难所",
    },
    ["Tranquil Shore"] = {
        ["ptBR"] = "Costa Plácida",
        ["ruRU"] = "Безмятежный берег",
        ["deDE"] = "Die stille Küste",
        ["koKR"] = "평온의 해변",
        ["esMX"] = "Orilla Tranquila",
        ["enUS"] = true,
        ["frFR"] = "Rivage paisible",
        ["esES"] = "Orilla Tranquila",
        ["zhTW"] = "寧靜海岸",
        ["zhCN"] = "静谧海岸",
    },
    ["Auren Falls"] = {
        ["ptBR"] = "Cachoeira Auren",
        ["ruRU"] = "Водопад Аурен",
        ["deDE"] = "Aurenfälle",
        ["koKR"] = "아우렌 폭포",
        ["esMX"] = "Cascadas Auren",
        ["enUS"] = true,
        ["frFR"] = "Chutes d'Auren",
        ["esES"] = "Cascadas Auren",
        ["zhTW"] = "奧倫瀑布",
        ["zhCN"] = "奥伦瀑布",
    },
    ["Coilskar Point"] = {
        ["ptBR"] = "Pontal dos Serpentálios",
        ["ruRU"] = "Лагерь Змеиных Колец",
        ["deDE"] = "Echsennarbe",
        ["koKR"] = "갈퀴흉터 거점",
        ["esMX"] = "Alto Cicatriz Espiral",
        ["enUS"] = true,
        ["frFR"] = "Halte de Glissentaille",
        ["esES"] = "Alto Cicatriz Espiral",
        ["zhTW"] = "考斯卡崗哨",
        ["zhCN"] = "库斯卡岗哨",
    },
    ["The Sacred Grove"] = {
        ["ptBR"] = "Bosque Sagrado",
        ["ruRU"] = "Священная роща",
        ["deDE"] = "Der heilige Hain",
        ["koKR"] = "신성한 숲",
        ["esMX"] = "La Arboleda Sagrada",
        ["enUS"] = true,
        ["frFR"] = "Le Bosquet sacré",
        ["esES"] = "La Arboleda Sagrada",
        ["zhTW"] = "神聖樹林",
        ["zhCN"] = "元素圣谷",
    },
    ["Sun's Reach Armory"] = {
        ["ptBR"] = "Armaria de Beirassol",
        ["ruRU"] = "Оружейная Солнечного Края",
        ["deDE"] = "Waffenkammer der Sonnenweiten",
        ["koKR"] = "태양너울 무기고",
        ["esMX"] = "Arsenal de Tramo del Sol",
        ["enUS"] = true,
        ["frFR"] = "Armurerie des Confins du soleil",
        ["esES"] = "Arsenal de Tramo del Sol",
        ["zhTW"] = "日境軍械庫",
        ["zhCN"] = "阳湾军械库",
    },
    ["Wizard Row"] = {
        ["ptBR"] = "Estreito do Teurgo",
        ["ruRU"] = "Путь Волшебника",
        ["deDE"] = "Zaubergasse",
        ["koKR"] = "마법사 지구",
        ["esMX"] = "Pasaje del Zahorí",
        ["enUS"] = true,
        ["frFR"] = "Allée des sorciers",
        ["esES"] = "Pasaje del Zahorí",
        ["zhTW"] = "巫師街",
        ["zhCN"] = "巫师街",
    },
    ["Portal Clearing"] = {
        ["ptBR"] = "Clareira do Portal",
        ["ruRU"] = "Прогалина с порталом",
        ["deDE"] = "Portalsicherung",
        ["koKR"] = "차원문 폐허",
        ["esMX"] = "Portal del Claro",
        ["enUS"] = true,
        ["frFR"] = "Clairière du portail",
        ["esES"] = "Portal del Claro",
        ["zhTW"] = "暮光之門",
        ["zhCN"] = "荒弃传送门",
    },
    ["The Bloodoath"] = {
        ["ptBR"] = "O Pacto de Sangue",
        ["ruRU"] = "Кровавая Клятва",
        ["deDE"] = "Die Blutschwur",
        ["koKR"] = "피의 맹세호",
        ["esMX"] = "El Juramento de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Le Serment de sang",
        ["esES"] = "El Juramento de Sangre",
        ["zhTW"] = "血之誓約",
        ["zhCN"] = "血誓号",
    },
    ["Skald"] = {
        ["ptBR"] = "Skald",
        ["ruRU"] = "Гарь",
        ["deDE"] = "Skald",
        ["koKR"] = "불타버린 언덕",
        ["esMX"] = "Skald",
        ["enUS"] = true,
        ["frFR"] = "Skald",
        ["esES"] = "Skald",
        ["zhTW"] = "斯卡德",
        ["zhCN"] = "焦火荒野",
    },
    ["Reaver's Fall"] = {
        ["ptBR"] = "Posto dos Destroços",
        ["ruRU"] = "Гибель Сквернобота",
        ["deDE"] = "Häschersturz",
        ["koKR"] = "지옥절단기 함락지",
        ["esMX"] = "Caída del Atracador Vil",
        ["enUS"] = true,
        ["frFR"] = "Le Trépas du saccageur",
        ["esES"] = "Caída del Atracador Vil",
        ["zhTW"] = "搶奪者荒野",
        ["zhCN"] = "机甲残骸",
    },
    ["Ring of Observance"] = {
        ["ptBR"] = "Círculo da Obediência",
        ["ruRU"] = "Ритуальный Круг",
        ["deDE"] = "Ring der Beobachtung",
        ["koKR"] = "규율의 광장",
        ["esMX"] = "Círculo de la Observancia",
        ["enUS"] = true,
        ["frFR"] = "Cercle d'observance",
        ["esES"] = "Círculo de la Observancia",
        ["zhTW"] = "儀式競技場",
        ["zhCN"] = "仪式广场",
    },
    ["Lake Sunspring"] = {
        ["ptBR"] = "Lago Solavera",
        ["ruRU"] = "Озеро Солнечного Источника",
        ["deDE"] = "Sonnenwindsee",
        ["koKR"] = "태양여울 호수",
        ["esMX"] = "Lago Primasol",
        ["enUS"] = true,
        ["frFR"] = "Lac Berceau-de-l'Eté",
        ["esES"] = "Lago Primasol",
        ["zhTW"] = "日春湖",
        ["zhCN"] = "日泉湖",
    },
    ["Northmaul Tower"] = {
        ["ptBR"] = "Torre Martelo do Norte",
        ["ruRU"] = "Башня Северного Молота",
        ["deDE"] = "Nordschlägerturm",
        ["koKR"] = "북녘망치 탑",
        ["esMX"] = "Torre Quiebranorte",
        ["enUS"] = true,
        ["frFR"] = "Tour Nord-sanglante",
        ["esES"] = "Torre Quiebranorte",
        ["zhTW"] = "北槌哨塔",
        ["zhCN"] = "北槌哨塔",
    },
    ["Town Square"] = {
        ["ptBR"] = "Praça da Cidade",
        ["ruRU"] = "Городская площадь",
        ["deDE"] = "Ratsplatz",
        ["koKR"] = "마을 광장",
        ["esMX"] = "Plaza de la Ciudad",
        ["enUS"] = true,
        ["frFR"] = "Place centrale",
        ["esES"] = "Plaza de la Ciudad",
        ["zhTW"] = "小鎮廣場",
        ["zhCN"] = "城镇广场",
    },
    ["Aldor Rise"] = {
        ["ptBR"] = "Terraço dos Aldor",
        ["ruRU"] = "Возвышенность Алдоров",
        ["deDE"] = "Aldorhöhe",
        ["koKR"] = "알도르 마루",
        ["esMX"] = "Alto Aldor",
        ["enUS"] = true,
        ["frFR"] = "Éminence de l'Aldor",
        ["esES"] = "Alto Aldor",
        ["zhTW"] = "奧多爾高地",
        ["zhCN"] = "奥尔多高地",
    },
    ["Zeth'Gor"] = {
        ["ptBR"] = "Zeth'Gor",
        ["ruRU"] = "Зет'Гор",
        ["deDE"] = "Zeth'Gor",
        ["koKR"] = "제스고르",
        ["esMX"] = "Zeth'Gor",
        ["enUS"] = true,
        ["frFR"] = "Zeth'Gor",
        ["esES"] = "Zeth'Gor",
        ["zhTW"] = "薩斯葛爾",
        ["zhCN"] = "塞斯高",
    },
    ["Vindicator's Rest"] = {
        ["ptBR"] = "Recanto do Vindicante",
        ["ruRU"] = "Привал Защитника",
        ["deDE"] = "Verteidigers Ruh'",
        ["koKR"] = "구원자의 안식처",
        ["esMX"] = "El Reposo del Vindicador",
        ["enUS"] = true,
        ["frFR"] = "Repos du redresseur de torts",
        ["esES"] = "El Reposo del Vindicador",
        ["zhTW"] = "復仇者之陵",
        ["zhCN"] = "守备官营地",
    },
    ["Ruins of Baa'ri"] = {
        ["ptBR"] = "Ruínas de Baa'ri",
        ["ruRU"] = "Руины Баа'ри",
        ["deDE"] = "Ruinen von Baa'ri",
        ["koKR"] = "바아리 폐허",
        ["esMX"] = "Ruinas de Baa'ri",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Baa'ri",
        ["esES"] = "Ruinas de Baa'ri",
        ["zhTW"] = "巴瑞廢墟",
        ["zhCN"] = "巴尔里废墟",
    },
    ["Invasion Point: Overlord"] = {
        ["ptBR"] = "Ponto de Invasão: Lorde supremo",
        ["ruRU"] = "Точка вторжения: Властитель",
        ["deDE"] = "Invasionspunkt: Oberanführer",
        ["koKR"] = "대군주의 침공 거점",
        ["esMX"] = "Punto de Invasión: Señor Supremo",
        ["enUS"] = true,
        ["frFR"] = "Site d'invasion : Suzerain",
        ["esES"] = "Punto de Invasión: Señor Supremo",
        ["zhTW"] = "侵略點:主宰者",
        ["zhCN"] = "登陆场：霸王",
    },
    ["Blackwind Lake"] = {
        ["ptBR"] = "Lago Ventonegro",
        ["ruRU"] = "Озеро Черного Ветра",
        ["deDE"] = "Schattenwindsee",
        ["koKR"] = "검은바람 호수",
        ["esMX"] = "Lago Vientonegro",
        ["enUS"] = true,
        ["frFR"] = "Lac Noirvent",
        ["esES"] = "Lago Vientonegro",
        ["zhTW"] = "黑風湖",
        ["zhCN"] = "黑风湖",
    },
    ["Ammen Fields"] = {
        ["ptBR"] = "Campos Ammen",
        ["ruRU"] = "Поля Аммен",
        ["deDE"] = "Am'menfelder",
        ["koKR"] = "암멘 들판",
        ["esMX"] = "Campos Ammen",
        ["enUS"] = true,
        ["frFR"] = "Champs d'Ammen",
        ["esES"] = "Campos Ammen",
        ["zhTW"] = "安曼牧場",
        ["zhCN"] = "埃门平原",
    },
    ["Windyreed Village"] = {
        ["ptBR"] = "Aldeia Canavento",
        ["ruRU"] = "Деревня Трепещущего Тростника",
        ["deDE"] = "Schilftanz",
        ["koKR"] = "바람갈대 마을",
        ["esMX"] = "Aldea Junco Alabeado",
        ["enUS"] = true,
        ["frFR"] = "Ventejonc",
        ["esES"] = "Aldea Junco Alabeado",
        ["zhTW"] = "風蘆村",
        ["zhCN"] = "风茅村",
    },
    ["Umbrafen Lake"] = {
        ["ptBR"] = "Lago Charco Sombrio",
        ["ruRU"] = "Озеро Тенетопь",
        ["deDE"] = "Umbrafennsee",
        ["koKR"] = "그늘늪 호수",
        ["esMX"] = "Lago Umbropantano",
        ["enUS"] = true,
        ["frFR"] = "Lac Umbretourbe",
        ["esES"] = "Lago Umbropantano",
        ["zhTW"] = "昂布拉凡湖",
        ["zhCN"] = "暗泽湖",
    },
    ["An'owyn"] = {
        ["ptBR"] = "An'owyn",
        ["ruRU"] = "Ан'овин",
        ["deDE"] = "An'owyn",
        ["koKR"] = "안오윈",
        ["esMX"] = "An'owyn",
        ["enUS"] = true,
        ["frFR"] = "An'owyn",
        ["esES"] = "An'owyn",
        ["zhTW"] = "安歐恩",
        ["zhCN"] = "安欧维恩",
    },
    ["Axxarien"] = {
        ["ptBR"] = "Axxarien",
        ["ruRU"] = "Аксариен",
        ["deDE"] = "Axxarien",
        ["koKR"] = "악사리엔",
        ["esMX"] = "Axxarien",
        ["enUS"] = true,
        ["frFR"] = "Axxarien",
        ["esES"] = "Axxarien",
        ["zhTW"] = "艾克薩瑞安",
        ["zhCN"] = "阿克萨林",
    },
    ["Ruins of Silvermoon"] = {
        ["ptBR"] = "Ruínas de Luaprata",
        ["ruRU"] = "Руины Луносвета",
        ["deDE"] = "Ruinen von Silbermond",
        ["koKR"] = "실버문 폐허",
        ["esMX"] = "Ruinas de Lunargenta",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Lune-d'argent",
        ["esES"] = "Ruinas de Lunargenta",
        ["zhTW"] = "銀月廢墟",
        ["zhCN"] = "银月城废墟",
    },
    ["The Scrap Field"] = {
        ["ptBR"] = "Campo dos Refugos",
        ["ruRU"] = "Захламленное поле",
        ["deDE"] = "Das Trümmerfeld",
        ["koKR"] = "고철 지대",
        ["esMX"] = "El Campo de Sobras",
        ["enUS"] = true,
        ["frFR"] = "La Ferraille",
        ["esES"] = "El Campo de Sobras",
        ["zhTW"] = "廢棄農場",
        ["zhCN"] = "废料场",
    },
    ["Derelict Manor"] = {
        ["ptBR"] = "Mansão Arruinada",
        ["ruRU"] = "Заброшенное поместье",
        ["deDE"] = "Heruntergekommenes Anwesen",
        ["koKR"] = "버려진 장원",
        ["esMX"] = "Mansión Derelicta",
        ["enUS"] = true,
        ["frFR"] = "Manoir abandonné",
        ["esES"] = "Masión Derelicta",
        ["zhTW"] = "遺棄的莊園",
        ["zhCN"] = "荒弃的庄园",
    },
    ["The Stormspire"] = {
        ["ptBR"] = "Pináculo da Tempestade",
        ["ruRU"] = "Штормовая Вершина",
        ["deDE"] = "Die Sturmsäule",
        ["koKR"] = "폭풍 첨탑",
        ["esMX"] = "La Flecha de la Tormenta",
        ["enUS"] = true,
        ["frFR"] = "La Foudreflèche",
        ["esES"] = "La Flecha de la Tormenta",
        ["zhTW"] = "風暴之尖",
        ["zhCN"] = "风暴尖塔",
    },
    ["The Cryo-Core"] = {
        ["ptBR"] = "Crio-núcleo",
        ["ruRU"] = "Криогенный блок",
        ["deDE"] = "Der Kryokern",
        ["koKR"] = "극저온 핵",
        ["esMX"] = "El Crionúcleo",
        ["enUS"] = true,
        ["frFR"] = "Le cryocœur",
        ["esES"] = "El Crionúcleo",
        ["zhTW"] = "冬眠核心",
        ["zhCN"] = "冷却核心",
    },
    ["Sanctum of the Moon"] = {
        ["ptBR"] = "Sacrário Lunar",
        ["ruRU"] = "Святилище Луны",
        ["deDE"] = "Sanktum des Mondes",
        ["koKR"] = "달의 성소",
        ["esMX"] = "Sagrario de la Luna",
        ["enUS"] = true,
        ["frFR"] = "Sanctum de la Lune",
        ["esES"] = "Sagrario de la Luna",
        ["zhTW"] = "明月聖所",
        ["zhCN"] = "月亮圣殿",
    },
    ["Blackwind Valley"] = {
        ["ptBR"] = "Vale Ventonegro",
        ["ruRU"] = "Долина Черного Ветра",
        ["deDE"] = "Schattenwindtal",
        ["koKR"] = "검은바람 계곡",
        ["esMX"] = "Valle Vientonegro",
        ["enUS"] = true,
        ["frFR"] = "Vallée de Noirvent",
        ["esES"] = "Valle Vientonegro",
        ["zhTW"] = "黑風谷",
        ["zhCN"] = "黑风谷",
    },
    ["Throne of the Elements"] = {
        ["ptBR"] = "Trono dos Elementos",
        ["ruRU"] = "Трон стихий",
        ["deDE"] = "Thron der Elemente",
        ["koKR"] = "정령의 옥좌",
        ["esMX"] = "El Trono de los Elementos",
        ["enUS"] = true,
        ["frFR"] = "Trône des éléments",
        ["esES"] = "El Trono de los Elementos",
        ["zhTW"] = "元素王座",
        ["zhCN"] = "元素王座",
    },
    ["Forge Camp: Rage"] = {
        ["ptBR"] = "Campo-forja: Raiva",
        ["ruRU"] = "Лагерь Легиона: Ярость",
        ["deDE"] = "Konstruktionslager: Zorn",
        ["koKR"] = "분노의 괴철로 기지",
        ["esMX"] = "Campamento Forja: Ira",
        ["enUS"] = true,
        ["frFR"] = "Camp de forge : Rage",
        ["esES"] = "Campamento Forja: Ira",
        ["zhTW"] = "煉冶場:狂怒",
        ["zhCN"] = "铸魔营地：狂乱",
    },
    ["Toryl Estate"] = {
        ["ptBR"] = "Propriedade Toryl",
        ["ruRU"] = "Имение Торила",
        ["deDE"] = "Toryls Grund",
        ["koKR"] = "토릴 영지",
        ["esMX"] = "Los Dominios Toryl",
        ["enUS"] = true,
        ["frFR"] = "Domaine de Toryl",
        ["esES"] = "Los Dominios Toryl",
        ["zhTW"] = "托爾莊園",
        ["zhCN"] = "托尔里公馆",
    },
    ["The Low Path"] = {
        ["ptBR"] = "Estrada Baixa",
        ["ruRU"] = "Нижний путь",
        ["deDE"] = "Der Niederpfad",
        ["koKR"] = "낮은길",
        ["esMX"] = "El Paso Bajo",
        ["enUS"] = true,
        ["frFR"] = "Le Bas chemin",
        ["esES"] = "El Paso Bajo",
        ["zhTW"] = "粗劣之地",
        ["zhCN"] = "山谷小径",
    },
    ["Wyrmskull Tunnel"] = {
        ["ptBR"] = "Túnel Caveira de Dragão",
        ["ruRU"] = "Туннель Драконьего Черепа",
        ["deDE"] = "Tunnel des Wyrmschädels",
        ["koKR"] = "고룡해골 굴",
        ["esMX"] = "Túnel Calavermis",
        ["enUS"] = true,
        ["frFR"] = "Tunnel Crâne-du-ver",
        ["esES"] = "Túnel Calavermis",
        ["zhTW"] = "龍骨隧道",
        ["zhCN"] = "龙颅小径",
    },
    ["Zeb'Watha"] = {
        ["ptBR"] = "Zeb'Watha",
        ["ruRU"] = "Зеб'Вата",
        ["deDE"] = "Zeb'Watha",
        ["koKR"] = "제브와타",
        ["esMX"] = "Zeb'Watha",
        ["enUS"] = true,
        ["frFR"] = "Zeb'Watha",
        ["esES"] = "Zeb'Watha",
        ["zhTW"] = "拉伯瓦薩",
        ["zhCN"] = "塞布瓦萨",
    },
    ["The Bone Wastes"] = {
        ["ptBR"] = "Deserto de Ossos",
        ["ruRU"] = "Костяные пустоши",
        ["deDE"] = "Die Knochenwüste",
        ["koKR"] = "해골 무덤",
        ["esMX"] = "El Vertedero de Huesos",
        ["enUS"] = true,
        ["frFR"] = "Le désert des Ossements",
        ["esES"] = "El Vertedero de Huesos",
        ["zhTW"] = "白骨荒野",
        ["zhCN"] = "白骨荒野",
    },
    ["Obsidia's Perch"] = {
        ["ptBR"] = "Ninho de Obsídia",
        ["ruRU"] = "Гнездо Обсидии",
        ["deDE"] = "Obsidias Hort",
        ["koKR"] = "옵시디아의 둥지",
        ["esMX"] = "Nido de Obsidia",
        ["enUS"] = true,
        ["frFR"] = "Perchoir d'Obsidia",
        ["esES"] = "Nido de Obsidia",
        ["zhTW"] = "歐比希迪亞棲所",
        ["zhCN"] = "欧比斯迪栖木",
    },
    ["Invasion Point: Destroyer"] = {
        ["ptBR"] = "Ponto de Invasão: Destruidor",
        ["ruRU"] = "Точка вторжения: Разрушитель",
        ["deDE"] = "Invasionspunkt: Zerstörer",
        ["koKR"] = "파괴자의 침공 거점",
        ["esMX"] = "Punto de Invasión: Destructor",
        ["enUS"] = true,
        ["frFR"] = "Site d'invasion : Destructeur",
        ["esES"] = "Punto de Invasión: Destructor",
        ["zhTW"] = "侵略點:摧毀者",
        ["zhCN"] = "登陆场：破坏",
    },
    ["The Stadium"] = {
        ["ptBR"] = "O Estádio",
        ["ruRU"] = "Ристалище",
        ["deDE"] = "Das Stadion",
        ["koKR"] = "경기장",
        ["esMX"] = "El Estadium",
        ["enUS"] = true,
        ["frFR"] = "Le Stade",
        ["esES"] = "El Estadium",
        ["zhTW"] = "競技場",
        ["zhCN"] = "竞赛场",
    },
    ["Sha'naari Wastes"] = {
        ["ptBR"] = "Deserto Sha'naari",
        ["ruRU"] = "Пустоши Ша'наари",
        ["deDE"] = "Weiten von Sha'naari",
        ["koKR"] = "샤나아리 황무지",
        ["esMX"] = "Ruinas Sha'naari",
        ["enUS"] = true,
        ["frFR"] = "Le désert Sha'naari",
        ["esES"] = "Ruinas Sha'naari",
        ["zhTW"] = "夏納瑞荒地",
        ["zhCN"] = "沙纳尔荒地",
    },
    ["Kil'sorrow Fortress"] = {
        ["ptBR"] = "Fortaleza Kil'pesar",
        ["ruRU"] = "Бастион Вечной Скорби",
        ["deDE"] = "Festung Kil'sorge",
        ["koKR"] = "킬소로우 요새",
        ["esMX"] = "Fortaleza Mata'penas",
        ["enUS"] = true,
        ["frFR"] = "Forteresse Kil'sorrau",
        ["esES"] = "Fortaleza Mata'penas",
        ["zhTW"] = "吉爾索洛堡壘",
        ["zhCN"] = "基尔索罗堡垒",
    },
    ["Celestial Ridge"] = {
        ["ptBR"] = "Pico Celestial",
        ["ruRU"] = "Небесная гряда",
        ["deDE"] = "Sternensturz",
        ["koKR"] = "하늘 마루",
        ["esMX"] = "Cresta Celestial",
        ["enUS"] = true,
        ["frFR"] = "Crête céleste",
        ["esES"] = "Cresta Celestial",
        ["zhTW"] = "天國山脈",
        ["zhCN"] = "苍穹之脊",
    },
    ["Test"] = {
        ["ptBR"] = "Test",
        ["ruRU"] = "Тест",
        ["deDE"] = "Test",
        ["koKR"] = "시험용",
        ["esMX"] = "Test",
        ["enUS"] = true,
        ["frFR"] = "Test",
        ["esES"] = "Test",
        ["zhTW"] = "Test",
        ["zhCN"] = "Test",
    },
    ["Ruins of Karabor"] = {
        ["ptBR"] = "Ruínas de Karabor",
        ["ruRU"] = "Руины Карабора",
        ["deDE"] = "Ruinen von Karabor",
        ["koKR"] = "카라보르 폐허",
        ["esMX"] = "Ruinas de Karabor",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Karabor",
        ["esES"] = "Ruinas de Karabor",
        ["zhTW"] = "卡拉伯爾廢墟",
        ["zhCN"] = "卡拉波废墟",
    },
    ["Skulking Row"] = {
        ["ptBR"] = "Passeio Furtivo",
        ["ruRU"] = "Обводной путь",
        ["deDE"] = "Lauergasse",
        ["koKR"] = "위험한 거리",
        ["esMX"] = "El Frontal de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Allée de la rôdaille",
        ["esES"] = "El Frontal de la Muerte",
        ["zhTW"] = "潛隱路",
        ["zhCN"] = "匿影小径",
    },
    ["Shadow Ridge"] = {
        ["ptBR"] = "Serra das Sombras",
        ["ruRU"] = "Хребет Теней",
        ["deDE"] = "Schattenkamm",
        ["koKR"] = "어둠 마루",
        ["esMX"] = "Cresta de las Sombras",
        ["enUS"] = true,
        ["frFR"] = "Ombrecrête",
        ["esES"] = "Cresta de las Sombras",
        ["zhTW"] = "暗影山脊",
        ["zhCN"] = "暗影山",
    },
    ["Nestlewood Thicket"] = {
        ["ptBR"] = "Mata Ninhal",
        ["ruRU"] = "Совиная чаща",
        ["deDE"] = "Nisteldickicht",
        ["koKR"] = "다닥나무 숲",
        ["esMX"] = "Matorral Cubrebosque",
        ["enUS"] = true,
        ["frFR"] = "Fourré des Nidebois",
        ["esES"] = "Matorral Cubrebosque",
        ["zhTW"] = "奈斯特灌木林",
        ["zhCN"] = "木巢林地",
    },
    ["Nestlewood Hills"] = {
        ["ptBR"] = "Serra do Ninhal",
        ["ruRU"] = "Совиные холмы",
        ["deDE"] = "Nistelhügel",
        ["koKR"] = "다닥나무 언덕",
        ["esMX"] = "Colinas Cubrebosque",
        ["enUS"] = true,
        ["frFR"] = "Collines des Nidebois",
        ["esES"] = "Colinas Cubrebosque",
        ["zhTW"] = "奈斯特山丘",
        ["zhCN"] = "木巢山",
    },
    ["Traitor's Cove"] = {
        ["ptBR"] = "Angra do Traidor",
        ["ruRU"] = "Бухта Изменника",
        ["deDE"] = "Verräterbucht",
        ["koKR"] = "배신자의 만",
        ["esMX"] = "Cala del Traidor",
        ["enUS"] = true,
        ["frFR"] = "Crique du traître",
        ["esES"] = "Cala del Traidor",
        ["zhTW"] = "背叛者海灣",
        ["zhCN"] = "叛徒湾",
    },
    ["Auren Ridge"] = {
        ["ptBR"] = "Pico Auren",
        ["ruRU"] = "Гряда Аурен",
        ["deDE"] = "Aurenkamm",
        ["koKR"] = "아우렌 마루",
        ["esMX"] = "Cresta Auren",
        ["enUS"] = true,
        ["frFR"] = "Crête d'Auren",
        ["esES"] = "Cresta Auren",
        ["zhTW"] = "奧倫山脊",
        ["zhCN"] = "奥伦山脊",
    },
    ["Dustquill Ravine"] = {
        ["ptBR"] = "Ravina do Pó de Espinheiro",
        ["ruRU"] = "Лощина Пыльного Пера",
        ["deDE"] = "Staubstachelschlucht",
        ["koKR"] = "먼지깃 협곡",
        ["esMX"] = "Barranco Pluma Polvorienta",
        ["enUS"] = true,
        ["frFR"] = "Ravin de Plumepoussière",
        ["esES"] = "Barranco Pluma Polvorienta",
        ["zhTW"] = "塵羽峽谷",
        ["zhCN"] = "尘羽峡谷",
    },
    ["Veil Reskk"] = {
        ["ptBR"] = "Véu Reskk",
        ["ruRU"] = "Гнездовье Ресск",
        ["deDE"] = "Reskkversteck",
        ["koKR"] = "장막의 레스크",
        ["esMX"] = "Velo Reskk",
        ["enUS"] = true,
        ["frFR"] = "Voile Reskk",
        ["esES"] = "Velo Reskk",
        ["zhTW"] = "迷霧瑞斯克",
        ["zhCN"] = "里斯克鸦巢",
    },
    ["The Proving Grounds"] = {
        ["ptBR"] = "Campo de Testes",
        ["ruRU"] = "Испытательный полигон",
        ["deDE"] = "Die Versuchsgründe",
        ["koKR"] = "발명품 실험장",
        ["esMX"] = "Terreno de Pruebas",
        ["enUS"] = true,
        ["frFR"] = "Le Terrain d'essai",
        ["esES"] = "Terreno de Pruebas",
        ["zhTW"] = "試煉場",
        ["zhCN"] = "实验场",
    },
    ["Darkcrest Shore"] = {
        ["ptBR"] = "Praia da Cristanegra",
        ["ruRU"] = "Побережье Темного Гребня",
        ["deDE"] = "Küste der Dunkelkämme",
        ["koKR"] = "암흑갈기 호숫가",
        ["esMX"] = "Playa Crestanegra",
        ["enUS"] = true,
        ["frFR"] = "Rivage des Sombrecrêtes",
        ["esES"] = "Playa Crestanegra",
        ["zhTW"] = "暗羽陸地",
        ["zhCN"] = "暗潮湖岸",
    },
    ["Menagerie Wreckage"] = {
        ["ptBR"] = "Destroços da Arca",
        ["ruRU"] = "Останки Зверинца",
        ["deDE"] = "Menagerietrümmer",
        ["koKR"] = "화물선 잔해",
        ["esMX"] = "Restos del Arca",
        ["enUS"] = true,
        ["frFR"] = "Débris de la ménagerie",
        ["esES"] = "Restos del Arca",
        ["zhTW"] = "獸欄殘骸",
        ["zhCN"] = "兽笼残骸",
    },
    ["Bloodmyst Isle"] = {
        ["ptBR"] = "Ilha Névoa Rubra",
        ["ruRU"] = "Остров Кровавой Дымки",
        ["deDE"] = "Blutmythosinsel",
        ["koKR"] = "핏빛안개 섬",
        ["esMX"] = "Isla Bruma de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Ile de Brume-sang",
        ["esES"] = "Isla Bruma de Sangre",
        ["zhTW"] = "血謎島",
        ["zhCN"] = "秘血岛",
    },
    ["Bonechewer Ruins"] = {
        ["ptBR"] = "Ruínas Mascaosso",
        ["ruRU"] = "Руины Костеглодов",
        ["deDE"] = "Ruinen der Knochenmalmer",
        ["koKR"] = "해골이빨 폐허",
        ["esMX"] = "Ruinas Mascahuesos",
        ["enUS"] = true,
        ["frFR"] = "Ruines Mâche-les-os",
        ["esES"] = "Ruinas Mascahuesos",
        ["zhTW"] = "噬骨者廢墟",
        ["zhCN"] = "噬骨废墟",
    },
    ["Azuremyst Isle"] = {
        ["ptBR"] = "Ilha Névoa Lazúli",
        ["ruRU"] = "Остров Лазурной Дымки",
        ["deDE"] = "Azurmythosinsel",
        ["koKR"] = "하늘안개 섬",
        ["esMX"] = "Isla Bruma Azur",
        ["enUS"] = true,
        ["frFR"] = "Ile de Brume-azur",
        ["esES"] = "Isla Bruma Azur",
        ["zhTW"] = "藍謎島",
        ["zhCN"] = "秘蓝岛",
    },
    ["Moonwing Den"] = {
        ["ptBR"] = "Covil dos Coruscantes",
        ["ruRU"] = "Прибежище Лунных Крыльев",
        ["deDE"] = "Mondschwingenbau",
        ["koKR"] = "달날개 소굴",
        ["esMX"] = "Túmulo Lunala",
        ["enUS"] = true,
        ["frFR"] = "Tanière Aile-de-lune",
        ["esES"] = "Túmulo Lunala",
        ["zhTW"] = "月翼獸窟",
        ["zhCN"] = "月翼洞穴",
    },
    ["The Legion Front"] = {
        ["ptBR"] = "O Front da Legião",
        ["ruRU"] = "Передовая Легиона",
        ["deDE"] = "Die Front der Legion",
        ["koKR"] = "군단 전초지",
        ["esMX"] = "La Avanzadilla de la Legión",
        ["enUS"] = true,
        ["frFR"] = "Le front de la Légion",
        ["esES"] = "La Avanzadilla de la Legión",
        ["zhTW"] = "軍團前線",
        ["zhCN"] = "军团前线",
    },
    ["Elemental Plateau"] = {
        ["ptBR"] = "Platô Elemental",
        ["ruRU"] = "Плато Стихий",
        ["deDE"] = "Elementarplateau",
        ["koKR"] = "정령의 고원",
        ["esMX"] = "Meseta Elemental",
        ["enUS"] = true,
        ["frFR"] = "Plateau élémentaire",
        ["esES"] = "Meseta Elemental",
        ["zhTW"] = "元素高原",
        ["zhCN"] = "元素高地",
    },
    ["Tel'athion's Camp"] = {
        ["ptBR"] = "Acampamento do Tel'athion",
        ["ruRU"] = "Лагерь Тел'атиона",
        ["deDE"] = "Tel'athions Lager",
        ["koKR"] = "텔아시온의 야영지",
        ["esMX"] = "Campamento de Tel'athion",
        ["enUS"] = true,
        ["frFR"] = "Camp de Tel'athion",
        ["esES"] = "Campamento de Tel'athion",
        ["zhTW"] = "泰勒希歐營地",
        ["zhCN"] = "塔希恩的营地",
    },
    ["Bristlelimb Village"] = {
        ["ptBR"] = "Aldeia dos Ericerdos",
        ["ruRU"] = "Деревня Косолапов",
        ["deDE"] = "Dorf der Sichelklauen",
        ["koKR"] = "뾰족가지 마을",
        ["esMX"] = "Aldea Brazolanudo",
        ["enUS"] = true,
        ["frFR"] = "Village des Bras-hirsutes",
        ["esES"] = "Aldea Brazolanudo",
        ["zhTW"] = "鬚肢村",
        ["zhCN"] = "刺臂村",
    },
    ["Wildhammer Stronghold"] = {
        ["ptBR"] = "Fortaleza Martelo Feroz",
        ["ruRU"] = "Цитадель Громового Молота",
        ["deDE"] = "Wildhammerfeste",
        ["koKR"] = "와일드해머 성채",
        ["esMX"] = "Bastión Martillo Salvaje",
        ["enUS"] = true,
        ["frFR"] = "Bastion des Marteaux-hardis",
        ["esES"] = "Bastión Martillo Salvaje",
        ["zhTW"] = "蠻錘要塞",
        ["zhCN"] = "蛮锤要塞",
    },
    ["Goldenmist Village"] = {
        ["ptBR"] = "Vila de Aurinévoa",
        ["ruRU"] = "Деревня Золотистой Дымки",
        ["deDE"] = "Goldnebel",
        ["koKR"] = "황금안개 마을",
        ["esMX"] = "Aldea Bruma Dorada",
        ["enUS"] = true,
        ["frFR"] = "Brume-d'or",
        ["esES"] = "Aldea de Bruma Dorada",
        ["zhTW"] = "金霧村",
        ["zhCN"] = "金雾村",
    },
    ["Wrathscale Point"] = {
        ["ptBR"] = "Posto Escamódio",
        ["ruRU"] = "Руины Зловещей Чешуи",
        ["deDE"] = "Hassprankenterritorium",
        ["koKR"] = "성난비늘 거점",
        ["esMX"] = "Punto Escama de Cólera",
        ["enUS"] = true,
        ["frFR"] = "Cap des Irécailles",
        ["esES"] = "Punto Escama de Cólera",
        ["zhTW"] = "怒鱗崗哨",
        ["zhCN"] = "怒鳞岗哨",
    },
    ["Trogma's Claim"] = {
        ["ptBR"] = "Mina de Trogma",
        ["ruRU"] = "Участок Трогмы",
        ["deDE"] = "Trogmas Besitz",
        ["koKR"] = "트로그마의 점령지",
        ["esMX"] = "La Llamada de Trogma",
        ["enUS"] = true,
        ["frFR"] = "La prétention de Trogma",
        ["esES"] = "La Llamada de Trogma",
        ["zhTW"] = "索格瑪領土",
        ["zhCN"] = "托格玛洞穴",
    },
    ["The Barrier Hills"] = {
        ["ptBR"] = "Picos da Barreira",
        ["ruRU"] = "Пограничные холмы",
        ["deDE"] = "Die Hügelwand",
        ["koKR"] = "울타리 언덕",
        ["esMX"] = "Las Colinas Barrera",
        ["enUS"] = true,
        ["frFR"] = "La Barrière",
        ["esES"] = "Las Colinas Barrera",
        ["zhTW"] = "阻礙之丘",
        ["zhCN"] = "壁垒山",
    },
    ["Blade's Edge Mountains"] = {
        ["ptBR"] = "Montanhas da Lâmina Afiada",
        ["ruRU"] = "Острогорье",
        ["deDE"] = "Schergrat",
        ["koKR"] = "칼날 산맥",
        ["esMX"] = "Montañas Filospada",
        ["enUS"] = true,
        ["frFR"] = "Les Tranchantes",
        ["esES"] = "Montañas Filospada",
        ["zhTW"] = "劍刃山脈",
        ["zhCN"] = "刀锋山",
    },
    ["The Crumbling Waste"] = {
        ["ptBR"] = "Ermo Esfacelado",
        ["ruRU"] = "Гиблый пустырь",
        ["deDE"] = "Die schwindende Weite",
        ["koKR"] = "부서진 잔해",
        ["esMX"] = "Las Ruinas Desmoronadas",
        ["enUS"] = true,
        ["frFR"] = "La Désagrégation",
        ["esES"] = "Las Ruinas Desmoronadas",
        ["zhTW"] = "破碎荒地",
        ["zhCN"] = "碎裂废土",
    },
    ["Zangarmarsh"] = {
        ["ptBR"] = "Pântano Zíngaro",
        ["ruRU"] = "Зангартопь",
        ["deDE"] = "Zangarmarschen",
        ["koKR"] = "장가르 습지대",
        ["esMX"] = "Marisma de Zangar",
        ["enUS"] = true,
        ["frFR"] = "Marécage de Zangar",
        ["esES"] = "Marisma de Zangar",
        ["zhTW"] = "贊格沼澤",
        ["zhCN"] = "赞加沼泽",
    },
    ["Tor'Watha"] = {
        ["ptBR"] = "Tor'Watha",
        ["ruRU"] = "Тор'Вата",
        ["deDE"] = "Tor'Watha",
        ["koKR"] = "토르와타",
        ["esMX"] = "Tor'Watha",
        ["enUS"] = true,
        ["frFR"] = "Tor'Watha",
        ["esES"] = "Tor'Watha",
        ["zhTW"] = "托爾瓦薩",
        ["zhCN"] = "托尔瓦萨",
    },
    ["Terokkar Forest"] = {
        ["ptBR"] = "Mata Terokkar",
        ["ruRU"] = "Лес Тероккар",
        ["deDE"] = "Wälder von Terokkar",
        ["koKR"] = "테로카르 숲",
        ["esMX"] = "Bosque de Terokkar",
        ["enUS"] = true,
        ["frFR"] = "Forêt de Terokkar",
        ["esES"] = "Bosque de Terokkar",
        ["zhTW"] = "泰洛卡森林",
        ["zhCN"] = "泰罗卡森林",
    },
    ["The Sin'loren"] = {
        ["ptBR"] = "O Sin'lonren",
        ["ruRU"] = "Син'лорен",
        ["deDE"] = "Die Sin'loren",
        ["koKR"] = "신로렌호",
        ["esMX"] = "El Sin'loren",
        ["enUS"] = true,
        ["frFR"] = "Le Sin'loren",
        ["esES"] = "El Sin'loren",
        ["zhTW"] = "辛洛倫",
        ["zhCN"] = "辛洛雷号",
    },
    ["Nagrand"] = {
        ["ptBR"] = "Nagrand",
        ["ruRU"] = "Награнд",
        ["deDE"] = "Nagrand",
        ["koKR"] = "나그란드",
        ["esMX"] = "Nagrand",
        ["enUS"] = true,
        ["frFR"] = "Nagrand",
        ["esES"] = "Nagrand",
        ["zhTW"] = "納葛蘭",
        ["zhCN"] = "纳格兰",
    },
    ["Expedition Point"] = {
        ["ptBR"] = "Posto da Expedição",
        ["ruRU"] = "Лагерь экспедиции",
        ["deDE"] = "Expeditionsposten",
        ["koKR"] = "원정대 거점",
        ["esMX"] = "Punta de Expedición",
        ["enUS"] = true,
        ["frFR"] = "Halte de l'expédition",
        ["esES"] = "Punta de Expedición",
        ["zhTW"] = "遠征隊哨塔",
        ["zhCN"] = "远征军岗哨",
    },
    ["Zeb'Nowa"] = {
        ["ptBR"] = "Zeb'Nowa",
        ["ruRU"] = "Зеб'Нова",
        ["deDE"] = "Zeb'Nowa",
        ["koKR"] = "제브노와",
        ["esMX"] = "Zeb'Nowa",
        ["enUS"] = true,
        ["frFR"] = "Zeb'Nowa",
        ["esES"] = "Zeb'Nowa",
        ["zhTW"] = "札布諾瓦",
        ["zhCN"] = "塞布努瓦",
    },
    ["Farstrider Enclave"] = {
        ["ptBR"] = "Enclave dos Andarilhos",
        ["ruRU"] = "Анклав Странников",
        ["deDE"] = "Enklave der Weltenwanderer",
        ["koKR"] = "원정순찰대 초소",
        ["esMX"] = "Enclave del Errante",
        ["enUS"] = true,
        ["frFR"] = "Enclave des Pérégrins",
        ["esES"] = "Enclave del Errante",
        ["zhTW"] = "遠行者營地",
        ["zhCN"] = "远行者营地",
    },
    ["Zeb'Tela"] = {
        ["ptBR"] = "Zeb'Tela",
        ["ruRU"] = "Зеб'Тела",
        ["deDE"] = "Zeb'Tela",
        ["koKR"] = "제브텔라",
        ["esMX"] = "Zeb'Tela",
        ["enUS"] = true,
        ["frFR"] = "Zeb'Tela",
        ["esES"] = "Zeb'Tela",
        ["zhTW"] = "札布泰拉",
        ["zhCN"] = "塞布提拉",
    },
    ["Thunderlord Stronghold"] = {
        ["ptBR"] = "Cidadela do Senhor do Trovão",
        ["ruRU"] = "Оплот Громоборцев",
        ["deDE"] = "Donnerfeste",
        ["koKR"] = "천둥군주 요새",
        ["esMX"] = "Bastión Señor del Trueno",
        ["enUS"] = true,
        ["frFR"] = "Bastion des Sire-tonnerre",
        ["esES"] = "Bastión Señor del Trueno",
        ["zhTW"] = "雷霆王村",
        ["zhCN"] = "雷神要塞",
    },
    ["Toshley's Station"] = {
        ["ptBR"] = "Estação do Tocha",
        ["ruRU"] = "Станция Тошли",
        ["deDE"] = "Toshleys Station",
        ["koKR"] = "토쉴리의 연구기지",
        ["esMX"] = "Estación de Toshley",
        ["enUS"] = true,
        ["frFR"] = "Poste de Toshley",
        ["esES"] = "Estación de Toshley",
        ["zhTW"] = "托斯利基地",
        ["zhCN"] = "托什雷的基地",
    },
    ["Elrendar River"] = {
        ["ptBR"] = "Rio Elrendar",
        ["ruRU"] = "Река Элрендар",
        ["deDE"] = "Der Elrendar",
        ["koKR"] = "엘렌다르 강",
        ["esMX"] = "Río Elrendar",
        ["enUS"] = true,
        ["frFR"] = "L'Elrendar",
        ["esES"] = "Río Elrendar",
        ["zhTW"] = "艾蘭達之河",
        ["zhCN"] = "艾尔伦达河",
    },
    ["Forge Base: Gehenna"] = {
        ["ptBR"] = "Base-forja: Geena",
        ["ruRU"] = "База Легиона: Геенна",
        ["deDE"] = "Konstruktionsbasis: Gehenna",
        ["koKR"] = "지옥의 괴철로 주둔지",
        ["esMX"] = "Base Forja: Gehenna",
        ["enUS"] = true,
        ["frFR"] = "Base de forge : Géhenne",
        ["esES"] = "Base Forja: Gehenna",
        ["zhTW"] = "熔爐基地:苦難",
        ["zhCN"] = "铸魔基地：炼狱",
    },
    ["Fallen Sky Ridge"] = {
        ["ptBR"] = "Serra do Céu Caído",
        ["ruRU"] = "Гряда Упавшего Неба",
        ["deDE"] = "Himmelssturzgrat",
        ["koKR"] = "무너진 하늘 마루",
        ["esMX"] = "Cresta Cielo Estrellado",
        ["enUS"] = true,
        ["frFR"] = "Crête Tombeciel",
        ["esES"] = "Cresta Cielo Estrellado",
        ["zhTW"] = "墜天山脈",
        ["zhCN"] = "坠星山",
    },
    ["Zeb'Sora"] = {
        ["ptBR"] = "Zeb'Sora",
        ["ruRU"] = "Зеб'Сора",
        ["deDE"] = "Zeb'Sora",
        ["koKR"] = "제브소라",
        ["esMX"] = "Zeb'Sora",
        ["enUS"] = true,
        ["frFR"] = "Zeb'Sora",
        ["esES"] = "Zeb'Sora",
        ["zhTW"] = "札布索拉",
        ["zhCN"] = "塞布索雷",
    },
    ["Fairbreeze Village"] = {
        ["ptBR"] = "Vila de Brisabela",
        ["ruRU"] = "Деревня Легкий Ветерок",
        ["deDE"] = "Morgenluft",
        ["koKR"] = "산들바람 마을",
        ["esMX"] = "Aldea Brisa Pura",
        ["enUS"] = true,
        ["frFR"] = "Brise-clémente",
        ["esES"] = "Aldea Brisa Pura",
        ["zhTW"] = "晴風村",
        ["zhCN"] = "晴风村",
    },
    ["Amani Catacombs"] = {
        ["ptBR"] = "Catacumbas Amani",
        ["ruRU"] = "Катакомбы Амани",
        ["deDE"] = "Amanikatakomben",
        ["koKR"] = "아마니 지하묘지",
        ["esMX"] = "Catacumbas Amani",
        ["enUS"] = true,
        ["frFR"] = "Catacombes des Amani",
        ["esES"] = "Catacumbas Amani",
        ["zhTW"] = "阿曼尼地下墓穴",
        ["zhCN"] = "阿曼尼墓穴",
    },
    ["Arklon Ruins"] = {
        ["ptBR"] = "Ruínas Arklon",
        ["ruRU"] = "Руины Арклона",
        ["deDE"] = "Ruinen von Arklon",
        ["koKR"] = "알클론 폐허",
        ["esMX"] = "Ruinas Arklon",
        ["enUS"] = true,
        ["frFR"] = "Ruines Arklon",
        ["esES"] = "Ruinas Arklon",
        ["zhTW"] = "阿克隆廢墟",
        ["zhCN"] = "阿尔科隆废墟",
    },
    ["Sungraze Peak"] = {
        ["ptBR"] = "Monte Triscassol",
        ["ruRU"] = "Пик Солнечного Пастбища",
        ["deDE"] = "Sonnenhügel",
        ["koKR"] = "해넘이 봉우리",
        ["esMX"] = "Cima Rasguño de Sol",
        ["enUS"] = true,
        ["frFR"] = "Pic de Frôle-soleil",
        ["esES"] = "Cima Rasguño de Sol",
        ["zhTW"] = "日傷山峰",
        ["zhCN"] = "阳痕峰",
    },
    ["Amani Pass"] = {
        ["ptBR"] = "Desfiladeiro Amani",
        ["ruRU"] = "Перевал Амани",
        ["deDE"] = "Amanipass",
        ["koKR"] = "아마니 고개",
        ["esMX"] = "Paso de Amani",
        ["enUS"] = true,
        ["frFR"] = "Passage des Amani",
        ["esES"] = "Paso de Amani",
        ["zhTW"] = "阿曼尼小徑",
        ["zhCN"] = "阿曼尼小径",
    },
    ["Dragonspine Ridge"] = {
        ["ptBR"] = "Serra de Espinodraco",
        ["ruRU"] = "Драконий хребет",
        ["deDE"] = "Drachenwirbelgrat",
        ["koKR"] = "용돌기 마루",
        ["esMX"] = "Cresta Espinazo de Dragón",
        ["enUS"] = true,
        ["frFR"] = "Crête d'Epine-de-dragon",
        ["esES"] = "Cresta Espinazo de Dragón",
        ["zhTW"] = "龍脊山脊",
        ["zhCN"] = "龙脊岭",
    },
    ["Socrethar's Seat"] = {
        ["ptBR"] = "Trono de Socrethar",
        ["ruRU"] = "Трон Сокретара",
        ["deDE"] = "Socrethars Sitz",
        ["koKR"] = "소크레타르의 옥좌",
        ["esMX"] = "Trono de Socrethar",
        ["enUS"] = true,
        ["frFR"] = "Siège de Socrethar",
        ["esES"] = "Trono de Socrethar",
        ["zhTW"] = "索奎薩爾的領地",
        ["zhCN"] = "索克雷萨之座",
    },
    ["Silmyr Lake"] = {
        ["ptBR"] = "Lago Silmyr",
        ["ruRU"] = "Озеро Силмир",
        ["deDE"] = "Silmyrsee",
        ["koKR"] = "실미르 호수",
        ["esMX"] = "Lago Silmyr",
        ["enUS"] = true,
        ["frFR"] = "Lac Silmyr",
        ["esES"] = "Lago Silmyr",
        ["zhTW"] = "泥濘湖",
        ["zhCN"] = "希尔米耶湖",
    },
    ["Hatchet Hills"] = {
        ["ptBR"] = "Serra da Machadinha",
        ["ruRU"] = "Холмы Томагавков",
        ["deDE"] = "Die Axthügel",
        ["koKR"] = "도끼 언덕",
        ["esMX"] = "Colinas Hacha",
        ["enUS"] = true,
        ["frFR"] = "Collines de la Cognée",
        ["esES"] = "Colinas Hacha",
        ["zhTW"] = "戰斧嶺",
        ["zhCN"] = "战斧岭",
    },
    ["Skettis"] = {
        ["ptBR"] = "Skettis",
        ["ruRU"] = "Скеттис",
        ["deDE"] = "Skettis",
        ["koKR"] = "스케티스",
        ["esMX"] = "Skettis",
        ["enUS"] = true,
        ["frFR"] = "Skettis",
        ["esES"] = "Skettis",
        ["zhTW"] = "司凱堤斯",
        ["zhCN"] = "斯克提斯",
    },
    ["Auchenai Grounds"] = {
        ["ptBR"] = "Território Auchenai",
        ["ruRU"] = "Аукенайские земли",
        ["deDE"] = "Auchenaigründe",
        ["koKR"] = "아키나이 영지",
        ["esMX"] = "Tierras Auchenai",
        ["enUS"] = true,
        ["frFR"] = "Terres Auchenaï",
        ["esES"] = "Tierras Auchenai",
        ["zhTW"] = "奧奇奈營地",
        ["zhCN"] = "奥金尼废墟",
    },
    ["Broken Hill"] = {
        ["ptBR"] = "Monte Partido",
        ["ruRU"] = "Изрезанный холм",
        ["deDE"] = "Die Trümmerbastion",
        ["koKR"] = "무너진 언덕",
        ["esMX"] = "Cerro Tábido",
        ["enUS"] = true,
        ["frFR"] = "Colline brisée",
        ["esES"] = "Cerro Tábido",
        ["zhTW"] = "破碎之丘",
        ["zhCN"] = "碎石岭",
    },
    ["Mag'har Post"] = {
        ["ptBR"] = "Posto Mag'har",
        ["ruRU"] = "Застава маг'харов",
        ["deDE"] = "Posten der Mag'har",
        ["koKR"] = "마그하르 거점",
        ["esMX"] = "Puesto Mag'har",
        ["enUS"] = true,
        ["frFR"] = "Poste Mag'har",
        ["esES"] = "Puesto Mag'har",
        ["zhTW"] = "瑪格哈崗哨",
        ["zhCN"] = "玛格汉岗哨",
    },
    ["Honor Hold"] = {
        ["ptBR"] = "Fortaleza da Honra",
        ["ruRU"] = "Оплот Чести",
        ["deDE"] = "Ehrenfeste",
        ["koKR"] = "명예의 요새",
        ["esMX"] = "Bastión del Honor",
        ["enUS"] = true,
        ["frFR"] = "Bastion de l'Honneur",
        ["esES"] = "Bastión del Honor",
        ["zhTW"] = "榮譽堡",
        ["zhCN"] = "荣耀堡",
    },
    ["Netherstone"] = {
        ["ptBR"] = "Pedra Etérea",
        ["ruRU"] = "Осколки Пустоты",
        ["deDE"] = "Netherstein",
        ["koKR"] = "황천의 돌무지",
        ["esMX"] = "Piedra Abisal",
        ["enUS"] = true,
        ["frFR"] = "Pierre-de-Néant",
        ["esES"] = "Piedra Abisal",
        ["zhTW"] = "虛空石",
        ["zhCN"] = "虚空石",
    },
    ["Lake Elrendar"] = {
        ["ptBR"] = "Lago Elrendar",
        ["ruRU"] = "Озеро Элрендар",
        ["deDE"] = "Elrendarsee",
        ["koKR"] = "엘렌다르 호수",
        ["esMX"] = "Lago Elrendar",
        ["enUS"] = true,
        ["frFR"] = "Lac Elrendar",
        ["esES"] = "Lago Elrendar",
        ["zhTW"] = "艾蘭達之湖",
        ["zhCN"] = "艾伦达尔湖",
    },
    ["Scryer's Tier"] = {
        ["ptBR"] = "Terraço dos Áugures",
        ["ruRU"] = "Ярус Провидцев",
        ["deDE"] = "Sehertreppe",
        ["koKR"] = "점술가 언덕",
        ["esMX"] = "Grada del Arúspice",
        ["enUS"] = true,
        ["frFR"] = "Degré des Clairvoyants",
        ["esES"] = "Grada del Arúspice",
        ["zhTW"] = "占卜者階梯",
        ["zhCN"] = "占星者之台",
    },
    ["Saltheril's Haven"] = {
        ["ptBR"] = "Refúgio de Saltheril",
        ["ruRU"] = "Вилла Салтерила",
        ["deDE"] = "Saltherils Hafen",
        ["koKR"] = "살데릴의 안식처",
        ["esMX"] = "Refugio de Saltheril",
        ["enUS"] = true,
        ["frFR"] = "Havre de Saltheril",
        ["esES"] = "Refugio de Saltheril",
        ["zhTW"] = "薩瑟里的避風港",
        ["zhCN"] = "萨瑟利尔庄园",
    },
    ["Arklonis Ridge"] = {
        ["ptBR"] = "Pico Arklonis",
        ["ruRU"] = "Гряда Арклонис",
        ["deDE"] = "Arklonisgrat",
        ["koKR"] = "아클로니스 마루",
        ["esMX"] = "Cresta Arklonis",
        ["enUS"] = true,
        ["frFR"] = "Crête d'Arklonis",
        ["esES"] = "Cresta Arklonis",
        ["zhTW"] = "阿卡隆斯山脊",
        ["zhCN"] = "阿尔科隆山脉",
    },
    ["Supply Caravan"] = {
        ["ptBR"] = "Caravana de Suprimentos",
        ["ruRU"] = "Караван",
        ["deDE"] = "Versorgungskarawane",
        ["koKR"] = "보급 짐마차",
        ["esMX"] = "Caravana de Provisiones",
        ["enUS"] = true,
        ["frFR"] = "Caravane de ravitaillement",
        ["esES"] = "Caravana de Provisiones",
        ["zhTW"] = "補給商隊",
        ["zhCN"] = "补给车队",
    },
    ["Underlight Mines"] = {
        ["ptBR"] = "Minas Telúminas",
        ["ruRU"] = "Беспросветные рудники",
        ["deDE"] = "Grubenlichtminen",
        ["koKR"] = "미명 광산",
        ["esMX"] = "Minas Sondaluz",
        ["enUS"] = true,
        ["frFR"] = "Mines de Terradiance",
        ["esES"] = "Minas Sondaluz",
        ["zhTW"] = "光底礦坑",
        ["zhCN"] = "幽光矿洞",
    },
    ["Shalandis Isle"] = {
        ["ptBR"] = "Ilha Shalandis",
        ["ruRU"] = "Остров Шаландис",
        ["deDE"] = "Die Insel Shalandis",
        ["koKR"] = "샬란디스 섬",
        ["esMX"] = "Isla Shalandis",
        ["enUS"] = true,
        ["frFR"] = "Ile de Shalandis",
        ["esES"] = "Isla Shalandis",
        ["zhTW"] = "薩藍迪斯小島",
        ["zhCN"] = "沙兰蒂斯岛",
    },
    ["Howling Ziggurat"] = {
        ["ptBR"] = "Zigurate Uivante",
        ["ruRU"] = "Воющий зиккурат",
        ["deDE"] = "Die heulende Ziggurat",
        ["koKR"] = "울부짖는 지구라트",
        ["esMX"] = "Zigurat Aullante",
        ["enUS"] = true,
        ["frFR"] = "Ziggourat hurlante",
        ["esES"] = "Zigurat Aullante",
        ["zhTW"] = "哀嚎通靈塔",
        ["zhCN"] = "鬼嚎通灵塔",
    },
    ["Bleeding Ziggurat"] = {
        ["ptBR"] = "Zigurate Sangrento",
        ["ruRU"] = "Кровоточащий зиккурат",
        ["deDE"] = "Die blutende Ziggurat",
        ["koKR"] = "피투성이 지구라트",
        ["esMX"] = "Zigurat Sangrante",
        ["enUS"] = true,
        ["frFR"] = "Ziggourat sanguinolente",
        ["esES"] = "Zigurat Sangrante",
        ["zhTW"] = "血色通靈塔",
        ["zhCN"] = "鲜血通灵塔",
    },
    ["Singing Ridge"] = {
        ["ptBR"] = "Platô Harmônico",
        ["ruRU"] = "Звенящий гребень",
        ["deDE"] = "Der singende Bergrücken",
        ["koKR"] = "노래하는 마루",
        ["esMX"] = "Cresta Canto",
        ["enUS"] = true,
        ["frFR"] = "Crête chantante",
        ["esES"] = "Cresta Canto",
        ["zhTW"] = "美聲山脊",
        ["zhCN"] = "晶歌山脉",
    },
    ["The Overlook"] = {
        ["ptBR"] = "Mirante",
        ["ruRU"] = "Обзорная площадка",
        ["deDE"] = "Der Rundblick",
        ["koKR"] = "전망대",
        ["esMX"] = "La Dominancia",
        ["enUS"] = true,
        ["frFR"] = "Le Surplomb",
        ["esES"] = "La Dominancia",
        ["zhTW"] = "望海崖",
        ["zhCN"] = "瞭望台",
    },
    ["Veil Lashh"] = {
        ["ptBR"] = "Véu Lashh",
        ["ruRU"] = "Гнездовье Лашш",
        ["deDE"] = "Lashhversteck",
        ["koKR"] = "장막의 래쉬",
        ["esMX"] = "Velo Lashh",
        ["enUS"] = true,
        ["frFR"] = "Voile Lashh",
        ["esES"] = "Velo Lashh",
        ["zhTW"] = "迷霧拉斯",
        ["zhCN"] = "拉什鸦巢",
    },
    ["Deatholme"] = {
        ["ptBR"] = "Cidadela da Morte",
        ["ruRU"] = "Смертхольм",
        ["deDE"] = "Die Todesfestung",
        ["koKR"] = "데솔름",
        ["esMX"] = "Ciudad de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Mortholme",
        ["esES"] = "Muerthogar",
        ["zhTW"] = "死亡之域",
        ["zhCN"] = "戴索姆",
    },
    ["Shadowmoon Village"] = {
        ["ptBR"] = "Aldeia Lua Negra",
        ["ruRU"] = "Деревня Призрачной Луны",
        ["deDE"] = "Schattenmond",
        ["koKR"] = "어둠달 마을",
        ["esMX"] = "Aldea Sombraluna",
        ["enUS"] = true,
        ["frFR"] = "Village d'Ombrelune",
        ["esES"] = "Aldea Sombraluna",
        ["zhTW"] = "影月村",
        ["zhCN"] = "影月村",
    },
    ["An'telas"] = {
        ["ptBR"] = "An'telas",
        ["ruRU"] = "Ан'телас",
        ["deDE"] = "An'telas",
        ["koKR"] = "안텔라스",
        ["esMX"] = "An'telas",
        ["enUS"] = true,
        ["frFR"] = "An'telas",
        ["esES"] = "An'telas",
        ["zhTW"] = "安泰拉斯",
        ["zhCN"] = "安泰拉斯",
    },
    ["Duskwither Grounds"] = {
        ["ptBR"] = "Terras do Ocaso",
        ["ruRU"] = "Земли Блеклых Сумерек",
        ["deDE"] = "Nachtschimmergrund",
        ["koKR"] = "더스크위더 정원",
        ["esMX"] = "Tierras Ocaso Marchito",
        ["enUS"] = true,
        ["frFR"] = "Terres de Ternesoir",
        ["esES"] = "Tierras Ocaso Marchito",
        ["zhTW"] = "暗木營地",
        ["zhCN"] = "达斯维瑟广场",
    },
    ["Dawnstar Spire"] = {
        ["ptBR"] = "Torre Aurestela",
        ["ruRU"] = "Башня Утренней Звезды",
        ["deDE"] = "Morgensternturm",
        ["koKR"] = "돈스타 첨탑",
        ["esMX"] = "Aguja de la Estrella del Alba",
        ["enUS"] = true,
        ["frFR"] = "Flèche d'Aubétoile",
        ["esES"] = "Aguja de la Estrella del Alba",
        ["zhTW"] = "晨星尖塔",
        ["zhCN"] = "晨星之塔",
    },
    ["Duskwither Spire"] = {
        ["ptBR"] = "Torre do Ocaso",
        ["ruRU"] = "Шпиль Блеклых Сумерек",
        ["deDE"] = "Nachtschimmerturm",
        ["koKR"] = "더스크위더 첨탑",
        ["esMX"] = "Aguja Ocaso Marchito",
        ["enUS"] = true,
        ["frFR"] = "Flèche de Ternesoir",
        ["esES"] = "Aguja Ocaso Marchito",
        ["zhTW"] = "暮萎尖塔",
        ["zhCN"] = "达斯维瑟之塔",
    },
    ["Sanctum of the Sun"] = {
        ["ptBR"] = "Sacrário Solar",
        ["ruRU"] = "Святилище Солнца",
        ["deDE"] = "Sanktum der Sonne",
        ["koKR"] = "태양의 성소",
        ["esMX"] = "Sagrario del Sol",
        ["enUS"] = true,
        ["frFR"] = "Sanctum du Soleil",
        ["esES"] = "Sagrario del Sol",
        ["zhTW"] = "太陽聖所",
        ["zhCN"] = "太阳圣殿",
    },
    ["Nazzivian"] = {
        ["ptBR"] = "Nazzivian",
        ["ruRU"] = "Наззивиан",
        ["deDE"] = "Nazzivian",
        ["koKR"] = "나지비안",
        ["esMX"] = "Nazzivian",
        ["enUS"] = true,
        ["frFR"] = "Nazzivian",
        ["esES"] = "Nazzivian",
        ["zhTW"] = "納茲維恩",
        ["zhCN"] = "纳兹维安",
    },
    ["Tuurem"] = {
        ["ptBR"] = "Tuurem",
        ["ruRU"] = "Туурем",
        ["deDE"] = "Tuurem",
        ["koKR"] = "투렘",
        ["esMX"] = "Tuurem",
        ["enUS"] = true,
        ["frFR"] = "Tuurem",
        ["esES"] = "Tuurem",
        ["zhTW"] = "杜瑞",
        ["zhCN"] = "图雷姆",
    },
    ["Circle of Blood"] = {
        ["ptBR"] = "Círculo Sangrento",
        ["ruRU"] = "Круг Крови",
        ["deDE"] = "Der Zirkel des Blutes",
        ["koKR"] = "피의 투기장",
        ["esMX"] = "Anillo de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Cercle de sang",
        ["esES"] = "Anillo de Sangre",
        ["zhTW"] = "血之環",
        ["zhCN"] = "鲜血之环",
    },
    ["Windrunner Village"] = {
        ["ptBR"] = "Vila dos Correventos",
        ["ruRU"] = "Деревня Ветрокрылых",
        ["deDE"] = "Windläuferdorf",
        ["koKR"] = "윈드러너 마을",
        ["esMX"] = "Aldea Brisaveloz",
        ["enUS"] = true,
        ["frFR"] = "Coursevent",
        ["esES"] = "Aldea Brisaveloz",
        ["zhTW"] = "風行者村",
        ["zhCN"] = "风行村",
    },
    ["Dawning Lane"] = {
        ["ptBR"] = "Alameda Alvorecente",
        ["ruRU"] = "Рассветная улица",
        ["deDE"] = "Dämmerweg",
        ["koKR"] = "새벽길",
        ["esMX"] = "Calle del Alba",
        ["enUS"] = true,
        ["frFR"] = "Allée du Point-du-jour",
        ["esES"] = "Calle del Alba",
        ["zhTW"] = "黎明小路",
        ["zhCN"] = "黎明之路",
    },
    ["Talon Stand"] = {
        ["ptBR"] = "Planalto da Garra",
        ["ruRU"] = "Холм Когтя",
        ["deDE"] = "Krallenhoch",
        ["koKR"] = "갈퀴발톱 언덕",
        ["esMX"] = "Alto de la Garra",
        ["enUS"] = true,
        ["frFR"] = "Le lieu des serres",
        ["esES"] = "Alto de la Garra",
        ["zhTW"] = "魔爪看臺",
        ["zhCN"] = "龙爪丘陵",
    },
    ["Lake Ere'Noru"] = {
        ["ptBR"] = "Lago Ere'Noru",
        ["ruRU"] = "Озеро Эре'Нору",
        ["deDE"] = "See von Ere'Noru",
        ["koKR"] = "에레노루 호수",
        ["esMX"] = "Lago Ere'Noru",
        ["enUS"] = true,
        ["frFR"] = "Lac Ere'Noru",
        ["esES"] = "Lago Ere'Noru",
        ["zhTW"] = "艾利諾魯湖",
        ["zhCN"] = "艾雷诺湖",
    },
    ["Huntress of the Sun"] = {
        ["ptBR"] = "Caçadora do Sol",
        ["ruRU"] = "Солнечная Охотница",
        ["deDE"] = "Jägerin der Sonne",
        ["koKR"] = "태양의 여사냥꾼",
        ["esMX"] = "Cazadora del Sol",
        ["enUS"] = true,
        ["frFR"] = "Chasseresse du soleil",
        ["esES"] = "Cazadora del Sol",
        ["zhTW"] = "太陽女獵師",
        ["zhCN"] = "太阳女猎手",
    },
    ["Azurebreeze Coast"] = {
        ["ptBR"] = "Costa da Brisa Azul",
        ["ruRU"] = "Побережье Лазурного Ветра",
        ["deDE"] = "Azurblaue Küste",
        ["koKR"] = "하늘바람 해안",
        ["esMX"] = "Costa Bris Azur",
        ["enUS"] = true,
        ["frFR"] = "Côte de Brise-d'Azur",
        ["esES"] = "Costa Bris Azur",
        ["zhTW"] = "蔚藍海岸",
        ["zhCN"] = "碧风海岸",
    },
    ["Silvermoon City"] = {
        ["ptBR"] = "Luaprata",
        ["ruRU"] = "Луносвет",
        ["deDE"] = "Silbermond",
        ["koKR"] = "실버문",
        ["esMX"] = "Ciudad de Lunargenta",
        ["enUS"] = true,
        ["frFR"] = "Lune-d'argent",
        ["esES"] = "Ciudad de Lunargenta",
        ["zhTW"] = "銀月城",
        ["zhCN"] = "银月城",
    },
    ["Void Ridge"] = {
        ["ptBR"] = "Escarpa do Caos",
        ["ruRU"] = "Пустынный обрыв",
        ["deDE"] = "Leerengrat",
        ["koKR"] = "공허의 마루",
        ["esMX"] = "Cresta del Vacío",
        ["enUS"] = true,
        ["frFR"] = "Crête du Vide",
        ["esES"] = "Cresta del Vacío",
        ["zhTW"] = "虛無之脊",
        ["zhCN"] = "虚空山脉",
    },
    ["Falthrien Academy"] = {
        ["ptBR"] = "Academia Falthrien",
        ["ruRU"] = "Академия Фалтриена",
        ["deDE"] = "Akademie von Falthrien",
        ["koKR"] = "팔스리엔 마법학회",
        ["esMX"] = "Academia Falthrien",
        ["enUS"] = true,
        ["frFR"] = "Académie de Falthrien",
        ["esES"] = "Academia Falthrien",
        ["zhTW"] = "法薩瑞安學院",
        ["zhCN"] = "法瑟林学院",
    },
    ["The Sunspire"] = {
        ["ptBR"] = "Torre do Sol",
        ["ruRU"] = "Солнечный шпиль",
        ["deDE"] = "Der Sonnenturm",
        ["koKR"] = "태양 첨탑",
        ["esMX"] = "La Aguja del Sol",
        ["enUS"] = true,
        ["frFR"] = "La flèche solaire",
        ["esES"] = "La Aguja del Sol",
        ["zhTW"] = "日尖塔",
        ["zhCN"] = "太阳之塔",
    },
    ["Twisting Nether"] = {
        ["ptBR"] = "Espiral Etérea",
        ["ruRU"] = "Круговерть Пустоты",
        ["deDE"] = "Wirbelnder Nether",
        ["koKR"] = "뒤틀린 황천",
        ["esMX"] = "El Vacío Abisal",
        ["enUS"] = true,
        ["frFR"] = "Le Néant distordu",
        ["esES"] = "El Vacío Abisal",
        ["zhTW"] = "扭曲虛空",
        ["zhCN"] = "扭曲虚空",
    },
    ["Hellfire Peninsula"] = {
        ["ptBR"] = "Península Fogo do Inferno",
        ["ruRU"] = "Полуостров Адского Пламени",
        ["deDE"] = "Höllenfeuerhalbinsel",
        ["koKR"] = "지옥불 반도",
        ["esMX"] = "Península del Fuego Infernal",
        ["enUS"] = true,
        ["frFR"] = "Péninsule des Flammes infernales",
        ["esES"] = "Península del Fuego Infernal",
        ["zhTW"] = "地獄火半島",
        ["zhCN"] = "地狱火半岛",
    },
    ["An'daroth"] = {
        ["ptBR"] = "An'daroth",
        ["ruRU"] = "Ан'дарот",
        ["deDE"] = "An'daroth",
        ["koKR"] = "안다로스",
        ["esMX"] = "An'daroth",
        ["enUS"] = true,
        ["frFR"] = "An'daroth",
        ["esES"] = "An'daroth",
        ["zhTW"] = "安都拉斯",
        ["zhCN"] = "安达洛斯",
    },
    ["Invasion Point: Cataclysm"] = {
        ["ptBR"] = "Ponto de Invasão: Cataclismo",
        ["ruRU"] = "Точка вторжения: Катаклизм",
        ["deDE"] = "Invasionspunkt: Katastrophe",
        ["koKR"] = "대재앙의 침공 거점",
        ["esMX"] = "Punto de Invasión: Cataclismo",
        ["enUS"] = true,
        ["frFR"] = "Site d'invasion : Cataclysme",
        ["esES"] = "Punto de Invasión: Cataclismo",
        ["zhTW"] = "侵略點:災難",
        ["zhCN"] = "登陆场：灾难",
    },
    ["The Altar of Shadows"] = {
        ["ptBR"] = "Altar das Sombras",
        ["ruRU"] = "Алтарь Теней",
        ["deDE"] = "Altar der Schatten",
        ["koKR"] = "어둠의 제단",
        ["esMX"] = "El Altar de las Sombras",
        ["enUS"] = true,
        ["frFR"] = "L'autel des Ombres",
        ["esES"] = "El Altar de las Sombras",
        ["zhTW"] = "暗影祭壇",
        ["zhCN"] = "暗影祭坛",
    },
    ["Forge Camp: Fear"] = {
        ["ptBR"] = "Campo-forja: Medo",
        ["ruRU"] = "Лагерь Легиона: Страх",
        ["deDE"] = "Konstruktionslager: Furcht",
        ["koKR"] = "경악의 괴철로 기지",
        ["esMX"] = "Campamento Forja: Miedo",
        ["enUS"] = true,
        ["frFR"] = "Camp de forge : Peur",
        ["esES"] = "Campamento Forja: Miedo",
        ["zhTW"] = "煉冶場:恐懼",
        ["zhCN"] = "铸魔营地：畏惧",
    },
    ["Veil Ala'rak"] = {
        ["ptBR"] = "Véu Ala'rak",
        ["ruRU"] = "Гнездовье Ала'рак",
        ["deDE"] = "Ala'rakversteck",
        ["koKR"] = "장막의 알라라크",
        ["esMX"] = "Velo Ala'rak",
        ["enUS"] = true,
        ["frFR"] = "Voile Ala'rak",
        ["esES"] = "Velo Ala'rak",
        ["zhTW"] = "迷霧亞拉芮克",
        ["zhCN"] = "奥拉克鸦巢",
    },
    ["Laughing Skull Ruins"] = {
        ["ptBR"] = "Ruínas Gargaveira",
        ["ruRU"] = "Руины Веселого Черепа",
        ["deDE"] = "Ruinen des Lachenden Schädels",
        ["koKR"] = "웃는 해골 폐허",
        ["esMX"] = "Ruinas Riecráneos",
        ["enUS"] = true,
        ["frFR"] = "Ruines du Crâne ricanant",
        ["esES"] = "Ruinas Riecráneos",
        ["zhTW"] = "獰笑骷髏廢墟",
        ["zhCN"] = "嘲颅废墟",
    },
    ["Shadowmoon Valley"] = {
        ["ptBR"] = "Vale da Lua Negra",
        ["ruRU"] = "Долина Призрачной Луны",
        ["deDE"] = "Schattenmondtal",
        ["koKR"] = "어둠달 골짜기",
        ["esMX"] = "Valle Sombraluna",
        ["enUS"] = true,
        ["frFR"] = "Vallée d'Ombrelune",
        ["esES"] = "Valle Sombraluna",
        ["zhTW"] = "影月谷",
        ["zhCN"] = "影月谷",
    },
    ["The Scorched Grove"] = {
        ["ptBR"] = "Mata Queimada",
        ["ruRU"] = "Выжженная роща",
        ["deDE"] = "Der versengte Hain",
        ["koKR"] = "불타버린 숲",
        ["esMX"] = "La Arboleda Agostada",
        ["enUS"] = true,
        ["frFR"] = "Le bosquet incendié",
        ["esES"] = "La Arboleda Agostada",
        ["zhTW"] = "烈焰邊境",
        ["zhCN"] = "焦痕谷",
    },
    ["The Living Wood"] = {
        ["ptBR"] = "Floresta Viva",
        ["ruRU"] = "Живой лес",
        ["deDE"] = "Der lebende Wald",
        ["koKR"] = "생명의 숲",
        ["esMX"] = "El Bosque Viviente",
        ["enUS"] = true,
        ["frFR"] = "Le bois vivant",
        ["esES"] = "El Bosque Viviente",
        ["zhTW"] = "活木森林",
        ["zhCN"] = "生命森林",
    },
    ["Lower Veil Shil'ak"] = {
        ["ptBR"] = "Véu Shil'ak Inferior",
        ["ruRU"] = "Нижнее гнездовье Шил'ак",
        ["deDE"] = "Unteres Shil'akversteck",
        ["koKR"] = "장막의 쉴라크",
        ["esMX"] = "Velo Shil'ak Bajo",
        ["enUS"] = true,
        ["frFR"] = "Voile Shil'ak inférieur",
        ["esES"] = "Velo Shil'ak Bajo",
        ["zhTW"] = "迷霧希拉克下層",
        ["zhCN"] = "下层夏尔克鸦巢",
    },
    ["Invasion Point: Annihilator"] = {
        ["ptBR"] = "Ponto de Invasão: Extirpador",
        ["ruRU"] = "Точка вторжения: Аннигилятор",
        ["deDE"] = "Invasionspunkt: Vernichter",
        ["koKR"] = "파멸자의 침공 거점",
        ["esMX"] = "Punto de invasión: Aniquilador",
        ["enUS"] = true,
        ["frFR"] = "Site d'invasion : Annihilateur",
        ["esES"] = "Punto de invasión: Aniquilador",
        ["zhTW"] = "侵略點:殲滅者",
        ["zhCN"] = "登陆场：歼灭",
    },
    ["Soulgrinder's Barrow"] = {
        ["ptBR"] = "Tumba do Trituralma",
        ["ruRU"] = "Холм Разрушителя Душ",
        ["deDE"] = "Hügel des Seelenschänders",
        ["koKR"] = "영혼분쇄자의 은신처",
        ["esMX"] = "Túmulo de Moledor de Almas",
        ["enUS"] = true,
        ["frFR"] = "Le refuge du Broyeur-d'âme",
        ["esES"] = "Túmulo de Moledor de Almas",
        ["zhTW"] = "靈魂研磨者獸穴",
        ["zhCN"] = "磨魂者之穴",
    },
    ["Auchindoun"] = {
        ["ptBR"] = "Auchindoun",
        ["ruRU"] = "Аукиндон",
        ["deDE"] = "Auchindoun",
        ["koKR"] = "아킨둔",
        ["esMX"] = "Auchindoun",
        ["enUS"] = true,
        ["frFR"] = "Auchindoun",
        ["esES"] = "Auchindoun",
        ["zhTW"] = "奧齊頓",
        ["zhCN"] = "奥金顿",
    },
    ["Thuron's Livery"] = {
        ["ptBR"] = "Cocheira de Thuron",
        ["ruRU"] = "Стойла Турона",
        ["deDE"] = "Thurons Aufzucht",
        ["koKR"] = "튜론의 매타조 훈련장",
        ["esMX"] = "Caballería de Thuron",
        ["enUS"] = true,
        ["frFR"] = "Écurie de Thuron",
        ["esES"] = "Caballería de Thuron",
        ["zhTW"] = "薩爾倫的出租商行",
        ["zhCN"] = "苏伦的养殖场",
    },
    ["Felspark Ravine"] = {
        ["ptBR"] = "Ravina de Vil Fagulha",
        ["ruRU"] = "Лощина Вспышки Скверны",
        ["deDE"] = "Teufelsfunkenklamm",
        ["koKR"] = "지옥불꽃 협곡",
        ["esMX"] = "Barranco Llama Infernal",
        ["enUS"] = true,
        ["frFR"] = "Ravin de Gangrétincelle",
        ["esES"] = "Barranco Burbujas Viles",
        ["zhTW"] = "魔焰深谷",
        ["zhCN"] = "魔火峡谷",
    },
    ["Andilien Estate"] = {
        ["ptBR"] = "Propriedade Andilien",
        ["ruRU"] = "Поместье Андилиен",
        ["deDE"] = "Andiliens Grund",
        ["koKR"] = "안딜리엔 영지",
        ["esMX"] = "Dominios Andilien",
        ["enUS"] = true,
        ["frFR"] = "Domaine d'Andilien",
        ["esES"] = "Dominios Andilien",
        ["zhTW"] = "安狄里安莊園",
        ["zhCN"] = "安迪尔林庄园",
    },
    ["Spirit Fields"] = {
        ["ptBR"] = "Campos dos Espíritos",
        ["ruRU"] = "Поля Духов",
        ["deDE"] = "Geisterfelder",
        ["koKR"] = "정기의 들판",
        ["esMX"] = "Campos de Espíritus",
        ["enUS"] = true,
        ["frFR"] = "Champs des esprits",
        ["esES"] = "Campos de Espíritus",
        ["zhTW"] = "靈魂原野",
        ["zhCN"] = "灵魂平原",
    },
    ["Forge Camp: Mageddon"] = {
        ["ptBR"] = "Campo-forja: Megido",
        ["ruRU"] = "Лагерь Легиона: Магеддон",
        ["deDE"] = "Konstruktionslager: Mageddon",
        ["koKR"] = "멸망의 괴철로 기지",
        ["esMX"] = "Campamento Forja: Mageddon",
        ["enUS"] = true,
        ["frFR"] = "Camp de forge : Mageddon",
        ["esES"] = "Campamento Forja: Mageddon",
        ["zhTW"] = "煉冶場:黑色祭壇",
        ["zhCN"] = "铸魔营地：暴虐",
    },
    ["Skethyl Mountains"] = {
        ["ptBR"] = "Montanhas Skethil",
        ["ruRU"] = "Горы Скетил",
        ["deDE"] = "Skethylberge",
        ["koKR"] = "스키실 산맥",
        ["esMX"] = "Montañas Skethyl",
        ["enUS"] = true,
        ["frFR"] = "Monts Skethyl",
        ["esES"] = "Montañas Skethyl",
        ["zhTW"] = "斯其索山脈",
        ["zhCN"] = "鸦羽山",
    },
    ["Expedition Armory"] = {
        ["ptBR"] = "Arsenal da Expedição",
        ["ruRU"] = "Оружейная экспедиции",
        ["deDE"] = "Expeditionsrüstlager",
        ["koKR"] = "원정대 무기고",
        ["esMX"] = "Armería de Expedición",
        ["enUS"] = true,
        ["frFR"] = "Armurerie de l'expédition",
        ["esES"] = "Armería de Expedición",
        ["zhTW"] = "遠征隊軍械庫",
        ["zhCN"] = "远征军物资库",
    },
    ["East Sanctum"] = {
        ["ptBR"] = "Sacrário do Leste",
        ["ruRU"] = "Восточное святилище",
        ["deDE"] = "Sanktum des Ostens",
        ["koKR"] = "동부 성소",
        ["esMX"] = "Sagrario del Este",
        ["enUS"] = true,
        ["frFR"] = "Sanctum oriental",
        ["esES"] = "Sagrario del Este",
        ["zhTW"] = "東部聖所",
        ["zhCN"] = "东部圣殿",
    },
    ["The Drain"] = {
        ["ptBR"] = "O Escoadouro",
        ["ruRU"] = "Стоки",
        ["deDE"] = "Der Abfluss",
        ["koKR"] = "배수로",
        ["esMX"] = "El Vaciado",
        ["enUS"] = true,
        ["frFR"] = "La Vidange",
        ["esES"] = "El Vaciado",
        ["zhTW"] = "排水之地",
        ["zhCN"] = "排水泵",
    },
    ["Ammen Vale"] = {
        ["ptBR"] = "Vale Ammen",
        ["ruRU"] = "Долина Аммен",
        ["deDE"] = "Am'mental",
        ["koKR"] = "암멘 골짜기",
        ["esMX"] = "Valle Ammen",
        ["enUS"] = true,
        ["frFR"] = "Val d'Ammen",
        ["esES"] = "Valle Ammen",
        ["zhTW"] = "安曼谷",
        ["zhCN"] = "埃门谷",
    },
    ["Shrine of Dath'Remar"] = {
        ["ptBR"] = "Altar de Dath'Remar",
        ["ruRU"] = "Святилище Дат'Ремара",
        ["deDE"] = "Schrein von Dath'Remar",
        ["koKR"] = "다트리마의 제단",
        ["esMX"] = "Santuario de Dath'Remar",
        ["enUS"] = true,
        ["frFR"] = "Sanctuaire de Dath'Remar",
        ["esES"] = "Santuario de Dath'Remar",
        ["zhTW"] = "達斯雷瑪神殿",
        ["zhCN"] = "达斯雷玛的神龛",
    },
    ["Netherweb Ridge"] = {
        ["ptBR"] = "Serra Redetérea",
        ["ruRU"] = "Гряда Пустопутов",
        ["deDE"] = "Netherweberkamm",
        ["koKR"] = "황천그물 마루",
        ["esMX"] = "Cresta Red Abisal",
        ["enUS"] = true,
        ["frFR"] = "Crête de Toile-néant",
        ["esES"] = "Cresta Red Abisal",
        ["zhTW"] = "幽網山脊",
        ["zhCN"] = "灵网山脊",
    },
    ["Voidwind Plateau"] = {
        ["ptBR"] = "Platô dos Ventos do Caos",
        ["ruRU"] = "Плато Пустынного Ветра",
        ["deDE"] = "Leerenwindplateau",
        ["koKR"] = "공허의 바람 고원",
        ["esMX"] = "Meseta del Viento del Vacío",
        ["enUS"] = true,
        ["frFR"] = "Le plateau Vent-du-Vide",
        ["esES"] = "Meseta del Viento del Vacío",
        ["zhTW"] = "裂風高原",
        ["zhCN"] = "虚风高原",
    },
    ["Ango'rosh Grounds"] = {
        ["ptBR"] = "Terras de Ango'rosh",
        ["ruRU"] = "Земли Анго'рош",
        ["deDE"] = "Grund der Ango'rosh",
        ["koKR"] = "앙고로쉬 영토",
        ["esMX"] = "Dominios Ango'rosh",
        ["enUS"] = true,
        ["frFR"] = "Terres Ango'rosh",
        ["esES"] = "Dominios Ango'rosh",
        ["zhTW"] = "安格拉斯營地",
        ["zhCN"] = "安葛洛什营地",
    },
    ["Deathforge Tower"] = {
        ["ptBR"] = "Torre da Forja da Morte",
        ["ruRU"] = "Башня Кузницы Смерти",
        ["deDE"] = "Turm der Todesschmiede",
        ["koKR"] = "죽음의 괴철로 탑",
        ["esMX"] = "Torre de la Forja Muerta",
        ["enUS"] = true,
        ["frFR"] = "Tour de la Forgemort",
        ["esES"] = "Torre de la Forja Muerta",
        ["zhTW"] = "死亡熔爐哨塔",
        ["zhCN"] = "死亡熔炉哨塔",
    },
    ["Veil Lithic"] = {
        ["ptBR"] = "Véu Lithic",
        ["ruRU"] = "Гнездовье Литик",
        ["deDE"] = "Lithicversteck",
        ["koKR"] = "장막의 리디크",
        ["esMX"] = "Velo Lítico",
        ["enUS"] = true,
        ["frFR"] = "Voile Lithic",
        ["esES"] = "Velo Lítico",
        ["zhTW"] = "迷霧里斯克",
        ["zhCN"] = "雷希鸦巢",
    },
    ["Slag Watch"] = {
        ["ptBR"] = "Mirante da Escória",
        ["ruRU"] = "Вышка на золе",
        ["deDE"] = "Schlackenwacht",
        ["koKR"] = "잿가루 감시초소",
        ["esMX"] = "Vigía de la Escoria",
        ["enUS"] = true,
        ["frFR"] = "Guet des scories",
        ["esES"] = "Vigía de la Escoria",
        ["zhTW"] = "爐熔守望",
        ["zhCN"] = "熔渣哨塔",
    },
    ["Serpent Lake"] = {
        ["ptBR"] = "Lago Serpente",
        ["ruRU"] = "Змеиное озеро",
        ["deDE"] = "Schlangensee",
        ["koKR"] = "물갈퀴 호수",
        ["esMX"] = "Lago Serpiente",
        ["enUS"] = true,
        ["frFR"] = "Lac des Serpents",
        ["esES"] = "Lago Serpiente",
        ["zhTW"] = "毒蛇之湖",
        ["zhCN"] = "毒蛇湖",
    },
    ["North Sanctum"] = {
        ["ptBR"] = "Sacrário do Norte",
        ["ruRU"] = "Северное святилище",
        ["deDE"] = "Sanktum des Nordens",
        ["koKR"] = "북부 성소",
        ["esMX"] = "Sagrario del Norte",
        ["enUS"] = true,
        ["frFR"] = "Sanctum septentrional",
        ["esES"] = "Sagrario del Norte",
        ["zhTW"] = "北部聖所",
        ["zhCN"] = "北部圣殿",
    },
    ["Farstrider Retreat"] = {
        ["ptBR"] = "Retiro dos Andarilhos",
        ["ruRU"] = "Обитель Странников",
        ["deDE"] = "Zuflucht der Weltenwanderer",
        ["koKR"] = "원정순찰대 산장",
        ["esMX"] = "El Retiro del Errante",
        ["enUS"] = true,
        ["frFR"] = "Retraite des Pérégrins",
        ["esES"] = "El Retiro del Errante",
        ["zhTW"] = "遠行者居所",
        ["zhCN"] = "远行者居所",
    },
    ["The Dead Mire"] = {
        ["ptBR"] = "O Charco Fantasma",
        ["ruRU"] = "Мертвая трясина",
        ["deDE"] = "Das Todesmoor",
        ["koKR"] = "죽음의 늪",
        ["esMX"] = "El Lodo Muerto",
        ["enUS"] = true,
        ["frFR"] = "La Morte-bourbe",
        ["esES"] = "El Lodo Muerto",
        ["zhTW"] = "死亡污泥",
        ["zhCN"] = "死亡泥潭",
    },
    ["The Spawning Glen"] = {
        ["ptBR"] = "Vale dos Rebentos",
        ["ruRU"] = "Грибная поляна",
        ["deDE"] = "Das Pilzgeflecht",
        ["koKR"] = "부화의 골짜기",
        ["esMX"] = "La Cañada Emergente",
        ["enUS"] = true,
        ["frFR"] = "Le vallon des pontes",
        ["esES"] = "La Cañada Emergente",
        ["zhTW"] = "重生峽谷",
        ["zhCN"] = "孢殖林",
    },
    ["Magisters Gate"] = {
        ["ptBR"] = "Portão dos Magísteres",
        ["ruRU"] = "Врата Магистров",
        ["deDE"] = "Magistertor",
        ["koKR"] = "마법학자 관문",
        ["esMX"] = "Puerta Magister",
        ["enUS"] = true,
        ["frFR"] = "Porte du Magistère",
        ["esES"] = "Puerta Magister",
        ["zhTW"] = "博學者之門",
        ["zhCN"] = "魔导师之门",
    },
    ["Tower of the Damned"] = {
        ["ptBR"] = "Torre dos Malditos",
        ["ruRU"] = "Башня Проклятых",
        ["deDE"] = "Turm der Verdammten",
        ["koKR"] = "저주받은 자의 탑",
        ["esMX"] = "Torre de los Condenados",
        ["enUS"] = true,
        ["frFR"] = "Tour des damnés",
        ["esES"] = "Torre de los Condenados",
        ["zhTW"] = "詛咒神教之塔",
        ["zhCN"] = "诅咒之塔",
    },
    ["Sunsail Anchorage"] = {
        ["ptBR"] = "Ancoradouro Velaclara",
        ["ruRU"] = "Причал Солнечного Паруса",
        ["deDE"] = "Ankerplatz der Sonnensegel",
        ["koKR"] = "해돋이 부두",
        ["esMX"] = "Fondeadero Vela del Sol",
        ["enUS"] = true,
        ["frFR"] = "Mouillage des Voiles du soleil",
        ["esES"] = "Fondeadero Vela del Sol",
        ["zhTW"] = "日帆泊地",
        ["zhCN"] = "阳帆港",
    },
    ["Veil Shalas"] = {
        ["ptBR"] = "Véu Shalas",
        ["ruRU"] = "Гнездовье Шалас",
        ["deDE"] = "Shalasversteck",
        ["koKR"] = "장막의 샬라스",
        ["esMX"] = "Velo Shalas",
        ["enUS"] = true,
        ["frFR"] = "Voile Shalas",
        ["esES"] = "Velo Shalas",
        ["zhTW"] = "迷霧撒拉斯",
        ["zhCN"] = "沙拉斯鸦巢",
    },
    ["Blacksilt Shore"] = {
        ["ptBR"] = "Praia Trevareia",
        ["ruRU"] = "Берег Черного Ила",
        ["deDE"] = "Schwarzschlammküste",
        ["koKR"] = "검은진흙 해안",
        ["esMX"] = "Costa Cienonegro",
        ["enUS"] = true,
        ["frFR"] = "Le rivage des Vase-noire",
        ["esES"] = "Costa Cienonegro",
        ["zhTW"] = "黑泥沙海岸",
        ["zhCN"] = "黑沙海岸",
    },
    ["Isle of Tribulations"] = {
        ["ptBR"] = "Ilha das Tribulações",
        ["ruRU"] = "Остров Напастей",
        ["deDE"] = "Insel des Martyriums",
        ["koKR"] = "고행의 섬",
        ["esMX"] = "Isla de las Tribulaciones",
        ["enUS"] = true,
        ["frFR"] = "Ile des Tribulations",
        ["esES"] = "Isla de las Tribulaciones",
        ["zhTW"] = "磨難之島",
        ["zhCN"] = "苦难岛",
    },
    ["The Ring of Blood"] = {
        ["ptBR"] = "Ringue de Sangue",
        ["ruRU"] = "Кольцо Крови",
        ["deDE"] = "Der Ring des Blutes",
        ["koKR"] = "피의 투기장",
        ["esMX"] = "El Círculo de Sangre",
        ["enUS"] = true,
        ["frFR"] = "L'arène de sang",
        ["esES"] = "El Círculo de Sangre",
        ["zhTW"] = "血色競技場",
        ["zhCN"] = "鲜血竞技场",
    },
    ["Golden Strand"] = {
        ["ptBR"] = "Areal Dourado",
        ["ruRU"] = "Золотистое взморье",
        ["deDE"] = "Der goldene Strand",
        ["koKR"] = "황금 해안",
        ["esMX"] = "La Ensenada Dorada",
        ["enUS"] = true,
        ["frFR"] = "Grève dorée",
        ["esES"] = "La Ensenada Dorada",
        ["zhTW"] = "金色湖岸",
        ["zhCN"] = "金色沙滩",
    },
    ["Orebor Harborage"] = {
        ["ptBR"] = "Porto Orebor",
        ["ruRU"] = "Прибежище Оребор",
        ["deDE"] = "Oreborzuflucht",
        ["koKR"] = "오레보르 피난처",
        ["esMX"] = "Puerto Orebor",
        ["enUS"] = true,
        ["frFR"] = "Havre d'Orebor",
        ["esES"] = "Puerto Orebor",
        ["zhTW"] = "奧雷伯爾港",
        ["zhCN"] = "奥雷柏尔营地",
    },
    ["Rivendark's Perch"] = {
        ["ptBR"] = "Ninho do Rivenegro",
        ["ruRU"] = "Гнездо Чернокрыла",
        ["deDE"] = "Nachtreißers Hort",
        ["koKR"] = "리븐다크의 둥지",
        ["esMX"] = "Nido de Desgarro Oscuro",
        ["enUS"] = true,
        ["frFR"] = "Perchoir de Clivenuit",
        ["esES"] = "Nido de Desgarro Oscuro",
        ["zhTW"] = "瑞文達科棲所",
        ["zhCN"] = "雷文达克栖木",
    },
    ["Insidion's Perch"] = {
        ["ptBR"] = "Ninho do Insidion",
        ["ruRU"] = "Гнездо Инсидиона",
        ["deDE"] = "Insidions Hort",
        ["koKR"] = "인시디온의 둥지",
        ["esMX"] = "Nido de Insidion",
        ["enUS"] = true,
        ["frFR"] = "Perchoir d'Insidion",
        ["esES"] = "Nido de Insidion",
        ["zhTW"] = "印希迪恩棲所",
        ["zhCN"] = "因斯迪安栖木",
    },
    ["Bash'ir Landing"] = {
        ["ptBR"] = "Patamar de Bash'ir",
        ["ruRU"] = "Лагерь Баш'ира",
        ["deDE"] = "Landeplatz von Bash'ir",
        ["koKR"] = "바쉬르 영지",
        ["esMX"] = "Alto Bash'ir",
        ["enUS"] = true,
        ["frFR"] = "Point d'ancrage de Bash'ir",
        ["esES"] = "Alto Bash'ir",
        ["zhTW"] = "貝許爾平臺",
        ["zhCN"] = "巴什伊尔码头",
    },
    ["The North Sea"] = {
        ["ptBR"] = "Mar do Norte",
        ["ruRU"] = "Северное море",
        ["deDE"] = "Das nördliche Meer",
        ["koKR"] = "북해",
        ["esMX"] = "El Mar del Norte",
        ["enUS"] = true,
        ["frFR"] = "La mer Boréale",
        ["esES"] = "El Mar Norte",
        ["zhTW"] = "北方海岸",
        ["zhCN"] = "北海",
    },
    ["Feralfen Village"] = {
        ["ptBR"] = "Vila do Charco das Feras",
        ["ruRU"] = "Деревня Дикотопь",
        ["deDE"] = "Wildfenn",
        ["koKR"] = "야생늪 마을",
        ["esMX"] = "Aldea Feropantano",
        ["enUS"] = true,
        ["frFR"] = "Tourbe-farouche",
        ["esES"] = "Aldea Feropantano",
        ["zhTW"] = "菲拉芬村",
        ["zhCN"] = "蛮沼村",
    },
    ["Terokk's Rest"] = {
        ["ptBR"] = "Repouso de Terokk",
        ["ruRU"] = "Покой Терокка",
        ["deDE"] = "Terokks Ruh",
        ["koKR"] = "테로크의 안식처",
        ["esMX"] = "Sosiego de Terokk",
        ["enUS"] = true,
        ["frFR"] = "Repos de Terokk",
        ["esES"] = "Sosiego de Terokk",
        ["zhTW"] = "泰洛克之墓",
        ["zhCN"] = "泰罗克之墓",
    },
    ["Kirin'Var Village"] = {
        ["ptBR"] = "Vila Kirin'Var",
        ["ruRU"] = "Деревня Кирин'Вар",
        ["deDE"] = "Kirin'Var",
        ["koKR"] = "키린바르 마을",
        ["esMX"] = "Poblado Kirin'Var",
        ["enUS"] = true,
        ["frFR"] = "Kirin'Var",
        ["esES"] = "Poblado Kirin'Var",
        ["zhTW"] = "肯瑞瓦村莊",
        ["zhCN"] = "肯瑞瓦村",
    },
    ["Dragonmaw Fortress"] = {
        ["ptBR"] = "Fortaleza Presa do Dragão",
        ["ruRU"] = "Крепость Драконьей Пасти",
        ["deDE"] = "Festung des Drachenmals",
        ["koKR"] = "용아귀 요새",
        ["esMX"] = "Fortaleza Faucedraco",
        ["enUS"] = true,
        ["frFR"] = "Forteresse Gueule-de-dragon",
        ["esES"] = "Fortaleza Faucedraco",
        ["zhTW"] = "龍喉堡壘",
        ["zhCN"] = "龙喉要塞",
    },
    ["Manaforge Duro"] = {
        ["ptBR"] = "Manaforja Dúria",
        ["ruRU"] = "Манагорн Даро",
        ["deDE"] = "Manaschmiede Duro",
        ["koKR"] = "듀로 마나괴철로",
        ["esMX"] = "Forja de Maná Duro",
        ["enUS"] = true,
        ["frFR"] = "Manaforge Duro",
        ["esES"] = "Forja de Maná Duro",
        ["zhTW"] = "法力熔爐杜羅",
        ["zhCN"] = "法力熔炉：杜隆",
    },
    ["Grangol'var Village"] = {
        ["ptBR"] = "Aldeia Grangol'var",
        ["ruRU"] = "Деревня Грангол'вар",
        ["deDE"] = "Grangol'var",
        ["koKR"] = "그란골바르 마을",
        ["esMX"] = "Poblado Grangol'var",
        ["enUS"] = true,
        ["frFR"] = "Grangol'var",
        ["esES"] = "Poblado Grangol'var",
        ["zhTW"] = "葛蘭戈瓦村",
        ["zhCN"] = "格兰戈瓦村",
    },
    ["Skyguard Outpost"] = {
        ["ptBR"] = "Posto Avançado da Guarda Aérea",
        ["ruRU"] = "Застава Стражи Небес",
        ["deDE"] = "Außenposten der Himmelswache",
        ["koKR"] = "하늘경비대 전초기지",
        ["esMX"] = "Avanzada de la Guardia del Cielo",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste de la Garde-ciel",
        ["esES"] = "Avanzada de la Guardia del Cielo",
        ["zhTW"] = "禦天者崗哨",
        ["zhCN"] = "天空卫队哨站",
    },
    ["Vim'gol's Circle"] = {
        ["ptBR"] = "Círculo de Vim'gol",
        ["ruRU"] = "Круг Вим'гола",
        ["deDE"] = "Vim'gols Kreis",
        ["koKR"] = "빔골의 마법진",
        ["esMX"] = "Anillo de Vim'gol",
        ["enUS"] = true,
        ["frFR"] = "Le cercle de Vim'gol",
        ["esES"] = "Anillo de Vim'gol",
        ["zhTW"] = "梵戈之環",
        ["zhCN"] = "维姆高尔的法阵",
    },
    ["Sorrow Wing Point"] = {
        ["ptBR"] = "Ilha Pesarasa",
        ["ruRU"] = "Вершина Крыльев Скорби",
        ["deDE"] = "Stätte der Gramschwingen",
        ["koKR"] = "슬픔의 날개 거점",
        ["esMX"] = "Punta Alapenas",
        ["enUS"] = true,
        ["frFR"] = "Halte Aile-du-chargrin",
        ["esES"] = "Punta Alapenas",
        ["zhTW"] = "憂傷之翼哨站",
        ["zhCN"] = "悲翼之地",
    },
    ["Vekhaar Stand"] = {
        ["ptBR"] = "Bosque de Vekhaar",
        ["ruRU"] = "Перелесок Векхаар",
        ["deDE"] = "Vekhaar",
        ["koKR"] = "베크하르 고원",
        ["esMX"] = "Alto Vekhaar",
        ["enUS"] = true,
        ["frFR"] = "Le séjour de Vekhaar",
        ["esES"] = "Alto Vekhaar",
        ["zhTW"] = "維克哈爾看臺",
        ["zhCN"] = "维克哈营地",
    },
    ["Furywing's Perch"] = {
        ["ptBR"] = "Ninho do Furialada",
        ["ruRU"] = "Гнездовье Ярокрыла",
        ["deDE"] = "Zornschwinges Hort",
        ["koKR"] = "퓨리윙의 둥지",
        ["esMX"] = "Nido de Alafuria",
        ["enUS"] = true,
        ["frFR"] = "Perchoir d'Aile-furie",
        ["esES"] = "Nido de Alafuria",
        ["zhTW"] = "狂怒之翼棲所",
        ["zhCN"] = "弗雷文栖木",
    },
    ["Sunspring Post"] = {
        ["ptBR"] = "Posto Solavera",
        ["ruRU"] = "Застава Солнечного Источника",
        ["deDE"] = "Sonnenwindposten",
        ["koKR"] = "태양여울 주둔지",
        ["esMX"] = "Puesto Primasol",
        ["enUS"] = true,
        ["frFR"] = "Poste de Berceau-de-l'Eté",
        ["esES"] = "Puesto Primasol",
        ["zhTW"] = "日春崗哨",
        ["zhCN"] = "日泉岗哨",
    },
    ["Zeppelin Crash"] = {
        ["ptBR"] = "Zepelim Caído",
        ["ruRU"] = "Место крушения дирижабля",
        ["deDE"] = "Zeppelinabsturzstelle",
        ["koKR"] = "비행선 추락지",
        ["esMX"] = "Zepelín Caído",
        ["enUS"] = true,
        ["frFR"] = "L'épave du zeppelin",
        ["esES"] = "Zepelín Caído",
        ["zhTW"] = "飛艇失事地",
        ["zhCN"] = "飞艇坠毁点",
    },
    ["Thornfang Hill"] = {
        ["ptBR"] = "Monte Presacúleo",
        ["ruRU"] = "Холм Колючего Клыка",
        ["deDE"] = "Dornnebelhügel",
        ["koKR"] = "가시송곳니 언덕",
        ["esMX"] = "Colina Colmillespinado",
        ["enUS"] = true,
        ["frFR"] = "Colline de Roncecroc",
        ["esES"] = "Colina Colmillespinado",
        ["zhTW"] = "棘牙丘陵",
        ["zhCN"] = "棘牙岭",
    },
    ["Razorthorn Rise"] = {
        ["ptBR"] = "Morro Espinhoso",
        ["ruRU"] = "Уступ Острого Шипа",
        ["deDE"] = "Messerdornhöhe",
        ["koKR"] = "서슬가시 언덕",
        ["esMX"] = "Alto Rajaespina",
        ["enUS"] = true,
        ["frFR"] = "Éminence de Tranchépine",
        ["esES"] = "Alto Rajaespina",
        ["zhTW"] = "刺棘高地",
        ["zhCN"] = "荆刺高地",
    },
    ["Netherstorm"] = {
        ["ptBR"] = "Eternévoa",
        ["ruRU"] = "Пустоверть",
        ["deDE"] = "Nethersturm",
        ["koKR"] = "황천의 폭풍",
        ["esMX"] = "Tormenta Abisal",
        ["enUS"] = true,
        ["frFR"] = "Raz-de-Néant",
        ["esES"] = "Tormenta Abisal",
        ["zhTW"] = "虛空風暴",
        ["zhCN"] = "虚空风暴",
    },
    ["Sha'tari Outpost"] = {
        ["ptBR"] = "Posto Sha'tari",
        ["ruRU"] = "Застава Ша'тар",
        ["deDE"] = "Außenposten der Sha'tari",
        ["koKR"] = "샤타리 전초기지",
        ["esMX"] = "Avanzada Sha'tari",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste sha'tari",
        ["esES"] = "Avanzada Sha'tari",
        ["zhTW"] = "薩塔前哨",
        ["zhCN"] = "沙塔尔前哨站",
    },
    ["The Shadow Stair"] = {
        ["ptBR"] = "Escada das Sombras",
        ["ruRU"] = "Лестница Теней",
        ["deDE"] = "Die Schattentreppe",
        ["koKR"] = "어둠의 계단",
        ["esMX"] = "La Escalera Umbría",
        ["enUS"] = true,
        ["frFR"] = "L'escalier de l'Ombre",
        ["esES"] = "La Escalera Umbría",
        ["zhTW"] = "暗影階梯",
        ["zhCN"] = "暗影阶梯",
    },
    ["Wyrmscar Island"] = {
        ["ptBR"] = "Ilha Mal-da-serpe",
        ["ruRU"] = "Остров Драконьей Скорби",
        ["deDE"] = "Insel Drachenfels",
        ["koKR"] = "고룡흉터 섬",
        ["esMX"] = "Isla Cicatriz de Vermis",
        ["enUS"] = true,
        ["frFR"] = "Île Balafre-du-ver",
        ["esES"] = "Isla Cicatriz de Vermis",
        ["zhTW"] = "龍痕島",
        ["zhCN"] = "龙痕岛",
    },
    ["Hellfire Basin"] = {
        ["ptBR"] = "Bacia Fogo do Inferno",
        ["ruRU"] = "Яма Адского Пламени",
        ["deDE"] = "Höllenfeuerbecken",
        ["koKR"] = "지옥불 분지",
        ["esMX"] = "Cuenca del Fuego Infernal",
        ["enUS"] = true,
        ["frFR"] = "Bassin des Flammes infernales",
        ["esES"] = "Cuenca del Fuego Infernal",
        ["zhTW"] = "地獄火盆地",
        ["zhCN"] = "地狱火盆地",
    },
    ["Eversong Woods"] = {
        ["ptBR"] = "Floresta do Canto Eterno",
        ["ruRU"] = "Леса Вечной Песни",
        ["deDE"] = "Immersangwald",
        ["koKR"] = "영원노래 숲",
        ["esMX"] = "Bosque Canción Eterna",
        ["enUS"] = true,
        ["frFR"] = "Bois des Chants éternels",
        ["esES"] = "Bosque Canción Eterna",
        ["zhTW"] = "永歌森林",
        ["zhCN"] = "永歌森林",
    },
    ["Umbrafen Village"] = {
        ["ptBR"] = "Aldeia do Charco Sombrio",
        ["ruRU"] = "Деревня Тенетопь",
        ["deDE"] = "Umbrafenn",
        ["koKR"] = "그늘늪 마을",
        ["esMX"] = "Aldea Umbropantano",
        ["enUS"] = true,
        ["frFR"] = "Umbretourbe",
        ["esES"] = "Aldea Umbropantano",
        ["zhTW"] = "昂布拉凡村",
        ["zhCN"] = "暗泽村",
    },
    ["Telaar"] = {
        ["ptBR"] = "Telaar",
        ["ruRU"] = "Телаар",
        ["deDE"] = "Telaar",
        ["koKR"] = "텔라아르",
        ["esMX"] = "Telaar",
        ["enUS"] = true,
        ["frFR"] = "Telaar",
        ["esES"] = "Telaar",
        ["zhTW"] = "泰拉",
        ["zhCN"] = "塔拉",
    },
    ["Northwind Cleft"] = {
        ["ptBR"] = "Fenda do Vento Norte",
        ["ruRU"] = "Расщелина Северного Ветра",
        ["deDE"] = "Nordwindkluft",
        ["koKR"] = "북새바람 동굴",
        ["esMX"] = "Grieta del Viento Norte",
        ["enUS"] = true,
        ["frFR"] = "Faille de Norsevent",
        ["esES"] = "Grieta del Viento Norte",
        ["zhTW"] = "北風斷崖",
        ["zhCN"] = "北风裂谷",
    },
    ["Circle of Blood Arena"] = {
        ["ptBR"] = "Arena do Círculo Sangrento",
        ["ruRU"] = "Арена Круга Крови",
        ["deDE"] = "Arena des Zirkels des Blutes",
        ["koKR"] = "피의 투기장",
        ["esMX"] = "Arena del Anillo de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Arène du Cercle de sang",
        ["esES"] = "Arena del Anillo de Sangre",
        ["zhTW"] = "血之環競技場",
        ["zhCN"] = "鲜血之环竞技场",
    },
    ["Eclipsion Fields"] = {
        ["ptBR"] = "Campos Eclipsion",
        ["ruRU"] = "Поля Затмения",
        ["deDE"] = "Felder der Mondfinsternis",
        ["koKR"] = "해그늘 벌판",
        ["esMX"] = "Campos Eclipsianos",
        ["enUS"] = true,
        ["frFR"] = "Champs éclipsions",
        ["esES"] = "Campos Eclipsianos",
        ["zhTW"] = "伊克利普森農場",
        ["zhCN"] = "日蚀平原",
    },
    ["Evergrove"] = {
        ["ptBR"] = "Arvoredo Eterno",
        ["ruRU"] = "Вечная роща",
        ["deDE"] = "Der ewige Hain",
        ["koKR"] = "영원의 숲",
        ["esMX"] = "Soto Eterno",
        ["enUS"] = true,
        ["frFR"] = "Bosquet éternel",
        ["esES"] = "Soto Eterno",
        ["zhTW"] = "永恆樹林",
        ["zhCN"] = "常青林",
    },
    ["Crimson Watch"] = {
        ["ptBR"] = "Vigília Carmesim",
        ["ruRU"] = "Кровавый Дозор",
        ["deDE"] = "Purpurwacht",
        ["koKR"] = "붉은 감시초소",
        ["esMX"] = "Atalaya Carmesí",
        ["enUS"] = true,
        ["frFR"] = "Guet cramoisi",
        ["esES"] = "Atalaya Carmesí",
        ["zhTW"] = "赤紅守望",
        ["zhCN"] = "火红岗哨",
    },
    ["The Vortex Fields"] = {
        ["ptBR"] = "Campos de Vórtice",
        ["ruRU"] = "Вихревые поля",
        ["deDE"] = "Die Vortexfelder",
        ["koKR"] = "소용돌이 지대",
        ["esMX"] = "Los Campos del Vórtice",
        ["enUS"] = true,
        ["frFR"] = "Les champs du vortex",
        ["esES"] = "Los Campos del Vórtice",
        ["zhTW"] = "漩渦農場",
        ["zhCN"] = "漩涡平原",
    },
    ["Stonebreaker Hold"] = {
        ["ptBR"] = "Vila de Quebrapedra",
        ["ruRU"] = "Форт Камнеломов",
        ["deDE"] = "Steinbrecherfeste",
        ["koKR"] = "돌망치 요새",
        ["esMX"] = "Bastión Rompepedras",
        ["enUS"] = true,
        ["frFR"] = "Fort des Brise-pierres",
        ["esES"] = "Bastión Rompepedras",
        ["zhTW"] = "碎石堡",
        ["zhCN"] = "裂石堡",
    },
    ["Daggerfen Village"] = {
        ["ptBR"] = "Aldeia Lamadaga",
        ["ruRU"] = "Деревня Остротопь",
        ["deDE"] = "Dolchfenn",
        ["koKR"] = "비수늪 마을",
        ["esMX"] = "Aldea Dagapantano",
        ["enUS"] = true,
        ["frFR"] = "Tourbedague",
        ["esES"] = "Aldea Dagapantano",
        ["zhTW"] = "匕首沼地村",
        ["zhCN"] = "匕潭村",
    },
    ["Magma Fields"] = {
        ["ptBR"] = "Campos de Magma",
        ["ruRU"] = "Магмовые поля",
        ["deDE"] = "Magmafelder",
        ["koKR"] = "용암 지대",
        ["esMX"] = "Campos de Magma",
        ["enUS"] = true,
        ["frFR"] = "Champs de magma",
        ["esES"] = "Campos de Magma",
        ["zhTW"] = "熔岩平原",
        ["zhCN"] = "熔岩平原",
    },
    ["Blackwind Landing"] = {
        ["ptBR"] = "Campo de Pouso Ventonegro",
        ["ruRU"] = "Лагерь Черного Ветра",
        ["deDE"] = "Schattenwindlager",
        ["koKR"] = "검은바람 비행기지",
        ["esMX"] = "Alto de los Vientonegro",
        ["enUS"] = true,
        ["frFR"] = "Le Raie'odrome de Noirvent",
        ["esES"] = "Alto de los Vientonegro",
        ["zhTW"] = "黑風平臺",
        ["zhCN"] = "黑风码头",
    },
    ["Swamprat Post"] = {
        ["ptBR"] = "Mocó do Rato Lamacento",
        ["ruRU"] = "Застава Болотной Крысы",
        ["deDE"] = "Sumpfrattenposten",
        ["koKR"] = "늪쥐 감시초소",
        ["esMX"] = "Avanzada Rata del Pantano",
        ["enUS"] = true,
        ["frFR"] = "Poste du Rat des marais",
        ["esES"] = "Avanzada Rata del Pantano",
        ["zhTW"] = "斯溫派特崗哨",
        ["zhCN"] = "沼泽鼠岗哨",
    },
    ["The Scalding Pools"] = {
        ["ptBR"] = "Lagos Escaldantes",
        ["ruRU"] = "Жгучие пруды",
        ["deDE"] = "Die siedenden Teiche",
        ["koKR"] = "끓어오르는 웅덩이",
        ["esMX"] = "Las Pozas Escaldantes",
        ["enUS"] = true,
        ["frFR"] = "Les bassins Brûlants",
        ["esES"] = "Las Pozas Escaldantes",
        ["zhTW"] = "沸水池",
        ["zhCN"] = "滚烫熔池",
    },
    ["Netherwing Pass"] = {
        ["ptBR"] = "Trilha da Asa Etérea",
        ["ruRU"] = "Перевал Крыльев Пустоты",
        ["deDE"] = "Netherschwingenpass",
        ["koKR"] = "황천날개 고개",
        ["esMX"] = "Desfiladero del Ala Abisal",
        ["enUS"] = true,
        ["frFR"] = "Défilé de l'Aile-du-Néant",
        ["esES"] = "Desfiladero del Ala Abisal",
        ["zhTW"] = "虛空之翼小徑",
        ["zhCN"] = "灵翼小径",
    },
    ["Ghostlands"] = {
        ["ptBR"] = "Terra Fantasma",
        ["ruRU"] = "Призрачные земли",
        ["deDE"] = "Geisterlande",
        ["koKR"] = "유령의 땅",
        ["esMX"] = "Tierras Fantasma",
        ["enUS"] = true,
        ["frFR"] = "Les Terres fantômes",
        ["esES"] = "Tierras Fantasma",
        ["zhTW"] = "鬼魂之地",
        ["zhCN"] = "幽魂之地",
    },
    ["Gor'gaz Outpost"] = {
        ["ptBR"] = "Acampamento Gor'gaz",
        ["ruRU"] = "Форт Гор'газ",
        ["deDE"] = "Außenposten von Gor'gaz",
        ["koKR"] = "고르가즈 전초기지",
        ["esMX"] = "Avanzada Gor'gaz",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste de Gor'gaz",
        ["esES"] = "Avanzada Gor'gaz",
        ["zhTW"] = "葛卡茲哨站",
        ["zhCN"] = "高加兹前哨",
    },
    ["Lower City"] = {
        ["ptBR"] = "Bairro Inferior",
        ["ruRU"] = "Нижний город",
        ["deDE"] = "Unteres Viertel",
        ["koKR"] = "고난의 거리",
        ["esMX"] = "Bajo Arrabal",
        ["enUS"] = true,
        ["frFR"] = "Ville basse",
        ["esES"] = "Bajo Arrabal",
        ["zhTW"] = "陰鬱城",
        ["zhCN"] = "贫民窟",
    },
    ["Allerian Post"] = {
        ["ptBR"] = "Posto Alleriano",
        ["ruRU"] = "Застава Аллерии",
        ["deDE"] = "Allerias Posten",
        ["koKR"] = "알레리아 초소",
        ["esMX"] = "Puesto Allerian",
        ["enUS"] = true,
        ["frFR"] = "Poste allérien",
        ["esES"] = "Puesto Allerian",
        ["zhTW"] = "艾蘭里哨站",
        ["zhCN"] = "奥蕾莉亚岗哨",
    },
    ["Scalewing Shelf"] = {
        ["ptBR"] = "Planalto Escamasa",
        ["ruRU"] = "Склон Чешуекрылых",
        ["deDE"] = "Schuppenflügelbank",
        ["koKR"] = "비늘날개 절벽",
        ["esMX"] = "Plataforma Alaescama",
        ["enUS"] = true,
        ["frFR"] = "Saillie ailécaille",
        ["esES"] = "Plataforma Alaescama",
        ["zhTW"] = "鱗翼沙洲",
        ["zhCN"] = "鳞翼岩床",
    },
    ["Silvermyst Isle"] = {
        ["ptBR"] = "Ilha Nevoaprata",
        ["ruRU"] = "Остров Серебристой Дымки",
        ["deDE"] = "Silbermythosinsel",
        ["koKR"] = "은빛안개 섬",
        ["esMX"] = "Isla Bruma de Plata",
        ["enUS"] = true,
        ["frFR"] = "Île de Brume-argent",
        ["esES"] = "Isla Bruma de Plata",
        ["zhTW"] = "銀謎小島",
        ["zhCN"] = "秘银岛",
    },
    ["The Fetid Pool"] = {
        ["ptBR"] = "Lago Fétido",
        ["ruRU"] = "Зловонный пруд",
        ["deDE"] = "Der faulige Teich",
        ["koKR"] = "악취나는 웅덩이",
        ["esMX"] = "La Poza Fétida",
        ["enUS"] = true,
        ["frFR"] = "Le Bassin fétide",
        ["esES"] = "La Poza Fétida",
        ["zhTW"] = "惡臭水池",
        ["zhCN"] = "恶臭之池",
    },
    ["Mag'har Grounds"] = {
        ["ptBR"] = "Terras de Mag'har",
        ["ruRU"] = "Земли маг'харов",
        ["deDE"] = "Grund der Mag'har",
        ["koKR"] = "마그하르 영토",
        ["esMX"] = "Dominios Mag'har",
        ["enUS"] = true,
        ["frFR"] = "Terres Mag'har",
        ["esES"] = "Dominios Mag'har",
        ["zhTW"] = "瑪格哈營地",
        ["zhCN"] = "玛格汉台地",
    },
    ["Haal'eshi Gorge"] = {
        ["ptBR"] = "Desfiladeiro Haal'eshi",
        ["ruRU"] = "Теснина Хаал'эш",
        ["deDE"] = "Schlucht der Haal'eshi",
        ["koKR"] = "하알레쉬 협곡",
        ["esMX"] = "Garganta Haal'eshi",
        ["enUS"] = true,
        ["frFR"] = "Gorge Haal'eshi",
        ["esES"] = "Garganta Haal'eshi",
        ["zhTW"] = "海艾斯峽谷",
        ["zhCN"] = "哈尔什峡谷",
    },
    ["Halaani Basin"] = {
        ["ptBR"] = "Bacia Halaani",
        ["ruRU"] = "Котловина Халаани",
        ["deDE"] = "Halaanibecken",
        ["koKR"] = "할라아니 분지",
        ["esMX"] = "Cuenca Halaani",
        ["enUS"] = true,
        ["frFR"] = "Bassin halaani",
        ["esES"] = "Cuenca Halaani",
        ["zhTW"] = "哈剌尼盆地",
        ["zhCN"] = "哈兰盆地",
    },
    ["Sanctum of the Stars"] = {
        ["ptBR"] = "Sacrário Estelar",
        ["ruRU"] = "Святилище Звезд",
        ["deDE"] = "Sanktum der Sterne",
        ["koKR"] = "별의 성소",
        ["esMX"] = "Sagrario de las Estrellas",
        ["enUS"] = true,
        ["frFR"] = "Sanctum des Étoiles",
        ["esES"] = "Sagrario de las Estrellas",
        ["zhTW"] = "星光聖所",
        ["zhCN"] = "群星圣殿",
    },
    ["Sketh'lon Wreckage"] = {
        ["ptBR"] = "Ruínas de Sketh'lon",
        ["ruRU"] = "Развалины Скет'лона",
        ["deDE"] = "Wrack der Sketh'lon",
        ["koKR"] = "스케슬론 폐허",
        ["esMX"] = "Ruinas de Sketh'lon",
        ["enUS"] = true,
        ["frFR"] = "Débris sketh'lon",
        ["esES"] = "Ruinas de Sketh'lon",
        ["zhTW"] = "史凱瑟隆殘骸",
        ["zhCN"] = "斯克瑟隆废墟",
    },
    ["Olembas"] = {
        ["ptBR"] = "Olembas",
        ["ruRU"] = "Олембас",
        ["deDE"] = "Olembas",
        ["koKR"] = "올렘바스",
        ["esMX"] = "Olembas",
        ["enUS"] = true,
        ["frFR"] = "Olembas",
        ["esES"] = "Olembas",
        ["zhTW"] = "奧萊姆貝斯",
        ["zhCN"] = "欧雷巴斯",
    },
    ["Veil Skith"] = {
        ["ptBR"] = "Véu Skith",
        ["ruRU"] = "Гнездовье Скит",
        ["deDE"] = "Skithversteck",
        ["koKR"] = "장막의 스키스",
        ["esMX"] = "Velo Skith",
        ["enUS"] = true,
        ["frFR"] = "Voile Skith",
        ["esES"] = "Velo Skith",
        ["zhTW"] = "迷霧斯奇司",
        ["zhCN"] = "基斯鸦巢",
    },
    ["Bladespire Grounds"] = {
        ["ptBR"] = "Terras dos Giralança",
        ["ruRU"] = "Земли Камнерогов",
        ["deDE"] = "Grund der Speerspießer",
        ["koKR"] = "칼날첨탑 영토",
        ["esMX"] = "Dominios Aguja del Filo",
        ["enUS"] = true,
        ["frFR"] = "Terres de la Flèchelame",
        ["esES"] = "Dominios Aguja del Filo",
        ["zhTW"] = "劍刃庭園",
        ["zhCN"] = "刀塔平原",
    },
    ["Wyrmskull Bridge"] = {
        ["ptBR"] = "Ponte da Caveira de Dragão",
        ["ruRU"] = "Мост Драконьего Черепа",
        ["deDE"] = "Brücke des Wyrmschädels",
        ["koKR"] = "고룡해골 다리",
        ["esMX"] = "Puente Calavermis",
        ["enUS"] = true,
        ["frFR"] = "Pont Crâne-du-ver",
        ["esES"] = "Puente Calavermis",
        ["zhTW"] = "龍骨橋",
        ["zhCN"] = "龙颅之桥",
    },
    ["The Path of Conquest"] = {
        ["ptBR"] = "O Caminho da Conquista",
        ["ruRU"] = "Путь Завоевания",
        ["deDE"] = "Pfad der Eroberung",
        ["koKR"] = "정복의 길",
        ["esMX"] = "El Sendero de la Conquista",
        ["enUS"] = true,
        ["frFR"] = "La voie de la Conquête",
        ["esES"] = "El Sendero de la Conquista",
        ["zhTW"] = "征服之路",
        ["zhCN"] = "征服之路",
    },
    ["The Altar of Damnation"] = {
        ["ptBR"] = "Altar da Danação",
        ["ruRU"] = "Алтарь Проклятия",
        ["deDE"] = "Altar der Verdammnis",
        ["koKR"] = "저주의 제단",
        ["esMX"] = "El Altar de Condenación",
        ["enUS"] = true,
        ["frFR"] = "L'Autel de la damnation",
        ["esES"] = "El Altar de Condenación",
        ["zhTW"] = "詛咒祭壇",
        ["zhCN"] = "诅咒祭坛",
    },
    ["The Tempest Rift"] = {
        ["ptBR"] = "Fenda Tempestuosa",
        ["ruRU"] = "Пояс Бурь",
        ["deDE"] = "Kluft der Stürme",
        ["koKR"] = "폭풍우 균열",
        ["esMX"] = "La Falla de la Tempestad",
        ["enUS"] = true,
        ["frFR"] = "La Faille des tempêtes",
        ["esES"] = "La Falla de la Tempestad",
        ["zhTW"] = "風暴裂口",
        ["zhCN"] = "风暴裂隙",
    },
    ["Forge Camp: Terror"] = {
        ["ptBR"] = "Campo-forja: Terror",
        ["ruRU"] = "Лагерь Легиона: Ужас",
        ["deDE"] = "Konstruktionslager: Terror",
        ["koKR"] = "공포의 괴철로 기지",
        ["esMX"] = "Campamento Forja: Terror",
        ["enUS"] = true,
        ["frFR"] = "Camp de forge : Terreur",
        ["esES"] = "Campamento Forja: Terror",
        ["zhTW"] = "煉冶場:驚駭",
        ["zhCN"] = "铸魔营地：恐怖",
    },
    ["Boulder'mok"] = {
        ["ptBR"] = "Rocha'mok",
        ["ruRU"] = "Камен'мок",
        ["deDE"] = "Fels'mok",
        ["koKR"] = "바울더모크",
        ["esMX"] = "Peña'mok",
        ["enUS"] = true,
        ["frFR"] = "Roche'mok",
        ["esES"] = "Peña'mok",
        ["zhTW"] = "圓面之地",
        ["zhCN"] = "砾石营地",
    },
    ["Unused3"] = {
        ["ptBR"] = "Unused3",
        ["ruRU"] = "Unused3",
        ["deDE"] = "Unused3",
        ["koKR"] = "Unused3",
        ["esMX"] = "Unused3",
        ["enUS"] = true,
        ["frFR"] = "Unused3",
        ["esES"] = "Unused3",
        ["zhTW"] = "Unused3",
        ["zhCN"] = "Unused3",
    },
    ["Shattered Plains"] = {
        ["ptBR"] = "Platô Despedaçado",
        ["ruRU"] = "Разоренные равнины",
        ["deDE"] = "Zerschlagene Weiten",
        ["koKR"] = "부서진 평원",
        ["esMX"] = "Llanuras Devastadas",
        ["enUS"] = true,
        ["frFR"] = "Les plaines brisées",
        ["esES"] = "Llanuras Devastadas",
        ["zhTW"] = "破碎平原",
        ["zhCN"] = "破碎平原",
    },
    ["Bleeding Hollow Ruins"] = {
        ["ptBR"] = "Ruínas dos Olhos Sangrentos",
        ["ruRU"] = "Руины Кровавой Глазницы",
        ["deDE"] = "Ruinen des Blutenden Auges",
        ["koKR"] = "피투성이굴 폐허",
        ["esMX"] = "Ruinas Foso Sangrante",
        ["enUS"] = true,
        ["frFR"] = "Ruines de l'Orbite sanglante",
        ["esES"] = "Ruinas Foso Sangrante",
        ["zhTW"] = "血之谷廢墟",
        ["zhCN"] = "血环废墟",
    },
    ["Southmaul Tower"] = {
        ["ptBR"] = "Torre Martelo do Sul",
        ["ruRU"] = "Башня Южного Молота",
        ["deDE"] = "Südschlägerturm",
        ["koKR"] = "남녘망치 탑",
        ["esMX"] = "Torre Quiebrasur",
        ["enUS"] = true,
        ["frFR"] = "Tour Sud-sanglante",
        ["esES"] = "Torre Quiebrasur",
        ["zhTW"] = "南槌哨塔",
        ["zhCN"] = "南槌哨塔",
    },
    ["Plain of Shards"] = {
        ["ptBR"] = "Planície dos Fragmentos",
        ["ruRU"] = "Долина Осколков",
        ["deDE"] = "Splitterebene",
        ["koKR"] = "수정 들판",
        ["esMX"] = "Llanura de los Fragmentos",
        ["enUS"] = true,
        ["frFR"] = "Plaine des éclats",
        ["esES"] = "Llanura de los Fragmentos",
        ["zhTW"] = "裂片曠野",
        ["zhCN"] = "碎片平原",
    },
    ["Raastok Glade"] = {
        ["ptBR"] = "Clareira Raastok",
        ["ruRU"] = "Прогалина Раасток",
        ["deDE"] = "Raastokgrund",
        ["koKR"] = "라스토크 숲",
        ["esMX"] = "Claro Raastok",
        ["enUS"] = true,
        ["frFR"] = "Clairière de Raastok",
        ["esES"] = "Claro Raastok",
        ["zhTW"] = "羅史達克林地",
        ["zhCN"] = "拉斯托克林地",
    },
    ["Blade Tooth Canyon"] = {
        ["ptBR"] = "Garganta da Presa Cortante",
        ["ruRU"] = "Каньон Острого Зуба",
        ["deDE"] = "Säbelzahnschlucht",
        ["koKR"] = "칼날이빨 대협곡",
        ["esMX"] = "Cañón Dientespada",
        ["enUS"] = true,
        ["frFR"] = "Canyon de Lamecroc",
        ["esES"] = "Cañón Dientespada",
        ["zhTW"] = "劍齒峽谷",
        ["zhCN"] = "刃齿峡谷",
    },
    ["Shatter Point"] = {
        ["ptBR"] = "Posto Despedaçado",
        ["ruRU"] = "Парящая застава",
        ["deDE"] = "Trümmerposten",
        ["koKR"] = "징검다리 거점",
        ["esMX"] = "Puesto Devastación",
        ["enUS"] = true,
        ["frFR"] = "Halte du Fracas",
        ["esES"] = "Puesto Devastación",
        ["zhTW"] = "破碎崗哨",
        ["zhCN"] = "破碎岗哨",
    },
    ["Altar of Sha'tar"] = {
        ["ptBR"] = "Altar de Sha'tar",
        ["ruRU"] = "Алтарь Ша'тар",
        ["deDE"] = "Altar der Sha'tar",
        ["koKR"] = "샤타르 제단",
        ["esMX"] = "Altar de Sha'tar",
        ["enUS"] = true,
        ["frFR"] = "Autel de Sha'tar",
        ["esES"] = "Altar de Sha'tar",
        ["zhTW"] = "薩塔祭壇",
        ["zhCN"] = "沙塔尔祭坛",
    },
    ["Ruins of Farahlon"] = {
        ["ptBR"] = "Ruínas de Farahlon",
        ["ruRU"] = "Руины Фаралона",
        ["deDE"] = "Ruinen von Farahlon",
        ["koKR"] = "파랄론 폐허",
        ["esMX"] = "Ruinas de Farahlon",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Farahlon",
        ["esES"] = "Ruinas de Farahlon",
        ["zhTW"] = "法拉隆廢墟",
        ["zhCN"] = "法兰伦废墟",
    },
    ["Bloodcurse Isle"] = {
        ["ptBR"] = "Ilha do Sangue Maldito",
        ["ruRU"] = "Остров Проклятой Крови",
        ["deDE"] = "Insel des Blutfluchs",
        ["koKR"] = "핏빛저주의 섬",
        ["esMX"] = "Isla Sangre Maldita",
        ["enUS"] = true,
        ["frFR"] = "Île du sang maudit",
        ["esES"] = "Isla Sangre Maldita",
        ["zhTW"] = "血咒島",
        ["zhCN"] = "血咒岛",
    },
    ["Moongraze Woods"] = {
        ["ptBR"] = "Matas do Pasto Lunar",
        ["ruRU"] = "Леса Лунного Оленя",
        ["deDE"] = "Mondweidenwald",
        ["koKR"] = "달새김 숲",
        ["esMX"] = "Bosque Pasto Lunar",
        ["enUS"] = true,
        ["frFR"] = "Bois frôle-lune",
        ["esES"] = "Bosque Pasto Lunar",
        ["zhTW"] = "牧月森林",
        ["zhCN"] = "月痕林地",
    },
    ["Sporewind Lake"] = {
        ["ptBR"] = "Lago dos Esporos",
        ["ruRU"] = "Озеро Спороветра",
        ["deDE"] = "Sporenwindsee",
        ["koKR"] = "포자바람 호수",
        ["esMX"] = "Lago Espora Volante",
        ["enUS"] = true,
        ["frFR"] = "Lac Ventespore",
        ["esES"] = "Lago Espora Volante",
        ["zhTW"] = "孢子風之湖",
        ["zhCN"] = "孢子湖",
    },
    ["The Shepherd's Gate"] = {
        ["ptBR"] = "Portão do Pastor",
        ["ruRU"] = "Ворота Пастыря",
        ["deDE"] = "Hirtentor",
        ["koKR"] = "수호자의 관문",
        ["esMX"] = "La Puerta del Pastor",
        ["enUS"] = true,
        ["frFR"] = "Porte du Berger",
        ["esES"] = "La Puerta del Pastor",
        ["zhTW"] = "牧羊人之門",
        ["zhCN"] = "牧羊人之门",
    },
    ["Fairbridge Strand"] = {
        ["ptBR"] = "Praia Pontebela",
        ["ruRU"] = "Берег у Крепкого моста",
        ["deDE"] = "Morgentaustrand",
        ["koKR"] = "구름다리 해변",
        ["esMX"] = "Playa Puentegrato",
        ["enUS"] = true,
        ["frFR"] = "Rivage de Pontgallant",
        ["esES"] = "Playa Puentegrato",
        ["zhTW"] = "美橋海岸",
        ["zhCN"] = "玉桥海滩",
    },
    ["Runestone Shan'dor"] = {
        ["ptBR"] = "Pedra Rúnica Shan'dor",
        ["ruRU"] = "Рунический камень Шан'дор",
        ["deDE"] = "Runenstein Shan'dor",
        ["koKR"] = "샨도르 마법석",
        ["esMX"] = "Piedra Rúnica Shan'dor",
        ["enUS"] = true,
        ["frFR"] = "Pierre runique Shan'dor",
        ["esES"] = "Piedra Rúnica Shan'dor",
        ["zhTW"] = "符石夏納多爾",
        ["zhCN"] = "杉多尔符文石",
    },
    ["Runestone Falithas"] = {
        ["ptBR"] = "Pedra Rúnica Falithas",
        ["ruRU"] = "Рунический камень Фалитас",
        ["deDE"] = "Runenstein Falithas",
        ["koKR"] = "팔리타스 마법석",
        ["esMX"] = "Piedra Rúnica Falithas",
        ["enUS"] = true,
        ["frFR"] = "Pierre runique Falithas",
        ["esES"] = "Piedra Rúnica Falithas",
        ["zhTW"] = "符石菲薩斯",
        ["zhCN"] = "法利萨斯符文石",
    },
    ["Den of Haal'esh"] = {
        ["ptBR"] = "Antro de Haal'esh",
        ["ruRU"] = "Логово Хаал'эш",
        ["deDE"] = "Haal'eshbau",
        ["koKR"] = "하알레쉬 소굴",
        ["esMX"] = "Cubil de Haal'esh",
        ["enUS"] = true,
        ["frFR"] = "Tanière des Haal'esh",
        ["esES"] = "Cubil de Haal'esh",
        ["zhTW"] = "海艾斯洞穴",
        ["zhCN"] = "哈尔什巢穴",
    },
    ["Telaari Basin"] = {
        ["ptBR"] = "Bacia Telaari",
        ["ruRU"] = "Телаарская котловина",
        ["deDE"] = "Telaaribecken",
        ["koKR"] = "텔라아리 분지",
        ["esMX"] = "Cuenca Telaari",
        ["enUS"] = true,
        ["frFR"] = "Bassin telaari",
        ["esES"] = "Cuenca Telaari",
        ["zhTW"] = "泰拉蕊盆地",
        ["zhCN"] = "塔拉盆地",
    },
    ["Netherwing Mines"] = {
        ["ptBR"] = "Minas da Asa Etérea",
        ["ruRU"] = "Копи Крыльев Пустоты",
        ["deDE"] = "Netherschwingenminen",
        ["koKR"] = "황천날개 광산",
        ["esMX"] = "Minas del Ala Abisal",
        ["enUS"] = true,
        ["frFR"] = "Mines de l'Aile-du-Néant",
        ["esES"] = "Minas del Ala Abisal",
        ["zhTW"] = "虛空之翼礦坑",
        ["zhCN"] = "灵翼矿洞",
    },
    ["The Living Grove"] = {
        ["ptBR"] = "Bosque Vicejante",
        ["ruRU"] = "Живая роща",
        ["deDE"] = "Der lebende Hain",
        ["koKR"] = "생명의 숲",
        ["esMX"] = "La Arboleda Viviente",
        ["enUS"] = true,
        ["frFR"] = "Le Bosquet vivant",
        ["esES"] = "La Arboleda Viviente",
        ["zhTW"] = "生命之林",
        ["zhCN"] = "活木林",
    },
    ["Ruins of Enkaat"] = {
        ["ptBR"] = "Ruínas de Enkaat",
        ["ruRU"] = "Руины Энкаата",
        ["deDE"] = "Ruinen von Enkaat",
        ["koKR"] = "엔카트 폐허",
        ["esMX"] = "Ruinas de Enkaat",
        ["enUS"] = true,
        ["frFR"] = "Ruines d'Enkaat",
        ["esES"] = "Ruinas de Enkaat",
        ["zhTW"] = "安卡特廢墟",
        ["zhCN"] = "恩卡特废墟",
    },
    ["Halaa"] = {
        ["ptBR"] = "Halaa",
        ["ruRU"] = "Халаа",
        ["deDE"] = "Halaa",
        ["koKR"] = "할라아",
        ["esMX"] = "Halaa",
        ["enUS"] = true,
        ["frFR"] = "Halaa",
        ["esES"] = "Halaa",
        ["zhTW"] = "哈剌",
        ["zhCN"] = "哈兰",
    },
    ["Temple of Telhamat"] = {
        ["ptBR"] = "Templo de Telhamat",
        ["ruRU"] = "Храм Телхамат",
        ["deDE"] = "Tempel von Telhamat",
        ["koKR"] = "텔하마트 사원",
        ["esMX"] = "Templo de Telhamat",
        ["enUS"] = true,
        ["frFR"] = "Temple de Telhamat",
        ["esES"] = "Templo de Telhamat",
        ["zhTW"] = "特爾哈曼神廟",
        ["zhCN"] = "塔哈玛特神殿",
    },
    ["Stonewall Canyon"] = {
        ["ptBR"] = "Garganta de Pedra",
        ["ruRU"] = "Каньон Каменной Стены",
        ["deDE"] = "Steinwallschlucht",
        ["koKR"] = "돌담 협곡",
        ["esMX"] = "Cañón de la Muralla",
        ["enUS"] = true,
        ["frFR"] = "Canyon de la Muraille",
        ["esES"] = "Cañón de la Muralla",
        ["zhTW"] = "石鐮峽谷",
        ["zhCN"] = "石墙峡谷",
    },
    ["Mystwood"] = {
        ["ptBR"] = "Bosque das Névoas",
        ["ruRU"] = "Таинственная роща",
        ["deDE"] = "Mythoswald",
        ["koKR"] = "안개숲",
        ["esMX"] = "Bosque Bruma",
        ["enUS"] = true,
        ["frFR"] = "Bois brumeux",
        ["esES"] = "Bosque Bruma",
        ["zhTW"] = "神秘森林",
        ["zhCN"] = "神木林",
    },
    ["The Lost Fold"] = {
        ["ptBR"] = "Recôncavo Perdido",
        ["ruRU"] = "Затерянная Падь",
        ["deDE"] = "Die verlorene Furt",
        ["koKR"] = "잃어버린 언덕",
        ["esMX"] = "El Aprisco Perdido",
        ["enUS"] = true,
        ["frFR"] = "Le Repli perdu",
        ["esES"] = "El Aprisco Perdido",
        ["zhTW"] = "遺忘農場",
        ["zhCN"] = "损坏的兽笼",
    },
    ["Aeris Landing"] = {
        ["ptBR"] = "Posto Aeris",
        ["ruRU"] = "Небесный лагерь",
        ["deDE"] = "Aerissteg",
        ["koKR"] = "에어리스 착륙지",
        ["esMX"] = "Desembarco Aeris",
        ["enUS"] = true,
        ["frFR"] = "Point d'ancrage Aeris",
        ["esES"] = "Desembarco Aeris",
        ["zhTW"] = "艾瑞斯平臺",
        ["zhCN"] = "埃瑞斯码头",
    },
    ["Chapel Yard"] = {
        ["ptBR"] = "Pátio da Capela",
        ["ruRU"] = "Церковный двор",
        ["deDE"] = "Kapellenhof",
        ["koKR"] = "예배당 지구",
        ["esMX"] = "Patio de la Capilla",
        ["enUS"] = true,
        ["frFR"] = "Cour de la chapelle",
        ["esES"] = "Patio de la Capilla",
        ["zhTW"] = "教堂庭院",
        ["zhCN"] = "礼拜堂广场",
    },
    ["The High Path"] = {
        ["ptBR"] = "Caminho Alto",
        ["ruRU"] = "Верхний путь",
        ["deDE"] = "Der Hochpfad",
        ["koKR"] = "높은길",
        ["esMX"] = "El Paso Elevado",
        ["enUS"] = true,
        ["frFR"] = "Le Haut chemin",
        ["esES"] = "El Paso Elevado",
        ["zhTW"] = "險惡之地",
        ["zhCN"] = "高原小径",
    },
    ["Bristlelimb Enclave"] = {
        ["ptBR"] = "Enclave dos Ericerdos",
        ["ruRU"] = "Анклав Косолапов",
        ["deDE"] = "Enklave der Sichelklauen",
        ["koKR"] = "뾰족가지 군락",
        ["esMX"] = "Enclave Brazolanudo",
        ["enUS"] = true,
        ["frFR"] = "L'enclave des Bras-hirsutes",
        ["esES"] = "Enclave Brazolanudo",
        ["zhTW"] = "鬚肢營地",
        ["zhCN"] = "刺臂领地",
    },
    ["Sun's Reach Sanctum"] = {
        ["ptBR"] = "Sacrário Beirassol",
        ["ruRU"] = "Святилище Солнечного Края",
        ["deDE"] = "Sanktum der Sonnenweiten",
        ["koKR"] = "태양너울 성소",
        ["esMX"] = "Sagrario de Tramo del Sol",
        ["enUS"] = true,
        ["frFR"] = "Sanctum des Confins du soleil",
        ["esES"] = "Sagrario de Tramo del Sol",
        ["zhTW"] = "日境聖所",
        ["zhCN"] = "阳湾圣殿",
    },
    ["Veridian Point"] = {
        ["ptBR"] = "Ponta Viridiana",
        ["ruRU"] = "Вершина Веридиан",
        ["deDE"] = "Viridiangrund",
        ["koKR"] = "청록 해안",
        ["esMX"] = "Punta Veridiana",
        ["enUS"] = true,
        ["frFR"] = "Cap viridien",
        ["esES"] = "Punta Veridiana",
        ["zhTW"] = "翠綠崗哨",
        ["zhCN"] = "绿龙尖岬",
    },
    ["The Bloodwash"] = {
        ["ptBR"] = "Maré Sangrenta",
        ["ruRU"] = "Кровавый Прибой",
        ["deDE"] = "Blutbrandung",
        ["koKR"] = "핏빛 여울",
        ["esMX"] = "La Playa de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Le Reflux sanglant",
        ["esES"] = "La Playa de Sangre",
        ["zhTW"] = "血浴之地",
        ["zhCN"] = "血浪海滩",
    },
    ["The Warp Piston"] = {
        ["ptBR"] = "Pistão Dimensional",
        ["ruRU"] = "Сверхускоритель",
        ["deDE"] = "Die Warpgondel",
        ["koKR"] = "초공간 추진기",
        ["esMX"] = "El Pistón de Distorsión",
        ["enUS"] = true,
        ["frFR"] = "Le piston de distorsion",
        ["esES"] = "El Pistón de Distorsión",
        ["zhTW"] = "星移活塞",
        ["zhCN"] = "跳跃引擎",
    },
    ["Windyreed Pass"] = {
        ["ptBR"] = "Desfiladeiro Canavento",
        ["ruRU"] = "Перевал Трепещущего Тростника",
        ["deDE"] = "Schilftanzpass",
        ["koKR"] = "바람갈대 고개",
        ["esMX"] = "Paso Junco Alabeado",
        ["enUS"] = true,
        ["frFR"] = "Passe de Ventejonc",
        ["esES"] = "Paso Junco Alabeado",
        ["zhTW"] = "風蘆小徑",
        ["zhCN"] = "风茅小径",
    },
    ["The Dead Scar"] = {
        ["ptBR"] = "A Trilha da Morte",
        ["ruRU"] = "Тропа Мертвых",
        ["deDE"] = "Die Todesschneise",
        ["koKR"] = "죽음의 흉터",
        ["esMX"] = "La Cicatriz Muerta",
        ["enUS"] = true,
        ["frFR"] = "La Malebrèche",
        ["esES"] = "La Cicatriz Muerta",
        ["zhTW"] = "死亡之痕",
        ["zhCN"] = "死亡之痕",
    },
    ["Forge Camp: Anger"] = {
        ["ptBR"] = "Campo-forja: Fúria",
        ["ruRU"] = "Лагерь Легиона: Злоба",
        ["deDE"] = "Konstruktionslager: Groll",
        ["koKR"] = "고통의 괴철로 기지",
        ["esMX"] = "Campamento Forja: Inquina",
        ["enUS"] = true,
        ["frFR"] = "Camp de forge : Colère",
        ["esES"] = "Campamento Forja: Inquina",
        ["zhTW"] = "煉冶場:怒氣",
        ["zhCN"] = "铸魔营地：怒火",
    },
    ["Oronok's Farm"] = {
        ["ptBR"] = "Fazenda de Oronok",
        ["ruRU"] = "Ферма Оронока",
        ["deDE"] = "Oronoks Hof",
        ["koKR"] = "오로노크의 농장",
        ["esMX"] = "Granja de Oronok",
        ["enUS"] = true,
        ["frFR"] = "Ferme d'Oronok",
        ["esES"] = "Granja de Oronok",
        ["zhTW"] = "歐朗諾克的農場",
        ["zhCN"] = "欧鲁诺克农场",
    },
    ["The Lagoon"] = {
        ["ptBR"] = "A Lagoa",
        ["ruRU"] = "Лагуна",
        ["deDE"] = "Die Lagune",
        ["koKR"] = "바다자리 호수",
        ["esMX"] = "La Laguna",
        ["enUS"] = true,
        ["frFR"] = "Le Lagon",
        ["esES"] = "La Laguna",
        ["zhTW"] = "瀉湖",
        ["zhCN"] = "环礁湖",
    },
    ["The Stair of Destiny"] = {
        ["ptBR"] = "Degraus do Destino",
        ["ruRU"] = "Ступени Судьбы",
        ["deDE"] = "Die Stufen des Schicksals",
        ["koKR"] = "운명의 계단",
        ["esMX"] = "Los Peldaños del Destino",
        ["enUS"] = true,
        ["frFR"] = "L'escalier du Destin",
        ["esES"] = "Los Peldaños del Destino",
        ["zhTW"] = "命運階梯",
        ["zhCN"] = "命运阶梯",
    },
    ["Stonebreaker Camp"] = {
        ["ptBR"] = "Acampamento Quebrapedra",
        ["ruRU"] = "Лагерь Камнеломов",
        ["deDE"] = "Steinbrecherlager",
        ["koKR"] = "돌망치 야영지",
        ["esMX"] = "Campamento Rompepedras",
        ["enUS"] = true,
        ["frFR"] = "Camp des Brise-pierres",
        ["esES"] = "Campamento Rompepedras",
        ["zhTW"] = "碎石營地",
        ["zhCN"] = "裂石营地",
    },
    ["Firewing Point"] = {
        ["ptBR"] = "Pontal Asardente",
        ["ruRU"] = "Лагерь Огнекрылых",
        ["deDE"] = "Posten der Feuerschwingen",
        ["koKR"] = "불꽃날개 거점",
        ["esMX"] = "Alto Ala de Fuego",
        ["enUS"] = true,
        ["frFR"] = "Halte Aile-de-feu",
        ["esES"] = "Alto Ala de Fuego",
        ["zhTW"] = "火翼崗哨",
        ["zhCN"] = "火翼岗哨",
    },
    ["Upper Veil Shil'ak"] = {
        ["ptBR"] = "Véu Shil'ak Superior",
        ["ruRU"] = "Верхнее гнездовье Шил'ак",
        ["deDE"] = "Oberes Shil'akversteck",
        ["koKR"] = "장막의 쉴라크 언덕",
        ["esMX"] = "Velo Shil'ak Alto",
        ["enUS"] = true,
        ["frFR"] = "Voile Shil'ak supérieur",
        ["esES"] = "Velo Shil'ak Alto",
        ["zhTW"] = "迷霧希拉克上層",
        ["zhCN"] = "上层夏尔克鸦巢",
    },
    ["Terrace of Light"] = {
        ["ptBR"] = "Terraço da Luz",
        ["ruRU"] = "Терраса Света",
        ["deDE"] = "Terrasse des Lichts",
        ["koKR"] = "빛의 정원",
        ["esMX"] = "Bancal de la Luz",
        ["enUS"] = true,
        ["frFR"] = "Terrasse de la Lumière",
        ["esES"] = "Bancal de la Luz",
        ["zhTW"] = "聖光露臺",
        ["zhCN"] = "圣光广场",
    },
    ["Midrealm Post"] = {
        ["ptBR"] = "Posto Terramédia",
        ["ruRU"] = "Застава срединных земель",
        ["deDE"] = "Mittelreichposten",
        ["koKR"] = "중앙 생태지구 주둔지",
        ["esMX"] = "Puesto de la Tierra Media",
        ["enUS"] = true,
        ["frFR"] = "Comptoir des Terres-médianes",
        ["esES"] = "Puesto de la Tierra Media",
        ["zhTW"] = "領地崗哨",
        ["zhCN"] = "中央圆顶哨站",
    },
    ["Cenarion Watchpost"] = {
        ["ptBR"] = "Guarita Cenariana",
        ["ruRU"] = "Кенарийский караульный пост",
        ["deDE"] = "Wachposten des Cenarius",
        ["koKR"] = "세나리온 감시초소",
        ["esMX"] = "Puesto de Vigilancia Cenarion",
        ["enUS"] = true,
        ["frFR"] = "Poste de garde cénarien",
        ["esES"] = "Puesto de Vigilancia Cenarion",
        ["zhTW"] = "塞納里奧看守站",
        ["zhCN"] = "塞纳里奥岗哨",
    },
    ["Oshu'gun"] = {
        ["ptBR"] = "Oshu'gun",
        ["ruRU"] = "Ошу'гун",
        ["deDE"] = "Oshu'gun",
        ["koKR"] = "오슈군",
        ["esMX"] = "Oshu'gun",
        ["enUS"] = true,
        ["frFR"] = "Oshu'gun",
        ["esES"] = "Oshu'gun",
        ["zhTW"] = "歐夏剛",
        ["zhCN"] = "沃舒古",
    },
    ["Writhing Mound"] = {
        ["ptBR"] = "Morro Retorcido",
        ["ruRU"] = "Перекопанный курган",
        ["deDE"] = "Der gequälte Hügel",
        ["koKR"] = "고뇌의 언덕",
        ["esMX"] = "Alcor Tortuoso",
        ["enUS"] = true,
        ["frFR"] = "Monticule grouillant",
        ["esES"] = "Alcor Tortuoso",
        ["zhTW"] = "苦痛山丘",
        ["zhCN"] = "痛苦之丘",
    },
    ["Arena Floor"] = {
        ["ptBR"] = "Pátio da Arena",
        ["ruRU"] = "Нижний уровень поля боя",
        ["deDE"] = "Arenagrund",
        ["koKR"] = "투기장",
        ["esMX"] = "El Suelo de la Arena",
        ["enUS"] = true,
        ["frFR"] = "Sol de l'arène",
        ["esES"] = "El Suelo de la Arena",
        ["zhTW"] = "競技場地面",
        ["zhCN"] = "竞技场",
    },
    ["Carrion Hill"] = {
        ["ptBR"] = "Monte Carniçal",
        ["ruRU"] = "Холм Падальщика",
        ["deDE"] = "Aashügel",
        ["koKR"] = "부패의 언덕",
        ["esMX"] = "Colina Carroña",
        ["enUS"] = true,
        ["frFR"] = "Colline des charognes",
        ["esES"] = "Colina Carroña",
        ["zhTW"] = "腐蝕嶺",
        ["zhCN"] = "腐臭山",
    },
    ["Tomb of Lights"] = {
        ["ptBR"] = "Tumba das Luzes",
        ["ruRU"] = "Гробница Света",
        ["deDE"] = "Grab des Lichts",
        ["koKR"] = "빛의 무덤",
        ["esMX"] = "Tumba de las Luces",
        ["enUS"] = true,
        ["frFR"] = "Tombeau des lumières",
        ["esES"] = "Tumba de las Luces",
        ["zhTW"] = "聖光之墓",
        ["zhCN"] = "圣光之墓",
    },
    ["The Hidden Reef"] = {
        ["ptBR"] = "Recife Oculto",
        ["ruRU"] = "Подводный риф",
        ["deDE"] = "Das versteckte Riff",
        ["koKR"] = "숨은 산호초",
        ["esMX"] = "El Arrecife Oculto",
        ["enUS"] = true,
        ["frFR"] = "Le récif caché",
        ["esES"] = "El Arrecife Oculto",
        ["zhTW"] = "隱秘沙洲",
        ["zhCN"] = "藏帆暗礁",
    },
    ["The Path of Glory"] = {
        ["ptBR"] = "Caminho da Glória",
        ["ruRU"] = "Путь Славы",
        ["deDE"] = "Der Pfad des Ruhms",
        ["koKR"] = "영광의 길",
        ["esMX"] = "El Camino a la Gloria",
        ["enUS"] = true,
        ["frFR"] = "Le sentier de la Gloire",
        ["esES"] = "El Camino a la Gloria",
        ["zhTW"] = "光榮之路",
        ["zhCN"] = "荣耀之路",
    },
    ["Darkcrest Enclave"] = {
        ["ptBR"] = "Enclave Cristanegra",
        ["ruRU"] = "Анклав Темного Гребня",
        ["deDE"] = "Enklave der Dunkelkämme",
        ["koKR"] = "암흑갈기 군락",
        ["esMX"] = "Enclave Cresta Oscura",
        ["enUS"] = true,
        ["frFR"] = "Enclave des sombrecrêtes",
        ["esES"] = "Enclave de la Cumbre Oscura",
        ["zhTW"] = "暗羽飛行地",
        ["zhCN"] = "暗潮营地",
    },
    ["Veil Rhaze"] = {
        ["ptBR"] = "Véu Rhaze",
        ["ruRU"] = "Гнездовье Рейз",
        ["deDE"] = "Rhazeversteck",
        ["koKR"] = "장막의 라제",
        ["esMX"] = "Velo Rhaze",
        ["enUS"] = true,
        ["frFR"] = "Voile Rhaze",
        ["esES"] = "Velo Rhaze",
        ["zhTW"] = "迷霧瑞漢茲",
        ["zhCN"] = "哈兹鸦巢",
    },
    ["Sunfire Point"] = {
        ["ptBR"] = "Pontal do Fogo Solar",
        ["ruRU"] = "Пик Солнечного Пламени",
        ["deDE"] = "Sonnenfeuergrund",
        ["koKR"] = "태양불꽃 거점",
        ["esMX"] = "Punta del Fuego Solar",
        ["enUS"] = true,
        ["frFR"] = "Halte du Feu solaire",
        ["esES"] = "Punta del Fuego Solar",
        ["zhTW"] = "烈日火焰崗哨",
        ["zhCN"] = "阳炎岗哨",
    },
    ["Geezle's Camp"] = {
        ["ptBR"] = "Acampamento do Zé Ruela",
        ["ruRU"] = "Лагерь Гизла",
        ["deDE"] = "Geezles Lager",
        ["koKR"] = "기즐의 야영지",
        ["esMX"] = "Campamento de Geezle",
        ["enUS"] = true,
        ["frFR"] = "Camp de Geezle",
        ["esES"] = "Campamento de Geezle",
        ["zhTW"] = "吉索的營地",
        ["zhCN"] = "吉兹尔的营地",
    },
    ["Dragonmaw Skyway"] = {
        ["ptBR"] = "Ponte Aérea Presa do Dragão",
        ["ruRU"] = "Заоблачная тропа Драконьей Пасти",
        ["deDE"] = "Himmelspfad des Drachenmals",
        ["koKR"] = "용아귀 하늘길",
        ["esMX"] = "Ruta Aérea Faucedraco",
        ["enUS"] = true,
        ["frFR"] = "Couloir aérien des Gueules-de-dragon",
        ["esES"] = "Ruta Aérea Faucedraco",
        ["zhTW"] = "龍喉航線",
        ["zhCN"] = "龙喉空港",
    },
    ["Refugee Caravan"] = {
        ["ptBR"] = "Caravana dos Refugiados",
        ["ruRU"] = "Караван беженцев",
        ["deDE"] = "Flüchtlingskarawane",
        ["koKR"] = "피난민 행렬",
        ["esMX"] = "Caravana de Refugiados",
        ["enUS"] = true,
        ["frFR"] = "Caravane de réfugiés",
        ["esES"] = "Caravana de Refugiados",
        ["zhTW"] = "難民商隊",
        ["zhCN"] = "难民车队",
    },
    ["Eco-Dome Midrealm"] = {
        ["ptBR"] = "Eco-domo Terramédia",
        ["ruRU"] = "Заповедник \"Срединные земли\"",
        ["deDE"] = "Biokuppel Mittelreich",
        ["koKR"] = "중앙 생태지구",
        ["esMX"] = "Ecodomo de la Tierra Media",
        ["enUS"] = true,
        ["frFR"] = "Écodôme Terres-médianes",
        ["esES"] = "Ecodomo de la Tierra Media",
        ["zhTW"] = "秘境領地",
        ["zhCN"] = "中央生态圆顶",
    },
    ["Derelict Caravan"] = {
        ["ptBR"] = "Caravana Abandonada",
        ["ruRU"] = "Брошенный Караван",
        ["deDE"] = "Die herrenlose Karawane",
        ["koKR"] = "버려진 짐마차",
        ["esMX"] = "Caravana Derelicta",
        ["enUS"] = true,
        ["frFR"] = "Caravane abandonnée",
        ["esES"] = "Caravana Derelicta",
        ["zhTW"] = "被遺棄的商隊",
        ["zhCN"] = "被遗弃的篷车",
    },
    ["Spinebreaker Post"] = {
        ["ptBR"] = "Acampamento Quebra-espinha",
        ["ruRU"] = "Застава Хребтолома",
        ["deDE"] = "Rückenbrecherposten",
        ["koKR"] = "해골망치 초소",
        ["esMX"] = "Avanzada Rompeloma",
        ["enUS"] = true,
        ["frFR"] = "Poste de Brise-échine",
        ["esES"] = "Avanzada Rompeloma",
        ["zhTW"] = "斷脊氏族崗哨",
        ["zhCN"] = "断背岗哨",
    },
    ["Camp of Boom"] = {
        ["ptBR"] = "Acampamento do Dr. Cabum",
        ["ruRU"] = "Лагерь Бума",
        ["deDE"] = "Lager von Dr. Bumm",
        ["koKR"] = "붐의 야영지",
        ["esMX"] = "Campamento de Bum",
        ["enUS"] = true,
        ["frFR"] = "Camp de Boum",
        ["esES"] = "Campamento de Bum",
        ["zhTW"] = "布姆營地",
        ["zhCN"] = "砰砰博士的营地",
    },
    ["Wildwind Path"] = {
        ["ptBR"] = "Trilha Vento Selvagem",
        ["ruRU"] = "Штормовой путь",
        ["deDE"] = "Wildwindpfad",
        ["koKR"] = "갈기바람 길",
        ["esMX"] = "Senda Ventosalvaje",
        ["enUS"] = true,
        ["frFR"] = "Sentier du Vent-sauvage",
        ["esES"] = "Senda Ventosalvaje",
        ["zhTW"] = "狂風小徑",
        ["zhCN"] = "狂风小径",
    },
    ["Access Shaft Zeon"] = {
        ["ptBR"] = "Poço de Acesso Zeon",
        ["ruRU"] = "Вход в шахту Зеон",
        ["deDE"] = "Zugangsschacht Zeon",
        ["koKR"] = "지온 작업 갱도",
        ["esMX"] = "Eje de Acceso Zeon",
        ["enUS"] = true,
        ["frFR"] = "Puits d'accès Zéon",
        ["esES"] = "Eje de Acceso Zeon",
        ["zhTW"] = "礦井之路通道",
        ["zhCN"] = "瑟安竖井",
    },
    ["Middenvale"] = {
        ["ptBR"] = "Vale da Podridão",
        ["ruRU"] = "Прелая долина",
        ["deDE"] = "Trümmerfall",
        ["koKR"] = "무지렁이 골짜기",
        ["esMX"] = "Mediavega",
        ["enUS"] = true,
        ["frFR"] = "Ordeval",
        ["esES"] = "Mediavega",
        ["zhTW"] = "廢棄谷",
        ["zhCN"] = "废墟谷",
    },
    ["Odesyus' Landing"] = {
        ["ptBR"] = "Assentamento de Odisseu",
        ["ruRU"] = "Лагерь Одиссия",
        ["deDE"] = "Odesyus' Ankerplatz",
        ["koKR"] = "오디시우스의 정박지",
        ["esMX"] = "Desembarco de Odesyus",
        ["enUS"] = true,
        ["frFR"] = "Point d'accostage d'Odesyus",
        ["esES"] = "Desembarco de Odesyus",
        ["zhTW"] = "奧迪席斯平臺",
        ["zhCN"] = "奥德修斯营地",
    },
    ["Ethereum Staging Grounds"] = {
        ["ptBR"] = "Bivaques do Eteréum",
        ["ruRU"] = "Испытательный полигон Эфириума",
        ["deDE"] = "Stützpunkt des Astraleums",
        ["koKR"] = "에테리움 작전 지역",
        ["esMX"] = "Punto de Escala de El Etereum",
        ["enUS"] = true,
        ["frFR"] = "Lieu de rassemblement de l'Ethereum",
        ["esES"] = "Punto de Escala Etereum",
        ["zhTW"] = "伊斯利恩軍事要塞",
        ["zhCN"] = "复仇军前沿基地",
    },
    ["Eco-Dome Sutheron"] = {
        ["ptBR"] = "Eco-domo Sutheron",
        ["ruRU"] = "Заповедник \"Сатерон\"",
        ["deDE"] = "Biokuppel Sutheron",
        ["koKR"] = "수데론 생태지구",
        ["esMX"] = "Ecodomo Sutheron",
        ["enUS"] = true,
        ["frFR"] = "Écodôme Sudron",
        ["esES"] = "Ecodomo Sutheron",
        ["zhTW"] = "桑什倫秘境",
        ["zhCN"] = "苏瑟伦生态圆顶",
    },
    ["The Black Temple"] = {
        ["ptBR"] = "Templo Negro",
        ["ruRU"] = "Черный храм",
        ["deDE"] = "Der Schwarze Tempel",
        ["koKR"] = "검은 사원",
        ["esMX"] = "El Templo Oscuro",
        ["enUS"] = true,
        ["frFR"] = "Le Temple noir",
        ["esES"] = "El Templo Oscuro",
        ["zhTW"] = "黑暗神廟",
        ["zhCN"] = "黑暗神殿",
    },
    ["Eco-Dome Farfield"] = {
        ["ptBR"] = "Eco-domo Campolonge",
        ["ruRU"] = "Заповедник \"Дальнее поле\"",
        ["deDE"] = "Biokuppel Fernfeld",
        ["koKR"] = "외곽 생태지구",
        ["esMX"] = "Ecodomo Campolejano",
        ["enUS"] = true,
        ["frFR"] = "Écodôme Champlointain",
        ["esES"] = "Ecodomo Campolejano",
        ["zhTW"] = "秘境原野",
        ["zhCN"] = "边缘生态圆顶",
    },
    ["Stillwhisper Pond"] = {
        ["ptBR"] = "Lagoa do Eterno Sussurro",
        ["ruRU"] = "Пруд Тихого Шелеста",
        ["deDE"] = "Stillwispertümpel",
        ["koKR"] = "잔잔한 속삭임 연못",
        ["esMX"] = "Charca Plácido Susurro",
        ["enUS"] = true,
        ["frFR"] = "Étang des Murmures-sereins",
        ["esES"] = "Charca Plácido Susurro",
        ["zhTW"] = "靜語池",
        ["zhCN"] = "萦语水池",
    },
    ["Gyro-Plank Bridge"] = {
        ["ptBR"] = "Ponte Giroprancha",
        ["ruRU"] = "Гиро-балочный мост",
        ["deDE"] = "Gyroplankenbrücke",
        ["koKR"] = "자이로 교각",
        ["esMX"] = "Puente Girolámina",
        ["enUS"] = true,
        ["frFR"] = "Pont de gyro-passerelles",
        ["esES"] = "Puente Girolámina",
        ["zhTW"] = "環木橋",
        ["zhCN"] = "机械桥",
    },
    ["Bladed Gulch"] = {
        ["ptBR"] = "Ravina das Lâminas",
        ["ruRU"] = "Лощина Клинков",
        ["deDE"] = "Messerschlucht",
        ["koKR"] = "칼날 협곡",
        ["esMX"] = "Barranco del Filo",
        ["enUS"] = true,
        ["frFR"] = "Goulet des Lames",
        ["esES"] = "Barranco del Filo",
        ["zhTW"] = "刀刃峽谷",
        ["zhCN"] = "刀刃峡谷",
    },
    ["Azure Watch"] = {
        ["ptBR"] = "Entreposto Lazúli",
        ["ruRU"] = "Лазурная застава",
        ["deDE"] = "Azurwacht",
        ["koKR"] = "하늘 감시초소",
        ["esMX"] = "Avanzada Azur",
        ["enUS"] = true,
        ["frFR"] = "Guet d'azur",
        ["esES"] = "Avanzada Azur",
        ["zhTW"] = "藍色守望",
        ["zhCN"] = "碧蓝岗哨",
    },
    ["Crystal Spine"] = {
        ["ptBR"] = "Serra dos Cristais",
        ["ruRU"] = "Хрустальное поле",
        ["deDE"] = "Kristallrücken",
        ["koKR"] = "수정 돌기",
        ["esMX"] = "Espina de Cristal",
        ["enUS"] = true,
        ["frFR"] = "Éperon de cristal",
        ["esES"] = "Espina de Cristal",
        ["zhTW"] = "水晶背脊",
        ["zhCN"] = "水晶之脊",
    },
    ["Elrendar Falls"] = {
        ["ptBR"] = "Cachoeira Elrendar",
        ["ruRU"] = "Водопад Элрендар",
        ["deDE"] = "Elrendarfälle",
        ["koKR"] = "엘렌다르 폭포",
        ["esMX"] = "Cascadas Elrendar",
        ["enUS"] = true,
        ["frFR"] = "Chutes de l'Elrendar",
        ["esES"] = "Cascadas Elrendar",
        ["zhTW"] = "艾蘭達瀑布",
        ["zhCN"] = "艾伦达尔瀑布",
    },
    ["Shadow Tomb"] = {
        ["ptBR"] = "Tumba Sombria",
        ["ruRU"] = "Гробница Тени",
        ["deDE"] = "Schattengrab",
        ["koKR"] = "어둠의 무덤",
        ["esMX"] = "Tumba Umbría",
        ["enUS"] = true,
        ["frFR"] = "Tombe des ombres",
        ["esES"] = "Tumba Umbría",
        ["zhTW"] = "暗影之墓",
        ["zhCN"] = "暗影墓穴",
    },
    ["Southwind Cleft"] = {
        ["ptBR"] = "Fenda do Vento Sul",
        ["ruRU"] = "Расщелина Южного Ветра",
        ["deDE"] = "Südwindkluft",
        ["koKR"] = "마파람 동굴",
        ["esMX"] = "Grieta del Viento Sur",
        ["enUS"] = true,
        ["frFR"] = "Faille de Sudevent",
        ["esES"] = "Grieta del Viento Sur",
        ["zhTW"] = "南風斷崖",
        ["zhCN"] = "南风裂谷",
    },
    ["Broken Wilds"] = {
        ["ptBR"] = "Espinhaço Inóspito",
        ["ruRU"] = "Скалистые пустоши",
        ["deDE"] = "Zerschlagene Wildnis",
        ["koKR"] = "파괴된 벌판",
        ["esMX"] = "Landas Tábidas",
        ["enUS"] = true,
        ["frFR"] = "Landes brisées",
        ["esES"] = "Landas Tábidas",
        ["zhTW"] = "破碎荒野",
        ["zhCN"] = "破碎荒野",
    },
    ["Falconwing Square"] = {
        ["ptBR"] = "Praça Asa do Falcão",
        ["ruRU"] = "Площадь Соколиных Крыльев",
        ["deDE"] = "Falkenplatz",
        ["koKR"] = "매날개 광장",
        ["esMX"] = "Plaza Alalcón",
        ["enUS"] = true,
        ["frFR"] = "Place de l'épervier",
        ["esES"] = "Plaza Alalcón",
        ["zhTW"] = "獵鷹之翼廣場",
        ["zhCN"] = "鹰翼广场",
    },
    ["Ammen Ford"] = {
        ["ptBR"] = "Vau Ammen",
        ["ruRU"] = "Переправа Аммен",
        ["deDE"] = "Am'menfluss",
        ["koKR"] = "암멘 여울",
        ["esMX"] = "Vado Ammen",
        ["enUS"] = true,
        ["frFR"] = "Gué d'Ammen",
        ["esES"] = "Vado Ammen",
        ["zhTW"] = "安曼淺灘",
        ["zhCN"] = "埃门海滩",
    },
    ["Thalassian Pass"] = {
        ["ptBR"] = "Caminho Thalassiano",
        ["ruRU"] = "Талассийский перевал",
        ["deDE"] = "Thalassischer Pass",
        ["koKR"] = "탈라시안 고개",
        ["esMX"] = "Desfiladero Thalassiano",
        ["enUS"] = true,
        ["frFR"] = "Passe thalassienne",
        ["esES"] = "Desfiladero Thalassiano",
        ["zhTW"] = "薩拉斯小徑",
        ["zhCN"] = "萨拉斯小径",
    },
    ["Bladespire Outpost"] = {
        ["ptBR"] = "Acampamento Giralança",
        ["ruRU"] = "Застава Камнерогов",
        ["deDE"] = "Außenposten der Speerspießer",
        ["koKR"] = "칼날첨탑 전초기지",
        ["esMX"] = "Avanzada Aguja del Filo",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste Flèchelame",
        ["esES"] = "Avanzada Aguja del Filo",
        ["zhTW"] = "劍刃崗哨",
        ["zhCN"] = "刀塔哨站",
    },
    ["Allerian Stronghold"] = {
        ["ptBR"] = "Fortaleza Alleriana",
        ["ruRU"] = "Бастион Аллерии",
        ["deDE"] = "Allerias Feste",
        ["koKR"] = "알레리아 성채",
        ["esMX"] = "Bastión Allerian",
        ["enUS"] = true,
        ["frFR"] = "Bastion allérien",
        ["esES"] = "Bastión Allerian",
        ["zhTW"] = "艾蘭里堡壘",
        ["zhCN"] = "奥蕾莉亚要塞",
    },
    ["Silting Shore"] = {
        ["ptBR"] = "Baía do Limo",
        ["ruRU"] = "Илистый Берег",
        ["deDE"] = "Schlickerküste",
        ["koKR"] = "개펄 해안",
        ["esMX"] = "La Costa de Cieno",
        ["enUS"] = true,
        ["frFR"] = "Rivage envasé",
        ["esES"] = "La Costa de Cieno",
        ["zhTW"] = "淤塞海岸",
        ["zhCN"] = "淤泥海岸",
    },
    ["Commons Hall"] = {
        ["ptBR"] = "Câmara dos Comuns",
        ["ruRU"] = "Общий зал",
        ["deDE"] = "Versammlungshalle",
        ["koKR"] = "대강당",
        ["esMX"] = "Cámara del Pueblo",
        ["enUS"] = true,
        ["frFR"] = "Communs",
        ["esES"] = "Cámara del Pueblo",
        ["zhTW"] = "平民大廳",
        ["zhCN"] = "平民大厅",
    },
    ["Churning Gulch"] = {
        ["ptBR"] = "Ravina Trêmula",
        ["ruRU"] = "Беспокойная лощина",
        ["deDE"] = "Grabenschlucht",
        ["koKR"] = "휘몰이 협곡",
        ["esMX"] = "Garganta Bulliciosa",
        ["enUS"] = true,
        ["frFR"] = "Goulet bouillonnant",
        ["esES"] = "Garganta Bulliciosa",
        ["zhTW"] = "翻騰峽谷",
        ["zhCN"] = "沸土峡谷",
    },
    ["The Violet Tower"] = {
        ["ptBR"] = "Torre Violeta",
        ["ruRU"] = "Аметистовая башня",
        ["deDE"] = "Der violette Turm",
        ["koKR"] = "자줏빛 탑",
        ["esMX"] = "Torre Violeta",
        ["enUS"] = true,
        ["frFR"] = "La Tour pourpre",
        ["esES"] = "Torre Violeta",
        ["zhTW"] = "紫蘿蘭之塔",
        ["zhCN"] = "紫罗兰之塔",
    },
    ["REUSE"] = {
        ["ptBR"] = "REUSE",
        ["ruRU"] = "REUSE",
        ["deDE"] = "REUSE",
        ["koKR"] = "REUSE",
        ["esMX"] = "REUSE",
        ["enUS"] = true,
        ["frFR"] = "REUSE",
        ["esES"] = "REUSE",
        ["zhTW"] = "REUSE",
        ["zhCN"] = "REUSE",
    },
    ["Draenethyst Mine"] = {
        ["ptBR"] = "Mina de Draenetista",
        ["ruRU"] = "Дренетистовые копи",
        ["deDE"] = "Draenethystmine",
        ["koKR"] = "드레니시스트 광산",
        ["esMX"] = "Mina Draenetista",
        ["enUS"] = true,
        ["frFR"] = "Mine de draenéthyste",
        ["esES"] = "Mina Draenetista",
        ["zhTW"] = "德萊尼礦坑",
        ["zhCN"] = "德拉诺晶矿",
    },
    ["Borune Ruins"] = {
        ["ptBR"] = "Ruínas de Borune",
        ["ruRU"] = "Руины Боруна",
        ["deDE"] = "Ruinen von Borune",
        ["koKR"] = "보룬 폐허",
        ["esMX"] = "Ruinas Borune",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Borune",
        ["esES"] = "Ruinas Borune",
        ["zhTW"] = "伯盧恩廢墟",
        ["zhCN"] = "博鲁恩废墟",
    },
    ["Elrendar Crossing"] = {
        ["ptBR"] = "Passagem de Elrendar",
        ["ruRU"] = "Мост Элрендар",
        ["deDE"] = "Elrendarkreuzung",
        ["koKR"] = "엘렌다르 건널목",
        ["esMX"] = "Cruce Elrendar",
        ["enUS"] = true,
        ["frFR"] = "Passage de l'Elrendar",
        ["esES"] = "Cruce Elrendar",
        ["zhTW"] = "艾蘭達路口",
        ["zhCN"] = "艾伦达尔桥",
    },
    ["Sunfury Hold"] = {
        ["ptBR"] = "Acampamento Solfúria",
        ["ruRU"] = "Форт Ярости Солнца",
        ["deDE"] = "Sonnenzornposten",
        ["koKR"] = "성난태양 주둔지",
        ["esMX"] = "Bastión Furia del Sol",
        ["enUS"] = true,
        ["frFR"] = "Bastion des Solfurie",
        ["esES"] = "Bastión Furia del Sol",
        ["zhTW"] = "日怒要塞",
        ["zhCN"] = "日怒堡",
    },
    ["Clan Watch"] = {
        ["ptBR"] = "Vila dos Clãs",
        ["ruRU"] = "Клановая Стража",
        ["deDE"] = "Klanwacht",
        ["koKR"] = "부족 초소",
        ["esMX"] = "Avanzada del Clan",
        ["enUS"] = true,
        ["frFR"] = "Guet des clans",
        ["esES"] = "Avanzada del Clan",
        ["zhTW"] = "氏族守望",
        ["zhCN"] = "氏族岗哨",
    },
    ["Pod Wreckage"] = {
        ["ptBR"] = "Destroços do Módulo Espacial",
        ["ruRU"] = "Обломки Капсулы",
        ["deDE"] = "Kapselwrack",
        ["koKR"] = "탈출선 잔해",
        ["esMX"] = "El Cementerio de Cápsulas",
        ["enUS"] = true,
        ["frFR"] = "Débris de capsule",
        ["esES"] = "El Cementerio de Cápsulas",
        ["zhTW"] = "卵囊殘骸",
        ["zhCN"] = "残破的逃生舱",
    },
    ["The Path of Anguish"] = {
        ["ptBR"] = "O Caminho da Angústia",
        ["ruRU"] = "Путь Страданий",
        ["deDE"] = "Der Pfad der Pein",
        ["koKR"] = "고통의 길",
        ["esMX"] = "El Camino del Tormento",
        ["enUS"] = true,
        ["frFR"] = "Le Chemin de l'angoisse",
        ["esES"] = "El Camino del Tormento",
        ["zhTW"] = "苦痛之路",
        ["zhCN"] = "苦痛之路",
    },
    ["Razorthorn Trail"] = {
        ["ptBR"] = "Trilha Espinhosa",
        ["ruRU"] = "Дорога Острого Шипа",
        ["deDE"] = "Messerdornpfad",
        ["koKR"] = "서슬가시 고개",
        ["esMX"] = "Senda Rajaespina",
        ["enUS"] = true,
        ["frFR"] = "Piste de Tranchépine",
        ["esES"] = "Senda Rajaespina",
        ["zhTW"] = "刺棘蔓",
        ["zhCN"] = "荆刺小径",
    },
    ["Bloodscale Enclave"] = {
        ["ptBR"] = "Enclave Sangrescama",
        ["ruRU"] = "Анклав Кровавой Чешуи",
        ["deDE"] = "Enklave der Blutschuppen",
        ["koKR"] = "피비늘 군락",
        ["esMX"] = "Enclave Escamas de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Enclave des écailles-sanglantes",
        ["esES"] = "Enclave Escamas de Sangre",
        ["zhTW"] = "血鱗營地",
        ["zhCN"] = "血鳞领地",
    },
    ["The Heap"] = {
        ["ptBR"] = "Os Destroços",
        ["ruRU"] = "Груда",
        ["deDE"] = "Der Hügel",
        ["koKR"] = "고철더미",
        ["esMX"] = "La Pila",
        ["enUS"] = true,
        ["frFR"] = "Le Monceau",
        ["esES"] = "La Pila",
        ["zhTW"] = "聚集之地",
        ["zhCN"] = "机甲废场",
    },
    ["Shartuul's Transporter"] = {
        ["ptBR"] = "Transporte de Shartuul",
        ["ruRU"] = "Транспортер Шартуула",
        ["deDE"] = "Shartuuls Transporter",
        ["koKR"] = "샤툴의 순간이동기",
        ["esMX"] = "Transportador de Shartuul",
        ["enUS"] = true,
        ["frFR"] = "Transporteur de Shartuul",
        ["esES"] = "Transportador de Shartuul",
        ["zhTW"] = "夏圖歐的傳送門",
        ["zhCN"] = "沙图尔的传送器",
    },
    ["Tuluman's Landing"] = {
        ["ptBR"] = "Acampamento do Tuluman",
        ["ruRU"] = "Лагерь Тулумана",
        ["deDE"] = "Tulumans Landeplatz",
        ["koKR"] = "툴루맨의 정박지",
        ["esMX"] = "Alto de Tuluman",
        ["enUS"] = true,
        ["frFR"] = "Point d'ancrage de Tuluman",
        ["esES"] = "Alto de Tuluman",
        ["zhTW"] = "吐魯曼平臺",
        ["zhCN"] = "图鲁曼的营地",
    },
    ["Emberglade"] = {
        ["ptBR"] = "Campo das Cinzas",
        ["ruRU"] = "Тлеющая поляна",
        ["deDE"] = "Glutgrund",
        ["koKR"] = "잿불숲",
        ["esMX"] = "El Claro de Ascuas",
        ["enUS"] = true,
        ["frFR"] = "Clairière de braise",
        ["esES"] = "El Claro de Ascuas",
        ["zhTW"] = "餘燼林地",
        ["zhCN"] = "灰烬林地",
    },
    ["Forge Base: Oblivion"] = {
        ["ptBR"] = "Base-forja: Oblívio",
        ["ruRU"] = "База Легиона: Забвение",
        ["deDE"] = "Konstruktionsbasis: Vergessenheit",
        ["koKR"] = "망각의 괴철로 주둔지",
        ["esMX"] = "Base Forja: Olvido",
        ["enUS"] = true,
        ["frFR"] = "Base de forge : Oubli",
        ["esES"] = "Base Forja: Olvido",
        ["zhTW"] = "熔爐基地:遺忘",
        ["zhCN"] = "铸魔基地：湮灭",
    },
    ["Isle of Quel'Danas"] = {
        ["ptBR"] = "Ilha de Quel'Danas",
        ["ruRU"] = "Остров Кель'Данас",
        ["deDE"] = "Insel von Quel'Danas",
        ["koKR"] = "쿠엘다나스 섬",
        ["esMX"] = "Isla de Quel'Danas",
        ["enUS"] = true,
        ["frFR"] = "Île de Quel'Danas",
        ["esES"] = "Isla de Quel'Danas",
        ["zhTW"] = "奎爾達納斯之島",
        ["zhCN"] = "奎尔丹纳斯岛",
    },
    ["Veil Harr'ik"] = {
        ["ptBR"] = "Véu Harr'ik",
        ["ruRU"] = "Гнездовье Харр'ик",
        ["deDE"] = "Harr'ikversteck",
        ["koKR"] = "장막의 하리크",
        ["esMX"] = "Velo Harr'ik",
        ["enUS"] = true,
        ["frFR"] = "Voile Harr'ik",
        ["esES"] = "Velo Harr'ik",
        ["zhTW"] = "迷霧哈瑞克",
        ["zhCN"] = "哈雷克鸦巢",
    },
    ["Manaforge Ara"] = {
        ["ptBR"] = "Manaforja Ara",
        ["ruRU"] = "Манагорн Ара",
        ["deDE"] = "Manaschmiede Ara",
        ["koKR"] = "아라 마나괴철로",
        ["esMX"] = "Forja de Maná Ara",
        ["enUS"] = true,
        ["frFR"] = "Manaforge Ara",
        ["esES"] = "Forja de Maná Ara",
        ["zhTW"] = "法力熔爐艾拉",
        ["zhCN"] = "法力熔炉：艾拉",
    },
    ["The Abyssal Shelf"] = {
        ["ptBR"] = "Prateleira Abissal",
        ["ruRU"] = "Косогор Бездны",
        ["deDE"] = "Die abyssische Untiefe",
        ["koKR"] = "심연의 절벽",
        ["esMX"] = "La Plataforma Abisal",
        ["enUS"] = true,
        ["frFR"] = "La Saillie abyssale",
        ["esES"] = "La Plataforma Abisal",
        ["zhTW"] = "深淵沙洲",
        ["zhCN"] = "地狱岩床",
    },
    ["West Sanctum"] = {
        ["ptBR"] = "Sacrário do Oeste",
        ["ruRU"] = "Западное святилище",
        ["deDE"] = "Sanktum des Westens",
        ["koKR"] = "서부 성소",
        ["esMX"] = "Sagrario del Oeste",
        ["enUS"] = true,
        ["frFR"] = "Sanctum occidental",
        ["esES"] = "Sagrario del Oeste",
        ["zhTW"] = "西部聖所",
        ["zhCN"] = "西部圣殿",
    },
    ["Mok'Nathal Village"] = {
        ["ptBR"] = "Vila de Mok'nathal",
        ["ruRU"] = "Деревня Мок'Натал",
        ["deDE"] = "Dorf der Mok'Nathal",
        ["koKR"] = "모크나탈 마을",
        ["esMX"] = "Aldea Mok'Nathal",
        ["enUS"] = true,
        ["frFR"] = "Mok'Nathal",
        ["esES"] = "Aldea Mok'Nathal",
        ["zhTW"] = "摩克納薩爾村",
        ["zhCN"] = "莫克纳萨村",
    },
    ["Raven's Wood"] = {
        ["ptBR"] = "Mata do Corvo",
        ["ruRU"] = "Лес Ворона",
        ["deDE"] = "Rabenwald",
        ["koKR"] = "까마귀 숲",
        ["esMX"] = "Bosque del Cuervo",
        ["enUS"] = true,
        ["frFR"] = "Bois aux corbeaux",
        ["esES"] = "Bosque del Cuervo",
        ["zhTW"] = "烏鴉林",
        ["zhCN"] = "乌鸦林",
    },
    ["Crash Site"] = {
        ["ptBR"] = "Ponto de Impacto",
        ["ruRU"] = "Место крушения",
        ["deDE"] = "Absturzstelle",
        ["koKR"] = "추락 지점",
        ["esMX"] = "Lugar del Accidente",
        ["enUS"] = true,
        ["frFR"] = "Point d'impact",
        ["esES"] = "Lugar del Accidente",
        ["zhTW"] = "失事地點",
        ["zhCN"] = "坠毁点",
    },
    ["Eco-Dome Skyperch"] = {
        ["ptBR"] = "Eco-domo Pouso do Céu",
        ["ruRU"] = "Заповедник \"Высь\"",
        ["deDE"] = "Biokuppel Himmelssitz",
        ["koKR"] = "하늘마루 생태지구",
        ["esMX"] = "Ecodomo Altocielo",
        ["enUS"] = true,
        ["frFR"] = "Écodôme Percheciel",
        ["esES"] = "Ecodomo Altocielo",
        ["zhTW"] = "秘境棲木",
        ["zhCN"] = "高空生态圆顶",
    },
    ["Bloodmaul Ravine"] = {
        ["ptBR"] = "Barranco Malho Sangrento",
        ["ruRU"] = "Лощина Кровавого Молота",
        ["deDE"] = "Blutschlägerklamm",
        ["koKR"] = "피망치 협곡",
        ["esMX"] = "Barranco Machacasangre",
        ["enUS"] = true,
        ["frFR"] = "Ravin de la Masse-sanglante",
        ["esES"] = "Barranco Machacasangre",
        ["zhTW"] = "血槌深谷",
        ["zhCN"] = "血槌峡谷",
    },
    ["Spinebreaker Mountains"] = {
        ["ptBR"] = "Montanhas Quebra-espinha",
        ["ruRU"] = "Горы Хребтолома",
        ["deDE"] = "Rückenbrecherberge",
        ["koKR"] = "해골망치 산맥",
        ["esMX"] = "Montañas Rompeloma",
        ["enUS"] = true,
        ["frFR"] = "Montagnes Brise-échine",
        ["esES"] = "Montañas Rompeloma",
        ["zhTW"] = "斷脊氏族山脈",
        ["zhCN"] = "断背山",
    },
    ["Blood Watch"] = {
        ["ptBR"] = "Entreposto Rubro",
        ["ruRU"] = "Кровавая застава",
        ["deDE"] = "Blutwacht",
        ["koKR"] = "핏빛 감시초소",
        ["esMX"] = "Avanzada de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Guet du sang",
        ["esES"] = "Avanzada de Sangre",
        ["zhTW"] = "血色守望",
        ["zhCN"] = "秘血岗哨",
    },
    ["Bladespire Hold"] = {
        ["ptBR"] = "Bastião Giralança",
        ["ruRU"] = "Форт Камнерогов",
        ["deDE"] = "Wehr der Speerspießer",
        ["koKR"] = "칼날첨탑 요새",
        ["esMX"] = "Bastión Aguja del Filo",
        ["enUS"] = true,
        ["frFR"] = "Bastion de Flèchelame",
        ["esES"] = "Bastión Aguja del Filo",
        ["zhTW"] = "劍刃要塞",
        ["zhCN"] = "刀塔要塞",
    },
    ["Protectorate Watch Post"] = {
        ["ptBR"] = "Posto de Guarda do Protetorado",
        ["ruRU"] = "Застава Стражей Протектората",
        ["deDE"] = "Wachposten des Protektorats",
        ["koKR"] = "자유연합 경비초소",
        ["esMX"] = "Avanzada del Protectorado",
        ["enUS"] = true,
        ["frFR"] = "Poste de garde du Protectorat",
        ["esES"] = "Avanzada del Protectorado",
        ["zhTW"] = "護國者哨站",
        ["zhCN"] = "维序派哨站",
    },
    ["Ridge of Madness"] = {
        ["ptBR"] = "Pico da Loucura",
        ["ruRU"] = "Гряда Безумия",
        ["deDE"] = "Grat des Wahnsinns",
        ["koKR"] = "광기의 마루",
        ["esMX"] = "Cresta de la Locura",
        ["enUS"] = true,
        ["frFR"] = "Crête de la folie",
        ["esES"] = "Cresta de la Locura",
        ["zhTW"] = "瘋狂山脊",
        ["zhCN"] = "疯狂之脊",
    },
    ["Boha'mu Ruins"] = {
        ["ptBR"] = "Ruínas de Boha'mu",
        ["ruRU"] = "Руины Боха'му",
        ["deDE"] = "Ruinen von Boha'mu",
        ["koKR"] = "보하무 폐허",
        ["esMX"] = "Ruinas Boha'mu",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Boha'mu",
        ["esES"] = "Ruinas Boha'mu",
        ["zhTW"] = "波哈姆廢墟",
        ["zhCN"] = "博哈姆废墟",
    },
    ["Bloodmaul Outpost"] = {
        ["ptBR"] = "Posto Avançado Malho Sangrento",
        ["ruRU"] = "Застава Кровавого Молота",
        ["deDE"] = "Außenposten der Blutschläger",
        ["koKR"] = "피망치 전초기지",
        ["esMX"] = "Avanzada Machacasangre",
        ["enUS"] = true,
        ["frFR"] = "Avant-poste de la Masse-sanglante",
        ["esES"] = "Avanzada Machacasangre",
        ["zhTW"] = "血槌前哨站",
        ["zhCN"] = "血槌哨站",
    },
    ["Razor Ridge"] = {
        ["ptBR"] = "Espinhaço Cortante",
        ["ruRU"] = "Островерхий гребень",
        ["deDE"] = "Messergrat",
        ["koKR"] = "칼날 마루",
        ["esMX"] = "Loma Tajo",
        ["enUS"] = true,
        ["frFR"] = "Tranchecrête",
        ["esES"] = "Loma Tajo",
        ["zhTW"] = "剃刀山脊",
        ["zhCN"] = "剃刀山",
    },
    ["Quagg Ridge"] = {
        ["ptBR"] = "Serra Quagg",
        ["ruRU"] = "Гряда Квагг",
        ["deDE"] = "Quaggkamm",
        ["koKR"] = "쿠아그 마루",
        ["esMX"] = "Cresta Quagg",
        ["enUS"] = true,
        ["frFR"] = "Crête des boues",
        ["esES"] = "Cresta Quagg",
        ["zhTW"] = "跨格山脊",
        ["zhCN"] = "泥泞山",
    },
    ["Cosmowrench"] = {
        ["ptBR"] = "Chave do Cosmos",
        ["ruRU"] = "Космоворот",
        ["deDE"] = "Kosmozang",
        ["koKR"] = "코스모렌치",
        ["esMX"] = "Cosmotirón",
        ["enUS"] = true,
        ["frFR"] = "Cosmovrille",
        ["esES"] = "Cosmotirón",
        ["zhTW"] = "扭曲太空",
        ["zhCN"] = "扳钳镇",
    },
    ["Vortex Pinnacle"] = {
        ["ptBR"] = "Pináculo do Vórtice",
        ["ruRU"] = "Вершина Смерча",
        ["deDE"] = "Vortexgipfel",
        ["koKR"] = "소용돌이 고원",
        ["esMX"] = "Cumbre del Vórtice",
        ["enUS"] = true,
        ["frFR"] = "Cime du vortex",
        ["esES"] = "Cumbre del Vórtice",
        ["zhTW"] = "漩渦尖塔",
        ["zhCN"] = "漩涡峰",
    },
    ["Death's Door"] = {
        ["ptBR"] = "Porta da Morte",
        ["ruRU"] = "Врата Смерти",
        ["deDE"] = "Schwelle des Todes",
        ["koKR"] = "죽음의 문",
        ["esMX"] = "Puerta de la Muerte",
        ["enUS"] = true,
        ["frFR"] = "Porte de la mort",
        ["esES"] = "Puerta de la Muerte",
        ["zhTW"] = "死亡之門",
        ["zhCN"] = "死亡之门",
    },
    ["Silvermoon's Pride"] = {
        ["ptBR"] = "Orgulho de Luaprata",
        ["ruRU"] = "Гордость Луносвета",
        ["deDE"] = "Silbermonds Stolz",
        ["koKR"] = "실버문의 긍지호",
        ["esMX"] = "Orgullo de Lunargenta",
        ["enUS"] = true,
        ["frFR"] = "La Fierté de Lune-d'argent",
        ["esES"] = "Orgullo de Lunargenta",
        ["zhTW"] = "銀月之驕",
        ["zhCN"] = "银月之傲",
    },
    ["The Fel Pits"] = {
        ["ptBR"] = "Poços Fétidos",
        ["ruRU"] = "Ямы Скверны",
        ["deDE"] = "Die Teufelsgruben",
        ["koKR"] = "지옥의 구덩이",
        ["esMX"] = "Las Fosas Viles",
        ["enUS"] = true,
        ["frFR"] = "Les Gangrefosses",
        ["esES"] = "Las Fosas Viles",
        ["zhTW"] = "惡魔深淵",
        ["zhCN"] = "魔能熔池",
    },
    ["Laughing Skull Courtyard"] = {
        ["ptBR"] = "Pátio Gargaveira",
        ["ruRU"] = "Внутренний двор Веселого Черепа",
        ["deDE"] = "Hof des Lachenden Schädels",
        ["koKR"] = "웃는 해골 광장",
        ["esMX"] = "Patio Riecráneos",
        ["enUS"] = true,
        ["frFR"] = "Cour du Crâne ricanant",
        ["esES"] = "Patio Riecráneos",
        ["zhTW"] = "獰笑骷髏庭院",
        ["zhCN"] = "嘲颅营地",
    },
    ["Veil Ruuan"] = {
        ["ptBR"] = "Véu Ruuan",
        ["ruRU"] = "Гнездовье Рууан",
        ["deDE"] = "Ruuanversteck",
        ["koKR"] = "장막의 루안",
        ["esMX"] = "Velo Ruuan",
        ["enUS"] = true,
        ["frFR"] = "Voile Ruuan",
        ["esES"] = "Velo Ruuan",
        ["zhTW"] = "迷霧魯安",
        ["zhCN"] = "卢安鸦巢",
    },
    ["Misty Ridge"] = {
        ["ptBR"] = "Pico da Neblina",
        ["ruRU"] = "Туманная гряда",
        ["deDE"] = "Nebelpass",
        ["koKR"] = "안개 마루",
        ["esMX"] = "Cresta Brumosa",
        ["enUS"] = true,
        ["frFR"] = "Crête brumeuse",
        ["esES"] = "Cresta Brumosa",
        ["zhTW"] = "多霧山脊",
        ["zhCN"] = "薄雾山",
    },
    ["The Crimson Reach"] = {
        ["ptBR"] = "Rincão Rubro",
        ["ruRU"] = "Кровавый берег",
        ["deDE"] = "Die Purpurbrandung",
        ["koKR"] = "진홍 해안",
        ["esMX"] = "El Tramo Carmesí",
        ["enUS"] = true,
        ["frFR"] = "Les confins cramoisis",
        ["esES"] = "El Tramo Carmesí",
        ["zhTW"] = "赤紅地帶",
        ["zhCN"] = "红砂海滩",
    },
    ["Ruuan Weald"] = {
        ["ptBR"] = "Bosque Ruuan",
        ["ruRU"] = "Чащоба Рууан",
        ["deDE"] = "Ruuanwald",
        ["koKR"] = "루안 숲",
        ["esMX"] = "Foresta Ruuan",
        ["enUS"] = true,
        ["frFR"] = "Sylve Ruuan",
        ["esES"] = "Foresta de Ruuan",
        ["zhTW"] = "魯安曠野",
        ["zhCN"] = "卢安荒野",
    },
    ["Daggermaw Canyon"] = {
        ["ptBR"] = "Garganta Gorjadaga",
        ["ruRU"] = "Каньон Кинжальной Пасти",
        ["deDE"] = "Dolchrachenklamm",
        ["koKR"] = "비수아귀 협곡",
        ["esMX"] = "Cañón Faucedaga",
        ["enUS"] = true,
        ["frFR"] = "Canyon des Crocs-lames",
        ["esES"] = "Cañón Faucedaga",
        ["zhTW"] = "匕爪峽谷",
        ["zhCN"] = "刃喉谷",
    },
    ["Telredor"] = {
        ["ptBR"] = "Telredor",
        ["ruRU"] = "Телредор",
        ["deDE"] = "Telredor",
        ["koKR"] = "텔레도르",
        ["esMX"] = "Telredor",
        ["enUS"] = true,
        ["frFR"] = "Telredor",
        ["esES"] = "Telredor",
        ["zhTW"] = "泰倫多爾",
        ["zhCN"] = "泰雷多尔",
    },
    ["Abandoned Armory"] = {
        ["ptBR"] = "Armaria Abandonada",
        ["ruRU"] = "Заброшенная оружейная",
        ["deDE"] = "Verlassenes Rüstlager",
        ["koKR"] = "버려진 무기고",
        ["esMX"] = "Armería Abandonada",
        ["enUS"] = true,
        ["frFR"] = "Armurerie abandonnée",
        ["esES"] = "Armería Abandonada",
        ["zhTW"] = "被遺棄的軍械庫",
        ["zhCN"] = "废弃的军械库",
    },
    ["Shamanar"] = {
        ["ptBR"] = "Shamanar",
        ["ruRU"] = "Шаманар",
        ["deDE"] = "Shamanar",
        ["koKR"] = "샤마나르",
        ["esMX"] = "Shamanar",
        ["enUS"] = true,
        ["frFR"] = "Shamanar",
        ["esES"] = "Shamanar",
        ["zhTW"] = "夏瑪那",
        ["zhCN"] = "萨满纳尔",
    },
    ["Eclipse Point"] = {
        ["ptBR"] = "Ponta do Eclipse",
        ["ruRU"] = "Лагерь Затмения",
        ["deDE"] = "Stätte der Mondfinsternis",
        ["koKR"] = "해그늘 주둔지",
        ["esMX"] = "Punta Eclipse",
        ["enUS"] = true,
        ["frFR"] = "Halte de l'éclipse",
        ["esES"] = "Punta Eclipse",
        ["zhTW"] = "日蝕崗哨",
        ["zhCN"] = "日蚀岗哨",
    },
    ["Warden's Cage"] = {
        ["ptBR"] = "Jaula do Carcereiro",
        ["ruRU"] = "Клеть Стражницы",
        ["deDE"] = "Kerker des Wächters",
        ["koKR"] = "감시자의 수용소",
        ["esMX"] = "Jaula de la Guardiana",
        ["enUS"] = true,
        ["frFR"] = "La Cage de la gardienne",
        ["esES"] = "Jaula de la Guardiana",
        ["zhTW"] = "典獄官監牢",
        ["zhCN"] = "守望者牢笼",
    },
    ["Shattered Sun Staging Area"] = {
        ["ptBR"] = "Bivaque Sol Partido",
        ["ruRU"] = "Подготовительный плацдарм Расколотого Солнца",
        ["deDE"] = "Sammelpunkt der Zerschmetterten Sonne",
        ["koKR"] = "무너진 태양 집결지",
        ["esMX"] = "Zona de Escala de Sol Devastado",
        ["enUS"] = true,
        ["frFR"] = "Zone de rassemblement du Soleil brisé",
        ["esES"] = "Zona de escala de Sol Devastado",
        ["zhTW"] = "破碎之日會所",
        ["zhCN"] = "破碎残阳基地",
    },
    ["Bloodscale Grounds"] = {
        ["ptBR"] = "Terras dos Sangrescamas",
        ["ruRU"] = "Земли Кровавой Чешуи",
        ["deDE"] = "Blutschuppengrund",
        ["koKR"] = "피비늘 영토",
        ["esMX"] = "Tierras Escamas de Sangre",
        ["enUS"] = true,
        ["frFR"] = "Terres des écailles-sanglantes",
        ["esES"] = "Tierras Escamas de Sangre",
        ["zhTW"] = "血鱗營地",
        ["zhCN"] = "血鳞浅滩",
    },
    ["East Supply Caravan"] = {
        ["ptBR"] = "Caravana Oriental de Suprimentos",
        ["ruRU"] = "Восточный караван",
        ["deDE"] = "Östliche Versorgungskarawane",
        ["koKR"] = "동쪽 보급 짐마차",
        ["esMX"] = "Caravana de Provisiones del Este",
        ["enUS"] = true,
        ["frFR"] = "Caravane de ravitaillement de l'est",
        ["esES"] = "Caravana de Provisiones del Este",
        ["zhTW"] = "東部補給營地",
        ["zhCN"] = "东补给车队",
    },
    ["The Warp Fields"] = {
        ["ptBR"] = "Campos Dimensionais",
        ["ruRU"] = "Искривленные поля",
        ["deDE"] = "Die Sphärenfelder",
        ["koKR"] = "일그러진 벌판",
        ["esMX"] = "Los Campos Alabeados",
        ["enUS"] = true,
        ["frFR"] = "Les champs de distorsion",
        ["esES"] = "Los Campos Alabeados",
        ["zhTW"] = "扭曲原野",
        ["zhCN"] = "迁跃平原",
    },
    ["Bladewood"] = {
        ["ptBR"] = "Mata Cortante",
        ["ruRU"] = "Лес Клинков",
        ["deDE"] = "Messerwinkel",
        ["koKR"] = "칼날숲",
        ["esMX"] = "Bosquespada",
        ["enUS"] = true,
        ["frFR"] = "Bois des Lames",
        ["esES"] = "Bosquespada",
        ["zhTW"] = "劍木林",
        ["zhCN"] = "刀林",
    },
    ["Spinebreaker Pass"] = {
        ["ptBR"] = "Desfiladeiro Quebra-espinha",
        ["ruRU"] = "Перевал Хребтолома",
        ["deDE"] = "Rückenbrecherpass",
        ["koKR"] = "해골망치 고개",
        ["esMX"] = "Desfiladero Rompeloma",
        ["enUS"] = true,
        ["frFR"] = "Passage des Brise-échine",
        ["esES"] = "Desfiladero Rompeloma",
        ["zhTW"] = "斷脊氏族小徑",
        ["zhCN"] = "断背小径",
    },
    ["Veil Shienor"] = {
        ["ptBR"] = "Véu Shienor",
        ["ruRU"] = "Гнездовье Шиенор",
        ["deDE"] = "Shienorversteck",
        ["koKR"] = "장막의 쉬에노르",
        ["esMX"] = "Velo Shienor",
        ["enUS"] = true,
        ["frFR"] = "Voile Shienor",
        ["esES"] = "Velo Shienor",
        ["zhTW"] = "迷霧辛諾",
        ["zhCN"] = "西诺鸦巢",
    },
    ["Sunstrider Isle"] = {
        ["ptBR"] = "Ilha Andassol",
        ["ruRU"] = "Остров Солнечного Скитальца",
        ["deDE"] = "Insel der Sonnenwanderer",
        ["koKR"] = "선스트라이더 섬",
        ["esMX"] = "Isla del Caminante del Sol",
        ["enUS"] = true,
        ["frFR"] = "Ile de Haut-soleil",
        ["esES"] = "Isla del Caminante del Sol",
        ["zhTW"] = "逐日者之島",
        ["zhCN"] = "逐日岛",
    },
    ["Twin Spire Ruins"] = {
        ["ptBR"] = "Ruínas das Agulhas Gêmeas",
        ["ruRU"] = "Руины Двух Башен",
        ["deDE"] = "Ruinen der Zwillingsspitze",
        ["koKR"] = "쌍둥이 첨탑 폐허",
        ["esMX"] = "Ruinas de las Agujas Gemelas",
        ["enUS"] = true,
        ["frFR"] = "Ruines des flèches jumelles",
        ["esES"] = "Ruinas de las Agujas Gemelas",
        ["zhTW"] = "雙塔廢墟",
        ["zhCN"] = "双塔废墟",
    },
    ["Northern Rampart"] = {
        ["ptBR"] = "Muralha do Norte",
        ["ruRU"] = "Северный бастион",
        ["deDE"] = "Nördliches Bollwerk",
        ["koKR"] = "북쪽 성루",
        ["esMX"] = "Muralla Norte",
        ["enUS"] = true,
        ["frFR"] = "Rempart du nord",
        ["esES"] = "Muralla Norte",
        ["zhTW"] = "北方堡壘",
        ["zhCN"] = "北部城墙",
    },
    ["Southern Rampart"] = {
        ["ptBR"] = "Muralha do Sul",
        ["ruRU"] = "Южный бастион",
        ["deDE"] = "Südliches Bollwerk",
        ["koKR"] = "남쪽 성루",
        ["esMX"] = "Muralla Sur",
        ["enUS"] = true,
        ["frFR"] = "Rempart du sud",
        ["esES"] = "Muralla Sur",
        ["zhTW"] = "南方堡壘",
        ["zhCN"] = "南部城墙",
    },
    ["Forge Camp: Hate"] = {
        ["ptBR"] = "Campo-forja: Ódio",
        ["ruRU"] = "Лагерь Легиона: Ненависть",
        ["deDE"] = "Konstruktionslager: Hass",
        ["koKR"] = "증오의 괴철로 기지",
        ["esMX"] = "Campamento Forja: Odio",
        ["enUS"] = true,
        ["frFR"] = "Camp de forge : Haine",
        ["esES"] = "Campamento Forja: Odio",
        ["zhTW"] = "煉冶場:仇恨",
        ["zhCN"] = "铸魔营地：仇恨",
    },
    ["Cenarion Post"] = {
        ["ptBR"] = "Posto Cenariano",
        ["ruRU"] = "Кенарийская застава",
        ["deDE"] = "Posten des Cenarius",
        ["koKR"] = "세나리온 초소",
        ["esMX"] = "Puesto Cenarion",
        ["enUS"] = true,
        ["frFR"] = "Poste cénarien",
        ["esES"] = "Puesto Cenarion",
        ["zhTW"] = "塞納里奧前哨",
        ["zhCN"] = "塞纳里奥哨站",
    },
    ["Ango'rosh Stronghold"] = {
        ["ptBR"] = "Fortaleza Ango'rosh",
        ["ruRU"] = "Крепость Анго'рош",
        ["deDE"] = "Festung der Ango'rosh",
        ["koKR"] = "앙고로쉬 소굴",
        ["esMX"] = "Bastión Ango'rosh",
        ["enUS"] = true,
        ["frFR"] = "Bastion Ango'rosh",
        ["esES"] = "Bastión Ango'rosh",
        ["zhTW"] = "安格拉斯要塞",
        ["zhCN"] = "安葛洛什要塞",
    },
    ["Pools of Aggonar"] = {
        ["ptBR"] = "Poços de Aggonar",
        ["ruRU"] = "Пруды Аггонара",
        ["deDE"] = "Teiche von Aggonar",
        ["koKR"] = "아고나르의 웅덩이",
        ["esMX"] = "Pozas de Aggonar",
        ["enUS"] = true,
        ["frFR"] = "Bassins d'Aggonar",
        ["esES"] = "Pozas de Aggonar",
        ["zhTW"] = "阿葛納爾之池",
        ["zhCN"] = "阿苟纳之池",
    },
    ["Jagged Ridge"] = {
        ["ptBR"] = "Serra dos Espigões",
        ["ruRU"] = "Зазубренная гряда",
        ["deDE"] = "Zackengrat",
        ["koKR"] = "뾰족 마루",
        ["esMX"] = "Cresta Dentada",
        ["enUS"] = true,
        ["frFR"] = "La crête dentelée",
        ["esES"] = "Cresta Dentada",
        ["zhTW"] = "鋸齒山脊",
        ["zhCN"] = "锯齿山",
    },
    ["Ancestral Grounds"] = {
        ["ptBR"] = "Terras Ancestrais",
        ["ruRU"] = "Земли Предков",
        ["deDE"] = "Ahnengrund",
        ["koKR"] = "선조의 터",
        ["esMX"] = "Tierras Ancestrales",
        ["enUS"] = true,
        ["frFR"] = "Terres ancestrales",
        ["esES"] = "Tierras Ancestrales",
        ["zhTW"] = "先祖之地",
        ["zhCN"] = "先祖之地",
    },
    ["The Stair of Doom"] = {
        ["ptBR"] = "Degraus da Perdição",
        ["ruRU"] = "Ступени Фатума",
        ["deDE"] = "Die Stufen der Verdammnis",
        ["koKR"] = "파멸의 계단",
        ["esMX"] = "La Escalera Maldita",
        ["enUS"] = true,
        ["frFR"] = "L'escalier de la Fatalité",
        ["esES"] = "La Escalera Maldita",
        ["zhTW"] = "厄運階梯",
        ["zhCN"] = "末日阶梯",
    },
    ["The Hand of Gul'dan"] = {
        ["ptBR"] = "A Mão de Gul'dan",
        ["ruRU"] = "Рука Гул'дана",
        ["deDE"] = "Die Hand von Gul'dan",
        ["koKR"] = "굴단의 손아귀",
        ["esMX"] = "La Mano de Gul'dan",
        ["enUS"] = true,
        ["frFR"] = "La main de Gul'dan",
        ["esES"] = "La Mano de Gul'dan",
        ["zhTW"] = "古爾丹火山",
        ["zhCN"] = "古尔丹之手",
    },
    ["Sun's Reach Harbor"] = {
        ["ptBR"] = "Porto de Beirassol",
        ["ruRU"] = "Гавань Солнечного Края",
        ["deDE"] = "Hafen der Sonnenweiten",
        ["koKR"] = "태양너울 항구",
        ["esMX"] = "Puerto de Tramo del Sol",
        ["enUS"] = true,
        ["frFR"] = "Port des Confins du soleil",
        ["esES"] = "Puerto de Tramo del Sol",
        ["zhTW"] = "日境港",
        ["zhCN"] = "阳湾港口",
    },
    ["Sha'tari Base Camp"] = {
        ["ptBR"] = "Acampamento Sha'tari",
        ["ruRU"] = "Лагерь Ша'тар",
        ["deDE"] = "Basislager der Sha'tari",
        ["koKR"] = "샤타리 주둔지",
        ["esMX"] = "Campamento Sha'tari",
        ["enUS"] = true,
        ["frFR"] = "Camp de base sha'tari",
        ["esES"] = "Campamento Sha'tari",
        ["zhTW"] = "薩塔營地",
        ["zhCN"] = "沙塔尔营地",
    },
    ["Suncrown Village"] = {
        ["ptBR"] = "Vila Corona Solar",
        ["ruRU"] = "Деревня Солнечной Короны",
        ["deDE"] = "Sonnenkuppe",
        ["koKR"] = "태양왕관 마을",
        ["esMX"] = "Aldea Corona del Sol",
        ["enUS"] = true,
        ["frFR"] = "Solcouronne",
        ["esES"] = "Aldea Corona del Sol",
        ["zhTW"] = "日冠村",
        ["zhCN"] = "日冕村",
    },
    ["The Exodar"] = {
        ["ptBR"] = "Exodar",
        ["ruRU"] = "Экзодар",
        ["deDE"] = "Die Exodar",
        ["koKR"] = "엑소다르",
        ["esMX"] = "El Exodar",
        ["enUS"] = true,
        ["frFR"] = "L'Exodar",
        ["esES"] = "El Exodar",
        ["zhTW"] = "艾克索達",
        ["zhCN"] = "埃索达",
    },
    ["Razaan's Landing"] = {
        ["ptBR"] = "Campo de Razaan",
        ["ruRU"] = "Лагерь Разаана",
        ["deDE"] = "Razaans Landeplatz",
        ["koKR"] = "라잔의 영지",
        ["esMX"] = "Zona de Aterrizaje Razaan",
        ["enUS"] = true,
        ["frFR"] = "Point d'ancrage de Razaan",
        ["esES"] = "Zona de Aterrizaje Razaan",
        ["zhTW"] = "雷森平台",
        ["zhCN"] = "拉扎安码头",
    },
    ["Cenarion Refuge"] = {
        ["ptBR"] = "Refúgio Cenariano",
        ["ruRU"] = "Кенарийский приют",
        ["deDE"] = "Zuflucht des Cenarius",
        ["koKR"] = "세나리온 야영지",
        ["esMX"] = "Refugio Cenarion",
        ["enUS"] = true,
        ["frFR"] = "Refuge cénarien",
        ["esES"] = "Refugio Cenarion",
        ["zhTW"] = "塞納里奧避難所",
        ["zhCN"] = "塞纳里奥庇护所",
    },
    ["Silverline Lake"] = {
        ["ptBR"] = "Lago da Linha Prateada",
        ["ruRU"] = "Серебристое озеро",
        ["deDE"] = "Silberwellensee",
        ["koKR"] = "희망의 호수",
        ["esMX"] = "Lago Lineargenta",
        ["enUS"] = true,
        ["frFR"] = "Lac Rivargent",
        ["esES"] = "Lago Lineargenta",
        ["zhTW"] = "銀線湖",
        ["zhCN"] = "银链湖",
    },
    ["The Foul Pool"] = {
        ["ptBR"] = "O Lago Pútrido",
        ["ruRU"] = "Смрадный пруд",
        ["deDE"] = "Der besudelte Teich",
        ["koKR"] = "타락의 웅덩이",
        ["esMX"] = "La Poza del Hediondo",
        ["enUS"] = true,
        ["frFR"] = "Le bassin souillé",
        ["esES"] = "La Poza del Hediondo",
        ["zhTW"] = "邪惡池塘",
        ["zhCN"] = "污淤之池",
    },
    ["Ata'mal Terrace"] = {
        ["ptBR"] = "Terraço de Ata'mal",
        ["ruRU"] = "Терраса Ата'мала",
        ["deDE"] = "Terrasse von Ata'mal",
        ["koKR"] = "아타말 언덕",
        ["esMX"] = "Bancal de Ata'mal",
        ["enUS"] = true,
        ["frFR"] = "Terrasse Ata'mal",
        ["esES"] = "Bancal de Ata'mal",
        ["zhTW"] = "阿塔莫露臺",
        ["zhCN"] = "阿塔玛平台",
    },
    ["Marshlight Lake"] = {
        ["ptBR"] = "Lago Pantanoso",
        ["ruRU"] = "Озеро Болотных Огоньков",
        ["deDE"] = "Sumpflichtsee",
        ["koKR"] = "수렁등불 호수",
        ["esMX"] = "Lago Luz Pantanosa",
        ["enUS"] = true,
        ["frFR"] = "Lac des furoles",
        ["esES"] = "Lago Luz Pantanosa",
        ["zhTW"] = "沼澤光之湖",
        ["zhCN"] = "沼光湖",
    },
    ["Tranquillien"] = {
        ["ptBR"] = "Tranquillien",
        ["ruRU"] = "Транквиллион",
        ["deDE"] = "Tristessa",
        ["koKR"] = "트랜퀼리엔",
        ["esMX"] = "Tranquillien",
        ["enUS"] = true,
        ["frFR"] = "Tranquillien",
        ["esES"] = "Tranquillien",
        ["zhTW"] = "安寧地",
        ["zhCN"] = "塔奎林",
    },
    ["Thrallmar"] = {
        ["ptBR"] = "Thrallmar",
        ["ruRU"] = "Траллмар",
        ["deDE"] = "Thrallmar",
        ["koKR"] = "스랄마",
        ["esMX"] = "Thrallmar",
        ["enUS"] = true,
        ["frFR"] = "Thrallmar",
        ["esES"] = "Thrallmar",
        ["zhTW"] = "索爾瑪",
        ["zhCN"] = "萨尔玛",
    },
    ["Throne of Kil'jaeden"] = {
        ["ptBR"] = "Trono de Kil'jaeden",
        ["ruRU"] = "Трон Кил'джедена",
        ["deDE"] = "Kil'jaedens Thron",
        ["koKR"] = "킬제덴의 옥좌",
        ["esMX"] = "Trono de Kil'jaeden",
        ["enUS"] = true,
        ["frFR"] = "Trône de Kil'jaeden",
        ["esES"] = "Trono de Kil'Jaeden",
        ["zhTW"] = "基爾加丹王座",
        ["zhCN"] = "基尔加丹王座",
    },
    ["Trelleum Mine"] = {
        ["ptBR"] = "Mina Trelleum",
        ["ruRU"] = "Рудник Треллеума",
        ["deDE"] = "Trelleummine",
        ["koKR"] = "트렐리움 광산",
        ["esMX"] = "Mina Trelleum",
        ["enUS"] = true,
        ["frFR"] = "Mine de Trelleum",
        ["esES"] = "Mina Trelleum",
        ["zhTW"] = "崔爾曼礦坑",
        ["zhCN"] = "特雷卢姆矿井",
    },
    ["Valley of Bones"] = {
        ["ptBR"] = "Vale dos Ossos",
        ["ruRU"] = "Долина Костей",
        ["deDE"] = "Tal der Knochen",
        ["koKR"] = "뼈의 골짜기",
        ["esMX"] = "Valle de los Huesos",
        ["enUS"] = true,
        ["frFR"] = "Vallée des ossements",
        ["esES"] = "Valle de los Huesos",
        ["zhTW"] = "白骨之谷",
        ["zhCN"] = "白骨之谷",
    },
    ["Shattrath City"] = {
        ["ptBR"] = "Shattrath",
        ["ruRU"] = "Шаттрат",
        ["deDE"] = "Shattrath",
        ["koKR"] = "샤트라스",
        ["esMX"] = "Ciudad de Shattrath",
        ["enUS"] = true,
        ["frFR"] = "Shattrath",
        ["esES"] = "Ciudad de Shattrath",
        ["zhTW"] = "撒塔斯城",
        ["zhCN"] = "沙塔斯城",
    },
    ["The Ring of Trials"] = {
        ["ptBR"] = "Ringue da Provação",
        ["ruRU"] = "Круг Испытаний",
        ["deDE"] = "Der Ring der Prüfung",
        ["koKR"] = "시험의 투기장",
        ["esMX"] = "El Círculo de los Retos",
        ["enUS"] = true,
        ["frFR"] = "L'arène des épreuves",
        ["esES"] = "El Círculo de los Retos",
        ["zhTW"] = "試煉競技場",
        ["zhCN"] = "试炼竞技场",
    },
    ["The Vector Coil"] = {
        ["ptBR"] = "Espiral Vetorial",
        ["ruRU"] = "Энергоблок",
        ["deDE"] = "Die Vektorspule",
        ["koKR"] = "벡터 코일",
        ["esMX"] = "La Espiral Vectorial",
        ["enUS"] = true,
        ["frFR"] = "La bobine vectorielle",
        ["esES"] = "La Espiral Vectorial",
        ["zhTW"] = "旋繞導航器",
        ["zhCN"] = "矢量感应器",
    },
    ["Funggor Cavern"] = {
        ["ptBR"] = "Caverna Fungor",
        ["ruRU"] = "Пещера Грибгор",
        ["deDE"] = "Funggorhöhle",
        ["koKR"] = "버섯 동굴",
        ["esMX"] = "Caverna Funggor",
        ["enUS"] = true,
        ["frFR"] = "Caverne de Funggor",
        ["esES"] = "Caverna Funggor",
        ["zhTW"] = "方格洞穴",
        ["zhCN"] = "蘑菇洞",
    },
    ["Unused2"] = {
        ["ptBR"] = "Unused2",
        ["ruRU"] = "Unused2",
        ["deDE"] = "Unused2",
        ["koKR"] = "Unused2",
        ["esMX"] = "Unused2",
        ["enUS"] = true,
        ["frFR"] = "Unused2",
        ["esES"] = "Unused2",
        ["zhTW"] = "Unused2",
        ["zhCN"] = "Unused2",
    },
    ["Nesingwary Safari"] = {
        ["ptBR"] = "Safári Rosarães",
        ["ruRU"] = "Охотничий лагерь Эрнестуэя",
        ["deDE"] = "Nesingwarys Safari",
        ["koKR"] = "네싱워리 탐험대",
        ["esMX"] = "Safari Nesingwary",
        ["enUS"] = true,
        ["frFR"] = "Safari de Nesingwary",
        ["esES"] = "Safari Nesingwary",
        ["zhTW"] = "奈辛瓦里狩獵隊",
        ["zhCN"] = "奈辛瓦里狩猎队营地",
    },
    ["Legion Hold"] = {
        ["ptBR"] = "Cidadela da Legião",
        ["ruRU"] = "Форт Легиона",
        ["deDE"] = "Feste der Legion",
        ["koKR"] = "불타는 군단 요새",
        ["esMX"] = "Bastión de la Legión",
        ["enUS"] = true,
        ["frFR"] = "Bastion de la Légion",
        ["esES"] = "Bastión de la Legión",
        ["zhTW"] = "軍團要塞",
        ["zhCN"] = "军团要塞",
    },
    ["Dragonmaw Base Camp"] = {
        ["ptBR"] = "Campo-base Presa do Dragão",
        ["ruRU"] = "Лагерь Драконьей Пасти",
        ["deDE"] = "Basislager des Drachenmals",
        ["koKR"] = "용아귀 주둔지",
        ["esMX"] = "Campamento Faucedraco",
        ["enUS"] = true,
        ["frFR"] = "Campement des Gueules-de-dragon",
        ["esES"] = "Campamento Faucedraco",
        ["zhTW"] = "龍喉營地",
        ["zhCN"] = "龙喉营地",
    },
    ["Illidari Point"] = {
        ["ptBR"] = "Pontal Illidari",
        ["ruRU"] = "Аванпост иллидари",
        ["deDE"] = "Stätte der Illidari",
        ["koKR"] = "일리다리 거점",
        ["esMX"] = "Alto Illidari",
        ["enUS"] = true,
        ["frFR"] = "Halte Illidari",
        ["esES"] = "Alto Illidari",
        ["zhTW"] = "伊利達瑞崗哨",
        ["zhCN"] = "伊利达雷岗哨",
    },
    ["Cenarion Thicket"] = {
        ["ptBR"] = "Mata Cenariana",
        ["ruRU"] = "Перелесок Кенария",
        ["deDE"] = "Cenariusdickicht",
        ["koKR"] = "세나리온 수풀",
        ["esMX"] = "Matorral Cenarion",
        ["enUS"] = true,
        ["frFR"] = "Fourré cénarien",
        ["esES"] = "Matorral Cenarion",
        ["zhTW"] = "塞納里奧灌木林",
        ["zhCN"] = "塞纳里奥树林",
    },
    ["The Dawning Square"] = {
        ["ptBR"] = "Praça da Aurora",
        ["ruRU"] = "Рассветная площадь",
        ["deDE"] = "Platz der Morgenröte",
        ["koKR"] = "새벽 광장",
        ["esMX"] = "La Plaza Crepuscular",
        ["enUS"] = true,
        ["frFR"] = "Place du Point-du-jour",
        ["esES"] = "La Plaza Crepuscular",
        ["zhTW"] = "曙光廣場",
        ["zhCN"] = "黎明广场",
    },
    ["Cursed Hollow"] = {
        ["ptBR"] = "Clareira Maldita",
        ["ruRU"] = "Окаянная лощина",
        ["deDE"] = "Verfluchtes Dunkel",
        ["koKR"] = "저주받은 골짜기",
        ["esMX"] = "Hoya Maldita",
        ["enUS"] = true,
        ["frFR"] = "Creux maudit",
        ["esES"] = "Hoya Maldita",
        ["zhTW"] = "詛咒之谷",
        ["zhCN"] = "诅咒洞窟",
    },
    ["Greengill Coast"] = {
        ["ptBR"] = "Costa Guelraverde",
        ["ruRU"] = "Берег Зеленожабрых",
        ["deDE"] = "Küste der Grünkiemen",
        ["koKR"] = "초록아가미 해안",
        ["esMX"] = "Costa Branquia Verde",
        ["enUS"] = true,
        ["frFR"] = "Côte de Verte-branchie",
        ["esES"] = "Costa Branquia Verde",
        ["zhTW"] = "綠鰓海岸",
        ["zhCN"] = "绿鳃海岸",
    },
    ["Warmaul Hill"] = {
        ["ptBR"] = "Morro Guerramalho",
        ["ruRU"] = "Холм Боевого Молота",
        ["deDE"] = "Totschlägerhügel",
        ["koKR"] = "전쟁망치 언덕",
        ["esMX"] = "Colina Mazo de Guerra",
        ["enUS"] = true,
        ["frFR"] = "Colline des Cogneguerre",
        ["esES"] = "Colina Mazo de Guerra",
        ["zhTW"] = "戰槌山丘",
        ["zhCN"] = "战槌山",
    },
    ["Ogri'la"] = {
        ["ptBR"] = "Ogri'la",
        ["ruRU"] = "Огри'ла",
        ["deDE"] = "Ogri'la",
        ["koKR"] = "오그릴라",
        ["esMX"] = "Ogri'la",
        ["enUS"] = true,
        ["frFR"] = "Ogri'la",
        ["esES"] = "Ogri'la",
        ["zhTW"] = "歐格利拉",
        ["zhCN"] = "奥格瑞拉",
    },
    ["Sporeggar"] = {
        ["ptBR"] = "Sporeggar",
        ["ruRU"] = "Спореггар",
        ["deDE"] = "Sporeggar",
        ["koKR"] = "스포어가르",
        ["esMX"] = "Esporaggar",
        ["enUS"] = true,
        ["frFR"] = "Sporeggar",
        ["esES"] = "Esporaggar",
        ["zhTW"] = "斯博格爾",
        ["zhCN"] = "孢子村",
    },
    ["Dawnstar Village"] = {
        ["ptBR"] = "Vila Aurestela",
        ["ruRU"] = "Деревня Утренней Звезды",
        ["deDE"] = "Morgenstern",
        ["koKR"] = "돈스타 마을",
        ["esMX"] = "Poblado Estrella del Alba",
        ["enUS"] = true,
        ["frFR"] = "Étoile-de-l'aube",
        ["esES"] = "Poblado Estrella del Alba",
        ["zhTW"] = "晨星村",
        ["zhCN"] = "晨星村",
    },
    ["Skysong Lake"] = {
        ["ptBR"] = "Lago Celicanto",
        ["ruRU"] = "Озеро Небесной Песни",
        ["deDE"] = "Himmelsweisensee",
        ["koKR"] = "하늘노래 호수",
        ["esMX"] = "Lago Son Celeste",
        ["enUS"] = true,
        ["frFR"] = "Lac Chanteciel",
        ["esES"] = "Lago Son Celeste",
        ["zhTW"] = "天歌湖",
        ["zhCN"] = "天歌湖",
    },
    ["Forge Camp: Wrath"] = {
        ["ptBR"] = "Campo-forja: Ira",
        ["ruRU"] = "Лагерь Легиона: Гнев",
        ["deDE"] = "Konstruktionslager: Wut",
        ["koKR"] = "격노의 괴철로 기지",
        ["esMX"] = "Campamento Forja: Cólera",
        ["enUS"] = true,
        ["frFR"] = "Camp de forge : Courroux",
        ["esES"] = "Campamento Forja: Cólera",
        ["zhTW"] = "煉冶場:憤怒",
        ["zhCN"] = "铸魔营地：天罚",
    },
    ["The Bloodcursed Reef"] = {
        ["ptBR"] = "Recife do Sangue Maldito",
        ["ruRU"] = "Риф Проклятой Крови",
        ["deDE"] = "Das Riff des Blutfluchs",
        ["koKR"] = "핏빛저주의 산호초",
        ["esMX"] = "El Arrecife Sangre Maldita",
        ["enUS"] = true,
        ["frFR"] = "Le récit du sang maudit",
        ["esES"] = "El Arrecife Sangre Maldita",
        ["zhTW"] = "血咒沙洲",
        ["zhCN"] = "血咒暗礁",
    },
    ["Hewn Bog"] = {
        ["ptBR"] = "Brejo Ceifado",
        ["ruRU"] = "Болотные вырубки",
        ["deDE"] = "Prügelsumpf",
        ["koKR"] = "벌거벗은 수렁",
        ["esMX"] = "Ciénaga Talada",
        ["enUS"] = true,
        ["frFR"] = "Tourbière taillée",
        ["esES"] = "Ciénaga Talada",
        ["zhTW"] = "開闢泥沼",
        ["zhCN"] = "菌杆沼泽",
    },
    ["Ragefeather Ridge"] = {
        ["ptBR"] = "Crista Penabrava",
        ["ruRU"] = "Хребет Яростного Пера",
        ["deDE"] = "Rachfederkamm",
        ["koKR"] = "성난깃털 마루",
        ["esMX"] = "Loma Plumira",
        ["enUS"] = true,
        ["frFR"] = "Crête des Rageplumes",
        ["esES"] = "Loma Plumira",
        ["zhTW"] = "怒羽山脊",
        ["zhCN"] = "怒羽山",
    },
    ["Grishnath"] = {
        ["ptBR"] = "Grishnath",
        ["ruRU"] = "Гришнат",
        ["deDE"] = "Grishnath",
        ["koKR"] = "그리쉬나스",
        ["esMX"] = "Grishnath",
        ["enUS"] = true,
        ["frFR"] = "Grishnath",
        ["esES"] = "Grishnath",
        ["zhTW"] = "葛瑞許納什",
        ["zhCN"] = "格里施纳",
    },
    ["Blackwing Coven"] = {
        ["ptBR"] = "Conciliábulo do Asa Negra",
        ["ruRU"] = "Пещера Крыла Тьмы",
        ["deDE"] = "Pechschwingenkoven",
        ["koKR"] = "검은날개 소굴",
        ["esMX"] = "Aquelarre Alanegra",
        ["enUS"] = true,
        ["frFR"] = "Convent de l'Aile noire",
        ["esES"] = "Aquelarre Alanegra",
        ["zhTW"] = "黑翼集會所",
        ["zhCN"] = "黑翼集会所",
    },
    ["Stillpine Hold"] = {
        ["ptBR"] = "Aldeia de Pinhoquieto",
        ["ruRU"] = "Логово племени Тихвой",
        ["deDE"] = "Tannenruhfeste",
        ["koKR"] = "너울소나무 요새",
        ["esMX"] = "Bastión Semprepino",
        ["enUS"] = true,
        ["frFR"] = "Repaire des Calmepins",
        ["esES"] = "Bastión Semprepino",
        ["zhTW"] = "靜松要塞",
        ["zhCN"] = "止松要塞",
    },
    ["Valaar's Berth"] = {
        ["ptBR"] = "Atracadouro de Valaar",
        ["ruRU"] = "Причал Валаара",
        ["deDE"] = "Valaars Steg",
        ["koKR"] = "발라르의 나루",
        ["esMX"] = "Atracadero de Valaar",
        ["enUS"] = true,
        ["frFR"] = "Amarrage de Valaar",
        ["esES"] = "Atracadero de Valaar",
        ["zhTW"] = "瓦拉船台",
        ["zhCN"] = "瓦拉尔港口",
    },
    ["Zangar Ridge"] = {
        ["ptBR"] = "Crista Zíngara",
        ["ruRU"] = "Гряда Зангара",
        ["deDE"] = "Zangarkamm",
        ["koKR"] = "장가르 마루",
        ["esMX"] = "Loma de Zangar",
        ["enUS"] = true,
        ["frFR"] = "Crête de Zangar",
        ["esES"] = "Loma de Zangar",
        ["zhTW"] = "贊格山脊",
        ["zhCN"] = "赞加山",
    },
    ["Windrunner Spire"] = {
        ["ptBR"] = "Pico dos Correventos",
        ["ruRU"] = "Шпили Ветрокрылых",
        ["deDE"] = "Windläuferturm",
        ["koKR"] = "윈드러너 첨탑",
        ["esMX"] = "Aguja Brisaveloz",
        ["enUS"] = true,
        ["frFR"] = "Flèche de Coursevent",
        ["esES"] = "Aguja Brisaveloz",
        ["zhTW"] = "風行者塔",
        ["zhCN"] = "风行者之塔",
    },
    ["Tides' Hollow"] = {
        ["ptBR"] = "Gruta das Marés",
        ["ruRU"] = "Пещера Приливов",
        ["deDE"] = "Gezeitenhöhle",
        ["koKR"] = "파도 동굴",
        ["esMX"] = "Hoya Mareanorte",
        ["enUS"] = true,
        ["frFR"] = "Creux des marées",
        ["esES"] = "Hoya de la Marea",
        ["zhTW"] = "海潮窪地",
        ["zhCN"] = "海潮洞窟",
    },
    ["Manaforge Ultris"] = {
        ["ptBR"] = "Manaforja Ultris",
        ["ruRU"] = "Манагорн Ультрис",
        ["deDE"] = "Manaschmiede Ultris",
        ["koKR"] = "울트리스 마나괴철로",
        ["esMX"] = "Forja de Maná Ultris",
        ["enUS"] = true,
        ["frFR"] = "Manaforge Ultris",
        ["esES"] = "Forja de Maná Ultris",
        ["zhTW"] = "法力熔爐奧崔斯",
        ["zhCN"] = "法力熔炉：乌提斯",
    },
    ["Netherwing Fields"] = {
        ["ptBR"] = "Campos da Asa Etérea",
        ["ruRU"] = "Поля Крыльев Пустоты",
        ["deDE"] = "Netherschwingenfelder",
        ["koKR"] = "황천날개 벌판",
        ["esMX"] = "Campos del Ala Abisal",
        ["enUS"] = true,
        ["frFR"] = "Champs de l'Aile-du-Néant",
        ["esES"] = "Campos del Ala Abisal",
        ["zhTW"] = "虛空之翼農場",
        ["zhCN"] = "灵翼平原",
    },
    ["Veil Vekh"] = {
        ["ptBR"] = "Véu Vekh",
        ["ruRU"] = "Гнездовье Векх",
        ["deDE"] = "Vekhversteck",
        ["koKR"] = "장막의 베크",
        ["esMX"] = "Velo Vekh",
        ["enUS"] = true,
        ["frFR"] = "Voile Vekh",
        ["esES"] = "Velo Vekh",
        ["zhTW"] = "迷霧維克",
        ["zhCN"] = "维克鸦巢",
    },
    ["Coilskar Cistern"] = {
        ["ptBR"] = "Cisterna Serpentálios",
        ["ruRU"] = "Водохранилище Змеиных Колец",
        ["deDE"] = "Zisterne der Echsennarbe",
        ["koKR"] = "갈퀴흉터 저수지",
        ["esMX"] = "Cisterna Cicatriz Espiral",
        ["enUS"] = true,
        ["frFR"] = "Citerne de Glissentaille",
        ["esES"] = "Cisterna Cicatriz Espiral",
        ["zhTW"] = "考斯卡水池",
        ["zhCN"] = "库斯卡水池",
    },
    ["The Twilight Ridge"] = {
        ["ptBR"] = "Cordilheira do Crepúsculo",
        ["ruRU"] = "Сумеречная гряда",
        ["deDE"] = "Zwielichthöhe",
        ["koKR"] = "황혼의 마루",
        ["esMX"] = "La Cresta del Crepúsculo",
        ["enUS"] = true,
        ["frFR"] = "La crête du Crépuscule",
        ["esES"] = "La Cresta del Crepúsculo",
        ["zhTW"] = "暮光山脊",
        ["zhCN"] = "暮光岭",
    },
    ["Garadar"] = {
        ["ptBR"] = "Garadar",
        ["ruRU"] = "Гарадар",
        ["deDE"] = "Garadar",
        ["koKR"] = "가라다르",
        ["esMX"] = "Garadar",
        ["enUS"] = true,
        ["frFR"] = "Garadar",
        ["esES"] = "Garadar",
        ["zhTW"] = "卡拉達爾",
        ["zhCN"] = "加拉达尔",
    },
    ["The Deathforge"] = {
        ["ptBR"] = "Forja da Morte",
        ["ruRU"] = "Кузница Смерти",
        ["deDE"] = "Die Todesschmiede",
        ["koKR"] = "죽음의 괴철로",
        ["esMX"] = "La Forja Muerta",
        ["enUS"] = true,
        ["frFR"] = "La Forgemort",
        ["esES"] = "La Forja Muerta",
        ["zhTW"] = "死亡熔爐",
        ["zhCN"] = "死亡熔炉",
    },
    ["Netherwing Ledge"] = {
        ["ptBR"] = "Plataforma da Asa Etérea",
        ["ruRU"] = "Кряж Крыльев Пустоты",
        ["deDE"] = "Netherschwingenscherbe",
        ["koKR"] = "황천날개 마루",
        ["esMX"] = "Arrecife del Ala Abisal",
        ["enUS"] = true,
        ["frFR"] = "Escarpement de l'Aile-du-Néant",
        ["esES"] = "Arrecife del Ala Abisal",
        ["zhTW"] = "虛空之翼岩架",
        ["zhCN"] = "灵翼浮岛",
    },
    ["Burning Blade Ruins"] = {
        ["ptBR"] = "Ruínas da Lâmina Ardente",
        ["ruRU"] = "Руины Пылающего Клинка",
        ["deDE"] = "Ruinen der Brennenden Klinge",
        ["koKR"] = "불타는 칼날 폐허",
        ["esMX"] = "Ruinas Filo Ardiente",
        ["enUS"] = true,
        ["frFR"] = "Ruines de la Lame ardente",
        ["esES"] = "Ruinas Filo Ardiente",
        ["zhTW"] = "燃燒之劍廢墟",
        ["zhCN"] = "火刃废墟",
    },
    ["Wildwind Peak"] = {
        ["ptBR"] = "Morro Vento Selvagem",
        ["ruRU"] = "Штормовой Пик",
        ["deDE"] = "Wildwindgipfel",
        ["koKR"] = "갈기바람 봉우리",
        ["esMX"] = "Cima Ventosalvaje",
        ["enUS"] = true,
        ["frFR"] = "Pic Vent-sauvage",
        ["esES"] = "Cima Ventosalvaje",
        ["zhTW"] = "狂風山尖",
        ["zhCN"] = "狂风山",
    },
    ["Feth's Way"] = {
        ["ptBR"] = "Trilha de Feth",
        ["ruRU"] = "Путь Фета",
        ["deDE"] = "Feths Pfad",
        ["koKR"] = "페스의 길",
        ["esMX"] = "Camino de Feth",
        ["enUS"] = true,
        ["frFR"] = "Voie de Feth",
        ["esES"] = "Camino de Feth",
        ["zhTW"] = "費司之路",
        ["zhCN"] = "菲斯小径",
    },
    ["Razorthorn Shelf"] = {
        ["ptBR"] = "Passagem Espinhosa",
        ["ruRU"] = "Обрыв Острого Шипа",
        ["deDE"] = "Messerdornbank",
        ["koKR"] = "서슬가시 벼랑",
        ["esMX"] = "Saliente Rajaespina",
        ["enUS"] = true,
        ["frFR"] = "Saillie de Tranchépine",
        ["esES"] = "Saliente Rajaespina",
        ["zhTW"] = "刺棘沙洲",
        ["zhCN"] = "荆刺岩地",
    },
    ["Dragons' End"] = {
        ["ptBR"] = "Findragões",
        ["ruRU"] = "Драконья Пагуба",
        ["deDE"] = "Drachenend",
        ["koKR"] = "용의 무덤",
        ["esMX"] = "Cabo del Dragón",
        ["enUS"] = true,
        ["frFR"] = "Fin des dragons",
        ["esES"] = "Cabo del Dragón",
        ["zhTW"] = "飛龍之末",
        ["zhCN"] = "巨龙之末",
    },
    ["Ruins of Loreth'Aran"] = {
        ["ptBR"] = "Ruínas de Loreth'Aran",
        ["ruRU"] = "Развалины Лорет'Арана",
        ["deDE"] = "Ruinen von Loreth'Aran",
        ["koKR"] = "로레스아란 폐허",
        ["esMX"] = "Ruinas de Loreth'Aran",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Loreth'Aran",
        ["esES"] = "Ruinas de Loreth'Aran",
        ["zhTW"] = "羅薩倫廢墟",
        ["zhCN"] = "洛雷萨兰废墟",
    },
    ["The Dawnchaser"] = {
        ["ptBR"] = "Conquistador da Aurora",
        ["ruRU"] = "Рассветный охотник",
        ["deDE"] = "Die Morgensturm",
        ["koKR"] = "새벽추적자호",
        ["esMX"] = "El Cazador del Albor",
        ["enUS"] = true,
        ["frFR"] = "Le Chasselaube",
        ["esES"] = "El Cazador del Albor",
        ["zhTW"] = "晨逐者",
        ["zhCN"] = "曙光追寻者号",
    },
    ["Blades' Run"] = {
        ["ptBR"] = "Ladeira Afiada",
        ["ruRU"] = "Скалистая тропа",
        ["deDE"] = "Säbelflucht",
        ["koKR"] = "칼날 고개",
        ["esMX"] = "Camino de las Espadas",
        ["enUS"] = true,
        ["frFR"] = "Le défilé des lames",
        ["esES"] = "Camino de las Espadas",
        ["zhTW"] = "劍之小道",
        ["zhCN"] = "刀锋之路",
    },
    ["Beryl Coast"] = {
        ["ptBR"] = "Costa Berília",
        ["ruRU"] = "Берилловое побережье",
        ["deDE"] = "Beryllküste",
        ["koKR"] = "녹주석 해안",
        ["esMX"] = "Costa de Berilo",
        ["enUS"] = true,
        ["frFR"] = "La côte de Béryl",
        ["esES"] = "Costa Beryl",
        ["zhTW"] = "貝瑞歐海岸",
        ["zhCN"] = "贝里尔海湾",
    },
    ["Manaforge Coruu"] = {
        ["ptBR"] = "Manaforja Coruu",
        ["ruRU"] = "Манагорн Коруу",
        ["deDE"] = "Manaschmiede Coruu",
        ["koKR"] = "코루 마나괴철로",
        ["esMX"] = "Forja de Maná Coruu",
        ["enUS"] = true,
        ["frFR"] = "Manaforge Coruu",
        ["esES"] = "Forja de Maná Coruu",
        ["zhTW"] = "法力熔爐寇魯",
        ["zhCN"] = "法力熔炉：库鲁恩",
    },
    ["Falcon Watch"] = {
        ["ptBR"] = "Vigília do Falcão",
        ["ruRU"] = "Соколиный дозор",
        ["deDE"] = "Falkenwacht",
        ["koKR"] = "매의 감시탑",
        ["esMX"] = "Avanzada del Halcón",
        ["enUS"] = true,
        ["frFR"] = "Guet de l'épervier",
        ["esES"] = "Avanzada del Halcón",
        ["zhTW"] = "獵鷹哨站",
        ["zhCN"] = "猎鹰岗哨",
    },
    ["Goldenbough Pass"] = {
        ["ptBR"] = "Caminho Ramadouro",
        ["ruRU"] = "Тропа Золотой Ветви",
        ["deDE"] = "Goldblattpass",
        ["koKR"] = "황금가지 고개",
        ["esMX"] = "Desfiladero Ramadorada",
        ["enUS"] = true,
        ["frFR"] = "Passe du Rameau d'or",
        ["esES"] = "Desfiladero Ramadorada",
        ["zhTW"] = "金枝小徑",
        ["zhCN"] = "金枝小径",
    },
    ["The Sun Forge"] = {
        ["ptBR"] = "Forja do Sol",
        ["ruRU"] = "Кузня Солнца",
        ["deDE"] = "Die Sonnenschmiede",
        ["koKR"] = "태양 괴철로",
        ["esMX"] = "La Forja del Sol",
        ["enUS"] = true,
        ["frFR"] = "La forge du Soleil",
        ["esES"] = "La Forja del Sol",
        ["zhTW"] = "太陽熔爐",
        ["zhCN"] = "太阳熔炉",
    },
    ["Ruins of Sha'naar"] = {
        ["ptBR"] = "Ruínas de Sha'naar",
        ["ruRU"] = "Руины Ша'наара",
        ["deDE"] = "Ruinen von Sha'naar",
        ["koKR"] = "샤나르 폐허",
        ["esMX"] = "Ruinas de Sha'naar",
        ["enUS"] = true,
        ["frFR"] = "Ruines de Sha'naar",
        ["esES"] = "Ruinas de Sha'naar",
        ["zhTW"] = "夏納廢墟",
        ["zhCN"] = "沙纳尔废墟",
    },
    ["Area 52"] = {
        ["ptBR"] = "Área 52",
        ["ruRU"] = "Зона 52",
        ["deDE"] = "Area 52",
        ["koKR"] = "52번 구역",
        ["esMX"] = "Área 52",
        ["enUS"] = true,
        ["frFR"] = "Zone 52",
        ["esES"] = "Área 52",
        ["zhTW"] = "52區",
        ["zhCN"] = "52区",
    },
    ["Sylvanaar"] = {
        ["ptBR"] = "Sylvanaar",
        ["ruRU"] = "Сильванаар",
        ["deDE"] = "Sylvanaar",
        ["koKR"] = "실바나르",
        ["esMX"] = "Sylvanaar",
        ["enUS"] = true,
        ["frFR"] = "Sylvanaar",
        ["esES"] = "Sylvanaar",
        ["zhTW"] = "希爾瓦納",
        ["zhCN"] = "希尔瓦纳",
    },
    ["The Broken Hills"] = {
        ["ptBR"] = "Montes Partidos",
        ["ruRU"] = "Изрезанные холмы",
        ["deDE"] = "Die zerklüfteten Hügel",
        ["koKR"] = "뒤틀린 언덕",
        ["esMX"] = "Las Colinas Quebradas",
        ["enUS"] = true,
        ["frFR"] = "Les Collines brisées",
        ["esES"] = "Las Colinas Quebradas",
        ["zhTW"] = "破碎之丘",
        ["zhCN"] = "碎石岭",
    },
    ["Zabra'jin"] = {
        ["ptBR"] = "Zabra'jin",
        ["ruRU"] = "Забра'джин",
        ["deDE"] = "Zabra'jin",
        ["koKR"] = "자브라진",
        ["esMX"] = "Zabra'jin",
        ["enUS"] = true,
        ["frFR"] = "Zabra'jin",
        ["esES"] = "Zabra'jin",
        ["zhTW"] = "薩布拉金",
        ["zhCN"] = "萨布拉金",
    },
    ["Pod Cluster"] = {
        ["ptBR"] = "Módulos Espaciais",
        ["ruRU"] = "Отсек Капсулы",
        ["deDE"] = "Kapselteil",
        ["koKR"] = "탈출선 착륙지",
        ["esMX"] = "La Maraña de Cápsulas",
        ["enUS"] = true,
        ["frFR"] = "Grappe de capsules",
        ["esES"] = "La Maraña de Cápsulas",
        ["zhTW"] = "卵囊串",
        ["zhCN"] = "完整的逃生舱",
    },
    ["The Great Fissure"] = {
        ["ptBR"] = "A Grande Fenda",
        ["ruRU"] = "Глубокий Разлом",
        ["deDE"] = "Die große Kluft",
        ["koKR"] = "거대한 균열",
        ["esMX"] = "La Gran Fisura",
        ["enUS"] = true,
        ["frFR"] = "La Grande fissure",
        ["esES"] = "La Gran Fisura",
        ["zhTW"] = "大裂縫",
        ["zhCN"] = "大裂隙",
    },
    ["Amberweb Pass"] = {
        ["ptBR"] = "Desfiladeiro da Teia Âmbar",
        ["ruRU"] = "Перевал Янтарной Паутины",
        ["deDE"] = "Goldweberpass",
        ["koKR"] = "호박그물 고개",
        ["esMX"] = "Paso de Redámbar",
        ["enUS"] = true,
        ["frFR"] = "Passe d'Ambretoile",
        ["esES"] = "Paso de Redámbar",
        ["zhTW"] = "琥珀網小徑",
        ["zhCN"] = "琥珀蛛网小径",
    },
    ["Manaforge B'naar"] = {
        ["ptBR"] = "Manaforja B'naar",
        ["ruRU"] = "Манагорн Б'наар",
        ["deDE"] = "Manaschmiede B'naar",
        ["koKR"] = "브나르 마나괴철로",
        ["esMX"] = "Forja de Maná B'naar",
        ["enUS"] = true,
        ["frFR"] = "Manaforge B'naar",
        ["esES"] = "Forja de Maná B'naar",
        ["zhTW"] = "法力熔爐巴納爾",
        ["zhCN"] = "法力熔炉：布纳尔",
    },
    ["Bloodmaul Camp"] = {
        ["ptBR"] = "Base dos Malho Sangrento",
        ["ruRU"] = "Лагерь Кровавого Молота",
        ["deDE"] = "Lager der Blutschläger",
        ["koKR"] = "피망치 야영지",
        ["esMX"] = "Campamento Machacasangre",
        ["enUS"] = true,
        ["frFR"] = "Camp de la Masse-sanglante",
        ["esES"] = "Campamento Machacasangre",
        ["zhTW"] = "血槌營地",
        ["zhCN"] = "血槌营地",
    },
    ["Lake Jorune"] = {
        ["ptBR"] = "Lago Dorune",
        ["ruRU"] = "Озеро Иорун",
        ["deDE"] = "Jorunesee",
        ["koKR"] = "조룬 호수",
        ["esMX"] = "Lago Jorune",
        ["enUS"] = true,
        ["frFR"] = "Lac Jorune",
        ["esES"] = "Lago Jorune",
        ["zhTW"] = "佐魯湖",
        ["zhCN"] = "尤鲁恩湖",
    },
    ["Sketh'lon Base Camp"] = {
        ["ptBR"] = "Base Sketh'lon",
        ["ruRU"] = "Лагерь Скет'лона",
        ["deDE"] = "Basislager der Sketh'lon",
        ["koKR"] = "스케슬론 주둔지",
        ["esMX"] = "Campamento Sketh'lon",
        ["enUS"] = true,
        ["frFR"] = "Campement Sketh'lon",
        ["esES"] = "Campamento Sketh'lon",
        ["zhTW"] = "史凱瑟隆營地",
        ["zhCN"] = "斯克瑟隆营地",
    },
    ["Mag'hari Procession"] = {
        ["ptBR"] = "Cortejo Fúnebre Mag'hari",
        ["ruRU"] = "Похоронная процессия маг'харов",
        ["deDE"] = "Mag'harische Prozession",
        ["koKR"] = "마그하리 행렬",
        ["esMX"] = "Procesión Mag'hari",
        ["enUS"] = true,
        ["frFR"] = "Procession Mag'hari",
        ["esES"] = "Procesión Mag'hari",
        ["zhTW"] = "瑪格哈利隊伍",
        ["zhCN"] = "玛格汉车队",
    },
    ["Kessel's Crossing"] = {
        ["ptBR"] = "Travessia de Kessel",
        ["ruRU"] = "Лагерь Кессела",
        ["deDE"] = "Kessels Wegelager",
        ["koKR"] = "케셀의 길목",
        ["esMX"] = "Encrucijada de Kessel",
        ["enUS"] = true,
        ["frFR"] = "La croisée de Kessel",
        ["esES"] = "Encrucijada de Kessel",
        ["zhTW"] = "凱索十字路",
        ["zhCN"] = "凯希尔路口",
    },
}

for k, v in pairs(outlandLocales) do
    l10n.translations[k] = v
end
