-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                          https://tradeskillmaster.com                          --
--    All Rights Reserved - Detailed license information included with addon.     --
-- ------------------------------------------------------------------------------ --

local TSM = select(2, ...) ---@type TSM
local Locale = TSM.Include("Locale")
if not Locale.ShouldLoad("deDE") then return end
local L = {}

-- LOCALE STRINGS START HERE
L["%d Characters"] = "%d Charaktere"
L["%d Custom Sources"] = "%d Benutzerdefinierte Quellen"
L["%d Faction-Realms"] = "%d Fraktions-Realms"
L["%d Groups"] = "%d Gruppen"
L["%d Groups Selected"] = "%d Ausgewählte Gruppen"
L["%d Guilds"] = "%d Gilden"
L["%d Items"] = "%d Items"
L["%d Operations"] = "%d Operationen"
L["%d Players"] = "%d Spieler"
L["%d Professions"] = "%d Berufe"
L["%d Rarities"] = "%d Raritäten"
L["%d Results"] = "%d Ergebnisse"
L["%d Selected"] = "%d Ausgewählt"
L["%d Sources"] = "%d Quellen"
L["%d Sub-Groups"] = "%d Untergruppen"
L["%d Types"] = "%d Arten"
L["%d auctions"] = "%d Auktionen"
L["%d groups"] = "%d Gruppen"
L["%d groups were created and %d items were added from the table."] = "%d Gruppen wurden erstellt und %d Items wurden aus der Tabelle hinzugefügt."
L["%d of %d"] = "%d von %d"
L["%d subgroups included"] = "%d Beinhaltet Untergruppen"
L["%d |4Group:Groups; Selected (%d |4Item:Items;)"] = "%d |4Gruppe:Gruppen; ausgewählt (%d |4Item:Items;)"
L["%s %s Operations"] = "%s %s Operationen"
L["%s (%s bags, %s bank, %s AH, %s mail)"] = "%s (%s Taschen, %s Bank, %s AH, %s Post)"
L["%s (%s player, %s alts, %s AH)"] = "%s (%s Spieler, %s Twinks, %s AH)"
L["%s (%s player, %s alts, %s guild, %s AH)"] = "%s (%s Spieler, %s Twinks, %s Gilde, %s AH)"
L["%s (%s profit)"] = "%s (%s Profit)"
L["%s - %s has been reset to default values."] = "%s - %s wurde auf den Standardwert zurückgesetzt."
L["%s Crafts"] = "%s Rezepte"
L["%s Items Bought"] = "%s Gegenstände gekauft"
L["%s Items Cancelled"] = "%s Gegenstände abgebrochen"
L["%s Items Expired"] = "%s Gegenstände abgelaufen"
L["%s Items Resold"] = "%s Gegenstände weiterverkauft"
L["%s Items Selected"] = "%s Gegenstände markiert"
L["%s Items Sold"] = "%s Gegenstände verkauft"
L["%s Items Total"] = "%s Gegenstände gesamt"
L["%s Operations"] = "%s Operationen"
L["%s Posted Auctions"] = "%s Eingestelle Auktionen"
L["%s Posted Auctions (Filtered)"] = "%s Eingestelle Auktionen (gefiltert)"
L["%s Sold Auctions"] = "%s Auktionen verkauft"
L["%s Sold Auctions (Filtered)"] = "%s Auktionen verkauft (gefiltert)"
L["%s Total"] = "%s Gesamt"
L["%s Total Profit"] = "%s Gesamter Profit"
L["%s ago"] = "vor %s"
L["%s group is already up to date."] = "%s Gruppe ist bereits auf dem aktuellen Stand."
L["%s group updated with %d items and %d materials."] = "%s Gruppe aktualisiert mit %d Gegenständen und %d Materialien."
L["%s in guild vault"] = "%s im Gildentresor"
L["%s is a valid custom price but %s is an invalid item."] = "%s ist ein gültiger eigener Preis, aber %s ist ein ungültiges Item."
L["%s is a valid custom price but did not give a value for %s."] = "%s ist ein gültiger eigener Preis, ergibt aber keinen Wert für %s."
L["%s is not a valid custom price and gave the following error: %s"] = "%s ist kein gültiger eigener Preis und führte zu folgendem Fehler: %s"
L["%s is not a valid source."] = "%s is not a valid source."
L["%s operation"] = "%s Operation"
L["%s operations"] = "%s Operationen"
L["%s previously had the max number of operations, so removed %s."] = "%s hatte zuvor die max. Anzahl an Operationen, also %s entfernt."
L["%s removed."] = "%s entfernt."
L["%s sent you %s"] = "%s hat dir %s gesendet"
L["%s sent you %s and %s"] = "%s sendet dir %s und %s"
L["%s sent you a COD of %s for %s"] = "%s hat dir eine Nachnahmegebühr von %s für %s gesendet"
L["%s sent you a message: %s"] = "%s hat dir eine Nachricht gesendet: %s"
L["%s total"] = "%s Gesamt"
L["%sDrag%s to move this button"] = "%sZiehen%s, um diesen Button zu verschieben"
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."] = "%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."] = "%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."
L["%sLeft-Click%s to open the main window"] = "%sLinksklick%s, um das Hauptfenster zu öffnen"
L["%sLeft-Click|r to ignore an item for this session. Hold %sShift|r to ignore permanently. You can remove items from permanent ignore in the Vendoring settings."] = "%sLeft-Click|r to ignore an item for this session. Hold %sShift|r to ignore permanently. You can remove items from permanent ignore in the Vendoring settings."
L["'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."] = "'%s' ist eine ungültige Operation. Min. Nachschub von %d ist höher als max. Nachschub von %d für %s."
L["'%s' is not a valid argument for convert()."] = "'%s' is not a valid argument for convert()."
L["'%s' is not a valid item argument."] = "'%s' is not a valid item argument."
L["(%d/500 Characters)"] = "(%d/500 Zeichen)"
L["(minimum 0 - maximum %d)"] = "(mindestens 0 - maximal %d)"
L["1 Group"] = "1 Gruppe"
L["1 Item"] = "1 Item"
L["1D"] = "1T"
L["1M"] = "1M"
L["1W"] = "1W"
L["1Y"] = "1J"
L["2Y"] = "2J"
L["3M"] = "3M"
L["6M"] = "6M"
L["A custom price of %s for %s evaluates to %s."] = "Ein eigener Preis von %s für %s ergibt %s."
L["A profile with that name already exists on the target account. Rename it first and try again."] = "Ein Profil mit diesem Namen existiert bereits auf dem Ziel-Account. Benenne es zuerst um und versuche es noch einmal."
L["A profile with this name already exists."] = "Ein Profil mit diesem Namen existiert bereits."
L["A scan is already in progress. Please stop that scan before starting another one."] = "Ein Scan wird bereits durchgeführt. Bitte beende diesen Scan, bevor du einen weiteren startest."
L["A single craft makes %d and you only need to restock %d."] = "A single craft makes %d and you only need to restock %d."
L["AH"] = "AH"
L["AH (Crafting)"] = "AH (Herstellen)"
L["AH (Disenchanting)"] = "AH (Entzaubern)"
L["AH BUSY"] = "AH BESCHÄFTIGT"
L["AHDB Minimum Bid"] = "AHDB Minimales Gebot"
L["AHDB Minimum Buyout"] = "AHDB Minimaler Sofortkauf"
L["ALT"] = "ALT"
L["Above max expires."] = "Über max. Abläufe."
L["Above max price. Not posting."] = "Über max. Preis. Erstelle keine Auktion."
L["Above max price. Posting at max."] = "Über max. Preis. Nutze Maximum."
L["Above max price. Posting at min."] = "Über max. Preis. Nutze Minimum."
L["Above max price. Posting at normal."] = "Über max. Preis. Nutze Normalpreis."
L["Accept COD?"] = "Nachnahme annehmen?"
L["Accepting this item will cost: %s"] = "Diesen Gegenstand akzeptieren kostet: %s"
L["Account Syncing"] = "Account-Sync"
L["Account sync removed. Please delete the account sync from the other account as well."] = "Account-Sync entfernt. Bitte entferne den Account-Sync auch auf dem anderen Account."
L["Accounting"] = "Accounting"
L["Active"] = "Active"
L["Active Alt"] = "Aktiver Twink"
L["Activity Type"] = "Aktivitätstyp"
L["Add"] = "Hinzufügen"
L["Add %d |4Item:Items"] = "%d hinzufügen |4Item:Items"
L["Add %s Operation"] = "%s Operationen hinzufügen"
L["Add More Operations"] = "Mehr Operationen hinzufügen"
L["Add Operation"] = "Operation hinzufügen"
L["Add Subject / Description"] = "Betreff / Beschreibung hinzufügen"
L["Add a new custom source"] = "Neue benutzerdefinierte Quelle hinzufügen"
L["Add account"] = "Konto hinzufügen"
L["Add operation to groups"] = "Operation zu Gruppen hinzufügen"
L["Add subject & description (optional)"] = "Betreff & Beschreibung hinzufügen (optional)"
L["Add to Mail"] = "Zur Post hinzufügen"
L["Added %s to %s."] = "Die Operation %s wurde zur Gruppe %s hinzugefügt."
L["Added '%s' profile which was received from %s."] = "'%s' Profil hinzugefügt. Erhalten von %s."
L["Additional error suppressed"] = "Zusätzlicher Fehler unterdrückt"
L["Adjust how TSM values crafted items when calculating profit."] = "Adjust how TSM values crafted items when calculating profit."
L["Adjust how crafted items are restocked."] = "Anpassen, wie hergestellter Gegenstand wieder aufgefüllt wird."
L["Adjust how items are mailed."] = "Pass Versand von Gegenstände an"
L["Adjust some general settings."] = "Generelle Einstellungen anpassen."
L["Adjust the settings below to set how groups attached to this operation will be auctioned."] = "Lege fest, wie die Gruppen von dieser Operation auktioniert werden sollen."
L["Adjust the settings below to set how groups attached to this operation will be cancelled."] = "Lege fest, wie die Gruppen von dieser Operation abgebrochen werden sollen."
L["Adjust the settings below to set how groups attached to this operation will be priced."] = "Lege fest, wie die Gruppen von dieser Operation preislich behandelt werden sollen."
L["Advanced Item Search"] = "Erweiterte Itemsuche"
L["Alarm Clock"] = "Wecker"
L["All"] = "Alles"
L["All Auctions"] = "Alle Auktionen"
L["All Bought"] = "Alles gekauft"
L["All Cancelled"] = "Alles abgebrochen"
L["All Characters"] = "Alle Charaktere"
L["All Expired"] = "Alle abgelaufenen"
L["All Faction-Realms"] = "Alle Frations-Realms"
L["All Guilds"] = "Alle Gilden"
L["All Item Classes"] = "Alle Gegenstandsklassen"
L["All Other"] = "Alle sonstigen"
L["All Players"] = "Alle Spieler"
L["All Professions"] = "Alle Berufe"
L["All Rarites"] = "Alle Raritäten"
L["All Rarities"] = "Alle Raritäten"
L["All Selected"] = "Alles ausgewählt"
L["All Slots"] = "Alle Plätze"
L["All Sold"] = "Alles verkauft"
L["All Sources"] = "Alle Quellen"
L["All Subclasses"] = "Alle Unterklassen"
L["All Time"] = "All Time"
L["All Types"] = "Alle Arten"
L["Allow partial stack"] = "Teilstapel zulassen"
L["Allows for testing of custom prices"] = "Allows for testing of custom prices"
L["Alt Guild Bank"] = "Twink Gildenbank"
L["Alts"] = "Twinks"
L["Alts AH"] = "Twinks AH"
L["Amount"] = "Betrag"
L["Amount kept in bags"] = "Menge in der Tasche behalten"
L["Amount of bag space to keep free"] = "Menge an Plätzen in der Tasche freilassen"
L["An old TSM addon was found installed. Please remove %s and any other old TSM addons to avoid issues."] = "Ein altes, installiertes TSM Addon gefunden. Bitte lösche %s und alle anderen alten TSM Addons, um Fehler zu vermeiden."
L["App Not Synced"] = "App nicht synchronisiert"
L["App Synced %s Ago"] = "App vor %s synchronisiert"
L["Appearance"] = "Aussehen"
L["Apply operation to group"] = "Operation auf Gruppe anwenden"
L["Are you sure you want to clear accounting data older than %d days for the currenet realm?"] = "Are you sure you want to clear accounting data older than %d days for the currenet realm?"
L["Are you sure you want to delete the selected operations?"] = "Bist du sicher, dass du die markierte Operation löschen willst?"
L["Are you sure you want to delete this operation?"] = "Diese Operation wirklich löschen?"
L["At above max price and not undercut."] = "Über max. Preis und nicht unterboten."
L["At normal price and not undercut."] = "Zum Normalpreis aber nicht unterbieten."
L["Attachments"] = "Anhänge"
L["Auction"] = "Auktion"
L["Auction House Cut"] = "Auktionshausgebühr"
L["Auction House Sounds"] = "Auktionshaus Ton"
L["Auction Window Close"] = "Auktionsfenster schließen"
L["Auction Window Open"] = "Auktionsfenster öffnen"
L["Auction duration"] = "Auktionsdauer"
L["Auction has been bid on."] = "Auf die Auktion wurde geboten."
L["Auction sale sound"] = "Auktion verkauft Ton"
L["AuctionDB"] = "AuktionsDB"
L["AuctionDB - Historical Price"] = "AuctionDB - Historical Price"
L["AuctionDB - Market Value"] = "AuktionsDB - Marktpreis"
L["AuctionDB - Minimum Buyout"] = "AuctionDB - Minimum Buyout"
L["AuctionDB - Recent Value"] = "AuctionDB - Recent Value"
L["AuctionDB - Region Historical Price"] = "AuctionDB - Region Historical Price"
L["AuctionDB - Region Market Value Average"] = "AuctionDB - Region Market Value Average"
L["AuctionDB - Region Sale Average"] = "AuctionDB - Region Sale Average"
L["AuctionDB - Region Sale Rate"] = "AuctionDB - Region Sale Rate"
L["AuctionDB - Region Sold Per Day"] = "AuctionDB - Region Sold Per Day"
L["AuctionDB Realm Data is %s Old"] = "AuctionDB Realm Data is %s Old"
L["AuctionDB Region Data is %s Old"] = "AuctionDB Region Data is %s Old"
L["Auctionator - Auction Value"] = "Auctionator - Auktionswert"
L["Auctioneer - Appraiser"] = "Auctioneer - Appraiser"
L["Auctioneer - Market Value"] = "Auctioneer - Marktwert"
L["Auctioneer - Minimum Buyout"] = "Auctioneer - Mindestsofortkauf"
L["Auctioning"] = "Auctioning"
L["Auctioning %s button"] = "Auctioning %s button"
L["Auctioning Details"] = "Auctioning Details"
L["Auctioning Log"] = "Auctioning-Protokoll"
L["Auctioning Operation"] = "Auctioning-Operation"
L["Auctioning operation"] = "Auctioning operation"
L["Auctioning operations control posting to and canceling from the AH."] = "Auctioning operations control posting to and canceling from the AH."
L["Auctions"] = "Aukts"
L["Auto Quest Complete"] = "Auto-Quest abgeschlossen"
L["Auto-focus browse search input"] = "Auto-focus browse search input"
L["Average Earned per Day"] = "Durchschnittlich verdient pro Tag"
L["Average Prices:"] = "Durchschnittspreise:"
L["Average Profit per Day"] = "Ø Profit pro Tag"
L["Average Spent per Day"] = "Durchschnittlich ausgegeben pro Tag"
L["Avg Buy Price"] = "Ø Kaufpreis"
L["Avg Profit"] = "Ø Profit"
L["Avg Sell Price"] = "Ø Verkaufspreis"
L["BUSY"] = "BESCHÄFTIGT"
L["BUY"] = "KAUFEN"
L["Back"] = "Zurück"
L["Bag"] = "Tasche"
L["Bags"] = "Tasche"
L["Bank"] = "Bank"
L["Banking"] = "Banking"
L["Banks"] = "Bank"
L["Base Group"] = "Basisgruppe"
L["Base Item"] = "Grund-Item"
L["Below is a list of all available price sources, along with a brief description of what they represent."] = "Hier ist eine Liste aller verfügbaren Preisquellen inkl. einer kurzen Beschreibung jeder Quelle."
L["Below min price. Posting at max."] = "Unter min. Preis. Nutze Maximum."
L["Below min price. Posting at min."] = "Below min price. Posting at min."
L["Below min price. Posting at normal."] = "Below min price. Posting at normal."
L["Below you can ignore this operation on certain characters or realms."] = "Below you can ignore this operation on certain characters or realms."
L["Bid %d / %d"] = "Bieten %d / %d"
L["Bid (item)"] = "Gebot (Item)"
L["Bid (stack)"] = "Gebot (Stapel)"
L["Bid (total)"] = "Gebot (Gesamt)"
L["Bid / Buyout"] = "Bieten / Sofortkauf"
L["Bid Auction"] = "Bieten Auktion"
L["Bid Price"] = "Gebotspreis"
L["Bid Sniper Paused"] = "Gebot-Sniper pausiert"
L["Bid Sniper Running"] = "Gebot-Sniper läuft"
L["Bid percent must be between 0 and 100."] = "Gebot muss zwischen 0 und 100 Prozent liegen."
L["Bidding Auction"] = "Gebots-Auktion"
L["Blacklisted players"] = "Spieler auf Blacklist"
L["Bought"] = "Gekauft"
L["Bought %d of %s from %s for %s"] = "%d %s von %s für %s gekauft"
L["Bought %sx%d for %s from %s"] = "%sx%d gekauft für %s von %s"
L["Bound Actions"] = "Gebundene Aktionen"
L["Browse"] = "Durchsuchen"
L["Browse / Sniper"] = "Durchsuchen / Sniper"
L["Buy"] = "Kaufen"
L["Buy %d / %d"] = "Kaufe %d / %d"
L["Buy %d / %d (Confirming %d / %d)"] = "Kaufe %d / %d (Bestätige %d / %d)"
L["Buy Auction"] = "Kaufe Auktion"
L["Buy Commodity"] = "Buy Commodity"
L["Buy Commodity (%02d)"] = "Buy Commodity (%02d)"
L["Buy Groups"] = "Kaufe Gruppen"
L["Buy Options"] = "Kaufoptionen"
L["Buy from AH"] = "Im AH kaufen"
L["Buy from AH (Crafting)"] = "Kaufe vom AH (Herstellen)"
L["Buy from AH (Disenchant)"] = "Kaufe vom AH (Entzaubern)"
L["Buy from Vendor"] = "Vom Händler kaufen"
L["Buyback All"] = "Buyback All"
L["Buyer/Seller"] = "Käufer/Verkäufer"
L["Buyout"] = "Aufkaufen"
L["Buyout (item)"] = "Sofortkauf (Item)"
L["Buyout (stack)"] = "Sofortkauf (Stapel)"
L["Buyout (total)"] = "Aufkaufen (Gesamt)"
L["Buyout Above Threshold"] = "Buyout Above Threshold"
L["Buyout Price"] = "Sofortkauf"
L["Buyout Sniper Paused"] = "Sofortkauf-Sniper pausiert"
L["Buyout Sniper Running"] = "Sofortkauf-Sniper läuft"
L["Buyout confirmation alert"] = "Buyout confirmation alert"
L["COD"] = "Nachnahme"
L["CRAFT"] = "HERSTELLEN"
L["CRAFTING"] = "HERSTELLEN"
L["CTRL"] = "STRG"
L["Can't load TSM tooltip while in combat"] = "TSM Tooltipp kann während eines Kampfes nicht geladen werden"
L["Cancel"] = "Abbrechen"
L["Cancel %d / %d"] = "Abbrechen %d / %d"
L["Cancel Auction"] = "Auktion abbrechen"
L["Cancel Scan"] = "Scan abbrechen"
L["Cancel auctions with bids"] = "Auktionen mit Geboten abbrechen"
L["Cancel or Post"] = "Abbrechen oder Einstellen"
L["Cancel to repost higher"] = "Abbrechen um höher einzustellen"
L["Cancel undercut auctions"] = "Unterbotene Auktionen abbrechen"
L["Canceled information"] = "Canceled information"
L["Canceling"] = "Abbrechen"
L["Canceling %d / %d"] = "Abbrechen %d / %d"
L["Canceling %d Auctions..."] = "Breche %d Auktionen ab..."
L["Canceling Options"] = "Abbruch-Optionen"
L["Canceling auction you've undercut."] = "breche Auktion ab die du unterboten hast"
L["Canceling disabled."] = "Abbrechen deaktiviert."
L["Canceling to repost at higher price."] = "Breche ab, um zum höheren Preis zu erstellen."
L["Canceling to repost at reset price."] = "Abbrechen, um zum Reset-Preis wieder einzustellen."
L["Canceling to repost higher."] = "Breche ab, um zum höheren Preis zu erstellen."
L["Canceling undercut auctions and to repost higher."] = "Unterbotene Auktionen abbrechen um höher einzustellen."
L["Canceling undercut auctions."] = "Breche unterbotene Auktionen ab."
L["Cancelled"] = "Abgebrochen"
L["Cancelled Since Last Sale"] = "Abgebrochen seit letztem Verkauf"
L["Cancelled auction of %sx%d"] = "Abgebrochene Auktion von %sx%d"
L["Cancelled:"] = "Abgebrochen:"
L["Cannot repair from the guild bank!"] = "Kann nicht aus der Gildenbank repariert werden!"
L["Cannot use additional filters with /crafting or /disenchant."] = "Cannot use additional filters with /crafting or /disenchant."
L["Cash Register"] = "Registrierkasse"
L["Changes to the specified profile (i.e. '/tsm profile Default' changes to the 'Default' profile)"] = "Changes to the specified profile (i.e. '/tsm profile Default' changes to the 'Default' profile)"
L["Character"] = "Charakter"
L["Chat Tab"] = "Chat-Tab"
L["Cheapest auction below min price."] = "billigste Auktion unter Mindestpreis."
L["Clear All"] = "Alles leeren"
L["Clear Data"] = "Clear Data"
L["Clear Filters"] = "Filter leeren"
L["Clear Old Data"] = "Alte Daten löschen"
L["Clear Old Data?"] = "Clear Old Data?"
L["Click and drag to resize this window."] = "Klicken und ziehen, um Fenstergröße zu ändern."
L["Click to hide this item for the current session. Hold shift to hide this item permanently."] = "Klicken, um den Gegenstand in der aktuellen Sitzung zu verstecken. Shift gedrückt halten für permanentes verstecken."
L["Coins (%s)"] = "Münzen (%s)"
L["Combine Partial Stacks"] = "Geteilte Bündel verbinden"
L["Combining..."] = "Kombinieren..."
L["Confirm"] = "Bestätigen"
L["Confirm complete sound"] = "Confirm complete sound"
L["Confirmation %s button"] = "Confirmation %s button"
L["Confirming %d / %d"] = "Bestätige %d / %d"
L["Confirming..."] = "Confirming..."
L["Connected to %s"] = "Verbunden mit %s ß"
L["Connecting to %s"] = "Verbinde zu %s"
L["Contacts"] = "Kontakte"
L["Contains auctions above your alert threshold!"] = "Contains auctions above your alert threshold!"
L["Contains auctions above your material value!"] = "Contains auctions above your material value!"
L["Convert Value (%s)"] = "Convert Value (%s)"
L["Cooldown"] = "Abklingzeit"
L["Cooldowns"] = "Abklingzeiten"
L["Copy Letter"] = "Copy Letter"
L["Cost"] = "Kosten"
L["Could not create macro as you already have too many. Delete one of your existing macros and try again."] = "Makro konnte nicht erstellt werden, da du bereits zu viele hast. Lösche ein vorhandenes Makro und versuche es erneut."
L["Could not find profile '%s'. Possible profiles: '%s'"] = "Profil '%s' konnte nicht gefunden werden. Mögliche Profile: '%s'"
L["Could not sell items due to not having free bag space available to split a stack of items."] = "Items konnten nicht verkaufen werden, da kein freier Taschenplatz verfügbar ist, um ein Stapel aufzuteilen."
L["Craft"] = "Herst"
L["Craft (Profitable)"] = "Craft (Profitable)"
L["Craft (Unprofitable)"] = "Herstellen (unprofitabel)"
L["Craft Next"] = "Craft Next"
L["Craft Value"] = "Craft Value"
L["Craft Vellum"] = "Craft Vellum"
L["Crafted Items"] = "Crafted Items"
L["Crafter"] = "Crafter"
L["Crafting"] = "Herstellen"
L["Crafting %s button"] = "Crafting %s button"
L["Crafting Cost"] = "Herst Kosten"
L["Crafting Material Cost"] = "Crafting Material Cost"
L["Crafting Mode"] = "Herstellungsmodus"
L["Crafting UI Improvements"] = "Crafting UI Improvements"
L["Crafting Value"] = "Crafting Value"
L["Crafting cost"] = "Herstellungskosten"
L["Crafting operation"] = "Crafting operation"
L["Crafting operations control how queuing profession crafts."] = "Crafting operations control how queuing profession crafts."
L["Crafts"] = "Rezepte"
L["Create Groups from Table"] = "Gruppe von Tabelle erstellen"
L["Create New"] = "Neu"
L["Create New Group"] = "Neue Gruppe erstellen"
L["Create New Operation"] = "Neue Operation erstellen"
L["Create Profession Groups"] = "Neue Beruf-Gruppen erstellen"
L["Create macro"] = "Makro erstellen"
L["Create new profile"] = "Neues Profil erstellen"
L["Current Price"] = "Aktueller Preis"
L["Custom"] = "Custom"
L["Custom Price"] = "Eigener Preis"
L["Custom Source"] = "Eigene Quelle"
L["Custom Sources"] = "Eigene Quellen"
L["Custom Theme"] = "Custom Theme"
L["Custom price name %s already exists."] = "Custom price name %s already exists."
L["Custom price name %s is a reserved word which cannot be used."] = "Custom price name %s is a reserved word which cannot be used."
L["Custom price names can only contain lowercase letters."] = "Custom price names can only contain lowercase letters."
L["Custom source (%s)"] = "Eigene Quellen (%s)"
L["Custom sources allow you to create more advanced prices for use throughout the addon. You'll be able to use these new variables in the same way you can use the built-in price sources such as %s and %s."] = "Custom sources allow you to create more advanced prices for use throughout the addon. You'll be able to use these new variables in the same way you can use the built-in price sources such as %s and %s."
L["DAILY PURCHASES"] = "TÄGLICHE KÄUFE"
L["DAILY SALES"] = "TÄGLICHE VERKÄUFE"
L["Dalaran"] = "Dalaran"
L["Dashboard"] = "Übersicht"
L["Default Price"] = "Standardpreis"
L["Default craft value method"] = "Default craft value method"
L["Default material cost method"] = "Default material cost method"
L["Default price configuration"] = "Default price configuration"
L["Define what priority Gathering gives certain sources."] = "Define what priority Gathering gives certain sources."
L["Delete %d Operations"] = "%d Operationen löschen"
L["Delete Group?"] = "Gruppe löschen?"
L["Delete Operation?"] = "Operation löschen?"
L["Delete Operations"] = "Operationen löschen"
L["Delete Operations?"] = "Operationen löschen?"
L["Delete Profile?"] = "Profil löschen?"
L["Delete Record?"] = "Aufzeichnung löschen?"
L["Delete the profile"] = "Lösche das Profil"
L["Deleting this group (%s) will also remove any sub-groups attached to this group."] = "Wenn du diese Gruppe entfernst (%s), werden auch alle zugehörigen Untergruppen gelöscht."
L["Deposit"] = "Anzahlung"
L["Deposit Cost"] = "Anzahlungs-Kosten"
L["Deposit reagents"] = "Deposit reagents"
L["Deselect All"] = "Alles abwählen"
L["Destroy Next"] = "Nächstes zerstören"
L["Destroy Value"] = "Zerstörungswert"
L["Destroy value"] = "Destroy value"
L["Destroy value source"] = "Destroy value source"
L["Destroying"] = "Destroying"
L["Destroying %s button"] = "Destroying %s button"
L["Destroying will ignore %s permanently. You can remove it from the ignored list in the settings."] = "Destroying will ignore %s permanently. You can remove it from the ignored list in the settings."
L["Destroying will ignore %s until you log out."] = "Destroying will ignore %s until you log out."
L["Destroying..."] = "Zerstören..."
L["Detailed crafting cost"] = "Detailed crafting cost"
L["Details"] = "Details"
L["Did not cancel %s because your cancel to repost threshold (%s) is invalid. Check your settings."] = "Die Auktion von %s wurde nicht abgebrochen, weil dein Schwellenwert zum Abbrechen einer Auktion, um sie neu zu erstellen (%s), ungültig ist. Überprüfe deine Einstellungen."
L["Did not cancel %s because your maximum price (%s) is invalid. Check your settings."] = "Auktion von %s nicht abgebrochen, weil max. Preis (%s) ungültig ist. Einstellungen prüfen."
L["Did not cancel %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "Auktion von %s nicht abgebrochen, weil max. Preis (%s) niedriger als min. Preis. (%s) Einstellungen prüfen."
L["Did not cancel %s because your minimum price (%s) is invalid. Check your settings."] = "Die Auktion von %s wurde nicht abgebrochen, weil dein Mindestpreis (%s) ungültig ist. Überprüfe deine Einstellungen."
L["Did not cancel %s because your normal price (%s) is invalid. Check your settings."] = "Die Auktion von %s wurde nicht abgebrochen, weil dein normaler Preis (%s) ungültig ist. Überprüfe deine Einstellungen."
L["Did not cancel %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "Die Auktion von %s wurde nicht abgebrochen, weil dein normaler Preis (%s) niedriger ist als dein Mindestpreis (%s). Überprüfe deine Einstellungen."
L["Did not cancel %s because your undercut (%s) is invalid. Check your settings."] = "Die Auktion von %s wurde nicht abgebrochen, weil dein Unterbieten (%s) ungültig ist. Überprüfe deine Einstellungen."
L["Did not change prices due to an invalid bid or buyout value."] = "Did not change prices due to an invalid bid or buyout value."
L["Did not post %s because Blizzard didn't provide all necessary information for it. Try again later."] = "Die Auktion von %s wurde nicht erstellt, weil Blizzard nicht alle notwendigen Informationen dafür bereitgestellt hat. Versuche es später noch einmal."
L["Did not post %s because the owner of the lowest auction (%s) is on both the blacklist and whitelist which is not allowed. Adjust your settings to correct this issue."] = "Auktion für %s wurde nicht erstellt, da der Besitzer der günstigsten Auktion (%s) sowohl auf der schwarzen als auch auf der weißen Liste steht, was nicht erlaubt ist. Passe deine Einstellungen an, um dieses Problem zu beheben."
L["Did not post %s because you or one of your alts (%s) is on the blacklist which is not allowed. Remove this character from your blacklist."] = "Auktion für %s wurde nicht erstellt, weil du oder einer deiner Twinks (%s) auf der schwarzen Liste steht, was nicht erlaubt ist. Entferne diesen Charakter aus deiner schwarzen Liste."
L["Did not post %s because your keep quantity (%s) is invalid. Check your settings."] = "Did not post %s because your keep quantity (%s) is invalid. Check your settings."
L["Did not post %s because your max expires (%s) is invalid. Check your settings."] = "Auktion für %s nicht erstellt, weil max. Abläufe (%s) ungültig sind. Einstellungen prüfen."
L["Did not post %s because your maximum price (%s) is invalid. Check your settings."] = "Auktion von %s nicht erstellt, weil max. Preis (%s) ungültig ist. Einstellungen prüfen."
L["Did not post %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "Die Auktion von %s wurde nicht erstellt, weil dein Höchstpreis (%s) niedriger ist als dein Mindestpreis (%s). Überprüfe deine Einstellungen."
L["Did not post %s because your minimum price (%s) is invalid. Check your settings."] = "Die Auktion von %s wurde nicht erstellt, weil dein Mindestpreis (%s) ungültig ist. Überprüfe deine Einstellungen."
L["Did not post %s because your normal price (%s) is invalid. Check your settings."] = "Die Auktion von %s wurde nicht erstellt, weil dein normaler Preis (%s) ungültig ist. Überprüfe deine Einstellungen."
L["Did not post %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "Die Auktion von %s wurde nicht erstellt, weil dein normaler Preis (%s) niedriger ist als dein Mindestpreis (%s). Überprüfe deine Einstellungen."
L["Did not post %s because your post cap (%s) is invalid. Check your settings."] = "Did not post %s because your post cap (%s) is invalid. Check your settings."
L["Did not post %s because your stack size (%s) is invalid. Check your settings."] = "Did not post %s because your stack size (%s) is invalid. Check your settings."
L["Did not post %s because your undercut (%s) is invalid. Check your settings."] = "Die Auktion von %s wurde nicht erstellt, weil dein Unterbieten (%s) ungültig ist. Überprüfe deine Einstellungen."
L["Disable invalid price warnings"] = "Warnungen über ungültige Preise deaktivieren"
L["Disenchant Search"] = "Entzauberungssuche"
L["Disenchant Search Options"] = "Optionen für die Entzauberungssuche"
L["Disenchant Value"] = "Entzauberungswert"
L["Disenchanting Options"] = "Entzauberungsoptionen"
L["Display total money received in chat"] = "Zeige das gesamte erhaltene Geld im Chat"
L["Don't Post Items"] = "Keine Items auktionieren"
L["Don't post after this many expires"] = "Don't post after this many expires"
L["Don't prompt to record trades"] = "Keine Rückfrage zur Protokollierung von Handelsaktivitäten"
L["Done Canceling"] = "Abbrechen abgeschlossen"
L["Done Posting"] = "Erfolgreich Auktion erstellt"
L["Done Scanning"] = "Scannen erledigt"
L["Done rebuilding item cache."] = "Done rebuilding item cache."
L["Down"] = "Down"
L["Duplicate the profile"] = "Profil duplizieren"
L["Duration"] = "Dauer"
L["Duskwood"] = "Duskwood"
L["EXPENSES"] = "AUSGABEN"
L["Edit"] = "Bearbeiten"
L["Edit Post"] = "Edit Post"
L["Embed TSM tooltip"] = "TSM Tooltipp einbetten"
L["Empty bags"] = "Leere Taschen"
L["Empty price string."] = "Leerer Preistext."
L["Enable TSM tooltips"] = "TSM Tooltipps aktivieren"
L["Enable automatic stack combination"] = "Automatisches Zusammenführen von Stapeln aktivieren"
L["Enable buying"] = "Enable buying"
L["Enable inbox chat messages"] = "Posteingang-Chatnachrichten aktivieren"
L["Enable region-wide trading (requires reload)"] = "Enable region-wide trading (requires reload)"
L["Enable restock"] = "Enable restock"
L["Enable selling"] = "Enable selling"
L["Enable sending chat messages"] = "Senden-Chatnachrichten aktivieren"
L["Enchant"] = "Verzaubern"
L["Ensure both characters are online and try again."] = "Stelle sicher, dass beide Charaktere Online sind und versuche es erneut."
L["Enter Filter"] = "Filter eintragen"
L["Enter Keyword"] = "Suchbegriff eingeben"
L["Enter a value from %d - %d"] = "Einen Wert zwischen %d - %d eingeben"
L["Enter a value from %d - %d%%"] = "Einen Wert zwischen %d - %d%% eingeben"
L["Enter name of logged-in character on other account"] = "Enter name of logged-in character on other account"
L["Enter player name"] = "Spielername eintragen"
L["Enter profile name"] = "Profilname eingeben"
L["Enter recipient name"] = "Enter recipient name"
L["Establishing connection to %s. Make sure that you've entered this character's name on the other account."] = "Verbindung mit %s wird hergestellt. Achte darauf, dass dieser Charaktername im anderen Account angegeben ist."
L["Establishing connection..."] = "Verbindung herstellen..."
L["Estimated Profit"] = "Estimated Profit"
L["Estimated Time"] = "Estimated Time"
L["Estimated deliver time"] = "Voraussichtliche Lieferzeit"
L["Exact Match"] = "Genauer Treffer"
L["Example"] = "Beispiel"
L["Example Item"] = "Beispiel Gegenstand"
L["Example Tooltip"] = "Tooltipp Beispiel"
L["Exclude custom sources?"] = "Exclude custom sources?"
L["Exclude operations?"] = "Exclude operations?"
L["Exit"] = "Beenden"
L["Expand / Collapse All Groups"] = "Expand / Collapse All Groups"
L["Expenses"] = "Ausgaben"
L["Expirations"] = "Abgelaufene Auktionen"
L["Expired"] = "Abgelaufen"
L["Expired Auctions"] = "Abgelaufene Auktionen"
L["Expired Since Last Sale"] = "Abgelaufen seit letztem Verkauf"
L["Expired information"] = "Expired information"
L["Expires"] = "Läuft ab"
L["Expires Since Last Sale"] = "Abgelaufene Auktionen seit letztem Verkauf"
L["Expiring Mails"] = "Auslaufende Mails"
L["Exploration"] = "Erkundung"
L["Export"] = "Export"
L["Export Custom Theme"] = "Export Custom Theme"
L["Export String"] = "String Exportieren"
L["Export theme"] = "Export theme"
L["Export this group"] = "Diese Gruppe exportieren"
L["Failed Auctions"] = "Gescheiterte Auktionen"
L["Failed to bid on auction of %s (x%s) for %s."] = "Failed to bid on auction of %s (x%s) for %s."
L["Failed to bid on auction of %s."] = "Fehler beim Bieten auf Auktion von %s."
L["Failed to buy auction of %s (x%s) for %s."] = "Failed to buy auction of %s (x%s) for %s."
L["Failed to buy auction of %s."] = "Fehler beim Kaufen der Auktion von %s."
L["Failed to buy auction."] = "Failed to buy auction."
L["Failed to cancel auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Failed to cancel auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."
L["Failed to find auction for %s, so removing it from the results."] = "Eine Auktion für %s konnte nicht gefunden werden und wurde aus den Ergebnissen entfernt."
L["Failed to move group, as a group with the same name already exists in the target location."] = "Failed to move group, as a group with the same name already exists in the target location."
L["Failed to post %sx%d as the item no longer exists in your bags."] = "Failed to post %sx%d as the item no longer exists in your bags."
L["Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."
L["Failed to send profile."] = "Profil senden fehlgeschlagen"
L["Failed to send profile. Ensure both characters are online and try again."] = "Failed to send profile. Ensure both characters are online and try again."
L["Failed to start sniper. No groups have a Sniper operation applied."] = "Failed to start sniper. No groups have a Sniper operation applied."
L["Favorite Scans"] = "Favorisierte Scans"
L["Favorite Searches"] = "Favorisierte Suchanfragen"
L["Favorited Patterns"] = "Favorisierte Muster"
L["Filter by Keyword"] = "Nach Suchwort filtern"
L["Filter by Price Source"] = "Filter by Price Source"
L["Filter by Profession"] = "Filtern nach Beruf"
L["Filter by duration"] = "Filtern nach Dauer"
L["Filter by groups"] = "Filtern nach Gruppen"
L["Filter by keyword"] = "Filtern nach Suchwort"
L["Filter group item lists based on the following price source"] = "Gruppierte Itemlisten anhand folgender Preisquelle filtern:"
L["Finding Selected Auction"] = "Suche ausgewählte Auktion"
L["First Auctioning Operation Max Price"] = "First Auctioning Operation Max Price"
L["First Auctioning Operation Min Price"] = "First Auctioning Operation Min Price"
L["First Auctioning Operation Normal Price"] = "First Auctioning Operation Normal Price"
L["Fishing Reel In"] = "Angelrolle"
L["For more info, visit %s. For help, join us in Discord: %s."] = "For more info, visit %s. For help, join us in Discord: %s."
L["Forget Character"] = "Charakter vergessen"
L["Found auction sound"] = "Sound, wenn eine Auktion gefunden wurde"
L["Frame"] = "Frame"
L["Friends"] = "Freunde"
L["From"] = "Von"
L["Full convert tooltip"] = "Full convert tooltip"
L["Full destroy tooltip"] = "Full destroy tooltip"
L["Full inventory"] = "Gesamtes Inventar"
L["GVault"] = "GTresor"
L["Garrison"] = "Garnison"
L["Gathering"] = "Sammeln"
L["Gathering Search"] = "Sammelsuche"
L["Gathering Setup"] = "Gathering Setup"
L["General Options"] = "Allgemeine Optionen"
L["General Settings"] = "Allgemeine Einstellungen"
L["Get from Bank"] = "Aus Bank nehmen"
L["Get from Guild Bank"] = "Aus Gildenbank nehmen"
L["Gets items from the bank or guild bank matching the item or partial text entered."] = "Gets items from the bank or guild bank matching the item or partial text entered."
L["Gold"] = "Gold"
L["Great Deals Search"] = "Great Deals Search"
L["Group Management"] = "Gruppenverwaltung"
L["Group Search"] = "Gruppensuche"
L["Group already exists."] = "Gruppe besteht bereits."
L["Group name"] = "Gruppenname"
L["Grouped Items"] = "Gruppierte Items"
L["Grouping Pets by Level"] = "Grouping Pets by Level"
L["Groups"] = "Gruppen"
L["Groups & Operations"] = "Gruppen & Operationen"
L["Groups Using"] = "Gruppen benutzt"
L["Guild"] = "Gilde"
L["Guild Bank"] = "Gildenbank"
L["HIGH"] = "HIGH"
L["Have"] = "Haben"
L["Have Mats"] = "Habe Materialien"
L["Have Skill Ups"] = "Gibt Skillpunkt"
L["Here you can add/remove what groups this operation is attached to."] = "Here you can add/remove what groups this operation is attached to."
L["Hide Columns"] = "Spalten verstecken"
L["Hide auctions with bids"] = "Auktionen mit Geboten nicht anzeigen"
L["Hide minimap icon"] = "Minikartensymbol ausblenden"
L["Hiding the TSM Banking UI. Type '/tsm bankui' to reopen it."] = "TSM Bank Interface verborgen. Verwende \"/tsm bankui\" um es erneut zu öffnen."
L["Hiding the TSM Task List UI. Type '/tsm tasklist' to reopen it."] = "Die TSM Aufgabenliste wird ausgeblendet. Tippe '/tsm tasklist', um sie erneut zu öffnen."
L["High Bidder"] = "Höchstbietender"
L["Historical Price"] = "Historischerpreis"
L["Historical price"] = "Historischer Preis"
L["Hold ALT to repair from the guild bank."] = "Halte ALT um von der Gildenbank zu reparieren."
L["Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."] = "Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."
L["Hold SHIFT to continue after the inbox refreshes"] = "Hold SHIFT to continue after the inbox refreshes"
L["Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."] = "Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."
L["Hold SHIFT to not continue after the inbox refreshes"] = "Hold SHIFT to not continue after the inbox refreshes"
L["Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."] = "Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."
L["Hold SHIFT while dragging to scale the window instead."] = "Hold SHIFT while dragging to scale the window instead."
L["Hold shift to move the items to the parent group instead of removing them."] = "Hold shift to move the items to the parent group instead of removing them."
L["Hr"] = "Std"
L["Hrs"] = "Std"
L["If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."] = "If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."
L["If you have multiple profiles set up with operations, enabling this will cause all but the current profile's operations to be irreversibly lost."] = "If you have multiple profiles set up with operations, enabling this will cause all but the current profile's operations to be irreversibly lost."
L["Ignore Auctions Below Min"] = "Auktionen unter Minimum ignorieren"
L["Ignore Characters"] = "Charaktere ignorieren"
L["Ignore Guilds"] = "Gilden ignorieren"
L["Ignore auctions by duration"] = "Ignore auctions by duration"
L["Ignore operation on characters"] = "Ignore operation on characters"
L["Ignore operation on faction-realms"] = "Ignore operation on faction-realms"
L["Ignored Cooldowns"] = "Ignorierte Abklingzeiten"
L["Ignored Items"] = "Ignorierte Items"
L["Import"] = "Importieren"
L["Import Groups & Operations"] = "Gruppen & Operationen importieren"
L["Import String"] = "String Importieren"
L["Import Summary"] = "Zusammenfassung importieren"
L["Import Theme"] = "Import Theme"
L["Import group"] = "Gruppe importieren"
L["Imported Group"] = "Importierte Gruppe"
L["Imported group (%s) with %d items, %d operations, and %d custom sources."] = "Imported group (%s) with %d items, %d operations, and %d custom sources."
L["In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."] = "In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."
L["Inbox Settings"] = "Posteingang-Einstellungen"
L["Include operations?"] = "Operationen einbeziehen?"
L["Include soulbound items"] = "Seelengebundene Items einbeziehen"
L["Information"] = "Informationen"
L["Invalid Quantity"] = "Ungültige Menge"
L["Invalid custom price source for %s. %s"] = "Ungültige eigene Preisquelle für %s. %s"
L["Invalid custom price."] = "Ungültiger eigener Preis."
L["Invalid group name."] = "Ungültiger Gruppenname."
L["Invalid numeric value."] = "ungültiger Zahlenwert"
L["Invalid operation name."] = "Ungültiger Operationsname."
L["Invalid player name."] = "Ungültiger Spielername."
L["Invalid price."] = "Ungültiger Preis."
L["Invalid search filter (%s)."] = "Ungültige Suchfilter (%s)."
L["Invalid search term."] = "ungültiger Suchbegriff"
L["Invalid search term. Cannot filter by price here."] = "Invalid search term. Cannot filter by price here."
L["Invalid seller data returned by server."] = "Ungültige Daten zum Verkäufer vom Server gemeldet."
L["Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."] = "Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."
L["Inventory"] = "Inventar"
L["Inventory / Gold Graph"] = "Inventar / Goldgraph"
L["Inventory Options"] = "Inventaroptionen"
L["It appears that you've manually copied your saved variables between accounts which will cause TSM's automatic sync'ing to not work. You'll need to undo this, and/or delete the TradeSkillMaster saved variables files on both accounts (with WoW closed) in order to fix this."] = "It appears that you've manually copied your saved variables between accounts which will cause TSM's automatic sync'ing to not work. You'll need to undo this, and/or delete the TradeSkillMaster saved variables files on both accounts (with WoW closed) in order to fix this."
L["Item"] = "Item"
L["Item Class"] = "Gegenstandsklasse"
L["Item Level"] = "Item Level"
L["Item Level Range"] = "Gegenstandsstufenbreich"
L["Item Name"] = "Name des Items"
L["Item Quality"] = "Item Qualität"
L["Item Selection"] = "Item Selection"
L["Item Slot"] = "Item Slot"
L["Item Subclass"] = "Item Subclass"
L["Item Value"] = "Item Wert"
L["Item/Group is invalid (see chat)."] = "Gegenstand/Gruppe ist ungültig (siehe Chat)."
L["Items"] = "Items"
L["Items Using"] = "Items Using"
L["Keep in bags quantity"] = "Keep in bags quantity"
L["Keep in bank quantity"] = "Keep in bank quantity"
L["Keep quantity"] = "Behalte Menge"
L["Keep this amount"] = "Behalte diese Menge"
L["Keeping %d."] = "Behalte %d."
L["Keeping undercut auctions posted."] = "Behalte unterbotene Auktionen."
L["LEAST GROUPS"] = "LEAST GROUPS"
L["LEAST ITEMS"] = "LEAST ITEMS"
L["LOW"] = "LOW"
L["Last 14 Days"] = "Letzten 14 Tage"
L["Last 3 Days"] = "Letzten 3 Tage"
L["Last 30 Days"] = "Letzten 30 Tage"
L["Last 60 Days"] = "Letzten 60 Tage"
L["Last 7 Days"] = "Letzten 7 Tage"
L["Last Purchased"] = "Letzter Einkauf"
L["Last Sold"] = "Letzter Verkauf"
L["Ledger"] = "Ledger"
L["Level Up"] = "Stufe aufgestiegen"
L["Limit"] = "Limit"
L["Link to Another Operation"] = "Verbinde mit einer anderen Operation"
L["Lock Column Width"] = "Spaltenbreite sperren"
L["Lock task list's background"] = "Lock task list's background"
L["Looks like TradeSkillMaster has encountered an error. Please help the author fix this error by following the instructions shown."] = "Es scheint so, als wäre TradeSkillMaster auf einen Fehler gestoßen. Du kannst dem Autor dabei helfen, diesen Fehler zu beheben, indem du die folgenden Anweisungen befolgst."
L["Loop detected in the following custom price:"] = "Schleife im folgenden eigenen Preis entdeckt:"
L["Lowest auction by whitelisted player."] = "Günstigste Auktion von Spieler aus weißer Liste."
L["MAX"] = "MAX"
L["MOST GROUPS"] = "MOST GROUPS"
L["MOST ITEMS"] = "MOST ITEMS"
L["MOVE"] = "BEWEGEN"
L["MOVING"] = "BEWEGEN"
L["Macro Setup"] = "Makro-Setup"
L["Macro created and scroll wheel bound!"] = "Makro erstellt und mit Mausrad verbunden!"
L["Macros"] = "Makros"
L["Mail"] = "Post"
L["Mail Disenchantables"] = "Entzauberbare Items versenden"
L["Mail Selected Groups"] = "Mail Selected Groups"
L["Mail Selected Groups (Auto Resend)"] = "Mail Selected Groups (Auto Resend)"
L["Mail Selected Groups (Dry Run + Auto Resend)"] = "Mail Selected Groups (Dry Run + Auto Resend)"
L["Mail Selected Groups (Dry Run)"] = "Mail Selected Groups (Dry Run)"
L["Mail disenchantables max quality"] = "Mail disenchantables max quality"
L["Mail to %s"] = "Post an %s"
L["Mailing"] = "Mailing"
L["Mailing all to %s."] = "Sende alles an %s."
L["Mailing operation"] = "Mailing operation"
L["Mailing operations control mailing to other characters."] = "Mailing operations control mailing to other characters."
L["Mailing up to %d to %s."] = "Sende bis zu %d an %s."
L["Make Cash On Delivery?"] = "Mit Nachnahmegebühr?"
L["Make Operations Global?"] = "Make Operations Global?"
L["Management Options"] = "Verwaltungsoptionen"
L["Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."] = "Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."
L["Many commonly-used actions in TSM can be added to a macro and bound to your scroll wheel. Use the options below to setup this macro and scroll wheel binding."] = "Viele häufig verwendete Aktionen in TSM können in ein Makro umgewandelt und an dein Mausrad gebunden werden. Benutze dazu die folgenden Optionen."
L["Map Ping"] = "Klick auf Minimap"
L["Market Value"] = "Marktwert"
L["Market Value Price Source"] = "Marktwert-Preisquelle"
L["Market value"] = "Marktwert"
L["Market value and trend"] = "Market value and trend"
L["Market value price source"] = "Marktpreis Preisquelle"
L["Mat Price"] = "Mat Preis"
L["Mat cost"] = "Mats Kosten"
L["Match stack size"] = "Match stack size"
L["Match whitelisted players"] = "Spieler aus der weißen Liste überprüfen"
L["Material Cost"] = "Materialkosten"
L["Materials"] = "Materialien"
L["Materials to Gather"] = "Zu sammelnde Materialien"
L["Max"] = "Max."
L["Max Buy Price"] = "Max. Kaufpreis"
L["Max Price"] = "Max. Preis"
L["Max Sell Price"] = "Max. Verkaufspreis"
L["Max Shopping Price"] = "Max. Einkaufspreis"
L["Max destroy value (Enter '0c' to disable)"] = "Max destroy value (Enter '0c' to disable)"
L["Max expires to bank"] = "Max expires to bank"
L["Max market value (Enter '0c' to disable)"] = "Max market value (Enter '0c' to disable)"
L["Max quantity"] = "Max. Menge"
L["Max shopping price"] = "Max. Einkaufspreis"
L["Max sniper price"] = "Max. Sniper Preis"
L["Maximum Quantity to Buy"] = "Maximum Quantity to Buy"
L["Maximum amount already posted."] = "Maximale Anzahl von Auktionen bereits erstellt."
L["Maximum auction price"] = "Maximum auction price"
L["Maximum disenchant level"] = "Maximum disenchant level"
L["Maximum disenchant quality"] = "Maximum disenchant quality"
L["Maximum disenchant search percent"] = "Maximum disenchant search percent"
L["Maximum price"] = "Maximaler Preis"
L["Maximum restock quantity"] = "Maximum restock quantity"
L["Midnight"] = "Mitternacht"
L["Mill"] = "Mill"
L["Mill Value"] = "Mahlenwert"
L["Min"] = "Min"
L["Min 0 - Max 20"] = "Min 0 - Max 20"
L["Min 0.5 - Max 10"] = "Min 0.5 - Max 10"
L["Min Buy Price"] = "Min Kaufpreis"
L["Min Buyout"] = "Min Sofortkaufpreis"
L["Min Sell Price"] = "Min Verkaufpreis"
L["Min buyout"] = "Min buyout"
L["Min number of expires"] = "Min number of expires"
L["Min profit amount"] = "Min profit amount"
L["Min/Normal/Max Prices"] = "Min/Normal/Max Preise"
L["Min/Normal/Max price"] = "Min/Normal/Max price"
L["Minimum Rarity"] = "Minimum Rarity"
L["Minimum disenchant level"] = "Minimum disenchant level"
L["Minimum price"] = "Minimum price"
L["Minimum restock quantity"] = "Minimum restock quantity"
L["Missing Materials"] = "Fehlende Materialien"
L["Modifiers"] = "Modifikatoren"
L["Money Frame Open"] = "Geldfenster öffnen"
L["Money Transfer"] = "Geldtransfer"
L["Move %d already grouped items?"] = "Move %d already grouped items?"
L["Move %d |4Item:Items"] = "Move %d |4Item:Items"
L["Move Item"] = "Gegenstand verschieben"
L["Move Quantity Options"] = "Move Quantity Options"
L["Move all to Bags"] = "Alles in Tasche verschieben"
L["Move to Parent Group"] = "Zur übergeordneten Gruppe wechseln"
L["Move to bags"] = "Zur Tasche verschieben"
L["Move to bank"] = "Zur Bank verschieben"
L["Moving"] = "Bewegen"
L["Multiple Items"] = "Mehrere Gegenstände"
L["Must be between %d and %s."] = "Muss zwischen %d und %s sein."
L["My Auctions"] = "Meine Auktionen"
L["My Auctions %s button"] = "My Auctions %s button"
L["NEED MATS"] = "KEINE MATS"
L["NO ITEMS"] = "KEINE ITEMS"
L["NOT OPEN"] = "NICHT OFFEN"
L["NOTE: The import contained %d invalid items which were ignored."] = "NOTE: The import contained %d invalid items which were ignored."
L["NOTE: The import contained %d operations with at least one invalid setting which was reset."] = "NOTE: The import contained %d operations with at least one invalid setting which was reset."
L["NPC"] = "NPC"
L["Name"] = "Name"
L["New Group"] = "Neue Gruppe"
L["New Operation"] = "Neue Operation"
L["News & Information"] = "Nachrichten & Informationen"
L["No Attachments"] = "Keine Anhänge"
L["No AuctionDB Realm Data"] = "No AuctionDB Realm Data"
L["No AuctionDB Region Data"] = "No AuctionDB Region Data"
L["No Characters"] = "Keine Charaktere"
L["No Faction-Realms"] = "No Faction-Realms"
L["No Guilds"] = "Keine Gilden"
L["No Materials to Gather"] = "Keine zu sammelnden Materialien"
L["No Operation Selected"] = "Keine Operation ausgewählt"
L["No Players"] = "Keine Spieler"
L["No Profession Opened"] = "Keinen Beruf geöffnet"
L["No Professions"] = "Keine Berufe"
L["No Rarities"] = "Keine Raritäten"
L["No Sound"] = "Kein Sound"
L["No Sources"] = "Keine Quellen"
L["No Types"] = "No Types"
L["No group selected"] = "Keine Gruppe ausgewählt"
L["No item specified. Usage: /tsm restock_help [ITEM_LINK]"] = "Kein Gegenstand spezifiziert. Nutze: /tsm restock_help [ITEM_LINK]"
L["No posting."] = "Keine Auktion erstellen."
L["No profile specified. Possible profiles: '%s'"] = "Kein Profil angegeben. Mögliche Profile: '%s'"
L["No recent AuctionDB scan data found."] = "Keine aktuellen AuktionsDB Scan-Daten gefunden."
L["No recipe selected"] = "No recipe selected"
L["No value was returned by the custom price for the specified item."] = "No value was returned by the custom price for the specified item."
L["No, cancel"] = "No, cancel"
L["None"] = "Nichts"
L["None (Always Show)"] = "Keine (immer zeigen)"
L["None Selected"] = "Nichts ausgewählt"
L["Nongroup to bank"] = "Nongroup to bank"
L["Normal price"] = "Normaler Preis"
L["Not Connected"] = "Nicht verbunden"
L["Not Enough Money"] = "Nicht genügend Gold"
L["Not Scanned"] = "Nicht gescannt"
L["Not canceling auction at reset price."] = "Wird nicht abgebrochen, Auktion bei Reset-Preis."
L["Not canceling auction below min price."] = "Wird nicht abgebrochen, Auktion unter Mindestpreis."
L["Not canceling."] = "Wird nicht abgebrochen."
L["Not enough items in bags."] = "Nicht genügend Gegenstände in den Taschen."
L["Not enough money to cancel."] = "Nicht genügend Gold zum abbrechen."
L["Nothing to move."] = "Nichts zu verschieben."
L["Nothing to send."] = "Nichts zu verschicken."
L["Number Owned"] = "Anzahl in Besitz"
L["Number of days"] = "Number of days"
L["OPEN"] = "ÖFFNEN"
L["Offline"] = "Offline"
L["On Cooldown for %s"] = "On Cooldown for %s"
L["Only show craftable"] = "Nur herstellbare Items"
L["Only show items with disenchant values above this price"] = "Only show items with disenchant values above this price"
L["Only show sold auctions"] = "Nur verkaufte Auktionen anzeigen"
L["Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."] = "Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."
L["Open All Mail"] = "Gesamte Post öffnen"
L["Open All Mail Without Money"] = "Gesamte Post ohne Geld öffnen"
L["Open Mail"] = "Mail öffnen"
L["Open Mail Without Money"] = "Open Mail Without Money"
L["Open Task List"] = "Aufgabenliste öffnen"
L["Open mail complete sound"] = "Open mail complete sound"
L["Opens the Destroying frame if there's stuff in your bags to be destroyed."] = "Opens the Destroying frame if there's stuff in your bags to be destroyed."
L["Operation"] = "Operation"
L["Operations"] = "Operationen"
L["Options specific to Sniper are below."] = "Options specific to Sniper are below."
L["Order Confirmation"] = "Order Confirmation"
L["Orgrimmar"] = "Orgrimmar"
L["Oribos Exchange Realm Price"] = "Oribos Exchange Realm Price"
L["Oribos Exchange Region Price"] = "Oribos Exchange Region Price"
L["Other"] = "Weitere"
L["Other Character"] = "Anderer Charakter"
L["Override Parent Operations"] = "Override Parent Operations"
L["Override default craft value"] = "Override default craft value"
L["PROFIT"] = "PROFIT"
L["Parent Items"] = "Übergeordnete Gegenstände"
L["Pausing Scan..."] = "Scan anhalten..."
L["Per Item"] = "Pro Item"
L["Per Stack"] = "Pro Stapel"
L["Performing a dry-run of your Mailing operations for the selected groups."] = "Performing a dry-run of your Mailing operations for the selected groups."
L["Player Gold"] = "Spielergold"
L["Player Invite Accept"] = "Spielereinladung akzeptieren"
L["Post"] = "Post"
L["Post / Cancel"] = "Einstellen / Abbrechen"
L["Post Auction"] = "Auktion einstellen"
L["Post Items from Bags"] = "Post Items from Bags"
L["Post Quantity"] = "Post Quantity"
L["Post Scan"] = "Einstellungsscan"
L["Post Selected"] = "Post Selected"
L["Post at Maximum Price"] = "Zum Höchstpreis erstellen"
L["Post at Minimum Price"] = "Zum Mindestpreis erstellen"
L["Post at Normal Price"] = "Zum Normalpreis erstellen"
L["Post cap"] = "Post cap"
L["Post cap to bags"] = "Post cap to bags"
L["Post from Shopping Scan"] = "Post from Shopping Scan"
L["Postage"] = "Versandkosten"
L["Posted at whitelisted player's price."] = "Zum Preis des Spielers aus weißer Liste gelistet."
L["Posted:"] = "Posted:"
L["Posting"] = "Auktionserstellung"
L["Posting %d / %d"] = "Erstelle Auktion %d / %d"
L["Posting %d items for %s hours."] = "Posting %d items for %s hours."
L["Posting %d stack(s) of %d for %s hours."] = "Posting %d stack(s) of %d for %s hours."
L["Posting Options"] = "Posting Options"
L["Posting Price"] = "Posting Price"
L["Posting at normal price."] = "Erstelle zum Normalpreis."
L["Posting at whitelisted player's price."] = "Erstelle zum Preis des Spielers aus der weißen Liste."
L["Posting at your current price."] = "Erstelle zu deinem aktuellen Preis."
L["Posting disabled."] = "Auktion erstellen deaktiviert."
L["Posts"] = "Angebote"
L["Potential"] = "Potential"
L["Prepare Bid"] = "Gebot vorbeiten"
L["Prepare Buy"] = "Kauf vorbereiten"
L["Preparing..."] = "Vorbereiten..."
L["Prevent closing the Auction House with the esc key"] = "Prevent closing the Auction House with the esc key"
L["Primary"] = "Primary"
L["Primary Alt"] = "Primary Alt"
L["Prints out the available price sources for use in custom prices"] = "Prints out the available price sources for use in custom prices"
L["Prints out the version numbers of all installed modules"] = "Prints out the version numbers of all installed modules"
L["Prints the slash command help listing"] = "Prints the slash command help listing"
L["Profession"] = "Berufe"
L["Profession Info"] = "Berufs-Info"
L["Professions Used In"] = "Relevant für die Berufe"
L["Profile changed to '%s'."] = "Profil wurde auf '%s' geändert."
L["Profiles"] = "Profile"
L["Profit"] = "Profit"
L["Profit (Total)"] = "Profit (Gesamt)"
L["Prospect"] = "Prospect"
L["Prospect Value"] = "Sondierungswert"
L["Purchase"] = "Purchase"
L["Purchase / Sale Info"] = "Purchase / Sale Info"
L["Purchase Data"] = "Purchase Data"
L["Purchase Item"] = "Purchase Item"
L["Purchase information"] = "Purchase information"
L["Purchased (Min/Avg/Max Price)"] = "Gekauft (Min/Ø/Max Preis)"
L["Purchased (Total Price)"] = "Gekauft (Gesamtpreis)"
L["Purchases"] = "Einkäufe"
L["Purchasing Auction"] = "Kaufe Auktion"
L["Puts items matching the item or partial text entered into the bank or guild bank."] = "Puts items matching the item or partial text entered into the bank or guild bank."
L["Qty"] = "Anz"
L["Quantity"] = "Menge"
L["Quantity Purchased:"] = "Menge gekauft:"
L["Quantity Sold:"] = "Anzahl verkauft:"
L["Quantity to move"] = "Menge zum verschieben"
L["Quest Added"] = "Quest hinzugefügt"
L["Quest Completed"] = "Quest abgeschlossen"
L["Quest Objectives Complete"] = "Questziel erreicht"
L["Queue"] = "Warteschlange"
L["Queue (%d)"] = "Queue (%d)"
L["Queue Summary"] = "Queue Summary"
L["Quickly mail all excess disenchantable items to a character"] = "Überschuss an entzauberbaren Items an Charakter senden"
L["Quickly mail all excess gold (limited to a certain amount) to a character"] = "Goldüberschuss (begrenzt auf eine bestimmte Menge) an Charakter senden"
L["Raid Warning"] = "Schlachtzugwarnung"
L["Rank %d"] = "Rank %d"
L["Read More"] = "Mehr lesen"
L["Ready Check"] = "Bereitschaftscheck"
L["Ready to Cancel"] = "Bereit zum Abbrechen"
L["Reagent Quality"] = "Reagent Quality"
L["Recent"] = "Recent"
L["Recent Scans"] = "Scanverlauf"
L["Recent Searches"] = "Suchverlauf"
L["Recent Value"] = "Recent Value"
L["Recent value"] = "Recent value"
L["Recipe Name"] = "Recipe Name"
L["Recipient"] = "Recipient"
L["Region Avg Daily Sold"] = "Regionaler Ø täglicher Verkäufe"
L["Region Historical Price"] = "Regionaler historischer Preis"
L["Region Market Value Avg"] = "Regionaler Marktwert Ø"
L["Region Sale Avg"] = "Regionaler Verkaufs Ø"
L["Region Sale Rate"] = "Regionale Verkaufsrate"
L["Region avg daily sold"] = "Region avg daily sold"
L["Region historical price"] = "Region historical price"
L["Region market value"] = "Region market value"
L["Region market value and trend"] = "Region market value and trend"
L["Region sale avg"] = "Region sale avg"
L["Region sale rate"] = "Region sale rate"
L["Reload"] = "Neuladen"
L["Reload UI (%02d)"] = "Reload UI (%02d)"
L["Reload UI (%d)"] = "Reload UI (%d)"
L["Remove"] = "Entfernen"
L["Remove %d |4Item:Items"] = "Remove %d |4Item:Items"
L["Remove Data Older Than (Days)"] = "Remove Data Older Than (Days)"
L["Remove this account sync and all synced data from this account"] = "Remove this account sync and all synced data from this account"
L["Removed a total of %s old records."] = "Es wurden insgesamt %s alte Daten entfernt."
L["Removed custom price source (%s) which has an invalid name."] = "Removed custom price source (%s) which has an invalid name."
L["Rename"] = "Umbenennen"
L["Rename Profile"] = "Profil umbenennen"
L["Rename Search"] = "Suche umbenennen"
L["Rename the profile"] = "Dieses Profil umbenennen"
L["Rename this group"] = "Diese Gruppe umbenennen"
L["Repair"] = "Reparieren"
L["Repair Bill"] = "Reparaturrechnung"
L["Repair from Guild Bank"] = "Von der Gildenbank reparieren"
L["Replace %d existing operations and %d existing custom sources?"] = "Replace %d existing operations and %d existing custom sources?"
L["Replace %d existing operations?"] = "Replace %d existing operations?"
L["Reply"] = "Antworten"
L["Report Spam"] = "Spam Melden"
L["Reports"] = "Reports"
L["Repost threshold"] = "Repost threshold"
L["Required Level"] = "Erforderliche Stufe"
L["Required Level Range"] = "Required Level Range"
L["Resale"] = "Wiederverkauf"
L["Rescan"] = "Rescan"
L["Reset"] = "Zurücksetzen"
L["Reset All Filters"] = "Alle Filter zurücksetzen"
L["Reset Filters"] = "Filter leeren"
L["Reset Operation?"] = "Operationen zurücksetzen?"
L["Reset Profile?"] = "Profil zurücksetzen?"
L["Reset Table"] = "Tabelle zurücksetzen"
L["Reset Zoom"] = "Zoom zurücksetzen"
L["Reset the current profile to default settings"] = "Reset the current profile to default settings"
L["Reset to Default"] = "Zurücksetzen auf Werkseinstellungen"
L["Resetting the operation will return all inputs back to default and cannot be unddone. Click confirm to reset."] = "Resetting the operation will return all inputs back to default and cannot be unddone. Click confirm to reset."
L["Restart"] = "Neustart"
L["Restart delay (minutes)"] = "Neustartverzögerung (in Minuten)"
L["Restock Groups"] = "Restock Groups"
L["Restock Options"] = "Restock Options"
L["Restock TSM Groups"] = "Restock TSM Groups"
L["Restock bags"] = "Taschen wiederauffüllen"
L["Restock help for %s: %s"] = "Restock help for %s: %s"
L["Restock quantity"] = "Restock quantity"
L["Restock target to max quantity"] = "Restock target to max quantity"
L["Restocking to %d."] = "Fülle auf %d wieder auf."
L["Restocking with a min profit."] = "Restocking with a min profit."
L["Restocking with no min profit."] = "Restocking with no min profit."
L["Restore bags"] = "Taschen wiederherstellen"
L["Resuming Scan..."] = "Scan fortsetzen..."
L["Retail Region-Wide Tracking"] = "Retail Region-Wide Tracking"
L["Retrying %d auction(s) which failed."] = "Wiederhole %d gescheiterte Auktion(en)."
L["Revenue"] = "Einnahmen"
L["Right-Click to reset the window size, scale, and position to their defaults."] = "Right-Click to reset the window size, scale, and position to their defaults."
L["Run Advanced Item Search"] = "Run Advanced Item Search"
L["Run Bid Sniper"] = "Gebot-Sniper starten"
L["Run Buyout Sniper"] = "Sofortkauf-Sniper starten"
L["Run Cancel Scan"] = "Abbruchscan"
L["Run Post Scan"] = "Einstellscan"
L["Run Shopping Scan"] = "Shoppingscan"
L["Running Sniper Scan"] = "Sniper-Scan läuft"
L["SALES"] = "VERKÄUFE"
L["SCAN ALL"] = "ALLE SCANNEN"
L["SCANNING"] = "SCANNEN"
L["SENDING"] = "SENDEN"
L["SHIFT"] = "SHIFT"
L["SOURCE %d"] = "QUELLE %d"
L["Sale"] = "Verkauf"
L["Sale Data"] = "Sale Data"
L["Sale Price"] = "Verkaufspreis"
L["Sale Rate"] = "Verkaufsrate"
L["Sale information"] = "Verkaufsinformationen"
L["Sale rate"] = "Sale rate"
L["Sales"] = "Umsatz"
L["Salvage"] = "Salvage"
L["Save & Close"] = "Save & Close"
L["Saved"] = "Saved"
L["Scan"] = "Scan"
L["Scan Paused"] = "Scan pausiert"
L["Scan complete sound"] = "Scan complete sound"
L["Scan was slowed down by %s seconds by other AH addons (%s seconds by %s)."] = "Scan was slowed down by %s seconds by other AH addons (%s seconds by %s)."
L["Scanning"] = "Scannen"
L["Scanning (%d Items)"] = "Scanne (%d Gegenstände)"
L["Scroll Wheel Options"] = "Mausrad Optionen"
L["Scroll wheel direction"] = "Richtung Mausrad"
L["Search"] = "Suche"
L["Search %s operations"] = "Search %s operations"
L["Search Bags"] = "Taschen durchsuchen"
L["Search Groups"] = "Gruppen durchsuchen"
L["Search Operations"] = "Operationen durchsuchen"
L["Search Patterns"] = "Rezepte durchsuchen"
L["Search Results"] = "Search Results"
L["Search Vendor"] = "Händlersuche"
L["Search items"] = "Search items"
L["Search items in group"] = "Search items in group"
L["Search items in mailbox"] = "Search items in mailbox"
L["Search the auction house"] = "Search the auction house"
L["Select / Deselect All Groups"] = "Select / Deselect All Groups"
L["Select / Deselect All Items"] = "Select / Deselect All Items"
L["Select / Deselect All Results"] = "Select / Deselect All Results"
L["Select Action"] = "Aktion auswählen"
L["Select All"] = "Alles markieren"
L["Select Auction to Cancel"] = "Wähle eine Auktion zum abbrechen"
L["Select Crafted Item Quality"] = "Select Crafted Item Quality"
L["Select Group"] = "Gruppe markieren"
L["Select Items to Attach"] = "Select Items to Attach"
L["Select a Source"] = "Wähle eine Quelle"
L["Select an Auction to Buy"] = "Select an Auction to Buy"
L["Select crafter"] = "Handwerker auswählen"
L["Select included subgroups"] = "Select included subgroups"
L["Select professions"] = "Berufe auswählen"
L["Selected Items (%d)"] = "Selected Items (%d)"
L["Sell"] = "Verkaufen"
L["Sell All"] = "Alles verkaufen"
L["Sell BoEs"] = "Verkaufe BoEs"
L["Sell Groups"] = "Gruppen verkaufen"
L["Sell Options"] = "Verkaufs Optionen"
L["Sell Trash"] = "Schrott verkaufen"
L["Sell soulbound items"] = "Verkaufe Seelengebundene Gegenstände"
L["Sell to Vendor"] = "An Händler verkaufen"
L["Seller"] = "Verkäufer"
L["Selling soulbound items."] = "Verkaufe seelengebundene Items."
L["Send"] = "Senden"
L["Send Disenchantables"] = "Send Disenchantables"
L["Send Excess Gold to Banker"] = "Goldüberschuss an Banker senden"
L["Send Gold"] = "Send Gold"
L["Send Mail"] = "Send Mail"
L["Send Money"] = "Gold senden"
L["Send grouped items individually"] = "Gruppierte Items einzeln versenden"
L["Send your active profile to this synced account"] = "Send your active profile to this synced account"
L["Sender"] = "Absender"
L["Sending %s to %s"] = "Sende %s an %s"
L["Sending %s to %s with a COD of %s"] = "Sende %s an %s mit einer Nachnahmegebühr von %s"
L["Sending Settings"] = "Senden-Einstellungen"
L["Sending your '%s' profile to %s. Please keep both characters online until this completes. This will take approximately: %s"] = "Sending your '%s' profile to %s. Please keep both characters online until this completes. This will take approximately: %s"
L["Sending..."] = "Versenden..."
L["Set bid as percentage of buyout"] = "Set bid as percentage of buyout"
L["Set how items are moved out of the bank."] = "Set how items are moved out of the bank."
L["Set how items are restocked from the bank."] = "Set how items are restocked from the bank."
L["Set keep in bags quantity"] = "Set keep in bags quantity"
L["Set keep in bank quantity"] = "Set keep in bank quantity"
L["Set max quantity"] = "Set max quantity"
L["Set min profit"] = "Set min profit"
L["Set move quantity"] = "Set move quantity"
L["Set stack size"] = "Set stack size"
L["Set stack size for restock"] = "Set stack size for restock"
L["Set what is bought from a vendor."] = "Set what is bought from a vendor."
L["Set what is sold to a vendor."] = "Set what is sold to a vendor."
L["Set what items are shown during a Shopping scan."] = "Set what items are shown during a Shopping scan."
L["Set what items are shown during a Sniper scan."] = "Set what items are shown during a Sniper scan."
L["Set your active profile or create a new one."] = "Set your active profile or create a new one."
L["Settings"] = "Einstellungen"
L["Setup various sounds that play when doing Auctioning scans."] = "Setup various sounds that play when doing Auctioning scans."
L["Share operations between all profiles"] = "Share operations between all profiles"
L["Shopping"] = "Shopping"
L["Shopping %s button"] = "Shopping %s button"
L["Shopping Operation Max Price"] = "Shopping Operation Max Price"
L["Shopping for auctions including those above the max price."] = "Kaufe Auktionen ein, einschließlich solcher über dem Höchstpreis."
L["Shopping for auctions with a max price set."] = "Kaufe Auktionen mit einem festgelegten Höchstpreis ein."
L["Shopping operation"] = "Shopping operation"
L["Shopping operations control buyout from the AH."] = "Shopping operations control buyout from the AH."
L["Shortfall to bags"] = "Shortfall to bags"
L["Show auctions above max price"] = "Show auctions above max price"
L["Show confirmation alert if buyout is above the alert price"] = "Zeige Bestätigungs-Alarm wenn der Sofortkauf über dem Alarm-Preis liegt."
L["Show destroying frame automatically"] = "Show destroying frame automatically"
L["Show on modifier"] = "Show on modifier"
L["Show only auctions with bids"] = "Show only auctions with bids"
L["Show results as:"] = "Show results as:"
L["Show total gold in header"] = "Show total gold in header"
L["Show ungrouped items as:"] = "Show ungrouped items as:"
L["Showing %s Mail"] = "Showing %s Mail"
L["Showing %s of %d Mail"] = "Showing %s of %d Mail"
L["Showing %s of %d Mails"] = "Showing %s of %d Mails"
L["Showing all %s Mails"] = "Showing all %s Mails"
L["Simple convert tooltip"] = "Simple convert tooltip"
L["Simple destroy tooltip"] = "Simple destroy tooltip"
L["Simple inventory"] = "Simple inventory"
L["Skip"] = "Überspringen"
L["Skipped:"] = "Übersprungen:"
L["Skipped: No assigned operation"] = "Übersprungen: Keine Operation zugewiesen"
L["Slash Commands:"] = "Slash-Befehle:"
L["Smart Avg Buy Price"] = "Smart Avg Buy Price"
L["Sniper"] = "Sniper"
L["Sniper %s button"] = "Sniper %s button"
L["Sniper Below Price"] = "Sniper Below Price"
L["Sniper Operation Below Price"] = "Sniper Operation Below Price"
L["Sniper Options"] = "Sniper-Optionen"
L["Sniper operation"] = "Sniper operation"
L["Sniper operations control sniping from the AH."] = "Sniper operations control sniping from the AH."
L["Sniping items below a max price"] = "Suche gezielt Items unter einem Höchstpreis"
L["Sold"] = "Verkauft"
L["Sold %d of %s to %s for %s"] = "Sold %d of %s to %s for %s"
L["Sold %s worth of items."] = "Items im Wert von %s verkauft."
L["Sold (Min/Avg/Max Price)"] = "Verkauft (Min/Ø/Max Preis)"
L["Sold (Total Price)"] = "Verkauft (Gesamtpreis)"
L["Sold [%s]x%d for %s to %s"] = "Verkauft [%s]x%d für %s an %s"
L["Sold for:"] = "Verkauft für:"
L["Some general Accounting options are below."] = "Some general Accounting options are below."
L["Some general Auctioning options are below."] = "Some general Auctioning options are below."
L["Some general Browse/Sniper options are below."] = "Some general Browse/Sniper options are below."
L["Some general TSM options are below."] = "Some general TSM options are below."
L["Some general appearance options are below."] = "Some general appearance options are below."
L["Some general options for the TSM tooltip information are below."] = "Unterhalb sind gewisse Einstellungen für den TSM Tooltipp."
L["Some options for the Disenchant Search are below."] = "Some options for the Disenchant Search are below."
L["Source"] = "Quelle"
L["Sources"] = "Quellen"
L["Sources to include for restock"] = "Sources to include for restock"
L["Specific Item"] = "Specific Item"
L["Stack"] = "Stapel"
L["Stack / Quantity"] = "Stapel / Anzahl"
L["Stack size"] = "Stapelgröße"
L["Stack size multiple"] = "Stack size multiple"
L["Stack(s)"] = "Stapel"
L["Start either a 'Buyout' or 'Bid' sniper using the buttons above."] = "Klicke auf einen der Buttons oben, um einen Sofortkauf- oder Gebot-Sniper zu starten."
L["Starting Scan..."] = "Starte Scan..."
L["Stormwind"] = "Sturmwind"
L["String"] = "String"
L["Subject"] = "Betreff"
L["Subject & Description added"] = "Thema & Beschreibung hinzugefügt"
L["Successfully sent your '%s' profile to %s!"] = "Successfully sent your '%s' profile to %s!"
L["Supported value range: %d - %d"] = "Unterstützter Wertebereich: %d - %d"
L["Swamp of Sorrows"] = "Sümpfe des Elends"
L["Switch to %s"] = "Zum %s wechseln"
L["Sync Setup Error: The specified player on the other account is not currently online."] = "Sync-Setup-Fehler: Der angegebene Spieler ist auf dem anderen Account gerade offline."
L["Sync Setup Error: This character is already part of a known account."] = "Sync-Setup-Fehler: Dieser Charakter gehört bereits zu einem bekannten Account."
L["Sync Setup Error: You entered the name of the current character and not the character on the other account."] = "Sync-Setup-Fehler: Du hast nicht den Charakter auf dem anderen Account, sondern den Namen des aktuellen Charakters eingegeben."
L["Sync Status"] = "Snyc Status"
L["TOP PURCHASE"] = "TOP PURCHASE"
L["TOP SALE"] = "TOP SALE"
L["TSM %s: What's new"] = "TSM %s: What's new"
L["TSM Accounting"] = "TSM Accounting"
L["TSM AuctionDB"] = "TSM AuctionDB"
L["TSM Auctioning"] = "TSM Auctioning"
L["TSM Crafting"] = "TSM Crafting"
L["TSM Desktop App Status (%s)"] = "TSM Desktop App Status (%s)"
L["TSM General Info"] = "TSM Allgemeine Infos"
L["TSM Shopping"] = "TSM Shopping"
L["TSM Sniper"] = "TSM Sniper"
L["TSM TASK LIST"] = "TSM AUFGABENLISTE"
L["TSM Version Info:"] = "TSM-Versionsinfo:"
L["TSM can automatically sync data between multiple WoW accounts."] = "TSM can automatically sync data between multiple WoW accounts."
L["TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"] = "TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"
L["TSM doesn't currently have any AuctionDB pricing data for your realm. We recommend you download the TSM Desktop Application from %s to automatically update your AuctionDB data (and auto-backup your TSM settings)."] = "TSM doesn't currently have any AuctionDB pricing data for your realm. We recommend you download the TSM Desktop Application from %s to automatically update your AuctionDB data (and auto-backup your TSM settings)."
L["TSM failed to scan some auctions. Please rerun the scan."] = "TSM konnte einige Auktionen nicht scannen. Bitte starte den Scan erneut."
L["TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."] = "TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."
L["TSM is missing important information from the TSM Desktop Application. Please ensure the TSM Desktop Application is running and is properly configured."] = "TSM fehlen wichtige Informationen aus der TSM-Desktop-App. Bitte stell sicher, dass die TSM-Desktop-App läuft und ordnungsgemäß konfiguriert ist."
L["TSM is not yet ready to establish a new sync connection. Please try again later."] = "TSM is not yet ready to establish a new sync connection. Please try again later."
L["TSM will not undercut any players you add to your whitelist."] = "TSM will not undercut any players you add to your whitelist."
L["TSM4"] = "TSM4"
L["Target character"] = "Ziel Charakter"
L["Target shortfall to bags"] = "Target shortfall to bags"
L["Tasks Added to Task List"] = "Aufgabe wurde zur Aufgabenliste hinzugefügt"
L["Tells you why a specific item is not being restocked and added to the queue."] = "Tells you why a specific item is not being restocked and added to the queue."
L["Text (%s)"] = "Text (%s)"
L["The '%s' function has an invalid number of arguments."] = "The '%s' function has an invalid number of arguments."
L["The '%s' item parameter was used outside of a custom source."] = "The '%s' item parameter was used outside of a custom source."
L["The 'Craft Value Method' did not return a value for this item."] = "The 'Craft Value Method' did not return a value for this item."
L["The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."] = "The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."
L["The AH does not support specifying a copper value (only gold and silver)."] = "The AH does not support specifying a copper value (only gold and silver)."
L["The Base Group contains all ungrouped items in the game. Use the search and filter controls to find items to add to other groups."] = "The Base Group contains all ungrouped items in the game. Use the search and filter controls to find items to add to other groups."
L["The TradeSkillMaster_AppHelper addon is installed, but not enabled. TSM has enabled it and requires a reload."] = "The TradeSkillMaster_AppHelper addon is installed, but not enabled. TSM has enabled it and requires a reload."
L["The buyout price for %s would be above the maximum allowed price. Skipping this item."] = "The buyout price for %s would be above the maximum allowed price. Skipping this item."
L["The canlearn filter was ignored because the CanIMogIt addon was not found."] = "Der Canlearn-Filter wurde ignoriert, da das Addon CanIMogIt nicht gefunden wurde."
L["The max quantity cannot be zero."] = "Max. Anzahl kann nicht 0 sein."
L["The min profit did not evaluate to a valid value for this item."] = "The min profit did not evaluate to a valid value for this item."
L["The name portion of the search term must be at least 3 characters if present."] = "The name portion of the search term must be at least 3 characters if present."
L["The pasted value was not valid. Ensure you are pasting the entire import string."] = "The pasted value was not valid. Ensure you are pasting the entire import string."
L["The player \\\"%s\\\" is already on your whitelist."] = "The player \\\"%s\\\" is already on your whitelist."
L["The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."] = "The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."
L["The profit of this item (%s) is below the min profit (%s)."] = "Der Profit für dieses Item (%s) ist kleiner als der Mindestprofit (%s)."
L["The same filter was specified multiple times."] = "The same filter was specified multiple times."
L["The search term must be at least 3 characters."] = "Die Suchabfrage muss min. drei Zeichen haben."
L["The seller name of the lowest auction for %s was not given by the server. Skipping this item."] = "The seller name of the lowest auction for %s was not given by the server. Skipping this item."
L["The specified filter was empty."] = "The specified filter was empty."
L["The specified item is not supported for crafting searches."] = "The specified item is not supported for crafting searches."
L["The specified item is not supported for disenchant searches."] = "The specified item is not supported for disenchant searches."
L["The specified item was not found."] = "The specified item was not found."
L["The unlearned filter was ignored because the CanIMogIt addon was not found."] = "Der Unlearned-Filter wurde ignoriert, da das Addon CanIMogIt nicht gefunden wurde."
L["The value must be greater than 0."] = "The value must be greater than 0."
L["The value must be greater than or equal of 0."] = "The value must be greater than or equal of 0."
L["The value was greater than the maximum allowed auction house price."] = "The value was greater than the maximum allowed auction house price."
L["Themes"] = "Themen"
L["There are unbalanced parentheses in this custom string."] = "There are unbalanced parentheses in this custom string."
L["There is currently no profession open, so cannot create profession groups."] = "There is currently no profession open, so cannot create profession groups."
L["There is no Crafting operation applied to this item's TSM group (%s)."] = "There is no Crafting operation applied to this item's TSM group (%s)."
L["This custom string is too complex for WoW to handle; use custom sources to simplify it."] = "This custom string is too complex for WoW to handle; use custom sources to simplify it."
L["This is not a valid profile name. Profile names must be at least one character long and may not contain '@' characters."] = "Dies ist kein gültiger Profilname. Profilnamen müssen mindestens 1 Zeichen lang sein und dürfen keine @-Zeichen enthalten."
L["This item does not have a crafting cost. Check that all of its mats have mat prices."] = "Dieses Item hat keine Herstellungskosten. Überprüfe, ob all seine Materialien Materialpreise haben."
L["This item is not in a TSM group."] = "Dieser Gegenstand ist in keiner TSM Gruppe."
L["This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."] = "This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."
L["This operation is applied to the base group which includes every item not in another group."] = "This operation is applied to the base group which includes every item not in another group."
L["This price is above your confirmation alert threshold."] = "This price is above your confirmation alert threshold."
L["This price is above your material value."] = "This price is above your material value."
L["This profession is not open."] = "Der Beruf ist nicht geöffnet."
L["This record belongs to another account and can only be deleted on that account."] = "This record belongs to another account and can only be deleted on that account."
L["This will permanently delete the '%s' profile."] = "Dies wird das Profil '%s‘ dauerhaft löschen."
L["This will reset all groups and operations (if not stored globally) to be wiped from '%s'."] = "This will reset all groups and operations (if not stored globally) to be wiped from '%s'."
L["Time"] = "Zeit"
L["Time Frame"] = "Zeitraum"
L["Tinker"] = "Tinker"
L["Toggles the TSM Banking UI if either the bank or guild bank is currently open."] = "Toggles the TSM Banking UI if either the bank or guild bank is currently open."
L["Toggles the TSM Crafting UI."] = "Toggles the TSM Crafting UI."
L["Toggles the TSM Task List UI"] = "Toggles the TSM Task List UI"
L["Toggles the main TSM window"] = "Toggles the main TSM window"
L["Tooltip Options"] = "Tooltipp Optionen"
L["Tooltip Settings"] = "Tooltipp Einstellungen"
L["Tooltip price format"] = "Tooltipp Preisformat"
L["Top Buyers"] = "Top Buyers"
L["Top Item"] = "Top Item"
L["Top Sellers"] = "Top Verkäufer"
L["Total"] = "Anz"
L["Total Gold"] = "Summe Gold"
L["Total Gold Collected: %s"] = "Summe Gold abgeholt: %s"
L["Total Gold Earned"] = "Gesamteinnahmen Gold"
L["Total Gold Spent"] = "Gesamtausgaben Gold"
L["Total Inventory Quantity"] = "Gesamtanzahl Inventar"
L["Total Items"] = "Gesamtanzahl"
L["Total Postage"] = "Total Postage"
L["Total Price"] = "Gesamtpreis"
L["Total Prices:"] = "Gesamtpreise:"
L["Total Profit"] = "Profit gesamt"
L["Total Value"] = "Gesamtwert"
L["Track Sales / Purchases via trade"] = "Verkäufe / Einkäufe via Handel protokollieren"
L["Transform"] = "Transform"
L["Transform Value"] = "Transformierungswert"
L["Type"] = "Typ"
L["Uncollected Only"] = "Uncollected Only"
L["Undercut amount"] = "Undercut amount"
L["Undercut by whitelisted player."] = "Unterboten von Spieler der weißen Liste."
L["Undercutting blacklisted player."] = "Unterbiete Spieler der schwarzen Liste."
L["Undercutting competition."] = "Unterbiete Wettbewerber."
L["Unexpected word ('%s') in custom string."] = "Unexpected word ('%s') in custom string."
L["Ungrouped Items"] = "Nicht gruppierte Items"
L["Ungrouped Items in Bags"] = "nicht gruppierte Gegenstände in den Taschen"
L["Unit Price"] = "Einheitenpreis"
L["Unknown Item"] = "Unbekanntes Item"
L["Unknown word (%s)."] = "Unbekanntes Wort (%s)."
L["Unlock Column Width"] = "Unlock Column Width"
L["Unwrap Gift"] = "Geschenk auspacken"
L["Up"] = "Hoch"
L["Up to date"] = "Aktuell"
L["Update existing macro"] = "Update existing macro"
L["Updating"] = "Wird aktualisiert"
L["Upgrades Only"] = "Nur Verbesserungen"
L["Usable Only"] = "Nur benutzbar"
L["Usage: /tsm price <Item Link> <Custom String>"] = "Usage: /tsm price <Item Link> <Custom String>"
L["Use the settings below to control which lines are shown in tooltips."] = "Verwende die unteren Einstellungen um festzulegen welche Zeilen im Tooltipp angezeigt werden."
L["Use this list to manage what cooldowns you'd like TSM to ignore from crafting."] = "Use this list to manage what cooldowns you'd like TSM to ignore from crafting."
L["Use this list to manage what items you'd like TSM to ignore from destroying."] = "Use this list to manage what items you'd like TSM to ignore from destroying."
L["Value"] = "Wert"
L["Value Price Source"] = "Value Price Source"
L["Value must be between %d and %d."] = "Wer muss zwischen %d und %d liegen."
L["Values"] = "Werte"
L["Vendor"] = "Verkäufer"
L["Vendor Buy Price"] = "Händler Kaufpreis"
L["Vendor Search"] = "Händlersuche"
L["Vendor Sell"] = "Händlerverkauf"
L["Vendor Sell Price"] = "Händler Verkaufspreis"
L["Vendor Trade"] = "Vendor Trade"
L["Vendor Trade Value"] = "Vendor Trade Value"
L["Vendor buy price"] = "Händler-Kaufpreis"
L["Vendor sell price"] = "Händler-Verkaufspreis"
L["Vendoring"] = "Vendoring"
L["Vendoring %s button"] = "Vendoring %s button"
L["Vendoring operation"] = "Vendoring operation"
L["Vendoring operations control selling to and buying from a vendor."] = "Vendoring operations control selling to and buying from a vendor."
L["WARNING: The macro was too long, so was truncated to fit by WoW."] = "WARNUNG: Das Makro war zu lang und wurde deshalb von WoW auf eine passende Größe gekürzt."
L["WARNING: Your minimum price for %s is below its vendorsell price (with AH cut taken into account). Consider raising your minimum price, or vendoring the item."] = "WARNING: Your minimum price for %s is below its vendorsell price (with AH cut taken into account). Consider raising your minimum price, or vendoring the item."
L["WOW UI"] = "WOW UI"
L["Warehousing"] = "Warehousing"
L["Warehousing operation"] = "Warehousing operation"
L["Warehousing operations control moving in and out of the bank."] = "Warehousing operations control moving in and out of the bank."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "Warehousing verschiebt jeweils bis zu %d Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Taschen > Bank/GBank ist, oder %d Einheiten eines Items zurück, wenn Bank/GBank > Taschen ist."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing verschiebt jeweils bis zu %d Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Taschen > Bank/GBank ist, oder %d Einheiten eines Items zurück, wenn Bank/GBank > Taschen ist. Das Wiederauffüllen stellt sicher, dass %d Items in deinen Taschen bleiben."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank."] = "Warehousing verschiebt jeweils bis zu %d Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Taschen > Bank/GBank ist."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "Warehousing verschiebt jeweils bis zu %d Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Taschen > Bank/GBank ist. Das Wiederauffüllen stellt sicher, dass %d Items in deinen Taschen bleiben."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags."] = "Warehousing verschiebt jeweils bis zu %d Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Bank/GBank > Taschen ist."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing verschiebt jeweils bis zu %d Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Bank/GBank > Taschen ist. Das Wiederauffüllen stellt sicher, dass %d Items in deinen Taschen bleiben."
L["Warehousing will move a max of %d of each item in this group."] = "Warehousing verschiebt jeweils bis zu %d Einheiten eines Items in dieser Gruppe."
L["Warehousing will move a max of %d of each item in this group. Restock will maintain %d items in your bags."] = "Warehousing verschiebt jeweils bis zu %d Einheiten eines Items in dieser Gruppe. Das Wiederauffüllen stellt sicher, dass %d Items in deinen Taschen bleiben."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "Warehousing verschiebt jeweils alle Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Taschen > Bank/GBank ist, oder jeweils %d Einheiten eines Items zurück, wenn Bank/GBank > Taschen ist."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing verschiebt jeweils alle Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Taschen > Bank/GBank ist, oder jeweils %d Einheiten eines Items zurück, wenn Bank/GBank > Taschen ist. Das Wiederauffüllen stellt sicher, dass %d Items in deinen Taschen bleiben."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank."] = "Warehousing verschiebt jeweils alle Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Taschen > Bank/GBank ist."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "Warehousing verschiebt jeweils alle Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Taschen > Bank/GBank ist. Das Wiederauffüllen stellt sicher, dass %d Items in deinen Taschen bleiben."
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags."] = "Warehousing verschiebt jeweils alle Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Bank/GBank > Taschen ist."
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing verschiebt jeweils alle Einheiten eines Items in dieser Gruppe und lässt jeweils %d Einheiten eines Items zurück, wenn Bank/GBank > Taschen ist. Das Wiederauffüllen stellt sicher, dass %d Items in deinen Taschen bleiben."
L["Warehousing will move all of the items in this group."] = "Warehousing verschiebt jeweils alle Einheiten eines Items in dieser Gruppe."
L["Warehousing will move all of the items in this group. Restock will maintain %d items in your bags."] = "Warehousing verschiebt jeweils alle Einheiten eines Items in dieser Gruppe. Das Wiederauffüllen stellt sicher, dass %d Items in deinen Taschen bleiben."
L["When above maximum:"] = "Wenn über Höchstpreis:"
L["When below minimum:"] = "Wenn unter Mindestpreis:"
L["Whitelist"] = "Weiße Liste"
L["Whitelisted characters"] = "Whitelisted characters"
L["Winamp"] = "Winamp"
L["Would send %s to %s"] = "Würde %s versenden an %s"
L["Would send %s to %s with a COD of %s"] = "Würde %s versenden an %s mit Nachnahme von %s"
L["Yes, I'm sure"] = "Yes, I'm sure"
L["Yes, I'm sure (%02d)"] = "Yes, I'm sure (%02d)"
L["You are not on one of the listed characters."] = "You are not on one of the listed characters."
L["You can clear old Accounting data for the current realm below to keep things running smoothly."] = "You can clear old Accounting data for the current realm below to keep things running smoothly."
L["You can import custom themes by pasting an import string into the box below."] = "You can import custom themes by pasting an import string into the box below."
L["You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"] = "You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"
L["You can now group pets by level, just like items."] = "You can now group pets by level, just like items."
L["You can use the export string below to share this custom theme with others."] = "You can use the export string below to share this custom theme with others."
L["You can use the export string below to share this group with others."] = "You can use the export string below to share this group with others."
L["You cannot use %s as part of this custom price."] = "Du kannst %s nicht als Teil dieses eigenen Preises verwenden."
L["You do not need to add \\\"%s\\\", alts are whitelisted automatically."] = "You do not need to add \\\"%s\\\", alts are whitelisted automatically."
L["You don't know how to craft this item."] = "Du weißt nicht, wie man dieses Item herstellt."
L["You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."] = "You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."
L["You must reload your UI for these settings to take effect. Reload now?"] = "Du musst dein UI neu laden, um diese Einstellungen wirksam werden zu lassen. Jetzt neu laden?"
L["You won an auction for %sx%d for %s"] = "Du hast die Auktion %sx%d mit %s gewonnen"
L["You've been phased which has caused the AH to stop working due to a bug on Blizzard's end. Please close and reopen the AH and restart Sniper."] = "Ein Bug seitens Blizzard hat dazu geführt, dass das AH nicht mehr funktioniert (du wurdest in eine andere Phase verschoben). Bitte schließe und öffne erneut das AH und starte den Sniper neu."
L["You've been undercut."] = "Du wurdest unterboten."
L["Your Buyout"] = "Dein Sofortkaufpreis"
L["Your auction has not been undercut."] = "Deine Auktion wurde nicht unterboten."
L["Your auction of %s expired"] = "Deine Auktion von %s ist ausgelaufen."
L["Your auction of %s has sold for %s!"] = "Deine Auktion %s wurde für %s verkauft!"
L["Your auction of %s has sold!"] = "Your auction of %s has sold!"
L["Your craft value method for '%s' was invalid so it has been returned to the default. Details: %s"] = "Deine Methode zur Marktwertermittlung von '%s' war ungültig und wurde auf den Standardwert zurückgesetzt. Details: %s"
L["Your default craft value method was invalid so it has been returned to the default. Details: %s"] = "Deine Standardmethode zur Marktwertermittlung war ungültig und wurde auf den Standardwert zurückgesetzt. Details: %s"
L["Your max restock (%s) is invalid for %s."] = "Your max restock (%s) is invalid for %s."
L["Your min restock (%s) is invalid for %s."] = "Your min restock (%s) is invalid for %s."
L["Your restock quantity is invalid. It must be between %d and %s."] = "Your restock quantity is invalid. It must be between %d and %s."
L["Your task list is currently empty."] = "Deine Aufgabenliste ist aktuell leer."
L["ilvl"] = "ilvl"
-- LOCALE STRINGS END HERE

Locale.SetTable(L)
