-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                          https://tradeskillmaster.com                          --
--    All Rights Reserved - Detailed license information included with addon.     --
-- ------------------------------------------------------------------------------ --

local TSM = select(2, ...) ---@type TSM
local Locale = TSM.Include("Locale")
if not Locale.ShouldLoad("esMX") then return end
local L = {}

-- LOCALE STRINGS START HERE
L["%d Characters"] = "%d Personajes"
L["%d Custom Sources"] = "%d Fuentes Personalizadas"
L["%d Faction-Realms"] = "%d Facción-Reinos"
L["%d Groups"] = "%d Grupos"
L["%d Groups Selected"] = "%d Grupos seleccionados"
L["%d Guilds"] = "%d Hermandades"
L["%d Items"] = "%d Objetos"
L["%d Operations"] = "%d Operaciones"
L["%d Players"] = "%d Jugadores"
L["%d Professions"] = "%d Profesiones"
L["%d Rarities"] = "%d Rarezas"
L["%d Results"] = "%d Resultados"
L["%d Selected"] = "%d Seleccionados"
L["%d Sources"] = "%d Fuentes"
L["%d Sub-Groups"] = "%d Sub-Grupos"
L["%d Types"] = "%d Tipos"
L["%d auctions"] = "%d subastas"
L["%d groups"] = "%d grupos"
L["%d groups were created and %d items were added from the table."] = "%d grupos fueron creados y %d objetos fueron agregados desde la tabla."
L["%d of %d"] = "%d de %d"
L["%d subgroups included"] = "%d subgrupos incluídos"
L["%d |4Group:Groups; Selected (%d |4Item:Items;)"] = "%d |4Grupo:Grupos; Seleccionado (%d |4Objeto:Objetos;)"
L["%s %s Operations"] = "%s %s Operaciones"
L["%s (%s bags, %s bank, %s AH, %s mail)"] = "%s (%s Bolsas, %s Banco, %s Casa de subastas, %s Correo)"
L["%s (%s player, %s alts, %s AH)"] = "%s (%s jugador, %s alts, %s Casa de Subastas)"
L["%s (%s player, %s alts, %s guild, %s AH)"] = "%s (%s Jugador, %s Alters, %s Hermandad, %s Casa de subastas)"
L["%s (%s profit)"] = "%s (%s ganancia)"
L["%s - %s has been reset to default values."] = "%s - %s ha sido restaurado a valores por defecto."
L["%s Crafts"] = "%s Creaciones"
L["%s Items Bought"] = "%s Objetos Comprados"
L["%s Items Cancelled"] = "%s Objetos Cancelados"
L["%s Items Expired"] = "%s Objetos Expirados"
L["%s Items Resold"] = "%s Objetos Revendidos"
L["%s Items Selected"] = "%s Objetos Seleccionados"
L["%s Items Sold"] = "%s Objetos Vendidos"
L["%s Items Total"] = "%s Objetos en Total"
L["%s Operations"] = "%s Operaciones"
L["%s Posted Auctions"] = "%s Subastas Publicadas"
L["%s Posted Auctions (Filtered)"] = "%s Subastas Publicadas (Filtrado)"
L["%s Sold Auctions"] = "%s Subastas Vendidas"
L["%s Sold Auctions (Filtered)"] = "%s Subastas Vendidas (filtrado)"
L["%s Total"] = "%s Total"
L["%s Total Profit"] = "%s Ganancia Total"
L["%s ago"] = "Hace %s"
L["%s group is already up to date."] = "El grupo %s ya está actualizado."
L["%s group updated with %d items and %d materials."] = "Grupo %s actualizado con %d objetos y %d materiales."
L["%s in guild vault"] = "%s en cámara de la Hermandad"
L["%s is a valid custom price but %s is an invalid item."] = "%s es un precio válido, pero %s no es un objeto válido."
L["%s is a valid custom price but did not give a value for %s."] = "%s es un precio válido pero no dio un valor para %s."
L["%s is not a valid custom price and gave the following error: %s"] = "%s no es un precio personalizado válido y dio el siguiente error: %s"
L["%s is not a valid source."] = "%s is not a valid source."
L["%s operation"] = "%s operación"
L["%s operations"] = "%s operaciones"
L["%s previously had the max number of operations, so removed %s."] = "%s anteriormente tenía el número máximo de operaciones, por lo que se eliminó %s."
L["%s removed."] = "%s eliminado."
L["%s sent you %s"] = "%s enviado a ti %s"
L["%s sent you %s and %s"] = "%s te envió %s y %s"
L["%s sent you a COD of %s for %s"] = "%s te envió un COD de %s para %s"
L["%s sent you a message: %s"] = "%s te ha enviado un mensaje: %s"
L["%s total"] = "%s total"
L["%sDrag%s to move this button"] = "%sArrastra%s para mover este botón"
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."] = "%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."] = "%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."
L["%sLeft-Click%s to open the main window"] = "%sClick Izquierdo%s para abrir la ventana principal"
L["%sLeft-Click|r to ignore an item for this session. Hold %sShift|r to ignore permanently. You can remove items from permanent ignore in the Vendoring settings."] = "%sClic Derecho|r para ignorar un objeto para esta sesión. Mantén %sShift|r para ignorar permanentemente. Puedes remover objetos de la lista de ignorados permanentes en los Ajustes de Venta."
L["'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."] = "'%s' es una operación inválida. El reabastecimiento mínimo de %d es mayor que el reabastecimiento máximo de %d por %s."
L["'%s' is not a valid argument for convert()."] = "'%s' is not a valid argument for convert()."
L["'%s' is not a valid item argument."] = "'%s' is not a valid item argument."
L["(%d/500 Characters)"] = "(%d/500 caracteres)"
L["(minimum 0 - maximum %d)"] = "(mínimo 0 - máximo %d)"
L["1 Group"] = "1 Grupo"
L["1 Item"] = "1 Objeto"
L["1D"] = "1D"
L["1M"] = "1M"
L["1W"] = "1S"
L["1Y"] = "1A"
L["2Y"] = "2A"
L["3M"] = "3M"
L["6M"] = "6M"
L["A custom price of %s for %s evaluates to %s."] = "Un precio personalizado de %s para %s se estima en %s."
L["A profile with that name already exists on the target account. Rename it first and try again."] = "Ya existe un perfil con ese nombre en la cuenta. Puedes renombrarlo e intentar nuevamente."
L["A profile with this name already exists."] = "Ya existe un perfil con ese nombre."
L["A scan is already in progress. Please stop that scan before starting another one."] = "Un escaneo ya está en curso. Debes detenerlo para poder iniciar otro."
L["A single craft makes %d and you only need to restock %d."] = "A single craft makes %d and you only need to restock %d."
L["AH"] = "Casa de Subastas"
L["AH (Crafting)"] = "Casa de Subastas (Fabricar)"
L["AH (Disenchanting)"] = "Casa de subastas (Desencantando)"
L["AH BUSY"] = "CASA DE SUBASTAS OCUPADA"
L["AHDB Minimum Bid"] = "AHDB Minimum Bid"
L["AHDB Minimum Buyout"] = "AHDB Minimum Buyout"
L["ALT"] = "ALT"
L["Above max expires."] = "Sobre el máximo de expiraciones."
L["Above max price. Not posting."] = "Sobre precio máximo. No se publica."
L["Above max price. Posting at max."] = "Sobre el precio máximo. Publicando al máximo"
L["Above max price. Posting at min."] = "Sobre el precio máximo. Publicando al mínimo."
L["Above max price. Posting at normal."] = "Sobre el precio máximo. Publicando al precio normal."
L["Accept COD?"] = "¿Aceptar C.R.?"
L["Accepting this item will cost: %s"] = "Aceptar este objeto costará: %s"
L["Account Syncing"] = "Sincronizar Cuentas"
L["Account sync removed. Please delete the account sync from the other account as well."] = "Account sync removed. Please delete the account sync from the other account as well."
L["Accounting"] = "Contabilidad"
L["Active"] = "Active"
L["Active Alt"] = "Active Alt"
L["Activity Type"] = "Tipo de Actividad"
L["Add"] = "Agregar"
L["Add %d |4Item:Items"] = "Add %d |4Item:Items"
L["Add %s Operation"] = "Add %s Operation"
L["Add More Operations"] = "Agregar Más Operaciones"
L["Add Operation"] = "Agregar Operación"
L["Add Subject / Description"] = "Agregar Asunto / Descripción"
L["Add a new custom source"] = "Agregar un origen personalizado"
L["Add account"] = "Agregar cuenta"
L["Add operation to groups"] = "Agregar operación a grupos"
L["Add subject & description (optional)"] = "Agregar asunto y descripción (opcional)"
L["Add to Mail"] = "Agregar a Mensaje"
L["Added %s to %s."] = "Added %s to %s."
L["Added '%s' profile which was received from %s."] = "Se agregó el perfil '%s', el cual fue recibido de %s."
L["Additional error suppressed"] = "Error Adicional Suprimido"
L["Adjust how TSM values crafted items when calculating profit."] = "Adjust how TSM values crafted items when calculating profit."
L["Adjust how crafted items are restocked."] = "Adjust how crafted items are restocked."
L["Adjust how items are mailed."] = "Ajustar cómo son enviados objetos por mensaje."
L["Adjust some general settings."] = "Adjust some general settings."
L["Adjust the settings below to set how groups attached to this operation will be auctioned."] = "Adjust the settings below to set how groups attached to this operation will be auctioned."
L["Adjust the settings below to set how groups attached to this operation will be cancelled."] = "Adjust the settings below to set how groups attached to this operation will be cancelled."
L["Adjust the settings below to set how groups attached to this operation will be priced."] = "Adjust the settings below to set how groups attached to this operation will be priced."
L["Advanced Item Search"] = "Búsqueda avanzada de objetos"
L["Alarm Clock"] = "Alarma"
L["All"] = "Todo"
L["All Auctions"] = "Todas las subastas"
L["All Bought"] = "Todos Comprados"
L["All Cancelled"] = "Todos Cancelados"
L["All Characters"] = "Todos los personajes"
L["All Expired"] = "Todos Expirados"
L["All Faction-Realms"] = "All Faction-Realms"
L["All Guilds"] = "All Guilds"
L["All Item Classes"] = "Toda clase de objeto"
L["All Other"] = "Todos Otros"
L["All Players"] = "Todos los jugadores"
L["All Professions"] = "Todas las profesiones"
L["All Rarites"] = "Todas las rarezas"
L["All Rarities"] = "Todas las rarezas"
L["All Selected"] = "All Selected"
L["All Slots"] = "All Slots"
L["All Sold"] = "Todos Vendidos"
L["All Sources"] = "All Sources"
L["All Subclasses"] = "Todas las subclases"
L["All Time"] = "Todo el tiempo"
L["All Types"] = "Todos los tipos"
L["Allow partial stack"] = "Allow partial stack"
L["Allows for testing of custom prices"] = "Allows for testing of custom prices"
L["Alt Guild Bank"] = "Alt Guild Bank"
L["Alts"] = "Alts"
L["Alts AH"] = "Casa de Subasta de Alts"
L["Amount"] = "Cantidad"
L["Amount kept in bags"] = "Amount kept in bags"
L["Amount of bag space to keep free"] = "Amount of bag space to keep free"
L["An old TSM addon was found installed. Please remove %s and any other old TSM addons to avoid issues."] = "An old TSM addon was found installed. Please remove %s and any other old TSM addons to avoid issues."
L["App Not Synced"] = "App No Sincronizada"
L["App Synced %s Ago"] = "App Synced %s Ago"
L["Appearance"] = "Apariencia"
L["Apply operation to group"] = "Aplicar operación a grupo"
L["Are you sure you want to clear accounting data older than %d days for the currenet realm?"] = "Are you sure you want to clear accounting data older than %d days for the currenet realm?"
L["Are you sure you want to delete the selected operations?"] = "Are you sure you want to delete the selected operations?"
L["Are you sure you want to delete this operation?"] = "¿Seguro que quieres eliminar esta operación?"
L["At above max price and not undercut."] = "At above max price and not undercut."
L["At normal price and not undercut."] = "At normal price and not undercut."
L["Attachments"] = "Adjuntos"
L["Auction"] = "Subasta"
L["Auction House Cut"] = "Comisión de la Casa de Subastas"
L["Auction House Sounds"] = "Sonidos de la Casa de Subastas"
L["Auction Window Close"] = "Cerrar Ventana de Subasta"
L["Auction Window Open"] = "Abrir Ventana de Subasta"
L["Auction duration"] = "Duración de subasta"
L["Auction has been bid on."] = "La subasta ha sido pujada."
L["Auction sale sound"] = "Sonido de venta de Subasta"
L["AuctionDB"] = "BD de Subasta"
L["AuctionDB - Historical Price"] = "AuctionDB - Historical Price"
L["AuctionDB - Market Value"] = "BD de Subasta - Valor de Mercado"
L["AuctionDB - Minimum Buyout"] = "BD de Subasta - Precio de Compra Mínimo"
L["AuctionDB - Recent Value"] = "AuctionDB - Recent Value"
L["AuctionDB - Region Historical Price"] = "AuctionDB - Region Historical Price"
L["AuctionDB - Region Market Value Average"] = "AuctionDB - Region Market Value Average"
L["AuctionDB - Region Sale Average"] = "AuctionDB - Region Sale Average"
L["AuctionDB - Region Sale Rate"] = "AuctionDB - Region Sale Rate"
L["AuctionDB - Region Sold Per Day"] = "AuctionDB - Region Sold Per Day"
L["AuctionDB Realm Data is %s Old"] = "BD de Subasta de Reino es %s Antigua"
L["AuctionDB Region Data is %s Old"] = "BD de Subasta de Región es %s Antigua"
L["Auctionator - Auction Value"] = "Auctionator - Valor de la subasta"
L["Auctioneer - Appraiser"] = "Subastador - Valuador"
L["Auctioneer - Market Value"] = "Auctioneer - Valor de mercado"
L["Auctioneer - Minimum Buyout"] = "Subastador - Precio mínimo de compra"
L["Auctioning"] = "Subasta"
L["Auctioning %s button"] = "Auctioning %s button"
L["Auctioning Details"] = "Auctioning Details"
L["Auctioning Log"] = "Registro de Subasta"
L["Auctioning Operation"] = "Operación de Subasta"
L["Auctioning operation"] = "Operación de subasta"
L["Auctioning operations control posting to and canceling from the AH."] = "Las operaciones de Subasta controlan el publicar y cancelar en la Casa de Subastas."
L["Auctions"] = "Subastas"
L["Auto Quest Complete"] = "Auto misión Completa"
L["Auto-focus browse search input"] = "Auto-focus browse search input"
L["Average Earned per Day"] = "Ingreso promedio por día"
L["Average Prices:"] = "Precios promedio:"
L["Average Profit per Day"] = "Ganancia promedio por día"
L["Average Spent per Day"] = "Gasto promedio por día"
L["Avg Buy Price"] = "Precio medio de compra"
L["Avg Profit"] = "Avg Profit"
L["Avg Sell Price"] = "Precio medio de venta"
L["BUSY"] = "OCUPADO"
L["BUY"] = "COMPRAR"
L["Back"] = "Back"
L["Bag"] = "Bolsa"
L["Bags"] = "Bolsas"
L["Bank"] = "Bank"
L["Banking"] = "Banking"
L["Banks"] = "Bancos"
L["Base Group"] = "Grupo Base"
L["Base Item"] = "Objeto Base"
L["Below is a list of all available price sources, along with a brief description of what they represent."] = "Below is a list of all available price sources, along with a brief description of what they represent."
L["Below min price. Posting at max."] = "Below min price. Posting at max."
L["Below min price. Posting at min."] = "Below min price. Posting at min."
L["Below min price. Posting at normal."] = "Below min price. Posting at normal."
L["Below you can ignore this operation on certain characters or realms."] = "Below you can ignore this operation on certain characters or realms."
L["Bid %d / %d"] = "Bid %d / %d"
L["Bid (item)"] = "Pujar (objeto)"
L["Bid (stack)"] = "Bid (stack)"
L["Bid (total)"] = "Pujar (total)"
L["Bid / Buyout"] = "Bid / Buyout"
L["Bid Auction"] = "Bid Auction"
L["Bid Price"] = "Precio de Puja"
L["Bid Sniper Paused"] = "Bid Sniper Paused"
L["Bid Sniper Running"] = "Bid Sniper Running"
L["Bid percent must be between 0 and 100."] = "Bid percent must be between 0 and 100."
L["Bidding Auction"] = "Bidding Auction"
L["Blacklisted players"] = "Blacklisted players"
L["Bought"] = "Comprado"
L["Bought %d of %s from %s for %s"] = "Bought %d of %s from %s for %s"
L["Bought %sx%d for %s from %s"] = "Bought %sx%d for %s from %s"
L["Bound Actions"] = "Bound Actions"
L["Browse"] = "Navegar"
L["Browse / Sniper"] = "Browse / Sniper"
L["Buy"] = "Comprar"
L["Buy %d / %d"] = "Buy %d / %d"
L["Buy %d / %d (Confirming %d / %d)"] = "Buy %d / %d (Confirming %d / %d)"
L["Buy Auction"] = "Buy Auction"
L["Buy Commodity"] = "Buy Commodity"
L["Buy Commodity (%02d)"] = "Buy Commodity (%02d)"
L["Buy Groups"] = "Comprar Grupos"
L["Buy Options"] = "Buy Options"
L["Buy from AH"] = "Comprar en la Casa de Subastas"
L["Buy from AH (Crafting)"] = "Comprar en la Casa de Subastas (Fabricando)"
L["Buy from AH (Disenchant)"] = "Comprar de la Casa de Subastas (Desencantar)"
L["Buy from Vendor"] = "Comprar al Vendedor"
L["Buyback All"] = "Recuperar Todo"
L["Buyer/Seller"] = "Buyer/Seller"
L["Buyout"] = "Compra"
L["Buyout (item)"] = "Compra (objeto)"
L["Buyout (stack)"] = "Buyout (stack)"
L["Buyout (total)"] = "Compra (total)"
L["Buyout Above Threshold"] = "Buyout Above Threshold"
L["Buyout Price"] = "Precio de Compra"
L["Buyout Sniper Paused"] = "Sniper de Compras pausado"
L["Buyout Sniper Running"] = "Sniper de Compras corriendo"
L["Buyout confirmation alert"] = "Buyout confirmation alert"
L["COD"] = "Pago contra reembolso"
L["CRAFT"] = "CRAFT"
L["CRAFTING"] = "CRAFTING"
L["CTRL"] = "CTRL"
L["Can't load TSM tooltip while in combat"] = "No se puede cargar la descripción emergente de TSM mientras se está en combate"
L["Cancel"] = "Cancelar"
L["Cancel %d / %d"] = "Cancel %d / %d"
L["Cancel Auction"] = "Cancelar Subasta"
L["Cancel Scan"] = "Cancelar escaneo"
L["Cancel auctions with bids"] = "Cancelar subastas con pujas"
L["Cancel or Post"] = "Cancelar o Publicar"
L["Cancel to repost higher"] = "Cancel to repost higher"
L["Cancel undercut auctions"] = "Cancel undercut auctions"
L["Canceled information"] = "Canceled information"
L["Canceling"] = "Cancelación"
L["Canceling %d / %d"] = "Canceling %d / %d"
L["Canceling %d Auctions..."] = "Cancelando %d Subastas..."
L["Canceling Options"] = "Canceling Options"
L["Canceling auction you've undercut."] = "Canceling auction you've undercut."
L["Canceling disabled."] = "Canceling disabled."
L["Canceling to repost at higher price."] = "Canceling to repost at higher price."
L["Canceling to repost at reset price."] = "Canceling to repost at reset price."
L["Canceling to repost higher."] = "Canceling to repost higher."
L["Canceling undercut auctions and to repost higher."] = "Canceling undercut auctions and to repost higher."
L["Canceling undercut auctions."] = "Canceling undercut auctions."
L["Cancelled"] = "Cancelado"
L["Cancelled Since Last Sale"] = "Cancelled Since Last Sale"
L["Cancelled auction of %sx%d"] = "Cancelled auction of %sx%d"
L["Cancelled:"] = "Cancelado:"
L["Cannot repair from the guild bank!"] = "¡No puede reparar desde el banco de hermandad!"
L["Cannot use additional filters with /crafting or /disenchant."] = "Cannot use additional filters with /crafting or /disenchant."
L["Cash Register"] = "Caja registradora"
L["Changes to the specified profile (i.e. '/tsm profile Default' changes to the 'Default' profile)"] = "Cambia al perfil especificado (ej. '/tsm profile Default' cambia al perfil 'Default')"
L["Character"] = "Personaje"
L["Chat Tab"] = "Pestaña de chat"
L["Cheapest auction below min price."] = "Cheapest auction below min price."
L["Clear All"] = "Borrar todo"
L["Clear Data"] = "Clear Data"
L["Clear Filters"] = "Limpiar Filtros"
L["Clear Old Data"] = "Clear Old Data"
L["Clear Old Data?"] = "Clear Old Data?"
L["Click and drag to resize this window."] = "Click and drag to resize this window."
L["Click to hide this item for the current session. Hold shift to hide this item permanently."] = "Click to hide this item for the current session. Hold shift to hide this item permanently."
L["Coins (%s)"] = "Monedas (%s)"
L["Combine Partial Stacks"] = "Combine Partial Stacks"
L["Combining..."] = "Combinando..."
L["Confirm"] = "Confirmar"
L["Confirm complete sound"] = "Confirm complete sound"
L["Confirmation %s button"] = "Confirmation %s button"
L["Confirming %d / %d"] = "Confirmando %d / %d"
L["Confirming..."] = "Confirming..."
L["Connected to %s"] = "Conectado a %s"
L["Connecting to %s"] = "Conectando a %s"
L["Contacts"] = "Contactos"
L["Contains auctions above your alert threshold!"] = "Contains auctions above your alert threshold!"
L["Contains auctions above your material value!"] = "Contains auctions above your material value!"
L["Convert Value (%s)"] = "Convert Value (%s)"
L["Cooldown"] = "Cooldown"
L["Cooldowns"] = "Cooldowns"
L["Copy Letter"] = "Copiar carta"
L["Cost"] = "Costo"
L["Could not create macro as you already have too many. Delete one of your existing macros and try again."] = "Could not create macro as you already have too many. Delete one of your existing macros and try again."
L["Could not find profile '%s'. Possible profiles: '%s'"] = "No se pudo encontrar el perfil '%s'. Posibles perfiles: '%s'"
L["Could not sell items due to not having free bag space available to split a stack of items."] = "Could not sell items due to not having free bag space available to split a stack of items."
L["Craft"] = "Craft"
L["Craft (Profitable)"] = "Craft (Profitable)"
L["Craft (Unprofitable)"] = "Craft (Unprofitable)"
L["Craft Next"] = "Craft Next"
L["Craft Value"] = "Craft Value"
L["Craft Vellum"] = "Craft Vellum"
L["Crafted Items"] = "Crafted Items"
L["Crafter"] = "Crafter"
L["Crafting"] = "Crafting"
L["Crafting %s button"] = "Crafting %s button"
L["Crafting Cost"] = "Crafting Cost"
L["Crafting Material Cost"] = "Crafting Material Cost"
L["Crafting Mode"] = "Crafting Mode"
L["Crafting UI Improvements"] = "Crafting UI Improvements"
L["Crafting Value"] = "Crafting Value"
L["Crafting cost"] = "Crafting cost"
L["Crafting operation"] = "Crafting operation"
L["Crafting operations control how queuing profession crafts."] = "Crafting operations control how queuing profession crafts."
L["Crafts"] = "Crafts"
L["Create Groups from Table"] = "Create Groups from Table"
L["Create New"] = "Crear nuevo"
L["Create New Group"] = "Crear un grupo nuevo"
L["Create New Operation"] = "Crear Nueva Operación"
L["Create Profession Groups"] = "Create Profession Groups"
L["Create macro"] = "Create macro"
L["Create new profile"] = "Crear nuevo perfil"
L["Current Price"] = "Precio Actual"
L["Custom"] = "Custom"
L["Custom Price"] = "Custom Price"
L["Custom Source"] = "Custom Source"
L["Custom Sources"] = "Custom Sources"
L["Custom Theme"] = "Custom Theme"
L["Custom price name %s already exists."] = "Custom price name %s already exists."
L["Custom price name %s is a reserved word which cannot be used."] = "Custom price name %s is a reserved word which cannot be used."
L["Custom price names can only contain lowercase letters."] = "Custom price names can only contain lowercase letters."
L["Custom source (%s)"] = "Custom source (%s)"
L["Custom sources allow you to create more advanced prices for use throughout the addon. You'll be able to use these new variables in the same way you can use the built-in price sources such as %s and %s."] = "Custom sources allow you to create more advanced prices for use throughout the addon. You'll be able to use these new variables in the same way you can use the built-in price sources such as %s and %s."
L["DAILY PURCHASES"] = "COMPRAS DIARIAS"
L["DAILY SALES"] = "VENTAS DIARIAS"
L["Dalaran"] = "Dalaran"
L["Dashboard"] = "Dashboard"
L["Default Price"] = "Default Price"
L["Default craft value method"] = "Default craft value method"
L["Default material cost method"] = "Default material cost method"
L["Default price configuration"] = "Default price configuration"
L["Define what priority Gathering gives certain sources."] = "Define what priority Gathering gives certain sources."
L["Delete %d Operations"] = "Delete %d Operations"
L["Delete Group?"] = "¿Eliminar grupo?"
L["Delete Operation?"] = "¿Eliminar operación?"
L["Delete Operations"] = "Eliminar operaciones"
L["Delete Operations?"] = "¿Eliminar operaciones?"
L["Delete Profile?"] = "¿Eliminar perfil?"
L["Delete Record?"] = "Delete Record?"
L["Delete the profile"] = "Eliminar perfil"
L["Deleting this group (%s) will also remove any sub-groups attached to this group."] = "Deleting this group (%s) will also remove any sub-groups attached to this group."
L["Deposit"] = "Depósito"
L["Deposit Cost"] = "Costo del Depósito"
L["Deposit reagents"] = "Deposit reagents"
L["Deselect All"] = "Desmarcar todo"
L["Destroy Next"] = "Destroy Next"
L["Destroy Value"] = "Borrar Valor"
L["Destroy value"] = "Borrar valor"
L["Destroy value source"] = "Destroy value source"
L["Destroying"] = "Destroying"
L["Destroying %s button"] = "Destroying %s button"
L["Destroying will ignore %s permanently. You can remove it from the ignored list in the settings."] = "Destroying will ignore %s permanently. You can remove it from the ignored list in the settings."
L["Destroying will ignore %s until you log out."] = "Destroying will ignore %s until you log out."
L["Destroying..."] = "Destruyendo..."
L["Detailed crafting cost"] = "Detailed crafting cost"
L["Details"] = "Detalles"
L["Did not cancel %s because your cancel to repost threshold (%s) is invalid. Check your settings."] = "Did not cancel %s because your cancel to repost threshold (%s) is invalid. Check your settings."
L["Did not cancel %s because your maximum price (%s) is invalid. Check your settings."] = "Did not cancel %s because your maximum price (%s) is invalid. Check your settings."
L["Did not cancel %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "Did not cancel %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."
L["Did not cancel %s because your minimum price (%s) is invalid. Check your settings."] = "Did not cancel %s because your minimum price (%s) is invalid. Check your settings."
L["Did not cancel %s because your normal price (%s) is invalid. Check your settings."] = "Did not cancel %s because your normal price (%s) is invalid. Check your settings."
L["Did not cancel %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "Did not cancel %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."
L["Did not cancel %s because your undercut (%s) is invalid. Check your settings."] = "Did not cancel %s because your undercut (%s) is invalid. Check your settings."
L["Did not change prices due to an invalid bid or buyout value."] = "Did not change prices due to an invalid bid or buyout value."
L["Did not post %s because Blizzard didn't provide all necessary information for it. Try again later."] = "Did not post %s because Blizzard didn't provide all necessary information for it. Try again later."
L["Did not post %s because the owner of the lowest auction (%s) is on both the blacklist and whitelist which is not allowed. Adjust your settings to correct this issue."] = "Did not post %s because the owner of the lowest auction (%s) is on both the blacklist and whitelist which is not allowed. Adjust your settings to correct this issue."
L["Did not post %s because you or one of your alts (%s) is on the blacklist which is not allowed. Remove this character from your blacklist."] = "Did not post %s because you or one of your alts (%s) is on the blacklist which is not allowed. Remove this character from your blacklist."
L["Did not post %s because your keep quantity (%s) is invalid. Check your settings."] = "Did not post %s because your keep quantity (%s) is invalid. Check your settings."
L["Did not post %s because your max expires (%s) is invalid. Check your settings."] = "Did not post %s because your max expires (%s) is invalid. Check your settings."
L["Did not post %s because your maximum price (%s) is invalid. Check your settings."] = "Did not post %s because your maximum price (%s) is invalid. Check your settings."
L["Did not post %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "Did not post %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."
L["Did not post %s because your minimum price (%s) is invalid. Check your settings."] = "No se publicó %s porque su precio mínimo (%s) no es válido. Verifique su configuración."
L["Did not post %s because your normal price (%s) is invalid. Check your settings."] = "Did not post %s because your normal price (%s) is invalid. Check your settings."
L["Did not post %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "Did not post %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."
L["Did not post %s because your post cap (%s) is invalid. Check your settings."] = "Did not post %s because your post cap (%s) is invalid. Check your settings."
L["Did not post %s because your stack size (%s) is invalid. Check your settings."] = "Did not post %s because your stack size (%s) is invalid. Check your settings."
L["Did not post %s because your undercut (%s) is invalid. Check your settings."] = "Did not post %s because your undercut (%s) is invalid. Check your settings."
L["Disable invalid price warnings"] = "Disable invalid price warnings"
L["Disenchant Search"] = "Búsqueda para Desencantar"
L["Disenchant Search Options"] = "Disenchant Search Options"
L["Disenchant Value"] = "Disenchant Value"
L["Disenchanting Options"] = "Disenchanting Options"
L["Display total money received in chat"] = "Display total money received in chat"
L["Don't Post Items"] = "Don't Post Items"
L["Don't post after this many expires"] = "Don't post after this many expires"
L["Don't prompt to record trades"] = "Don't prompt to record trades"
L["Done Canceling"] = "Done Canceling"
L["Done Posting"] = "Publicación Terminada"
L["Done Scanning"] = "Done Scanning"
L["Done rebuilding item cache."] = "Done rebuilding item cache."
L["Down"] = "Down"
L["Duplicate the profile"] = "Duplicar el perfil"
L["Duration"] = "Duración"
L["Duskwood"] = "Duskwood"
L["EXPENSES"] = "GASTOS"
L["Edit"] = "Editar"
L["Edit Post"] = "Editar Publicación"
L["Embed TSM tooltip"] = "Embed TSM tooltip"
L["Empty bags"] = "Bolsas vacías"
L["Empty price string."] = "Cadena de precio vacía."
L["Enable TSM tooltips"] = "Enable TSM tooltips"
L["Enable automatic stack combination"] = "Enable automatic stack combination"
L["Enable buying"] = "Enable buying"
L["Enable inbox chat messages"] = "Enable inbox chat messages"
L["Enable region-wide trading (requires reload)"] = "Enable region-wide trading (requires reload)"
L["Enable restock"] = "Enable restock"
L["Enable selling"] = "Enable selling"
L["Enable sending chat messages"] = "Enable sending chat messages"
L["Enchant"] = "Enchant"
L["Ensure both characters are online and try again."] = "Ensure both characters are online and try again."
L["Enter Filter"] = "Enter Filter"
L["Enter Keyword"] = "Enter Keyword"
L["Enter a value from %d - %d"] = "Enter a value from %d - %d"
L["Enter a value from %d - %d%%"] = "Enter a value from %d - %d%%"
L["Enter name of logged-in character on other account"] = "Enter name of logged-in character on other account"
L["Enter player name"] = "Ingresa el nombre del jugador"
L["Enter profile name"] = "Ingresa el nombre del perfil"
L["Enter recipient name"] = "Ingresa el nombre del destinatario"
L["Establishing connection to %s. Make sure that you've entered this character's name on the other account."] = "Estableciendo conexión a %s. Asegúrate de haber ingresado el nombre de este personaje en la otra cuenta."
L["Establishing connection..."] = "Establishing connection..."
L["Estimated Profit"] = "Estimated Profit"
L["Estimated Time"] = "Estimated Time"
L["Estimated deliver time"] = "Estimated deliver time"
L["Exact Match"] = "Exact Match"
L["Example"] = "Ejemplo"
L["Example Item"] = "Example Item"
L["Example Tooltip"] = "Example Tooltip"
L["Exclude custom sources?"] = "Exclude custom sources?"
L["Exclude operations?"] = "Exclude operations?"
L["Exit"] = "Salida"
L["Expand / Collapse All Groups"] = "Expandir / Contraer todos los grupos"
L["Expenses"] = "Gastos"
L["Expirations"] = "Expirations"
L["Expired"] = "Expirado"
L["Expired Auctions"] = "Expired Auctions"
L["Expired Since Last Sale"] = "Expired Since Last Sale"
L["Expired information"] = "Expired information"
L["Expires"] = "Expira en"
L["Expires Since Last Sale"] = "Expires Since Last Sale"
L["Expiring Mails"] = "Expiring Mails"
L["Exploration"] = "Exploración"
L["Export"] = "Exportar"
L["Export Custom Theme"] = "Export Custom Theme"
L["Export String"] = "Export String"
L["Export theme"] = "Export theme"
L["Export this group"] = "Exportar este grupo"
L["Failed Auctions"] = "Subastas Fallidas"
L["Failed to bid on auction of %s (x%s) for %s."] = "Failed to bid on auction of %s (x%s) for %s."
L["Failed to bid on auction of %s."] = "Failed to bid on auction of %s."
L["Failed to buy auction of %s (x%s) for %s."] = "Failed to buy auction of %s (x%s) for %s."
L["Failed to buy auction of %s."] = "Failed to buy auction of %s."
L["Failed to buy auction."] = "Failed to buy auction."
L["Failed to cancel auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Failed to cancel auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."
L["Failed to find auction for %s, so removing it from the results."] = "Failed to find auction for %s, so removing it from the results."
L["Failed to move group, as a group with the same name already exists in the target location."] = "Failed to move group, as a group with the same name already exists in the target location."
L["Failed to post %sx%d as the item no longer exists in your bags."] = "Failed to post %sx%d as the item no longer exists in your bags."
L["Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."
L["Failed to send profile."] = "Fallo al enviar perfil"
L["Failed to send profile. Ensure both characters are online and try again."] = "Error al enviar perfil. Asegúrate que ambos personajes se encuentren en línea e intenta nuevamente."
L["Failed to start sniper. No groups have a Sniper operation applied."] = "Failed to start sniper. No groups have a Sniper operation applied."
L["Favorite Scans"] = "Escaneos Favoritos"
L["Favorite Searches"] = "Búsquedas Favoritas"
L["Favorited Patterns"] = "Favorited Patterns"
L["Filter by Keyword"] = "Filtrar por palabra clave"
L["Filter by Price Source"] = "Filter by Price Source"
L["Filter by Profession"] = "Filtrar por profesión"
L["Filter by duration"] = "Filtrar por duración"
L["Filter by groups"] = "Filtrar por grupos"
L["Filter by keyword"] = "Filtrar por palabra clave"
L["Filter group item lists based on the following price source"] = "Filtrar las listas de grupos según la siguiente fuente de precios"
L["Finding Selected Auction"] = "Finding Selected Auction"
L["First Auctioning Operation Max Price"] = "First Auctioning Operation Max Price"
L["First Auctioning Operation Min Price"] = "First Auctioning Operation Min Price"
L["First Auctioning Operation Normal Price"] = "First Auctioning Operation Normal Price"
L["Fishing Reel In"] = "Pesca - recoger el sedal"
L["For more info, visit %s. For help, join us in Discord: %s."] = "For more info, visit %s. For help, join us in Discord: %s."
L["Forget Character"] = "Olvidar Personaje"
L["Found auction sound"] = "Found auction sound"
L["Frame"] = "Frame"
L["Friends"] = "Amigos"
L["From"] = "De"
L["Full convert tooltip"] = "Full convert tooltip"
L["Full destroy tooltip"] = "Full destroy tooltip"
L["Full inventory"] = "Full inventory"
L["GVault"] = "Cámara Herm."
L["Garrison"] = "Fortaleza"
L["Gathering"] = "Gathering"
L["Gathering Search"] = "Gathering Search"
L["Gathering Setup"] = "Gathering Setup"
L["General Options"] = "Opciones Generales"
L["General Settings"] = "General Settings"
L["Get from Bank"] = "Get from Bank"
L["Get from Guild Bank"] = "Get from Guild Bank"
L["Gets items from the bank or guild bank matching the item or partial text entered."] = "Gets items from the bank or guild bank matching the item or partial text entered."
L["Gold"] = "Oro"
L["Great Deals Search"] = "Búsqueda de Grandes Ofertas"
L["Group Management"] = "Administrar Grupo"
L["Group Search"] = "Búsqueda de grupo"
L["Group already exists."] = "Group already exists."
L["Group name"] = "Nombre de grupo"
L["Grouped Items"] = "Objetos en el grupo"
L["Grouping Pets by Level"] = "Grouping Pets by Level"
L["Groups"] = "Grupos"
L["Groups & Operations"] = "Groups & Operations"
L["Groups Using"] = "Groups Using"
L["Guild"] = "Hermandad"
L["Guild Bank"] = "Banco de hermandad"
L["HIGH"] = "MAXIMO"
L["Have"] = "Have"
L["Have Mats"] = "Have Mats"
L["Have Skill Ups"] = "Have Skill Ups"
L["Here you can add/remove what groups this operation is attached to."] = "Here you can add/remove what groups this operation is attached to."
L["Hide Columns"] = "Ocultar Columnas"
L["Hide auctions with bids"] = "Ocultar subastas con pujas"
L["Hide minimap icon"] = "Ocultar icono en el minimapa"
L["Hiding the TSM Banking UI. Type '/tsm bankui' to reopen it."] = "Hiding the TSM Banking UI. Type '/tsm bankui' to reopen it."
L["Hiding the TSM Task List UI. Type '/tsm tasklist' to reopen it."] = "Hiding the TSM Task List UI. Type '/tsm tasklist' to reopen it."
L["High Bidder"] = "Mayor postor"
L["Historical Price"] = "Precio Historico"
L["Historical price"] = "Precio histórico"
L["Hold ALT to repair from the guild bank."] = "Mantén ALT para reparar desde el banco de hermandad."
L["Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."] = "Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."
L["Hold SHIFT to continue after the inbox refreshes"] = "Hold SHIFT to continue after the inbox refreshes"
L["Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."] = "Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."
L["Hold SHIFT to not continue after the inbox refreshes"] = "Hold SHIFT to not continue after the inbox refreshes"
L["Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."] = "Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."
L["Hold SHIFT while dragging to scale the window instead."] = "Hold SHIFT while dragging to scale the window instead."
L["Hold shift to move the items to the parent group instead of removing them."] = "Hold shift to move the items to the parent group instead of removing them."
L["Hr"] = "Hr"
L["Hrs"] = "Hrs"
L["If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."] = "If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."
L["If you have multiple profiles set up with operations, enabling this will cause all but the current profile's operations to be irreversibly lost."] = "Si tienes múltiples perfiles configurados con operaciones, activando esto provocará que las operaciones de todos los perfiles excepto el actual se pierdan irreversiblemente."
L["Ignore Auctions Below Min"] = "Ignore Auctions Below Min"
L["Ignore Characters"] = "Ignorar Personaje"
L["Ignore Guilds"] = "Ignorar Hermandades"
L["Ignore auctions by duration"] = "Ignore auctions by duration"
L["Ignore operation on characters"] = "Ignore operation on characters"
L["Ignore operation on faction-realms"] = "Ignore operation on faction-realms"
L["Ignored Cooldowns"] = "Ignored Cooldowns"
L["Ignored Items"] = "Objetos ignorados"
L["Import"] = "Importar"
L["Import Groups & Operations"] = "Import Groups & Operations"
L["Import String"] = "Import String"
L["Import Summary"] = "Import Summary"
L["Import Theme"] = "Import Theme"
L["Import group"] = "Importar grupo"
L["Imported Group"] = "Imported Group"
L["Imported group (%s) with %d items, %d operations, and %d custom sources."] = "Imported group (%s) with %d items, %d operations, and %d custom sources."
L["In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."] = "In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."
L["Inbox Settings"] = "Inbox Settings"
L["Include operations?"] = "Include operations?"
L["Include soulbound items"] = "Include soulbound items"
L["Information"] = "Información"
L["Invalid Quantity"] = "Calidad inválida."
L["Invalid custom price source for %s. %s"] = "Invalid custom price source for %s. %s"
L["Invalid custom price."] = "Precio personalizado no válido"
L["Invalid group name."] = "Nombre de grupo invalido."
L["Invalid numeric value."] = "Valor numérico no válido."
L["Invalid operation name."] = "Nombre de operacion invalido."
L["Invalid player name."] = "Nombre de jugador no válido."
L["Invalid price."] = "Precio inválido."
L["Invalid search filter (%s)."] = "Invalid search filter (%s)."
L["Invalid search term."] = "Invalid search term."
L["Invalid search term. Cannot filter by price here."] = "Invalid search term. Cannot filter by price here."
L["Invalid seller data returned by server."] = "Invalid seller data returned by server."
L["Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."] = "Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."
L["Inventory"] = "Inventario"
L["Inventory / Gold Graph"] = "Inventory / Gold Graph"
L["Inventory Options"] = "Opciones de inventario"
L["It appears that you've manually copied your saved variables between accounts which will cause TSM's automatic sync'ing to not work. You'll need to undo this, and/or delete the TradeSkillMaster saved variables files on both accounts (with WoW closed) in order to fix this."] = "It appears that you've manually copied your saved variables between accounts which will cause TSM's automatic sync'ing to not work. You'll need to undo this, and/or delete the TradeSkillMaster saved variables files on both accounts (with WoW closed) in order to fix this."
L["Item"] = "Objeto"
L["Item Class"] = "Clase de objeto"
L["Item Level"] = "Nivel de Objeto"
L["Item Level Range"] = "Item Level Range"
L["Item Name"] = "Nombre de Objeto"
L["Item Quality"] = "Calidad de objeto"
L["Item Selection"] = "Selección de objeto"
L["Item Slot"] = "Item Slot"
L["Item Subclass"] = "Subclase de Objeto"
L["Item Value"] = "Item Value"
L["Item/Group is invalid (see chat)."] = "Objeto/Grupo es inválido (mira el chat)."
L["Items"] = "Objetos"
L["Items Using"] = "Items Using"
L["Keep in bags quantity"] = "Keep in bags quantity"
L["Keep in bank quantity"] = "Keep in bank quantity"
L["Keep quantity"] = "Keep quantity"
L["Keep this amount"] = "Keep this amount"
L["Keeping %d."] = "Keeping %d."
L["Keeping undercut auctions posted."] = "Keeping undercut auctions posted."
L["LEAST GROUPS"] = "LEAST GROUPS"
L["LEAST ITEMS"] = "LEAST ITEMS"
L["LOW"] = "MINIMO"
L["Last 14 Days"] = "Últimos 14 días"
L["Last 3 Days"] = "Últimos 3 días"
L["Last 30 Days"] = "Últimos 30 días"
L["Last 60 Days"] = "Últimos 60 días"
L["Last 7 Days"] = "Últimos 7 días"
L["Last Purchased"] = "Última compra"
L["Last Sold"] = "Última venta"
L["Ledger"] = "Contabilidad"
L["Level Up"] = "Subida de Nivel"
L["Limit"] = "Límite"
L["Link to Another Operation"] = "Link to Another Operation"
L["Lock Column Width"] = "Bloquear Ancho de Columna"
L["Lock task list's background"] = "Lock task list's background"
L["Looks like TradeSkillMaster has encountered an error. Please help the author fix this error by following the instructions shown."] = "Parece que TradeSkillMaster ha encontrado un error. Por favor, ayuda el autor solucionar este error, siguiendo las instrucciones que se muestran."
L["Loop detected in the following custom price:"] = "bucle detectado en el siguiente precio personalizado:"
L["Lowest auction by whitelisted player."] = "Lowest auction by whitelisted player."
L["MAX"] = "MAX"
L["MOST GROUPS"] = "MOST GROUPS"
L["MOST ITEMS"] = "MOST ITEMS"
L["MOVE"] = "MOVER"
L["MOVING"] = "MOVIENDO"
L["Macro Setup"] = "Configuración de macro."
L["Macro created and scroll wheel bound!"] = "¡Macro creada y rueda de desplazamiento enlazada!"
L["Macros"] = "Macros"
L["Mail"] = "Correo"
L["Mail Disenchantables"] = "Enviar Desencantables"
L["Mail Selected Groups"] = "Enviar los grupos seleccionados"
L["Mail Selected Groups (Auto Resend)"] = "Enviar los grupos seleccionados (Reenvío automático)"
L["Mail Selected Groups (Dry Run + Auto Resend)"] = "Enviar los grupos seleccionados (Ejecución en Seco + Reenvío automático)"
L["Mail Selected Groups (Dry Run)"] = "Enviar los grupos seleccionados (Ejecución en Seco)"
L["Mail disenchantables max quality"] = "Calidad máx. de desencantables a enviar"
L["Mail to %s"] = "Enviar mensaje a %s"
L["Mailing"] = "Envío de mensajes"
L["Mailing all to %s."] = "Enviando todo a %s."
L["Mailing operation"] = "Mailing operation"
L["Mailing operations control mailing to other characters."] = "Mailing operations control mailing to other characters."
L["Mailing up to %d to %s."] = "Enviando hasta %d a %s"
L["Make Cash On Delivery?"] = "¿Convertir en Pago Contra Reembolso?"
L["Make Operations Global?"] = "Make Operations Global?"
L["Management Options"] = "Opciones de Manejo"
L["Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."] = "Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."
L["Many commonly-used actions in TSM can be added to a macro and bound to your scroll wheel. Use the options below to setup this macro and scroll wheel binding."] = "Many commonly-used actions in TSM can be added to a macro and bound to your scroll wheel. Use the options below to setup this macro and scroll wheel binding."
L["Map Ping"] = "Ping en Mapa"
L["Market Value"] = "Valor del Mercado"
L["Market Value Price Source"] = "Market Value Price Source"
L["Market value"] = "Market value"
L["Market value and trend"] = "Market value and trend"
L["Market value price source"] = "Market value price source"
L["Mat Price"] = "Mat Price"
L["Mat cost"] = "Mat cost"
L["Match stack size"] = "Match stack size"
L["Match whitelisted players"] = "Match whitelisted players"
L["Material Cost"] = "Material Cost"
L["Materials"] = "Materiales"
L["Materials to Gather"] = "Materials to Gather"
L["Max"] = "Max"
L["Max Buy Price"] = "Max Buy Price"
L["Max Price"] = "Max Price"
L["Max Sell Price"] = "Max Sell Price"
L["Max Shopping Price"] = "Max Shopping Price"
L["Max destroy value (Enter '0c' to disable)"] = "Max destroy value (Enter '0c' to disable)"
L["Max expires to bank"] = "Max expires to bank"
L["Max market value (Enter '0c' to disable)"] = "Max market value (Enter '0c' to disable)"
L["Max quantity"] = "Max quantity"
L["Max shopping price"] = "Max shopping price"
L["Max sniper price"] = "Max sniper price"
L["Maximum Quantity to Buy"] = "Cantidad Máxima a Comprar"
L["Maximum amount already posted."] = "Maximum amount already posted."
L["Maximum auction price"] = "Maximum auction price"
L["Maximum disenchant level"] = "Maximum disenchant level"
L["Maximum disenchant quality"] = "Maximum disenchant quality"
L["Maximum disenchant search percent"] = "Maximum disenchant search percent"
L["Maximum price"] = "Maximum price"
L["Maximum restock quantity"] = "Maximum restock quantity"
L["Midnight"] = "Midnight"
L["Mill"] = "Mill"
L["Mill Value"] = "Mill Value"
L["Min"] = "Min"
L["Min 0 - Max 20"] = "Min 0 - Max 20"
L["Min 0.5 - Max 10"] = "Min 0.5 - Max 10"
L["Min Buy Price"] = "Precio mínimo de compra"
L["Min Buyout"] = "Compra Mínima"
L["Min Sell Price"] = "Min Sell Price"
L["Min buyout"] = "Compra mínima"
L["Min number of expires"] = "Min number of expires"
L["Min profit amount"] = "Min profit amount"
L["Min/Normal/Max Prices"] = "Min/Normal/Max Precios"
L["Min/Normal/Max price"] = "Min/Normal/Max precio"
L["Minimum Rarity"] = "Rareza Mínima"
L["Minimum disenchant level"] = "Nivel de desencantación mínimo"
L["Minimum price"] = "Precio mínimo"
L["Minimum restock quantity"] = "Minimum restock quantity"
L["Missing Materials"] = "Missing Materials"
L["Modifiers"] = "Modifiers"
L["Money Frame Open"] = "Marco de dinero abierto"
L["Money Transfer"] = "Money Transfer"
L["Move %d already grouped items?"] = "Move %d already grouped items?"
L["Move %d |4Item:Items"] = "Move %d |4Item:Items"
L["Move Item"] = "Mover objeto"
L["Move Quantity Options"] = "Move Quantity Options"
L["Move all to Bags"] = "Mover todo al inventario"
L["Move to Parent Group"] = "Mover al grupo principal"
L["Move to bags"] = "Mover a las bolsas"
L["Move to bank"] = "Mover al banco"
L["Moving"] = "Moviendo"
L["Multiple Items"] = "Multiple Items"
L["Must be between %d and %s."] = "Must be between %d and %s."
L["My Auctions"] = "Mis Subastas"
L["My Auctions %s button"] = "My Auctions %s button"
L["NEED MATS"] = "NEED MATS"
L["NO ITEMS"] = "NO ITEMS"
L["NOT OPEN"] = "NOT OPEN"
L["NOTE: The import contained %d invalid items which were ignored."] = "NOTE: The import contained %d invalid items which were ignored."
L["NOTE: The import contained %d operations with at least one invalid setting which was reset."] = "NOTE: The import contained %d operations with at least one invalid setting which was reset."
L["NPC"] = "NPC"
L["Name"] = "Nombre"
L["New Group"] = "Nuevo grupo"
L["New Operation"] = "Nueva Operación"
L["News & Information"] = "Noticias e Información"
L["No Attachments"] = "No hay adjuntos"
L["No AuctionDB Realm Data"] = "No hay BD de Subasta de Reino"
L["No AuctionDB Region Data"] = "No hay BD de Subasta de Región"
L["No Characters"] = "No Characters"
L["No Faction-Realms"] = "No Faction-Realms"
L["No Guilds"] = "Ninguna Hermandad"
L["No Materials to Gather"] = "No Materials to Gather"
L["No Operation Selected"] = "No ha Seleccionado una Operación"
L["No Players"] = "No Players"
L["No Profession Opened"] = "No Profession Opened"
L["No Professions"] = "No Professions"
L["No Rarities"] = "No Rarities"
L["No Sound"] = "Sin sonido"
L["No Sources"] = "No Sources"
L["No Types"] = "No Types"
L["No group selected"] = "No ha seleccionado un grupo"
L["No item specified. Usage: /tsm restock_help [ITEM_LINK]"] = "No item specified. Usage: /tsm restock_help [ITEM_LINK]"
L["No posting."] = "No posting."
L["No profile specified. Possible profiles: '%s'"] = "Sin perfil especificado. Posibles perfiles: '%s'"
L["No recent AuctionDB scan data found."] = "No se encontró BD de Subasta reciente."
L["No recipe selected"] = "No recipe selected"
L["No value was returned by the custom price for the specified item."] = "No value was returned by the custom price for the specified item."
L["No, cancel"] = "No, cancel"
L["None"] = "Ninguno"
L["None (Always Show)"] = "Ninguno (Mostrar siempre)"
L["None Selected"] = "Sin Seleccion"
L["Nongroup to bank"] = "Nongroup to bank"
L["Normal price"] = "Precio normal"
L["Not Connected"] = "No conectado"
L["Not Enough Money"] = "Not Enough Money"
L["Not Scanned"] = "Not Scanned"
L["Not canceling auction at reset price."] = "Not canceling auction at reset price."
L["Not canceling auction below min price."] = "Not canceling auction below min price."
L["Not canceling."] = "Not canceling."
L["Not enough items in bags."] = "Not enough items in bags."
L["Not enough money to cancel."] = "Not enough money to cancel."
L["Nothing to move."] = "Nothing to move."
L["Nothing to send."] = "Nothing to send."
L["Number Owned"] = "Number Owned"
L["Number of days"] = "Number of days"
L["OPEN"] = "ABRIR"
L["Offline"] = "Desconectado"
L["On Cooldown for %s"] = "On Cooldown for %s"
L["Only show craftable"] = "Only show craftable"
L["Only show items with disenchant values above this price"] = "Only show items with disenchant values above this price"
L["Only show sold auctions"] = "Mostrar solo subastas vendidas"
L["Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."] = "Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."
L["Open All Mail"] = "Abrir todos los mensajes"
L["Open All Mail Without Money"] = "Abrir todos los mensajes sin dinero"
L["Open Mail"] = "Abrir correo"
L["Open Mail Without Money"] = "Abrir correo sin dinero"
L["Open Task List"] = "Abrir Lista de Tareas"
L["Open mail complete sound"] = "Sonido al abrir todos los mensajes"
L["Opens the Destroying frame if there's stuff in your bags to be destroyed."] = "Opens the Destroying frame if there's stuff in your bags to be destroyed."
L["Operation"] = "Operación"
L["Operations"] = "Operaciones"
L["Options specific to Sniper are below."] = "Options specific to Sniper are below."
L["Order Confirmation"] = "Order Confirmation"
L["Orgrimmar"] = "Orgrimmar"
L["Oribos Exchange Realm Price"] = "Oribos Exchange Realm Price"
L["Oribos Exchange Region Price"] = "Oribos Exchange Region Price"
L["Other"] = "Otro"
L["Other Character"] = "Otro personaje"
L["Override Parent Operations"] = "Override Parent Operations"
L["Override default craft value"] = "Override default craft value"
L["PROFIT"] = "GANANCIA"
L["Parent Items"] = "Objetos Padre"
L["Pausing Scan..."] = "Pausing Scan..."
L["Per Item"] = "Por Objeto"
L["Per Stack"] = "Per Stack"
L["Performing a dry-run of your Mailing operations for the selected groups."] = "Ejecutando una ejecución en seco de tus operaciones de envío para los grupos seleccionados."
L["Player Gold"] = "Oro del Personaje"
L["Player Invite Accept"] = "Aceptar invitación de jugador."
L["Post"] = "Publicar"
L["Post / Cancel"] = "Post / Cancel"
L["Post Auction"] = "Post Auction"
L["Post Items from Bags"] = "Publicar Objetos desde las Bolsas"
L["Post Quantity"] = "Post Quantity"
L["Post Scan"] = "Post Scan"
L["Post Selected"] = "Publicar Selección"
L["Post at Maximum Price"] = "Post at Maximum Price"
L["Post at Minimum Price"] = "Post at Minimum Price"
L["Post at Normal Price"] = "Post at Normal Price"
L["Post cap"] = "Post cap"
L["Post cap to bags"] = "Post cap to bags"
L["Post from Shopping Scan"] = "Post from Shopping Scan"
L["Postage"] = "Franqueo"
L["Posted at whitelisted player's price."] = "Posted at whitelisted player's price."
L["Posted:"] = "Posted:"
L["Posting"] = "Publicación"
L["Posting %d / %d"] = "Posting %d / %d"
L["Posting %d items for %s hours."] = "Posting %d items for %s hours."
L["Posting %d stack(s) of %d for %s hours."] = "Posting %d stack(s) of %d for %s hours."
L["Posting Options"] = "Posting Options"
L["Posting Price"] = "Posting Price"
L["Posting at normal price."] = "Posting at normal price."
L["Posting at whitelisted player's price."] = "Posting at whitelisted player's price."
L["Posting at your current price."] = "Posting at your current price."
L["Posting disabled."] = "Posting disabled."
L["Posts"] = "Posts"
L["Potential"] = "Potencial"
L["Prepare Bid"] = "Prepare Bid"
L["Prepare Buy"] = "Prepare Buy"
L["Preparing..."] = "Preparing..."
L["Prevent closing the Auction House with the esc key"] = "Prevenir cerrar la ventana de la Casa de Subastas con la tecla Esc"
L["Primary"] = "Primary"
L["Primary Alt"] = "Primary Alt"
L["Prints out the available price sources for use in custom prices"] = "Prints out the available price sources for use in custom prices"
L["Prints out the version numbers of all installed modules"] = "Prints out the version numbers of all installed modules"
L["Prints the slash command help listing"] = "Prints the slash command help listing"
L["Profession"] = "Profesión"
L["Profession Info"] = "Profession Info"
L["Professions Used In"] = "Professions Used In"
L["Profile changed to '%s'."] = "Perfil cambiado a '%s'."
L["Profiles"] = "Perfiles"
L["Profit"] = "Profit"
L["Profit (Total)"] = "Profit (Total)"
L["Prospect"] = "Prospect"
L["Prospect Value"] = "Prospect Value"
L["Purchase"] = "Comprar"
L["Purchase / Sale Info"] = "Purchase / Sale Info"
L["Purchase Data"] = "Purchase Data"
L["Purchase Item"] = "Comprar Objeto"
L["Purchase information"] = "Purchase information"
L["Purchased (Min/Avg/Max Price)"] = "Purchased (Min/Avg/Max Price)"
L["Purchased (Total Price)"] = "Purchased (Total Price)"
L["Purchases"] = "Compras"
L["Purchasing Auction"] = "Purchasing Auction"
L["Puts items matching the item or partial text entered into the bank or guild bank."] = "Puts items matching the item or partial text entered into the bank or guild bank."
L["Qty"] = "Ctd"
L["Quantity"] = "Cantidad"
L["Quantity Purchased:"] = "Quantity Purchased:"
L["Quantity Sold:"] = "Quantity Sold:"
L["Quantity to move"] = "Quantity to move"
L["Quest Added"] = "Misión Agregada"
L["Quest Completed"] = "Misión Completada"
L["Quest Objectives Complete"] = "Objetivos de misión completados."
L["Queue"] = "Queue"
L["Queue (%d)"] = "Queue (%d)"
L["Queue Summary"] = "Queue Summary"
L["Quickly mail all excess disenchantable items to a character"] = "Enviar rápidamente el exceso de objetos desencantables a un personaje"
L["Quickly mail all excess gold (limited to a certain amount) to a character"] = "Envía rápidamente el exceso de oro (limitado a cierta cantidad) a un personaje"
L["Raid Warning"] = "Alerta de Banda"
L["Rank %d"] = "Rank %d"
L["Read More"] = "Seguir leyendo"
L["Ready Check"] = "Comprobación de listo"
L["Ready to Cancel"] = "Listo para Cancelar"
L["Reagent Quality"] = "Reagent Quality"
L["Recent"] = "Recent"
L["Recent Scans"] = "Escaneos Recientes"
L["Recent Searches"] = "Búsquedas Recientes"
L["Recent Value"] = "Recent Value"
L["Recent value"] = "Recent value"
L["Recipe Name"] = "Recipe Name"
L["Recipient"] = "Destinatario"
L["Region Avg Daily Sold"] = "Venta Promedio Diaria de la Región"
L["Region Historical Price"] = "Region Historical Price"
L["Region Market Value Avg"] = "Valor Promedio en el Mercado de la Región"
L["Region Sale Avg"] = "Valor Promedio de Venta de la Región"
L["Region Sale Rate"] = "Tasa de Venta Regional"
L["Region avg daily sold"] = "Venta promedio diaria de la región"
L["Region historical price"] = "Region historical price"
L["Region market value"] = "Region market value"
L["Region market value and trend"] = "Region market value and trend"
L["Region sale avg"] = "Valor promedio de venta de la región"
L["Region sale rate"] = "Region sale rate"
L["Reload"] = "Reload"
L["Reload UI (%02d)"] = "Recargar UI (%02d)"
L["Reload UI (%d)"] = "Recargar UI (%d)"
L["Remove"] = "Remove"
L["Remove %d |4Item:Items"] = "Remove %d |4Item:Items"
L["Remove Data Older Than (Days)"] = "Remove Data Older Than (Days)"
L["Remove this account sync and all synced data from this account"] = "Remove this account sync and all synced data from this account"
L["Removed a total of %s old records."] = "Removed a total of %s old records."
L["Removed custom price source (%s) which has an invalid name."] = "Removed custom price source (%s) which has an invalid name."
L["Rename"] = "Renombrar"
L["Rename Profile"] = "Renombrar perfil"
L["Rename Search"] = "Rename Search"
L["Rename the profile"] = "Renombra el perfil"
L["Rename this group"] = "Rename this group"
L["Repair"] = "Reparar"
L["Repair Bill"] = "Costos de reparación"
L["Repair from Guild Bank"] = "Reparar desde Banco de Hermandad"
L["Replace %d existing operations and %d existing custom sources?"] = "Replace %d existing operations and %d existing custom sources?"
L["Replace %d existing operations?"] = "Replace %d existing operations?"
L["Reply"] = "Responder"
L["Report Spam"] = "Report Spam"
L["Reports"] = "Reports"
L["Repost threshold"] = "Repost threshold"
L["Required Level"] = "Required Level"
L["Required Level Range"] = "Required Level Range"
L["Resale"] = "Reventas"
L["Rescan"] = "Rescan"
L["Reset"] = "Reset"
L["Reset All Filters"] = "Restablecer Todos los Filtros"
L["Reset Filters"] = "Restablecer Filtros"
L["Reset Operation?"] = "¿Restablecer Operación?"
L["Reset Profile?"] = "¿Restablecer Perfil?"
L["Reset Table"] = "Restablecer Tabla"
L["Reset Zoom"] = "Restablecer Zoom"
L["Reset the current profile to default settings"] = "Restablece el perfil actual a los ajustes por defecto"
L["Reset to Default"] = "Restablecer por Defecto"
L["Resetting the operation will return all inputs back to default and cannot be unddone. Click confirm to reset."] = "Resetting the operation will return all inputs back to default and cannot be unddone. Click confirm to reset."
L["Restart"] = "Restart"
L["Restart delay (minutes)"] = "Restart delay (minutes)"
L["Restock Groups"] = "Restock Groups"
L["Restock Options"] = "Restock Options"
L["Restock TSM Groups"] = "Restock TSM Groups"
L["Restock bags"] = "Restock bags"
L["Restock help for %s: %s"] = "Restock help for %s: %s"
L["Restock quantity"] = "Restock quantity"
L["Restock target to max quantity"] = "Restock target to max quantity"
L["Restocking to %d."] = "Restocking to %d."
L["Restocking with a min profit."] = "Restocking with a min profit."
L["Restocking with no min profit."] = "Restocking with no min profit."
L["Restore bags"] = "Restore bags"
L["Resuming Scan..."] = "Resuming Scan..."
L["Retail Region-Wide Tracking"] = "Retail Region-Wide Tracking"
L["Retrying %d auction(s) which failed."] = "Retrying %d auction(s) which failed."
L["Revenue"] = "Ingresos"
L["Right-Click to reset the window size, scale, and position to their defaults."] = "Right-Click to reset the window size, scale, and position to their defaults."
L["Run Advanced Item Search"] = "Run Advanced Item Search"
L["Run Bid Sniper"] = "Run Bid Sniper"
L["Run Buyout Sniper"] = "Run Buyout Sniper"
L["Run Cancel Scan"] = "Run Cancel Scan"
L["Run Post Scan"] = "Run Post Scan"
L["Run Shopping Scan"] = "Ejecutar Escaneo de Compras"
L["Running Sniper Scan"] = "Running Sniper Scan"
L["SALES"] = "VENTAS"
L["SCAN ALL"] = "SCAN ALL"
L["SCANNING"] = "ESCANEANDO"
L["SENDING"] = "SENDING"
L["SHIFT"] = "SHIFT"
L["SOURCE %d"] = "FUENTE %d"
L["Sale"] = "Sale"
L["Sale Data"] = "Sale Data"
L["Sale Price"] = "Precio de venta"
L["Sale Rate"] = "Tasa de Venta"
L["Sale information"] = "Sale information"
L["Sale rate"] = "Sale rate"
L["Sales"] = "Ventas"
L["Salvage"] = "Salvage"
L["Save & Close"] = "Save & Close"
L["Saved"] = "Saved"
L["Scan"] = "Escanear"
L["Scan Paused"] = "Scan Paused"
L["Scan complete sound"] = "Scan complete sound"
L["Scan was slowed down by %s seconds by other AH addons (%s seconds by %s)."] = "Scan was slowed down by %s seconds by other AH addons (%s seconds by %s)."
L["Scanning"] = "Escaneando"
L["Scanning (%d Items)"] = "Escaneando (%d Objetos)"
L["Scroll Wheel Options"] = "Scroll Wheel Options"
L["Scroll wheel direction"] = "Scroll wheel direction"
L["Search"] = "Buscar"
L["Search %s operations"] = "Buscar %s operaciones"
L["Search Bags"] = "Buscar en las bolsas"
L["Search Groups"] = "Buscar en grupos"
L["Search Operations"] = "Buscar Operaciones"
L["Search Patterns"] = "Search Patterns"
L["Search Results"] = "Resultados de búsqueda"
L["Search Vendor"] = "Buscar en el vendedor"
L["Search items"] = "Buscar objetos"
L["Search items in group"] = "Buscar objetos en grupo"
L["Search items in mailbox"] = "Buscar objetos en bandeja de entrada"
L["Search the auction house"] = "Buscar en la casa de subastas"
L["Select / Deselect All Groups"] = "Seleccionar / Deseleccionar todos los grupos"
L["Select / Deselect All Items"] = "Seleccionar / Deseleccionar todos los objetos"
L["Select / Deselect All Results"] = "Seleccionar / Deseleccionar todos los resultados"
L["Select Action"] = "Select Action"
L["Select All"] = "Marcar todo"
L["Select Auction to Cancel"] = "Seleccione una Subasta para Cancelar"
L["Select Crafted Item Quality"] = "Select Crafted Item Quality"
L["Select Group"] = "Seleccionar grupo"
L["Select Items to Attach"] = "Selecciona objetos a adjuntar"
L["Select a Source"] = "Select a Source"
L["Select an Auction to Buy"] = "Select an Auction to Buy"
L["Select crafter"] = "Select crafter"
L["Select included subgroups"] = "Select included subgroups"
L["Select professions"] = "Select professions"
L["Selected Items (%d)"] = "Selected Items (%d)"
L["Sell"] = "Vender"
L["Sell All"] = "Vender Todo"
L["Sell BoEs"] = "Vender BoEs"
L["Sell Groups"] = "Vender Grupos"
L["Sell Options"] = "Sell Options"
L["Sell Trash"] = "Vender Basura"
L["Sell soulbound items"] = "Sell soulbound items"
L["Sell to Vendor"] = "Vender al vendedor"
L["Seller"] = "Vendedor"
L["Selling soulbound items."] = "Selling soulbound items."
L["Send"] = "Enviar"
L["Send Disenchantables"] = "Enviar desencantables"
L["Send Excess Gold to Banker"] = "Enviar exceso de oro a banquero"
L["Send Gold"] = "Enviar Oro"
L["Send Mail"] = "Enviar Mensaje"
L["Send Money"] = "Enviar Dinero"
L["Send grouped items individually"] = "Send grouped items individually"
L["Send your active profile to this synced account"] = "Envía tu perfil activo a esta cuenta sincronizada"
L["Sender"] = "Sender"
L["Sending %s to %s"] = "Sending %s to %s"
L["Sending %s to %s with a COD of %s"] = "Sending %s to %s with a COD of %s"
L["Sending Settings"] = "Sending Settings"
L["Sending your '%s' profile to %s. Please keep both characters online until this completes. This will take approximately: %s"] = "Enviando tu perfil '%s' a %s. Por favor mantengan ambos personajes en línea hasta que esto termine. Esto tomará aproximadamente: %s"
L["Sending..."] = "Sending..."
L["Set bid as percentage of buyout"] = "Set bid as percentage of buyout"
L["Set how items are moved out of the bank."] = "Set how items are moved out of the bank."
L["Set how items are restocked from the bank."] = "Set how items are restocked from the bank."
L["Set keep in bags quantity"] = "Set keep in bags quantity"
L["Set keep in bank quantity"] = "Set keep in bank quantity"
L["Set max quantity"] = "Set max quantity"
L["Set min profit"] = "Set min profit"
L["Set move quantity"] = "Set move quantity"
L["Set stack size"] = "Set stack size"
L["Set stack size for restock"] = "Set stack size for restock"
L["Set what is bought from a vendor."] = "Set what is bought from a vendor."
L["Set what is sold to a vendor."] = "Set what is sold to a vendor."
L["Set what items are shown during a Shopping scan."] = "Set what items are shown during a Shopping scan."
L["Set what items are shown during a Sniper scan."] = "Set what items are shown during a Sniper scan."
L["Set your active profile or create a new one."] = "Establece tu perfil activo o crea uno nuevo"
L["Settings"] = "Ajustes"
L["Setup various sounds that play when doing Auctioning scans."] = "Setup various sounds that play when doing Auctioning scans."
L["Share operations between all profiles"] = "Share operations between all profiles"
L["Shopping"] = "Shopping"
L["Shopping %s button"] = "Shopping %s button"
L["Shopping Operation Max Price"] = "Shopping Operation Max Price"
L["Shopping for auctions including those above the max price."] = "Shopping for auctions including those above the max price."
L["Shopping for auctions with a max price set."] = "Shopping for auctions with a max price set."
L["Shopping operation"] = "Shopping operation"
L["Shopping operations control buyout from the AH."] = "Shopping operations control buyout from the AH."
L["Shortfall to bags"] = "Shortfall to bags"
L["Show auctions above max price"] = "Show auctions above max price"
L["Show confirmation alert if buyout is above the alert price"] = "Show confirmation alert if buyout is above the alert price"
L["Show destroying frame automatically"] = "Show destroying frame automatically"
L["Show on modifier"] = "Show on modifier"
L["Show only auctions with bids"] = "Mostrar solo subastas con pujas"
L["Show results as:"] = "Show results as:"
L["Show total gold in header"] = "Show total gold in header"
L["Show ungrouped items as:"] = "Show ungrouped items as:"
L["Showing %s Mail"] = "Listando %s mensaje(s)"
L["Showing %s of %d Mail"] = "Listando %s de %d mensaje(s)"
L["Showing %s of %d Mails"] = "Listando %s de %d mensaje(s)"
L["Showing all %s Mails"] = "Listando todos los %s mensaje(s)"
L["Simple convert tooltip"] = "Simple convert tooltip"
L["Simple destroy tooltip"] = "Simple destroy tooltip"
L["Simple inventory"] = "Simple inventory"
L["Skip"] = "Omitir"
L["Skipped:"] = "Omitido:"
L["Skipped: No assigned operation"] = "Omitido: Sin operación asignada"
L["Slash Commands:"] = "Comandos de Diagonal:"
L["Smart Avg Buy Price"] = "Smart Avg Buy Price"
L["Sniper"] = "Sniper"
L["Sniper %s button"] = "Sniper %s button"
L["Sniper Below Price"] = "Sniper Below Price"
L["Sniper Operation Below Price"] = "Sniper Operation Below Price"
L["Sniper Options"] = "Sniper Options"
L["Sniper operation"] = "Sniper operation"
L["Sniper operations control sniping from the AH."] = "Sniper operations control sniping from the AH."
L["Sniping items below a max price"] = "Sniping items below a max price"
L["Sold"] = "Vendido"
L["Sold %d of %s to %s for %s"] = "Sold %d of %s to %s for %s"
L["Sold %s worth of items."] = "Sold %s worth of items."
L["Sold (Min/Avg/Max Price)"] = "Vendido (Min/Prom/Precio Max)"
L["Sold (Total Price)"] = "Vendido (Precio Total)"
L["Sold [%s]x%d for %s to %s"] = "Vendido [%s]x%d por %s a %s"
L["Sold for:"] = "Vendido por:"
L["Some general Accounting options are below."] = "Some general Accounting options are below."
L["Some general Auctioning options are below."] = "Some general Auctioning options are below."
L["Some general Browse/Sniper options are below."] = "Some general Browse/Sniper options are below."
L["Some general TSM options are below."] = "Some general TSM options are below."
L["Some general appearance options are below."] = "Some general appearance options are below."
L["Some general options for the TSM tooltip information are below."] = "Some general options for the TSM tooltip information are below."
L["Some options for the Disenchant Search are below."] = "Some options for the Disenchant Search are below."
L["Source"] = "Fuente"
L["Sources"] = "Fuentes"
L["Sources to include for restock"] = "Sources to include for restock"
L["Specific Item"] = "Objeto Específico"
L["Stack"] = "Stack"
L["Stack / Quantity"] = "Stack / Quantity"
L["Stack size"] = "Stack size"
L["Stack size multiple"] = "Stack size multiple"
L["Stack(s)"] = "Stack(s)"
L["Start either a 'Buyout' or 'Bid' sniper using the buttons above."] = "Start either a 'Buyout' or 'Bid' sniper using the buttons above."
L["Starting Scan..."] = "Starting Scan..."
L["Stormwind"] = "Ventormenta"
L["String"] = "String"
L["Subject"] = "Asunto"
L["Subject & Description added"] = "Asunto y Descripción agregados"
L["Successfully sent your '%s' profile to %s!"] = "¡Se envió exitosamente tu perfil '%s' a %s!"
L["Supported value range: %d - %d"] = "Supported value range: %d - %d"
L["Swamp of Sorrows"] = "Swamp of Sorrows"
L["Switch to %s"] = "Switch to %s"
L["Sync Setup Error: The specified player on the other account is not currently online."] = "Error de configuración de sincronización: el jugador especificado en la otra cuenta no está en línea."
L["Sync Setup Error: This character is already part of a known account."] = "Error de configuración de sincronización: este personaje ya es parte de una cuenta enlazada."
L["Sync Setup Error: You entered the name of the current character and not the character on the other account."] = "Error de configuración de sincronización: ingresó el nombre del personaje actual y no el personaje de la otra cuenta."
L["Sync Status"] = "Sync Status"
L["TOP PURCHASE"] = "MAYOR VENTA"
L["TOP SALE"] = "MAYOR COMPRA"
L["TSM %s: What's new"] = "TSM %s: What's new"
L["TSM Accounting"] = "TSM Accounting"
L["TSM AuctionDB"] = "TSM BD de Subasta"
L["TSM Auctioning"] = "TSM Auctioning"
L["TSM Crafting"] = "TSM Crafting"
L["TSM Desktop App Status (%s)"] = "Estado de TSM Desktop App (%s)"
L["TSM General Info"] = "TSM Información General"
L["TSM Shopping"] = "TSM Shopping"
L["TSM Sniper"] = "TSM Sniper"
L["TSM TASK LIST"] = "TSM TASK LIST"
L["TSM Version Info:"] = "Información de la versión de TSM:"
L["TSM can automatically sync data between multiple WoW accounts."] = "TSM can automatically sync data between multiple WoW accounts."
L["TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"] = "TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"
L["TSM doesn't currently have any AuctionDB pricing data for your realm. We recommend you download the TSM Desktop Application from %s to automatically update your AuctionDB data (and auto-backup your TSM settings)."] = "TSM actualmente no tiene precios de la BD de Subasta para tu reino. Te recomendamos descargar TSM Desktop Application desde %s para automáticamente actualizar tu BD de Subasta  (y hacer una copia de seguridad de tu configuración de TSM)."
L["TSM failed to scan some auctions. Please rerun the scan."] = "TSM failed to scan some auctions. Please rerun the scan."
L["TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."] = "TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."
L["TSM is missing important information from the TSM Desktop Application. Please ensure the TSM Desktop Application is running and is properly configured."] = "TSM is missing important information from the TSM Desktop Application. Please ensure the TSM Desktop Application is running and is properly configured."
L["TSM is not yet ready to establish a new sync connection. Please try again later."] = "TSM is not yet ready to establish a new sync connection. Please try again later."
L["TSM will not undercut any players you add to your whitelist."] = "TSM will not undercut any players you add to your whitelist."
L["TSM4"] = "TSM4"
L["Target character"] = "Target character"
L["Target shortfall to bags"] = "Target shortfall to bags"
L["Tasks Added to Task List"] = "Tasks Added to Task List"
L["Tells you why a specific item is not being restocked and added to the queue."] = "Tells you why a specific item is not being restocked and added to the queue."
L["Text (%s)"] = "Texto (%s)"
L["The '%s' function has an invalid number of arguments."] = "The '%s' function has an invalid number of arguments."
L["The '%s' item parameter was used outside of a custom source."] = "The '%s' item parameter was used outside of a custom source."
L["The 'Craft Value Method' did not return a value for this item."] = "The 'Craft Value Method' did not return a value for this item."
L["The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."] = "The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."
L["The AH does not support specifying a copper value (only gold and silver)."] = "The AH does not support specifying a copper value (only gold and silver)."
L["The Base Group contains all ungrouped items in the game. Use the search and filter controls to find items to add to other groups."] = "El Grupo Base contiene todos los objetos sin agrupar en el juego. Usa los controles de búsqueda y filtro para encontrar objetos que agregar a otros grupos."
L["The TradeSkillMaster_AppHelper addon is installed, but not enabled. TSM has enabled it and requires a reload."] = "The TradeSkillMaster_AppHelper addon is installed, but not enabled. TSM has enabled it and requires a reload."
L["The buyout price for %s would be above the maximum allowed price. Skipping this item."] = "The buyout price for %s would be above the maximum allowed price. Skipping this item."
L["The canlearn filter was ignored because the CanIMogIt addon was not found."] = "The canlearn filter was ignored because the CanIMogIt addon was not found."
L["The max quantity cannot be zero."] = "The max quantity cannot be zero."
L["The min profit did not evaluate to a valid value for this item."] = "The min profit did not evaluate to a valid value for this item."
L["The name portion of the search term must be at least 3 characters if present."] = "The name portion of the search term must be at least 3 characters if present."
L["The pasted value was not valid. Ensure you are pasting the entire import string."] = "The pasted value was not valid. Ensure you are pasting the entire import string."
L["The player \\\"%s\\\" is already on your whitelist."] = "The player \\\"%s\\\" is already on your whitelist."
L["The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."] = "The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."
L["The profit of this item (%s) is below the min profit (%s)."] = "The profit of this item (%s) is below the min profit (%s)."
L["The same filter was specified multiple times."] = "The same filter was specified multiple times."
L["The search term must be at least 3 characters."] = "The search term must be at least 3 characters."
L["The seller name of the lowest auction for %s was not given by the server. Skipping this item."] = "The seller name of the lowest auction for %s was not given by the server. Skipping this item."
L["The specified filter was empty."] = "The specified filter was empty."
L["The specified item is not supported for crafting searches."] = "The specified item is not supported for crafting searches."
L["The specified item is not supported for disenchant searches."] = "The specified item is not supported for disenchant searches."
L["The specified item was not found."] = "The specified item was not found."
L["The unlearned filter was ignored because the CanIMogIt addon was not found."] = "The unlearned filter was ignored because the CanIMogIt addon was not found."
L["The value must be greater than 0."] = "The value must be greater than 0."
L["The value must be greater than or equal of 0."] = "The value must be greater than or equal of 0."
L["The value was greater than the maximum allowed auction house price."] = "The value was greater than the maximum allowed auction house price."
L["Themes"] = "Themes"
L["There are unbalanced parentheses in this custom string."] = "There are unbalanced parentheses in this custom string."
L["There is currently no profession open, so cannot create profession groups."] = "There is currently no profession open, so cannot create profession groups."
L["There is no Crafting operation applied to this item's TSM group (%s)."] = "There is no Crafting operation applied to this item's TSM group (%s)."
L["This custom string is too complex for WoW to handle; use custom sources to simplify it."] = "This custom string is too complex for WoW to handle; use custom sources to simplify it."
L["This is not a valid profile name. Profile names must be at least one character long and may not contain '@' characters."] = "Este no es un nombre de perfil válido. Los nombres de perfil deben tener al menos un carácter y no contener caracteres '@'."
L["This item does not have a crafting cost. Check that all of its mats have mat prices."] = "This item does not have a crafting cost. Check that all of its mats have mat prices."
L["This item is not in a TSM group."] = "This item is not in a TSM group."
L["This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."] = "This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."
L["This operation is applied to the base group which includes every item not in another group."] = "This operation is applied to the base group which includes every item not in another group."
L["This price is above your confirmation alert threshold."] = "This price is above your confirmation alert threshold."
L["This price is above your material value."] = "This price is above your material value."
L["This profession is not open."] = "This profession is not open."
L["This record belongs to another account and can only be deleted on that account."] = "This record belongs to another account and can only be deleted on that account."
L["This will permanently delete the '%s' profile."] = "Esto eliminará el perfil '%s' permanentemente ."
L["This will reset all groups and operations (if not stored globally) to be wiped from '%s'."] = "This will reset all groups and operations (if not stored globally) to be wiped from '%s'."
L["Time"] = "Time"
L["Time Frame"] = "Periodo de Tiempo"
L["Tinker"] = "Tinker"
L["Toggles the TSM Banking UI if either the bank or guild bank is currently open."] = "Toggles the TSM Banking UI if either the bank or guild bank is currently open."
L["Toggles the TSM Crafting UI."] = "Toggles the TSM Crafting UI."
L["Toggles the TSM Task List UI"] = "Toggles the TSM Task List UI"
L["Toggles the main TSM window"] = "Toggles the main TSM window"
L["Tooltip Options"] = "Tooltip Options"
L["Tooltip Settings"] = "Tooltip Settings"
L["Tooltip price format"] = "Tooltip price format"
L["Top Buyers"] = "Top Buyers"
L["Top Item"] = "Mejor objeto"
L["Top Sellers"] = "Top Sellers"
L["Total"] = "Total"
L["Total Gold"] = "Oro total"
L["Total Gold Collected: %s"] = "Oro Total Recolectado: %s"
L["Total Gold Earned"] = "Total de oro ingresado"
L["Total Gold Spent"] = "Total de oro gastado"
L["Total Inventory Quantity"] = "Total Inventory Quantity"
L["Total Items"] = "Objetos Totales"
L["Total Postage"] = "Franqueo Total"
L["Total Price"] = "Total Price"
L["Total Prices:"] = "Total Prices:"
L["Total Profit"] = "Ganancia total"
L["Total Value"] = "Valor total"
L["Track Sales / Purchases via trade"] = "Track Sales / Purchases via trade"
L["Transform"] = "Transform"
L["Transform Value"] = "Transform Value"
L["Type"] = "Tipo"
L["Uncollected Only"] = "Uncollected Only"
L["Undercut amount"] = "Undercut amount"
L["Undercut by whitelisted player."] = "Undercut by whitelisted player."
L["Undercutting blacklisted player."] = "Undercutting blacklisted player."
L["Undercutting competition."] = "Undercutting competition."
L["Unexpected word ('%s') in custom string."] = "Unexpected word ('%s') in custom string."
L["Ungrouped Items"] = "Objetos Sin Grupo"
L["Ungrouped Items in Bags"] = "Objetos Sin Grupo en las Bolsas"
L["Unit Price"] = "Precio unitario"
L["Unknown Item"] = "Unknown Item"
L["Unknown word (%s)."] = "Unknown word (%s)."
L["Unlock Column Width"] = "Unlock Column Width"
L["Unwrap Gift"] = "Desenvolver el regalo"
L["Up"] = "Arriba"
L["Up to date"] = "Up to date"
L["Update existing macro"] = "Update existing macro"
L["Updating"] = "Actualizando"
L["Upgrades Only"] = "Upgrades Only"
L["Usable Only"] = "Solo utilizable"
L["Usage: /tsm price <Item Link> <Custom String>"] = "Usage: /tsm price <Item Link> <Custom String>"
L["Use the settings below to control which lines are shown in tooltips."] = "Use the settings below to control which lines are shown in tooltips."
L["Use this list to manage what cooldowns you'd like TSM to ignore from crafting."] = "Use this list to manage what cooldowns you'd like TSM to ignore from crafting."
L["Use this list to manage what items you'd like TSM to ignore from destroying."] = "Use this list to manage what items you'd like TSM to ignore from destroying."
L["Value"] = "Valor"
L["Value Price Source"] = "Fuente Valor de Venta"
L["Value must be between %d and %d."] = "Value must be between %d and %d."
L["Values"] = "Valores"
L["Vendor"] = "Vendedor"
L["Vendor Buy Price"] = "Vendor Buy Price"
L["Vendor Search"] = "Búsqueda de Vendedores"
L["Vendor Sell"] = "Precio de Venta"
L["Vendor Sell Price"] = "Precio de Venta al Vendedor"
L["Vendor Trade"] = "Vendor Trade"
L["Vendor Trade Value"] = "Vendor Trade Value"
L["Vendor buy price"] = "Vendor buy price"
L["Vendor sell price"] = "Precio de venta al vendedor"
L["Vendoring"] = "Venta"
L["Vendoring %s button"] = "Vendoring %s button"
L["Vendoring operation"] = "Operación de Venta"
L["Vendoring operations control selling to and buying from a vendor."] = "Las operaciones de Venta controlan el vender y comprar a un vendedor."
L["WARNING: The macro was too long, so was truncated to fit by WoW."] = "ADVERTENCIA: La macro era demasiado larga, por lo que WoW lo recorto para que cupiera."
L["WARNING: Your minimum price for %s is below its vendorsell price (with AH cut taken into account). Consider raising your minimum price, or vendoring the item."] = "ADVERTENCIA: Tu precio mínimo para %s está por debajo de su precio de venta (tomando en cuenta el depósito de la Casa de Subastas). Considera aumentar tu precio mínimo, o vender el objeto."
L["WOW UI"] = "WOW UI"
L["Warehousing"] = "Warehousing"
L["Warehousing operation"] = "Warehousing operation"
L["Warehousing operations control moving in and out of the bank."] = "Warehousing operations control moving in and out of the bank."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."
L["Warehousing will move a max of %d of each item in this group."] = "Warehousing will move a max of %d of each item in this group."
L["Warehousing will move a max of %d of each item in this group. Restock will maintain %d items in your bags."] = "Warehousing will move a max of %d of each item in this group. Restock will maintain %d items in your bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank."] = "Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."
L["Warehousing will move all of the items in this group."] = "Warehousing will move all of the items in this group."
L["Warehousing will move all of the items in this group. Restock will maintain %d items in your bags."] = "Warehousing will move all of the items in this group. Restock will maintain %d items in your bags."
L["When above maximum:"] = "When above maximum:"
L["When below minimum:"] = "When below minimum:"
L["Whitelist"] = "Whitelist"
L["Whitelisted characters"] = "Whitelisted characters"
L["Winamp"] = "Winamp"
L["Would send %s to %s"] = "Would send %s to %s"
L["Would send %s to %s with a COD of %s"] = "Would send %s to %s with a COD of %s"
L["Yes, I'm sure"] = "Yes, I'm sure"
L["Yes, I'm sure (%02d)"] = "Yes, I'm sure (%02d)"
L["You are not on one of the listed characters."] = "You are not on one of the listed characters."
L["You can clear old Accounting data for the current realm below to keep things running smoothly."] = "You can clear old Accounting data for the current realm below to keep things running smoothly."
L["You can import custom themes by pasting an import string into the box below."] = "You can import custom themes by pasting an import string into the box below."
L["You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"] = "You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"
L["You can now group pets by level, just like items."] = "You can now group pets by level, just like items."
L["You can use the export string below to share this custom theme with others."] = "You can use the export string below to share this custom theme with others."
L["You can use the export string below to share this group with others."] = "You can use the export string below to share this group with others."
L["You cannot use %s as part of this custom price."] = "No puede usar %s  como parte de este precio personalizado."
L["You do not need to add \\\"%s\\\", alts are whitelisted automatically."] = "You do not need to add \\\"%s\\\", alts are whitelisted automatically."
L["You don't know how to craft this item."] = "You don't know how to craft this item."
L["You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."] = "You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."
L["You must reload your UI for these settings to take effect. Reload now?"] = "Debe volver a cargar su Interfaz para que esta configuración surta efecto. Recargar ahora?"
L["You won an auction for %sx%d for %s"] = "Ganaste una subasta por %sx%d por %s"
L["You've been phased which has caused the AH to stop working due to a bug on Blizzard's end. Please close and reopen the AH and restart Sniper."] = "You've been phased which has caused the AH to stop working due to a bug on Blizzard's end. Please close and reopen the AH and restart Sniper."
L["You've been undercut."] = "Has sido socavado(a)."
L["Your Buyout"] = "Your Buyout"
L["Your auction has not been undercut."] = "Your auction has not been undercut."
L["Your auction of %s expired"] = "Your auction of %s expired"
L["Your auction of %s has sold for %s!"] = "¡Tu subasta de %s se ha vendido por %s!"
L["Your auction of %s has sold!"] = "Your auction of %s has sold!"
L["Your craft value method for '%s' was invalid so it has been returned to the default. Details: %s"] = "Your craft value method for '%s' was invalid so it has been returned to the default. Details: %s"
L["Your default craft value method was invalid so it has been returned to the default. Details: %s"] = "Your default craft value method was invalid so it has been returned to the default. Details: %s"
L["Your max restock (%s) is invalid for %s."] = "Your max restock (%s) is invalid for %s."
L["Your min restock (%s) is invalid for %s."] = "Your min restock (%s) is invalid for %s."
L["Your restock quantity is invalid. It must be between %d and %s."] = "Your restock quantity is invalid. It must be between %d and %s."
L["Your task list is currently empty."] = "Your task list is currently empty."
L["ilvl"] = "Nivel de objeto"
-- LOCALE STRINGS END HERE

Locale.SetTable(L)
