-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                          https://tradeskillmaster.com                          --
--    All Rights Reserved - Detailed license information included with addon.     --
-- ------------------------------------------------------------------------------ --

local TSM = select(2, ...) ---@type TSM
local Locale = TSM.Include("Locale")
if not Locale.ShouldLoad("koKR") then return end
local L = {}

-- LOCALE STRINGS START HERE
L["%d Characters"] = "%d 캐릭터"
L["%d Custom Sources"] = "%d 맞춤형 출처"
L["%d Faction-Realms"] = "%d 진영-서버"
L["%d Groups"] = "%d 그룹"
L["%d Groups Selected"] = "%d 그룹 선택됨"
L["%d Guilds"] = "%d 길드"
L["%d Items"] = "%d 아이템"
L["%d Operations"] = "%d 작업"
L["%d Players"] = "%d 캐릭터"
L["%d Professions"] = "%d 전문 기술"
L["%d Rarities"] = "%d 희귀"
L["%d Results"] = "%d 결과"
L["%d Selected"] = "%d 선택됨"
L["%d Sources"] = "%d 출처"
L["%d Sub-Groups"] = "%d하위 그룹"
L["%d Types"] = "%d 타입"
L["%d auctions"] = "%d 경매"
L["%d groups"] = "%d 그룹"
L["%d groups were created and %d items were added from the table."] = "%d 그룹이 생성되었고 %d 아이템이 표에서 추가되었습니다."
L["%d of %d"] = "%d 의 %d"
L["%d subgroups included"] = "%d 하위 그룹이 포함됨"
L["%d |4Group:Groups; Selected (%d |4Item:Items;)"] = "%d |4그룹:Groups; 선택됨 (%d |4아이템:Items;)"
L["%s %s Operations"] = "%s %s 작업"
L["%s (%s bags, %s bank, %s AH, %s mail)"] = "%s (%s 가방, %s 은행, %s 경매장, %s 우편)"
L["%s (%s player, %s alts, %s AH)"] = "%s (%s 플레이어, %s 부캐, %s 경매장)"
L["%s (%s player, %s alts, %s guild, %s AH)"] = "%s (%s 플레이어, %s 부캐, %s 길드, %s 경매장)"
L["%s (%s profit)"] = "%s (%s 이익)"
L["%s - %s has been reset to default values."] = "%s - %s이(가) 기본값으로 재설정됨"
L["%s Crafts"] = "%s 제작"
L["%s Items Bought"] = "%s 아이템 구매됨"
L["%s Items Cancelled"] = "%s 아이템 취소됨"
L["%s Items Expired"] = "%s 아이템 만료됨"
L["%s Items Resold"] = "%s 아이템 재판매됨"
L["%s Items Selected"] = "%s 아이템 선택됨"
L["%s Items Sold"] = "%s 아이템 판매됨"
L["%s Items Total"] = "전체 %s 아이템"
L["%s Operations"] = "%s 작업"
L["%s Posted Auctions"] = "%s건의 개시된 경매"
L["%s Posted Auctions (Filtered)"] = "%s건의 등록된 경매 (필터링됨)"
L["%s Sold Auctions"] = "%s건의 판매된 경매"
L["%s Sold Auctions (Filtered)"] = "%s건의 판매된 경매 (필터링됨)"
L["%s Total"] = "총 %s"
L["%s Total Profit"] = "%s 전체 이익"
L["%s ago"] = "%s 이전"
L["%s group is already up to date."] = "%s 그룹은 이미 최신 상태입니다."
L["%s group updated with %d items and %d materials."] = "%s 그룹이 %d 아이템과 %d 재료로 업데이트 되었습니다."
L["%s in guild vault"] = "%s 길드 은행"
L["%s is a valid custom price but %s is an invalid item."] = "%s은(는) 유효한 사용자 가격이지만 %s은(는) 유효하지 않은 아이템입니다."
L["%s is a valid custom price but did not give a value for %s."] = "%s은(는) 유효한 사용자 가격이지만 %s에 대한 가격은 없습니다."
L["%s is not a valid custom price and gave the following error: %s"] = "%s은(는) 유효하지 않은 사용자 가격이므로 에러가 발생하였습니다. %s"
L["%s is not a valid source."] = "%s is not a valid source."
L["%s operation"] = "%s 작업"
L["%s operations"] = "%s 작업들"
L["%s previously had the max number of operations, so removed %s."] = "%s 에는 이미 최대의 작업이 있으므로, %s 는 제거되었습니다."
L["%s removed."] = "%s 삭제됨."
L["%s sent you %s"] = "%s 님이 당신에게 %s 아이템을 보냈습니다"
L["%s sent you %s and %s"] = "%s 님이 당신에게 %s 그리고 %s 을(를) 보냈습니다."
L["%s sent you a COD of %s for %s"] = "%s 님이 당신에게 %s 아이템을 골드 %s 으로 대금청구를 보냈습니다."
L["%s sent you a message: %s"] = "%s 님이 메시지를 보냈습니다: %s"
L["%s total"] = "총 %s"
L["%sDrag%s to move this button"] = "%s드레그%s : 미니맵 아이콘 이동"
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."] = "%s중요:|r 회계 데이터가 이 서버에 대해 마지막으로 저장되었을 때 와우가 처리하기에는 너무 커서 저장된 변수의 손상을 방지하기 위해 오래된 데이터가 자동으로 잘렸습니다. 마지막 %s의 구매 데이터는 보존되었습니다."
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."] = "%s중요:|r 회계 데이터가 이 서버에 대해 마지막으로 저장되었을 때 와우가 처리하기에는 너무 커서 저장된 변수의 손상을 방지하기 위해 오래된 데이터가 자동으로 잘렸습니다. 마지막 %s의 판매 데이터는 보존되었습니다."
L["%sLeft-Click%s to open the main window"] = "%s좌클릭%s : 설정창 열기"
L["%sLeft-Click|r to ignore an item for this session. Hold %sShift|r to ignore permanently. You can remove items from permanent ignore in the Vendoring settings."] = "%sLeft-Click|r to ignore an item for this session. Hold %sShift|r to ignore permanently. You can remove items from permanent ignore in the Vendoring settings."
L["'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."] = "'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."
L["'%s' is not a valid argument for convert()."] = "'%s' is not a valid argument for convert()."
L["'%s' is not a valid item argument."] = "'%s' is not a valid item argument."
L["(%d/500 Characters)"] = "(%d/500 글자)"
L["(minimum 0 - maximum %d)"] = "(최소 0 - 최대 %d)"
L["1 Group"] = "1 그룹"
L["1 Item"] = "1 아이템"
L["1D"] = "1일"
L["1M"] = "1달"
L["1W"] = "1주"
L["1Y"] = "1년"
L["2Y"] = "2년"
L["3M"] = "3달"
L["6M"] = "6달"
L["A custom price of %s for %s evaluates to %s."] = "사용자 가격 %s인 %s의 평가 가치는 %s입니다."
L["A profile with that name already exists on the target account. Rename it first and try again."] = "대상 계정에 해당 이름의 프로필이 이미 존재합니다. 먼저 이름을 변경하고 다시 시도하세요."
L["A profile with this name already exists."] = "해당 이름의 프로필이 대상 계정에 존재합니다."
L["A scan is already in progress. Please stop that scan before starting another one."] = "스캔이 이미 진행 중입니다. 다른 스캔을 시작하려면 기존 검사를 중지하세요."
L["A single craft makes %d and you only need to restock %d."] = "한번의 제작으로 %d을 만들고 %d만 재보충하면 됩니다."
L["AH"] = "경매장"
L["AH (Crafting)"] = "경매 (제작)"
L["AH (Disenchanting)"] = "경매 (마력 추출)"
L["AH BUSY"] = "경매장 혼잡함"
L["AHDB Minimum Bid"] = "경매장DB 입찰 최저가"
L["AHDB Minimum Buyout"] = "경매장DB 즉시구입 최저가"
L["ALT"] = "ALT"
L["Above max expires."] = "유효 기간 초과."
L["Above max price. Not posting."] = "최대 가격 초과. 경매 등록 안함."
L["Above max price. Posting at max."] = "최대 가격 초과. 최고가에 경매 등록."
L["Above max price. Posting at min."] = "최대 가격 초과. 최저가에 경매 등록."
L["Above max price. Posting at normal."] = "최대 가격 이상. 정상가에 경매 등록."
L["Accept COD?"] = "대금 청구를 수락하시겠습니까?"
L["Accepting this item will cost: %s"] = "이 아이템을 수취할려면 다음 비용이 필요합니다: %s"
L["Account Syncing"] = "계정 동기화"
L["Account sync removed. Please delete the account sync from the other account as well."] = "계정 동기화가 제거되었습니다. 다른 계정에서도 계정 동기화를 삭제하세요."
L["Accounting"] = "회계"
L["Active"] = "활성화"
L["Active Alt"] = "Alt 활성화"
L["Activity Type"] = "활동 유형"
L["Add"] = "추가"
L["Add %d |4Item:Items"] = "%d |4아이템:아이템 추가"
L["Add %s Operation"] = "%s 작업 추가하기"
L["Add More Operations"] = "더 많은 작업 추가하기"
L["Add Operation"] = "작업 추가하기"
L["Add Subject / Description"] = "제목 / 설명 추가 (선택)"
L["Add a new custom source"] = "새로운 커스텀 소스 추가하기"
L["Add account"] = "계정 추가하기"
L["Add operation to groups"] = "그룹에 작업 추가하기"
L["Add subject & description (optional)"] = "제목 & 설명 추가하기 (선택)"
L["Add to Mail"] = "메일에 추가하기"
L["Added %s to %s."] = "%s가 %s에 추가됨."
L["Added '%s' profile which was received from %s."] = "%s 에게 받은 '%s' 프로필이 추가되었습니다."
L["Additional error suppressed"] = "추가적인 오류 표시 안 함"
L["Adjust how TSM values crafted items when calculating profit."] = "이익을 계산할 때 TSM이 값을 만드는 방식 조정"
L["Adjust how crafted items are restocked."] = "제작된 아이템이 재보충되는 방식 조정."
L["Adjust how items are mailed."] = "아이템이 우편으로 보내지는 방식 조정하기"
L["Adjust some general settings."] = "일반 설정 조정하기."
L["Adjust the settings below to set how groups attached to this operation will be auctioned."] = "아래의 설정을 조정하여 이 작업에 연결된 그룹이 경매되는 방식을 설정하세요."
L["Adjust the settings below to set how groups attached to this operation will be cancelled."] = "아래의 설정을 조정하여 이 작업에 연결된 그룹이 취소되는 방식을 설정하세요."
L["Adjust the settings below to set how groups attached to this operation will be priced."] = "아래의 설정을 조정하여 이 작업에 연결된 그룹의 가격 책정 방식을 설정하세요."
L["Advanced Item Search"] = "고급 아이템 검색"
L["Alarm Clock"] = "알람 시계"
L["All"] = "전체"
L["All Auctions"] = "전체 경매"
L["All Bought"] = "전체 매수"
L["All Cancelled"] = "모두 취소됨"
L["All Characters"] = "모든 케릭터"
L["All Expired"] = "모두 만료됨"
L["All Faction-Realms"] = "모든 진영-서버"
L["All Guilds"] = "모든 길드"
L["All Item Classes"] = "모든 아이템 클래스"
L["All Other"] = "다른 모든 것"
L["All Players"] = "모든 플레이어"
L["All Professions"] = "모든 전문 기술"
L["All Rarites"] = "모든 품질"
L["All Rarities"] = "모든 품질"
L["All Selected"] = "모두 선택됨"
L["All Slots"] = "모든 칸"
L["All Sold"] = "모두 판매"
L["All Sources"] = "모든 출처"
L["All Subclasses"] = "모든 하위 클래스"
L["All Time"] = "전체 시간"
L["All Types"] = "모든 유형"
L["Allow partial stack"] = "부분 묶음 허용"
L["Allows for testing of custom prices"] = "사용자 가격 테스트 허용"
L["Alt Guild Bank"] = "부캐 길드 은행"
L["Alts"] = "부캐"
L["Alts AH"] = "부캐 경매장"
L["Amount"] = "수량"
L["Amount kept in bags"] = "가방에 있는 양"
L["Amount of bag space to keep free"] = "여유 공간으로 확보할 가방 공간"
L["An old TSM addon was found installed. Please remove %s and any other old TSM addons to avoid issues."] = "오래된 TSM 애드온이 설치된 것을 감지했습니다. 문제를 해결하기 위해 %s 와 다른 모든 오래된 TSM 애드온을 삭제하세요."
L["App Not Synced"] = "앱이 동기화되지 않음"
L["App Synced %s Ago"] = "앱이 %s 전 동기화 됨"
L["Appearance"] = "외형"
L["Apply operation to group"] = "그룹에 작업을 적용하기"
L["Are you sure you want to clear accounting data older than %d days for the currenet realm?"] = "Are you sure you want to clear accounting data older than %d days for the currenet realm?"
L["Are you sure you want to delete the selected operations?"] = "정말 선택된 작업을 삭제할까요?"
L["Are you sure you want to delete this operation?"] = "정말로 선택된 작업을 지우시겠습니까?"
L["At above max price and not undercut."] = "최고가 이상이고 상위입찰이 아닙니다."
L["At normal price and not undercut."] = "정상가 이상이고 상위입찰이 아닙니다."
L["Attachments"] = "첨부물"
L["Auction"] = "경매"
L["Auction House Cut"] = "경매장 수수료"
L["Auction House Sounds"] = "경매장 소리"
L["Auction Window Close"] = "경매장 창 끄기"
L["Auction Window Open"] = "경매장 창 종료음"
L["Auction duration"] = "경매 기간"
L["Auction has been bid on."] = "경매가 입찰되었습니다."
L["Auction sale sound"] = "경매 판매 소리"
L["AuctionDB"] = "AuctionDB"
L["AuctionDB - Historical Price"] = "AuctionDB - Historical Price"
L["AuctionDB - Market Value"] = "경매DB - 상점가"
L["AuctionDB - Minimum Buyout"] = "경매DB - 최저가 즉시구매"
L["AuctionDB - Recent Value"] = "AuctionDB - Recent Value"
L["AuctionDB - Region Historical Price"] = "AuctionDB - Region Historical Price"
L["AuctionDB - Region Market Value Average"] = "AuctionDB - Region Market Value Average"
L["AuctionDB - Region Sale Average"] = "AuctionDB - Region Sale Average"
L["AuctionDB - Region Sale Rate"] = "AuctionDB - Region Sale Rate"
L["AuctionDB - Region Sold Per Day"] = "AuctionDB - Region Sold Per Day"
L["AuctionDB Realm Data is %s Old"] = "경매DB 서버 데이터가 %s 이전"
L["AuctionDB Region Data is %s Old"] = "경매DB 지역 데이터가 %s 이전"
L["Auctionator - Auction Value"] = "Auctionator - 경매가"
L["Auctioneer - Appraiser"] = "Auctioneer -  감정인"
L["Auctioneer - Market Value"] = "Auctioneer - 시장가"
L["Auctioneer - Minimum Buyout"] = "Auctioneer - 최소 구매가"
L["Auctioning"] = "경매"
L["Auctioning %s button"] = "경매 %s 버튼"
L["Auctioning Details"] = "경매 세부사항"
L["Auctioning Log"] = "경매 기록"
L["Auctioning Operation"] = "경매 운영"
L["Auctioning operation"] = "경매 운영"
L["Auctioning operations control posting to and canceling from the AH."] = "경매 운영은 경매장에 대한 등록 및 취소를 제어합니다."
L["Auctions"] = "경매"
L["Auto Quest Complete"] = "자동 퀘스트 완료음"
L["Auto-focus browse search input"] = "자동초점 경매서핑 검색 입력"
L["Average Earned per Day"] = "일 평균 획득 골드"
L["Average Prices:"] = "평균 가격:"
L["Average Profit per Day"] = "일 평균 이익"
L["Average Spent per Day"] = "일 평균 지출"
L["Avg Buy Price"] = "평균 구매 가격"
L["Avg Profit"] = "평균 이익"
L["Avg Sell Price"] = "평균 판매 가격"
L["BUSY"] = "혼잡"
L["BUY"] = "구입"
L["Back"] = "이전"
L["Bag"] = "가방"
L["Bags"] = "가방"
L["Bank"] = "Bank"
L["Banking"] = "은행"
L["Banks"] = "은행"
L["Base Group"] = "기본 그룹"
L["Base Item"] = "기본 아이템"
L["Below is a list of all available price sources, along with a brief description of what they represent."] = "아래에서 사용 가능한 모든 가격 출처의 목록과 그에 해당하는 간략한 설명입니다."
L["Below min price. Posting at max."] = "최저가 미만. 최고가에 경매 등록."
L["Below min price. Posting at min."] = "최저가 미만. 최저가에 경매 등록."
L["Below min price. Posting at normal."] = "최저가 미만. 정상가에 경매 등록."
L["Below you can ignore this operation on certain characters or realms."] = "아래에서 특정 캐릭터 또는 서버에서 이 작업을 제외할 수 있습니다."
L["Bid %d / %d"] = "입찰 %d / %d"
L["Bid (item)"] = "입찰 (아이템)"
L["Bid (stack)"] = "입찰 (묶음)"
L["Bid (total)"] = "입찰 (전체)"
L["Bid / Buyout"] = "입찰 / 즉시 구입"
L["Bid Auction"] = "경매 입찰"
L["Bid Price"] = "입찰가"
L["Bid Sniper Paused"] = "입찰 Sniper 중지됨"
L["Bid Sniper Running"] = "입찰 Sniper 실행중"
L["Bid percent must be between 0 and 100."] = "입찰 퍼센트는 0 에서 100 사이여야 합니다."
L["Bidding Auction"] = "경매 입찰"
L["Blacklisted players"] = "블랙리스트된 플레이어"
L["Bought"] = "구매"
L["Bought %d of %s from %s for %s"] = "Bought %d of %s from %s for %s"
L["Bought %sx%d for %s from %s"] = "%sx%d을 %s 가격으로 %s에게 구매"
L["Bound Actions"] = "작업 배정"
L["Browse"] = "경매 참관"
L["Browse / Sniper"] = "살펴보기 / Sniper"
L["Buy"] = "구매"
L["Buy %d / %d"] = "%d / %d 구매"
L["Buy %d / %d (Confirming %d / %d)"] = "%d / %d 구매(%d / %d 확인)"
L["Buy Auction"] = "경매 구매"
L["Buy Commodity"] = "상품 구매하기"
L["Buy Commodity (%02d)"] = "Buy Commodity (%02d)"
L["Buy Groups"] = "그룹 구매"
L["Buy Options"] = "옵션 구매"
L["Buy from AH"] = "경매장에서 구매"
L["Buy from AH (Crafting)"] = "경매장에서 구매 (제작물)"
L["Buy from AH (Disenchant)"] = "경매장에서 구매 (마력추출)"
L["Buy from Vendor"] = "상인에게 구매"
L["Buyback All"] = "모두 되사기"
L["Buyer/Seller"] = "구매자/판매자"
L["Buyout"] = "즉시 구입"
L["Buyout (item)"] = "즉시 구입 (아이템)"
L["Buyout (stack)"] = "즉시 구매 (묶음)"
L["Buyout (total)"] = "즉시 구매 (전체)"
L["Buyout Above Threshold"] = "Buyout Above Threshold"
L["Buyout Price"] = "즉시 구매 가격"
L["Buyout Sniper Paused"] = "즉구 Sniper 중지됨"
L["Buyout Sniper Running"] = "즉구 Sniper 가동중"
L["Buyout confirmation alert"] = "즉시 구매 확인 경고"
L["COD"] = "대금청구"
L["CRAFT"] = "제작"
L["CRAFTING"] = "제작"
L["CTRL"] = "CTRL"
L["Can't load TSM tooltip while in combat"] = "전투중에는 TSM 툴팁을 불러올 수 없습니다"
L["Cancel"] = "취소하기"
L["Cancel %d / %d"] = "%d / %d 취소"
L["Cancel Auction"] = "경매 취소하기"
L["Cancel Scan"] = "스캔 취소"
L["Cancel auctions with bids"] = "Cancel auctions with bids"
L["Cancel or Post"] = "취소 또는 등록"
L["Cancel to repost higher"] = "상위 재등록을 위해 취소"
L["Cancel undercut auctions"] = "상위입찰 경매 취소"
L["Canceled information"] = "취소된 경매 정보"
L["Canceling"] = "취소 중"
L["Canceling %d / %d"] = "%d / %d 취소중"
L["Canceling %d Auctions..."] = "%d 경매 취소 중..."
L["Canceling Options"] = "취소 설정"
L["Canceling auction you've undercut."] = "상위입찰된 경매를 취소합니다."
L["Canceling disabled."] = "취소 불가."
L["Canceling to repost at higher price."] = "상위 가격으로 재등록하기 위해 취소합니다."
L["Canceling to repost at reset price."] = "재설정 가격으로 재등록하기 위해 취소합니다."
L["Canceling to repost higher."] = "상위에 재등록하기 위해 취소합니다."
L["Canceling undercut auctions and to repost higher."] = "상위입찰 경매를 취소하고 상위 가격으로 재등록합니다."
L["Canceling undercut auctions."] = "상위입찰 경매를 취소합니다."
L["Cancelled"] = "취소됨"
L["Cancelled Since Last Sale"] = "마지막 판매 이후 취소됨"
L["Cancelled auction of %sx%d"] = "%sx%d의 경매가 취소됨"
L["Cancelled:"] = "취소 중:"
L["Cannot repair from the guild bank!"] = "길드 은행으로부터 수리할 수 없습니다!"
L["Cannot use additional filters with /crafting or /disenchant."] = "/crafting 또는 /disenchant와 함께 추가 필터를 사용할 수 없습니다."
L["Cash Register"] = "금전 등록기음"
L["Changes to the specified profile (i.e. '/tsm profile Default' changes to the 'Default' profile)"] = "지정된 프로필로 변경 (예: '/tsm profile Default'는 '기본' 프로필로 변경)"
L["Character"] = "캐릭터"
L["Chat Tab"] = "채팅 탭"
L["Cheapest auction below min price."] = "최저가 이하의 가장 저렴한 경매."
L["Clear All"] = "모두 지우기"
L["Clear Data"] = "데이터 지우기"
L["Clear Filters"] = "필터 해제"
L["Clear Old Data"] = "오래된 데이터 지우기"
L["Clear Old Data?"] = "오래된 데이터를 지울까요?"
L["Click and drag to resize this window."] = "클릭하고 드래그하여 창의 크기를 조절하세요."
L["Click to hide this item for the current session. Hold shift to hide this item permanently."] = "지금동안만 이 아이템을 숨길려면 클릭하세요. 쉬프트와 같이 누르면 이 아이템이 영구적으로 숨겨집니다."
L["Coins (%s)"] = "동전 (%s)"
L["Combine Partial Stacks"] = "쪼개진 묶음 합치기"
L["Combining..."] = "합치는 중..."
L["Confirm"] = "확인"
L["Confirm complete sound"] = "확인 완료 알림음"
L["Confirmation %s button"] = "확인 %s 버튼"
L["Confirming %d / %d"] = "%d / %d 확인중"
L["Confirming..."] = "Confirming..."
L["Connected to %s"] = "%s 에 연결됨"
L["Connecting to %s"] = "%s 에 연결하는 중"
L["Contacts"] = "주소록"
L["Contains auctions above your alert threshold!"] = "알림 한계값을 초과하는 경매가 포함되어 있습니다!"
L["Contains auctions above your material value!"] = "Contains auctions above your material value!"
L["Convert Value (%s)"] = "Convert Value (%s)"
L["Cooldown"] = "재사용 대기시간"
L["Cooldowns"] = "재사용 대기시간"
L["Copy Letter"] = "글자 복사하기"
L["Cost"] = "비용"
L["Could not create macro as you already have too many. Delete one of your existing macros and try again."] = "메크로 창이 가득 차 메크로를 만들 수 없습니다. 메크로 중 하나를 지우고 다시 시도 하세요."
L["Could not find profile '%s'. Possible profiles: '%s'"] = "프로필 '%s'를 찾을 수 없습니다. 가능한 프로필: '%s'"
L["Could not sell items due to not having free bag space available to split a stack of items."] = "아이템 묶음을 분할할 수 있은 가방 여유 공간이 없기 때문에 아이템을 판매할 수 없습니다."
L["Craft"] = "제작"
L["Craft (Profitable)"] = "제작 (이익)"
L["Craft (Unprofitable)"] = "제작 (손해)"
L["Craft Next"] = "다음 제작하기"
L["Craft Value"] = "제작 가치"
L["Craft Vellum"] = "Craft Vellum"
L["Crafted Items"] = "제작된 아이템"
L["Crafter"] = "제작자"
L["Crafting"] = "제작"
L["Crafting %s button"] = "Crafting %s button"
L["Crafting Cost"] = "제작 비용"
L["Crafting Material Cost"] = "제작 원재료 비용"
L["Crafting Mode"] = "제작 모드"
L["Crafting UI Improvements"] = "Crafting UI Improvements"
L["Crafting Value"] = "Crafting Value"
L["Crafting cost"] = "제작 비용"
L["Crafting operation"] = "제작 설정"
L["Crafting operations control how queuing profession crafts."] = "Crafting operations control how queuing profession crafts."
L["Crafts"] = "제작"
L["Create Groups from Table"] = "Create Groups from Table"
L["Create New"] = "새로 만들기"
L["Create New Group"] = "새로운 그룹 만들기"
L["Create New Operation"] = "새 작업 생성"
L["Create Profession Groups"] = "Create Profession Groups"
L["Create macro"] = "메크로 만들기"
L["Create new profile"] = "프로필 새로 만들기"
L["Current Price"] = "현재 가격"
L["Custom"] = "Custom"
L["Custom Price"] = "Custom Price"
L["Custom Source"] = "Custom Source"
L["Custom Sources"] = "Custom Sources"
L["Custom Theme"] = "Custom Theme"
L["Custom price name %s already exists."] = "%s 커스텀 가격 이름이 이미 존재합니다."
L["Custom price name %s is a reserved word which cannot be used."] = "%s 커스텀 개인 가격은 예약된 이름이기 때문에 사용할 수 없습니다."
L["Custom price names can only contain lowercase letters."] = "커스텀 가격 이름은 소문자만 허용됩니다."
L["Custom source (%s)"] = "Custom source (%s)"
L["Custom sources allow you to create more advanced prices for use throughout the addon. You'll be able to use these new variables in the same way you can use the built-in price sources such as %s and %s."] = "커스텀 소스는 에드온에서 고급화된 가격을 만들수 있도록 해줍니다. 내장된 가격 소스인 %s 혹은 %s 사용하는 것과 같이 새로운 변수를 사용할 수 있습니다."
L["DAILY PURCHASES"] = "일일 매수량"
L["DAILY SALES"] = "일일 매출건"
L["Dalaran"] = "달라란"
L["Dashboard"] = "대시보드"
L["Default Price"] = "기본 가격"
L["Default craft value method"] = "Default craft value method"
L["Default material cost method"] = "Default material cost method"
L["Default price configuration"] = "기본 가격 설정"
L["Define what priority Gathering gives certain sources."] = "Define what priority Gathering gives certain sources."
L["Delete %d Operations"] = "Delete %d Operations"
L["Delete Group?"] = "그룹을 삭제할까요?"
L["Delete Operation?"] = "작업을 삭제할까요?"
L["Delete Operations"] = "작업 삭제하기"
L["Delete Operations?"] = "작업들을 삭제할까요?"
L["Delete Profile?"] = "프로필을 삭제 할까요?"
L["Delete Record?"] = "레코드를 삭제할까요?"
L["Delete the profile"] = "프로파일 삭제하기"
L["Deleting this group (%s) will also remove any sub-groups attached to this group."] = "(%s) 그룹을 삭제하면 이 그룹에 포함된 하위 그룹도 삭제됩니다."
L["Deposit"] = "맡기기"
L["Deposit Cost"] = "보증금"
L["Deposit reagents"] = "재료 은행"
L["Deselect All"] = "모두 선택 해제하기"
L["Destroy Next"] = "다음 물건 뽀각하기"
L["Destroy Value"] = "Destroy Value"
L["Destroy value"] = "Destroy value"
L["Destroy value source"] = "Destroy value source"
L["Destroying"] = "마력 추출"
L["Destroying %s button"] = "Destroying %s button"
L["Destroying will ignore %s permanently. You can remove it from the ignored list in the settings."] = "파괴하면 %s 을(를) 영구적으로 무시합니다. 설정의 리스트에서 이를 제거할 수 있습니다."
L["Destroying will ignore %s until you log out."] = "Destroying will ignore %s until you log out."
L["Destroying..."] = "뽀각중..."
L["Detailed crafting cost"] = "Detailed crafting cost"
L["Details"] = "자세한 사항"
L["Did not cancel %s because your cancel to repost threshold (%s) is invalid. Check your settings."] = "Did not cancel %s because your cancel to repost threshold (%s) is invalid. Check your settings."
L["Did not cancel %s because your maximum price (%s) is invalid. Check your settings."] = "최대 가격 (%s) 이 유효하지 않기 때문에 %s 취소가 중지되었습니다. 설정을 확인하세요."
L["Did not cancel %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "최대 가격 (%s) 이 최소 가격 (%s) 보다 낮기 때문에 %s 취소가 중지되었습니다. 설정을 확인하세요."
L["Did not cancel %s because your minimum price (%s) is invalid. Check your settings."] = "Did not cancel %s because your minimum price (%s) is invalid. Check your settings."
L["Did not cancel %s because your normal price (%s) is invalid. Check your settings."] = "Did not cancel %s because your normal price (%s) is invalid. Check your settings."
L["Did not cancel %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "Did not cancel %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."
L["Did not cancel %s because your undercut (%s) is invalid. Check your settings."] = "Did not cancel %s because your undercut (%s) is invalid. Check your settings."
L["Did not change prices due to an invalid bid or buyout value."] = "유효하지 않은 입찰 혹은 즉시 구매 가격으로 인해 가격이 변동되지 않았습니다."
L["Did not post %s because Blizzard didn't provide all necessary information for it. Try again later."] = "Did not post %s because Blizzard didn't provide all necessary information for it. Try again later."
L["Did not post %s because the owner of the lowest auction (%s) is on both the blacklist and whitelist which is not allowed. Adjust your settings to correct this issue."] = "가장 낮은 가격의 (%s) 판매자가 블랙리스트와 화이트리스트 모두 있기 때문에 %s 경매 시작이 중지되었습니다. 이 문제를 해결할려면 설정을 조정하세요."
L["Did not post %s because you or one of your alts (%s) is on the blacklist which is not allowed. Remove this character from your blacklist."] = "Did not post %s because you or one of your alts (%s) is on the blacklist which is not allowed. Remove this character from your blacklist."
L["Did not post %s because your keep quantity (%s) is invalid. Check your settings."] = "Did not post %s because your keep quantity (%s) is invalid. Check your settings."
L["Did not post %s because your max expires (%s) is invalid. Check your settings."] = "Did not post %s because your max expires (%s) is invalid. Check your settings."
L["Did not post %s because your maximum price (%s) is invalid. Check your settings."] = "Did not post %s because your maximum price (%s) is invalid. Check your settings."
L["Did not post %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "Did not post %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."
L["Did not post %s because your minimum price (%s) is invalid. Check your settings."] = "Did not post %s because your minimum price (%s) is invalid. Check your settings."
L["Did not post %s because your normal price (%s) is invalid. Check your settings."] = "Did not post %s because your normal price (%s) is invalid. Check your settings."
L["Did not post %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "Did not post %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."
L["Did not post %s because your post cap (%s) is invalid. Check your settings."] = "Did not post %s because your post cap (%s) is invalid. Check your settings."
L["Did not post %s because your stack size (%s) is invalid. Check your settings."] = "Did not post %s because your stack size (%s) is invalid. Check your settings."
L["Did not post %s because your undercut (%s) is invalid. Check your settings."] = "Did not post %s because your undercut (%s) is invalid. Check your settings."
L["Disable invalid price warnings"] = "유효하지 않은 가격 경고 비활성화"
L["Disenchant Search"] = "마력 추출 검색"
L["Disenchant Search Options"] = "마력 추출 검색 설정"
L["Disenchant Value"] = "마력 추출 가치"
L["Disenchanting Options"] = "마력 추출 옵션"
L["Display total money received in chat"] = "채팅에 받은 금액 표시하기"
L["Don't Post Items"] = "아이템 올리지 않기"
L["Don't post after this many expires"] = "Don't post after this many expires"
L["Don't prompt to record trades"] = "물물교환 기록하지 않기"
L["Done Canceling"] = "취소 완료"
L["Done Posting"] = "경매 시작 완료"
L["Done Scanning"] = "스캔 완료"
L["Done rebuilding item cache."] = "아이템 캐시 리빌딩 완료"
L["Down"] = "아래로"
L["Duplicate the profile"] = "프로필 복사하기"
L["Duration"] = "기간"
L["Duskwood"] = "그늘숲"
L["EXPENSES"] = "지출"
L["Edit"] = "편집"
L["Edit Post"] = "경매 시작 편집"
L["Embed TSM tooltip"] = "Embed TSM tooltip"
L["Empty bags"] = "가방 비우기"
L["Empty price string."] = "빈 가격 문자열."
L["Enable TSM tooltips"] = "TSM 툴팁 활성화"
L["Enable automatic stack combination"] = "Enable automatic stack combination"
L["Enable buying"] = "구매 활성화"
L["Enable inbox chat messages"] = "Enable inbox chat messages"
L["Enable region-wide trading (requires reload)"] = "Enable region-wide trading (requires reload)"
L["Enable restock"] = "Enable restock"
L["Enable selling"] = "Enable selling"
L["Enable sending chat messages"] = "Enable sending chat messages"
L["Enchant"] = "마법부여"
L["Ensure both characters are online and try again."] = "두 캐릭터 모두 온라인 상태인지 확인하고 다시 시도하세요."
L["Enter Filter"] = "필터 입력"
L["Enter Keyword"] = "키워드 입력"
L["Enter a value from %d - %d"] = "%d - %d 사이의 값을 입력"
L["Enter a value from %d - %d%%"] = "%d - %d%% 사이의 값 입력"
L["Enter name of logged-in character on other account"] = "다른 계정에서 로그인 된 캐릭터 이름 입력"
L["Enter player name"] = "플레이어 이름 입력"
L["Enter profile name"] = "프로필 이름을 입력하세요"
L["Enter recipient name"] = "수취인 이름을 입력하세요"
L["Establishing connection to %s. Make sure that you've entered this character's name on the other account."] = "%s 에 연결하는 중입니다. 다른 계정의 캐릭터 이름을 입력하였는지 확인하세요."
L["Establishing connection..."] = "연결하는 중..."
L["Estimated Profit"] = "Estimated Profit"
L["Estimated Time"] = "Estimated Time"
L["Estimated deliver time"] = "예상 완료 시간"
L["Exact Match"] = "정확히 일치"
L["Example"] = "예시"
L["Example Item"] = "아이템 예시"
L["Example Tooltip"] = "툴팁 예시"
L["Exclude custom sources?"] = "Exclude custom sources?"
L["Exclude operations?"] = "Exclude operations?"
L["Exit"] = "나가기"
L["Expand / Collapse All Groups"] = "모든 그룹 펼치기 / 닫기"
L["Expenses"] = "지출"
L["Expirations"] = "Expirations"
L["Expired"] = "만료됨"
L["Expired Auctions"] = "만료된 경매"
L["Expired Since Last Sale"] = "Expired Since Last Sale"
L["Expired information"] = "Expired information"
L["Expires"] = "Expires"
L["Expires Since Last Sale"] = "Expires Since Last Sale"
L["Expiring Mails"] = "우편 추출하기"
L["Exploration"] = "폭발음"
L["Export"] = "내보내기"
L["Export Custom Theme"] = "Export Custom Theme"
L["Export String"] = "Export String"
L["Export theme"] = "Export theme"
L["Export this group"] = "그룹 추출하기"
L["Failed Auctions"] = "유찰된 경매"
L["Failed to bid on auction of %s (x%s) for %s."] = "Failed to bid on auction of %s (x%s) for %s."
L["Failed to bid on auction of %s."] = "Failed to bid on auction of %s."
L["Failed to buy auction of %s (x%s) for %s."] = "Failed to buy auction of %s (x%s) for %s."
L["Failed to buy auction of %s."] = "%s 경매 구매에 실패했습니다."
L["Failed to buy auction."] = "경매 구매에 실패했습니다."
L["Failed to cancel auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "경매장이 혼잡하여 경매 취소에 실패했습니다. 다른 에드온이 경매장을 스캔하고 있는지 확인하고 다시 시도하세요."
L["Failed to find auction for %s, so removing it from the results."] = "%s에 대한 경매 검색에 실패하였기에 결과에서 삭제했습니다."
L["Failed to move group, as a group with the same name already exists in the target location."] = "Failed to move group, as a group with the same name already exists in the target location."
L["Failed to post %sx%d as the item no longer exists in your bags."] = "가방에 더 이상 존재하지 않기 때문에 %sx%d 아이템을 올리는데 실패했습니다."
L["Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."
L["Failed to send profile."] = "프로필 전송에 실패했습니다."
L["Failed to send profile. Ensure both characters are online and try again."] = "프로파일 전송에 실패했습니다. 두 캐릭터 모두가 온라인 상태인지 확인하고 다시 시도하세요."
L["Failed to start sniper. No groups have a Sniper operation applied."] = "Failed to start sniper. No groups have a Sniper operation applied."
L["Favorite Scans"] = "즐겨찾는 스캔"
L["Favorite Searches"] = "즐겨찾기"
L["Favorited Patterns"] = "즐겨찾는 도안"
L["Filter by Keyword"] = "키워드로 정렬"
L["Filter by Price Source"] = "가격 소스로 정렬"
L["Filter by Profession"] = "전문 기술로 정렬"
L["Filter by duration"] = "기간으로 정렬"
L["Filter by groups"] = "그룹으로 정렬"
L["Filter by keyword"] = "키워드로 정렬"
L["Filter group item lists based on the following price source"] = "아래의 가격 소스에 따라 그룹 아이템을 필터하기"
L["Finding Selected Auction"] = "Finding Selected Auction"
L["First Auctioning Operation Max Price"] = "First Auctioning Operation Max Price"
L["First Auctioning Operation Min Price"] = "First Auctioning Operation Min Price"
L["First Auctioning Operation Normal Price"] = "First Auctioning Operation Normal Price"
L["Fishing Reel In"] = "낚시 릴 스피닝음"
L["For more info, visit %s. For help, join us in Discord: %s."] = "더 많은 정보를 찾고 싶으시면 %s 를 방문하세요. 지원을 받고 싶으시면 디스코드에 참여하세요: %s"
L["Forget Character"] = "캐릭터 지우기"
L["Found auction sound"] = "Found auction sound"
L["Frame"] = "Frame"
L["Friends"] = "친구"
L["From"] = "발신자"
L["Full convert tooltip"] = "Full convert tooltip"
L["Full destroy tooltip"] = "Full destroy tooltip"
L["Full inventory"] = "전체 인벤토리"
L["GVault"] = "길드 은행"
L["Garrison"] = "임무"
L["Gathering"] = "채집"
L["Gathering Search"] = "Gathering Search"
L["Gathering Setup"] = "Gathering Setup"
L["General Options"] = "일반 옵션"
L["General Settings"] = "일반 설정"
L["Get from Bank"] = "은행에서 찾기"
L["Get from Guild Bank"] = "Get from Guild Bank"
L["Gets items from the bank or guild bank matching the item or partial text entered."] = "Gets items from the bank or guild bank matching the item or partial text entered."
L["Gold"] = "골드"
L["Great Deals Search"] = "Great Deals Search"
L["Group Management"] = "그룹 관리"
L["Group Search"] = "그룹 검색"
L["Group already exists."] = "그룹이 이미 존재합니다."
L["Group name"] = "그룹 이름"
L["Grouped Items"] = "그룹화된 아이템"
L["Grouping Pets by Level"] = "Grouping Pets by Level"
L["Groups"] = "그룹"
L["Groups & Operations"] = "그룹 / 작업"
L["Groups Using"] = "Groups Using"
L["Guild"] = "길드"
L["Guild Bank"] = "길드 은행"
L["HIGH"] = "최고"
L["Have"] = "보유량"
L["Have Mats"] = "재료 있음"
L["Have Skill Ups"] = "숙련도 상승 가능함"
L["Here you can add/remove what groups this operation is attached to."] = "Here you can add/remove what groups this operation is attached to."
L["Hide Columns"] = "열 숨기기"
L["Hide auctions with bids"] = "입찰 있는 경매 숨기기"
L["Hide minimap icon"] = "미니맵 아이콘 숨기기"
L["Hiding the TSM Banking UI. Type '/tsm bankui' to reopen it."] = "TSM 은행 UI를 숨겼습니다. '/tsm bankui'를 입력하여 다시 여세요."
L["Hiding the TSM Task List UI. Type '/tsm tasklist' to reopen it."] = "TSM Task List UI를 숨겼습니다. '/tsm tasklist'를 입력하여 다시 여세요."
L["High Bidder"] = "최고 입찰자"
L["Historical Price"] = "Historical Price"
L["Historical price"] = "Historical price"
L["Hold ALT to repair from the guild bank."] = "ALT를 눌러 길드 은행 잔고로 수리하기"
L["Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."] = "Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."
L["Hold SHIFT to continue after the inbox refreshes"] = "Hold SHIFT to continue after the inbox refreshes"
L["Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."] = "Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."
L["Hold SHIFT to not continue after the inbox refreshes"] = "Hold SHIFT to not continue after the inbox refreshes"
L["Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."] = "Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."
L["Hold SHIFT while dragging to scale the window instead."] = "쉬프트를 누른 상태에서 드래그하여 창의 크기를 조절하세요."
L["Hold shift to move the items to the parent group instead of removing them."] = "Hold shift to move the items to the parent group instead of removing them."
L["Hr"] = "Hr"
L["Hrs"] = "Hrs"
L["If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."] = "If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."
L["If you have multiple profiles set up with operations, enabling this will cause all but the current profile's operations to be irreversibly lost."] = "만약 여러 프로파일 사이에 작업을 갖고 있을 때 이 설정을 활성화 하면 현재 프로파일의 작업이 영구적으로 유실됩니다."
L["Ignore Auctions Below Min"] = "Ignore Auctions Below Min"
L["Ignore Characters"] = "캐릭터 무시하기"
L["Ignore Guilds"] = "길드 무시하기"
L["Ignore auctions by duration"] = "Ignore auctions by duration"
L["Ignore operation on characters"] = "Ignore operation on characters"
L["Ignore operation on faction-realms"] = "Ignore operation on faction-realms"
L["Ignored Cooldowns"] = "Ignored Cooldowns"
L["Ignored Items"] = "무시된 아이템"
L["Import"] = "가져오기"
L["Import Groups & Operations"] = "Import Groups & Operations"
L["Import String"] = "Import String"
L["Import Summary"] = "Import Summary"
L["Import Theme"] = "Import Theme"
L["Import group"] = "Import group"
L["Imported Group"] = "Imported Group"
L["Imported group (%s) with %d items, %d operations, and %d custom sources."] = "Imported group (%s) with %d items, %d operations, and %d custom sources."
L["In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."] = "In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."
L["Inbox Settings"] = "인박스 설정"
L["Include operations?"] = "Include operations?"
L["Include soulbound items"] = "귀속 아이템 포함"
L["Information"] = "정보"
L["Invalid Quantity"] = "유효하지 않은 수량"
L["Invalid custom price source for %s. %s"] = "Invalid custom price source for %s. %s"
L["Invalid custom price."] = "잘못된 사용자 가격입니다."
L["Invalid group name."] = "유효하지 않은 그룹 이름"
L["Invalid numeric value."] = "유효하지 않은 수치."
L["Invalid operation name."] = "유효하지 않은 작업 이름"
L["Invalid player name."] = "잘못된 플레이어 이름입니다."
L["Invalid price."] = "유효하지 않은 가격"
L["Invalid search filter (%s)."] = "유효하지 않은 필터 (%s)"
L["Invalid search term."] = "유효하지 않은 검색어"
L["Invalid search term. Cannot filter by price here."] = "Invalid search term. Cannot filter by price here."
L["Invalid seller data returned by server."] = "서버에서 유효하지 않은 판매자 데이터가 반환되었습니다."
L["Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."] = "Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."
L["Inventory"] = "인벤토리"
L["Inventory / Gold Graph"] = "인벤토리 / 골드 그래프"
L["Inventory Options"] = "인벤토리 설정"
L["It appears that you've manually copied your saved variables between accounts which will cause TSM's automatic sync'ing to not work. You'll need to undo this, and/or delete the TradeSkillMaster saved variables files on both accounts (with WoW closed) in order to fix this."] = "다른 계정들 사이에서 저장된 값을 수동으로 복사한 것 같습니다. 이는 TSM 자동 동기화 기능이 작동하지 않게 만듭니다. 이 문제를 해결하기 위해서는 다시 되돌리고 두 계정에 있는 TSM 저장 값들을 삭제해야 합니다."
L["Item"] = "아이템"
L["Item Class"] = "Item Class"
L["Item Level"] = "아이템 레벨"
L["Item Level Range"] = "아이템 레벨 구간"
L["Item Name"] = "아이템 이름"
L["Item Quality"] = "아이템 품질"
L["Item Selection"] = "아이템 선택"
L["Item Slot"] = "Item Slot"
L["Item Subclass"] = "Item Subclass"
L["Item Value"] = "아이템 가격"
L["Item/Group is invalid (see chat)."] = "Item/Group is invalid (see chat)."
L["Items"] = "아이템"
L["Items Using"] = "Items Using"
L["Keep in bags quantity"] = "가방에 있는 수량"
L["Keep in bank quantity"] = "은행에 있는 수량"
L["Keep quantity"] = "Keep quantity"
L["Keep this amount"] = "Keep this amount"
L["Keeping %d."] = "Keeping %d."
L["Keeping undercut auctions posted."] = "Keeping undercut auctions posted."
L["LEAST GROUPS"] = "LEAST GROUPS"
L["LEAST ITEMS"] = "LEAST ITEMS"
L["LOW"] = "최저"
L["Last 14 Days"] = "지난 14일"
L["Last 3 Days"] = "지난 3일"
L["Last 30 Days"] = "지난 30일"
L["Last 60 Days"] = "지난 60일"
L["Last 7 Days"] = "지난 7일"
L["Last Purchased"] = "마지막 구매"
L["Last Sold"] = "마지막 판매"
L["Ledger"] = "장부"
L["Level Up"] = "레벨 업"
L["Limit"] = "한도"
L["Link to Another Operation"] = "다른 작업에 링크하기"
L["Lock Column Width"] = "열 너비 고정"
L["Lock task list's background"] = "Lock task list's background"
L["Looks like TradeSkillMaster has encountered an error. Please help the author fix this error by following the instructions shown."] = "TradeSkillMaster에 에러가 발생한 것 같습니다. 아래 표시된 안내에 따라 제작자가 에러를 수정할 수 있도록 도움을 주시기 바랍니다."
L["Loop detected in the following custom price:"] = "Loop detected in the following custom price:"
L["Lowest auction by whitelisted player."] = "Lowest auction by whitelisted player."
L["MAX"] = "MAX"
L["MOST GROUPS"] = "MOST GROUPS"
L["MOST ITEMS"] = "MOST ITEMS"
L["MOVE"] = "MOVE"
L["MOVING"] = "MOVING"
L["Macro Setup"] = "매크로 설정"
L["Macro created and scroll wheel bound!"] = "Macro created and scroll wheel bound!"
L["Macros"] = "메크로"
L["Mail"] = "우편"
L["Mail Disenchantables"] = "Mail Disenchantables"
L["Mail Selected Groups"] = "Mail Selected Groups"
L["Mail Selected Groups (Auto Resend)"] = "Mail Selected Groups (Auto Resend)"
L["Mail Selected Groups (Dry Run + Auto Resend)"] = "Mail Selected Groups (Dry Run + Auto Resend)"
L["Mail Selected Groups (Dry Run)"] = "Mail Selected Groups (Dry Run)"
L["Mail disenchantables max quality"] = "Mail disenchantables max quality"
L["Mail to %s"] = "%s 님에게 메일 보내기"
L["Mailing"] = "우편"
L["Mailing all to %s."] = "Mailing all to %s."
L["Mailing operation"] = "Mailing operation"
L["Mailing operations control mailing to other characters."] = "Mailing operations control mailing to other characters."
L["Mailing up to %d to %s."] = "Mailing up to %d to %s."
L["Make Cash On Delivery?"] = "대금 청구"
L["Make Operations Global?"] = "작업을 전체적으로 할까요?"
L["Management Options"] = "관리 옵션"
L["Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."] = "Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."
L["Many commonly-used actions in TSM can be added to a macro and bound to your scroll wheel. Use the options below to setup this macro and scroll wheel binding."] = "TSM에서 일반적으로 사용되는 많은 활동들은 메크로에 추가되어 스크롤 휠에 연결할 수 있습니다. 아래 설정을 사용하여 매크로를 설정하고 스크롤 휠에 지정하세요."
L["Map Ping"] = "미니맵 표시음(ping)"
L["Market Value"] = "시장 가격"
L["Market Value Price Source"] = "Market Value Price Source"
L["Market value"] = "시장 가격"
L["Market value and trend"] = "Market value and trend"
L["Market value price source"] = "Market value price source"
L["Mat Price"] = "Mat Price"
L["Mat cost"] = "Mat cost"
L["Match stack size"] = "Match stack size"
L["Match whitelisted players"] = "Match whitelisted players"
L["Material Cost"] = "Material Cost"
L["Materials"] = "재료"
L["Materials to Gather"] = "부족한 재료"
L["Max"] = "최대"
L["Max Buy Price"] = "최대로 구매할 금액"
L["Max Price"] = "최대 금액"
L["Max Sell Price"] = "최대 판매 가격"
L["Max Shopping Price"] = "Max Shopping Price"
L["Max destroy value (Enter '0c' to disable)"] = "Max destroy value (Enter '0c' to disable)"
L["Max expires to bank"] = "Max expires to bank"
L["Max market value (Enter '0c' to disable)"] = "Max market value (Enter '0c' to disable)"
L["Max quantity"] = "최대 수량"
L["Max shopping price"] = "Max shopping price"
L["Max sniper price"] = "Max sniper price"
L["Maximum Quantity to Buy"] = "Maximum Quantity to Buy"
L["Maximum amount already posted."] = "Maximum amount already posted."
L["Maximum auction price"] = "Maximum auction price"
L["Maximum disenchant level"] = "Maximum disenchant level"
L["Maximum disenchant quality"] = "Maximum disenchant quality"
L["Maximum disenchant search percent"] = "Maximum disenchant search percent"
L["Maximum price"] = "최대 가격"
L["Maximum restock quantity"] = "Maximum restock quantity"
L["Midnight"] = "자정"
L["Mill"] = "Mill"
L["Mill Value"] = "Mill Value"
L["Min"] = "Min"
L["Min 0 - Max 20"] = "Min 0 - Max 20"
L["Min 0.5 - Max 10"] = "Min 0.5 - Max 10"
L["Min Buy Price"] = "Min Buy Price"
L["Min Buyout"] = "최소 즉시 구매"
L["Min Sell Price"] = "Min Sell Price"
L["Min buyout"] = "최소 즉시 구매"
L["Min number of expires"] = "Min number of expires"
L["Min profit amount"] = "Min profit amount"
L["Min/Normal/Max Prices"] = "Min/Normal/Max Prices"
L["Min/Normal/Max price"] = "Min/Normal/Max price"
L["Minimum Rarity"] = "Minimum Rarity"
L["Minimum disenchant level"] = "Minimum disenchant level"
L["Minimum price"] = "Minimum price"
L["Minimum restock quantity"] = "Minimum restock quantity"
L["Missing Materials"] = "부족한 재료"
L["Modifiers"] = "조합키"
L["Money Frame Open"] = "머니프레임 오픈음"
L["Money Transfer"] = "송금"
L["Move %d already grouped items?"] = "Move %d already grouped items?"
L["Move %d |4Item:Items"] = "Move %d |4Item:Items"
L["Move Item"] = "아이템 옮기기"
L["Move Quantity Options"] = "Move Quantity Options"
L["Move all to Bags"] = "모두 가방으로 옮기기"
L["Move to Parent Group"] = "Move to Parent Group"
L["Move to bags"] = "Move to bags"
L["Move to bank"] = "은행으로 옮기기"
L["Moving"] = "Moving"
L["Multiple Items"] = "Multiple Items"
L["Must be between %d and %s."] = "Must be between %d and %s."
L["My Auctions"] = "나의 경매"
L["My Auctions %s button"] = "My Auctions %s button"
L["NEED MATS"] = "재료 필요함"
L["NO ITEMS"] = "NO ITEMS"
L["NOT OPEN"] = "NOT OPEN"
L["NOTE: The import contained %d invalid items which were ignored."] = "참고: 불러온것에 포함된 %d 아이템은 유효하지 않으며 무시되었습니다."
L["NOTE: The import contained %d operations with at least one invalid setting which was reset."] = "NOTE: The import contained %d operations with at least one invalid setting which was reset."
L["NPC"] = "NPC"
L["Name"] = "이름"
L["New Group"] = "새 그룹"
L["New Operation"] = "새 작업"
L["News & Information"] = "뉴스 & 정보"
L["No Attachments"] = "No Attachments"
L["No AuctionDB Realm Data"] = "AuctionDB 서버 데이터 없음"
L["No AuctionDB Region Data"] = "No AuctionDB Region Data"
L["No Characters"] = "캐릭터 없음"
L["No Faction-Realms"] = "No Faction-Realms"
L["No Guilds"] = "No Guilds"
L["No Materials to Gather"] = "부족한 재료 없음"
L["No Operation Selected"] = "선택한 작업 없음"
L["No Players"] = "플레이어 없음"
L["No Profession Opened"] = "No Profession Opened"
L["No Professions"] = "전문 기술 없음"
L["No Rarities"] = "No Rarities"
L["No Sound"] = "소리 없음"
L["No Sources"] = "No Sources"
L["No Types"] = "No Types"
L["No group selected"] = "선택된 그룹 없음"
L["No item specified. Usage: /tsm restock_help [ITEM_LINK]"] = "No item specified. Usage: /tsm restock_help [ITEM_LINK]"
L["No posting."] = "No posting."
L["No profile specified. Possible profiles: '%s'"] = "선택된 프로파일 없음. '%s' 인가요?"
L["No recent AuctionDB scan data found."] = "최신 AuctionDB 스캔 데이터를 찾을 수 없음."
L["No recipe selected"] = "No recipe selected"
L["No value was returned by the custom price for the specified item."] = "No value was returned by the custom price for the specified item."
L["No, cancel"] = "No, cancel"
L["None"] = "없음"
L["None (Always Show)"] = "조건 없음 (항상 표시)"
L["None Selected"] = "선택된것 없음"
L["Nongroup to bank"] = "Nongroup to bank"
L["Normal price"] = "평시 가격"
L["Not Connected"] = "연결되지 않음"
L["Not Enough Money"] = "Not Enough Money"
L["Not Scanned"] = "스캔되지 않음"
L["Not canceling auction at reset price."] = "Not canceling auction at reset price."
L["Not canceling auction below min price."] = "Not canceling auction below min price."
L["Not canceling."] = "Not canceling."
L["Not enough items in bags."] = "Not enough items in bags."
L["Not enough money to cancel."] = "Not enough money to cancel."
L["Nothing to move."] = "옮길 것 없음."
L["Nothing to send."] = "보낼 것 없음."
L["Number Owned"] = "보유수량"
L["Number of days"] = "Number of days"
L["OPEN"] = "OPEN"
L["Offline"] = "오프라인"
L["On Cooldown for %s"] = "On Cooldown for %s"
L["Only show craftable"] = "제작 가능한 것만 보이기"
L["Only show items with disenchant values above this price"] = "Only show items with disenchant values above this price"
L["Only show sold auctions"] = "매도된 경매만 보이기"
L["Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."] = "Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."
L["Open All Mail"] = "모든 우편 열기"
L["Open All Mail Without Money"] = "Open All Mail Without Money"
L["Open Mail"] = "우편 열기"
L["Open Mail Without Money"] = "Open Mail Without Money"
L["Open Task List"] = "Open Task List"
L["Open mail complete sound"] = "Open mail complete sound"
L["Opens the Destroying frame if there's stuff in your bags to be destroyed."] = "가방 안에 뽀각될 수 있는 물건이 있을 경우 마력 추출 창 열기"
L["Operation"] = "작업"
L["Operations"] = "작업"
L["Options specific to Sniper are below."] = "Options specific to Sniper are below."
L["Order Confirmation"] = "구매 확인"
L["Orgrimmar"] = "오그리마"
L["Oribos Exchange Realm Price"] = "Oribos Exchange Realm Price"
L["Oribos Exchange Region Price"] = "Oribos Exchange Region Price"
L["Other"] = "다른"
L["Other Character"] = "다른 캐릭터"
L["Override Parent Operations"] = "Override Parent Operations"
L["Override default craft value"] = "기본 제작 비용 무시하기"
L["PROFIT"] = "이익"
L["Parent Items"] = "상위 그룹의 아이템"
L["Pausing Scan..."] = "스캔을 중지하는중..."
L["Per Item"] = "개당 가격"
L["Per Stack"] = "Per Stack"
L["Performing a dry-run of your Mailing operations for the selected groups."] = "Performing a dry-run of your Mailing operations for the selected groups."
L["Player Gold"] = "플레이어 골드"
L["Player Invite Accept"] = "초대 효과음"
L["Post"] = "Post"
L["Post / Cancel"] = "Post / Cancel"
L["Post Auction"] = "Post Auction"
L["Post Items from Bags"] = "Post Items from Bags"
L["Post Quantity"] = "Post Quantity"
L["Post Scan"] = "Post Scan"
L["Post Selected"] = "Post Selected"
L["Post at Maximum Price"] = "최대 가격에 올리기"
L["Post at Minimum Price"] = "Post at Minimum Price"
L["Post at Normal Price"] = "Post at Normal Price"
L["Post cap"] = "Post cap"
L["Post cap to bags"] = "Post cap to bags"
L["Post from Shopping Scan"] = "Post from Shopping Scan"
L["Postage"] = "우편요금"
L["Posted at whitelisted player's price."] = "Posted at whitelisted player's price."
L["Posted:"] = "Posted:"
L["Posting"] = "Posting"
L["Posting %d / %d"] = "Posting %d / %d"
L["Posting %d items for %s hours."] = "Posting %d items for %s hours."
L["Posting %d stack(s) of %d for %s hours."] = "Posting %d stack(s) of %d for %s hours."
L["Posting Options"] = "올리기 옵션"
L["Posting Price"] = "Posting Price"
L["Posting at normal price."] = "평시 가격으로 올리기"
L["Posting at whitelisted player's price."] = "화이트리스트에 있는 플레이어의 가격으로 올리기."
L["Posting at your current price."] = "당신의 현재가로 올리기"
L["Posting disabled."] = "올리기 비활성화됨."
L["Posts"] = "Posts"
L["Potential"] = "Potential"
L["Prepare Bid"] = "입찰 준비"
L["Prepare Buy"] = "구매 준비"
L["Preparing..."] = "준비중..."
L["Prevent closing the Auction House with the esc key"] = "ESC 키 경매장 꺼짐 방지"
L["Primary"] = "Primary"
L["Primary Alt"] = "Primary Alt"
L["Prints out the available price sources for use in custom prices"] = "Prints out the available price sources for use in custom prices"
L["Prints out the version numbers of all installed modules"] = "Prints out the version numbers of all installed modules"
L["Prints the slash command help listing"] = "Prints the slash command help listing"
L["Profession"] = "전문 기술"
L["Profession Info"] = "전문 기술 정보"
L["Professions Used In"] = "사용처"
L["Profile changed to '%s'."] = "프로필이 '%s' 으로 변경되었습니다."
L["Profiles"] = "프로필"
L["Profit"] = "이익"
L["Profit (Total)"] = "이익 (종합)"
L["Prospect"] = "Prospect"
L["Prospect Value"] = "전망가"
L["Purchase"] = "구매"
L["Purchase / Sale Info"] = "구매 / 판매 정보"
L["Purchase Data"] = "구매 데이터"
L["Purchase Item"] = "아이템 구매하기"
L["Purchase information"] = "구매 정보"
L["Purchased (Min/Avg/Max Price)"] = "구매 (최소/평균/최대 가격)"
L["Purchased (Total Price)"] = "Purchased (Total Price)"
L["Purchases"] = "구매"
L["Purchasing Auction"] = "Purchasing Auction"
L["Puts items matching the item or partial text entered into the bank or guild bank."] = "Puts items matching the item or partial text entered into the bank or guild bank."
L["Qty"] = "수량"
L["Quantity"] = "수"
L["Quantity Purchased:"] = "구매한 양:"
L["Quantity Sold:"] = "판매된 수량:"
L["Quantity to move"] = "Quantity to move"
L["Quest Added"] = "퀘스트 추가음"
L["Quest Completed"] = "퀘스트 완료음"
L["Quest Objectives Complete"] = "퀘스트 물건 수집완료음"
L["Queue"] = "대기열에 올리기"
L["Queue (%d)"] = "Queue (%d)"
L["Queue Summary"] = "Queue Summary"
L["Quickly mail all excess disenchantable items to a character"] = "초과된 추출물을 캐릭터로 우편 보내기."
L["Quickly mail all excess gold (limited to a certain amount) to a character"] = "초과된 골드를 신속히 캐릭터로 옮기기 (일부 금액에 한정)."
L["Raid Warning"] = "공격대 경보음"
L["Rank %d"] = "Rank %d"
L["Read More"] = "더 읽기"
L["Ready Check"] = "준비완료 확인음"
L["Ready to Cancel"] = "취소 준비 완료"
L["Reagent Quality"] = "Reagent Quality"
L["Recent"] = "최근"
L["Recent Scans"] = "최근 스캔"
L["Recent Searches"] = "최근 검색"
L["Recent Value"] = "Recent Value"
L["Recent value"] = "Recent value"
L["Recipe Name"] = "도안 이름"
L["Recipient"] = "수취인"
L["Region Avg Daily Sold"] = "지역 일평균 판매량"
L["Region Historical Price"] = "Region Historical Price"
L["Region Market Value Avg"] = "Region Market Value Avg"
L["Region Sale Avg"] = "Region Sale Avg"
L["Region Sale Rate"] = "지역 판매율"
L["Region avg daily sold"] = "지역 일평균 판매량"
L["Region historical price"] = "Region historical price"
L["Region market value"] = "Region market value"
L["Region market value and trend"] = "Region market value and trend"
L["Region sale avg"] = "Region sale avg"
L["Region sale rate"] = "지역 판매량"
L["Reload"] = "리로드"
L["Reload UI (%02d)"] = "UI 리로드 (%02d)"
L["Reload UI (%d)"] = "UI 리로드 (%d)"
L["Remove"] = "제거하기"
L["Remove %d |4Item:Items"] = "Remove %d |4Item:Items"
L["Remove Data Older Than (Days)"] = "다음보다 오래된 기록 지우기 (일)"
L["Remove this account sync and all synced data from this account"] = "Remove this account sync and all synced data from this account"
L["Removed a total of %s old records."] = "전체 %s 의 오래된 기록이 제거되었습니다."
L["Removed custom price source (%s) which has an invalid name."] = "유효하지 않은 이름의 커스텀 가격 소스 (%s) 가 제거되었습니다."
L["Rename"] = "이름 변경"
L["Rename Profile"] = "프로파일 이름 변경하기"
L["Rename Search"] = "검색 변경하기"
L["Rename the profile"] = "프로파일 이름 변경하기"
L["Rename this group"] = "그룹 이름 변경하기"
L["Repair"] = "수리"
L["Repair Bill"] = "수리비"
L["Repair from Guild Bank"] = "길드 은행에서 수리하기"
L["Replace %d existing operations and %d existing custom sources?"] = "Replace %d existing operations and %d existing custom sources?"
L["Replace %d existing operations?"] = "Replace %d existing operations?"
L["Reply"] = "회신하기"
L["Report Spam"] = "스팸 신고"
L["Reports"] = "리포트"
L["Repost threshold"] = "다시 올리기 한도"
L["Required Level"] = "요구 레벨"
L["Required Level Range"] = "요구 레벨 구간"
L["Resale"] = "재판매"
L["Rescan"] = "다시 스캔하기"
L["Reset"] = "초기화"
L["Reset All Filters"] = "모든 필터 초기화"
L["Reset Filters"] = "필터 초기화"
L["Reset Operation?"] = "작업을 초기화할까요?"
L["Reset Profile?"] = "프로필을 초기화할까요?"
L["Reset Table"] = "표 초기화하기"
L["Reset Zoom"] = "확대 초기화"
L["Reset the current profile to default settings"] = "현재 프로파일을 기본 설정으로 초기화하기"
L["Reset to Default"] = "기본값으로 초기화"
L["Resetting the operation will return all inputs back to default and cannot be unddone. Click confirm to reset."] = "이 작업을 초기화하면 입력값이 기본값으로 돌아가고, 되돌릴 수 없습니다. 확인을 눌러 초기화하세요."
L["Restart"] = "재시작"
L["Restart delay (minutes)"] = "재시작 지연시간 (분)"
L["Restock Groups"] = "Restock Groups"
L["Restock Options"] = "Restock Options"
L["Restock TSM Groups"] = "Restock TSM Groups"
L["Restock bags"] = "Restock bags"
L["Restock help for %s: %s"] = "Restock help for %s: %s"
L["Restock quantity"] = "Restock quantity"
L["Restock target to max quantity"] = "Restock target to max quantity"
L["Restocking to %d."] = "Restocking to %d."
L["Restocking with a min profit."] = "Restocking with a min profit."
L["Restocking with no min profit."] = "Restocking with no min profit."
L["Restore bags"] = "Restore bags"
L["Resuming Scan..."] = "스캔 다시 시작하는중..."
L["Retail Region-Wide Tracking"] = "Retail Region-Wide Tracking"
L["Retrying %d auction(s) which failed."] = "Retrying %d auction(s) which failed."
L["Revenue"] = "수익"
L["Right-Click to reset the window size, scale, and position to their defaults."] = "오른쪽 클릭하여 창의 크기, 스케일, 위치를 초기값으로 리셋하세요."
L["Run Advanced Item Search"] = "고급 아이템 검색 시작하기"
L["Run Bid Sniper"] = "입찰 저격 시작하기"
L["Run Buyout Sniper"] = "즉시 구매 Sniper 가동하기"
L["Run Cancel Scan"] = "취소 스캔 시작하기"
L["Run Post Scan"] = "올리기 스캔 시작하기"
L["Run Shopping Scan"] = "쇼핑 스캔 시작하기"
L["Running Sniper Scan"] = "Running Sniper Scan"
L["SALES"] = "소득"
L["SCAN ALL"] = "모두 스캔하기"
L["SCANNING"] = "검색 중"
L["SENDING"] = "보내는중"
L["SHIFT"] = "SHIFT"
L["SOURCE %d"] = "SOURCE %d"
L["Sale"] = "판매"
L["Sale Data"] = "판매 데이터"
L["Sale Price"] = "판매 가격"
L["Sale Rate"] = "판매율"
L["Sale information"] = "판매 정보"
L["Sale rate"] = "판매율"
L["Sales"] = "판매"
L["Salvage"] = "Salvage"
L["Save & Close"] = "Save & Close"
L["Saved"] = "Saved"
L["Scan"] = "스캔"
L["Scan Paused"] = "스캔 일시 정지됨"
L["Scan complete sound"] = "스캔 완료 알림음"
L["Scan was slowed down by %s seconds by other AH addons (%s seconds by %s)."] = "다른 경매 에드온에 의해 스캔이 %s 초 느려졌습니다.(%s 초가 %s 에 의해)"
L["Scanning"] = "검색 중"
L["Scanning (%d Items)"] = "스캔하는중 (%d 아이템)"
L["Scroll Wheel Options"] = "스크롤 휠 옵션"
L["Scroll wheel direction"] = "스크롤 휠 방향"
L["Search"] = "검색"
L["Search %s operations"] = "Search %s operations"
L["Search Bags"] = "가방 검색"
L["Search Groups"] = "그룹 검색"
L["Search Operations"] = "작업 검색"
L["Search Patterns"] = "도안 검색하기"
L["Search Results"] = "Search Results"
L["Search Vendor"] = "Search Vendor"
L["Search items"] = "아이탬 검색"
L["Search items in group"] = "그룹에서 아이템 검색"
L["Search items in mailbox"] = "우편함에서 아이템 검색"
L["Search the auction house"] = "경매장 검색"
L["Select / Deselect All Groups"] = "Select / Deselect All Groups"
L["Select / Deselect All Items"] = "Select / Deselect All Items"
L["Select / Deselect All Results"] = "Select / Deselect All Results"
L["Select Action"] = "Select Action"
L["Select All"] = "모두 선택"
L["Select Auction to Cancel"] = "Select Auction to Cancel"
L["Select Crafted Item Quality"] = "Select Crafted Item Quality"
L["Select Group"] = "그룹 선택"
L["Select Items to Attach"] = "첨부할 아이템 선택하기"
L["Select a Source"] = "Select a Source"
L["Select an Auction to Buy"] = "Select an Auction to Buy"
L["Select crafter"] = "Select crafter"
L["Select included subgroups"] = "Select included subgroups"
L["Select professions"] = "전문 기술 선택"
L["Selected Items (%d)"] = "Selected Items (%d)"
L["Sell"] = "판매"
L["Sell All"] = "Sell All"
L["Sell BoEs"] = "착귀 판매"
L["Sell Groups"] = "Sell Groups"
L["Sell Options"] = "Sell Options"
L["Sell Trash"] = "잡템 판매"
L["Sell soulbound items"] = "귀속된 아이템 판매"
L["Sell to Vendor"] = "상인에게 판매"
L["Seller"] = "판매자"
L["Selling soulbound items."] = "Selling soulbound items."
L["Send"] = "발송"
L["Send Disenchantables"] = "Send Disenchantables"
L["Send Excess Gold to Banker"] = "초과된 골드를 창고 캐릭으로 옮기기"
L["Send Gold"] = "골드 보내기"
L["Send Mail"] = "우편 발송하기"
L["Send Money"] = "돈 보내기"
L["Send grouped items individually"] = "Send grouped items individually"
L["Send your active profile to this synced account"] = "Send your active profile to this synced account"
L["Sender"] = "Sender"
L["Sending %s to %s"] = "%s 을(를) %s 님에게 보냄."
L["Sending %s to %s with a COD of %s"] = "%s 를 %s 에게 금액 %s 만큼 대금청구를 보냈습니다."
L["Sending Settings"] = "Sending Settings"
L["Sending your '%s' profile to %s. Please keep both characters online until this completes. This will take approximately: %s"] = "당신의 '%s' 프로필을 %s 님에게 보내는 중입니다. 완료될 때까지 두 캐릭터를 온라인 상태로 유지하세요. 이는 대략 다음 시간이 소요됩니다: %s"
L["Sending..."] = "보내는 중"
L["Set bid as percentage of buyout"] = "Set bid as percentage of buyout"
L["Set how items are moved out of the bank."] = "Set how items are moved out of the bank."
L["Set how items are restocked from the bank."] = "Set how items are restocked from the bank."
L["Set keep in bags quantity"] = "Set keep in bags quantity"
L["Set keep in bank quantity"] = "Set keep in bank quantity"
L["Set max quantity"] = "Set max quantity"
L["Set min profit"] = "Set min profit"
L["Set move quantity"] = "Set move quantity"
L["Set stack size"] = "Set stack size"
L["Set stack size for restock"] = "Set stack size for restock"
L["Set what is bought from a vendor."] = "Set what is bought from a vendor."
L["Set what is sold to a vendor."] = "Set what is sold to a vendor."
L["Set what items are shown during a Shopping scan."] = "Set what items are shown during a Shopping scan."
L["Set what items are shown during a Sniper scan."] = "Set what items are shown during a Sniper scan."
L["Set your active profile or create a new one."] = "활성화할 프로필을 설정하거나 새로 만듭니다."
L["Settings"] = "설정"
L["Setup various sounds that play when doing Auctioning scans."] = "Setup various sounds that play when doing Auctioning scans."
L["Share operations between all profiles"] = "Share operations between all profiles"
L["Shopping"] = "쇼핑"
L["Shopping %s button"] = "Shopping %s button"
L["Shopping Operation Max Price"] = "Shopping Operation Max Price"
L["Shopping for auctions including those above the max price."] = "Shopping for auctions including those above the max price."
L["Shopping for auctions with a max price set."] = "Shopping for auctions with a max price set."
L["Shopping operation"] = "쇼핑 작업"
L["Shopping operations control buyout from the AH."] = "Shopping operations control buyout from the AH."
L["Shortfall to bags"] = "Shortfall to bags"
L["Show auctions above max price"] = "Show auctions above max price"
L["Show confirmation alert if buyout is above the alert price"] = "Show confirmation alert if buyout is above the alert price"
L["Show destroying frame automatically"] = "마력 추출 창 자동으로 보이기"
L["Show on modifier"] = "조합키 눌렀을 때 보이기"
L["Show only auctions with bids"] = "입찰건이 있는 경매만 보이기"
L["Show results as:"] = "Show results as:"
L["Show total gold in header"] = "Show total gold in header"
L["Show ungrouped items as:"] = "Show ungrouped items as:"
L["Showing %s Mail"] = "%s 우편 표시중"
L["Showing %s of %d Mail"] = "Showing %s of %d Mail"
L["Showing %s of %d Mails"] = "Showing %s of %d Mails"
L["Showing all %s Mails"] = "모든 %s 우편 보는중"
L["Simple convert tooltip"] = "Simple convert tooltip"
L["Simple destroy tooltip"] = "Simple destroy tooltip"
L["Simple inventory"] = "Simple inventory"
L["Skip"] = "스킵"
L["Skipped:"] = "Skipped:"
L["Skipped: No assigned operation"] = "Skipped: No assigned operation"
L["Slash Commands:"] = "슬래시 명령어:"
L["Smart Avg Buy Price"] = "Smart Avg Buy Price"
L["Sniper"] = "Sniper"
L["Sniper %s button"] = "Sniper %s button"
L["Sniper Below Price"] = "Sniper Below Price"
L["Sniper Operation Below Price"] = "Sniper Operation Below Price"
L["Sniper Options"] = "Sniper Options"
L["Sniper operation"] = "Sniper operation"
L["Sniper operations control sniping from the AH."] = "Sniper operations control sniping from the AH."
L["Sniping items below a max price"] = "Sniping items below a max price"
L["Sold"] = "판매됨"
L["Sold %d of %s to %s for %s"] = "Sold %d of %s to %s for %s"
L["Sold %s worth of items."] = "Sold %s worth of items."
L["Sold (Min/Avg/Max Price)"] = "Sold (Min/Avg/Max Price)"
L["Sold (Total Price)"] = "Sold (Total Price)"
L["Sold [%s]x%d for %s to %s"] = "Sold [%s]x%d for %s to %s"
L["Sold for:"] = "Sold for:"
L["Some general Accounting options are below."] = "Some general Accounting options are below."
L["Some general Auctioning options are below."] = "Some general Auctioning options are below."
L["Some general Browse/Sniper options are below."] = "Some general Browse/Sniper options are below."
L["Some general TSM options are below."] = "TSM 일반 설정들이 아래에 표시됩니다."
L["Some general appearance options are below."] = "Some general appearance options are below."
L["Some general options for the TSM tooltip information are below."] = "TSM 툴팁 설정들이 아래에 표시됩니다."
L["Some options for the Disenchant Search are below."] = "Some options for the Disenchant Search are below."
L["Source"] = "Source"
L["Sources"] = "출처"
L["Sources to include for restock"] = "Sources to include for restock"
L["Specific Item"] = "Specific Item"
L["Stack"] = "묶음"
L["Stack / Quantity"] = "묶음 / 수량"
L["Stack size"] = "묶음의 크기"
L["Stack size multiple"] = "Stack size multiple"
L["Stack(s)"] = "묶음"
L["Start either a 'Buyout' or 'Bid' sniper using the buttons above."] = "아래 버튼을 사용하여 '즉시 구매' 혹은 '입찰' Sniper를 시작하세요."
L["Starting Scan..."] = "스캔 시작..."
L["Stormwind"] = "스톰윈드"
L["String"] = "String"
L["Subject"] = "제목"
L["Subject & Description added"] = "Subject & Description added"
L["Successfully sent your '%s' profile to %s!"] = "성공적으로 당신의 '%s' 프로필을 %s로 전송하였습니다!"
L["Supported value range: %d - %d"] = "가능한 값의 범위: %d - %d"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["Switch to %s"] = "%s로 넘어가기"
L["Sync Setup Error: The specified player on the other account is not currently online."] = "Sync Setup Error: The specified player on the other account is not currently online."
L["Sync Setup Error: This character is already part of a known account."] = "동기화 설정 오류: 이 캐릭터는 이미 알려진 계정에 속합니다."
L["Sync Setup Error: You entered the name of the current character and not the character on the other account."] = "동기화 설정 오류: 다른 계정의 캐릭터 이름을 입력해야하지만 현재 캐릭터의 이름이 입력되었습니다."
L["Sync Status"] = "동기화 상태"
L["TOP PURCHASE"] = "최대 매수액"
L["TOP SALE"] = "최대 매출액"
L["TSM %s: What's new"] = "TSM %s: What's new"
L["TSM Accounting"] = "TSM Accounting"
L["TSM AuctionDB"] = "TSM AuctionDB"
L["TSM Auctioning"] = "TSM Auctioning"
L["TSM Crafting"] = "TSM Crafting"
L["TSM Desktop App Status (%s)"] = "TSM 데스크탑 앱 상태 (%s)"
L["TSM General Info"] = "TSM 일반 정보"
L["TSM Shopping"] = "TSM 쇼핑"
L["TSM Sniper"] = "TSM Sniper"
L["TSM TASK LIST"] = "TSM 작업 리스트"
L["TSM Version Info:"] = "TSM 버전 정보:"
L["TSM can automatically sync data between multiple WoW accounts."] = "TSM은 여러 와우 계정 사이에서 자동으로 데이터를 동기화할 수 있습니다."
L["TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"] = "TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"
L["TSM doesn't currently have any AuctionDB pricing data for your realm. We recommend you download the TSM Desktop Application from %s to automatically update your AuctionDB data (and auto-backup your TSM settings)."] = "TSM이 당신의 서버에 대한 AuctionDB를 갖고 있지 않습니다. %s에서 TSM 데스크탑 어플을 다운받아 자동으로 AuctionDB를 업데이트 받고 TSM 설정을 자동으로 백업할 것을 추천합니다."
L["TSM failed to scan some auctions. Please rerun the scan."] = "TSM이 몇몇 경매 스캔에 실패했습니다. 스캔으로 돌아가세요."
L["TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."] = "TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."
L["TSM is missing important information from the TSM Desktop Application. Please ensure the TSM Desktop Application is running and is properly configured."] = "TSM 데스크톱 애플리케이션에서 중요한 정보가 누락되었습니다. TSM 데스크톱 애플리케이션이 실행 중이며 제대로 구성되어 있는지 확인해 주세요."
L["TSM is not yet ready to establish a new sync connection. Please try again later."] = "TSM이 새로운 동기화 연결하기 위한 준비를 마치지 못했습니다. 나중에 시도하세요."
L["TSM will not undercut any players you add to your whitelist."] = "TSM은 화이트리스트에 있는 어떠한 플레이어도 언더컷 하지 않을 것입니다."
L["TSM4"] = "TSM4"
L["Target character"] = "목표 캐릭터"
L["Target shortfall to bags"] = "Target shortfall to bags"
L["Tasks Added to Task List"] = "Tasks Added to Task List"
L["Tells you why a specific item is not being restocked and added to the queue."] = "Tells you why a specific item is not being restocked and added to the queue."
L["Text (%s)"] = "문자 (%s)"
L["The '%s' function has an invalid number of arguments."] = "The '%s' function has an invalid number of arguments."
L["The '%s' item parameter was used outside of a custom source."] = "The '%s' item parameter was used outside of a custom source."
L["The 'Craft Value Method' did not return a value for this item."] = "The 'Craft Value Method' did not return a value for this item."
L["The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."] = "The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."
L["The AH does not support specifying a copper value (only gold and silver)."] = "The AH does not support specifying a copper value (only gold and silver)."
L["The Base Group contains all ungrouped items in the game. Use the search and filter controls to find items to add to other groups."] = "그룹화되지 않은 게임 내 모든 아이템은 기본 그룹에 포함됩니다. 검색과 필터를 사용하여 다른 그룹에 추가할 아이템을 찾아보세요."
L["The TradeSkillMaster_AppHelper addon is installed, but not enabled. TSM has enabled it and requires a reload."] = "TradeSkillMaster_AppHelper 에드온이 설치되었지만, 활성화 될 수 없습니다. TSM이 그것을 활성화 했고, 리로드가 필요합니다."
L["The buyout price for %s would be above the maximum allowed price. Skipping this item."] = "%s에 대한 즉시 구매 가격은 허용된 최대 가격을 넘어섭니다. 이 아이템은 스킵됩니다."
L["The canlearn filter was ignored because the CanIMogIt addon was not found."] = "The canlearn filter was ignored because the CanIMogIt addon was not found."
L["The max quantity cannot be zero."] = "최대 수량은 0이 될 수 없습니다."
L["The min profit did not evaluate to a valid value for this item."] = "The min profit did not evaluate to a valid value for this item."
L["The name portion of the search term must be at least 3 characters if present."] = "The name portion of the search term must be at least 3 characters if present."
L["The pasted value was not valid. Ensure you are pasting the entire import string."] = "붙여 넣은 값은 유효하지 않습니다. 전체 값을 붙여 넣었는지 확인하세요."
L["The player \\\"%s\\\" is already on your whitelist."] = "The player \\\"%s\\\" is already on your whitelist."
L["The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."] = "The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."
L["The profit of this item (%s) is below the min profit (%s)."] = "The profit of this item (%s) is below the min profit (%s)."
L["The same filter was specified multiple times."] = "동일한 필터가 여러번 지정되었습니다."
L["The search term must be at least 3 characters."] = "검색어는 최소한 3글자여야 합니다."
L["The seller name of the lowest auction for %s was not given by the server. Skipping this item."] = "The seller name of the lowest auction for %s was not given by the server. Skipping this item."
L["The specified filter was empty."] = "지정된 필터는 비어있습니다."
L["The specified item is not supported for crafting searches."] = "The specified item is not supported for crafting searches."
L["The specified item is not supported for disenchant searches."] = "The specified item is not supported for disenchant searches."
L["The specified item was not found."] = "지정된 아이템을 찾을 수 없습니다."
L["The unlearned filter was ignored because the CanIMogIt addon was not found."] = "The unlearned filter was ignored because the CanIMogIt addon was not found."
L["The value must be greater than 0."] = "The value must be greater than 0."
L["The value must be greater than or equal of 0."] = "The value must be greater than or equal of 0."
L["The value was greater than the maximum allowed auction house price."] = "The value was greater than the maximum allowed auction house price."
L["Themes"] = "테마"
L["There are unbalanced parentheses in this custom string."] = "There are unbalanced parentheses in this custom string."
L["There is currently no profession open, so cannot create profession groups."] = "There is currently no profession open, so cannot create profession groups."
L["There is no Crafting operation applied to this item's TSM group (%s)."] = "There is no Crafting operation applied to this item's TSM group (%s)."
L["This custom string is too complex for WoW to handle; use custom sources to simplify it."] = "This custom string is too complex for WoW to handle; use custom sources to simplify it."
L["This is not a valid profile name. Profile names must be at least one character long and may not contain '@' characters."] = "유효한 프로필 이름이 아닙니다. 프로필 이름은 최소한 한 글자 이상이어야 하며 '@' 글자를 사용할 수 없습니다."
L["This item does not have a crafting cost. Check that all of its mats have mat prices."] = "This item does not have a crafting cost. Check that all of its mats have mat prices."
L["This item is not in a TSM group."] = "이 아이템은 TSM 그룹에 없습니다."
L["This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."] = "This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."
L["This operation is applied to the base group which includes every item not in another group."] = "This operation is applied to the base group which includes every item not in another group."
L["This price is above your confirmation alert threshold."] = "This price is above your confirmation alert threshold."
L["This price is above your material value."] = "This price is above your material value."
L["This profession is not open."] = "전문 기술 창이 열려있지 않습니다."
L["This record belongs to another account and can only be deleted on that account."] = "이 기록은 다른 계정에 연결되어 있기 때문에 그 계정에서만 삭제될 수 있습니다."
L["This will permanently delete the '%s' profile."] = "이는 '%s' 프로필을 영구적으로 제거합니다."
L["This will reset all groups and operations (if not stored globally) to be wiped from '%s'."] = "This will reset all groups and operations (if not stored globally) to be wiped from '%s'."
L["Time"] = "시간"
L["Time Frame"] = "기간"
L["Tinker"] = "Tinker"
L["Toggles the TSM Banking UI if either the bank or guild bank is currently open."] = "은행이나 길드 은행 창이 열려 있을 경우 TSM 은행 UI 켜기"
L["Toggles the TSM Crafting UI."] = "TSM 제작 UI 열기."
L["Toggles the TSM Task List UI"] = "Toggles the TSM Task List UI"
L["Toggles the main TSM window"] = "메인 TSM 화면 켜기"
L["Tooltip Options"] = "툴팁 옵션"
L["Tooltip Settings"] = "툴팁 설정"
L["Tooltip price format"] = "툴팁 금액 형식"
L["Top Buyers"] = "최고 구매자"
L["Top Item"] = "최고 아이템"
L["Top Sellers"] = "최고 판매자"
L["Total"] = "총"
L["Total Gold"] = "총 골드"
L["Total Gold Collected: %s"] = "총 수집된 골드: %s"
L["Total Gold Earned"] = "획득한 전체 골드"
L["Total Gold Spent"] = "총 소비한 골드"
L["Total Inventory Quantity"] = "전체 인벤토리 수량"
L["Total Items"] = "전체 아이템"
L["Total Postage"] = "전체 우편요금"
L["Total Price"] = "총 가격"
L["Total Prices:"] = "Total Prices:"
L["Total Profit"] = "전체 이익"
L["Total Value"] = "총 가치"
L["Track Sales / Purchases via trade"] = "물물교환한 판매 / 구매 기록하기"
L["Transform"] = "Transform"
L["Transform Value"] = "Transform Value"
L["Type"] = "유형"
L["Uncollected Only"] = "Uncollected Only"
L["Undercut amount"] = "Undercut amount"
L["Undercut by whitelisted player."] = "화이트리스트에 있는 플레이어에 의해 언더컷됨."
L["Undercutting blacklisted player."] = "블랙리스트의 플레이어를 언더컷하기"
L["Undercutting competition."] = "언더컷 완료."
L["Unexpected word ('%s') in custom string."] = "Unexpected word ('%s') in custom string."
L["Ungrouped Items"] = "그룹화되지 않은 아이템"
L["Ungrouped Items in Bags"] = "그룹화되지 않은 가방 안 아이템"
L["Unit Price"] = "Unit Price"
L["Unknown Item"] = "Unknown Item"
L["Unknown word (%s)."] = "Unknown word (%s)."
L["Unlock Column Width"] = "열 너비 고정 해제"
L["Unwrap Gift"] = "선물포장지 오픈음"
L["Up"] = "위"
L["Up to date"] = "최신"
L["Update existing macro"] = "Update existing macro"
L["Updating"] = "업데이트중"
L["Upgrades Only"] = "Upgrades Only"
L["Usable Only"] = "Usable Only"
L["Usage: /tsm price <Item Link> <Custom String>"] = "Usage: /tsm price <Item Link> <Custom String>"
L["Use the settings below to control which lines are shown in tooltips."] = "Use the settings below to control which lines are shown in tooltips."
L["Use this list to manage what cooldowns you'd like TSM to ignore from crafting."] = "Use this list to manage what cooldowns you'd like TSM to ignore from crafting."
L["Use this list to manage what items you'd like TSM to ignore from destroying."] = "Use this list to manage what items you'd like TSM to ignore from destroying."
L["Value"] = "가격"
L["Value Price Source"] = "Value Price Source"
L["Value must be between %d and %d."] = "값은 반드시 %d 와 %d 사이어야 합니다."
L["Values"] = "가격"
L["Vendor"] = "상인"
L["Vendor Buy Price"] = "Vendor Buy Price"
L["Vendor Search"] = "Vendor Search"
L["Vendor Sell"] = "Vendor Sell"
L["Vendor Sell Price"] = "Vendor Sell Price"
L["Vendor Trade"] = "Vendor Trade"
L["Vendor Trade Value"] = "Vendor Trade Value"
L["Vendor buy price"] = "Vendor buy price"
L["Vendor sell price"] = "Vendor sell price"
L["Vendoring"] = "Vendoring"
L["Vendoring %s button"] = "Vendoring %s button"
L["Vendoring operation"] = "Vendoring operation"
L["Vendoring operations control selling to and buying from a vendor."] = "Vendoring operations control selling to and buying from a vendor."
L["WARNING: The macro was too long, so was truncated to fit by WoW."] = "경고: 매크로가 너무 깁니다, 적당한 길이로 조정할것"
L["WARNING: Your minimum price for %s is below its vendorsell price (with AH cut taken into account). Consider raising your minimum price, or vendoring the item."] = "경고: %s에 대한 당신의 최소 가격은 상인 판매 금액보다 낮습니다(경매장 수수료 포함). 최소 가격을 올리거나, 상인에 판매하는 것을 고려하세요."
L["WOW UI"] = "와우UI"
L["Warehousing"] = "창고"
L["Warehousing operation"] = "Warehousing operation"
L["Warehousing operations control moving in and out of the bank."] = "Warehousing operations control moving in and out of the bank."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."
L["Warehousing will move a max of %d of each item in this group."] = "Warehousing will move a max of %d of each item in this group."
L["Warehousing will move a max of %d of each item in this group. Restock will maintain %d items in your bags."] = "Warehousing will move a max of %d of each item in this group. Restock will maintain %d items in your bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank."] = "Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags."
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."
L["Warehousing will move all of the items in this group."] = "Warehousing will move all of the items in this group."
L["Warehousing will move all of the items in this group. Restock will maintain %d items in your bags."] = "Warehousing will move all of the items in this group. Restock will maintain %d items in your bags."
L["When above maximum:"] = "When above maximum:"
L["When below minimum:"] = "When below minimum:"
L["Whitelist"] = "화이트리스트"
L["Whitelisted characters"] = "화이트리스트에 있는 캐릭터"
L["Winamp"] = "Winamp"
L["Would send %s to %s"] = "Would send %s to %s"
L["Would send %s to %s with a COD of %s"] = "%s 아이템을 %s 님에게 골드 %s 대금청구를 보내시겠습니까?"
L["Yes, I'm sure"] = "Yes, I'm sure"
L["Yes, I'm sure (%02d)"] = "Yes, I'm sure (%02d)"
L["You are not on one of the listed characters."] = "리스트에 있는 캐릭터를 하고 있지 않습니다."
L["You can clear old Accounting data for the current realm below to keep things running smoothly."] = "You can clear old Accounting data for the current realm below to keep things running smoothly."
L["You can import custom themes by pasting an import string into the box below."] = "You can import custom themes by pasting an import string into the box below."
L["You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"] = "You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"
L["You can now group pets by level, just like items."] = "You can now group pets by level, just like items."
L["You can use the export string below to share this custom theme with others."] = "You can use the export string below to share this custom theme with others."
L["You can use the export string below to share this group with others."] = "You can use the export string below to share this group with others."
L["You cannot use %s as part of this custom price."] = "이 사용자 가격의 일부분으로 %s|1을;를; 사용할 수 없습니다."
L["You do not need to add \\\"%s\\\", alts are whitelisted automatically."] = "You do not need to add \\\"%s\\\", alts are whitelisted automatically."
L["You don't know how to craft this item."] = "이 아이템의 제조법을 배우지 않았습니다."
L["You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."] = "You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."
L["You must reload your UI for these settings to take effect. Reload now?"] = "이 설정을 적용하기 위해서는 UI를 다시 불러와야 합니다 . 지금 리로드할까요?"
L["You won an auction for %sx%d for %s"] = "%sx%d 경매에 가격 %s 으로 낙찰되었습니다"
L["You've been phased which has caused the AH to stop working due to a bug on Blizzard's end. Please close and reopen the AH and restart Sniper."] = "You've been phased which has caused the AH to stop working due to a bug on Blizzard's end. Please close and reopen the AH and restart Sniper."
L["You've been undercut."] = "당신은 언더컷 되었습니다."
L["Your Buyout"] = "나의 즉시 구매"
L["Your auction has not been undercut."] = "Your auction has not been undercut."
L["Your auction of %s expired"] = "당신의 %s 경매가 만료되었습니다."
L["Your auction of %s has sold for %s!"] = "당신의 경매물품 %s (이)가 %s 에 판매되었습니다!"
L["Your auction of %s has sold!"] = "Your auction of %s has sold!"
L["Your craft value method for '%s' was invalid so it has been returned to the default. Details: %s"] = "Your craft value method for '%s' was invalid so it has been returned to the default. Details: %s"
L["Your default craft value method was invalid so it has been returned to the default. Details: %s"] = "Your default craft value method was invalid so it has been returned to the default. Details: %s"
L["Your max restock (%s) is invalid for %s."] = "Your max restock (%s) is invalid for %s."
L["Your min restock (%s) is invalid for %s."] = "Your min restock (%s) is invalid for %s."
L["Your restock quantity is invalid. It must be between %d and %s."] = "Your restock quantity is invalid. It must be between %d and %s."
L["Your task list is currently empty."] = "당신의 작업 리스트가 비어있습니다."
L["ilvl"] = "아이템 레벨"
-- LOCALE STRINGS END HERE

Locale.SetTable(L)
