-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                          https://tradeskillmaster.com                          --
--    All Rights Reserved - Detailed license information included with addon.     --
-- ------------------------------------------------------------------------------ --

local TSM = select(2, ...) ---@type TSM
local Locale = TSM.Include("Locale")
if not Locale.ShouldLoad("zhCN") then return end
local L = {}

-- LOCALE STRINGS START HERE
L["%d Characters"] = "%d个角色"
L["%d Custom Sources"] = "%d个自定义源"
L["%d Faction-Realms"] = "%d个阵营-服务器"
L["%d Groups"] = "%d个分组"
L["%d Groups Selected"] = "%d个已选择分组"
L["%d Guilds"] = "%d 公会"
L["%d Items"] = "%d个物品"
L["%d Operations"] = "%d个操作"
L["%d Players"] = "%d位玩家"
L["%d Professions"] = "%d个专业"
L["%d Rarities"] = "%d个稀有"
L["%d Results"] = "%d个结果"
L["%d Selected"] = "已选择%d个"
L["%d Sources"] = "%d个来源"
L["%d Sub-Groups"] = "%d个子分组"
L["%d Types"] = "%d个类型"
L["%d auctions"] = "%d个拍卖"
L["%d groups"] = "%d个分组"
L["%d groups were created and %d items were added from the table."] = "已创建%d个分组，并从表单添加了%d个物品"
L["%d of %d"] = "%d堆，每堆%d个"
L["%d subgroups included"] = "包含%d个子分组"
L["%d |4Group:Groups; Selected (%d |4Item:Items;)"] = "%d |4组:组; 已选 (%d|4项:项;)"
L["%s %s Operations"] = "%s %s 操作"
L["%s (%s bags, %s bank, %s AH, %s mail)"] = "%s (%s 背包, %s 银行, %s 拍卖行, %s 邮件)"
L["%s (%s player, %s alts, %s AH)"] = "%s (%s 玩家, %s 小号, %s 拍卖行)"
L["%s (%s player, %s alts, %s guild, %s AH)"] = "%s (%s 玩家, %s 小号, %s 公会, %s 拍卖行)"
L["%s (%s profit)"] = "%s (%s利润)"
L["%s - %s has been reset to default values."] = "%s - %s 已重置为默认值。"
L["%s Crafts"] = "%s 制造"
L["%s Items Bought"] = "已购买%s"
L["%s Items Cancelled"] = "%s物品已取消"
L["%s Items Expired"] = "%s物品已过期"
L["%s Items Resold"] = "%s物品已转售"
L["%s Items Selected"] = "已选择%s个物品"
L["%s Items Sold"] = "已售出%s件"
L["%s Items Total"] = "总计%s项"
L["%s Operations"] = "%s 操作"
L["%s Posted Auctions"] = "已发布%s项拍卖"
L["%s Posted Auctions (Filtered)"] = "%s发布了拍卖（已筛选）"
L["%s Sold Auctions"] = "%s已售拍卖"
L["%s Sold Auctions (Filtered)"] = "%s已售拍卖（已筛选）"
L["%s Total"] = "总计%s"
L["%s Total Profit"] = "%s总利润"
L["%s ago"] = "%s之前"
L["%s group is already up to date."] = "%s分组已更新"
L["%s group updated with %d items and %d materials."] = "%s分组已更新%d件物品和%d件材料"
L["%s in guild vault"] = "%s 在公会仓库"
L["%s is a valid custom price but %s is an invalid item."] = "%s 是一个有效的自定义价格但 %s 是一个无效物品。"
L["%s is a valid custom price but did not give a value for %s."] = "%s 是一个有效的自定义价格但没有为 %s 给出一个值。"
L["%s is not a valid custom price and gave the following error: %s"] = "%s 不是一个有效的自定义价格,错误信息: %s"
L["%s is not a valid source."] = "%s is not a valid source."
L["%s operation"] = "%s 操作"
L["%s operations"] = "%s 操作"
L["%s previously had the max number of operations, so removed %s."] = "%s 先前操作量已达最大值，所以移除 %s。"
L["%s removed."] = "%s已删除。"
L["%s sent you %s"] = "%s给你邮寄了%s"
L["%s sent you %s and %s"] = "%s给你邮寄了%s和%s"
L["%s sent you a COD of %s for %s"] = "%s给你发送了付款取货物品%s，价格%s"
L["%s sent you a message: %s"] = "%s发送给你一条消息：%s"
L["%s total"] = "共计%s"
L["%sDrag%s to move this button"] = "%s拖拽 %s移动按钮"
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."] = "%s重要提示：|r 当上次保存本服会计数据时，数据太大，WoW无法处理，为免损坏保存变量，所以自动清理了旧数据。已保留最后 %s 购买数据。"
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."] = "%s重要提示:|r 当上次保存本服会计数据时，数据太大，WoW无法处理，为免损坏保存变量，所以自动清理了旧数据。已保留最后 %s 销售数据。"
L["%sLeft-Click%s to open the main window"] = "%s左键单击%s打开主窗口"
L["%sLeft-Click|r to ignore an item for this session. Hold %sShift|r to ignore permanently. You can remove items from permanent ignore in the Vendoring settings."] = "%s左键单击|r将在此次任务中忽略一个物品。同时按住%sShift|r将永久忽略它。可在NPC商店设置中，从永久忽略列表中移除。"
L["'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."] = "'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."
L["'%s' is not a valid argument for convert()."] = "'%s' is not a valid argument for convert()."
L["'%s' is not a valid item argument."] = "'%s' is not a valid item argument."
L["(%d/500 Characters)"] = "(%d/500 个角色)"
L["(minimum 0 - maximum %d)"] = "(最小0-最大%d)"
L["1 Group"] = "1 组"
L["1 Item"] = "1 物品"
L["1D"] = "1天"
L["1M"] = "1月"
L["1W"] = "1周"
L["1Y"] = "1年"
L["2Y"] = "2年"
L["3M"] = "1季"
L["6M"] = "半年"
L["A custom price of %s for %s evaluates to %s."] = "%s的自定义价格为%s到%s。"
L["A profile with that name already exists on the target account. Rename it first and try again."] = "目标账号上已存在同名配置文件。请在重命名后重试。"
L["A profile with this name already exists."] = "已存在同名配置文件。"
L["A scan is already in progress. Please stop that scan before starting another one."] = "一项扫描进行中，请停止该扫描后再开始新扫描。"
L["A single craft makes %d and you only need to restock %d."] = "单次制造%d，仅需补货%d个。"
L["AH"] = "拍卖行"
L["AH (Crafting)"] = "拍卖行(制造业)"
L["AH (Disenchanting)"] = "拍卖行(分解)"
L["AH BUSY"] = "拍卖行繁忙"
L["AHDB Minimum Bid"] = "AHDB最低竞价"
L["AHDB Minimum Buyout"] = "AHDB最低一口价"
L["ALT"] = "ALT"
L["Above max expires."] = "超过最大值过期。"
L["Above max price. Not posting."] = "高于最高价，不发布。"
L["Above max price. Posting at max."] = "高于最高价，以最高价发布。"
L["Above max price. Posting at min."] = "高于最高价，以最低价发布。"
L["Above max price. Posting at normal."] = "高于最高价，以正常价发布。"
L["Accept COD?"] = "是否接受付款取货？"
L["Accepting this item will cost: %s"] = "接受该物品将花费: %s"
L["Account Syncing"] = "账户同步"
L["Account sync removed. Please delete the account sync from the other account as well."] = "帐户同步已移除，也请删除其他帐户同步信息。"
L["Accounting"] = "会计"
L["Active"] = "输入框/选项"
L["Active Alt"] = "搜索框/小标题字体"
L["Activity Type"] = "活动类型"
L["Add"] = "新增"
L["Add %d |4Item:Items"] = "添加 %d |4物品:物品"
L["Add %s Operation"] = "新增%s操作"
L["Add More Operations"] = "添加更多操作"
L["Add Operation"] = "添加操作"
L["Add Subject / Description"] = "添加主题/描述"
L["Add a new custom source"] = "添加自定义源"
L["Add account"] = "添加账户"
L["Add operation to groups"] = "为分组添加操作"
L["Add subject & description (optional)"] = "添加主题及描述(可选)"
L["Add to Mail"] = "添加至邮件"
L["Added %s to %s."] = "已添加 %s到%s。"
L["Added '%s' profile which was received from %s."] = "已添加从%s收到的'%s'配置。"
L["Additional error suppressed"] = "已阻止更多错误"
L["Adjust how TSM values crafted items when calculating profit."] = "调整TSM在计算利润时如何估值制造品。"
L["Adjust how crafted items are restocked."] = "调整专业制品补货方式。"
L["Adjust how items are mailed."] = "调整邮件的邮寄方式"
L["Adjust some general settings."] = "调整一些常规设置。"
L["Adjust the settings below to set how groups attached to this operation will be auctioned."] = "调整以下设置以设置如何拍卖与该操作关联的组。"
L["Adjust the settings below to set how groups attached to this operation will be cancelled."] = "调整以下设置以设置如何取消有此操作的分组。"
L["Adjust the settings below to set how groups attached to this operation will be priced."] = "调整以下设置以设置添加到此操作分组组的定价方式。"
L["Advanced Item Search"] = "高级物品搜索"
L["Alarm Clock"] = "闹钟"
L["All"] = "所有"
L["All Auctions"] = "所有拍卖"
L["All Bought"] = "全部购买"
L["All Cancelled"] = "全部取消"
L["All Characters"] = "所有角色"
L["All Expired"] = "全部过期"
L["All Faction-Realms"] = "所有阵营-服务器"
L["All Guilds"] = "所有公会"
L["All Item Classes"] = "所有物品类别"
L["All Other"] = "所有其他"
L["All Players"] = "所有玩家"
L["All Professions"] = "所有专业"
L["All Rarites"] = "所有稀有"
L["All Rarities"] = "所有稀有"
L["All Selected"] = "全部选择"
L["All Slots"] = "所有插槽"
L["All Sold"] = "全部卖出"
L["All Sources"] = "所有来源"
L["All Subclasses"] = "所有子类别"
L["All Time"] = "全天"
L["All Types"] = "所有类型"
L["Allow partial stack"] = "允许部分堆叠"
L["Allows for testing of custom prices"] = "允许测试自定义价格"
L["Alt Guild Bank"] = "小号公会银行"
L["Alts"] = "小号"
L["Alts AH"] = "小号AH"
L["Amount"] = "数量"
L["Amount kept in bags"] = "背包保留数量"
L["Amount of bag space to keep free"] = "背包保留可用空间"
L["An old TSM addon was found installed. Please remove %s and any other old TSM addons to avoid issues."] = "发现已安装旧的TSM插件。请删除%s和任何其他旧的TSM插件，以避免出现问题。"
L["App Not Synced"] = "应用未同步"
L["App Synced %s Ago"] = "应用已同步%s"
L["Appearance"] = "外观"
L["Apply operation to group"] = "将操作应用于分组"
L["Are you sure you want to clear accounting data older than %d days for the currenet realm?"] = "Are you sure you want to clear accounting data older than %d days for the currenet realm?"
L["Are you sure you want to delete the selected operations?"] = "您确定要删除所选的操作吗？"
L["Are you sure you want to delete this operation?"] = "你确定要删除这个操作吗？"
L["At above max price and not undercut."] = "高于最高价格且未被压价"
L["At normal price and not undercut."] = "处于正常价格且未被压价"
L["Attachments"] = "附件"
L["Auction"] = "拍卖"
L["Auction House Cut"] = "拍卖打折"
L["Auction House Sounds"] = "拍卖行音效"
L["Auction Window Close"] = "拍卖窗口关闭"
L["Auction Window Open"] = "拍卖窗口打开"
L["Auction duration"] = "拍卖时间"
L["Auction has been bid on."] = "已被竞标"
L["Auction sale sound"] = "拍卖声"
L["AuctionDB"] = "拍卖数据库AuctionDB"
L["AuctionDB - Historical Price"] = "AuctionDB - Historical Price"
L["AuctionDB - Market Value"] = "拍卖数据库-市场价格"
L["AuctionDB - Minimum Buyout"] = "拍卖数据库-最低一口价"
L["AuctionDB - Recent Value"] = "AuctionDB - Recent Value"
L["AuctionDB - Region Historical Price"] = "AuctionDB - Region Historical Price"
L["AuctionDB - Region Market Value Average"] = "AuctionDB - Region Market Value Average"
L["AuctionDB - Region Sale Average"] = "AuctionDB - Region Sale Average"
L["AuctionDB - Region Sale Rate"] = "AuctionDB - Region Sale Rate"
L["AuctionDB - Region Sold Per Day"] = "AuctionDB - Region Sold Per Day"
L["AuctionDB Realm Data is %s Old"] = "拍卖数据库 服务器数据是%s旧的"
L["AuctionDB Region Data is %s Old"] = "拍卖数据库 区域数据是%s旧的"
L["Auctionator - Auction Value"] = "Auctionator - 拍卖价格"
L["Auctioneer - Appraiser"] = "Auctioneer - 估价"
L["Auctioneer - Market Value"] = "Auctioneer - 市场价"
L["Auctioneer - Minimum Buyout"] = "Auctioneer - 最低一口价"
L["Auctioning"] = "拍卖"
L["Auctioning %s button"] = "拍卖 %s 按钮"
L["Auctioning Details"] = "拍卖细节"
L["Auctioning Log"] = "拍卖日志"
L["Auctioning Operation"] = "拍卖操作"
L["Auctioning operation"] = "拍卖操作"
L["Auctioning operations control posting to and canceling from the AH."] = "拍卖操作控制如何在拍卖行发布和取消拍卖。"
L["Auctions"] = "拍卖"
L["Auto Quest Complete"] = "自动完成任务"
L["Auto-focus browse search input"] = "自动选定搜索框"
L["Average Earned per Day"] = "日均收入"
L["Average Prices:"] = "平均价:"
L["Average Profit per Day"] = "日均利润"
L["Average Spent per Day"] = "日均花费"
L["Avg Buy Price"] = "平均买入价"
L["Avg Profit"] = "平均利润"
L["Avg Sell Price"] = "平均卖出价"
L["BUSY"] = "繁忙"
L["BUY"] = "购买"
L["Back"] = "后退"
L["Bag"] = "背包"
L["Bags"] = "背包"
L["Bank"] = "Bank"
L["Banking"] = "银行助手"
L["Banks"] = "银行"
L["Base Group"] = "基础分组"
L["Base Item"] = "基础物品"
L["Below is a list of all available price sources, along with a brief description of what they represent."] = "以下是可用价格源列表，并对它们代表的含义附有简短的描述"
L["Below min price. Posting at max."] = "低于最低价，以最高价发布。"
L["Below min price. Posting at min."] = "低于最低价，以最低价发布。"
L["Below min price. Posting at normal."] = "低于最低价，以正常价发布。"
L["Below you can ignore this operation on certain characters or realms."] = "以下你可以在指定角色或服务器忽略此操作。"
L["Bid %d / %d"] = "竞拍%d / %d"
L["Bid (item)"] = "竞拍（物品）"
L["Bid (stack)"] = "竞拍（堆叠）"
L["Bid (total)"] = "竞拍（总计）"
L["Bid / Buyout"] = "竞价/一口价"
L["Bid Auction"] = "竞拍"
L["Bid Price"] = "竞拍价格"
L["Bid Sniper Paused"] = "狙击竞价暂停"
L["Bid Sniper Running"] = "运行狙击竞标"
L["Bid percent must be between 0 and 100."] = "竞价比例必须在0到100之间。"
L["Bidding Auction"] = "竞标拍卖"
L["Blacklisted players"] = "黑名单玩家"
L["Bought"] = "买入"
L["Bought %d of %s from %s for %s"] = "买了%d 个 %s，从%s，价格%s"
L["Bought %sx%d for %s from %s"] = "买入 %sx%d 为 %s 从 %s"
L["Bound Actions"] = "限制操作"
L["Browse"] = "浏览"
L["Browse / Sniper"] = "浏览/狙击"
L["Buy"] = "购买"
L["Buy %d / %d"] = "购买%d / %d"
L["Buy %d / %d (Confirming %d / %d)"] = "购买 %d / %d (确认 %d / %d)"
L["Buy Auction"] = "竞拍"
L["Buy Commodity"] = "购买商品"
L["Buy Commodity (%02d)"] = "Buy Commodity (%02d)"
L["Buy Groups"] = "购买分组"
L["Buy Options"] = "购买选项"
L["Buy from AH"] = "从拍卖行购买"
L["Buy from AH (Crafting)"] = "从拍卖行购买（制造）"
L["Buy from AH (Disenchant)"] = "从拍卖购买（分解）"
L["Buy from Vendor"] = "从NPC购买"
L["Buyback All"] = "全部购回"
L["Buyer/Seller"] = "购买者/售者"
L["Buyout"] = "一口价"
L["Buyout (item)"] = "一口价（物品）"
L["Buyout (stack)"] = "一口价（堆叠）"
L["Buyout (total)"] = "一口价（总计）"
L["Buyout Above Threshold"] = "Buyout Above Threshold"
L["Buyout Price"] = "一口价"
L["Buyout Sniper Paused"] = "狙击购买已暂停"
L["Buyout Sniper Running"] = "狙击购买中"
L["Buyout confirmation alert"] = "一口价确认警告"
L["COD"] = "付款取货"
L["CRAFT"] = "制造"
L["CRAFTING"] = "制造"
L["CTRL"] = "CTRL"
L["Can't load TSM tooltip while in combat"] = "战斗中不能载入TSM鼠标提示"
L["Cancel"] = "取消"
L["Cancel %d / %d"] = "取消 %d / %d"
L["Cancel Auction"] = "取消拍卖"
L["Cancel Scan"] = "取消扫描"
L["Cancel auctions with bids"] = "取消已被竞标的拍卖"
L["Cancel or Post"] = "取消或发布"
L["Cancel to repost higher"] = "取消并以更高价格发布"
L["Cancel undercut auctions"] = "取消被压价的拍卖"
L["Canceled information"] = "被取消的信息"
L["Canceling"] = "取消"
L["Canceling %d / %d"] = "正在取消%d个，共%d个"
L["Canceling %d Auctions..."] = "取消%d拍卖..."
L["Canceling Options"] = "取消设置"
L["Canceling auction you've undercut."] = "取消被压价的拍卖"
L["Canceling disabled."] = "禁用取消"
L["Canceling to repost at higher price."] = "取消并以更高价格发布。"
L["Canceling to repost at reset price."] = "取消并以转卖价发布。"
L["Canceling to repost higher."] = "取消并以更高价格发布。"
L["Canceling undercut auctions and to repost higher."] = "取消被压价的拍卖并以更高价格发布。"
L["Canceling undercut auctions."] = "取消被压价的拍卖。"
L["Cancelled"] = "已取消"
L["Cancelled Since Last Sale"] = "自上次售出后取消"
L["Cancelled auction of %sx%d"] = "取消%sx%d的拍卖"
L["Cancelled:"] = "已取消:"
L["Cannot repair from the guild bank!"] = "无法从公会银行修理！"
L["Cannot use additional filters with /crafting or /disenchant."] = "在/crafting 或/disenchant 后不能添加额外筛选命令。"
L["Cash Register"] = "收银台"
L["Changes to the specified profile (i.e. '/tsm profile Default' changes to the 'Default' profile)"] = "切换至指定的配置文件（如：'/tsm profile Default' 切换至 'Default' 配置文件）"
L["Character"] = "角色"
L["Chat Tab"] = "聊天标签"
L["Cheapest auction below min price."] = "低于最低价不发布"
L["Clear All"] = "全部清除"
L["Clear Data"] = "清除资料"
L["Clear Filters"] = "清除筛选"
L["Clear Old Data"] = "清除旧数据"
L["Clear Old Data?"] = "清除旧数据？"
L["Click and drag to resize this window."] = "单击并拖动以调整此窗口的大小。"
L["Click to hide this item for the current session. Hold shift to hide this item permanently."] = "单击以隐藏当前会话的此项。按住Shift键可永久隐藏该项目。"
L["Coins (%s)"] = "(%s) 金币"
L["Combine Partial Stacks"] = "合并堆叠"
L["Combining..."] = "合并中..."
L["Confirm"] = "确认"
L["Confirm complete sound"] = "确认完成提示音"
L["Confirmation %s button"] = "确认%s按钮"
L["Confirming %d / %d"] = "确认中%d / %d"
L["Confirming..."] = "Confirming..."
L["Connected to %s"] = "已连接 %s..."
L["Connecting to %s"] = "正在连接%s"
L["Contacts"] = "联系人"
L["Contains auctions above your alert threshold!"] = "包含高于您的警报阈值的拍卖！"
L["Contains auctions above your material value!"] = "Contains auctions above your material value!"
L["Convert Value (%s)"] = "Convert Value (%s)"
L["Cooldown"] = "冷却"
L["Cooldowns"] = "冷却"
L["Copy Letter"] = "邮件副本"
L["Cost"] = "成本"
L["Could not create macro as you already have too many. Delete one of your existing macros and try again."] = "无法创建宏，因为你的宏已经满了。删除一个现有宏后重试。"
L["Could not find profile '%s'. Possible profiles: '%s'"] = "找不到配置文件 '%s' 。可能的配置文件：'%s' 。"
L["Could not sell items due to not having free bag space available to split a stack of items."] = "由于没有可用分开堆叠物品的空余背包空间，因此无法出售物品。"
L["Craft"] = "制造"
L["Craft (Profitable)"] = "制造 (有利润时)"
L["Craft (Unprofitable)"] = "制造（无利润）"
L["Craft Next"] = "制造下一个"
L["Craft Value"] = "制造价值"
L["Craft Vellum"] = "Craft Vellum"
L["Crafted Items"] = "制造物品"
L["Crafter"] = "制造者"
L["Crafting"] = "制造"
L["Crafting %s button"] = "制造中 %s"
L["Crafting Cost"] = "制造成本"
L["Crafting Material Cost"] = "制造材料成本"
L["Crafting Mode"] = "制造模式"
L["Crafting UI Improvements"] = "Crafting UI Improvements"
L["Crafting Value"] = "制造价值"
L["Crafting cost"] = "制造成本"
L["Crafting operation"] = "制造操作"
L["Crafting operations control how queuing profession crafts."] = "制造操作控制制造专业如何排队。"
L["Crafts"] = "制造"
L["Create Groups from Table"] = "从表单创建分组"
L["Create New"] = "新建"
L["Create New Group"] = "新建分组"
L["Create New Operation"] = "新建操作"
L["Create Profession Groups"] = "创建专业分组"
L["Create macro"] = "创建宏"
L["Create new profile"] = "新建配置文件"
L["Current Price"] = "当前价"
L["Custom"] = "自定义"
L["Custom Price"] = "自定义价格"
L["Custom Source"] = "自订来源"
L["Custom Sources"] = "自定义源"
L["Custom Theme"] = "自定义主题"
L["Custom price name %s already exists."] = "自定义价格名称%s已存在。"
L["Custom price name %s is a reserved word which cannot be used."] = "自定义价格名称 %s 是保留字段，无法使用。"
L["Custom price names can only contain lowercase letters."] = "自定义价格名称只能包含小写字母"
L["Custom source (%s)"] = "自定义源 (%s)"
L["Custom sources allow you to create more advanced prices for use throughout the addon. You'll be able to use these new variables in the same way you can use the built-in price sources such as %s and %s."] = "自定义来源允许您创建在整个插件中使用的更高级的价格。您将能够以与使用内置价格来源（例如%s和%s）相同的方式来使用这些新变量。"
L["DAILY PURCHASES"] = "平均每天采购量"
L["DAILY SALES"] = "平均每天销量"
L["Dalaran"] = "达拉然"
L["Dashboard"] = "总览"
L["Default Price"] = "默认价格"
L["Default craft value method"] = "默认制成品估价方法"
L["Default material cost method"] = "默认材料成本方法"
L["Default price configuration"] = "默认价格配置"
L["Define what priority Gathering gives certain sources."] = "定义资源获取优先级"
L["Delete %d Operations"] = "删除 %d项操作"
L["Delete Group?"] = "删除分组？"
L["Delete Operation?"] = "删除操作？"
L["Delete Operations"] = "删除操作"
L["Delete Operations?"] = "删除操作？"
L["Delete Profile?"] = "是否删除配置？"
L["Delete Record?"] = "删除记录？"
L["Delete the profile"] = "删除配置文件"
L["Deleting this group (%s) will also remove any sub-groups attached to this group."] = "删除该分组(%s)会移除该分组下所有次级分组"
L["Deposit"] = "寄存"
L["Deposit Cost"] = "寄存费用"
L["Deposit reagents"] = "存放到材料银行"
L["Deselect All"] = "全部取消"
L["Destroy Next"] = "分解下一个"
L["Destroy Value"] = "分解价值"
L["Destroy value"] = "分解价值"
L["Destroy value source"] = "分解价值来源"
L["Destroying"] = "分解"
L["Destroying %s button"] = "分解%s"
L["Destroying will ignore %s permanently. You can remove it from the ignored list in the settings."] = "分解工具将永久忽略%s。你可以在设置中将该物品移除忽略列表。"
L["Destroying will ignore %s until you log out."] = "分解工具将在登出前忽略%s。"
L["Destroying..."] = "正在分解..."
L["Detailed crafting cost"] = "详细制造成本"
L["Details"] = "明细"
L["Did not cancel %s because your cancel to repost threshold (%s) is invalid. Check your settings."] = "未取消%s，因为你的取消并重新发布的阈值(%s)无效，请检查你的设置。"
L["Did not cancel %s because your maximum price (%s) is invalid. Check your settings."] = "未取消%s，因为你的最高价格(%s)无效。请检查你的设置。"
L["Did not cancel %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "未取消%s，因为你的最高价格(%s)低于最低价格(%s)。请检查你的设置。"
L["Did not cancel %s because your minimum price (%s) is invalid. Check your settings."] = "未取消%s，因为你的最低价(%s)无效。请检查你的设置。"
L["Did not cancel %s because your normal price (%s) is invalid. Check your settings."] = "未取消%s，因为你的正常价(%s)无效。请检查你的设置。"
L["Did not cancel %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "未取消%s，因为你的正常价格(%s)低于最低价格(%s)。请检查你的设置。"
L["Did not cancel %s because your undercut (%s) is invalid. Check your settings."] = "未取消%s，因为你的压价 (%s) 无效。请检查你的设置。"
L["Did not change prices due to an invalid bid or buyout value."] = "未修改价格，存在无效的标定价格或一口价。"
L["Did not post %s because Blizzard didn't provide all necessary information for it. Try again later."] = "未发布%s，因为暴雪未提供全部必要的信息。请稍后重试。"
L["Did not post %s because the owner of the lowest auction (%s) is on both the blacklist and whitelist which is not allowed. Adjust your settings to correct this issue."] = "未发布%s，因为不允许最低价拍卖者(%s)同时出现在黑名单和白名单上。调整你的设置以更正此问题。"
L["Did not post %s because you or one of your alts (%s) is on the blacklist which is not allowed. Remove this character from your blacklist."] = "未发布%s，因为你或你的其他角色(%s)在黑名单中。请从黑名单中删除。"
L["Did not post %s because your keep quantity (%s) is invalid. Check your settings."] = "未发布%s，因为你的保留数目(%s) 无效，请检查你的设置。"
L["Did not post %s because your max expires (%s) is invalid. Check your settings."] = "未发布%s，因为你的最长过期时间(%s) 无效，请检查您的设置。"
L["Did not post %s because your maximum price (%s) is invalid. Check your settings."] = "未发布%s，因为你的最高价(%s) 无效，请检查您的设置。"
L["Did not post %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "未发布%s，因为你的最高价(%s) 低于最低价(%s)，请检查您的设置。"
L["Did not post %s because your minimum price (%s) is invalid. Check your settings."] = "未发布%s，因为你的最低价(%s) 无效，请检查您的设置。"
L["Did not post %s because your normal price (%s) is invalid. Check your settings."] = "未发布%s，因为你的正常价(%s) 无效，请检查您的设置。"
L["Did not post %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "未发布%s，因为你的正常价(%s) 低于最低价(%s)，请检查你的设置。"
L["Did not post %s because your post cap (%s) is invalid. Check your settings."] = "未发布%s，因为你的最大发布数目(%s)无效，请检查你的设置。"
L["Did not post %s because your stack size (%s) is invalid. Check your settings."] = "未发布%s，因为你的堆叠数目(%s)无效，请检查你的设置。"
L["Did not post %s because your undercut (%s) is invalid. Check your settings."] = "未发布%s，因为你的压价(%s)无效，请检查你的设置。"
L["Disable invalid price warnings"] = "禁用无效价格提醒"
L["Disenchant Search"] = "分解搜索"
L["Disenchant Search Options"] = "分解搜索选项"
L["Disenchant Value"] = "分解价值"
L["Disenchanting Options"] = "分解选项"
L["Display total money received in chat"] = "显示聊天中收到的总金额"
L["Don't Post Items"] = "不发布物品"
L["Don't post after this many expires"] = "超过此数量过期后不发布"
L["Don't prompt to record trades"] = "不立即记录交易"
L["Done Canceling"] = "取消完成"
L["Done Posting"] = "发布完成"
L["Done Scanning"] = "扫描完成"
L["Done rebuilding item cache."] = "完成项目缓存重建。"
L["Down"] = "下"
L["Duplicate the profile"] = "复制配置文件"
L["Duration"] = "持续时间"
L["Duskwood"] = "暮色森林"
L["EXPENSES"] = "支出"
L["Edit"] = "编辑"
L["Edit Post"] = "编辑发布"
L["Embed TSM tooltip"] = "嵌入TSM工具提示"
L["Empty bags"] = "空的背包"
L["Empty price string."] = "清空价格字符串。"
L["Enable TSM tooltips"] = "启用TSM工具提示"
L["Enable automatic stack combination"] = "启用自动堆叠整理"
L["Enable buying"] = "启用购买"
L["Enable inbox chat messages"] = "启用收件箱聊天消息"
L["Enable region-wide trading (requires reload)"] = "Enable region-wide trading (requires reload)"
L["Enable restock"] = "启用补货"
L["Enable selling"] = "实现销售"
L["Enable sending chat messages"] = "开启发件聊天信息"
L["Enchant"] = "附魔"
L["Ensure both characters are online and try again."] = "确保两个人物都在线，然后重试。"
L["Enter Filter"] = "输入筛选名"
L["Enter Keyword"] = "输入关键字"
L["Enter a value from %d - %d"] = "输入%d-%d区间值"
L["Enter a value from %d - %d%%"] = "输入%d-%d%%区间值"
L["Enter name of logged-in character on other account"] = "输入其他账号已登录的角色名"
L["Enter player name"] = "输入玩家姓名"
L["Enter profile name"] = "输入配置名称"
L["Enter recipient name"] = "收件人姓名"
L["Establishing connection to %s. Make sure that you've entered this character's name on the other account."] = "正在与 %s 建立连接。确保您已在其他帐户中输入此角色名。"
L["Establishing connection..."] = "正在建立连接..."
L["Estimated Profit"] = "Estimated Profit"
L["Estimated Time"] = "Estimated Time"
L["Estimated deliver time"] = "预计交付时间"
L["Exact Match"] = "完全匹配"
L["Example"] = "示例"
L["Example Item"] = "示例物品"
L["Example Tooltip"] = "示例鼠标提示"
L["Exclude custom sources?"] = "排除自定义源?"
L["Exclude operations?"] = "排除操作？"
L["Exit"] = "退出"
L["Expand / Collapse All Groups"] = "展开/折叠所有组"
L["Expenses"] = "支出"
L["Expirations"] = "过期"
L["Expired"] = "到期的"
L["Expired Auctions"] = "过期的拍卖"
L["Expired Since Last Sale"] = "上次出售到期的"
L["Expired information"] = "过期信息"
L["Expires"] = "到期"
L["Expires Since Last Sale"] = "自上次销售起过期"
L["Expiring Mails"] = "过期邮件"
L["Exploration"] = "探测"
L["Export"] = "导出"
L["Export Custom Theme"] = "导出自定义主题"
L["Export String"] = "导出字符串"
L["Export theme"] = "导出主题"
L["Export this group"] = "导出该组"
L["Failed Auctions"] = "流标"
L["Failed to bid on auction of %s (x%s) for %s."] = "无法在%s（x%s）的拍卖中为%s出价。"
L["Failed to bid on auction of %s."] = "竞标%s失败"
L["Failed to buy auction of %s (x%s) for %s."] = "购买%s(x%s)拍卖失败，出价%s。"
L["Failed to buy auction of %s."] = "购买%s拍卖失败。"
L["Failed to buy auction."] = "购买拍卖失败。"
L["Failed to cancel auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "由于拍卖行繁忙无法取消拍卖。确保无其他插件在扫描拍卖行并重试。"
L["Failed to find auction for %s, so removing it from the results."] = "查找%s失败,已经从结果移除"
L["Failed to move group, as a group with the same name already exists in the target location."] = "Failed to move group, as a group with the same name already exists in the target location."
L["Failed to post %sx%d as the item no longer exists in your bags."] = "无法发布%sx%d，因为该物品已不在您背包中。"
L["Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."
L["Failed to send profile."] = "发送配置文件失败。"
L["Failed to send profile. Ensure both characters are online and try again."] = "发送配置文件失败。确保两个角色都在线，然后重试。"
L["Failed to start sniper. No groups have a Sniper operation applied."] = "无法启动狙击，没有分组采用了狙击操作。"
L["Favorite Scans"] = "收藏的扫描"
L["Favorite Searches"] = "收藏的搜索"
L["Favorited Patterns"] = "收藏夹配方"
L["Filter by Keyword"] = "按关键字筛选"
L["Filter by Price Source"] = "按价格来源筛选"
L["Filter by Profession"] = "按专业筛选"
L["Filter by duration"] = "按持续时间筛选"
L["Filter by groups"] = "按组筛选"
L["Filter by keyword"] = "按关键字筛选"
L["Filter group item lists based on the following price source"] = "根据以下价格源筛选分组物品"
L["Finding Selected Auction"] = "查找选定的拍卖"
L["First Auctioning Operation Max Price"] = "首次拍卖最高价"
L["First Auctioning Operation Min Price"] = "首次拍卖最低价"
L["First Auctioning Operation Normal Price"] = "首次拍卖正常价"
L["Fishing Reel In"] = "钓鱼卷轴"
L["For more info, visit %s. For help, join us in Discord: %s."] = "更多信息，请到 %s。寻求帮助，请在Discord: %s 加入我们。"
L["Forget Character"] = "遗忘角色"
L["Found auction sound"] = "找到拍卖音效"
L["Frame"] = "框架色"
L["Friends"] = "好友"
L["From"] = "从"
L["Full convert tooltip"] = "Full convert tooltip"
L["Full destroy tooltip"] = "Full destroy tooltip"
L["Full inventory"] = "全部库存"
L["GVault"] = "公会银行"
L["Garrison"] = "要塞"
L["Gathering"] = "收集"
L["Gathering Search"] = "收集搜索"
L["Gathering Setup"] = "收集设置"
L["General Options"] = "常规选项"
L["General Settings"] = "常规设置"
L["Get from Bank"] = "从银行获得"
L["Get from Guild Bank"] = "从公会银行获得"
L["Gets items from the bank or guild bank matching the item or partial text entered."] = "从银行或公会银行获取与输入的物品名或部分文本匹配的物品。"
L["Gold"] = "金"
L["Great Deals Search"] = "大交易巨划算搜索"
L["Group Management"] = "分组管理"
L["Group Search"] = "组搜索"
L["Group already exists."] = "已存在的分组"
L["Group name"] = "组名"
L["Grouped Items"] = "已分组的物品"
L["Grouping Pets by Level"] = "Grouping Pets by Level"
L["Groups"] = "分组"
L["Groups & Operations"] = "分组和操作"
L["Groups Using"] = "在用分组"
L["Guild"] = "公会"
L["Guild Bank"] = "公会银行"
L["HIGH"] = "高"
L["Have"] = "拥有"
L["Have Mats"] = "材料齐备"
L["Have Skill Ups"] = "提高技能"
L["Here you can add/remove what groups this operation is attached to."] = "在这里您可以添加/删除某个分组到此操作。"
L["Hide Columns"] = "隐藏列"
L["Hide auctions with bids"] = "隐藏已竞标拍卖"
L["Hide minimap icon"] = "隐藏小地图图标"
L["Hiding the TSM Banking UI. Type '/tsm bankui' to reopen it."] = "隐藏TSM银行助手,输入 '/tsm bankui'  可重新打开"
L["Hiding the TSM Task List UI. Type '/tsm tasklist' to reopen it."] = "隐藏TSM 任务列表,输入 '/tsm tasklist' 可重新打开"
L["High Bidder"] = "高出价者"
L["Historical Price"] = "历史价格"
L["Historical price"] = "历史价格"
L["Hold ALT to repair from the guild bank."] = "按住 ALT 键公会修理"
L["Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."] = "按住SHIFT键可在“%s”之后自动重发邮件，按住CTRL键可演示一次，该演示仅在聊天消息显示结果并不实际寄出。"
L["Hold SHIFT to continue after the inbox refreshes"] = "按住SHIFT键可在收件箱刷新后继续"
L["Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."] = "按住SHIFT键可在收件箱刷新后继续，按住CTRL键可不打开附有金币的邮件。"
L["Hold SHIFT to not continue after the inbox refreshes"] = "按住 SHIFT 以在邮箱刷新后不继续"
L["Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."] = "按住SHIFT键可在收件箱刷新后不继续，按住CTRL键可不打开附有金币的邮件。"
L["Hold SHIFT while dragging to scale the window instead."] = "按住SHIFT拖拽缩放窗口"
L["Hold shift to move the items to the parent group instead of removing them."] = "按住shift键将物品移至父分组，而不是将其删除。"
L["Hr"] = "小时"
L["Hrs"] = "小时"
L["If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."] = "If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."
L["If you have multiple profiles set up with operations, enabling this will cause all but the current profile's operations to be irreversibly lost."] = "如果您有多个配置文件设置了操作，启用此选项将导致除当前配置文件外的所有操作不可逆转地丢失。"
L["Ignore Auctions Below Min"] = "忽略最低价以下的拍卖"
L["Ignore Characters"] = "忽略角色"
L["Ignore Guilds"] = "忽略公会"
L["Ignore auctions by duration"] = "按持续时间忽略拍卖"
L["Ignore operation on characters"] = "在角色上忽略操作"
L["Ignore operation on faction-realms"] = "在阵营-服务器上忽略操作"
L["Ignored Cooldowns"] = "忽略冷却"
L["Ignored Items"] = "忽略物品"
L["Import"] = "导入"
L["Import Groups & Operations"] = "导入分组&操作"
L["Import String"] = "导入字符串"
L["Import Summary"] = "导入总览"
L["Import Theme"] = "导入主题"
L["Import group"] = "导入分组"
L["Imported Group"] = "已导入分组"
L["Imported group (%s) with %d items, %d operations, and %d custom sources."] = "已导入分组 (%s) 包含 %d 物品, %d 操作, 和 %d 自定义源。"
L["In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."] = "In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."
L["Inbox Settings"] = "收件设置"
L["Include operations?"] = "包括操作?"
L["Include soulbound items"] = "包括灵魂绑定物品"
L["Information"] = "信息"
L["Invalid Quantity"] = "无效数量"
L["Invalid custom price source for %s. %s"] = "无效的自定义价格源%s. %s"
L["Invalid custom price."] = "无效的自定义价格。"
L["Invalid group name."] = "无效分组名"
L["Invalid numeric value."] = "无效的数值"
L["Invalid operation name."] = "无效的操作名"
L["Invalid player name."] = "无效玩家名"
L["Invalid price."] = "价格无效"
L["Invalid search filter (%s)."] = "无效的搜索筛选器 (%s)"
L["Invalid search term."] = "搜寻字词无效"
L["Invalid search term. Cannot filter by price here."] = "搜寻字词无效。无法在此处按价格筛选"
L["Invalid seller data returned by server."] = "服务器返回无效的卖家数据。"
L["Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."] = "无效的压价。设置你的压价为零铜币以达到不压价且发布在现在最低拍卖价之前。"
L["Inventory"] = "仓库"
L["Inventory / Gold Graph"] = "库存/金币 图表"
L["Inventory Options"] = "库存设置"
L["It appears that you've manually copied your saved variables between accounts which will cause TSM's automatic sync'ing to not work. You'll need to undo this, and/or delete the TradeSkillMaster saved variables files on both accounts (with WoW closed) in order to fix this."] = "你似乎在账号间手动复制了SavedVariables，导致TSM的自动同步无法工作。你需要撤销此更改，并/或 删除这些账号的TSM SavedVariables来修复此问题（需先关闭魔兽世界）。"
L["Item"] = "物品"
L["Item Class"] = "物品类别"
L["Item Level"] = "物品等级"
L["Item Level Range"] = "物品等级范围"
L["Item Name"] = "物品名称"
L["Item Quality"] = "物品品质"
L["Item Selection"] = "物品选择"
L["Item Slot"] = "物品槽"
L["Item Subclass"] = "物品子类"
L["Item Value"] = "物品价格"
L["Item/Group is invalid (see chat)."] = "物品/分组无效(查看聊天框)"
L["Items"] = "物品"
L["Items Using"] = "在用物品"
L["Keep in bags quantity"] = "背包保持数量"
L["Keep in bank quantity"] = "银行保持数量"
L["Keep quantity"] = "保持数量"
L["Keep this amount"] = "保持这个数量"
L["Keeping %d."] = "持有%d."
L["Keeping undercut auctions posted."] = "保持发布的压价拍卖。"
L["LEAST GROUPS"] = "最少分组"
L["LEAST ITEMS"] = "最少物品"
L["LOW"] = "低"
L["Last 14 Days"] = "14日内"
L["Last 3 Days"] = "3日内"
L["Last 30 Days"] = "30日内"
L["Last 60 Days"] = "60日内"
L["Last 7 Days"] = "7日内"
L["Last Purchased"] = "上次买入"
L["Last Sold"] = "上次售出"
L["Ledger"] = "账本"
L["Level Up"] = "等级上升"
L["Limit"] = "限制"
L["Link to Another Operation"] = "关联到另一个操作"
L["Lock Column Width"] = "锁定列宽"
L["Lock task list's background"] = "锁定后台任务列表"
L["Looks like TradeSkillMaster has encountered an error. Please help the author fix this error by following the instructions shown."] = "看上去TSM出错了。请按以下说明来帮助作者修正错误。"
L["Loop detected in the following custom price:"] = "以下自定义价格循环检测："
L["Lowest auction by whitelisted player."] = "最低价的拍卖为白名单玩家"
L["MAX"] = "MAX"
L["MOST GROUPS"] = "最多分组"
L["MOST ITEMS"] = "最多物品"
L["MOVE"] = "移动"
L["MOVING"] = "移动中"
L["Macro Setup"] = "宏设置"
L["Macro created and scroll wheel bound!"] = "已创建宏并绑定鼠标滚轮！"
L["Macros"] = "宏"
L["Mail"] = "邮件"
L["Mail Disenchantables"] = "邮寄可分解物品"
L["Mail Selected Groups"] = "邮寄所选分组"
L["Mail Selected Groups (Auto Resend)"] = "邮寄所选组 (自动复寄)"
L["Mail Selected Groups (Dry Run + Auto Resend)"] = "邮寄所选组 (演示 + 自动复寄)"
L["Mail Selected Groups (Dry Run)"] = "邮寄所选组 (演示)"
L["Mail disenchantables max quality"] = "邮寄可分解物品最高品质"
L["Mail to %s"] = "邮寄给 %s"
L["Mailing"] = "邮寄"
L["Mailing all to %s."] = "全部邮寄至 %s"
L["Mailing operation"] = "邮寄操作"
L["Mailing operations control mailing to other characters."] = "邮寄操作控制邮寄给其他角色。"
L["Mailing up to %d to %s."] = "邮寄最多%d给%s"
L["Make Cash On Delivery?"] = "货到付款？"
L["Make Operations Global?"] = "使操作全局化？"
L["Management Options"] = "管理选项"
L["Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."] = "Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."
L["Many commonly-used actions in TSM can be added to a macro and bound to your scroll wheel. Use the options below to setup this macro and scroll wheel binding."] = "TSM 中的许多常用操作可以添加到宏并绑定到滚轮。使用下面的选项设置宏和滚轮绑定。"
L["Map Ping"] = "地图Ping"
L["Market Value"] = "市场价格"
L["Market Value Price Source"] = "市场价来源"
L["Market value"] = "市场价格"
L["Market value and trend"] = "Market value and trend"
L["Market value price source"] = "市场价来源"
L["Mat Price"] = "原料价格"
L["Mat cost"] = "材料成本"
L["Match stack size"] = "匹配堆叠大小"
L["Match whitelisted players"] = "匹配白名单玩家"
L["Material Cost"] = "材料成本"
L["Materials"] = "材料"
L["Materials to Gather"] = "要收集的材料"
L["Max"] = "最大"
L["Max Buy Price"] = "最高买入价"
L["Max Price"] = "最高价格"
L["Max Sell Price"] = "最高卖价"
L["Max Shopping Price"] = "最高商店价格"
L["Max destroy value (Enter '0c' to disable)"] = "最大分解价值 (输入'0c' 禁用)"
L["Max expires to bank"] = "最大到期存银行"
L["Max market value (Enter '0c' to disable)"] = "最高市场价(输入'0c'禁用)"
L["Max quantity"] = "最大数量"
L["Max shopping price"] = "最高商店价格"
L["Max sniper price"] = "最高狙击价格"
L["Maximum Quantity to Buy"] = "最大买入量"
L["Maximum amount already posted."] = "已发布最大数量"
L["Maximum auction price"] = "最高拍卖价"
L["Maximum disenchant level"] = "最高分解等级"
L["Maximum disenchant quality"] = "最高分解品质"
L["Maximum disenchant search percent"] = "最高分解搜索百分比"
L["Maximum price"] = "最高价"
L["Maximum restock quantity"] = "最大补货量"
L["Midnight"] = "午夜"
L["Mill"] = "Mill"
L["Mill Value"] = "研磨价值"
L["Min"] = "最小"
L["Min 0 - Max 20"] = "最小 0 - 最大 20"
L["Min 0.5 - Max 10"] = "最小 0.5 - 最大 10"
L["Min Buy Price"] = "最低买入价"
L["Min Buyout"] = "最低一口价"
L["Min Sell Price"] = "最低卖价"
L["Min buyout"] = "最低一口价"
L["Min number of expires"] = "最小过期数"
L["Min profit amount"] = "最小利润额"
L["Min/Normal/Max Prices"] = "最低/正常/最高 价格"
L["Min/Normal/Max price"] = "最低/正常/最高 价格"
L["Minimum Rarity"] = "最低稀有品质"
L["Minimum disenchant level"] = "最低分解等级"
L["Minimum price"] = "最低价格"
L["Minimum restock quantity"] = "Minimum restock quantity"
L["Missing Materials"] = "缺少的材料"
L["Modifiers"] = "修饰键"
L["Money Frame Open"] = "金钱框架打开"
L["Money Transfer"] = "金币交易量"
L["Move %d already grouped items?"] = "移动 %d 已分组物品?"
L["Move %d |4Item:Items"] = "移动 %d |4物品:物品"
L["Move Item"] = "移动物品"
L["Move Quantity Options"] = "移动数量选项"
L["Move all to Bags"] = "全部移到背包"
L["Move to Parent Group"] = "移到父组"
L["Move to bags"] = "移到背包"
L["Move to bank"] = "移到银行"
L["Moving"] = "移动中"
L["Multiple Items"] = "多个物品"
L["Must be between %d and %s."] = "必须在 %d 和 %s之间。"
L["My Auctions"] = "我的拍卖"
L["My Auctions %s button"] = "我的拍卖 %s 按钮"
L["NEED MATS"] = "需要材料"
L["NO ITEMS"] = "没有物品"
L["NOT OPEN"] = "未打开"
L["NOTE: The import contained %d invalid items which were ignored."] = "提示: 导入包含 %d无效物品， 已忽略。"
L["NOTE: The import contained %d operations with at least one invalid setting which was reset."] = "提示: 导入 %d 操作，包含至少一个已重置过的无效设置。"
L["NPC"] = "NPC"
L["Name"] = "名称"
L["New Group"] = "新分组"
L["New Operation"] = "新操作"
L["News & Information"] = "新闻资讯"
L["No Attachments"] = "无附件"
L["No AuctionDB Realm Data"] = "无TSM数据库 服务器数据"
L["No AuctionDB Region Data"] = "无TSM数据库 区域数据"
L["No Characters"] = "未选择角色"
L["No Faction-Realms"] = "未选择阵营-服务器"
L["No Guilds"] = "未选择公会"
L["No Materials to Gather"] = "没有材料需收集"
L["No Operation Selected"] = "未选择操作"
L["No Players"] = "未选择玩家"
L["No Profession Opened"] = "未打开专业"
L["No Professions"] = "无专业"
L["No Rarities"] = "没有稀有"
L["No Sound"] = "无声"
L["No Sources"] = "无来源"
L["No Types"] = "无类型"
L["No group selected"] = "未选择分组"
L["No item specified. Usage: /tsm restock_help [ITEM_LINK]"] = "未指定物品。 用法：/tsm restock help [物品链接]"
L["No posting."] = "未发布"
L["No profile specified. Possible profiles: '%s'"] = "无指定配置。可能配置：'%s'"
L["No recent AuctionDB scan data found."] = "未找到近期AuctionDB扫描数据。"
L["No recipe selected"] = "No recipe selected"
L["No value was returned by the custom price for the specified item."] = "自定义价格中没有返回指定物品值。"
L["No, cancel"] = "No, cancel"
L["None"] = "无"
L["None (Always Show)"] = "无（总是显示）"
L["None Selected"] = "未选择"
L["Nongroup to bank"] = "未分组存银行"
L["Normal price"] = "正常价格"
L["Not Connected"] = "未连接"
L["Not Enough Money"] = "没有足够金币"
L["Not Scanned"] = "未扫描的"
L["Not canceling auction at reset price."] = "不取消位于转卖价格的拍卖"
L["Not canceling auction below min price."] = "低于最低价格时不取消拍卖"
L["Not canceling."] = "未取消"
L["Not enough items in bags."] = "背包物品不足"
L["Not enough money to cancel."] = "没有足够金币以取消"
L["Nothing to move."] = "没有可移动"
L["Nothing to send."] = "无物品可邮寄"
L["Number Owned"] = "拥有的数量"
L["Number of days"] = "Number of days"
L["OPEN"] = "打开"
L["Offline"] = "离线"
L["On Cooldown for %s"] = "On Cooldown for %s"
L["Only show craftable"] = "只显示可制造"
L["Only show items with disenchant values above this price"] = "仅显示分解价值高于此价格的物品"
L["Only show sold auctions"] = "仅显示已售拍品"
L["Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."] = "Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."
L["Open All Mail"] = "打开所有邮件"
L["Open All Mail Without Money"] = "打开所有无金币邮件"
L["Open Mail"] = "打开邮件"
L["Open Mail Without Money"] = "打开无金币邮件"
L["Open Task List"] = "打开任务列表"
L["Open mail complete sound"] = "打开邮件完成提示音"
L["Opens the Destroying frame if there's stuff in your bags to be destroyed."] = "背包有可分解物品，则打开TSM分解窗口。"
L["Operation"] = "操作"
L["Operations"] = "操作"
L["Options specific to Sniper are below."] = "以下指定狙击选项。"
L["Order Confirmation"] = "订单确认"
L["Orgrimmar"] = "奥格瑞玛"
L["Oribos Exchange Realm Price"] = "Oribos Exchange Realm Price"
L["Oribos Exchange Region Price"] = "Oribos Exchange Region Price"
L["Other"] = "其他"
L["Other Character"] = "其他角色"
L["Override Parent Operations"] = "覆盖父操作"
L["Override default craft value"] = "覆盖默认制品估价"
L["PROFIT"] = "利润"
L["Parent Items"] = "父项目"
L["Pausing Scan..."] = "暂停扫描中..."
L["Per Item"] = "每个物品"
L["Per Stack"] = "每堆叠"
L["Performing a dry-run of your Mailing operations for the selected groups."] = "为选定分组演示邮寄操作"
L["Player Gold"] = "玩家金币"
L["Player Invite Accept"] = "接受玩家邀请"
L["Post"] = "发布"
L["Post / Cancel"] = "发布/取消"
L["Post Auction"] = "发布拍卖"
L["Post Items from Bags"] = "从背包发布"
L["Post Quantity"] = "发布数量"
L["Post Scan"] = "发布扫描"
L["Post Selected"] = "发布已选择"
L["Post at Maximum Price"] = "以最高价发布"
L["Post at Minimum Price"] = "以最低价发布"
L["Post at Normal Price"] = "以正常价格发布"
L["Post cap"] = "发布的最大堆叠数"
L["Post cap to bags"] = "从背包发布最大数量"
L["Post from Shopping Scan"] = "从购买扫描发布"
L["Postage"] = "邮费"
L["Posted at whitelisted player's price."] = "以白名单玩家价格发布"
L["Posted:"] = "已发布："
L["Posting"] = "发布中"
L["Posting %d / %d"] = "发布中 %d / %d"
L["Posting %d items for %s hours."] = "发布 %d 物品 %s 小时。"
L["Posting %d stack(s) of %d for %s hours."] = "按%d堆叠%d且以%s小时发布"
L["Posting Options"] = "发布设置"
L["Posting Price"] = "发布价格"
L["Posting at normal price."] = "正以正常价发布"
L["Posting at whitelisted player's price."] = "正以白名单玩家价格发布"
L["Posting at your current price."] = "以当前价发布"
L["Posting disabled."] = "禁用发布"
L["Posts"] = "发布"
L["Potential"] = "潜在"
L["Prepare Bid"] = "准备竞价"
L["Prepare Buy"] = "准备购买"
L["Preparing..."] = "正在准备..."
L["Prevent closing the Auction House with the esc key"] = "禁用“ESC”关闭拍卖行"
L["Primary"] = "背景色"
L["Primary Alt"] = "次级背景色"
L["Prints out the available price sources for use in custom prices"] = "输出可用的价格源，以用于自定义价格。"
L["Prints out the version numbers of all installed modules"] = "输出所有已安装模块的版本号"
L["Prints the slash command help listing"] = "输出斜杠命令帮助列表"
L["Profession"] = "专业"
L["Profession Info"] = "专业信息"
L["Professions Used In"] = "涉及专业"
L["Profile changed to '%s'."] = "变更成'%s'配置。"
L["Profiles"] = "配置文件"
L["Profit"] = "利润"
L["Profit (Total)"] = "利润（总计）"
L["Prospect"] = "Prospect"
L["Prospect Value"] = "预期价格"
L["Purchase"] = "购买"
L["Purchase / Sale Info"] = "购买/出售信息"
L["Purchase Data"] = "购买数据"
L["Purchase Item"] = "购买物品"
L["Purchase information"] = "购买信息"
L["Purchased (Min/Avg/Max Price)"] = "购买（最小/平均/最高价)"
L["Purchased (Total Price)"] = "购买(总价)"
L["Purchases"] = "购买数量"
L["Purchasing Auction"] = "采购"
L["Puts items matching the item or partial text entered into the bank or guild bank."] = "将与输入的物品或部分文本匹配的物品放入银行或公会银行。"
L["Qty"] = "数量"
L["Quantity"] = "数量"
L["Quantity Purchased:"] = "购买数量："
L["Quantity Sold:"] = "售出数量"
L["Quantity to move"] = "移动数量"
L["Quest Added"] = "任务已添加"
L["Quest Completed"] = "任务已完成"
L["Quest Objectives Complete"] = "任务目标完成"
L["Queue"] = "加入队列"
L["Queue (%d)"] = "Queue (%d)"
L["Queue Summary"] = "Queue Summary"
L["Quickly mail all excess disenchantable items to a character"] = "快速将所有多余的可分解物品邮寄给角色"
L["Quickly mail all excess gold (limited to a certain amount) to a character"] = "快速将所有多余的金币（限制在一定数量）邮寄给角色"
L["Raid Warning"] = "副本警告"
L["Rank %d"] = "等级%d"
L["Read More"] = "阅读更多"
L["Ready Check"] = "准备好检查"
L["Ready to Cancel"] = "准备取消"
L["Reagent Quality"] = "Reagent Quality"
L["Recent"] = "最近的"
L["Recent Scans"] = "最近的扫描"
L["Recent Searches"] = "最近的搜索"
L["Recent Value"] = "Recent Value"
L["Recent value"] = "Recent value"
L["Recipe Name"] = "配方名称"
L["Recipient"] = "收件人"
L["Region Avg Daily Sold"] = "区域平均每日出售"
L["Region Historical Price"] = "区域历史价格"
L["Region Market Value Avg"] = "区域市场均价"
L["Region Sale Avg"] = "区域平均出售"
L["Region Sale Rate"] = "区域成交率"
L["Region avg daily sold"] = "区域平均每日出售"
L["Region historical price"] = "区域历史价格"
L["Region market value"] = "区域市场价格"
L["Region market value and trend"] = "Region market value and trend"
L["Region sale avg"] = "区域平均出售"
L["Region sale rate"] = "区域成交率"
L["Reload"] = "重载"
L["Reload UI (%02d)"] = "重载界面 (%02d)"
L["Reload UI (%d)"] = "重载界面(%d)"
L["Remove"] = "移除"
L["Remove %d |4Item:Items"] = "移除 %d |4物品:物品"
L["Remove Data Older Than (Days)"] = "移除超过 (天)的旧数据"
L["Remove this account sync and all synced data from this account"] = "删除该账号同步和从该账号同步的所有数据"
L["Removed a total of %s old records."] = "总共删除了%s 旧记录"
L["Removed custom price source (%s) which has an invalid name."] = "移除名称无效的自定义价格源 (%s) 。"
L["Rename"] = "重命名"
L["Rename Profile"] = "重命名配置"
L["Rename Search"] = "重命名搜索"
L["Rename the profile"] = "重命名配置"
L["Rename this group"] = "重命名分组"
L["Repair"] = "修理"
L["Repair Bill"] = "修理账单"
L["Repair from Guild Bank"] = "公会银行修理"
L["Replace %d existing operations and %d existing custom sources?"] = "替换 %d 现有操作和 %d 自定义源?"
L["Replace %d existing operations?"] = "替换 %d 现有操作?"
L["Reply"] = "回复"
L["Report Spam"] = "报告垃圾邮件"
L["Reports"] = "汇总"
L["Repost threshold"] = "重新发布阈值"
L["Required Level"] = "所需人物等级"
L["Required Level Range"] = "人物等级范围"
L["Resale"] = "转卖"
L["Rescan"] = "重新扫描"
L["Reset"] = "重置"
L["Reset All Filters"] = "重置所有筛选器"
L["Reset Filters"] = "重置筛选器"
L["Reset Operation?"] = "重置操作？"
L["Reset Profile?"] = "重置配置文件？"
L["Reset Table"] = "重置列表"
L["Reset Zoom"] = "重置缩放"
L["Reset the current profile to default settings"] = "重置当前配置档为默认设置"
L["Reset to Default"] = "重置为默认"
L["Resetting the operation will return all inputs back to default and cannot be unddone. Click confirm to reset."] = "重置这项操作将会把所有已输入内容还原至默认设置且不能被撤销。点击确认以重置。"
L["Restart"] = "重启"
L["Restart delay (minutes)"] = "(分钟)后重启"
L["Restock Groups"] = "Restock Groups"
L["Restock Options"] = "补货选项"
L["Restock TSM Groups"] = "Restock TSM Groups"
L["Restock bags"] = "背包补货"
L["Restock help for %s: %s"] = "补货帮助 %s: %s"
L["Restock quantity"] = "补货数量"
L["Restock target to max quantity"] = "将目标补货至最大数量"
L["Restocking to %d."] = "补货到%d"
L["Restocking with a min profit."] = "以最低利润补货。"
L["Restocking with no min profit."] = "无最低利润的补货。"
L["Restore bags"] = "恢复背包"
L["Resuming Scan..."] = "继续扫描..."
L["Retail Region-Wide Tracking"] = "Retail Region-Wide Tracking"
L["Retrying %d auction(s) which failed."] = "重试失败的%d拍卖"
L["Revenue"] = "收益"
L["Right-Click to reset the window size, scale, and position to their defaults."] = "右击重置窗口大小、比例、位置为默认值。"
L["Run Advanced Item Search"] = "运行高级项目搜索"
L["Run Bid Sniper"] = "运行狙击竞价"
L["Run Buyout Sniper"] = "运行狙击一口价"
L["Run Cancel Scan"] = "取消扫描"
L["Run Post Scan"] = "发布扫描"
L["Run Shopping Scan"] = "购买扫描"
L["Running Sniper Scan"] = "狙击扫描"
L["SALES"] = "出售"
L["SCAN ALL"] = "全部扫描"
L["SCANNING"] = "正在扫描"
L["SENDING"] = "发送中"
L["SHIFT"] = "SHIFT"
L["SOURCE %d"] = "来源%d"
L["Sale"] = "出售"
L["Sale Data"] = "销售数据"
L["Sale Price"] = "销售价格"
L["Sale Rate"] = "成交率"
L["Sale information"] = "销售信息"
L["Sale rate"] = "销售率"
L["Sales"] = "出售"
L["Salvage"] = "Salvage"
L["Save & Close"] = "Save & Close"
L["Saved"] = "Saved"
L["Scan"] = "扫描"
L["Scan Paused"] = "扫描暂停"
L["Scan complete sound"] = "扫描完成提示音"
L["Scan was slowed down by %s seconds by other AH addons (%s seconds by %s)."] = "其他AH插件将扫描速度减慢了 %s 秒 (%s 秒 因 %s)."
L["Scanning"] = "正在扫描"
L["Scanning (%d Items)"] = "扫描 (%d个物品)"
L["Scroll Wheel Options"] = "滚轮选项"
L["Scroll wheel direction"] = "滚轮方向"
L["Search"] = "搜索"
L["Search %s operations"] = "搜索 %s 操作"
L["Search Bags"] = "搜索背包"
L["Search Groups"] = "搜索分组"
L["Search Operations"] = "搜索操作"
L["Search Patterns"] = "搜索配方"
L["Search Results"] = "搜索结果"
L["Search Vendor"] = "搜索NPC"
L["Search items"] = "搜索物品"
L["Search items in group"] = "搜索分组物品"
L["Search items in mailbox"] = "搜索邮箱物品"
L["Search the auction house"] = "搜索拍卖行"
L["Select / Deselect All Groups"] = "全选 / 不选 所有组"
L["Select / Deselect All Items"] = "全选 / 不选 所有物品"
L["Select / Deselect All Results"] = "全选 / 不选 所有结果"
L["Select Action"] = "选择操作"
L["Select All"] = "全选"
L["Select Auction to Cancel"] = "选择要取消的拍卖"
L["Select Crafted Item Quality"] = "Select Crafted Item Quality"
L["Select Group"] = "选择分组"
L["Select Items to Attach"] = "选择物品作附件"
L["Select a Source"] = "选择一个源"
L["Select an Auction to Buy"] = "选择要购买的拍卖"
L["Select crafter"] = "选择制造者"
L["Select included subgroups"] = "选择包括的子分组"
L["Select professions"] = "选择专业"
L["Selected Items (%d)"] = "Selected Items (%d)"
L["Sell"] = "出售"
L["Sell All"] = "出售所有"
L["Sell BoEs"] = "出售 BoEs装绑物品"
L["Sell Groups"] = "出售分组"
L["Sell Options"] = "出售选项"
L["Sell Trash"] = "出售垃圾"
L["Sell soulbound items"] = "出售灵魂绑定物品"
L["Sell to Vendor"] = "卖给NPC"
L["Seller"] = "出售者"
L["Selling soulbound items."] = "出售灵魂绑定物品"
L["Send"] = "发送"
L["Send Disenchantables"] = "发送可分解"
L["Send Excess Gold to Banker"] = "邮寄多余金币给银行角色"
L["Send Gold"] = "邮寄金币"
L["Send Mail"] = "发送邮件"
L["Send Money"] = "邮寄钱"
L["Send grouped items individually"] = "单独邮寄分组物品"
L["Send your active profile to this synced account"] = "发送当前配置给同步账号"
L["Sender"] = "寄件人"
L["Sending %s to %s"] = "发送%s到%s"
L["Sending %s to %s with a COD of %s"] = "正在发送%s给%s ，到付金额为%s"
L["Sending Settings"] = "发送设置"
L["Sending your '%s' profile to %s. Please keep both characters online until this completes. This will take approximately: %s"] = "正在发送 '%s' 的配置文件到%s。 请保持两个角色都在线直到发送完成。 这大约需要: %s。"
L["Sending..."] = "发送中..."
L["Set bid as percentage of buyout"] = "将竞标出价设为一口价的百分比"
L["Set how items are moved out of the bank."] = "设置如何将物品移出银行。"
L["Set how items are restocked from the bank."] = "设置如何从银行补货。"
L["Set keep in bags quantity"] = "设置背包保留数量"
L["Set keep in bank quantity"] = "设置银行保留数量"
L["Set max quantity"] = "设置最大数量"
L["Set min profit"] = "设置最小利润"
L["Set move quantity"] = "设置转移数量"
L["Set stack size"] = "设置堆叠大小"
L["Set stack size for restock"] = "为补货设置堆叠大小"
L["Set what is bought from a vendor."] = "设置从NPC购入"
L["Set what is sold to a vendor."] = "设置卖给NPC"
L["Set what items are shown during a Shopping scan."] = "设置在购物扫描时显示哪些项目。"
L["Set what items are shown during a Sniper scan."] = "设置在“狙击”扫描时显示哪些项目。"
L["Set your active profile or create a new one."] = "设置当前配置或创建新配置"
L["Settings"] = "设置"
L["Setup various sounds that play when doing Auctioning scans."] = "设置运行拍卖行扫描时播放的不同音效。"
L["Share operations between all profiles"] = "Share operations between all profiles"
L["Shopping"] = "购买"
L["Shopping %s button"] = "购买 %s 按钮"
L["Shopping Operation Max Price"] = "购买操作最高限价"
L["Shopping for auctions including those above the max price."] = "购买拍卖品(包括那些高于最高价格的)"
L["Shopping for auctions with a max price set."] = "购买拍卖品(在最高价格限定下)"
L["Shopping operation"] = "购买操作"
L["Shopping operations control buyout from the AH."] = "购买操作控制从AH拍卖行买入。"
L["Shortfall to bags"] = "背包短缺"
L["Show auctions above max price"] = "显示高于最高限价的拍卖"
L["Show confirmation alert if buyout is above the alert price"] = "如果一口价超过警惕价格，则显示确认提醒"
L["Show destroying frame automatically"] = "自动显示分解窗口"
L["Show on modifier"] = "按修饰键显示（Alt、Ctrl、Shift）"
L["Show only auctions with bids"] = "仅显示有竞价的拍卖"
L["Show results as:"] = "结果显示为:"
L["Show total gold in header"] = "在顶部显示总金币"
L["Show ungrouped items as:"] = "未分组物品显示为:"
L["Showing %s Mail"] = "显示 %s 邮件"
L["Showing %s of %d Mail"] = "显示 %s 第 %d 邮件"
L["Showing %s of %d Mails"] = "已显示 %s 封邮件，共 %d 封"
L["Showing all %s Mails"] = "已显示所有 %s 封邮件"
L["Simple convert tooltip"] = "Simple convert tooltip"
L["Simple destroy tooltip"] = "Simple destroy tooltip"
L["Simple inventory"] = "简单库存"
L["Skip"] = "跳过"
L["Skipped:"] = "已跳过:"
L["Skipped: No assigned operation"] = "已跳过:未分配操作"
L["Slash Commands:"] = "斜杠命令："
L["Smart Avg Buy Price"] = "智能平均买入价"
L["Sniper"] = "狙击"
L["Sniper %s button"] = "狙击%s按钮"
L["Sniper Below Price"] = "狙击低于价格"
L["Sniper Operation Below Price"] = "狙击操作低于价格"
L["Sniper Options"] = "狙击选项"
L["Sniper operation"] = "狙击操作"
L["Sniper operations control sniping from the AH."] = "狙击操作控制从拍卖行狙击商品"
L["Sniping items below a max price"] = "狙击物品低于最高价"
L["Sold"] = "卖出"
L["Sold %d of %s to %s for %s"] = "售出 %d 个 %s 给 %s 售价 %s\""
L["Sold %s worth of items."] = "售出价值%s的物品。"
L["Sold (Min/Avg/Max Price)"] = "出售(最小/平均/最高价)"
L["Sold (Total Price)"] = "售出(总价):"
L["Sold [%s]x%d for %s to %s"] = "卖出 [%s]x%d 售价 %s 给 %s\""
L["Sold for:"] = "售价："
L["Some general Accounting options are below."] = "一些常规会计选项如下。"
L["Some general Auctioning options are below."] = "以下是一些关于拍卖的选项。"
L["Some general Browse/Sniper options are below."] = "以下是一些关于浏览和狙击的选项。"
L["Some general TSM options are below."] = "以下是一些通用的 TSM 选项。"
L["Some general appearance options are below."] = "以下是一些关于外观的选项。"
L["Some general options for the TSM tooltip information are below."] = "以下是一些关于 TSM 鼠标提示信息的选项。"
L["Some options for the Disenchant Search are below."] = "一些常规分解搜索选项如下。"
L["Source"] = "来源"
L["Sources"] = "来源"
L["Sources to include for restock"] = "需包含的补货来源"
L["Specific Item"] = "指定物品"
L["Stack"] = "堆叠"
L["Stack / Quantity"] = "堆叠/数量"
L["Stack size"] = "堆叠大小"
L["Stack size multiple"] = "多个堆叠大小"
L["Stack(s)"] = "堆叠"
L["Start either a 'Buyout' or 'Bid' sniper using the buttons above."] = "使用上面的按钮启动“一口价”或“竞标”狙击搜索"
L["Starting Scan..."] = "开始扫描..."
L["Stormwind"] = "暴风城"
L["String"] = "字符串"
L["Subject"] = "邮件主题"
L["Subject & Description added"] = "添加主题和说明"
L["Successfully sent your '%s' profile to %s!"] = "成功将您的配置文件 '%s' 发送至 %s！"
L["Supported value range: %d - %d"] = "支持的值范围: %d - %d\""
L["Swamp of Sorrows"] = "悲伤沼泽"
L["Switch to %s"] = "切换到%s"
L["Sync Setup Error: The specified player on the other account is not currently online."] = "同步设置错误：另一个账号中的指定角色不在线。"
L["Sync Setup Error: This character is already part of a known account."] = "同步设置错误：该角色已经在一个已知账号中。"
L["Sync Setup Error: You entered the name of the current character and not the character on the other account."] = "同步设置错误：您输入了当前角色名而非其他账号下的角色名。"
L["Sync Status"] = "同步状态"
L["TOP PURCHASE"] = "热门购买"
L["TOP SALE"] = "最畅销"
L["TSM %s: What's new"] = "TSM %s: 新变化"
L["TSM Accounting"] = "TSM会计"
L["TSM AuctionDB"] = "TSM拍卖数据库"
L["TSM Auctioning"] = "TSM拍卖"
L["TSM Crafting"] = "TSM制造"
L["TSM Desktop App Status (%s)"] = "TSM桌面程序状态(%s)"
L["TSM General Info"] = "TSM 一般信息"
L["TSM Shopping"] = "TSM购物"
L["TSM Sniper"] = "TSM狙击"
L["TSM TASK LIST"] = "TSM 任务列表"
L["TSM Version Info:"] = "TSM版本信息："
L["TSM can automatically sync data between multiple WoW accounts."] = "TSM能自动在多个WoW账号间同步数据。"
L["TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"] = "TSM检测到您刚刚将%s交易给%s以换取%s。您想让会计模块保存这笔交易的记录吗？"
L["TSM doesn't currently have any AuctionDB pricing data for your realm. We recommend you download the TSM Desktop Application from %s to automatically update your AuctionDB data (and auto-backup your TSM settings)."] = "TSM现无本服AuctionDB。请从%s下载TSM程序，更新AuctionDB、自动备份TSM设置（限美欧服）。"
L["TSM failed to scan some auctions. Please rerun the scan."] = "TSM未能扫描拍卖。 请重新运行扫描。"
L["TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."] = "TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."
L["TSM is missing important information from the TSM Desktop Application. Please ensure the TSM Desktop Application is running and is properly configured."] = "TSM缺少TSM桌面程序的重要信息。 请确保TSM桌面程序正在运行且正确配置。"
L["TSM is not yet ready to establish a new sync connection. Please try again later."] = "TSM尚未准备好建立新的同步连接，请稍后重试。"
L["TSM will not undercut any players you add to your whitelist."] = "TSM将不会试图压价你白名单中角色发布的物品。"
L["TSM4"] = "TSM4"
L["Target character"] = "目标角色"
L["Target shortfall to bags"] = "背包短缺目标"
L["Tasks Added to Task List"] = "添加到任务列表"
L["Tells you why a specific item is not being restocked and added to the queue."] = "告诉您指定物品未补货并添加到队列的原因。"
L["Text (%s)"] = "文本 (%s)"
L["The '%s' function has an invalid number of arguments."] = "The '%s' function has an invalid number of arguments."
L["The '%s' item parameter was used outside of a custom source."] = "The '%s' item parameter was used outside of a custom source."
L["The 'Craft Value Method' did not return a value for this item."] = "“制成品估价方法”没有给出该物品估值"
L["The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."] = "使用“智能平均买入价”设置已经从TSM移除，并且被新的“智能平均购入”价格源取代。请更新您的自定义价格。"
L["The AH does not support specifying a copper value (only gold and silver)."] = "AH不支持设定铜币价格(仅可金币和银币)。"
L["The Base Group contains all ungrouped items in the game. Use the search and filter controls to find items to add to other groups."] = "基础分组包含游戏中所有未分组的物品。使用搜索和筛选查找物品，将其添加到其他分组。"
L["The TradeSkillMaster_AppHelper addon is installed, but not enabled. TSM has enabled it and requires a reload."] = "TradeSkillMaster_AppHelper插件已安装，但未启用。TSM现启用它，需要重新加载。"
L["The buyout price for %s would be above the maximum allowed price. Skipping this item."] = "%s的一口价高于最高允许价格。跳过此物品。"
L["The canlearn filter was ignored because the CanIMogIt addon was not found."] = "由于未找到CanIMogIt插件，忽略canlearn筛选器。"
L["The max quantity cannot be zero."] = "最大数量不能是0。"
L["The min profit did not evaluate to a valid value for this item."] = "The min profit did not evaluate to a valid value for this item."
L["The name portion of the search term must be at least 3 characters if present."] = "搜索词的名称部分必须至少包含3个字符（如果存在）。"
L["The pasted value was not valid. Ensure you are pasting the entire import string."] = "粘贴的价格无效。请确认您粘贴了完整的导入字符串。"
L["The player \\\"%s\\\" is already on your whitelist."] = "The player \\\"%s\\\" is already on your whitelist."
L["The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."] = "价格必须含 g/s/c 标签。 例如 '1g2s' 表示 1金2银。"
L["The profit of this item (%s) is below the min profit (%s)."] = "此物品的利润 (%s)低于最低利润(%s)"
L["The same filter was specified multiple times."] = "多次指定同一筛选器。"
L["The search term must be at least 3 characters."] = "搜索词必须至少包含3个字符。"
L["The seller name of the lowest auction for %s was not given by the server. Skipping this item."] = "服务器没有给出%s最低价卖家名称。忽略此物品。"
L["The specified filter was empty."] = "指定筛选器为空。"
L["The specified item is not supported for crafting searches."] = "制造搜索不支持指定物品。"
L["The specified item is not supported for disenchant searches."] = "分解搜索不支持指定物品。"
L["The specified item was not found."] = "找不到指定物品。"
L["The unlearned filter was ignored because the CanIMogIt addon was not found."] = "unlearned筛选被忽略，因为找不到CanIMogIt插件"
L["The value must be greater than 0."] = "该值必须大于0。"
L["The value must be greater than or equal of 0."] = "The value must be greater than or equal of 0."
L["The value was greater than the maximum allowed auction house price."] = "该价高于允许的最高拍卖行价格。"
L["Themes"] = "主题"
L["There are unbalanced parentheses in this custom string."] = "There are unbalanced parentheses in this custom string."
L["There is currently no profession open, so cannot create profession groups."] = "目前没有打开专业技能，因此无法创建专业分组。"
L["There is no Crafting operation applied to this item's TSM group (%s)."] = "没有对该物品的TSM分组（%s）应用任何制造操作。"
L["This custom string is too complex for WoW to handle; use custom sources to simplify it."] = "This custom string is too complex for WoW to handle; use custom sources to simplify it."
L["This is not a valid profile name. Profile names must be at least one character long and may not contain '@' characters."] = "这是一个无效的配置文件名。配置文件名必须至少有一个字符长度并且不包含“@”字符。"
L["This item does not have a crafting cost. Check that all of its mats have mat prices."] = "此物品没有制造成本。 检查所有材料是否有材料价格"
L["This item is not in a TSM group."] = "此物品不在TSM分组"
L["This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."] = "当您补货时，此商品将被添加到队列中。如有疑问，请访问http://support.tradeskillmaster.com以获得进一步的帮助。"
L["This operation is applied to the base group which includes every item not in another group."] = "该操作应用于基础分组，包含不在其他组中的所有物品。"
L["This price is above your confirmation alert threshold."] = "此价格高于确认警报阈值"
L["This price is above your material value."] = "This price is above your material value."
L["This profession is not open."] = "此专业技能未打开。"
L["This record belongs to another account and can only be deleted on that account."] = "该记录属于另一个用户，只能在那个用户下删除。"
L["This will permanently delete the '%s' profile."] = "此操作将永久删除配置文件 '%s'"
L["This will reset all groups and operations (if not stored globally) to be wiped from '%s'."] = "这将重置要从“%s”中擦除的所有组和操作（如果不是全局存储的）。"
L["Time"] = "时间"
L["Time Frame"] = "时限"
L["Tinker"] = "修理"
L["Toggles the TSM Banking UI if either the bank or guild bank is currently open."] = "当银行或公会银行打开时，打开TSM银行助手界面。"
L["Toggles the TSM Crafting UI."] = "切换TSM制造UI"
L["Toggles the TSM Task List UI"] = "切换 TSM 任务列表 UI"
L["Toggles the main TSM window"] = "切換TSM主窗口"
L["Tooltip Options"] = "鼠标提示选项"
L["Tooltip Settings"] = "鼠标提示设置"
L["Tooltip price format"] = "提示价格格式"
L["Top Buyers"] = "头部买家"
L["Top Item"] = "畅销物品"
L["Top Sellers"] = "头部卖家"
L["Total"] = "总计"
L["Total Gold"] = "总金币"
L["Total Gold Collected: %s"] = "收集的金币总数：%s"
L["Total Gold Earned"] = "总金币赚取"
L["Total Gold Spent"] = "总消费"
L["Total Inventory Quantity"] = "总库存"
L["Total Items"] = "物品总数"
L["Total Postage"] = "累计邮费"
L["Total Price"] = "总价格："
L["Total Prices:"] = "总价："
L["Total Profit"] = "总利润"
L["Total Value"] = "总价值"
L["Track Sales / Purchases via trade"] = "记录贸易买卖"
L["Transform"] = "Transform"
L["Transform Value"] = "转化价值"
L["Type"] = "类型"
L["Uncollected Only"] = "仅未收集"
L["Undercut amount"] = "压价金额"
L["Undercut by whitelisted player."] = "被白名单玩家压价"
L["Undercutting blacklisted player."] = "压价黑名单"
L["Undercutting competition."] = "压价发布"
L["Unexpected word ('%s') in custom string."] = "Unexpected word ('%s') in custom string."
L["Ungrouped Items"] = "未分组的物品"
L["Ungrouped Items in Bags"] = "背包未分组物品"
L["Unit Price"] = "单价"
L["Unknown Item"] = "未知物品"
L["Unknown word (%s)."] = "未知关键字 (%s)."
L["Unlock Column Width"] = "未锁定列宽"
L["Unwrap Gift"] = "打开礼物包裹"
L["Up"] = "向上"
L["Up to date"] = "最新"
L["Update existing macro"] = "更新已存在的宏"
L["Updating"] = "更新中"
L["Upgrades Only"] = "仅有提升"
L["Usable Only"] = "仅可用"
L["Usage: /tsm price <Item Link> <Custom String>"] = "用法: /tsm price <Item Link> <Custom String>"
L["Use the settings below to control which lines are shown in tooltips."] = "以下设定用来控制鼠标提示显示的行。"
L["Use this list to manage what cooldowns you'd like TSM to ignore from crafting."] = "使用这个列表来管理你希望TSM在制造过程中忽略哪些冷却时间"
L["Use this list to manage what items you'd like TSM to ignore from destroying."] = "使用此列表来管理您不希望TSM分解的物品。"
L["Value"] = "价值"
L["Value Price Source"] = "价值价格来源（字符串）"
L["Value must be between %d and %d."] = "值必须在 %d 和 %d 之间。"
L["Values"] = "价值"
L["Vendor"] = "NPC"
L["Vendor Buy Price"] = "NPC购买价"
L["Vendor Search"] = "卖店价搜索"
L["Vendor Sell"] = "出售"
L["Vendor Sell Price"] = "NPC出售价"
L["Vendor Trade"] = "Vendor Trade"
L["Vendor Trade Value"] = "Vendor Trade Value"
L["Vendor buy price"] = "NPC购买价"
L["Vendor sell price"] = "供应商售价"
L["Vendoring"] = "NPC供应商"
L["Vendoring %s button"] = "NPC供应商 %s 按钮"
L["Vendoring operation"] = "NPC供应商操作"
L["Vendoring operations control selling to and buying from a vendor."] = "NPC供应商操作影响你与NPC商人的购买和销售。"
L["WARNING: The macro was too long, so was truncated to fit by WoW."] = "警告：宏过长，所以被WoW截断以适应。"
L["WARNING: Your minimum price for %s is below its vendorsell price (with AH cut taken into account). Consider raising your minimum price, or vendoring the item."] = "警告：%s的最低价低于卖店价（扣除AH手续费等）。请提高最低价，或直接卖给NPC。"
L["WOW UI"] = "WOW UI"
L["Warehousing"] = "仓库"
L["Warehousing operation"] = "仓库选项"
L["Warehousing operations control moving in and out of the bank."] = "仓库选项控制银行物品的进出。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "仓库会转移该分组最多每样%d物品，当背包 > 银行/公会银行时每样保留 %d 物品，当银行/公会银行 > 背包时每样保留 %d 物品。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "仓库会转移该分组最多每样%d物品，当背包 > 银行/公会银行时每样保留 %d 物品，当银行/公会银行 > 背包时每样保留 %d 物品。补货模块会维持%d物品在背包中。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank."] = "仓库会转移该分组最多每样%d物品，当背包 > 银行/公会银行时，每样保留 %d 物品。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "仓库会转移该分组最多每样%d物品，当背包 > 银行/公会银行时，每样保留 %d 物品。补货模块会维持%d物品在背包中。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags."] = "仓库会转移该分组最多每样%d物品，当银行/公会银行 > 背包时，每样保留 %d 物品。"
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "仓库会转移该分组最多每样%d物品，当银行/公会银行 > 背包时，每样保留 %d 物品。补货模块会维持%d物品在背包中。"
L["Warehousing will move a max of %d of each item in this group."] = "仓库会转移该分组最多每样%d物品。"
L["Warehousing will move a max of %d of each item in this group. Restock will maintain %d items in your bags."] = "仓库会转移该分组最多每样%d物品，补货模块会维持%d物品在背包中。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "仓库会转移该分组所有物品，当背包 > 银行/公会银行时每样保留 %d 物品，当银行/公会银行 > 背包时每样保留 %d 物品。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "仓库会转移该分组所有物品，当背包 > 银行/公会银行时每样保留 %d 物品，当银行/公会银行 > 背包时每样保留 %d 物品。补货模块会维持%d物品在背包中。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank."] = "仓库会转移该分组所有物品，当背包 > 银行/公会银行时，每样保留 %d 物品。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "仓库会转移该分组所有物品，当背包 > 银行/公会银行时，每样保留 %d 物品。补货模块会维持%d物品在背包中。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags."] = "仓库会转移该分组所有物品，当银行/公会银行 > 背包时，每样保留 %d 物品。"
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "仓库会转移该分组所有物品，当银行/公会银行 > 背包时，每样保留 %d 物品。补货模块会维持%d物品在背包中。"
L["Warehousing will move all of the items in this group."] = "仓库会转移该分组所有物品。"
L["Warehousing will move all of the items in this group. Restock will maintain %d items in your bags."] = "仓库会转移该分组所有物品。补货模块会保留%d物品在背包中。"
L["When above maximum:"] = "当超过最大值："
L["When below minimum:"] = "当小于最小值："
L["Whitelist"] = "白名单"
L["Whitelisted characters"] = "白名单角色"
L["Winamp"] = "Winamp风格"
L["Would send %s to %s"] = "将发送%s给%s"
L["Would send %s to %s with a COD of %s"] = "将发送%s给%s，到付价%s"
L["Yes, I'm sure"] = "Yes, I'm sure"
L["Yes, I'm sure (%02d)"] = "Yes, I'm sure (%02d)"
L["You are not on one of the listed characters."] = "你的角色不在列表中。"
L["You can clear old Accounting data for the current realm below to keep things running smoothly."] = "You can clear old Accounting data for the current realm below to keep things running smoothly."
L["You can import custom themes by pasting an import string into the box below."] = "在下框中粘贴导入字符串，以导入自定义主题。"
L["You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"] = "你可以粘贴字符串在下框中以导入分组。可导入的分组字符串可去这里找： https://tradeskillmaster.com/group-maker/all。"
L["You can now group pets by level, just like items."] = "You can now group pets by level, just like items."
L["You can use the export string below to share this custom theme with others."] = "你可用以下导出字符串，分享自定义主题给其他人。"
L["You can use the export string below to share this group with others."] = "你可用以下导出字符串，分享分组给其他人。"
L["You cannot use %s as part of this custom price."] = "你不能将%s作为自定义价格的一部分。"
L["You do not need to add \\\"%s\\\", alts are whitelisted automatically."] = "You do not need to add \\\"%s\\\", alts are whitelisted automatically."
L["You don't know how to craft this item."] = "你尚未学会制造这个物品。"
L["You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."] = "您要么至少已经有该物品最大补货数量，要么要加入队列的数量小于最小补货数量。"
L["You must reload your UI for these settings to take effect. Reload now?"] = "你需要重载UI来使这些改动生效。是否现在重载？"
L["You won an auction for %sx%d for %s"] = "你已买入%sx%d，买入价%s"
L["You've been phased which has caused the AH to stop working due to a bug on Blizzard's end. Please close and reopen the AH and restart Sniper."] = "由于暴雪终端的一个bug，你已经被分阶段处理，导致AH停止工作。请关闭并重新打开拍卖行，重启狙击。"
L["You've been undercut."] = "已被压价"
L["Your Buyout"] = "你的一口价"
L["Your auction has not been undercut."] = "你的拍卖未被压价。"
L["Your auction of %s expired"] = "你拍卖的%s已经过期"
L["Your auction of %s has sold for %s!"] = "你拍卖的%s已经以%s的价格卖出！"
L["Your auction of %s has sold!"] = "Your auction of %s has sold!"
L["Your craft value method for '%s' was invalid so it has been returned to the default. Details: %s"] = "你对'%s'设置的制造物品定价方式无效，已重置为默认值，详见: %s"
L["Your default craft value method was invalid so it has been returned to the default. Details: %s"] = "你的制造物品定价方式无效，已返回默认值。详见: %s"
L["Your max restock (%s) is invalid for %s."] = "最高补货量(%s)对于%s无效。"
L["Your min restock (%s) is invalid for %s."] = "最低补货量(%s)对于%s无效。"
L["Your restock quantity is invalid. It must be between %d and %s."] = "你的补货数量无效，它必须在%d和%s之间。"
L["Your task list is currently empty."] = "你的任务列表目前是空的。"
L["ilvl"] = "物品等级"
-- LOCALE STRINGS END HERE

Locale.SetTable(L)
